#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
/*
 * LockDatabaseFrequently.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct LockDatabaseFrequentlyWorkload : TestWorkload {
	static constexpr auto NAME = "LockDatabaseFrequently";

	double delayBetweenLocks;
	double testDuration;
	PerfIntCounter lockCount{ "LockCount" };

	LockDatabaseFrequentlyWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		delayBetweenLocks = getOption(options, "delayBetweenLocks"_sr, 0.1);
		testDuration = getOption(options, "testDuration"_sr, 60);
	}

	Future<Void> setup(Database const& cx) override { return Void(); }

	Future<Void> start(Database const& cx) override { return clientId == 0 ? worker(this, cx) : Void(); }

	Future<bool> check(Database const& cx) override { return true; }

	void getMetrics(std::vector<PerfMetric>& m) override {
		if (clientId == 0) {
			m.push_back(lockCount.getMetric());
		}
	}

																#line 53 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabaseFrequently.actor.g.cpp.py_gen"
// This generated class is to be used only via worker()
															#line 51 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
template <class WorkerActor>
															#line 51 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
class WorkerActorState {
															#line 59 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabaseFrequently.actor.g.cpp.py_gen"
public:
															#line 51 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
	WorkerActorState(LockDatabaseFrequentlyWorkload* const& self,Database const& cx) 
															#line 51 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
															#line 51 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
		 : self(self),
															#line 51 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
		   cx(cx),
															#line 52 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
		   end(delay(self->testDuration)),
															#line 53 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
		   lastLock(g_network->now()),
															#line 54 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
		   lastUnlock(g_network->now() + self->delayBetweenLocks / 2)
															#line 74 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabaseFrequently.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("worker", reinterpret_cast<unsigned long>(this));

	}
	~WorkerActorState() 
	{
		fdb_probe_actor_destroy("worker", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 55 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
			;
															#line 89 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabaseFrequently.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WorkerActorState();
		static_cast<WorkerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 56 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
		StrictFuture<Void> __when_expr_0 = lockAndUnlock(self, cx, &lastLock, &lastUnlock);
															#line 56 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
		if (static_cast<WorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 121 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabaseFrequently.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<WorkerActor*>(this)->actor_wait_state = 1;
															#line 56 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WorkerActor, 0, Void >*>(static_cast<WorkerActor*>(this)));
															#line 126 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabaseFrequently.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 57 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
		++self->lockCount;
															#line 58 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
		if (end.isReady())
															#line 137 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabaseFrequently.actor.g.cpp.py_gen"
		{
															#line 59 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
			if (!static_cast<WorkerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WorkerActorState(); static_cast<WorkerActor*>(this)->destroy(); return 0; }
															#line 141 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabaseFrequently.actor.g.cpp.py_gen"
			new (&static_cast<WorkerActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~WorkerActorState();
			static_cast<WorkerActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 57 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
		++self->lockCount;
															#line 58 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
		if (end.isReady())
															#line 157 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabaseFrequently.actor.g.cpp.py_gen"
		{
															#line 59 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
			if (!static_cast<WorkerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WorkerActorState(); static_cast<WorkerActor*>(this)->destroy(); return 0; }
															#line 161 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabaseFrequently.actor.g.cpp.py_gen"
			new (&static_cast<WorkerActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~WorkerActorState();
			static_cast<WorkerActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WorkerActor*>(this)->actor_wait_state > 0) static_cast<WorkerActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerActor*>(this)->ActorCallback< WorkerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("worker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("worker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WorkerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("worker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("worker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WorkerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("worker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("worker", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 51 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
	LockDatabaseFrequentlyWorkload* self;
															#line 51 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
	Database cx;
															#line 52 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
	Future<Void> end;
															#line 53 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
	double lastLock;
															#line 54 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
	double lastUnlock;
															#line 256 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabaseFrequently.actor.g.cpp.py_gen"
};
// This generated class is to be used only via worker()
															#line 51 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
class WorkerActor final : public Actor<Void>, public ActorCallback< WorkerActor, 0, Void >, public FastAllocated<WorkerActor>, public WorkerActorState<WorkerActor> {
															#line 261 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabaseFrequently.actor.g.cpp.py_gen"
public:
	using FastAllocated<WorkerActor>::operator new;
	using FastAllocated<WorkerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13659101141169589504UL, 4355350433454094592UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WorkerActor, 0, Void >;
															#line 51 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
	WorkerActor(LockDatabaseFrequentlyWorkload* const& self,Database const& cx) 
															#line 278 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabaseFrequently.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   WorkerActorState<WorkerActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("worker", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9305151550442981632UL, 410782307204870400UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("worker");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("worker", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WorkerActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 51 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
[[nodiscard]] static Future<Void> worker( LockDatabaseFrequentlyWorkload* const& self, Database const& cx ) {
															#line 51 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
	return Future<Void>(new WorkerActor(self, cx));
															#line 310 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabaseFrequently.actor.g.cpp.py_gen"
}

#line 63 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"

																#line 315 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabaseFrequently.actor.g.cpp.py_gen"
// This generated class is to be used only via lockAndUnlock()
															#line 64 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
template <class LockAndUnlockActor>
															#line 64 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
class LockAndUnlockActorState {
															#line 321 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabaseFrequently.actor.g.cpp.py_gen"
public:
															#line 64 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
	LockAndUnlockActorState(LockDatabaseFrequentlyWorkload* const& self,Database const& cx,double* const& lastLock,double* const& lastUnlock) 
															#line 64 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
															#line 64 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
		 : self(self),
															#line 64 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
		   cx(cx),
															#line 64 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
		   lastLock(lastLock),
															#line 64 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
		   lastUnlock(lastUnlock),
															#line 68 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
		   uid(deterministicRandom()->randomUniqueID())
															#line 336 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabaseFrequently.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("lockAndUnlock", reinterpret_cast<unsigned long>(this));

	}
	~LockAndUnlockActorState() 
	{
		fdb_probe_actor_destroy("lockAndUnlock", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 69 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
			StrictFuture<Void> __when_expr_0 = lockDatabase(cx, uid) && poisson(lastLock, self->delayBetweenLocks);
															#line 69 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
			if (static_cast<LockAndUnlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 353 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabaseFrequently.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<LockAndUnlockActor*>(this)->actor_wait_state = 1;
															#line 69 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LockAndUnlockActor, 0, Void >*>(static_cast<LockAndUnlockActor*>(this)));
															#line 358 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabaseFrequently.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LockAndUnlockActorState();
		static_cast<LockAndUnlockActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 70 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
		StrictFuture<Void> __when_expr_1 = unlockDatabase(cx, uid) && poisson(lastUnlock, self->delayBetweenLocks);
															#line 70 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
		if (static_cast<LockAndUnlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 383 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabaseFrequently.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<LockAndUnlockActor*>(this)->actor_wait_state = 2;
															#line 70 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LockAndUnlockActor, 1, Void >*>(static_cast<LockAndUnlockActor*>(this)));
															#line 388 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabaseFrequently.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 70 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
		StrictFuture<Void> __when_expr_1 = unlockDatabase(cx, uid) && poisson(lastUnlock, self->delayBetweenLocks);
															#line 70 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
		if (static_cast<LockAndUnlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 399 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabaseFrequently.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<LockAndUnlockActor*>(this)->actor_wait_state = 2;
															#line 70 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LockAndUnlockActor, 1, Void >*>(static_cast<LockAndUnlockActor*>(this)));
															#line 404 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabaseFrequently.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LockAndUnlockActor*>(this)->actor_wait_state > 0) static_cast<LockAndUnlockActor*>(this)->actor_wait_state = 0;
		static_cast<LockAndUnlockActor*>(this)->ActorCallback< LockAndUnlockActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LockAndUnlockActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("lockAndUnlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockAndUnlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockAndUnlock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LockAndUnlockActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("lockAndUnlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockAndUnlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockAndUnlock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LockAndUnlockActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("lockAndUnlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LockAndUnlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockAndUnlock", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 71 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
		if (!static_cast<LockAndUnlockActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LockAndUnlockActorState(); static_cast<LockAndUnlockActor*>(this)->destroy(); return 0; }
															#line 488 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabaseFrequently.actor.g.cpp.py_gen"
		new (&static_cast<LockAndUnlockActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~LockAndUnlockActorState();
		static_cast<LockAndUnlockActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 71 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
		if (!static_cast<LockAndUnlockActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LockAndUnlockActorState(); static_cast<LockAndUnlockActor*>(this)->destroy(); return 0; }
															#line 500 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabaseFrequently.actor.g.cpp.py_gen"
		new (&static_cast<LockAndUnlockActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~LockAndUnlockActorState();
		static_cast<LockAndUnlockActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<LockAndUnlockActor*>(this)->actor_wait_state > 0) static_cast<LockAndUnlockActor*>(this)->actor_wait_state = 0;
		static_cast<LockAndUnlockActor*>(this)->ActorCallback< LockAndUnlockActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LockAndUnlockActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("lockAndUnlock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockAndUnlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockAndUnlock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< LockAndUnlockActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("lockAndUnlock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockAndUnlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockAndUnlock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< LockAndUnlockActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("lockAndUnlock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LockAndUnlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockAndUnlock", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 64 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
	LockDatabaseFrequentlyWorkload* self;
															#line 64 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
	Database cx;
															#line 64 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
	double* lastLock;
															#line 64 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
	double* lastUnlock;
															#line 68 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
	UID uid;
															#line 593 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabaseFrequently.actor.g.cpp.py_gen"
};
// This generated class is to be used only via lockAndUnlock()
															#line 64 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
class LockAndUnlockActor final : public Actor<Void>, public ActorCallback< LockAndUnlockActor, 0, Void >, public ActorCallback< LockAndUnlockActor, 1, Void >, public FastAllocated<LockAndUnlockActor>, public LockAndUnlockActorState<LockAndUnlockActor> {
															#line 598 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabaseFrequently.actor.g.cpp.py_gen"
public:
	using FastAllocated<LockAndUnlockActor>::operator new;
	using FastAllocated<LockAndUnlockActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3096023631964784640UL, 18369141959944832768UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LockAndUnlockActor, 0, Void >;
friend struct ActorCallback< LockAndUnlockActor, 1, Void >;
															#line 64 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
	LockAndUnlockActor(LockDatabaseFrequentlyWorkload* const& self,Database const& cx,double* const& lastLock,double* const& lastUnlock) 
															#line 616 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabaseFrequently.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   LockAndUnlockActorState<LockAndUnlockActor>(self, cx, lastLock, lastUnlock),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("lockAndUnlock", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9656700896920403200UL, 8137737371183607296UL);
		ActorExecutionContextHelper __helper(static_cast<LockAndUnlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("lockAndUnlock");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("lockAndUnlock", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LockAndUnlockActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< LockAndUnlockActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 64 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
[[nodiscard]] static Future<Void> lockAndUnlock( LockDatabaseFrequentlyWorkload* const& self, Database const& cx, double* const& lastLock, double* const& lastUnlock ) {
															#line 64 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
	return Future<Void>(new LockAndUnlockActor(self, cx, lastLock, lastUnlock));
															#line 649 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabaseFrequently.actor.g.cpp.py_gen"
}

#line 73 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabaseFrequently.actor.cpp"
};

WorkloadFactory<LockDatabaseFrequentlyWorkload> LockDatabaseFrequentlyWorkloadFactory;
