#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
/*
 * BackupCorrectness.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2022 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/DatabaseConfiguration.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbrpc/simulator.h"
#include "fdbclient/BackupAgent.actor.h"
#include "fdbclient/BackupContainer.h"
#include "fdbclient/BackupContainerFileSystem.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/workloads/BulkSetup.actor.h"
#include "flow/IRandom.h"
#include "flow/actorcompiler.h" // This must be the last #include.

// A workload for
// https://github.com/apple/foundationdb/blob/main/design/backup_v2_partitioned_logs.md
// TODO: why is this file forked?  Just because the backup *implementation* differs doesn't
// mean a new test workload is warranted.  If the APIs are similar then why doesn't the old test work too?
// In the mean time we are dealing with two heavily overlapping source files with tons of cut/paste
// unmodified code:
// diff -U 10 BackupCorrectness.actor.cpp BackupCorrectnessPartitioned.actor.cpp
struct BackupAndRestorePartitionedCorrectnessWorkload : TestWorkload {
	static constexpr auto NAME = "BackupAndRestorePartitionedCorrectness";
	double backupAfter, restoreAfter, abortAndRestartAfter;
	double minBackupAfter;
	double backupStartAt, restoreStartAfterBackupFinished, stopDifferentialAfter;
	Key backupTag;
	int backupRangesCount, backupRangeLengthMax;
	bool differentialBackup, performRestore, agentRequest;
	Standalone<VectorRef<KeyRangeRef>> backupRanges;
	std::vector<KeyRange> skippedRestoreRanges;
	Standalone<VectorRef<KeyRangeRef>> restoreRanges;
	static int backupAgentRequests;
	LockDB locked{ false };
	bool allowPauses;
	bool shareLogRange;
	bool shouldSkipRestoreRanges;
	bool defaultBackup;
	Optional<std::string> encryptionKeyFileName;

	BackupAndRestorePartitionedCorrectnessWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		locked.set(sharedRandomNumber % 2);
		backupAfter = getOption(options, "backupAfter"_sr, 10.0);
		double minBackupAfter = getOption(options, "minBackupAfter"_sr, backupAfter);
		if (backupAfter > minBackupAfter) {
			backupAfter = deterministicRandom()->random01() * (backupAfter - minBackupAfter) + minBackupAfter;
		}
		restoreAfter = getOption(options, "restoreAfter"_sr, 35.0);
		performRestore = getOption(options, "performRestore"_sr, true);
		backupTag = getOption(options, "backupTag"_sr, BackupAgentBase::getDefaultTag());
		backupRangesCount = getOption(options, "backupRangesCount"_sr, 5);
		backupRangeLengthMax = getOption(options, "backupRangeLengthMax"_sr, 1);
		abortAndRestartAfter =
		    getOption(options,
		              "abortAndRestartAfter"_sr,
		              deterministicRandom()->random01() < 0.5
		                  ? deterministicRandom()->random01() * (restoreAfter - backupAfter) + backupAfter
		                  : 0.0);
		differentialBackup =
		    getOption(options, "differentialBackup"_sr, deterministicRandom()->random01() < 0.5 ? true : false);
		stopDifferentialAfter =
		    getOption(options,
		              "stopDifferentialAfter"_sr,
		              differentialBackup ? deterministicRandom()->random01() *
		                                           (restoreAfter - std::max(abortAndRestartAfter, backupAfter)) +
		                                       std::max(abortAndRestartAfter, backupAfter)
		                                 : 0.0);
		agentRequest = getOption(options, "simBackupAgents"_sr, true);
		allowPauses = getOption(options, "allowPauses"_sr, true);
		shareLogRange = getOption(options, "shareLogRange"_sr, false);
		defaultBackup = getOption(options, "defaultBackup"_sr, false);

		std::vector<std::string> restorePrefixesToInclude =
		    getOption(options, "restorePrefixesToInclude"_sr, std::vector<std::string>());

		shouldSkipRestoreRanges = deterministicRandom()->random01() < 0.3 ? true : false;
		if (getOption(options, "encrypted"_sr, deterministicRandom()->random01() < 0.5)) {
			encryptionKeyFileName = "simfdb/" + getTestEncryptionFileName();
		}

		TraceEvent("BARW_ClientId").detail("Id", wcx.clientId);
		UID randomID = nondeterministicRandom()->randomUniqueID();
		TraceEvent("BARW_PerformRestore", randomID).detail("Value", performRestore);
		if (defaultBackup) {
			addDefaultBackupRanges(backupRanges);
		} else if (shareLogRange) {
			bool beforePrefix = sharedRandomNumber & 1;
			if (beforePrefix)
				backupRanges.push_back_deep(backupRanges.arena(), KeyRangeRef(normalKeys.begin, "\xfe\xff\xfe"_sr));
			else
				backupRanges.push_back_deep(backupRanges.arena(),
				                            KeyRangeRef(strinc("\x00\x00\x01"_sr), normalKeys.end));
		} else if (backupRangesCount <= 0) {
			backupRanges.push_back_deep(backupRanges.arena(), normalKeys);
		} else {
			// Add backup ranges
			std::set<std::string> rangeEndpoints;
			while (rangeEndpoints.size() < backupRangesCount * 2) {
				rangeEndpoints.insert(deterministicRandom()->randomAlphaNumeric(
				    deterministicRandom()->randomInt(1, backupRangeLengthMax + 1)));
			}

			// Create ranges from the keys, in order, to prevent overlaps
			std::vector<std::string> sortedEndpoints(rangeEndpoints.begin(), rangeEndpoints.end());
			sort(sortedEndpoints.begin(), sortedEndpoints.end());
			for (auto i = sortedEndpoints.begin(); i != sortedEndpoints.end(); ++i) {
				const std::string& start = *i++;
				backupRanges.push_back_deep(backupRanges.arena(), KeyRangeRef(start, *i));

				// Track the added range
				TraceEvent("BARW_BackupCorrectnessRange", randomID).detail("RangeBegin", start).detail("RangeEnd", *i);
			}
		}

		if (performRestore && !restorePrefixesToInclude.empty() && shouldSkipRestoreRanges) {
			for (auto& range : backupRanges) {
				bool intersection = false;
				for (auto& prefix : restorePrefixesToInclude) {
					KeyRange prefixRange(KeyRangeRef(prefix, strinc(prefix)));
					if (range.intersects(prefixRange)) {
						intersection = true;
					}
					TraceEvent("BARW_PrefixSkipRangeDetails")
					    .detail("PrefixMandatory", printable(prefix))
					    .detail("BackupRange", printable(range))
					    .detail("Intersection", intersection);
				}
				// If the backup range intersects with restorePrefixesToInclude or a coin flip is true then use it as a
				// restore range as well, otherwise skip it.
				if (intersection || deterministicRandom()->coinflip()) {
					restoreRanges.push_back_deep(restoreRanges.arena(), range);
				} else {
					skippedRestoreRanges.push_back(range);
				}
			}
		} else {
			restoreRanges = backupRanges;
		}

		// If no random backup ranges intersected with restorePrefixesToInclude or won the coin flip then restoreRanges
		// will be empty, so move an item from skippedRestoreRanges to restoreRanges.
		if (restoreRanges.empty()) {
			ASSERT(!skippedRestoreRanges.empty());
			restoreRanges.push_back_deep(restoreRanges.arena(), skippedRestoreRanges.back());
			skippedRestoreRanges.pop_back();
		}

		for (auto& range : restoreRanges) {
			TraceEvent("BARW_RestoreRange", randomID)
			    .detail("RangeBegin", printable(range.begin))
			    .detail("RangeEnd", printable(range.end));
		}
		for (auto& range : skippedRestoreRanges) {
			TraceEvent("BARW_SkipRange", randomID)
			    .detail("RangeBegin", printable(range.begin))
			    .detail("RangeEnd", printable(range.end));
		}
	}

	Future<Void> setup(Database const& cx) override {
		if (clientId != 0) {
			return Void();
		}

		return _setup(cx, this);
	}

																#line 189 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
// This generated class is to be used only via _setup()
															#line 187 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
template <class _setupActor>
															#line 187 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
class _setupActorState {
															#line 195 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
public:
															#line 187 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	_setupActorState(Database const& cx,BackupAndRestorePartitionedCorrectnessWorkload* const& self) 
															#line 187 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
															#line 187 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		 : cx(cx),
															#line 187 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		   self(self),
															#line 188 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		   adjusted(false)
															#line 206 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_setup", reinterpret_cast<unsigned long>(this));

	}
	~_setupActorState() 
	{
		fdb_probe_actor_destroy("_setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 190 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			if (BUGGIFY)
															#line 221 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			{
															#line 191 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
				for( auto r : getSystemBackupRanges() ) {
															#line 192 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
					self->backupRanges.push_back_deep(self->backupRanges.arena(), r);
															#line 227 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
				}
															#line 194 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
				for( auto r : getSystemBackupRanges() ) {
															#line 195 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
					self->restoreRanges.push_back_deep(self->restoreRanges.arena(), r);
															#line 233 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
				}
			}
															#line 199 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 238 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~_setupActorState();
			static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 187 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	Database cx;
															#line 187 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	BackupAndRestorePartitionedCorrectnessWorkload* self;
															#line 188 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	bool adjusted;
															#line 266 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _setup()
															#line 187 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
class _setupActor final : public Actor<Void>, public FastAllocated<_setupActor>, public _setupActorState<_setupActor> {
															#line 271 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
public:
	using FastAllocated<_setupActor>::operator new;
	using FastAllocated<_setupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(367686442358411008UL, 17793810329298103296UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 187 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	_setupActor(Database const& cx,BackupAndRestorePartitionedCorrectnessWorkload* const& self) 
															#line 287 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _setupActorState<_setupActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3044502327521131520UL, 13387266639422932480UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
															#line 187 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
[[nodiscard]] Future<Void> _setup( Database const& cx, BackupAndRestorePartitionedCorrectnessWorkload* const& self ) {
															#line 187 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	return Future<Void>(new _setupActor(cx, self));
															#line 318 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
}

#line 201 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"

	Future<Void> start(Database const& cx) override {
		if (clientId != 0)
			return Void();

		TraceEvent(SevInfo, "BARW_Param")
		    .detail("Locked", locked)
		    .detail("BackupAfter", backupAfter)
		    .detail("RestoreAfter", restoreAfter)
		    .detail("PerformRestore", performRestore)
		    .detail("BackupTag", printable(backupTag).c_str())
		    .detail("BackupRangesCount", backupRangesCount)
		    .detail("BackupRangeLengthMax", backupRangeLengthMax)
		    .detail("AbortAndRestartAfter", abortAndRestartAfter)
		    .detail("DifferentialBackup", differentialBackup)
		    .detail("StopDifferentialAfter", stopDifferentialAfter)
		    .detail("AgentRequest", agentRequest)
		    .detail("Encrypted", encryptionKeyFileName.present());

		return _start(cx, this);
	}

	Future<bool> check(Database const& cx) override {
		if (clientId != 0)
			return true;
		else
			return _check(cx, this);
	}

																#line 351 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
// This generated class is to be used only via _check()
															#line 230 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
template <class _checkActor>
															#line 230 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
class _checkActorState {
															#line 357 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
public:
															#line 230 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	_checkActorState(Database const& cx,BackupAndRestorePartitionedCorrectnessWorkload* const& self) 
															#line 230 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
															#line 230 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		 : cx(cx),
															#line 230 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		   self(self),
															#line 231 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		   tr(cx)
															#line 368 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_check", reinterpret_cast<unsigned long>(this));

	}
	~_checkActorState() 
	{
		fdb_probe_actor_destroy("_check", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 232 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			;
															#line 383 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 250 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(true); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 406 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(true);
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 234 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			restoreIndex = int();
															#line 235 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			restoreIndex = 0;
															#line 428 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			loopDepth = a_body1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 247 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 247 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 465 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 2;
															#line 247 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 1, Void >*>(static_cast<_checkActor*>(this)));
															#line 470 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 244 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		TraceEvent("BackupCorrectnessFinish").log();
															#line 485 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 235 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (!(restoreIndex < self->skippedRestoreRanges.size()))
															#line 501 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 236 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		range = self->skippedRestoreRanges[restoreIndex];
															#line 237 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		Standalone<StringRef> restoreTag(self->backupTag.toString() + "_" + std::to_string(restoreIndex));
															#line 238 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		StrictFuture<RangeResult> __when_expr_0 = tr.getRange(range, GetRangeLimits::ROW_LIMIT_UNLIMITED);
															#line 238 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 513 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 1;
															#line 238 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 0, RangeResult >*>(static_cast<_checkActor*>(this)));
															#line 518 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(RangeResult const& res,int loopDepth) 
	{
															#line 239 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (!res.empty())
															#line 540 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		{
															#line 240 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			TraceEvent(SevError, "BARW_UnexpectedRangePresent").detail("Range", printable(range));
															#line 241 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(false); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 546 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(false);
			this->~_checkActorState();
			static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 235 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		restoreIndex++;
															#line 554 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(RangeResult && res,int loopDepth) 
	{
															#line 239 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (!res.empty())
															#line 563 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		{
															#line 240 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			TraceEvent(SevError, "BARW_UnexpectedRangePresent").detail("Range", printable(range));
															#line 241 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(false); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 569 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(false);
			this->~_checkActorState();
			static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 235 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		restoreIndex++;
															#line 577 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(RangeResult const& res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(res, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(RangeResult && res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _checkActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _checkActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _checkActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _checkActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 230 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	Database cx;
															#line 230 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	BackupAndRestorePartitionedCorrectnessWorkload* self;
															#line 231 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	Transaction tr;
															#line 234 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	int restoreIndex;
															#line 236 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	KeyRangeRef range;
															#line 754 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _check()
															#line 230 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
class _checkActor final : public Actor<bool>, public ActorCallback< _checkActor, 0, RangeResult >, public ActorCallback< _checkActor, 1, Void >, public FastAllocated<_checkActor>, public _checkActorState<_checkActor> {
															#line 759 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
public:
	using FastAllocated<_checkActor>::operator new;
	using FastAllocated<_checkActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2737929238053498112UL, 9783815113331876864UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _checkActor, 0, RangeResult >;
friend struct ActorCallback< _checkActor, 1, Void >;
															#line 230 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	_checkActor(Database const& cx,BackupAndRestorePartitionedCorrectnessWorkload* const& self) 
															#line 777 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   _checkActorState<_checkActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18414574916690025728UL, 14115196402046968064UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_check");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _checkActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _checkActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 230 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
[[nodiscard]] static Future<bool> _check( Database const& cx, BackupAndRestorePartitionedCorrectnessWorkload* const& self ) {
															#line 230 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	return Future<bool>(new _checkActor(cx, self));
															#line 810 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
}

#line 252 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"

	void getMetrics(std::vector<PerfMetric>& m) override {}

																#line 817 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
// This generated class is to be used only via changePaused()
															#line 255 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
template <class ChangePausedActor>
															#line 255 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
class ChangePausedActorState {
															#line 823 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
public:
															#line 255 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	ChangePausedActorState(Database const& cx,FileBackupAgent* const& backupAgent) 
															#line 255 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
															#line 255 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		 : cx(cx),
															#line 255 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		   backupAgent(backupAgent)
															#line 832 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("changePaused", reinterpret_cast<unsigned long>(this));

	}
	~ChangePausedActorState() 
	{
		fdb_probe_actor_destroy("changePaused", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 256 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			;
															#line 847 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ChangePausedActorState();
		static_cast<ChangePausedActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 257 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		StrictFuture<Void> __when_expr_0 = backupAgent->changePause(cx, true);
															#line 257 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (static_cast<ChangePausedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 879 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ChangePausedActor*>(this)->actor_wait_state = 1;
															#line 257 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ChangePausedActor, 0, Void >*>(static_cast<ChangePausedActor*>(this)));
															#line 884 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 258 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(30 * deterministicRandom()->random01());
															#line 258 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (static_cast<ChangePausedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 895 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ChangePausedActor*>(this)->actor_wait_state = 2;
															#line 258 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ChangePausedActor, 1, Void >*>(static_cast<ChangePausedActor*>(this)));
															#line 900 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 258 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(30 * deterministicRandom()->random01());
															#line 258 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (static_cast<ChangePausedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 911 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ChangePausedActor*>(this)->actor_wait_state = 2;
															#line 258 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ChangePausedActor, 1, Void >*>(static_cast<ChangePausedActor*>(this)));
															#line 916 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ChangePausedActor*>(this)->actor_wait_state > 0) static_cast<ChangePausedActor*>(this)->actor_wait_state = 0;
		static_cast<ChangePausedActor*>(this)->ActorCallback< ChangePausedActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangePausedActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ChangePausedActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ChangePausedActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 259 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		StrictFuture<Void> __when_expr_2 = backupAgent->changePause(cx, false);
															#line 259 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (static_cast<ChangePausedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1002 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<ChangePausedActor*>(this)->actor_wait_state = 3;
															#line 259 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ChangePausedActor, 2, Void >*>(static_cast<ChangePausedActor*>(this)));
															#line 1007 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 259 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		StrictFuture<Void> __when_expr_2 = backupAgent->changePause(cx, false);
															#line 259 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (static_cast<ChangePausedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1018 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<ChangePausedActor*>(this)->actor_wait_state = 3;
															#line 259 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ChangePausedActor, 2, Void >*>(static_cast<ChangePausedActor*>(this)));
															#line 1023 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ChangePausedActor*>(this)->actor_wait_state > 0) static_cast<ChangePausedActor*>(this)->actor_wait_state = 0;
		static_cast<ChangePausedActor*>(this)->ActorCallback< ChangePausedActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangePausedActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ChangePausedActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ChangePausedActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 260 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(120 * deterministicRandom()->random01());
															#line 260 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (static_cast<ChangePausedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1109 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<ChangePausedActor*>(this)->actor_wait_state = 4;
															#line 260 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ChangePausedActor, 3, Void >*>(static_cast<ChangePausedActor*>(this)));
															#line 1114 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 260 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(120 * deterministicRandom()->random01());
															#line 260 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (static_cast<ChangePausedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1125 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<ChangePausedActor*>(this)->actor_wait_state = 4;
															#line 260 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ChangePausedActor, 3, Void >*>(static_cast<ChangePausedActor*>(this)));
															#line 1130 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ChangePausedActor*>(this)->actor_wait_state > 0) static_cast<ChangePausedActor*>(this)->actor_wait_state = 0;
		static_cast<ChangePausedActor*>(this)->ActorCallback< ChangePausedActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangePausedActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ChangePausedActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ChangePausedActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ChangePausedActor*>(this)->actor_wait_state > 0) static_cast<ChangePausedActor*>(this)->actor_wait_state = 0;
		static_cast<ChangePausedActor*>(this)->ActorCallback< ChangePausedActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangePausedActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ChangePausedActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ChangePausedActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 255 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	Database cx;
															#line 255 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	FileBackupAgent* backupAgent;
															#line 1301 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
};
// This generated class is to be used only via changePaused()
															#line 255 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
class ChangePausedActor final : public Actor<Void>, public ActorCallback< ChangePausedActor, 0, Void >, public ActorCallback< ChangePausedActor, 1, Void >, public ActorCallback< ChangePausedActor, 2, Void >, public ActorCallback< ChangePausedActor, 3, Void >, public FastAllocated<ChangePausedActor>, public ChangePausedActorState<ChangePausedActor> {
															#line 1306 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
public:
	using FastAllocated<ChangePausedActor>::operator new;
	using FastAllocated<ChangePausedActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17813228486751752448UL, 10960365479261368064UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ChangePausedActor, 0, Void >;
friend struct ActorCallback< ChangePausedActor, 1, Void >;
friend struct ActorCallback< ChangePausedActor, 2, Void >;
friend struct ActorCallback< ChangePausedActor, 3, Void >;
															#line 255 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	ChangePausedActor(Database const& cx,FileBackupAgent* const& backupAgent) 
															#line 1326 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ChangePausedActorState<ChangePausedActor>(cx, backupAgent),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5431177707453768448UL, 12966551901980677120UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("changePaused");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ChangePausedActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ChangePausedActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ChangePausedActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ChangePausedActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 255 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
[[nodiscard]] static Future<Void> changePaused( Database const& cx, FileBackupAgent* const& backupAgent ) {
															#line 255 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	return Future<Void>(new ChangePausedActor(cx, backupAgent));
															#line 1361 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
}

#line 263 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"

																#line 1366 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
// This generated class is to be used only via statusLoop()
															#line 264 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
template <class StatusLoopActor>
															#line 264 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
class StatusLoopActorState {
															#line 1372 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
public:
															#line 264 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	StatusLoopActorState(Database const& cx,std::string const& tag) 
															#line 264 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
															#line 264 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		 : cx(cx),
															#line 264 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		   tag(tag),
															#line 265 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		   agent()
															#line 1383 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("statusLoop", reinterpret_cast<unsigned long>(this));

	}
	~StatusLoopActorState() 
	{
		fdb_probe_actor_destroy("statusLoop", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 266 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			;
															#line 1398 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StatusLoopActorState();
		static_cast<StatusLoopActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 267 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		StrictFuture<bool> __when_expr_0 = agent.checkActive(cx);
															#line 267 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (static_cast<StatusLoopActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1430 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<StatusLoopActor*>(this)->actor_wait_state = 1;
															#line 267 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StatusLoopActor, 0, bool >*>(static_cast<StatusLoopActor*>(this)));
															#line 1435 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(bool const& active,int loopDepth) 
	{
															#line 268 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		TraceEvent("BARW_AgentActivityCheck").detail("IsActive", active);
															#line 269 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		StrictFuture<std::string> __when_expr_1 = agent.getStatus(cx, ShowErrors::True, tag);
															#line 269 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (static_cast<StatusLoopActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1448 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<StatusLoopActor*>(this)->actor_wait_state = 2;
															#line 269 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StatusLoopActor, 1, std::string >*>(static_cast<StatusLoopActor*>(this)));
															#line 1453 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(bool && active,int loopDepth) 
	{
															#line 268 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		TraceEvent("BARW_AgentActivityCheck").detail("IsActive", active);
															#line 269 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		StrictFuture<std::string> __when_expr_1 = agent.getStatus(cx, ShowErrors::True, tag);
															#line 269 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (static_cast<StatusLoopActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1466 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<StatusLoopActor*>(this)->actor_wait_state = 2;
															#line 269 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StatusLoopActor, 1, std::string >*>(static_cast<StatusLoopActor*>(this)));
															#line 1471 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(bool const& active,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(active, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(bool && active,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(active), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StatusLoopActor*>(this)->actor_wait_state > 0) static_cast<StatusLoopActor*>(this)->actor_wait_state = 0;
		static_cast<StatusLoopActor*>(this)->ActorCallback< StatusLoopActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< StatusLoopActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StatusLoopActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StatusLoopActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(std::string const& status,int loopDepth) 
	{
															#line 270 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		puts(status.c_str());
															#line 271 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		StrictFuture<std::string> __when_expr_2 = agent.getStatusJSON(cx, tag);
															#line 271 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (static_cast<StatusLoopActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1559 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<StatusLoopActor*>(this)->actor_wait_state = 3;
															#line 271 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< StatusLoopActor, 2, std::string >*>(static_cast<StatusLoopActor*>(this)));
															#line 1564 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(std::string && status,int loopDepth) 
	{
															#line 270 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		puts(status.c_str());
															#line 271 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		StrictFuture<std::string> __when_expr_2 = agent.getStatusJSON(cx, tag);
															#line 271 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (static_cast<StatusLoopActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1577 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<StatusLoopActor*>(this)->actor_wait_state = 3;
															#line 271 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< StatusLoopActor, 2, std::string >*>(static_cast<StatusLoopActor*>(this)));
															#line 1582 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(std::string const& status,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(status, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(std::string && status,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(status), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<StatusLoopActor*>(this)->actor_wait_state > 0) static_cast<StatusLoopActor*>(this)->actor_wait_state = 0;
		static_cast<StatusLoopActor*>(this)->ActorCallback< StatusLoopActor, 1, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< StatusLoopActor, 1, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< StatusLoopActor, 1, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< StatusLoopActor, 1, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont3(std::string const& statusJSON,int loopDepth) 
	{
															#line 272 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		puts(statusJSON.c_str());
															#line 273 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(2.0);
															#line 273 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (static_cast<StatusLoopActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1670 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<StatusLoopActor*>(this)->actor_wait_state = 4;
															#line 273 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< StatusLoopActor, 3, Void >*>(static_cast<StatusLoopActor*>(this)));
															#line 1675 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(std::string && statusJSON,int loopDepth) 
	{
															#line 272 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		puts(statusJSON.c_str());
															#line 273 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(2.0);
															#line 273 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (static_cast<StatusLoopActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1688 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<StatusLoopActor*>(this)->actor_wait_state = 4;
															#line 273 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< StatusLoopActor, 3, Void >*>(static_cast<StatusLoopActor*>(this)));
															#line 1693 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(std::string const& statusJSON,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(statusJSON, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(std::string && statusJSON,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(statusJSON), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<StatusLoopActor*>(this)->actor_wait_state > 0) static_cast<StatusLoopActor*>(this)->actor_wait_state = 0;
		static_cast<StatusLoopActor*>(this)->ActorCallback< StatusLoopActor, 2, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< StatusLoopActor, 2, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< StatusLoopActor, 2, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< StatusLoopActor, 2, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<StatusLoopActor*>(this)->actor_wait_state > 0) static_cast<StatusLoopActor*>(this)->actor_wait_state = 0;
		static_cast<StatusLoopActor*>(this)->ActorCallback< StatusLoopActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StatusLoopActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< StatusLoopActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< StatusLoopActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 264 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	Database cx;
															#line 264 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	std::string tag;
															#line 265 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	FileBackupAgent agent;
															#line 1866 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
};
// This generated class is to be used only via statusLoop()
															#line 264 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
class StatusLoopActor final : public Actor<Void>, public ActorCallback< StatusLoopActor, 0, bool >, public ActorCallback< StatusLoopActor, 1, std::string >, public ActorCallback< StatusLoopActor, 2, std::string >, public ActorCallback< StatusLoopActor, 3, Void >, public FastAllocated<StatusLoopActor>, public StatusLoopActorState<StatusLoopActor> {
															#line 1871 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
public:
	using FastAllocated<StatusLoopActor>::operator new;
	using FastAllocated<StatusLoopActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15738935387087417600UL, 17157986620946487040UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StatusLoopActor, 0, bool >;
friend struct ActorCallback< StatusLoopActor, 1, std::string >;
friend struct ActorCallback< StatusLoopActor, 2, std::string >;
friend struct ActorCallback< StatusLoopActor, 3, Void >;
															#line 264 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	StatusLoopActor(Database const& cx,std::string const& tag) 
															#line 1891 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   StatusLoopActorState<StatusLoopActor>(cx, tag),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1858547908313483776UL, 2242404897950274816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("statusLoop");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StatusLoopActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< StatusLoopActor, 1, std::string >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< StatusLoopActor, 2, std::string >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< StatusLoopActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 264 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
[[nodiscard]] static Future<Void> statusLoop( Database const& cx, std::string const& tag ) {
															#line 264 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	return Future<Void>(new StatusLoopActor(cx, tag));
															#line 1926 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
}

#line 276 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"

																#line 1931 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
// This generated class is to be used only via doBackup()
															#line 277 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
template <class DoBackupActor>
															#line 277 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
class DoBackupActorState {
															#line 1937 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
public:
															#line 277 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	DoBackupActorState(BackupAndRestorePartitionedCorrectnessWorkload* const& self,double const& startDelay,FileBackupAgent* const& backupAgent,Database const& cx,Key const& tag,Standalone<VectorRef<KeyRangeRef>> const& backupRanges,double const& stopDifferentialDelay) 
															#line 277 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
															#line 277 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		 : self(self),
															#line 277 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		   startDelay(startDelay),
															#line 277 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		   backupAgent(backupAgent),
															#line 277 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		   cx(cx),
															#line 277 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		   tag(tag),
															#line 277 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		   backupRanges(backupRanges),
															#line 277 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		   stopDifferentialDelay(stopDifferentialDelay),
															#line 285 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		   randomID(nondeterministicRandom()->randomUniqueID()),
															#line 287 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		   stopDifferentialFuture(delay(stopDifferentialDelay))
															#line 1960 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("doBackup", reinterpret_cast<unsigned long>(this));

	}
	~DoBackupActorState() 
	{
		fdb_probe_actor_destroy("doBackup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 288 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(startDelay);
															#line 288 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1977 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DoBackupActor*>(this)->actor_wait_state = 1;
															#line 288 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 0, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 1982 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoBackupActorState();
		static_cast<DoBackupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 290 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (startDelay || BUGGIFY)
															#line 2005 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		{
															#line 291 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			TraceEvent("BARW_DoBackupAbortBackup1", randomID) .detail("Tag", printable(tag)) .detail("StartDelay", startDelay);
															#line 2009 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			try {
															#line 296 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
				StrictFuture<Void> __when_expr_1 = backupAgent->abortBackup(cx, tag.toString());
															#line 296 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
				if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 2015 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
				static_cast<DoBackupActor*>(this)->actor_wait_state = 2;
															#line 296 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 1, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 2020 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 290 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (startDelay || BUGGIFY)
															#line 2040 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		{
															#line 291 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			TraceEvent("BARW_DoBackupAbortBackup1", randomID) .detail("Tag", printable(tag)) .detail("StartDelay", startDelay);
															#line 2044 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			try {
															#line 296 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
				StrictFuture<Void> __when_expr_1 = backupAgent->abortBackup(cx, tag.toString());
															#line 296 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
				if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 2050 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
				static_cast<DoBackupActor*>(this)->actor_wait_state = 2;
															#line 296 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 1, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 2055 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 304 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		TraceEvent("BARW_DoBackupSubmitBackup", randomID) .detail("Tag", printable(tag)) .detail("StopWhenDone", stopDifferentialDelay ? "False" : "True");
															#line 308 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		backupContainer = "file://simfdb/backups/";
															#line 309 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		status = statusLoop(cx, tag.toString());
															#line 2154 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		try {
															#line 311 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			StrictFuture<Void> __when_expr_2 = backupAgent->submitBackup(cx, StringRef(backupContainer), {}, deterministicRandom()->randomInt(0, 60), deterministicRandom()->randomInt(0, 2000), tag.toString(), backupRanges, false, StopWhenDone{ !stopDifferentialDelay }, UsePartitionedLog::True, IncrementalBackupOnly::False, self->encryptionKeyFileName);
															#line 311 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 2160 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont2Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<DoBackupActor*>(this)->actor_wait_state = 3;
															#line 311 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 2, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 2165 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 298 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			TraceEvent("BARW_DoBackupAbortBackupException", randomID).error(e).detail("Tag", printable(tag));
															#line 299 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			if (e.code() != error_code_backup_unneeded)
															#line 2189 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			{
															#line 300 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 2193 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6(int loopDepth) 
	{
															#line 330 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (stopDifferentialDelay)
															#line 2309 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		{
															#line 331 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			CODE_PROBE(!stopDifferentialFuture.isReady(), "Restore starts at specified time - stopDifferential not ready");
															#line 333 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			StrictFuture<Void> __when_expr_3 = stopDifferentialFuture;
															#line 333 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2317 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont6when1(__when_expr_3.get(), loopDepth); };
			static_cast<DoBackupActor*>(this)->actor_wait_state = 4;
															#line 333 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 3, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 2322 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont9(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 324 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			TraceEvent("BARW_DoBackupSubmitBackupException", randomID).error(e).detail("Tag", printable(tag));
															#line 325 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			if (e.code() != error_code_backup_unneeded && e.code() != error_code_backup_duplicate)
															#line 2339 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			{
															#line 326 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 2343 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont9(int loopDepth) 
	{
															#line 427 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		TraceEvent("BARW_DoBackupWaitBackup", randomID).detail("Tag", printable(tag));
															#line 428 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		StrictFuture<EBackupState> __when_expr_10 = backupAgent->waitBackup(cx, tag.toString(), StopWhenDone::True);
															#line 428 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2463 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont9when1(__when_expr_10.get(), loopDepth); };
		static_cast<DoBackupActor*>(this)->actor_wait_state = 11;
															#line 428 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 10, EBackupState >*>(static_cast<DoBackupActor*>(this)));
															#line 2468 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10(Void const& _,int loopDepth) 
	{
															#line 334 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		TraceEvent("BARW_DoBackupWaitToDiscontinue", randomID) .detail("Tag", printable(tag)) .detail("DifferentialAfter", stopDifferentialDelay);
															#line 2477 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		try {
															#line 339 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			if (BUGGIFY)
															#line 2481 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			{
															#line 340 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
				backupTag = makeBackupTag(tag.toString());
															#line 341 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
				TraceEvent("BARW_DoBackupWaitForRestorable", randomID).detail("Tag", backupTag.tagName);
															#line 344 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
				lastBackupContainer = Reference<IBackupContainer>();
															#line 345 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
				lastBackupUID = UID();
															#line 346 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
				StrictFuture<EBackupState> __when_expr_4 = backupAgent->waitBackup( cx, backupTag.tagName, StopWhenDone::False, &lastBackupContainer, &lastBackupUID);
															#line 346 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
				if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont10Catch1(actor_cancelled(), loopDepth);
															#line 2495 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont10Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont10when1(__when_expr_4.get(), loopDepth); };
				static_cast<DoBackupActor*>(this)->actor_wait_state = 5;
															#line 346 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 4, EBackupState >*>(static_cast<DoBackupActor*>(this)));
															#line 2500 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 414 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
				TraceEvent("BARW_DoBackupDiscontinueBackup", randomID) .detail("Tag", printable(tag)) .detail("DifferentialAfter", stopDifferentialDelay);
															#line 417 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
				StrictFuture<Void> __when_expr_9 = backupAgent->discontinueBackup(cx, tag);
															#line 417 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
				if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont10Catch1(actor_cancelled(), loopDepth);
															#line 2511 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
				if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont10Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont10when2(__when_expr_9.get(), loopDepth); };
				static_cast<DoBackupActor*>(this)->actor_wait_state = 10;
															#line 417 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
				__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 9, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 2516 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1cont10Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont10Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10(Void && _,int loopDepth) 
	{
															#line 334 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		TraceEvent("BARW_DoBackupWaitToDiscontinue", randomID) .detail("Tag", printable(tag)) .detail("DifferentialAfter", stopDifferentialDelay);
															#line 2532 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		try {
															#line 339 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			if (BUGGIFY)
															#line 2536 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			{
															#line 340 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
				backupTag = makeBackupTag(tag.toString());
															#line 341 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
				TraceEvent("BARW_DoBackupWaitForRestorable", randomID).detail("Tag", backupTag.tagName);
															#line 344 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
				lastBackupContainer = Reference<IBackupContainer>();
															#line 345 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
				lastBackupUID = UID();
															#line 346 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
				StrictFuture<EBackupState> __when_expr_4 = backupAgent->waitBackup( cx, backupTag.tagName, StopWhenDone::False, &lastBackupContainer, &lastBackupUID);
															#line 346 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
				if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont10Catch1(actor_cancelled(), loopDepth);
															#line 2550 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont10Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont10when1(__when_expr_4.get(), loopDepth); };
				static_cast<DoBackupActor*>(this)->actor_wait_state = 5;
															#line 346 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 4, EBackupState >*>(static_cast<DoBackupActor*>(this)));
															#line 2555 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 414 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
				TraceEvent("BARW_DoBackupDiscontinueBackup", randomID) .detail("Tag", printable(tag)) .detail("DifferentialAfter", stopDifferentialDelay);
															#line 417 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
				StrictFuture<Void> __when_expr_9 = backupAgent->discontinueBackup(cx, tag);
															#line 417 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
				if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont10Catch1(actor_cancelled(), loopDepth);
															#line 2566 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
				if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont10Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont10when2(__when_expr_9.get(), loopDepth); };
				static_cast<DoBackupActor*>(this)->actor_wait_state = 10;
															#line 417 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
				__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 9, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 2571 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1cont10Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont10Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont10cont1(int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont10Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 420 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			TraceEvent("BARW_DoBackupDiscontinueBackupException", randomID).error(e).detail("Tag", printable(tag));
															#line 421 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			if (e.code() != error_code_backup_unneeded && e.code() != error_code_backup_duplicate)
															#line 2671 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			{
															#line 422 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 2675 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont10cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont2(int loopDepth) 
	{
		loopDepth = a_body1cont10cont17(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont3(int loopDepth) 
	{
															#line 349 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		TraceEvent("BARW_DoBackupWaitForRestorable", randomID) .detail("Tag", backupTag.tagName) .detail("Result", BackupAgentBase::getStateText(resultWait));
															#line 353 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		restorable = false;
															#line 354 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (lastBackupContainer)
															#line 2701 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		{
															#line 355 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			fdesc = lastBackupContainer->describeBackup();
															#line 356 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			StrictFuture<Void> __when_expr_5 = ready(fdesc);
															#line 356 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont10Catch1(actor_cancelled(), loopDepth);
															#line 2709 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont10Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont10cont3when1(__when_expr_5.get(), loopDepth); };
			static_cast<DoBackupActor*>(this)->actor_wait_state = 6;
															#line 356 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 5, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 2714 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont10cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10when1(EBackupState const& __resultWait,int loopDepth) 
	{
															#line 346 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		resultWait = __resultWait;
															#line 2728 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		loopDepth = a_body1cont10cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(EBackupState && __resultWait,int loopDepth) 
	{
		resultWait = std::move(__resultWait);
		loopDepth = a_body1cont10cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 4, EBackupState >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 4, EBackupState >*,EBackupState const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 4, EBackupState >*,EBackupState && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 4, EBackupState >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont10Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont10cont4(int loopDepth) 
	{
															#line 366 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		TraceEvent("BARW_LastBackupContainer", randomID) .detail("BackupTag", printable(tag)) .detail("LastBackupContainer", lastBackupContainer ? lastBackupContainer->getURL() : "") .detail("LastBackupUID", lastBackupUID) .detail("WaitStatus", BackupAgentBase::getStateText(resultWait)) .detail("Restorable", restorable);
															#line 374 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (resultWait == EBackupState::STATE_ABORTED)
															#line 2809 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		{
		}
		else
		{
															#line 377 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			if (!lastBackupContainer)
															#line 2816 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			{
															#line 378 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
				TraceEvent(SevError, "BARW_MissingBackupContainer", randomID) .detail("LastBackupUID", lastBackupUID) .detail("BackupTag", printable(tag)) .detail("WaitStatus", BackupAgentBase::getStateText(resultWait));
															#line 382 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
				printf("BackupCorrectnessMissingBackupContainer   tag: %s  status: %s\n", printable(tag).c_str(), BackupAgentBase::getStateText(resultWait));
															#line 2822 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			}
			else
			{
															#line 387 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
				if (!restorable)
															#line 2828 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
				{
															#line 388 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
					TraceEvent(SevError, "BARW_NotRestorable", randomID) .detail("LastBackupUID", lastBackupUID) .detail("BackupTag", printable(tag)) .detail("BackupFolder", lastBackupContainer->getURL()) .detail("WaitStatus", BackupAgentBase::getStateText(resultWait));
															#line 393 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
					printf("BackupCorrectnessNotRestorable:  tag: %s\n", printable(tag).c_str());
															#line 2834 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
				}
			}
		}
															#line 398 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (startDelay)
															#line 2840 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		{
															#line 399 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			TraceEvent("BARW_DoBackupAbortBackup2", randomID) .detail("Tag", printable(tag)) .detail("WaitStatus", BackupAgentBase::getStateText(resultWait)) .detail("LastBackupContainer", lastBackupContainer ? lastBackupContainer->getURL() : "") .detail("Restorable", restorable);
															#line 404 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			StrictFuture<Void> __when_expr_7 = backupAgent->abortBackup(cx, tag.toString());
															#line 404 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont10Catch1(actor_cancelled(), loopDepth);
															#line 2848 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont10Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont10cont4when1(__when_expr_7.get(), loopDepth); };
			static_cast<DoBackupActor*>(this)->actor_wait_state = 8;
															#line 404 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 7, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 2853 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 406 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			TraceEvent("BARW_DoBackupDiscontinueBackup", randomID) .detail("Tag", printable(tag)) .detail("DifferentialAfter", stopDifferentialDelay);
															#line 409 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			StrictFuture<Void> __when_expr_8 = backupAgent->discontinueBackup(cx, tag);
															#line 409 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont10Catch1(actor_cancelled(), loopDepth);
															#line 2864 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont10Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont10cont4when2(__when_expr_8.get(), loopDepth); };
			static_cast<DoBackupActor*>(this)->actor_wait_state = 9;
															#line 409 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 8, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 2869 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont10cont5(Void const& _,int loopDepth) 
	{
															#line 358 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (!fdesc.isError())
															#line 2879 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		{
															#line 359 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			desc = fdesc.get();
															#line 360 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			StrictFuture<Void> __when_expr_6 = desc.resolveVersionTimes(cx);
															#line 360 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont10Catch1(actor_cancelled(), loopDepth);
															#line 2887 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont10Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont10cont5when1(__when_expr_6.get(), loopDepth); };
			static_cast<DoBackupActor*>(this)->actor_wait_state = 7;
															#line 360 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 6, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 2892 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont10cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont5(Void && _,int loopDepth) 
	{
															#line 358 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (!fdesc.isError())
															#line 2906 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		{
															#line 359 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			desc = fdesc.get();
															#line 360 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			StrictFuture<Void> __when_expr_6 = desc.resolveVersionTimes(cx);
															#line 360 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont10Catch1(actor_cancelled(), loopDepth);
															#line 2914 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont10Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont10cont5when1(__when_expr_6.get(), loopDepth); };
			static_cast<DoBackupActor*>(this)->actor_wait_state = 7;
															#line 360 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 6, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 2919 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont10cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont10cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont10cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont10Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont10cont6(int loopDepth) 
	{
		loopDepth = a_body1cont10cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont7(Void const& _,int loopDepth) 
	{
															#line 361 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		printf("BackupDescription:\n%s\n", desc.toString().c_str());
															#line 362 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		restorable = desc.maxRestorableVersion.present();
															#line 3016 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		loopDepth = a_body1cont10cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont7(Void && _,int loopDepth) 
	{
															#line 361 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		printf("BackupDescription:\n%s\n", desc.toString().c_str());
															#line 362 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		restorable = desc.maxRestorableVersion.present();
															#line 3027 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		loopDepth = a_body1cont10cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont10cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont10cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont10Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont10cont9(int loopDepth) 
	{
		loopDepth = a_body1cont10cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont14(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont14(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont14(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont14(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont10cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont10cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont10Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont10cont15(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont15(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont4when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont15(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont4when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont15(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont10cont4when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont10cont4when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont10Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont10cont16(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont16(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont10when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont16(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont16(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont10cont17(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont10cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11(int loopDepth) 
	{
															#line 430 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		statusText = std::string();
															#line 432 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		StrictFuture<std::string> __when_expr_11 = backupAgent->getStatus(cx, ShowErrors::True, tag.toString());
															#line 432 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3395 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont11when1(__when_expr_11.get(), loopDepth); };
		static_cast<DoBackupActor*>(this)->actor_wait_state = 12;
															#line 432 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 11, std::string >*>(static_cast<DoBackupActor*>(this)));
															#line 3400 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9when1(EBackupState const& __statusValue,int loopDepth) 
	{
															#line 428 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		statusValue = __statusValue;
															#line 3409 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(EBackupState && __statusValue,int loopDepth) 
	{
		statusValue = std::move(__statusValue);
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 10, EBackupState >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 10, EBackupState >*,EBackupState const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 10, EBackupState >*,EBackupState && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 10, EBackupState >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont11cont1(std::string const& _statusText,int loopDepth) 
	{
															#line 433 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		statusText = _statusText;
															#line 436 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		TraceEvent("BARW_DoBackupComplete", randomID) .detail("Tag", printable(tag)) .detail("Status", statusText) .detail("StatusValue", BackupAgentBase::getStateText(statusValue));
															#line 441 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (!static_cast<DoBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoBackupActorState(); static_cast<DoBackupActor*>(this)->destroy(); return 0; }
															#line 3492 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		new (&static_cast<DoBackupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoBackupActorState();
		static_cast<DoBackupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont11cont1(std::string && _statusText,int loopDepth) 
	{
															#line 433 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		statusText = _statusText;
															#line 436 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		TraceEvent("BARW_DoBackupComplete", randomID) .detail("Tag", printable(tag)) .detail("Status", statusText) .detail("StatusValue", BackupAgentBase::getStateText(statusValue));
															#line 441 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (!static_cast<DoBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoBackupActorState(); static_cast<DoBackupActor*>(this)->destroy(); return 0; }
															#line 3508 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		new (&static_cast<DoBackupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoBackupActorState();
		static_cast<DoBackupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont11when1(std::string const& _statusText,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1(_statusText, loopDepth);

		return loopDepth;
	}
	int a_body1cont11when1(std::string && _statusText,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1(std::move(_statusText), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 11, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 11, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 11, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 11, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 11);

	}
															#line 277 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	BackupAndRestorePartitionedCorrectnessWorkload* self;
															#line 277 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	double startDelay;
															#line 277 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	FileBackupAgent* backupAgent;
															#line 277 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	Database cx;
															#line 277 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	Key tag;
															#line 277 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> backupRanges;
															#line 277 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	double stopDifferentialDelay;
															#line 285 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	UID randomID;
															#line 287 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	Future<Void> stopDifferentialFuture;
															#line 308 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	std::string backupContainer;
															#line 309 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	Future<Void> status;
															#line 340 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	KeyBackedTag backupTag;
															#line 344 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	Reference<IBackupContainer> lastBackupContainer;
															#line 345 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	UID lastBackupUID;
															#line 346 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	EBackupState resultWait;
															#line 353 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	bool restorable;
															#line 355 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	Future<BackupDescription> fdesc;
															#line 359 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	BackupDescription desc;
															#line 428 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	EBackupState statusValue;
															#line 430 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	std::string statusText;
															#line 3631 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
};
// This generated class is to be used only via doBackup()
															#line 277 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
class DoBackupActor final : public Actor<Void>, public ActorCallback< DoBackupActor, 0, Void >, public ActorCallback< DoBackupActor, 1, Void >, public ActorCallback< DoBackupActor, 2, Void >, public ActorCallback< DoBackupActor, 3, Void >, public ActorCallback< DoBackupActor, 4, EBackupState >, public ActorCallback< DoBackupActor, 5, Void >, public ActorCallback< DoBackupActor, 6, Void >, public ActorCallback< DoBackupActor, 7, Void >, public ActorCallback< DoBackupActor, 8, Void >, public ActorCallback< DoBackupActor, 9, Void >, public ActorCallback< DoBackupActor, 10, EBackupState >, public ActorCallback< DoBackupActor, 11, std::string >, public FastAllocated<DoBackupActor>, public DoBackupActorState<DoBackupActor> {
															#line 3636 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
public:
	using FastAllocated<DoBackupActor>::operator new;
	using FastAllocated<DoBackupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6207618936944469504UL, 3648049120130412544UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoBackupActor, 0, Void >;
friend struct ActorCallback< DoBackupActor, 1, Void >;
friend struct ActorCallback< DoBackupActor, 2, Void >;
friend struct ActorCallback< DoBackupActor, 3, Void >;
friend struct ActorCallback< DoBackupActor, 4, EBackupState >;
friend struct ActorCallback< DoBackupActor, 5, Void >;
friend struct ActorCallback< DoBackupActor, 6, Void >;
friend struct ActorCallback< DoBackupActor, 7, Void >;
friend struct ActorCallback< DoBackupActor, 8, Void >;
friend struct ActorCallback< DoBackupActor, 9, Void >;
friend struct ActorCallback< DoBackupActor, 10, EBackupState >;
friend struct ActorCallback< DoBackupActor, 11, std::string >;
															#line 277 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	DoBackupActor(BackupAndRestorePartitionedCorrectnessWorkload* const& self,double const& startDelay,FileBackupAgent* const& backupAgent,Database const& cx,Key const& tag,Standalone<VectorRef<KeyRangeRef>> const& backupRanges,double const& stopDifferentialDelay) 
															#line 3664 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   DoBackupActorState<DoBackupActor>(self, startDelay, backupAgent, cx, tag, backupRanges, stopDifferentialDelay),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15925328432552866816UL, 11115638302355080704UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doBackup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoBackupActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoBackupActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DoBackupActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< DoBackupActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< DoBackupActor, 4, EBackupState >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< DoBackupActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< DoBackupActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< DoBackupActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< DoBackupActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< DoBackupActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< DoBackupActor, 10, EBackupState >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< DoBackupActor, 11, std::string >*)0, actor_cancelled()); break;
		}

	}
};
															#line 277 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
[[nodiscard]] static Future<Void> doBackup( BackupAndRestorePartitionedCorrectnessWorkload* const& self, double const& startDelay, FileBackupAgent* const& backupAgent, Database const& cx, Key const& tag, Standalone<VectorRef<KeyRangeRef>> const& backupRanges, double const& stopDifferentialDelay ) {
															#line 277 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	return Future<Void>(new DoBackupActor(self, startDelay, backupAgent, cx, tag, backupRanges, stopDifferentialDelay));
															#line 3707 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
}

#line 443 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"

																#line 3712 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
// This generated class is to be used only via clearAndRestoreSystemKeys()
															#line 444 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
template <class ClearAndRestoreSystemKeysActor>
															#line 444 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
class ClearAndRestoreSystemKeysActorState {
															#line 3718 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
public:
															#line 444 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	ClearAndRestoreSystemKeysActorState(Database const& cx,BackupAndRestorePartitionedCorrectnessWorkload* const& self,FileBackupAgent* const& backupAgent,Version const& targetVersion,Reference<IBackupContainer> const& lastBackupContainer,Standalone<VectorRef<KeyRangeRef>> const& systemRestoreRanges) 
															#line 444 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
															#line 444 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		 : cx(cx),
															#line 444 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		   self(self),
															#line 444 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		   backupAgent(backupAgent),
															#line 444 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		   targetVersion(targetVersion),
															#line 444 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		   lastBackupContainer(lastBackupContainer),
															#line 444 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		   systemRestoreRanges(systemRestoreRanges)
															#line 3735 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("clearAndRestoreSystemKeys", reinterpret_cast<unsigned long>(this));

	}
	~ClearAndRestoreSystemKeysActorState() 
	{
		fdb_probe_actor_destroy("clearAndRestoreSystemKeys", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 451 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			StrictFuture<Void> __when_expr_0 = runRYWTransaction(cx, [=](Reference<ReadYourWritesTransaction> tr) -> Future<Void> { tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS); for (auto& range : systemRestoreRanges) { tr->clear(range); } return Void(); });
															#line 451 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			if (static_cast<ClearAndRestoreSystemKeysActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3752 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ClearAndRestoreSystemKeysActor*>(this)->actor_wait_state = 1;
															#line 451 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClearAndRestoreSystemKeysActor, 0, Void >*>(static_cast<ClearAndRestoreSystemKeysActor*>(this)));
															#line 3757 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClearAndRestoreSystemKeysActorState();
		static_cast<ClearAndRestoreSystemKeysActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 458 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		restoreTag = Standalone<StringRef>(self->backupTag.toString() + "_system");
															#line 459 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		printf("BackupCorrectness, backupAgent.restore is called for tag:%s\n", restoreTag.toString().c_str());
															#line 460 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		StrictFuture<Void> __when_expr_1 = success(backupAgent->restore(cx, cx, restoreTag, KeyRef(lastBackupContainer->getURL()), lastBackupContainer->getProxy(), systemRestoreRanges, WaitForComplete::True, targetVersion, Verbose::True, Key(), Key(), self->locked, UnlockDB::True, OnlyApplyMutationLogs::False, InconsistentSnapshotOnly::False, ::invalidVersion, self->encryptionKeyFileName));
															#line 460 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (static_cast<ClearAndRestoreSystemKeysActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3786 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ClearAndRestoreSystemKeysActor*>(this)->actor_wait_state = 2;
															#line 460 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClearAndRestoreSystemKeysActor, 1, Void >*>(static_cast<ClearAndRestoreSystemKeysActor*>(this)));
															#line 3791 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 458 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		restoreTag = Standalone<StringRef>(self->backupTag.toString() + "_system");
															#line 459 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		printf("BackupCorrectness, backupAgent.restore is called for tag:%s\n", restoreTag.toString().c_str());
															#line 460 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		StrictFuture<Void> __when_expr_1 = success(backupAgent->restore(cx, cx, restoreTag, KeyRef(lastBackupContainer->getURL()), lastBackupContainer->getProxy(), systemRestoreRanges, WaitForComplete::True, targetVersion, Verbose::True, Key(), Key(), self->locked, UnlockDB::True, OnlyApplyMutationLogs::False, InconsistentSnapshotOnly::False, ::invalidVersion, self->encryptionKeyFileName));
															#line 460 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (static_cast<ClearAndRestoreSystemKeysActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3806 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ClearAndRestoreSystemKeysActor*>(this)->actor_wait_state = 2;
															#line 460 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClearAndRestoreSystemKeysActor, 1, Void >*>(static_cast<ClearAndRestoreSystemKeysActor*>(this)));
															#line 3811 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClearAndRestoreSystemKeysActor*>(this)->actor_wait_state > 0) static_cast<ClearAndRestoreSystemKeysActor*>(this)->actor_wait_state = 0;
		static_cast<ClearAndRestoreSystemKeysActor*>(this)->ActorCallback< ClearAndRestoreSystemKeysActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClearAndRestoreSystemKeysActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clearAndRestoreSystemKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAndRestoreSystemKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAndRestoreSystemKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClearAndRestoreSystemKeysActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clearAndRestoreSystemKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAndRestoreSystemKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAndRestoreSystemKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClearAndRestoreSystemKeysActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clearAndRestoreSystemKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAndRestoreSystemKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAndRestoreSystemKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 477 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		printf("BackupCorrectness, backupAgent.restore finished for tag:%s\n", restoreTag.toString().c_str());
															#line 478 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (!static_cast<ClearAndRestoreSystemKeysActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClearAndRestoreSystemKeysActorState(); static_cast<ClearAndRestoreSystemKeysActor*>(this)->destroy(); return 0; }
															#line 3897 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		new (&static_cast<ClearAndRestoreSystemKeysActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClearAndRestoreSystemKeysActorState();
		static_cast<ClearAndRestoreSystemKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 477 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		printf("BackupCorrectness, backupAgent.restore finished for tag:%s\n", restoreTag.toString().c_str());
															#line 478 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (!static_cast<ClearAndRestoreSystemKeysActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClearAndRestoreSystemKeysActorState(); static_cast<ClearAndRestoreSystemKeysActor*>(this)->destroy(); return 0; }
															#line 3911 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		new (&static_cast<ClearAndRestoreSystemKeysActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClearAndRestoreSystemKeysActorState();
		static_cast<ClearAndRestoreSystemKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ClearAndRestoreSystemKeysActor*>(this)->actor_wait_state > 0) static_cast<ClearAndRestoreSystemKeysActor*>(this)->actor_wait_state = 0;
		static_cast<ClearAndRestoreSystemKeysActor*>(this)->ActorCallback< ClearAndRestoreSystemKeysActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClearAndRestoreSystemKeysActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clearAndRestoreSystemKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAndRestoreSystemKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAndRestoreSystemKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClearAndRestoreSystemKeysActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clearAndRestoreSystemKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAndRestoreSystemKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAndRestoreSystemKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClearAndRestoreSystemKeysActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clearAndRestoreSystemKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAndRestoreSystemKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAndRestoreSystemKeys", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 444 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	Database cx;
															#line 444 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	BackupAndRestorePartitionedCorrectnessWorkload* self;
															#line 444 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	FileBackupAgent* backupAgent;
															#line 444 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	Version targetVersion;
															#line 444 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	Reference<IBackupContainer> lastBackupContainer;
															#line 444 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> systemRestoreRanges;
															#line 458 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	Standalone<StringRef> restoreTag;
															#line 4008 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
};
// This generated class is to be used only via clearAndRestoreSystemKeys()
															#line 444 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
class ClearAndRestoreSystemKeysActor final : public Actor<Void>, public ActorCallback< ClearAndRestoreSystemKeysActor, 0, Void >, public ActorCallback< ClearAndRestoreSystemKeysActor, 1, Void >, public FastAllocated<ClearAndRestoreSystemKeysActor>, public ClearAndRestoreSystemKeysActorState<ClearAndRestoreSystemKeysActor> {
															#line 4013 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
public:
	using FastAllocated<ClearAndRestoreSystemKeysActor>::operator new;
	using FastAllocated<ClearAndRestoreSystemKeysActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16396828882830885120UL, 5814359017035001088UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClearAndRestoreSystemKeysActor, 0, Void >;
friend struct ActorCallback< ClearAndRestoreSystemKeysActor, 1, Void >;
															#line 444 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	ClearAndRestoreSystemKeysActor(Database const& cx,BackupAndRestorePartitionedCorrectnessWorkload* const& self,FileBackupAgent* const& backupAgent,Version const& targetVersion,Reference<IBackupContainer> const& lastBackupContainer,Standalone<VectorRef<KeyRangeRef>> const& systemRestoreRanges) 
															#line 4031 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ClearAndRestoreSystemKeysActorState<ClearAndRestoreSystemKeysActor>(cx, self, backupAgent, targetVersion, lastBackupContainer, systemRestoreRanges),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clearAndRestoreSystemKeys", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16912799750989885184UL, 15867424326961837824UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAndRestoreSystemKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clearAndRestoreSystemKeys");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clearAndRestoreSystemKeys", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClearAndRestoreSystemKeysActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ClearAndRestoreSystemKeysActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 444 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
[[nodiscard]] static Future<Void> clearAndRestoreSystemKeys( Database const& cx, BackupAndRestorePartitionedCorrectnessWorkload* const& self, FileBackupAgent* const& backupAgent, Version const& targetVersion, Reference<IBackupContainer> const& lastBackupContainer, Standalone<VectorRef<KeyRangeRef>> const& systemRestoreRanges ) {
															#line 444 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	return Future<Void>(new ClearAndRestoreSystemKeysActor(cx, self, backupAgent, targetVersion, lastBackupContainer, systemRestoreRanges));
															#line 4064 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
}

#line 480 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"

																#line 4069 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
// This generated class is to be used only via _start()
															#line 481 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
template <class _startActor>
															#line 481 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
class _startActorState {
															#line 4075 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
public:
															#line 481 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	_startActorState(Database const& cx,BackupAndRestorePartitionedCorrectnessWorkload* const& self) 
															#line 481 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
															#line 481 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		 : cx(cx),
															#line 481 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		   self(self),
															#line 482 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		   backupAgent()
															#line 4086 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 483 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			StrictFuture<DatabaseConfiguration> __when_expr_0 = getDatabaseConfiguration(cx);
															#line 483 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4103 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 483 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, DatabaseConfiguration >*>(static_cast<_startActor*>(this)));
															#line 4108 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 484 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		TraceEvent("BARW_Arguments") .detail("BackupTag", printable(self->backupTag)) .detail("PerformRestore", self->performRestore) .detail("BackupAfter", self->backupAfter) .detail("RestoreAfter", self->restoreAfter) .detail("AbortAndRestartAfter", self->abortAndRestartAfter) .detail("DifferentialAfter", self->stopDifferentialAfter);
															#line 492 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		randomID = nondeterministicRandom()->randomUniqueID();
															#line 493 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (self->allowPauses && BUGGIFY)
															#line 4135 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		{
															#line 494 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			cp = changePaused(cx, &backupAgent);
															#line 4139 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		}
															#line 498 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (self->agentRequest)
															#line 4143 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		{
															#line 499 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			BackupAndRestorePartitionedCorrectnessWorkload::backupAgentRequests++;
															#line 4147 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		}
															#line 502 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (self->encryptionKeyFileName.present())
															#line 4151 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		{
															#line 503 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			StrictFuture<Void> __when_expr_1 = BackupContainerFileSystem::createTestEncryptionKeyFile(self->encryptionKeyFileName.get());
															#line 503 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4157 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 503 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 4162 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(DatabaseConfiguration const& __config,int loopDepth) 
	{
															#line 483 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		config = __config;
															#line 4176 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(DatabaseConfiguration && __config,int loopDepth) 
	{
		config = std::move(__config);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, DatabaseConfiguration >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, DatabaseConfiguration >*,DatabaseConfiguration const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, DatabaseConfiguration >*,DatabaseConfiguration && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, DatabaseConfiguration >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
		try {
															#line 507 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			startRestore = delay(self->restoreAfter);
															#line 510 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			StrictFuture<Void> __when_expr_2 = delay(self->backupAfter);
															#line 510 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 4260 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont2Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 510 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 4265 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont6(int loopDepth) 
	{
															#line 757 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 4367 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 754 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			TraceEvent(SevError, "BackupAndRestorePartitionedCorrectness").error(e).GetLastError();
															#line 755 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 4382 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
															#line 512 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		TraceEvent("BARW_DoBackup1", randomID).detail("Tag", printable(self->backupTag));
															#line 513 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		b = doBackup(self, 0, &backupAgent, cx, self->backupTag, self->backupRanges, self->stopDifferentialAfter);
															#line 516 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		TraceEvent("BARW_DoBackupWait", randomID) .detail("BackupTag", printable(self->backupTag)) .detail("AbortAndRestartAfter", self->abortAndRestartAfter);
															#line 4400 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		try {
															#line 520 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			StrictFuture<Void> __when_expr_3 = b;
															#line 520 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont7Catch1(actor_cancelled(), loopDepth);
															#line 4406 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont7Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont7when1(__when_expr_3.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 520 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 4411 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont7Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont7Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
															#line 512 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		TraceEvent("BARW_DoBackup1", randomID).detail("Tag", printable(self->backupTag));
															#line 513 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		b = doBackup(self, 0, &backupAgent, cx, self->backupTag, self->backupRanges, self->stopDifferentialAfter);
															#line 516 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		TraceEvent("BARW_DoBackupWait", randomID) .detail("BackupTag", printable(self->backupTag)) .detail("AbortAndRestartAfter", self->abortAndRestartAfter);
															#line 4430 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		try {
															#line 520 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			StrictFuture<Void> __when_expr_3 = b;
															#line 520 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont7Catch1(actor_cancelled(), loopDepth);
															#line 4436 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont7Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont7when1(__when_expr_3.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 520 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 4441 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont7Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont7Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont8(int loopDepth) 
	{
															#line 528 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		TraceEvent("BARW_DoBackupDone", randomID) .detail("BackupTag", printable(self->backupTag)) .detail("AbortAndRestartAfter", self->abortAndRestartAfter);
															#line 532 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		keyBackedTag = makeBackupTag(self->backupTag.toString());
															#line 533 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		StrictFuture<UidAndAbortedFlagT> __when_expr_4 = keyBackedTag.getOrThrow(cx.getReference());
															#line 533 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 4537 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont2Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont8when1(__when_expr_4.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 533 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, UidAndAbortedFlagT >*>(static_cast<_startActor*>(this)));
															#line 4542 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 522 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			if (e.code() != error_code_database_locked)
															#line 4552 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			{
															#line 523 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
				return a_body1cont2Catch1(e, loopDepth);
															#line 4556 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			}
															#line 524 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			if (self->performRestore)
															#line 4560 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			{
															#line 525 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
				return a_body1cont2Catch1(e, loopDepth);
															#line 4564 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			}
															#line 526 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 4568 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~_startActorState();
			static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont9(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont9(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont7Catch1(error, 0);
		} catch (...) {
			a_body1cont7Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont7Catch1(error, 0);
		} catch (...) {
			a_body1cont7Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont7Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont7Catch1(error, 0);
		} catch (...) {
			a_body1cont7Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11(UidAndAbortedFlagT const& uidFlag,int loopDepth) 
	{
															#line 534 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		logUid = uidFlag.first;
															#line 535 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		StrictFuture<Key> __when_expr_5 = BackupConfig(logUid).destUidValue().getD(cx.getReference());
															#line 535 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 4690 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont2Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont11when1(__when_expr_5.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 535 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Key >*>(static_cast<_startActor*>(this)));
															#line 4695 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11(UidAndAbortedFlagT && uidFlag,int loopDepth) 
	{
															#line 534 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		logUid = uidFlag.first;
															#line 535 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		StrictFuture<Key> __when_expr_5 = BackupConfig(logUid).destUidValue().getD(cx.getReference());
															#line 535 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 4708 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont2Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont11when1(__when_expr_5.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 535 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Key >*>(static_cast<_startActor*>(this)));
															#line 4713 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8when1(UidAndAbortedFlagT const& uidFlag,int loopDepth) 
	{
		loopDepth = a_body1cont11(uidFlag, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(UidAndAbortedFlagT && uidFlag,int loopDepth) 
	{
		loopDepth = a_body1cont11(std::move(uidFlag), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 4, UidAndAbortedFlagT >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 4, UidAndAbortedFlagT >*,UidAndAbortedFlagT const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _startActor, 4, UidAndAbortedFlagT >*,UidAndAbortedFlagT && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _startActor, 4, UidAndAbortedFlagT >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont11cont1(int loopDepth) 
	{
															#line 536 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		StrictFuture<Reference<IBackupContainer>> __when_expr_6 = BackupConfig(logUid).backupContainer().getD(cx.getReference());
															#line 536 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 4799 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont2Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont11cont1when1(__when_expr_6.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 536 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, Reference<IBackupContainer> >*>(static_cast<_startActor*>(this)));
															#line 4804 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11when1(Key const& __destUidValue,int loopDepth) 
	{
															#line 535 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		destUidValue = __destUidValue;
															#line 4813 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		loopDepth = a_body1cont11cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11when1(Key && __destUidValue,int loopDepth) 
	{
		destUidValue = std::move(__destUidValue);
		loopDepth = a_body1cont11cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 5, Key >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _startActor, 5, Key >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont11cont2(int loopDepth) 
	{
															#line 539 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		CODE_PROBE(!startRestore.isReady(), "Restore starts at specified time");
															#line 540 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		StrictFuture<Void> __when_expr_7 = startRestore;
															#line 540 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 4896 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont2Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont11cont2when1(__when_expr_7.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 8;
															#line 540 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _startActor, 7, Void >*>(static_cast<_startActor*>(this)));
															#line 4901 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont1when1(Reference<IBackupContainer> const& __lastBackupContainer,int loopDepth) 
	{
															#line 536 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		lastBackupContainer = __lastBackupContainer;
															#line 4910 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		loopDepth = a_body1cont11cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont1when1(Reference<IBackupContainer> && __lastBackupContainer,int loopDepth) 
	{
		lastBackupContainer = std::move(__lastBackupContainer);
		loopDepth = a_body1cont11cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 6, Reference<IBackupContainer> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Reference<IBackupContainer> >*,Reference<IBackupContainer> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont11cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Reference<IBackupContainer> >*,Reference<IBackupContainer> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont11cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< _startActor, 6, Reference<IBackupContainer> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont11cont3(Void const& _,int loopDepth) 
	{
															#line 542 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (lastBackupContainer && self->performRestore)
															#line 4989 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		{
															#line 543 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			auto container = IBackupContainer::openContainer(lastBackupContainer->getURL(), lastBackupContainer->getProxy(), lastBackupContainer->getEncryptionKeyFileName());
															#line 546 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			StrictFuture<BackupDescription> __when_expr_8 = container->describeBackup();
															#line 546 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 4997 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont2Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont11cont3when1(__when_expr_8.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 9;
															#line 546 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< _startActor, 8, BackupDescription >*>(static_cast<_startActor*>(this)));
															#line 5002 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont11cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont3(Void && _,int loopDepth) 
	{
															#line 542 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (lastBackupContainer && self->performRestore)
															#line 5016 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		{
															#line 543 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			auto container = IBackupContainer::openContainer(lastBackupContainer->getURL(), lastBackupContainer->getProxy(), lastBackupContainer->getEncryptionKeyFileName());
															#line 546 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			StrictFuture<BackupDescription> __when_expr_8 = container->describeBackup();
															#line 546 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 5024 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont2Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont11cont3when1(__when_expr_8.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 9;
															#line 546 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< _startActor, 8, BackupDescription >*>(static_cast<_startActor*>(this)));
															#line 5029 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont11cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont11cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< _startActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont11cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< _startActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont11cont4(int loopDepth) 
	{
															#line 635 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		backupAgentKey = uidPrefixKey(logRangesRange.begin, logUid);
															#line 636 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		backupLogValuesKey = destUidValue.withPrefix(backupLogKeys.begin);
															#line 637 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		backupLatestVersionsPath = destUidValue.withPrefix(backupLatestVersionsPrefix);
															#line 638 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		backupLatestVersionsKey = uidPrefixKey(backupLatestVersionsPath, logUid);
															#line 639 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		displaySystemKeys = 0;
															#line 642 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		;
															#line 5128 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		loopDepth = a_body1cont11cont4loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont5(BackupDescription const& desc,int loopDepth) 
	{
															#line 547 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		targetVersion = -1;
															#line 548 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (desc.maxRestorableVersion.present())
															#line 5139 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		{
															#line 549 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			if (deterministicRandom()->random01() < 0.1)
															#line 5143 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			{
															#line 550 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
				targetVersion = desc.minRestorableVersion.get();
															#line 5147 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			}
			else
			{
															#line 551 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
				if (deterministicRandom()->random01() < 0.1)
															#line 5153 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
				{
															#line 552 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
					targetVersion = desc.maxRestorableVersion.get();
															#line 5157 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
				}
				else
				{
															#line 553 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
					if (deterministicRandom()->random01() < 0.5)
															#line 5163 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
					{
															#line 554 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
						targetVersion = (desc.minRestorableVersion.get() != desc.maxRestorableVersion.get()) ? deterministicRandom()->randomInt64(desc.minRestorableVersion.get(), desc.maxRestorableVersion.get()) : desc.maxRestorableVersion.get();
															#line 5167 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
					}
				}
			}
		}
															#line 560 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		StrictFuture<Void> __when_expr_9 = runRYWTransaction(cx, [=](Reference<ReadYourWritesTransaction> tr) -> Future<Void> { tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS); for (auto& kvrange : self->backupRanges) { tr->clear(kvrange); } return Void(); });
															#line 560 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 5176 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont2Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont11cont5when1(__when_expr_9.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 10;
															#line 560 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< _startActor, 9, Void >*>(static_cast<_startActor*>(this)));
															#line 5181 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont5(BackupDescription && desc,int loopDepth) 
	{
															#line 547 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		targetVersion = -1;
															#line 548 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (desc.maxRestorableVersion.present())
															#line 5192 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		{
															#line 549 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			if (deterministicRandom()->random01() < 0.1)
															#line 5196 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			{
															#line 550 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
				targetVersion = desc.minRestorableVersion.get();
															#line 5200 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			}
			else
			{
															#line 551 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
				if (deterministicRandom()->random01() < 0.1)
															#line 5206 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
				{
															#line 552 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
					targetVersion = desc.maxRestorableVersion.get();
															#line 5210 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
				}
				else
				{
															#line 553 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
					if (deterministicRandom()->random01() < 0.5)
															#line 5216 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
					{
															#line 554 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
						targetVersion = (desc.minRestorableVersion.get() != desc.maxRestorableVersion.get()) ? deterministicRandom()->randomInt64(desc.minRestorableVersion.get(), desc.maxRestorableVersion.get()) : desc.maxRestorableVersion.get();
															#line 5220 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
					}
				}
			}
		}
															#line 560 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		StrictFuture<Void> __when_expr_9 = runRYWTransaction(cx, [=](Reference<ReadYourWritesTransaction> tr) -> Future<Void> { tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS); for (auto& kvrange : self->backupRanges) { tr->clear(kvrange); } return Void(); });
															#line 560 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 5229 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont2Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont11cont5when1(__when_expr_9.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 10;
															#line 560 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< _startActor, 9, Void >*>(static_cast<_startActor*>(this)));
															#line 5234 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont3when1(BackupDescription const& desc,int loopDepth) 
	{
		loopDepth = a_body1cont11cont5(desc, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont3when1(BackupDescription && desc,int loopDepth) 
	{
		loopDepth = a_body1cont11cont5(std::move(desc), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 8, BackupDescription >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 8, BackupDescription >*,BackupDescription const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont11cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< _startActor, 8, BackupDescription >*,BackupDescription && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont11cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< _startActor, 8, BackupDescription >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont11cont6(Void const& _,int loopDepth) 
	{
															#line 571 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		TraceEvent("BARW_Restore", randomID) .detail("LastBackupContainer", lastBackupContainer->getURL()) .detail("RestoreAfter", self->restoreAfter) .detail("BackupTag", printable(self->backupTag)) .detail("TargetVersion", targetVersion);
															#line 576 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		restores = std::vector<Future<Version>>();
															#line 577 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		restoreTags = std::vector<Standalone<StringRef>>();
															#line 578 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		restoreIndex = 0;
															#line 581 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		Standalone<VectorRef<KeyRangeRef>> modifiedRestoreRanges;
															#line 582 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		Standalone<VectorRef<KeyRangeRef>> systemRestoreRanges;
															#line 583 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		for(int i = 0;i < self->restoreRanges.size();++i) {
															#line 584 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			if (!self->restoreRanges[i].intersects(getSystemBackupRanges()))
															#line 5332 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			{
															#line 585 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
				modifiedRestoreRanges.push_back_deep(modifiedRestoreRanges.arena(), self->restoreRanges[i]);
															#line 5336 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			}
			else
			{
															#line 587 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
				KeyRangeRef normalKeyRange = self->restoreRanges[i] & normalKeys;
															#line 588 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
				KeyRangeRef systemKeyRange = self->restoreRanges[i] & systemKeys;
															#line 589 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
				if (!normalKeyRange.empty())
															#line 5346 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
				{
															#line 590 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
					modifiedRestoreRanges.push_back_deep(modifiedRestoreRanges.arena(), normalKeyRange);
															#line 5350 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
				}
															#line 592 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
				if (!systemKeyRange.empty())
															#line 5354 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
				{
															#line 593 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
					systemRestoreRanges.push_back_deep(systemRestoreRanges.arena(), systemKeyRange);
															#line 5358 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
				}
			}
		}
															#line 597 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		self->restoreRanges = modifiedRestoreRanges;
															#line 598 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (!systemRestoreRanges.empty())
															#line 5366 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		{
															#line 602 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			StrictFuture<Void> __when_expr_10 = clearAndRestoreSystemKeys( cx, self, &backupAgent, targetVersion, lastBackupContainer, systemRestoreRanges);
															#line 602 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 5372 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1cont2Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont11cont6when1(__when_expr_10.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 11;
															#line 602 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< _startActor, 10, Void >*>(static_cast<_startActor*>(this)));
															#line 5377 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont11cont13(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont6(Void && _,int loopDepth) 
	{
															#line 571 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		TraceEvent("BARW_Restore", randomID) .detail("LastBackupContainer", lastBackupContainer->getURL()) .detail("RestoreAfter", self->restoreAfter) .detail("BackupTag", printable(self->backupTag)) .detail("TargetVersion", targetVersion);
															#line 576 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		restores = std::vector<Future<Version>>();
															#line 577 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		restoreTags = std::vector<Standalone<StringRef>>();
															#line 578 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		restoreIndex = 0;
															#line 581 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		Standalone<VectorRef<KeyRangeRef>> modifiedRestoreRanges;
															#line 582 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		Standalone<VectorRef<KeyRangeRef>> systemRestoreRanges;
															#line 583 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		for(int i = 0;i < self->restoreRanges.size();++i) {
															#line 584 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			if (!self->restoreRanges[i].intersects(getSystemBackupRanges()))
															#line 5405 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			{
															#line 585 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
				modifiedRestoreRanges.push_back_deep(modifiedRestoreRanges.arena(), self->restoreRanges[i]);
															#line 5409 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			}
			else
			{
															#line 587 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
				KeyRangeRef normalKeyRange = self->restoreRanges[i] & normalKeys;
															#line 588 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
				KeyRangeRef systemKeyRange = self->restoreRanges[i] & systemKeys;
															#line 589 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
				if (!normalKeyRange.empty())
															#line 5419 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
				{
															#line 590 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
					modifiedRestoreRanges.push_back_deep(modifiedRestoreRanges.arena(), normalKeyRange);
															#line 5423 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
				}
															#line 592 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
				if (!systemKeyRange.empty())
															#line 5427 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
				{
															#line 593 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
					systemRestoreRanges.push_back_deep(systemRestoreRanges.arena(), systemKeyRange);
															#line 5431 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
				}
			}
		}
															#line 597 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		self->restoreRanges = modifiedRestoreRanges;
															#line 598 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (!systemRestoreRanges.empty())
															#line 5439 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		{
															#line 602 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			StrictFuture<Void> __when_expr_10 = clearAndRestoreSystemKeys( cx, self, &backupAgent, targetVersion, lastBackupContainer, systemRestoreRanges);
															#line 602 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 5445 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1cont2Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont11cont6when1(__when_expr_10.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 11;
															#line 602 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< _startActor, 10, Void >*>(static_cast<_startActor*>(this)));
															#line 5450 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont11cont13(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont11cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< _startActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont11cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< _startActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont11cont13(int loopDepth) 
	{
															#line 607 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		Standalone<StringRef> restoreTag(self->backupTag.toString() + "_" + std::to_string(restoreIndex));
															#line 608 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		restoreTags.push_back(restoreTag);
															#line 609 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		printf("BackupCorrectness, backupAgent.restore is called for restoreIndex:%d tag:%s\n", restoreIndex, restoreTag.toString().c_str());
															#line 612 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		restores.push_back(backupAgent.restore(cx, cx, restoreTag, KeyRef(lastBackupContainer->getURL()), lastBackupContainer->getProxy(), self->restoreRanges, WaitForComplete::True, targetVersion, Verbose::True, Key(), Key(), self->locked, UnlockDB::True, OnlyApplyMutationLogs::False, InconsistentSnapshotOnly::False, ::invalidVersion, self->encryptionKeyFileName));
															#line 629 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		StrictFuture<Void> __when_expr_11 = waitForAll(restores);
															#line 629 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 5549 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1cont2Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont11cont13when1(__when_expr_11.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 12;
															#line 629 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< _startActor, 11, Void >*>(static_cast<_startActor*>(this)));
															#line 5554 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont19(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont13(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont19(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont13(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont19(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont19(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont11cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< _startActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont11cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< _startActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont11cont13cont1(Void const& _,int loopDepth) 
	{
															#line 631 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		for( auto& restore : restores ) {
															#line 632 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			ASSERT(!restore.isError());
															#line 5652 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont11cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont13cont1(Void && _,int loopDepth) 
	{
															#line 631 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		for( auto& restore : restores ) {
															#line 632 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			ASSERT(!restore.isError());
															#line 5664 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont11cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont13when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont13cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont13when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont13cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont11cont13when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< _startActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont11cont13when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< _startActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1cont11cont20(int loopDepth) 
	{
															#line 737 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (displaySystemKeys)
															#line 5749 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		{
															#line 738 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			StrictFuture<Void> __when_expr_20 = TaskBucket::debugPrintRange(cx, normalKeys.end, StringRef());
															#line 738 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 5755 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			if (__when_expr_20.isReady()) { if (__when_expr_20.isError()) return a_body1cont2Catch1(__when_expr_20.getError(), loopDepth); else return a_body1cont11cont20when1(__when_expr_20.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 21;
															#line 738 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			__when_expr_20.addCallbackAndClear(static_cast<ActorCallback< _startActor, 20, Void >*>(static_cast<_startActor*>(this)));
															#line 5760 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont11cont20cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont4loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont11cont4loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont4loopBody1(int loopDepth) 
	{
															#line 643 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		tr = Reference<ReadYourWritesTransaction>(new ReadYourWritesTransaction(cx));
															#line 645 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		TraceEvent("BARW_CheckLeftoverKeys", randomID).detail("BackupTag", printable(self->backupTag));
															#line 5783 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		try {
															#line 651 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			TraceEvent("BARW_CheckLeftoverTasks", randomID).detail("BackupTag", printable(self->backupTag));
															#line 652 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			StrictFuture<int64_t> __when_expr_12 = backupAgent.getTaskCount(tr);
															#line 652 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont11cont4loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5791 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1cont11cont4loopBody1Catch1(__when_expr_12.getError(), loopDepth); else return a_body1cont11cont4loopBody1when1(__when_expr_12.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 13;
															#line 652 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< _startActor, 12, int64_t >*>(static_cast<_startActor*>(this)));
															#line 5796 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont11cont4loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont11cont4loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont4break1(int loopDepth) 
	{
		try {
			return a_body1cont11cont20(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont4loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont11cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont11cont4loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 732 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			TraceEvent("BARW_CheckException", randomID).error(e);
															#line 733 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			StrictFuture<Void> __when_expr_19 = tr->onError(e);
															#line 733 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5835 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			if (__when_expr_19.isReady()) { if (__when_expr_19.isError()) return a_body1cont2Catch1(__when_expr_19.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11cont4loopBody1Catch1when1(__when_expr_19.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 20;
															#line 733 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			__when_expr_19.addCallbackAndClear(static_cast<ActorCallback< _startActor, 19, Void >*>(static_cast<_startActor*>(this)));
															#line 5840 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont11cont4loopBody1cont2(int loopDepth) 
	{
															#line 653 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		waitCycles = 0;
															#line 655 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		;
															#line 5857 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		loopDepth = a_body1cont11cont4loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont4loopBody1when1(int64_t const& __taskCount,int loopDepth) 
	{
															#line 652 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		taskCount = __taskCount;
															#line 5866 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		loopDepth = a_body1cont11cont4loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont4loopBody1when1(int64_t && __taskCount,int loopDepth) 
	{
		taskCount = std::move(__taskCount);
		loopDepth = a_body1cont11cont4loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 12, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 12, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont11cont4loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< _startActor, 12, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont11cont4loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< _startActor, 12, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont11cont4loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 12);

	}
	int a_body1cont11cont4loopBody1cont3(int loopDepth) 
	{
															#line 674 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		StrictFuture<RangeResult> __when_expr_15 = tr->getRange(KeyRange(KeyRangeRef(backupAgentKey, strinc(backupAgentKey))), 100);
															#line 674 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont11cont4loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5947 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1cont11cont4loopBody1Catch1(__when_expr_15.getError(), loopDepth); else return a_body1cont11cont4loopBody1cont3when1(__when_expr_15.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 16;
															#line 674 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		__when_expr_15.addCallbackAndClear(static_cast<ActorCallback< _startActor, 15, RangeResult >*>(static_cast<_startActor*>(this)));
															#line 5952 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont4loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont11cont4loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont4loopBody1cont2loopBody1(int loopDepth) 
	{
															#line 655 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (!(taskCount > 0))
															#line 5968 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		{
			return a_body1cont11cont4loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 656 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		waitCycles++;
															#line 658 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		TraceEvent("BARW_NonzeroTaskWait", randomID) .detail("BackupTag", printable(self->backupTag)) .detail("TaskCount", taskCount) .detail("WaitCycles", waitCycles);
															#line 662 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		printf("%.6f %-10s Wait #%4d for %lld tasks to end\n", now(), randomID.toString().c_str(), waitCycles, (long long)taskCount);
															#line 668 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		StrictFuture<Void> __when_expr_13 = delay(5.0);
															#line 668 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont11cont4loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5982 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1cont11cont4loopBody1Catch1(__when_expr_13.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11cont4loopBody1cont2loopBody1when1(__when_expr_13.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 14;
															#line 668 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< _startActor, 13, Void >*>(static_cast<_startActor*>(this)));
															#line 5987 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont4loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont11cont4loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont11cont4loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont11cont4loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont4loopBody1cont2loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 670 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		tr = makeReference<ReadYourWritesTransaction>(cx);
															#line 671 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		StrictFuture<Void> __when_expr_14 = store(taskCount, backupAgent.getTaskCount(tr));
															#line 671 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont11cont4loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6013 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1cont11cont4loopBody1Catch1(__when_expr_14.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11cont4loopBody1cont2loopBody1cont1when1(__when_expr_14.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 15;
															#line 671 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< _startActor, 14, Void >*>(static_cast<_startActor*>(this)));
															#line 6018 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont4loopBody1cont2loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 670 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		tr = makeReference<ReadYourWritesTransaction>(cx);
															#line 671 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		StrictFuture<Void> __when_expr_14 = store(taskCount, backupAgent.getTaskCount(tr));
															#line 671 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont11cont4loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6031 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1cont11cont4loopBody1Catch1(__when_expr_14.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11cont4loopBody1cont2loopBody1cont1when1(__when_expr_14.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 15;
															#line 671 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< _startActor, 14, Void >*>(static_cast<_startActor*>(this)));
															#line 6036 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont4loopBody1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont4loopBody1cont2loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont4loopBody1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont4loopBody1cont2loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose14() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 13, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 13, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont11cont4loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorCallback< _startActor, 13, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont11cont4loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorCallback< _startActor, 13, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont11cont4loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 13);

	}
	int a_body1cont11cont4loopBody1cont2loopBody1cont3(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont11cont4loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont11cont4loopBody1cont2loopBody1cont3(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont11cont4loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont11cont4loopBody1cont2loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont4loopBody1cont2loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont4loopBody1cont2loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont4loopBody1cont2loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose15() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 14, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 14, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont11cont4loopBody1cont2loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_fire(ActorCallback< _startActor, 14, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont11cont4loopBody1cont2loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_error(ActorCallback< _startActor, 14, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont11cont4loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 14);

	}
	int a_body1cont11cont4loopBody1cont4(RangeResult const& agentValues,int loopDepth) 
	{
															#line 678 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (agentValues.size() > 0)
															#line 6207 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		{
															#line 679 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			displaySystemKeys++;
															#line 680 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			printf("BackupCorrectnessLeftOverMutationKeys: (%d) %s\n", agentValues.size(), printable(backupAgentKey).c_str());
															#line 683 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			TraceEvent(SevError, "BackupCorrectnessLeftOverMutationKeys", randomID) .detail("BackupTag", printable(self->backupTag)) .detail("LeftOverKeys", agentValues.size()) .detail("KeySpace", printable(backupAgentKey));
															#line 687 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			for( auto& s : agentValues ) {
															#line 688 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
				TraceEvent("BARW_LeftOverKey", randomID) .detail("Key", printable(StringRef(s.key.toString()))) .detail("Value", printable(StringRef(s.value.toString())));
															#line 691 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
				printf("   Key: %-50s  Value: %s\n", printable(StringRef(s.key.toString())).c_str(), printable(StringRef(s.value.toString())).c_str());
															#line 6221 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 696 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			printf("No left over backup agent configuration keys\n");
															#line 6228 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		}
															#line 699 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_16 = tr->get(backupLatestVersionsKey);
															#line 699 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont11cont4loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6234 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		if (__when_expr_16.isReady()) { if (__when_expr_16.isError()) return a_body1cont11cont4loopBody1Catch1(__when_expr_16.getError(), loopDepth); else return a_body1cont11cont4loopBody1cont4when1(__when_expr_16.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 17;
															#line 699 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		__when_expr_16.addCallbackAndClear(static_cast<ActorCallback< _startActor, 16, Optional<Value> >*>(static_cast<_startActor*>(this)));
															#line 6239 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont4loopBody1cont4(RangeResult && agentValues,int loopDepth) 
	{
															#line 678 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (agentValues.size() > 0)
															#line 6248 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		{
															#line 679 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			displaySystemKeys++;
															#line 680 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			printf("BackupCorrectnessLeftOverMutationKeys: (%d) %s\n", agentValues.size(), printable(backupAgentKey).c_str());
															#line 683 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			TraceEvent(SevError, "BackupCorrectnessLeftOverMutationKeys", randomID) .detail("BackupTag", printable(self->backupTag)) .detail("LeftOverKeys", agentValues.size()) .detail("KeySpace", printable(backupAgentKey));
															#line 687 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			for( auto& s : agentValues ) {
															#line 688 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
				TraceEvent("BARW_LeftOverKey", randomID) .detail("Key", printable(StringRef(s.key.toString()))) .detail("Value", printable(StringRef(s.value.toString())));
															#line 691 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
				printf("   Key: %-50s  Value: %s\n", printable(StringRef(s.key.toString())).c_str(), printable(StringRef(s.value.toString())).c_str());
															#line 6262 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 696 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			printf("No left over backup agent configuration keys\n");
															#line 6269 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		}
															#line 699 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_16 = tr->get(backupLatestVersionsKey);
															#line 699 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont11cont4loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6275 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		if (__when_expr_16.isReady()) { if (__when_expr_16.isError()) return a_body1cont11cont4loopBody1Catch1(__when_expr_16.getError(), loopDepth); else return a_body1cont11cont4loopBody1cont4when1(__when_expr_16.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 17;
															#line 699 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		__when_expr_16.addCallbackAndClear(static_cast<ActorCallback< _startActor, 16, Optional<Value> >*>(static_cast<_startActor*>(this)));
															#line 6280 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont4loopBody1cont3when1(RangeResult const& agentValues,int loopDepth) 
	{
		loopDepth = a_body1cont11cont4loopBody1cont4(agentValues, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont4loopBody1cont3when1(RangeResult && agentValues,int loopDepth) 
	{
		loopDepth = a_body1cont11cont4loopBody1cont4(std::move(agentValues), loopDepth);

		return loopDepth;
	}
	void a_exitChoose16() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 15, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 15, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont11cont4loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_fire(ActorCallback< _startActor, 15, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont11cont4loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_error(ActorCallback< _startActor, 15, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont11cont4loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 15);

	}
	int a_body1cont11cont4loopBody1cont5(Optional<Value> const& latestVersion,int loopDepth) 
	{
															#line 700 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (latestVersion.present())
															#line 6364 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		{
															#line 701 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			TraceEvent(SevError, "BackupCorrectnessLeftOverVersionKey", randomID) .detail("BackupTag", printable(self->backupTag)) .detail("BackupLatestVersionsKey", backupLatestVersionsKey.printable()) .detail("DestUidValue", destUidValue.printable());
															#line 6368 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		}
		else
		{
															#line 706 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			printf("No left over backup version key\n");
															#line 6374 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		}
															#line 709 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		StrictFuture<RangeResult> __when_expr_17 = tr->getRange( KeyRange(KeyRangeRef(backupLatestVersionsPath, strinc(backupLatestVersionsPath))), 1);
															#line 709 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont11cont4loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6380 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		if (__when_expr_17.isReady()) { if (__when_expr_17.isError()) return a_body1cont11cont4loopBody1Catch1(__when_expr_17.getError(), loopDepth); else return a_body1cont11cont4loopBody1cont5when1(__when_expr_17.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 18;
															#line 709 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		__when_expr_17.addCallbackAndClear(static_cast<ActorCallback< _startActor, 17, RangeResult >*>(static_cast<_startActor*>(this)));
															#line 6385 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont4loopBody1cont5(Optional<Value> && latestVersion,int loopDepth) 
	{
															#line 700 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (latestVersion.present())
															#line 6394 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		{
															#line 701 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			TraceEvent(SevError, "BackupCorrectnessLeftOverVersionKey", randomID) .detail("BackupTag", printable(self->backupTag)) .detail("BackupLatestVersionsKey", backupLatestVersionsKey.printable()) .detail("DestUidValue", destUidValue.printable());
															#line 6398 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		}
		else
		{
															#line 706 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			printf("No left over backup version key\n");
															#line 6404 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		}
															#line 709 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		StrictFuture<RangeResult> __when_expr_17 = tr->getRange( KeyRange(KeyRangeRef(backupLatestVersionsPath, strinc(backupLatestVersionsPath))), 1);
															#line 709 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont11cont4loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6410 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		if (__when_expr_17.isReady()) { if (__when_expr_17.isError()) return a_body1cont11cont4loopBody1Catch1(__when_expr_17.getError(), loopDepth); else return a_body1cont11cont4loopBody1cont5when1(__when_expr_17.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 18;
															#line 709 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		__when_expr_17.addCallbackAndClear(static_cast<ActorCallback< _startActor, 17, RangeResult >*>(static_cast<_startActor*>(this)));
															#line 6415 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont4loopBody1cont4when1(Optional<Value> const& latestVersion,int loopDepth) 
	{
		loopDepth = a_body1cont11cont4loopBody1cont5(latestVersion, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont4loopBody1cont4when1(Optional<Value> && latestVersion,int loopDepth) 
	{
		loopDepth = a_body1cont11cont4loopBody1cont5(std::move(latestVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose17() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 16, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 16, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont11cont4loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_fire(ActorCallback< _startActor, 16, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont11cont4loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_error(ActorCallback< _startActor, 16, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont11cont4loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 16);

	}
	int a_body1cont11cont4loopBody1cont9(RangeResult const& versions,int loopDepth) 
	{
															#line 711 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (!self->shareLogRange || !versions.size())
															#line 6499 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		{
															#line 712 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			StrictFuture<RangeResult> __when_expr_18 = tr->getRange(KeyRange(KeyRangeRef(backupLogValuesKey, strinc(backupLogValuesKey))), 100);
															#line 712 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont11cont4loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6505 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			if (__when_expr_18.isReady()) { if (__when_expr_18.isError()) return a_body1cont11cont4loopBody1Catch1(__when_expr_18.getError(), loopDepth); else return a_body1cont11cont4loopBody1cont9when1(__when_expr_18.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 19;
															#line 712 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			__when_expr_18.addCallbackAndClear(static_cast<ActorCallback< _startActor, 18, RangeResult >*>(static_cast<_startActor*>(this)));
															#line 6510 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont11cont4loopBody1cont12(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont4loopBody1cont9(RangeResult && versions,int loopDepth) 
	{
															#line 711 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (!self->shareLogRange || !versions.size())
															#line 6524 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		{
															#line 712 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			StrictFuture<RangeResult> __when_expr_18 = tr->getRange(KeyRange(KeyRangeRef(backupLogValuesKey, strinc(backupLogValuesKey))), 100);
															#line 712 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont11cont4loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6530 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			if (__when_expr_18.isReady()) { if (__when_expr_18.isError()) return a_body1cont11cont4loopBody1Catch1(__when_expr_18.getError(), loopDepth); else return a_body1cont11cont4loopBody1cont9when1(__when_expr_18.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 19;
															#line 712 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			__when_expr_18.addCallbackAndClear(static_cast<ActorCallback< _startActor, 18, RangeResult >*>(static_cast<_startActor*>(this)));
															#line 6535 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont11cont4loopBody1cont12(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont4loopBody1cont5when1(RangeResult const& versions,int loopDepth) 
	{
		loopDepth = a_body1cont11cont4loopBody1cont9(versions, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont4loopBody1cont5when1(RangeResult && versions,int loopDepth) 
	{
		loopDepth = a_body1cont11cont4loopBody1cont9(std::move(versions), loopDepth);

		return loopDepth;
	}
	void a_exitChoose18() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 17, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 17, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont11cont4loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_fire(ActorCallback< _startActor, 17, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont11cont4loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_error(ActorCallback< _startActor, 17, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont11cont4loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 17);

	}
	int a_body1cont11cont4loopBody1cont12(int loopDepth) 
	{
		return a_body1cont11cont4break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont11cont4loopBody1cont13(RangeResult const& logValues,int loopDepth) 
	{
															#line 716 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (logValues.size() > 0)
															#line 6630 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		{
															#line 717 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			displaySystemKeys++;
															#line 718 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			printf("BackupCorrectnessLeftOverLogKeys: (%d) %s\n", logValues.size(), printable(backupLogValuesKey).c_str());
															#line 721 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			TraceEvent(SevError, "BackupCorrectnessLeftOverLogKeys", randomID) .detail("BackupTag", printable(self->backupTag)) .detail("LeftOverKeys", logValues.size()) .detail("KeySpace", printable(backupLogValuesKey));
															#line 6638 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		}
		else
		{
															#line 726 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			printf("No left over backup log keys\n");
															#line 6644 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont11cont4loopBody1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont4loopBody1cont13(RangeResult && logValues,int loopDepth) 
	{
															#line 716 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (logValues.size() > 0)
															#line 6654 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		{
															#line 717 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			displaySystemKeys++;
															#line 718 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			printf("BackupCorrectnessLeftOverLogKeys: (%d) %s\n", logValues.size(), printable(backupLogValuesKey).c_str());
															#line 721 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			TraceEvent(SevError, "BackupCorrectnessLeftOverLogKeys", randomID) .detail("BackupTag", printable(self->backupTag)) .detail("LeftOverKeys", logValues.size()) .detail("KeySpace", printable(backupLogValuesKey));
															#line 6662 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		}
		else
		{
															#line 726 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			printf("No left over backup log keys\n");
															#line 6668 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont11cont4loopBody1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont4loopBody1cont9when1(RangeResult const& logValues,int loopDepth) 
	{
		loopDepth = a_body1cont11cont4loopBody1cont13(logValues, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont4loopBody1cont9when1(RangeResult && logValues,int loopDepth) 
	{
		loopDepth = a_body1cont11cont4loopBody1cont13(std::move(logValues), loopDepth);

		return loopDepth;
	}
	void a_exitChoose19() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 18, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 18, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1cont11cont4loopBody1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_fire(ActorCallback< _startActor, 18, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1cont11cont4loopBody1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_error(ActorCallback< _startActor, 18, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1cont11cont4loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 18);

	}
	int a_body1cont11cont4loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont4loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont4loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont4loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont4loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont4loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont4loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont4loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose20() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 19, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 19, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1cont11cont4loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 19);

	}
	void a_callback_fire(ActorCallback< _startActor, 19, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1cont11cont4loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 19);

	}
	void a_callback_error(ActorCallback< _startActor, 19, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 19);

	}
	int a_body1cont11cont20cont1(int loopDepth) 
	{
															#line 741 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		TraceEvent("BARW_Complete", randomID).detail("BackupTag", printable(self->backupTag));
															#line 744 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if (self->agentRequest)
															#line 6842 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		{
															#line 745 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			BackupAndRestorePartitionedCorrectnessWorkload::backupAgentRequests--;
															#line 6846 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		}
															#line 749 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
		if ((g_simulator->backupAgents == ISimulator::BackupAgentType::BackupToFile) && (!BackupAndRestorePartitionedCorrectnessWorkload::backupAgentRequests))
															#line 6850 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		{
															#line 751 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
			g_simulator->backupAgents = ISimulator::BackupAgentType::NoBackupAgents;
															#line 6854 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont11cont20cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont20cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont20cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont20cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont20cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont20when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont20cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont20when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont20cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose21() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 20, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 20, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose21();
		try {
			a_body1cont11cont20when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 20);

	}
	void a_callback_fire(ActorCallback< _startActor, 20, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose21();
		try {
			a_body1cont11cont20when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 20);

	}
	void a_callback_error(ActorCallback< _startActor, 20, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose21();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 20);

	}
	int a_body1cont11cont20cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 481 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	Database cx;
															#line 481 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	BackupAndRestorePartitionedCorrectnessWorkload* self;
															#line 482 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	FileBackupAgent backupAgent;
															#line 483 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	DatabaseConfiguration config;
															#line 492 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	UID randomID;
															#line 494 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	Future<Void> cp;
															#line 507 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	Future<Void> startRestore;
															#line 513 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	Future<Void> b;
															#line 532 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	KeyBackedTag keyBackedTag;
															#line 534 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	UID logUid;
															#line 535 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	Key destUidValue;
															#line 536 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	Reference<IBackupContainer> lastBackupContainer;
															#line 547 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	Version targetVersion;
															#line 576 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	std::vector<Future<Version>> restores;
															#line 577 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	std::vector<Standalone<StringRef>> restoreTags;
															#line 578 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	int restoreIndex;
															#line 635 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	Key backupAgentKey;
															#line 636 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	Key backupLogValuesKey;
															#line 637 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	Key backupLatestVersionsPath;
															#line 638 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	Key backupLatestVersionsKey;
															#line 639 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	int displaySystemKeys;
															#line 643 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 652 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	int64_t taskCount;
															#line 653 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	int waitCycles;
															#line 7008 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _start()
															#line 481 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, DatabaseConfiguration >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, Void >, public ActorCallback< _startActor, 3, Void >, public ActorCallback< _startActor, 4, UidAndAbortedFlagT >, public ActorCallback< _startActor, 5, Key >, public ActorCallback< _startActor, 6, Reference<IBackupContainer> >, public ActorCallback< _startActor, 7, Void >, public ActorCallback< _startActor, 8, BackupDescription >, public ActorCallback< _startActor, 9, Void >, public ActorCallback< _startActor, 10, Void >, public ActorCallback< _startActor, 11, Void >, public ActorCallback< _startActor, 12, int64_t >, public ActorCallback< _startActor, 13, Void >, public ActorCallback< _startActor, 14, Void >, public ActorCallback< _startActor, 15, RangeResult >, public ActorCallback< _startActor, 16, Optional<Value> >, public ActorCallback< _startActor, 17, RangeResult >, public ActorCallback< _startActor, 18, RangeResult >, public ActorCallback< _startActor, 19, Void >, public ActorCallback< _startActor, 20, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 7013 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13327996364735720960UL, 13684966302086062592UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, DatabaseConfiguration >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, Void >;
friend struct ActorCallback< _startActor, 3, Void >;
friend struct ActorCallback< _startActor, 4, UidAndAbortedFlagT >;
friend struct ActorCallback< _startActor, 5, Key >;
friend struct ActorCallback< _startActor, 6, Reference<IBackupContainer> >;
friend struct ActorCallback< _startActor, 7, Void >;
friend struct ActorCallback< _startActor, 8, BackupDescription >;
friend struct ActorCallback< _startActor, 9, Void >;
friend struct ActorCallback< _startActor, 10, Void >;
friend struct ActorCallback< _startActor, 11, Void >;
friend struct ActorCallback< _startActor, 12, int64_t >;
friend struct ActorCallback< _startActor, 13, Void >;
friend struct ActorCallback< _startActor, 14, Void >;
friend struct ActorCallback< _startActor, 15, RangeResult >;
friend struct ActorCallback< _startActor, 16, Optional<Value> >;
friend struct ActorCallback< _startActor, 17, RangeResult >;
friend struct ActorCallback< _startActor, 18, RangeResult >;
friend struct ActorCallback< _startActor, 19, Void >;
friend struct ActorCallback< _startActor, 20, Void >;
															#line 481 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	_startActor(Database const& cx,BackupAndRestorePartitionedCorrectnessWorkload* const& self) 
															#line 7050 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, DatabaseConfiguration >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _startActor, 4, UidAndAbortedFlagT >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _startActor, 5, Key >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< _startActor, 6, Reference<IBackupContainer> >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< _startActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< _startActor, 8, BackupDescription >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< _startActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< _startActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< _startActor, 11, Void >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< _startActor, 12, int64_t >*)0, actor_cancelled()); break;
		case 14: this->a_callback_error((ActorCallback< _startActor, 13, Void >*)0, actor_cancelled()); break;
		case 15: this->a_callback_error((ActorCallback< _startActor, 14, Void >*)0, actor_cancelled()); break;
		case 16: this->a_callback_error((ActorCallback< _startActor, 15, RangeResult >*)0, actor_cancelled()); break;
		case 17: this->a_callback_error((ActorCallback< _startActor, 16, Optional<Value> >*)0, actor_cancelled()); break;
		case 18: this->a_callback_error((ActorCallback< _startActor, 17, RangeResult >*)0, actor_cancelled()); break;
		case 19: this->a_callback_error((ActorCallback< _startActor, 18, RangeResult >*)0, actor_cancelled()); break;
		case 20: this->a_callback_error((ActorCallback< _startActor, 19, Void >*)0, actor_cancelled()); break;
		case 21: this->a_callback_error((ActorCallback< _startActor, 20, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 481 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
[[nodiscard]] static Future<Void> _start( Database const& cx, BackupAndRestorePartitionedCorrectnessWorkload* const& self ) {
															#line 481 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 7102 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectnessPartitioned.actor.g.cpp.py_gen"
}

#line 759 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectnessPartitioned.actor.cpp"
};

int BackupAndRestorePartitionedCorrectnessWorkload::backupAgentRequests = 0;

WorkloadFactory<BackupAndRestorePartitionedCorrectnessWorkload> BackupAndRestorePartitionedCorrectnessWorkloadFactory;
