#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
/*
 * PaxosConfigConsumer.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbserver/PaxosConfigConsumer.h"

#include <algorithm>
#include <map>
#include <numeric>

#include "fdbserver/Knobs.h"
#include "flow/actorcompiler.h" // This must be the last #include.

using ConfigFollowerInfo = ModelInterface<ConfigFollowerInterface>;

struct CommittedVersions {
	Version secondToLastCommitted;
	Version lastCommitted;
};

struct QuorumVersion {
	CommittedVersions versions;
	bool isQuorum;
};

class GetCommittedVersionQuorum {
	// Set to the <secondToLastCommitted, lastCommitted> versions a quorum of
	// ConfigNodes agree on, otherwise unset.
	Promise<QuorumVersion> quorumVersion;
	std::vector<Future<Void>> actors;
	std::vector<ConfigFollowerInterface> cfis;
	std::map<Version, std::vector<ConfigFollowerInterface>> replies;
	std::map<Version, Version> priorVersions;
	std::map<NetworkAddress, Version> committed;
	// Need to know the largest compacted version on any node to avoid asking
	// for changes that have already been compacted.
	Version largestCompactedResponse{ 0 };
	// Last durably committed version.
	Version lastSeenVersion;
	// Largest compacted version on the existing ConfigNodes.
	Version largestCompacted;
	size_t totalRepliesReceived{ 0 };
	size_t maxAgreement{ 0 };
	// Stores the largest live version out of all the responses.
	Version largestLive{ 0 };
	// Stores the largest committed version out of all responses.
	Version largestCommitted{ 0 };
	bool allowSpecialCaseRollforward_{ false };
	// True if a quorum has zero as their committed version. See explanation
	// comment below.
	bool specialZeroQuorum{ false };

	// Sends rollback/rollforward messages to any nodes that are not up to date
	// with the latest committed version as determined by the quorum. Should
	// only be called after a committed version has been determined.
																#line 74 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
// This generated class is to be used only via updateNode()
															#line 72 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
template <class UpdateNodeActor>
															#line 72 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
class UpdateNodeActorState {
															#line 80 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
public:
															#line 72 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
	UpdateNodeActorState(GetCommittedVersionQuorum* const& self,CommittedVersions const& nodeVersion,CommittedVersions const& quorumVersion,Version const& lastCompacted,ConfigFollowerInterface const& cfi) 
															#line 72 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
															#line 72 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		 : self(self),
															#line 72 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		   nodeVersion(nodeVersion),
															#line 72 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		   quorumVersion(quorumVersion),
															#line 72 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		   lastCompacted(lastCompacted),
															#line 72 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		   cfi(cfi),
															#line 77 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		   target(quorumVersion.lastCommitted)
															#line 97 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("updateNode", reinterpret_cast<unsigned long>(this));

	}
	~UpdateNodeActorState() 
	{
		fdb_probe_actor_destroy("updateNode", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 86 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			if (nodeVersion.lastCommitted == target)
															#line 112 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			{
															#line 87 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
				if (!static_cast<UpdateNodeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateNodeActorState(); static_cast<UpdateNodeActor*>(this)->destroy(); return 0; }
															#line 116 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
				new (&static_cast<UpdateNodeActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~UpdateNodeActorState();
				static_cast<UpdateNodeActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 90 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			if (nodeVersion.lastCommitted < target)
															#line 124 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			{
															#line 91 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
				rollback = Optional<Version>();
															#line 92 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
				if (nodeVersion.lastCommitted > quorumVersion.secondToLastCommitted)
															#line 130 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
				{
															#line 98 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
					rollback = quorumVersion.secondToLastCommitted;
															#line 134 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
				}
				else
				{
															#line 99 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
					if (nodeVersion.lastCommitted < quorumVersion.secondToLastCommitted)
															#line 140 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
					{
															#line 103 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
						rollback = std::max(nodeVersion.lastCommitted - 1, self->largestCompacted);
															#line 144 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
					}
				}
															#line 106 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
				if (rollback.present())
															#line 149 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
				{
															#line 114 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
					rollback = std::max(rollback.get(), lastCompacted);
															#line 153 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
				}
				try {
															#line 120 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
					interfs = self->replies[target];
															#line 121 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
					std::vector<Future<Void>> fs;
															#line 122 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
					for( ConfigFollowerInterface& interf : interfs ) {
															#line 123 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
						if (interf.hostname.present())
															#line 164 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
						{
															#line 124 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
							fs.push_back(tryInitializeRequestStream( &interf.getChanges, interf.hostname.get(), WLTOKEN_CONFIGFOLLOWER_GETCHANGES));
															#line 168 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
						}
					}
															#line 128 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
					StrictFuture<Void> __when_expr_0 = waitForAll(fs);
															#line 128 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
					if (static_cast<UpdateNodeActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 175 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<UpdateNodeActor*>(this)->actor_wait_state = 1;
															#line 128 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateNodeActor, 0, Void >*>(static_cast<UpdateNodeActor*>(this)));
															#line 180 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				catch (Error& error) {
					loopDepth = a_body1Catch2(error, loopDepth);
				} catch (...) {
					loopDepth = a_body1Catch2(unknown_error(), loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateNodeActorState();
		static_cast<UpdateNodeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 181 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		if (!static_cast<UpdateNodeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateNodeActorState(); static_cast<UpdateNodeActor*>(this)->destroy(); return 0; }
															#line 214 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		new (&static_cast<UpdateNodeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateNodeActorState();
		static_cast<UpdateNodeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 169 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			if (e.code() == error_code_transaction_too_old)
															#line 233 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			{
															#line 175 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
				TraceEvent(SevInfo, "ConsumerConfigNodeRollforwardError").error(e);
															#line 237 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			}
			else
			{
															#line 177 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 243 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
															#line 129 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		quorumCfi = Reference<ConfigFollowerInfo>(new ConfigFollowerInfo(interfs));
															#line 130 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		lastSeenVersion = std::max( rollback.present() ? rollback.get() : nodeVersion.lastCommitted, self->largestCompactedResponse);
															#line 132 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		StrictFuture<ConfigFollowerGetChangesReply> __when_expr_1 = timeoutError(basicLoadBalance(quorumCfi, &ConfigFollowerInterface::getChanges, ConfigFollowerGetChangesRequest{ lastSeenVersion, target }), SERVER_KNOBS->GET_COMMITTED_VERSION_TIMEOUT);
															#line 132 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		if (static_cast<UpdateNodeActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 265 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont8when1(__when_expr_1.get(), loopDepth); };
		static_cast<UpdateNodeActor*>(this)->actor_wait_state = 2;
															#line 132 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdateNodeActor, 1, ConfigFollowerGetChangesReply >*>(static_cast<UpdateNodeActor*>(this)));
															#line 270 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
															#line 129 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		quorumCfi = Reference<ConfigFollowerInfo>(new ConfigFollowerInfo(interfs));
															#line 130 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		lastSeenVersion = std::max( rollback.present() ? rollback.get() : nodeVersion.lastCommitted, self->largestCompactedResponse);
															#line 132 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		StrictFuture<ConfigFollowerGetChangesReply> __when_expr_1 = timeoutError(basicLoadBalance(quorumCfi, &ConfigFollowerInterface::getChanges, ConfigFollowerGetChangesRequest{ lastSeenVersion, target }), SERVER_KNOBS->GET_COMMITTED_VERSION_TIMEOUT);
															#line 132 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		if (static_cast<UpdateNodeActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 285 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont8when1(__when_expr_1.get(), loopDepth); };
		static_cast<UpdateNodeActor*>(this)->actor_wait_state = 2;
															#line 132 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdateNodeActor, 1, ConfigFollowerGetChangesReply >*>(static_cast<UpdateNodeActor*>(this)));
															#line 290 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateNodeActor*>(this)->actor_wait_state > 0) static_cast<UpdateNodeActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateNodeActor*>(this)->ActorCallback< UpdateNodeActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateNodeActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateNode", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateNodeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateNode", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateNodeActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateNode", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateNodeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateNode", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateNodeActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateNode", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateNodeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateNode", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont11(ConfigFollowerGetChangesReply const& reply,int loopDepth) 
	{
															#line 147 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		if (cfi.hostname.present())
															#line 374 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		{
															#line 148 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			StrictFuture<Void> __when_expr_2 = timeoutError( retryGetReplyFromHostname(ConfigFollowerRollforwardRequest{ rollback, nodeVersion.lastCommitted, target, reply.changes, reply.annotations, self->specialZeroQuorum }, cfi.hostname.get(), WLTOKEN_CONFIGFOLLOWER_ROLLFORWARD), SERVER_KNOBS->GET_COMMITTED_VERSION_TIMEOUT);
															#line 148 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			if (static_cast<UpdateNodeActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 380 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont11when1(__when_expr_2.get(), loopDepth); };
			static_cast<UpdateNodeActor*>(this)->actor_wait_state = 3;
															#line 148 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< UpdateNodeActor, 2, Void >*>(static_cast<UpdateNodeActor*>(this)));
															#line 385 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 159 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			StrictFuture<Void> __when_expr_3 = timeoutError( cfi.rollforward.getReply(ConfigFollowerRollforwardRequest{ rollback, nodeVersion.lastCommitted, target, reply.changes, reply.annotations, self->specialZeroQuorum }), SERVER_KNOBS->GET_COMMITTED_VERSION_TIMEOUT);
															#line 159 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			if (static_cast<UpdateNodeActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 394 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch2(__when_expr_3.getError(), loopDepth); else return a_body1cont11when2(__when_expr_3.get(), loopDepth); };
			static_cast<UpdateNodeActor*>(this)->actor_wait_state = 4;
															#line 159 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< UpdateNodeActor, 3, Void >*>(static_cast<UpdateNodeActor*>(this)));
															#line 399 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont11(ConfigFollowerGetChangesReply && reply,int loopDepth) 
	{
															#line 147 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		if (cfi.hostname.present())
															#line 409 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		{
															#line 148 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			StrictFuture<Void> __when_expr_2 = timeoutError( retryGetReplyFromHostname(ConfigFollowerRollforwardRequest{ rollback, nodeVersion.lastCommitted, target, reply.changes, reply.annotations, self->specialZeroQuorum }, cfi.hostname.get(), WLTOKEN_CONFIGFOLLOWER_ROLLFORWARD), SERVER_KNOBS->GET_COMMITTED_VERSION_TIMEOUT);
															#line 148 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			if (static_cast<UpdateNodeActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 415 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont11when1(__when_expr_2.get(), loopDepth); };
			static_cast<UpdateNodeActor*>(this)->actor_wait_state = 3;
															#line 148 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< UpdateNodeActor, 2, Void >*>(static_cast<UpdateNodeActor*>(this)));
															#line 420 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 159 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			StrictFuture<Void> __when_expr_3 = timeoutError( cfi.rollforward.getReply(ConfigFollowerRollforwardRequest{ rollback, nodeVersion.lastCommitted, target, reply.changes, reply.annotations, self->specialZeroQuorum }), SERVER_KNOBS->GET_COMMITTED_VERSION_TIMEOUT);
															#line 159 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			if (static_cast<UpdateNodeActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 429 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch2(__when_expr_3.getError(), loopDepth); else return a_body1cont11when2(__when_expr_3.get(), loopDepth); };
			static_cast<UpdateNodeActor*>(this)->actor_wait_state = 4;
															#line 159 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< UpdateNodeActor, 3, Void >*>(static_cast<UpdateNodeActor*>(this)));
															#line 434 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont8when1(ConfigFollowerGetChangesReply const& reply,int loopDepth) 
	{
		loopDepth = a_body1cont11(reply, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(ConfigFollowerGetChangesReply && reply,int loopDepth) 
	{
		loopDepth = a_body1cont11(std::move(reply), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UpdateNodeActor*>(this)->actor_wait_state > 0) static_cast<UpdateNodeActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateNodeActor*>(this)->ActorCallback< UpdateNodeActor, 1, ConfigFollowerGetChangesReply >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateNodeActor, 1, ConfigFollowerGetChangesReply >*,ConfigFollowerGetChangesReply const& value) 
	{
		fdb_probe_actor_enter("updateNode", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateNodeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateNode", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UpdateNodeActor, 1, ConfigFollowerGetChangesReply >*,ConfigFollowerGetChangesReply && value) 
	{
		fdb_probe_actor_enter("updateNode", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateNodeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateNode", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UpdateNodeActor, 1, ConfigFollowerGetChangesReply >*,Error err) 
	{
		fdb_probe_actor_enter("updateNode", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateNodeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateNode", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont11cont1(int loopDepth) 
	{
		loopDepth = a_body1cont11cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<UpdateNodeActor*>(this)->actor_wait_state > 0) static_cast<UpdateNodeActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateNodeActor*>(this)->ActorCallback< UpdateNodeActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateNodeActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateNode", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateNodeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateNode", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< UpdateNodeActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateNode", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateNodeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateNode", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< UpdateNodeActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateNode", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateNodeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateNode", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont11cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<UpdateNodeActor*>(this)->actor_wait_state > 0) static_cast<UpdateNodeActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateNodeActor*>(this)->ActorCallback< UpdateNodeActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateNodeActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateNode", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateNodeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont11when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateNode", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< UpdateNodeActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateNode", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateNodeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont11when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateNode", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< UpdateNodeActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateNode", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateNodeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateNode", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont11cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 72 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
	GetCommittedVersionQuorum* self;
															#line 72 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
	CommittedVersions nodeVersion;
															#line 72 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
	CommittedVersions quorumVersion;
															#line 72 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
	Version lastCompacted;
															#line 72 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
	ConfigFollowerInterface cfi;
															#line 77 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
	Version target;
															#line 91 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
	Optional<Version> rollback;
															#line 120 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
	std::vector<ConfigFollowerInterface> interfs;
															#line 129 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
	Reference<ConfigFollowerInfo> quorumCfi;
															#line 130 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
	Version lastSeenVersion;
															#line 728 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via updateNode()
															#line 72 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
class UpdateNodeActor final : public Actor<Void>, public ActorCallback< UpdateNodeActor, 0, Void >, public ActorCallback< UpdateNodeActor, 1, ConfigFollowerGetChangesReply >, public ActorCallback< UpdateNodeActor, 2, Void >, public ActorCallback< UpdateNodeActor, 3, Void >, public FastAllocated<UpdateNodeActor>, public UpdateNodeActorState<UpdateNodeActor> {
															#line 733 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
public:
	using FastAllocated<UpdateNodeActor>::operator new;
	using FastAllocated<UpdateNodeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8844237263290333952UL, 7451429251781225472UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateNodeActor, 0, Void >;
friend struct ActorCallback< UpdateNodeActor, 1, ConfigFollowerGetChangesReply >;
friend struct ActorCallback< UpdateNodeActor, 2, Void >;
friend struct ActorCallback< UpdateNodeActor, 3, Void >;
															#line 72 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
	UpdateNodeActor(GetCommittedVersionQuorum* const& self,CommittedVersions const& nodeVersion,CommittedVersions const& quorumVersion,Version const& lastCompacted,ConfigFollowerInterface const& cfi) 
															#line 753 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   UpdateNodeActorState<UpdateNodeActor>(self, nodeVersion, quorumVersion, lastCompacted, cfi),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateNode", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5946121856321633792UL, 10926998606258611712UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateNodeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateNode");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateNode", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateNodeActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UpdateNodeActor, 1, ConfigFollowerGetChangesReply >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< UpdateNodeActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< UpdateNodeActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 72 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
[[nodiscard]] static Future<Void> updateNode( GetCommittedVersionQuorum* const& self, CommittedVersions const& nodeVersion, CommittedVersions const& quorumVersion, Version const& lastCompacted, ConfigFollowerInterface const& cfi ) {
															#line 72 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
	return Future<Void>(new UpdateNodeActor(self, nodeVersion, quorumVersion, lastCompacted, cfi));
															#line 788 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
}

#line 183 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"

																#line 793 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
// This generated class is to be used only via getCommittedVersionActor()
															#line 184 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
template <class GetCommittedVersionActorActor>
															#line 184 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
class GetCommittedVersionActorActorState {
															#line 799 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
public:
															#line 184 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
	GetCommittedVersionActorActorState(GetCommittedVersionQuorum* const& self,ConfigFollowerInterface const& cfi) 
															#line 184 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
															#line 184 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		 : self(self),
															#line 184 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		   cfi(cfi)
															#line 808 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getCommittedVersionActor", reinterpret_cast<unsigned long>(this));

	}
	~GetCommittedVersionActorActorState() 
	{
		fdb_probe_actor_destroy("getCommittedVersionActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 186 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
				reply = ConfigFollowerGetCommittedVersionReply();
															#line 187 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
				if (cfi.hostname.present())
															#line 826 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
				{
															#line 188 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
					StrictFuture<Void> __when_expr_0 = timeoutError(store(reply, retryGetReplyFromHostname(ConfigFollowerGetCommittedVersionRequest{}, cfi.hostname.get(), WLTOKEN_CONFIGFOLLOWER_GETCOMMITTEDVERSION)), SERVER_KNOBS->GET_COMMITTED_VERSION_TIMEOUT);
															#line 188 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
					if (static_cast<GetCommittedVersionActorActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 832 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<GetCommittedVersionActorActor*>(this)->actor_wait_state = 1;
															#line 188 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetCommittedVersionActorActor, 0, Void >*>(static_cast<GetCommittedVersionActorActor*>(this)));
															#line 837 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				else
				{
															#line 194 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
					StrictFuture<Void> __when_expr_1 = timeoutError( store(reply, cfi.getCommittedVersion.getReply(ConfigFollowerGetCommittedVersionRequest{})), SERVER_KNOBS->GET_COMMITTED_VERSION_TIMEOUT);
															#line 194 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
					if (static_cast<GetCommittedVersionActorActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 846 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
					static_cast<GetCommittedVersionActorActor*>(this)->actor_wait_state = 2;
															#line 194 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetCommittedVersionActorActor, 1, Void >*>(static_cast<GetCommittedVersionActorActor*>(this)));
															#line 851 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetCommittedVersionActorActorState();
		static_cast<GetCommittedVersionActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 365 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		if (!static_cast<GetCommittedVersionActorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetCommittedVersionActorActorState(); static_cast<GetCommittedVersionActorActor*>(this)->destroy(); return 0; }
															#line 881 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		new (&static_cast<GetCommittedVersionActorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetCommittedVersionActorActorState();
		static_cast<GetCommittedVersionActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 310 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			if (e.code() == error_code_operation_cancelled)
															#line 894 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			{
															#line 311 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 898 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			}
															#line 314 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			++self->totalRepliesReceived;
															#line 319 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			if (e.code() == error_code_version_already_compacted)
															#line 904 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			{
															#line 320 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
				if (self->quorumVersion.canBeSet())
															#line 908 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
				{
															#line 322 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
					auto local = self->quorumVersion;
															#line 323 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
					local.sendError(e);
															#line 914 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
				}
				loopDepth = a_body1Catch2cont1(loopDepth);
			}
			else
			{
															#line 325 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
				if (e.code() != error_code_timed_out && e.code() != error_code_future_version && e.code() != error_code_broken_promise)
															#line 922 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
				{
															#line 327 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
					if (self->quorumVersion.canBeSet())
															#line 926 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
					{
															#line 329 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
						auto local = self->quorumVersion;
															#line 330 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
						local.sendError(e);
															#line 932 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
					}
					loopDepth = a_body1Catch2cont5(loopDepth);
				}
				else
				{
															#line 332 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
					if (self->totalRepliesReceived == self->cfis.size() && self->quorumVersion.canBeSet() && !self->quorumVersion.isError())
															#line 940 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
					{
															#line 334 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
						size_t nonTimeoutReplies = std::accumulate(self->replies.begin(), self->replies.end(), 0, [](int value, auto const& p) { return value + p.second.size(); });
															#line 339 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
						if (nonTimeoutReplies >= self->cfis.size() / 2 + 1)
															#line 946 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
						{
															#line 345 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
							self->quorumVersion.send( QuorumVersion{ CommittedVersions{ self->lastSeenVersion, self->largestCommitted }, false });
															#line 348 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
							if (e.code() == error_code_future_version)
															#line 952 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
							{
															#line 349 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
								StrictFuture<Void> __when_expr_8 = self->updateNode(self, CommittedVersions{ self->lastSeenVersion, self->largestCommitted }, self->quorumVersion.getFuture().get().versions, self->largestCompactedResponse, cfi);
															#line 349 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
								if (static_cast<GetCommittedVersionActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 958 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
								if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1Catch2when1(__when_expr_8.get(), loopDepth); };
								static_cast<GetCommittedVersionActorActor*>(this)->actor_wait_state = 9;
															#line 349 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
								__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< GetCommittedVersionActorActor, 8, Void >*>(static_cast<GetCommittedVersionActorActor*>(this)));
															#line 963 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
								loopDepth = 0;
							}
							else
							{
								loopDepth = a_body1Catch2cont10(loopDepth);
							}
						}
						else
						{
															#line 355 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
							if (!self->quorumVersion.isSet())
															#line 975 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
							{
															#line 360 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
								auto local = self->quorumVersion;
															#line 361 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
								local.sendError(e);
															#line 981 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
							}
							loopDepth = a_body1Catch2cont9(loopDepth);
						}
					}
					else
					{
						loopDepth = a_body1Catch2cont8(loopDepth);
					}
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 199 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		if (!reply.registered)
															#line 1005 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		{
															#line 204 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			return a_body1Catch2(future_version(), loopDepth);
															#line 1009 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		}
															#line 207 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		++self->totalRepliesReceived;
															#line 208 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		self->largestCompactedResponse = std::max(self->largestCompactedResponse, reply.lastCompacted);
															#line 209 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		lastCompacted = reply.lastCompacted;
															#line 210 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		self->committed[cfi.address()] = reply.lastCommitted;
															#line 211 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		self->largestLive = std::max(self->largestLive, reply.lastLive);
															#line 212 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		self->largestCommitted = std::max(self->largestCommitted, reply.lastCommitted);
															#line 213 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		committedVersions = CommittedVersions{ self->lastSeenVersion, reply.lastCommitted };
															#line 214 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		if (self->priorVersions.find(committedVersions.lastCommitted) == self->priorVersions.end())
															#line 1027 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		{
															#line 215 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			self->priorVersions[committedVersions.lastCommitted] = self->lastSeenVersion;
															#line 1031 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		}
															#line 217 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		auto& nodes = self->replies[committedVersions.lastCommitted];
															#line 218 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		nodes.push_back(cfi);
															#line 219 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		self->maxAgreement = std::max(nodes.size(), self->maxAgreement);
															#line 229 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		if (nodes.size() >= self->cfis.size() / 2 + 1)
															#line 1041 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		{
															#line 267 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			if (self->allowSpecialCaseRollforward_ && committedVersions.lastCommitted == 0 && self->largestCommitted > 0)
															#line 1045 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			{
															#line 269 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
				self->specialZeroQuorum = true;
															#line 270 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
				committedVersions = CommittedVersions{ 0, self->largestCommitted };
															#line 1051 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			}
															#line 274 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			if (self->quorumVersion.canBeSet())
															#line 1055 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			{
															#line 275 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
				self->quorumVersion.send(QuorumVersion{ committedVersions, true });
															#line 1059 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			}
															#line 277 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			StrictFuture<Void> __when_expr_2 = self->updateNode( self, committedVersions, self->quorumVersion.getFuture().get().versions, lastCompacted, cfi);
															#line 277 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			if (static_cast<GetCommittedVersionActorActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1065 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<GetCommittedVersionActorActor*>(this)->actor_wait_state = 3;
															#line 277 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetCommittedVersionActorActor, 2, Void >*>(static_cast<GetCommittedVersionActorActor*>(this)));
															#line 1070 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 279 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			if (self->maxAgreement >= self->cfis.size() / 2 + 1)
															#line 1077 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			{
															#line 283 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
				StrictFuture<QuorumVersion> __when_expr_3 = self->quorumVersion.getFuture();
															#line 283 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
				if (static_cast<GetCommittedVersionActorActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1083 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch2(__when_expr_3.getError(), loopDepth); else return a_body1cont2when2(__when_expr_3.get(), loopDepth); };
				static_cast<GetCommittedVersionActorActor*>(this)->actor_wait_state = 4;
															#line 283 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetCommittedVersionActorActor, 3, QuorumVersion >*>(static_cast<GetCommittedVersionActorActor*>(this)));
															#line 1088 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 287 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
				if (self->maxAgreement + (self->cfis.size() - self->totalRepliesReceived) < (self->cfis.size() / 2 + 1))
															#line 1095 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
				{
															#line 295 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
					Version largestCommitted = self->replies.rbegin()->first;
															#line 296 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
					Version largestCommittedPrior = self->priorVersions[largestCommitted];
															#line 297 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
					if (self->quorumVersion.canBeSet())
															#line 1103 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
					{
															#line 298 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
						self->quorumVersion.send( QuorumVersion{ CommittedVersions{ largestCommittedPrior, largestCommitted }, false });
															#line 1107 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
					}
															#line 301 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
					StrictFuture<Void> __when_expr_5 = self->updateNode( self, committedVersions, self->quorumVersion.getFuture().get().versions, lastCompacted, cfi);
															#line 301 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
					if (static_cast<GetCommittedVersionActorActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1113 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
					if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch2(__when_expr_5.getError(), loopDepth); else return a_body1cont2when3(__when_expr_5.get(), loopDepth); };
					static_cast<GetCommittedVersionActorActor*>(this)->actor_wait_state = 6;
															#line 301 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
					__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< GetCommittedVersionActorActor, 5, Void >*>(static_cast<GetCommittedVersionActorActor*>(this)));
															#line 1118 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				else
				{
															#line 306 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
					StrictFuture<QuorumVersion> __when_expr_6 = self->quorumVersion.getFuture();
															#line 306 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
					if (static_cast<GetCommittedVersionActorActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1127 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
					if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch2(__when_expr_6.getError(), loopDepth); else return a_body1cont2when4(__when_expr_6.get(), loopDepth); };
					static_cast<GetCommittedVersionActorActor*>(this)->actor_wait_state = 7;
															#line 306 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
					__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< GetCommittedVersionActorActor, 6, QuorumVersion >*>(static_cast<GetCommittedVersionActorActor*>(this)));
															#line 1132 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
			}
		}

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetCommittedVersionActorActor*>(this)->actor_wait_state > 0) static_cast<GetCommittedVersionActorActor*>(this)->actor_wait_state = 0;
		static_cast<GetCommittedVersionActorActor*>(this)->ActorCallback< GetCommittedVersionActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetCommittedVersionActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getCommittedVersionActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommittedVersionActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommittedVersionActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetCommittedVersionActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getCommittedVersionActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommittedVersionActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommittedVersionActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetCommittedVersionActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getCommittedVersionActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommittedVersionActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommittedVersionActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetCommittedVersionActorActor*>(this)->actor_wait_state > 0) static_cast<GetCommittedVersionActorActor*>(this)->actor_wait_state = 0;
		static_cast<GetCommittedVersionActorActor*>(this)->ActorCallback< GetCommittedVersionActorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetCommittedVersionActorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getCommittedVersionActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommittedVersionActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommittedVersionActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetCommittedVersionActorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getCommittedVersionActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommittedVersionActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommittedVersionActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetCommittedVersionActorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getCommittedVersionActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommittedVersionActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommittedVersionActor", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
		loopDepth = a_body1cont17(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetCommittedVersionActorActor*>(this)->actor_wait_state > 0) static_cast<GetCommittedVersionActorActor*>(this)->actor_wait_state = 0;
		static_cast<GetCommittedVersionActorActor*>(this)->ActorCallback< GetCommittedVersionActorActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetCommittedVersionActorActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getCommittedVersionActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommittedVersionActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommittedVersionActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetCommittedVersionActorActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getCommittedVersionActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommittedVersionActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommittedVersionActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetCommittedVersionActorActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getCommittedVersionActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommittedVersionActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommittedVersionActor", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont11(int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont12(QuorumVersion const& quorumVersion,int loopDepth) 
	{
															#line 284 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		ASSERT(committedVersions.lastCommitted != quorumVersion.versions.lastCommitted || self->specialZeroQuorum);
															#line 286 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		StrictFuture<Void> __when_expr_4 = self->updateNode(self, committedVersions, quorumVersion.versions, lastCompacted, cfi);
															#line 286 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		if (static_cast<GetCommittedVersionActorActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1421 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch2(__when_expr_4.getError(), loopDepth); else return a_body1cont12when1(__when_expr_4.get(), loopDepth); };
		static_cast<GetCommittedVersionActorActor*>(this)->actor_wait_state = 5;
															#line 286 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< GetCommittedVersionActorActor, 4, Void >*>(static_cast<GetCommittedVersionActorActor*>(this)));
															#line 1426 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12(QuorumVersion && quorumVersion,int loopDepth) 
	{
															#line 284 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		ASSERT(committedVersions.lastCommitted != quorumVersion.versions.lastCommitted || self->specialZeroQuorum);
															#line 286 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		StrictFuture<Void> __when_expr_4 = self->updateNode(self, committedVersions, quorumVersion.versions, lastCompacted, cfi);
															#line 286 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		if (static_cast<GetCommittedVersionActorActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1439 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch2(__when_expr_4.getError(), loopDepth); else return a_body1cont12when1(__when_expr_4.get(), loopDepth); };
		static_cast<GetCommittedVersionActorActor*>(this)->actor_wait_state = 5;
															#line 286 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< GetCommittedVersionActorActor, 4, Void >*>(static_cast<GetCommittedVersionActorActor*>(this)));
															#line 1444 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when2(QuorumVersion const& quorumVersion,int loopDepth) 
	{
		loopDepth = a_body1cont12(quorumVersion, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when2(QuorumVersion && quorumVersion,int loopDepth) 
	{
		loopDepth = a_body1cont12(std::move(quorumVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<GetCommittedVersionActorActor*>(this)->actor_wait_state > 0) static_cast<GetCommittedVersionActorActor*>(this)->actor_wait_state = 0;
		static_cast<GetCommittedVersionActorActor*>(this)->ActorCallback< GetCommittedVersionActorActor, 3, QuorumVersion >::remove();

	}
	void a_callback_fire(ActorCallback< GetCommittedVersionActorActor, 3, QuorumVersion >*,QuorumVersion const& value) 
	{
		fdb_probe_actor_enter("getCommittedVersionActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommittedVersionActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommittedVersionActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetCommittedVersionActorActor, 3, QuorumVersion >*,QuorumVersion && value) 
	{
		fdb_probe_actor_enter("getCommittedVersionActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommittedVersionActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommittedVersionActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetCommittedVersionActorActor, 3, QuorumVersion >*,Error err) 
	{
		fdb_probe_actor_enter("getCommittedVersionActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommittedVersionActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommittedVersionActor", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont12cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont12when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<GetCommittedVersionActorActor*>(this)->actor_wait_state > 0) static_cast<GetCommittedVersionActorActor*>(this)->actor_wait_state = 0;
		static_cast<GetCommittedVersionActorActor*>(this)->ActorCallback< GetCommittedVersionActorActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetCommittedVersionActorActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getCommittedVersionActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommittedVersionActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont12when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommittedVersionActor", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< GetCommittedVersionActorActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getCommittedVersionActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommittedVersionActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont12when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommittedVersionActor", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< GetCommittedVersionActorActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getCommittedVersionActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommittedVersionActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommittedVersionActor", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont13(int loopDepth) 
	{
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont14(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont13(loopDepth);

		return loopDepth;
	}
	int a_body1cont14(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont13(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<GetCommittedVersionActorActor*>(this)->actor_wait_state > 0) static_cast<GetCommittedVersionActorActor*>(this)->actor_wait_state = 0;
		static_cast<GetCommittedVersionActorActor*>(this)->ActorCallback< GetCommittedVersionActorActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetCommittedVersionActorActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getCommittedVersionActor", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommittedVersionActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont2when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommittedVersionActor", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< GetCommittedVersionActorActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getCommittedVersionActor", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommittedVersionActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont2when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommittedVersionActor", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< GetCommittedVersionActorActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getCommittedVersionActor", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommittedVersionActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommittedVersionActor", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont16(QuorumVersion const& quorumVersion,int loopDepth) 
	{
															#line 307 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		StrictFuture<Void> __when_expr_7 = self->updateNode(self, committedVersions, quorumVersion.versions, lastCompacted, cfi);
															#line 307 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		if (static_cast<GetCommittedVersionActorActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1710 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch2(__when_expr_7.getError(), loopDepth); else return a_body1cont16when1(__when_expr_7.get(), loopDepth); };
		static_cast<GetCommittedVersionActorActor*>(this)->actor_wait_state = 8;
															#line 307 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< GetCommittedVersionActorActor, 7, Void >*>(static_cast<GetCommittedVersionActorActor*>(this)));
															#line 1715 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont16(QuorumVersion && quorumVersion,int loopDepth) 
	{
															#line 307 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		StrictFuture<Void> __when_expr_7 = self->updateNode(self, committedVersions, quorumVersion.versions, lastCompacted, cfi);
															#line 307 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		if (static_cast<GetCommittedVersionActorActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1726 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch2(__when_expr_7.getError(), loopDepth); else return a_body1cont16when1(__when_expr_7.get(), loopDepth); };
		static_cast<GetCommittedVersionActorActor*>(this)->actor_wait_state = 8;
															#line 307 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< GetCommittedVersionActorActor, 7, Void >*>(static_cast<GetCommittedVersionActorActor*>(this)));
															#line 1731 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when4(QuorumVersion const& quorumVersion,int loopDepth) 
	{
		loopDepth = a_body1cont16(quorumVersion, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when4(QuorumVersion && quorumVersion,int loopDepth) 
	{
		loopDepth = a_body1cont16(std::move(quorumVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<GetCommittedVersionActorActor*>(this)->actor_wait_state > 0) static_cast<GetCommittedVersionActorActor*>(this)->actor_wait_state = 0;
		static_cast<GetCommittedVersionActorActor*>(this)->ActorCallback< GetCommittedVersionActorActor, 6, QuorumVersion >::remove();

	}
	void a_callback_fire(ActorCallback< GetCommittedVersionActorActor, 6, QuorumVersion >*,QuorumVersion const& value) 
	{
		fdb_probe_actor_enter("getCommittedVersionActor", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommittedVersionActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont2when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommittedVersionActor", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< GetCommittedVersionActorActor, 6, QuorumVersion >*,QuorumVersion && value) 
	{
		fdb_probe_actor_enter("getCommittedVersionActor", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommittedVersionActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont2when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommittedVersionActor", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< GetCommittedVersionActorActor, 6, QuorumVersion >*,Error err) 
	{
		fdb_probe_actor_enter("getCommittedVersionActor", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommittedVersionActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommittedVersionActor", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont16cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont13(loopDepth);

		return loopDepth;
	}
	int a_body1cont16cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont13(loopDepth);

		return loopDepth;
	}
	int a_body1cont16when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont16cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont16when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont16cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<GetCommittedVersionActorActor*>(this)->actor_wait_state > 0) static_cast<GetCommittedVersionActorActor*>(this)->actor_wait_state = 0;
		static_cast<GetCommittedVersionActorActor*>(this)->ActorCallback< GetCommittedVersionActorActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetCommittedVersionActorActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getCommittedVersionActor", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommittedVersionActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont16when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommittedVersionActor", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< GetCommittedVersionActorActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getCommittedVersionActor", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommittedVersionActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont16when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommittedVersionActor", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< GetCommittedVersionActorActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getCommittedVersionActor", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommittedVersionActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommittedVersionActor", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont17(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch2cont1(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2cont5(int loopDepth) 
	{
		loopDepth = a_body1Catch2cont1(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2cont8(int loopDepth) 
	{
		loopDepth = a_body1Catch2cont5(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2cont9(int loopDepth) 
	{
		loopDepth = a_body1Catch2cont8(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2cont10(int loopDepth) 
	{
		loopDepth = a_body1Catch2cont9(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2cont11(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont10(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2cont11(Void && _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont10(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<GetCommittedVersionActorActor*>(this)->actor_wait_state > 0) static_cast<GetCommittedVersionActorActor*>(this)->actor_wait_state = 0;
		static_cast<GetCommittedVersionActorActor*>(this)->ActorCallback< GetCommittedVersionActorActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetCommittedVersionActorActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getCommittedVersionActor", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommittedVersionActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommittedVersionActor", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< GetCommittedVersionActorActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getCommittedVersionActor", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommittedVersionActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommittedVersionActor", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< GetCommittedVersionActorActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getCommittedVersionActor", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommittedVersionActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommittedVersionActor", reinterpret_cast<unsigned long>(this), 8);

	}
															#line 184 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
	GetCommittedVersionQuorum* self;
															#line 184 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
	ConfigFollowerInterface cfi;
															#line 186 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
	ConfigFollowerGetCommittedVersionReply reply;
															#line 209 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
	Version lastCompacted;
															#line 213 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
	CommittedVersions committedVersions;
															#line 2038 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getCommittedVersionActor()
															#line 184 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
class GetCommittedVersionActorActor final : public Actor<Void>, public ActorCallback< GetCommittedVersionActorActor, 0, Void >, public ActorCallback< GetCommittedVersionActorActor, 1, Void >, public ActorCallback< GetCommittedVersionActorActor, 2, Void >, public ActorCallback< GetCommittedVersionActorActor, 3, QuorumVersion >, public ActorCallback< GetCommittedVersionActorActor, 4, Void >, public ActorCallback< GetCommittedVersionActorActor, 5, Void >, public ActorCallback< GetCommittedVersionActorActor, 6, QuorumVersion >, public ActorCallback< GetCommittedVersionActorActor, 7, Void >, public ActorCallback< GetCommittedVersionActorActor, 8, Void >, public FastAllocated<GetCommittedVersionActorActor>, public GetCommittedVersionActorActorState<GetCommittedVersionActorActor> {
															#line 2043 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetCommittedVersionActorActor>::operator new;
	using FastAllocated<GetCommittedVersionActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10101744869381619712UL, 5070487707118298880UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetCommittedVersionActorActor, 0, Void >;
friend struct ActorCallback< GetCommittedVersionActorActor, 1, Void >;
friend struct ActorCallback< GetCommittedVersionActorActor, 2, Void >;
friend struct ActorCallback< GetCommittedVersionActorActor, 3, QuorumVersion >;
friend struct ActorCallback< GetCommittedVersionActorActor, 4, Void >;
friend struct ActorCallback< GetCommittedVersionActorActor, 5, Void >;
friend struct ActorCallback< GetCommittedVersionActorActor, 6, QuorumVersion >;
friend struct ActorCallback< GetCommittedVersionActorActor, 7, Void >;
friend struct ActorCallback< GetCommittedVersionActorActor, 8, Void >;
															#line 184 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
	GetCommittedVersionActorActor(GetCommittedVersionQuorum* const& self,ConfigFollowerInterface const& cfi) 
															#line 2068 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   GetCommittedVersionActorActorState<GetCommittedVersionActorActor>(self, cfi),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getCommittedVersionActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8554255230800004352UL, 16898735717465481728UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommittedVersionActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getCommittedVersionActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getCommittedVersionActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetCommittedVersionActorActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetCommittedVersionActorActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetCommittedVersionActorActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< GetCommittedVersionActorActor, 3, QuorumVersion >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< GetCommittedVersionActorActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< GetCommittedVersionActorActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< GetCommittedVersionActorActor, 6, QuorumVersion >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< GetCommittedVersionActorActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< GetCommittedVersionActorActor, 8, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 184 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
[[nodiscard]] static Future<Void> getCommittedVersionActor( GetCommittedVersionQuorum* const& self, ConfigFollowerInterface const& cfi ) {
															#line 184 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
	return Future<Void>(new GetCommittedVersionActorActor(self, cfi));
															#line 2108 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
}

#line 367 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"

public:
	explicit GetCommittedVersionQuorum(std::vector<ConfigFollowerInterface> const& cfis,
	                                   Version lastSeenVersion,
	                                   Version largestCompacted)
	  : cfis(cfis), lastSeenVersion(lastSeenVersion), largestCompacted(largestCompacted) {}
	Future<QuorumVersion> getCommittedVersion() {
		ASSERT(!isReady()); // ensures this function is not accidentally called before resetting state
		for (const auto& cfi : cfis) {
			actors.push_back(getCommittedVersionActor(this, cfi));
		}
		return quorumVersion.getFuture();
	}
	bool isReady() const {
		return quorumVersion.getFuture().isValid() && quorumVersion.getFuture().isReady() &&
		       !quorumVersion.getFuture().isError();
	}
	std::vector<ConfigFollowerInterface> getReadReplicas() const {
		if (quorumVersion.getFuture().isError()) {
			throw quorumVersion.getFuture().getError();
		}
		ASSERT(isReady());
		return replies.at(quorumVersion.getFuture().get().versions.lastCommitted);
	}
	Version getLargestLive() const { return largestLive; }
	Version getSmallestCommitted() const {
		if (committed.size() == cfis.size()) {
			Version smallest = MAX_VERSION;
			for (const auto& [key, value] : committed) {
				smallest = std::min(smallest, value);
			}
			return smallest;
		}
		return ::invalidVersion;
	}
	void allowSpecialCaseRollforward() { allowSpecialCaseRollforward_ = true; }
	bool isSpecialZeroQuorum() const { return specialZeroQuorum; }
	Future<Void> complete() const { return waitForAll(actors); }
};

class PaxosConfigConsumerImpl {
	std::vector<ConfigFollowerInterface> cfis;
	GetCommittedVersionQuorum getCommittedVersionQuorum;
	Version lastSeenVersion{ 0 };
	Version compactionVersion{ 0 };
	double pollingInterval;
	Optional<double> compactionInterval;
	bool allowSpecialCaseRollforward_{ false };
	bool readPreviousCoordinators{ false };
	UID id;

																#line 2163 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
// This generated class is to be used only via getCommittedVersion()
															#line 418 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
template <class GetCommittedVersionActor>
															#line 418 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
class GetCommittedVersionActorState {
															#line 2169 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
public:
															#line 418 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
	GetCommittedVersionActorState(PaxosConfigConsumerImpl* const& self) 
															#line 418 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
															#line 418 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		 : self(self)
															#line 2176 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getCommittedVersion", reinterpret_cast<unsigned long>(this));

	}
	~GetCommittedVersionActorState() 
	{
		fdb_probe_actor_destroy("getCommittedVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 419 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			if (self->allowSpecialCaseRollforward_)
															#line 2191 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			{
															#line 420 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
				self->getCommittedVersionQuorum.allowSpecialCaseRollforward();
															#line 2195 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			}
															#line 422 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			StrictFuture<QuorumVersion> __when_expr_0 = self->getCommittedVersionQuorum.getCommittedVersion();
															#line 422 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			if (static_cast<GetCommittedVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2201 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetCommittedVersionActor*>(this)->actor_wait_state = 1;
															#line 422 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetCommittedVersionActor, 0, QuorumVersion >*>(static_cast<GetCommittedVersionActor*>(this)));
															#line 2206 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetCommittedVersionActorState();
		static_cast<GetCommittedVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(QuorumVersion const& quorumVersion,int loopDepth) 
	{
															#line 423 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		if (!quorumVersion.isQuorum)
															#line 2229 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		{
															#line 424 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			return a_body1Catch1(failed_to_reach_quorum(), loopDepth);
															#line 2233 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		}
															#line 426 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		if (!static_cast<GetCommittedVersionActor*>(this)->SAV<Version>::futures) { (void)(quorumVersion.versions.lastCommitted); this->~GetCommittedVersionActorState(); static_cast<GetCommittedVersionActor*>(this)->destroy(); return 0; }
															#line 2237 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		new (&static_cast<GetCommittedVersionActor*>(this)->SAV< Version >::value()) Version(quorumVersion.versions.lastCommitted);
		this->~GetCommittedVersionActorState();
		static_cast<GetCommittedVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(QuorumVersion && quorumVersion,int loopDepth) 
	{
															#line 423 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		if (!quorumVersion.isQuorum)
															#line 2249 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		{
															#line 424 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			return a_body1Catch1(failed_to_reach_quorum(), loopDepth);
															#line 2253 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		}
															#line 426 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		if (!static_cast<GetCommittedVersionActor*>(this)->SAV<Version>::futures) { (void)(quorumVersion.versions.lastCommitted); this->~GetCommittedVersionActorState(); static_cast<GetCommittedVersionActor*>(this)->destroy(); return 0; }
															#line 2257 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		new (&static_cast<GetCommittedVersionActor*>(this)->SAV< Version >::value()) Version(quorumVersion.versions.lastCommitted);
		this->~GetCommittedVersionActorState();
		static_cast<GetCommittedVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(QuorumVersion const& quorumVersion,int loopDepth) 
	{
		loopDepth = a_body1cont1(quorumVersion, loopDepth);

		return loopDepth;
	}
	int a_body1when1(QuorumVersion && quorumVersion,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(quorumVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetCommittedVersionActor*>(this)->actor_wait_state > 0) static_cast<GetCommittedVersionActor*>(this)->actor_wait_state = 0;
		static_cast<GetCommittedVersionActor*>(this)->ActorCallback< GetCommittedVersionActor, 0, QuorumVersion >::remove();

	}
	void a_callback_fire(ActorCallback< GetCommittedVersionActor, 0, QuorumVersion >*,QuorumVersion const& value) 
	{
		fdb_probe_actor_enter("getCommittedVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommittedVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetCommittedVersionActor, 0, QuorumVersion >*,QuorumVersion && value) 
	{
		fdb_probe_actor_enter("getCommittedVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommittedVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetCommittedVersionActor, 0, QuorumVersion >*,Error err) 
	{
		fdb_probe_actor_enter("getCommittedVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommittedVersion", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 418 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
	PaxosConfigConsumerImpl* self;
															#line 2342 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getCommittedVersion()
															#line 418 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
class GetCommittedVersionActor final : public Actor<Version>, public ActorCallback< GetCommittedVersionActor, 0, QuorumVersion >, public FastAllocated<GetCommittedVersionActor>, public GetCommittedVersionActorState<GetCommittedVersionActor> {
															#line 2347 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetCommittedVersionActor>::operator new;
	using FastAllocated<GetCommittedVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13735581764619833344UL, 11893520496670860544UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetCommittedVersionActor, 0, QuorumVersion >;
															#line 418 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
	GetCommittedVersionActor(PaxosConfigConsumerImpl* const& self) 
															#line 2364 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		 : Actor<Version>(),
		   GetCommittedVersionActorState<GetCommittedVersionActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getCommittedVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8917899261172622336UL, 9522656687011892480UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getCommittedVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getCommittedVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetCommittedVersionActor, 0, QuorumVersion >*)0, actor_cancelled()); break;
		}

	}
};
															#line 418 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
[[nodiscard]] static Future<Version> getCommittedVersion( PaxosConfigConsumerImpl* const& self ) {
															#line 418 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
	return Future<Version>(new GetCommittedVersionActor(self));
															#line 2396 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
}

#line 428 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"

	// Periodically compact knob changes on the configuration nodes. All nodes
	// must have received a version before it can be compacted.
																#line 2403 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
// This generated class is to be used only via compactor()
															#line 431 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
template <class CompactorActor>
															#line 431 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
class CompactorActorState {
															#line 2409 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
public:
															#line 431 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
	CompactorActorState(PaxosConfigConsumerImpl* const& self,ConfigBroadcaster* const& broadcaster) 
															#line 431 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
															#line 431 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		 : self(self),
															#line 431 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		   broadcaster(broadcaster)
															#line 2418 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("compactor", reinterpret_cast<unsigned long>(this));

	}
	~CompactorActorState() 
	{
		fdb_probe_actor_destroy("compactor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 432 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			if (!self->compactionInterval.present())
															#line 2433 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			{
															#line 433 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
				StrictFuture<Void> __when_expr_0 = Never();
															#line 433 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
				if (static_cast<CompactorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2439 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<CompactorActor*>(this)->actor_wait_state = 1;
															#line 433 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CompactorActor, 0, Void >*>(static_cast<CompactorActor*>(this)));
															#line 2444 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CompactorActorState();
		static_cast<CompactorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 436 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		;
															#line 2472 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 434 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		if (!static_cast<CompactorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CompactorActorState(); static_cast<CompactorActor*>(this)->destroy(); return 0; }
															#line 2481 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		new (&static_cast<CompactorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CompactorActorState();
		static_cast<CompactorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 434 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		if (!static_cast<CompactorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CompactorActorState(); static_cast<CompactorActor*>(this)->destroy(); return 0; }
															#line 2493 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		new (&static_cast<CompactorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CompactorActorState();
		static_cast<CompactorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CompactorActor*>(this)->actor_wait_state > 0) static_cast<CompactorActor*>(this)->actor_wait_state = 0;
		static_cast<CompactorActor*>(this)->ActorCallback< CompactorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CompactorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("compactor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CompactorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("compactor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CompactorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("compactor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CompactorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("compactor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CompactorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("compactor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CompactorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("compactor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 437 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		compactionVersion = self->compactionVersion;
															#line 438 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delayJittered(self->compactionInterval.get());
															#line 438 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		if (static_cast<CompactorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2591 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CompactorActor*>(this)->actor_wait_state = 2;
															#line 438 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CompactorActor, 1, Void >*>(static_cast<CompactorActor*>(this)));
															#line 2596 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 439 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		std::vector<Future<Void>> compactionRequests;
															#line 440 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		compactionRequests.reserve(compactionRequests.size());
															#line 441 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		for( const auto& cfi : self->cfis ) {
															#line 442 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			if (cfi.hostname.present())
															#line 2611 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			{
															#line 443 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
				compactionRequests.push_back( retryGetReplyFromHostname(ConfigFollowerCompactRequest{ compactionVersion }, cfi.hostname.get(), WLTOKEN_CONFIGFOLLOWER_COMPACT));
															#line 2615 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			}
			else
			{
															#line 448 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
				compactionRequests.push_back( cfi.compact.getReply(ConfigFollowerCompactRequest{ compactionVersion }));
															#line 2621 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			}
		}
		try {
															#line 453 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			StrictFuture<Void> __when_expr_2 = timeoutError(waitForAll(compactionRequests), 1.0);
															#line 453 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			if (static_cast<CompactorActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 2629 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1cont1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
			static_cast<CompactorActor*>(this)->actor_wait_state = 3;
															#line 453 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CompactorActor, 2, Void >*>(static_cast<CompactorActor*>(this)));
															#line 2634 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 439 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		std::vector<Future<Void>> compactionRequests;
															#line 440 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		compactionRequests.reserve(compactionRequests.size());
															#line 441 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		for( const auto& cfi : self->cfis ) {
															#line 442 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			if (cfi.hostname.present())
															#line 2655 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			{
															#line 443 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
				compactionRequests.push_back( retryGetReplyFromHostname(ConfigFollowerCompactRequest{ compactionVersion }, cfi.hostname.get(), WLTOKEN_CONFIGFOLLOWER_COMPACT));
															#line 2659 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			}
			else
			{
															#line 448 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
				compactionRequests.push_back( cfi.compact.getReply(ConfigFollowerCompactRequest{ compactionVersion }));
															#line 2665 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			}
		}
		try {
															#line 453 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			StrictFuture<Void> __when_expr_2 = timeoutError(waitForAll(compactionRequests), 1.0);
															#line 453 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			if (static_cast<CompactorActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 2673 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1cont1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
			static_cast<CompactorActor*>(this)->actor_wait_state = 3;
															#line 453 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CompactorActor, 2, Void >*>(static_cast<CompactorActor*>(this)));
															#line 2678 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CompactorActor*>(this)->actor_wait_state > 0) static_cast<CompactorActor*>(this)->actor_wait_state = 0;
		static_cast<CompactorActor*>(this)->ActorCallback< CompactorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CompactorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("compactor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CompactorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("compactor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CompactorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("compactor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CompactorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("compactor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CompactorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("compactor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CompactorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("compactor", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont2(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 456 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			TraceEvent(SevWarn, "ErrorSendingCompactionRequest").error(e);
															#line 2775 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 454 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		broadcaster->compact(compactionVersion);
															#line 2790 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 454 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		broadcaster->compact(compactionVersion);
															#line 2799 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CompactorActor*>(this)->actor_wait_state > 0) static_cast<CompactorActor*>(this)->actor_wait_state = 0;
		static_cast<CompactorActor*>(this)->ActorCallback< CompactorActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CompactorActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("compactor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CompactorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("compactor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CompactorActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("compactor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CompactorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("compactor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CompactorActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("compactor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CompactorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("compactor", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 431 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
	PaxosConfigConsumerImpl* self;
															#line 431 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
	ConfigBroadcaster* broadcaster;
															#line 437 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
	Version compactionVersion;
															#line 2898 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via compactor()
															#line 431 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
class CompactorActor final : public Actor<Void>, public ActorCallback< CompactorActor, 0, Void >, public ActorCallback< CompactorActor, 1, Void >, public ActorCallback< CompactorActor, 2, Void >, public FastAllocated<CompactorActor>, public CompactorActorState<CompactorActor> {
															#line 2903 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
public:
	using FastAllocated<CompactorActor>::operator new;
	using FastAllocated<CompactorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9334588836446595328UL, 10623383804335961600UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CompactorActor, 0, Void >;
friend struct ActorCallback< CompactorActor, 1, Void >;
friend struct ActorCallback< CompactorActor, 2, Void >;
															#line 431 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
	CompactorActor(PaxosConfigConsumerImpl* const& self,ConfigBroadcaster* const& broadcaster) 
															#line 2922 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   CompactorActorState<CompactorActor>(self, broadcaster),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("compactor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18397928151659365120UL, 1246258962531721984UL);
		ActorExecutionContextHelper __helper(static_cast<CompactorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("compactor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("compactor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CompactorActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CompactorActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CompactorActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 431 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
[[nodiscard]] static Future<Void> compactor( PaxosConfigConsumerImpl* const& self, ConfigBroadcaster* const& broadcaster ) {
															#line 431 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
	return Future<Void>(new CompactorActor(self, broadcaster));
															#line 2956 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
}

#line 460 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"

																#line 2961 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
// This generated class is to be used only via getSnapshotAndChanges()
															#line 461 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
template <class GetSnapshotAndChangesActor>
															#line 461 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
class GetSnapshotAndChangesActorState {
															#line 2967 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
public:
															#line 461 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
	GetSnapshotAndChangesActorState(PaxosConfigConsumerImpl* const& self,ConfigBroadcaster* const& broadcaster) 
															#line 461 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
															#line 461 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		 : self(self),
															#line 461 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		   broadcaster(broadcaster)
															#line 2976 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this));

	}
	~GetSnapshotAndChangesActorState() 
	{
		fdb_probe_actor_destroy("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 462 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			;
															#line 2991 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetSnapshotAndChangesActorState();
		static_cast<GetSnapshotAndChangesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 520 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		if (!static_cast<GetSnapshotAndChangesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetSnapshotAndChangesActorState(); static_cast<GetSnapshotAndChangesActor*>(this)->destroy(); return 0; }
															#line 3014 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		new (&static_cast<GetSnapshotAndChangesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetSnapshotAndChangesActorState();
		static_cast<GetSnapshotAndChangesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 463 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		self->resetCommittedVersionQuorum();
															#line 3033 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		try {
															#line 465 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			StrictFuture<Version> __when_expr_0 = getCommittedVersion(self);
															#line 465 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			if (static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3039 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state = 1;
															#line 465 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetSnapshotAndChangesActor, 0, Version >*>(static_cast<GetSnapshotAndChangesActor*>(this)));
															#line 3044 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 509 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			if (e.code() == error_code_failed_to_reach_quorum)
															#line 3079 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			{
															#line 510 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
				StrictFuture<Void> __when_expr_4 = self->getCommittedVersionQuorum.complete();
															#line 510 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
				if (static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3085 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
				static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state = 5;
															#line 510 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< GetSnapshotAndChangesActor, 4, Void >*>(static_cast<GetSnapshotAndChangesActor*>(this)));
															#line 3090 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 511 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
				if (e.code() != error_code_timed_out && e.code() != error_code_broken_promise && e.code() != error_code_version_already_compacted && e.code() != error_code_process_behind && e.code() != error_code_future_version)
															#line 3097 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
				{
															#line 514 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
					return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 3101 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
				}
				loopDepth = a_body1loopBody1Catch1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 466 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		readReplicas = self->getCommittedVersionQuorum.getReadReplicas();
															#line 468 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		std::vector<Future<Void>> fs;
															#line 469 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		for( ConfigFollowerInterface& readReplica : readReplicas ) {
															#line 470 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			if (readReplica.hostname.present())
															#line 3124 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			{
															#line 471 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
				fs.push_back(tryInitializeRequestStream(&readReplica.getSnapshotAndChanges, readReplica.hostname.get(), WLTOKEN_CONFIGFOLLOWER_GETSNAPSHOTANDCHANGES));
															#line 3128 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			}
		}
															#line 476 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(fs);
															#line 476 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		if (static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3135 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state = 2;
															#line 476 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetSnapshotAndChangesActor, 1, Void >*>(static_cast<GetSnapshotAndChangesActor*>(this)));
															#line 3140 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Version const& __committedVersion,int loopDepth) 
	{
															#line 465 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		committedVersion = __committedVersion;
															#line 3149 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Version && __committedVersion,int loopDepth) 
	{
		committedVersion = std::move(__committedVersion);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state > 0) static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state = 0;
		static_cast<GetSnapshotAndChangesActor*>(this)->ActorCallback< GetSnapshotAndChangesActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< GetSnapshotAndChangesActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotAndChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetSnapshotAndChangesActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotAndChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetSnapshotAndChangesActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotAndChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 477 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		configNodes = Reference<ConfigFollowerInfo>(new ConfigFollowerInfo(readReplicas));
															#line 478 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		StrictFuture<ConfigFollowerGetSnapshotAndChangesReply> __when_expr_2 = timeoutError(basicLoadBalance(configNodes, &ConfigFollowerInterface::getSnapshotAndChanges, ConfigFollowerGetSnapshotAndChangesRequest{ committedVersion }), SERVER_KNOBS->GET_SNAPSHOT_AND_CHANGES_TIMEOUT);
															#line 478 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		if (static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3232 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state = 3;
															#line 478 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetSnapshotAndChangesActor, 2, ConfigFollowerGetSnapshotAndChangesReply >*>(static_cast<GetSnapshotAndChangesActor*>(this)));
															#line 3237 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 477 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		configNodes = Reference<ConfigFollowerInfo>(new ConfigFollowerInfo(readReplicas));
															#line 478 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		StrictFuture<ConfigFollowerGetSnapshotAndChangesReply> __when_expr_2 = timeoutError(basicLoadBalance(configNodes, &ConfigFollowerInterface::getSnapshotAndChanges, ConfigFollowerGetSnapshotAndChangesRequest{ committedVersion }), SERVER_KNOBS->GET_SNAPSHOT_AND_CHANGES_TIMEOUT);
															#line 478 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		if (static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3250 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state = 3;
															#line 478 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetSnapshotAndChangesActor, 2, ConfigFollowerGetSnapshotAndChangesReply >*>(static_cast<GetSnapshotAndChangesActor*>(this)));
															#line 3255 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state > 0) static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state = 0;
		static_cast<GetSnapshotAndChangesActor*>(this)->ActorCallback< GetSnapshotAndChangesActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetSnapshotAndChangesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotAndChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetSnapshotAndChangesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotAndChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetSnapshotAndChangesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotAndChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont6(ConfigFollowerGetSnapshotAndChangesReply const& reply,int loopDepth) 
	{
															#line 483 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		Version smallestCommitted = self->getCommittedVersionQuorum.getSmallestCommitted();
															#line 484 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		TraceEvent(SevDebug, "ConfigConsumerGotSnapshotAndChanges", self->id) .detail("SnapshotVersion", reply.snapshotVersion) .detail("SnapshotSize", reply.snapshot.size()) .detail("ChangesVersion", committedVersion) .detail("ChangesSize", reply.changes.size()) .detail("AnnotationsSize", reply.annotations.size()) .detail("LargestLiveVersion", self->getCommittedVersionQuorum.getLargestLive()) .detail("SmallestCommitted", smallestCommitted);
															#line 492 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		ASSERT_GE(committedVersion, self->lastSeenVersion);
															#line 493 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		self->lastSeenVersion = std::max(self->lastSeenVersion, committedVersion);
															#line 494 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		self->compactionVersion = std::max(self->compactionVersion, smallestCommitted);
															#line 495 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		broadcaster->applySnapshotAndChanges(std::move(reply.snapshot), reply.snapshotVersion, reply.changes, self->lastSeenVersion, reply.annotations, self->getCommittedVersionQuorum.getReadReplicas(), self->getCommittedVersionQuorum.getLargestLive(), self->readPreviousCoordinators);
															#line 503 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->getCommittedVersionQuorum.complete();
															#line 503 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		if (static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3353 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont6when1(__when_expr_3.get(), loopDepth); };
		static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state = 4;
															#line 503 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetSnapshotAndChangesActor, 3, Void >*>(static_cast<GetSnapshotAndChangesActor*>(this)));
															#line 3358 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont6(ConfigFollowerGetSnapshotAndChangesReply && reply,int loopDepth) 
	{
															#line 483 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		Version smallestCommitted = self->getCommittedVersionQuorum.getSmallestCommitted();
															#line 484 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		TraceEvent(SevDebug, "ConfigConsumerGotSnapshotAndChanges", self->id) .detail("SnapshotVersion", reply.snapshotVersion) .detail("SnapshotSize", reply.snapshot.size()) .detail("ChangesVersion", committedVersion) .detail("ChangesSize", reply.changes.size()) .detail("AnnotationsSize", reply.annotations.size()) .detail("LargestLiveVersion", self->getCommittedVersionQuorum.getLargestLive()) .detail("SmallestCommitted", smallestCommitted);
															#line 492 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		ASSERT_GE(committedVersion, self->lastSeenVersion);
															#line 493 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		self->lastSeenVersion = std::max(self->lastSeenVersion, committedVersion);
															#line 494 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		self->compactionVersion = std::max(self->compactionVersion, smallestCommitted);
															#line 495 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		broadcaster->applySnapshotAndChanges(std::move(reply.snapshot), reply.snapshotVersion, reply.changes, self->lastSeenVersion, reply.annotations, self->getCommittedVersionQuorum.getReadReplicas(), self->getCommittedVersionQuorum.getLargestLive(), self->readPreviousCoordinators);
															#line 503 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->getCommittedVersionQuorum.complete();
															#line 503 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		if (static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3381 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont6when1(__when_expr_3.get(), loopDepth); };
		static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state = 4;
															#line 503 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetSnapshotAndChangesActor, 3, Void >*>(static_cast<GetSnapshotAndChangesActor*>(this)));
															#line 3386 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(ConfigFollowerGetSnapshotAndChangesReply const& reply,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(reply, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(ConfigFollowerGetSnapshotAndChangesReply && reply,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(reply), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state > 0) static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state = 0;
		static_cast<GetSnapshotAndChangesActor*>(this)->ActorCallback< GetSnapshotAndChangesActor, 2, ConfigFollowerGetSnapshotAndChangesReply >::remove();

	}
	void a_callback_fire(ActorCallback< GetSnapshotAndChangesActor, 2, ConfigFollowerGetSnapshotAndChangesReply >*,ConfigFollowerGetSnapshotAndChangesReply const& value) 
	{
		fdb_probe_actor_enter("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotAndChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetSnapshotAndChangesActor, 2, ConfigFollowerGetSnapshotAndChangesReply >*,ConfigFollowerGetSnapshotAndChangesReply && value) 
	{
		fdb_probe_actor_enter("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotAndChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetSnapshotAndChangesActor, 2, ConfigFollowerGetSnapshotAndChangesReply >*,Error err) 
	{
		fdb_probe_actor_enter("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotAndChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont7(Void const& _,int loopDepth) 
	{
															#line 504 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		if (self->allowSpecialCaseRollforward_)
															#line 3470 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		{
															#line 505 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			self->allowSpecialCaseRollforward_ = false;
															#line 3474 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void && _,int loopDepth) 
	{
															#line 504 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		if (self->allowSpecialCaseRollforward_)
															#line 3484 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		{
															#line 505 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			self->allowSpecialCaseRollforward_ = false;
															#line 3488 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state > 0) static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state = 0;
		static_cast<GetSnapshotAndChangesActor*>(this)->ActorCallback< GetSnapshotAndChangesActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetSnapshotAndChangesActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotAndChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetSnapshotAndChangesActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotAndChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetSnapshotAndChangesActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotAndChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
															#line 516 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		StrictFuture<Void> __when_expr_5 = delayJittered(0.1);
															#line 516 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		if (static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3575 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1cont1when1(__when_expr_5.get(), loopDepth); };
		static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state = 6;
															#line 516 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< GetSnapshotAndChangesActor, 5, Void >*>(static_cast<GetSnapshotAndChangesActor*>(this)));
															#line 3580 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state > 0) static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state = 0;
		static_cast<GetSnapshotAndChangesActor*>(this)->ActorCallback< GetSnapshotAndChangesActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetSnapshotAndChangesActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotAndChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< GetSnapshotAndChangesActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotAndChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< GetSnapshotAndChangesActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotAndChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1Catch1cont5(Void const& _,int loopDepth) 
	{
															#line 517 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		self->resetCommittedVersionQuorum();
															#line 3676 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont5(Void && _,int loopDepth) 
	{
															#line 517 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		self->resetCommittedVersionQuorum();
															#line 3685 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state > 0) static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state = 0;
		static_cast<GetSnapshotAndChangesActor*>(this)->ActorCallback< GetSnapshotAndChangesActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetSnapshotAndChangesActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotAndChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< GetSnapshotAndChangesActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotAndChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< GetSnapshotAndChangesActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotAndChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 461 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
	PaxosConfigConsumerImpl* self;
															#line 461 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
	ConfigBroadcaster* broadcaster;
															#line 465 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
	Version committedVersion;
															#line 466 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
	std::vector<ConfigFollowerInterface> readReplicas;
															#line 477 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
	Reference<ConfigFollowerInfo> configNodes;
															#line 3775 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getSnapshotAndChanges()
															#line 461 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
class GetSnapshotAndChangesActor final : public Actor<Void>, public ActorCallback< GetSnapshotAndChangesActor, 0, Version >, public ActorCallback< GetSnapshotAndChangesActor, 1, Void >, public ActorCallback< GetSnapshotAndChangesActor, 2, ConfigFollowerGetSnapshotAndChangesReply >, public ActorCallback< GetSnapshotAndChangesActor, 3, Void >, public ActorCallback< GetSnapshotAndChangesActor, 4, Void >, public ActorCallback< GetSnapshotAndChangesActor, 5, Void >, public FastAllocated<GetSnapshotAndChangesActor>, public GetSnapshotAndChangesActorState<GetSnapshotAndChangesActor> {
															#line 3780 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetSnapshotAndChangesActor>::operator new;
	using FastAllocated<GetSnapshotAndChangesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2166201321327858432UL, 14512737463785651456UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetSnapshotAndChangesActor, 0, Version >;
friend struct ActorCallback< GetSnapshotAndChangesActor, 1, Void >;
friend struct ActorCallback< GetSnapshotAndChangesActor, 2, ConfigFollowerGetSnapshotAndChangesReply >;
friend struct ActorCallback< GetSnapshotAndChangesActor, 3, Void >;
friend struct ActorCallback< GetSnapshotAndChangesActor, 4, Void >;
friend struct ActorCallback< GetSnapshotAndChangesActor, 5, Void >;
															#line 461 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
	GetSnapshotAndChangesActor(PaxosConfigConsumerImpl* const& self,ConfigBroadcaster* const& broadcaster) 
															#line 3802 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   GetSnapshotAndChangesActorState<GetSnapshotAndChangesActor>(self, broadcaster),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3162109226205960192UL, 17975068368386092544UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotAndChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getSnapshotAndChanges");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetSnapshotAndChangesActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetSnapshotAndChangesActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetSnapshotAndChangesActor, 2, ConfigFollowerGetSnapshotAndChangesReply >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< GetSnapshotAndChangesActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< GetSnapshotAndChangesActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< GetSnapshotAndChangesActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 461 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
[[nodiscard]] static Future<Void> getSnapshotAndChanges( PaxosConfigConsumerImpl* const& self, ConfigBroadcaster* const& broadcaster ) {
															#line 461 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
	return Future<Void>(new GetSnapshotAndChangesActor(self, broadcaster));
															#line 3839 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
}

#line 522 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"

																#line 3844 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
// This generated class is to be used only via fetchChanges()
															#line 523 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
template <class FetchChangesActor>
															#line 523 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
class FetchChangesActorState {
															#line 3850 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
public:
															#line 523 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
	FetchChangesActorState(PaxosConfigConsumerImpl* const& self,ConfigBroadcaster* const& broadcaster) 
															#line 523 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
															#line 523 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		 : self(self),
															#line 523 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		   broadcaster(broadcaster)
															#line 3859 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("fetchChanges", reinterpret_cast<unsigned long>(this));

	}
	~FetchChangesActorState() 
	{
		fdb_probe_actor_destroy("fetchChanges", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 524 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = getSnapshotAndChanges(self, broadcaster);
															#line 524 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			if (static_cast<FetchChangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3876 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FetchChangesActor*>(this)->actor_wait_state = 1;
															#line 524 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FetchChangesActor, 0, Void >*>(static_cast<FetchChangesActor*>(this)));
															#line 3881 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FetchChangesActorState();
		static_cast<FetchChangesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 525 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		self->resetCommittedVersionQuorum();
															#line 526 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		;
															#line 3906 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 525 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		self->resetCommittedVersionQuorum();
															#line 526 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		;
															#line 3917 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FetchChangesActor*>(this)->actor_wait_state > 0) static_cast<FetchChangesActor*>(this)->actor_wait_state = 0;
		static_cast<FetchChangesActor*>(this)->ActorCallback< FetchChangesActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FetchChangesActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchChanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchChanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FetchChangesActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchChanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchChanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FetchChangesActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchChanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchChanges", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 528 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			StrictFuture<Version> __when_expr_1 = getCommittedVersion(self);
															#line 528 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			if (static_cast<FetchChangesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4011 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<FetchChangesActor*>(this)->actor_wait_state = 2;
															#line 528 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FetchChangesActor, 1, Version >*>(static_cast<FetchChangesActor*>(this)));
															#line 4016 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		try {
															#line 614 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			StrictFuture<Void> __when_expr_8 = self->getCommittedVersionQuorum.complete();
															#line 614 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			if (static_cast<FetchChangesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 4034 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont1loopBody1cont1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont1loopBody1cont1when1(__when_expr_8.get(), loopDepth); };
			static_cast<FetchChangesActor*>(this)->actor_wait_state = 9;
															#line 614 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< FetchChangesActor, 8, Void >*>(static_cast<FetchChangesActor*>(this)));
															#line 4039 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 588 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			if (e.code() == error_code_version_already_compacted || e.code() == error_code_timed_out || e.code() == error_code_failed_to_reach_quorum || e.code() == error_code_version_already_compacted || e.code() == error_code_process_behind || e.code() == error_code_future_version)
															#line 4055 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			{
															#line 591 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
				CODE_PROBE(true, "PaxosConfigConsumer fetch error");
															#line 592 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
				if (e.code() == error_code_failed_to_reach_quorum)
															#line 4061 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
				{
					try {
															#line 594 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
						StrictFuture<Void> __when_expr_6 = self->getCommittedVersionQuorum.complete();
															#line 594 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
						if (static_cast<FetchChangesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1Catch1(actor_cancelled(), loopDepth);
															#line 4068 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
						if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont1loopBody1Catch1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont1loopBody1Catch1when1(__when_expr_6.get(), loopDepth); };
						static_cast<FetchChangesActor*>(this)->actor_wait_state = 7;
															#line 594 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
						__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< FetchChangesActor, 6, Void >*>(static_cast<FetchChangesActor*>(this)));
															#line 4073 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
						loopDepth = 0;
					}
					catch (Error& error) {
						loopDepth = a_body1cont1loopBody1Catch1Catch1(error, loopDepth);
					} catch (...) {
						loopDepth = a_body1cont1loopBody1Catch1Catch1(unknown_error(), loopDepth);
					}
				}
				else
				{
					loopDepth = a_body1cont1loopBody1Catch1cont2(loopDepth);
				}
			}
			else
			{
															#line 606 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
				if (e.code() == error_code_broken_promise)
															#line 4091 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
				{
															#line 607 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
					self->resetCommittedVersionQuorum();
															#line 4095 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
					return a_body1cont1loopHead1(loopDepth); // continue
				}
				else
				{
															#line 610 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
					return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 4102 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(int loopDepth) 
	{
															#line 537 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		if (committedVersion > self->lastSeenVersion)
															#line 4118 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		{
															#line 538 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			ASSERT(self->getCommittedVersionQuorum.getReadReplicas().size() >= self->cfis.size() / 2 + 1 || self->getCommittedVersionQuorum.isSpecialZeroQuorum());
															#line 540 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			if (BUGGIFY)
															#line 4124 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			{
															#line 545 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
				StrictFuture<Void> __when_expr_2 = delay(deterministicRandom()->random01() * 5);
															#line 545 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
				if (static_cast<FetchChangesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4130 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
				static_cast<FetchChangesActor*>(this)->actor_wait_state = 3;
															#line 545 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FetchChangesActor, 2, Void >*>(static_cast<FetchChangesActor*>(this)));
															#line 4135 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1loopBody1cont4(loopDepth);
			}
		}
		else
		{
															#line 583 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			if (committedVersion == self->lastSeenVersion)
															#line 4147 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			{
															#line 584 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
				broadcaster->applyChanges({}, -1, {}, self->getCommittedVersionQuorum.getReadReplicas());
															#line 4151 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Version const& __committedVersion,int loopDepth) 
	{
															#line 528 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		committedVersion = __committedVersion;
															#line 4162 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Version && __committedVersion,int loopDepth) 
	{
		committedVersion = std::move(__committedVersion);
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FetchChangesActor*>(this)->actor_wait_state > 0) static_cast<FetchChangesActor*>(this)->actor_wait_state = 0;
		static_cast<FetchChangesActor*>(this)->ActorCallback< FetchChangesActor, 1, Version >::remove();

	}
	void a_callback_fire(ActorCallback< FetchChangesActor, 1, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("fetchChanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchChanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FetchChangesActor, 1, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("fetchChanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchChanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FetchChangesActor, 1, Version >*,Error err) 
	{
		fdb_probe_actor_enter("fetchChanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchChanges", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont3(int loopDepth) 
	{
															#line 586 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		StrictFuture<Void> __when_expr_5 = delayJittered(self->pollingInterval);
															#line 586 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		if (static_cast<FetchChangesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4243 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont1loopBody1cont3when1(__when_expr_5.get(), loopDepth); };
		static_cast<FetchChangesActor*>(this)->actor_wait_state = 6;
															#line 586 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< FetchChangesActor, 5, Void >*>(static_cast<FetchChangesActor*>(this)));
															#line 4248 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4(int loopDepth) 
	{
															#line 547 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		readReplicas = self->getCommittedVersionQuorum.getReadReplicas();
															#line 549 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		std::vector<Future<Void>> fs;
															#line 550 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		for( ConfigFollowerInterface& readReplica : readReplicas ) {
															#line 551 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			if (readReplica.hostname.present())
															#line 4263 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			{
															#line 552 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
				fs.push_back(tryInitializeRequestStream(&readReplica.getChanges, readReplica.hostname.get(), WLTOKEN_CONFIGFOLLOWER_GETCHANGES));
															#line 4267 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			}
		}
															#line 557 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		StrictFuture<Void> __when_expr_3 = waitForAll(fs);
															#line 557 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		if (static_cast<FetchChangesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4274 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<FetchChangesActor*>(this)->actor_wait_state = 4;
															#line 557 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FetchChangesActor, 3, Void >*>(static_cast<FetchChangesActor*>(this)));
															#line 4279 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FetchChangesActor*>(this)->actor_wait_state > 0) static_cast<FetchChangesActor*>(this)->actor_wait_state = 0;
		static_cast<FetchChangesActor*>(this)->ActorCallback< FetchChangesActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FetchChangesActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchChanges", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchChanges", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FetchChangesActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchChanges", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchChanges", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FetchChangesActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchChanges", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchChanges", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 558 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		configNodes = Reference<ConfigFollowerInfo>(new ConfigFollowerInfo(readReplicas));
															#line 559 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		StrictFuture<ConfigFollowerGetChangesReply> __when_expr_4 = timeoutError( basicLoadBalance(configNodes, &ConfigFollowerInterface::getChanges, ConfigFollowerGetChangesRequest{ self->lastSeenVersion, committedVersion }), SERVER_KNOBS->FETCH_CHANGES_TIMEOUT);
															#line 559 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		if (static_cast<FetchChangesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4379 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont1loopBody1cont6when1(__when_expr_4.get(), loopDepth); };
		static_cast<FetchChangesActor*>(this)->actor_wait_state = 5;
															#line 559 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< FetchChangesActor, 4, ConfigFollowerGetChangesReply >*>(static_cast<FetchChangesActor*>(this)));
															#line 4384 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 558 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		configNodes = Reference<ConfigFollowerInfo>(new ConfigFollowerInfo(readReplicas));
															#line 559 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		StrictFuture<ConfigFollowerGetChangesReply> __when_expr_4 = timeoutError( basicLoadBalance(configNodes, &ConfigFollowerInterface::getChanges, ConfigFollowerGetChangesRequest{ self->lastSeenVersion, committedVersion }), SERVER_KNOBS->FETCH_CHANGES_TIMEOUT);
															#line 559 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		if (static_cast<FetchChangesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4397 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont1loopBody1cont6when1(__when_expr_4.get(), loopDepth); };
		static_cast<FetchChangesActor*>(this)->actor_wait_state = 5;
															#line 559 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< FetchChangesActor, 4, ConfigFollowerGetChangesReply >*>(static_cast<FetchChangesActor*>(this)));
															#line 4402 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<FetchChangesActor*>(this)->actor_wait_state > 0) static_cast<FetchChangesActor*>(this)->actor_wait_state = 0;
		static_cast<FetchChangesActor*>(this)->ActorCallback< FetchChangesActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FetchChangesActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchChanges", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchChanges", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< FetchChangesActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchChanges", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchChanges", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< FetchChangesActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchChanges", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchChanges", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont9(ConfigFollowerGetChangesReply const& reply,int loopDepth) 
	{
															#line 564 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		for( const auto& versionedMutation : reply.changes ) {
															#line 565 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			TraceEvent te(SevDebug, "ConsumerFetchedMutation", self->id);
															#line 566 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			te.detail("Version", versionedMutation.version) .detail("ConfigClass", versionedMutation.mutation.getConfigClass()) .detail("KnobName", versionedMutation.mutation.getKnobName());
															#line 569 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			if (versionedMutation.mutation.isSet())
															#line 4492 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			{
															#line 570 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
				te.detail("Op", "Set") .detail("KnobValue", versionedMutation.mutation.getValue().toString());
															#line 4496 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			}
			else
			{
															#line 573 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
				te.detail("Op", "Clear");
															#line 4502 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			}
		}
															#line 576 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		self->lastSeenVersion = committedVersion;
															#line 577 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		Version smallestCommitted = self->getCommittedVersionQuorum.getSmallestCommitted();
															#line 578 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		self->compactionVersion = std::max(self->compactionVersion, smallestCommitted);
															#line 579 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		broadcaster->applyChanges(reply.changes, self->lastSeenVersion, reply.annotations, self->getCommittedVersionQuorum.getReadReplicas());
															#line 4513 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont9(ConfigFollowerGetChangesReply && reply,int loopDepth) 
	{
															#line 564 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		for( const auto& versionedMutation : reply.changes ) {
															#line 565 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			TraceEvent te(SevDebug, "ConsumerFetchedMutation", self->id);
															#line 566 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			te.detail("Version", versionedMutation.version) .detail("ConfigClass", versionedMutation.mutation.getConfigClass()) .detail("KnobName", versionedMutation.mutation.getKnobName());
															#line 569 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			if (versionedMutation.mutation.isSet())
															#line 4528 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			{
															#line 570 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
				te.detail("Op", "Set") .detail("KnobValue", versionedMutation.mutation.getValue().toString());
															#line 4532 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			}
			else
			{
															#line 573 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
				te.detail("Op", "Clear");
															#line 4538 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			}
		}
															#line 576 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		self->lastSeenVersion = committedVersion;
															#line 577 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		Version smallestCommitted = self->getCommittedVersionQuorum.getSmallestCommitted();
															#line 578 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		self->compactionVersion = std::max(self->compactionVersion, smallestCommitted);
															#line 579 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		broadcaster->applyChanges(reply.changes, self->lastSeenVersion, reply.annotations, self->getCommittedVersionQuorum.getReadReplicas());
															#line 4549 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6when1(ConfigFollowerGetChangesReply const& reply,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont9(reply, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6when1(ConfigFollowerGetChangesReply && reply,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont9(std::move(reply), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<FetchChangesActor*>(this)->actor_wait_state > 0) static_cast<FetchChangesActor*>(this)->actor_wait_state = 0;
		static_cast<FetchChangesActor*>(this)->ActorCallback< FetchChangesActor, 4, ConfigFollowerGetChangesReply >::remove();

	}
	void a_callback_fire(ActorCallback< FetchChangesActor, 4, ConfigFollowerGetChangesReply >*,ConfigFollowerGetChangesReply const& value) 
	{
		fdb_probe_actor_enter("fetchChanges", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchChanges", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< FetchChangesActor, 4, ConfigFollowerGetChangesReply >*,ConfigFollowerGetChangesReply && value) 
	{
		fdb_probe_actor_enter("fetchChanges", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchChanges", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< FetchChangesActor, 4, ConfigFollowerGetChangesReply >*,Error err) 
	{
		fdb_probe_actor_enter("fetchChanges", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchChanges", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont1loopBody1cont16(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont16cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont16(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont16cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont16(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont16(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<FetchChangesActor*>(this)->actor_wait_state > 0) static_cast<FetchChangesActor*>(this)->actor_wait_state = 0;
		static_cast<FetchChangesActor*>(this)->ActorCallback< FetchChangesActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FetchChangesActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchChanges", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchChanges", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< FetchChangesActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchChanges", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchChanges", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< FetchChangesActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchChanges", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchChanges", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont1loopBody1cont16cont1(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont2(int loopDepth) 
	{
															#line 604 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		self->resetCommittedVersionQuorum();
															#line 605 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		StrictFuture<Void> __when_expr_7 = getSnapshotAndChanges(self, broadcaster);
															#line 605 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		if (static_cast<FetchChangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4743 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1cont2when1(__when_expr_7.get(), loopDepth); };
		static_cast<FetchChangesActor*>(this)->actor_wait_state = 8;
															#line 605 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< FetchChangesActor, 7, Void >*>(static_cast<FetchChangesActor*>(this)));
															#line 4748 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 596 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			if (e.code() == error_code_broken_promise)
															#line 4764 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			{
															#line 597 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
				self->resetCommittedVersionQuorum();
															#line 4768 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
				return a_body1cont1loopHead1(loopDepth); // continue
			}
			else
			{
															#line 600 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 4775 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<FetchChangesActor*>(this)->actor_wait_state > 0) static_cast<FetchChangesActor*>(this)->actor_wait_state = 0;
		static_cast<FetchChangesActor*>(this)->ActorCallback< FetchChangesActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FetchChangesActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchChanges", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchChanges", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< FetchChangesActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchChanges", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchChanges", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< FetchChangesActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchChanges", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1Catch1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchChanges", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont1loopBody1Catch1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1Catch1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<FetchChangesActor*>(this)->actor_wait_state > 0) static_cast<FetchChangesActor*>(this)->actor_wait_state = 0;
		static_cast<FetchChangesActor*>(this)->ActorCallback< FetchChangesActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FetchChangesActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchChanges", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1Catch1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchChanges", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< FetchChangesActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchChanges", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1Catch1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchChanges", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< FetchChangesActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchChanges", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchChanges", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont1loopBody1cont17(int loopDepth) 
	{
															#line 620 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
		self->resetCommittedVersionQuorum();
															#line 4977 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 616 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
			if (e.code() != error_code_broken_promise)
															#line 4987 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			{
															#line 617 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 4991 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont1loopBody1cont17(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont18(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont18cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont18(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont18cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont18(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont18(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<FetchChangesActor*>(this)->actor_wait_state > 0) static_cast<FetchChangesActor*>(this)->actor_wait_state = 0;
		static_cast<FetchChangesActor*>(this)->ActorCallback< FetchChangesActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FetchChangesActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchChanges", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchChanges", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< FetchChangesActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchChanges", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchChanges", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< FetchChangesActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchChanges", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchChanges", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont1loopBody1cont18cont1(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont17(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 523 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
	PaxosConfigConsumerImpl* self;
															#line 523 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
	ConfigBroadcaster* broadcaster;
															#line 528 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
	Version committedVersion;
															#line 547 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
	std::vector<ConfigFollowerInterface> readReplicas;
															#line 558 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
	Reference<ConfigFollowerInfo> configNodes;
															#line 5113 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via fetchChanges()
															#line 523 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
class FetchChangesActor final : public Actor<Void>, public ActorCallback< FetchChangesActor, 0, Void >, public ActorCallback< FetchChangesActor, 1, Version >, public ActorCallback< FetchChangesActor, 2, Void >, public ActorCallback< FetchChangesActor, 3, Void >, public ActorCallback< FetchChangesActor, 4, ConfigFollowerGetChangesReply >, public ActorCallback< FetchChangesActor, 5, Void >, public ActorCallback< FetchChangesActor, 6, Void >, public ActorCallback< FetchChangesActor, 7, Void >, public ActorCallback< FetchChangesActor, 8, Void >, public FastAllocated<FetchChangesActor>, public FetchChangesActorState<FetchChangesActor> {
															#line 5118 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
public:
	using FastAllocated<FetchChangesActor>::operator new;
	using FastAllocated<FetchChangesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1916203612685009920UL, 15616716255175254272UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FetchChangesActor, 0, Void >;
friend struct ActorCallback< FetchChangesActor, 1, Version >;
friend struct ActorCallback< FetchChangesActor, 2, Void >;
friend struct ActorCallback< FetchChangesActor, 3, Void >;
friend struct ActorCallback< FetchChangesActor, 4, ConfigFollowerGetChangesReply >;
friend struct ActorCallback< FetchChangesActor, 5, Void >;
friend struct ActorCallback< FetchChangesActor, 6, Void >;
friend struct ActorCallback< FetchChangesActor, 7, Void >;
friend struct ActorCallback< FetchChangesActor, 8, Void >;
															#line 523 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
	FetchChangesActor(PaxosConfigConsumerImpl* const& self,ConfigBroadcaster* const& broadcaster) 
															#line 5143 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FetchChangesActorState<FetchChangesActor>(self, broadcaster),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fetchChanges", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(247041911323866368UL, 15046812401233103616UL);
		ActorExecutionContextHelper __helper(static_cast<FetchChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fetchChanges");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fetchChanges", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FetchChangesActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FetchChangesActor, 1, Version >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FetchChangesActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< FetchChangesActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< FetchChangesActor, 4, ConfigFollowerGetChangesReply >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< FetchChangesActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< FetchChangesActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< FetchChangesActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< FetchChangesActor, 8, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 523 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
[[nodiscard]] static Future<Void> fetchChanges( PaxosConfigConsumerImpl* const& self, ConfigBroadcaster* const& broadcaster ) {
															#line 523 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"
	return Future<Void>(new FetchChangesActor(self, broadcaster));
															#line 5183 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/build_output/fdbserver/PaxosConfigConsumer.actor.g.cpp.py_gen"
}

#line 623 "/codebuild/output/src884493268/src/github.com/apple/foundationdb/fdbserver/PaxosConfigConsumer.actor.cpp"

	void resetCommittedVersionQuorum() {
		getCommittedVersionQuorum = GetCommittedVersionQuorum{ cfis, lastSeenVersion, compactionVersion };
	}

public:
	Future<Void> readSnapshot(ConfigBroadcaster& broadcaster) { return getSnapshotAndChanges(this, &broadcaster); }

	Future<Void> consume(ConfigBroadcaster& broadcaster) {
		return fetchChanges(this, &broadcaster) || compactor(this, &broadcaster);
	}

	void allowSpecialCaseRollforward() { this->allowSpecialCaseRollforward_ = true; }

	UID getID() const { return id; }

	PaxosConfigConsumerImpl(std::vector<ConfigFollowerInterface> const& cfis,
	                        double pollingInterval,
	                        Optional<double> compactionInterval,
	                        bool readPreviousCoordinators)
	  : cfis(cfis), getCommittedVersionQuorum(cfis, 0, 0), pollingInterval(pollingInterval),
	    compactionInterval(compactionInterval), readPreviousCoordinators(readPreviousCoordinators),
	    id(deterministicRandom()->randomUniqueID()) {}
};

PaxosConfigConsumer::PaxosConfigConsumer(std::vector<ConfigFollowerInterface> const& cfis,
                                         double pollingInterval,
                                         Optional<double> compactionInterval,
                                         bool readPreviousCoordinators)
  : impl(PImpl<PaxosConfigConsumerImpl>::create(cfis, pollingInterval, compactionInterval, readPreviousCoordinators)) {}

PaxosConfigConsumer::PaxosConfigConsumer(ServerCoordinators const& coordinators,
                                         double pollingInterval,
                                         Optional<double> compactionInterval,
                                         bool readPreviousCoordinators)
  : impl(PImpl<PaxosConfigConsumerImpl>::create(coordinators.configServers,
                                                pollingInterval,
                                                compactionInterval,
                                                readPreviousCoordinators)) {}

PaxosConfigConsumer::~PaxosConfigConsumer() = default;

Future<Void> PaxosConfigConsumer::readSnapshot(ConfigBroadcaster& broadcaster) {
	return impl->readSnapshot(broadcaster);
}

Future<Void> PaxosConfigConsumer::consume(ConfigBroadcaster& broadcaster) {
	return impl->consume(broadcaster);
}

void PaxosConfigConsumer::allowSpecialCaseRollforward() {
	impl->allowSpecialCaseRollforward();
}

UID PaxosConfigConsumer::getID() const {
	return impl->getID();
}
