#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
/*
 * IAsyncFile.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "flow/IAsyncFile.h"
#include "flow/Error.h"
#include "flow/Knobs.h"
#include "flow/Platform.h"
#include "flow/UnitTest.h"
#include <iostream>
#include "flow/actorcompiler.h" // has to be last include

IAsyncFile::~IAsyncFile() = default;

const static unsigned int ONE_MEGABYTE = 1 << 20;
const static unsigned int FOUR_KILOBYTES = 4 << 10;

															#line 36 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
namespace {
// This generated class is to be used only via zeroRangeHelper()
															#line 34 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
template <class ZeroRangeHelperActor>
															#line 34 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
class ZeroRangeHelperActorState {
															#line 43 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
public:
															#line 34 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	ZeroRangeHelperActorState(Reference<IAsyncFile> const& f,int64_t const& offset,int64_t const& length,int const& fixedbyte) 
															#line 34 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
															#line 34 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		 : f(f),
															#line 34 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		   offset(offset),
															#line 34 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		   length(length),
															#line 34 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		   fixedbyte(fixedbyte),
															#line 35 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		   pos(offset),
															#line 36 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		   zeros(aligned_alloc(ONE_MEGABYTE, ONE_MEGABYTE))
															#line 60 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
	{
		fdb_probe_actor_create("zeroRangeHelper", reinterpret_cast<unsigned long>(this));

	}
	~ZeroRangeHelperActorState() 
	{
		fdb_probe_actor_destroy("zeroRangeHelper", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 37 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
			memset(zeros, fixedbyte, ONE_MEGABYTE);
															#line 39 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
			;
															#line 77 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ZeroRangeHelperActorState();
		static_cast<ZeroRangeHelperActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 46 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		aligned_free(zeros);
															#line 47 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (!static_cast<ZeroRangeHelperActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ZeroRangeHelperActorState(); static_cast<ZeroRangeHelperActor*>(this)->destroy(); return 0; }
															#line 102 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		new (&static_cast<ZeroRangeHelperActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ZeroRangeHelperActorState();
		static_cast<ZeroRangeHelperActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 39 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (!(pos < offset + length))
															#line 121 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 40 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		len = std::min<int64_t>(ONE_MEGABYTE, offset + length - pos);
															#line 41 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_0 = f->write(zeros, len, pos);
															#line 41 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<ZeroRangeHelperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 131 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ZeroRangeHelperActor*>(this)->actor_wait_state = 1;
															#line 41 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ZeroRangeHelperActor, 0, Void >*>(static_cast<ZeroRangeHelperActor*>(this)));
															#line 136 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 42 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		pos += len;
															#line 43 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_1 = yield();
															#line 43 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<ZeroRangeHelperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 162 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ZeroRangeHelperActor*>(this)->actor_wait_state = 2;
															#line 43 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ZeroRangeHelperActor, 1, Void >*>(static_cast<ZeroRangeHelperActor*>(this)));
															#line 167 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 42 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		pos += len;
															#line 43 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_1 = yield();
															#line 43 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<ZeroRangeHelperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 180 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ZeroRangeHelperActor*>(this)->actor_wait_state = 2;
															#line 43 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ZeroRangeHelperActor, 1, Void >*>(static_cast<ZeroRangeHelperActor*>(this)));
															#line 185 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ZeroRangeHelperActor*>(this)->actor_wait_state > 0) static_cast<ZeroRangeHelperActor*>(this)->actor_wait_state = 0;
		static_cast<ZeroRangeHelperActor*>(this)->ActorCallback< ZeroRangeHelperActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ZeroRangeHelperActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("zeroRangeHelper", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ZeroRangeHelperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("zeroRangeHelper", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ZeroRangeHelperActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("zeroRangeHelper", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ZeroRangeHelperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("zeroRangeHelper", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ZeroRangeHelperActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("zeroRangeHelper", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ZeroRangeHelperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("zeroRangeHelper", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ZeroRangeHelperActor*>(this)->actor_wait_state > 0) static_cast<ZeroRangeHelperActor*>(this)->actor_wait_state = 0;
		static_cast<ZeroRangeHelperActor*>(this)->ActorCallback< ZeroRangeHelperActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ZeroRangeHelperActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("zeroRangeHelper", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ZeroRangeHelperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("zeroRangeHelper", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ZeroRangeHelperActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("zeroRangeHelper", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ZeroRangeHelperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("zeroRangeHelper", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ZeroRangeHelperActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("zeroRangeHelper", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ZeroRangeHelperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("zeroRangeHelper", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 34 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	Reference<IAsyncFile> f;
															#line 34 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	int64_t offset;
															#line 34 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	int64_t length;
															#line 34 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	int fixedbyte;
															#line 35 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	int64_t pos;
															#line 36 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	void* zeros;
															#line 40 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	int len;
															#line 366 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
};
// This generated class is to be used only via zeroRangeHelper()
															#line 34 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
class ZeroRangeHelperActor final : public Actor<Void>, public ActorCallback< ZeroRangeHelperActor, 0, Void >, public ActorCallback< ZeroRangeHelperActor, 1, Void >, public FastAllocated<ZeroRangeHelperActor>, public ZeroRangeHelperActorState<ZeroRangeHelperActor> {
															#line 371 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
public:
	using FastAllocated<ZeroRangeHelperActor>::operator new;
	using FastAllocated<ZeroRangeHelperActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6649326359436894720UL, 2086280237160978944UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ZeroRangeHelperActor, 0, Void >;
friend struct ActorCallback< ZeroRangeHelperActor, 1, Void >;
															#line 34 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	ZeroRangeHelperActor(Reference<IAsyncFile> const& f,int64_t const& offset,int64_t const& length,int const& fixedbyte) 
															#line 389 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		 : Actor<Void>(),
		   ZeroRangeHelperActorState<ZeroRangeHelperActor>(f, offset, length, fixedbyte),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("zeroRangeHelper", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(847389472181090304UL, 484964843869325824UL);
		ActorExecutionContextHelper __helper(static_cast<ZeroRangeHelperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("zeroRangeHelper");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("zeroRangeHelper", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ZeroRangeHelperActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ZeroRangeHelperActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 34 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
[[nodiscard]] static Future<Void> zeroRangeHelper( Reference<IAsyncFile> const& f, int64_t const& offset, int64_t const& length, int const& fixedbyte ) {
															#line 34 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	return Future<Void>(new ZeroRangeHelperActor(f, offset, length, fixedbyte));
															#line 423 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
}

#line 49 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"

Future<Void> IAsyncFile::zeroRange(int64_t offset, int64_t length) {
	return uncancellable(zeroRangeHelper(Reference<IAsyncFile>::addRef(this), offset, length, 0));
}

															#line 432 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase54()
															#line 54 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
template <class FlowTestCase54Actor>
															#line 54 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
class FlowTestCase54ActorState {
															#line 439 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
public:
															#line 54 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	FlowTestCase54ActorState(UnitTestParameters const& params) 
															#line 54 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
															#line 54 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		 : params(params),
															#line 55 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		   filename("/tmp/__ZEROJUNK__")
															#line 448 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase54", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase54ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase54", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 56 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
			StrictFuture<Reference<IAsyncFile>> __when_expr_0 = IAsyncFileSystem::filesystem()->open( filename, IAsyncFile::OPEN_ATOMIC_WRITE_AND_CREATE | IAsyncFile::OPEN_CREATE | IAsyncFile::OPEN_READWRITE, 0);
															#line 56 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
			if (static_cast<FlowTestCase54Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 465 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase54Actor*>(this)->actor_wait_state = 1;
															#line 56 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase54Actor, 0, Reference<IAsyncFile> >*>(static_cast<FlowTestCase54Actor*>(this)));
															#line 470 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase54ActorState();
		static_cast<FlowTestCase54Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 60 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_1 = f->sync();
															#line 60 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase54Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 495 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase54Actor*>(this)->actor_wait_state = 2;
															#line 60 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase54Actor, 1, Void >*>(static_cast<FlowTestCase54Actor*>(this)));
															#line 500 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> const& __f,int loopDepth) 
	{
															#line 56 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		f = __f;
															#line 509 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> && __f,int loopDepth) 
	{
		f = std::move(__f);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase54Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase54Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase54Actor*>(this)->ActorCallback< FlowTestCase54Actor, 0, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase54Actor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("flowTestCase54", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase54Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase54", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase54Actor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("flowTestCase54", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase54Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase54", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase54Actor, 0, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase54", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase54Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase54", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 61 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_2 = f->zeroRange(0, ONE_MEGABYTE);
															#line 61 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase54Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 590 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FlowTestCase54Actor*>(this)->actor_wait_state = 3;
															#line 61 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase54Actor, 2, Void >*>(static_cast<FlowTestCase54Actor*>(this)));
															#line 595 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 61 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_2 = f->zeroRange(0, ONE_MEGABYTE);
															#line 61 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase54Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 606 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FlowTestCase54Actor*>(this)->actor_wait_state = 3;
															#line 61 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase54Actor, 2, Void >*>(static_cast<FlowTestCase54Actor*>(this)));
															#line 611 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FlowTestCase54Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase54Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase54Actor*>(this)->ActorCallback< FlowTestCase54Actor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase54Actor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase54", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase54Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase54", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FlowTestCase54Actor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase54", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase54Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase54", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FlowTestCase54Actor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase54", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase54Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase54", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 62 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<int64_t> __when_expr_3 = f->size();
															#line 62 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase54Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 697 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<FlowTestCase54Actor*>(this)->actor_wait_state = 4;
															#line 62 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase54Actor, 3, int64_t >*>(static_cast<FlowTestCase54Actor*>(this)));
															#line 702 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 62 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<int64_t> __when_expr_3 = f->size();
															#line 62 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase54Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 713 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<FlowTestCase54Actor*>(this)->actor_wait_state = 4;
															#line 62 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase54Actor, 3, int64_t >*>(static_cast<FlowTestCase54Actor*>(this)));
															#line 718 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FlowTestCase54Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase54Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase54Actor*>(this)->ActorCallback< FlowTestCase54Actor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase54Actor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase54", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase54Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase54", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FlowTestCase54Actor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase54", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase54Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase54", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FlowTestCase54Actor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase54", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase54Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase54", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(int64_t const& size,int loopDepth) 
	{
															#line 63 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		ASSERT(ONE_MEGABYTE == size);
															#line 66 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_4 = zeroRangeHelper(f, 0, ONE_MEGABYTE, 0xff);
															#line 66 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase54Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 806 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<FlowTestCase54Actor*>(this)->actor_wait_state = 5;
															#line 66 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase54Actor, 4, Void >*>(static_cast<FlowTestCase54Actor*>(this)));
															#line 811 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(int64_t && size,int loopDepth) 
	{
															#line 63 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		ASSERT(ONE_MEGABYTE == size);
															#line 66 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_4 = zeroRangeHelper(f, 0, ONE_MEGABYTE, 0xff);
															#line 66 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase54Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 824 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<FlowTestCase54Actor*>(this)->actor_wait_state = 5;
															#line 66 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase54Actor, 4, Void >*>(static_cast<FlowTestCase54Actor*>(this)));
															#line 829 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(int64_t const& size,int loopDepth) 
	{
		loopDepth = a_body1cont4(size, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(int64_t && size,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(size), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<FlowTestCase54Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase54Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase54Actor*>(this)->ActorCallback< FlowTestCase54Actor, 3, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase54Actor, 3, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("flowTestCase54", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase54Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase54", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< FlowTestCase54Actor, 3, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("flowTestCase54", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase54Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase54", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< FlowTestCase54Actor, 3, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase54", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase54Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase54", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 67 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_5 = f->zeroRange(0, ONE_MEGABYTE);
															#line 67 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase54Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 915 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<FlowTestCase54Actor*>(this)->actor_wait_state = 6;
															#line 67 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase54Actor, 5, Void >*>(static_cast<FlowTestCase54Actor*>(this)));
															#line 920 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 67 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_5 = f->zeroRange(0, ONE_MEGABYTE);
															#line 67 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase54Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 931 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<FlowTestCase54Actor*>(this)->actor_wait_state = 6;
															#line 67 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase54Actor, 5, Void >*>(static_cast<FlowTestCase54Actor*>(this)));
															#line 936 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<FlowTestCase54Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase54Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase54Actor*>(this)->ActorCallback< FlowTestCase54Actor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase54Actor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase54", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase54Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase54", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< FlowTestCase54Actor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase54", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase54Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase54", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< FlowTestCase54Actor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase54", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase54Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase54", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 68 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		page = (uint8_t*)malloc(FOUR_KILOBYTES);
															#line 69 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<int> __when_expr_6 = f->read(page, FOUR_KILOBYTES, 0);
															#line 69 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase54Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1024 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont6when1(__when_expr_6.get(), loopDepth); };
		static_cast<FlowTestCase54Actor*>(this)->actor_wait_state = 7;
															#line 69 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase54Actor, 6, int >*>(static_cast<FlowTestCase54Actor*>(this)));
															#line 1029 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 68 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		page = (uint8_t*)malloc(FOUR_KILOBYTES);
															#line 69 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<int> __when_expr_6 = f->read(page, FOUR_KILOBYTES, 0);
															#line 69 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase54Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1042 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont6when1(__when_expr_6.get(), loopDepth); };
		static_cast<FlowTestCase54Actor*>(this)->actor_wait_state = 7;
															#line 69 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase54Actor, 6, int >*>(static_cast<FlowTestCase54Actor*>(this)));
															#line 1047 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<FlowTestCase54Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase54Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase54Actor*>(this)->ActorCallback< FlowTestCase54Actor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase54Actor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase54", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase54Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase54", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< FlowTestCase54Actor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase54", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase54Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase54", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< FlowTestCase54Actor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase54", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase54Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase54", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont7(int const& n,int loopDepth) 
	{
															#line 70 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		ASSERT(n == FOUR_KILOBYTES);
															#line 71 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		for(int i = 0;i < FOUR_KILOBYTES;i++) {
															#line 72 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
			ASSERT(page[i] == 0);
															#line 1135 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		}
															#line 74 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		free(page);
															#line 77 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		f.clear();
															#line 78 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_7 = IAsyncFileSystem::filesystem()->deleteFile(filename, true);
															#line 78 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase54Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1145 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont7when1(__when_expr_7.get(), loopDepth); };
		static_cast<FlowTestCase54Actor*>(this)->actor_wait_state = 8;
															#line 78 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase54Actor, 7, Void >*>(static_cast<FlowTestCase54Actor*>(this)));
															#line 1150 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7(int && n,int loopDepth) 
	{
															#line 70 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		ASSERT(n == FOUR_KILOBYTES);
															#line 71 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		for(int i = 0;i < FOUR_KILOBYTES;i++) {
															#line 72 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
			ASSERT(page[i] == 0);
															#line 1163 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		}
															#line 74 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		free(page);
															#line 77 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		f.clear();
															#line 78 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_7 = IAsyncFileSystem::filesystem()->deleteFile(filename, true);
															#line 78 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase54Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1173 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont7when1(__when_expr_7.get(), loopDepth); };
		static_cast<FlowTestCase54Actor*>(this)->actor_wait_state = 8;
															#line 78 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase54Actor, 7, Void >*>(static_cast<FlowTestCase54Actor*>(this)));
															#line 1178 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6when1(int const& n,int loopDepth) 
	{
		loopDepth = a_body1cont7(n, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(int && n,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(n), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<FlowTestCase54Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase54Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase54Actor*>(this)->ActorCallback< FlowTestCase54Actor, 6, int >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase54Actor, 6, int >*,int const& value) 
	{
		fdb_probe_actor_enter("flowTestCase54", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase54Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase54", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< FlowTestCase54Actor, 6, int >*,int && value) 
	{
		fdb_probe_actor_enter("flowTestCase54", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase54Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase54", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< FlowTestCase54Actor, 6, int >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase54", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase54Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase54", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
															#line 79 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (!static_cast<FlowTestCase54Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase54ActorState(); static_cast<FlowTestCase54Actor*>(this)->destroy(); return 0; }
															#line 1262 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		new (&static_cast<FlowTestCase54Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase54ActorState();
		static_cast<FlowTestCase54Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
															#line 79 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (!static_cast<FlowTestCase54Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase54ActorState(); static_cast<FlowTestCase54Actor*>(this)->destroy(); return 0; }
															#line 1274 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		new (&static_cast<FlowTestCase54Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase54ActorState();
		static_cast<FlowTestCase54Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<FlowTestCase54Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase54Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase54Actor*>(this)->ActorCallback< FlowTestCase54Actor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase54Actor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase54", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase54Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase54", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< FlowTestCase54Actor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase54", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase54Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase54", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< FlowTestCase54Actor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase54", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase54Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase54", reinterpret_cast<unsigned long>(this), 7);

	}
															#line 54 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	UnitTestParameters params;
															#line 55 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	std::string filename;
															#line 56 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	Reference<IAsyncFile> f;
															#line 68 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	uint8_t* page;
															#line 1365 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase54()
															#line 54 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
class FlowTestCase54Actor final : public Actor<Void>, public ActorCallback< FlowTestCase54Actor, 0, Reference<IAsyncFile> >, public ActorCallback< FlowTestCase54Actor, 1, Void >, public ActorCallback< FlowTestCase54Actor, 2, Void >, public ActorCallback< FlowTestCase54Actor, 3, int64_t >, public ActorCallback< FlowTestCase54Actor, 4, Void >, public ActorCallback< FlowTestCase54Actor, 5, Void >, public ActorCallback< FlowTestCase54Actor, 6, int >, public ActorCallback< FlowTestCase54Actor, 7, Void >, public FastAllocated<FlowTestCase54Actor>, public FlowTestCase54ActorState<FlowTestCase54Actor> {
															#line 1370 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase54Actor>::operator new;
	using FastAllocated<FlowTestCase54Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12063955990700639232UL, 1049996331260794880UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase54Actor, 0, Reference<IAsyncFile> >;
friend struct ActorCallback< FlowTestCase54Actor, 1, Void >;
friend struct ActorCallback< FlowTestCase54Actor, 2, Void >;
friend struct ActorCallback< FlowTestCase54Actor, 3, int64_t >;
friend struct ActorCallback< FlowTestCase54Actor, 4, Void >;
friend struct ActorCallback< FlowTestCase54Actor, 5, Void >;
friend struct ActorCallback< FlowTestCase54Actor, 6, int >;
friend struct ActorCallback< FlowTestCase54Actor, 7, Void >;
															#line 54 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	FlowTestCase54Actor(UnitTestParameters const& params) 
															#line 1394 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase54ActorState<FlowTestCase54Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase54", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16478453105262663168UL, 6418535300656033536UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase54Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase54");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase54", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase54Actor, 0, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FlowTestCase54Actor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FlowTestCase54Actor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< FlowTestCase54Actor, 3, int64_t >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< FlowTestCase54Actor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< FlowTestCase54Actor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< FlowTestCase54Actor, 6, int >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< FlowTestCase54Actor, 7, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 54 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
static Future<Void> flowTestCase54( UnitTestParameters const& params ) {
															#line 54 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	return Future<Void>(new FlowTestCase54Actor(params));
															#line 1434 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase54, "/fileio/zero")

#line 81 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"

															#line 1440 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
namespace {
// This generated class is to be used only via incrementalDeleteHelper()
															#line 82 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
template <class IncrementalDeleteHelperActor>
															#line 82 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
class IncrementalDeleteHelperActorState {
															#line 1447 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
public:
															#line 82 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	IncrementalDeleteHelperActorState(std::string const& filename,bool const& mustBeDurable,int64_t const& truncateAmt,double const& interval) 
															#line 82 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
															#line 82 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		 : filename(filename),
															#line 82 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		   mustBeDurable(mustBeDurable),
															#line 82 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		   truncateAmt(truncateAmt),
															#line 82 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		   interval(interval),
															#line 86 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		   file(),
															#line 87 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		   remainingFileSize(),
															#line 88 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		   exists(fileExists(filename))
															#line 1466 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
	{
		fdb_probe_actor_create("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this));

	}
	~IncrementalDeleteHelperActorState() 
	{
		fdb_probe_actor_destroy("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 90 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
			if (exists)
															#line 1481 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
			{
															#line 91 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
				StrictFuture<Reference<IAsyncFile>> __when_expr_0 = IAsyncFileSystem::filesystem()->open( filename, IAsyncFile::OPEN_READWRITE | IAsyncFile::OPEN_UNCACHED | IAsyncFile::OPEN_UNBUFFERED, 0);
															#line 91 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
				if (static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1487 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state = 1;
															#line 91 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< IncrementalDeleteHelperActor, 0, Reference<IAsyncFile> >*>(static_cast<IncrementalDeleteHelperActor*>(this)));
															#line 1492 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~IncrementalDeleteHelperActorState();
		static_cast<IncrementalDeleteHelperActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 99 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_2 = IAsyncFileSystem::filesystem()->deleteFile(filename, mustBeDurable);
															#line 99 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1522 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state = 3;
															#line 99 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< IncrementalDeleteHelperActor, 2, Void >*>(static_cast<IncrementalDeleteHelperActor*>(this)));
															#line 1527 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Reference<IAsyncFile> const& f,int loopDepth) 
	{
															#line 93 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		file = f;
															#line 95 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<int64_t> __when_expr_1 = file->size();
															#line 95 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1540 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state = 2;
															#line 95 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< IncrementalDeleteHelperActor, 1, int64_t >*>(static_cast<IncrementalDeleteHelperActor*>(this)));
															#line 1545 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Reference<IAsyncFile> && f,int loopDepth) 
	{
															#line 93 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		file = f;
															#line 95 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<int64_t> __when_expr_1 = file->size();
															#line 95 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1558 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state = 2;
															#line 95 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< IncrementalDeleteHelperActor, 1, int64_t >*>(static_cast<IncrementalDeleteHelperActor*>(this)));
															#line 1563 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> const& f,int loopDepth) 
	{
		loopDepth = a_body1cont2(f, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> && f,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(f), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state > 0) static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state = 0;
		static_cast<IncrementalDeleteHelperActor*>(this)->ActorCallback< IncrementalDeleteHelperActor, 0, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< IncrementalDeleteHelperActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementalDeleteHelperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< IncrementalDeleteHelperActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementalDeleteHelperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< IncrementalDeleteHelperActor, 0, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementalDeleteHelperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int64_t const& fileSize,int loopDepth) 
	{
															#line 96 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		remainingFileSize = fileSize;
															#line 1647 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(int64_t && fileSize,int loopDepth) 
	{
															#line 96 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		remainingFileSize = fileSize;
															#line 1656 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(int64_t const& fileSize,int loopDepth) 
	{
		loopDepth = a_body1cont3(fileSize, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(int64_t && fileSize,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(fileSize), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state > 0) static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state = 0;
		static_cast<IncrementalDeleteHelperActor*>(this)->ActorCallback< IncrementalDeleteHelperActor, 1, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< IncrementalDeleteHelperActor, 1, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementalDeleteHelperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< IncrementalDeleteHelperActor, 1, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementalDeleteHelperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< IncrementalDeleteHelperActor, 1, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementalDeleteHelperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 101 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (exists)
															#line 1740 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		{
															#line 102 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
			;
															#line 1744 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
			loopDepth = a_body1cont5loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 101 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (exists)
															#line 1758 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		{
															#line 102 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
			;
															#line 1762 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
			loopDepth = a_body1cont5loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state > 0) static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state = 0;
		static_cast<IncrementalDeleteHelperActor*>(this)->ActorCallback< IncrementalDeleteHelperActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< IncrementalDeleteHelperActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementalDeleteHelperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< IncrementalDeleteHelperActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementalDeleteHelperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< IncrementalDeleteHelperActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementalDeleteHelperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(int loopDepth) 
	{
															#line 109 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (!static_cast<IncrementalDeleteHelperActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~IncrementalDeleteHelperActorState(); static_cast<IncrementalDeleteHelperActor*>(this)->destroy(); return 0; }
															#line 1851 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		new (&static_cast<IncrementalDeleteHelperActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~IncrementalDeleteHelperActorState();
		static_cast<IncrementalDeleteHelperActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7(int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont5loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1(int loopDepth) 
	{
															#line 102 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (!(remainingFileSize > 0))
															#line 1876 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		{
			return a_body1cont5break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 103 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_3 = file->truncate(remainingFileSize);
															#line 103 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1884 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont5loopBody1when1(__when_expr_3.get(), loopDepth); };
		static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state = 4;
															#line 103 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< IncrementalDeleteHelperActor, 3, Void >*>(static_cast<IncrementalDeleteHelperActor*>(this)));
															#line 1889 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5break1(int loopDepth) 
	{
		try {
			return a_body1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 104 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_4 = file->sync();
															#line 104 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1913 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont5loopBody1cont1when1(__when_expr_4.get(), loopDepth); };
		static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state = 5;
															#line 104 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< IncrementalDeleteHelperActor, 4, Void >*>(static_cast<IncrementalDeleteHelperActor*>(this)));
															#line 1918 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 104 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_4 = file->sync();
															#line 104 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1929 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont5loopBody1cont1when1(__when_expr_4.get(), loopDepth); };
		static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state = 5;
															#line 104 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< IncrementalDeleteHelperActor, 4, Void >*>(static_cast<IncrementalDeleteHelperActor*>(this)));
															#line 1934 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state > 0) static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state = 0;
		static_cast<IncrementalDeleteHelperActor*>(this)->ActorCallback< IncrementalDeleteHelperActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< IncrementalDeleteHelperActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementalDeleteHelperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< IncrementalDeleteHelperActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementalDeleteHelperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< IncrementalDeleteHelperActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementalDeleteHelperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont5loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 105 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_5 = delay(interval);
															#line 105 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2020 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont5loopBody1cont3when1(__when_expr_5.get(), loopDepth); };
		static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state = 6;
															#line 105 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< IncrementalDeleteHelperActor, 5, Void >*>(static_cast<IncrementalDeleteHelperActor*>(this)));
															#line 2025 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 105 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_5 = delay(interval);
															#line 105 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2036 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont5loopBody1cont3when1(__when_expr_5.get(), loopDepth); };
		static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state = 6;
															#line 105 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< IncrementalDeleteHelperActor, 5, Void >*>(static_cast<IncrementalDeleteHelperActor*>(this)));
															#line 2041 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state > 0) static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state = 0;
		static_cast<IncrementalDeleteHelperActor*>(this)->ActorCallback< IncrementalDeleteHelperActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< IncrementalDeleteHelperActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementalDeleteHelperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< IncrementalDeleteHelperActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementalDeleteHelperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< IncrementalDeleteHelperActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementalDeleteHelperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont5loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 102 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		remainingFileSize -= truncateAmt;
															#line 2125 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont5loopHead1(0);

		return loopDepth;
	}
	int a_body1cont5loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 102 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		remainingFileSize -= truncateAmt;
															#line 2134 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont5loopHead1(0);

		return loopDepth;
	}
	int a_body1cont5loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state > 0) static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state = 0;
		static_cast<IncrementalDeleteHelperActor*>(this)->ActorCallback< IncrementalDeleteHelperActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< IncrementalDeleteHelperActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementalDeleteHelperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< IncrementalDeleteHelperActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementalDeleteHelperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< IncrementalDeleteHelperActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementalDeleteHelperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 82 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	std::string filename;
															#line 82 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	bool mustBeDurable;
															#line 82 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	int64_t truncateAmt;
															#line 82 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	double interval;
															#line 86 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	Reference<IAsyncFile> file;
															#line 87 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	int64_t remainingFileSize;
															#line 88 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	bool exists;
															#line 2228 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
};
// This generated class is to be used only via incrementalDeleteHelper()
															#line 82 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
class IncrementalDeleteHelperActor final : public Actor<Void>, public ActorCallback< IncrementalDeleteHelperActor, 0, Reference<IAsyncFile> >, public ActorCallback< IncrementalDeleteHelperActor, 1, int64_t >, public ActorCallback< IncrementalDeleteHelperActor, 2, Void >, public ActorCallback< IncrementalDeleteHelperActor, 3, Void >, public ActorCallback< IncrementalDeleteHelperActor, 4, Void >, public ActorCallback< IncrementalDeleteHelperActor, 5, Void >, public FastAllocated<IncrementalDeleteHelperActor>, public IncrementalDeleteHelperActorState<IncrementalDeleteHelperActor> {
															#line 2233 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
public:
	using FastAllocated<IncrementalDeleteHelperActor>::operator new;
	using FastAllocated<IncrementalDeleteHelperActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10707583846139637760UL, 14999528248986422272UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< IncrementalDeleteHelperActor, 0, Reference<IAsyncFile> >;
friend struct ActorCallback< IncrementalDeleteHelperActor, 1, int64_t >;
friend struct ActorCallback< IncrementalDeleteHelperActor, 2, Void >;
friend struct ActorCallback< IncrementalDeleteHelperActor, 3, Void >;
friend struct ActorCallback< IncrementalDeleteHelperActor, 4, Void >;
friend struct ActorCallback< IncrementalDeleteHelperActor, 5, Void >;
															#line 82 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	IncrementalDeleteHelperActor(std::string const& filename,bool const& mustBeDurable,int64_t const& truncateAmt,double const& interval) 
															#line 2255 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		 : Actor<Void>(),
		   IncrementalDeleteHelperActorState<IncrementalDeleteHelperActor>(filename, mustBeDurable, truncateAmt, interval),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16637687109927832064UL, 6078856186001469440UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementalDeleteHelperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("incrementalDeleteHelper");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< IncrementalDeleteHelperActor, 0, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< IncrementalDeleteHelperActor, 1, int64_t >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< IncrementalDeleteHelperActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< IncrementalDeleteHelperActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< IncrementalDeleteHelperActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< IncrementalDeleteHelperActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 82 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
[[nodiscard]] static Future<Void> incrementalDeleteHelper( std::string const& filename, bool const& mustBeDurable, int64_t const& truncateAmt, double const& interval ) {
															#line 82 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	return Future<Void>(new IncrementalDeleteHelperActor(filename, mustBeDurable, truncateAmt, interval));
															#line 2293 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
}

#line 111 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"

Future<Void> IAsyncFileSystem::incrementalDeleteFile(const std::string& filename, bool mustBeDurable) {
	return uncancellable(incrementalDeleteHelper(filename,
	                                             mustBeDurable,
	                                             FLOW_KNOBS->INCREMENTAL_DELETE_TRUNCATE_AMOUNT,
	                                             FLOW_KNOBS->INCREMENTAL_DELETE_INTERVAL));
}

															#line 2305 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase119()
															#line 119 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
template <class FlowTestCase119Actor>
															#line 119 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
class FlowTestCase119ActorState {
															#line 2312 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
public:
															#line 119 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	FlowTestCase119ActorState(UnitTestParameters const& params) 
															#line 119 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
															#line 119 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		 : params(params),
															#line 121 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		   fileSize(5e9),
															#line 122 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		   filename("/tmp/__JUNK__")
															#line 2323 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase119", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase119ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase119", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 123 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
			StrictFuture<Reference<IAsyncFile>> __when_expr_0 = IAsyncFileSystem::filesystem()->open( filename, IAsyncFile::OPEN_ATOMIC_WRITE_AND_CREATE | IAsyncFile::OPEN_CREATE | IAsyncFile::OPEN_READWRITE, 0);
															#line 123 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
			if (static_cast<FlowTestCase119Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2340 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase119Actor*>(this)->actor_wait_state = 1;
															#line 123 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase119Actor, 0, Reference<IAsyncFile> >*>(static_cast<FlowTestCase119Actor*>(this)));
															#line 2345 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase119ActorState();
		static_cast<FlowTestCase119Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 125 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_1 = f->sync();
															#line 125 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase119Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2370 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase119Actor*>(this)->actor_wait_state = 2;
															#line 125 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase119Actor, 1, Void >*>(static_cast<FlowTestCase119Actor*>(this)));
															#line 2375 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> const& __f,int loopDepth) 
	{
															#line 123 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		f = __f;
															#line 2384 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> && __f,int loopDepth) 
	{
		f = std::move(__f);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase119Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase119Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase119Actor*>(this)->ActorCallback< FlowTestCase119Actor, 0, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase119Actor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("flowTestCase119", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase119Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase119", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase119Actor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("flowTestCase119", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase119Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase119", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase119Actor, 0, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase119", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase119Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase119", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 126 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_2 = f->truncate(fileSize);
															#line 126 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase119Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2465 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FlowTestCase119Actor*>(this)->actor_wait_state = 3;
															#line 126 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase119Actor, 2, Void >*>(static_cast<FlowTestCase119Actor*>(this)));
															#line 2470 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 126 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_2 = f->truncate(fileSize);
															#line 126 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase119Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2481 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FlowTestCase119Actor*>(this)->actor_wait_state = 3;
															#line 126 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase119Actor, 2, Void >*>(static_cast<FlowTestCase119Actor*>(this)));
															#line 2486 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FlowTestCase119Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase119Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase119Actor*>(this)->ActorCallback< FlowTestCase119Actor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase119Actor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase119", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase119Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase119", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FlowTestCase119Actor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase119", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase119Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase119", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FlowTestCase119Actor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase119", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase119Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase119", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 128 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		f.clear();
															#line 129 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_3 = IAsyncFileSystem::filesystem()->incrementalDeleteFile(filename, true);
															#line 129 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase119Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2574 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<FlowTestCase119Actor*>(this)->actor_wait_state = 4;
															#line 129 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase119Actor, 3, Void >*>(static_cast<FlowTestCase119Actor*>(this)));
															#line 2579 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 128 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		f.clear();
															#line 129 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_3 = IAsyncFileSystem::filesystem()->incrementalDeleteFile(filename, true);
															#line 129 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase119Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2592 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<FlowTestCase119Actor*>(this)->actor_wait_state = 4;
															#line 129 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase119Actor, 3, Void >*>(static_cast<FlowTestCase119Actor*>(this)));
															#line 2597 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FlowTestCase119Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase119Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase119Actor*>(this)->ActorCallback< FlowTestCase119Actor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase119Actor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase119", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase119Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase119", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FlowTestCase119Actor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase119", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase119Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase119", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FlowTestCase119Actor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase119", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase119Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase119", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 130 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (!static_cast<FlowTestCase119Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase119ActorState(); static_cast<FlowTestCase119Actor*>(this)->destroy(); return 0; }
															#line 2681 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		new (&static_cast<FlowTestCase119Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase119ActorState();
		static_cast<FlowTestCase119Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 130 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (!static_cast<FlowTestCase119Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase119ActorState(); static_cast<FlowTestCase119Actor*>(this)->destroy(); return 0; }
															#line 2693 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		new (&static_cast<FlowTestCase119Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase119ActorState();
		static_cast<FlowTestCase119Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<FlowTestCase119Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase119Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase119Actor*>(this)->ActorCallback< FlowTestCase119Actor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase119Actor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase119", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase119Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase119", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< FlowTestCase119Actor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase119", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase119Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase119", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< FlowTestCase119Actor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase119", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase119Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase119", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 119 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	UnitTestParameters params;
															#line 121 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	int64_t fileSize;
															#line 122 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	std::string filename;
															#line 123 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	Reference<IAsyncFile> f;
															#line 2784 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase119()
															#line 119 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
class FlowTestCase119Actor final : public Actor<Void>, public ActorCallback< FlowTestCase119Actor, 0, Reference<IAsyncFile> >, public ActorCallback< FlowTestCase119Actor, 1, Void >, public ActorCallback< FlowTestCase119Actor, 2, Void >, public ActorCallback< FlowTestCase119Actor, 3, Void >, public FastAllocated<FlowTestCase119Actor>, public FlowTestCase119ActorState<FlowTestCase119Actor> {
															#line 2789 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase119Actor>::operator new;
	using FastAllocated<FlowTestCase119Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12212333728457177088UL, 8433630285897043200UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase119Actor, 0, Reference<IAsyncFile> >;
friend struct ActorCallback< FlowTestCase119Actor, 1, Void >;
friend struct ActorCallback< FlowTestCase119Actor, 2, Void >;
friend struct ActorCallback< FlowTestCase119Actor, 3, Void >;
															#line 119 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	FlowTestCase119Actor(UnitTestParameters const& params) 
															#line 2809 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase119ActorState<FlowTestCase119Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase119", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12727445349328075264UL, 5991661947233202688UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase119Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase119");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase119", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase119Actor, 0, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FlowTestCase119Actor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FlowTestCase119Actor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< FlowTestCase119Actor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 119 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
static Future<Void> flowTestCase119( UnitTestParameters const& params ) {
															#line 119 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	return Future<Void>(new FlowTestCase119Actor(params));
															#line 2845 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase119, "/fileio/incrementalDelete")

#line 132 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"

															#line 2851 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase133()
															#line 133 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
template <class FlowTestCase133Actor>
															#line 133 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
class FlowTestCase133ActorState {
															#line 2858 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
public:
															#line 133 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	FlowTestCase133ActorState(UnitTestParameters const& params) 
															#line 133 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
															#line 133 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		 : params(params),
															#line 135 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		   fileSize(100e6),
															#line 136 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		   filename("/tmp/__JUNK__." + deterministicRandom()->randomUniqueID().toString()),
															#line 137 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		   renamedFile("/tmp/__RENAMED_JUNK__." + deterministicRandom()->randomUniqueID().toString()),
															#line 138 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		   data(new char[4096]),
															#line 139 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		   readData(new char[4096])
															#line 2875 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase133", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase133ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase133", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 140 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
			StrictFuture<Reference<IAsyncFile>> __when_expr_0 = IAsyncFileSystem::filesystem()->open( filename, IAsyncFile::OPEN_ATOMIC_WRITE_AND_CREATE | IAsyncFile::OPEN_CREATE | IAsyncFile::OPEN_READWRITE, 0644);
															#line 140 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
			if (static_cast<FlowTestCase133Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2892 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase133Actor*>(this)->actor_wait_state = 1;
															#line 140 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase133Actor, 0, Reference<IAsyncFile> >*>(static_cast<FlowTestCase133Actor*>(this)));
															#line 2897 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase133ActorState();
		static_cast<FlowTestCase133Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 145 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_1 = f->sync();
															#line 145 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase133Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2922 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase133Actor*>(this)->actor_wait_state = 2;
															#line 145 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase133Actor, 1, Void >*>(static_cast<FlowTestCase133Actor*>(this)));
															#line 2927 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> const& __f,int loopDepth) 
	{
															#line 140 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		f = __f;
															#line 2936 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> && __f,int loopDepth) 
	{
		f = std::move(__f);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase133Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase133Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase133Actor*>(this)->ActorCallback< FlowTestCase133Actor, 0, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase133Actor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase133Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase133Actor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase133Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase133Actor, 0, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase133Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 146 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_2 = f->truncate(fileSize);
															#line 146 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase133Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3017 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FlowTestCase133Actor*>(this)->actor_wait_state = 3;
															#line 146 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase133Actor, 2, Void >*>(static_cast<FlowTestCase133Actor*>(this)));
															#line 3022 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 146 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_2 = f->truncate(fileSize);
															#line 146 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase133Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3033 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FlowTestCase133Actor*>(this)->actor_wait_state = 3;
															#line 146 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase133Actor, 2, Void >*>(static_cast<FlowTestCase133Actor*>(this)));
															#line 3038 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FlowTestCase133Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase133Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase133Actor*>(this)->ActorCallback< FlowTestCase133Actor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase133Actor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase133Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FlowTestCase133Actor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase133Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FlowTestCase133Actor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase133Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 147 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		memset(data.get(), 0, 4096);
															#line 149 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		for(int i = 0;i < 16;++i) {
															#line 150 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
			data[i] = deterministicRandom()->randomAlphaNumeric();
															#line 3126 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		}
															#line 153 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_3 = f->write(data.get(), 4096, 0);
															#line 153 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase133Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3132 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<FlowTestCase133Actor*>(this)->actor_wait_state = 4;
															#line 153 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase133Actor, 3, Void >*>(static_cast<FlowTestCase133Actor*>(this)));
															#line 3137 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 147 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		memset(data.get(), 0, 4096);
															#line 149 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		for(int i = 0;i < 16;++i) {
															#line 150 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
			data[i] = deterministicRandom()->randomAlphaNumeric();
															#line 3150 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		}
															#line 153 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_3 = f->write(data.get(), 4096, 0);
															#line 153 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase133Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3156 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<FlowTestCase133Actor*>(this)->actor_wait_state = 4;
															#line 153 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase133Actor, 3, Void >*>(static_cast<FlowTestCase133Actor*>(this)));
															#line 3161 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FlowTestCase133Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase133Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase133Actor*>(this)->ActorCallback< FlowTestCase133Actor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase133Actor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase133Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FlowTestCase133Actor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase133Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FlowTestCase133Actor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase133Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 154 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_4 = f->write(data.get(), 4096, fileSize - 4096);
															#line 154 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase133Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3247 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<FlowTestCase133Actor*>(this)->actor_wait_state = 5;
															#line 154 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase133Actor, 4, Void >*>(static_cast<FlowTestCase133Actor*>(this)));
															#line 3252 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 154 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_4 = f->write(data.get(), 4096, fileSize - 4096);
															#line 154 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase133Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3263 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<FlowTestCase133Actor*>(this)->actor_wait_state = 5;
															#line 154 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase133Actor, 4, Void >*>(static_cast<FlowTestCase133Actor*>(this)));
															#line 3268 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<FlowTestCase133Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase133Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase133Actor*>(this)->ActorCallback< FlowTestCase133Actor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase133Actor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase133Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< FlowTestCase133Actor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase133Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< FlowTestCase133Actor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase133Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 155 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_5 = f->sync();
															#line 155 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase133Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3354 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<FlowTestCase133Actor*>(this)->actor_wait_state = 6;
															#line 155 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase133Actor, 5, Void >*>(static_cast<FlowTestCase133Actor*>(this)));
															#line 3359 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 155 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_5 = f->sync();
															#line 155 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase133Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3370 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<FlowTestCase133Actor*>(this)->actor_wait_state = 6;
															#line 155 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase133Actor, 5, Void >*>(static_cast<FlowTestCase133Actor*>(this)));
															#line 3375 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<FlowTestCase133Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase133Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase133Actor*>(this)->ActorCallback< FlowTestCase133Actor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase133Actor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase133Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< FlowTestCase133Actor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase133Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< FlowTestCase133Actor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase133Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
															#line 157 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		f.clear();
															#line 158 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_6 = IAsyncFileSystem::filesystem()->renameFile(filename, renamedFile);
															#line 158 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase133Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3463 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont7when1(__when_expr_6.get(), loopDepth); };
		static_cast<FlowTestCase133Actor*>(this)->actor_wait_state = 7;
															#line 158 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase133Actor, 6, Void >*>(static_cast<FlowTestCase133Actor*>(this)));
															#line 3468 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
															#line 157 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		f.clear();
															#line 158 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_6 = IAsyncFileSystem::filesystem()->renameFile(filename, renamedFile);
															#line 158 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase133Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3481 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont7when1(__when_expr_6.get(), loopDepth); };
		static_cast<FlowTestCase133Actor*>(this)->actor_wait_state = 7;
															#line 158 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase133Actor, 6, Void >*>(static_cast<FlowTestCase133Actor*>(this)));
															#line 3486 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<FlowTestCase133Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase133Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase133Actor*>(this)->ActorCallback< FlowTestCase133Actor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase133Actor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase133Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< FlowTestCase133Actor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase133Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< FlowTestCase133Actor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase133Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
															#line 159 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Reference<IAsyncFile>> __when_expr_7 = IAsyncFileSystem::filesystem()->open(renamedFile, IAsyncFile::OPEN_READONLY, 0);
															#line 159 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase133Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3572 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont8when1(__when_expr_7.get(), loopDepth); };
		static_cast<FlowTestCase133Actor*>(this)->actor_wait_state = 8;
															#line 159 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase133Actor, 7, Reference<IAsyncFile> >*>(static_cast<FlowTestCase133Actor*>(this)));
															#line 3577 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
															#line 159 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Reference<IAsyncFile>> __when_expr_7 = IAsyncFileSystem::filesystem()->open(renamedFile, IAsyncFile::OPEN_READONLY, 0);
															#line 159 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase133Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3588 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont8when1(__when_expr_7.get(), loopDepth); };
		static_cast<FlowTestCase133Actor*>(this)->actor_wait_state = 8;
															#line 159 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase133Actor, 7, Reference<IAsyncFile> >*>(static_cast<FlowTestCase133Actor*>(this)));
															#line 3593 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<FlowTestCase133Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase133Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase133Actor*>(this)->ActorCallback< FlowTestCase133Actor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase133Actor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase133Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< FlowTestCase133Actor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase133Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< FlowTestCase133Actor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase133Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont9(Reference<IAsyncFile> const& _f,int loopDepth) 
	{
															#line 160 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		f = _f;
															#line 163 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		bool renamedExists = false;
															#line 164 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		auto bName = basename(renamedFile);
															#line 165 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		auto files = platform::listFiles("/tmp/");
															#line 166 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		for( const auto& file : files ) {
															#line 167 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
			if (file == bName)
															#line 3687 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
			{
															#line 168 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
				renamedExists = true;
															#line 3691 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
			}
															#line 170 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
			ASSERT(file != filename);
															#line 3695 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		}
															#line 172 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		ASSERT(renamedExists);
															#line 175 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<int> __when_expr_8 = f->read(readData.get(), 4096, 0);
															#line 175 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase133Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3703 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont9when1(__when_expr_8.get(), loopDepth); };
		static_cast<FlowTestCase133Actor*>(this)->actor_wait_state = 9;
															#line 175 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase133Actor, 8, int >*>(static_cast<FlowTestCase133Actor*>(this)));
															#line 3708 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9(Reference<IAsyncFile> && _f,int loopDepth) 
	{
															#line 160 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		f = _f;
															#line 163 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		bool renamedExists = false;
															#line 164 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		auto bName = basename(renamedFile);
															#line 165 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		auto files = platform::listFiles("/tmp/");
															#line 166 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		for( const auto& file : files ) {
															#line 167 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
			if (file == bName)
															#line 3727 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
			{
															#line 168 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
				renamedExists = true;
															#line 3731 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
			}
															#line 170 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
			ASSERT(file != filename);
															#line 3735 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		}
															#line 172 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		ASSERT(renamedExists);
															#line 175 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<int> __when_expr_8 = f->read(readData.get(), 4096, 0);
															#line 175 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase133Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3743 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont9when1(__when_expr_8.get(), loopDepth); };
		static_cast<FlowTestCase133Actor*>(this)->actor_wait_state = 9;
															#line 175 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase133Actor, 8, int >*>(static_cast<FlowTestCase133Actor*>(this)));
															#line 3748 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8when1(Reference<IAsyncFile> const& _f,int loopDepth) 
	{
		loopDepth = a_body1cont9(_f, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Reference<IAsyncFile> && _f,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(_f), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<FlowTestCase133Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase133Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase133Actor*>(this)->ActorCallback< FlowTestCase133Actor, 7, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase133Actor, 7, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase133Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< FlowTestCase133Actor, 7, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase133Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< FlowTestCase133Actor, 7, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase133Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont10(int const& length,int loopDepth) 
	{
															#line 176 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		ASSERT(length == 4096);
															#line 177 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		ASSERT(memcmp(readData.get(), data.get(), 4096) == 0);
															#line 179 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		f.clear();
															#line 182 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_9 = IAsyncFileSystem::filesystem()->deleteFile(renamedFile, true);
															#line 182 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase133Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3840 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont10when1(__when_expr_9.get(), loopDepth); };
		static_cast<FlowTestCase133Actor*>(this)->actor_wait_state = 10;
															#line 182 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase133Actor, 9, Void >*>(static_cast<FlowTestCase133Actor*>(this)));
															#line 3845 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10(int && length,int loopDepth) 
	{
															#line 176 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		ASSERT(length == 4096);
															#line 177 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		ASSERT(memcmp(readData.get(), data.get(), 4096) == 0);
															#line 179 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		f.clear();
															#line 182 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_9 = IAsyncFileSystem::filesystem()->deleteFile(renamedFile, true);
															#line 182 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase133Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3862 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont10when1(__when_expr_9.get(), loopDepth); };
		static_cast<FlowTestCase133Actor*>(this)->actor_wait_state = 10;
															#line 182 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase133Actor, 9, Void >*>(static_cast<FlowTestCase133Actor*>(this)));
															#line 3867 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9when1(int const& length,int loopDepth) 
	{
		loopDepth = a_body1cont10(length, loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(int && length,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(length), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<FlowTestCase133Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase133Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase133Actor*>(this)->ActorCallback< FlowTestCase133Actor, 8, int >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase133Actor, 8, int >*,int const& value) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase133Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< FlowTestCase133Actor, 8, int >*,int && value) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase133Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< FlowTestCase133Actor, 8, int >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase133Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont10cont1(Void const& _,int loopDepth) 
	{
															#line 183 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (!static_cast<FlowTestCase133Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase133ActorState(); static_cast<FlowTestCase133Actor*>(this)->destroy(); return 0; }
															#line 3951 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		new (&static_cast<FlowTestCase133Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase133ActorState();
		static_cast<FlowTestCase133Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10cont1(Void && _,int loopDepth) 
	{
															#line 183 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (!static_cast<FlowTestCase133Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase133ActorState(); static_cast<FlowTestCase133Actor*>(this)->destroy(); return 0; }
															#line 3963 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		new (&static_cast<FlowTestCase133Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase133ActorState();
		static_cast<FlowTestCase133Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<FlowTestCase133Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase133Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase133Actor*>(this)->ActorCallback< FlowTestCase133Actor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase133Actor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase133Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< FlowTestCase133Actor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase133Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< FlowTestCase133Actor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase133Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 9);

	}
															#line 133 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	UnitTestParameters params;
															#line 135 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	int64_t fileSize;
															#line 136 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	std::string filename;
															#line 137 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	std::string renamedFile;
															#line 138 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	std::unique_ptr<char[]> data;
															#line 139 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	std::unique_ptr<char[]> readData;
															#line 140 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	Reference<IAsyncFile> f;
															#line 4060 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase133()
															#line 133 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
class FlowTestCase133Actor final : public Actor<Void>, public ActorCallback< FlowTestCase133Actor, 0, Reference<IAsyncFile> >, public ActorCallback< FlowTestCase133Actor, 1, Void >, public ActorCallback< FlowTestCase133Actor, 2, Void >, public ActorCallback< FlowTestCase133Actor, 3, Void >, public ActorCallback< FlowTestCase133Actor, 4, Void >, public ActorCallback< FlowTestCase133Actor, 5, Void >, public ActorCallback< FlowTestCase133Actor, 6, Void >, public ActorCallback< FlowTestCase133Actor, 7, Reference<IAsyncFile> >, public ActorCallback< FlowTestCase133Actor, 8, int >, public ActorCallback< FlowTestCase133Actor, 9, Void >, public FastAllocated<FlowTestCase133Actor>, public FlowTestCase133ActorState<FlowTestCase133Actor> {
															#line 4065 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase133Actor>::operator new;
	using FastAllocated<FlowTestCase133Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15396987477132989440UL, 9198203951703105792UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase133Actor, 0, Reference<IAsyncFile> >;
friend struct ActorCallback< FlowTestCase133Actor, 1, Void >;
friend struct ActorCallback< FlowTestCase133Actor, 2, Void >;
friend struct ActorCallback< FlowTestCase133Actor, 3, Void >;
friend struct ActorCallback< FlowTestCase133Actor, 4, Void >;
friend struct ActorCallback< FlowTestCase133Actor, 5, Void >;
friend struct ActorCallback< FlowTestCase133Actor, 6, Void >;
friend struct ActorCallback< FlowTestCase133Actor, 7, Reference<IAsyncFile> >;
friend struct ActorCallback< FlowTestCase133Actor, 8, int >;
friend struct ActorCallback< FlowTestCase133Actor, 9, Void >;
															#line 133 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	FlowTestCase133Actor(UnitTestParameters const& params) 
															#line 4091 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase133ActorState<FlowTestCase133Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10787953888875940864UL, 17839854724649630208UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase133Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase133");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase133Actor, 0, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FlowTestCase133Actor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FlowTestCase133Actor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< FlowTestCase133Actor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< FlowTestCase133Actor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< FlowTestCase133Actor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< FlowTestCase133Actor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< FlowTestCase133Actor, 7, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< FlowTestCase133Actor, 8, int >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< FlowTestCase133Actor, 9, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 133 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
static Future<Void> flowTestCase133( UnitTestParameters const& params ) {
															#line 133 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	return Future<Void>(new FlowTestCase133Actor(params));
															#line 4133 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase133, "/fileio/rename")

#line 185 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"

// Truncating to extend size should zero the new data
															#line 4140 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase187()
															#line 187 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
template <class FlowTestCase187Actor>
															#line 187 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
class FlowTestCase187ActorState {
															#line 4147 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
public:
															#line 187 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	FlowTestCase187ActorState(UnitTestParameters const& params) 
															#line 187 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
															#line 187 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		 : params(params),
															#line 188 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		   filename("/tmp/__JUNK__")
															#line 4156 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase187", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase187ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase187", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 189 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
			StrictFuture<Reference<IAsyncFile>> __when_expr_0 = IAsyncFileSystem::filesystem()->open( filename, IAsyncFile::OPEN_ATOMIC_WRITE_AND_CREATE | IAsyncFile::OPEN_CREATE | IAsyncFile::OPEN_READWRITE, 0);
															#line 189 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
			if (static_cast<FlowTestCase187Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4173 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase187Actor*>(this)->actor_wait_state = 1;
															#line 189 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase187Actor, 0, Reference<IAsyncFile> >*>(static_cast<FlowTestCase187Actor*>(this)));
															#line 4178 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase187ActorState();
		static_cast<FlowTestCase187Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 191 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		data = std::array<char, 4096>();
															#line 192 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_1 = f->sync();
															#line 192 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase187Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4205 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase187Actor*>(this)->actor_wait_state = 2;
															#line 192 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase187Actor, 1, Void >*>(static_cast<FlowTestCase187Actor*>(this)));
															#line 4210 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> const& __f,int loopDepth) 
	{
															#line 189 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		f = __f;
															#line 4219 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> && __f,int loopDepth) 
	{
		f = std::move(__f);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase187Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase187Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase187Actor*>(this)->ActorCallback< FlowTestCase187Actor, 0, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase187Actor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("flowTestCase187", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase187Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase187", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase187Actor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("flowTestCase187", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase187Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase187", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase187Actor, 0, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase187", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase187Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase187", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 193 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_2 = f->truncate(4096);
															#line 193 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase187Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4300 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FlowTestCase187Actor*>(this)->actor_wait_state = 3;
															#line 193 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase187Actor, 2, Void >*>(static_cast<FlowTestCase187Actor*>(this)));
															#line 4305 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 193 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_2 = f->truncate(4096);
															#line 193 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase187Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4316 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FlowTestCase187Actor*>(this)->actor_wait_state = 3;
															#line 193 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase187Actor, 2, Void >*>(static_cast<FlowTestCase187Actor*>(this)));
															#line 4321 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FlowTestCase187Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase187Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase187Actor*>(this)->ActorCallback< FlowTestCase187Actor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase187Actor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase187", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase187Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase187", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FlowTestCase187Actor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase187", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase187Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase187", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FlowTestCase187Actor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase187", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase187Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase187", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 194 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<int> __when_expr_3 = f->read(&data[0], 4096, 0);
															#line 194 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase187Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4407 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<FlowTestCase187Actor*>(this)->actor_wait_state = 4;
															#line 194 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase187Actor, 3, int >*>(static_cast<FlowTestCase187Actor*>(this)));
															#line 4412 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 194 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<int> __when_expr_3 = f->read(&data[0], 4096, 0);
															#line 194 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase187Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4423 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<FlowTestCase187Actor*>(this)->actor_wait_state = 4;
															#line 194 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase187Actor, 3, int >*>(static_cast<FlowTestCase187Actor*>(this)));
															#line 4428 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FlowTestCase187Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase187Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase187Actor*>(this)->ActorCallback< FlowTestCase187Actor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase187Actor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase187", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase187Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase187", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FlowTestCase187Actor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase187", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase187Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase187", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FlowTestCase187Actor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase187", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase187Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase187", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(int const& length,int loopDepth) 
	{
															#line 195 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		ASSERT(length == 4096);
															#line 196 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		for( auto c : data ) {
															#line 197 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
			ASSERT(c == '\0');
															#line 4516 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		}
															#line 200 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		f.clear();
															#line 201 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_4 = IAsyncFileSystem::filesystem()->incrementalDeleteFile(filename, true);
															#line 201 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase187Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4524 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<FlowTestCase187Actor*>(this)->actor_wait_state = 5;
															#line 201 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase187Actor, 4, Void >*>(static_cast<FlowTestCase187Actor*>(this)));
															#line 4529 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(int && length,int loopDepth) 
	{
															#line 195 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		ASSERT(length == 4096);
															#line 196 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		for( auto c : data ) {
															#line 197 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
			ASSERT(c == '\0');
															#line 4542 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		}
															#line 200 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		f.clear();
															#line 201 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_4 = IAsyncFileSystem::filesystem()->incrementalDeleteFile(filename, true);
															#line 201 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase187Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4550 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<FlowTestCase187Actor*>(this)->actor_wait_state = 5;
															#line 201 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase187Actor, 4, Void >*>(static_cast<FlowTestCase187Actor*>(this)));
															#line 4555 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(int const& length,int loopDepth) 
	{
		loopDepth = a_body1cont4(length, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(int && length,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(length), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<FlowTestCase187Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase187Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase187Actor*>(this)->ActorCallback< FlowTestCase187Actor, 3, int >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase187Actor, 3, int >*,int const& value) 
	{
		fdb_probe_actor_enter("flowTestCase187", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase187Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase187", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< FlowTestCase187Actor, 3, int >*,int && value) 
	{
		fdb_probe_actor_enter("flowTestCase187", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase187Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase187", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< FlowTestCase187Actor, 3, int >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase187", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase187Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase187", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 202 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (!static_cast<FlowTestCase187Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase187ActorState(); static_cast<FlowTestCase187Actor*>(this)->destroy(); return 0; }
															#line 4639 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		new (&static_cast<FlowTestCase187Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase187ActorState();
		static_cast<FlowTestCase187Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 202 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (!static_cast<FlowTestCase187Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase187ActorState(); static_cast<FlowTestCase187Actor*>(this)->destroy(); return 0; }
															#line 4651 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		new (&static_cast<FlowTestCase187Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase187ActorState();
		static_cast<FlowTestCase187Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<FlowTestCase187Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase187Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase187Actor*>(this)->ActorCallback< FlowTestCase187Actor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase187Actor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase187", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase187Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase187", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< FlowTestCase187Actor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase187", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase187Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase187", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< FlowTestCase187Actor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase187", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase187Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase187", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 187 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	UnitTestParameters params;
															#line 188 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	std::string filename;
															#line 189 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	Reference<IAsyncFile> f;
															#line 191 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	std::array<char, 4096> data;
															#line 4742 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase187()
															#line 187 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
class FlowTestCase187Actor final : public Actor<Void>, public ActorCallback< FlowTestCase187Actor, 0, Reference<IAsyncFile> >, public ActorCallback< FlowTestCase187Actor, 1, Void >, public ActorCallback< FlowTestCase187Actor, 2, Void >, public ActorCallback< FlowTestCase187Actor, 3, int >, public ActorCallback< FlowTestCase187Actor, 4, Void >, public FastAllocated<FlowTestCase187Actor>, public FlowTestCase187ActorState<FlowTestCase187Actor> {
															#line 4747 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase187Actor>::operator new;
	using FastAllocated<FlowTestCase187Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11545412674032951296UL, 16547166953468449792UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase187Actor, 0, Reference<IAsyncFile> >;
friend struct ActorCallback< FlowTestCase187Actor, 1, Void >;
friend struct ActorCallback< FlowTestCase187Actor, 2, Void >;
friend struct ActorCallback< FlowTestCase187Actor, 3, int >;
friend struct ActorCallback< FlowTestCase187Actor, 4, Void >;
															#line 187 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	FlowTestCase187Actor(UnitTestParameters const& params) 
															#line 4768 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase187ActorState<FlowTestCase187Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase187", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13164102787064916480UL, 7257332761839999232UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase187Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase187");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase187", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase187Actor, 0, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FlowTestCase187Actor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FlowTestCase187Actor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< FlowTestCase187Actor, 3, int >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< FlowTestCase187Actor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 187 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
static Future<Void> flowTestCase187( UnitTestParameters const& params ) {
															#line 187 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	return Future<Void>(new FlowTestCase187Actor(params));
															#line 4805 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase187, "/fileio/truncateAndRead")

#line 204 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
