#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
/*
 * NativeAPI.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/NativeAPI.actor.h"

#include <algorithm>
#include <cstdio>
#include <iterator>
#include <limits>
#include <memory>
#include <regex>
#include <string>
#include <unordered_set>
#include <tuple>
#include <utility>
#include <vector>

#include "boost/algorithm/string.hpp"

#include "fdbclient/Knobs.h"
#include "flow/CodeProbe.h"
#include "fmt/format.h"

#include "fdbclient/FDBOptions.g.h"
#include "fdbclient/FDBTypes.h"
#include "fdbrpc/FailureMonitor.h"
#include "fdbrpc/MultiInterface.h"
#include "fdbrpc/TenantInfo.h"

#include "fdbclient/ActorLineageProfiler.h"
#include "fdbclient/AnnotateActor.h"
#include "fdbclient/Atomic.h"
#include "fdbclient/ClusterInterface.h"
#include "fdbclient/ClusterConnectionFile.h"
#include "fdbclient/ClusterConnectionMemoryRecord.h"
#include "fdbclient/CoordinationInterface.h"
#include "fdbclient/CommitTransaction.h"
#include "fdbclient/DatabaseContext.h"
#include "fdbclient/GlobalConfig.actor.h"
#include "fdbclient/IKnobCollection.h"
#include "fdbclient/JsonBuilder.h"
#include "fdbclient/KeyBackedTypes.actor.h"
#include "fdbclient/KeyRangeMap.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/NameLineage.h"
#include "fdbclient/CommitProxyInterface.h"
#include "fdbclient/MonitorLeader.h"
#include "fdbclient/MutationList.h"
#include "fdbclient/ParallelStream.actor.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbclient/SpecialKeySpace.actor.h"
#include "fdbclient/StorageServerInterface.h"
#include "fdbclient/SystemData.h"
#include "fdbclient/Tenant.h"
#include "fdbclient/TenantSpecialKeys.actor.h"
#include "fdbclient/TransactionLineage.h"
#include "fdbclient/versions.h"
#include "fdbrpc/WellKnownEndpoints.h"
#include "fdbrpc/LoadBalance.h"
#include "fdbrpc/Net2FileSystem.h"
#include "fdbrpc/simulator.h"
#include "fdbrpc/sim_validation.h"
#include "flow/Arena.h"
#include "flow/ActorCollection.h"
#include "flow/DeterministicRandom.h"
#include "flow/Error.h"
#include "flow/FastRef.h"
#include "flow/GetSourceVersion.h"
#include "flow/IRandom.h"
#include "flow/Trace.h"
#include "flow/ProtocolVersion.h"
#include "flow/flow.h"
#include "flow/genericactors.actor.h"
#include "flow/Knobs.h"
#include "flow/Platform.h"
#include "flow/SystemMonitor.h"
#include "flow/TLSConfig.actor.h"
#include "fdbclient/Tracing.h"
#include "flow/UnitTest.h"
#include "flow/network.h"
#include "flow/serialize.h"

#ifdef ADDRESS_SANITIZER
#include <sanitizer/lsan_interface.h>
#endif

#ifdef WIN32
#define WIN32_LEAN_AND_MEAN
#include <Windows.h>
#undef min
#undef max
#else
#include <time.h>
#endif
#include "flow/actorcompiler.h" // This must be the last #include.

template class RequestStream<OpenDatabaseRequest, false>;
template struct NetNotifiedQueue<OpenDatabaseRequest, false>;

namespace {

TransactionLineageCollector transactionLineageCollector;
NameLineageCollector nameLineageCollector;

} // namespace

FDB_BOOLEAN_PARAM(TransactionRecordLogInfo);

// Whether or not a request should include the tenant name
FDB_BOOLEAN_PARAM(UseTenant);

NetworkOptions networkOptions;
TLSConfig tlsConfig(TLSEndpointType::CLIENT);

// The default values, TRACE_DEFAULT_ROLL_SIZE and TRACE_DEFAULT_MAX_LOGS_SIZE are located in Trace.h.
NetworkOptions::NetworkOptions()
  : traceRollSize(TRACE_DEFAULT_ROLL_SIZE), traceMaxLogsSize(TRACE_DEFAULT_MAX_LOGS_SIZE), traceLogGroup("default"),
    traceFormat("xml"), traceClockSource("now"), traceInitializeOnSetup(false),
    supportedVersions(new ReferencedObject<Standalone<VectorRef<ClientVersionRef>>>()), runLoopProfilingEnabled(false),
    primaryClient(true) {}

template <>
void addref(DatabaseContext* ptr) {
	ptr->addref();
}
template <>
void delref(DatabaseContext* ptr) {
	ptr->delref();
}

															#line 150 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
namespace {
// This generated class is to be used only via refreshTransaction()
															#line 148 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class RefreshTransactionActor>
															#line 148 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class RefreshTransactionActorState {
															#line 157 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
															#line 148 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	RefreshTransactionActorState(DatabaseContext* const& self,Transaction* const& tr) 
															#line 148 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 148 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : self(self),
															#line 148 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   tr(tr)
															#line 166 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
	{
		fdb_probe_actor_create("refreshTransaction", reinterpret_cast<unsigned long>(this));

	}
	~RefreshTransactionActorState() 
	{
		fdb_probe_actor_destroy("refreshTransaction", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 149 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			*tr = Transaction();
															#line 150 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(0);
															#line 150 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<RefreshTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 185 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RefreshTransactionActor*>(this)->actor_wait_state = 1;
															#line 150 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RefreshTransactionActor, 0, Void >*>(static_cast<RefreshTransactionActor*>(this)));
															#line 190 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RefreshTransactionActorState();
		static_cast<RefreshTransactionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 151 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		*tr = Transaction(Database(Reference<DatabaseContext>::addRef(self)));
															#line 152 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<RefreshTransactionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RefreshTransactionActorState(); static_cast<RefreshTransactionActor*>(this)->destroy(); return 0; }
															#line 215 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<RefreshTransactionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RefreshTransactionActorState();
		static_cast<RefreshTransactionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 151 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		*tr = Transaction(Database(Reference<DatabaseContext>::addRef(self)));
															#line 152 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<RefreshTransactionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RefreshTransactionActorState(); static_cast<RefreshTransactionActor*>(this)->destroy(); return 0; }
															#line 229 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<RefreshTransactionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RefreshTransactionActorState();
		static_cast<RefreshTransactionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RefreshTransactionActor*>(this)->actor_wait_state > 0) static_cast<RefreshTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<RefreshTransactionActor*>(this)->ActorCallback< RefreshTransactionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RefreshTransactionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("refreshTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RefreshTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("refreshTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RefreshTransactionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("refreshTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RefreshTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("refreshTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RefreshTransactionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("refreshTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RefreshTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("refreshTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 148 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	DatabaseContext* self;
															#line 148 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Transaction* tr;
															#line 316 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
};
// This generated class is to be used only via refreshTransaction()
															#line 148 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class RefreshTransactionActor final : public Actor<Void>, public ActorCallback< RefreshTransactionActor, 0, Void >, public FastAllocated<RefreshTransactionActor>, public RefreshTransactionActorState<RefreshTransactionActor> {
															#line 321 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
	using FastAllocated<RefreshTransactionActor>::operator new;
	using FastAllocated<RefreshTransactionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16193964119503484928UL, 17399246601571020544UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RefreshTransactionActor, 0, Void >;
															#line 148 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	RefreshTransactionActor(DatabaseContext* const& self,Transaction* const& tr) 
															#line 338 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		 : Actor<Void>(),
		   RefreshTransactionActorState<RefreshTransactionActor>(self, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("refreshTransaction", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4345345362439766272UL, 3425069992022049280UL);
		ActorExecutionContextHelper __helper(static_cast<RefreshTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("refreshTransaction");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("refreshTransaction", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RefreshTransactionActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 148 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<Void> refreshTransaction( DatabaseContext* const& self, Transaction* const& tr ) {
															#line 148 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Void>(new RefreshTransactionActor(self, tr));
															#line 371 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
}

#line 154 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

// FIXME: get a prototype in a header file, ugh.
															#line 377 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
[[nodiscard]] Future<RangeResult> getWorkerInterfaces( Reference<IClusterConnectionRecord> const& clusterRecord );

#line 157 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

Optional<KeyRangeLocationInfo> DatabaseContext::getCachedLocation(const TenantInfo& tenant,
                                                                  const KeyRef& key,
                                                                  Reverse isBackward) {
	Arena arena;
	KeyRef resolvedKey = key;

	if (tenant.hasTenant()) {
		CODE_PROBE(true, "Database context get cached location with tenant");
		resolvedKey = resolvedKey.withPrefix(tenant.prefix.get(), arena);
	}

	auto range =
	    isBackward ? locationCache.rangeContainingKeyBefore(resolvedKey) : locationCache.rangeContaining(resolvedKey);
	auto& loc = range->value();
	if (loc) {
		// Cache hit: extend expiration time if refresh knob is set
		if (CLIENT_KNOBS->LOCATION_CACHE_ENTRY_REFRESH_TIME > 0.0 && loc->expireTime > 0.0) {
			CODE_PROBE(true, "Location cache hit - refresh expire time");
			loc->expireTime = now() + CLIENT_KNOBS->LOCATION_CACHE_ENTRY_REFRESH_TIME;
		}
		return KeyRangeLocationInfo(toPrefixRelativeRange(range->range(), tenant.prefix), loc);
	}

	return Optional<KeyRangeLocationInfo>();
}

bool DatabaseContext::getCachedLocations(const TenantInfo& tenant,
                                         const KeyRangeRef& range,
                                         std::vector<KeyRangeLocationInfo>& result,
                                         int limit,
                                         Reverse reverse) {
	result.clear();

	Arena arena;
	KeyRangeRef resolvedRange = range;

	if (tenant.hasTenant()) {
		CODE_PROBE(true, "Database context get cached locations with tenant");
		resolvedRange = resolvedRange.withPrefix(tenant.prefix.get(), arena);
	}

	auto begin = locationCache.rangeContaining(resolvedRange.begin);
	auto end = locationCache.rangeContainingKeyBefore(resolvedRange.end);

	loop {
		auto r = reverse ? end : begin;
		if (!r->value()) {
			CODE_PROBE(result.size(), "had some but not all cached locations");
			result.clear();
			return false;
		}
		// Cache hit: extend expiration time if refresh knob is set
		if (CLIENT_KNOBS->LOCATION_CACHE_ENTRY_REFRESH_TIME > 0.0 && r->value()->expireTime > 0.0) {
			CODE_PROBE(true, "Location cache hit2 - refresh expire time");
			r->value()->expireTime = now() + CLIENT_KNOBS->LOCATION_CACHE_ENTRY_REFRESH_TIME;
		}
		result.emplace_back(toPrefixRelativeRange(r->range() & resolvedRange, tenant.prefix), r->value());
		if (result.size() == limit || begin == end) {
			break;
		}

		if (reverse)
			--end;
		else
			++begin;
	}

	return true;
}

Reference<LocationInfo> DatabaseContext::setCachedLocation(const KeyRangeRef& absoluteKeys,
                                                           const std::vector<StorageServerInterface>& servers) {
	std::vector<Reference<ReferencedInterface<StorageServerInterface>>> serverRefs;
	serverRefs.reserve(servers.size());
	for (const auto& interf : servers) {
		serverRefs.push_back(StorageServerInfo::getInterface(this, interf, clientLocality));
	}

	int maxEvictionAttempts = 100, attempts = 0;
	auto loc = makeReference<LocationInfo>(serverRefs);
	// TODO: ideally remove based on TTL expiration times, instead of random
	while (locationCache.size() > locationCacheSize && attempts < maxEvictionAttempts) {
		CODE_PROBE(true, "NativeAPI storage server locationCache entry evicted");
		attempts++;
		auto r = locationCache.randomRange();
		Key begin = r.begin(), end = r.end(); // insert invalidates r, so can't be passed a mere reference into it
		locationCache.insert(KeyRangeRef(begin, end), Reference<LocationInfo>());
	}
	locationCache.insert(absoluteKeys, loc);
	return loc;
}

void DatabaseContext::invalidateCache(const Optional<KeyRef>& tenantPrefix, const KeyRef& key, Reverse isBackward) {
	Arena arena;
	KeyRef resolvedKey = key;
	if (tenantPrefix.present() && !tenantPrefix.get().empty()) {
		CODE_PROBE(true, "Database context invalidate cache for tenant key");
		resolvedKey = resolvedKey.withPrefix(tenantPrefix.get(), arena);
	}

	if (isBackward) {
		locationCache.rangeContainingKeyBefore(resolvedKey)->value() = Reference<LocationInfo>();
	} else {
		locationCache.rangeContaining(resolvedKey)->value() = Reference<LocationInfo>();
	}
}

void DatabaseContext::invalidateCache(const Optional<KeyRef>& tenantPrefix, const KeyRangeRef& keys) {
	Arena arena;
	KeyRangeRef resolvedKeys = keys;
	if (tenantPrefix.present() && !tenantPrefix.get().empty()) {
		CODE_PROBE(true, "Database context invalidate cache for tenant range");
		resolvedKeys = resolvedKeys.withPrefix(tenantPrefix.get(), arena);
	}

	auto rs = locationCache.intersectingRanges(resolvedKeys);
	Key begin = rs.begin().begin(),
	    end = rs.end().begin(); // insert invalidates rs, so can't be passed a mere reference into it
	locationCache.insert(KeyRangeRef(begin, end), Reference<LocationInfo>());
}

void DatabaseContext::setFailedEndpointOnHealthyServer(const Endpoint& endpoint) {
	if (failedEndpointsOnHealthyServersInfo.find(endpoint) == failedEndpointsOnHealthyServersInfo.end()) {
		failedEndpointsOnHealthyServersInfo[endpoint] =
		    EndpointFailureInfo{ .startTime = now(), .lastRefreshTime = now() };
	}
}

void DatabaseContext::updateFailedEndpointRefreshTime(const Endpoint& endpoint) {
	if (failedEndpointsOnHealthyServersInfo.find(endpoint) == failedEndpointsOnHealthyServersInfo.end()) {
		// The endpoint is not failed. Nothing to update.
		return;
	}
	failedEndpointsOnHealthyServersInfo[endpoint].lastRefreshTime = now();
}

Optional<EndpointFailureInfo> DatabaseContext::getEndpointFailureInfo(const Endpoint& endpoint) {
	if (failedEndpointsOnHealthyServersInfo.find(endpoint) == failedEndpointsOnHealthyServersInfo.end()) {
		return Optional<EndpointFailureInfo>();
	}
	return failedEndpointsOnHealthyServersInfo[endpoint];
}

void DatabaseContext::clearFailedEndpointOnHealthyServer(const Endpoint& endpoint) {
	failedEndpointsOnHealthyServersInfo.erase(endpoint);
}

Future<Void> DatabaseContext::onProxiesChanged() {
	backoffDelay = 0.0;
	return this->proxiesChangeTrigger.onTrigger();
}

bool DatabaseContext::sampleReadTags() const {
	double sampleRate = globalConfig->get(transactionTagSampleRate, CLIENT_KNOBS->READ_TAG_SAMPLE_RATE);
	return sampleRate > 0 && deterministicRandom()->random01() <= sampleRate;
}

bool DatabaseContext::sampleOnCost(uint64_t cost) const {
	double sampleCost = globalConfig->get<double>(transactionTagSampleCost, CLIENT_KNOBS->COMMIT_SAMPLE_COST);
	if (sampleCost <= 0)
		return false;
	return deterministicRandom()->random01() <= (double)cost / sampleCost;
}

void validateOptionValuePresent(Optional<StringRef> value) {
	if (!value.present()) {
		throw invalid_option_value();
	}
}

void validateOptionValueNotPresent(Optional<StringRef> value) {
	if (value.present() && value.get().size() > 0) {
		throw invalid_option_value();
	}
}

int64_t extractIntOption(Optional<StringRef> value, int64_t minValue, int64_t maxValue) {
	validateOptionValuePresent(value);
	if (value.get().size() != 8) {
		throw invalid_option_value();
	}

	int64_t passed = *((int64_t*)(value.get().begin()));
	if (passed > maxValue || passed < minValue) {
		throw invalid_option_value();
	}

	return passed;
}

uint64_t extractHexOption(StringRef value) {
	char* end;
	uint64_t id = strtoull(value.toString().c_str(), &end, 16);
	if (*end)
		throw invalid_option_value();
	return id;
}

void DatabaseContext::setOption(FDBDatabaseOptions::Option option, Optional<StringRef> value) {
	int defaultFor = FDBDatabaseOptions::optionInfo.getMustExist(option).defaultFor;
	if (defaultFor >= 0) {
		ASSERT(FDBTransactionOptions::optionInfo.find((FDBTransactionOptions::Option)defaultFor) !=
		       FDBTransactionOptions::optionInfo.end());
		TraceEvent(SevDebug, "DatabaseContextSetPersistentOption").detail("Option", option).detail("Value", value);
		transactionDefaults.addOption((FDBTransactionOptions::Option)defaultFor, value.castTo<Standalone<StringRef>>());
	} else {
		switch (option) {
		case FDBDatabaseOptions::LOCATION_CACHE_SIZE:
			locationCacheSize = (int)extractIntOption(value, 0, std::numeric_limits<int>::max());
			break;
		case FDBDatabaseOptions::MACHINE_ID:
			clientLocality =
			    LocalityData(clientLocality.processId(),
			                 value.present() ? Standalone<StringRef>(value.get()) : Optional<Standalone<StringRef>>(),
			                 clientLocality.machineId(),
			                 clientLocality.dcId());
			if (clientInfo->get().commitProxies.size())
				commitProxies = makeReference<CommitProxyInfo>(clientInfo->get().commitProxies);
			if (clientInfo->get().grvProxies.size())
				grvProxies = makeReference<GrvProxyInfo>(clientInfo->get().grvProxies, BalanceOnRequests::True);
			server_interf.clear();
			locationCache.insert(allKeys, Reference<LocationInfo>());
			break;
		case FDBDatabaseOptions::MAX_WATCHES:
			maxOutstandingWatches = (int)extractIntOption(value, 0, CLIENT_KNOBS->ABSOLUTE_MAX_WATCHES);
			break;
		case FDBDatabaseOptions::DATACENTER_ID:
			clientLocality =
			    LocalityData(clientLocality.processId(),
			                 clientLocality.zoneId(),
			                 clientLocality.machineId(),
			                 value.present() ? Standalone<StringRef>(value.get()) : Optional<Standalone<StringRef>>());
			if (clientInfo->get().commitProxies.size())
				commitProxies = makeReference<CommitProxyInfo>(clientInfo->get().commitProxies);
			if (clientInfo->get().grvProxies.size())
				grvProxies = makeReference<GrvProxyInfo>(clientInfo->get().grvProxies, BalanceOnRequests::True);
			server_interf.clear();
			locationCache.insert(allKeys, Reference<LocationInfo>());
			break;
		case FDBDatabaseOptions::SNAPSHOT_RYW_ENABLE:
			validateOptionValueNotPresent(value);
			snapshotRywEnabled++;
			break;
		case FDBDatabaseOptions::SNAPSHOT_RYW_DISABLE:
			validateOptionValueNotPresent(value);
			snapshotRywEnabled--;
			break;
		case FDBDatabaseOptions::USE_CONFIG_DATABASE:
			validateOptionValueNotPresent(value);
			useConfigDatabase = true;
			break;
		case FDBDatabaseOptions::TEST_CAUSAL_READ_RISKY:
			verifyCausalReadsProp = double(extractIntOption(value, 0, 100)) / 100.0;
			break;
		default:
			break;
		}
	}
}

void DatabaseContext::increaseWatchCounter() {
	if (outstandingWatches >= maxOutstandingWatches)
		throw too_many_watches();

	++outstandingWatches;
}

void DatabaseContext::decreaseWatchCounter() {
	--outstandingWatches;
	ASSERT(outstandingWatches >= 0);
}

Future<Void> DatabaseContext::onConnected() const {
	return connected;
}

															#line 658 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
namespace {
// This generated class is to be used only via switchConnectionRecordImpl()
															#line 434 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class SwitchConnectionRecordImplActor>
															#line 434 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class SwitchConnectionRecordImplActorState {
															#line 665 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
															#line 434 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	SwitchConnectionRecordImplActorState(Reference<IClusterConnectionRecord> const& connRecord,DatabaseContext* const& self) 
															#line 434 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 434 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : connRecord(connRecord),
															#line 434 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   self(self)
															#line 674 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
	{
		fdb_probe_actor_create("switchConnectionRecordImpl", reinterpret_cast<unsigned long>(this));

	}
	~SwitchConnectionRecordImplActorState() 
	{
		fdb_probe_actor_destroy("switchConnectionRecordImpl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 436 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			CODE_PROBE(true, "Switch connection file");
															#line 437 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			TraceEvent("SwitchConnectionRecord") .detail("ClusterFile", connRecord->toString()) .detail("ConnectionString", connRecord->getConnectionString().toString());
															#line 442 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			self->commitProxies.clear();
															#line 443 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			self->grvProxies.clear();
															#line 444 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			self->minAcceptableReadVersion = std::numeric_limits<Version>::max();
															#line 445 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			self->invalidateCache({}, allKeys);
															#line 447 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			self->ssVersionVectorCache.clear();
															#line 449 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			auto clearedClientInfo = self->clientInfo->get();
															#line 450 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			clearedClientInfo.commitProxies.clear();
															#line 451 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			clearedClientInfo.grvProxies.clear();
															#line 452 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			clearedClientInfo.id = deterministicRandom()->randomUniqueID();
															#line 453 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			self->clientInfo->set(clearedClientInfo);
															#line 454 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			self->connectionRecord->set(connRecord);
															#line 456 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			db = Database(Reference<DatabaseContext>::addRef(self));
															#line 457 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			tr = Transaction(db);
															#line 458 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			;
															#line 719 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SwitchConnectionRecordImplActorState();
		static_cast<SwitchConnectionRecordImplActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 459 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_LOCK_AWARE);
															#line 749 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		try {
															#line 461 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			TraceEvent("SwitchConnectionRecordAttemptingGRV").log();
															#line 462 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Version> __when_expr_0 = tr.getReadVersion();
															#line 462 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<SwitchConnectionRecordImplActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 757 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SwitchConnectionRecordImplActor*>(this)->actor_wait_state = 1;
															#line 462 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SwitchConnectionRecordImplActor, 0, Version >*>(static_cast<SwitchConnectionRecordImplActor*>(this)));
															#line 762 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 470 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			TraceEvent("SwitchConnectionRecordError").detail("Error", e.what());
															#line 471 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 471 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<SwitchConnectionRecordImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 788 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<SwitchConnectionRecordImplActor*>(this)->actor_wait_state = 2;
															#line 471 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SwitchConnectionRecordImplActor, 1, Void >*>(static_cast<SwitchConnectionRecordImplActor*>(this)));
															#line 793 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version const& v,int loopDepth) 
	{
															#line 463 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		TraceEvent("SwitchConnectionRecordGotRV") .detail("ReadVersion", v) .detail("MinAcceptableReadVersion", self->minAcceptableReadVersion);
															#line 466 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(self->minAcceptableReadVersion != std::numeric_limits<Version>::max());
															#line 467 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		self->connectionFileChangedTrigger.trigger();
															#line 468 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<SwitchConnectionRecordImplActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SwitchConnectionRecordImplActorState(); static_cast<SwitchConnectionRecordImplActor*>(this)->destroy(); return 0; }
															#line 814 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<SwitchConnectionRecordImplActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SwitchConnectionRecordImplActorState();
		static_cast<SwitchConnectionRecordImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version && v,int loopDepth) 
	{
															#line 463 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		TraceEvent("SwitchConnectionRecordGotRV") .detail("ReadVersion", v) .detail("MinAcceptableReadVersion", self->minAcceptableReadVersion);
															#line 466 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(self->minAcceptableReadVersion != std::numeric_limits<Version>::max());
															#line 467 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		self->connectionFileChangedTrigger.trigger();
															#line 468 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<SwitchConnectionRecordImplActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SwitchConnectionRecordImplActorState(); static_cast<SwitchConnectionRecordImplActor*>(this)->destroy(); return 0; }
															#line 832 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<SwitchConnectionRecordImplActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SwitchConnectionRecordImplActorState();
		static_cast<SwitchConnectionRecordImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Version const& v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(v, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Version && v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(v), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SwitchConnectionRecordImplActor*>(this)->actor_wait_state > 0) static_cast<SwitchConnectionRecordImplActor*>(this)->actor_wait_state = 0;
		static_cast<SwitchConnectionRecordImplActor*>(this)->ActorCallback< SwitchConnectionRecordImplActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< SwitchConnectionRecordImplActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("switchConnectionRecordImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SwitchConnectionRecordImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("switchConnectionRecordImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SwitchConnectionRecordImplActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("switchConnectionRecordImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SwitchConnectionRecordImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("switchConnectionRecordImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SwitchConnectionRecordImplActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("switchConnectionRecordImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SwitchConnectionRecordImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("switchConnectionRecordImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SwitchConnectionRecordImplActor*>(this)->actor_wait_state > 0) static_cast<SwitchConnectionRecordImplActor*>(this)->actor_wait_state = 0;
		static_cast<SwitchConnectionRecordImplActor*>(this)->ActorCallback< SwitchConnectionRecordImplActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SwitchConnectionRecordImplActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("switchConnectionRecordImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SwitchConnectionRecordImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("switchConnectionRecordImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SwitchConnectionRecordImplActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("switchConnectionRecordImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SwitchConnectionRecordImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("switchConnectionRecordImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SwitchConnectionRecordImplActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("switchConnectionRecordImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SwitchConnectionRecordImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("switchConnectionRecordImpl", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 434 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reference<IClusterConnectionRecord> connRecord;
															#line 434 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	DatabaseContext* self;
															#line 456 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Database db;
															#line 457 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Transaction tr;
															#line 1010 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
};
// This generated class is to be used only via switchConnectionRecordImpl()
															#line 434 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class SwitchConnectionRecordImplActor final : public Actor<Void>, public ActorCallback< SwitchConnectionRecordImplActor, 0, Version >, public ActorCallback< SwitchConnectionRecordImplActor, 1, Void >, public FastAllocated<SwitchConnectionRecordImplActor>, public SwitchConnectionRecordImplActorState<SwitchConnectionRecordImplActor> {
															#line 1015 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
	using FastAllocated<SwitchConnectionRecordImplActor>::operator new;
	using FastAllocated<SwitchConnectionRecordImplActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5666213116368945664UL, 1353518157654684416UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SwitchConnectionRecordImplActor, 0, Version >;
friend struct ActorCallback< SwitchConnectionRecordImplActor, 1, Void >;
															#line 434 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	SwitchConnectionRecordImplActor(Reference<IClusterConnectionRecord> const& connRecord,DatabaseContext* const& self) 
															#line 1033 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		 : Actor<Void>(),
		   SwitchConnectionRecordImplActorState<SwitchConnectionRecordImplActor>(connRecord, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("switchConnectionRecordImpl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7312653141277564928UL, 2692131377335283456UL);
		ActorExecutionContextHelper __helper(static_cast<SwitchConnectionRecordImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("switchConnectionRecordImpl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("switchConnectionRecordImpl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SwitchConnectionRecordImplActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SwitchConnectionRecordImplActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 434 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] static Future<Void> switchConnectionRecordImpl( Reference<IClusterConnectionRecord> const& connRecord, DatabaseContext* const& self ) {
															#line 434 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Void>(new SwitchConnectionRecordImplActor(connRecord, self));
															#line 1067 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
}

#line 475 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

Reference<IClusterConnectionRecord> DatabaseContext::getConnectionRecord() {
	if (connectionRecord) {
		return connectionRecord->get();
	}
	return Reference<IClusterConnectionRecord>();
}

Future<Void> DatabaseContext::switchConnectionRecord(Reference<IClusterConnectionRecord> standby) {
	ASSERT(switchable);
	return switchConnectionRecordImpl(standby, this);
}

Future<Void> DatabaseContext::connectionFileChanged() {
	return connectionFileChangedTrigger.onTrigger();
}

void DatabaseContext::expireThrottles() {
	for (auto& priorityItr : throttledTags) {
		for (auto tagItr = priorityItr.second.begin(); tagItr != priorityItr.second.end();) {
			if (tagItr->second.expired()) {
				CODE_PROBE(true, "Expiring client throttle");
				tagItr = priorityItr.second.erase(tagItr);
			} else {
				++tagItr;
			}
		}
	}
}

// Initialize tracing for FDB client
//
// connRecord is necessary for determining the local IP, which is then included in the trace
// file name, and also used to annotate all trace events.
//
// If trace_initialize_on_setup is not set, tracing is initialized when opening a database.
// In that case we can immediately determine the IP. Thus, we can use the IP in the
// trace file name and annotate all events with it.
//
// If trace_initialize_on_setup network option is set, tracing is at first initialized without
// connRecord and thus without the local IP. In that case we cannot use the local IP in the
// trace file names. The IP is then provided by a repeated call to initializeClientTracing
// when opening a database. All tracing events from this point are annotated with the local IP
//
// If tracing initialization is completed, further calls to initializeClientTracing are ignored
void initializeClientTracing(Reference<IClusterConnectionRecord> connRecord, Optional<int> apiVersion) {
	if (!networkOptions.traceDirectory.present()) {
		return;
	}

	bool initialized = traceFileIsOpen();
	if (initialized && (isTraceLocalAddressSet() || !connRecord)) {
		// Tracing initialization is completed
		return;
	}

	// Network must be created before initializing tracing
	ASSERT(g_network);

	Optional<NetworkAddress> localAddress;
	if (connRecord) {
		auto publicIP = connRecord->getConnectionString().determineLocalSourceIP();
		localAddress = NetworkAddress(publicIP, ::getpid());
	}
	platform::ImageInfo imageInfo = platform::getImageInfo();

	if (initialized) {
		// Tracing already initialized, just need to update the IP address
		setTraceLocalAddress(localAddress.get());
		TraceEvent("ClientStart")
		    .detail("SourceVersion", getSourceVersion())
		    .detail("Version", FDB_VT_VERSION)
		    .detail("PackageName", FDB_VT_PACKAGE_NAME)
		    .detailf("ActualTime", "%lld", DEBUG_DETERMINISM ? 0 : time(nullptr))
		    .detail("ApiVersion", apiVersion)
		    .detail("ClientLibrary", imageInfo.fileName)
		    .detailf("ImageOffset", "%p", imageInfo.offset)
		    .detail("Primary", networkOptions.primaryClient)
		    .trackLatest("ClientStart");
	} else {
		// Initialize tracing
		selectTraceFormatter(networkOptions.traceFormat);
		selectTraceClockSource(networkOptions.traceClockSource);
		addUniversalTraceField("ClientDescription",
		                       format("%s-%s-%" PRIu64,
		                              networkOptions.primaryClient ? "primary" : "external",
		                              FDB_VT_VERSION,
		                              deterministicRandom()->randomUInt64()));

		std::string identifier = networkOptions.traceFileIdentifier;
		openTraceFile(localAddress,
		              networkOptions.traceRollSize,
		              networkOptions.traceMaxLogsSize,
		              networkOptions.traceDirectory.get(),
		              "trace",
		              networkOptions.traceLogGroup,
		              identifier,
		              networkOptions.tracePartialFileSuffix,
		              InitializeTraceMetrics::True);

		TraceEvent("ClientStart")
		    .detail("SourceVersion", getSourceVersion())
		    .detail("Version", FDB_VT_VERSION)
		    .detail("PackageName", FDB_VT_PACKAGE_NAME)
		    .detailf("ActualTime", "%lld", DEBUG_DETERMINISM ? 0 : time(nullptr))
		    .detail("ApiVersion", apiVersion)
		    .detail("ClientLibrary", imageInfo.fileName)
		    .detailf("ImageOffset", "%p", imageInfo.offset)
		    .detail("Primary", networkOptions.primaryClient)
		    .trackLatest("ClientStart");

		g_network->initMetrics();
		FlowTransport::transport().initMetrics();
	}

	// Initialize system monitoring once the local IP is available
	if (localAddress.present()) {
		initializeSystemMonitorMachineState(SystemMonitorMachineState(IPAddress(localAddress.get().ip)));
		systemMonitor();
		uncancellable(recurring(&systemMonitor, CLIENT_KNOBS->SYSTEM_MONITOR_INTERVAL, TaskPriority::FlushTrace));
	}
}

// Creates a database object that represents a connection to a cluster
// This constructor uses a preallocated DatabaseContext that may have been created
// on another thread
Database Database::createDatabase(Reference<IClusterConnectionRecord> connRecord,
                                  int apiVersion,
                                  IsInternal internal,
                                  LocalityData const& clientLocality,
                                  DatabaseContext* preallocatedDb) {
	if (!g_network)
		throw network_not_setup();

	ASSERT(TraceEvent::isNetworkThread());

	initializeClientTracing(connRecord, apiVersion);

	g_network->initTLS();

	auto clientInfo = makeReference<AsyncVar<ClientDBInfo>>();
	auto coordinator = makeReference<AsyncVar<Optional<ClientLeaderRegInterface>>>();
	auto connectionRecord = makeReference<AsyncVar<Reference<IClusterConnectionRecord>>>();
	connectionRecord->set(connRecord);
	Future<Void> clientInfoMonitor = monitorProxies(connectionRecord,
	                                                clientInfo,
	                                                coordinator,
	                                                networkOptions.supportedVersions,
	                                                StringRef(networkOptions.traceLogGroup),
	                                                internal);

	DatabaseContext* db;
	if (preallocatedDb) {
		db = new (preallocatedDb) DatabaseContext(connectionRecord,
		                                          clientInfo,
		                                          coordinator,
		                                          clientInfoMonitor,
		                                          TaskPriority::DefaultEndpoint,
		                                          clientLocality,
		                                          EnableLocalityLoadBalance::True,
		                                          LockAware::False,
		                                          internal,
		                                          apiVersion,
		                                          IsSwitchable::True);
	} else {
		db = new DatabaseContext(connectionRecord,
		                         clientInfo,
		                         coordinator,
		                         clientInfoMonitor,
		                         TaskPriority::DefaultEndpoint,
		                         clientLocality,
		                         EnableLocalityLoadBalance::True,
		                         LockAware::False,
		                         internal,
		                         apiVersion,
		                         IsSwitchable::True);
	}

	auto database = Database(db);
	database->globalConfig->init(Reference<AsyncVar<ClientDBInfo> const>(clientInfo),
	                             std::addressof(clientInfo->get()));
	database->globalConfig->trigger(samplingFrequency, samplingProfilerUpdateFrequency);
	database->globalConfig->trigger(samplingWindow, samplingProfilerUpdateWindow);

	TraceEvent("ConnectToDatabase", database->dbId)
	    .detail("Version", FDB_VT_VERSION)
	    .detail("ClusterFile", connRecord ? connRecord->toString() : "None")
	    .detail("ConnectionString", connRecord ? connRecord->getConnectionString().toString() : "None")
	    .detail("ClientLibrary", platform::getImageInfo().fileName)
	    .detail("Primary", networkOptions.primaryClient)
	    .detail("Internal", internal)
	    .trackLatest(database->connectToDatabaseEventCacheHolder.trackingKey);

	return database;
}

Database Database::createDatabase(std::string connFileName,
                                  int apiVersion,
                                  IsInternal internal,
                                  LocalityData const& clientLocality) {
	Reference<IClusterConnectionRecord> rccr = ClusterConnectionFile::openOrDefault(connFileName);
	return Database::createDatabase(rccr, apiVersion, internal, clientLocality);
}

Database Database::createSimulatedExtraDatabase(std::string connectionString, Optional<TenantName> defaultTenant) {
	auto extraFile = makeReference<ClusterConnectionMemoryRecord>(ClusterConnectionString(connectionString));
	Database db = Database::createDatabase(extraFile, ApiVersion::LATEST_VERSION);
	db->defaultTenant = defaultTenant;
	return db;
}

const UniqueOrderedOptionList<FDBTransactionOptions>& Database::getTransactionDefaults() const {
	ASSERT(db);
	return db->transactionDefaults;
}

void setNetworkOption(FDBNetworkOptions::Option option, Optional<StringRef> value) {
	std::regex identifierRegex("^[a-zA-Z0-9_]*$");
	switch (option) {
	// SOMEDAY: If the network is already started, should these five throw an error?
	case FDBNetworkOptions::TRACE_ENABLE:
		networkOptions.traceDirectory = value.present() ? value.get().toString() : "";
		break;
	case FDBNetworkOptions::TRACE_ROLL_SIZE:
		validateOptionValuePresent(value);
		networkOptions.traceRollSize = extractIntOption(value, 0, std::numeric_limits<int64_t>::max());
		break;
	case FDBNetworkOptions::TRACE_MAX_LOGS_SIZE:
		validateOptionValuePresent(value);
		networkOptions.traceMaxLogsSize = extractIntOption(value, 0, std::numeric_limits<int64_t>::max());
		break;
	case FDBNetworkOptions::TRACE_FORMAT:
		validateOptionValuePresent(value);
		networkOptions.traceFormat = value.get().toString();
		if (!validateTraceFormat(networkOptions.traceFormat)) {
			fprintf(stderr, "Unrecognized trace format: `%s'\n", networkOptions.traceFormat.c_str());
			throw invalid_option_value();
		}
		break;
	case FDBNetworkOptions::TRACE_FILE_IDENTIFIER:
		validateOptionValuePresent(value);
		networkOptions.traceFileIdentifier = value.get().toString();
		if (networkOptions.traceFileIdentifier.length() > CLIENT_KNOBS->TRACE_LOG_FILE_IDENTIFIER_MAX_LENGTH) {
			fprintf(stderr, "Trace file identifier provided is too long.\n");
			throw invalid_option_value();
		} else if (!std::regex_match(networkOptions.traceFileIdentifier, identifierRegex)) {
			fprintf(stderr, "Trace file identifier should only contain alphanumerics and underscores.\n");
			throw invalid_option_value();
		}
		break;

	case FDBNetworkOptions::TRACE_LOG_GROUP:
		if (value.present()) {
			if (traceFileIsOpen()) {
				setTraceLogGroup(value.get().toString());
			} else {
				networkOptions.traceLogGroup = value.get().toString();
			}
		}
		break;
	case FDBNetworkOptions::TRACE_CLOCK_SOURCE:
		validateOptionValuePresent(value);
		networkOptions.traceClockSource = value.get().toString();
		if (!validateTraceClockSource(networkOptions.traceClockSource)) {
			fprintf(stderr, "Unrecognized trace clock source: `%s'\n", networkOptions.traceClockSource.c_str());
			throw invalid_option_value();
		}
		break;
	case FDBNetworkOptions::TRACE_PARTIAL_FILE_SUFFIX:
		validateOptionValuePresent(value);
		networkOptions.tracePartialFileSuffix = value.get().toString();
		break;
	case FDBNetworkOptions::TRACE_INITIALIZE_ON_SETUP:
		networkOptions.traceInitializeOnSetup = true;
		break;
	case FDBNetworkOptions::KNOB: {
		validateOptionValuePresent(value);

		std::string optionValue = value.get().toString();
		TraceEvent("SetKnob").detail("KnobString", optionValue);

		size_t eq = optionValue.find_first_of('=');
		if (eq == optionValue.npos) {
			TraceEvent(SevWarnAlways, "InvalidKnobString").detail("KnobString", optionValue);
			throw invalid_option_value();
		}

		std::string knobName = optionValue.substr(0, eq);
		std::string knobValueString = optionValue.substr(eq + 1);

		try {
			auto knobValue = IKnobCollection::parseKnobValue(knobName, knobValueString, IKnobCollection::Type::CLIENT);
			if (g_network) {
				IKnobCollection::getMutableGlobalKnobCollection().setKnob(knobName, knobValue);
			} else {
				networkOptions.knobs[knobName] = knobValue;
			}
		} catch (Error& e) {
			TraceEvent(SevWarnAlways, "UnrecognizedKnob").detail("Knob", knobName.c_str());
			fprintf(stderr, "FoundationDB client ignoring unrecognized knob option '%s'\n", knobName.c_str());
		}
		break;
	}
	case FDBNetworkOptions::TLS_PLUGIN:
		validateOptionValuePresent(value);
		break;
	case FDBNetworkOptions::TLS_CERT_PATH:
		validateOptionValuePresent(value);
		tlsConfig.setCertificatePath(value.get().toString());
		break;
	case FDBNetworkOptions::TLS_CERT_BYTES: {
		validateOptionValuePresent(value);
		tlsConfig.setCertificateBytes(value.get().toString());
		break;
	}
	case FDBNetworkOptions::TLS_CA_PATH: {
		validateOptionValuePresent(value);
		tlsConfig.setCAPath(value.get().toString());
		break;
	}
	case FDBNetworkOptions::TLS_CA_BYTES: {
		validateOptionValuePresent(value);
		tlsConfig.setCABytes(value.get().toString());
		break;
	}
	case FDBNetworkOptions::TLS_PASSWORD:
		validateOptionValuePresent(value);
		tlsConfig.setPassword(value.get().toString());
		break;
	case FDBNetworkOptions::TLS_KEY_PATH:
		validateOptionValuePresent(value);
		tlsConfig.setKeyPath(value.get().toString());
		break;
	case FDBNetworkOptions::TLS_KEY_BYTES: {
		validateOptionValuePresent(value);
		tlsConfig.setKeyBytes(value.get().toString());
		break;
	}
	case FDBNetworkOptions::TLS_VERIFY_PEERS:
		validateOptionValuePresent(value);
		tlsConfig.clearVerifyPeers();
		tlsConfig.addVerifyPeers(value.get().toString());
		break;
	case FDBNetworkOptions::TLS_DISABLE_PLAINTEXT_CONNECTION:
		tlsConfig.setDisablePlainTextConnection(true);
		break;
	case FDBNetworkOptions::CLIENT_BUGGIFY_ENABLE:
		enableClientBuggify();
		break;
	case FDBNetworkOptions::CLIENT_BUGGIFY_DISABLE:
		disableClientBuggify();
		break;
	case FDBNetworkOptions::CLIENT_BUGGIFY_SECTION_ACTIVATED_PROBABILITY:
		validateOptionValuePresent(value);
		clearClientBuggifySections();
		P_CLIENT_BUGGIFIED_SECTION_ACTIVATED = double(extractIntOption(value, 0, 100)) / 100.0;
		break;
	case FDBNetworkOptions::CLIENT_BUGGIFY_SECTION_FIRED_PROBABILITY:
		validateOptionValuePresent(value);
		P_CLIENT_BUGGIFIED_SECTION_FIRES = double(extractIntOption(value, 0, 100)) / 100.0;
		break;
	case FDBNetworkOptions::DISABLE_CLIENT_STATISTICS_LOGGING:
		validateOptionValueNotPresent(value);
		networkOptions.logClientInfo = false;
		break;
	case FDBNetworkOptions::SUPPORTED_CLIENT_VERSIONS: {
		// The multi-version API should be providing us these guarantees
		ASSERT(g_network);
		ASSERT(value.present());

		Standalone<VectorRef<ClientVersionRef>> supportedVersions;
		std::vector<StringRef> supportedVersionsStrings = value.get().splitAny(";"_sr);
		for (StringRef versionString : supportedVersionsStrings) {
#ifdef ADDRESS_SANITIZER
			__lsan_disable();
#endif
			// LSAN reports that we leak this allocation in client
			// tests, but I cannot seem to figure out why. AFAICT
			// it's not actually leaking. If it is a leak, it's only a few bytes.
			supportedVersions.push_back_deep(supportedVersions.arena(), ClientVersionRef(versionString));
#ifdef ADDRESS_SANITIZER
			__lsan_enable();
#endif
		}

		ASSERT(supportedVersions.size() > 0);
		networkOptions.supportedVersions->set(supportedVersions);

		break;
	}
	case FDBNetworkOptions::ENABLE_RUN_LOOP_PROFILING: // Same as ENABLE_SLOW_TASK_PROFILING
		validateOptionValueNotPresent(value);
		networkOptions.runLoopProfilingEnabled = true;
		break;
	case FDBNetworkOptions::DISTRIBUTED_CLIENT_TRACER: {
		validateOptionValuePresent(value);
		std::string tracer = value.get().toString();
		if (tracer == "none" || tracer == "disabled") {
			openTracer(TracerType::DISABLED);
		} else if (tracer == "logfile" || tracer == "file" || tracer == "log_file") {
			openTracer(TracerType::LOG_FILE);
		} else if (tracer == "network_lossy") {
			openTracer(TracerType::NETWORK_LOSSY);
		} else {
			fprintf(stderr, "ERROR: Unknown or unsupported tracer: `%s'", tracer.c_str());
			throw invalid_option_value();
		}
		break;
	}
	case FDBNetworkOptions::EXTERNAL_CLIENT:
		networkOptions.primaryClient = false;
		break;
	default:
		break;
	}
}

// update the network busyness on a 1s cadence
															#line 1489 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
namespace {
// This generated class is to be used only via monitorNetworkBusyness()
															#line 893 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class MonitorNetworkBusynessActor>
															#line 893 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class MonitorNetworkBusynessActorState {
															#line 1496 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
															#line 893 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	MonitorNetworkBusynessActorState() 
															#line 893 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 894 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : prevTime(now())
															#line 1503 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
	{
		fdb_probe_actor_create("monitorNetworkBusyness", reinterpret_cast<unsigned long>(this));

	}
	~MonitorNetworkBusynessActorState() 
	{
		fdb_probe_actor_destroy("monitorNetworkBusyness", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 895 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			;
															#line 1518 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorNetworkBusynessActorState();
		static_cast<MonitorNetworkBusynessActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 896 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(CLIENT_KNOBS->NETWORK_BUSYNESS_MONITOR_INTERVAL, TaskPriority::FlushTrace);
															#line 896 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<MonitorNetworkBusynessActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1550 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<MonitorNetworkBusynessActor*>(this)->actor_wait_state = 1;
															#line 896 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorNetworkBusynessActor, 0, Void >*>(static_cast<MonitorNetworkBusynessActor*>(this)));
															#line 1555 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 897 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		double elapsed = now() - prevTime;
															#line 898 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		prevTime = now();
															#line 899 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		struct NetworkMetrics::PriorityStats& tracker = g_network->networkInfo.metrics.starvationTrackerNetworkBusyness;
															#line 901 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (tracker.active)
															#line 1570 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 902 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			tracker.duration += now() - tracker.windowedTimer;
															#line 903 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			tracker.maxDuration = std::max(tracker.maxDuration, now() - tracker.timer);
															#line 904 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			tracker.windowedTimer = now();
															#line 1578 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 907 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		double busyFraction = std::min(elapsed, tracker.duration) / elapsed;
															#line 915 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		double burstiness = 0;
															#line 916 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (CLIENT_KNOBS->BUSYNESS_SPIKE_START_THRESHOLD >= 0 && CLIENT_KNOBS->BUSYNESS_SPIKE_SATURATED_THRESHOLD >= CLIENT_KNOBS->BUSYNESS_SPIKE_START_THRESHOLD)
															#line 1586 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 918 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			burstiness = std::min(1.0, std::max(0.0, tracker.maxDuration - CLIENT_KNOBS->BUSYNESS_SPIKE_START_THRESHOLD) / std::max(1e-6, CLIENT_KNOBS->BUSYNESS_SPIKE_SATURATED_THRESHOLD - CLIENT_KNOBS->BUSYNESS_SPIKE_START_THRESHOLD));
															#line 1590 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 925 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		g_network->networkInfo.metrics.networkBusyness = std::max(busyFraction, burstiness);
															#line 927 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		tracker.duration = 0;
															#line 928 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		tracker.maxDuration = 0;
															#line 1598 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 897 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		double elapsed = now() - prevTime;
															#line 898 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		prevTime = now();
															#line 899 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		struct NetworkMetrics::PriorityStats& tracker = g_network->networkInfo.metrics.starvationTrackerNetworkBusyness;
															#line 901 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (tracker.active)
															#line 1613 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 902 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			tracker.duration += now() - tracker.windowedTimer;
															#line 903 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			tracker.maxDuration = std::max(tracker.maxDuration, now() - tracker.timer);
															#line 904 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			tracker.windowedTimer = now();
															#line 1621 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 907 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		double busyFraction = std::min(elapsed, tracker.duration) / elapsed;
															#line 915 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		double burstiness = 0;
															#line 916 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (CLIENT_KNOBS->BUSYNESS_SPIKE_START_THRESHOLD >= 0 && CLIENT_KNOBS->BUSYNESS_SPIKE_SATURATED_THRESHOLD >= CLIENT_KNOBS->BUSYNESS_SPIKE_START_THRESHOLD)
															#line 1629 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 918 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			burstiness = std::min(1.0, std::max(0.0, tracker.maxDuration - CLIENT_KNOBS->BUSYNESS_SPIKE_START_THRESHOLD) / std::max(1e-6, CLIENT_KNOBS->BUSYNESS_SPIKE_SATURATED_THRESHOLD - CLIENT_KNOBS->BUSYNESS_SPIKE_START_THRESHOLD));
															#line 1633 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 925 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		g_network->networkInfo.metrics.networkBusyness = std::max(busyFraction, burstiness);
															#line 927 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		tracker.duration = 0;
															#line 928 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		tracker.maxDuration = 0;
															#line 1641 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorNetworkBusynessActor*>(this)->actor_wait_state > 0) static_cast<MonitorNetworkBusynessActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorNetworkBusynessActor*>(this)->ActorCallback< MonitorNetworkBusynessActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorNetworkBusynessActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorNetworkBusyness", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorNetworkBusynessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorNetworkBusyness", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorNetworkBusynessActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorNetworkBusyness", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorNetworkBusynessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorNetworkBusyness", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorNetworkBusynessActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorNetworkBusyness", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorNetworkBusynessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorNetworkBusyness", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 894 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	double prevTime;
															#line 1723 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
};
// This generated class is to be used only via monitorNetworkBusyness()
															#line 893 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class MonitorNetworkBusynessActor final : public Actor<Void>, public ActorCallback< MonitorNetworkBusynessActor, 0, Void >, public FastAllocated<MonitorNetworkBusynessActor>, public MonitorNetworkBusynessActorState<MonitorNetworkBusynessActor> {
															#line 1728 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
	using FastAllocated<MonitorNetworkBusynessActor>::operator new;
	using FastAllocated<MonitorNetworkBusynessActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17055148350574476032UL, 5080492995315083264UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorNetworkBusynessActor, 0, Void >;
															#line 893 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	MonitorNetworkBusynessActor() 
															#line 1745 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		 : Actor<Void>(),
		   MonitorNetworkBusynessActorState<MonitorNetworkBusynessActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorNetworkBusyness", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9706183877542601984UL, 10068029726573410048UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorNetworkBusynessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorNetworkBusyness");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorNetworkBusyness", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorNetworkBusynessActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 893 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<Void> monitorNetworkBusyness(  ) {
															#line 893 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Void>(new MonitorNetworkBusynessActor());
															#line 1778 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
}

#line 931 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

static void setupGlobalKnobs() {
	IKnobCollection::setGlobalKnobCollection(IKnobCollection::Type::CLIENT, Randomize::False, IsSimulated::False);
	for (const auto& [knobName, knobValue] : networkOptions.knobs) {
		IKnobCollection::getMutableGlobalKnobCollection().setKnob(knobName, knobValue);
	}
}

// Setup g_network and start monitoring for network busyness
void setupNetwork(uint64_t transportId, UseMetrics useMetrics) {
	if (g_network)
		throw network_already_setup();

	if (!networkOptions.logClientInfo.present())
		networkOptions.logClientInfo = true;

	setupGlobalKnobs();
	g_network = newNet2(tlsConfig, false, useMetrics || networkOptions.traceDirectory.present());
	g_network->addStopCallback(Net2FileSystem::stop);
	FlowTransport::createInstance(true, transportId, WLTOKEN_RESERVED_COUNT);
	Net2FileSystem::newFileSystem();

	if (networkOptions.traceInitializeOnSetup) {
		::initializeClientTracing({}, {});
	}

	uncancellable(monitorNetworkBusyness());
}

void runNetwork() {
	if (!g_network) {
		throw network_not_setup();
	}

	if (!g_network->checkRunnable()) {
		throw network_cannot_be_restarted();
	}

	if (networkOptions.traceDirectory.present() && networkOptions.runLoopProfilingEnabled) {
		setupRunLoopProfiler();
	}

	g_network->run();

	if (networkOptions.traceDirectory.present())
		systemMonitor();
}

void stopNetwork() {
	if (!g_network)
		throw network_not_setup();

	TraceEvent("ClientStopNetwork").log();

	if (networkOptions.traceDirectory.present() && networkOptions.runLoopProfilingEnabled) {
		stopRunLoopProfiler();
	}

	g_network->stop();
}

void DatabaseContext::updateProxies() {
	if (proxiesLastChange == clientInfo->get().id)
		return;
	proxiesLastChange = clientInfo->get().id;
	commitProxies.clear();
	grvProxies.clear();
	bool commitProxyProvisional = false, grvProxyProvisional = false;
	if (clientInfo->get().commitProxies.size()) {
		commitProxies = makeReference<CommitProxyInfo>(clientInfo->get().commitProxies);
		commitProxyProvisional = clientInfo->get().commitProxies[0].provisional;
	}
	if (clientInfo->get().grvProxies.size()) {
		grvProxies = makeReference<GrvProxyInfo>(clientInfo->get().grvProxies, BalanceOnRequests::True);
		grvProxyProvisional = clientInfo->get().grvProxies[0].provisional;
	}
	if (clientInfo->get().commitProxies.size() && clientInfo->get().grvProxies.size()) {
		ASSERT(commitProxyProvisional == grvProxyProvisional);
		proxyProvisional = commitProxyProvisional;
	}
}

Reference<CommitProxyInfo> DatabaseContext::getCommitProxies(UseProvisionalProxies useProvisionalProxies) {
	updateProxies();
	if (proxyProvisional && !useProvisionalProxies) {
		return Reference<CommitProxyInfo>();
	}
	return commitProxies;
}

Reference<GrvProxyInfo> DatabaseContext::getGrvProxies(UseProvisionalProxies useProvisionalProxies) {
	updateProxies();
	if (proxyProvisional && !useProvisionalProxies) {
		return Reference<GrvProxyInfo>();
	}
	return grvProxies;
}

bool DatabaseContext::isCurrentGrvProxy(UID proxyId) const {
	for (const auto& proxy : clientInfo->get().grvProxies) {
		if (proxy.id() == proxyId)
			return true;
	}
	CODE_PROBE(true, "stale GRV proxy detected", probe::decoration::rare);
	return false;
}

// Actor which will wait until the MultiInterface<CommitProxyInterface> returned by the DatabaseContext cx is not
// nullptr
															#line 1891 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
namespace {
// This generated class is to be used only via getCommitProxiesFuture()
															#line 1040 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class GetCommitProxiesFutureActor>
															#line 1040 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetCommitProxiesFutureActorState {
															#line 1898 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
															#line 1040 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetCommitProxiesFutureActorState(DatabaseContext* const& cx,UseProvisionalProxies const& useProvisionalProxies) 
															#line 1040 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 1040 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : cx(cx),
															#line 1040 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   useProvisionalProxies(useProvisionalProxies)
															#line 1907 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
	{
		fdb_probe_actor_create("getCommitProxiesFuture", reinterpret_cast<unsigned long>(this));

	}
	~GetCommitProxiesFutureActorState() 
	{
		fdb_probe_actor_destroy("getCommitProxiesFuture", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1042 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			;
															#line 1922 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetCommitProxiesFutureActorState();
		static_cast<GetCommitProxiesFutureActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1043 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		Reference<CommitProxyInfo> commitProxies = cx->getCommitProxies(useProvisionalProxies);
															#line 1044 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (commitProxies)
															#line 1954 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 1045 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!static_cast<GetCommitProxiesFutureActor*>(this)->SAV<Reference<CommitProxyInfo>>::futures) { (void)(commitProxies); this->~GetCommitProxiesFutureActorState(); static_cast<GetCommitProxiesFutureActor*>(this)->destroy(); return 0; }
															#line 1958 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			new (&static_cast<GetCommitProxiesFutureActor*>(this)->SAV< Reference<CommitProxyInfo> >::value()) Reference<CommitProxyInfo>(commitProxies);
			this->~GetCommitProxiesFutureActorState();
			static_cast<GetCommitProxiesFutureActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1046 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_0 = cx->onProxiesChanged();
															#line 1046 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetCommitProxiesFutureActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1968 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<GetCommitProxiesFutureActor*>(this)->actor_wait_state = 1;
															#line 1046 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetCommitProxiesFutureActor, 0, Void >*>(static_cast<GetCommitProxiesFutureActor*>(this)));
															#line 1973 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetCommitProxiesFutureActor*>(this)->actor_wait_state > 0) static_cast<GetCommitProxiesFutureActor*>(this)->actor_wait_state = 0;
		static_cast<GetCommitProxiesFutureActor*>(this)->ActorCallback< GetCommitProxiesFutureActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetCommitProxiesFutureActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getCommitProxiesFuture", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommitProxiesFutureActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommitProxiesFuture", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetCommitProxiesFutureActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getCommitProxiesFuture", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommitProxiesFutureActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommitProxiesFuture", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetCommitProxiesFutureActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getCommitProxiesFuture", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommitProxiesFutureActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommitProxiesFuture", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1040 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	DatabaseContext* cx;
															#line 1040 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	UseProvisionalProxies useProvisionalProxies;
															#line 2069 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
};
// This generated class is to be used only via getCommitProxiesFuture()
															#line 1040 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetCommitProxiesFutureActor final : public Actor<Reference<CommitProxyInfo>>, public ActorCallback< GetCommitProxiesFutureActor, 0, Void >, public FastAllocated<GetCommitProxiesFutureActor>, public GetCommitProxiesFutureActorState<GetCommitProxiesFutureActor> {
															#line 2074 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
	using FastAllocated<GetCommitProxiesFutureActor>::operator new;
	using FastAllocated<GetCommitProxiesFutureActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6933175486702308608UL, 12455003509175578368UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Reference<CommitProxyInfo>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetCommitProxiesFutureActor, 0, Void >;
															#line 1040 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetCommitProxiesFutureActor(DatabaseContext* const& cx,UseProvisionalProxies const& useProvisionalProxies) 
															#line 2091 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		 : Actor<Reference<CommitProxyInfo>>(),
		   GetCommitProxiesFutureActorState<GetCommitProxiesFutureActor>(cx, useProvisionalProxies),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getCommitProxiesFuture", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5140351585656034048UL, 11319334858847052544UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommitProxiesFutureActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getCommitProxiesFuture");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getCommitProxiesFuture", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetCommitProxiesFutureActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1040 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<Reference<CommitProxyInfo>> getCommitProxiesFuture( DatabaseContext* const& cx, UseProvisionalProxies const& useProvisionalProxies ) {
															#line 1040 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Reference<CommitProxyInfo>>(new GetCommitProxiesFutureActor(cx, useProvisionalProxies));
															#line 2124 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
}

#line 1049 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

// Returns a future which will not be set until the CommitProxyInfo of this DatabaseContext is not nullptr
Future<Reference<CommitProxyInfo>> DatabaseContext::getCommitProxiesFuture(
    UseProvisionalProxies useProvisionalProxies) {
	return ::getCommitProxiesFuture(this, useProvisionalProxies);
}

void GetRangeLimits::decrement(VectorRef<KeyValueRef> const& data) {
	if (rows != GetRangeLimits::ROW_LIMIT_UNLIMITED) {
		ASSERT(data.size() <= rows);
		rows -= data.size();
	}

	minRows = std::max(0, minRows - data.size());

	if (bytes != GetRangeLimits::BYTE_LIMIT_UNLIMITED)
		bytes = std::max(0, bytes - (int)data.expectedSize() - (8 - (int)sizeof(KeyValueRef)) * data.size());
}

void GetRangeLimits::decrement(KeyValueRef const& data) {
	minRows = std::max(0, minRows - 1);
	if (rows != GetRangeLimits::ROW_LIMIT_UNLIMITED)
		rows--;
	if (bytes != GetRangeLimits::BYTE_LIMIT_UNLIMITED)
		bytes = std::max(0, bytes - (int)8 - (int)data.expectedSize());
}

void GetRangeLimits::decrement(VectorRef<MappedKeyValueRef> const& data) {
	if (rows != GetRangeLimits::ROW_LIMIT_UNLIMITED) {
		ASSERT(data.size() <= rows);
		rows -= data.size();
	}

	minRows = std::max(0, minRows - data.size());

	// TODO: For now, expectedSize only considers the size of the original key values, but not the underlying queries or
	// results. Also, double check it is correct when dealing with sizeof(MappedKeyValueRef).
	if (bytes != GetRangeLimits::BYTE_LIMIT_UNLIMITED)
		bytes = std::max(0, bytes - (int)data.expectedSize() - (8 - (int)sizeof(MappedKeyValueRef)) * data.size());
}

void GetRangeLimits::decrement(MappedKeyValueRef const& data) {
	minRows = std::max(0, minRows - 1);
	if (rows != GetRangeLimits::ROW_LIMIT_UNLIMITED)
		rows--;
	// TODO: For now, expectedSize only considers the size of the original key values, but not the underlying queries or
	// results. Also, double check it is correct when dealing with sizeof(MappedKeyValueRef).
	if (bytes != GetRangeLimits::BYTE_LIMIT_UNLIMITED)
		bytes = std::max(0, bytes - (int)8 - (int)data.expectedSize());
}

// True if either the row or byte limit has been reached
bool GetRangeLimits::isReached() const {
	return rows == 0 || (bytes == 0 && minRows == 0);
}

// True if data would cause the row or byte limit to be reached
bool GetRangeLimits::reachedBy(VectorRef<KeyValueRef> const& data) const {
	return (rows != GetRangeLimits::ROW_LIMIT_UNLIMITED && data.size() >= rows) ||
	       (bytes != GetRangeLimits::BYTE_LIMIT_UNLIMITED &&
	        (int)data.expectedSize() + (8 - (int)sizeof(KeyValueRef)) * data.size() >= bytes && data.size() >= minRows);
}

bool GetRangeLimits::hasByteLimit() const {
	return bytes != GetRangeLimits::BYTE_LIMIT_UNLIMITED;
}

bool GetRangeLimits::hasRowLimit() const {
	return rows != GetRangeLimits::ROW_LIMIT_UNLIMITED;
}

bool GetRangeLimits::hasSatisfiedMinRows() const {
	return hasByteLimit() && minRows == 0;
}

AddressExclusion AddressExclusion::parse(StringRef const& key) {
	// Must not change: serialized to the database!
	auto parsedIp = IPAddress::parse(key.toString());
	if (parsedIp.present()) {
		return AddressExclusion(parsedIp.get());
	}

	// Not a whole machine, includes `port'.
	try {
		auto addr = NetworkAddress::parse(key.toString());
		if (addr.isTLS()) {
			TraceEvent(SevWarnAlways, "AddressExclusionParseError")
			    .detail("String", key)
			    .detail("Description", "Address inclusion string should not include `:tls' suffix.");
			return AddressExclusion();
		}
		return AddressExclusion(addr.ip, addr.port);
	} catch (Error&) {
		TraceEvent(SevWarnAlways, "AddressExclusionParseError").detail("String", key);
		return AddressExclusion();
	}
}

Tenant::Tenant(Database cx, TenantName name) : idFuture(cx->lookupTenant(name)), name(name) {}
Tenant::Tenant(int64_t id) : idFuture(id) {}
Tenant::Tenant(Future<int64_t> id, Optional<TenantName> name) : idFuture(id), name(name) {}

int64_t Tenant::id() const {
	ASSERT(idFuture.isReady());
	return idFuture.get();
}

Future<int64_t> Tenant::getIdFuture() const {
	return idFuture;
}

KeyRef Tenant::prefix() const {
	ASSERT(idFuture.isReady());
	if (bigEndianId == -1) {
		bigEndianId = bigEndian64(idFuture.get());
	}
	return StringRef(reinterpret_cast<const uint8_t*>(&bigEndianId), TenantAPI::PREFIX_SIZE);
}

std::string Tenant::description() const {
	StringRef nameStr = name.castTo<TenantNameRef>().orDefault("<unspecified>"_sr);
	if (idFuture.canGet()) {
		return format("%.*s (%lld)", nameStr.size(), nameStr.begin(), idFuture.get());
	} else {
		return format("%.*s", nameStr.size(), nameStr.begin());
	}
}

Future<Optional<Value>> getValue(Reference<TransactionState> const& trState,
                                 Key const& key,
                                 UseTenant const& useTenant = UseTenant::True,
                                 TransactionRecordLogInfo const& recordLogInfo = TransactionRecordLogInfo::True);

Future<RangeResult> getRange(Reference<TransactionState> const& trState,
                             KeySelector const& begin,
                             KeySelector const& end,
                             GetRangeLimits const& limits,
                             Reverse const& reverse,
                             UseTenant const& useTenant);

															#line 2268 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
namespace {
// This generated class is to be used only via fetchServerInterface()
															#line 1189 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class FetchServerInterfaceActor>
															#line 1189 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class FetchServerInterfaceActorState {
															#line 2275 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
															#line 1189 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	FetchServerInterfaceActorState(Reference<TransactionState> const& trState,UID const& id) 
															#line 1189 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 1189 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : trState(trState),
															#line 1189 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   id(id)
															#line 2284 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
	{
		fdb_probe_actor_create("fetchServerInterface", reinterpret_cast<unsigned long>(this));

	}
	~FetchServerInterfaceActorState() 
	{
		fdb_probe_actor_destroy("fetchServerInterface", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1190 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = getValue(trState, serverListKeyFor(id), UseTenant::False, TransactionRecordLogInfo::False);
															#line 1190 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<FetchServerInterfaceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2301 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FetchServerInterfaceActor*>(this)->actor_wait_state = 1;
															#line 1190 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FetchServerInterfaceActor, 0, Optional<Value> >*>(static_cast<FetchServerInterfaceActor*>(this)));
															#line 2306 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FetchServerInterfaceActorState();
		static_cast<FetchServerInterfaceActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& val,int loopDepth) 
	{
															#line 1193 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!val.present())
															#line 2329 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 1195 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!static_cast<FetchServerInterfaceActor*>(this)->SAV<Optional<StorageServerInterface>>::futures) { (void)(Optional<StorageServerInterface>()); this->~FetchServerInterfaceActorState(); static_cast<FetchServerInterfaceActor*>(this)->destroy(); return 0; }
															#line 2333 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			new (&static_cast<FetchServerInterfaceActor*>(this)->SAV< Optional<StorageServerInterface> >::value()) Optional<StorageServerInterface>(Optional<StorageServerInterface>());
			this->~FetchServerInterfaceActorState();
			static_cast<FetchServerInterfaceActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1198 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<FetchServerInterfaceActor*>(this)->SAV<Optional<StorageServerInterface>>::futures) { (void)(decodeServerListValue(val.get())); this->~FetchServerInterfaceActorState(); static_cast<FetchServerInterfaceActor*>(this)->destroy(); return 0; }
															#line 2341 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<FetchServerInterfaceActor*>(this)->SAV< Optional<StorageServerInterface> >::value()) Optional<StorageServerInterface>(decodeServerListValue(val.get()));
		this->~FetchServerInterfaceActorState();
		static_cast<FetchServerInterfaceActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && val,int loopDepth) 
	{
															#line 1193 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!val.present())
															#line 2353 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 1195 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!static_cast<FetchServerInterfaceActor*>(this)->SAV<Optional<StorageServerInterface>>::futures) { (void)(Optional<StorageServerInterface>()); this->~FetchServerInterfaceActorState(); static_cast<FetchServerInterfaceActor*>(this)->destroy(); return 0; }
															#line 2357 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			new (&static_cast<FetchServerInterfaceActor*>(this)->SAV< Optional<StorageServerInterface> >::value()) Optional<StorageServerInterface>(Optional<StorageServerInterface>());
			this->~FetchServerInterfaceActorState();
			static_cast<FetchServerInterfaceActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1198 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<FetchServerInterfaceActor*>(this)->SAV<Optional<StorageServerInterface>>::futures) { (void)(decodeServerListValue(val.get())); this->~FetchServerInterfaceActorState(); static_cast<FetchServerInterfaceActor*>(this)->destroy(); return 0; }
															#line 2365 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<FetchServerInterfaceActor*>(this)->SAV< Optional<StorageServerInterface> >::value()) Optional<StorageServerInterface>(decodeServerListValue(val.get()));
		this->~FetchServerInterfaceActorState();
		static_cast<FetchServerInterfaceActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1cont1(val, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FetchServerInterfaceActor*>(this)->actor_wait_state > 0) static_cast<FetchServerInterfaceActor*>(this)->actor_wait_state = 0;
		static_cast<FetchServerInterfaceActor*>(this)->ActorCallback< FetchServerInterfaceActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< FetchServerInterfaceActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("fetchServerInterface", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchServerInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchServerInterface", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FetchServerInterfaceActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("fetchServerInterface", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchServerInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchServerInterface", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FetchServerInterfaceActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("fetchServerInterface", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchServerInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchServerInterface", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1189 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reference<TransactionState> trState;
															#line 1189 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	UID id;
															#line 2452 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
};
// This generated class is to be used only via fetchServerInterface()
															#line 1189 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class FetchServerInterfaceActor final : public Actor<Optional<StorageServerInterface>>, public ActorCallback< FetchServerInterfaceActor, 0, Optional<Value> >, public FastAllocated<FetchServerInterfaceActor>, public FetchServerInterfaceActorState<FetchServerInterfaceActor> {
															#line 2457 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
	using FastAllocated<FetchServerInterfaceActor>::operator new;
	using FastAllocated<FetchServerInterfaceActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5521552206190516736UL, 9956763375801588480UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<StorageServerInterface>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FetchServerInterfaceActor, 0, Optional<Value> >;
															#line 1189 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	FetchServerInterfaceActor(Reference<TransactionState> const& trState,UID const& id) 
															#line 2474 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		 : Actor<Optional<StorageServerInterface>>(),
		   FetchServerInterfaceActorState<FetchServerInterfaceActor>(trState, id),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fetchServerInterface", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14331509920591601920UL, 209697105602724096UL);
		ActorExecutionContextHelper __helper(static_cast<FetchServerInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fetchServerInterface");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fetchServerInterface", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FetchServerInterfaceActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1189 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<Optional<StorageServerInterface>> fetchServerInterface( Reference<TransactionState> const& trState, UID const& id ) {
															#line 1189 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Optional<StorageServerInterface>>(new FetchServerInterfaceActor(trState, id));
															#line 2507 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
}

#line 1200 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

															#line 2512 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
namespace {
// This generated class is to be used only via transactionalGetServerInterfaces()
															#line 1201 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class TransactionalGetServerInterfacesActor>
															#line 1201 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class TransactionalGetServerInterfacesActorState {
															#line 2519 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
															#line 1201 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	TransactionalGetServerInterfacesActorState(Reference<TransactionState> const& trState,std::vector<UID> const& ids) 
															#line 1201 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 1201 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : trState(trState),
															#line 1201 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   ids(ids),
															#line 1204 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   serverListEntries()
															#line 2530 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
	{
		fdb_probe_actor_create("transactionalGetServerInterfaces", reinterpret_cast<unsigned long>(this));

	}
	~TransactionalGetServerInterfacesActorState() 
	{
		fdb_probe_actor_destroy("transactionalGetServerInterfaces", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1205 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			serverListEntries.reserve(ids.size());
															#line 1206 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			for(int s = 0;s < ids.size();s++) {
															#line 1207 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				serverListEntries.push_back(fetchServerInterface(trState, ids[s]));
															#line 2549 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 1210 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<std::vector<Optional<StorageServerInterface>>> __when_expr_0 = getAll(serverListEntries);
															#line 1210 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<TransactionalGetServerInterfacesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2555 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TransactionalGetServerInterfacesActor*>(this)->actor_wait_state = 1;
															#line 1210 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TransactionalGetServerInterfacesActor, 0, std::vector<Optional<StorageServerInterface>> >*>(static_cast<TransactionalGetServerInterfacesActor*>(this)));
															#line 2560 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TransactionalGetServerInterfacesActorState();
		static_cast<TransactionalGetServerInterfacesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<Optional<StorageServerInterface>> const& serverListValues,int loopDepth) 
	{
															#line 1211 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		std::vector<StorageServerInterface> serverInterfaces;
															#line 1212 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		for(int s = 0;s < serverListValues.size();s++) {
															#line 1213 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!serverListValues[s].present())
															#line 2587 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 1215 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (!static_cast<TransactionalGetServerInterfacesActor*>(this)->SAV<Optional<std::vector<StorageServerInterface>>>::futures) { (void)(Optional<std::vector<StorageServerInterface>>()); this->~TransactionalGetServerInterfacesActorState(); static_cast<TransactionalGetServerInterfacesActor*>(this)->destroy(); return 0; }
															#line 2591 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				new (&static_cast<TransactionalGetServerInterfacesActor*>(this)->SAV< Optional<std::vector<StorageServerInterface>> >::value()) Optional<std::vector<StorageServerInterface>>(Optional<std::vector<StorageServerInterface>>());
				this->~TransactionalGetServerInterfacesActorState();
				static_cast<TransactionalGetServerInterfacesActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1217 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			serverInterfaces.push_back(serverListValues[s].get());
															#line 2599 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 1219 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<TransactionalGetServerInterfacesActor*>(this)->SAV<Optional<std::vector<StorageServerInterface>>>::futures) { (void)(serverInterfaces); this->~TransactionalGetServerInterfacesActorState(); static_cast<TransactionalGetServerInterfacesActor*>(this)->destroy(); return 0; }
															#line 2603 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<TransactionalGetServerInterfacesActor*>(this)->SAV< Optional<std::vector<StorageServerInterface>> >::value()) Optional<std::vector<StorageServerInterface>>(serverInterfaces);
		this->~TransactionalGetServerInterfacesActorState();
		static_cast<TransactionalGetServerInterfacesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<Optional<StorageServerInterface>> && serverListValues,int loopDepth) 
	{
															#line 1211 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		std::vector<StorageServerInterface> serverInterfaces;
															#line 1212 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		for(int s = 0;s < serverListValues.size();s++) {
															#line 1213 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!serverListValues[s].present())
															#line 2619 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 1215 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (!static_cast<TransactionalGetServerInterfacesActor*>(this)->SAV<Optional<std::vector<StorageServerInterface>>>::futures) { (void)(Optional<std::vector<StorageServerInterface>>()); this->~TransactionalGetServerInterfacesActorState(); static_cast<TransactionalGetServerInterfacesActor*>(this)->destroy(); return 0; }
															#line 2623 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				new (&static_cast<TransactionalGetServerInterfacesActor*>(this)->SAV< Optional<std::vector<StorageServerInterface>> >::value()) Optional<std::vector<StorageServerInterface>>(Optional<std::vector<StorageServerInterface>>());
				this->~TransactionalGetServerInterfacesActorState();
				static_cast<TransactionalGetServerInterfacesActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1217 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			serverInterfaces.push_back(serverListValues[s].get());
															#line 2631 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 1219 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<TransactionalGetServerInterfacesActor*>(this)->SAV<Optional<std::vector<StorageServerInterface>>>::futures) { (void)(serverInterfaces); this->~TransactionalGetServerInterfacesActorState(); static_cast<TransactionalGetServerInterfacesActor*>(this)->destroy(); return 0; }
															#line 2635 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<TransactionalGetServerInterfacesActor*>(this)->SAV< Optional<std::vector<StorageServerInterface>> >::value()) Optional<std::vector<StorageServerInterface>>(serverInterfaces);
		this->~TransactionalGetServerInterfacesActorState();
		static_cast<TransactionalGetServerInterfacesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<Optional<StorageServerInterface>> const& serverListValues,int loopDepth) 
	{
		loopDepth = a_body1cont1(serverListValues, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<Optional<StorageServerInterface>> && serverListValues,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(serverListValues), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TransactionalGetServerInterfacesActor*>(this)->actor_wait_state > 0) static_cast<TransactionalGetServerInterfacesActor*>(this)->actor_wait_state = 0;
		static_cast<TransactionalGetServerInterfacesActor*>(this)->ActorCallback< TransactionalGetServerInterfacesActor, 0, std::vector<Optional<StorageServerInterface>> >::remove();

	}
	void a_callback_fire(ActorCallback< TransactionalGetServerInterfacesActor, 0, std::vector<Optional<StorageServerInterface>> >*,std::vector<Optional<StorageServerInterface>> const& value) 
	{
		fdb_probe_actor_enter("transactionalGetServerInterfaces", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionalGetServerInterfacesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transactionalGetServerInterfaces", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TransactionalGetServerInterfacesActor, 0, std::vector<Optional<StorageServerInterface>> >*,std::vector<Optional<StorageServerInterface>> && value) 
	{
		fdb_probe_actor_enter("transactionalGetServerInterfaces", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionalGetServerInterfacesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transactionalGetServerInterfaces", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TransactionalGetServerInterfacesActor, 0, std::vector<Optional<StorageServerInterface>> >*,Error err) 
	{
		fdb_probe_actor_enter("transactionalGetServerInterfaces", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionalGetServerInterfacesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transactionalGetServerInterfaces", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1201 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reference<TransactionState> trState;
															#line 1201 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	std::vector<UID> ids;
															#line 1204 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	std::vector<Future<Optional<StorageServerInterface>>> serverListEntries;
															#line 2724 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
};
// This generated class is to be used only via transactionalGetServerInterfaces()
															#line 1201 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class TransactionalGetServerInterfacesActor final : public Actor<Optional<std::vector<StorageServerInterface>>>, public ActorCallback< TransactionalGetServerInterfacesActor, 0, std::vector<Optional<StorageServerInterface>> >, public FastAllocated<TransactionalGetServerInterfacesActor>, public TransactionalGetServerInterfacesActorState<TransactionalGetServerInterfacesActor> {
															#line 2729 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
	using FastAllocated<TransactionalGetServerInterfacesActor>::operator new;
	using FastAllocated<TransactionalGetServerInterfacesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3845726348140042752UL, 17183246311143821056UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<std::vector<StorageServerInterface>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TransactionalGetServerInterfacesActor, 0, std::vector<Optional<StorageServerInterface>> >;
															#line 1201 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	TransactionalGetServerInterfacesActor(Reference<TransactionState> const& trState,std::vector<UID> const& ids) 
															#line 2746 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		 : Actor<Optional<std::vector<StorageServerInterface>>>(),
		   TransactionalGetServerInterfacesActorState<TransactionalGetServerInterfacesActor>(trState, ids),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("transactionalGetServerInterfaces", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8960874033469204480UL, 15207940511002765056UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionalGetServerInterfacesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("transactionalGetServerInterfaces");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("transactionalGetServerInterfaces", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TransactionalGetServerInterfacesActor, 0, std::vector<Optional<StorageServerInterface>> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1201 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<Optional<std::vector<StorageServerInterface>>> transactionalGetServerInterfaces( Reference<TransactionState> const& trState, std::vector<UID> const& ids ) {
															#line 1201 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Optional<std::vector<StorageServerInterface>>>(new TransactionalGetServerInterfacesActor(trState, ids));
															#line 2779 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
}

#line 1221 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

void updateTssMappings(Database cx, const GetKeyServerLocationsReply& reply) {
	// Since a ss -> tss mapping is included in resultsTssMapping iff that SS is in results and has a tss pair,
	// all SS in results that do not have a mapping present must not have a tss pair.
	std::unordered_map<UID, const StorageServerInterface*> ssiById;
	for (const auto& [_, shard] : reply.results) {
		for (auto& ssi : shard) {
			ssiById[ssi.id()] = &ssi;
		}
	}

	for (const auto& mapping : reply.resultsTssMapping) {
		auto ssi = ssiById.find(mapping.first);
		ASSERT(ssi != ssiById.end());
		cx->addTssMapping(*ssi->second, mapping.second);
		ssiById.erase(mapping.first);
	}

	// if SS didn't have a mapping above, it's still in the ssiById map, so remove its tss mapping
	for (const auto& it : ssiById) {
		cx->removeTssMapping(*it.second);
	}
}

void updateTagMappings(Database cx, const GetKeyServerLocationsReply& reply) {
	for (const auto& mapping : reply.resultsTagMapping) {
		cx->addSSIdTagMapping(mapping.first, mapping.second);
	}
}

// If isBackward == true, returns the shard containing the key before 'key' (an infinitely long, inexpressible key).
// Otherwise returns the shard containing key
															#line 2815 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
namespace {
// This generated class is to be used only via getKeyLocation_internal()
															#line 1253 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class GetKeyLocation_internalActor>
															#line 1253 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetKeyLocation_internalActorState {
															#line 2822 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
															#line 1253 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetKeyLocation_internalActorState(Database const& cx,TenantInfo const& tenant,Key const& key,SpanContext const& spanContext,Optional<UID> const& debugID,UseProvisionalProxies const& useProvisionalProxies,Reverse const& isBackward,Version const& version) 
															#line 1253 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 1253 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : cx(cx),
															#line 1253 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   tenant(tenant),
															#line 1253 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   key(key),
															#line 1253 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   spanContext(spanContext),
															#line 1253 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   debugID(debugID),
															#line 1253 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   useProvisionalProxies(useProvisionalProxies),
															#line 1253 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   isBackward(isBackward),
															#line 1253 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   version(version),
															#line 1262 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   span("NAPI:getKeyLocation"_loc, spanContext)
															#line 2845 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
	{
		fdb_probe_actor_create("getKeyLocation_internal", reinterpret_cast<unsigned long>(this));

	}
	~GetKeyLocation_internalActorState() 
	{
		fdb_probe_actor_destroy("getKeyLocation_internal", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1263 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (isBackward)
															#line 2860 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 1264 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				ASSERT(key != allKeys.begin && key <= allKeys.end);
															#line 2864 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
			else
			{
															#line 1266 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				ASSERT(key < allKeys.end);
															#line 2870 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 1269 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (debugID.present())
															#line 2874 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 1270 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				g_traceBatch.addEvent("TransactionDebug", debugID.get().first(), "NativeAPI.getKeyLocation.Before");
															#line 2878 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 1272 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			;
															#line 2882 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetKeyLocation_internalActorState();
		static_cast<GetKeyLocation_internalActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1274 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_0 = cx->getBackoff();
															#line 1274 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<GetKeyLocation_internalActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2915 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetKeyLocation_internalActor*>(this)->actor_wait_state = 1;
															#line 1274 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetKeyLocation_internalActor, 0, Void >*>(static_cast<GetKeyLocation_internalActor*>(this)));
															#line 2920 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1300 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (e.code() == error_code_commit_proxy_memory_limit_exceeded)
															#line 2942 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 1302 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				TraceEvent(SevWarnAlways, "CommitProxyOverloadedForKeyLocation").suppressFor(5);
															#line 1303 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				cx->updateBackoff(e);
															#line 2948 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				return a_body1loopHead1(loopDepth); // continue
			}
															#line 1307 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 2953 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 1275 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++cx->transactionKeyServerLocationRequests;
															#line 1277 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_1 = cx->onProxiesChanged();
															#line 1276 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetKeyLocation_internalActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2971 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
															#line 1278 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<GetKeyServerLocationsReply> __when_expr_2 = basicLoadBalance( cx->getCommitProxies(useProvisionalProxies), &CommitProxyInterface::getKeyServersLocations, GetKeyServerLocationsRequest( span.context, tenant, key, Optional<KeyRef>(), 100, isBackward, version, key.arena()), TaskPriority::DefaultPromiseEndpoint);
															#line 2975 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont2when2(__when_expr_2.get(), loopDepth); };
		static_cast<GetKeyLocation_internalActor*>(this)->actor_wait_state = 2;
															#line 1277 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetKeyLocation_internalActor, 1, Void >*>(static_cast<GetKeyLocation_internalActor*>(this)));
															#line 1278 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetKeyLocation_internalActor, 2, GetKeyServerLocationsReply >*>(static_cast<GetKeyLocation_internalActor*>(this)));
															#line 2982 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 1275 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++cx->transactionKeyServerLocationRequests;
															#line 1277 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_1 = cx->onProxiesChanged();
															#line 1276 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetKeyLocation_internalActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2995 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
															#line 1278 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<GetKeyServerLocationsReply> __when_expr_2 = basicLoadBalance( cx->getCommitProxies(useProvisionalProxies), &CommitProxyInterface::getKeyServersLocations, GetKeyServerLocationsRequest( span.context, tenant, key, Optional<KeyRef>(), 100, isBackward, version, key.arena()), TaskPriority::DefaultPromiseEndpoint);
															#line 2999 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont2when2(__when_expr_2.get(), loopDepth); };
		static_cast<GetKeyLocation_internalActor*>(this)->actor_wait_state = 2;
															#line 1277 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetKeyLocation_internalActor, 1, Void >*>(static_cast<GetKeyLocation_internalActor*>(this)));
															#line 1278 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetKeyLocation_internalActor, 2, GetKeyServerLocationsReply >*>(static_cast<GetKeyLocation_internalActor*>(this)));
															#line 3006 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetKeyLocation_internalActor*>(this)->actor_wait_state > 0) static_cast<GetKeyLocation_internalActor*>(this)->actor_wait_state = 0;
		static_cast<GetKeyLocation_internalActor*>(this)->ActorCallback< GetKeyLocation_internalActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetKeyLocation_internalActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyLocation_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetKeyLocation_internalActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyLocation_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetKeyLocation_internalActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyLocation_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when2(GetKeyServerLocationsReply const& rep,int loopDepth) 
	{
															#line 1284 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++cx->transactionKeyServerLocationRequestsCompleted;
															#line 1285 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (debugID.present())
															#line 3110 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 1286 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			g_traceBatch.addEvent( "TransactionDebug", debugID.get().first(), "NativeAPI.getKeyLocation.After");
															#line 3114 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 1288 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(rep.results.size() == 1);
															#line 1290 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		auto locationInfo = cx->setCachedLocation(rep.results[0].first, rep.results[0].second);
															#line 1291 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		updateTssMappings(cx, rep);
															#line 1292 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		updateTagMappings(cx, rep);
															#line 1294 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		cx->updateBackoff(success());
															#line 1295 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetKeyLocation_internalActor*>(this)->SAV<KeyRangeLocationInfo>::futures) { (void)(KeyRangeLocationInfo( KeyRange(toPrefixRelativeRange(rep.results[0].first, tenant.prefix), rep.arena), locationInfo)); this->~GetKeyLocation_internalActorState(); static_cast<GetKeyLocation_internalActor*>(this)->destroy(); return 0; }
															#line 3128 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<GetKeyLocation_internalActor*>(this)->SAV< KeyRangeLocationInfo >::value()) KeyRangeLocationInfo(KeyRangeLocationInfo( KeyRange(toPrefixRelativeRange(rep.results[0].first, tenant.prefix), rep.arena), locationInfo));
		this->~GetKeyLocation_internalActorState();
		static_cast<GetKeyLocation_internalActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when2(GetKeyServerLocationsReply && rep,int loopDepth) 
	{
															#line 1284 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++cx->transactionKeyServerLocationRequestsCompleted;
															#line 1285 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (debugID.present())
															#line 3142 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 1286 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			g_traceBatch.addEvent( "TransactionDebug", debugID.get().first(), "NativeAPI.getKeyLocation.After");
															#line 3146 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 1288 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(rep.results.size() == 1);
															#line 1290 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		auto locationInfo = cx->setCachedLocation(rep.results[0].first, rep.results[0].second);
															#line 1291 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		updateTssMappings(cx, rep);
															#line 1292 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		updateTagMappings(cx, rep);
															#line 1294 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		cx->updateBackoff(success());
															#line 1295 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetKeyLocation_internalActor*>(this)->SAV<KeyRangeLocationInfo>::futures) { (void)(KeyRangeLocationInfo( KeyRange(toPrefixRelativeRange(rep.results[0].first, tenant.prefix), rep.arena), locationInfo)); this->~GetKeyLocation_internalActorState(); static_cast<GetKeyLocation_internalActor*>(this)->destroy(); return 0; }
															#line 3160 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<GetKeyLocation_internalActor*>(this)->SAV< KeyRangeLocationInfo >::value()) KeyRangeLocationInfo(KeyRangeLocationInfo( KeyRange(toPrefixRelativeRange(rep.results[0].first, tenant.prefix), rep.arena), locationInfo));
		this->~GetKeyLocation_internalActorState();
		static_cast<GetKeyLocation_internalActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetKeyLocation_internalActor*>(this)->actor_wait_state > 0) static_cast<GetKeyLocation_internalActor*>(this)->actor_wait_state = 0;
		static_cast<GetKeyLocation_internalActor*>(this)->ActorCallback< GetKeyLocation_internalActor, 1, Void >::remove();
		static_cast<GetKeyLocation_internalActor*>(this)->ActorCallback< GetKeyLocation_internalActor, 2, GetKeyServerLocationsReply >::remove();

	}
	void a_callback_fire(ActorCallback< GetKeyLocation_internalActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyLocation_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetKeyLocation_internalActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyLocation_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetKeyLocation_internalActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyLocation_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetKeyLocation_internalActor, 2, GetKeyServerLocationsReply >*,GetKeyServerLocationsReply const& value) 
	{
		fdb_probe_actor_enter("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyLocation_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetKeyLocation_internalActor, 2, GetKeyServerLocationsReply >*,GetKeyServerLocationsReply && value) 
	{
		fdb_probe_actor_enter("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyLocation_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetKeyLocation_internalActor, 2, GetKeyServerLocationsReply >*,Error err) 
	{
		fdb_probe_actor_enter("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyLocation_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 1253 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Database cx;
															#line 1253 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	TenantInfo tenant;
															#line 1253 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Key key;
															#line 1253 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	SpanContext spanContext;
															#line 1253 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Optional<UID> debugID;
															#line 1253 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	UseProvisionalProxies useProvisionalProxies;
															#line 1253 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reverse isBackward;
															#line 1253 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Version version;
															#line 1262 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Span span;
															#line 3320 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
};
// This generated class is to be used only via getKeyLocation_internal()
															#line 1253 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetKeyLocation_internalActor final : public Actor<KeyRangeLocationInfo>, public ActorCallback< GetKeyLocation_internalActor, 0, Void >, public ActorCallback< GetKeyLocation_internalActor, 1, Void >, public ActorCallback< GetKeyLocation_internalActor, 2, GetKeyServerLocationsReply >, public FastAllocated<GetKeyLocation_internalActor>, public GetKeyLocation_internalActorState<GetKeyLocation_internalActor> {
															#line 3325 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
	using FastAllocated<GetKeyLocation_internalActor>::operator new;
	using FastAllocated<GetKeyLocation_internalActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5885801355784594944UL, 2667039626771411456UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<KeyRangeLocationInfo>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetKeyLocation_internalActor, 0, Void >;
friend struct ActorCallback< GetKeyLocation_internalActor, 1, Void >;
friend struct ActorCallback< GetKeyLocation_internalActor, 2, GetKeyServerLocationsReply >;
															#line 1253 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetKeyLocation_internalActor(Database const& cx,TenantInfo const& tenant,Key const& key,SpanContext const& spanContext,Optional<UID> const& debugID,UseProvisionalProxies const& useProvisionalProxies,Reverse const& isBackward,Version const& version) 
															#line 3344 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		 : Actor<KeyRangeLocationInfo>(),
		   GetKeyLocation_internalActorState<GetKeyLocation_internalActor>(cx, tenant, key, spanContext, debugID, useProvisionalProxies, isBackward, version),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1277245642794616832UL, 6556686229128886016UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyLocation_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getKeyLocation_internal");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetKeyLocation_internalActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetKeyLocation_internalActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1253 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<KeyRangeLocationInfo> getKeyLocation_internal( Database const& cx, TenantInfo const& tenant, Key const& key, SpanContext const& spanContext, Optional<UID> const& debugID, UseProvisionalProxies const& useProvisionalProxies, Reverse const& isBackward, Version const& version ) {
															#line 1253 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<KeyRangeLocationInfo>(new GetKeyLocation_internalActor(cx, tenant, key, spanContext, debugID, useProvisionalProxies, isBackward, version));
															#line 3378 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
}

#line 1311 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

// Checks if `endpoint` is failed on a healthy server or not. Returns true if we need to refresh the location cache for
// the endpoint.
bool checkOnlyEndpointFailed(const Database& cx, const Endpoint& endpoint) {
	if (IFailureMonitor::failureMonitor().onlyEndpointFailed(endpoint)) {
		// This endpoint is failed, but the server is still healthy. There are two cases this can happen:
		//    - There is a recent bounce in the cluster where the endpoints in SSes get updated.
		//    - The SS is failed and terminated on a server, but the server is kept running.
		// To account for the first case, we invalidate the cache and issue GetKeyLocation requests to the proxy to
		// update the cache with the new SS points. However, if the failure is caused by the second case, the
		// requested key location will continue to be the failed endpoint until the data movement is finished. But
		// every read will generate a GetKeyLocation request to the proxies (and still getting the failed endpoint
		// back), which may overload the proxy and affect data movement speed. Therefore, we only refresh the
		// location cache for short period of time, and after the initial grace period that we keep retrying
		// resolving key location, we will slow it down to resolve it only once every
		// `LOCATION_CACHE_FAILED_ENDPOINT_RETRY_INTERVAL`.
		cx->setFailedEndpointOnHealthyServer(endpoint);
		const auto& failureInfo = cx->getEndpointFailureInfo(endpoint);
		ASSERT(failureInfo.present());
		if (now() - failureInfo.get().startTime < CLIENT_KNOBS->LOCATION_CACHE_ENDPOINT_FAILURE_GRACE_PERIOD ||
		    now() - failureInfo.get().lastRefreshTime > CLIENT_KNOBS->LOCATION_CACHE_FAILED_ENDPOINT_RETRY_INTERVAL) {
			cx->updateFailedEndpointRefreshTime(endpoint);
			return true;
		}
	} else {
		cx->clearFailedEndpointOnHealthyServer(endpoint);
	}
	return false;
}

template <class F>
Future<KeyRangeLocationInfo> getKeyLocation(Database const& cx,
                                            TenantInfo const& tenant,
                                            Key const& key,
                                            F StorageServerInterface::* member,
                                            SpanContext spanContext,
                                            Optional<UID> debugID,
                                            UseProvisionalProxies useProvisionalProxies,
                                            Reverse isBackward,
                                            Version version) {
	// we first check whether this range is cached
	Optional<KeyRangeLocationInfo> locationInfo = cx->getCachedLocation(tenant, key, isBackward);
	if (!locationInfo.present()) {
		return getKeyLocation_internal(
		    cx, tenant, key, spanContext, debugID, useProvisionalProxies, isBackward, version);
	}

	bool onlyEndpointFailedAndNeedRefresh = false;
	for (int i = 0; i < locationInfo.get().locations->size(); i++) {
		if (checkOnlyEndpointFailed(cx, locationInfo.get().locations->get(i, member).getEndpoint())) {
			onlyEndpointFailedAndNeedRefresh = true;
		}
	}

	if (onlyEndpointFailedAndNeedRefresh) {
		cx->invalidateCache(tenant.prefix, key);

		// Refresh the cache with a new getKeyLocations made to proxies.
		return getKeyLocation_internal(
		    cx, tenant, key, spanContext, debugID, useProvisionalProxies, isBackward, version);
	}

	return locationInfo.get();
}

template <class F>
Future<KeyRangeLocationInfo> getKeyLocation(Reference<TransactionState> trState,
                                            Key const& key,
                                            F StorageServerInterface::* member,
                                            Reverse isBackward,
                                            UseTenant useTenant) {
	CODE_PROBE(!useTenant, "Get key location ignoring tenant");
	return getKeyLocation(trState->cx,
	                      useTenant ? trState->getTenantInfo() : TenantInfo(),
	                      key,
	                      member,
	                      trState->spanContext,
	                      trState->readOptions.present() ? trState->readOptions.get().debugID : Optional<UID>(),
	                      trState->useProvisionalProxies,
	                      isBackward,
	                      trState->readVersionFuture.isValid() && trState->readVersionFuture.isReady()
	                          ? trState->readVersion()
	                          : latestVersion);
}

void DatabaseContext::updateBackoff(const Error& err) {
	switch (err.code()) {
	case error_code_success:
		backoffDelay = backoffDelay / CLIENT_KNOBS->BACKOFF_GROWTH_RATE;
		if (backoffDelay < CLIENT_KNOBS->DEFAULT_BACKOFF) {
			backoffDelay = 0.0;
		}
		break;

	case error_code_commit_proxy_memory_limit_exceeded:
		++transactionsResourceConstrained;
		if (backoffDelay == 0.0) {
			backoffDelay = CLIENT_KNOBS->DEFAULT_BACKOFF;
		} else {
			backoffDelay = std::min(backoffDelay * CLIENT_KNOBS->BACKOFF_GROWTH_RATE,
			                        CLIENT_KNOBS->RESOURCE_CONSTRAINED_MAX_BACKOFF);
		}
		break;

	default:
		ASSERT_WE_THINK(false);
	}
}

															#line 3491 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
namespace {
// This generated class is to be used only via getKeyRangeLocations_internal()
															#line 1420 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class GetKeyRangeLocations_internalActor>
															#line 1420 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetKeyRangeLocations_internalActorState {
															#line 3498 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
															#line 1420 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetKeyRangeLocations_internalActorState(Database const& cx,TenantInfo const& tenant,KeyRange const& keys,int const& limit,Reverse const& reverse,SpanContext const& spanContext,Optional<UID> const& debugID,UseProvisionalProxies const& useProvisionalProxies,Version const& version) 
															#line 1420 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 1420 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : cx(cx),
															#line 1420 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   tenant(tenant),
															#line 1420 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   keys(keys),
															#line 1420 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   limit(limit),
															#line 1420 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   reverse(reverse),
															#line 1420 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   spanContext(spanContext),
															#line 1420 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   debugID(debugID),
															#line 1420 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   useProvisionalProxies(useProvisionalProxies),
															#line 1420 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   version(version),
															#line 1430 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   span("NAPI:getKeyRangeLocations"_loc, spanContext)
															#line 3523 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
	{
		fdb_probe_actor_create("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this));

	}
	~GetKeyRangeLocations_internalActorState() 
	{
		fdb_probe_actor_destroy("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1431 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (debugID.present())
															#line 3538 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 1432 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				g_traceBatch.addEvent("TransactionDebug", debugID.get().first(), "NativeAPI.getKeyLocations.Before");
															#line 3542 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 1434 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			;
															#line 3546 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetKeyRangeLocations_internalActorState();
		static_cast<GetKeyRangeLocations_internalActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1436 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_0 = cx->getBackoff();
															#line 1436 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<GetKeyRangeLocations_internalActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3579 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetKeyRangeLocations_internalActor*>(this)->actor_wait_state = 1;
															#line 1436 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetKeyRangeLocations_internalActor, 0, Void >*>(static_cast<GetKeyRangeLocations_internalActor*>(this)));
															#line 3584 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1471 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (e.code() == error_code_commit_proxy_memory_limit_exceeded)
															#line 3606 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 1473 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				TraceEvent(SevWarnAlways, "CommitProxyOverloadedForRangeLocation").suppressFor(5);
															#line 1474 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				cx->updateBackoff(e);
															#line 3612 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				return a_body1loopHead1(loopDepth); // continue
			}
															#line 1478 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 3617 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 1437 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++cx->transactionKeyServerLocationRequests;
															#line 1439 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_1 = cx->onProxiesChanged();
															#line 1438 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetKeyRangeLocations_internalActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3635 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
															#line 1440 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<GetKeyServerLocationsReply> __when_expr_2 = basicLoadBalance( cx->getCommitProxies(useProvisionalProxies), &CommitProxyInterface::getKeyServersLocations, GetKeyServerLocationsRequest( span.context, tenant, keys.begin, keys.end, limit, reverse, version, keys.arena()), TaskPriority::DefaultPromiseEndpoint);
															#line 3639 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont2when2(__when_expr_2.get(), loopDepth); };
		static_cast<GetKeyRangeLocations_internalActor*>(this)->actor_wait_state = 2;
															#line 1439 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetKeyRangeLocations_internalActor, 1, Void >*>(static_cast<GetKeyRangeLocations_internalActor*>(this)));
															#line 1440 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetKeyRangeLocations_internalActor, 2, GetKeyServerLocationsReply >*>(static_cast<GetKeyRangeLocations_internalActor*>(this)));
															#line 3646 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 1437 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++cx->transactionKeyServerLocationRequests;
															#line 1439 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_1 = cx->onProxiesChanged();
															#line 1438 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetKeyRangeLocations_internalActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3659 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
															#line 1440 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<GetKeyServerLocationsReply> __when_expr_2 = basicLoadBalance( cx->getCommitProxies(useProvisionalProxies), &CommitProxyInterface::getKeyServersLocations, GetKeyServerLocationsRequest( span.context, tenant, keys.begin, keys.end, limit, reverse, version, keys.arena()), TaskPriority::DefaultPromiseEndpoint);
															#line 3663 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont2when2(__when_expr_2.get(), loopDepth); };
		static_cast<GetKeyRangeLocations_internalActor*>(this)->actor_wait_state = 2;
															#line 1439 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetKeyRangeLocations_internalActor, 1, Void >*>(static_cast<GetKeyRangeLocations_internalActor*>(this)));
															#line 1440 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetKeyRangeLocations_internalActor, 2, GetKeyServerLocationsReply >*>(static_cast<GetKeyRangeLocations_internalActor*>(this)));
															#line 3670 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetKeyRangeLocations_internalActor*>(this)->actor_wait_state > 0) static_cast<GetKeyRangeLocations_internalActor*>(this)->actor_wait_state = 0;
		static_cast<GetKeyRangeLocations_internalActor*>(this)->ActorCallback< GetKeyRangeLocations_internalActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetKeyRangeLocations_internalActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyRangeLocations_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetKeyRangeLocations_internalActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyRangeLocations_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetKeyRangeLocations_internalActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyRangeLocations_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when2(GetKeyServerLocationsReply const& _rep,int loopDepth) 
	{
															#line 1446 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++cx->transactionKeyServerLocationRequestsCompleted;
															#line 1447 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		rep = _rep;
															#line 1448 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (debugID.present())
															#line 3776 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 1449 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			g_traceBatch.addEvent( "TransactionDebug", debugID.get().first(), "NativeAPI.getKeyLocations.After");
															#line 3780 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 1451 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(rep.results.size());
															#line 1453 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		results = std::vector<KeyRangeLocationInfo>();
															#line 1454 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		shard = 0;
															#line 1455 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		;
															#line 3790 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2when2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when2(GetKeyServerLocationsReply && _rep,int loopDepth) 
	{
															#line 1446 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++cx->transactionKeyServerLocationRequestsCompleted;
															#line 1447 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		rep = _rep;
															#line 1448 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (debugID.present())
															#line 3803 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 1449 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			g_traceBatch.addEvent( "TransactionDebug", debugID.get().first(), "NativeAPI.getKeyLocations.After");
															#line 3807 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 1451 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(rep.results.size());
															#line 1453 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		results = std::vector<KeyRangeLocationInfo>();
															#line 1454 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		shard = 0;
															#line 1455 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		;
															#line 3817 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2when2loopHead1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetKeyRangeLocations_internalActor*>(this)->actor_wait_state > 0) static_cast<GetKeyRangeLocations_internalActor*>(this)->actor_wait_state = 0;
		static_cast<GetKeyRangeLocations_internalActor*>(this)->ActorCallback< GetKeyRangeLocations_internalActor, 1, Void >::remove();
		static_cast<GetKeyRangeLocations_internalActor*>(this)->ActorCallback< GetKeyRangeLocations_internalActor, 2, GetKeyServerLocationsReply >::remove();

	}
	void a_callback_fire(ActorCallback< GetKeyRangeLocations_internalActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyRangeLocations_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetKeyRangeLocations_internalActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyRangeLocations_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetKeyRangeLocations_internalActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyRangeLocations_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont2when2cont1(int loopDepth) 
	{
															#line 1463 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		updateTssMappings(cx, rep);
															#line 1464 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		updateTagMappings(cx, rep);
															#line 1466 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		cx->updateBackoff(success());
															#line 1467 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetKeyRangeLocations_internalActor*>(this)->SAV<std::vector<KeyRangeLocationInfo>>::futures) { (void)(results); this->~GetKeyRangeLocations_internalActorState(); static_cast<GetKeyRangeLocations_internalActor*>(this)->destroy(); return 0; }
															#line 3896 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<GetKeyRangeLocations_internalActor*>(this)->SAV< std::vector<KeyRangeLocationInfo> >::value()) std::vector<KeyRangeLocationInfo>(std::move(results)); // state_var_RVO
		this->~GetKeyRangeLocations_internalActorState();
		static_cast<GetKeyRangeLocations_internalActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont2when2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when2loopBody1(int loopDepth) 
	{
															#line 1455 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!(shard < rep.results.size()))
															#line 3915 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
			return a_body1loopBody1cont2when2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1458 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		results.emplace_back( (toPrefixRelativeRange(rep.results[shard].first, tenant.prefix) & keys), cx->setCachedLocation(rep.results[shard].first, rep.results[shard].second));
															#line 1461 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_3 = yield();
															#line 1461 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetKeyRangeLocations_internalActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3925 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when2loopBody1when1(__when_expr_3.get(), loopDepth); };
		static_cast<GetKeyRangeLocations_internalActor*>(this)->actor_wait_state = 3;
															#line 1461 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetKeyRangeLocations_internalActor, 3, Void >*>(static_cast<GetKeyRangeLocations_internalActor*>(this)));
															#line 3930 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2when2cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2when2loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 1455 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		shard++;
															#line 3952 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont2when2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2when2loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 1455 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		shard++;
															#line 3961 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont2when2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2when2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2when2loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2when2loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetKeyRangeLocations_internalActor*>(this)->actor_wait_state > 0) static_cast<GetKeyRangeLocations_internalActor*>(this)->actor_wait_state = 0;
		static_cast<GetKeyRangeLocations_internalActor*>(this)->ActorCallback< GetKeyRangeLocations_internalActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetKeyRangeLocations_internalActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyRangeLocations_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetKeyRangeLocations_internalActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyRangeLocations_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetKeyRangeLocations_internalActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyRangeLocations_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetKeyRangeLocations_internalActor, 2, GetKeyServerLocationsReply >*,GetKeyServerLocationsReply const& value) 
	{
		fdb_probe_actor_enter("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyRangeLocations_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetKeyRangeLocations_internalActor, 2, GetKeyServerLocationsReply >*,GetKeyServerLocationsReply && value) 
	{
		fdb_probe_actor_enter("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyRangeLocations_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetKeyRangeLocations_internalActor, 2, GetKeyServerLocationsReply >*,Error err) 
	{
		fdb_probe_actor_enter("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyRangeLocations_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 1420 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Database cx;
															#line 1420 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	TenantInfo tenant;
															#line 1420 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeyRange keys;
															#line 1420 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	int limit;
															#line 1420 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reverse reverse;
															#line 1420 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	SpanContext spanContext;
															#line 1420 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Optional<UID> debugID;
															#line 1420 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	UseProvisionalProxies useProvisionalProxies;
															#line 1420 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Version version;
															#line 1430 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Span span;
															#line 1447 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetKeyServerLocationsReply rep;
															#line 1453 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	std::vector<KeyRangeLocationInfo> results;
															#line 1454 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	int shard;
															#line 4137 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
};
// This generated class is to be used only via getKeyRangeLocations_internal()
															#line 1420 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetKeyRangeLocations_internalActor final : public Actor<std::vector<KeyRangeLocationInfo>>, public ActorCallback< GetKeyRangeLocations_internalActor, 0, Void >, public ActorCallback< GetKeyRangeLocations_internalActor, 1, Void >, public ActorCallback< GetKeyRangeLocations_internalActor, 2, GetKeyServerLocationsReply >, public ActorCallback< GetKeyRangeLocations_internalActor, 3, Void >, public FastAllocated<GetKeyRangeLocations_internalActor>, public GetKeyRangeLocations_internalActorState<GetKeyRangeLocations_internalActor> {
															#line 4142 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
	using FastAllocated<GetKeyRangeLocations_internalActor>::operator new;
	using FastAllocated<GetKeyRangeLocations_internalActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3387955214753972736UL, 5374463807529404928UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<KeyRangeLocationInfo>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetKeyRangeLocations_internalActor, 0, Void >;
friend struct ActorCallback< GetKeyRangeLocations_internalActor, 1, Void >;
friend struct ActorCallback< GetKeyRangeLocations_internalActor, 2, GetKeyServerLocationsReply >;
friend struct ActorCallback< GetKeyRangeLocations_internalActor, 3, Void >;
															#line 1420 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetKeyRangeLocations_internalActor(Database const& cx,TenantInfo const& tenant,KeyRange const& keys,int const& limit,Reverse const& reverse,SpanContext const& spanContext,Optional<UID> const& debugID,UseProvisionalProxies const& useProvisionalProxies,Version const& version) 
															#line 4162 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		 : Actor<std::vector<KeyRangeLocationInfo>>(),
		   GetKeyRangeLocations_internalActorState<GetKeyRangeLocations_internalActor>(cx, tenant, keys, limit, reverse, spanContext, debugID, useProvisionalProxies, version),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7661675249109580544UL, 8773323650101319936UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyRangeLocations_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getKeyRangeLocations_internal");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetKeyRangeLocations_internalActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetKeyRangeLocations_internalActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetKeyRangeLocations_internalActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1420 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<std::vector<KeyRangeLocationInfo>> getKeyRangeLocations_internal( Database const& cx, TenantInfo const& tenant, KeyRange const& keys, int const& limit, Reverse const& reverse, SpanContext const& spanContext, Optional<UID> const& debugID, UseProvisionalProxies const& useProvisionalProxies, Version const& version ) {
															#line 1420 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<std::vector<KeyRangeLocationInfo>>(new GetKeyRangeLocations_internalActor(cx, tenant, keys, limit, reverse, spanContext, debugID, useProvisionalProxies, version));
															#line 4197 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
}

#line 1482 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

// Get the SS locations for each shard in the 'keys' key-range;
// Returned vector size is the number of shards in the input keys key-range.
// Returned vector element is <ShardRange, storage server location info> pairs, where
// ShardRange is the whole shard key-range, not a part of the given key range.
// Example: If query the function with  key range (b, d), the returned list of pairs could be something like:
// [([a, b1), locationInfo), ([b1, c), locationInfo), ([c, d1), locationInfo)].
template <class F>
Future<std::vector<KeyRangeLocationInfo>> getKeyRangeLocations(Database const& cx,
                                                               TenantInfo const& tenant,
                                                               KeyRange const& keys,
                                                               int limit,
                                                               Reverse reverse,
                                                               F StorageServerInterface::* member,
                                                               SpanContext const& spanContext,
                                                               Optional<UID> const& debugID,
                                                               UseProvisionalProxies useProvisionalProxies,
                                                               Version version) {

	ASSERT(!keys.empty());

	std::vector<KeyRangeLocationInfo> locations;
	if (!cx->getCachedLocations(tenant, keys, locations, limit, reverse)) {
		return getKeyRangeLocations_internal(
		    cx, tenant, keys, limit, reverse, spanContext, debugID, useProvisionalProxies, version);
	}

	bool foundFailed = false;
	for (const auto& locationInfo : locations) {
		bool onlyEndpointFailedAndNeedRefresh = false;
		for (int i = 0; i < locationInfo.locations->size(); i++) {
			if (checkOnlyEndpointFailed(cx, locationInfo.locations->get(i, member).getEndpoint())) {
				onlyEndpointFailedAndNeedRefresh = true;
			}
		}

		if (onlyEndpointFailedAndNeedRefresh) {
			cx->invalidateCache(tenant.prefix, locationInfo.range.begin);
			foundFailed = true;
		}
	}

	if (foundFailed) {
		// Refresh the cache with a new getKeyRangeLocations made to proxies.
		return getKeyRangeLocations_internal(
		    cx, tenant, keys, limit, reverse, spanContext, debugID, useProvisionalProxies, version);
	}

	return locations;
}

template <class F>
Future<std::vector<KeyRangeLocationInfo>> getKeyRangeLocations(Reference<TransactionState> trState,
                                                               KeyRange const& keys,
                                                               int limit,
                                                               Reverse reverse,
                                                               F StorageServerInterface::* member,
                                                               UseTenant useTenant) {
	CODE_PROBE(!useTenant, "Get key range locations ignoring tenant");
	return getKeyRangeLocations(trState->cx,
	                            useTenant ? trState->getTenantInfo(AllowInvalidTenantID::True) : TenantInfo(),
	                            keys,
	                            limit,
	                            reverse,
	                            member,
	                            trState->spanContext,
	                            trState->readOptions.present() ? trState->readOptions.get().debugID : Optional<UID>(),
	                            trState->useProvisionalProxies,
	                            trState->readVersionFuture.isValid() && trState->readVersionFuture.isReady()
	                                ? trState->readVersion()
	                                : latestVersion);
}

															#line 4274 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
namespace {
// This generated class is to be used only via warmRange_impl()
															#line 1555 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class WarmRange_implActor>
															#line 1555 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class WarmRange_implActorState {
															#line 4281 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
															#line 1555 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	WarmRange_implActorState(Reference<TransactionState> const& trState,KeyRange const& keys) 
															#line 1555 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 1555 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : trState(trState),
															#line 1555 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   keys(keys),
															#line 1556 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   totalRanges(0),
															#line 1557 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   totalRequests(0)
															#line 4294 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
	{
		fdb_probe_actor_create("warmRange_impl", reinterpret_cast<unsigned long>(this));

	}
	~WarmRange_implActorState() 
	{
		fdb_probe_actor_destroy("warmRange_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1559 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_0 = trState->startTransaction();
															#line 1559 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<WarmRange_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4311 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WarmRange_implActor*>(this)->actor_wait_state = 1;
															#line 1559 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WarmRange_implActor, 0, Void >*>(static_cast<WarmRange_implActor*>(this)));
															#line 4316 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WarmRange_implActorState();
		static_cast<WarmRange_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1561 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		;
															#line 4339 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1561 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		;
															#line 4348 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WarmRange_implActor*>(this)->actor_wait_state > 0) static_cast<WarmRange_implActor*>(this)->actor_wait_state = 0;
		static_cast<WarmRange_implActor*>(this)->ActorCallback< WarmRange_implActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WarmRange_implActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("warmRange_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WarmRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("warmRange_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WarmRange_implActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("warmRange_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WarmRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("warmRange_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WarmRange_implActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("warmRange_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WarmRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("warmRange_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1596 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<WarmRange_implActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WarmRange_implActorState(); static_cast<WarmRange_implActor*>(this)->destroy(); return 0; }
															#line 4432 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<WarmRange_implActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WarmRange_implActorState();
		static_cast<WarmRange_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1562 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<std::vector<KeyRangeLocationInfo>> __when_expr_1 = getKeyRangeLocations_internal( trState->cx, trState->getTenantInfo(), keys, CLIENT_KNOBS->WARM_RANGE_SHARD_LIMIT, Reverse::False, trState->spanContext, trState->readOptions.present() ? trState->readOptions.get().debugID : Optional<UID>(), trState->useProvisionalProxies, trState->readVersion());
															#line 1562 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<WarmRange_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4453 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WarmRange_implActor*>(this)->actor_wait_state = 2;
															#line 1562 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WarmRange_implActor, 1, std::vector<KeyRangeLocationInfo> >*>(static_cast<WarmRange_implActor*>(this)));
															#line 4458 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(std::vector<KeyRangeLocationInfo> const& locations,int loopDepth) 
	{
															#line 1572 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		totalRanges += CLIENT_KNOBS->WARM_RANGE_SHARD_LIMIT;
															#line 1573 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		totalRequests++;
															#line 1574 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (locations.size() == 0 || totalRanges >= trState->cx->locationCacheSize || locations[locations.size() - 1].range.end >= keys.end)
															#line 4484 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1578 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		keys = KeyRangeRef(locations[locations.size() - 1].range.end, keys.end);
															#line 1580 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (totalRequests % 20 == 0)
															#line 4492 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 1582 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			tr = Transaction(trState->cx, trState->tenant());
															#line 1583 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			;
															#line 4498 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = a_body1cont1loopBody1cont1loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(std::vector<KeyRangeLocationInfo> && locations,int loopDepth) 
	{
															#line 1572 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		totalRanges += CLIENT_KNOBS->WARM_RANGE_SHARD_LIMIT;
															#line 1573 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		totalRequests++;
															#line 1574 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (locations.size() == 0 || totalRanges >= trState->cx->locationCacheSize || locations[locations.size() - 1].range.end >= keys.end)
															#line 4516 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1578 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		keys = KeyRangeRef(locations[locations.size() - 1].range.end, keys.end);
															#line 1580 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (totalRequests % 20 == 0)
															#line 4524 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 1582 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			tr = Transaction(trState->cx, trState->tenant());
															#line 1583 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			;
															#line 4530 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = a_body1cont1loopBody1cont1loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(std::vector<KeyRangeLocationInfo> const& locations,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(locations, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(std::vector<KeyRangeLocationInfo> && locations,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(locations), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WarmRange_implActor*>(this)->actor_wait_state > 0) static_cast<WarmRange_implActor*>(this)->actor_wait_state = 0;
		static_cast<WarmRange_implActor*>(this)->ActorCallback< WarmRange_implActor, 1, std::vector<KeyRangeLocationInfo> >::remove();

	}
	void a_callback_fire(ActorCallback< WarmRange_implActor, 1, std::vector<KeyRangeLocationInfo> >*,std::vector<KeyRangeLocationInfo> const& value) 
	{
		fdb_probe_actor_enter("warmRange_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WarmRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("warmRange_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WarmRange_implActor, 1, std::vector<KeyRangeLocationInfo> >*,std::vector<KeyRangeLocationInfo> && value) 
	{
		fdb_probe_actor_enter("warmRange_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WarmRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("warmRange_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WarmRange_implActor, 1, std::vector<KeyRangeLocationInfo> >*,Error err) 
	{
		fdb_probe_actor_enter("warmRange_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WarmRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("warmRange_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont2(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 1585 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1586 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			tr.setOption(FDBTransactionOptions::CAUSAL_READ_RISKY);
															#line 1587 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_2 = success(tr.getReadVersion());
															#line 1587 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<WarmRange_implActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4645 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont1loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<WarmRange_implActor*>(this)->actor_wait_state = 3;
															#line 1587 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WarmRange_implActor, 2, Void >*>(static_cast<WarmRange_implActor*>(this)));
															#line 4650 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1590 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 1590 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<WarmRange_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 4687 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1cont1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<WarmRange_implActor*>(this)->actor_wait_state = 4;
															#line 1590 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WarmRange_implActor, 3, Void >*>(static_cast<WarmRange_implActor*>(this)));
															#line 4692 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1cont1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1cont1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WarmRange_implActor*>(this)->actor_wait_state > 0) static_cast<WarmRange_implActor*>(this)->actor_wait_state = 0;
		static_cast<WarmRange_implActor*>(this)->ActorCallback< WarmRange_implActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WarmRange_implActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("warmRange_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WarmRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("warmRange_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WarmRange_implActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("warmRange_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WarmRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("warmRange_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WarmRange_implActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("warmRange_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WarmRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("warmRange_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<WarmRange_implActor*>(this)->actor_wait_state > 0) static_cast<WarmRange_implActor*>(this)->actor_wait_state = 0;
		static_cast<WarmRange_implActor*>(this)->ActorCallback< WarmRange_implActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WarmRange_implActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("warmRange_impl", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WarmRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("warmRange_impl", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< WarmRange_implActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("warmRange_impl", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WarmRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("warmRange_impl", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< WarmRange_implActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("warmRange_impl", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WarmRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("warmRange_impl", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 1555 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reference<TransactionState> trState;
															#line 1555 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeyRange keys;
															#line 1556 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	int totalRanges;
															#line 1557 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	int totalRequests;
															#line 1582 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Transaction tr;
															#line 4887 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
};
// This generated class is to be used only via warmRange_impl()
															#line 1555 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class WarmRange_implActor final : public Actor<Void>, public ActorCallback< WarmRange_implActor, 0, Void >, public ActorCallback< WarmRange_implActor, 1, std::vector<KeyRangeLocationInfo> >, public ActorCallback< WarmRange_implActor, 2, Void >, public ActorCallback< WarmRange_implActor, 3, Void >, public FastAllocated<WarmRange_implActor>, public WarmRange_implActorState<WarmRange_implActor> {
															#line 4892 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
	using FastAllocated<WarmRange_implActor>::operator new;
	using FastAllocated<WarmRange_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14592932931285855232UL, 15685289001692792320UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WarmRange_implActor, 0, Void >;
friend struct ActorCallback< WarmRange_implActor, 1, std::vector<KeyRangeLocationInfo> >;
friend struct ActorCallback< WarmRange_implActor, 2, Void >;
friend struct ActorCallback< WarmRange_implActor, 3, Void >;
															#line 1555 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	WarmRange_implActor(Reference<TransactionState> const& trState,KeyRange const& keys) 
															#line 4912 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		 : Actor<Void>(),
		   WarmRange_implActorState<WarmRange_implActor>(trState, keys),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("warmRange_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8548379736654756608UL, 17106069152090307840UL);
		ActorExecutionContextHelper __helper(static_cast<WarmRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("warmRange_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("warmRange_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WarmRange_implActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WarmRange_implActor, 1, std::vector<KeyRangeLocationInfo> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WarmRange_implActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< WarmRange_implActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1555 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<Void> warmRange_impl( Reference<TransactionState> const& trState, KeyRange const& keys ) {
															#line 1555 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Void>(new WarmRange_implActor(trState, keys));
															#line 4948 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
}

#line 1598 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

SpanContext generateSpanID(bool transactionTracingSample, SpanContext parentContext = SpanContext()) {
	if (parentContext.isValid()) {
		return SpanContext(parentContext.traceID, deterministicRandom()->randomUInt64(), parentContext.m_Flags);
	}
	if (transactionTracingSample) {
		return SpanContext(deterministicRandom()->randomUniqueID(),
		                   deterministicRandom()->randomUInt64(),
		                   deterministicRandom()->random01() <= FLOW_KNOBS->TRACING_SAMPLE_RATE
		                       ? TraceFlags::sampled
		                       : TraceFlags::unsampled);
	}
	return SpanContext(
	    deterministicRandom()->randomUniqueID(), deterministicRandom()->randomUInt64(), TraceFlags::unsampled);
}

															#line 4968 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
namespace {
// This generated class is to be used only via lookupTenantImpl()
															#line 1614 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class LookupTenantImplActor>
															#line 1614 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class LookupTenantImplActorState {
															#line 4975 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
															#line 1614 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	LookupTenantImplActorState(DatabaseContext* const& cx,TenantName const& tenant) 
															#line 1614 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 1614 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : cx(cx),
															#line 1614 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   tenant(tenant)
															#line 4984 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
	{
		fdb_probe_actor_create("lookupTenantImpl", reinterpret_cast<unsigned long>(this));

	}
	~LookupTenantImplActorState() 
	{
		fdb_probe_actor_destroy("lookupTenantImpl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1615 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			;
															#line 4999 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LookupTenantImplActorState();
		static_cast<LookupTenantImplActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1617 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_0 = cx->getBackoff();
															#line 1617 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<LookupTenantImplActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5032 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<LookupTenantImplActor*>(this)->actor_wait_state = 1;
															#line 1617 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LookupTenantImplActor, 0, Void >*>(static_cast<LookupTenantImplActor*>(this)));
															#line 5037 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1632 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (e.code() == error_code_commit_proxy_memory_limit_exceeded)
															#line 5059 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 1633 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				CODE_PROBE(true, "Lookup tenant memory limit exceeded");
															#line 1634 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				TraceEvent(SevWarnAlways, "CommitProxyOverloadedForTenant").suppressFor(5);
															#line 1636 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				cx->updateBackoff(e);
															#line 5067 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				return a_body1loopHead1(loopDepth); // continue
			}
															#line 1640 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 5072 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 1619 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++cx->transactionTenantLookupRequests;
															#line 1621 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_1 = cx->onProxiesChanged();
															#line 1620 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<LookupTenantImplActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5090 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
															#line 1622 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<GetTenantIdReply> __when_expr_2 = basicLoadBalance(cx->getCommitProxies(UseProvisionalProxies::False), &CommitProxyInterface::getTenantId, GetTenantIdRequest(tenant, latestVersion), TaskPriority::DefaultPromiseEndpoint);
															#line 5094 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont2when2(__when_expr_2.get(), loopDepth); };
		static_cast<LookupTenantImplActor*>(this)->actor_wait_state = 2;
															#line 1621 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LookupTenantImplActor, 1, Void >*>(static_cast<LookupTenantImplActor*>(this)));
															#line 1622 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< LookupTenantImplActor, 2, GetTenantIdReply >*>(static_cast<LookupTenantImplActor*>(this)));
															#line 5101 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 1619 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++cx->transactionTenantLookupRequests;
															#line 1621 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_1 = cx->onProxiesChanged();
															#line 1620 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<LookupTenantImplActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5114 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
															#line 1622 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<GetTenantIdReply> __when_expr_2 = basicLoadBalance(cx->getCommitProxies(UseProvisionalProxies::False), &CommitProxyInterface::getTenantId, GetTenantIdRequest(tenant, latestVersion), TaskPriority::DefaultPromiseEndpoint);
															#line 5118 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont2when2(__when_expr_2.get(), loopDepth); };
		static_cast<LookupTenantImplActor*>(this)->actor_wait_state = 2;
															#line 1621 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LookupTenantImplActor, 1, Void >*>(static_cast<LookupTenantImplActor*>(this)));
															#line 1622 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< LookupTenantImplActor, 2, GetTenantIdReply >*>(static_cast<LookupTenantImplActor*>(this)));
															#line 5125 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LookupTenantImplActor*>(this)->actor_wait_state > 0) static_cast<LookupTenantImplActor*>(this)->actor_wait_state = 0;
		static_cast<LookupTenantImplActor*>(this)->ActorCallback< LookupTenantImplActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LookupTenantImplActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("lookupTenantImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LookupTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lookupTenantImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LookupTenantImplActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("lookupTenantImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LookupTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lookupTenantImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LookupTenantImplActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("lookupTenantImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LookupTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lookupTenantImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when2(GetTenantIdReply const& rep,int loopDepth) 
	{
															#line 1626 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++cx->transactionTenantLookupRequestsCompleted;
															#line 1627 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		cx->updateBackoff(success());
															#line 1628 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<LookupTenantImplActor*>(this)->SAV<int64_t>::futures) { (void)(rep.tenantId); this->~LookupTenantImplActorState(); static_cast<LookupTenantImplActor*>(this)->destroy(); return 0; }
															#line 5231 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<LookupTenantImplActor*>(this)->SAV< int64_t >::value()) int64_t(rep.tenantId);
		this->~LookupTenantImplActorState();
		static_cast<LookupTenantImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when2(GetTenantIdReply && rep,int loopDepth) 
	{
															#line 1626 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++cx->transactionTenantLookupRequestsCompleted;
															#line 1627 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		cx->updateBackoff(success());
															#line 1628 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<LookupTenantImplActor*>(this)->SAV<int64_t>::futures) { (void)(rep.tenantId); this->~LookupTenantImplActorState(); static_cast<LookupTenantImplActor*>(this)->destroy(); return 0; }
															#line 5247 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<LookupTenantImplActor*>(this)->SAV< int64_t >::value()) int64_t(rep.tenantId);
		this->~LookupTenantImplActorState();
		static_cast<LookupTenantImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<LookupTenantImplActor*>(this)->actor_wait_state > 0) static_cast<LookupTenantImplActor*>(this)->actor_wait_state = 0;
		static_cast<LookupTenantImplActor*>(this)->ActorCallback< LookupTenantImplActor, 1, Void >::remove();
		static_cast<LookupTenantImplActor*>(this)->ActorCallback< LookupTenantImplActor, 2, GetTenantIdReply >::remove();

	}
	void a_callback_fire(ActorCallback< LookupTenantImplActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("lookupTenantImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LookupTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lookupTenantImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< LookupTenantImplActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("lookupTenantImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LookupTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lookupTenantImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< LookupTenantImplActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("lookupTenantImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LookupTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lookupTenantImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< LookupTenantImplActor, 2, GetTenantIdReply >*,GetTenantIdReply const& value) 
	{
		fdb_probe_actor_enter("lookupTenantImpl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LookupTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lookupTenantImpl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< LookupTenantImplActor, 2, GetTenantIdReply >*,GetTenantIdReply && value) 
	{
		fdb_probe_actor_enter("lookupTenantImpl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LookupTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lookupTenantImpl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< LookupTenantImplActor, 2, GetTenantIdReply >*,Error err) 
	{
		fdb_probe_actor_enter("lookupTenantImpl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LookupTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lookupTenantImpl", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 1614 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	DatabaseContext* cx;
															#line 1614 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	TenantName tenant;
															#line 5393 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
};
// This generated class is to be used only via lookupTenantImpl()
															#line 1614 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class LookupTenantImplActor final : public Actor<int64_t>, public ActorCallback< LookupTenantImplActor, 0, Void >, public ActorCallback< LookupTenantImplActor, 1, Void >, public ActorCallback< LookupTenantImplActor, 2, GetTenantIdReply >, public FastAllocated<LookupTenantImplActor>, public LookupTenantImplActorState<LookupTenantImplActor> {
															#line 5398 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
	using FastAllocated<LookupTenantImplActor>::operator new;
	using FastAllocated<LookupTenantImplActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16508827140310030848UL, 5454547467732492544UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int64_t>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LookupTenantImplActor, 0, Void >;
friend struct ActorCallback< LookupTenantImplActor, 1, Void >;
friend struct ActorCallback< LookupTenantImplActor, 2, GetTenantIdReply >;
															#line 1614 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	LookupTenantImplActor(DatabaseContext* const& cx,TenantName const& tenant) 
															#line 5417 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		 : Actor<int64_t>(),
		   LookupTenantImplActorState<LookupTenantImplActor>(cx, tenant),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("lookupTenantImpl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11585582208618864384UL, 12455856959616988672UL);
		ActorExecutionContextHelper __helper(static_cast<LookupTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("lookupTenantImpl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("lookupTenantImpl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LookupTenantImplActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< LookupTenantImplActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1614 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<int64_t> lookupTenantImpl( DatabaseContext* const& cx, TenantName const& tenant ) {
															#line 1614 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<int64_t>(new LookupTenantImplActor(cx, tenant));
															#line 5451 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
}

#line 1644 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

Future<int64_t> DatabaseContext::lookupTenant(TenantName tenant) {
	return lookupTenantImpl(this, tenant);
}

TransactionState::TransactionState(Database cx,
                                   Optional<Reference<Tenant>> tenant,
                                   TaskPriority taskID,
                                   SpanContext spanContext,
                                   Reference<TransactionLogInfo> trLogInfo)
  : cx(cx), trLogInfo(trLogInfo), options(cx), taskID(taskID), spanContext(spanContext),
    readVersionObtainedFromGrvProxy(true), tenant_(tenant), tenantSet(tenant.present()) {}

Reference<TransactionState> TransactionState::cloneAndReset(Reference<TransactionLogInfo> newTrLogInfo,
                                                            bool generateNewSpan) const {

	SpanContext newSpanContext = generateNewSpan ? generateSpanID(cx->transactionTracingSample) : spanContext;
	Reference<TransactionState> newState =
	    makeReference<TransactionState>(cx, tenant_, cx->taskID, newSpanContext, newTrLogInfo);

	if (!cx->apiVersionAtLeast(16)) {
		newState->options = options;
	}

	newState->readVersionFuture = Future<Version>();
	newState->metadataVersion = Promise<Optional<Key>>();
	newState->numErrors = numErrors;
	newState->startTime = startTime;
	newState->committedVersion = committedVersion;
	newState->conflictingKeys = conflictingKeys;
	newState->tenantSet = tenantSet;

	return newState;
}

TenantInfo TransactionState::getTenantInfo(AllowInvalidTenantID allowInvalidTenantId /* = false */) {
	Optional<Reference<Tenant>> const& t = tenant();

	if (options.rawAccess) {
		CODE_PROBE(true, "Get tenant info raw access transaction");
		return TenantInfo();
	} else if (!cx->internal && cx->clientInfo->get().clusterType == ClusterType::METACLUSTER_MANAGEMENT) {
		CODE_PROBE(true, "Get tenant info invalid management cluster access", probe::decoration::rare);
		throw management_cluster_invalid_access();
	} else if (!cx->internal && cx->clientInfo->get().tenantMode == TenantMode::REQUIRED && !t.present()) {
		CODE_PROBE(true, "Get tenant info tenant name required", probe::decoration::rare);
		throw tenant_name_required();
	} else if (!t.present()) {
		CODE_PROBE(true, "Get tenant info without tenant");
		return TenantInfo();
	} else if (cx->clientInfo->get().tenantMode == TenantMode::DISABLED && t.present()) {
		// If we are running provisional proxies, we allow a tenant request to go through since we don't know the tenant
		// mode. Such a transaction would not be allowed to commit without enabling provisional commits because either
		// the commit proxies will be provisional or the read version will be too old.
		if (!cx->clientInfo->get().grvProxies.empty() && !cx->clientInfo->get().grvProxies[0].provisional) {
			CODE_PROBE(true, "Get tenant info use tenant in disabled tenant mode", probe::decoration::rare);
			throw tenants_disabled();
		} else {
			CODE_PROBE(true, "Get tenant info provisional proxies");
			ASSERT(!useProvisionalProxies);
		}
	}

	ASSERT(t.present() && (allowInvalidTenantId || t.get()->id() != TenantInfo::INVALID_TENANT));
	return TenantInfo(
	    (allowInvalidTenantId && !t.get()->ready().isReady()) ? TenantInfo::INVALID_TENANT : t.get()->id(), authToken);
}

// Returns the tenant used in this transaction. If the tenant is unset and raw access isn't specified, then the default
// tenant from DatabaseContext is applied to this transaction (note: the default tenant is typically unset, but in
// simulation could be something different).
//
// This function should not be called in the transaction constructor or in the setOption function to allow a user the
// opportunity to set raw access.
Optional<Reference<Tenant>> const& TransactionState::tenant() {
	hasTenant(ResolveDefaultTenant::True);
	return tenant_;
}

// Returns true if the tenant has been set, but does not cause default tenant resolution. This is useful in setOption
// (where we do not want to call tenant()) if we want to enforce that an option not be set on a Tenant transaction (e.g.
// for raw access).
bool TransactionState::hasTenant(ResolveDefaultTenant resolveDefaultTenant) {
	if (!tenantSet && resolveDefaultTenant) {
		if (!options.rawAccess && cx->defaultTenant.present()) {
			tenant_ = makeReference<Tenant>(cx->lookupTenant(cx->defaultTenant.get()), cx->defaultTenant);
		}
		tenantSet = true;
	}

	return tenant_.present();
}

															#line 5548 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
namespace {
// This generated class is to be used only via startTransaction()
															#line 1737 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class StartTransactionActor>
															#line 1737 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class StartTransactionActorState {
															#line 5555 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
															#line 1737 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	StartTransactionActorState(Reference<TransactionState> const& trState) 
															#line 1737 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 1737 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : trState(trState)
															#line 5562 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
	{
		fdb_probe_actor_create("startTransaction", reinterpret_cast<unsigned long>(this));

	}
	~StartTransactionActorState() 
	{
		fdb_probe_actor_destroy("startTransaction", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1738 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(trState->readVersionFuture);
															#line 1738 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<StartTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5579 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<StartTransactionActor*>(this)->actor_wait_state = 1;
															#line 1738 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StartTransactionActor, 0, Void >*>(static_cast<StartTransactionActor*>(this)));
															#line 5584 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StartTransactionActorState();
		static_cast<StartTransactionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1739 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (trState->hasTenant())
															#line 5607 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 1740 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_1 = trState->tenant().get()->ready();
															#line 1740 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<StartTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5613 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<StartTransactionActor*>(this)->actor_wait_state = 2;
															#line 1740 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StartTransactionActor, 1, Void >*>(static_cast<StartTransactionActor*>(this)));
															#line 5618 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1739 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (trState->hasTenant())
															#line 5632 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 1740 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_1 = trState->tenant().get()->ready();
															#line 1740 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<StartTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5638 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<StartTransactionActor*>(this)->actor_wait_state = 2;
															#line 1740 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StartTransactionActor, 1, Void >*>(static_cast<StartTransactionActor*>(this)));
															#line 5643 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StartTransactionActor*>(this)->actor_wait_state > 0) static_cast<StartTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<StartTransactionActor*>(this)->ActorCallback< StartTransactionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartTransactionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StartTransactionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StartTransactionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1743 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<StartTransactionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartTransactionActorState(); static_cast<StartTransactionActor*>(this)->destroy(); return 0; }
															#line 5732 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<StartTransactionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~StartTransactionActorState();
		static_cast<StartTransactionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<StartTransactionActor*>(this)->actor_wait_state > 0) static_cast<StartTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<StartTransactionActor*>(this)->ActorCallback< StartTransactionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartTransactionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< StartTransactionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< StartTransactionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1737 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reference<TransactionState> trState;
															#line 5829 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
};
// This generated class is to be used only via startTransaction()
															#line 1737 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class StartTransactionActor final : public Actor<Void>, public ActorCallback< StartTransactionActor, 0, Void >, public ActorCallback< StartTransactionActor, 1, Void >, public FastAllocated<StartTransactionActor>, public StartTransactionActorState<StartTransactionActor> {
															#line 5834 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
	using FastAllocated<StartTransactionActor>::operator new;
	using FastAllocated<StartTransactionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11004004840262964736UL, 5541086657643102976UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StartTransactionActor, 0, Void >;
friend struct ActorCallback< StartTransactionActor, 1, Void >;
															#line 1737 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	StartTransactionActor(Reference<TransactionState> const& trState) 
															#line 5852 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		 : Actor<Void>(),
		   StartTransactionActorState<StartTransactionActor>(trState),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("startTransaction", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7927092769933293824UL, 16612754116029991424UL);
		ActorExecutionContextHelper __helper(static_cast<StartTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("startTransaction");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("startTransaction", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StartTransactionActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< StartTransactionActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1737 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<Void> startTransaction( Reference<TransactionState> const& trState ) {
															#line 1737 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Void>(new StartTransactionActor(trState));
															#line 5886 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
}

#line 1745 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

Future<Void> TransactionState::startTransaction(uint32_t readVersionFlags) {
	if (!startFuture.isValid()) {
		if (!readVersionFuture.isValid()) {
			readVersionFuture = getReadVersion(readVersionFlags);
		}
		if (readVersionFuture.isReady() && (!hasTenant() || tenant().get()->ready().isReady())) {
			startFuture = Void();
		} else {
			startFuture = ::startTransaction(Reference<TransactionState>::addRef(this));
		}
	}

	return startFuture;
}

Future<Void> Transaction::warmRange(KeyRange keys) {
	return warmRange_impl(trState, keys);
}

namespace {

template <class Interface, class Request, bool P>
Future<REPLY_TYPE(Request)> loadBalance(
    DatabaseContext* ctx,
    const Reference<LocationInfo> alternatives,
    RequestStream<Request, P> Interface::* channel,
    const Request& request = Request(),
    TaskPriority taskID = TaskPriority::DefaultPromiseEndpoint,
    AtMostOnce atMostOnce =
        AtMostOnce::False, // if true, throws request_maybe_delivered() instead of retrying automatically
    QueueModel* model = nullptr,
    bool compareReplicas = false,
    int requiredReplicas = 0) {
	return fmap(
	    [ctx](auto const& res) {
		    if (res.cached) {
			    ctx->updateCache.trigger();
		    }
		    return res;
	    },
	    loadBalance(
	        alternatives->locations(), channel, request, taskID, atMostOnce, model, compareReplicas, requiredReplicas));
}
} // namespace

															#line 5936 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
namespace {
// This generated class is to be used only via getValue()
															#line 1791 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class GetValueActor>
															#line 1791 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetValueActorState {
															#line 5943 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
															#line 1791 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetValueActorState(Reference<TransactionState> const& trState,Key const& key,UseTenant const& useTenant,TransactionRecordLogInfo const& recordLogInfo) 
															#line 1791 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 1791 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : trState(trState),
															#line 1791 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   key(key),
															#line 1791 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   useTenant(useTenant),
															#line 1791 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   recordLogInfo(recordLogInfo)
															#line 5956 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
	{
		fdb_probe_actor_create("getValue", reinterpret_cast<unsigned long>(this));

	}
	~GetValueActorState() 
	{
		fdb_probe_actor_destroy("getValue", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1795 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_0 = trState->startTransaction();
															#line 1795 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<GetValueActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5973 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetValueActor*>(this)->actor_wait_state = 1;
															#line 1795 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetValueActor, 0, Void >*>(static_cast<GetValueActor*>(this)));
															#line 5978 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetValueActorState();
		static_cast<GetValueActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1797 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		CODE_PROBE(trState->hasTenant(), "NativeAPI getValue has tenant");
															#line 1799 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		span = Span("NAPI:getValue"_loc, trState->spanContext);
															#line 1800 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (useTenant && trState->hasTenant())
															#line 6005 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 1801 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			span.addAttribute("tenant"_sr, trState->tenant().get()->name.castTo<TenantNameRef>().orDefault("<unspecified>"_sr));
															#line 6009 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 1805 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		trState->cx->validateVersion(trState->readVersion());
															#line 1807 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		;
															#line 6015 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1797 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		CODE_PROBE(trState->hasTenant(), "NativeAPI getValue has tenant");
															#line 1799 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		span = Span("NAPI:getValue"_loc, trState->spanContext);
															#line 1800 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (useTenant && trState->hasTenant())
															#line 6028 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 1801 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			span.addAttribute("tenant"_sr, trState->tenant().get()->name.castTo<TenantNameRef>().orDefault("<unspecified>"_sr));
															#line 6032 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 1805 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		trState->cx->validateVersion(trState->readVersion());
															#line 1807 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		;
															#line 6038 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetValueActor*>(this)->actor_wait_state > 0) static_cast<GetValueActor*>(this)->actor_wait_state = 0;
		static_cast<GetValueActor*>(this)->ActorCallback< GetValueActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetValueActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getValue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getValue", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetValueActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getValue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getValue", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetValueActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getValue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getValue", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1808 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<KeyRangeLocationInfo> __when_expr_1 = getKeyLocation(trState, key, &StorageServerInterface::getValue, Reverse::False, useTenant);
															#line 1808 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetValueActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6131 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetValueActor*>(this)->actor_wait_state = 2;
															#line 1808 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetValueActor, 1, KeyRangeLocationInfo >*>(static_cast<GetValueActor*>(this)));
															#line 6136 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 1811 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		getValueID = Optional<UID>();
															#line 1812 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		startTime = uint64_t();
															#line 1813 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		startTimeD = double();
															#line 1814 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ssLatestCommitVersions = VersionVector();
															#line 1815 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		readOptions = trState->readOptions;
															#line 1817 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		trState->cx->getLatestCommitVersions(locationInfo.locations, trState, ssLatestCommitVersions);
															#line 6155 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		try {
															#line 1819 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (trState->readOptions.present() && trState->readOptions.get().debugID.present())
															#line 6159 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 1820 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				getValueID = nondeterministicRandom()->randomUniqueID();
															#line 1821 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				readOptions.get().debugID = getValueID;
															#line 1823 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				g_traceBatch.addAttach( "GetValueAttachID", trState->readOptions.get().debugID.get().first(), getValueID.get().first());
															#line 1825 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				g_traceBatch.addEvent("GetValueDebug", getValueID.get().first(), "NativeAPI.getValue.Before");
															#line 6169 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 1834 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			++trState->cx->getValueSubmitted;
															#line 1835 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			startTime = timer_int();
															#line 1836 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			startTimeD = now();
															#line 1837 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			++trState->cx->transactionPhysicalReads;
															#line 1839 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			reply = GetValueReply();
															#line 6181 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			try {
															#line 1841 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (CLIENT_BUGGIFY_WITH_PROB(.01))
															#line 6185 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				{
															#line 1842 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					return a_body1cont1loopBody1cont1Catch2(deterministicRandom()->randomChoice( std::vector<Error>{ transaction_too_old(), future_version() }), loopDepth);
															#line 6189 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				}
															#line 1846 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				StrictFuture<Void> __when_expr_2 = trState->cx->connectionFileChanged();
															#line 1845 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (static_cast<GetValueActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont1Catch2(actor_cancelled(), loopDepth);
															#line 6195 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1cont1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
															#line 1849 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				StrictFuture<GetValueReply> __when_expr_3 = loadBalance(trState->cx.getPtr(), locationInfo.locations, &StorageServerInterface::getValue, GetValueRequest(span.context, useTenant ? trState->getTenantInfo() : TenantInfo(), key, trState->readVersion(), trState->cx->sampleReadTags() ? trState->options.readTags : Optional<TagSet>(), readOptions, ssLatestCommitVersions), TaskPriority::DefaultPromiseEndpoint, AtMostOnce::False, trState->cx->enableLocalityLoadBalance ? &trState->cx->queueModel : nullptr, trState->options.enableReplicaConsistencyCheck, trState->options.requiredReplicas);
															#line 6199 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1cont1Catch2(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1cont1when2(__when_expr_3.get(), loopDepth); };
				static_cast<GetValueActor*>(this)->actor_wait_state = 3;
															#line 1846 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetValueActor, 2, Void >*>(static_cast<GetValueActor*>(this)));
															#line 1849 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetValueActor, 3, GetValueReply >*>(static_cast<GetValueActor*>(this)));
															#line 6206 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont1loopBody1cont1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont1loopBody1cont1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(KeyRangeLocationInfo const& __locationInfo,int loopDepth) 
	{
															#line 1808 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		locationInfo = __locationInfo;
															#line 6227 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(KeyRangeLocationInfo && __locationInfo,int loopDepth) 
	{
		locationInfo = std::move(__locationInfo);
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetValueActor*>(this)->actor_wait_state > 0) static_cast<GetValueActor*>(this)->actor_wait_state = 0;
		static_cast<GetValueActor*>(this)->ActorCallback< GetValueActor, 1, KeyRangeLocationInfo >::remove();

	}
	void a_callback_fire(ActorCallback< GetValueActor, 1, KeyRangeLocationInfo >*,KeyRangeLocationInfo const& value) 
	{
		fdb_probe_actor_enter("getValue", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getValue", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetValueActor, 1, KeyRangeLocationInfo >*,KeyRangeLocationInfo && value) 
	{
		fdb_probe_actor_enter("getValue", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getValue", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetValueActor, 1, KeyRangeLocationInfo >*,Error err) 
	{
		fdb_probe_actor_enter("getValue", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getValue", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont2(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1905 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			trState->cx->getValueCompleted->latency = timer_int() - startTime;
															#line 1906 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			trState->cx->getValueCompleted->log();
															#line 1907 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (getValueID.present())
															#line 6317 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 1908 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				g_traceBatch.addEvent("GetValueDebug", getValueID.get().first(), "NativeAPI.getValue.Error");
															#line 6321 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 1916 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (e.code() == error_code_wrong_shard_server || e.code() == error_code_all_alternatives_failed)
															#line 6325 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 1917 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				trState->cx->invalidateCache(useTenant ? trState->tenant().mapRef(&Tenant::prefix) : Optional<KeyRef>(), key);
															#line 1919 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				StrictFuture<Void> __when_expr_4 = delay(CLIENT_KNOBS->WRONG_SHARD_SERVER_DELAY, trState->taskID);
															#line 1919 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (static_cast<GetValueActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6333 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1Catch1when1(__when_expr_4.get(), loopDepth); };
				static_cast<GetValueActor*>(this)->actor_wait_state = 4;
															#line 1919 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< GetValueActor, 4, Void >*>(static_cast<GetValueActor*>(this)));
															#line 6338 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 1921 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (trState->trLogInfo && recordLogInfo)
															#line 6345 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				{
															#line 1922 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					trState->trLogInfo->addLog( FdbClientLogEvents::EventGetError(startTimeD, trState->cx->clientLocality.dcId(), static_cast<int>(e.code()), key, trState->tenant().flatMapRef(&Tenant::name)));
															#line 6349 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				}
															#line 1928 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 6353 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(int loopDepth) 
	{
															#line 1875 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		double latency = now() - startTimeD;
															#line 1876 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		trState->cx->readLatencies.addSample(latency);
															#line 1877 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (trState->trLogInfo && recordLogInfo)
															#line 6372 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 1878 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			int valueSize = reply.value.present() ? reply.value.get().size() : 0;
															#line 1879 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			trState->trLogInfo->addLog(FdbClientLogEvents::EventGet(startTimeD, trState->cx->clientLocality.dcId(), latency, valueSize, key, trState->tenant().flatMapRef(&Tenant::name)));
															#line 6378 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 1886 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		trState->cx->getValueCompleted->latency = timer_int() - startTime;
															#line 1887 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		trState->cx->getValueCompleted->log();
															#line 1888 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		trState->totalCost += getReadOperationCost(key.size() + (reply.value.present() ? reply.value.get().size() : 0));
															#line 1891 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (getValueID.present())
															#line 6388 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 1892 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			g_traceBatch.addEvent("GetValueDebug", getValueID.get().first(), "NativeAPI.getValue.After");
															#line 6392 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 1901 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		trState->cx->transactionBytesRead += reply.value.present() ? reply.value.get().size() : 0;
															#line 1902 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++trState->cx->transactionKeysRead;
															#line 1903 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetValueActor*>(this)->SAV<Optional<Value>>::futures) { (void)(reply.value); this->~GetValueActorState(); static_cast<GetValueActor*>(this)->destroy(); return 0; }
															#line 6400 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<GetValueActor*>(this)->SAV< Optional<Value> >::value()) Optional<Value>(reply.value);
		this->~GetValueActorState();
		static_cast<GetValueActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch2(const Error& __current_error,int loopDepth=0) 
	{
		try {
															#line 1871 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			++trState->cx->transactionPhysicalReadsCompleted;
															#line 1872 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			return a_body1cont1loopBody1cont1Catch1(__current_error, loopDepth);
															#line 6415 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5(int loopDepth) 
	{
															#line 1869 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++trState->cx->transactionPhysicalReadsCompleted;
															#line 6429 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
															#line 1847 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		return a_body1cont1loopBody1cont1Catch2(transaction_too_old(), loopDepth);
															#line 6438 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void && _,int loopDepth) 
	{
															#line 1847 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		return a_body1cont1loopBody1cont1Catch2(transaction_too_old(), loopDepth);
															#line 6446 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when2(GetValueReply const& _reply,int loopDepth) 
	{
															#line 1866 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		reply = _reply;
															#line 6454 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when2(GetValueReply && _reply,int loopDepth) 
	{
															#line 1866 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		reply = _reply;
															#line 6463 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetValueActor*>(this)->actor_wait_state > 0) static_cast<GetValueActor*>(this)->actor_wait_state = 0;
		static_cast<GetValueActor*>(this)->ActorCallback< GetValueActor, 2, Void >::remove();
		static_cast<GetValueActor*>(this)->ActorCallback< GetValueActor, 3, GetValueReply >::remove();

	}
	void a_callback_fire(ActorCallback< GetValueActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getValue", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch2(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getValue", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetValueActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getValue", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch2(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getValue", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetValueActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getValue", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch2(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getValue", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetValueActor, 3, GetValueReply >*,GetValueReply const& value) 
	{
		fdb_probe_actor_enter("getValue", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch2(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getValue", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetValueActor, 3, GetValueReply >*,GetValueReply && value) 
	{
		fdb_probe_actor_enter("getValue", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch2(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getValue", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetValueActor, 3, GetValueReply >*,Error err) 
	{
		fdb_probe_actor_enter("getValue", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch2(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getValue", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1Catch1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1Catch1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<GetValueActor*>(this)->actor_wait_state > 0) static_cast<GetValueActor*>(this)->actor_wait_state = 0;
		static_cast<GetValueActor*>(this)->ActorCallback< GetValueActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetValueActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getValue", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getValue", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< GetValueActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getValue", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getValue", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< GetValueActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getValue", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getValue", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 1791 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reference<TransactionState> trState;
															#line 1791 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Key key;
															#line 1791 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	UseTenant useTenant;
															#line 1791 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	TransactionRecordLogInfo recordLogInfo;
															#line 1799 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Span span;
															#line 1808 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeyRangeLocationInfo locationInfo;
															#line 1811 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Optional<UID> getValueID;
															#line 1812 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	uint64_t startTime;
															#line 1813 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	double startTimeD;
															#line 1814 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	VersionVector ssLatestCommitVersions;
															#line 1815 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Optional<ReadOptions> readOptions;
															#line 1839 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetValueReply reply;
															#line 6719 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
};
// This generated class is to be used only via getValue()
															#line 1791 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetValueActor final : public Actor<Optional<Value>>, public ActorCallback< GetValueActor, 0, Void >, public ActorCallback< GetValueActor, 1, KeyRangeLocationInfo >, public ActorCallback< GetValueActor, 2, Void >, public ActorCallback< GetValueActor, 3, GetValueReply >, public ActorCallback< GetValueActor, 4, Void >, public FastAllocated<GetValueActor>, public GetValueActorState<GetValueActor> {
															#line 6724 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
	using FastAllocated<GetValueActor>::operator new;
	using FastAllocated<GetValueActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3759287691971721472UL, 8197654407464304896UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<Value>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetValueActor, 0, Void >;
friend struct ActorCallback< GetValueActor, 1, KeyRangeLocationInfo >;
friend struct ActorCallback< GetValueActor, 2, Void >;
friend struct ActorCallback< GetValueActor, 3, GetValueReply >;
friend struct ActorCallback< GetValueActor, 4, Void >;
															#line 1791 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetValueActor(Reference<TransactionState> const& trState,Key const& key,UseTenant const& useTenant,TransactionRecordLogInfo const& recordLogInfo) 
															#line 6745 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		 : Actor<Optional<Value>>(),
		   GetValueActorState<GetValueActor>(trState, key, useTenant, recordLogInfo),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getValue", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4269006456623515904UL, 18410873568439542016UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getValue");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getValue", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetValueActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetValueActor, 1, KeyRangeLocationInfo >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetValueActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< GetValueActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1791 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<Optional<Value>> getValue( Reference<TransactionState> const& trState, Key const& key, UseTenant const& useTenant, TransactionRecordLogInfo const& recordLogInfo ) {
															#line 1791 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Optional<Value>>(new GetValueActor(trState, key, useTenant, recordLogInfo));
															#line 6781 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
}

#line 1933 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

															#line 6786 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
namespace {
// This generated class is to be used only via getKey()
															#line 1934 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class GetKeyActor>
															#line 1934 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetKeyActorState {
															#line 6793 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
															#line 1934 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetKeyActorState(Reference<TransactionState> const& trState,KeySelector const& k,UseTenant const& useTenant = UseTenant::True) 
															#line 1934 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 1934 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : trState(trState),
															#line 1934 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   k(k),
															#line 1934 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   useTenant(useTenant)
															#line 6804 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
	{
		fdb_probe_actor_create("getKey", reinterpret_cast<unsigned long>(this));

	}
	~GetKeyActorState() 
	{
		fdb_probe_actor_destroy("getKey", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1935 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			CODE_PROBE(!useTenant, "Get key ignoring tenant");
															#line 1936 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_0 = trState->startTransaction();
															#line 1936 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<GetKeyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6823 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetKeyActor*>(this)->actor_wait_state = 1;
															#line 1936 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetKeyActor, 0, Void >*>(static_cast<GetKeyActor*>(this)));
															#line 6828 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetKeyActorState();
		static_cast<GetKeyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1938 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		CODE_PROBE(trState->hasTenant(), "NativeAPI getKey has tenant");
															#line 1940 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		getKeyID = Optional<UID>();
															#line 1941 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		readOptions = trState->readOptions;
															#line 1943 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		span = Span("NAPI:getKey"_loc, trState->spanContext);
															#line 1944 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (trState->readOptions.present() && trState->readOptions.get().debugID.present())
															#line 6859 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 1945 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			getKeyID = nondeterministicRandom()->randomUniqueID();
															#line 1946 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			readOptions.get().debugID = getKeyID;
															#line 1948 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			g_traceBatch.addAttach( "GetKeyAttachID", trState->readOptions.get().debugID.get().first(), getKeyID.get().first());
															#line 1950 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			g_traceBatch.addEvent( "GetKeyDebug", getKeyID.get().first(), "NativeAPI.getKey.AfterVersion");
															#line 6869 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 1957 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		;
															#line 6873 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1938 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		CODE_PROBE(trState->hasTenant(), "NativeAPI getKey has tenant");
															#line 1940 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		getKeyID = Optional<UID>();
															#line 1941 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		readOptions = trState->readOptions;
															#line 1943 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		span = Span("NAPI:getKey"_loc, trState->spanContext);
															#line 1944 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (trState->readOptions.present() && trState->readOptions.get().debugID.present())
															#line 6890 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 1945 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			getKeyID = nondeterministicRandom()->randomUniqueID();
															#line 1946 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			readOptions.get().debugID = getKeyID;
															#line 1948 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			g_traceBatch.addAttach( "GetKeyAttachID", trState->readOptions.get().debugID.get().first(), getKeyID.get().first());
															#line 1950 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			g_traceBatch.addEvent( "GetKeyDebug", getKeyID.get().first(), "NativeAPI.getKey.AfterVersion");
															#line 6900 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 1957 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		;
															#line 6904 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetKeyActor*>(this)->actor_wait_state > 0) static_cast<GetKeyActor*>(this)->actor_wait_state = 0;
		static_cast<GetKeyActor*>(this)->ActorCallback< GetKeyActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetKeyActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetKeyActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetKeyActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1958 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (k.getKey() == allKeys.end)
															#line 6995 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 1959 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (k.offset > 0)
															#line 6999 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 1960 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (!static_cast<GetKeyActor*>(this)->SAV<Key>::futures) { (void)(allKeys.end); this->~GetKeyActorState(); static_cast<GetKeyActor*>(this)->destroy(); return 0; }
															#line 7003 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				new (&static_cast<GetKeyActor*>(this)->SAV< Key >::value()) Key(allKeys.end);
				this->~GetKeyActorState();
				static_cast<GetKeyActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1962 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			k.orEqual = false;
															#line 7011 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
		else
		{
															#line 1963 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (k.getKey() == allKeys.begin && k.offset <= 0)
															#line 7017 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 1964 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (!static_cast<GetKeyActor*>(this)->SAV<Key>::futures) { (void)(Key()); this->~GetKeyActorState(); static_cast<GetKeyActor*>(this)->destroy(); return 0; }
															#line 7021 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				new (&static_cast<GetKeyActor*>(this)->SAV< Key >::value()) Key(Key());
				this->~GetKeyActorState();
				static_cast<GetKeyActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 1967 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		Key locationKey(k.getKey(), k.arena());
															#line 1968 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<KeyRangeLocationInfo> __when_expr_1 = getKeyLocation( trState, locationKey, &StorageServerInterface::getKey, Reverse{ k.isBackward() }, useTenant);
															#line 1968 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetKeyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7034 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetKeyActor*>(this)->actor_wait_state = 2;
															#line 1968 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetKeyActor, 1, KeyRangeLocationInfo >*>(static_cast<GetKeyActor*>(this)));
															#line 7039 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 1971 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ssLatestCommitVersions = VersionVector();
															#line 1972 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		trState->cx->getLatestCommitVersions(locationInfo.locations, trState, ssLatestCommitVersions);
															#line 7050 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		try {
															#line 1975 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (getKeyID.present())
															#line 7054 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 1976 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				g_traceBatch.addEvent( "GetKeyDebug", getKeyID.get().first(), "NativeAPI.getKey.Before");
															#line 7058 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 1981 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			++trState->cx->transactionPhysicalReads;
															#line 1983 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			GetKeyRequest req(span.context, useTenant ? trState->getTenantInfo() : TenantInfo(), k, trState->readVersion(), trState->cx->sampleReadTags() ? trState->options.readTags : Optional<TagSet>(), readOptions, ssLatestCommitVersions);
															#line 1990 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			req.arena.dependsOn(k.arena());
															#line 1992 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			reply = GetKeyReply();
															#line 7068 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			try {
															#line 1995 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				StrictFuture<Void> __when_expr_2 = trState->cx->connectionFileChanged();
															#line 1994 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (static_cast<GetKeyActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont1Catch2(actor_cancelled(), loopDepth);
															#line 7074 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1cont1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
															#line 1998 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				StrictFuture<GetKeyReply> __when_expr_3 = loadBalance(trState->cx.getPtr(), locationInfo.locations, &StorageServerInterface::getKey, req, TaskPriority::DefaultPromiseEndpoint, AtMostOnce::False, trState->cx->enableLocalityLoadBalance ? &trState->cx->queueModel : nullptr, trState->options.enableReplicaConsistencyCheck, trState->options.requiredReplicas);
															#line 7078 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1cont1Catch2(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1cont1when2(__when_expr_3.get(), loopDepth); };
				static_cast<GetKeyActor*>(this)->actor_wait_state = 3;
															#line 1995 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetKeyActor, 2, Void >*>(static_cast<GetKeyActor*>(this)));
															#line 1998 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetKeyActor, 3, GetKeyReply >*>(static_cast<GetKeyActor*>(this)));
															#line 7085 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont1loopBody1cont1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont1loopBody1cont1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(KeyRangeLocationInfo const& __locationInfo,int loopDepth) 
	{
															#line 1968 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		locationInfo = __locationInfo;
															#line 7106 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(KeyRangeLocationInfo && __locationInfo,int loopDepth) 
	{
		locationInfo = std::move(__locationInfo);
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetKeyActor*>(this)->actor_wait_state > 0) static_cast<GetKeyActor*>(this)->actor_wait_state = 0;
		static_cast<GetKeyActor*>(this)->ActorCallback< GetKeyActor, 1, KeyRangeLocationInfo >::remove();

	}
	void a_callback_fire(ActorCallback< GetKeyActor, 1, KeyRangeLocationInfo >*,KeyRangeLocationInfo const& value) 
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetKeyActor, 1, KeyRangeLocationInfo >*,KeyRangeLocationInfo && value) 
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetKeyActor, 1, KeyRangeLocationInfo >*,Error err) 
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont6(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2026 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (getKeyID.present())
															#line 7192 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 2027 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				g_traceBatch.addEvent("GetKeyDebug", getKeyID.get().first(), "NativeAPI.getKey.Error");
															#line 7196 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 2028 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (e.code() == error_code_wrong_shard_server || e.code() == error_code_all_alternatives_failed)
															#line 7200 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 2029 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				trState->cx->invalidateCache(useTenant ? trState->tenant().mapRef(&Tenant::prefix) : Optional<KeyRef>(), k.getKey(), Reverse{ k.isBackward() });
															#line 2033 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				StrictFuture<Void> __when_expr_4 = delay(CLIENT_KNOBS->WRONG_SHARD_SERVER_DELAY, trState->taskID);
															#line 2033 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (static_cast<GetKeyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7208 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1Catch1when1(__when_expr_4.get(), loopDepth); };
				static_cast<GetKeyActor*>(this)->actor_wait_state = 4;
															#line 2033 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< GetKeyActor, 4, Void >*>(static_cast<GetKeyActor*>(this)));
															#line 7213 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 2035 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				TraceEvent(SevInfo, "GetKeyError").error(e).detail("AtKey", k.getKey()).detail("Offset", k.offset);
															#line 2036 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 7222 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont7(int loopDepth) 
	{
															#line 2016 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (getKeyID.present())
															#line 7237 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2017 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			g_traceBatch.addEvent("GetKeyDebug", getKeyID.get().first(), "NativeAPI.getKey.After");
															#line 7241 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 2021 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		k = reply.sel;
															#line 2022 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!k.offset && k.orEqual)
															#line 7247 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2023 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!static_cast<GetKeyActor*>(this)->SAV<Key>::futures) { (void)(k.getKey()); this->~GetKeyActorState(); static_cast<GetKeyActor*>(this)->destroy(); return 0; }
															#line 7251 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			new (&static_cast<GetKeyActor*>(this)->SAV< Key >::value()) Key(k.getKey());
			this->~GetKeyActorState();
			static_cast<GetKeyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont1loopBody1cont15(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch2(const Error& __current_error,int loopDepth=0) 
	{
		try {
															#line 2013 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			++trState->cx->transactionPhysicalReadsCompleted;
															#line 2014 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			return a_body1cont1loopBody1cont1Catch1(__current_error, loopDepth);
															#line 7268 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont9(int loopDepth) 
	{
															#line 2011 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++trState->cx->transactionPhysicalReadsCompleted;
															#line 7282 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
															#line 1996 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		return a_body1cont1loopBody1cont1Catch2(transaction_too_old(), loopDepth);
															#line 7291 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void && _,int loopDepth) 
	{
															#line 1996 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		return a_body1cont1loopBody1cont1Catch2(transaction_too_old(), loopDepth);
															#line 7299 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when2(GetKeyReply const& _reply,int loopDepth) 
	{
															#line 2008 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		reply = _reply;
															#line 7307 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when2(GetKeyReply && _reply,int loopDepth) 
	{
															#line 2008 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		reply = _reply;
															#line 7316 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetKeyActor*>(this)->actor_wait_state > 0) static_cast<GetKeyActor*>(this)->actor_wait_state = 0;
		static_cast<GetKeyActor*>(this)->ActorCallback< GetKeyActor, 2, Void >::remove();
		static_cast<GetKeyActor*>(this)->ActorCallback< GetKeyActor, 3, GetKeyReply >::remove();

	}
	void a_callback_fire(ActorCallback< GetKeyActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch2(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetKeyActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch2(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetKeyActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch2(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetKeyActor, 3, GetKeyReply >*,GetKeyReply const& value) 
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch2(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetKeyActor, 3, GetKeyReply >*,GetKeyReply && value) 
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch2(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetKeyActor, 3, GetKeyReply >*,Error err) 
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch2(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont11(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont15(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1Catch1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1Catch1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<GetKeyActor*>(this)->actor_wait_state > 0) static_cast<GetKeyActor*>(this)->actor_wait_state = 0;
		static_cast<GetKeyActor*>(this)->ActorCallback< GetKeyActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetKeyActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< GetKeyActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< GetKeyActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 1934 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reference<TransactionState> trState;
															#line 1934 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeySelector k;
															#line 1934 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	UseTenant useTenant;
															#line 1940 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Optional<UID> getKeyID;
															#line 1941 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Optional<ReadOptions> readOptions;
															#line 1943 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Span span;
															#line 1968 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeyRangeLocationInfo locationInfo;
															#line 1971 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	VersionVector ssLatestCommitVersions;
															#line 1992 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetKeyReply reply;
															#line 7579 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
};
// This generated class is to be used only via getKey()
															#line 1934 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetKeyActor final : public Actor<Key>, public ActorCallback< GetKeyActor, 0, Void >, public ActorCallback< GetKeyActor, 1, KeyRangeLocationInfo >, public ActorCallback< GetKeyActor, 2, Void >, public ActorCallback< GetKeyActor, 3, GetKeyReply >, public ActorCallback< GetKeyActor, 4, Void >, public FastAllocated<GetKeyActor>, public GetKeyActorState<GetKeyActor> {
															#line 7584 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
	using FastAllocated<GetKeyActor>::operator new;
	using FastAllocated<GetKeyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4461494077422944768UL, 9800899118657701632UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Key>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetKeyActor, 0, Void >;
friend struct ActorCallback< GetKeyActor, 1, KeyRangeLocationInfo >;
friend struct ActorCallback< GetKeyActor, 2, Void >;
friend struct ActorCallback< GetKeyActor, 3, GetKeyReply >;
friend struct ActorCallback< GetKeyActor, 4, Void >;
															#line 1934 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetKeyActor(Reference<TransactionState> const& trState,KeySelector const& k,UseTenant const& useTenant = UseTenant::True) 
															#line 7605 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		 : Actor<Key>(),
		   GetKeyActorState<GetKeyActor>(trState, k, useTenant),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3161838746568296704UL, 16159820804706226432UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getKey");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetKeyActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetKeyActor, 1, KeyRangeLocationInfo >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetKeyActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< GetKeyActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1934 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<Key> getKey( Reference<TransactionState> const& trState, KeySelector const& k, UseTenant const& useTenant = UseTenant::True ) {
															#line 1934 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Key>(new GetKeyActor(trState, k, useTenant));
															#line 7641 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
}

#line 2041 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

															#line 7646 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
namespace {
// This generated class is to be used only via waitForCommittedVersion()
															#line 2042 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class WaitForCommittedVersionActor>
															#line 2042 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class WaitForCommittedVersionActorState {
															#line 7653 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
															#line 2042 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	WaitForCommittedVersionActorState(Database const& cx,Version const& version,SpanContext const& spanContext) 
															#line 2042 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 2042 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : cx(cx),
															#line 2042 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   version(version),
															#line 2042 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   spanContext(spanContext),
															#line 2043 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   span("NAPI:waitForCommittedVersion"_loc, spanContext)
															#line 7666 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
	{
		fdb_probe_actor_create("waitForCommittedVersion", reinterpret_cast<unsigned long>(this));

	}
	~WaitForCommittedVersionActorState() 
	{
		fdb_probe_actor_destroy("waitForCommittedVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2044 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			;
															#line 7681 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitForCommittedVersionActorState();
		static_cast<WaitForCommittedVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 2047 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_0 = cx->onProxiesChanged();
															#line 2046 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<WaitForCommittedVersionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7714 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 2048 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<GetReadVersionReply> __when_expr_1 = basicLoadBalance( cx->getGrvProxies(UseProvisionalProxies::False), &GrvProxyInterface::getConsistentReadVersion, GetReadVersionRequest( span.context, 0, TransactionPriority::IMMEDIATE, cx->ssVersionVectorCache.getMaxVersion()), cx->taskID);
															#line 7718 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
			static_cast<WaitForCommittedVersionActor*>(this)->actor_wait_state = 1;
															#line 2047 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitForCommittedVersionActor, 0, Void >*>(static_cast<WaitForCommittedVersionActor*>(this)));
															#line 2048 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitForCommittedVersionActor, 1, GetReadVersionReply >*>(static_cast<WaitForCommittedVersionActor*>(this)));
															#line 7725 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2072 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (e.code() == error_code_batch_transaction_throttled || e.code() == error_code_grv_proxy_memory_limit_exceeded)
															#line 7747 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 2075 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				StrictFuture<Void> __when_expr_3 = delayJittered(CLIENT_KNOBS->GRV_ERROR_RETRY_DELAY);
															#line 2075 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (static_cast<WaitForCommittedVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7753 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
				static_cast<WaitForCommittedVersionActor*>(this)->actor_wait_state = 3;
															#line 2075 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WaitForCommittedVersionActor, 3, Void >*>(static_cast<WaitForCommittedVersionActor*>(this)));
															#line 7758 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 2077 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				TraceEvent(SevError, "WaitForCommittedVersionError").error(e);
															#line 2078 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 7767 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(GetReadVersionReply const& v,int loopDepth) 
	{
															#line 2054 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		cx->minAcceptableReadVersion = std::min(cx->minAcceptableReadVersion, v.version);
															#line 2055 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (v.midShardSize > 0)
															#line 7802 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2056 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			cx->smoothMidShardSize.setTotal(v.midShardSize);
															#line 7806 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 2057 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (cx->versionVectorCacheActive(v.ssVersionVectorDelta))
															#line 7810 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2058 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (cx->isCurrentGrvProxy(v.proxyId))
															#line 7814 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 2059 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				cx->ssVersionVectorCache.applyDelta(v.ssVersionVectorDelta);
															#line 7818 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
			else
			{
															#line 2061 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				cx->ssVersionVectorCache.clear();
															#line 7824 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
		}
															#line 2064 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (v.version >= version)
															#line 7829 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2065 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!static_cast<WaitForCommittedVersionActor*>(this)->SAV<Version>::futures) { (void)(v.version); this->~WaitForCommittedVersionActorState(); static_cast<WaitForCommittedVersionActor*>(this)->destroy(); return 0; }
															#line 7833 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			new (&static_cast<WaitForCommittedVersionActor*>(this)->SAV< Version >::value()) Version(v.version);
			this->~WaitForCommittedVersionActorState();
			static_cast<WaitForCommittedVersionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2068 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(CLIENT_KNOBS->FUTURE_VERSION_RETRY_DELAY, cx->taskID);
															#line 2068 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<WaitForCommittedVersionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7843 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1when2when1(__when_expr_2.get(), loopDepth); };
		static_cast<WaitForCommittedVersionActor*>(this)->actor_wait_state = 2;
															#line 2068 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WaitForCommittedVersionActor, 2, Void >*>(static_cast<WaitForCommittedVersionActor*>(this)));
															#line 7848 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when2(GetReadVersionReply && v,int loopDepth) 
	{
															#line 2054 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		cx->minAcceptableReadVersion = std::min(cx->minAcceptableReadVersion, v.version);
															#line 2055 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (v.midShardSize > 0)
															#line 7859 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2056 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			cx->smoothMidShardSize.setTotal(v.midShardSize);
															#line 7863 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 2057 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (cx->versionVectorCacheActive(v.ssVersionVectorDelta))
															#line 7867 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2058 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (cx->isCurrentGrvProxy(v.proxyId))
															#line 7871 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 2059 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				cx->ssVersionVectorCache.applyDelta(v.ssVersionVectorDelta);
															#line 7875 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
			else
			{
															#line 2061 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				cx->ssVersionVectorCache.clear();
															#line 7881 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
		}
															#line 2064 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (v.version >= version)
															#line 7886 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2065 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!static_cast<WaitForCommittedVersionActor*>(this)->SAV<Version>::futures) { (void)(v.version); this->~WaitForCommittedVersionActorState(); static_cast<WaitForCommittedVersionActor*>(this)->destroy(); return 0; }
															#line 7890 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			new (&static_cast<WaitForCommittedVersionActor*>(this)->SAV< Version >::value()) Version(v.version);
			this->~WaitForCommittedVersionActorState();
			static_cast<WaitForCommittedVersionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2068 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(CLIENT_KNOBS->FUTURE_VERSION_RETRY_DELAY, cx->taskID);
															#line 2068 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<WaitForCommittedVersionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7900 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1when2when1(__when_expr_2.get(), loopDepth); };
		static_cast<WaitForCommittedVersionActor*>(this)->actor_wait_state = 2;
															#line 2068 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WaitForCommittedVersionActor, 2, Void >*>(static_cast<WaitForCommittedVersionActor*>(this)));
															#line 7905 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitForCommittedVersionActor*>(this)->actor_wait_state > 0) static_cast<WaitForCommittedVersionActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForCommittedVersionActor*>(this)->ActorCallback< WaitForCommittedVersionActor, 0, Void >::remove();
		static_cast<WaitForCommittedVersionActor*>(this)->ActorCallback< WaitForCommittedVersionActor, 1, GetReadVersionReply >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForCommittedVersionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitForCommittedVersionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitForCommittedVersionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1when2cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WaitForCommittedVersionActor*>(this)->actor_wait_state > 0) static_cast<WaitForCommittedVersionActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForCommittedVersionActor*>(this)->ActorCallback< WaitForCommittedVersionActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForCommittedVersionActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WaitForCommittedVersionActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WaitForCommittedVersionActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WaitForCommittedVersionActor, 1, GetReadVersionReply >*,GetReadVersionReply const& value) 
	{
		fdb_probe_actor_enter("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WaitForCommittedVersionActor, 1, GetReadVersionReply >*,GetReadVersionReply && value) 
	{
		fdb_probe_actor_enter("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WaitForCommittedVersionActor, 1, GetReadVersionReply >*,Error err) 
	{
		fdb_probe_actor_enter("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WaitForCommittedVersionActor*>(this)->actor_wait_state > 0) static_cast<WaitForCommittedVersionActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForCommittedVersionActor*>(this)->ActorCallback< WaitForCommittedVersionActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForCommittedVersionActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< WaitForCommittedVersionActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< WaitForCommittedVersionActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 2042 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Database cx;
															#line 2042 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Version version;
															#line 2042 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	SpanContext spanContext;
															#line 2043 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Span span;
															#line 8232 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
};
// This generated class is to be used only via waitForCommittedVersion()
															#line 2042 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class WaitForCommittedVersionActor final : public Actor<Version>, public ActorCallback< WaitForCommittedVersionActor, 0, Void >, public ActorCallback< WaitForCommittedVersionActor, 1, GetReadVersionReply >, public ActorCallback< WaitForCommittedVersionActor, 2, Void >, public ActorCallback< WaitForCommittedVersionActor, 3, Void >, public FastAllocated<WaitForCommittedVersionActor>, public WaitForCommittedVersionActorState<WaitForCommittedVersionActor> {
															#line 8237 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
	using FastAllocated<WaitForCommittedVersionActor>::operator new;
	using FastAllocated<WaitForCommittedVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14415459185653555712UL, 2241179819958739712UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitForCommittedVersionActor, 0, Void >;
friend struct ActorCallback< WaitForCommittedVersionActor, 1, GetReadVersionReply >;
friend struct ActorCallback< WaitForCommittedVersionActor, 2, Void >;
friend struct ActorCallback< WaitForCommittedVersionActor, 3, Void >;
															#line 2042 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	WaitForCommittedVersionActor(Database const& cx,Version const& version,SpanContext const& spanContext) 
															#line 8257 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		 : Actor<Version>(),
		   WaitForCommittedVersionActorState<WaitForCommittedVersionActor>(cx, version, spanContext),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9303840678792357376UL, 476365445843715840UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitForCommittedVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitForCommittedVersionActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WaitForCommittedVersionActor, 2, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WaitForCommittedVersionActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2042 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<Version> waitForCommittedVersion( Database const& cx, Version const& version, SpanContext const& spanContext ) {
															#line 2042 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Version>(new WaitForCommittedVersionActor(cx, version, spanContext));
															#line 8292 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
}

#line 2083 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

															#line 8297 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
namespace {
// This generated class is to be used only via getRawVersion()
															#line 2084 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class GetRawVersionActor>
															#line 2084 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetRawVersionActorState {
															#line 8304 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
															#line 2084 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetRawVersionActorState(Reference<TransactionState> const& trState) 
															#line 2084 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 2084 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : trState(trState),
															#line 2085 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   span("NAPI:getRawVersion"_loc, trState->spanContext)
															#line 8313 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
	{
		fdb_probe_actor_create("getRawVersion", reinterpret_cast<unsigned long>(this));

	}
	~GetRawVersionActorState() 
	{
		fdb_probe_actor_destroy("getRawVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2086 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			;
															#line 8328 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetRawVersionActorState();
		static_cast<GetRawVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2088 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_0 = trState->cx->onProxiesChanged();
															#line 2087 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetRawVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8360 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 2089 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<GetReadVersionReply> __when_expr_1 = basicLoadBalance(trState->cx->getGrvProxies(UseProvisionalProxies::False), &GrvProxyInterface::getConsistentReadVersion, GetReadVersionRequest(trState->spanContext, 0, TransactionPriority::IMMEDIATE, trState->cx->ssVersionVectorCache.getMaxVersion()), trState->cx->taskID);
															#line 8364 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<GetRawVersionActor*>(this)->actor_wait_state = 1;
															#line 2088 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetRawVersionActor, 0, Void >*>(static_cast<GetRawVersionActor*>(this)));
															#line 2089 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetRawVersionActor, 1, GetReadVersionReply >*>(static_cast<GetRawVersionActor*>(this)));
															#line 8371 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(GetReadVersionReply const& v,int loopDepth) 
	{
															#line 2097 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (trState->cx->versionVectorCacheActive(v.ssVersionVectorDelta))
															#line 8398 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2098 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (trState->cx->isCurrentGrvProxy(v.proxyId))
															#line 8402 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 2099 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				trState->cx->ssVersionVectorCache.applyDelta(v.ssVersionVectorDelta);
															#line 8406 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
			else
			{
															#line 2101 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				trState->cx->ssVersionVectorCache.clear();
															#line 8412 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
		}
															#line 2104 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetRawVersionActor*>(this)->SAV<Version>::futures) { (void)(v.version); this->~GetRawVersionActorState(); static_cast<GetRawVersionActor*>(this)->destroy(); return 0; }
															#line 8417 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<GetRawVersionActor*>(this)->SAV< Version >::value()) Version(v.version);
		this->~GetRawVersionActorState();
		static_cast<GetRawVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when2(GetReadVersionReply && v,int loopDepth) 
	{
															#line 2097 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (trState->cx->versionVectorCacheActive(v.ssVersionVectorDelta))
															#line 8429 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2098 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (trState->cx->isCurrentGrvProxy(v.proxyId))
															#line 8433 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 2099 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				trState->cx->ssVersionVectorCache.applyDelta(v.ssVersionVectorDelta);
															#line 8437 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
			else
			{
															#line 2101 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				trState->cx->ssVersionVectorCache.clear();
															#line 8443 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
		}
															#line 2104 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetRawVersionActor*>(this)->SAV<Version>::futures) { (void)(v.version); this->~GetRawVersionActorState(); static_cast<GetRawVersionActor*>(this)->destroy(); return 0; }
															#line 8448 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<GetRawVersionActor*>(this)->SAV< Version >::value()) Version(v.version);
		this->~GetRawVersionActorState();
		static_cast<GetRawVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetRawVersionActor*>(this)->actor_wait_state > 0) static_cast<GetRawVersionActor*>(this)->actor_wait_state = 0;
		static_cast<GetRawVersionActor*>(this)->ActorCallback< GetRawVersionActor, 0, Void >::remove();
		static_cast<GetRawVersionActor*>(this)->ActorCallback< GetRawVersionActor, 1, GetReadVersionReply >::remove();

	}
	void a_callback_fire(ActorCallback< GetRawVersionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getRawVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRawVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRawVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetRawVersionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getRawVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRawVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRawVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetRawVersionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getRawVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRawVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRawVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetRawVersionActor, 1, GetReadVersionReply >*,GetReadVersionReply const& value) 
	{
		fdb_probe_actor_enter("getRawVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRawVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRawVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetRawVersionActor, 1, GetReadVersionReply >*,GetReadVersionReply && value) 
	{
		fdb_probe_actor_enter("getRawVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRawVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRawVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetRawVersionActor, 1, GetReadVersionReply >*,Error err) 
	{
		fdb_probe_actor_enter("getRawVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRawVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRawVersion", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2084 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reference<TransactionState> trState;
															#line 2085 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Span span;
															#line 8581 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
};
// This generated class is to be used only via getRawVersion()
															#line 2084 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetRawVersionActor final : public Actor<Version>, public ActorCallback< GetRawVersionActor, 0, Void >, public ActorCallback< GetRawVersionActor, 1, GetReadVersionReply >, public FastAllocated<GetRawVersionActor>, public GetRawVersionActorState<GetRawVersionActor> {
															#line 8586 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
	using FastAllocated<GetRawVersionActor>::operator new;
	using FastAllocated<GetRawVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6965004601269635328UL, 16907095283925158656UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetRawVersionActor, 0, Void >;
friend struct ActorCallback< GetRawVersionActor, 1, GetReadVersionReply >;
															#line 2084 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetRawVersionActor(Reference<TransactionState> const& trState) 
															#line 8604 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		 : Actor<Version>(),
		   GetRawVersionActorState<GetRawVersionActor>(trState),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getRawVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6451071362418865408UL, 866680570832095232UL);
		ActorExecutionContextHelper __helper(static_cast<GetRawVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getRawVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getRawVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetRawVersionActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2084 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<Version> getRawVersion( Reference<TransactionState> const& trState ) {
															#line 2084 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Version>(new GetRawVersionActor(trState));
															#line 8637 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
}

#line 2109 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

															#line 8642 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
[[nodiscard]] Future<Void> readVersionBatcher( DatabaseContext* const& cx, FutureStream<std::pair<Promise<GetReadVersionReply>, Optional<UID>>> const& versionStream, uint32_t const& flags );

#line 2114 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

															#line 8647 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
namespace {
// This generated class is to be used only via watchValue()
															#line 2115 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class WatchValueActor>
															#line 2115 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class WatchValueActorState {
															#line 8654 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
															#line 2115 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	WatchValueActorState(Database const& cx,Reference<const WatchParameters> const& parameters) 
															#line 2115 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 2115 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : cx(cx),
															#line 2115 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   parameters(parameters),
															#line 2116 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   span("NAPI:watchValue"_loc, parameters->spanContext),
															#line 2117 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   ver(parameters->version)
															#line 8667 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
	{
		fdb_probe_actor_create("watchValue", reinterpret_cast<unsigned long>(this));

	}
	~WatchValueActorState() 
	{
		fdb_probe_actor_destroy("watchValue", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2118 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			cx->validateVersion(parameters->version);
															#line 2119 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			ASSERT(parameters->version != latestVersion);
															#line 2121 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			CODE_PROBE(parameters->tenant.hasTenant(), "NativeAPI watchValue has tenant");
															#line 2123 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			;
															#line 8688 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WatchValueActorState();
		static_cast<WatchValueActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2124 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<KeyRangeLocationInfo> __when_expr_0 = getKeyLocation(cx, parameters->tenant, parameters->key, &StorageServerInterface::watchValue, parameters->spanContext, parameters->debugID, parameters->useProvisionalProxies, Reverse::False, parameters->version);
															#line 2124 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<WatchValueActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8720 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<WatchValueActor*>(this)->actor_wait_state = 1;
															#line 2124 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WatchValueActor, 0, KeyRangeLocationInfo >*>(static_cast<WatchValueActor*>(this)));
															#line 8725 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		try {
															#line 2134 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			watchValueID = Optional<UID>();
															#line 2135 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (parameters->debugID.present())
															#line 8737 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 2136 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				watchValueID = nondeterministicRandom()->randomUniqueID();
															#line 2138 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				g_traceBatch.addAttach( "WatchValueAttachID", parameters->debugID.get().first(), watchValueID.get().first());
															#line 2140 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				g_traceBatch.addEvent("WatchValueDebug", watchValueID.get().first(), "NativeAPI.watchValue.Before");
															#line 8745 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 2144 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			resp = WatchValueReply();
															#line 2146 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<WatchValueReply> __when_expr_1 = loadBalance(cx.getPtr(), locationInfo.locations, &StorageServerInterface::watchValue, WatchValueRequest(span.context, parameters->tenant, parameters->key, parameters->value, ver, cx->sampleReadTags() ? parameters->tags : Optional<TagSet>(), watchValueID), TaskPriority::DefaultPromiseEndpoint);
															#line 2145 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<WatchValueActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 8753 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
															#line 2160 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_2 = cx->connectionRecord ? cx->connectionRecord->onChange() : Never();
															#line 8757 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1cont1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont1when2(__when_expr_2.get(), loopDepth); };
			static_cast<WatchValueActor*>(this)->actor_wait_state = 2;
															#line 2146 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WatchValueActor, 1, WatchValueReply >*>(static_cast<WatchValueActor*>(this)));
															#line 2160 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WatchValueActor, 2, Void >*>(static_cast<WatchValueActor*>(this)));
															#line 8764 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(KeyRangeLocationInfo const& __locationInfo,int loopDepth) 
	{
															#line 2124 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		locationInfo = __locationInfo;
															#line 8779 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(KeyRangeLocationInfo && __locationInfo,int loopDepth) 
	{
		locationInfo = std::move(__locationInfo);
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WatchValueActor*>(this)->actor_wait_state > 0) static_cast<WatchValueActor*>(this)->actor_wait_state = 0;
		static_cast<WatchValueActor*>(this)->ActorCallback< WatchValueActor, 0, KeyRangeLocationInfo >::remove();

	}
	void a_callback_fire(ActorCallback< WatchValueActor, 0, KeyRangeLocationInfo >*,KeyRangeLocationInfo const& value) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WatchValueActor, 0, KeyRangeLocationInfo >*,KeyRangeLocationInfo && value) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WatchValueActor, 0, KeyRangeLocationInfo >*,Error err) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2190 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (e.code() == error_code_wrong_shard_server || e.code() == error_code_all_alternatives_failed)
															#line 8865 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 2191 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				cx->invalidateCache(parameters->tenant.prefix, parameters->key);
															#line 2192 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				StrictFuture<Void> __when_expr_5 = delay(CLIENT_KNOBS->WRONG_SHARD_SERVER_DELAY, parameters->taskID);
															#line 2192 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (static_cast<WatchValueActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8873 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1Catch1when1(__when_expr_5.get(), loopDepth); };
				static_cast<WatchValueActor*>(this)->actor_wait_state = 5;
															#line 2192 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< WatchValueActor, 5, Void >*>(static_cast<WatchValueActor*>(this)));
															#line 8878 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 2193 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (e.code() == error_code_watch_cancelled || e.code() == error_code_process_behind)
															#line 8885 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				{
															#line 2195 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					CODE_PROBE(e.code() == error_code_watch_cancelled, "Too many watches on the storage server, poll for changes instead");
															#line 2196 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					CODE_PROBE(e.code() == error_code_process_behind, "The storage servers are all behind", probe::decoration::rare);
															#line 2198 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					StrictFuture<Void> __when_expr_6 = delay(CLIENT_KNOBS->WATCH_POLLING_TIME, parameters->taskID);
															#line 2198 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					if (static_cast<WatchValueActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8895 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
					if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1Catch1when2(__when_expr_6.get(), loopDepth); };
					static_cast<WatchValueActor*>(this)->actor_wait_state = 6;
															#line 2198 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< WatchValueActor, 6, Void >*>(static_cast<WatchValueActor*>(this)));
															#line 8900 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 2199 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					if (e.code() == error_code_timed_out)
															#line 8907 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
					{
															#line 2201 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
						CODE_PROBE(true, "A watch timed out");
															#line 2202 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
						StrictFuture<Void> __when_expr_7 = delay(CLIENT_KNOBS->FUTURE_VERSION_RETRY_DELAY, parameters->taskID);
															#line 2202 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
						if (static_cast<WatchValueActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8915 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
						if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1Catch1when3(__when_expr_7.get(), loopDepth); };
						static_cast<WatchValueActor*>(this)->actor_wait_state = 7;
															#line 2202 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
						__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< WatchValueActor, 7, Void >*>(static_cast<WatchValueActor*>(this)));
															#line 8920 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
						loopDepth = 0;
					}
					else
					{
															#line 2204 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
						err = e;
															#line 2205 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
						StrictFuture<Void> __when_expr_8 = delay(CLIENT_KNOBS->FUTURE_VERSION_RETRY_DELAY, parameters->taskID);
															#line 2205 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
						if (static_cast<WatchValueActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8931 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
						if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1Catch1when4(__when_expr_8.get(), loopDepth); };
						static_cast<WatchValueActor*>(this)->actor_wait_state = 8;
															#line 2205 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
						__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< WatchValueActor, 8, Void >*>(static_cast<WatchValueActor*>(this)));
															#line 8936 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
						loopDepth = 0;
					}
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 2164 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (watchValueID.present())
															#line 8954 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2165 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			g_traceBatch.addEvent("WatchValueDebug", watchValueID.get().first(), "NativeAPI.watchValue.After");
															#line 8958 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 2171 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Version> __when_expr_4 = waitForCommittedVersion(cx, resp.version, span.context);
															#line 2171 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<WatchValueActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 8964 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1cont1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_4.get(), loopDepth); };
		static_cast<WatchValueActor*>(this)->actor_wait_state = 4;
															#line 2171 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< WatchValueActor, 4, Version >*>(static_cast<WatchValueActor*>(this)));
															#line 8969 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(WatchValueReply const& r,int loopDepth) 
	{
															#line 2158 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		resp = r;
															#line 8978 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(WatchValueReply && r,int loopDepth) 
	{
															#line 2158 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		resp = r;
															#line 8987 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when2(Void const& _,int loopDepth) 
	{
															#line 2161 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_3 = Never();
															#line 2161 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<WatchValueActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 8998 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1cont1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont1when2when1(__when_expr_3.get(), loopDepth); };
		static_cast<WatchValueActor*>(this)->actor_wait_state = 3;
															#line 2161 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WatchValueActor, 3, Void >*>(static_cast<WatchValueActor*>(this)));
															#line 9003 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1when2(Void && _,int loopDepth) 
	{
															#line 2161 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_3 = Never();
															#line 2161 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<WatchValueActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 9014 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1cont1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont1when2when1(__when_expr_3.get(), loopDepth); };
		static_cast<WatchValueActor*>(this)->actor_wait_state = 3;
															#line 2161 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WatchValueActor, 3, Void >*>(static_cast<WatchValueActor*>(this)));
															#line 9019 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WatchValueActor*>(this)->actor_wait_state > 0) static_cast<WatchValueActor*>(this)->actor_wait_state = 0;
		static_cast<WatchValueActor*>(this)->ActorCallback< WatchValueActor, 1, WatchValueReply >::remove();
		static_cast<WatchValueActor*>(this)->ActorCallback< WatchValueActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WatchValueActor, 1, WatchValueReply >*,WatchValueReply const& value) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WatchValueActor, 1, WatchValueReply >*,WatchValueReply && value) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WatchValueActor, 1, WatchValueReply >*,Error err) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont1when2cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when2cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1when2cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1when2cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WatchValueActor*>(this)->actor_wait_state > 0) static_cast<WatchValueActor*>(this)->actor_wait_state = 0;
		static_cast<WatchValueActor*>(this)->ActorCallback< WatchValueActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WatchValueActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< WatchValueActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< WatchValueActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< WatchValueActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WatchValueActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WatchValueActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont5(Version const& v,int loopDepth) 
	{
															#line 2179 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		bool buggifyRetry = g_network->isSimulated() && !g_simulator->speedUpSimulation && BUGGIFY_WITH_PROB(0.1);
															#line 2180 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		CODE_PROBE(buggifyRetry, "Watch buggifying version gap retry");
															#line 2181 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (v - resp.version < 50'000'000 && !buggifyRetry)
															#line 9240 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2182 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!static_cast<WatchValueActor*>(this)->SAV<Version>::futures) { (void)(resp.version); this->~WatchValueActorState(); static_cast<WatchValueActor*>(this)->destroy(); return 0; }
															#line 9244 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			new (&static_cast<WatchValueActor*>(this)->SAV< Version >::value()) Version(resp.version);
			this->~WatchValueActorState();
			static_cast<WatchValueActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2184 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ver = v;
															#line 2186 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (watchValueID.present())
															#line 9254 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2187 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			g_traceBatch.addEvent("WatchValueDebug", watchValueID.get().first(), "NativeAPI.watchValue.Retry");
															#line 9258 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Version && v,int loopDepth) 
	{
															#line 2179 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		bool buggifyRetry = g_network->isSimulated() && !g_simulator->speedUpSimulation && BUGGIFY_WITH_PROB(0.1);
															#line 2180 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		CODE_PROBE(buggifyRetry, "Watch buggifying version gap retry");
															#line 2181 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (v - resp.version < 50'000'000 && !buggifyRetry)
															#line 9272 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2182 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!static_cast<WatchValueActor*>(this)->SAV<Version>::futures) { (void)(resp.version); this->~WatchValueActorState(); static_cast<WatchValueActor*>(this)->destroy(); return 0; }
															#line 9276 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			new (&static_cast<WatchValueActor*>(this)->SAV< Version >::value()) Version(resp.version);
			this->~WatchValueActorState();
			static_cast<WatchValueActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2184 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ver = v;
															#line 2186 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (watchValueID.present())
															#line 9286 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2187 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			g_traceBatch.addEvent("WatchValueDebug", watchValueID.get().first(), "NativeAPI.watchValue.Retry");
															#line 9290 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Version const& v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(v, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Version && v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(v), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<WatchValueActor*>(this)->actor_wait_state > 0) static_cast<WatchValueActor*>(this)->actor_wait_state = 0;
		static_cast<WatchValueActor*>(this)->ActorCallback< WatchValueActor, 4, Version >::remove();

	}
	void a_callback_fire(ActorCallback< WatchValueActor, 4, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< WatchValueActor, 4, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< WatchValueActor, 4, Version >*,Error err) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<WatchValueActor*>(this)->actor_wait_state > 0) static_cast<WatchValueActor*>(this)->actor_wait_state = 0;
		static_cast<WatchValueActor*>(this)->ActorCallback< WatchValueActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WatchValueActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< WatchValueActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< WatchValueActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1cont1Catch1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<WatchValueActor*>(this)->actor_wait_state > 0) static_cast<WatchValueActor*>(this)->actor_wait_state = 0;
		static_cast<WatchValueActor*>(this)->ActorCallback< WatchValueActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WatchValueActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont1Catch1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< WatchValueActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont1Catch1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< WatchValueActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1loopBody1cont1Catch1cont5(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<WatchValueActor*>(this)->actor_wait_state > 0) static_cast<WatchValueActor*>(this)->actor_wait_state = 0;
		static_cast<WatchValueActor*>(this)->ActorCallback< WatchValueActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WatchValueActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1cont1Catch1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< WatchValueActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1cont1Catch1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< WatchValueActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1loopBody1cont1Catch1cont7(Void const& _,int loopDepth) 
	{
															#line 2206 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		return a_body1Catch1(err, std::max(0, loopDepth - 1));
															#line 9667 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1cont7(Void && _,int loopDepth) 
	{
															#line 2206 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		return a_body1Catch1(err, std::max(0, loopDepth - 1));
															#line 9675 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1when4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1when4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<WatchValueActor*>(this)->actor_wait_state > 0) static_cast<WatchValueActor*>(this)->actor_wait_state = 0;
		static_cast<WatchValueActor*>(this)->ActorCallback< WatchValueActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WatchValueActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1cont1Catch1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< WatchValueActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1cont1Catch1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< WatchValueActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 8);

	}
															#line 2115 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Database cx;
															#line 2115 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reference<const WatchParameters> parameters;
															#line 2116 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Span span;
															#line 2117 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Version ver;
															#line 2124 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeyRangeLocationInfo locationInfo;
															#line 2134 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Optional<UID> watchValueID;
															#line 2144 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	WatchValueReply resp;
															#line 2204 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Error err;
															#line 9770 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
};
// This generated class is to be used only via watchValue()
															#line 2115 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class WatchValueActor final : public Actor<Version>, public ActorCallback< WatchValueActor, 0, KeyRangeLocationInfo >, public ActorCallback< WatchValueActor, 1, WatchValueReply >, public ActorCallback< WatchValueActor, 2, Void >, public ActorCallback< WatchValueActor, 3, Void >, public ActorCallback< WatchValueActor, 4, Version >, public ActorCallback< WatchValueActor, 5, Void >, public ActorCallback< WatchValueActor, 6, Void >, public ActorCallback< WatchValueActor, 7, Void >, public ActorCallback< WatchValueActor, 8, Void >, public FastAllocated<WatchValueActor>, public WatchValueActorState<WatchValueActor> {
															#line 9775 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
	using FastAllocated<WatchValueActor>::operator new;
	using FastAllocated<WatchValueActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18106180677469712896UL, 4242082144432541952UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WatchValueActor, 0, KeyRangeLocationInfo >;
friend struct ActorCallback< WatchValueActor, 1, WatchValueReply >;
friend struct ActorCallback< WatchValueActor, 2, Void >;
friend struct ActorCallback< WatchValueActor, 3, Void >;
friend struct ActorCallback< WatchValueActor, 4, Version >;
friend struct ActorCallback< WatchValueActor, 5, Void >;
friend struct ActorCallback< WatchValueActor, 6, Void >;
friend struct ActorCallback< WatchValueActor, 7, Void >;
friend struct ActorCallback< WatchValueActor, 8, Void >;
															#line 2115 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	WatchValueActor(Database const& cx,Reference<const WatchParameters> const& parameters) 
															#line 9800 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		 : Actor<Version>(),
		   WatchValueActorState<WatchValueActor>(cx, parameters),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2460336902643348224UL, 8395577603832240640UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("watchValue");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WatchValueActor, 0, KeyRangeLocationInfo >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WatchValueActor, 1, WatchValueReply >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WatchValueActor, 3, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< WatchValueActor, 4, Version >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< WatchValueActor, 5, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< WatchValueActor, 6, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< WatchValueActor, 7, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< WatchValueActor, 8, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2115 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<Version> watchValue( Database const& cx, Reference<const WatchParameters> const& parameters ) {
															#line 2115 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Version>(new WatchValueActor(cx, parameters));
															#line 9840 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
}

#line 2211 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

															#line 9845 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
namespace {
// This generated class is to be used only via watchStorageServerResp()
															#line 2212 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class WatchStorageServerRespActor>
															#line 2212 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class WatchStorageServerRespActorState {
															#line 9852 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
															#line 2212 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	WatchStorageServerRespActorState(int64_t const& tenantId,Key const& key,Database const& cx) 
															#line 2212 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 2212 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : tenantId(tenantId),
															#line 2212 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   key(key),
															#line 2212 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   cx(cx)
															#line 9863 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
	{
		fdb_probe_actor_create("watchStorageServerResp", reinterpret_cast<unsigned long>(this));

	}
	~WatchStorageServerRespActorState() 
	{
		fdb_probe_actor_destroy("watchStorageServerResp", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2213 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			;
															#line 9878 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WatchStorageServerRespActorState();
		static_cast<WatchStorageServerRespActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 2215 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			metadata = cx->getWatchMetadata(tenantId, key);
															#line 2216 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!metadata.isValid())
															#line 9911 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 2217 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (!static_cast<WatchStorageServerRespActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WatchStorageServerRespActorState(); static_cast<WatchStorageServerRespActor*>(this)->destroy(); return 0; }
															#line 9915 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				new (&static_cast<WatchStorageServerRespActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~WatchStorageServerRespActorState();
				static_cast<WatchStorageServerRespActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 2219 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Version> __when_expr_0 = watchValue(cx, metadata->parameters);
															#line 2219 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<WatchStorageServerRespActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9925 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WatchStorageServerRespActor*>(this)->actor_wait_state = 1;
															#line 2219 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WatchStorageServerRespActor, 0, Version >*>(static_cast<WatchStorageServerRespActor*>(this)));
															#line 9930 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2242 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (e.code() == error_code_operation_cancelled)
															#line 9952 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 2243 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 9956 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 2246 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			Reference<WatchMetadata> metadata = cx->getWatchMetadata(tenantId, key);
															#line 2247 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!metadata.isValid())
															#line 9962 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 2248 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (!static_cast<WatchStorageServerRespActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WatchStorageServerRespActorState(); static_cast<WatchStorageServerRespActor*>(this)->destroy(); return 0; }
															#line 9966 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				new (&static_cast<WatchStorageServerRespActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~WatchStorageServerRespActorState();
				static_cast<WatchStorageServerRespActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 2249 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (metadata->watchPromise.getFutureReferenceCount() == 1)
															#line 9976 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				{
															#line 2250 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					cx->deleteWatchMetadata(tenantId, key);
															#line 2251 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					if (!static_cast<WatchStorageServerRespActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WatchStorageServerRespActorState(); static_cast<WatchStorageServerRespActor*>(this)->destroy(); return 0; }
															#line 9982 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
					new (&static_cast<WatchStorageServerRespActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~WatchStorageServerRespActorState();
					static_cast<WatchStorageServerRespActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
				else
				{
															#line 2252 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					if (e.code() == error_code_future_version)
															#line 9992 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
					{
						return a_body1loopHead1(loopDepth); // continue
					}
				}
			}
															#line 2255 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			cx->deleteWatchMetadata(tenantId, key);
															#line 2256 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			metadata->watchPromise.sendError(e);
															#line 2257 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 10004 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version const& watchVersion,int loopDepth) 
	{
															#line 2221 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		metadata = cx->getWatchMetadata(tenantId, key);
															#line 2222 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!metadata.isValid())
															#line 10020 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2223 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!static_cast<WatchStorageServerRespActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WatchStorageServerRespActorState(); static_cast<WatchStorageServerRespActor*>(this)->destroy(); return 0; }
															#line 10024 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			new (&static_cast<WatchStorageServerRespActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~WatchStorageServerRespActorState();
			static_cast<WatchStorageServerRespActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2226 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (watchVersion >= metadata->parameters->version)
															#line 10032 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2227 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			cx->deleteWatchMetadata(tenantId, key);
															#line 2228 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (metadata->watchPromise.canBeSet())
															#line 10038 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 2229 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				metadata->watchPromise.send(watchVersion);
															#line 10042 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
		}
		else
		{
															#line 2233 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			CODE_PROBE(true, "ABA issue where the version returned from the server is less than the version in the map");
															#line 2237 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (metadata->watchPromise.getFutureReferenceCount() == 1)
															#line 10051 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 2238 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				cx->deleteWatchMetadata(tenantId, key);
															#line 10055 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
		}
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version && watchVersion,int loopDepth) 
	{
															#line 2221 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		metadata = cx->getWatchMetadata(tenantId, key);
															#line 2222 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!metadata.isValid())
															#line 10068 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2223 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!static_cast<WatchStorageServerRespActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WatchStorageServerRespActorState(); static_cast<WatchStorageServerRespActor*>(this)->destroy(); return 0; }
															#line 10072 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			new (&static_cast<WatchStorageServerRespActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~WatchStorageServerRespActorState();
			static_cast<WatchStorageServerRespActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2226 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (watchVersion >= metadata->parameters->version)
															#line 10080 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2227 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			cx->deleteWatchMetadata(tenantId, key);
															#line 2228 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (metadata->watchPromise.canBeSet())
															#line 10086 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 2229 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				metadata->watchPromise.send(watchVersion);
															#line 10090 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
		}
		else
		{
															#line 2233 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			CODE_PROBE(true, "ABA issue where the version returned from the server is less than the version in the map");
															#line 2237 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (metadata->watchPromise.getFutureReferenceCount() == 1)
															#line 10099 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 2238 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				cx->deleteWatchMetadata(tenantId, key);
															#line 10103 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
		}
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Version const& watchVersion,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(watchVersion, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Version && watchVersion,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(watchVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WatchStorageServerRespActor*>(this)->actor_wait_state > 0) static_cast<WatchStorageServerRespActor*>(this)->actor_wait_state = 0;
		static_cast<WatchStorageServerRespActor*>(this)->ActorCallback< WatchStorageServerRespActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< WatchStorageServerRespActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("watchStorageServerResp", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchStorageServerRespActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchStorageServerResp", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WatchStorageServerRespActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("watchStorageServerResp", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchStorageServerRespActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchStorageServerResp", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WatchStorageServerRespActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("watchStorageServerResp", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchStorageServerRespActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchStorageServerResp", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 2212 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	int64_t tenantId;
															#line 2212 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Key key;
															#line 2212 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Database cx;
															#line 2215 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reference<WatchMetadata> metadata;
															#line 10206 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
};
// This generated class is to be used only via watchStorageServerResp()
															#line 2212 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class WatchStorageServerRespActor final : public Actor<Void>, public ActorCallback< WatchStorageServerRespActor, 0, Version >, public FastAllocated<WatchStorageServerRespActor>, public WatchStorageServerRespActorState<WatchStorageServerRespActor> {
															#line 10211 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
	using FastAllocated<WatchStorageServerRespActor>::operator new;
	using FastAllocated<WatchStorageServerRespActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3324906091193138176UL, 4775945572635831552UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WatchStorageServerRespActor, 0, Version >;
															#line 2212 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	WatchStorageServerRespActor(int64_t const& tenantId,Key const& key,Database const& cx) 
															#line 10228 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		 : Actor<Void>(),
		   WatchStorageServerRespActorState<WatchStorageServerRespActor>(tenantId, key, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("watchStorageServerResp", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5937245291561340160UL, 16097796804231101184UL);
		ActorExecutionContextHelper __helper(static_cast<WatchStorageServerRespActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("watchStorageServerResp");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("watchStorageServerResp", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WatchStorageServerRespActor, 0, Version >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2212 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<Void> watchStorageServerResp( int64_t const& tenantId, Key const& key, Database const& cx ) {
															#line 2212 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Void>(new WatchStorageServerRespActor(tenantId, key, cx));
															#line 10261 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
}

#line 2261 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

															#line 10266 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
namespace {
// This generated class is to be used only via sameVersionDiffValue()
															#line 2262 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class SameVersionDiffValueActor>
															#line 2262 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class SameVersionDiffValueActorState {
															#line 10273 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
															#line 2262 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	SameVersionDiffValueActorState(Database const& cx,Reference<WatchParameters> const& parameters) 
															#line 2262 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 2262 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : cx(cx),
															#line 2262 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   parameters(parameters),
															#line 2263 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   tr(cx, parameters->tenant.hasTenant() ? makeReference<Tenant>(parameters->tenant.tenantId) : Optional<Reference<Tenant>>())
															#line 10284 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
	{
		fdb_probe_actor_create("sameVersionDiffValue", reinterpret_cast<unsigned long>(this));

	}
	~SameVersionDiffValueActorState() 
	{
		fdb_probe_actor_destroy("sameVersionDiffValue", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2268 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			;
															#line 10299 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SameVersionDiffValueActorState();
		static_cast<SameVersionDiffValueActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 2270 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!parameters->tenant.hasTenant())
															#line 10330 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 2271 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 10334 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 2274 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(parameters->key);
															#line 2274 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<SameVersionDiffValueActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10340 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SameVersionDiffValueActor*>(this)->actor_wait_state = 1;
															#line 2274 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SameVersionDiffValueActor, 0, Optional<Value> >*>(static_cast<SameVersionDiffValueActor*>(this)));
															#line 10345 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2302 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 2302 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<SameVersionDiffValueActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10369 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<SameVersionDiffValueActor*>(this)->actor_wait_state = 3;
															#line 2302 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SameVersionDiffValueActor, 2, Void >*>(static_cast<SameVersionDiffValueActor*>(this)));
															#line 10374 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 2275 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		Reference<WatchMetadata> metadata = cx->getWatchMetadata(parameters->tenant.tenantId, parameters->key);
															#line 2278 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (metadata.isValid() && valSS != metadata->parameters->value)
															#line 10391 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2279 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			cx->deleteWatchMetadata(parameters->tenant.tenantId, parameters->key);
															#line 2281 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			metadata->watchPromise.send(parameters->version);
															#line 2282 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			metadata->watchFutureSS.cancel();
															#line 10399 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 2286 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (valSS == parameters->value && tr.getTransactionState()->tenantId() == parameters->tenant.tenantId)
															#line 10403 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2287 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			metadata = makeReference<WatchMetadata>(parameters);
															#line 2288 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			cx->setWatchMetadata(metadata);
															#line 2290 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			metadata->watchFutureSS = watchStorageServerResp(parameters->tenant.tenantId, parameters->key, cx);
															#line 10411 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 2294 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (valSS != parameters->value)
															#line 10415 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2295 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!static_cast<SameVersionDiffValueActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SameVersionDiffValueActorState(); static_cast<SameVersionDiffValueActor*>(this)->destroy(); return 0; }
															#line 10419 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			new (&static_cast<SameVersionDiffValueActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~SameVersionDiffValueActorState();
			static_cast<SameVersionDiffValueActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2298 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_1 = success(metadata->watchPromise.getFuture());
															#line 2298 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<SameVersionDiffValueActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10429 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<SameVersionDiffValueActor*>(this)->actor_wait_state = 2;
															#line 2298 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SameVersionDiffValueActor, 1, Void >*>(static_cast<SameVersionDiffValueActor*>(this)));
															#line 10434 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& __valSS,int loopDepth) 
	{
															#line 2274 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		valSS = __valSS;
															#line 10443 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && __valSS,int loopDepth) 
	{
		valSS = std::move(__valSS);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SameVersionDiffValueActor*>(this)->actor_wait_state > 0) static_cast<SameVersionDiffValueActor*>(this)->actor_wait_state = 0;
		static_cast<SameVersionDiffValueActor*>(this)->ActorCallback< SameVersionDiffValueActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< SameVersionDiffValueActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SameVersionDiffValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SameVersionDiffValueActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SameVersionDiffValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SameVersionDiffValueActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SameVersionDiffValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 2300 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<SameVersionDiffValueActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SameVersionDiffValueActorState(); static_cast<SameVersionDiffValueActor*>(this)->destroy(); return 0; }
															#line 10522 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<SameVersionDiffValueActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SameVersionDiffValueActorState();
		static_cast<SameVersionDiffValueActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 2300 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<SameVersionDiffValueActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SameVersionDiffValueActorState(); static_cast<SameVersionDiffValueActor*>(this)->destroy(); return 0; }
															#line 10534 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<SameVersionDiffValueActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SameVersionDiffValueActorState();
		static_cast<SameVersionDiffValueActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SameVersionDiffValueActor*>(this)->actor_wait_state > 0) static_cast<SameVersionDiffValueActor*>(this)->actor_wait_state = 0;
		static_cast<SameVersionDiffValueActor*>(this)->ActorCallback< SameVersionDiffValueActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SameVersionDiffValueActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SameVersionDiffValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SameVersionDiffValueActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SameVersionDiffValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SameVersionDiffValueActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SameVersionDiffValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<SameVersionDiffValueActor*>(this)->actor_wait_state > 0) static_cast<SameVersionDiffValueActor*>(this)->actor_wait_state = 0;
		static_cast<SameVersionDiffValueActor*>(this)->ActorCallback< SameVersionDiffValueActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SameVersionDiffValueActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SameVersionDiffValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< SameVersionDiffValueActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SameVersionDiffValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< SameVersionDiffValueActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SameVersionDiffValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 2262 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Database cx;
															#line 2262 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reference<WatchParameters> parameters;
															#line 2263 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 2274 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Optional<Value> valSS;
															#line 10712 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
};
// This generated class is to be used only via sameVersionDiffValue()
															#line 2262 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class SameVersionDiffValueActor final : public Actor<Void>, public ActorCallback< SameVersionDiffValueActor, 0, Optional<Value> >, public ActorCallback< SameVersionDiffValueActor, 1, Void >, public ActorCallback< SameVersionDiffValueActor, 2, Void >, public FastAllocated<SameVersionDiffValueActor>, public SameVersionDiffValueActorState<SameVersionDiffValueActor> {
															#line 10717 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
	using FastAllocated<SameVersionDiffValueActor>::operator new;
	using FastAllocated<SameVersionDiffValueActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(167065831298212096UL, 6810821113466901248UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SameVersionDiffValueActor, 0, Optional<Value> >;
friend struct ActorCallback< SameVersionDiffValueActor, 1, Void >;
friend struct ActorCallback< SameVersionDiffValueActor, 2, Void >;
															#line 2262 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	SameVersionDiffValueActor(Database const& cx,Reference<WatchParameters> const& parameters) 
															#line 10736 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		 : Actor<Void>(),
		   SameVersionDiffValueActorState<SameVersionDiffValueActor>(cx, parameters),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1345293727184951296UL, 14775766526751535104UL);
		ActorExecutionContextHelper __helper(static_cast<SameVersionDiffValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("sameVersionDiffValue");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SameVersionDiffValueActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SameVersionDiffValueActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< SameVersionDiffValueActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2262 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<Void> sameVersionDiffValue( Database const& cx, Reference<WatchParameters> const& parameters ) {
															#line 2262 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Void>(new SameVersionDiffValueActor(cx, parameters));
															#line 10771 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
}

#line 2306 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

Future<Void> getWatchFuture(Database cx, Reference<WatchParameters> parameters) {
	Reference<WatchMetadata> metadata = cx->getWatchMetadata(parameters->tenant.tenantId, parameters->key);

	// case 1: key not in map
	if (!metadata.isValid()) {
		metadata = makeReference<WatchMetadata>(parameters);
		cx->setWatchMetadata(metadata);

		metadata->watchFutureSS = watchStorageServerResp(parameters->tenant.tenantId, parameters->key, cx);
		return success(metadata->watchPromise.getFuture());
	}
	// case 2: val_1 == val_2 (received watch with same value as key already in the map so just update)
	else if (metadata->parameters->value == parameters->value) {
		if (parameters->version > metadata->parameters->version) {
			metadata->parameters = parameters;
		}

		return success(metadata->watchPromise.getFuture());
	}
	// case 3: val_1 != val_2 && version_2 > version_1 (received watch with different value and a higher version so
	// recreate in SS)
	else if (parameters->version > metadata->parameters->version) {
		CODE_PROBE(true,
		           "Setting a watch that has a different value than the one in the map but a higher version (newer)");
		cx->deleteWatchMetadata(parameters->tenant.tenantId, parameters->key);

		metadata->watchPromise.send(parameters->version);
		metadata->watchFutureSS.cancel();

		metadata = makeReference<WatchMetadata>(parameters);
		cx->setWatchMetadata(metadata);

		metadata->watchFutureSS = watchStorageServerResp(parameters->tenant.tenantId, parameters->key, cx);

		return success(metadata->watchPromise.getFuture());
	}
	// case 5: val_1 != val_2 && version_1 == version_2 (received watch with different value but same version)
	else if (metadata->parameters->version == parameters->version) {
		CODE_PROBE(true, "Setting a watch which has a different value than the one in the map but the same version");
		return sameVersionDiffValue(cx, parameters);
	}
	CODE_PROBE(true, "Setting a watch which has a different value than the one in the map but a lower version (older)");

	// case 4: val_1 != val_2 && version_2 < version_1
	return Void();
}

namespace {

// NOTE: Since an ACTOR could receive multiple exceptions for a single catch clause, e.g. broken promise together with
// operation cancelled, If the decreaseWatchRefCount is placed at the catch clause, it might be triggered for multiple
// times. One could check if the SAV isSet, but seems a more intuitive way is to use RAII-style constructor/destructor
// pair. Yet the object has to be constructed after a wait statement, so it must be trivially-constructible. This
// requires move-assignment operator implemented.
class WatchRefCountUpdater {
	Database cx;
	int64_t tenantID;
	KeyRef key;
	Version version;

public:
	WatchRefCountUpdater() = default;

	WatchRefCountUpdater(const Database& cx_, const int64_t tenantID_, KeyRef key_, const Version& ver)
	  : cx(cx_), tenantID(tenantID_), key(key_), version(ver) {}

	WatchRefCountUpdater& operator=(WatchRefCountUpdater&& other) {
		if (cx.getReference()) {
			cx->decreaseWatchRefCount(tenantID, key, version);
		}

		cx = std::move(other.cx);
		tenantID = std::move(other.tenantID);
		key = std::move(other.key);
		version = std::move(other.version);

		cx->increaseWatchRefCount(tenantID, key, version);

		return *this;
	}

	~WatchRefCountUpdater() {
		if (cx.getReference()) {
			cx->decreaseWatchRefCount(tenantID, key, version);
		}
	}
};

} // namespace

															#line 10866 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
namespace {
// This generated class is to be used only via watchValueMap()
															#line 2397 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class WatchValueMapActor>
															#line 2397 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class WatchValueMapActorState {
															#line 10873 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
															#line 2397 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	WatchValueMapActorState(Future<Version> const& version,TenantInfo const& tenant,Key const& key,Optional<Value> const& value,Database const& cx,TagSet const& tags,SpanContext const& spanContext,TaskPriority const& taskID,Optional<UID> const& debugID,UseProvisionalProxies const& useProvisionalProxies) 
															#line 2397 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 2397 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : version(version),
															#line 2397 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   tenant(tenant),
															#line 2397 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   key(key),
															#line 2397 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   value(value),
															#line 2397 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   cx(cx),
															#line 2397 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   tags(tags),
															#line 2397 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   spanContext(spanContext),
															#line 2397 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   taskID(taskID),
															#line 2397 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   debugID(debugID),
															#line 2397 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   useProvisionalProxies(useProvisionalProxies)
															#line 10898 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
	{
		fdb_probe_actor_create("watchValueMap", reinterpret_cast<unsigned long>(this));

	}
	~WatchValueMapActorState() 
	{
		fdb_probe_actor_destroy("watchValueMap", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2407 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Version> __when_expr_0 = version;
															#line 2407 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<WatchValueMapActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10915 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WatchValueMapActor*>(this)->actor_wait_state = 1;
															#line 2407 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WatchValueMapActor, 0, Version >*>(static_cast<WatchValueMapActor*>(this)));
															#line 10920 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WatchValueMapActorState();
		static_cast<WatchValueMapActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2408 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		watchRefCountUpdater = WatchRefCountUpdater(cx, tenant.tenantId, key, ver);
															#line 2410 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_1 = getWatchFuture(cx, makeReference<WatchParameters>( tenant, key, value, ver, tags, spanContext, taskID, debugID, useProvisionalProxies));
															#line 2410 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<WatchValueMapActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10947 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WatchValueMapActor*>(this)->actor_wait_state = 2;
															#line 2410 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WatchValueMapActor, 1, Void >*>(static_cast<WatchValueMapActor*>(this)));
															#line 10952 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Version const& __ver,int loopDepth) 
	{
															#line 2407 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ver = __ver;
															#line 10961 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Version && __ver,int loopDepth) 
	{
		ver = std::move(__ver);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WatchValueMapActor*>(this)->actor_wait_state > 0) static_cast<WatchValueMapActor*>(this)->actor_wait_state = 0;
		static_cast<WatchValueMapActor*>(this)->ActorCallback< WatchValueMapActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< WatchValueMapActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("watchValueMap", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueMapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValueMap", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WatchValueMapActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("watchValueMap", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueMapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValueMap", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WatchValueMapActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("watchValueMap", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueMapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValueMap", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 2414 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<WatchValueMapActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WatchValueMapActorState(); static_cast<WatchValueMapActor*>(this)->destroy(); return 0; }
															#line 11040 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<WatchValueMapActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WatchValueMapActorState();
		static_cast<WatchValueMapActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 2414 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<WatchValueMapActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WatchValueMapActorState(); static_cast<WatchValueMapActor*>(this)->destroy(); return 0; }
															#line 11052 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<WatchValueMapActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WatchValueMapActorState();
		static_cast<WatchValueMapActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WatchValueMapActor*>(this)->actor_wait_state > 0) static_cast<WatchValueMapActor*>(this)->actor_wait_state = 0;
		static_cast<WatchValueMapActor*>(this)->ActorCallback< WatchValueMapActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WatchValueMapActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("watchValueMap", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueMapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValueMap", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WatchValueMapActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("watchValueMap", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueMapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValueMap", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WatchValueMapActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("watchValueMap", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueMapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValueMap", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2397 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Future<Version> version;
															#line 2397 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	TenantInfo tenant;
															#line 2397 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Key key;
															#line 2397 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Optional<Value> value;
															#line 2397 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Database cx;
															#line 2397 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	TagSet tags;
															#line 2397 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	SpanContext spanContext;
															#line 2397 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	TaskPriority taskID;
															#line 2397 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Optional<UID> debugID;
															#line 2397 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	UseProvisionalProxies useProvisionalProxies;
															#line 2407 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Version ver;
															#line 2408 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	WatchRefCountUpdater watchRefCountUpdater;
															#line 11159 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
};
// This generated class is to be used only via watchValueMap()
															#line 2397 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class WatchValueMapActor final : public Actor<Void>, public ActorCallback< WatchValueMapActor, 0, Version >, public ActorCallback< WatchValueMapActor, 1, Void >, public FastAllocated<WatchValueMapActor>, public WatchValueMapActorState<WatchValueMapActor> {
															#line 11164 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
	using FastAllocated<WatchValueMapActor>::operator new;
	using FastAllocated<WatchValueMapActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10390716827557806848UL, 7495365778718388992UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WatchValueMapActor, 0, Version >;
friend struct ActorCallback< WatchValueMapActor, 1, Void >;
															#line 2397 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	WatchValueMapActor(Future<Version> const& version,TenantInfo const& tenant,Key const& key,Optional<Value> const& value,Database const& cx,TagSet const& tags,SpanContext const& spanContext,TaskPriority const& taskID,Optional<UID> const& debugID,UseProvisionalProxies const& useProvisionalProxies) 
															#line 11182 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		 : Actor<Void>(),
		   WatchValueMapActorState<WatchValueMapActor>(version, tenant, key, value, cx, tags, spanContext, taskID, debugID, useProvisionalProxies),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("watchValueMap", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15055311216113119744UL, 3063023898867388672UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueMapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("watchValueMap");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("watchValueMap", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WatchValueMapActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WatchValueMapActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2397 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<Void> watchValueMap( Future<Version> const& version, TenantInfo const& tenant, Key const& key, Optional<Value> const& value, Database const& cx, TagSet const& tags, SpanContext const& spanContext, TaskPriority const& taskID, Optional<UID> const& debugID, UseProvisionalProxies const& useProvisionalProxies ) {
															#line 2397 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Void>(new WatchValueMapActor(version, tenant, key, value, cx, tags, spanContext, taskID, debugID, useProvisionalProxies));
															#line 11216 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
}

#line 2416 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

template <class GetKeyValuesFamilyRequest>
void transformRangeLimits(GetRangeLimits limits, Reverse reverse, GetKeyValuesFamilyRequest& req) {
	if (limits.bytes != 0) {
		if (!limits.hasRowLimit())
			req.limit = CLIENT_KNOBS->REPLY_BYTE_LIMIT; // Can't get more than this many rows anyway
		else
			req.limit = std::min(CLIENT_KNOBS->REPLY_BYTE_LIMIT, limits.rows);

		if (reverse)
			req.limit *= -1;

		if (!limits.hasByteLimit())
			req.limitBytes = CLIENT_KNOBS->REPLY_BYTE_LIMIT;
		else
			req.limitBytes = std::min(CLIENT_KNOBS->REPLY_BYTE_LIMIT, limits.bytes);
	} else {
		req.limitBytes = CLIENT_KNOBS->REPLY_BYTE_LIMIT;
		req.limit = reverse ? -limits.minRows : limits.minRows;
	}
}

template <class GetKeyValuesFamilyRequest>
PublicRequestStream<GetKeyValuesFamilyRequest> StorageServerInterface::* getRangeRequestStream() {
	if constexpr (std::is_same<GetKeyValuesFamilyRequest, GetKeyValuesRequest>::value) {
		return &StorageServerInterface::getKeyValues;
	} else if (std::is_same<GetKeyValuesFamilyRequest, GetMappedKeyValuesRequest>::value) {
		return &StorageServerInterface::getMappedKeyValues;
	} else {
		UNREACHABLE();
	}
}

															#line 11253 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
namespace {
// This generated class is to be used only via getExactRange()
															#line 2449 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class GetKeyValuesFamilyRequest, class GetKeyValuesFamilyReply, class RangeResultFamily, class GetExactRangeActor>
															#line 2449 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetExactRangeActorState {
															#line 11260 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
															#line 2449 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetExactRangeActorState(Reference<TransactionState> const& trState,KeyRange const& keys,Key const& mapper,GetRangeLimits const& limits,Reverse const& reverse,UseTenant const& useTenant) 
															#line 2449 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 2449 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : trState(trState),
															#line 2449 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   keys(keys),
															#line 2449 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   mapper(mapper),
															#line 2449 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   limits(limits),
															#line 2449 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   reverse(reverse),
															#line 2449 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   useTenant(useTenant),
															#line 2456 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   output(),
															#line 2458 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   span("NAPI:getExactRange"_loc, trState->spanContext)
															#line 11281 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
	{
		fdb_probe_actor_create("getExactRange", reinterpret_cast<unsigned long>(this));

	}
	~GetExactRangeActorState() 
	{
		fdb_probe_actor_destroy("getExactRange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2460 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			CODE_PROBE(trState->hasTenant() && useTenant, "NativeAPI getExactRange has tenant");
															#line 2461 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			CODE_PROBE(!useTenant, "NativeAPI getExactRange ignoring tenant");
															#line 2463 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (useTenant && trState->hasTenant())
															#line 11300 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 2464 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				span.addAttribute("tenant"_sr, trState->tenant().get()->name.castTo<TenantNameRef>().orDefault("<unspecified>"_sr));
															#line 11304 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 2469 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			;
															#line 11308 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetExactRangeActorState();
		static_cast<GetExactRangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2470 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<std::vector<KeyRangeLocationInfo>> __when_expr_0 = getKeyRangeLocations(trState, keys, CLIENT_KNOBS->GET_RANGE_SHARD_LIMIT, reverse, getRangeRequestStream<GetKeyValuesFamilyRequest>(), useTenant);
															#line 2470 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetExactRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11340 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<GetExactRangeActor*>(this)->actor_wait_state = 1;
															#line 2470 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetExactRangeActor, 0, std::vector<KeyRangeLocationInfo> >*>(static_cast<GetExactRangeActor*>(this)));
															#line 11345 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 2477 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(locations.size());
															#line 2478 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		shard = 0;
															#line 2479 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		;
															#line 11358 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<KeyRangeLocationInfo> const& __locations,int loopDepth) 
	{
															#line 2470 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		locations = __locations;
															#line 11367 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<KeyRangeLocationInfo> && __locations,int loopDepth) 
	{
		locations = std::move(__locations);
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetExactRangeActor*>(this)->actor_wait_state > 0) static_cast<GetExactRangeActor*>(this)->actor_wait_state = 0;
		static_cast<GetExactRangeActor*>(this)->ActorCallback< GetExactRangeActor, 0, std::vector<KeyRangeLocationInfo> >::remove();

	}
	void a_callback_fire(ActorCallback< GetExactRangeActor, 0, std::vector<KeyRangeLocationInfo> >*,std::vector<KeyRangeLocationInfo> const& value) 
	{
		fdb_probe_actor_enter("getExactRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetExactRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getExactRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetExactRangeActor, 0, std::vector<KeyRangeLocationInfo> >*,std::vector<KeyRangeLocationInfo> && value) 
	{
		fdb_probe_actor_enter("getExactRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetExactRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getExactRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetExactRangeActor, 0, std::vector<KeyRangeLocationInfo> >*,Error err) 
	{
		fdb_probe_actor_enter("getExactRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetExactRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getExactRange", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1(int loopDepth) 
	{
															#line 2480 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		const KeyRangeRef& range = locations[shard].range;
															#line 2482 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		GetKeyValuesFamilyRequest req;
															#line 2483 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.mapper = mapper;
															#line 2484 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.arena.dependsOn(mapper.arena());
															#line 2486 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.tenantInfo = useTenant ? trState->getTenantInfo() : TenantInfo();
															#line 2487 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.version = trState->readVersion();
															#line 2488 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.begin = firstGreaterOrEqual(range.begin);
															#line 2489 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.end = firstGreaterOrEqual(range.end);
															#line 2491 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.spanContext = span.context;
															#line 2492 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		trState->cx->getLatestCommitVersions(locations[shard].locations, trState, req.ssLatestCommitVersions);
															#line 2495 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.arena.dependsOn(locations[shard].range.arena());
															#line 2497 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		transformRangeLimits(limits, reverse, req);
															#line 2498 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(req.limitBytes > 0 && req.limit != 0 && req.limit < 0 == reverse);
															#line 2501 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.tags = trState->cx->sampleReadTags() ? trState->options.readTags : Optional<TagSet>();
															#line 2503 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.options = trState->readOptions;
															#line 11487 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		try {
															#line 2506 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (trState->readOptions.present() && trState->readOptions.get().debugID.present())
															#line 11491 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 2507 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				g_traceBatch.addEvent("TransactionDebug", trState->readOptions.get().debugID.get().first(), "NativeAPI.getExactRange.Before");
															#line 11495 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 2519 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			++trState->cx->transactionPhysicalReads;
															#line 2520 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			rep = GetKeyValuesFamilyReply();
															#line 11501 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			try {
															#line 2523 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				StrictFuture<Void> __when_expr_1 = trState->cx->connectionFileChanged();
															#line 2522 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (static_cast<GetExactRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch2(actor_cancelled(), loopDepth);
															#line 11507 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1loopBody1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
															#line 2526 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				StrictFuture<GetKeyValuesFamilyReply> __when_expr_2 = loadBalance( trState->cx.getPtr(), locations[shard].locations, getRangeRequestStream<GetKeyValuesFamilyRequest>(), req, TaskPriority::DefaultPromiseEndpoint, AtMostOnce::False, trState->cx->enableLocalityLoadBalance ? &trState->cx->queueModel : nullptr, trState->options.enableReplicaConsistencyCheck, trState->options.requiredReplicas);
															#line 11511 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1cont1loopBody1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1when2(__when_expr_2.get(), loopDepth); };
				static_cast<GetExactRangeActor*>(this)->actor_wait_state = 2;
															#line 2523 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetExactRangeActor, 1, Void >*>(static_cast<GetExactRangeActor*>(this)));
															#line 2526 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetExactRangeActor, 2, GetKeyValuesFamilyReply >*>(static_cast<GetExactRangeActor*>(this)));
															#line 11518 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1loopBody1cont1loopBody1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1loopBody1cont1loopBody1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2625 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (e.code() == error_code_wrong_shard_server || e.code() == error_code_all_alternatives_failed)
															#line 11559 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 2626 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				const KeyRangeRef& range = locations[shard].range;
															#line 2628 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (reverse)
															#line 11565 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				{
															#line 2629 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					keys = KeyRangeRef(keys.begin, range.end);
															#line 11569 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				}
				else
				{
															#line 2631 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					keys = KeyRangeRef(range.begin, keys.end);
															#line 11575 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				}
															#line 2633 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				trState->cx->invalidateCache( useTenant ? trState->tenant().mapRef(&Tenant::prefix) : Optional<KeyRef>(), keys);
															#line 2636 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				StrictFuture<Void> __when_expr_3 = delay(CLIENT_KNOBS->WRONG_SHARD_SERVER_DELAY, trState->taskID);
															#line 2636 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (static_cast<GetExactRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 11583 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
				static_cast<GetExactRangeActor*>(this)->actor_wait_state = 3;
															#line 2636 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetExactRangeActor, 3, Void >*>(static_cast<GetExactRangeActor*>(this)));
															#line 11588 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 2639 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				TraceEvent(SevInfo, "GetExactRangeError") .error(e) .detail("Tenant", trState->tenant()) .detail("ShardBegin", locations[shard].range.begin) .detail("ShardEnd", locations[shard].range.end);
															#line 2644 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 2));
															#line 11597 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2(int loopDepth) 
	{
															#line 2544 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (trState->readOptions.present() && trState->readOptions.get().debugID.present())
															#line 11612 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2545 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			g_traceBatch.addEvent("TransactionDebug", trState->readOptions.get().debugID.get().first(), "NativeAPI.getExactRange.After");
															#line 11616 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 2548 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		output.arena().dependsOn(rep.arena);
															#line 2549 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		output.append(output.arena(), rep.data.begin(), rep.data.size());
															#line 2551 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (limits.hasRowLimit() && rep.data.size() > limits.rows)
															#line 11624 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2552 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			TraceEvent(SevError, "GetExactRangeTooManyRows") .detail("RowLimit", limits.rows) .detail("DeliveredRows", output.size());
															#line 2555 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			ASSERT(false);
															#line 11630 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 2557 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		limits.decrement(rep.data);
															#line 2559 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (limits.isReached())
															#line 11636 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2560 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			output.more = true;
															#line 2561 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!static_cast<GetExactRangeActor*>(this)->SAV<RangeResultFamily>::futures) { (void)(output); this->~GetExactRangeActorState(); static_cast<GetExactRangeActor*>(this)->destroy(); return 0; }
															#line 11642 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			new (&static_cast<GetExactRangeActor*>(this)->SAV< RangeResultFamily >::value()) RangeResultFamily(std::move(output)); // state_var_RVO
			this->~GetExactRangeActorState();
			static_cast<GetExactRangeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2564 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		bool more = rep.more;
															#line 2566 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (reverse && more && rep.data.size() > 0 && output[output.size() - 1].key == locations[shard].range.begin)
															#line 11652 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2568 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			more = false;
															#line 11656 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 2570 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (more)
															#line 11660 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2571 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!rep.data.size())
															#line 11664 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 2572 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				TraceEvent(SevError, "GetExactRangeError") .detail("Reason", "More data indicated but no rows present") .detail("LimitBytes", limits.bytes) .detail("LimitRows", limits.rows) .detail("OutputSize", output.size()) .detail("OutputBytes", output.expectedSize()) .detail("BlockSize", rep.data.size()) .detail("BlockBytes", rep.data.expectedSize());
															#line 2580 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				ASSERT(false);
															#line 11670 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 2582 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			CODE_PROBE(true, "GetKeyValuesFamilyReply.more in getExactRange");
															#line 2584 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (reverse)
															#line 11676 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 2585 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				locations[shard].range = KeyRangeRef(locations[shard].range.begin, output[output.size() - 1].key);
															#line 11680 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
			else
			{
															#line 2588 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				locations[shard].range = KeyRangeRef(keyAfter(output[output.size() - 1].key), locations[shard].range.end);
															#line 11686 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
		}
															#line 2592 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		bool redoKeyLocationRequest = false;
															#line 2593 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!more || locations[shard].range.empty())
															#line 11693 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2594 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			CODE_PROBE(true, "getExactrange (!more || locations[shard].first.empty())");
															#line 2595 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (shard == locations.size() - 1)
															#line 11699 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 2596 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				const KeyRangeRef& range = locations[shard].range;
															#line 2597 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				KeyRef begin = reverse ? keys.begin : range.end;
															#line 2598 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				KeyRef end = reverse ? range.begin : keys.end;
															#line 2600 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (begin >= end)
															#line 11709 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				{
															#line 2601 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					output.more = false;
															#line 2602 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					if (!static_cast<GetExactRangeActor*>(this)->SAV<RangeResultFamily>::futures) { (void)(output); this->~GetExactRangeActorState(); static_cast<GetExactRangeActor*>(this)->destroy(); return 0; }
															#line 11715 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
					new (&static_cast<GetExactRangeActor*>(this)->SAV< RangeResultFamily >::value()) RangeResultFamily(std::move(output)); // state_var_RVO
					this->~GetExactRangeActorState();
					static_cast<GetExactRangeActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 2605 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				keys = KeyRangeRef(begin, end);
															#line 2606 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				redoKeyLocationRequest = true;
															#line 11725 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 2609 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			++shard;
															#line 11729 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 2615 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (limits.hasSatisfiedMinRows() && output.size() > 0)
															#line 11733 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2616 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			output.more = true;
															#line 2617 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!static_cast<GetExactRangeActor*>(this)->SAV<RangeResultFamily>::futures) { (void)(output); this->~GetExactRangeActorState(); static_cast<GetExactRangeActor*>(this)->destroy(); return 0; }
															#line 11739 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			new (&static_cast<GetExactRangeActor*>(this)->SAV< RangeResultFamily >::value()) RangeResultFamily(std::move(output)); // state_var_RVO
			this->~GetExactRangeActorState();
			static_cast<GetExactRangeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2620 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (redoKeyLocationRequest)
															#line 11747 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2621 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			CODE_PROBE(true, "Multiple requests of key locations");
															#line 11751 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont1loopBody1cont21(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch2(const Error& __current_error,int loopDepth=0) 
	{
		try {
															#line 2541 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			++trState->cx->transactionPhysicalReadsCompleted;
															#line 2542 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			return a_body1loopBody1cont1loopBody1Catch1(__current_error, loopDepth);
															#line 11765 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont4(int loopDepth) 
	{
															#line 2539 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++trState->cx->transactionPhysicalReadsCompleted;
															#line 11779 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 2524 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		return a_body1loopBody1cont1loopBody1Catch2(transaction_too_old(), loopDepth);
															#line 11788 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 2524 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		return a_body1loopBody1cont1loopBody1Catch2(transaction_too_old(), loopDepth);
															#line 11796 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when2(GetKeyValuesFamilyReply const& _rep,int loopDepth) 
	{
															#line 2536 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		rep = _rep;
															#line 11804 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when2(GetKeyValuesFamilyReply && _rep,int loopDepth) 
	{
															#line 2536 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		rep = _rep;
															#line 11813 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetExactRangeActor*>(this)->actor_wait_state > 0) static_cast<GetExactRangeActor*>(this)->actor_wait_state = 0;
		static_cast<GetExactRangeActor*>(this)->ActorCallback< GetExactRangeActor, 1, Void >::remove();
		static_cast<GetExactRangeActor*>(this)->ActorCallback< GetExactRangeActor, 2, GetKeyValuesFamilyReply >::remove();

	}
	void a_callback_fire(ActorCallback< GetExactRangeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getExactRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetExactRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch2(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getExactRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetExactRangeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getExactRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetExactRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch2(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getExactRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetExactRangeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getExactRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetExactRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch2(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getExactRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetExactRangeActor, 2, GetKeyValuesFamilyReply >*,GetKeyValuesFamilyReply const& value) 
	{
		fdb_probe_actor_enter("getExactRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetExactRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch2(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getExactRange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetExactRangeActor, 2, GetKeyValuesFamilyReply >*,GetKeyValuesFamilyReply && value) 
	{
		fdb_probe_actor_enter("getExactRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetExactRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch2(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getExactRange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetExactRangeActor, 2, GetKeyValuesFamilyReply >*,Error err) 
	{
		fdb_probe_actor_enter("getExactRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetExactRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch2(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getExactRange", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont1loopBody1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont21(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1cont2(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1cont2(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetExactRangeActor*>(this)->actor_wait_state > 0) static_cast<GetExactRangeActor*>(this)->actor_wait_state = 0;
		static_cast<GetExactRangeActor*>(this)->ActorCallback< GetExactRangeActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetExactRangeActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getExactRange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetExactRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getExactRange", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetExactRangeActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getExactRange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetExactRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getExactRange", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetExactRangeActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getExactRange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetExactRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getExactRange", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 2449 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reference<TransactionState> trState;
															#line 2449 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeyRange keys;
															#line 2449 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Key mapper;
															#line 2449 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetRangeLimits limits;
															#line 2449 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reverse reverse;
															#line 2449 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	UseTenant useTenant;
															#line 2456 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	RangeResultFamily output;
															#line 2458 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Span span;
															#line 2470 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	std::vector<KeyRangeLocationInfo> locations;
															#line 2478 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	int shard;
															#line 2520 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetKeyValuesFamilyReply rep;
															#line 12074 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
};
// This generated class is to be used only via getExactRange()
															#line 2449 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class GetKeyValuesFamilyRequest, class GetKeyValuesFamilyReply, class RangeResultFamily>
															#line 2449 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetExactRangeActor final : public Actor<RangeResultFamily>, public ActorCallback< GetExactRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 0, std::vector<KeyRangeLocationInfo> >, public ActorCallback< GetExactRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 1, Void >, public ActorCallback< GetExactRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 2, GetKeyValuesFamilyReply >, public ActorCallback< GetExactRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 3, Void >, public FastAllocated<GetExactRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>>, public GetExactRangeActorState<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily, GetExactRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>> {
															#line 12081 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
	using FastAllocated<GetExactRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>>::operator new;
	using FastAllocated<GetExactRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7699692152360001024UL, 14647836803351909120UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RangeResultFamily>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetExactRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 0, std::vector<KeyRangeLocationInfo> >;
friend struct ActorCallback< GetExactRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 1, Void >;
friend struct ActorCallback< GetExactRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 2, GetKeyValuesFamilyReply >;
friend struct ActorCallback< GetExactRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 3, Void >;
															#line 2449 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetExactRangeActor(Reference<TransactionState> const& trState,KeyRange const& keys,Key const& mapper,GetRangeLimits const& limits,Reverse const& reverse,UseTenant const& useTenant) 
															#line 12101 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		 : Actor<RangeResultFamily>(),
		   GetExactRangeActorState<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily, GetExactRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>>(trState, keys, mapper, limits, reverse, useTenant),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getExactRange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3520479274471320064UL, 12983301301951641856UL);
		ActorExecutionContextHelper __helper(static_cast<GetExactRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getExactRange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getExactRange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetExactRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 0, std::vector<KeyRangeLocationInfo> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetExactRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetExactRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2449 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class GetKeyValuesFamilyRequest, class GetKeyValuesFamilyReply, class RangeResultFamily>
															#line 2449 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<RangeResultFamily> getExactRange( Reference<TransactionState> const& trState, KeyRange const& keys, Key const& mapper, GetRangeLimits const& limits, Reverse const& reverse, UseTenant const& useTenant ) {
															#line 2449 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<RangeResultFamily>(new GetExactRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>(trState, keys, mapper, limits, reverse, useTenant));
															#line 12138 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
}

#line 2650 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

Future<Key> resolveKey(Reference<TransactionState> trState, KeySelector const& key, UseTenant useTenant) {
	if (key.isFirstGreaterOrEqual())
		return Future<Key>(key.getKey());

	if (key.isFirstGreaterThan())
		return Future<Key>(keyAfter(key.getKey()));

	return getKey(trState, key, useTenant);
}

															#line 12153 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
namespace {
// This generated class is to be used only via getRangeFallback()
															#line 2661 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class GetKeyValuesFamilyRequest, class GetKeyValuesFamilyReply, class RangeResultFamily, class GetRangeFallbackActor>
															#line 2661 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetRangeFallbackActorState {
															#line 12160 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
															#line 2661 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetRangeFallbackActorState(Reference<TransactionState> const& trState,KeySelector const& begin,KeySelector const& end,Key const& mapper,GetRangeLimits const& limits,Reverse const& reverse,UseTenant const& useTenant) 
															#line 2661 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 2661 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : trState(trState),
															#line 2661 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   begin(begin),
															#line 2661 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   end(end),
															#line 2661 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   mapper(mapper),
															#line 2661 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   limits(limits),
															#line 2661 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   reverse(reverse),
															#line 2661 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   useTenant(useTenant)
															#line 12179 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
	{
		fdb_probe_actor_create("getRangeFallback", reinterpret_cast<unsigned long>(this));

	}
	~GetRangeFallbackActorState() 
	{
		fdb_probe_actor_destroy("getRangeFallback", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2669 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			CODE_PROBE(trState->hasTenant() && useTenant, "NativeAPI getRangeFallback has tenant");
															#line 2670 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			CODE_PROBE(!useTenant, "NativeAPI getRangeFallback ignoring tenant");
															#line 2672 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			Future<Key> fb = resolveKey(trState, begin, useTenant);
															#line 2673 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			fe = resolveKey(trState, end, useTenant);
															#line 2675 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Key> __when_expr_0 = fb;
															#line 2675 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<GetRangeFallbackActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12204 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetRangeFallbackActor*>(this)->actor_wait_state = 1;
															#line 2675 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetRangeFallbackActor, 0, Key >*>(static_cast<GetRangeFallbackActor*>(this)));
															#line 12209 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetRangeFallbackActorState();
		static_cast<GetRangeFallbackActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2676 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Key> __when_expr_1 = fe;
															#line 2676 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetRangeFallbackActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12234 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetRangeFallbackActor*>(this)->actor_wait_state = 2;
															#line 2676 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetRangeFallbackActor, 1, Key >*>(static_cast<GetRangeFallbackActor*>(this)));
															#line 12239 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Key const& __b,int loopDepth) 
	{
															#line 2675 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		b = __b;
															#line 12248 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Key && __b,int loopDepth) 
	{
		b = std::move(__b);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetRangeFallbackActor*>(this)->actor_wait_state > 0) static_cast<GetRangeFallbackActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeFallbackActor*>(this)->ActorCallback< GetRangeFallbackActor, 0, Key >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeFallbackActor, 0, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("getRangeFallback", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeFallback", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetRangeFallbackActor, 0, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("getRangeFallback", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeFallback", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetRangeFallbackActor, 0, Key >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeFallback", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeFallback", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 2677 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (b >= e)
															#line 12327 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2678 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!static_cast<GetRangeFallbackActor*>(this)->SAV<RangeResultFamily>::futures) { (void)(RangeResultFamily()); this->~GetRangeFallbackActorState(); static_cast<GetRangeFallbackActor*>(this)->destroy(); return 0; }
															#line 12331 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			new (&static_cast<GetRangeFallbackActor*>(this)->SAV< RangeResultFamily >::value()) RangeResultFamily(RangeResultFamily());
			this->~GetRangeFallbackActorState();
			static_cast<GetRangeFallbackActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2685 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<RangeResultFamily> __when_expr_2 = getExactRange<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>( trState, KeyRangeRef(b, e), mapper, limits, reverse, useTenant);
															#line 2685 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetRangeFallbackActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12341 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<GetRangeFallbackActor*>(this)->actor_wait_state = 3;
															#line 2685 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetRangeFallbackActor, 2, RangeResultFamily >*>(static_cast<GetRangeFallbackActor*>(this)));
															#line 12346 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Key const& __e,int loopDepth) 
	{
															#line 2676 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		e = __e;
															#line 12355 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Key && __e,int loopDepth) 
	{
		e = std::move(__e);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetRangeFallbackActor*>(this)->actor_wait_state > 0) static_cast<GetRangeFallbackActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeFallbackActor*>(this)->ActorCallback< GetRangeFallbackActor, 1, Key >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeFallbackActor, 1, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("getRangeFallback", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeFallback", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetRangeFallbackActor, 1, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("getRangeFallback", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeFallback", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetRangeFallbackActor, 1, Key >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeFallback", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeFallback", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(RangeResultFamily const& _r,int loopDepth) 
	{
															#line 2687 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		RangeResultFamily r = _r;
															#line 2689 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (b == allKeys.begin && ((reverse && !r.more) || !reverse))
															#line 12436 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2690 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			r.readToBegin = true;
															#line 12440 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 2697 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (e == allKeys.end && ((!reverse && !r.more) || reverse))
															#line 12444 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2698 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			r.readThroughEnd = true;
															#line 12448 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 2700 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(!limits.hasRowLimit() || r.size() <= limits.rows);
															#line 2703 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (limits.hasByteLimit() && r.expectedSize() > size_t(limits.bytes + CLIENT_KNOBS->SYSTEM_KEY_SIZE_LIMIT + CLIENT_KNOBS->VALUE_SIZE_LIMIT + 1) && limits.minRows == 0)
															#line 12454 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2707 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			TraceEvent(SevWarnAlways, "GetRangeFallbackTooMuchData") .detail("LimitBytes", limits.bytes) .detail("DeliveredBytes", r.expectedSize()) .detail("LimitRows", limits.rows) .detail("DeliveredRows", r.size());
															#line 12458 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 2714 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetRangeFallbackActor*>(this)->SAV<RangeResultFamily>::futures) { (void)(r); this->~GetRangeFallbackActorState(); static_cast<GetRangeFallbackActor*>(this)->destroy(); return 0; }
															#line 12462 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<GetRangeFallbackActor*>(this)->SAV< RangeResultFamily >::value()) RangeResultFamily(r);
		this->~GetRangeFallbackActorState();
		static_cast<GetRangeFallbackActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(RangeResultFamily && _r,int loopDepth) 
	{
															#line 2687 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		RangeResultFamily r = _r;
															#line 2689 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (b == allKeys.begin && ((reverse && !r.more) || !reverse))
															#line 12476 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2690 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			r.readToBegin = true;
															#line 12480 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 2697 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (e == allKeys.end && ((!reverse && !r.more) || reverse))
															#line 12484 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2698 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			r.readThroughEnd = true;
															#line 12488 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 2700 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(!limits.hasRowLimit() || r.size() <= limits.rows);
															#line 2703 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (limits.hasByteLimit() && r.expectedSize() > size_t(limits.bytes + CLIENT_KNOBS->SYSTEM_KEY_SIZE_LIMIT + CLIENT_KNOBS->VALUE_SIZE_LIMIT + 1) && limits.minRows == 0)
															#line 12494 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2707 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			TraceEvent(SevWarnAlways, "GetRangeFallbackTooMuchData") .detail("LimitBytes", limits.bytes) .detail("DeliveredBytes", r.expectedSize()) .detail("LimitRows", limits.rows) .detail("DeliveredRows", r.size());
															#line 12498 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 2714 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetRangeFallbackActor*>(this)->SAV<RangeResultFamily>::futures) { (void)(r); this->~GetRangeFallbackActorState(); static_cast<GetRangeFallbackActor*>(this)->destroy(); return 0; }
															#line 12502 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<GetRangeFallbackActor*>(this)->SAV< RangeResultFamily >::value()) RangeResultFamily(r);
		this->~GetRangeFallbackActorState();
		static_cast<GetRangeFallbackActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(RangeResultFamily const& _r,int loopDepth) 
	{
		loopDepth = a_body1cont3(_r, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(RangeResultFamily && _r,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_r), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetRangeFallbackActor*>(this)->actor_wait_state > 0) static_cast<GetRangeFallbackActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeFallbackActor*>(this)->ActorCallback< GetRangeFallbackActor, 2, RangeResultFamily >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeFallbackActor, 2, RangeResultFamily >*,RangeResultFamily const& value) 
	{
		fdb_probe_actor_enter("getRangeFallback", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeFallback", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetRangeFallbackActor, 2, RangeResultFamily >*,RangeResultFamily && value) 
	{
		fdb_probe_actor_enter("getRangeFallback", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeFallback", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetRangeFallbackActor, 2, RangeResultFamily >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeFallback", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeFallback", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 2661 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reference<TransactionState> trState;
															#line 2661 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeySelector begin;
															#line 2661 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeySelector end;
															#line 2661 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Key mapper;
															#line 2661 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetRangeLimits limits;
															#line 2661 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reverse reverse;
															#line 2661 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	UseTenant useTenant;
															#line 2673 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Future<Key> fe;
															#line 2675 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Key b;
															#line 2676 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Key e;
															#line 12605 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
};
// This generated class is to be used only via getRangeFallback()
															#line 2661 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class GetKeyValuesFamilyRequest, class GetKeyValuesFamilyReply, class RangeResultFamily>
															#line 2661 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetRangeFallbackActor final : public Actor<RangeResultFamily>, public ActorCallback< GetRangeFallbackActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 0, Key >, public ActorCallback< GetRangeFallbackActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 1, Key >, public ActorCallback< GetRangeFallbackActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 2, RangeResultFamily >, public FastAllocated<GetRangeFallbackActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>>, public GetRangeFallbackActorState<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily, GetRangeFallbackActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>> {
															#line 12612 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
	using FastAllocated<GetRangeFallbackActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>>::operator new;
	using FastAllocated<GetRangeFallbackActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3581417499624766208UL, 13512048377133121536UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RangeResultFamily>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetRangeFallbackActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 0, Key >;
friend struct ActorCallback< GetRangeFallbackActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 1, Key >;
friend struct ActorCallback< GetRangeFallbackActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 2, RangeResultFamily >;
															#line 2661 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetRangeFallbackActor(Reference<TransactionState> const& trState,KeySelector const& begin,KeySelector const& end,Key const& mapper,GetRangeLimits const& limits,Reverse const& reverse,UseTenant const& useTenant) 
															#line 12631 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		 : Actor<RangeResultFamily>(),
		   GetRangeFallbackActorState<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily, GetRangeFallbackActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>>(trState, begin, end, mapper, limits, reverse, useTenant),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getRangeFallback", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3517076735759144704UL, 3895872481659177216UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getRangeFallback");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getRangeFallback", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetRangeFallbackActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 0, Key >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetRangeFallbackActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 1, Key >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetRangeFallbackActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 2, RangeResultFamily >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2661 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class GetKeyValuesFamilyRequest, class GetKeyValuesFamilyReply, class RangeResultFamily>
															#line 2661 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<RangeResultFamily> getRangeFallback( Reference<TransactionState> const& trState, KeySelector const& begin, KeySelector const& end, Key const& mapper, GetRangeLimits const& limits, Reverse const& reverse, UseTenant const& useTenant ) {
															#line 2661 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<RangeResultFamily>(new GetRangeFallbackActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>(trState, begin, end, mapper, limits, reverse, useTenant));
															#line 12668 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
}

#line 2716 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

int64_t inline getRangeResultFamilyBytes(RangeResultRef result) {
	return result.expectedSize();
}

int64_t inline getRangeResultFamilyBytes(MappedRangeResultRef result) {
	int64_t bytes = 0;
	for (const MappedKeyValueRef& mappedKeyValue : result) {
		bytes += mappedKeyValue.key.size() + mappedKeyValue.value.size();
		auto& reqAndResult = mappedKeyValue.reqAndResult;
		if (std::holds_alternative<GetValueReqAndResultRef>(reqAndResult)) {
			auto getValue = std::get<GetValueReqAndResultRef>(reqAndResult);
			bytes += getValue.expectedSize();
		} else if (std::holds_alternative<GetRangeReqAndResultRef>(reqAndResult)) {
			auto getRange = std::get<GetRangeReqAndResultRef>(reqAndResult);
			bytes += getRange.result.expectedSize();
		} else {
			throw internal_error();
		}
	}
	return bytes;
}

// TODO: Client should add mapped keys to conflict ranges.
template <class RangeResultFamily> // RangeResult or MappedRangeResult
void getRangeFinished(Reference<TransactionState> trState,
                      double startTime,
                      KeySelector begin,
                      KeySelector end,
                      Snapshot snapshot,
                      Promise<std::pair<Key, Key>> conflictRange,
                      Reverse reverse,
                      RangeResultFamily result) {
	int64_t bytes = getRangeResultFamilyBytes(result);

	trState->totalCost += getReadOperationCost(bytes);
	trState->cx->transactionBytesRead += bytes;
	trState->cx->transactionKeysRead += result.size();

	if (trState->trLogInfo) {
		trState->trLogInfo->addLog(FdbClientLogEvents::EventGetRange(startTime,
		                                                             trState->cx->clientLocality.dcId(),
		                                                             now() - startTime,
		                                                             bytes,
		                                                             begin.getKey(),
		                                                             end.getKey(),
		                                                             trState->tenant().flatMapRef(&Tenant::name)));
	}

	if (!snapshot) {
		Key rangeBegin;
		Key rangeEnd;

		if (result.readToBegin) {
			rangeBegin = allKeys.begin;
		} else if (((!reverse || !result.more || begin.offset > 1) && begin.offset > 0) || result.size() == 0) {
			rangeBegin = Key(begin.getKey(), begin.arena());
		} else {
			rangeBegin = reverse ? result.end()[-1].key : result[0].key;
		}

		if (end.offset > begin.offset && end.getKey() < rangeBegin) {
			rangeBegin = Key(end.getKey(), end.arena());
		}

		if (result.readThroughEnd) {
			rangeEnd = allKeys.end;
		} else if (((reverse || !result.more || end.offset <= 0) && end.offset <= 1) || result.size() == 0) {
			rangeEnd = Key(end.getKey(), end.arena());
		} else {
			rangeEnd = keyAfter(reverse ? result[0].key : result.end()[-1].key);
		}

		if (begin.offset < end.offset && begin.getKey() > rangeEnd) {
			rangeEnd = Key(begin.getKey(), begin.arena());
		}

		conflictRange.send(std::make_pair(rangeBegin, rangeEnd));
	}
}

															#line 12753 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
namespace {
// This generated class is to be used only via getRange()
															#line 2797 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class GetKeyValuesFamilyRequest, class GetKeyValuesFamilyReply, class RangeResultFamily, class GetRangeActor>
															#line 2797 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetRangeActorState {
															#line 12760 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
															#line 2797 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetRangeActorState(Reference<TransactionState> const& trState,KeySelector const& begin,KeySelector const& end,Key const& mapper,GetRangeLimits const& limits,Promise<std::pair<Key, Key>> const& conflictRange,Snapshot const& snapshot,Reverse const& reverse,UseTenant const& useTenant = UseTenant::True) 
															#line 2797 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 2797 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : trState(trState),
															#line 2797 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   begin(begin),
															#line 2797 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   end(end),
															#line 2797 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   mapper(mapper),
															#line 2797 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   limits(limits),
															#line 2797 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   conflictRange(conflictRange),
															#line 2797 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   snapshot(snapshot),
															#line 2797 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   reverse(reverse),
															#line 2797 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   useTenant(useTenant),
															#line 2813 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   originalLimits(limits),
															#line 2814 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   originalBegin(begin),
															#line 2815 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   originalEnd(end),
															#line 2816 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   output(),
															#line 2817 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   span("NAPI:getRange"_loc, trState->spanContext),
															#line 2818 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   getRangeID(Optional<UID>())
															#line 12795 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
	{
		fdb_probe_actor_create("getRange", reinterpret_cast<unsigned long>(this));

	}
	~GetRangeActorState() 
	{
		fdb_probe_actor_destroy("getRange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2820 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			CODE_PROBE(trState->hasTenant() && useTenant, "NativeAPI getExactRange has tenant");
															#line 2821 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			CODE_PROBE(!useTenant, "Get range ignoring tenant");
															#line 2823 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (useTenant && trState->hasTenant())
															#line 12814 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 2824 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				span.addAttribute("tenant"_sr, trState->tenant().get()->name.castTo<TenantNameRef>().orDefault("<unspecified>"_sr));
															#line 12818 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
			try {
															#line 2829 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				StrictFuture<Void> __when_expr_0 = trState->startTransaction();
															#line 2829 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (static_cast<GetRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 12825 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetRangeActor*>(this)->actor_wait_state = 1;
															#line 2829 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetRangeActor, 0, Void >*>(static_cast<GetRangeActor*>(this)));
															#line 12830 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetRangeActorState();
		static_cast<GetRangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 3103 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (conflictRange.canBeSet())
															#line 12860 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 3104 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				conflictRange.send(std::make_pair(Key(), Key()));
															#line 12864 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 3107 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 12868 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 2830 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		trState->cx->validateVersion(trState->readVersion());
															#line 2832 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		startTime = now();
															#line 2834 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (begin.getKey() == allKeys.begin && begin.offset < 1)
															#line 12886 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2835 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			output.readToBegin = true;
															#line 2836 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			begin = KeySelector(firstGreaterOrEqual(begin.getKey()), begin.arena());
															#line 12892 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 2839 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(!limits.isReached());
															#line 2840 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT((!limits.hasRowLimit() || limits.rows >= limits.minRows) && limits.minRows >= 0);
															#line 2842 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		;
															#line 12900 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 2830 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		trState->cx->validateVersion(trState->readVersion());
															#line 2832 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		startTime = now();
															#line 2834 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (begin.getKey() == allKeys.begin && begin.offset < 1)
															#line 12913 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2835 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			output.readToBegin = true;
															#line 2836 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			begin = KeySelector(firstGreaterOrEqual(begin.getKey()), begin.arena());
															#line 12919 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 2839 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(!limits.isReached());
															#line 2840 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT((!limits.hasRowLimit() || limits.rows >= limits.minRows) && limits.minRows >= 0);
															#line 2842 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		;
															#line 12927 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetRangeActor*>(this)->actor_wait_state > 0) static_cast<GetRangeActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeActor*>(this)->ActorCallback< GetRangeActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetRangeActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetRangeActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1(int loopDepth) 
	{
															#line 2843 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (end.getKey() == allKeys.begin && (end.offset < 1 || end.isFirstGreaterOrEqual()))
															#line 13018 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2844 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			getRangeFinished( trState, startTime, originalBegin, originalEnd, snapshot, conflictRange, reverse, output);
															#line 2846 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!static_cast<GetRangeActor*>(this)->SAV<RangeResultFamily>::futures) { (void)(output); this->~GetRangeActorState(); static_cast<GetRangeActor*>(this)->destroy(); return 0; }
															#line 13024 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			new (&static_cast<GetRangeActor*>(this)->SAV< RangeResultFamily >::value()) RangeResultFamily(std::move(output)); // state_var_RVO
			this->~GetRangeActorState();
			static_cast<GetRangeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2849 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		Key locationKey = reverse ? Key(end.getKey(), end.arena()) : Key(begin.getKey(), begin.arena());
															#line 2850 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		Reverse locationBackward{ reverse ? (end - 1).isBackward() : begin.isBackward() };
															#line 2851 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<KeyRangeLocationInfo> __when_expr_1 = getKeyLocation( trState, locationKey, getRangeRequestStream<GetKeyValuesFamilyRequest>(), locationBackward, useTenant);
															#line 2851 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 13038 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetRangeActor*>(this)->actor_wait_state = 2;
															#line 2851 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetRangeActor, 1, KeyRangeLocationInfo >*>(static_cast<GetRangeActor*>(this)));
															#line 13043 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(int loopDepth) 
	{
															#line 2853 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		shard = beginServer.range;
															#line 2854 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		modifiedSelectors = false;
															#line 2855 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req = GetKeyValuesFamilyRequest();
															#line 2856 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.mapper = mapper;
															#line 2857 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.arena.dependsOn(mapper.arena());
															#line 2858 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.tenantInfo = useTenant ? trState->getTenantInfo() : TenantInfo();
															#line 2859 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.options = trState->readOptions;
															#line 2860 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.version = trState->readVersion();
															#line 2861 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.taskID = trState->taskID;
															#line 2863 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		trState->cx->getLatestCommitVersions(beginServer.locations, trState, req.ssLatestCommitVersions);
															#line 2867 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		bool dependOnShard = false;
															#line 2868 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (reverse && (begin - 1).isDefinitelyLess(shard.begin) && (!begin.isFirstGreaterOrEqual() || begin.getKey() != shard.begin))
															#line 13074 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2873 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			req.begin = firstGreaterOrEqual(shard.begin);
															#line 2874 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			modifiedSelectors = true;
															#line 2875 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			req.arena.dependsOn(shard.arena());
															#line 2876 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			dependOnShard = true;
															#line 13084 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
		else
		{
															#line 2878 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			req.begin = begin;
															#line 2879 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			req.arena.dependsOn(begin.arena());
															#line 13092 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 2882 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!reverse && end.isDefinitelyGreater(shard.end))
															#line 13096 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2883 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			req.end = firstGreaterOrEqual(shard.end);
															#line 2884 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			modifiedSelectors = true;
															#line 2885 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!dependOnShard)
															#line 13104 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 2886 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				req.arena.dependsOn(shard.arena());
															#line 13108 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
		}
		else
		{
															#line 2889 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			req.end = end;
															#line 2890 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			req.arena.dependsOn(end.arena());
															#line 13117 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 2893 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		transformRangeLimits(limits, reverse, req);
															#line 2894 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(req.limitBytes > 0 && req.limit != 0 && req.limit < 0 == reverse);
															#line 2896 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.tags = trState->cx->sampleReadTags() ? trState->options.readTags : Optional<TagSet>();
															#line 2897 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.spanContext = span.context;
															#line 2898 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (trState->readOptions.present() && trState->readOptions.get().debugID.present())
															#line 13129 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2899 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			getRangeID = nondeterministicRandom()->randomUniqueID();
															#line 2900 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			g_traceBatch.addAttach( "TransactionAttachID", trState->readOptions.get().debugID.get().first(), getRangeID.get().first());
															#line 13135 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
		try {
															#line 2904 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (getRangeID.present())
															#line 13140 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 2905 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				g_traceBatch.addEvent("TransactionDebug", getRangeID.get().first(), "NativeAPI.getRange.Before");
															#line 13144 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 2925 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			++trState->cx->transactionPhysicalReads;
															#line 2926 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			rep = GetKeyValuesFamilyReply();
															#line 13150 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			try {
															#line 2928 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (CLIENT_BUGGIFY_WITH_PROB(.01))
															#line 13154 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				{
															#line 2929 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					return a_body1cont3loopBody1cont1Catch2(deterministicRandom()->randomChoice( std::vector<Error>{ transaction_too_old(), future_version() }), loopDepth);
															#line 13158 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				}
															#line 2933 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				StrictFuture<GetKeyValuesFamilyReply> __when_expr_2 = loadBalance(trState->cx.getPtr(), beginServer.locations, getRangeRequestStream<GetKeyValuesFamilyRequest>(), req, TaskPriority::DefaultPromiseEndpoint, AtMostOnce::False, trState->cx->enableLocalityLoadBalance ? &trState->cx->queueModel : nullptr, trState->options.enableReplicaConsistencyCheck, trState->options.requiredReplicas);
															#line 2933 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (static_cast<GetRangeActor*>(this)->actor_wait_state < 0) return a_body1cont3loopBody1cont1Catch2(actor_cancelled(), loopDepth);
															#line 13164 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont3loopBody1cont1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont3loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
				static_cast<GetRangeActor*>(this)->actor_wait_state = 3;
															#line 2933 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetRangeActor, 2, GetKeyValuesFamilyReply >*>(static_cast<GetRangeActor*>(this)));
															#line 13169 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont3loopBody1cont1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont3loopBody1cont1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1cont3loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont3loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(KeyRangeLocationInfo const& __beginServer,int loopDepth) 
	{
															#line 2851 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		beginServer = __beginServer;
															#line 13190 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(KeyRangeLocationInfo && __beginServer,int loopDepth) 
	{
		beginServer = std::move(__beginServer);
		loopDepth = a_body1cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetRangeActor*>(this)->actor_wait_state > 0) static_cast<GetRangeActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeActor*>(this)->ActorCallback< GetRangeActor, 1, KeyRangeLocationInfo >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeActor, 1, KeyRangeLocationInfo >*,KeyRangeLocationInfo const& value) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetRangeActor, 1, KeyRangeLocationInfo >*,KeyRangeLocationInfo && value) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetRangeActor, 1, KeyRangeLocationInfo >*,Error err) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3loopBody1cont3(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 3068 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (getRangeID.present())
															#line 13276 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 3069 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				g_traceBatch.addEvent("TransactionDebug", getRangeID.get().first(), "NativeAPI.getRange.Error");
															#line 3070 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				TraceEvent("TransactionDebugError", getRangeID.get()).error(e);
															#line 13282 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 3072 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (e.code() == error_code_wrong_shard_server || e.code() == error_code_all_alternatives_failed)
															#line 13286 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 3073 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				trState->cx->invalidateCache(useTenant ? trState->tenant().mapRef(&Tenant::prefix) : Optional<KeyRef>(), reverse ? end.getKey() : begin.getKey(), Reverse{ reverse ? (end - 1).isBackward() : begin.isBackward() });
															#line 3078 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (e.code() == error_code_wrong_shard_server)
															#line 13292 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				{
															#line 3079 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					StrictFuture<RangeResultFamily> __when_expr_4 = getRangeFallback<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>( trState, originalBegin, originalEnd, mapper, originalLimits, reverse, useTenant);
															#line 3079 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					if (static_cast<GetRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 13298 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
					if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch2(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1cont1Catch1when1(__when_expr_4.get(), loopDepth); };
					static_cast<GetRangeActor*>(this)->actor_wait_state = 5;
															#line 3079 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< GetRangeActor, 4, RangeResultFamily >*>(static_cast<GetRangeActor*>(this)));
															#line 13303 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont3loopBody1cont1Catch1cont3(loopDepth);
				}
			}
			else
			{
															#line 3089 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (trState->trLogInfo)
															#line 13315 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				{
															#line 3090 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					trState->trLogInfo->addLog( FdbClientLogEvents::EventGetRangeError(startTime, trState->cx->clientLocality.dcId(), static_cast<int>(e.code()), begin.getKey(), end.getKey(), trState->tenant().flatMapRef(&Tenant::name)));
															#line 13319 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				}
															#line 3098 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				return a_body1Catch2(e, std::max(0, loopDepth - 1));
															#line 13323 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont10(int loopDepth) 
	{
															#line 2950 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (getRangeID.present())
															#line 13338 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2951 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			g_traceBatch.addEvent("TransactionDebug", getRangeID.get().first(), "NativeAPI.getRange.After");
															#line 13342 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 2965 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(!rep.more || rep.data.size());
															#line 2966 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(!limits.hasRowLimit() || rep.data.size() <= limits.rows);
															#line 2968 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		limits.decrement(rep.data);
															#line 2970 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (reverse && begin.isLastLessOrEqual() && rep.data.size() && rep.data.end()[-1].key == begin.getKey())
															#line 13352 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2972 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			modifiedSelectors = false;
															#line 13356 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 2975 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		bool finished = limits.isReached() || (!modifiedSelectors && !rep.more) || limits.hasSatisfiedMinRows();
															#line 2976 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		bool readThrough = modifiedSelectors && !rep.more;
															#line 2979 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (finished && !output.size())
															#line 13364 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2980 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			bool readToBegin = output.readToBegin;
															#line 2981 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			bool readThroughEnd = output.readThroughEnd;
															#line 2983 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			using RangeResultRefFamily = typename RangeResultFamily::RefType;
															#line 2984 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			output = RangeResultFamily( RangeResultRefFamily(rep.data, modifiedSelectors || limits.isReached() || rep.more), rep.arena);
															#line 2986 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			output.readToBegin = readToBegin;
															#line 2987 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			output.readThroughEnd = readThroughEnd;
															#line 2989 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (BUGGIFY && limits.hasByteLimit() && output.size() > std::max(1, originalLimits.minRows) && (!std::is_same<GetKeyValuesFamilyRequest, GetMappedKeyValuesRequest>::value))
															#line 13380 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 2994 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				RangeResultFamily copy;
															#line 2995 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				int newSize = deterministicRandom()->randomInt(std::max(1, originalLimits.minRows), output.size());
															#line 2997 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				for(int i = 0;i < newSize;i++) {
															#line 2998 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					copy.push_back_deep(copy.arena(), output[i]);
															#line 13390 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				}
															#line 3000 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				output = copy;
															#line 3001 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				output.more = true;
															#line 3003 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				getRangeFinished( trState, startTime, originalBegin, originalEnd, snapshot, conflictRange, reverse, output);
															#line 3005 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (!static_cast<GetRangeActor*>(this)->SAV<RangeResultFamily>::futures) { (void)(output); this->~GetRangeActorState(); static_cast<GetRangeActor*>(this)->destroy(); return 0; }
															#line 13400 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				new (&static_cast<GetRangeActor*>(this)->SAV< RangeResultFamily >::value()) RangeResultFamily(std::move(output)); // state_var_RVO
				this->~GetRangeActorState();
				static_cast<GetRangeActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 3008 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (readThrough)
															#line 13408 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 3009 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				output.arena().dependsOn(shard.arena());
															#line 3011 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				ASSERT(modifiedSelectors);
															#line 3012 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				output.more = true;
															#line 3013 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				output.setReadThrough(reverse ? shard.begin : shard.end);
															#line 13418 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 3016 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			getRangeFinished( trState, startTime, originalBegin, originalEnd, snapshot, conflictRange, reverse, output);
															#line 3018 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!output.more)
															#line 13424 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 3019 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				ASSERT(!output.readThrough.present());
															#line 13428 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 3021 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!static_cast<GetRangeActor*>(this)->SAV<RangeResultFamily>::futures) { (void)(output); this->~GetRangeActorState(); static_cast<GetRangeActor*>(this)->destroy(); return 0; }
															#line 13432 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			new (&static_cast<GetRangeActor*>(this)->SAV< RangeResultFamily >::value()) RangeResultFamily(std::move(output)); // state_var_RVO
			this->~GetRangeActorState();
			static_cast<GetRangeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 3024 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		output.arena().dependsOn(rep.arena);
															#line 3025 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		output.append(output.arena(), rep.data.begin(), rep.data.size());
															#line 3027 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (finished)
															#line 13444 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 3028 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			output.more = modifiedSelectors || limits.isReached() || rep.more;
															#line 3029 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (readThrough)
															#line 13450 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 3030 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				output.arena().dependsOn(shard.arena());
															#line 3031 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				output.setReadThrough(reverse ? shard.begin : shard.end);
															#line 13456 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 3034 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			getRangeFinished( trState, startTime, originalBegin, originalEnd, snapshot, conflictRange, reverse, output);
															#line 3036 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!output.more)
															#line 13462 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 3037 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				ASSERT(!output.readThrough.present());
															#line 13466 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 3039 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!static_cast<GetRangeActor*>(this)->SAV<RangeResultFamily>::futures) { (void)(output); this->~GetRangeActorState(); static_cast<GetRangeActor*>(this)->destroy(); return 0; }
															#line 13470 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			new (&static_cast<GetRangeActor*>(this)->SAV< RangeResultFamily >::value()) RangeResultFamily(std::move(output)); // state_var_RVO
			this->~GetRangeActorState();
			static_cast<GetRangeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 3042 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!rep.more)
															#line 13478 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 3043 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			ASSERT(modifiedSelectors);
															#line 3044 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			CODE_PROBE(true, "!GetKeyValuesFamilyReply.more and modifiedSelectors in getRange");
															#line 3046 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!rep.data.size())
															#line 13486 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 3047 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				StrictFuture<RangeResultFamily> __when_expr_3 = getRangeFallback<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>( trState, originalBegin, originalEnd, mapper, originalLimits, reverse, useTenant);
															#line 3047 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (static_cast<GetRangeActor*>(this)->actor_wait_state < 0) return a_body1cont3loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 13492 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont3loopBody1cont1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3loopBody1cont10when1(__when_expr_3.get(), loopDepth); };
				static_cast<GetRangeActor*>(this)->actor_wait_state = 4;
															#line 3047 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetRangeActor, 3, RangeResultFamily >*>(static_cast<GetRangeActor*>(this)));
															#line 13497 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont3loopBody1cont10cont12(loopDepth);
			}
		}
		else
		{
															#line 3060 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			CODE_PROBE(true, "GetKeyValuesFamilyReply.more in getRange");
															#line 3061 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (reverse)
															#line 13511 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 3062 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				end = firstGreaterOrEqual(output[output.size() - 1].key);
															#line 13515 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
			else
			{
															#line 3064 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				begin = firstGreaterThan(output[output.size() - 1].key);
															#line 13521 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
			loopDepth = a_body1cont3loopBody1cont10cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1Catch2(const Error& __current_error,int loopDepth=0) 
	{
		try {
															#line 2946 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			++trState->cx->transactionPhysicalReadsCompleted;
															#line 2947 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			return a_body1cont3loopBody1cont1Catch1(__current_error, loopDepth);
															#line 13535 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1cont3loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont3loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont12(GetKeyValuesFamilyReply const& _rep,int loopDepth) 
	{
															#line 2943 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		rep = _rep;
															#line 2944 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++trState->cx->transactionPhysicalReadsCompleted;
															#line 13551 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1cont3loopBody1cont12cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont12(GetKeyValuesFamilyReply && _rep,int loopDepth) 
	{
															#line 2943 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		rep = _rep;
															#line 2944 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++trState->cx->transactionPhysicalReadsCompleted;
															#line 13562 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1cont3loopBody1cont12cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1when1(GetKeyValuesFamilyReply const& _rep,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont12(_rep, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1when1(GetKeyValuesFamilyReply && _rep,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont12(std::move(_rep), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetRangeActor*>(this)->actor_wait_state > 0) static_cast<GetRangeActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeActor*>(this)->ActorCallback< GetRangeActor, 2, GetKeyValuesFamilyReply >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeActor, 2, GetKeyValuesFamilyReply >*,GetKeyValuesFamilyReply const& value) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1cont1Catch2(error, 0);
		} catch (...) {
			a_body1cont3loopBody1cont1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetRangeActor, 2, GetKeyValuesFamilyReply >*,GetKeyValuesFamilyReply && value) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1cont1Catch2(error, 0);
		} catch (...) {
			a_body1cont3loopBody1cont1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetRangeActor, 2, GetKeyValuesFamilyReply >*,Error err) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3loopBody1cont1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1cont1Catch2(error, 0);
		} catch (...) {
			a_body1cont3loopBody1cont1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont3loopBody1cont12cont2(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont3loopBody1cont10(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont3loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont3loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont10cont1(int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont10cont17(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont10cont12(int loopDepth) 
	{
															#line 3055 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (reverse)
															#line 13665 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 3056 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			end = firstGreaterOrEqual(shard.begin);
															#line 13669 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
		else
		{
															#line 3058 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			begin = firstGreaterOrEqual(shard.end);
															#line 13675 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
		loopDepth = a_body1cont3loopBody1cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont10cont13(RangeResultFamily const& result,int loopDepth) 
	{
															#line 3050 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		getRangeFinished( trState, startTime, originalBegin, originalEnd, snapshot, conflictRange, reverse, result);
															#line 3052 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetRangeActor*>(this)->SAV<RangeResultFamily>::futures) { (void)(result); this->~GetRangeActorState(); static_cast<GetRangeActor*>(this)->destroy(); return 0; }
															#line 13687 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<GetRangeActor*>(this)->SAV< RangeResultFamily >::value()) RangeResultFamily(result);
		this->~GetRangeActorState();
		static_cast<GetRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1cont10cont13(RangeResultFamily && result,int loopDepth) 
	{
															#line 3050 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		getRangeFinished( trState, startTime, originalBegin, originalEnd, snapshot, conflictRange, reverse, result);
															#line 3052 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetRangeActor*>(this)->SAV<RangeResultFamily>::futures) { (void)(result); this->~GetRangeActorState(); static_cast<GetRangeActor*>(this)->destroy(); return 0; }
															#line 13701 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<GetRangeActor*>(this)->SAV< RangeResultFamily >::value()) RangeResultFamily(result);
		this->~GetRangeActorState();
		static_cast<GetRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1cont10when1(RangeResultFamily const& result,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont10cont13(result, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont10when1(RangeResultFamily && result,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont10cont13(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<GetRangeActor*>(this)->actor_wait_state > 0) static_cast<GetRangeActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeActor*>(this)->ActorCallback< GetRangeActor, 3, RangeResultFamily >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeActor, 3, RangeResultFamily >*,RangeResultFamily const& value) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetRangeActor, 3, RangeResultFamily >*,RangeResultFamily && value) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetRangeActor, 3, RangeResultFamily >*,Error err) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont3loopBody1cont10cont17(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont3loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1Catch1cont3(int loopDepth) 
	{
															#line 3087 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_5 = delay(CLIENT_KNOBS->WRONG_SHARD_SERVER_DELAY, trState->taskID);
															#line 3087 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 13809 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch2(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1cont1Catch1cont3when1(__when_expr_5.get(), loopDepth); };
		static_cast<GetRangeActor*>(this)->actor_wait_state = 6;
															#line 3087 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< GetRangeActor, 5, Void >*>(static_cast<GetRangeActor*>(this)));
															#line 13814 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1Catch1cont4(RangeResultFamily const& result,int loopDepth) 
	{
															#line 3082 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		getRangeFinished( trState, startTime, originalBegin, originalEnd, snapshot, conflictRange, reverse, result);
															#line 3084 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetRangeActor*>(this)->SAV<RangeResultFamily>::futures) { (void)(result); this->~GetRangeActorState(); static_cast<GetRangeActor*>(this)->destroy(); return 0; }
															#line 13825 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<GetRangeActor*>(this)->SAV< RangeResultFamily >::value()) RangeResultFamily(result);
		this->~GetRangeActorState();
		static_cast<GetRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1Catch1cont4(RangeResultFamily && result,int loopDepth) 
	{
															#line 3082 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		getRangeFinished( trState, startTime, originalBegin, originalEnd, snapshot, conflictRange, reverse, result);
															#line 3084 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetRangeActor*>(this)->SAV<RangeResultFamily>::futures) { (void)(result); this->~GetRangeActorState(); static_cast<GetRangeActor*>(this)->destroy(); return 0; }
															#line 13839 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<GetRangeActor*>(this)->SAV< RangeResultFamily >::value()) RangeResultFamily(result);
		this->~GetRangeActorState();
		static_cast<GetRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1Catch1when1(RangeResultFamily const& result,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1Catch1cont4(result, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1Catch1when1(RangeResultFamily && result,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1Catch1cont4(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<GetRangeActor*>(this)->actor_wait_state > 0) static_cast<GetRangeActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeActor*>(this)->ActorCallback< GetRangeActor, 4, RangeResultFamily >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeActor, 4, RangeResultFamily >*,RangeResultFamily const& value) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont3loopBody1cont1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< GetRangeActor, 4, RangeResultFamily >*,RangeResultFamily && value) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont3loopBody1cont1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< GetRangeActor, 4, RangeResultFamily >*,Error err) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont3loopBody1cont1Catch1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1Catch1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1Catch1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1Catch1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1Catch1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1Catch1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<GetRangeActor*>(this)->actor_wait_state > 0) static_cast<GetRangeActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeActor*>(this)->ActorCallback< GetRangeActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont3loopBody1cont1Catch1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< GetRangeActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont3loopBody1cont1Catch1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< GetRangeActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 2797 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reference<TransactionState> trState;
															#line 2797 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeySelector begin;
															#line 2797 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeySelector end;
															#line 2797 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Key mapper;
															#line 2797 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetRangeLimits limits;
															#line 2797 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Promise<std::pair<Key, Key>> conflictRange;
															#line 2797 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Snapshot snapshot;
															#line 2797 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reverse reverse;
															#line 2797 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	UseTenant useTenant;
															#line 2813 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetRangeLimits originalLimits;
															#line 2814 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeySelector originalBegin;
															#line 2815 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeySelector originalEnd;
															#line 2816 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	RangeResultFamily output;
															#line 2817 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Span span;
															#line 2818 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Optional<UID> getRangeID;
															#line 2832 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	double startTime;
															#line 2851 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeyRangeLocationInfo beginServer;
															#line 2853 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeyRange shard;
															#line 2854 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	bool modifiedSelectors;
															#line 2855 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetKeyValuesFamilyRequest req;
															#line 2926 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetKeyValuesFamilyReply rep;
															#line 14051 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
};
// This generated class is to be used only via getRange()
															#line 2797 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class GetKeyValuesFamilyRequest, class GetKeyValuesFamilyReply, class RangeResultFamily>
															#line 2797 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetRangeActor final : public Actor<RangeResultFamily>, public ActorCallback< GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 0, Void >, public ActorCallback< GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 1, KeyRangeLocationInfo >, public ActorCallback< GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 2, GetKeyValuesFamilyReply >, public ActorCallback< GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 3, RangeResultFamily >, public ActorCallback< GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 4, RangeResultFamily >, public ActorCallback< GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 5, Void >, public FastAllocated<GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>>, public GetRangeActorState<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily, GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>> {
															#line 14058 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
	using FastAllocated<GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>>::operator new;
	using FastAllocated<GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(963978482902304256UL, 1147005225546018048UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RangeResultFamily>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 0, Void >;
friend struct ActorCallback< GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 1, KeyRangeLocationInfo >;
friend struct ActorCallback< GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 2, GetKeyValuesFamilyReply >;
friend struct ActorCallback< GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 3, RangeResultFamily >;
friend struct ActorCallback< GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 4, RangeResultFamily >;
friend struct ActorCallback< GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 5, Void >;
															#line 2797 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetRangeActor(Reference<TransactionState> const& trState,KeySelector const& begin,KeySelector const& end,Key const& mapper,GetRangeLimits const& limits,Promise<std::pair<Key, Key>> const& conflictRange,Snapshot const& snapshot,Reverse const& reverse,UseTenant const& useTenant = UseTenant::True) 
															#line 14080 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		 : Actor<RangeResultFamily>(),
		   GetRangeActorState<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily, GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>>(trState, begin, end, mapper, limits, conflictRange, snapshot, reverse, useTenant),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2910272544121951744UL, 708275608187718144UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getRange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 1, KeyRangeLocationInfo >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 2, GetKeyValuesFamilyReply >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 3, RangeResultFamily >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 4, RangeResultFamily >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2797 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class GetKeyValuesFamilyRequest, class GetKeyValuesFamilyReply, class RangeResultFamily>
															#line 2797 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<RangeResultFamily> getRange( Reference<TransactionState> const& trState, KeySelector const& begin, KeySelector const& end, Key const& mapper, GetRangeLimits const& limits, Promise<std::pair<Key, Key>> const& conflictRange, Snapshot const& snapshot, Reverse const& reverse, UseTenant const& useTenant = UseTenant::True ) {
															#line 2797 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<RangeResultFamily>(new GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>(trState, begin, end, mapper, limits, conflictRange, snapshot, reverse, useTenant));
															#line 14120 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
}

#line 3110 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

template <class StreamReply>
struct TSSDuplicateStreamData {
	PromiseStream<StreamReply> stream;
	Promise<Void> tssComparisonDone;

	// empty constructor for optional?
	TSSDuplicateStreamData() {}

	TSSDuplicateStreamData(PromiseStream<StreamReply> stream) : stream(stream) {}

	bool done() { return tssComparisonDone.getFuture().isReady(); }

	void setDone() {
		if (tssComparisonDone.canBeSet()) {
			tssComparisonDone.send(Void());
		}
	}

	~TSSDuplicateStreamData() {}
};

// Error tracking here is weird, and latency doesn't really mean the same thing here as it does with normal tss
// comparisons, so this is pretty much just counting mismatches
															#line 14148 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
namespace {
// This generated class is to be used only via tssStreamComparison()
															#line 3134 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class Request, class TssStreamComparisonActor>
															#line 3134 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class TssStreamComparisonActorState {
															#line 14155 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
															#line 3134 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	TssStreamComparisonActorState(Request const& request,TSSDuplicateStreamData<REPLYSTREAM_TYPE(Request)> const& streamData,ReplyPromiseStream<REPLYSTREAM_TYPE(Request)> const& tssReplyStream,TSSEndpointData const& tssData) 
															#line 3134 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 3134 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : request(request),
															#line 3134 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   streamData(streamData),
															#line 3134 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   tssReplyStream(tssReplyStream),
															#line 3134 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   tssData(tssData),
															#line 3139 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   ssEndOfStream(false),
															#line 3140 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   tssEndOfStream(false),
															#line 3141 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   ssReply(Optional<REPLYSTREAM_TYPE(Request)>()),
															#line 3142 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   tssReply(Optional<REPLYSTREAM_TYPE(Request)>())
															#line 14176 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
	{
		fdb_probe_actor_create("tssStreamComparison", reinterpret_cast<unsigned long>(this));

	}
	~TssStreamComparisonActorState() 
	{
		fdb_probe_actor_destroy("tssStreamComparison", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3144 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			;
															#line 14191 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TssStreamComparisonActorState();
		static_cast<TssStreamComparisonActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 3146 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ssReply = Optional<REPLYSTREAM_TYPE(Request)>();
															#line 3147 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		tssReply = Optional<REPLYSTREAM_TYPE(Request)>();
															#line 3149 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		startTime = now();
															#line 14225 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		try {
															#line 3152 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			auto __when_expr_0 = streamData.stream.getFuture();
															#line 14229 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			static_assert(std::is_same<decltype(__when_expr_0), FutureStream<REPLYSTREAM_TYPE(Request)>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<REPLYSTREAM_TYPE(Request)>>::value, "invalid type");
															#line 3152 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<TssStreamComparisonActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 14233 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
			static_cast<TssStreamComparisonActor*>(this)->actor_wait_state = 1;
															#line 3152 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< TssStreamComparisonActor, 0, REPLYSTREAM_TYPE(Request) >*>(static_cast<TssStreamComparisonActor*>(this)));
															#line 14238 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 3169 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		sleepTime = std::max(startTime + FLOW_KNOBS->LOAD_BALANCE_TSS_TIMEOUT - now(), 0.0);
															#line 14253 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		try {
															#line 3173 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			auto __when_expr_1 = tssReplyStream.getFuture();
															#line 14257 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			static_assert(std::is_same<decltype(__when_expr_1), FutureStream<REPLYSTREAM_TYPE(Request)>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<REPLYSTREAM_TYPE(Request)>>::value, "invalid type");
															#line 3172 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<TssStreamComparisonActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 14261 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1when1(__when_expr_1.pop(), loopDepth); };
															#line 3176 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_2 = delay(sleepTime);
															#line 14265 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1cont1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont1when2(__when_expr_2.get(), loopDepth); };
			static_cast<TssStreamComparisonActor*>(this)->actor_wait_state = 2;
															#line 3173 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< TssStreamComparisonActor, 1, REPLYSTREAM_TYPE(Request) >*>(static_cast<TssStreamComparisonActor*>(this)));
															#line 3176 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TssStreamComparisonActor, 2, Void >*>(static_cast<TssStreamComparisonActor*>(this)));
															#line 14272 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 3155 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 14288 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 3156 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				streamData.setDone();
															#line 3157 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 14294 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 3159 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (e.code() == error_code_end_of_stream)
															#line 14298 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 3162 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				ssEndOfStream = true;
															#line 14302 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
			else
			{
															#line 3164 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				tssData.metrics->ssError(e.code());
															#line 14308 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 3166 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			CODE_PROBE(e.code() != error_code_end_of_stream, "SS got error in TSS stream comparison");
															#line 14312 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(REPLYSTREAM_TYPE(Request) const& _ssReply,int loopDepth) 
	{
															#line 3153 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ssReply = _ssReply;
															#line 14327 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(REPLYSTREAM_TYPE(Request) && _ssReply,int loopDepth) 
	{
															#line 3153 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ssReply = _ssReply;
															#line 14336 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(REPLYSTREAM_TYPE(Request) const& _ssReply,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_ssReply, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(REPLYSTREAM_TYPE(Request) && _ssReply,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_ssReply), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TssStreamComparisonActor*>(this)->actor_wait_state > 0) static_cast<TssStreamComparisonActor*>(this)->actor_wait_state = 0;
		static_cast<TssStreamComparisonActor*>(this)->ActorSingleCallback< TssStreamComparisonActor, 0, REPLYSTREAM_TYPE(Request) >::remove();

	}
	void a_callback_fire(ActorSingleCallback< TssStreamComparisonActor, 0, REPLYSTREAM_TYPE(Request) >*,REPLYSTREAM_TYPE(Request) const& value) 
	{
		fdb_probe_actor_enter("tssStreamComparison", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TssStreamComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssStreamComparison", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< TssStreamComparisonActor, 0, REPLYSTREAM_TYPE(Request) >*,REPLYSTREAM_TYPE(Request) && value) 
	{
		fdb_probe_actor_enter("tssStreamComparison", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TssStreamComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssStreamComparison", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< TssStreamComparisonActor, 0, REPLYSTREAM_TYPE(Request) >*,Error err) 
	{
		fdb_probe_actor_enter("tssStreamComparison", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TssStreamComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssStreamComparison", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
															#line 3196 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!ssEndOfStream || !tssEndOfStream)
															#line 14433 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 3197 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			++tssData.metrics->streamComparisons;
															#line 14437 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 3201 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (ssReply.present() && tssReply.present())
															#line 14441 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 3208 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if ((!ssEndOfStream || !tssEndOfStream) && !TSS_doCompare(ssReply.get(), tssReply.get()))
															#line 14445 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 3209 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				CODE_PROBE(true, "TSS mismatch in stream comparison");
															#line 3210 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				TraceEvent mismatchEvent( (g_network->isSimulated() && g_simulator->tssMode == ISimulator::TSSMode::EnabledDropMutations) ? SevWarnAlways : SevError, LB_mismatchTraceName(request, TSS_COMPARISON));
															#line 3215 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				mismatchEvent.setMaxEventLength(FLOW_KNOBS->TSS_LARGE_TRACE_SIZE);
															#line 3216 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				mismatchEvent.detail("TSSID", tssData.tssId);
															#line 3218 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (tssData.metrics->shouldRecordDetailedMismatch())
															#line 14457 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				{
															#line 3219 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					TSS_traceMismatch(mismatchEvent, request, ssReply.get(), tssReply.get(), TSS_COMPARISON);
															#line 3221 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					CODE_PROBE(FLOW_KNOBS->LOAD_BALANCE_TSS_MISMATCH_TRACE_FULL, "Tracing Full TSS Mismatch in stream comparison", probe::decoration::rare);
															#line 3224 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					CODE_PROBE(!FLOW_KNOBS->LOAD_BALANCE_TSS_MISMATCH_TRACE_FULL, "Tracing Partial TSS Mismatch in stream comparison and storing the rest in FDB");
															#line 3227 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					if (!FLOW_KNOBS->LOAD_BALANCE_TSS_MISMATCH_TRACE_FULL)
															#line 14467 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
					{
															#line 3228 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
						mismatchEvent.disable();
															#line 3229 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
						UID mismatchUID = deterministicRandom()->randomUniqueID();
															#line 3230 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
						tssData.metrics->recordDetailedMismatchData(mismatchUID, mismatchEvent.getFields().toString());
															#line 3233 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
						TraceEvent summaryEvent((g_network->isSimulated() && g_simulator->tssMode == ISimulator::TSSMode::EnabledDropMutations) ? SevWarnAlways : SevError, LB_mismatchTraceName(request, TSS_COMPARISON));
															#line 3238 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
						summaryEvent.detail("TSSID", tssData.tssId).detail("MismatchId", mismatchUID);
															#line 14479 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
					}
				}
				else
				{
															#line 3242 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					mismatchEvent.disable();
															#line 14486 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				}
															#line 3244 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				streamData.setDone();
															#line 3245 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (!static_cast<TssStreamComparisonActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TssStreamComparisonActorState(); static_cast<TssStreamComparisonActor*>(this)->destroy(); return 0; }
															#line 14492 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				new (&static_cast<TssStreamComparisonActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~TssStreamComparisonActorState();
				static_cast<TssStreamComparisonActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 3248 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!ssReply.present() || !tssReply.present() || ssEndOfStream || tssEndOfStream)
															#line 14501 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 3250 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			streamData.setDone();
															#line 3251 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!static_cast<TssStreamComparisonActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TssStreamComparisonActorState(); static_cast<TssStreamComparisonActor*>(this)->destroy(); return 0; }
															#line 14507 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			new (&static_cast<TssStreamComparisonActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~TssStreamComparisonActorState();
			static_cast<TssStreamComparisonActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 3182 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 14522 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 3183 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				streamData.setDone();
															#line 3184 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 14528 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 3186 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (e.code() == error_code_end_of_stream)
															#line 14532 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 3189 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				tssEndOfStream = true;
															#line 14536 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
			else
			{
															#line 3191 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				tssData.metrics->tssError(e.code());
															#line 14542 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 3193 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			CODE_PROBE(e.code() != error_code_end_of_stream, "TSS got error in TSS stream comparison");
															#line 14546 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = a_body1loopBody1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(REPLYSTREAM_TYPE(Request) const& _tssReply,int loopDepth) 
	{
															#line 3174 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		tssReply = _tssReply;
															#line 14567 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(REPLYSTREAM_TYPE(Request) && _tssReply,int loopDepth) 
	{
															#line 3174 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		tssReply = _tssReply;
															#line 14576 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when2(Void const& _,int loopDepth) 
	{
															#line 3177 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++tssData.metrics->tssTimeouts;
															#line 3178 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		CODE_PROBE(true, "Got TSS timeout in stream comparison", probe::decoration::rare);
															#line 14587 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when2(Void && _,int loopDepth) 
	{
															#line 3177 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++tssData.metrics->tssTimeouts;
															#line 3178 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		CODE_PROBE(true, "Got TSS timeout in stream comparison", probe::decoration::rare);
															#line 14598 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TssStreamComparisonActor*>(this)->actor_wait_state > 0) static_cast<TssStreamComparisonActor*>(this)->actor_wait_state = 0;
		static_cast<TssStreamComparisonActor*>(this)->ActorSingleCallback< TssStreamComparisonActor, 1, REPLYSTREAM_TYPE(Request) >::remove();
		static_cast<TssStreamComparisonActor*>(this)->ActorCallback< TssStreamComparisonActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorSingleCallback< TssStreamComparisonActor, 1, REPLYSTREAM_TYPE(Request) >*,REPLYSTREAM_TYPE(Request) const& value) 
	{
		fdb_probe_actor_enter("tssStreamComparison", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TssStreamComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssStreamComparison", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< TssStreamComparisonActor, 1, REPLYSTREAM_TYPE(Request) >*,REPLYSTREAM_TYPE(Request) && value) 
	{
		fdb_probe_actor_enter("tssStreamComparison", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TssStreamComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssStreamComparison", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< TssStreamComparisonActor, 1, REPLYSTREAM_TYPE(Request) >*,Error err) 
	{
		fdb_probe_actor_enter("tssStreamComparison", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TssStreamComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssStreamComparison", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TssStreamComparisonActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tssStreamComparison", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TssStreamComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssStreamComparison", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TssStreamComparisonActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tssStreamComparison", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TssStreamComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssStreamComparison", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TssStreamComparisonActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tssStreamComparison", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TssStreamComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssStreamComparison", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont7(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 3134 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Request request;
															#line 3134 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	TSSDuplicateStreamData<REPLYSTREAM_TYPE(Request)> streamData;
															#line 3134 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	ReplyPromiseStream<REPLYSTREAM_TYPE(Request)> tssReplyStream;
															#line 3134 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	TSSEndpointData tssData;
															#line 3139 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	bool ssEndOfStream;
															#line 3140 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	bool tssEndOfStream;
															#line 3141 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Optional<REPLYSTREAM_TYPE(Request)> ssReply;
															#line 3142 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Optional<REPLYSTREAM_TYPE(Request)> tssReply;
															#line 3149 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	double startTime;
															#line 3169 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	double sleepTime;
															#line 14757 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
};
// This generated class is to be used only via tssStreamComparison()
															#line 3134 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class Request>
															#line 3134 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class TssStreamComparisonActor final : public Actor<Void>, public ActorSingleCallback< TssStreamComparisonActor<Request>, 0, REPLYSTREAM_TYPE(Request) >, public ActorSingleCallback< TssStreamComparisonActor<Request>, 1, REPLYSTREAM_TYPE(Request) >, public ActorCallback< TssStreamComparisonActor<Request>, 2, Void >, public FastAllocated<TssStreamComparisonActor<Request>>, public TssStreamComparisonActorState<Request, TssStreamComparisonActor<Request>> {
															#line 14764 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
	using FastAllocated<TssStreamComparisonActor<Request>>::operator new;
	using FastAllocated<TssStreamComparisonActor<Request>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4895771619397899520UL, 5615291898672066560UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< TssStreamComparisonActor<Request>, 0, REPLYSTREAM_TYPE(Request) >;
friend struct ActorSingleCallback< TssStreamComparisonActor<Request>, 1, REPLYSTREAM_TYPE(Request) >;
friend struct ActorCallback< TssStreamComparisonActor<Request>, 2, Void >;
															#line 3134 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	TssStreamComparisonActor(Request const& request,TSSDuplicateStreamData<REPLYSTREAM_TYPE(Request)> const& streamData,ReplyPromiseStream<REPLYSTREAM_TYPE(Request)> const& tssReplyStream,TSSEndpointData const& tssData) 
															#line 14783 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		 : Actor<Void>(),
		   TssStreamComparisonActorState<Request, TssStreamComparisonActor<Request>>(request, streamData, tssReplyStream, tssData),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tssStreamComparison", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12049828901958652672UL, 1449468964280732928UL);
		ActorExecutionContextHelper __helper(static_cast<TssStreamComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tssStreamComparison");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tssStreamComparison", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< TssStreamComparisonActor<Request>, 0, REPLYSTREAM_TYPE(Request) >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorSingleCallback< TssStreamComparisonActor<Request>, 1, REPLYSTREAM_TYPE(Request) >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 3134 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class Request>
															#line 3134 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] static Future<Void> tssStreamComparison( Request const& request, TSSDuplicateStreamData<REPLYSTREAM_TYPE(Request)> const& streamData, ReplyPromiseStream<REPLYSTREAM_TYPE(Request)> const& tssReplyStream, TSSEndpointData const& tssData ) {
															#line 3134 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Void>(new TssStreamComparisonActor<Request>(request, streamData, tssReplyStream, tssData));
															#line 14819 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
}

#line 3255 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

// Currently only used for GetKeyValuesStream but could easily be plugged for other stream types
// User of the stream has to forward the SS's responses to the returned promise stream, if it is set
template <class Request, bool P>
Optional<TSSDuplicateStreamData<REPLYSTREAM_TYPE(Request)>>
maybeDuplicateTSSStreamFragment(Request& req, QueueModel* model, RequestStream<Request, P> const* ssStream) {
	if (model) {
		Optional<TSSEndpointData> tssData = model->getTssData(ssStream->getEndpoint().token.first());

		if (tssData.present()) {
			CODE_PROBE(true, "duplicating stream to TSS");
			resetReply(req);
			// FIXME: optimize to avoid creating new netNotifiedQueueWithAcknowledgements for each stream duplication
			RequestStream<Request> tssRequestStream(tssData.get().endpoint);
			ReplyPromiseStream<REPLYSTREAM_TYPE(Request)> tssReplyStream = tssRequestStream.getReplyStream(req);
			PromiseStream<REPLYSTREAM_TYPE(Request)> ssDuplicateReplyStream;
			TSSDuplicateStreamData<REPLYSTREAM_TYPE(Request)> streamData(ssDuplicateReplyStream);
			model->addActor.send(tssStreamComparison(req, streamData, tssReplyStream, tssData.get()));
			return Optional<TSSDuplicateStreamData<REPLYSTREAM_TYPE(Request)>>(streamData);
		}
	}
	return Optional<TSSDuplicateStreamData<REPLYSTREAM_TYPE(Request)>>();
}

// Streams all of the KV pairs in a target key range into a ParallelStream fragment
															#line 14848 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
namespace {
// This generated class is to be used only via getRangeStreamFragment()
															#line 3280 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class GetRangeStreamFragmentActor>
															#line 3280 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetRangeStreamFragmentActorState {
															#line 14855 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
															#line 3280 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetRangeStreamFragmentActorState(Reference<TransactionState> const& trState,ParallelStream<RangeResult>::Fragment* const& results,KeyRange const& keys,GetRangeLimits const& limits,Snapshot const& snapshot,Reverse const& reverse,SpanContext const& spanContext) 
															#line 3280 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 3280 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : trState(trState),
															#line 3280 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   results(results),
															#line 3280 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   keys(keys),
															#line 3280 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   limits(limits),
															#line 3280 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   snapshot(snapshot),
															#line 3280 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   reverse(reverse),
															#line 3280 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   spanContext(spanContext)
															#line 14874 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
	{
		fdb_probe_actor_create("getRangeStreamFragment", reinterpret_cast<unsigned long>(this));

	}
	~GetRangeStreamFragmentActorState() 
	{
		fdb_probe_actor_destroy("getRangeStreamFragment", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3287 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			;
															#line 14889 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetRangeStreamFragmentActorState();
		static_cast<GetRangeStreamFragmentActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 3288 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<std::vector<KeyRangeLocationInfo>> __when_expr_0 = getKeyRangeLocations(trState, keys, CLIENT_KNOBS->GET_RANGE_SHARD_LIMIT, reverse, &StorageServerInterface::getKeyValuesStream, UseTenant::True);
															#line 3288 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14921 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state = 1;
															#line 3288 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetRangeStreamFragmentActor, 0, std::vector<KeyRangeLocationInfo> >*>(static_cast<GetRangeStreamFragmentActor*>(this)));
															#line 14926 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 3295 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(locations.size());
															#line 3296 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		shard = 0;
															#line 3297 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		;
															#line 14939 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<KeyRangeLocationInfo> const& __locations,int loopDepth) 
	{
															#line 3288 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		locations = __locations;
															#line 14948 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<KeyRangeLocationInfo> && __locations,int loopDepth) 
	{
		locations = std::move(__locations);
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state > 0) static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeStreamFragmentActor*>(this)->ActorCallback< GetRangeStreamFragmentActor, 0, std::vector<KeyRangeLocationInfo> >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeStreamFragmentActor, 0, std::vector<KeyRangeLocationInfo> >*,std::vector<KeyRangeLocationInfo> const& value) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetRangeStreamFragmentActor, 0, std::vector<KeyRangeLocationInfo> >*,std::vector<KeyRangeLocationInfo> && value) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetRangeStreamFragmentActor, 0, std::vector<KeyRangeLocationInfo> >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1(int loopDepth) 
	{
															#line 3298 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		const KeyRange& range = locations[shard].range;
															#line 3300 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		tssDuplicateStream = Optional<TSSDuplicateStreamData<GetKeyValuesStreamReply>>();
															#line 3301 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req = GetKeyValuesStreamRequest();
															#line 3302 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.tenantInfo = trState->getTenantInfo();
															#line 3303 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.version = trState->readVersion();
															#line 3304 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.begin = firstGreaterOrEqual(range.begin);
															#line 3305 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.end = firstGreaterOrEqual(range.end);
															#line 3306 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.spanContext = spanContext;
															#line 3307 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.limit = reverse ? -CLIENT_KNOBS->REPLY_BYTE_LIMIT : CLIENT_KNOBS->REPLY_BYTE_LIMIT;
															#line 3308 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.limitBytes = std::numeric_limits<int>::max();
															#line 3309 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.options = trState->readOptions;
															#line 3311 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		trState->cx->getLatestCommitVersions(locations[shard].locations, trState, req.ssLatestCommitVersions);
															#line 3314 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.arena.dependsOn(range.arena());
															#line 3316 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(req.limitBytes > 0 && req.limit != 0 && req.limit < 0 == reverse);
															#line 3319 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.tags = trState->cx->sampleReadTags() ? trState->options.readTags : Optional<TagSet>();
															#line 15068 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		try {
															#line 3322 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (trState->readOptions.present() && trState->readOptions.get().debugID.present())
															#line 15072 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 3323 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				g_traceBatch.addEvent("TransactionDebug", trState->readOptions.get().debugID.get().first(), "NativeAPI.RangeStream.Before");
															#line 15076 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 3327 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			++trState->cx->transactionPhysicalReads;
															#line 3328 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			rep = GetKeyValuesStreamReply();
															#line 3330 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (locations[shard].locations->size() == 0)
															#line 15084 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 3331 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				StrictFuture<Void> __when_expr_1 = trState->cx->connectionFileChanged();
															#line 3331 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 15090 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
				static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state = 2;
															#line 3331 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetRangeStreamFragmentActor, 1, Void >*>(static_cast<GetRangeStreamFragmentActor*>(this)));
															#line 15095 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1cont1loopBody1cont2(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 3530 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (tssDuplicateStream.present() && !tssDuplicateStream.get().done())
															#line 15135 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 3531 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				tssDuplicateStream.get().stream.sendError(e);
															#line 15139 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 3533 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 15143 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 3534 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 2));
															#line 15147 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 3536 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (e.code() == error_code_wrong_shard_server || e.code() == error_code_all_alternatives_failed || e.code() == error_code_connection_failed || e.code() == error_code_request_maybe_delivered)
															#line 15151 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 3538 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				const KeyRangeRef& range = locations[shard].range;
															#line 3540 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (reverse)
															#line 15157 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				{
															#line 3541 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					keys = KeyRangeRef(keys.begin, range.end);
															#line 15161 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				}
				else
				{
															#line 3543 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					keys = KeyRangeRef(range.begin, keys.end);
															#line 15167 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				}
															#line 3545 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				trState->cx->invalidateCache(trState->tenant().mapRef(&Tenant::prefix), keys);
															#line 3547 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				StrictFuture<Void> __when_expr_6 = delay(CLIENT_KNOBS->WRONG_SHARD_SERVER_DELAY, trState->taskID);
															#line 3547 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 15175 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1Catch1when1(__when_expr_6.get(), loopDepth); };
				static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state = 6;
															#line 3547 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< GetRangeStreamFragmentActor, 6, Void >*>(static_cast<GetRangeStreamFragmentActor*>(this)));
															#line 15180 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 3550 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				results->sendError(e);
															#line 3551 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (!static_cast<GetRangeStreamFragmentActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetRangeStreamFragmentActorState(); static_cast<GetRangeStreamFragmentActor*>(this)->destroy(); return 0; }
															#line 15189 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				new (&static_cast<GetRangeStreamFragmentActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~GetRangeStreamFragmentActorState();
				static_cast<GetRangeStreamFragmentActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2(int loopDepth) 
	{
															#line 3336 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		useIdx = -1;
															#line 3338 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		;
															#line 15210 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 3332 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		results->sendError(transaction_too_old());
															#line 3333 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetRangeStreamFragmentActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetRangeStreamFragmentActorState(); static_cast<GetRangeStreamFragmentActor*>(this)->destroy(); return 0; }
															#line 15221 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<GetRangeStreamFragmentActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetRangeStreamFragmentActorState();
		static_cast<GetRangeStreamFragmentActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 3332 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		results->sendError(transaction_too_old());
															#line 3333 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetRangeStreamFragmentActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetRangeStreamFragmentActorState(); static_cast<GetRangeStreamFragmentActor*>(this)->destroy(); return 0; }
															#line 15235 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<GetRangeStreamFragmentActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetRangeStreamFragmentActorState();
		static_cast<GetRangeStreamFragmentActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state > 0) static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeStreamFragmentActor*>(this)->ActorCallback< GetRangeStreamFragmentActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeStreamFragmentActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetRangeStreamFragmentActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetRangeStreamFragmentActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont1loopBody1cont6(int loopDepth) 
	{
															#line 3377 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		replyStream = locations[shard] .locations->get(useIdx, &StorageServerInterface::getKeyValuesStream) .getReplyStream(req);
															#line 3382 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		tssDuplicateStream = maybeDuplicateTSSStreamFragment( req, trState->cx->enableLocalityLoadBalance ? &trState->cx->queueModel : nullptr, &locations[shard].locations->get(useIdx, &StorageServerInterface::getKeyValuesStream));
															#line 3387 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		breakAgain = false;
															#line 3388 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		;
															#line 15328 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopBody1cont6loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2loopBody1(int loopDepth) 
	{
															#line 3341 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		int count = 0;
															#line 3342 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		for(int i = 0;i < locations[shard].locations->size();i++) {
															#line 3343 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!IFailureMonitor::failureMonitor() .getState(locations[shard] .locations->get(i, &StorageServerInterface::getKeyValuesStream) .getEndpoint()) .failed)
															#line 15348 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 3348 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (deterministicRandom()->random01() <= 1.0 / ++count)
															#line 15352 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				{
															#line 3349 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					useIdx = i;
															#line 15356 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				}
			}
		}
															#line 3354 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (useIdx >= 0)
															#line 15362 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
			return a_body1loopBody1cont1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 3358 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		std::vector<Future<Void>> ok(locations[shard].locations->size());
															#line 3359 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		for(int i = 0;i < ok.size();i++) {
															#line 3360 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			ok[i] = IFailureMonitor::failureMonitor().onStateEqual( locations[shard] .locations->get(i, &StorageServerInterface::getKeyValuesStream) .getEndpoint(), FailureStatus(false));
															#line 15372 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 3368 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (now() - g_network->networkInfo.newestAlternativesFailure > 1 || deterministicRandom()->random01() < 0.01)
															#line 15376 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 3370 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			TraceEvent("AllAlternativesFailed") .detail("Alternatives", locations[shard].locations->description());
															#line 15380 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 3374 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_2 = allAlternativesFailedDelay(quorum(ok, 1));
															#line 3374 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15386 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1loopBody1cont2loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state = 3;
															#line 3374 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetRangeStreamFragmentActor, 2, Void >*>(static_cast<GetRangeStreamFragmentActor*>(this)));
															#line 15391 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1loopBody1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont2loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont2loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state > 0) static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeStreamFragmentActor*>(this)->ActorCallback< GetRangeStreamFragmentActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeStreamFragmentActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetRangeStreamFragmentActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetRangeStreamFragmentActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont1loopBody1cont7(int loopDepth) 
	{
															#line 3525 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (breakAgain)
															#line 15500 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
			return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont6loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1cont6loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont6loopBody1(int loopDepth) 
	{
															#line 3389 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_3 = results->onEmpty();
															#line 3389 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15521 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1loopBody1cont6loopBody1when1(__when_expr_3.get(), loopDepth); };
		static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state = 4;
															#line 3389 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetRangeStreamFragmentActor, 3, Void >*>(static_cast<GetRangeStreamFragmentActor*>(this)));
															#line 15526 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont6break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1loopBody1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont6loopBody1cont1(Void const& _,int loopDepth) 
	{
		try {
															#line 3392 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_4 = trState->cx->connectionFileChanged();
															#line 3391 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 15551 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont6loopBody1cont1when1(__when_expr_4.get(), loopDepth); };
															#line 3400 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			auto __when_expr_5 = replyStream.getFuture();
															#line 15555 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			static_assert(std::is_same<decltype(__when_expr_5), FutureStream<GetKeyValuesStreamReply>>::value || std::is_same<decltype(__when_expr_5), ThreadFutureStream<GetKeyValuesStreamReply>>::value, "invalid type");
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont6loopBody1cont1when2(__when_expr_5.pop(), loopDepth); };
			static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state = 5;
															#line 3392 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< GetRangeStreamFragmentActor, 4, Void >*>(static_cast<GetRangeStreamFragmentActor*>(this)));
															#line 3400 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorSingleCallback< GetRangeStreamFragmentActor, 5, GetKeyValuesStreamReply >*>(static_cast<GetRangeStreamFragmentActor*>(this)));
															#line 15563 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont6loopBody1cont1(Void && _,int loopDepth) 
	{
		try {
															#line 3392 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_4 = trState->cx->connectionFileChanged();
															#line 3391 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 15581 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont6loopBody1cont1when1(__when_expr_4.get(), loopDepth); };
															#line 3400 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			auto __when_expr_5 = replyStream.getFuture();
															#line 15585 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			static_assert(std::is_same<decltype(__when_expr_5), FutureStream<GetKeyValuesStreamReply>>::value || std::is_same<decltype(__when_expr_5), ThreadFutureStream<GetKeyValuesStreamReply>>::value, "invalid type");
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont6loopBody1cont1when2(__when_expr_5.pop(), loopDepth); };
			static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state = 5;
															#line 3392 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< GetRangeStreamFragmentActor, 4, Void >*>(static_cast<GetRangeStreamFragmentActor*>(this)));
															#line 3400 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorSingleCallback< GetRangeStreamFragmentActor, 5, GetKeyValuesStreamReply >*>(static_cast<GetRangeStreamFragmentActor*>(this)));
															#line 15593 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont6loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont6loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont6loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont6loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state > 0) static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeStreamFragmentActor*>(this)->ActorCallback< GetRangeStreamFragmentActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeStreamFragmentActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1loopBody1cont6loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetRangeStreamFragmentActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1loopBody1cont6loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetRangeStreamFragmentActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont1loopBody1cont6loopBody1cont2(int loopDepth) 
	{
															#line 3421 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (trState->readOptions.present() && trState->readOptions.get().debugID.present())
															#line 15683 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 3422 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			g_traceBatch.addEvent("TransactionDebug", trState->readOptions.get().debugID.get().first(), "NativeAPI.getExactRange.After");
															#line 15687 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 3425 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		RangeResult output(RangeResultRef(rep.data, rep.more), rep.arena);
															#line 3427 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (tssDuplicateStream.present() && !tssDuplicateStream.get().done())
															#line 15693 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 3429 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			GetKeyValuesStreamReply replyCopy;
															#line 3430 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			replyCopy.version = rep.version;
															#line 3431 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			replyCopy.more = rep.more;
															#line 3432 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			replyCopy.cached = rep.cached;
															#line 3433 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			replyCopy.arena.dependsOn(rep.arena);
															#line 3434 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			replyCopy.data.append(replyCopy.arena, rep.data.begin(), rep.data.size());
															#line 3435 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			tssDuplicateStream.get().stream.send(replyCopy);
															#line 15709 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 3438 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		int64_t bytes = 0;
															#line 3439 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		for( const KeyValueRef& kv : output ) {
															#line 3440 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			bytes += kv.key.size() + kv.value.size();
															#line 15717 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 3443 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		trState->cx->transactionBytesRead += bytes;
															#line 3444 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		trState->cx->transactionKeysRead += output.size();
															#line 3447 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (reverse && output.more && rep.data.size() > 0 && output[output.size() - 1].key == locations[shard].range.begin)
															#line 15725 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 3449 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			output.more = false;
															#line 15729 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 3452 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (output.more)
															#line 15733 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 3453 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!rep.data.size())
															#line 15737 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 3454 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				TraceEvent(SevError, "GetRangeStreamError") .detail("Reason", "More data indicated but no rows present") .detail("LimitBytes", limits.bytes) .detail("LimitRows", limits.rows) .detail("OutputSize", output.size()) .detail("OutputBytes", output.expectedSize()) .detail("BlockSize", rep.data.size()) .detail("BlockBytes", rep.data.expectedSize());
															#line 3462 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				ASSERT(false);
															#line 15743 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 3464 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			CODE_PROBE(true, "GetKeyValuesStreamReply.more in getRangeStream");
															#line 3466 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (reverse)
															#line 15749 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 3467 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				locations[shard].range = KeyRangeRef(locations[shard].range.begin, output[output.size() - 1].key);
															#line 15753 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
			else
			{
															#line 3470 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				locations[shard].range = KeyRangeRef(keyAfter(output[output.size() - 1].key), locations[shard].range.end);
															#line 15759 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
		}
															#line 3474 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (locations[shard].range.empty())
															#line 15764 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 3475 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			output.more = false;
															#line 15768 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 3478 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!output.more)
															#line 15772 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 3479 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			const KeyRange& range = locations[shard].range;
															#line 3480 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (shard == locations.size() - 1)
															#line 15778 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 3481 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				KeyRef begin = reverse ? keys.begin : range.end;
															#line 3482 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				KeyRef end = reverse ? range.begin : keys.end;
															#line 3484 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (begin >= end)
															#line 15786 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				{
															#line 3485 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					if (range.begin == allKeys.begin)
															#line 15790 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
					{
															#line 3486 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
						output.readToBegin = true;
															#line 15794 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
					}
															#line 3488 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					if (range.end == allKeys.end)
															#line 15798 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
					{
															#line 3489 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
						output.readThroughEnd = true;
															#line 15802 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
					}
															#line 3491 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					output.arena().dependsOn(keys.arena());
															#line 3494 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					output.more = true;
															#line 3495 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					output.setReadThrough(reverse ? keys.begin : keys.end);
															#line 3496 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					results->send(std::move(output));
															#line 3497 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					results->finish();
															#line 3498 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					if (tssDuplicateStream.present() && !tssDuplicateStream.get().done())
															#line 15816 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
					{
															#line 3499 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
						tssDuplicateStream.get().stream.sendError(end_of_stream());
															#line 15820 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
					}
															#line 3501 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					if (!static_cast<GetRangeStreamFragmentActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetRangeStreamFragmentActorState(); static_cast<GetRangeStreamFragmentActor*>(this)->destroy(); return 0; }
															#line 15824 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
					new (&static_cast<GetRangeStreamFragmentActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~GetRangeStreamFragmentActorState();
					static_cast<GetRangeStreamFragmentActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 3503 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				keys = KeyRangeRef(begin, end);
															#line 3504 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				breakAgain = true;
															#line 15834 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
			else
			{
															#line 3506 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				++shard;
															#line 15840 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 3508 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			output.arena().dependsOn(range.arena());
															#line 3510 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			output.more = true;
															#line 3511 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			output.setReadThrough(reverse ? range.begin : range.end);
															#line 3512 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			results->send(std::move(output));
															#line 15850 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			return a_body1loopBody1cont1loopBody1cont6break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 3516 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(output.size());
															#line 3517 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (keys.begin == allKeys.begin && !reverse)
															#line 15857 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 3518 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			output.readToBegin = true;
															#line 15861 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 3520 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (keys.end == allKeys.end && reverse)
															#line 15865 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 3521 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			output.readThroughEnd = true;
															#line 15869 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 3523 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		results->send(std::move(output));
															#line 15873 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont1loopBody1cont6loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 3406 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			++trState->cx->transactionPhysicalReadsCompleted;
															#line 3407 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (e.code() == error_code_broken_promise)
															#line 15885 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 3408 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (tssDuplicateStream.present() && !tssDuplicateStream.get().done())
															#line 15889 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				{
															#line 3409 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					tssDuplicateStream.get().stream.sendError(connection_failed());
															#line 15893 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				}
															#line 3411 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				return a_body1loopBody1cont1loopBody1Catch1(connection_failed(), std::max(0, loopDepth - 1));
															#line 15897 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 3413 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (e.code() != error_code_end_of_stream)
															#line 15901 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 3414 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (tssDuplicateStream.present() && !tssDuplicateStream.get().done())
															#line 15905 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				{
															#line 3415 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					tssDuplicateStream.get().stream.sendError(e);
															#line 15909 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				}
															#line 3417 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				return a_body1loopBody1cont1loopBody1Catch1(e, std::max(0, loopDepth - 1));
															#line 15913 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 3419 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			rep = GetKeyValuesStreamReply();
															#line 15917 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = a_body1loopBody1cont1loopBody1cont6loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont6loopBody1cont3(int loopDepth) 
	{
															#line 3404 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++trState->cx->transactionPhysicalReadsCompleted;
															#line 15932 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopBody1cont6loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont6loopBody1cont1when1(Void const& _,int loopDepth) 
	{
															#line 3393 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		results->sendError(transaction_too_old());
															#line 3394 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (tssDuplicateStream.present() && !tssDuplicateStream.get().done())
															#line 15943 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 3395 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			tssDuplicateStream.get().stream.sendError(transaction_too_old());
															#line 15947 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 3397 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetRangeStreamFragmentActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetRangeStreamFragmentActorState(); static_cast<GetRangeStreamFragmentActor*>(this)->destroy(); return 0; }
															#line 15951 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<GetRangeStreamFragmentActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetRangeStreamFragmentActorState();
		static_cast<GetRangeStreamFragmentActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont6loopBody1cont1when1(Void && _,int loopDepth) 
	{
															#line 3393 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		results->sendError(transaction_too_old());
															#line 3394 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (tssDuplicateStream.present() && !tssDuplicateStream.get().done())
															#line 15965 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 3395 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			tssDuplicateStream.get().stream.sendError(transaction_too_old());
															#line 15969 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 3397 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetRangeStreamFragmentActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetRangeStreamFragmentActorState(); static_cast<GetRangeStreamFragmentActor*>(this)->destroy(); return 0; }
															#line 15973 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<GetRangeStreamFragmentActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetRangeStreamFragmentActorState();
		static_cast<GetRangeStreamFragmentActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont6loopBody1cont1when2(GetKeyValuesStreamReply const& _rep,int loopDepth) 
	{
															#line 3401 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		rep = _rep;
															#line 15985 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopBody1cont6loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont6loopBody1cont1when2(GetKeyValuesStreamReply && _rep,int loopDepth) 
	{
															#line 3401 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		rep = _rep;
															#line 15994 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopBody1cont6loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state > 0) static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeStreamFragmentActor*>(this)->ActorCallback< GetRangeStreamFragmentActor, 4, Void >::remove();
		static_cast<GetRangeStreamFragmentActor*>(this)->ActorSingleCallback< GetRangeStreamFragmentActor, 5, GetKeyValuesStreamReply >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeStreamFragmentActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont1loopBody1cont6loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< GetRangeStreamFragmentActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont1loopBody1cont6loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< GetRangeStreamFragmentActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorSingleCallback< GetRangeStreamFragmentActor, 5, GetKeyValuesStreamReply >*,GetKeyValuesStreamReply const& value) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont1loopBody1cont6loopBody1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorSingleCallback< GetRangeStreamFragmentActor, 5, GetKeyValuesStreamReply >*,GetKeyValuesStreamReply && value) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont1loopBody1cont6loopBody1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorSingleCallback< GetRangeStreamFragmentActor, 5, GetKeyValuesStreamReply >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1cont1loopBody1cont6loopBody1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1loopBody1cont6loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1cont4(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1cont4(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state > 0) static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeStreamFragmentActor*>(this)->ActorCallback< GetRangeStreamFragmentActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeStreamFragmentActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< GetRangeStreamFragmentActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< GetRangeStreamFragmentActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 3280 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reference<TransactionState> trState;
															#line 3280 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	ParallelStream<RangeResult>::Fragment* results;
															#line 3280 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeyRange keys;
															#line 3280 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetRangeLimits limits;
															#line 3280 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Snapshot snapshot;
															#line 3280 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reverse reverse;
															#line 3280 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	SpanContext spanContext;
															#line 3288 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	std::vector<KeyRangeLocationInfo> locations;
															#line 3296 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	int shard;
															#line 3300 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Optional<TSSDuplicateStreamData<GetKeyValuesStreamReply>> tssDuplicateStream;
															#line 3301 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetKeyValuesStreamRequest req;
															#line 3328 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetKeyValuesStreamReply rep;
															#line 3336 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	int useIdx;
															#line 3377 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	ReplyPromiseStream<GetKeyValuesStreamReply> replyStream;
															#line 3387 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	bool breakAgain;
															#line 16263 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
};
// This generated class is to be used only via getRangeStreamFragment()
															#line 3280 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetRangeStreamFragmentActor final : public Actor<Void>, public ActorCallback< GetRangeStreamFragmentActor, 0, std::vector<KeyRangeLocationInfo> >, public ActorCallback< GetRangeStreamFragmentActor, 1, Void >, public ActorCallback< GetRangeStreamFragmentActor, 2, Void >, public ActorCallback< GetRangeStreamFragmentActor, 3, Void >, public ActorCallback< GetRangeStreamFragmentActor, 4, Void >, public ActorSingleCallback< GetRangeStreamFragmentActor, 5, GetKeyValuesStreamReply >, public ActorCallback< GetRangeStreamFragmentActor, 6, Void >, public FastAllocated<GetRangeStreamFragmentActor>, public GetRangeStreamFragmentActorState<GetRangeStreamFragmentActor> {
															#line 16268 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
	using FastAllocated<GetRangeStreamFragmentActor>::operator new;
	using FastAllocated<GetRangeStreamFragmentActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7031077937131057920UL, 7360376905691285504UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetRangeStreamFragmentActor, 0, std::vector<KeyRangeLocationInfo> >;
friend struct ActorCallback< GetRangeStreamFragmentActor, 1, Void >;
friend struct ActorCallback< GetRangeStreamFragmentActor, 2, Void >;
friend struct ActorCallback< GetRangeStreamFragmentActor, 3, Void >;
friend struct ActorCallback< GetRangeStreamFragmentActor, 4, Void >;
friend struct ActorSingleCallback< GetRangeStreamFragmentActor, 5, GetKeyValuesStreamReply >;
friend struct ActorCallback< GetRangeStreamFragmentActor, 6, Void >;
															#line 3280 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetRangeStreamFragmentActor(Reference<TransactionState> const& trState,ParallelStream<RangeResult>::Fragment* const& results,KeyRange const& keys,GetRangeLimits const& limits,Snapshot const& snapshot,Reverse const& reverse,SpanContext const& spanContext) 
															#line 16291 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		 : Actor<Void>(),
		   GetRangeStreamFragmentActorState<GetRangeStreamFragmentActor>(trState, results, keys, limits, snapshot, reverse, spanContext),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5899419315066500352UL, 5523941769855860224UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getRangeStreamFragment");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetRangeStreamFragmentActor, 0, std::vector<KeyRangeLocationInfo> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetRangeStreamFragmentActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetRangeStreamFragmentActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< GetRangeStreamFragmentActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< GetRangeStreamFragmentActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< GetRangeStreamFragmentActor, 6, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 3280 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<Void> getRangeStreamFragment( Reference<TransactionState> const& trState, ParallelStream<RangeResult>::Fragment* const& results, KeyRange const& keys, GetRangeLimits const& limits, Snapshot const& snapshot, Reverse const& reverse, SpanContext const& spanContext ) {
															#line 3280 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Void>(new GetRangeStreamFragmentActor(trState, results, keys, limits, snapshot, reverse, spanContext));
															#line 16329 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
}

#line 3557 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

															#line 16334 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
[[nodiscard]] Future<Standalone<VectorRef<KeyRef>>> getRangeSplitPoints( Reference<TransactionState> const& trState, KeyRange const& keys, int64_t const& chunkSize );

#line 3561 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

static KeyRange intersect(KeyRangeRef lhs, KeyRangeRef rhs) {
	return KeyRange(KeyRangeRef(std::max(lhs.begin, rhs.begin), std::min(lhs.end, rhs.end)));
}

// Divides the requested key range into 1MB fragments, create range streams for each fragment, and merges the results so
// the client get them in order
															#line 16345 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
namespace {
// This generated class is to be used only via getRangeStream()
															#line 3568 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class GetRangeStreamActor>
															#line 3568 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetRangeStreamActorState {
															#line 16352 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
															#line 3568 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetRangeStreamActorState(Reference<TransactionState> const& trState,PromiseStream<RangeResult> const& _results,KeySelector const& begin,KeySelector const& end,GetRangeLimits const& limits,Promise<std::pair<Key, Key>> const& conflictRange,Snapshot const& snapshot,Reverse const& reverse) 
															#line 3568 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 3568 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : trState(trState),
															#line 3568 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   _results(_results),
															#line 3568 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   begin(begin),
															#line 3568 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   end(end),
															#line 3568 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   limits(limits),
															#line 3568 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   conflictRange(conflictRange),
															#line 3568 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   snapshot(snapshot),
															#line 3568 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   reverse(reverse),
															#line 3576 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   results(_results, CLIENT_KNOBS->RANGESTREAM_BUFFERED_FRAGMENTS_LIMIT)
															#line 16375 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
	{
		fdb_probe_actor_create("getRangeStream", reinterpret_cast<unsigned long>(this));

	}
	~GetRangeStreamActorState() 
	{
		fdb_probe_actor_destroy("getRangeStream", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3579 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			ASSERT(!limits.hasRowLimit());
															#line 3580 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			span = Span("NAPI:getRangeStream"_loc, trState->spanContext);
															#line 3582 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_0 = trState->startTransaction();
															#line 3582 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<GetRangeStreamActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16396 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetRangeStreamActor*>(this)->actor_wait_state = 1;
															#line 3582 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetRangeStreamActor, 0, Void >*>(static_cast<GetRangeStreamActor*>(this)));
															#line 16401 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetRangeStreamActorState();
		static_cast<GetRangeStreamActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 3584 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		CODE_PROBE(trState->hasTenant(), "NativeAPI getRangeStream has tenant");
															#line 3585 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		trState->cx->validateVersion(trState->readVersion());
															#line 3587 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		Future<Key> fb = resolveKey(trState, begin, UseTenant::True);
															#line 3588 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		fe = resolveKey(trState, end, UseTenant::True);
															#line 3590 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Key> __when_expr_1 = fb;
															#line 3590 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetRangeStreamActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16434 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetRangeStreamActor*>(this)->actor_wait_state = 2;
															#line 3590 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetRangeStreamActor, 1, Key >*>(static_cast<GetRangeStreamActor*>(this)));
															#line 16439 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 3584 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		CODE_PROBE(trState->hasTenant(), "NativeAPI getRangeStream has tenant");
															#line 3585 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		trState->cx->validateVersion(trState->readVersion());
															#line 3587 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		Future<Key> fb = resolveKey(trState, begin, UseTenant::True);
															#line 3588 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		fe = resolveKey(trState, end, UseTenant::True);
															#line 3590 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Key> __when_expr_1 = fb;
															#line 3590 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetRangeStreamActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16458 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetRangeStreamActor*>(this)->actor_wait_state = 2;
															#line 3590 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetRangeStreamActor, 1, Key >*>(static_cast<GetRangeStreamActor*>(this)));
															#line 16463 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetRangeStreamActor*>(this)->actor_wait_state > 0) static_cast<GetRangeStreamActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeStreamActor*>(this)->ActorCallback< GetRangeStreamActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeStreamActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetRangeStreamActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetRangeStreamActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 3591 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Key> __when_expr_2 = fe;
															#line 3591 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetRangeStreamActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16549 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<GetRangeStreamActor*>(this)->actor_wait_state = 3;
															#line 3591 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetRangeStreamActor, 2, Key >*>(static_cast<GetRangeStreamActor*>(this)));
															#line 16554 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Key const& __b,int loopDepth) 
	{
															#line 3590 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		b = __b;
															#line 16563 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Key && __b,int loopDepth) 
	{
		b = std::move(__b);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetRangeStreamActor*>(this)->actor_wait_state > 0) static_cast<GetRangeStreamActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeStreamActor*>(this)->ActorCallback< GetRangeStreamActor, 1, Key >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeStreamActor, 1, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetRangeStreamActor, 1, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetRangeStreamActor, 1, Key >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 3593 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!snapshot)
															#line 16642 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 3595 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			conflictRange.send(std::make_pair(std::min(b, Key(begin.getKey(), begin.arena())), std::max(e, Key(end.getKey(), end.arena()))));
															#line 16646 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 3599 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (b >= e)
															#line 16650 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 3600 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_3 = results.finish();
															#line 3600 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<GetRangeStreamActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16656 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
			static_cast<GetRangeStreamActor*>(this)->actor_wait_state = 4;
															#line 3600 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetRangeStreamActor, 3, Void >*>(static_cast<GetRangeStreamActor*>(this)));
															#line 16661 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2when1(Key const& __e,int loopDepth) 
	{
															#line 3591 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		e = __e;
															#line 16675 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Key && __e,int loopDepth) 
	{
		e = std::move(__e);
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetRangeStreamActor*>(this)->actor_wait_state > 0) static_cast<GetRangeStreamActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeStreamActor*>(this)->ActorCallback< GetRangeStreamActor, 2, Key >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeStreamActor, 2, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetRangeStreamActor, 2, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetRangeStreamActor, 2, Key >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 3608 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		outstandingRequests = std::vector<Future<Void>>();
															#line 3609 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		;
															#line 16756 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1cont4loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 3601 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetRangeStreamActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetRangeStreamActorState(); static_cast<GetRangeStreamActor*>(this)->destroy(); return 0; }
															#line 16765 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<GetRangeStreamActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetRangeStreamActorState();
		static_cast<GetRangeStreamActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 3601 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetRangeStreamActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetRangeStreamActorState(); static_cast<GetRangeStreamActor*>(this)->destroy(); return 0; }
															#line 16777 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<GetRangeStreamActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetRangeStreamActorState();
		static_cast<GetRangeStreamActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<GetRangeStreamActor*>(this)->actor_wait_state > 0) static_cast<GetRangeStreamActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeStreamActor*>(this)->ActorCallback< GetRangeStreamActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeStreamActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetRangeStreamActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetRangeStreamActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont8(int loopDepth) 
	{
															#line 3645 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_7 = waitForAll(outstandingRequests) && results.finish();
															#line 3645 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetRangeStreamActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16866 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont8when1(__when_expr_7.get(), loopDepth); };
		static_cast<GetRangeStreamActor*>(this)->actor_wait_state = 8;
															#line 3645 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< GetRangeStreamActor, 7, Void >*>(static_cast<GetRangeStreamActor*>(this)));
															#line 16871 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont4loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1(int loopDepth) 
	{
															#line 3609 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!(b < e))
															#line 16887 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
			return a_body1cont4break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 3610 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<KeyRangeLocationInfo> __when_expr_4 = getKeyLocation( trState, reverse ? e : b, &StorageServerInterface::getKeyValuesStream, reverse, UseTenant::True);
															#line 3610 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetRangeStreamActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16895 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont4loopBody1when1(__when_expr_4.get(), loopDepth); };
		static_cast<GetRangeStreamActor*>(this)->actor_wait_state = 5;
															#line 3610 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< GetRangeStreamActor, 4, KeyRangeLocationInfo >*>(static_cast<GetRangeStreamActor*>(this)));
															#line 16900 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4break1(int loopDepth) 
	{
		try {
			return a_body1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1(int loopDepth) 
	{
															#line 3612 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		shardIntersection = intersect(locationInfo.range, KeyRangeRef(b, e));
															#line 3613 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Standalone<VectorRef<KeyRef>>> __when_expr_5 = getRangeSplitPoints(trState, shardIntersection, CLIENT_KNOBS->RANGESTREAM_FRAGMENT_SIZE);
															#line 3613 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetRangeStreamActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16926 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont4loopBody1cont1when1(__when_expr_5.get(), loopDepth); };
		static_cast<GetRangeStreamActor*>(this)->actor_wait_state = 6;
															#line 3613 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< GetRangeStreamActor, 5, Standalone<VectorRef<KeyRef>> >*>(static_cast<GetRangeStreamActor*>(this)));
															#line 16931 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4loopBody1when1(KeyRangeLocationInfo const& __locationInfo,int loopDepth) 
	{
															#line 3610 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		locationInfo = __locationInfo;
															#line 16940 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1cont4loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1when1(KeyRangeLocationInfo && __locationInfo,int loopDepth) 
	{
		locationInfo = std::move(__locationInfo);
		loopDepth = a_body1cont4loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<GetRangeStreamActor*>(this)->actor_wait_state > 0) static_cast<GetRangeStreamActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeStreamActor*>(this)->ActorCallback< GetRangeStreamActor, 4, KeyRangeLocationInfo >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeStreamActor, 4, KeyRangeLocationInfo >*,KeyRangeLocationInfo const& value) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< GetRangeStreamActor, 4, KeyRangeLocationInfo >*,KeyRangeLocationInfo && value) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< GetRangeStreamActor, 4, KeyRangeLocationInfo >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont4loopBody1cont3(int loopDepth) 
	{
															#line 3615 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		toSend = std::vector<KeyRange>();
															#line 3618 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!splitPoints.empty())
															#line 17021 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 3619 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			toSend.push_back(KeyRange(KeyRangeRef(shardIntersection.begin, splitPoints.front()), splitPoints.arena()));
															#line 3620 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			for(int i = 0;i < splitPoints.size() - 1;++i) {
															#line 3621 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				toSend.push_back(KeyRange(KeyRangeRef(splitPoints[i], splitPoints[i + 1]), splitPoints.arena()));
															#line 17029 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 3623 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			toSend.push_back(KeyRange(KeyRangeRef(splitPoints.back(), shardIntersection.end), splitPoints.arena()));
															#line 17033 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
		else
		{
															#line 3625 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			toSend.push_back(KeyRange(KeyRangeRef(shardIntersection.begin, shardIntersection.end)));
															#line 17039 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 3628 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		idx = 0;
															#line 3629 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		useIdx = 0;
															#line 3630 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		;
															#line 17047 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1cont4loopBody1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1when1(Standalone<VectorRef<KeyRef>> const& __splitPoints,int loopDepth) 
	{
															#line 3613 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		splitPoints = __splitPoints;
															#line 17056 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1cont4loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1when1(Standalone<VectorRef<KeyRef>> && __splitPoints,int loopDepth) 
	{
		splitPoints = std::move(__splitPoints);
		loopDepth = a_body1cont4loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<GetRangeStreamActor*>(this)->actor_wait_state > 0) static_cast<GetRangeStreamActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeStreamActor*>(this)->ActorCallback< GetRangeStreamActor, 5, Standalone<VectorRef<KeyRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeStreamActor, 5, Standalone<VectorRef<KeyRef>> >*,Standalone<VectorRef<KeyRef>> const& value) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont4loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< GetRangeStreamActor, 5, Standalone<VectorRef<KeyRef>> >*,Standalone<VectorRef<KeyRef>> && value) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont4loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< GetRangeStreamActor, 5, Standalone<VectorRef<KeyRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont4loopBody1cont4(int loopDepth) 
	{
															#line 3639 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (reverse)
															#line 17135 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 3640 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			e = shardIntersection.begin;
															#line 17139 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
		else
		{
															#line 3642 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			b = shardIntersection.end;
															#line 17145 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont4loopBody1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont3loopBody1(int loopDepth) 
	{
															#line 3630 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!(idx < toSend.size()))
															#line 17162 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
			return a_body1cont4loopBody1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 3631 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		useIdx = reverse ? toSend.size() - idx - 1 : idx;
															#line 3632 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (toSend[useIdx].empty())
															#line 17170 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
			return a_body1cont4loopBody1cont3continue1(loopDepth); // continue
		}
															#line 3635 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<ParallelStream<RangeResult>::Fragment*> __when_expr_6 = results.createFragment();
															#line 3635 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetRangeStreamActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 17178 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 2)); else return a_body1cont4loopBody1cont3loopBody1when1(__when_expr_6.get(), loopDepth); };
		static_cast<GetRangeStreamActor*>(this)->actor_wait_state = 7;
															#line 3635 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< GetRangeStreamActor, 6, ParallelStream<RangeResult>::Fragment* >*>(static_cast<GetRangeStreamActor*>(this)));
															#line 17183 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4loopBody1cont3break1(int loopDepth) 
	{
		try {
			return a_body1cont4loopBody1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont4loopBody1cont3continue1(int loopDepth) 
	{
															#line 3630 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++idx;
															#line 17205 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont4loopBody1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont3loopBody1cont1(ParallelStream<RangeResult>::Fragment* const& fragment,int loopDepth) 
	{
															#line 3636 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		outstandingRequests.push_back( getRangeStreamFragment(trState, fragment, toSend[useIdx], limits, snapshot, reverse, span.context));
															#line 3630 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++idx;
															#line 17216 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont4loopBody1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont3loopBody1cont1(ParallelStream<RangeResult>::Fragment* && fragment,int loopDepth) 
	{
															#line 3636 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		outstandingRequests.push_back( getRangeStreamFragment(trState, fragment, toSend[useIdx], limits, snapshot, reverse, span.context));
															#line 3630 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++idx;
															#line 17227 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont4loopBody1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont3loopBody1when1(ParallelStream<RangeResult>::Fragment* const& fragment,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont3loopBody1cont1(fragment, loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont3loopBody1when1(ParallelStream<RangeResult>::Fragment* && fragment,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont3loopBody1cont1(std::move(fragment), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<GetRangeStreamActor*>(this)->actor_wait_state > 0) static_cast<GetRangeStreamActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeStreamActor*>(this)->ActorCallback< GetRangeStreamActor, 6, ParallelStream<RangeResult>::Fragment* >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeStreamActor, 6, ParallelStream<RangeResult>::Fragment* >*,ParallelStream<RangeResult>::Fragment* const& value) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont4loopBody1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< GetRangeStreamActor, 6, ParallelStream<RangeResult>::Fragment* >*,ParallelStream<RangeResult>::Fragment* && value) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont4loopBody1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< GetRangeStreamActor, 6, ParallelStream<RangeResult>::Fragment* >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont9(Void const& _,int loopDepth) 
	{
															#line 3646 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetRangeStreamActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetRangeStreamActorState(); static_cast<GetRangeStreamActor*>(this)->destroy(); return 0; }
															#line 17311 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<GetRangeStreamActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetRangeStreamActorState();
		static_cast<GetRangeStreamActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont9(Void && _,int loopDepth) 
	{
															#line 3646 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetRangeStreamActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetRangeStreamActorState(); static_cast<GetRangeStreamActor*>(this)->destroy(); return 0; }
															#line 17323 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<GetRangeStreamActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetRangeStreamActorState();
		static_cast<GetRangeStreamActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<GetRangeStreamActor*>(this)->actor_wait_state > 0) static_cast<GetRangeStreamActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeStreamActor*>(this)->ActorCallback< GetRangeStreamActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeStreamActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< GetRangeStreamActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< GetRangeStreamActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 7);

	}
															#line 3568 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reference<TransactionState> trState;
															#line 3568 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	PromiseStream<RangeResult> _results;
															#line 3568 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeySelector begin;
															#line 3568 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeySelector end;
															#line 3568 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetRangeLimits limits;
															#line 3568 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Promise<std::pair<Key, Key>> conflictRange;
															#line 3568 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Snapshot snapshot;
															#line 3568 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reverse reverse;
															#line 3576 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	ParallelStream<RangeResult> results;
															#line 3580 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Span span;
															#line 3588 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Future<Key> fe;
															#line 3590 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Key b;
															#line 3591 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Key e;
															#line 3608 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	std::vector<Future<Void>> outstandingRequests;
															#line 3610 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeyRangeLocationInfo locationInfo;
															#line 3612 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeyRange shardIntersection;
															#line 3613 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Standalone<VectorRef<KeyRef>> splitPoints;
															#line 3615 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	std::vector<KeyRange> toSend;
															#line 3628 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	int idx;
															#line 3629 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	int useIdx;
															#line 17446 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
};
// This generated class is to be used only via getRangeStream()
															#line 3568 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetRangeStreamActor final : public Actor<Void>, public ActorCallback< GetRangeStreamActor, 0, Void >, public ActorCallback< GetRangeStreamActor, 1, Key >, public ActorCallback< GetRangeStreamActor, 2, Key >, public ActorCallback< GetRangeStreamActor, 3, Void >, public ActorCallback< GetRangeStreamActor, 4, KeyRangeLocationInfo >, public ActorCallback< GetRangeStreamActor, 5, Standalone<VectorRef<KeyRef>> >, public ActorCallback< GetRangeStreamActor, 6, ParallelStream<RangeResult>::Fragment* >, public ActorCallback< GetRangeStreamActor, 7, Void >, public FastAllocated<GetRangeStreamActor>, public GetRangeStreamActorState<GetRangeStreamActor> {
															#line 17451 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
	using FastAllocated<GetRangeStreamActor>::operator new;
	using FastAllocated<GetRangeStreamActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3864260491478365440UL, 17726034844778018048UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetRangeStreamActor, 0, Void >;
friend struct ActorCallback< GetRangeStreamActor, 1, Key >;
friend struct ActorCallback< GetRangeStreamActor, 2, Key >;
friend struct ActorCallback< GetRangeStreamActor, 3, Void >;
friend struct ActorCallback< GetRangeStreamActor, 4, KeyRangeLocationInfo >;
friend struct ActorCallback< GetRangeStreamActor, 5, Standalone<VectorRef<KeyRef>> >;
friend struct ActorCallback< GetRangeStreamActor, 6, ParallelStream<RangeResult>::Fragment* >;
friend struct ActorCallback< GetRangeStreamActor, 7, Void >;
															#line 3568 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetRangeStreamActor(Reference<TransactionState> const& trState,PromiseStream<RangeResult> const& _results,KeySelector const& begin,KeySelector const& end,GetRangeLimits const& limits,Promise<std::pair<Key, Key>> const& conflictRange,Snapshot const& snapshot,Reverse const& reverse) 
															#line 17475 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		 : Actor<Void>(),
		   GetRangeStreamActorState<GetRangeStreamActor>(trState, _results, begin, end, limits, conflictRange, snapshot, reverse),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10544369634926336512UL, 15814804397175604224UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getRangeStream");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetRangeStreamActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetRangeStreamActor, 1, Key >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetRangeStreamActor, 2, Key >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< GetRangeStreamActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< GetRangeStreamActor, 4, KeyRangeLocationInfo >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< GetRangeStreamActor, 5, Standalone<VectorRef<KeyRef>> >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< GetRangeStreamActor, 6, ParallelStream<RangeResult>::Fragment* >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< GetRangeStreamActor, 7, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 3568 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<Void> getRangeStream( Reference<TransactionState> const& trState, PromiseStream<RangeResult> const& _results, KeySelector const& begin, KeySelector const& end, GetRangeLimits const& limits, Promise<std::pair<Key, Key>> const& conflictRange, Snapshot const& snapshot, Reverse const& reverse ) {
															#line 3568 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Void>(new GetRangeStreamActor(trState, _results, begin, end, limits, conflictRange, snapshot, reverse));
															#line 17515 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
}

#line 3648 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

Future<RangeResult> getRange(Reference<TransactionState> const& trState,
                             KeySelector const& begin,
                             KeySelector const& end,
                             GetRangeLimits const& limits,
                             Reverse const& reverse,
                             UseTenant const& useTenant) {
	return getRange<GetKeyValuesRequest, GetKeyValuesReply, RangeResult>(
	    trState, begin, end, ""_sr, limits, Promise<std::pair<Key, Key>>(), Snapshot::True, reverse, useTenant);
}

bool DatabaseContext::debugUseTags = false;
const std::vector<std::string> DatabaseContext::debugTransactionTagChoices = { "a", "b", "c", "d", "e", "f", "g",
	                                                                           "h", "i", "j", "k", "l", "m", "n",
	                                                                           "o", "p", "q", "r", "s", "t" };

void debugAddTags(Reference<TransactionState> trState) {
	int numTags = deterministicRandom()->randomInt(0, CLIENT_KNOBS->MAX_TAGS_PER_TRANSACTION + 1);
	for (int i = 0; i < numTags; ++i) {
		TransactionTag tag;
		if (deterministicRandom()->random01() < 0.7) {
			tag = TransactionTagRef(deterministicRandom()->randomChoice(DatabaseContext::debugTransactionTagChoices));
		} else {
			int length = deterministicRandom()->randomInt(1, CLIENT_KNOBS->MAX_TRANSACTION_TAG_LENGTH + 1);
			uint8_t* s = new (tag.arena()) uint8_t[length];
			for (int j = 0; j < length; ++j) {
				s[j] = (uint8_t)deterministicRandom()->randomInt(0, 256);
			}

			tag.contents() = TransactionTagRef(s, length);
		}

		if (deterministicRandom()->coinflip()) {
			trState->options.readTags.addTag(tag);
		}
		trState->options.tags.addTag(tag);
	}
}

Transaction::Transaction()
  : trState(makeReference<TransactionState>(TaskPriority::DefaultEndpoint, generateSpanID(false))) {}

Transaction::Transaction(Database const& cx, Optional<Reference<Tenant>> const& tenant)
  : trState(makeReference<TransactionState>(cx,
                                            tenant,
                                            cx->taskID,
                                            generateSpanID(cx->transactionTracingSample),
                                            createTrLogInfoProbabilistically(cx))),
    span(trState->spanContext, "Transaction"_loc), backoff(CLIENT_KNOBS->DEFAULT_BACKOFF), tr(trState->spanContext) {
	if (DatabaseContext::debugUseTags) {
		debugAddTags(trState);
	}
}

Transaction::~Transaction() {
	flushTrLogsIfEnabled();
	cancelWatches();
}

void Transaction::operator=(Transaction&& r) noexcept {
	flushTrLogsIfEnabled();
	tr = std::move(r.tr);
	trState = std::move(r.trState);
	extraConflictRanges = std::move(r.extraConflictRanges);
	commitResult = std::move(r.commitResult);
	committing = std::move(r.committing);
	backoff = r.backoff;
	watches = r.watches;
}

void Transaction::flushTrLogsIfEnabled() {
	if (trState && trState->trLogInfo && trState->trLogInfo->logsAdded && trState->trLogInfo->trLogWriter.getData()) {
		ASSERT(trState->trLogInfo->flushed == false);
		trState->cx->clientStatusUpdater.inStatusQ.push_back(
		    { trState->trLogInfo->identifier, std::move(trState->trLogInfo->trLogWriter) });
		trState->trLogInfo->flushed = true;
	}
}

VersionVector Transaction::getVersionVector() const {
	return trState->cx->ssVersionVectorCache;
}

void Transaction::setVersion(Version v) {
	trState->startTime = now();
	if (trState->readVersionFuture.isValid())
		throw read_version_already_set();
	if (v <= 0)
		throw version_invalid();

	trState->readVersionFuture = v;
	trState->readVersionObtainedFromGrvProxy = false;
}

Future<Optional<Value>> Transaction::get(const Key& key, Snapshot snapshot) {
	++trState->cx->transactionLogicalReads;
	++trState->cx->transactionGetValueRequests;
	// ASSERT (key < allKeys.end);

	// There are no keys in the database with size greater than the max key size
	if (key.size() > getMaxReadKeySize(key)) {
		return Optional<Value>();
	}

	auto ver = getReadVersion();

	/*	if (!systemKeys.contains(key))
	        return Optional<Value>(Value()); */

	if (!snapshot)
		tr.transaction.read_conflict_ranges.push_back(tr.arena, singleKeyRange(key, tr.arena));

	UseTenant useTenant = UseTenant::True;
	if (key == metadataVersionKey) {
		// It is legal to read the metadata version key inside of a tenant.
		// This will return the global metadata version key.
		useTenant = UseTenant::False;
		++trState->cx->transactionMetadataVersionReads;
		if (!ver.isReady() || trState->metadataVersion.isSet()) {
			return trState->metadataVersion.getFuture();
		} else {
			if (ver.isError()) {
				return ver.getError();
			}
			if (ver.get() == trState->cx->metadataVersionCache[trState->cx->mvCacheInsertLocation].first) {
				return trState->cx->metadataVersionCache[trState->cx->mvCacheInsertLocation].second;
			}

			Version v = ver.get();
			int hi = trState->cx->mvCacheInsertLocation;
			int lo = (trState->cx->mvCacheInsertLocation + 1) % trState->cx->metadataVersionCache.size();

			while (hi != lo) {
				int cu = hi > lo ? (hi + lo) / 2
				                 : ((hi + trState->cx->metadataVersionCache.size() + lo) / 2) %
				                       trState->cx->metadataVersionCache.size();
				if (v == trState->cx->metadataVersionCache[cu].first) {
					return trState->cx->metadataVersionCache[cu].second;
				}
				if (cu == lo) {
					break;
				}
				if (v < trState->cx->metadataVersionCache[cu].first) {
					hi = cu;
				} else {
					lo = (cu + 1) % trState->cx->metadataVersionCache.size();
				}
			}
		}
	}

	return getValue(trState, key, useTenant);
}

void Watch::setWatch(Future<Void> watchFuture) {
	this->watchFuture = watchFuture;

	// Cause the watch loop to go around and start waiting on watchFuture
	onSetWatchTrigger.send(Void());
}

															#line 17680 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
namespace {
// This generated class is to be used only via getTenantMetadata()
															#line 3809 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class GetTenantMetadataActor>
															#line 3809 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetTenantMetadataActorState {
															#line 17687 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
															#line 3809 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetTenantMetadataActorState(Reference<TransactionState> const& trState) 
															#line 3809 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 3809 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : trState(trState)
															#line 17694 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
	{
		fdb_probe_actor_create("getTenantMetadata", reinterpret_cast<unsigned long>(this));

	}
	~GetTenantMetadataActorState() 
	{
		fdb_probe_actor_destroy("getTenantMetadata", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3810 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_0 = trState->startTransaction();
															#line 3810 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<GetTenantMetadataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17711 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetTenantMetadataActor*>(this)->actor_wait_state = 1;
															#line 3810 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetTenantMetadataActor, 0, Void >*>(static_cast<GetTenantMetadataActor*>(this)));
															#line 17716 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetTenantMetadataActorState();
		static_cast<GetTenantMetadataActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 3811 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetTenantMetadataActor*>(this)->SAV<TenantInfo>::futures) { (void)(trState->getTenantInfo()); this->~GetTenantMetadataActorState(); static_cast<GetTenantMetadataActor*>(this)->destroy(); return 0; }
															#line 17739 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<GetTenantMetadataActor*>(this)->SAV< TenantInfo >::value()) TenantInfo(trState->getTenantInfo());
		this->~GetTenantMetadataActorState();
		static_cast<GetTenantMetadataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 3811 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetTenantMetadataActor*>(this)->SAV<TenantInfo>::futures) { (void)(trState->getTenantInfo()); this->~GetTenantMetadataActorState(); static_cast<GetTenantMetadataActor*>(this)->destroy(); return 0; }
															#line 17751 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<GetTenantMetadataActor*>(this)->SAV< TenantInfo >::value()) TenantInfo(trState->getTenantInfo());
		this->~GetTenantMetadataActorState();
		static_cast<GetTenantMetadataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetTenantMetadataActor*>(this)->actor_wait_state > 0) static_cast<GetTenantMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<GetTenantMetadataActor*>(this)->ActorCallback< GetTenantMetadataActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetTenantMetadataActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getTenantMetadata", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenantMetadata", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetTenantMetadataActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getTenantMetadata", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenantMetadata", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetTenantMetadataActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getTenantMetadata", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenantMetadata", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 3809 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reference<TransactionState> trState;
															#line 17836 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
};
// This generated class is to be used only via getTenantMetadata()
															#line 3809 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetTenantMetadataActor final : public Actor<TenantInfo>, public ActorCallback< GetTenantMetadataActor, 0, Void >, public FastAllocated<GetTenantMetadataActor>, public GetTenantMetadataActorState<GetTenantMetadataActor> {
															#line 17841 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
	using FastAllocated<GetTenantMetadataActor>::operator new;
	using FastAllocated<GetTenantMetadataActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17552403183455413504UL, 10704261458848183552UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<TenantInfo>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetTenantMetadataActor, 0, Void >;
															#line 3809 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetTenantMetadataActor(Reference<TransactionState> const& trState) 
															#line 17858 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		 : Actor<TenantInfo>(),
		   GetTenantMetadataActorState<GetTenantMetadataActor>(trState),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getTenantMetadata", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15136455772467430656UL, 18368454153055306496UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getTenantMetadata");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getTenantMetadata", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetTenantMetadataActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 3809 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<TenantInfo> getTenantMetadata( Reference<TransactionState> const& trState ) {
															#line 3809 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<TenantInfo>(new GetTenantMetadataActor(trState));
															#line 17891 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
}

#line 3813 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

Future<TenantInfo> populateAndGetTenant(Reference<TransactionState> trState, Key const& key) {
	if (!trState->hasTenant() || key == metadataVersionKey) {
		return TenantInfo();
	} else if (trState->startTransaction().canGet()) {
		return trState->getTenantInfo();
	} else {
		return getTenantMetadata(trState);
	}
}

// Restarts a watch after a database switch
															#line 17907 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
namespace {
// This generated class is to be used only via restartWatch()
															#line 3825 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class RestartWatchActor>
															#line 3825 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class RestartWatchActorState {
															#line 17914 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
															#line 3825 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	RestartWatchActorState(Database const& cx,TenantInfo const& tenantInfo,Key const& key,Optional<Value> const& value,TagSet const& tags,SpanContext const& spanContext,TaskPriority const& taskID,Optional<UID> const& debugID,UseProvisionalProxies const& useProvisionalProxies) 
															#line 3825 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 3825 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : cx(cx),
															#line 3825 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   tenantInfo(tenantInfo),
															#line 3825 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   key(key),
															#line 3825 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   value(value),
															#line 3825 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   tags(tags),
															#line 3825 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   spanContext(spanContext),
															#line 3825 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   taskID(taskID),
															#line 3825 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   debugID(debugID),
															#line 3825 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   useProvisionalProxies(useProvisionalProxies)
															#line 17937 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
	{
		fdb_probe_actor_create("restartWatch", reinterpret_cast<unsigned long>(this));

	}
	~RestartWatchActorState() 
	{
		fdb_probe_actor_destroy("restartWatch", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3836 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			cx->deleteWatchMetadata(tenantInfo.tenantId, key, true);
															#line 3838 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_0 = watchValueMap(cx->minAcceptableReadVersion, tenantInfo, key, value, cx, tags, spanContext, taskID, debugID, useProvisionalProxies);
															#line 3838 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<RestartWatchActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17956 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RestartWatchActor*>(this)->actor_wait_state = 1;
															#line 3838 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RestartWatchActor, 0, Void >*>(static_cast<RestartWatchActor*>(this)));
															#line 17961 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RestartWatchActorState();
		static_cast<RestartWatchActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 3849 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<RestartWatchActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RestartWatchActorState(); static_cast<RestartWatchActor*>(this)->destroy(); return 0; }
															#line 17984 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<RestartWatchActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RestartWatchActorState();
		static_cast<RestartWatchActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 3849 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<RestartWatchActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RestartWatchActorState(); static_cast<RestartWatchActor*>(this)->destroy(); return 0; }
															#line 17996 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<RestartWatchActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RestartWatchActorState();
		static_cast<RestartWatchActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RestartWatchActor*>(this)->actor_wait_state > 0) static_cast<RestartWatchActor*>(this)->actor_wait_state = 0;
		static_cast<RestartWatchActor*>(this)->ActorCallback< RestartWatchActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RestartWatchActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("restartWatch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestartWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restartWatch", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RestartWatchActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("restartWatch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestartWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restartWatch", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RestartWatchActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("restartWatch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestartWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restartWatch", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 3825 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Database cx;
															#line 3825 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	TenantInfo tenantInfo;
															#line 3825 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Key key;
															#line 3825 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Optional<Value> value;
															#line 3825 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	TagSet tags;
															#line 3825 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	SpanContext spanContext;
															#line 3825 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	TaskPriority taskID;
															#line 3825 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Optional<UID> debugID;
															#line 3825 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	UseProvisionalProxies useProvisionalProxies;
															#line 18097 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
};
// This generated class is to be used only via restartWatch()
															#line 3825 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class RestartWatchActor final : public Actor<Void>, public ActorCallback< RestartWatchActor, 0, Void >, public FastAllocated<RestartWatchActor>, public RestartWatchActorState<RestartWatchActor> {
															#line 18102 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
	using FastAllocated<RestartWatchActor>::operator new;
	using FastAllocated<RestartWatchActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15134566685729853184UL, 10211187328942013440UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RestartWatchActor, 0, Void >;
															#line 3825 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	RestartWatchActor(Database const& cx,TenantInfo const& tenantInfo,Key const& key,Optional<Value> const& value,TagSet const& tags,SpanContext const& spanContext,TaskPriority const& taskID,Optional<UID> const& debugID,UseProvisionalProxies const& useProvisionalProxies) 
															#line 18119 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		 : Actor<Void>(),
		   RestartWatchActorState<RestartWatchActor>(cx, tenantInfo, key, value, tags, spanContext, taskID, debugID, useProvisionalProxies),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("restartWatch", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(415901849338767872UL, 13846331734017316352UL);
		ActorExecutionContextHelper __helper(static_cast<RestartWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("restartWatch");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("restartWatch", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RestartWatchActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 3825 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<Void> restartWatch( Database const& cx, TenantInfo const& tenantInfo, Key const& key, Optional<Value> const& value, TagSet const& tags, SpanContext const& spanContext, TaskPriority const& taskID, Optional<UID> const& debugID, UseProvisionalProxies const& useProvisionalProxies ) {
															#line 3825 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Void>(new RestartWatchActor(cx, tenantInfo, key, value, tags, spanContext, taskID, debugID, useProvisionalProxies));
															#line 18152 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
}

#line 3851 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

// FIXME: This seems pretty horrible. Now a Database can't die until all of its watches do...
															#line 18158 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
namespace {
// This generated class is to be used only via watch()
															#line 3853 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class WatchActor>
															#line 3853 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class WatchActorState {
															#line 18165 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
															#line 3853 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	WatchActorState(Reference<Watch> const& watch,Database const& cx,Future<TenantInfo> const& tenant,TagSet const& tags,SpanContext const& spanContext,TaskPriority const& taskID,Optional<UID> const& debugID,UseProvisionalProxies const& useProvisionalProxies) 
															#line 3853 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 3853 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : watch(watch),
															#line 3853 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   cx(cx),
															#line 3853 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   tenant(tenant),
															#line 3853 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   tags(tags),
															#line 3853 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   spanContext(spanContext),
															#line 3853 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   taskID(taskID),
															#line 3853 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   debugID(debugID),
															#line 3853 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   useProvisionalProxies(useProvisionalProxies)
															#line 18186 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
	{
		fdb_probe_actor_create("watch", reinterpret_cast<unsigned long>(this));

	}
	~WatchActorState() 
	{
		fdb_probe_actor_destroy("watch", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 3865 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				StrictFuture<Void> __when_expr_0 = watch->onChangeTrigger.getFuture();
															#line 3862 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (static_cast<WatchActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 18204 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 3868 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				StrictFuture<Void> __when_expr_1 = watch->onSetWatchTrigger.getFuture();
															#line 18208 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
				static_cast<WatchActor*>(this)->actor_wait_state = 1;
															#line 3865 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WatchActor, 0, Void >*>(static_cast<WatchActor*>(this)));
															#line 3868 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WatchActor, 1, Void >*>(static_cast<WatchActor*>(this)));
															#line 18215 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WatchActorState();
		static_cast<WatchActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 3899 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		cx->decreaseWatchCounter();
															#line 3900 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<WatchActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WatchActorState(); static_cast<WatchActor*>(this)->destroy(); return 0; }
															#line 18246 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<WatchActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WatchActorState();
		static_cast<WatchActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 3895 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			cx->decreaseWatchCounter();
															#line 3896 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 18261 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
															#line 3870 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<TenantInfo> __when_expr_2 = tenant;
															#line 3870 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<WatchActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 18295 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1when2when1(__when_expr_2.get(), loopDepth); };
		static_cast<WatchActor*>(this)->actor_wait_state = 2;
															#line 3870 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WatchActor, 2, TenantInfo >*>(static_cast<WatchActor*>(this)));
															#line 18300 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
															#line 3870 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<TenantInfo> __when_expr_2 = tenant;
															#line 3870 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<WatchActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 18311 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1when2when1(__when_expr_2.get(), loopDepth); };
		static_cast<WatchActor*>(this)->actor_wait_state = 2;
															#line 3870 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WatchActor, 2, TenantInfo >*>(static_cast<WatchActor*>(this)));
															#line 18316 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WatchActor*>(this)->actor_wait_state > 0) static_cast<WatchActor*>(this)->actor_wait_state = 0;
		static_cast<WatchActor*>(this)->ActorCallback< WatchActor, 0, Void >::remove();
		static_cast<WatchActor*>(this)->ActorCallback< WatchActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WatchActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("watch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watch", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WatchActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("watch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watch", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WatchActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("watch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watch", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1when2cont1(int loopDepth) 
	{
															#line 3871 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		;
															#line 18389 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1when2cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when2when1(TenantInfo const& __tenantInfo,int loopDepth) 
	{
															#line 3870 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		tenantInfo = __tenantInfo;
															#line 18398 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1when2cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when2when1(TenantInfo && __tenantInfo,int loopDepth) 
	{
		tenantInfo = std::move(__tenantInfo);
		loopDepth = a_body1when2cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WatchActor*>(this)->actor_wait_state > 0) static_cast<WatchActor*>(this)->actor_wait_state = 0;
		static_cast<WatchActor*>(this)->ActorCallback< WatchActor, 2, TenantInfo >::remove();

	}
	void a_callback_fire(ActorCallback< WatchActor, 2, TenantInfo >*,TenantInfo const& value) 
	{
		fdb_probe_actor_enter("watch", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watch", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WatchActor, 2, TenantInfo >*,TenantInfo && value) 
	{
		fdb_probe_actor_enter("watch", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watch", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WatchActor, 2, TenantInfo >*,Error err) 
	{
		fdb_probe_actor_enter("watch", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watch", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1when2cont2(int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when2cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1when2cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1when2cont1loopBody1(int loopDepth) 
	{
															#line 3874 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_3 = watch->watchFuture;
															#line 3872 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<WatchActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 18492 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch2(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1when2cont1loopBody1when1(__when_expr_3.get(), loopDepth); };
															#line 3878 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_4 = cx->connectionFileChanged();
															#line 18496 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch2(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1when2cont1loopBody1when2(__when_expr_4.get(), loopDepth); };
		static_cast<WatchActor*>(this)->actor_wait_state = 3;
															#line 3874 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WatchActor, 3, Void >*>(static_cast<WatchActor*>(this)));
															#line 3878 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< WatchActor, 4, Void >*>(static_cast<WatchActor*>(this)));
															#line 18503 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when2cont1break1(int loopDepth) 
	{
		try {
			return a_body1when2cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1when2cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1when2cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1when2cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		return a_body1when2cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1when2cont1loopBody1when1(Void && _,int loopDepth) 
	{
		return a_body1when2cont1break1(loopDepth==0?0:loopDepth-1); // bre