#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
/*
 * fdbcli.actor.h
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once

// When actually compiled (NO_INTELLISENSE), include the generated
// version of this file.  In intellisense use the source version.
#if defined(NO_INTELLISENSE) && !defined(FDBCLI_FDBCLI_ACTOR_G_H)
#define FDBCLI_FDBCLI_ACTOR_G_H
#include "fdbcli/fdbcli.actor.g.h"
#elif !defined(FDBCLI_FDBCLI_ACTOR_H)
#define FDBCLI_FDBCLI_ACTOR_H

#include "fdbcli/FlowLineNoise.h"

#include "fdbclient/CoordinationInterface.h"
#include "fdbclient/IClientApi.h"
#include "fdbclient/StatusClient.h"
#include "fdbclient/StorageServerInterface.h"
#include "flow/Arena.h"

#include "flow/actorcompiler.h" // This must be the last #include.

namespace fdb_cli {

constexpr char msgTypeKey[] = "type";
constexpr char msgClusterKey[] = "cluster";
constexpr char msgClusterTypeKey[] = "cluster_type";
constexpr char msgMetaclusterName[] = "metacluster_name";
constexpr char msgMetaclusterKey[] = "metacluster";
constexpr char msgDataClustersKey[] = "data_clusters";
constexpr char msgCapacityKey[] = "capacity";
constexpr char msgAllocatedKey[] = "allocated";
constexpr char msgTenantIdPrefixKey[] = "tenant_id_prefix";
constexpr char msgErrorKey[] = "error";

struct CommandHelp {
	std::string usage;
	std::string short_desc;
	std::string long_desc;
	CommandHelp() {}
	CommandHelp(const char* usage, const char* short_desc, const char* long_desc)
	  : usage(usage), short_desc(short_desc), long_desc(long_desc) {}
};

void arrayGenerator(const char* text, const char* line, const char** options, std::vector<std::string>& lc);

struct CommandFactory {
	typedef void (*CompletionGeneratorFunc)(const char* text,
	                                        const char* line,
	                                        std::vector<std::string>& lc,
	                                        std::vector<StringRef> const& tokens);

	typedef std::vector<const char*> (*HintGeneratorFunc)(std::vector<StringRef> const& tokens, bool inArgument);

	CommandFactory(const char* name,
	               CommandHelp help,
	               CompletionGeneratorFunc completionFunc = nullptr,
	               HintGeneratorFunc hintFunc = nullptr) {
		commands()[name] = help;
		if (completionFunc) {
			completionGenerators()[name] = completionFunc;
		}
		if (hintFunc) {
			hintGenerators()[name] = hintFunc;
		}
	}
	CommandFactory(const char* name) { hiddenCommands().insert(name); }
	static std::map<std::string, CommandHelp>& commands() {
		static std::map<std::string, CommandHelp> helpMap;
		return helpMap;
	}
	static std::set<std::string>& hiddenCommands() {
		static std::set<std::string> commands;
		return commands;
	}
	static std::map<std::string, CompletionGeneratorFunc>& completionGenerators() {
		static std::map<std::string, CompletionGeneratorFunc> completionMap;
		return completionMap;
	}
	static std::map<std::string, HintGeneratorFunc>& hintGenerators() {
		static std::map<std::string, HintGeneratorFunc> hintMap;
		return hintMap;
	}
};

// Special keys used by fdbcli commands
// advanceversion
extern const KeyRef advanceVersionSpecialKey;
// consistencycheck
extern const KeyRef consistencyCheckSpecialKey;
// coordinators
extern const KeyRef clusterDescriptionSpecialKey;
extern const KeyRef configDBSpecialKey;
extern const KeyRef coordinatorsAutoSpecialKey;
extern const KeyRef coordinatorsProcessSpecialKey;
// datadistribution
extern const KeyRef ddModeSpecialKey;
extern const KeyRef ddIgnoreRebalanceSpecialKey;
// exclude/include
extern const KeyRangeRef excludedServersSpecialKeyRange;
extern const KeyRangeRef failedServersSpecialKeyRange;
extern const KeyRangeRef excludedLocalitySpecialKeyRange;
extern const KeyRangeRef failedLocalitySpecialKeyRange;
extern const KeyRef excludedForceOptionSpecialKey;
extern const KeyRef failedForceOptionSpecialKey;
extern const KeyRef excludedLocalityForceOptionSpecialKey;
extern const KeyRef failedLocalityForceOptionSpecialKey;
extern const KeyRangeRef exclusionInProgressSpecialKeyRange;
// lock/unlock
extern const KeyRef lockSpecialKey;
// maintenance
extern const KeyRangeRef maintenanceSpecialKeyRange;
extern const KeyRef ignoreSSFailureSpecialKey;
// setclass
extern const KeyRangeRef processClassSourceSpecialKeyRange;
extern const KeyRangeRef processClassTypeSpecialKeyRange;
// Other special keys
inline const KeyRef errorMsgSpecialKey = "\xff\xff/error_message"_sr;
inline const KeyRef workerInterfacesVerifyOptionSpecialKey = "\xff\xff/management/options/worker_interfaces/verify"_sr;
// help functions (Copied from fdbcli.actor.cpp)

// get all workers' info
															#line 143 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h"
[[nodiscard]] Future<bool> getWorkers( Reference<IDatabase> const& db, std::vector<ProcessData>* const& workers );

#line 142 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// get all storages' interface
															#line 148 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h"
[[nodiscard]] Future<Void> getStorageServerInterfaces( Reference<IDatabase> const& db, std::map<std::string, StorageServerInterface>* const& interfaces );

#line 145 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"

// compare StringRef with the given c string
bool tokencmp(StringRef token, const char* command);
// print the usage of the specified command
void printUsage(StringRef command);
// print the long description of the specified command
void printLongDesc(StringRef command);
// Pre: tr failed with special_keys_api_failure error
// Read the error message special key and return the message
															#line 161 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h"
[[nodiscard]] Future<std::string> getSpecialKeysFailureErrorMessage( Reference<ITransaction> const& tr );

#line 155 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// Using \xff\xff/worker_interfaces/ special key, get all worker interfaces.
// A worker list will be returned from CC.
// If verify, we will try to establish connections to all workers returned.
// In particular, it will deserialize \xff\xff/worker_interfaces/<address>:=<ClientInterface> kv pairs and issue RPC
// calls, then only return interfaces(kv pairs) the client can talk to
															#line 170 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h"
[[nodiscard]] Future<Void> getWorkerInterfaces( Reference<ITransaction> const& tr, std::map<Key, std::pair<Value, ClientLeaderRegInterface>>* const& address_interface, bool const& verify = false );

#line 163 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// print cluster status info
void printStatus(StatusObjectReader statusObj,
                 StatusClient::StatusLevel level,
                 bool displayDatabaseAvailable = true,
                 bool hideErrorMessages = false);

// All fdbcli commands (alphabetically)
// All below actors return true if the command is executed successfully
// advanceversion command
															#line 183 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h"
[[nodiscard]] Future<bool> advanceVersionCommandActor( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens );

#line 173 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// cache_range command
															#line 188 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h"
[[nodiscard]] Future<bool> cacheRangeCommandActor( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens );

#line 175 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// configure command
															#line 193 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h"
[[nodiscard]] Future<bool> configureCommandActor( Reference<IDatabase> const& db, Database const& localDb, std::vector<StringRef> const& tokens, LineNoise* const& linenoise, Future<Void> const& warn );

#line 181 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// consistency command
															#line 198 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h"
[[nodiscard]] Future<bool> consistencyCheckCommandActor( Reference<ITransaction> const& tr, std::vector<StringRef> const& tokens, bool const& intrans );

#line 185 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// consistency scan command
															#line 203 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h"
[[nodiscard]] Future<bool> consistencyScanCommandActor( Database const& localDb, std::vector<StringRef> const& tokens );

#line 187 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// coordinators command
															#line 208 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h"
[[nodiscard]] Future<bool> coordinatorsCommandActor( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens );

#line 189 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// datadistribution command
															#line 213 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h"
[[nodiscard]] Future<bool> dataDistributionCommandActor( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens );

#line 191 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// exclude command
															#line 218 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h"
[[nodiscard]] Future<bool> excludeCommandActor( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens, Future<Void> const& warn );

#line 193 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// expensive_data_check command
															#line 223 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h"
[[nodiscard]] Future<bool> expensiveDataCheckCommandActor( Reference<IDatabase> const& db, Reference<ITransaction> const& tr, std::vector<StringRef> const& tokens, std::map<Key, std::pair<Value, ClientLeaderRegInterface>>* const& address_interface );

#line 199 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// fileconfigure command
															#line 228 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h"
[[nodiscard]] Future<bool> fileConfigureCommandActor( Reference<IDatabase> const& db, std::string const& filePath, bool const& isNewDatabase, bool const& force );

#line 204 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// Trigger audit storage
															#line 233 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h"
[[nodiscard]] Future<UID> auditStorageCommandActor( Reference<IClusterConnectionRecord> const& clusterFile, std::vector<StringRef> const& tokens );

#line 207 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// Retrieve audit storage status
															#line 238 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h"
[[nodiscard]] Future<bool> getAuditStatusCommandActor( Database const& cx, std::vector<StringRef> const& tokens );

#line 209 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// Retrieve shard information command
															#line 243 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h"
[[nodiscard]] Future<bool> locationMetadataCommandActor( Database const& cx, std::vector<StringRef> const& tokens );

#line 211 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// Bulk loading command
															#line 248 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h"
[[nodiscard]] Future<UID> bulkLoadCommandActor( Database const& cx, std::vector<StringRef> const& tokens );

#line 213 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// Bulk dumping command
															#line 253 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h"
[[nodiscard]] Future<UID> bulkDumpCommandActor( Database const& cx, std::vector<StringRef> const& tokens );

#line 215 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// force_recovery_with_data_loss command
															#line 258 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h"
[[nodiscard]] Future<bool> forceRecoveryWithDataLossCommandActor( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens );

#line 217 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// include command
															#line 263 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h"
[[nodiscard]] Future<bool> includeCommandActor( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens );

#line 219 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// kill command
															#line 268 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h"
[[nodiscard]] Future<bool> killCommandActor( Reference<IDatabase> const& db, Reference<ITransaction> const& tr, std::vector<StringRef> const& tokens, std::map<Key, std::pair<Value, ClientLeaderRegInterface>>* const& address_interface );

#line 224 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// lock/unlock command
															#line 273 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h"
[[nodiscard]] Future<bool> lockCommandActor( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens );

#line 226 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
															#line 277 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h"
[[nodiscard]] Future<bool> unlockDatabaseActor( Reference<IDatabase> const& db, UID const& uid );

#line 227 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"

// metacluster command
Future<bool> metaclusterCommand(Reference<IDatabase> db, std::vector<StringRef> tokens);

// blobrestore command
															#line 286 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h"
[[nodiscard]] Future<bool> blobRestoreCommandActor( Database const& localDb, std::vector<StringRef> const& tokens );

#line 233 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// hotrange command
															#line 291 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h"
[[nodiscard]] Future<bool> hotRangeCommandActor( Database const& localDb, Reference<IDatabase> const& db, std::vector<StringRef> const& tokens, std::map<std::string, StorageServerInterface>* const& storage_interface );

#line 238 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"

// maintenance command
															#line 297 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h"
[[nodiscard]] Future<bool> setHealthyZone( Reference<IDatabase> const& db, StringRef const& zoneId, double const& seconds, bool const& printWarning = false );

#line 241 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
															#line 301 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h"
[[nodiscard]] Future<bool> clearHealthyZone( Reference<IDatabase> const& db, bool const& printWarning = false, bool const& clearSSFailureZoneString = false );

#line 244 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
															#line 305 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h"
[[nodiscard]] Future<bool> maintenanceCommandActor( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens );

#line 245 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// profile command
															#line 310 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h"
[[nodiscard]] Future<bool> profileCommandActor( Database const& db, Reference<ITransaction> const& tr, std::vector<StringRef> const& tokens, bool const& intrans );

#line 250 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// quota command
															#line 315 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h"
[[nodiscard]] Future<bool> quotaCommandActor( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens );

#line 252 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// setclass command
															#line 320 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h"
[[nodiscard]] Future<bool> setClassCommandActor( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens );

#line 254 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// snapshot command
															#line 325 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h"
[[nodiscard]] Future<bool> snapshotCommandActor( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens );

#line 256 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// status command
															#line 330 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h"
[[nodiscard]] Future<bool> statusCommandActor( Reference<IDatabase> const& db, Database const& localDb, std::vector<StringRef> const& tokens, bool const& isExecMode = false );

#line 261 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// suspend command
															#line 335 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h"
[[nodiscard]] Future<bool> suspendCommandActor( Reference<IDatabase> const& db, Reference<ITransaction> const& tr, std::vector<StringRef> const& tokens, std::map<Key, std::pair<Value, ClientLeaderRegInterface>>* const& address_interface );

#line 266 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// tenant command
Future<bool> tenantCommand(Reference<IDatabase> db, std::vector<StringRef> tokens);
// tenant command compatibility layer
Future<bool> tenantCommandForwarder(Reference<IDatabase> db, std::vector<StringRef> tokens);
// tenantgroup command
Future<bool> tenantGroupCommand(Reference<IDatabase> db, std::vector<StringRef> tokens);
// throttle command
															#line 346 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h"
[[nodiscard]] Future<bool> throttleCommandActor( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens );

#line 274 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// triggerteaminfolog command
															#line 351 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h"
[[nodiscard]] Future<bool> triggerddteaminfologCommandActor( Reference<IDatabase> const& db );

#line 276 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// tssq command
															#line 356 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h"
[[nodiscard]] Future<bool> tssqCommandActor( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens );

#line 278 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// versionepoch command
															#line 361 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h"
[[nodiscard]] Future<bool> versionEpochCommandActor( Reference<IDatabase> const& db, Database const& cx, std::vector<StringRef> const& tokens );

#line 280 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// targetversion command
															#line 366 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h"
[[nodiscard]] Future<bool> targetVersionCommandActor( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens );

#line 282 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// idempotencyids command
															#line 371 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h"
[[nodiscard]] Future<bool> idempotencyIdsCommandActor( Database const& cx, std::vector<StringRef> const& tokens );

#line 284 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"

// rangeconfig command
															#line 377 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h"
[[nodiscard]] Future<bool> rangeConfigCommandActor( Database const& cx, std::vector<StringRef> const& tokens );

#line 287 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"

// debug commands: getlocation, getall
															#line 383 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h"
[[nodiscard]] Future<bool> getLocationCommandActor( Database const& cx, std::vector<StringRef> const& tokens );

#line 290 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
															#line 387 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h"
[[nodiscard]] Future<bool> getallCommandActor( Database const& cx, std::vector<StringRef> const& tokens, Version const& version );

#line 291 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
															#line 391 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h"
[[nodiscard]] Future<bool> checkallCommandActor( Database const& cx, std::vector<StringRef> const& tokens );

#line 292 "/codebuild/output/src2838892639/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
} // namespace fdb_cli

#include "flow/unactorcompiler.h"
#endif
