/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb;

import com.apple.foundationdb.Database;
import com.apple.foundationdb.FDB;
import com.apple.foundationdb.RequiresDatabase;
import com.apple.foundationdb.Transaction;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={RequiresDatabase.class})
class FutureIntegrationTest {
    private static final FDB fdb = FDB.selectAPIVersion((int)740);

    FutureIntegrationTest() {
    }

    @Test
    @Tag(value="SupportsExternalClient")
    public void testCancelFuture() throws Exception {
        this.testTransaction(transaction -> {
            CompletableFuture completableFuture = transaction.get("hello".getBytes());
            completableFuture.cancel(true);
            return null;
        });
    }

    @Test
    @Tag(value="SupportsExternalClient")
    public void testCancelWithCallbackSet() throws Exception {
        this.testTransaction(transaction -> {
            CompletableFuture completableFuture = transaction.get("hello".getBytes());
            completableFuture.thenAcceptAsync(byArray -> {
                Assertions.assertNull((Object)byArray);
                CompletableFuture completableFuture = transaction.get("world".getBytes());
                completableFuture.join();
            });
            completableFuture.cancel(true);
            return null;
        });
    }

    @Test
    @Tag(value="SupportsExternalClient")
    public void testSetCallbackAfterJoin() throws Exception {
        this.testTransaction(transaction -> {
            CompletableFuture completableFuture = transaction.get("hello".getBytes());
            completableFuture.join();
            completableFuture.thenAcceptAsync(byArray -> {
                Assertions.assertNull((Object)byArray);
                CompletableFuture completableFuture = transaction.get("world".getBytes());
                completableFuture.join();
            });
            return null;
        });
    }

    @Test
    @Tag(value="SupportsExternalClient")
    public void testCancelFromCallback() throws Exception {
        this.testTransaction(transaction -> {
            CompletableFuture completableFuture = transaction.get("hello".getBytes());
            completableFuture.thenAcceptAsync(byArray -> {
                Assertions.assertNull((Object)byArray);
                CompletableFuture completableFuture2 = transaction.get("world".getBytes());
                completableFuture.cancel(true);
                completableFuture2.cancel(true);
            });
            return null;
        });
    }

    private <T> void testTransaction(Function<? super Transaction, T> function) {
        int n;
        try (Database database = fdb.open();){
            for (n = 0; n < 10; ++n) {
                database.run(function);
            }
        }
        database = fdb.open(null, (Executor)new DirectExecutor());
        try {
            for (n = 0; n < 10; ++n) {
                database.run(function);
            }
        }
        finally {
            if (database != null) {
                database.close();
            }
        }
    }

    static class DirectExecutor
    implements Executor {
        DirectExecutor() {
        }

        @Override
        public void execute(Runnable runnable) {
            runnable.run();
        }
    }
}

