#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
/*
 * TenantManagementWorkload.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <cstdint>
#include <limits>
#include "fdbclient/ClientBooleanParams.h"
#include "fdbclient/ClusterConnectionMemoryRecord.h"
#include "fdbclient/FDBOptions.g.h"
#include "fdbclient/FDBTypes.h"
#include "fdbclient/GenericManagementAPI.actor.h"
#include "fdbclient/KeyBackedTypes.actor.h"
#include "fdbclient/KeyRangeMap.h"
#include "fdbclient/MultiVersionTransaction.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbclient/RunRYWTransaction.actor.h"
#include "fdbclient/Tenant.h"
#include "fdbclient/TenantManagement.actor.h"
#include "fdbclient/TenantSpecialKeys.actor.h"
#include "fdbclient/ThreadSafeTransaction.h"
#include "fdbrpc/simulator.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/Knobs.h"
#include "flow/ApiVersion.h"
#include "flow/Error.h"
#include "flow/IRandom.h"
#include "flow/ThreadHelper.actor.h"
#include "flow/flow.h"
#include "libb64/decode.h"

#include "metacluster/Metacluster.h"
#include "metacluster/MetaclusterConsistency.actor.h"
#include "metacluster/TenantConsistency.actor.h"

#include "flow/actorcompiler.h" // This must be the last #include.

struct TenantManagementWorkload : TestWorkload {
	static constexpr auto NAME = "TenantManagement";

	struct TenantTestData {
		Reference<Tenant> tenant;
		Optional<TenantGroupName> tenantGroup;
		TenantAPI::TenantLockState lockState = TenantAPI::TenantLockState::UNLOCKED;
		Optional<UID> lockId;
		bool empty;

		TenantTestData() : empty(true) {}
		TenantTestData(int64_t id, Optional<TenantGroupName> tenantGroup, bool empty)
		  : tenant(makeReference<Tenant>(id)), tenantGroup(tenantGroup), empty(empty) {}
		TenantTestData(int64_t id, Optional<TenantName> tName, Optional<TenantGroupName> tenantGroup, bool empty)
		  : tenant(makeReference<Tenant>(id, tName)), tenantGroup(tenantGroup), empty(empty) {}
	};

	struct TenantGroupData {
		int64_t tenantCount = 0;
	};

	std::map<TenantName, TenantTestData> createdTenants;
	std::map<TenantGroupName, TenantGroupData> createdTenantGroups;
	// Contains references to ALL tenants that were created by this client
	// Possible to have been deleted, but will be tracked historically here
	std::vector<Reference<Tenant>> allTestTenants;
	int64_t maxId = -1;

	const Key keyName = "key"_sr;
	const Key testParametersKey = nonMetadataSystemKeys.begin.withSuffix("/tenant_test/test_parameters"_sr);
	const Value noTenantValue = "no_tenant"_sr;
	const TenantName tenantNamePrefix = "tenant_management_workload_"_sr;
	ClusterName dataClusterName;
	TenantName localTenantNamePrefix;
	TenantName localTenantGroupNamePrefix;

	const Key specialKeysTenantMapPrefix = SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::MANAGEMENT)
	                                           .begin.withSuffix(TenantRangeImpl::submoduleRange.begin)
	                                           .withSuffix(TenantRangeImpl::mapSubRange.begin);
	const Key specialKeysTenantConfigPrefix = SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::MANAGEMENT)
	                                              .begin.withSuffix(TenantRangeImpl::submoduleRange.begin)
	                                              .withSuffix(TenantRangeImpl::configureSubRange.begin);
	const Key specialKeysTenantRenamePrefix = SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::MANAGEMENT)
	                                              .begin.withSuffix(TenantRangeImpl::submoduleRange.begin)
	                                              .withSuffix(TenantRangeImpl::renameSubRange.begin);

	int maxTenants;
	int maxTenantGroups;
	double testDuration;
	bool useMetacluster;
	bool singleClient;

	Version oldestDeletionVersion = 0;
	Version newestDeletionVersion = 0;

	Reference<IDatabase> mvDb;
	Database dataDb;
	bool hasNoTenantKey = false; // whether this workload has non-tenant key
	int64_t tenantIdPrefix = 0;

	// This test exercises multiple different ways to work with tenants
	enum class OperationType {
		// Use the special key-space APIs
		SPECIAL_KEYS,
		// Use the ManagementAPI functions that take a Database object and implement a retry loop
		MANAGEMENT_DATABASE,
		// Use the ManagementAPI functions that take a Transaction object
		MANAGEMENT_TRANSACTION,
		// Use the Metacluster API, if applicable. Note: not all APIs have a metacluster variant,
		// and if there isn't one this will choose one of the other options.
		METACLUSTER
	};

	OperationType randomOperationType() {
		double metaclusterProb = useMetacluster ? 0.9 : 0.1;

		if (deterministicRandom()->random01() < metaclusterProb) {
			return OperationType::METACLUSTER;
		} else {
			return (OperationType)deterministicRandom()->randomInt(0, 3);
		}
	}

	TenantManagementWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		maxTenants = std::min<int>(1e8 - 1, getOption(options, "maxTenants"_sr, 1000));
		maxTenantGroups = std::min<int>(2 * maxTenants, getOption(options, "maxTenantGroups"_sr, 20));
		testDuration = getOption(options, "testDuration"_sr, 120.0);
		singleClient = getOption(options, "singleClient"_sr, false);

		localTenantNamePrefix = format("%stenant_%d_", tenantNamePrefix.toString().c_str(), clientId);
		localTenantGroupNamePrefix = format("%stenantgroup_%d_", tenantNamePrefix.toString().c_str(), clientId);

		bool defaultUseMetacluster = false;
		if (clientId == 0 && g_network->isSimulated() && !g_simulator->extraDatabases.empty()) {
			defaultUseMetacluster = deterministicRandom()->coinflip();
		}

		useMetacluster = getOption(options, "useMetacluster"_sr, defaultUseMetacluster);
	}

	struct TestParameters {
		constexpr static FileIdentifier file_identifier = 1527576;

		bool useMetacluster = false;

		TestParameters() {}
		TestParameters(bool useMetacluster) : useMetacluster(useMetacluster) {}

		template <class Ar>
		void serialize(Ar& ar) {
			serializer(ar, useMetacluster);
		}

		Value encode() const { return ObjectWriter::toValue(*this, Unversioned()); }
		static TestParameters decode(ValueRef const& value) {
			return ObjectReader::fromStringRef<TestParameters>(value, Unversioned());
		}
	};

	Future<Void> setup(Database const& cx) override {
		if (clientId == 0 && g_network->isSimulated() && BUGGIFY) {
			IKnobCollection::getMutableGlobalKnobCollection().setKnob(
			    "max_tenants_per_cluster", KnobValueRef::create(int{ deterministicRandom()->randomInt(20, 100) }));
		}

		if (clientId == 0 || !singleClient) {
			return _setup(cx, this);
		} else {
			return Void();
		}
	}

	// Set a key outside of all tenants to make sure that our tenants aren't writing to the regular key-space
	Future<Void> writeNonTenantKey() const {
		return runRYWTransaction(dataDb, [this](Reference<ReadYourWritesTransaction> tr) {
			tr->setOption(FDBTransactionOptions::RAW_ACCESS);
			tr->set(keyName, noTenantValue);
			return Future<Void>(Void());
		});
	}

	// load test parameters from metacluster
																#line 197 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
// This generated class is to be used only via loadTestParameters()
															#line 195 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
template <class LoadTestParametersActor>
															#line 195 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
class LoadTestParametersActorState {
															#line 203 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
public:
															#line 195 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	LoadTestParametersActorState(Database const& cx,TenantManagementWorkload* const& self) 
															#line 195 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
															#line 195 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		 : cx(cx),
															#line 195 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   self(self),
															#line 196 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   tr(cx)
															#line 214 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("loadTestParameters", reinterpret_cast<unsigned long>(this));

	}
	~LoadTestParametersActorState() 
	{
		fdb_probe_actor_destroy("loadTestParameters", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 198 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			;
															#line 229 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LoadTestParametersActorState();
		static_cast<LoadTestParametersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 200 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			tr.setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 201 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(self->testParametersKey);
															#line 201 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (static_cast<LoadTestParametersActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 264 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<LoadTestParametersActor*>(this)->actor_wait_state = 1;
															#line 201 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LoadTestParametersActor, 0, Optional<Value> >*>(static_cast<LoadTestParametersActor*>(this)));
															#line 269 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 210 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 210 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (static_cast<LoadTestParametersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 293 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<LoadTestParametersActor*>(this)->actor_wait_state = 3;
															#line 210 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< LoadTestParametersActor, 2, Void >*>(static_cast<LoadTestParametersActor*>(this)));
															#line 298 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& val,int loopDepth) 
	{
															#line 202 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (val.present())
															#line 313 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		{
															#line 203 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			TestParameters params = TestParameters::decode(val.get());
															#line 204 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			self->useMetacluster = params.useMetacluster;
															#line 205 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (!static_cast<LoadTestParametersActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LoadTestParametersActorState(); static_cast<LoadTestParametersActor*>(this)->destroy(); return 0; }
															#line 321 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			new (&static_cast<LoadTestParametersActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~LoadTestParametersActorState();
			static_cast<LoadTestParametersActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 207 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(1.0);
															#line 207 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (static_cast<LoadTestParametersActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 331 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<LoadTestParametersActor*>(this)->actor_wait_state = 2;
															#line 207 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LoadTestParametersActor, 1, Void >*>(static_cast<LoadTestParametersActor*>(this)));
															#line 336 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && val,int loopDepth) 
	{
															#line 202 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (val.present())
															#line 345 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		{
															#line 203 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			TestParameters params = TestParameters::decode(val.get());
															#line 204 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			self->useMetacluster = params.useMetacluster;
															#line 205 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (!static_cast<LoadTestParametersActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LoadTestParametersActorState(); static_cast<LoadTestParametersActor*>(this)->destroy(); return 0; }
															#line 353 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			new (&static_cast<LoadTestParametersActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~LoadTestParametersActorState();
			static_cast<LoadTestParametersActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 207 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(1.0);
															#line 207 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (static_cast<LoadTestParametersActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 363 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<LoadTestParametersActor*>(this)->actor_wait_state = 2;
															#line 207 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LoadTestParametersActor, 1, Void >*>(static_cast<LoadTestParametersActor*>(this)));
															#line 368 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(val, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LoadTestParametersActor*>(this)->actor_wait_state > 0) static_cast<LoadTestParametersActor*>(this)->actor_wait_state = 0;
		static_cast<LoadTestParametersActor*>(this)->ActorCallback< LoadTestParametersActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< LoadTestParametersActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("loadTestParameters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadTestParametersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadTestParameters", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LoadTestParametersActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("loadTestParameters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadTestParametersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadTestParameters", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LoadTestParametersActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("loadTestParameters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadTestParametersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadTestParameters", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 208 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		tr.reset();
															#line 452 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 208 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		tr.reset();
															#line 461 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<LoadTestParametersActor*>(this)->actor_wait_state > 0) static_cast<LoadTestParametersActor*>(this)->actor_wait_state = 0;
		static_cast<LoadTestParametersActor*>(this)->ActorCallback< LoadTestParametersActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadTestParametersActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadTestParameters", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadTestParametersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadTestParameters", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< LoadTestParametersActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadTestParameters", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadTestParametersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadTestParameters", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< LoadTestParametersActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadTestParameters", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadTestParametersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadTestParameters", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<LoadTestParametersActor*>(this)->actor_wait_state > 0) static_cast<LoadTestParametersActor*>(this)->actor_wait_state = 0;
		static_cast<LoadTestParametersActor*>(this)->ActorCallback< LoadTestParametersActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadTestParametersActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadTestParameters", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadTestParametersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadTestParameters", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< LoadTestParametersActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadTestParameters", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadTestParametersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadTestParameters", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< LoadTestParametersActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadTestParameters", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadTestParametersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadTestParameters", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 195 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	Database cx;
															#line 195 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	TenantManagementWorkload* self;
															#line 196 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	Transaction tr;
															#line 647 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
};
// This generated class is to be used only via loadTestParameters()
															#line 195 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
class LoadTestParametersActor final : public Actor<Void>, public ActorCallback< LoadTestParametersActor, 0, Optional<Value> >, public ActorCallback< LoadTestParametersActor, 1, Void >, public ActorCallback< LoadTestParametersActor, 2, Void >, public FastAllocated<LoadTestParametersActor>, public LoadTestParametersActorState<LoadTestParametersActor> {
															#line 652 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
public:
	using FastAllocated<LoadTestParametersActor>::operator new;
	using FastAllocated<LoadTestParametersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2087989046656669440UL, 10900383826496648960UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LoadTestParametersActor, 0, Optional<Value> >;
friend struct ActorCallback< LoadTestParametersActor, 1, Void >;
friend struct ActorCallback< LoadTestParametersActor, 2, Void >;
															#line 195 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	LoadTestParametersActor(Database const& cx,TenantManagementWorkload* const& self) 
															#line 671 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   LoadTestParametersActorState<LoadTestParametersActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("loadTestParameters", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5470466161371688448UL, 15424079043858701312UL);
		ActorExecutionContextHelper __helper(static_cast<LoadTestParametersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("loadTestParameters");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("loadTestParameters", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LoadTestParametersActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< LoadTestParametersActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< LoadTestParametersActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 195 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
[[nodiscard]] static Future<Void> loadTestParameters( Database const& cx, TenantManagementWorkload* const& self ) {
															#line 195 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	return Future<Void>(new LoadTestParametersActor(cx, self));
															#line 705 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
}

#line 214 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"

	// send test parameters from metacluster
																#line 711 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
// This generated class is to be used only via sendTestParameters()
															#line 216 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
template <class SendTestParametersActor>
															#line 216 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
class SendTestParametersActorState {
															#line 717 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
public:
															#line 216 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	SendTestParametersActorState(Database const& cx,TenantManagementWorkload* const& self) 
															#line 216 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
															#line 216 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		 : cx(cx),
															#line 216 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   self(self)
															#line 726 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("sendTestParameters", reinterpret_cast<unsigned long>(this));

	}
	~SendTestParametersActorState() 
	{
		fdb_probe_actor_destroy("sendTestParameters", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 218 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			fmt::print("Sending test parameters ...\n");
															#line 219 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			tr = Transaction(cx);
															#line 220 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			;
															#line 745 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SendTestParametersActorState();
		static_cast<SendTestParametersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 230 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (!static_cast<SendTestParametersActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SendTestParametersActorState(); static_cast<SendTestParametersActor*>(this)->destroy(); return 0; }
															#line 768 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		new (&static_cast<SendTestParametersActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SendTestParametersActorState();
		static_cast<SendTestParametersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 222 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			tr.setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 223 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			tr.set(self->testParametersKey, TestParameters(self->useMetacluster).encode());
															#line 224 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 224 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (static_cast<SendTestParametersActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 794 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SendTestParametersActor*>(this)->actor_wait_state = 1;
															#line 224 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SendTestParametersActor, 0, Void >*>(static_cast<SendTestParametersActor*>(this)));
															#line 799 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 227 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 227 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (static_cast<SendTestParametersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 836 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<SendTestParametersActor*>(this)->actor_wait_state = 2;
															#line 227 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SendTestParametersActor, 1, Void >*>(static_cast<SendTestParametersActor*>(this)));
															#line 841 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SendTestParametersActor*>(this)->actor_wait_state > 0) static_cast<SendTestParametersActor*>(this)->actor_wait_state = 0;
		static_cast<SendTestParametersActor*>(this)->ActorCallback< SendTestParametersActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SendTestParametersActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("sendTestParameters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SendTestParametersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendTestParameters", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SendTestParametersActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("sendTestParameters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SendTestParametersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendTestParameters", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SendTestParametersActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("sendTestParameters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SendTestParametersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendTestParameters", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SendTestParametersActor*>(this)->actor_wait_state > 0) static_cast<SendTestParametersActor*>(this)->actor_wait_state = 0;
		static_cast<SendTestParametersActor*>(this)->ActorCallback< SendTestParametersActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SendTestParametersActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("sendTestParameters", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SendTestParametersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendTestParameters", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SendTestParametersActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("sendTestParameters", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SendTestParametersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendTestParameters", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SendTestParametersActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("sendTestParameters", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SendTestParametersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendTestParameters", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 216 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	Database cx;
															#line 216 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	TenantManagementWorkload* self;
															#line 219 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	Transaction tr;
															#line 1032 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
};
// This generated class is to be used only via sendTestParameters()
															#line 216 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
class SendTestParametersActor final : public Actor<Void>, public ActorCallback< SendTestParametersActor, 0, Void >, public ActorCallback< SendTestParametersActor, 1, Void >, public FastAllocated<SendTestParametersActor>, public SendTestParametersActorState<SendTestParametersActor> {
															#line 1037 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
public:
	using FastAllocated<SendTestParametersActor>::operator new;
	using FastAllocated<SendTestParametersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15968961027913587200UL, 4276734397102969856UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SendTestParametersActor, 0, Void >;
friend struct ActorCallback< SendTestParametersActor, 1, Void >;
															#line 216 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	SendTestParametersActor(Database const& cx,TenantManagementWorkload* const& self) 
															#line 1055 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   SendTestParametersActorState<SendTestParametersActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("sendTestParameters", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12919494679499865856UL, 10534791905691478528UL);
		ActorExecutionContextHelper __helper(static_cast<SendTestParametersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("sendTestParameters");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("sendTestParameters", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SendTestParametersActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SendTestParametersActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 216 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
[[nodiscard]] static Future<Void> sendTestParameters( Database const& cx, TenantManagementWorkload* const& self ) {
															#line 216 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	return Future<Void>(new SendTestParametersActor(cx, self));
															#line 1088 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
}

#line 232 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"

	// only the first client will do this setup
																#line 1094 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
// This generated class is to be used only via firstClientSetup()
															#line 234 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
template <class FirstClientSetupActor>
															#line 234 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
class FirstClientSetupActorState {
															#line 1100 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
public:
															#line 234 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	FirstClientSetupActorState(Database const& cx,TenantManagementWorkload* const& self) 
															#line 234 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
															#line 234 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		 : cx(cx),
															#line 234 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   self(self)
															#line 1109 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("firstClientSetup", reinterpret_cast<unsigned long>(this));

	}
	~FirstClientSetupActorState() 
	{
		fdb_probe_actor_destroy("firstClientSetup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 235 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = sendTestParameters(cx, self);
															#line 235 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (static_cast<FirstClientSetupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1126 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FirstClientSetupActor*>(this)->actor_wait_state = 1;
															#line 235 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FirstClientSetupActor, 0, Void >*>(static_cast<FirstClientSetupActor*>(this)));
															#line 1131 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FirstClientSetupActorState();
		static_cast<FirstClientSetupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 237 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (self->dataDb->getTenantMode() != TenantMode::REQUIRED)
															#line 1154 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		{
															#line 238 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			self->hasNoTenantKey = true;
															#line 239 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_1 = self->writeNonTenantKey();
															#line 239 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (static_cast<FirstClientSetupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1162 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<FirstClientSetupActor*>(this)->actor_wait_state = 2;
															#line 239 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FirstClientSetupActor, 1, Void >*>(static_cast<FirstClientSetupActor*>(this)));
															#line 1167 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 237 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (self->dataDb->getTenantMode() != TenantMode::REQUIRED)
															#line 1181 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		{
															#line 238 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			self->hasNoTenantKey = true;
															#line 239 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_1 = self->writeNonTenantKey();
															#line 239 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (static_cast<FirstClientSetupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1189 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<FirstClientSetupActor*>(this)->actor_wait_state = 2;
															#line 239 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FirstClientSetupActor, 1, Void >*>(static_cast<FirstClientSetupActor*>(this)));
															#line 1194 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FirstClientSetupActor*>(this)->actor_wait_state > 0) static_cast<FirstClientSetupActor*>(this)->actor_wait_state = 0;
		static_cast<FirstClientSetupActor*>(this)->ActorCallback< FirstClientSetupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FirstClientSetupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("firstClientSetup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FirstClientSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("firstClientSetup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FirstClientSetupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("firstClientSetup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FirstClientSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("firstClientSetup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FirstClientSetupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("firstClientSetup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FirstClientSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("firstClientSetup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 241 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (!static_cast<FirstClientSetupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FirstClientSetupActorState(); static_cast<FirstClientSetupActor*>(this)->destroy(); return 0; }
															#line 1283 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		new (&static_cast<FirstClientSetupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FirstClientSetupActorState();
		static_cast<FirstClientSetupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FirstClientSetupActor*>(this)->actor_wait_state > 0) static_cast<FirstClientSetupActor*>(this)->actor_wait_state = 0;
		static_cast<FirstClientSetupActor*>(this)->ActorCallback< FirstClientSetupActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FirstClientSetupActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("firstClientSetup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FirstClientSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("firstClientSetup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FirstClientSetupActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("firstClientSetup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FirstClientSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("firstClientSetup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FirstClientSetupActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("firstClientSetup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FirstClientSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("firstClientSetup", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 234 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	Database cx;
															#line 234 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	TenantManagementWorkload* self;
															#line 1382 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
};
// This generated class is to be used only via firstClientSetup()
															#line 234 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
class FirstClientSetupActor final : public Actor<Void>, public ActorCallback< FirstClientSetupActor, 0, Void >, public ActorCallback< FirstClientSetupActor, 1, Void >, public FastAllocated<FirstClientSetupActor>, public FirstClientSetupActorState<FirstClientSetupActor> {
															#line 1387 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
public:
	using FastAllocated<FirstClientSetupActor>::operator new;
	using FastAllocated<FirstClientSetupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15490338372611988224UL, 15939158525746719232UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FirstClientSetupActor, 0, Void >;
friend struct ActorCallback< FirstClientSetupActor, 1, Void >;
															#line 234 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	FirstClientSetupActor(Database const& cx,TenantManagementWorkload* const& self) 
															#line 1405 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   FirstClientSetupActorState<FirstClientSetupActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("firstClientSetup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18324989659266792704UL, 2512103243084033536UL);
		ActorExecutionContextHelper __helper(static_cast<FirstClientSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("firstClientSetup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("firstClientSetup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FirstClientSetupActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FirstClientSetupActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 234 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
[[nodiscard]] static Future<Void> firstClientSetup( Database const& cx, TenantManagementWorkload* const& self ) {
															#line 234 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	return Future<Void>(new FirstClientSetupActor(cx, self));
															#line 1438 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
}

#line 243 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"

																#line 1443 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
// This generated class is to be used only via _setup()
															#line 244 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
template <class _setupActor>
															#line 244 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
class _setupActorState {
															#line 1449 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
public:
															#line 244 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	_setupActorState(Database const& cx,TenantManagementWorkload* const& self) 
															#line 244 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
															#line 244 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		 : cx(cx),
															#line 244 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   self(self)
															#line 1458 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("_setup", reinterpret_cast<unsigned long>(this));

	}
	~_setupActorState() 
	{
		fdb_probe_actor_destroy("_setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 245 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (self->clientId != 0)
															#line 1473 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			{
															#line 246 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				StrictFuture<Void> __when_expr_0 = loadTestParameters(cx, self);
															#line 246 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1479 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<_setupActor*>(this)->actor_wait_state = 1;
															#line 246 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 0, Void >*>(static_cast<_setupActor*>(this)));
															#line 1484 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 249 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		metacluster::util::SkipMetaclusterCreation skipMetaclusterCreation(!self->useMetacluster || self->clientId != 0);
															#line 251 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		Optional<metacluster::DataClusterEntry> entry;
															#line 252 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (!skipMetaclusterCreation)
															#line 1516 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		{
															#line 253 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			entry = metacluster::DataClusterEntry();
															#line 254 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			entry.get().capacity.numTenantGroups = 1e9;
															#line 1522 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		}
															#line 257 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		StrictFuture<metacluster::util::SimulatedMetacluster> __when_expr_1 = metacluster::util::createSimulatedMetacluster(cx, self->tenantIdPrefix, entry, skipMetaclusterCreation);
															#line 257 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1528 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_setupActor*>(this)->actor_wait_state = 2;
															#line 257 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 1, metacluster::util::SimulatedMetacluster >*>(static_cast<_setupActor*>(this)));
															#line 1533 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _setupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 260 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		self->mvDb = simMetacluster.managementDb;
															#line 262 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (self->useMetacluster)
															#line 1631 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		{
															#line 263 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			ASSERT_EQ(simMetacluster.dataDbs.size(), 1);
															#line 264 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			self->dataClusterName = simMetacluster.dataDbs.begin()->first;
															#line 265 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			self->dataDb = simMetacluster.dataDbs.begin()->second;
															#line 1639 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		}
		else
		{
															#line 267 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			self->dataDb = cx;
															#line 1645 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		}
															#line 270 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (self->clientId == 0)
															#line 1649 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		{
															#line 271 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_2 = firstClientSetup(cx, self);
															#line 271 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1655 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
			static_cast<_setupActor*>(this)->actor_wait_state = 3;
															#line 271 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 2, Void >*>(static_cast<_setupActor*>(this)));
															#line 1660 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(metacluster::util::SimulatedMetacluster const& __simMetacluster,int loopDepth) 
	{
															#line 257 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		simMetacluster = __simMetacluster;
															#line 1674 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(metacluster::util::SimulatedMetacluster && __simMetacluster,int loopDepth) 
	{
		simMetacluster = std::move(__simMetacluster);
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 1, metacluster::util::SimulatedMetacluster >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, metacluster::util::SimulatedMetacluster >*,metacluster::util::SimulatedMetacluster const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, metacluster::util::SimulatedMetacluster >*,metacluster::util::SimulatedMetacluster && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _setupActor, 1, metacluster::util::SimulatedMetacluster >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 274 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 1753 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _setupActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _setupActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 244 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	Database cx;
															#line 244 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	TenantManagementWorkload* self;
															#line 257 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	metacluster::util::SimulatedMetacluster simMetacluster;
															#line 1854 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
};
// This generated class is to be used only via _setup()
															#line 244 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
class _setupActor final : public Actor<Void>, public ActorCallback< _setupActor, 0, Void >, public ActorCallback< _setupActor, 1, metacluster::util::SimulatedMetacluster >, public ActorCallback< _setupActor, 2, Void >, public FastAllocated<_setupActor>, public _setupActorState<_setupActor> {
															#line 1859 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
public:
	using FastAllocated<_setupActor>::operator new;
	using FastAllocated<_setupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12366137417980201728UL, 5316551318843425792UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _setupActor, 0, Void >;
friend struct ActorCallback< _setupActor, 1, metacluster::util::SimulatedMetacluster >;
friend struct ActorCallback< _setupActor, 2, Void >;
															#line 244 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	_setupActor(Database const& cx,TenantManagementWorkload* const& self) 
															#line 1878 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   _setupActorState<_setupActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3044502327521131520UL, 13387266639422932480UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _setupActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _setupActor, 1, metacluster::util::SimulatedMetacluster >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _setupActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 244 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
[[nodiscard]] static Future<Void> _setup( Database const& cx, TenantManagementWorkload* const& self ) {
															#line 244 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	return Future<Void>(new _setupActor(cx, self));
															#line 1912 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
}

#line 276 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"

																#line 1917 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
// This generated class is to be used only via getLastTenantModification()
															#line 277 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
template <class DB, class GetLastTenantModificationActor>
															#line 277 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
class GetLastTenantModificationActorState {
															#line 1923 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
public:
															#line 277 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	GetLastTenantModificationActorState(Reference<DB> const& db,OperationType const& type) 
															#line 277 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
															#line 277 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		 : db(db),
															#line 277 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   type(type),
															#line 279 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   tr(db->createTransaction())
															#line 1934 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("getLastTenantModification", reinterpret_cast<unsigned long>(this));

	}
	~GetLastTenantModificationActorState() 
	{
		fdb_probe_actor_destroy("getLastTenantModification", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 280 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			;
															#line 1949 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetLastTenantModificationActorState();
		static_cast<GetLastTenantModificationActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 282 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 283 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (type == OperationType::METACLUSTER)
															#line 1982 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			{
															#line 284 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				StrictFuture<Versionstamp> __when_expr_0 = metacluster::metadata::management::tenantMetadata().lastTenantModification.getD( tr, Snapshot::False, Versionstamp());
															#line 284 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				if (static_cast<GetLastTenantModificationActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1988 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetLastTenantModificationActor*>(this)->actor_wait_state = 1;
															#line 284 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetLastTenantModificationActor, 0, Versionstamp >*>(static_cast<GetLastTenantModificationActor*>(this)));
															#line 1993 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1cont2(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 293 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_2 = safeThreadFutureToFuture(tr->onError(e));
															#line 293 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (static_cast<GetLastTenantModificationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2022 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<GetLastTenantModificationActor*>(this)->actor_wait_state = 3;
															#line 293 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetLastTenantModificationActor, 2, Void >*>(static_cast<GetLastTenantModificationActor*>(this)));
															#line 2027 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 289 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		StrictFuture<Versionstamp> __when_expr_1 = TenantMetadata::lastTenantModification().getD(tr, Snapshot::False, Versionstamp());
															#line 289 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (static_cast<GetLastTenantModificationActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2044 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetLastTenantModificationActor*>(this)->actor_wait_state = 2;
															#line 289 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetLastTenantModificationActor, 1, Versionstamp >*>(static_cast<GetLastTenantModificationActor*>(this)));
															#line 2049 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Versionstamp const& vs,int loopDepth) 
	{
															#line 287 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (!static_cast<GetLastTenantModificationActor*>(this)->SAV<Versionstamp>::futures) { (void)(vs); this->~GetLastTenantModificationActorState(); static_cast<GetLastTenantModificationActor*>(this)->destroy(); return 0; }
															#line 2058 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		new (&static_cast<GetLastTenantModificationActor*>(this)->SAV< Versionstamp >::value()) Versionstamp(vs);
		this->~GetLastTenantModificationActorState();
		static_cast<GetLastTenantModificationActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Versionstamp && vs,int loopDepth) 
	{
															#line 287 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (!static_cast<GetLastTenantModificationActor*>(this)->SAV<Versionstamp>::futures) { (void)(vs); this->~GetLastTenantModificationActorState(); static_cast<GetLastTenantModificationActor*>(this)->destroy(); return 0; }
															#line 2070 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		new (&static_cast<GetLastTenantModificationActor*>(this)->SAV< Versionstamp >::value()) Versionstamp(vs);
		this->~GetLastTenantModificationActorState();
		static_cast<GetLastTenantModificationActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Versionstamp const& vs,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(vs, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Versionstamp && vs,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(vs), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetLastTenantModificationActor*>(this)->actor_wait_state > 0) static_cast<GetLastTenantModificationActor*>(this)->actor_wait_state = 0;
		static_cast<GetLastTenantModificationActor*>(this)->ActorCallback< GetLastTenantModificationActor, 0, Versionstamp >::remove();

	}
	void a_callback_fire(ActorCallback< GetLastTenantModificationActor, 0, Versionstamp >*,Versionstamp const& value) 
	{
		fdb_probe_actor_enter("getLastTenantModification", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLastTenantModificationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLastTenantModification", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetLastTenantModificationActor, 0, Versionstamp >*,Versionstamp && value) 
	{
		fdb_probe_actor_enter("getLastTenantModification", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLastTenantModificationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLastTenantModification", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetLastTenantModificationActor, 0, Versionstamp >*,Error err) 
	{
		fdb_probe_actor_enter("getLastTenantModification", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetLastTenantModificationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLastTenantModification", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont5(Versionstamp const& vs,int loopDepth) 
	{
															#line 291 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (!static_cast<GetLastTenantModificationActor*>(this)->SAV<Versionstamp>::futures) { (void)(vs); this->~GetLastTenantModificationActorState(); static_cast<GetLastTenantModificationActor*>(this)->destroy(); return 0; }
															#line 2157 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		new (&static_cast<GetLastTenantModificationActor*>(this)->SAV< Versionstamp >::value()) Versionstamp(vs);
		this->~GetLastTenantModificationActorState();
		static_cast<GetLastTenantModificationActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5(Versionstamp && vs,int loopDepth) 
	{
															#line 291 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (!static_cast<GetLastTenantModificationActor*>(this)->SAV<Versionstamp>::futures) { (void)(vs); this->~GetLastTenantModificationActorState(); static_cast<GetLastTenantModificationActor*>(this)->destroy(); return 0; }
															#line 2169 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		new (&static_cast<GetLastTenantModificationActor*>(this)->SAV< Versionstamp >::value()) Versionstamp(vs);
		this->~GetLastTenantModificationActorState();
		static_cast<GetLastTenantModificationActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Versionstamp const& vs,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(vs, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Versionstamp && vs,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(vs), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetLastTenantModificationActor*>(this)->actor_wait_state > 0) static_cast<GetLastTenantModificationActor*>(this)->actor_wait_state = 0;
		static_cast<GetLastTenantModificationActor*>(this)->ActorCallback< GetLastTenantModificationActor, 1, Versionstamp >::remove();

	}
	void a_callback_fire(ActorCallback< GetLastTenantModificationActor, 1, Versionstamp >*,Versionstamp const& value) 
	{
		fdb_probe_actor_enter("getLastTenantModification", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLastTenantModificationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLastTenantModification", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetLastTenantModificationActor, 1, Versionstamp >*,Versionstamp && value) 
	{
		fdb_probe_actor_enter("getLastTenantModification", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLastTenantModificationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLastTenantModification", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetLastTenantModificationActor, 1, Versionstamp >*,Error err) 
	{
		fdb_probe_actor_enter("getLastTenantModification", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetLastTenantModificationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLastTenantModification", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetLastTenantModificationActor*>(this)->actor_wait_state > 0) static_cast<GetLastTenantModificationActor*>(this)->actor_wait_state = 0;
		static_cast<GetLastTenantModificationActor*>(this)->ActorCallback< GetLastTenantModificationActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetLastTenantModificationActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getLastTenantModification", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLastTenantModificationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLastTenantModification", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetLastTenantModificationActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getLastTenantModification", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLastTenantModificationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLastTenantModification", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetLastTenantModificationActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getLastTenantModification", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetLastTenantModificationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLastTenantModification", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 277 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	Reference<DB> db;
															#line 277 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	OperationType type;
															#line 279 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	Reference<typename DB::TransactionT> tr;
															#line 2345 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
};
// This generated class is to be used only via getLastTenantModification()
															#line 277 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
template <class DB>
															#line 277 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
class GetLastTenantModificationActor final : public Actor<Versionstamp>, public ActorCallback< GetLastTenantModificationActor<DB>, 0, Versionstamp >, public ActorCallback< GetLastTenantModificationActor<DB>, 1, Versionstamp >, public ActorCallback< GetLastTenantModificationActor<DB>, 2, Void >, public FastAllocated<GetLastTenantModificationActor<DB>>, public GetLastTenantModificationActorState<DB, GetLastTenantModificationActor<DB>> {
															#line 2352 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
public:
	using FastAllocated<GetLastTenantModificationActor<DB>>::operator new;
	using FastAllocated<GetLastTenantModificationActor<DB>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2180916500294045696UL, 10424553361257912320UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Versionstamp>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetLastTenantModificationActor<DB>, 0, Versionstamp >;
friend struct ActorCallback< GetLastTenantModificationActor<DB>, 1, Versionstamp >;
friend struct ActorCallback< GetLastTenantModificationActor<DB>, 2, Void >;
															#line 277 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	GetLastTenantModificationActor(Reference<DB> const& db,OperationType const& type) 
															#line 2371 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		 : Actor<Versionstamp>(),
		   GetLastTenantModificationActorState<DB, GetLastTenantModificationActor<DB>>(db, type),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getLastTenantModification", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15589244338514320384UL, 1643519844806692352UL);
		ActorExecutionContextHelper __helper(static_cast<GetLastTenantModificationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getLastTenantModification");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getLastTenantModification", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetLastTenantModificationActor<DB>, 0, Versionstamp >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetLastTenantModificationActor<DB>, 1, Versionstamp >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetLastTenantModificationActor<DB>, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 277 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
template <class DB>
															#line 277 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
[[nodiscard]] static Future<Versionstamp> getLastTenantModification( Reference<DB> const& db, OperationType const& type ) {
															#line 277 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	return Future<Versionstamp>(new GetLastTenantModificationActor<DB>(db, type));
															#line 2407 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
}

#line 297 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"

																#line 2412 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
// This generated class is to be used only via getLatestReadVersion()
															#line 298 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
template <class DB, class GetLatestReadVersionActor>
															#line 298 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
class GetLatestReadVersionActorState {
															#line 2418 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
public:
															#line 298 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	GetLatestReadVersionActorState(Reference<DB> const& db,OperationType const& type) 
															#line 298 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
															#line 298 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		 : db(db),
															#line 298 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   type(type),
															#line 300 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   tr(db->createTransaction())
															#line 2429 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("getLatestReadVersion", reinterpret_cast<unsigned long>(this));

	}
	~GetLatestReadVersionActorState() 
	{
		fdb_probe_actor_destroy("getLatestReadVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 301 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			;
															#line 2444 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetLatestReadVersionActorState();
		static_cast<GetLatestReadVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 303 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			StrictFuture<Version> __when_expr_0 = safeThreadFutureToFuture(tr->getReadVersion());
															#line 303 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (static_cast<GetLatestReadVersionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2477 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetLatestReadVersionActor*>(this)->actor_wait_state = 1;
															#line 303 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetLatestReadVersionActor, 0, Version >*>(static_cast<GetLatestReadVersionActor*>(this)));
															#line 2482 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 306 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->onError(e));
															#line 306 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (static_cast<GetLatestReadVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2506 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetLatestReadVersionActor*>(this)->actor_wait_state = 2;
															#line 306 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetLatestReadVersionActor, 1, Void >*>(static_cast<GetLatestReadVersionActor*>(this)));
															#line 2511 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version const& readVersion,int loopDepth) 
	{
															#line 304 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (!static_cast<GetLatestReadVersionActor*>(this)->SAV<Version>::futures) { (void)(readVersion); this->~GetLatestReadVersionActorState(); static_cast<GetLatestReadVersionActor*>(this)->destroy(); return 0; }
															#line 2526 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		new (&static_cast<GetLatestReadVersionActor*>(this)->SAV< Version >::value()) Version(readVersion);
		this->~GetLatestReadVersionActorState();
		static_cast<GetLatestReadVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version && readVersion,int loopDepth) 
	{
															#line 304 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (!static_cast<GetLatestReadVersionActor*>(this)->SAV<Version>::futures) { (void)(readVersion); this->~GetLatestReadVersionActorState(); static_cast<GetLatestReadVersionActor*>(this)->destroy(); return 0; }
															#line 2538 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		new (&static_cast<GetLatestReadVersionActor*>(this)->SAV< Version >::value()) Version(readVersion);
		this->~GetLatestReadVersionActorState();
		static_cast<GetLatestReadVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Version const& readVersion,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(readVersion, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Version && readVersion,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(readVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetLatestReadVersionActor*>(this)->actor_wait_state > 0) static_cast<GetLatestReadVersionActor*>(this)->actor_wait_state = 0;
		static_cast<GetLatestReadVersionActor*>(this)->ActorCallback< GetLatestReadVersionActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< GetLatestReadVersionActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("getLatestReadVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLatestReadVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLatestReadVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetLatestReadVersionActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("getLatestReadVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLatestReadVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLatestReadVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetLatestReadVersionActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("getLatestReadVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetLatestReadVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLatestReadVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetLatestReadVersionActor*>(this)->actor_wait_state > 0) static_cast<GetLatestReadVersionActor*>(this)->actor_wait_state = 0;
		static_cast<GetLatestReadVersionActor*>(this)->ActorCallback< GetLatestReadVersionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetLatestReadVersionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getLatestReadVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLatestReadVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLatestReadVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetLatestReadVersionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getLatestReadVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLatestReadVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLatestReadVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetLatestReadVersionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getLatestReadVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetLatestReadVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLatestReadVersion", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 298 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	Reference<DB> db;
															#line 298 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	OperationType type;
															#line 300 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	Reference<typename DB::TransactionT> tr;
															#line 2714 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
};
// This generated class is to be used only via getLatestReadVersion()
															#line 298 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
template <class DB>
															#line 298 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
class GetLatestReadVersionActor final : public Actor<Version>, public ActorCallback< GetLatestReadVersionActor<DB>, 0, Version >, public ActorCallback< GetLatestReadVersionActor<DB>, 1, Void >, public FastAllocated<GetLatestReadVersionActor<DB>>, public GetLatestReadVersionActorState<DB, GetLatestReadVersionActor<DB>> {
															#line 2721 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
public:
	using FastAllocated<GetLatestReadVersionActor<DB>>::operator new;
	using FastAllocated<GetLatestReadVersionActor<DB>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15657539559169133312UL, 6828211502698639104UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetLatestReadVersionActor<DB>, 0, Version >;
friend struct ActorCallback< GetLatestReadVersionActor<DB>, 1, Void >;
															#line 298 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	GetLatestReadVersionActor(Reference<DB> const& db,OperationType const& type) 
															#line 2739 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		 : Actor<Version>(),
		   GetLatestReadVersionActorState<DB, GetLatestReadVersionActor<DB>>(db, type),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getLatestReadVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8866154676546024192UL, 7536349278348617472UL);
		ActorExecutionContextHelper __helper(static_cast<GetLatestReadVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getLatestReadVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getLatestReadVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetLatestReadVersionActor<DB>, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetLatestReadVersionActor<DB>, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 298 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
template <class DB>
															#line 298 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
[[nodiscard]] static Future<Version> getLatestReadVersion( Reference<DB> const& db, OperationType const& type ) {
															#line 298 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	return Future<Version>(new GetLatestReadVersionActor<DB>(db, type));
															#line 2774 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
}

#line 310 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"

	static Future<Versionstamp> getLastTenantModification(TenantManagementWorkload* self, OperationType type) {
		if (type == OperationType::METACLUSTER) {
			return getLastTenantModification(self->mvDb, type);
		} else {
			return getLastTenantModification(self->dataDb.getReference(), type);
		}
	}

	static Future<Version> getLatestReadVersion(TenantManagementWorkload* self, OperationType type) {
		if (type == OperationType::METACLUSTER) {
			return getLatestReadVersion(self->mvDb, type);
		} else {
			return getLatestReadVersion(self->dataDb.getReference(), type);
		}
	}

	TenantName chooseTenantName(bool allowSystemTenant) {
		TenantName tenant(format(
		    "%s%08d", localTenantNamePrefix.toString().c_str(), deterministicRandom()->randomInt(0, maxTenants)));
		if (allowSystemTenant && deterministicRandom()->random01() < 0.02) {
			tenant = tenant.withPrefix("\xff"_sr);
		}

		return tenant;
	}

	Optional<TenantGroupName> chooseTenantGroup(bool allowSystemTenantGroup, bool allowEmptyGroup = true) {
		Optional<TenantGroupName> tenantGroup;
		if (!allowEmptyGroup || deterministicRandom()->coinflip()) {
			tenantGroup = TenantGroupNameRef(format("%s%08d",
			                                        localTenantGroupNamePrefix.toString().c_str(),
			                                        deterministicRandom()->randomInt(0, maxTenantGroups)));
			if (allowSystemTenantGroup && deterministicRandom()->random01() < 0.02) {
				tenantGroup = tenantGroup.get().withPrefix("\xff"_sr);
			}
		}

		return tenantGroup;
	}

	// Creates tenant(s) using the specified operation type
																#line 2820 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
// This generated class is to be used only via createTenantImpl()
															#line 352 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
template <class CreateTenantImplActor>
															#line 352 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
class CreateTenantImplActorState {
															#line 2826 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
public:
															#line 352 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	CreateTenantImplActorState(Reference<ReadYourWritesTransaction> const& tr,std::map<TenantName, TenantMapEntry> const& tenantsToCreate,OperationType const& operationType,TenantManagementWorkload* const& self) 
															#line 352 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
															#line 352 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		 : tr(tr),
															#line 352 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   tenantsToCreate(tenantsToCreate),
															#line 352 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   operationType(operationType),
															#line 352 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   self(self),
															#line 356 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   entry(),
															#line 357 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   assign(metacluster::AssignClusterAutomatically::True),
															#line 358 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   ignoreCapacityLimit(deterministicRandom()->coinflip())
															#line 2845 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("createTenantImpl", reinterpret_cast<unsigned long>(this));

	}
	~CreateTenantImplActorState() 
	{
		fdb_probe_actor_destroy("createTenantImpl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 360 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (operationType == OperationType::SPECIAL_KEYS)
															#line 2860 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			{
															#line 361 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				tr->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 362 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				for( auto [tenant, entry] : tenantsToCreate ) {
															#line 363 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					tr->set(self->specialKeysTenantMapPrefix.withSuffix(tenant), ""_sr);
															#line 364 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					if (entry.tenantGroup.present())
															#line 2870 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					{
															#line 365 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						tr->set(self->specialKeysTenantConfigPrefix.withSuffix( Tuple::makeTuple(tenant, "tenant_group"_sr).pack()), entry.tenantGroup.get());
															#line 2874 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					}
				}
															#line 370 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				StrictFuture<Void> __when_expr_0 = tr->commit();
															#line 370 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				if (static_cast<CreateTenantImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2881 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<CreateTenantImplActor*>(this)->actor_wait_state = 1;
															#line 370 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CreateTenantImplActor, 0, Void >*>(static_cast<CreateTenantImplActor*>(this)));
															#line 2886 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 371 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				if (operationType == OperationType::MANAGEMENT_DATABASE)
															#line 2893 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				{
															#line 372 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					ASSERT(tenantsToCreate.size() == 1);
															#line 373 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					StrictFuture<Void> __when_expr_1 = success(TenantAPI::createTenant( self->dataDb.getReference(), tenantsToCreate.begin()->first, tenantsToCreate.begin()->second));
															#line 373 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					if (static_cast<CreateTenantImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2901 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
					static_cast<CreateTenantImplActor*>(this)->actor_wait_state = 2;
															#line 373 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CreateTenantImplActor, 1, Void >*>(static_cast<CreateTenantImplActor*>(this)));
															#line 2906 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 375 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					if (operationType == OperationType::MANAGEMENT_TRANSACTION)
															#line 2913 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					{
															#line 376 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 377 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						StrictFuture<int64_t> __when_expr_2 = TenantAPI::getNextTenantId(tr);
															#line 377 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						if (static_cast<CreateTenantImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2921 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
						if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1when3(__when_expr_2.get(), loopDepth); };
						static_cast<CreateTenantImplActor*>(this)->actor_wait_state = 3;
															#line 377 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CreateTenantImplActor, 2, int64_t >*>(static_cast<CreateTenantImplActor*>(this)));
															#line 2926 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
						loopDepth = 0;
					}
					else
					{
															#line 389 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						ASSERT_EQ(operationType, OperationType::METACLUSTER);
															#line 390 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						ASSERT_EQ(tenantsToCreate.size(), 1);
															#line 391 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						entry = metacluster::MetaclusterTenantMapEntry::fromTenantMapEntry(tenantsToCreate.begin()->second);
															#line 392 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						if (deterministicRandom()->coinflip())
															#line 2939 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
						{
															#line 393 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
							entry.assignedCluster = self->dataClusterName;
															#line 394 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
							assign = metacluster::AssignClusterAutomatically::False;
															#line 2945 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
						}
						try {
															#line 398 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
							StrictFuture<Void> __when_expr_5 = metacluster::createTenant(self->mvDb, entry, assign, ignoreCapacityLimit);
															#line 398 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
							if (static_cast<CreateTenantImplActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 2952 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
							if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch2(__when_expr_5.getError(), loopDepth); else return a_body1when4(__when_expr_5.get(), loopDepth); };
							static_cast<CreateTenantImplActor*>(this)->actor_wait_state = 6;
															#line 398 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
							__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CreateTenantImplActor, 5, Void >*>(static_cast<CreateTenantImplActor*>(this)));
															#line 2957 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
							loopDepth = 0;
						}
						catch (Error& error) {
							loopDepth = a_body1Catch2(error, loopDepth);
						} catch (...) {
							loopDepth = a_body1Catch2(unknown_error(), loopDepth);
						}
					}
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CreateTenantImplActorState();
		static_cast<CreateTenantImplActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 409 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (!static_cast<CreateTenantImplActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CreateTenantImplActorState(); static_cast<CreateTenantImplActor*>(this)->destroy(); return 0; }
															#line 2989 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		new (&static_cast<CreateTenantImplActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CreateTenantImplActorState();
		static_cast<CreateTenantImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CreateTenantImplActor*>(this)->actor_wait_state > 0) static_cast<CreateTenantImplActor*>(this)->actor_wait_state = 0;
		static_cast<CreateTenantImplActor*>(this)->ActorCallback< CreateTenantImplActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CreateTenantImplActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("createTenantImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenantImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CreateTenantImplActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("createTenantImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenantImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CreateTenantImplActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("createTenantImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenantImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont5(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CreateTenantImplActor*>(this)->actor_wait_state > 0) static_cast<CreateTenantImplActor*>(this)->actor_wait_state = 0;
		static_cast<CreateTenantImplActor*>(this)->ActorCallback< CreateTenantImplActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CreateTenantImplActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("createTenantImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenantImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CreateTenantImplActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("createTenantImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenantImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CreateTenantImplActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("createTenantImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenantImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont7(int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(int64_t const& _nextId,int loopDepth) 
	{
															#line 378 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		int64_t nextId = _nextId;
															#line 380 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		std::vector<Future<Void>> createFutures;
															#line 381 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		for( auto [tenant, entry] : tenantsToCreate ) {
															#line 382 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			entry.setId(nextId++);
															#line 383 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			createFutures.push_back(success(TenantAPI::createTenantTransaction(tr, entry)));
															#line 3195 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		}
															#line 385 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		TenantMetadata::lastTenantId().set(tr, nextId - 1);
															#line 386 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_3 = waitForAll(createFutures);
															#line 386 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (static_cast<CreateTenantImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3203 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont8when1(__when_expr_3.get(), loopDepth); };
		static_cast<CreateTenantImplActor*>(this)->actor_wait_state = 4;
															#line 386 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CreateTenantImplActor, 3, Void >*>(static_cast<CreateTenantImplActor*>(this)));
															#line 3208 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8(int64_t && _nextId,int loopDepth) 
	{
															#line 378 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		int64_t nextId = _nextId;
															#line 380 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		std::vector<Future<Void>> createFutures;
															#line 381 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		for( auto [tenant, entry] : tenantsToCreate ) {
															#line 382 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			entry.setId(nextId++);
															#line 383 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			createFutures.push_back(success(TenantAPI::createTenantTransaction(tr, entry)));
															#line 3225 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		}
															#line 385 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		TenantMetadata::lastTenantId().set(tr, nextId - 1);
															#line 386 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_3 = waitForAll(createFutures);
															#line 386 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (static_cast<CreateTenantImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3233 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont8when1(__when_expr_3.get(), loopDepth); };
		static_cast<CreateTenantImplActor*>(this)->actor_wait_state = 4;
															#line 386 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CreateTenantImplActor, 3, Void >*>(static_cast<CreateTenantImplActor*>(this)));
															#line 3238 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when3(int64_t const& _nextId,int loopDepth) 
	{
		loopDepth = a_body1cont8(_nextId, loopDepth);

		return loopDepth;
	}
	int a_body1when3(int64_t && _nextId,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_nextId), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CreateTenantImplActor*>(this)->actor_wait_state > 0) static_cast<CreateTenantImplActor*>(this)->actor_wait_state = 0;
		static_cast<CreateTenantImplActor*>(this)->ActorCallback< CreateTenantImplActor, 2, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< CreateTenantImplActor, 2, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("createTenantImpl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenantImpl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CreateTenantImplActor, 2, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("createTenantImpl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenantImpl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CreateTenantImplActor, 2, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("createTenantImpl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenantImpl", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont9(Void const& _,int loopDepth) 
	{
															#line 387 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_4 = tr->commit();
															#line 387 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (static_cast<CreateTenantImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3324 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont9when1(__when_expr_4.get(), loopDepth); };
		static_cast<CreateTenantImplActor*>(this)->actor_wait_state = 5;
															#line 387 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CreateTenantImplActor, 4, Void >*>(static_cast<CreateTenantImplActor*>(this)));
															#line 3329 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9(Void && _,int loopDepth) 
	{
															#line 387 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_4 = tr->commit();
															#line 387 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (static_cast<CreateTenantImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3340 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont9when1(__when_expr_4.get(), loopDepth); };
		static_cast<CreateTenantImplActor*>(this)->actor_wait_state = 5;
															#line 387 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CreateTenantImplActor, 4, Void >*>(static_cast<CreateTenantImplActor*>(this)));
															#line 3345 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CreateTenantImplActor*>(this)->actor_wait_state > 0) static_cast<CreateTenantImplActor*>(this)->actor_wait_state = 0;
		static_cast<CreateTenantImplActor*>(this)->ActorCallback< CreateTenantImplActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CreateTenantImplActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("createTenantImpl", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenantImpl", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CreateTenantImplActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("createTenantImpl", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenantImpl", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CreateTenantImplActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("createTenantImpl", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenantImpl", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont11(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont11(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<CreateTenantImplActor*>(this)->actor_wait_state > 0) static_cast<CreateTenantImplActor*>(this)->actor_wait_state = 0;
		static_cast<CreateTenantImplActor*>(this)->ActorCallback< CreateTenantImplActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CreateTenantImplActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("createTenantImpl", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenantImpl", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< CreateTenantImplActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("createTenantImpl", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenantImpl", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< CreateTenantImplActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("createTenantImpl", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenantImpl", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont12(int loopDepth) 
	{
															#line 406 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (!static_cast<CreateTenantImplActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CreateTenantImplActorState(); static_cast<CreateTenantImplActor*>(this)->destroy(); return 0; }
															#line 3516 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		new (&static_cast<CreateTenantImplActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CreateTenantImplActorState();
		static_cast<CreateTenantImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 401 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (e.code() == error_code_invalid_tenant_configuration)
															#line 3529 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			{
															#line 402 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				ASSERT(assign && ignoreCapacityLimit);
															#line 3533 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			}
															#line 404 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 3537 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont14(Void const& _,int loopDepth) 
	{
															#line 399 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT(!assign || !ignoreCapacityLimit);
															#line 3551 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont14cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont14(Void && _,int loopDepth) 
	{
															#line 399 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT(!assign || !ignoreCapacityLimit);
															#line 3560 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont14cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14(_, loopDepth);

		return loopDepth;
	}
	int a_body1when4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<CreateTenantImplActor*>(this)->actor_wait_state > 0) static_cast<CreateTenantImplActor*>(this)->actor_wait_state = 0;
		static_cast<CreateTenantImplActor*>(this)->ActorCallback< CreateTenantImplActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CreateTenantImplActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("createTenantImpl", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenantImpl", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< CreateTenantImplActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("createTenantImpl", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenantImpl", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< CreateTenantImplActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("createTenantImpl", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenantImpl", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont14cont2(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont12(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 352 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 352 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	std::map<TenantName, TenantMapEntry> tenantsToCreate;
															#line 352 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	OperationType operationType;
															#line 352 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	TenantManagementWorkload* self;
															#line 356 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	metacluster::MetaclusterTenantMapEntry entry;
															#line 357 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	metacluster::AssignClusterAutomatically assign;
															#line 358 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	metacluster::IgnoreCapacityLimit ignoreCapacityLimit;
															#line 3667 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
};
// This generated class is to be used only via createTenantImpl()
															#line 352 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
class CreateTenantImplActor final : public Actor<Void>, public ActorCallback< CreateTenantImplActor, 0, Void >, public ActorCallback< CreateTenantImplActor, 1, Void >, public ActorCallback< CreateTenantImplActor, 2, int64_t >, public ActorCallback< CreateTenantImplActor, 3, Void >, public ActorCallback< CreateTenantImplActor, 4, Void >, public ActorCallback< CreateTenantImplActor, 5, Void >, public FastAllocated<CreateTenantImplActor>, public CreateTenantImplActorState<CreateTenantImplActor> {
															#line 3672 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
public:
	using FastAllocated<CreateTenantImplActor>::operator new;
	using FastAllocated<CreateTenantImplActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5000389047807875072UL, 5633521683926842880UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CreateTenantImplActor, 0, Void >;
friend struct ActorCallback< CreateTenantImplActor, 1, Void >;
friend struct ActorCallback< CreateTenantImplActor, 2, int64_t >;
friend struct ActorCallback< CreateTenantImplActor, 3, Void >;
friend struct ActorCallback< CreateTenantImplActor, 4, Void >;
friend struct ActorCallback< CreateTenantImplActor, 5, Void >;
															#line 352 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	CreateTenantImplActor(Reference<ReadYourWritesTransaction> const& tr,std::map<TenantName, TenantMapEntry> const& tenantsToCreate,OperationType const& operationType,TenantManagementWorkload* const& self) 
															#line 3694 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   CreateTenantImplActorState<CreateTenantImplActor>(tr, tenantsToCreate, operationType, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("createTenantImpl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11968175469740558080UL, 6402236568462905344UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("createTenantImpl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("createTenantImpl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CreateTenantImplActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CreateTenantImplActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CreateTenantImplActor, 2, int64_t >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CreateTenantImplActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< CreateTenantImplActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< CreateTenantImplActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 352 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
[[nodiscard]] static Future<Void> createTenantImpl( Reference<ReadYourWritesTransaction> const& tr, std::map<TenantName, TenantMapEntry> const& tenantsToCreate, OperationType const& operationType, TenantManagementWorkload* const& self ) {
															#line 352 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	return Future<Void>(new CreateTenantImplActor(tr, tenantsToCreate, operationType, self));
															#line 3731 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
}

#line 411 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"

																#line 3736 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
// This generated class is to be used only via verifyTenantCreate()
															#line 412 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
template <class TenantMapEntryImpl, class VerifyTenantCreateActor>
															#line 412 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
class VerifyTenantCreateActorState {
															#line 3742 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
public:
															#line 412 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	VerifyTenantCreateActorState(TenantManagementWorkload* const& self,Optional<TenantMapEntryImpl> const& entry,TenantName const& itrName,Optional<TenantGroupName> const& tGroup) 
															#line 412 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
															#line 412 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		 : self(self),
															#line 412 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   entry(entry),
															#line 412 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   itrName(itrName),
															#line 412 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   tGroup(tGroup)
															#line 3755 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("verifyTenantCreate", reinterpret_cast<unsigned long>(this));

	}
	~VerifyTenantCreateActorState() 
	{
		fdb_probe_actor_destroy("verifyTenantCreate", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 417 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			ASSERT(entry.present());
															#line 418 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			ASSERT(entry.get().id > self->maxId);
															#line 419 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			ASSERT(entry.get().tenantGroup == tGroup);
															#line 420 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			ASSERT(TenantAPI::getTenantIdPrefix(entry.get().id) == self->tenantIdPrefix);
															#line 422 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (self->useMetacluster)
															#line 3778 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			{
															#line 424 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				StrictFuture<Optional<TenantMapEntry>> __when_expr_0 = TenantAPI::tryGetTenant(self->dataDb.getReference(), itrName);
															#line 424 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				if (static_cast<VerifyTenantCreateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3784 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<VerifyTenantCreateActor*>(this)->actor_wait_state = 1;
															#line 424 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< VerifyTenantCreateActor, 0, Optional<TenantMapEntry> >*>(static_cast<VerifyTenantCreateActor*>(this)));
															#line 3789 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~VerifyTenantCreateActorState();
		static_cast<VerifyTenantCreateActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 432 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		self->maxId = entry.get().id;
															#line 433 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		TenantTestData tData = TenantTestData(entry.get().id, itrName, tGroup, true);
															#line 434 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		self->createdTenants[itrName] = tData;
															#line 435 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		self->allTestTenants.push_back(tData.tenant);
															#line 436 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (!static_cast<VerifyTenantCreateActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~VerifyTenantCreateActorState(); static_cast<VerifyTenantCreateActor*>(this)->destroy(); return 0; }
															#line 3825 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		new (&static_cast<VerifyTenantCreateActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~VerifyTenantCreateActorState();
		static_cast<VerifyTenantCreateActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Optional<TenantMapEntry> const& dataEntry,int loopDepth) 
	{
															#line 425 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT(dataEntry.present());
															#line 426 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT(dataEntry.get().id == entry.get().id);
															#line 427 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT(TenantAPI::getTenantIdPrefix(dataEntry.get().id) == self->tenantIdPrefix);
															#line 428 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT(dataEntry.get().tenantGroup == entry.get().tenantGroup);
															#line 3843 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Optional<TenantMapEntry> && dataEntry,int loopDepth) 
	{
															#line 425 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT(dataEntry.present());
															#line 426 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT(dataEntry.get().id == entry.get().id);
															#line 427 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT(TenantAPI::getTenantIdPrefix(dataEntry.get().id) == self->tenantIdPrefix);
															#line 428 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT(dataEntry.get().tenantGroup == entry.get().tenantGroup);
															#line 3858 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<TenantMapEntry> const& dataEntry,int loopDepth) 
	{
		loopDepth = a_body1cont2(dataEntry, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<TenantMapEntry> && dataEntry,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(dataEntry), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<VerifyTenantCreateActor*>(this)->actor_wait_state > 0) static_cast<VerifyTenantCreateActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyTenantCreateActor*>(this)->ActorCallback< VerifyTenantCreateActor, 0, Optional<TenantMapEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyTenantCreateActor, 0, Optional<TenantMapEntry> >*,Optional<TenantMapEntry> const& value) 
	{
		fdb_probe_actor_enter("verifyTenantCreate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyTenantCreateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyTenantCreate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< VerifyTenantCreateActor, 0, Optional<TenantMapEntry> >*,Optional<TenantMapEntry> && value) 
	{
		fdb_probe_actor_enter("verifyTenantCreate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyTenantCreateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyTenantCreate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< VerifyTenantCreateActor, 0, Optional<TenantMapEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("verifyTenantCreate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyTenantCreateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyTenantCreate", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 412 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	TenantManagementWorkload* self;
															#line 412 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	Optional<TenantMapEntryImpl> entry;
															#line 412 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	TenantName itrName;
															#line 412 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	Optional<TenantGroupName> tGroup;
															#line 3946 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
};
// This generated class is to be used only via verifyTenantCreate()
															#line 412 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
template <class TenantMapEntryImpl>
															#line 412 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
class VerifyTenantCreateActor final : public Actor<Void>, public ActorCallback< VerifyTenantCreateActor<TenantMapEntryImpl>, 0, Optional<TenantMapEntry> >, public FastAllocated<VerifyTenantCreateActor<TenantMapEntryImpl>>, public VerifyTenantCreateActorState<TenantMapEntryImpl, VerifyTenantCreateActor<TenantMapEntryImpl>> {
															#line 3953 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
public:
	using FastAllocated<VerifyTenantCreateActor<TenantMapEntryImpl>>::operator new;
	using FastAllocated<VerifyTenantCreateActor<TenantMapEntryImpl>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1947273903016299520UL, 8456909858497127424UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< VerifyTenantCreateActor<TenantMapEntryImpl>, 0, Optional<TenantMapEntry> >;
															#line 412 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	VerifyTenantCreateActor(TenantManagementWorkload* const& self,Optional<TenantMapEntryImpl> const& entry,TenantName const& itrName,Optional<TenantGroupName> const& tGroup) 
															#line 3970 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   VerifyTenantCreateActorState<TenantMapEntryImpl, VerifyTenantCreateActor<TenantMapEntryImpl>>(self, entry, itrName, tGroup),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("verifyTenantCreate", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16442480136445200384UL, 2484501263240481792UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyTenantCreateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("verifyTenantCreate");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("verifyTenantCreate", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< VerifyTenantCreateActor<TenantMapEntryImpl>, 0, Optional<TenantMapEntry> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 412 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
template <class TenantMapEntryImpl>
															#line 412 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
[[nodiscard]] static Future<Void> verifyTenantCreate( TenantManagementWorkload* const& self, Optional<TenantMapEntryImpl> const& entry, TenantName const& itrName, Optional<TenantGroupName> const& tGroup ) {
															#line 412 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	return Future<Void>(new VerifyTenantCreateActor<TenantMapEntryImpl>(self, entry, itrName, tGroup));
															#line 4004 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
}

#line 438 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"

																#line 4009 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
// This generated class is to be used only via createTenant()
															#line 439 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
template <class CreateTenantActor>
															#line 439 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
class CreateTenantActorState {
															#line 4015 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
public:
															#line 439 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	CreateTenantActorState(TenantManagementWorkload* const& self) 
															#line 439 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
															#line 439 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		 : self(self),
															#line 440 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   operationType(self->randomOperationType())
															#line 4024 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("createTenant", reinterpret_cast<unsigned long>(this));

	}
	~CreateTenantActorState() 
	{
		fdb_probe_actor_destroy("createTenant", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 441 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			int numTenants = 1;
															#line 444 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (operationType == OperationType::SPECIAL_KEYS || operationType == OperationType::MANAGEMENT_TRANSACTION)
															#line 4041 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			{
															#line 445 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				numTenants = deterministicRandom()->randomInt(1, 5);
															#line 4045 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			}
															#line 450 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			alreadyExists = false;
															#line 453 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			hasSystemTenant = false;
															#line 456 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			hasSystemTenantGroup = false;
															#line 458 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			newTenants = 0;
															#line 459 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			tenantsToCreate = std::map<TenantName, TenantMapEntry>();
															#line 460 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			for(int i = 0;i < numTenants;++i) {
															#line 461 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				TenantName tenant = self->chooseTenantName(true);
															#line 462 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				for(;tenantsToCreate.contains(tenant);) {
															#line 463 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					tenant = self->chooseTenantName(true);
															#line 4065 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				}
															#line 466 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				TenantMapEntry entry;
															#line 467 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				entry.tenantName = tenant;
															#line 468 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				entry.tenantGroup = self->chooseTenantGroup(true);
															#line 470 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				if (self->createdTenants.contains(tenant))
															#line 4075 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				{
															#line 471 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					alreadyExists = true;
															#line 4079 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				}
				else
				{
															#line 472 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					if (!tenantsToCreate.contains(tenant))
															#line 4085 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					{
															#line 473 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						++newTenants;
															#line 4089 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					}
				}
															#line 476 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				tenantsToCreate[tenant] = entry;
															#line 477 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				hasSystemTenant = hasSystemTenant || tenant.startsWith("\xff"_sr);
															#line 478 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				hasSystemTenantGroup = hasSystemTenantGroup || entry.tenantGroup.orDefault(""_sr).startsWith("\xff"_sr);
															#line 4098 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			}
															#line 483 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			existedAtStart = alreadyExists;
															#line 485 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			tr = makeReference<ReadYourWritesTransaction>(self->dataDb);
															#line 486 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			minTenantCount = std::numeric_limits<int64_t>::max();
															#line 487 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			finalTenantCount = 0;
															#line 489 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			StrictFuture<Version> __when_expr_0 = self->getLatestReadVersion(self, operationType);
															#line 489 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (static_cast<CreateTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4112 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CreateTenantActor*>(this)->actor_wait_state = 1;
															#line 489 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CreateTenantActor, 0, Version >*>(static_cast<CreateTenantActor*>(this)));
															#line 4117 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CreateTenantActorState();
		static_cast<CreateTenantActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 490 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		;
															#line 4140 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Version const& __originalReadVersion,int loopDepth) 
	{
															#line 489 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		originalReadVersion = __originalReadVersion;
															#line 4149 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Version && __originalReadVersion,int loopDepth) 
	{
		originalReadVersion = std::move(__originalReadVersion);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CreateTenantActor*>(this)->actor_wait_state > 0) static_cast<CreateTenantActor*>(this)->actor_wait_state = 0;
		static_cast<CreateTenantActor*>(this)->ActorCallback< CreateTenantActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CreateTenantActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 493 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			retried = false;
															#line 494 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			;
															#line 4238 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = a_body1cont1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 650 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (e.code() == error_code_invalid_tenant_name)
															#line 4260 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			{
															#line 651 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				ASSERT(hasSystemTenant);
															#line 652 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				if (!static_cast<CreateTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CreateTenantActorState(); static_cast<CreateTenantActor*>(this)->destroy(); return 0; }
															#line 4266 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				new (&static_cast<CreateTenantActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~CreateTenantActorState();
				static_cast<CreateTenantActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 653 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				if (e.code() == error_code_invalid_tenant_group_name)
															#line 4276 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				{
															#line 654 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					ASSERT(hasSystemTenantGroup);
															#line 655 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					if (!static_cast<CreateTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CreateTenantActorState(); static_cast<CreateTenantActor*>(this)->destroy(); return 0; }
															#line 4282 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					new (&static_cast<CreateTenantActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~CreateTenantActorState();
					static_cast<CreateTenantActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
				else
				{
															#line 656 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					if (e.code() == error_code_invalid_metacluster_operation)
															#line 4292 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					{
															#line 657 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						ASSERT(operationType == OperationType::METACLUSTER != self->useMetacluster);
															#line 658 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						if (!static_cast<CreateTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CreateTenantActorState(); static_cast<CreateTenantActor*>(this)->destroy(); return 0; }
															#line 4298 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
						new (&static_cast<CreateTenantActor*>(this)->SAV< Void >::value()) Void(Void());
						this->~CreateTenantActorState();
						static_cast<CreateTenantActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
					else
					{
															#line 659 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						if (e.code() == error_code_cluster_no_capacity)
															#line 4308 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
						{
															#line 662 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
							if (operationType == OperationType::MANAGEMENT_TRANSACTION || operationType == OperationType::SPECIAL_KEYS)
															#line 4312 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
							{
															#line 664 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
								ASSERT(finalTenantCount + newTenants > CLIENT_KNOBS->MAX_TENANTS_PER_CLUSTER);
															#line 4316 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
							}
															#line 666 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
							if (!static_cast<CreateTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CreateTenantActorState(); static_cast<CreateTenantActor*>(this)->destroy(); return 0; }
															#line 4320 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
							new (&static_cast<CreateTenantActor*>(this)->SAV< Void >::value()) Void(Void());
							this->~CreateTenantActorState();
							static_cast<CreateTenantActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
						else
						{
															#line 670 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
							if (operationType == OperationType::MANAGEMENT_DATABASE || operationType == OperationType::METACLUSTER)
															#line 4330 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
							{
															#line 672 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
								if (e.code() == error_code_tenant_already_exists)
															#line 4334 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
								{
															#line 673 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
									ASSERT(existedAtStart);
															#line 4338 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
								}
								else
								{
															#line 675 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
									ASSERT(tenantsToCreate.size() == 1);
															#line 676 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
									TraceEvent(SevError, "CreateTenantFailure") .errorUnsuppressed(e) .detail("TenantName", tenantsToCreate.begin()->first);
															#line 679 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
									ASSERT(false);
															#line 4348 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
								}
															#line 682 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
								if (!static_cast<CreateTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CreateTenantActorState(); static_cast<CreateTenantActor*>(this)->destroy(); return 0; }
															#line 4352 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
								new (&static_cast<CreateTenantActor*>(this)->SAV< Void >::value()) Void(Void());
								this->~CreateTenantActorState();
								static_cast<CreateTenantActor*>(this)->finishSendAndDelPromiseRef();
								return 0;
							}
							else
							{
								try {
															#line 688 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
									StrictFuture<Void> __when_expr_15 = tr->onError(e);
															#line 688 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
									if (static_cast<CreateTenantActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1Catch1(actor_cancelled(), loopDepth);
															#line 4365 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
									if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1cont1loopBody1Catch1Catch1(__when_expr_15.getError(), loopDepth); else return a_body1cont1loopBody1Catch1when1(__when_expr_15.get(), loopDepth); };
									static_cast<CreateTenantActor*>(this)->actor_wait_state = 16;
															#line 688 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
									__when_expr_15.addCallbackAndClear(static_cast<ActorCallback< CreateTenantActor, 15, Void >*>(static_cast<CreateTenantActor*>(this)));
															#line 4370 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
									loopDepth = 0;
								}
								catch (Error& error) {
									loopDepth = a_body1cont1loopBody1Catch1Catch1(error, loopDepth);
								} catch (...) {
									loopDepth = a_body1cont1loopBody1Catch1Catch1(unknown_error(), loopDepth);
								}
							}
						}
					}
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(int loopDepth) 
	{
															#line 567 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT(self->useMetacluster == (operationType == OperationType::METACLUSTER));
															#line 570 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (operationType == OperationType::MANAGEMENT_DATABASE || operationType == OperationType::METACLUSTER)
															#line 4398 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		{
															#line 572 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			ASSERT(!existedAtStart);
															#line 4402 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		}
															#line 576 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT(!hasSystemTenant);
															#line 577 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT(!hasSystemTenantGroup);
															#line 579 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		tenantItr = typename std::map<TenantName, TenantMapEntry>::iterator();
															#line 580 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		tenantItr = tenantsToCreate.begin();
															#line 4412 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1(int loopDepth) 
	{
															#line 495 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (operationType == OperationType::MANAGEMENT_TRANSACTION || operationType == OperationType::SPECIAL_KEYS)
															#line 4428 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		{
															#line 497 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 498 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_1 = store(finalTenantCount, TenantMetadata::tenantCount().getD(tr, Snapshot::False, 0));
															#line 498 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (static_cast<CreateTenantActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4436 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CreateTenantActor*>(this)->actor_wait_state = 2;
															#line 498 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CreateTenantActor, 1, Void >*>(static_cast<CreateTenantActor*>(this)));
															#line 4441 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(int loopDepth) 
	{
		try {
															#line 503 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			StrictFuture<Optional<Void>> __when_expr_2 = timeout(createTenantImpl(tr, tenantsToCreate, operationType, self), deterministicRandom()->randomInt(1, 30));
															#line 503 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (static_cast<CreateTenantActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 4471 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1loopBody1cont1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
			static_cast<CreateTenantActor*>(this)->actor_wait_state = 3;
															#line 503 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CreateTenantActor, 2, Optional<Void> >*>(static_cast<CreateTenantActor*>(this)));
															#line 4476 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 499 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		minTenantCount = std::min(finalTenantCount, minTenantCount);
															#line 4491 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 499 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		minTenantCount = std::min(finalTenantCount, minTenantCount);
															#line 4500 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CreateTenantActor*>(this)->actor_wait_state > 0) static_cast<CreateTenantActor*>(this)->actor_wait_state = 0;
		static_cast<CreateTenantActor*>(this)->ActorCallback< CreateTenantActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CreateTenantActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1loopBody1cont4(int loopDepth) 
	{
															#line 540 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (operationType == OperationType::METACLUSTER)
															#line 4584 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		{
															#line 541 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			StrictFuture<Optional<metacluster::MetaclusterTenantMapEntry>> __when_expr_3 = metacluster::tryGetTenant(self->mvDb, tenantsToCreate.begin()->first);
															#line 541 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (static_cast<CreateTenantActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4590 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1loopBody1cont4when1(__when_expr_3.get(), loopDepth); };
			static_cast<CreateTenantActor*>(this)->actor_wait_state = 4;
															#line 541 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CreateTenantActor, 3, Optional<metacluster::MetaclusterTenantMapEntry> >*>(static_cast<CreateTenantActor*>(this)));
															#line 4595 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 556 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			StrictFuture<Optional<TenantMapEntry>> __when_expr_4 = TenantAPI::tryGetTenant(self->dataDb.getReference(), tenantsToCreate.begin()->first);
															#line 556 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (static_cast<CreateTenantActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4604 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1loopBody1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1loopBody1cont4when2(__when_expr_4.get(), loopDepth); };
			static_cast<CreateTenantActor*>(this)->actor_wait_state = 5;
															#line 556 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CreateTenantActor, 4, Optional<TenantMapEntry> >*>(static_cast<CreateTenantActor*>(this)));
															#line 4609 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 527 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (e.code() == error_code_tenant_already_exists && !existedAtStart)
															#line 4620 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			{
															#line 528 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				ASSERT(operationType == OperationType::METACLUSTER || operationType == OperationType::MANAGEMENT_DATABASE);
															#line 530 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				ASSERT(retried);
															#line 4626 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
			}
			else
			{
															#line 532 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				if (e.code() == error_code_invalid_tenant_configuration)
															#line 4633 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				{
															#line 533 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					ASSERT_EQ(operationType, OperationType::METACLUSTER);
															#line 4637 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				}
				else
				{
															#line 535 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					return a_body1cont1loopBody1Catch1(e, std::max(0, loopDepth - 1));
															#line 4643 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				}
			}
			loopDepth = a_body1cont1loopBody1loopBody1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont5(Optional<Void> const& result,int loopDepth) 
	{
															#line 506 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (result.present())
															#line 4660 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		{
															#line 510 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (operationType == OperationType::SPECIAL_KEYS || operationType == OperationType::MANAGEMENT_TRANSACTION)
															#line 4664 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			{
															#line 512 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				ASSERT(minTenantCount + newTenants <= CLIENT_KNOBS->MAX_TENANTS_PER_CLUSTER);
															#line 4668 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			}
			else
			{
															#line 515 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				ASSERT(!alreadyExists);
															#line 4674 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			}
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 521 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		retried = true;
															#line 522 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		tr->reset();
															#line 4682 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont5(Optional<Void> && result,int loopDepth) 
	{
															#line 506 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (result.present())
															#line 4691 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		{
															#line 510 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (operationType == OperationType::SPECIAL_KEYS || operationType == OperationType::MANAGEMENT_TRANSACTION)
															#line 4695 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			{
															#line 512 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				ASSERT(minTenantCount + newTenants <= CLIENT_KNOBS->MAX_TENANTS_PER_CLUSTER);
															#line 4699 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			}
			else
			{
															#line 515 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				ASSERT(!alreadyExists);
															#line 4705 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			}
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 521 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		retried = true;
															#line 522 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		tr->reset();
															#line 4713 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1when1(Optional<Void> const& result,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont5(result, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1when1(Optional<Void> && result,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont5(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CreateTenantActor*>(this)->actor_wait_state > 0) static_cast<CreateTenantActor*>(this)->actor_wait_state = 0;
		static_cast<CreateTenantActor*>(this)->ActorCallback< CreateTenantActor, 2, Optional<Void> >::remove();

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 2, Optional<Void> >*,Optional<Void> const& value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 2, Optional<Void> >*,Optional<Void> && value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CreateTenantActor, 2, Optional<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1loopBody1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1loopBody1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont11(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont12(Optional<metacluster::MetaclusterTenantMapEntry> const& resultEntry,int loopDepth) 
	{
															#line 543 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (resultEntry.present())
															#line 4816 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		{
															#line 544 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (resultEntry.get().tenantState == metacluster::TenantState::READY)
															#line 4820 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			{
															#line 546 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				alreadyExists = true;
															#line 4824 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			}
			else
			{
															#line 550 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				ASSERT(resultEntry.get().tenantState == metacluster::TenantState::REGISTERING);
															#line 4830 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			}
		}
		else
		{
															#line 553 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			CODE_PROBE(true, "Tenant creation (metacluster) aborted before writing data.");
															#line 4837 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		}
		loopDepth = a_body1cont1loopBody1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont12(Optional<metacluster::MetaclusterTenantMapEntry> && resultEntry,int loopDepth) 
	{
															#line 543 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (resultEntry.present())
															#line 4847 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		{
															#line 544 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (resultEntry.get().tenantState == metacluster::TenantState::READY)
															#line 4851 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			{
															#line 546 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				alreadyExists = true;
															#line 4855 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			}
			else
			{
															#line 550 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				ASSERT(resultEntry.get().tenantState == metacluster::TenantState::REGISTERING);
															#line 4861 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			}
		}
		else
		{
															#line 553 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			CODE_PROBE(true, "Tenant creation (metacluster) aborted before writing data.");
															#line 4868 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		}
		loopDepth = a_body1cont1loopBody1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont4when1(Optional<metacluster::MetaclusterTenantMapEntry> const& resultEntry,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont12(resultEntry, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont4when1(Optional<metacluster::MetaclusterTenantMapEntry> && resultEntry,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont12(std::move(resultEntry), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CreateTenantActor*>(this)->actor_wait_state > 0) static_cast<CreateTenantActor*>(this)->actor_wait_state = 0;
		static_cast<CreateTenantActor*>(this)->ActorCallback< CreateTenantActor, 3, Optional<metacluster::MetaclusterTenantMapEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 3, Optional<metacluster::MetaclusterTenantMapEntry> >*,Optional<metacluster::MetaclusterTenantMapEntry> const& value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 3, Optional<metacluster::MetaclusterTenantMapEntry> >*,Optional<metacluster::MetaclusterTenantMapEntry> && value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CreateTenantActor, 3, Optional<metacluster::MetaclusterTenantMapEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1loopBody1cont13(Optional<TenantMapEntry> const& tenantEntry,int loopDepth) 
	{
															#line 558 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (tenantEntry.present())
															#line 4953 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		{
															#line 559 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			alreadyExists = true;
															#line 4957 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		}
		else
		{
															#line 561 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			CODE_PROBE(true, "Tenant creation (non-metacluster) aborted before writing data.");
															#line 4963 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		}
		loopDepth = a_body1cont1loopBody1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont13(Optional<TenantMapEntry> && tenantEntry,int loopDepth) 
	{
															#line 558 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (tenantEntry.present())
															#line 4973 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		{
															#line 559 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			alreadyExists = true;
															#line 4977 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		}
		else
		{
															#line 561 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			CODE_PROBE(true, "Tenant creation (non-metacluster) aborted before writing data.");
															#line 4983 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		}
		loopDepth = a_body1cont1loopBody1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont4when2(Optional<TenantMapEntry> const& tenantEntry,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont13(tenantEntry, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont4when2(Optional<TenantMapEntry> && tenantEntry,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont13(std::move(tenantEntry), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<CreateTenantActor*>(this)->actor_wait_state > 0) static_cast<CreateTenantActor*>(this)->actor_wait_state = 0;
		static_cast<CreateTenantActor*>(this)->ActorCallback< CreateTenantActor, 4, Optional<TenantMapEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 4, Optional<TenantMapEntry> >*,Optional<TenantMapEntry> const& value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1loopBody1cont4when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 4, Optional<TenantMapEntry> >*,Optional<TenantMapEntry> && value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1loopBody1cont4when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< CreateTenantActor, 4, Optional<TenantMapEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont1loopBody1cont3(int loopDepth) 
	{
															#line 648 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (!static_cast<CreateTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CreateTenantActorState(); static_cast<CreateTenantActor*>(this)->destroy(); return 0; }
															#line 5068 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		new (&static_cast<CreateTenantActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CreateTenantActorState();
		static_cast<CreateTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1(int loopDepth) 
	{
															#line 580 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (!(tenantItr != tenantsToCreate.end()))
															#line 5087 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		{
			return a_body1cont1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 582 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (self->createdTenants.contains(tenantItr->first))
															#line 5093 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		{
			return a_body1cont1loopBody1cont2continue1(loopDepth); // continue
		}
															#line 587 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		tPrefix = StringRef();
															#line 588 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (operationType == OperationType::METACLUSTER)
															#line 5101 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		{
															#line 589 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			StrictFuture<Optional<metacluster::MetaclusterTenantMapEntry>> __when_expr_5 = metacluster::tryGetTenant(self->mvDb, tenantItr->first);
															#line 589 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (static_cast<CreateTenantActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5107 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1loopBody1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont2loopBody1when1(__when_expr_5.get(), loopDepth); };
			static_cast<CreateTenantActor*>(this)->actor_wait_state = 6;
															#line 589 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CreateTenantActor, 5, Optional<metacluster::MetaclusterTenantMapEntry> >*>(static_cast<CreateTenantActor*>(this)));
															#line 5112 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 596 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			StrictFuture<Optional<TenantMapEntry>> __when_expr_7 = TenantAPI::tryGetTenant(self->dataDb.getReference(), tenantItr->first);
															#line 596 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (static_cast<CreateTenantActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5121 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont1loopBody1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont2loopBody1when2(__when_expr_7.get(), loopDepth); };
			static_cast<CreateTenantActor*>(this)->actor_wait_state = 8;
															#line 596 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< CreateTenantActor, 7, Optional<TenantMapEntry> >*>(static_cast<CreateTenantActor*>(this)));
															#line 5126 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2continue1(int loopDepth) 
	{
															#line 580 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		++tenantItr;
															#line 5149 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont1(int loopDepth) 
	{
															#line 603 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		StrictFuture<Versionstamp> __when_expr_9 = getLastTenantModification(self, operationType);
															#line 603 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (static_cast<CreateTenantActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5160 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont1loopBody1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont2loopBody1cont1when1(__when_expr_9.get(), loopDepth); };
		static_cast<CreateTenantActor*>(this)->actor_wait_state = 10;
															#line 603 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< CreateTenantActor, 9, Versionstamp >*>(static_cast<CreateTenantActor*>(this)));
															#line 5165 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont4(int loopDepth) 
	{
															#line 591 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_6 = verifyTenantCreate<metacluster::MetaclusterTenantMapEntry>( self, metaEntry, tenantItr->first, tenantItr->second.tenantGroup);
															#line 591 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (static_cast<CreateTenantActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5176 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont1loopBody1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont2loopBody1cont4when1(__when_expr_6.get(), loopDepth); };
		static_cast<CreateTenantActor*>(this)->actor_wait_state = 7;
															#line 591 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< CreateTenantActor, 6, Void >*>(static_cast<CreateTenantActor*>(this)));
															#line 5181 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1when1(Optional<metacluster::MetaclusterTenantMapEntry> const& __metaEntry,int loopDepth) 
	{
															#line 589 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		metaEntry = __metaEntry;
															#line 5190 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont2loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1when1(Optional<metacluster::MetaclusterTenantMapEntry> && __metaEntry,int loopDepth) 
	{
		metaEntry = std::move(__metaEntry);
		loopDepth = a_body1cont1loopBody1cont2loopBody1cont4(loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<CreateTenantActor*>(this)->actor_wait_state > 0) static_cast<CreateTenantActor*>(this)->actor_wait_state = 0;
		static_cast<CreateTenantActor*>(this)->ActorCallback< CreateTenantActor, 5, Optional<metacluster::MetaclusterTenantMapEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 5, Optional<metacluster::MetaclusterTenantMapEntry> >*,Optional<metacluster::MetaclusterTenantMapEntry> const& value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 5, Optional<metacluster::MetaclusterTenantMapEntry> >*,Optional<metacluster::MetaclusterTenantMapEntry> && value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< CreateTenantActor, 5, Optional<metacluster::MetaclusterTenantMapEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont1loopBody1cont2loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 593 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT(metaEntry.get().tenantState == metacluster::TenantState::READY);
															#line 594 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		tPrefix = metaEntry.get().prefix;
															#line 5271 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 593 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT(metaEntry.get().tenantState == metacluster::TenantState::READY);
															#line 594 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		tPrefix = metaEntry.get().prefix;
															#line 5282 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<CreateTenantActor*>(this)->actor_wait_state > 0) static_cast<CreateTenantActor*>(this)->actor_wait_state = 0;
		static_cast<CreateTenantActor*>(this)->ActorCallback< CreateTenantActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1cont2loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1cont2loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< CreateTenantActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont1loopBody1cont2loopBody1cont7(int loopDepth) 
	{
															#line 598 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_8 = verifyTenantCreate<TenantMapEntry>( self, normalEntry, tenantItr->first, tenantItr->second.tenantGroup);
															#line 598 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (static_cast<CreateTenantActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5368 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont1loopBody1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont2loopBody1cont7when1(__when_expr_8.get(), loopDepth); };
		static_cast<CreateTenantActor*>(this)->actor_wait_state = 9;
															#line 598 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< CreateTenantActor, 8, Void >*>(static_cast<CreateTenantActor*>(this)));
															#line 5373 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1when2(Optional<TenantMapEntry> const& __normalEntry,int loopDepth) 
	{
															#line 596 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		normalEntry = __normalEntry;
															#line 5382 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont2loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1when2(Optional<TenantMapEntry> && __normalEntry,int loopDepth) 
	{
		normalEntry = std::move(__normalEntry);
		loopDepth = a_body1cont1loopBody1cont2loopBody1cont7(loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<CreateTenantActor*>(this)->actor_wait_state > 0) static_cast<CreateTenantActor*>(this)->actor_wait_state = 0;
		static_cast<CreateTenantActor*>(this)->ActorCallback< CreateTenantActor, 7, Optional<TenantMapEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 7, Optional<TenantMapEntry> >*,Optional<TenantMapEntry> const& value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1cont2loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 7, Optional<TenantMapEntry> >*,Optional<TenantMapEntry> && value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1cont2loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< CreateTenantActor, 7, Optional<TenantMapEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont1loopBody1cont2loopBody1cont8(Void const& _,int loopDepth) 
	{
															#line 600 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		tPrefix = normalEntry.get().prefix;
															#line 5461 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont8(Void && _,int loopDepth) 
	{
															#line 600 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		tPrefix = normalEntry.get().prefix;
															#line 5470 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<CreateTenantActor*>(this)->actor_wait_state > 0) static_cast<CreateTenantActor*>(this)->actor_wait_state = 0;
		static_cast<CreateTenantActor*>(this)->ActorCallback< CreateTenantActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1loopBody1cont2loopBody1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1loopBody1cont2loopBody1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< CreateTenantActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont1loopBody1cont2loopBody1cont10(Versionstamp const& currentVersionstamp,int loopDepth) 
	{
															#line 604 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT_GT(currentVersionstamp.version, originalReadVersion);
															#line 607 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (tenantItr->second.tenantGroup.present())
															#line 5556 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		{
															#line 608 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			self->createdTenantGroups[tenantItr->second.tenantGroup.get()].tenantCount++;
															#line 5560 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		}
															#line 612 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		insertData = deterministicRandom()->random01() < 0.5;
															#line 613 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (insertData)
															#line 5566 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		{
															#line 614 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			insertTr = Transaction(self->dataDb, self->createdTenants[tenantItr->first].tenant);
															#line 615 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			;
															#line 5572 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = a_body1cont1loopBody1cont2loopBody1cont10loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont2loopBody1cont10cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont10(Versionstamp && currentVersionstamp,int loopDepth) 
	{
															#line 604 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT_GT(currentVersionstamp.version, originalReadVersion);
															#line 607 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (tenantItr->second.tenantGroup.present())
															#line 5588 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		{
															#line 608 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			self->createdTenantGroups[tenantItr->second.tenantGroup.get()].tenantCount++;
															#line 5592 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		}
															#line 612 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		insertData = deterministicRandom()->random01() < 0.5;
															#line 613 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (insertData)
															#line 5598 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		{
															#line 614 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			insertTr = Transaction(self->dataDb, self->createdTenants[tenantItr->first].tenant);
															#line 615 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			;
															#line 5604 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = a_body1cont1loopBody1cont2loopBody1cont10loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont2loopBody1cont10cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont1when1(Versionstamp const& currentVersionstamp,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2loopBody1cont10(currentVersionstamp, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont1when1(Versionstamp && currentVersionstamp,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2loopBody1cont10(std::move(currentVersionstamp), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<CreateTenantActor*>(this)->actor_wait_state > 0) static_cast<CreateTenantActor*>(this)->actor_wait_state = 0;
		static_cast<CreateTenantActor*>(this)->ActorCallback< CreateTenantActor, 9, Versionstamp >::remove();

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 9, Versionstamp >*,Versionstamp const& value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont1loopBody1cont2loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 9, Versionstamp >*,Versionstamp && value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont1loopBody1cont2loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< CreateTenantActor, 9, Versionstamp >*,Error err) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont1loopBody1cont2loopBody1cont10cont1(int loopDepth) 
	{
															#line 645 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_14 = checkTenantContents(self, tenantItr->first, self->createdTenants[tenantItr->first]);
															#line 645 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (static_cast<CreateTenantActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5695 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1cont1loopBody1Catch1(__when_expr_14.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont2loopBody1cont10cont1when1(__when_expr_14.get(), loopDepth); };
		static_cast<CreateTenantActor*>(this)->actor_wait_state = 15;
															#line 645 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< CreateTenantActor, 14, Void >*>(static_cast<CreateTenantActor*>(this)));
															#line 5700 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont10cont3(int loopDepth) 
	{
															#line 626 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		self->createdTenants[tenantItr->first].empty = false;
															#line 630 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		checkTr = Transaction(self->dataDb);
															#line 631 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		;
															#line 5713 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont2loopBody1cont10cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont10loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1cont2loopBody1cont10loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont10loopBody1(int loopDepth) 
	{
		try {
															#line 618 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			insertTr.set(self->keyName, tenantItr->first);
															#line 619 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_10 = insertTr.commit();
															#line 619 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (static_cast<CreateTenantActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont2loopBody1cont10loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5734 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1cont1loopBody1cont2loopBody1cont10loopBody1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont1loopBody1cont2loopBody1cont10loopBody1when1(__when_expr_10.get(), loopDepth); };
			static_cast<CreateTenantActor*>(this)->actor_wait_state = 11;
															#line 619 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< CreateTenantActor, 10, Void >*>(static_cast<CreateTenantActor*>(this)));
															#line 5739 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont2loopBody1cont10loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont2loopBody1cont10loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont10break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont2loopBody1cont10cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont10loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1cont2loopBody1cont10loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont10loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 622 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_11 = insertTr.onError(e);
															#line 622 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (static_cast<CreateTenantActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 5776 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1cont1loopBody1Catch1(__when_expr_11.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1cont2loopBody1cont10loopBody1Catch1when1(__when_expr_11.get(), loopDepth); };
			static_cast<CreateTenantActor*>(this)->actor_wait_state = 12;
															#line 622 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< CreateTenantActor, 11, Void >*>(static_cast<CreateTenantActor*>(this)));
															#line 5781 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont10loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1cont1loopBody1cont2loopBody1cont10break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont10loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1cont1loopBody1cont2loopBody1cont10break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont10loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2loopBody1cont10loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont10loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2loopBody1cont10loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<CreateTenantActor*>(this)->actor_wait_state > 0) static_cast<CreateTenantActor*>(this)->actor_wait_state = 0;
		static_cast<CreateTenantActor*>(this)->ActorCallback< CreateTenantActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont1loopBody1cont2loopBody1cont10loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont2loopBody1cont10loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont2loopBody1cont10loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont1loopBody1cont2loopBody1cont10loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont2loopBody1cont10loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont2loopBody1cont10loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< CreateTenantActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont1loopBody1cont2loopBody1cont10loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont2loopBody1cont10loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont2loopBody1cont10loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont1loopBody1cont2loopBody1cont10loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2loopBody1cont10loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont10loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2loopBody1cont10loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont10loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2loopBody1cont10loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont10loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2loopBody1cont10loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<CreateTenantActor*>(this)->actor_wait_state > 0) static_cast<CreateTenantActor*>(this)->actor_wait_state = 0;
		static_cast<CreateTenantActor*>(this)->ActorCallback< CreateTenantActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont1loopBody1cont2loopBody1cont10loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont1loopBody1cont2loopBody1cont10loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< CreateTenantActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1cont1loopBody1cont2loopBody1cont10cont4(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2loopBody1cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont10cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1cont2loopBody1cont10cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont10cont3loopBody1(int loopDepth) 
	{
		try {
															#line 633 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			checkTr.setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 634 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_12 = checkTr.get(self->keyName.withPrefix(tPrefix));
															#line 634 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (static_cast<CreateTenantActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont2loopBody1cont10cont3loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5988 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1cont1loopBody1cont2loopBody1cont10cont3loopBody1Catch1(__when_expr_12.getError(), loopDepth); else return a_body1cont1loopBody1cont2loopBody1cont10cont3loopBody1when1(__when_expr_12.get(), loopDepth); };
			static_cast<CreateTenantActor*>(this)->actor_wait_state = 13;
															#line 634 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< CreateTenantActor, 12, Optional<Value> >*>(static_cast<CreateTenantActor*>(this)));
															#line 5993 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont2loopBody1cont10cont3loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont2loopBody1cont10cont3loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont10cont3break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont2loopBody1cont10cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont10cont3loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1cont2loopBody1cont10cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont10cont3loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 639 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_13 = checkTr.onError(e);
															#line 639 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (static_cast<CreateTenantActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 6030 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1cont1loopBody1Catch1(__when_expr_13.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1cont2loopBody1cont10cont3loopBody1Catch1when1(__when_expr_13.get(), loopDepth); };
			static_cast<CreateTenantActor*>(this)->actor_wait_state = 14;
															#line 639 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< CreateTenantActor, 13, Void >*>(static_cast<CreateTenantActor*>(this)));
															#line 6035 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont10cont3loopBody1cont2(Optional<Value> const& val,int loopDepth) 
	{
															#line 635 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT(val.present());
															#line 636 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT(val.get() == tenantItr->first);
															#line 6052 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		return a_body1cont1loopBody1cont2loopBody1cont10cont3break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont10cont3loopBody1cont2(Optional<Value> && val,int loopDepth) 
	{
															#line 635 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT(val.present());
															#line 636 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT(val.get() == tenantItr->first);
															#line 6063 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		return a_body1cont1loopBody1cont2loopBody1cont10cont3break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont10cont3loopBody1when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2loopBody1cont10cont3loopBody1cont2(val, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont10cont3loopBody1when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2loopBody1cont10cont3loopBody1cont2(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<CreateTenantActor*>(this)->actor_wait_state > 0) static_cast<CreateTenantActor*>(this)->actor_wait_state = 0;
		static_cast<CreateTenantActor*>(this)->ActorCallback< CreateTenantActor, 12, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 12, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont1loopBody1cont2loopBody1cont10cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont2loopBody1cont10cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont2loopBody1cont10cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 12, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont1loopBody1cont2loopBody1cont10cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont2loopBody1cont10cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont2loopBody1cont10cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< CreateTenantActor, 12, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont1loopBody1cont2loopBody1cont10cont3loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont2loopBody1cont10cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont2loopBody1cont10cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 12);

	}
	int a_body1cont1loopBody1cont2loopBody1cont10cont3loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2loopBody1cont10cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont10cont3loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2loopBody1cont10cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont10cont3loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2loopBody1cont10cont3loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont10cont3loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2loopBody1cont10cont3loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose14() 
	{
		if (static_cast<CreateTenantActor*>(this)->actor_wait_state > 0) static_cast<CreateTenantActor*>(this)->actor_wait_state = 0;
		static_cast<CreateTenantActor*>(this)->ActorCallback< CreateTenantActor, 13, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 13, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont1loopBody1cont2loopBody1cont10cont3loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 13, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont1loopBody1cont2loopBody1cont10cont3loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorCallback< CreateTenantActor, 13, Void >*,Error err) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 13);

	}
	int a_body1cont1loopBody1cont2loopBody1cont10cont5(Void const& _,int loopDepth) 
	{
															#line 580 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		++tenantItr;
															#line 6234 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont10cont5(Void && _,int loopDepth) 
	{
															#line 580 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		++tenantItr;
															#line 6243 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont10cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2loopBody1cont10cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont10cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2loopBody1cont10cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose15() 
	{
		if (static_cast<CreateTenantActor*>(this)->actor_wait_state > 0) static_cast<CreateTenantActor*>(this)->actor_wait_state = 0;
		static_cast<CreateTenantActor*>(this)->ActorCallback< CreateTenantActor, 14, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 14, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont1loopBody1cont2loopBody1cont10cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 14, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont1loopBody1cont2loopBody1cont10cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_error(ActorCallback< CreateTenantActor, 14, Void >*,Error err) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 14);

	}
	int a_body1cont1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont5(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont7(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont10(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont14(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 690 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			for( auto [tenant, _] : tenantsToCreate ) {
															#line 691 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				TraceEvent(SevError, "CreateTenantFailure") .errorUnsuppressed(e) .detail("TenantName", tenant);
															#line 6366 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			}
															#line 695 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			ASSERT(false);
															#line 6370 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = a_body1cont1loopBody1Catch1cont14(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont15(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont15cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont15(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont15cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont15(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont15(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose16() 
	{
		if (static_cast<CreateTenantActor*>(this)->actor_wait_state > 0) static_cast<CreateTenantActor*>(this)->actor_wait_state = 0;
		static_cast<CreateTenantActor*>(this)->ActorCallback< CreateTenantActor, 15, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 15, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 15, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_error(ActorCallback< CreateTenantActor, 15, Void >*,Error err) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont1loopBody1Catch1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 15);

	}
	int a_body1cont1loopBody1Catch1cont15cont1(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1Catch1cont14(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 439 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	TenantManagementWorkload* self;
															#line 440 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	OperationType operationType;
															#line 450 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	bool alreadyExists;
															#line 453 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	bool hasSystemTenant;
															#line 456 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	bool hasSystemTenantGroup;
															#line 458 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	int newTenants;
															#line 459 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	std::map<TenantName, TenantMapEntry> tenantsToCreate;
															#line 483 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	bool existedAtStart;
															#line 485 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 486 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	int64_t minTenantCount;
															#line 487 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	int64_t finalTenantCount;
															#line 489 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	Version originalReadVersion;
															#line 493 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	bool retried;
															#line 579 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	typename std::map<TenantName, TenantMapEntry>::iterator tenantItr;
															#line 587 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	StringRef tPrefix;
															#line 589 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	Optional<metacluster::MetaclusterTenantMapEntry> metaEntry;
															#line 596 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	Optional<TenantMapEntry> normalEntry;
															#line 612 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	bool insertData;
															#line 614 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	Transaction insertTr;
															#line 630 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	Transaction checkTr;
															#line 6521 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
};
// This generated class is to be used only via createTenant()
															#line 439 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
class CreateTenantActor final : public Actor<Void>, public ActorCallback< CreateTenantActor, 0, Version >, public ActorCallback< CreateTenantActor, 1, Void >, public ActorCallback< CreateTenantActor, 2, Optional<Void> >, public ActorCallback< CreateTenantActor, 3, Optional<metacluster::MetaclusterTenantMapEntry> >, public ActorCallback< CreateTenantActor, 4, Optional<TenantMapEntry> >, public ActorCallback< CreateTenantActor, 5, Optional<metacluster::MetaclusterTenantMapEntry> >, public ActorCallback< CreateTenantActor, 6, Void >, public ActorCallback< CreateTenantActor, 7, Optional<TenantMapEntry> >, public ActorCallback< CreateTenantActor, 8, Void >, public ActorCallback< CreateTenantActor, 9, Versionstamp >, public ActorCallback< CreateTenantActor, 10, Void >, public ActorCallback< CreateTenantActor, 11, Void >, public ActorCallback< CreateTenantActor, 12, Optional<Value> >, public ActorCallback< CreateTenantActor, 13, Void >, public ActorCallback< CreateTenantActor, 14, Void >, public ActorCallback< CreateTenantActor, 15, Void >, public FastAllocated<CreateTenantActor>, public CreateTenantActorState<CreateTenantActor> {
															#line 6526 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
public:
	using FastAllocated<CreateTenantActor>::operator new;
	using FastAllocated<CreateTenantActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18247530965926146304UL, 799619758956786176UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CreateTenantActor, 0, Version >;
friend struct ActorCallback< CreateTenantActor, 1, Void >;
friend struct ActorCallback< CreateTenantActor, 2, Optional<Void> >;
friend struct ActorCallback< CreateTenantActor, 3, Optional<metacluster::MetaclusterTenantMapEntry> >;
friend struct ActorCallback< CreateTenantActor, 4, Optional<TenantMapEntry> >;
friend struct ActorCallback< CreateTenantActor, 5, Optional<metacluster::MetaclusterTenantMapEntry> >;
friend struct ActorCallback< CreateTenantActor, 6, Void >;
friend struct ActorCallback< CreateTenantActor, 7, Optional<TenantMapEntry> >;
friend struct ActorCallback< CreateTenantActor, 8, Void >;
friend struct ActorCallback< CreateTenantActor, 9, Versionstamp >;
friend struct ActorCallback< CreateTenantActor, 10, Void >;
friend struct ActorCallback< CreateTenantActor, 11, Void >;
friend struct ActorCallback< CreateTenantActor, 12, Optional<Value> >;
friend struct ActorCallback< CreateTenantActor, 13, Void >;
friend struct ActorCallback< CreateTenantActor, 14, Void >;
friend struct ActorCallback< CreateTenantActor, 15, Void >;
															#line 439 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	CreateTenantActor(TenantManagementWorkload* const& self) 
															#line 6558 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   CreateTenantActorState<CreateTenantActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2480746510970185984UL, 428737674404862208UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("createTenant");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CreateTenantActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CreateTenantActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CreateTenantActor, 2, Optional<Void> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CreateTenantActor, 3, Optional<metacluster::MetaclusterTenantMapEntry> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< CreateTenantActor, 4, Optional<TenantMapEntry> >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< CreateTenantActor, 5, Optional<metacluster::MetaclusterTenantMapEntry> >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< CreateTenantActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< CreateTenantActor, 7, Optional<TenantMapEntry> >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< CreateTenantActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< CreateTenantActor, 9, Versionstamp >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< CreateTenantActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< CreateTenantActor, 11, Void >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< CreateTenantActor, 12, Optional<Value> >*)0, actor_cancelled()); break;
		case 14: this->a_callback_error((ActorCallback< CreateTenantActor, 13, Void >*)0, actor_cancelled()); break;
		case 15: this->a_callback_error((ActorCallback< CreateTenantActor, 14, Void >*)0, actor_cancelled()); break;
		case 16: this->a_callback_error((ActorCallback< CreateTenantActor, 15, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 439 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
[[nodiscard]] static Future<Void> createTenant( TenantManagementWorkload* const& self ) {
															#line 439 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	return Future<Void>(new CreateTenantActor(self));
															#line 6605 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
}

#line 701 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"

	// set a random watch on a tenant
																#line 6611 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
// This generated class is to be used only via watchTenant()
															#line 703 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
template <class WatchTenantActor>
															#line 703 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
class WatchTenantActorState {
															#line 6617 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
public:
															#line 703 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	WatchTenantActorState(TenantManagementWorkload* const& self,Reference<Tenant> const& tenant) 
															#line 703 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
															#line 703 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		 : self(self),
															#line 703 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   tenant(tenant)
															#line 6626 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("watchTenant", reinterpret_cast<unsigned long>(this));

	}
	~WatchTenantActorState() 
	{
		fdb_probe_actor_destroy("watchTenant", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 704 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			;
															#line 6641 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WatchTenantActorState();
		static_cast<WatchTenantActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 705 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		tr = Reference<ReadYourWritesTransaction>(new ReadYourWritesTransaction(self->dataDb, tenant));
															#line 6671 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		try {
															#line 707 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			watch = tr->watch(doubleToTestKey(deterministicRandom()->random01()));
															#line 708 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr->commit();
															#line 708 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (static_cast<WatchTenantActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6679 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WatchTenantActor*>(this)->actor_wait_state = 1;
															#line 708 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WatchTenantActor, 0, Void >*>(static_cast<WatchTenantActor*>(this)));
															#line 6684 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 712 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr->onError(e);
															#line 712 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (static_cast<WatchTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6708 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<WatchTenantActor*>(this)->actor_wait_state = 3;
															#line 712 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WatchTenantActor, 2, Void >*>(static_cast<WatchTenantActor*>(this)));
															#line 6713 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 709 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = watch;
															#line 709 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (static_cast<WatchTenantActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6730 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<WatchTenantActor*>(this)->actor_wait_state = 2;
															#line 709 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WatchTenantActor, 1, Void >*>(static_cast<WatchTenantActor*>(this)));
															#line 6735 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 709 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = watch;
															#line 709 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (static_cast<WatchTenantActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6746 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<WatchTenantActor*>(this)->actor_wait_state = 2;
															#line 709 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WatchTenantActor, 1, Void >*>(static_cast<WatchTenantActor*>(this)));
															#line 6751 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WatchTenantActor*>(this)->actor_wait_state > 0) static_cast<WatchTenantActor*>(this)->actor_wait_state = 0;
		static_cast<WatchTenantActor*>(this)->ActorCallback< WatchTenantActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WatchTenantActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("watchTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WatchTenantActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("watchTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WatchTenantActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("watchTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 710 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (!static_cast<WatchTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WatchTenantActorState(); static_cast<WatchTenantActor*>(this)->destroy(); return 0; }
															#line 6835 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		new (&static_cast<WatchTenantActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WatchTenantActorState();
		static_cast<WatchTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 710 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (!static_cast<WatchTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WatchTenantActorState(); static_cast<WatchTenantActor*>(this)->destroy(); return 0; }
															#line 6847 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		new (&static_cast<WatchTenantActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WatchTenantActorState();
		static_cast<WatchTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WatchTenantActor*>(this)->actor_wait_state > 0) static_cast<WatchTenantActor*>(this)->actor_wait_state = 0;
		static_cast<WatchTenantActor*>(this)->ActorCallback< WatchTenantActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WatchTenantActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("watchTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WatchTenantActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("watchTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WatchTenantActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("watchTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WatchTenantActor*>(this)->actor_wait_state > 0) static_cast<WatchTenantActor*>(this)->actor_wait_state = 0;
		static_cast<WatchTenantActor*>(this)->ActorCallback< WatchTenantActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WatchTenantActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("watchTenant", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchTenant", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WatchTenantActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("watchTenant", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchTenant", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WatchTenantActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("watchTenant", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchTenant", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 703 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	TenantManagementWorkload* self;
															#line 703 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	Reference<Tenant> tenant;
															#line 705 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 707 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	Future<Void> watch;
															#line 7025 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
};
// This generated class is to be used only via watchTenant()
															#line 703 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
class WatchTenantActor final : public Actor<Void>, public ActorCallback< WatchTenantActor, 0, Void >, public ActorCallback< WatchTenantActor, 1, Void >, public ActorCallback< WatchTenantActor, 2, Void >, public FastAllocated<WatchTenantActor>, public WatchTenantActorState<WatchTenantActor> {
															#line 7030 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
public:
	using FastAllocated<WatchTenantActor>::operator new;
	using FastAllocated<WatchTenantActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2646791805054124032UL, 11989592725988262400UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WatchTenantActor, 0, Void >;
friend struct ActorCallback< WatchTenantActor, 1, Void >;
friend struct ActorCallback< WatchTenantActor, 2, Void >;
															#line 703 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	WatchTenantActor(TenantManagementWorkload* const& self,Reference<Tenant> const& tenant) 
															#line 7049 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   WatchTenantActorState<WatchTenantActor>(self, tenant),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("watchTenant", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10835948524955407360UL, 3199538431113957632UL);
		ActorExecutionContextHelper __helper(static_cast<WatchTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("watchTenant");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("watchTenant", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WatchTenantActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WatchTenantActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WatchTenantActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 703 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
[[nodiscard]] static Future<Void> watchTenant( TenantManagementWorkload* const& self, Reference<Tenant> const& tenant ) {
															#line 703 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	return Future<Void>(new WatchTenantActor(self, tenant));
															#line 7083 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
}

#line 716 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"

	void checkWatchOnDeletedTenant(std::vector<std::pair<TenantName, Future<ErrorOr<Void>>>>& watchFutures) {
		for (auto& [t, f] : watchFutures) {
			auto& res = f.get();
			if (res.isError(error_code_tenant_removed) || res.isError(error_code_tenant_not_found)) {
				CODE_PROBE(res.isError(error_code_tenant_removed),
				           "Watch Triggered because the tenant is deleted during watch");
			} else {
				TraceEvent(SevError, "WatchDeletedTenantCheckFailed")
				    .detail("Tenant", t)
				    .detail("IsError", res.isError() ? res.getError().what() : "Void()");
			}
		}
	}

																#line 7102 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
// This generated class is to be used only via clearTenantData()
															#line 731 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
template <class ClearTenantDataActor>
															#line 731 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
class ClearTenantDataActorState {
															#line 7108 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
public:
															#line 731 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	ClearTenantDataActorState(TenantManagementWorkload* const& self,TenantName const& tenantName) 
															#line 731 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
															#line 731 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		 : self(self),
															#line 731 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   tenantName(tenantName),
															#line 732 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   clearTr(self->dataDb, self->createdTenants[tenantName].tenant)
															#line 7119 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("clearTenantData", reinterpret_cast<unsigned long>(this));

	}
	~ClearTenantDataActorState() 
	{
		fdb_probe_actor_destroy("clearTenantData", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 733 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			;
															#line 7134 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClearTenantDataActorState();
		static_cast<ClearTenantDataActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 735 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			clearTr.clear(self->keyName);
															#line 736 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = clearTr.commit();
															#line 736 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (static_cast<ClearTenantDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7169 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ClearTenantDataActor*>(this)->actor_wait_state = 1;
															#line 736 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClearTenantDataActor, 0, Void >*>(static_cast<ClearTenantDataActor*>(this)));
															#line 7174 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 743 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (e.code() == error_code_tenant_locked)
															#line 7196 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			{
															#line 744 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				ASSERT_NE(self->createdTenants[tenantName].lockState, TenantAPI::TenantLockState::UNLOCKED);
															#line 745 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				if (!static_cast<ClearTenantDataActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ClearTenantDataActorState(); static_cast<ClearTenantDataActor*>(this)->destroy(); return 0; }
															#line 7202 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				new (&static_cast<ClearTenantDataActor*>(this)->SAV< bool >::value()) bool(false);
				this->~ClearTenantDataActorState();
				static_cast<ClearTenantDataActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 747 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_1 = clearTr.onError(e);
															#line 747 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (static_cast<ClearTenantDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7212 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ClearTenantDataActor*>(this)->actor_wait_state = 2;
															#line 747 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClearTenantDataActor, 1, Void >*>(static_cast<ClearTenantDataActor*>(this)));
															#line 7217 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 737 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		auto itr = self->createdTenants.find(tenantName);
															#line 738 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT(itr != self->createdTenants.end());
															#line 739 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT_EQ(itr->second.lockState, TenantAPI::TenantLockState::UNLOCKED);
															#line 740 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		itr->second.empty = true;
															#line 741 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (!static_cast<ClearTenantDataActor*>(this)->SAV<bool>::futures) { (void)(true); this->~ClearTenantDataActorState(); static_cast<ClearTenantDataActor*>(this)->destroy(); return 0; }
															#line 7240 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		new (&static_cast<ClearTenantDataActor*>(this)->SAV< bool >::value()) bool(true);
		this->~ClearTenantDataActorState();
		static_cast<ClearTenantDataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 737 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		auto itr = self->createdTenants.find(tenantName);
															#line 738 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT(itr != self->createdTenants.end());
															#line 739 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT_EQ(itr->second.lockState, TenantAPI::TenantLockState::UNLOCKED);
															#line 740 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		itr->second.empty = true;
															#line 741 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (!static_cast<ClearTenantDataActor*>(this)->SAV<bool>::futures) { (void)(true); this->~ClearTenantDataActorState(); static_cast<ClearTenantDataActor*>(this)->destroy(); return 0; }
															#line 7260 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		new (&static_cast<ClearTenantDataActor*>(this)->SAV< bool >::value()) bool(true);
		this->~ClearTenantDataActorState();
		static_cast<ClearTenantDataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClearTenantDataActor*>(this)->actor_wait_state > 0) static_cast<ClearTenantDataActor*>(this)->actor_wait_state = 0;
		static_cast<ClearTenantDataActor*>(this)->ActorCallback< ClearTenantDataActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClearTenantDataActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clearTenantData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearTenantDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearTenantData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClearTenantDataActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clearTenantData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearTenantDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearTenantData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClearTenantDataActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clearTenantData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearTenantDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearTenantData", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ClearTenantDataActor*>(this)->actor_wait_state > 0) static_cast<ClearTenantDataActor*>(this)->actor_wait_state = 0;
		static_cast<ClearTenantDataActor*>(this)->ActorCallback< ClearTenantDataActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClearTenantDataActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clearTenantData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearTenantDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearTenantData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClearTenantDataActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clearTenantData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearTenantDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearTenantData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClearTenantDataActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clearTenantData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearTenantDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearTenantData", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 731 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	TenantManagementWorkload* self;
															#line 731 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	TenantName tenantName;
															#line 732 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	Transaction clearTr;
															#line 7436 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
};
// This generated class is to be used only via clearTenantData()
															#line 731 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
class ClearTenantDataActor final : public Actor<bool>, public ActorCallback< ClearTenantDataActor, 0, Void >, public ActorCallback< ClearTenantDataActor, 1, Void >, public FastAllocated<ClearTenantDataActor>, public ClearTenantDataActorState<ClearTenantDataActor> {
															#line 7441 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
public:
	using FastAllocated<ClearTenantDataActor>::operator new;
	using FastAllocated<ClearTenantDataActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15620217305147806208UL, 1617526073155199488UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClearTenantDataActor, 0, Void >;
friend struct ActorCallback< ClearTenantDataActor, 1, Void >;
															#line 731 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	ClearTenantDataActor(TenantManagementWorkload* const& self,TenantName const& tenantName) 
															#line 7459 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		 : Actor<bool>(),
		   ClearTenantDataActorState<ClearTenantDataActor>(self, tenantName),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clearTenantData", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14579134113318347008UL, 12945364584588274944UL);
		ActorExecutionContextHelper __helper(static_cast<ClearTenantDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clearTenantData");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clearTenantData", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClearTenantDataActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ClearTenantDataActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 731 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
[[nodiscard]] static Future<bool> clearTenantData( TenantManagementWorkload* const& self, TenantName const& tenantName ) {
															#line 731 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	return Future<bool>(new ClearTenantDataActor(self, tenantName));
															#line 7492 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
}

#line 751 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"

	// Deletes the tenant or tenant range using the specified operation type
																#line 7498 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
// This generated class is to be used only via deleteTenantImpl()
															#line 753 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
template <class DeleteTenantImplActor>
															#line 753 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
class DeleteTenantImplActorState {
															#line 7504 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
public:
															#line 753 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	DeleteTenantImplActorState(Reference<ReadYourWritesTransaction> const& tr,TenantName const& beginTenant,Optional<TenantName> const& endTenant,std::map<TenantName, int64_t> const& tenants,OperationType const& operationType,TenantManagementWorkload* const& self) 
															#line 753 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
															#line 753 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		 : tr(tr),
															#line 753 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   beginTenant(beginTenant),
															#line 753 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   endTenant(endTenant),
															#line 753 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   tenants(tenants),
															#line 753 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   operationType(operationType),
															#line 753 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   self(self)
															#line 7521 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("deleteTenantImpl", reinterpret_cast<unsigned long>(this));

	}
	~DeleteTenantImplActorState() 
	{
		fdb_probe_actor_destroy("deleteTenantImpl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 759 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (operationType == OperationType::SPECIAL_KEYS)
															#line 7536 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			{
															#line 760 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				tr->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 761 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				Key key = self->specialKeysTenantMapPrefix.withSuffix(beginTenant);
															#line 762 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				if (endTenant.present())
															#line 7544 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				{
															#line 763 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					tr->clear(KeyRangeRef(key, self->specialKeysTenantMapPrefix.withSuffix(endTenant.get())));
															#line 7548 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				}
				else
				{
															#line 765 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					tr->clear(key);
															#line 7554 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				}
															#line 767 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				StrictFuture<Void> __when_expr_0 = tr->commit();
															#line 767 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				if (static_cast<DeleteTenantImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7560 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<DeleteTenantImplActor*>(this)->actor_wait_state = 1;
															#line 767 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantImplActor, 0, Void >*>(static_cast<DeleteTenantImplActor*>(this)));
															#line 7565 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 768 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				if (operationType == OperationType::MANAGEMENT_DATABASE)
															#line 7572 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				{
															#line 769 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					ASSERT(!endTenant.present() && tenants.size() == 1);
															#line 770 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					StrictFuture<Void> __when_expr_1 = TenantAPI::deleteTenant(self->dataDb.getReference(), beginTenant);
															#line 770 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					if (static_cast<DeleteTenantImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7580 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
					static_cast<DeleteTenantImplActor*>(this)->actor_wait_state = 2;
															#line 770 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantImplActor, 1, Void >*>(static_cast<DeleteTenantImplActor*>(this)));
															#line 7585 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 771 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					if (operationType == OperationType::MANAGEMENT_TRANSACTION)
															#line 7592 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					{
															#line 772 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 773 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						std::vector<Future<Void>> deleteFutures;
															#line 774 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						for( auto const& [name, id] : tenants ) {
															#line 775 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
							if (id != TenantInfo::INVALID_TENANT)
															#line 7602 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
							{
															#line 776 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
								deleteFutures.push_back(TenantAPI::deleteTenantTransaction(tr, id));
															#line 7606 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
							}
						}
															#line 780 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						StrictFuture<Void> __when_expr_2 = waitForAll(deleteFutures);
															#line 780 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						if (static_cast<DeleteTenantImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7613 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
						if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1when3(__when_expr_2.get(), loopDepth); };
						static_cast<DeleteTenantImplActor*>(this)->actor_wait_state = 3;
															#line 780 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantImplActor, 2, Void >*>(static_cast<DeleteTenantImplActor*>(this)));
															#line 7618 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
						loopDepth = 0;
					}
					else
					{
															#line 783 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						ASSERT(!endTenant.present() && tenants.size() == 1);
															#line 788 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						StrictFuture<Optional<metacluster::MetaclusterTenantMapEntry>> __when_expr_4 = metacluster::tryGetTenant(self->mvDb, beginTenant);
															#line 788 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						if (static_cast<DeleteTenantImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7629 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
						if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1when4(__when_expr_4.get(), loopDepth); };
						static_cast<DeleteTenantImplActor*>(this)->actor_wait_state = 5;
															#line 788 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantImplActor, 4, Optional<metacluster::MetaclusterTenantMapEntry> >*>(static_cast<DeleteTenantImplActor*>(this)));
															#line 7634 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
						loopDepth = 0;
					}
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DeleteTenantImplActorState();
		static_cast<DeleteTenantImplActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 798 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (!static_cast<DeleteTenantImplActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteTenantImplActorState(); static_cast<DeleteTenantImplActor*>(this)->destroy(); return 0; }
															#line 7660 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		new (&static_cast<DeleteTenantImplActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DeleteTenantImplActorState();
		static_cast<DeleteTenantImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DeleteTenantImplActor*>(this)->actor_wait_state > 0) static_cast<DeleteTenantImplActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteTenantImplActor*>(this)->ActorCallback< DeleteTenantImplActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteTenantImplActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("deleteTenantImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DeleteTenantImplActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("deleteTenantImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DeleteTenantImplActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("deleteTenantImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont5(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DeleteTenantImplActor*>(this)->actor_wait_state > 0) static_cast<DeleteTenantImplActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteTenantImplActor*>(this)->ActorCallback< DeleteTenantImplActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteTenantImplActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("deleteTenantImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DeleteTenantImplActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("deleteTenantImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DeleteTenantImplActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("deleteTenantImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont7(int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
															#line 781 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_3 = tr->commit();
															#line 781 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (static_cast<DeleteTenantImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7860 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont8when1(__when_expr_3.get(), loopDepth); };
		static_cast<DeleteTenantImplActor*>(this)->actor_wait_state = 4;
															#line 781 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantImplActor, 3, Void >*>(static_cast<DeleteTenantImplActor*>(this)));
															#line 7865 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
															#line 781 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_3 = tr->commit();
															#line 781 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (static_cast<DeleteTenantImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7876 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont8when1(__when_expr_3.get(), loopDepth); };
		static_cast<DeleteTenantImplActor*>(this)->actor_wait_state = 4;
															#line 781 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantImplActor, 3, Void >*>(static_cast<DeleteTenantImplActor*>(this)));
															#line 7881 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DeleteTenantImplActor*>(this)->actor_wait_state > 0) static_cast<DeleteTenantImplActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteTenantImplActor*>(this)->ActorCallback< DeleteTenantImplActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteTenantImplActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("deleteTenantImpl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantImpl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DeleteTenantImplActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("deleteTenantImpl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantImpl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DeleteTenantImplActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("deleteTenantImpl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantImpl", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont11(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont11(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<DeleteTenantImplActor*>(this)->actor_wait_state > 0) static_cast<DeleteTenantImplActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteTenantImplActor*>(this)->ActorCallback< DeleteTenantImplActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteTenantImplActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("deleteTenantImpl", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantImpl", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< DeleteTenantImplActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("deleteTenantImpl", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantImpl", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< DeleteTenantImplActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("deleteTenantImpl", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantImpl", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont12(Optional<metacluster::MetaclusterTenantMapEntry> const& entry,int loopDepth) 
	{
															#line 790 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (entry.present() && deterministicRandom()->coinflip())
															#line 8052 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		{
															#line 791 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_5 = metacluster::deleteTenant(self->mvDb, entry.get().id);
															#line 791 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (static_cast<DeleteTenantImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8058 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont12when1(__when_expr_5.get(), loopDepth); };
			static_cast<DeleteTenantImplActor*>(this)->actor_wait_state = 6;
															#line 791 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantImplActor, 5, Void >*>(static_cast<DeleteTenantImplActor*>(this)));
															#line 8063 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 794 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_6 = metacluster::deleteTenant(self->mvDb, beginTenant);
															#line 794 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (static_cast<DeleteTenantImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8072 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont12when2(__when_expr_6.get(), loopDepth); };
			static_cast<DeleteTenantImplActor*>(this)->actor_wait_state = 7;
															#line 794 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantImplActor, 6, Void >*>(static_cast<DeleteTenantImplActor*>(this)));
															#line 8077 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont12(Optional<metacluster::MetaclusterTenantMapEntry> && entry,int loopDepth) 
	{
															#line 790 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (entry.present() && deterministicRandom()->coinflip())
															#line 8087 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		{
															#line 791 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_5 = metacluster::deleteTenant(self->mvDb, entry.get().id);
															#line 791 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (static_cast<DeleteTenantImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8093 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont12when1(__when_expr_5.get(), loopDepth); };
			static_cast<DeleteTenantImplActor*>(this)->actor_wait_state = 6;
															#line 791 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantImplActor, 5, Void >*>(static_cast<DeleteTenantImplActor*>(this)));
															#line 8098 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 794 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_6 = metacluster::deleteTenant(self->mvDb, beginTenant);
															#line 794 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (static_cast<DeleteTenantImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8107 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont12when2(__when_expr_6.get(), loopDepth); };
			static_cast<DeleteTenantImplActor*>(this)->actor_wait_state = 7;
															#line 794 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantImplActor, 6, Void >*>(static_cast<DeleteTenantImplActor*>(this)));
															#line 8112 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1when4(Optional<metacluster::MetaclusterTenantMapEntry> const& entry,int loopDepth) 
	{
		loopDepth = a_body1cont12(entry, loopDepth);

		return loopDepth;
	}
	int a_body1when4(Optional<metacluster::MetaclusterTenantMapEntry> && entry,int loopDepth) 
	{
		loopDepth = a_body1cont12(std::move(entry), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<DeleteTenantImplActor*>(this)->actor_wait_state > 0) static_cast<DeleteTenantImplActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteTenantImplActor*>(this)->ActorCallback< DeleteTenantImplActor, 4, Optional<metacluster::MetaclusterTenantMapEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteTenantImplActor, 4, Optional<metacluster::MetaclusterTenantMapEntry> >*,Optional<metacluster::MetaclusterTenantMapEntry> const& value) 
	{
		fdb_probe_actor_enter("deleteTenantImpl", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantImpl", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< DeleteTenantImplActor, 4, Optional<metacluster::MetaclusterTenantMapEntry> >*,Optional<metacluster::MetaclusterTenantMapEntry> && value) 
	{
		fdb_probe_actor_enter("deleteTenantImpl", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantImpl", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< DeleteTenantImplActor, 4, Optional<metacluster::MetaclusterTenantMapEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("deleteTenantImpl", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantImpl", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont12cont1(int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2(Void const& _,int loopDepth) 
	{
															#line 792 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		CODE_PROBE(true, "Deleted tenant by ID");
															#line 8203 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont12cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2(Void && _,int loopDepth) 
	{
															#line 792 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		CODE_PROBE(true, "Deleted tenant by ID");
															#line 8212 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont12cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<DeleteTenantImplActor*>(this)->actor_wait_state > 0) static_cast<DeleteTenantImplActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteTenantImplActor*>(this)->ActorCallback< DeleteTenantImplActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteTenantImplActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("deleteTenantImpl", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont12when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantImpl", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< DeleteTenantImplActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("deleteTenantImpl", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont12when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantImpl", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< DeleteTenantImplActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("deleteTenantImpl", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantImpl", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont12cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<DeleteTenantImplActor*>(this)->actor_wait_state > 0) static_cast<DeleteTenantImplActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteTenantImplActor*>(this)->ActorCallback< DeleteTenantImplActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteTenantImplActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("deleteTenantImpl", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont12when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantImpl", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< DeleteTenantImplActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("deleteTenantImpl", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont12when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantImpl", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< DeleteTenantImplActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("deleteTenantImpl", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantImpl", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 753 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 753 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	TenantName beginTenant;
															#line 753 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	Optional<TenantName> endTenant;
															#line 753 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	std::map<TenantName, int64_t> tenants;
															#line 753 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	OperationType operationType;
															#line 753 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	TenantManagementWorkload* self;
															#line 8391 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
};
// This generated class is to be used only via deleteTenantImpl()
															#line 753 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
class DeleteTenantImplActor final : public Actor<Void>, public ActorCallback< DeleteTenantImplActor, 0, Void >, public ActorCallback< DeleteTenantImplActor, 1, Void >, public ActorCallback< DeleteTenantImplActor, 2, Void >, public ActorCallback< DeleteTenantImplActor, 3, Void >, public ActorCallback< DeleteTenantImplActor, 4, Optional<metacluster::MetaclusterTenantMapEntry> >, public ActorCallback< DeleteTenantImplActor, 5, Void >, public ActorCallback< DeleteTenantImplActor, 6, Void >, public FastAllocated<DeleteTenantImplActor>, public DeleteTenantImplActorState<DeleteTenantImplActor> {
															#line 8396 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
public:
	using FastAllocated<DeleteTenantImplActor>::operator new;
	using FastAllocated<DeleteTenantImplActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3379744613991791360UL, 6948116572176829440UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DeleteTenantImplActor, 0, Void >;
friend struct ActorCallback< DeleteTenantImplActor, 1, Void >;
friend struct ActorCallback< DeleteTenantImplActor, 2, Void >;
friend struct ActorCallback< DeleteTenantImplActor, 3, Void >;
friend struct ActorCallback< DeleteTenantImplActor, 4, Optional<metacluster::MetaclusterTenantMapEntry> >;
friend struct ActorCallback< DeleteTenantImplActor, 5, Void >;
friend struct ActorCallback< DeleteTenantImplActor, 6, Void >;
															#line 753 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	DeleteTenantImplActor(Reference<ReadYourWritesTransaction> const& tr,TenantName const& beginTenant,Optional<TenantName> const& endTenant,std::map<TenantName, int64_t> const& tenants,OperationType const& operationType,TenantManagementWorkload* const& self) 
															#line 8419 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   DeleteTenantImplActorState<DeleteTenantImplActor>(tr, beginTenant, endTenant, tenants, operationType, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("deleteTenantImpl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15709087701505673472UL, 17256617852694221824UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("deleteTenantImpl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("deleteTenantImpl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DeleteTenantImplActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DeleteTenantImplActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DeleteTenantImplActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< DeleteTenantImplActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< DeleteTenantImplActor, 4, Optional<metacluster::MetaclusterTenantMapEntry> >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< DeleteTenantImplActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< DeleteTenantImplActor, 6, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 753 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
[[nodiscard]] static Future<Void> deleteTenantImpl( Reference<ReadYourWritesTransaction> const& tr, TenantName const& beginTenant, Optional<TenantName> const& endTenant, std::map<TenantName, int64_t> const& tenants, OperationType const& operationType, TenantManagementWorkload* const& self ) {
															#line 753 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	return Future<Void>(new DeleteTenantImplActor(tr, beginTenant, endTenant, tenants, operationType, self));
															#line 8457 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
}

#line 800 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"

																#line 8462 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
// This generated class is to be used only via deleteTenant()
															#line 801 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
template <class DeleteTenantActor>
															#line 801 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
class DeleteTenantActorState {
															#line 8468 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
public:
															#line 801 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	DeleteTenantActorState(TenantManagementWorkload* const& self) 
															#line 801 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
															#line 801 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		 : self(self),
															#line 802 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   watchTenantCheck(deterministicRandom()->coinflip()),
															#line 803 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   beginTenant(self->chooseTenantName(true)),
															#line 804 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   operationType(self->randomOperationType()),
															#line 805 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   tr(makeReference<ReadYourWritesTransaction>(self->dataDb)),
															#line 808 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   endTenant(operationType != OperationType::MANAGEMENT_DATABASE && operationType != OperationType::METACLUSTER && !beginTenant.startsWith("\xff"_sr) && deterministicRandom()->random01() < 0.2 ? Optional<TenantName>(self->chooseTenantName(false)) : Optional<TenantName>())
															#line 8485 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("deleteTenant", reinterpret_cast<unsigned long>(this));

	}
	~DeleteTenantActorState() 
	{
		fdb_probe_actor_destroy("deleteTenant", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 814 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (endTenant.present() && endTenant < beginTenant)
															#line 8500 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			{
															#line 815 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				TenantName temp = beginTenant;
															#line 816 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				beginTenant = endTenant.get();
															#line 817 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				endTenant = temp;
															#line 8508 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			}
															#line 820 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			auto itr = self->createdTenants.find(beginTenant);
															#line 824 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			alreadyExists = itr != self->createdTenants.end();
															#line 827 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			existedAtStart = alreadyExists;
															#line 830 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			isEmpty = true;
															#line 833 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			anyExists = alreadyExists;
															#line 836 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			tenants = std::map<TenantName, int64_t>();
															#line 837 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (!endTenant.present())
															#line 8524 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			{
															#line 838 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				tenants[beginTenant] = anyExists ? itr->second.tenant->id() : TenantInfo::INVALID_TENANT;
															#line 8528 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			}
			else
			{
															#line 839 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				if (endTenant.present())
															#line 8534 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				{
															#line 840 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					anyExists = false;
															#line 841 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					for(auto itr = self->createdTenants.lower_bound(beginTenant);itr != self->createdTenants.end() && itr->first < endTenant.get();++itr) {
															#line 844 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						tenants[itr->first] = itr->second.tenant->id();
															#line 845 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						anyExists = true;
															#line 8544 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					}
				}
			}
															#line 850 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			tenantItr = std::map<TenantName, int64_t>::iterator();
															#line 851 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			watchFutures = std::vector<std::pair<TenantName, Future<ErrorOr<Void>>>>();
															#line 8552 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			try {
															#line 853 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				if (alreadyExists || endTenant.present())
															#line 8556 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				{
															#line 854 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					tenantItr = tenants.begin();
															#line 8560 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					loopDepth = a_body1loopHead1(loopDepth);
				}
				else
				{
					loopDepth = a_body1cont7(loopDepth);
				}
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DeleteTenantActorState();
		static_cast<DeleteTenantActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 886 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		StrictFuture<Version> __when_expr_1 = self->getLatestReadVersion(self, operationType);
															#line 886 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (static_cast<DeleteTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8596 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DeleteTenantActor*>(this)->actor_wait_state = 2;
															#line 886 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantActor, 1, Version >*>(static_cast<DeleteTenantActor*>(this)));
															#line 8601 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 877 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			TraceEvent(SevError, "DeleteTenantFailure") .errorUnsuppressed(e) .detail("TenantName", beginTenant) .detail("EndTenant", endTenant);
															#line 881 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			ASSERT(false);
															#line 882 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (!static_cast<DeleteTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteTenantActorState(); static_cast<DeleteTenantActor*>(this)->destroy(); return 0; }
															#line 8615 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			new (&static_cast<DeleteTenantActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~DeleteTenantActorState();
			static_cast<DeleteTenantActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7(int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 854 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (!(tenantItr != tenants.end()))
															#line 8652 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 856 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		cleared = false;
															#line 857 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (deterministicRandom()->random01() < 0.9)
															#line 8660 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		{
															#line 858 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = store(cleared, clearTenantData(self, tenantItr->first));
															#line 858 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (static_cast<DeleteTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8666 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DeleteTenantActor*>(this)->actor_wait_state = 1;
															#line 858 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantActor, 0, Void >*>(static_cast<DeleteTenantActor*>(this)));
															#line 8671 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 869 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (!cleared)
															#line 8698 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		{
															#line 870 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			auto itr = self->createdTenants.find(tenantItr->first);
															#line 871 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			ASSERT(itr != self->createdTenants.end());
															#line 872 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			isEmpty = isEmpty && itr->second.empty;
															#line 8706 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		}
															#line 854 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		++tenantItr;
															#line 8710 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 861 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (cleared && watchTenantCheck)
															#line 8719 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		{
															#line 862 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			watchFutures.emplace_back( tenantItr->first, errorOr(watchTenant(self, self->createdTenants[tenantItr->first].tenant)));
															#line 8723 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 861 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (cleared && watchTenantCheck)
															#line 8733 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		{
															#line 862 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			watchFutures.emplace_back( tenantItr->first, errorOr(watchTenant(self, self->createdTenants[tenantItr->first].tenant)));
															#line 8737 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DeleteTenantActor*>(this)->actor_wait_state > 0) static_cast<DeleteTenantActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteTenantActor*>(this)->ActorCallback< DeleteTenantActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteTenantActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DeleteTenantActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DeleteTenantActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont9(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10(int loopDepth) 
	{
															#line 887 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		;
															#line 8835 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont10loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Version const& __originalReadVersion,int loopDepth) 
	{
															#line 886 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		originalReadVersion = __originalReadVersion;
															#line 8844 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Version && __originalReadVersion,int loopDepth) 
	{
		originalReadVersion = std::move(__originalReadVersion);
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DeleteTenantActor*>(this)->actor_wait_state > 0) static_cast<DeleteTenantActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteTenantActor*>(this)->ActorCallback< DeleteTenantActor, 1, Version >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteTenantActor, 1, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DeleteTenantActor, 1, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DeleteTenantActor, 1, Version >*,Error err) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont10loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont10loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10loopBody1(int loopDepth) 
	{
		try {
															#line 890 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			retried = false;
															#line 891 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			;
															#line 8933 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = a_body1cont10loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont10loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont10loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont10loopHead1(0);

		return loopDepth;
	}
	int a_body1cont10loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1016 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (e.code() == error_code_tenant_not_empty)
															#line 8955 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			{
															#line 1017 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				ASSERT(!isEmpty);
															#line 1018 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				if (!static_cast<DeleteTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteTenantActorState(); static_cast<DeleteTenantActor*>(this)->destroy(); return 0; }
															#line 8961 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				new (&static_cast<DeleteTenantActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~DeleteTenantActorState();
				static_cast<DeleteTenantActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 1019 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				if (e.code() == error_code_invalid_metacluster_operation)
															#line 8971 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				{
															#line 1020 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					ASSERT(operationType == OperationType::METACLUSTER != self->useMetacluster);
															#line 1021 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					if (!static_cast<DeleteTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteTenantActorState(); static_cast<DeleteTenantActor*>(this)->destroy(); return 0; }
															#line 8977 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					new (&static_cast<DeleteTenantActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~DeleteTenantActorState();
					static_cast<DeleteTenantActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
				else
				{
															#line 1025 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					if (operationType == OperationType::MANAGEMENT_DATABASE || operationType == OperationType::METACLUSTER)
															#line 8987 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					{
															#line 1027 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						if (e.code() == error_code_tenant_not_found)
															#line 8991 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
						{
															#line 1028 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
							ASSERT(!existedAtStart && !endTenant.present());
															#line 8995 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
						}
						else
						{
															#line 1030 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
							TraceEvent(SevError, "DeleteTenantFailure") .errorUnsuppressed(e) .detail("TenantName", beginTenant) .detail("EndTenant", endTenant);
															#line 1034 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
							ASSERT(false);
															#line 9003 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
						}
															#line 1036 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						if (!static_cast<DeleteTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteTenantActorState(); static_cast<DeleteTenantActor*>(this)->destroy(); return 0; }
															#line 9007 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
						new (&static_cast<DeleteTenantActor*>(this)->SAV< Void >::value()) Void(Void());
						this->~DeleteTenantActorState();
						static_cast<DeleteTenantActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
					else
					{
						try {
															#line 1042 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
							StrictFuture<Void> __when_expr_10 = tr->onError(e);
															#line 1042 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
							if (static_cast<DeleteTenantActor*>(this)->actor_wait_state < 0) return a_body1cont10loopBody1Catch1Catch1(actor_cancelled(), loopDepth);
															#line 9020 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
							if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1cont10loopBody1Catch1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont10loopBody1Catch1when1(__when_expr_10.get(), loopDepth); };
							static_cast<DeleteTenantActor*>(this)->actor_wait_state = 11;
															#line 1042 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
							__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantActor, 10, Void >*>(static_cast<DeleteTenantActor*>(this)));
															#line 9025 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
							loopDepth = 0;
						}
						catch (Error& error) {
							loopDepth = a_body1cont10loopBody1Catch1Catch1(error, loopDepth);
						} catch (...) {
							loopDepth = a_body1cont10loopBody1Catch1Catch1(unknown_error(), loopDepth);
						}
					}
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont10loopBody1cont2(int loopDepth) 
	{
															#line 958 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (!anyExists && operationType == OperationType::MANAGEMENT_TRANSACTION)
															#line 9049 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		{
															#line 959 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (!static_cast<DeleteTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteTenantActorState(); static_cast<DeleteTenantActor*>(this)->destroy(); return 0; }
															#line 9053 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			new (&static_cast<DeleteTenantActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~DeleteTenantActorState();
			static_cast<DeleteTenantActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 964 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (endTenant.present() && beginTenant == endTenant.get() && operationType == OperationType::SPECIAL_KEYS)
															#line 9061 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		{
															#line 966 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (!static_cast<DeleteTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteTenantActorState(); static_cast<DeleteTenantActor*>(this)->destroy(); return 0; }
															#line 9065 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			new (&static_cast<DeleteTenantActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~DeleteTenantActorState();
			static_cast<DeleteTenantActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 970 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT(self->useMetacluster == (operationType == OperationType::METACLUSTER));
															#line 974 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (!existedAtStart && !endTenant.present() && (operationType == OperationType::MANAGEMENT_TRANSACTION || operationType == OperationType::SPECIAL_KEYS))
															#line 9075 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		{
															#line 977 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (!static_cast<DeleteTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteTenantActorState(); static_cast<DeleteTenantActor*>(this)->destroy(); return 0; }
															#line 9079 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			new (&static_cast<DeleteTenantActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~DeleteTenantActorState();
			static_cast<DeleteTenantActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 980 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT(existedAtStart || endTenant.present());
															#line 983 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT(isEmpty);
															#line 985 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (tenants.size() > 0)
															#line 9091 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		{
															#line 986 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			StrictFuture<Versionstamp> __when_expr_8 = getLastTenantModification(self, operationType);
															#line 986 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (static_cast<DeleteTenantActor*>(this)->actor_wait_state < 0) return a_body1cont10loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9097 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont10loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont10loopBody1cont2when1(__when_expr_8.get(), loopDepth); };
			static_cast<DeleteTenantActor*>(this)->actor_wait_state = 9;
															#line 986 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantActor, 8, Versionstamp >*>(static_cast<DeleteTenantActor*>(this)));
															#line 9102 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont10loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont10loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 893 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			StrictFuture<Version> __when_expr_2 = getLatestReadVersion(self, OperationType::MANAGEMENT_DATABASE);
															#line 893 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (static_cast<DeleteTenantActor*>(this)->actor_wait_state < 0) return a_body1cont10loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9126 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont10loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont10loopBody1loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<DeleteTenantActor*>(this)->actor_wait_state = 3;
															#line 893 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantActor, 2, Version >*>(static_cast<DeleteTenantActor*>(this)));
															#line 9131 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont10loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont10loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont10loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont10loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont10loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10loopBody1loopBody1cont1(int loopDepth) 
	{
															#line 936 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (!tenants.empty())
															#line 9159 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		{
															#line 937 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (operationType == OperationType::METACLUSTER)
															#line 9163 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			{
															#line 939 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				StrictFuture<Optional<metacluster::MetaclusterTenantMapEntry>> __when_expr_6 = metacluster::tryGetTenant(self->mvDb, tenants.begin()->first);
															#line 939 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				if (static_cast<DeleteTenantActor*>(this)->actor_wait_state < 0) return a_body1cont10loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9169 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont10loopBody1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont10loopBody1loopBody1cont1when1(__when_expr_6.get(), loopDepth); };
				static_cast<DeleteTenantActor*>(this)->actor_wait_state = 7;
															#line 939 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantActor, 6, Optional<metacluster::MetaclusterTenantMapEntry> >*>(static_cast<DeleteTenantActor*>(this)));
															#line 9174 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 948 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				StrictFuture<Optional<TenantMapEntry>> __when_expr_7 = TenantAPI::tryGetTenant(self->dataDb.getReference(), tenants.begin()->first);
															#line 948 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				if (static_cast<DeleteTenantActor*>(this)->actor_wait_state < 0) return a_body1cont10loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9183 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont10loopBody1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1cont10loopBody1loopBody1cont1when2(__when_expr_7.get(), loopDepth); };
				static_cast<DeleteTenantActor*>(this)->actor_wait_state = 8;
															#line 948 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantActor, 7, Optional<TenantMapEntry> >*>(static_cast<DeleteTenantActor*>(this)));
															#line 9188 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				loopDepth = 0;
			}
		}
		else
		{
			loopDepth = a_body1cont10loopBody1loopBody1cont13(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 921 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (e.code() == error_code_tenant_not_found && existedAtStart)
															#line 9204 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			{
															#line 922 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				ASSERT(operationType == OperationType::METACLUSTER || operationType == OperationType::MANAGEMENT_DATABASE);
															#line 924 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				ASSERT(retried);
															#line 9210 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				return a_body1cont10loopBody1break1(loopDepth==0?0:loopDepth-1); // break
			}
			else
			{
															#line 926 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				if (e.code() == error_code_grv_proxy_memory_limit_exceeded || e.code() == error_code_batch_transaction_throttled)
															#line 9217 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				{
															#line 929 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					StrictFuture<Void> __when_expr_5 = tr->onError(e);
															#line 929 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					if (static_cast<DeleteTenantActor*>(this)->actor_wait_state < 0) return a_body1cont10loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9223 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont10loopBody1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont10loopBody1loopBody1Catch1when1(__when_expr_5.get(), loopDepth); };
					static_cast<DeleteTenantActor*>(this)->actor_wait_state = 6;
															#line 929 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantActor, 5, Void >*>(static_cast<DeleteTenantActor*>(this)));
															#line 9228 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 932 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					return a_body1cont10loopBody1Catch1(e, std::max(0, loopDepth - 1));
															#line 9235 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1cont10loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont10loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont10loopBody1loopBody1cont2(int loopDepth) 
	{
															#line 895 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		StrictFuture<Optional<Void>> __when_expr_3 = timeout(deleteTenantImpl(tr, beginTenant, endTenant, tenants, operationType, self), deterministicRandom()->randomInt(1, 30));
															#line 895 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (static_cast<DeleteTenantActor*>(this)->actor_wait_state < 0) return a_body1cont10loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9253 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont10loopBody1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont10loopBody1loopBody1cont2when1(__when_expr_3.get(), loopDepth); };
		static_cast<DeleteTenantActor*>(this)->actor_wait_state = 4;
															#line 895 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantActor, 3, Optional<Void> >*>(static_cast<DeleteTenantActor*>(this)));
															#line 9258 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10loopBody1loopBody1when1(Version const& __beforeVersion,int loopDepth) 
	{
															#line 893 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		beforeVersion = __beforeVersion;
															#line 9267 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont10loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont10loopBody1loopBody1when1(Version && __beforeVersion,int loopDepth) 
	{
		beforeVersion = std::move(__beforeVersion);
		loopDepth = a_body1cont10loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DeleteTenantActor*>(this)->actor_wait_state > 0) static_cast<DeleteTenantActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteTenantActor*>(this)->ActorCallback< DeleteTenantActor, 2, Version >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteTenantActor, 2, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont10loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont10loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont10loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DeleteTenantActor, 2, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont10loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont10loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont10loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DeleteTenantActor, 2, Version >*,Error err) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont10loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont10loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont10loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont10loopBody1loopBody1cont3(Optional<Void> const& result,int loopDepth) 
	{
															#line 899 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (result.present())
															#line 9346 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		{
															#line 900 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (anyExists)
															#line 9350 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			{
															#line 901 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				if (self->oldestDeletionVersion == 0 && !tenants.empty())
															#line 9354 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				{
															#line 902 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					StrictFuture<Version> __when_expr_4 = self->getLatestReadVersion(self, OperationType::MANAGEMENT_DATABASE);
															#line 902 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					if (static_cast<DeleteTenantActor*>(this)->actor_wait_state < 0) return a_body1cont10loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9360 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont10loopBody1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont10loopBody1loopBody1cont3when1(__when_expr_4.get(), loopDepth); };
					static_cast<DeleteTenantActor*>(this)->actor_wait_state = 5;
															#line 902 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantActor, 4, Version >*>(static_cast<DeleteTenantActor*>(this)));
															#line 9365 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont10loopBody1loopBody1cont6(loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1cont10loopBody1loopBody1cont5(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont10loopBody1loopBody1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10loopBody1loopBody1cont3(Optional<Void> && result,int loopDepth) 
	{
															#line 899 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (result.present())
															#line 9389 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		{
															#line 900 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (anyExists)
															#line 9393 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			{
															#line 901 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				if (self->oldestDeletionVersion == 0 && !tenants.empty())
															#line 9397 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				{
															#line 902 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					StrictFuture<Version> __when_expr_4 = self->getLatestReadVersion(self, OperationType::MANAGEMENT_DATABASE);
															#line 902 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					if (static_cast<DeleteTenantActor*>(this)->actor_wait_state < 0) return a_body1cont10loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9403 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont10loopBody1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont10loopBody1loopBody1cont3when1(__when_expr_4.get(), loopDepth); };
					static_cast<DeleteTenantActor*>(this)->actor_wait_state = 5;
															#line 902 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantActor, 4, Version >*>(static_cast<DeleteTenantActor*>(this)));
															#line 9408 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont10loopBody1loopBody1cont6(loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1cont10loopBody1loopBody1cont5(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont10loopBody1loopBody1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10loopBody1loopBody1cont2when1(Optional<Void> const& result,int loopDepth) 
	{
		loopDepth = a_body1cont10loopBody1loopBody1cont3(result, loopDepth);

		return loopDepth;
	}
	int a_body1cont10loopBody1loopBody1cont2when1(Optional<Void> && result,int loopDepth) 
	{
		loopDepth = a_body1cont10loopBody1loopBody1cont3(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<DeleteTenantActor*>(this)->actor_wait_state > 0) static_cast<DeleteTenantActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteTenantActor*>(this)->ActorCallback< DeleteTenantActor, 3, Optional<Void> >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteTenantActor, 3, Optional<Void> >*,Optional<Void> const& value) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont10loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont10loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont10loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< DeleteTenantActor, 3, Optional<Void> >*,Optional<Void> && value) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont10loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont10loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont10loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< DeleteTenantActor, 3, Optional<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont10loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont10loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont10loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont10loopBody1loopBody1cont4(int loopDepth) 
	{
															#line 915 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		retried = true;
															#line 916 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		tr->reset();
															#line 9509 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont10loopBody1loopBody1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont10loopBody1loopBody1cont5(int loopDepth) 
	{
															#line 910 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT(operationType == OperationType::SPECIAL_KEYS || operationType == OperationType::MANAGEMENT_TRANSACTION || alreadyExists);
															#line 9518 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		return a_body1cont10loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont10loopBody1loopBody1cont6(int loopDepth) 
	{
															#line 906 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		self->newestDeletionVersion = beforeVersion;
															#line 9527 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont10loopBody1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont10loopBody1loopBody1cont7(Version const& afterVersion,int loopDepth) 
	{
															#line 904 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		self->oldestDeletionVersion = afterVersion;
															#line 9536 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont10loopBody1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont10loopBody1loopBody1cont7(Version && afterVersion,int loopDepth) 
	{
															#line 904 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		self->oldestDeletionVersion = afterVersion;
															#line 9545 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont10loopBody1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont10loopBody1loopBody1cont3when1(Version const& afterVersion,int loopDepth) 
	{
		loopDepth = a_body1cont10loopBody1loopBody1cont7(afterVersion, loopDepth);

		return loopDepth;
	}
	int a_body1cont10loopBody1loopBody1cont3when1(Version && afterVersion,int loopDepth) 
	{
		loopDepth = a_body1cont10loopBody1loopBody1cont7(std::move(afterVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<DeleteTenantActor*>(this)->actor_wait_state > 0) static_cast<DeleteTenantActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteTenantActor*>(this)->ActorCallback< DeleteTenantActor, 4, Version >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteTenantActor, 4, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont10loopBody1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont10loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont10loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< DeleteTenantActor, 4, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont10loopBody1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont10loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont10loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< DeleteTenantActor, 4, Version >*,Error err) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont10loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont10loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont10loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont10loopBody1loopBody1cont12(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont10loopBody1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont10loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont10loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont10loopBody1loopBody1Catch1cont4(Void const& _,int loopDepth) 
	{
		return a_body1cont10loopBody1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1cont10loopBody1loopBody1Catch1cont4(Void && _,int loopDepth) 
	{
		return a_body1cont10loopBody1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1cont10loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10loopBody1loopBody1Catch1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10loopBody1loopBody1Catch1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<DeleteTenantActor*>(this)->actor_wait_state > 0) static_cast<DeleteTenantActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteTenantActor*>(this)->ActorCallback< DeleteTenantActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteTenantActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont10loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont10loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont10loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< DeleteTenantActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont10loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont10loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont10loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< DeleteTenantActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont10loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont10loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont10loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont10loopBody1loopBody1cont13(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont10loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont10loopBody1loopBody1cont14(int loopDepth) 
	{
		loopDepth = a_body1cont10loopBody1loopBody1cont13(loopDepth);

		return loopDepth;
	}
	int a_body1cont10loopBody1loopBody1cont15(Optional<metacluster::MetaclusterTenantMapEntry> const& resultEntry,int loopDepth) 
	{
															#line 941 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (!resultEntry.present())
															#line 9741 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		{
															#line 942 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			alreadyExists = false;
															#line 9745 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		}
		else
		{
															#line 944 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			ASSERT(resultEntry.get().tenantState == metacluster::TenantState::READY || resultEntry.get().tenantState == metacluster::TenantState::REMOVING);
															#line 9751 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		}
		loopDepth = a_body1cont10loopBody1loopBody1cont14(loopDepth);

		return loopDepth;
	}
	int a_body1cont10loopBody1loopBody1cont15(Optional<metacluster::MetaclusterTenantMapEntry> && resultEntry,int loopDepth) 
	{
															#line 941 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (!resultEntry.present())
															#line 9761 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		{
															#line 942 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			alreadyExists = false;
															#line 9765 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		}
		else
		{
															#line 944 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			ASSERT(resultEntry.get().tenantState == metacluster::TenantState::READY || resultEntry.get().tenantState == metacluster::TenantState::REMOVING);
															#line 9771 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		}
		loopDepth = a_body1cont10loopBody1loopBody1cont14(loopDepth);

		return loopDepth;
	}
	int a_body1cont10loopBody1loopBody1cont1when1(Optional<metacluster::MetaclusterTenantMapEntry> const& resultEntry,int loopDepth) 
	{
		loopDepth = a_body1cont10loopBody1loopBody1cont15(resultEntry, loopDepth);

		return loopDepth;
	}
	int a_body1cont10loopBody1loopBody1cont1when1(Optional<metacluster::MetaclusterTenantMapEntry> && resultEntry,int loopDepth) 
	{
		loopDepth = a_body1cont10loopBody1loopBody1cont15(std::move(resultEntry), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<DeleteTenantActor*>(this)->actor_wait_state > 0) static_cast<DeleteTenantActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteTenantActor*>(this)->ActorCallback< DeleteTenantActor, 6, Optional<metacluster::MetaclusterTenantMapEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteTenantActor, 6, Optional<metacluster::MetaclusterTenantMapEntry> >*,Optional<metacluster::MetaclusterTenantMapEntry> const& value) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont10loopBody1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont10loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont10loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< DeleteTenantActor, 6, Optional<metacluster::MetaclusterTenantMapEntry> >*,Optional<metacluster::MetaclusterTenantMapEntry> && value) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont10loopBody1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont10loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont10loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< DeleteTenantActor, 6, Optional<metacluster::MetaclusterTenantMapEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont10loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont10loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont10loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont10loopBody1loopBody1cont16(Optional<TenantMapEntry> const& tenantEntry,int loopDepth) 
	{
															#line 950 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (!tenantEntry.present())
															#line 9856 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		{
															#line 951 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			alreadyExists = false;
															#line 9860 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		}
		loopDepth = a_body1cont10loopBody1loopBody1cont14(loopDepth);

		return loopDepth;
	}
	int a_body1cont10loopBody1loopBody1cont16(Optional<TenantMapEntry> && tenantEntry,int loopDepth) 
	{
															#line 950 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (!tenantEntry.present())
															#line 9870 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		{
															#line 951 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			alreadyExists = false;
															#line 9874 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		}
		loopDepth = a_body1cont10loopBody1loopBody1cont14(loopDepth);

		return loopDepth;
	}
	int a_body1cont10loopBody1loopBody1cont1when2(Optional<TenantMapEntry> const& tenantEntry,int loopDepth) 
	{
		loopDepth = a_body1cont10loopBody1loopBody1cont16(tenantEntry, loopDepth);

		return loopDepth;
	}
	int a_body1cont10loopBody1loopBody1cont1when2(Optional<TenantMapEntry> && tenantEntry,int loopDepth) 
	{
		loopDepth = a_body1cont10loopBody1loopBody1cont16(std::move(tenantEntry), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<DeleteTenantActor*>(this)->actor_wait_state > 0) static_cast<DeleteTenantActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteTenantActor*>(this)->ActorCallback< DeleteTenantActor, 7, Optional<TenantMapEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteTenantActor, 7, Optional<TenantMapEntry> >*,Optional<TenantMapEntry> const& value) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont10loopBody1loopBody1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont10loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont10loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< DeleteTenantActor, 7, Optional<TenantMapEntry> >*,Optional<TenantMapEntry> && value) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont10loopBody1loopBody1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont10loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont10loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< DeleteTenantActor, 7, Optional<TenantMapEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont10loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont10loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont10loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont10loopBody1cont3(int loopDepth) 
	{
															#line 991 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		for( auto const& [name, id] : tenants ) {
															#line 992 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			auto itr = self->createdTenants.find(name);
															#line 993 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			ASSERT(itr != self->createdTenants.end());
															#line 996 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (itr->second.tenantGroup.present())
															#line 9965 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			{
															#line 997 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				auto tenantGroupItr = self->createdTenantGroups.find(itr->second.tenantGroup.get());
															#line 998 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				ASSERT(tenantGroupItr != self->createdTenantGroups.end());
															#line 999 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				if (--tenantGroupItr->second.tenantCount == 0)
															#line 9973 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				{
															#line 1000 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					self->createdTenantGroups.erase(tenantGroupItr);
															#line 9977 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				}
			}
															#line 1004 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			self->createdTenants.erase(name);
															#line 9982 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		}
															#line 1008 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		wi = 0;
															#line 1009 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		;
															#line 9988 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont10loopBody1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10loopBody1cont7(Versionstamp const& currentVersionstamp,int loopDepth) 
	{
															#line 987 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT_GT(currentVersionstamp.version, originalReadVersion);
															#line 9997 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont10loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont10loopBody1cont7(Versionstamp && currentVersionstamp,int loopDepth) 
	{
															#line 987 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT_GT(currentVersionstamp.version, originalReadVersion);
															#line 10006 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont10loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont10loopBody1cont2when1(Versionstamp const& currentVersionstamp,int loopDepth) 
	{
		loopDepth = a_body1cont10loopBody1cont7(currentVersionstamp, loopDepth);

		return loopDepth;
	}
	int a_body1cont10loopBody1cont2when1(Versionstamp && currentVersionstamp,int loopDepth) 
	{
		loopDepth = a_body1cont10loopBody1cont7(std::move(currentVersionstamp), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<DeleteTenantActor*>(this)->actor_wait_state > 0) static_cast<DeleteTenantActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteTenantActor*>(this)->ActorCallback< DeleteTenantActor, 8, Versionstamp >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteTenantActor, 8, Versionstamp >*,Versionstamp const& value) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont10loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont10loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont10loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< DeleteTenantActor, 8, Versionstamp >*,Versionstamp && value) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont10loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont10loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont10loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< DeleteTenantActor, 8, Versionstamp >*,Error err) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont10loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont10loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont10loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont10loopBody1cont9(int loopDepth) 
	{
															#line 1012 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		self->checkWatchOnDeletedTenant(watchFutures);
															#line 1014 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (!static_cast<DeleteTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteTenantActorState(); static_cast<DeleteTenantActor*>(this)->destroy(); return 0; }
															#line 10092 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		new (&static_cast<DeleteTenantActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DeleteTenantActorState();
		static_cast<DeleteTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10loopBody1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont10loopBody1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10loopBody1cont3loopBody1(int loopDepth) 
	{
															#line 1009 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (!(wi < watchFutures.size()))
															#line 10111 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		{
			return a_body1cont10loopBody1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1010 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_9 = ready(watchFutures[wi].second);
															#line 1010 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (static_cast<DeleteTenantActor*>(this)->actor_wait_state < 0) return a_body1cont10loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10119 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont10loopBody1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1cont10loopBody1cont3loopBody1when1(__when_expr_9.get(), loopDepth); };
		static_cast<DeleteTenantActor*>(this)->actor_wait_state = 10;
															#line 1010 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantActor, 9, Void >*>(static_cast<DeleteTenantActor*>(this)));
															#line 10124 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10loopBody1cont3break1(int loopDepth) 
	{
		try {
			return a_body1cont10loopBody1cont9(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont10loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont10loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10loopBody1cont3loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 1009 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		++wi;
															#line 10146 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont10loopBody1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont10loopBody1cont3loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 1009 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		++wi;
															#line 10155 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont10loopBody1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont10loopBody1cont3loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10loopBody1cont3loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10loopBody1cont3loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10loopBody1cont3loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<DeleteTenantActor*>(this)->actor_wait_state > 0) static_cast<DeleteTenantActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteTenantActor*>(this)->ActorCallback< DeleteTenantActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteTenantActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10loopBody1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont10loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont10loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< DeleteTenantActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10loopBody1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont10loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont10loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< DeleteTenantActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont10loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont10loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont10loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1cont10loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10loopBody1Catch1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont10loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10loopBody1Catch1cont5(int loopDepth) 
	{
		loopDepth = a_body1cont10loopBody1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont10loopBody1Catch1cont9(int loopDepth) 
	{
		loopDepth = a_body1cont10loopBody1Catch1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont10loopBody1Catch1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1044 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			TraceEvent(SevError, "DeleteTenantFailure") .errorUnsuppressed(e) .detail("TenantName", beginTenant) .detail("EndTenant", endTenant);
															#line 1048 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			ASSERT(false);
															#line 10266 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = a_body1cont10loopBody1Catch1cont9(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont10loopBody1Catch1cont10(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10loopBody1Catch1cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10loopBody1Catch1cont10(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10loopBody1Catch1cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10loopBody1Catch1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10loopBody1Catch1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<DeleteTenantActor*>(this)->actor_wait_state > 0) static_cast<DeleteTenantActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteTenantActor*>(this)->ActorCallback< DeleteTenantActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteTenantActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont10loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont10loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1cont10loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< DeleteTenantActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont10loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont10loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1cont10loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< DeleteTenantActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont10loopBody1Catch1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont10loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1cont10loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont10loopBody1Catch1cont10cont1(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont10loopBody1Catch1cont9(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 801 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	TenantManagementWorkload* self;
															#line 802 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	bool watchTenantCheck;
															#line 803 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	TenantName beginTenant;
															#line 804 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	OperationType operationType;
															#line 805 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 808 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	Optional<TenantName> endTenant;
															#line 824 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	bool alreadyExists;
															#line 827 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	bool existedAtStart;
															#line 830 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	bool isEmpty;
															#line 833 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	bool anyExists;
															#line 836 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	std::map<TenantName, int64_t> tenants;
															#line 850 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	std::map<TenantName, int64_t>::iterator tenantItr;
															#line 851 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	std::vector<std::pair<TenantName, Future<ErrorOr<Void>>>> watchFutures;
															#line 856 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	bool cleared;
															#line 886 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	Version originalReadVersion;
															#line 890 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	bool retried;
															#line 893 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	Version beforeVersion;
															#line 1008 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	int wi;
															#line 10413 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
};
// This generated class is to be used only via deleteTenant()
															#line 801 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
class DeleteTenantActor final : public Actor<Void>, public ActorCallback< DeleteTenantActor, 0, Void >, public ActorCallback< DeleteTenantActor, 1, Version >, public ActorCallback< DeleteTenantActor, 2, Version >, public ActorCallback< DeleteTenantActor, 3, Optional<Void> >, public ActorCallback< DeleteTenantActor, 4, Version >, public ActorCallback< DeleteTenantActor, 5, Void >, public ActorCallback< DeleteTenantActor, 6, Optional<metacluster::MetaclusterTenantMapEntry> >, public ActorCallback< DeleteTenantActor, 7, Optional<TenantMapEntry> >, public ActorCallback< DeleteTenantActor, 8, Versionstamp >, public ActorCallback< DeleteTenantActor, 9, Void >, public ActorCallback< DeleteTenantActor, 10, Void >, public FastAllocated<DeleteTenantActor>, public DeleteTenantActorState<DeleteTenantActor> {
															#line 10418 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
public:
	using FastAllocated<DeleteTenantActor>::operator new;
	using FastAllocated<DeleteTenantActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8450759301109780224UL, 10810377345411928320UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DeleteTenantActor, 0, Void >;
friend struct ActorCallback< DeleteTenantActor, 1, Version >;
friend struct ActorCallback< DeleteTenantActor, 2, Version >;
friend struct ActorCallback< DeleteTenantActor, 3, Optional<Void> >;
friend struct ActorCallback< DeleteTenantActor, 4, Version >;
friend struct ActorCallback< DeleteTenantActor, 5, Void >;
friend struct ActorCallback< DeleteTenantActor, 6, Optional<metacluster::MetaclusterTenantMapEntry> >;
friend struct ActorCallback< DeleteTenantActor, 7, Optional<TenantMapEntry> >;
friend struct ActorCallback< DeleteTenantActor, 8, Versionstamp >;
friend struct ActorCallback< DeleteTenantActor, 9, Void >;
friend struct ActorCallback< DeleteTenantActor, 10, Void >;
															#line 801 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	DeleteTenantActor(TenantManagementWorkload* const& self) 
															#line 10445 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   DeleteTenantActorState<DeleteTenantActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14546017859301560576UL, 18123705475076122368UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("deleteTenant");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DeleteTenantActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DeleteTenantActor, 1, Version >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DeleteTenantActor, 2, Version >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< DeleteTenantActor, 3, Optional<Void> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< DeleteTenantActor, 4, Version >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< DeleteTenantActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< DeleteTenantActor, 6, Optional<metacluster::MetaclusterTenantMapEntry> >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< DeleteTenantActor, 7, Optional<TenantMapEntry> >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< DeleteTenantActor, 8, Versionstamp >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< DeleteTenantActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< DeleteTenantActor, 10, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 801 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
[[nodiscard]] static Future<Void> deleteTenant( TenantManagementWorkload* const& self ) {
															#line 801 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	return Future<Void>(new DeleteTenantActor(self));
															#line 10487 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
}

#line 1054 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"

	// Performs some validation on a tenant's contents
																#line 10493 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
// This generated class is to be used only via checkTenantContents()
															#line 1056 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
template <class CheckTenantContentsActor>
															#line 1056 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
class CheckTenantContentsActorState {
															#line 10499 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
public:
															#line 1056 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	CheckTenantContentsActorState(TenantManagementWorkload* const& self,TenantName const& tenantName,TenantTestData const& tenantData) 
															#line 1056 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
															#line 1056 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		 : self(self),
															#line 1056 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   tenantName(tenantName),
															#line 1056 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   tenantData(tenantData),
															#line 1059 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   tr(self->dataDb, self->createdTenants[tenantName].tenant)
															#line 10512 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("checkTenantContents", reinterpret_cast<unsigned long>(this));

	}
	~CheckTenantContentsActorState() 
	{
		fdb_probe_actor_destroy("checkTenantContents", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1060 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			;
															#line 10527 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckTenantContentsActorState();
		static_cast<CheckTenantContentsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1086 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (!static_cast<CheckTenantContentsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckTenantContentsActorState(); static_cast<CheckTenantContentsActor*>(this)->destroy(); return 0; }
															#line 10550 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		new (&static_cast<CheckTenantContentsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckTenantContentsActorState();
		static_cast<CheckTenantContentsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1062 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_LOCK_AWARE);
															#line 1066 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(KeyRangeRef(""_sr, "\xff"_sr), 2);
															#line 1066 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (static_cast<CheckTenantContentsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10574 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckTenantContentsActor*>(this)->actor_wait_state = 1;
															#line 1066 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckTenantContentsActor, 0, RangeResult >*>(static_cast<CheckTenantContentsActor*>(this)));
															#line 10579 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1082 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 1082 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (static_cast<CheckTenantContentsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10616 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CheckTenantContentsActor*>(this)->actor_wait_state = 2;
															#line 1082 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckTenantContentsActor, 1, Void >*>(static_cast<CheckTenantContentsActor*>(this)));
															#line 10621 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 1069 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (tenantData.empty)
															#line 10636 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		{
															#line 1070 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			ASSERT(result.size() == 0);
															#line 10640 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		}
		else
		{
															#line 1075 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			CODE_PROBE(true, "Check tenant contents with data");
															#line 1076 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			ASSERT(result.size() == 1);
															#line 1077 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			ASSERT(result[0].key == self->keyName);
															#line 1078 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			ASSERT(result[0].value == tenantName);
															#line 10652 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& __result,int loopDepth) 
	{
															#line 1066 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		result = __result;
															#line 10662 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && __result,int loopDepth) 
	{
		result = std::move(__result);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckTenantContentsActor*>(this)->actor_wait_state > 0) static_cast<CheckTenantContentsActor*>(this)->actor_wait_state = 0;
		static_cast<CheckTenantContentsActor*>(this)->ActorCallback< CheckTenantContentsActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CheckTenantContentsActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("checkTenantContents", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTenantContentsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkTenantContents", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckTenantContentsActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("checkTenantContents", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTenantContentsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkTenantContents", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckTenantContentsActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("checkTenantContents", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTenantContentsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkTenantContents", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckTenantContentsActor*>(this)->actor_wait_state > 0) static_cast<CheckTenantContentsActor*>(this)->actor_wait_state = 0;
		static_cast<CheckTenantContentsActor*>(this)->ActorCallback< CheckTenantContentsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckTenantContentsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkTenantContents", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTenantContentsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkTenantContents", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckTenantContentsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkTenantContents", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTenantContentsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkTenantContents", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckTenantContentsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkTenantContents", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTenantContentsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkTenantContents", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1056 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	TenantManagementWorkload* self;
															#line 1056 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	TenantName tenantName;
															#line 1056 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	TenantTestData tenantData;
															#line 1059 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	Transaction tr;
															#line 1066 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	RangeResult result;
															#line 10834 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
};
// This generated class is to be used only via checkTenantContents()
															#line 1056 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
class CheckTenantContentsActor final : public Actor<Void>, public ActorCallback< CheckTenantContentsActor, 0, RangeResult >, public ActorCallback< CheckTenantContentsActor, 1, Void >, public FastAllocated<CheckTenantContentsActor>, public CheckTenantContentsActorState<CheckTenantContentsActor> {
															#line 10839 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
public:
	using FastAllocated<CheckTenantContentsActor>::operator new;
	using FastAllocated<CheckTenantContentsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12953288594482425344UL, 2315474369486224384UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckTenantContentsActor, 0, RangeResult >;
friend struct ActorCallback< CheckTenantContentsActor, 1, Void >;
															#line 1056 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	CheckTenantContentsActor(TenantManagementWorkload* const& self,TenantName const& tenantName,TenantTestData const& tenantData) 
															#line 10857 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   CheckTenantContentsActorState<CheckTenantContentsActor>(self, tenantName, tenantData),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkTenantContents", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9256351566928764416UL, 15445598721491574784UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTenantContentsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkTenantContents");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkTenantContents", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckTenantContentsActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckTenantContentsActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1056 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
[[nodiscard]] static Future<Void> checkTenantContents( TenantManagementWorkload* const& self, TenantName const& tenantName, TenantTestData const& tenantData ) {
															#line 1056 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	return Future<Void>(new CheckTenantContentsActor(self, tenantName, tenantData));
															#line 10890 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
}

#line 1088 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"

	// Convert the JSON document returned by the special-key space when reading tenant metadata
	// into a TenantMapEntry
	static TenantMapEntry jsonToTenantMapEntry(ValueRef tenantJson) {
		json_spirit::mValue jsonObject;
		json_spirit::read_string(tenantJson.toString(), jsonObject);
		JSONDoc jsonDoc(jsonObject);

		int64_t id;

		std::string name;
		std::string base64Name;
		std::string printableName;
		std::string prefix;
		std::string base64Prefix;
		std::string printablePrefix;
		std::string tenantStateStr;
		std::string base64TenantGroup;
		std::string printableTenantGroup;
		std::string assignedClusterStr;

		jsonDoc.get("id", id);
		jsonDoc.get("name.base64", base64Name);
		jsonDoc.get("name.printable", printableName);

		name = base64::decoder::from_string(base64Name);
		ASSERT(name == unprintable(printableName));

		jsonDoc.get("prefix.base64", base64Prefix);
		jsonDoc.get("prefix.printable", printablePrefix);

		prefix = base64::decoder::from_string(base64Prefix);
		ASSERT(prefix == unprintable(printablePrefix));

		jsonDoc.get("tenant_state", tenantStateStr);

		Optional<TenantGroupName> tenantGroup;
		if (jsonDoc.tryGet("tenant_group.base64", base64TenantGroup)) {
			jsonDoc.get("tenant_group.printable", printableTenantGroup);
			std::string tenantGroupStr = base64::decoder::from_string(base64TenantGroup);
			ASSERT(tenantGroupStr == unprintable(printableTenantGroup));
			tenantGroup = TenantGroupNameRef(tenantGroupStr);
		}

		TenantMapEntry entry(id, TenantNameRef(name), tenantGroup);
		ASSERT(entry.prefix == prefix);
		return entry;
	}

	// Gets the metadata for a tenant using the specified operation type
																#line 10944 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
// This generated class is to be used only via getTenantImpl()
															#line 1138 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
template <class GetTenantImplActor>
															#line 1138 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
class GetTenantImplActorState {
															#line 10950 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
public:
															#line 1138 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	GetTenantImplActorState(Reference<ReadYourWritesTransaction> const& tr,TenantName const& tenant,OperationType const& operationType,TenantManagementWorkload* const& self) 
															#line 1138 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
															#line 1138 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		 : tr(tr),
															#line 1138 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   tenant(tenant),
															#line 1138 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   operationType(operationType),
															#line 1138 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   self(self),
															#line 1142 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   entry()
															#line 10965 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("getTenantImpl", reinterpret_cast<unsigned long>(this));

	}
	~GetTenantImplActorState() 
	{
		fdb_probe_actor_destroy("getTenantImpl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1143 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (operationType == OperationType::SPECIAL_KEYS)
															#line 10980 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			{
															#line 1144 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				Key key = self->specialKeysTenantMapPrefix.withSuffix(tenant);
															#line 1145 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				StrictFuture<Optional<Value>> __when_expr_0 = tr->get(key);
															#line 1145 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				if (static_cast<GetTenantImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10988 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetTenantImplActor*>(this)->actor_wait_state = 1;
															#line 1145 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetTenantImplActor, 0, Optional<Value> >*>(static_cast<GetTenantImplActor*>(this)));
															#line 10993 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 1150 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				if (operationType == OperationType::MANAGEMENT_DATABASE)
															#line 11000 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				{
															#line 1151 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					StrictFuture<Void> __when_expr_1 = store(entry, TenantAPI::getTenant(self->dataDb.getReference(), tenant));
															#line 1151 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					if (static_cast<GetTenantImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11006 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
					static_cast<GetTenantImplActor*>(this)->actor_wait_state = 2;
															#line 1151 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetTenantImplActor, 1, Void >*>(static_cast<GetTenantImplActor*>(this)));
															#line 11011 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 1152 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					if (operationType == OperationType::MANAGEMENT_TRANSACTION)
															#line 11018 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					{
															#line 1153 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 1154 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						StrictFuture<Void> __when_expr_2 = store(entry, TenantAPI::getTenantTransaction(tr, tenant));
															#line 1154 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						if (static_cast<GetTenantImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11026 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
						if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1when3(__when_expr_2.get(), loopDepth); };
						static_cast<GetTenantImplActor*>(this)->actor_wait_state = 3;
															#line 1154 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetTenantImplActor, 2, Void >*>(static_cast<GetTenantImplActor*>(this)));
															#line 11031 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
						loopDepth = 0;
					}
					else
					{
						loopDepth = a_body1cont7(loopDepth);
					}
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetTenantImplActorState();
		static_cast<GetTenantImplActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1157 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (!static_cast<GetTenantImplActor*>(this)->SAV<TenantMapEntry>::futures) { (void)(entry); this->~GetTenantImplActorState(); static_cast<GetTenantImplActor*>(this)->destroy(); return 0; }
															#line 11061 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		new (&static_cast<GetTenantImplActor*>(this)->SAV< TenantMapEntry >::value()) TenantMapEntry(std::move(entry)); // state_var_RVO
		this->~GetTenantImplActorState();
		static_cast<GetTenantImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Optional<Value> const& value,int loopDepth) 
	{
															#line 1146 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (!value.present())
															#line 11073 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		{
															#line 1147 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			return a_body1Catch1(tenant_not_found(), loopDepth);
															#line 11077 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		}
															#line 1149 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		entry = TenantManagementWorkload::jsonToTenantMapEntry(value.get());
															#line 11081 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Optional<Value> && value,int loopDepth) 
	{
															#line 1146 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (!value.present())
															#line 11090 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		{
															#line 1147 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			return a_body1Catch1(tenant_not_found(), loopDepth);
															#line 11094 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		}
															#line 1149 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		entry = TenantManagementWorkload::jsonToTenantMapEntry(value.get());
															#line 11098 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& value,int loopDepth) 
	{
		loopDepth = a_body1cont2(value, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && value,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetTenantImplActor*>(this)->actor_wait_state > 0) static_cast<GetTenantImplActor*>(this)->actor_wait_state = 0;
		static_cast<GetTenantImplActor*>(this)->ActorCallback< GetTenantImplActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetTenantImplActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("getTenantImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenantImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetTenantImplActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("getTenantImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenantImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetTenantImplActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("getTenantImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenantImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont5(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetTenantImplActor*>(this)->actor_wait_state > 0) static_cast<GetTenantImplActor*>(this)->actor_wait_state = 0;
		static_cast<GetTenantImplActor*>(this)->ActorCallback< GetTenantImplActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetTenantImplActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getTenantImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenantImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetTenantImplActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getTenantImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenantImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetTenantImplActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getTenantImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenantImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont7(int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetTenantImplActor*>(this)->actor_wait_state > 0) static_cast<GetTenantImplActor*>(this)->actor_wait_state = 0;
		static_cast<GetTenantImplActor*>(this)->ActorCallback< GetTenantImplActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetTenantImplActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getTenantImpl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenantImpl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetTenantImplActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getTenantImpl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenantImpl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetTenantImplActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getTenantImpl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenantImpl", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1138 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1138 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	TenantName tenant;
															#line 1138 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	OperationType operationType;
															#line 1138 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	TenantManagementWorkload* self;
															#line 1142 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	TenantMapEntry entry;
															#line 11374 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
};
// This generated class is to be used only via getTenantImpl()
															#line 1138 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
class GetTenantImplActor final : public Actor<TenantMapEntry>, public ActorCallback< GetTenantImplActor, 0, Optional<Value> >, public ActorCallback< GetTenantImplActor, 1, Void >, public ActorCallback< GetTenantImplActor, 2, Void >, public FastAllocated<GetTenantImplActor>, public GetTenantImplActorState<GetTenantImplActor> {
															#line 11379 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
public:
	using FastAllocated<GetTenantImplActor>::operator new;
	using FastAllocated<GetTenantImplActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4738009231390240256UL, 16222976433002555136UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<TenantMapEntry>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetTenantImplActor, 0, Optional<Value> >;
friend struct ActorCallback< GetTenantImplActor, 1, Void >;
friend struct ActorCallback< GetTenantImplActor, 2, Void >;
															#line 1138 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	GetTenantImplActor(Reference<ReadYourWritesTransaction> const& tr,TenantName const& tenant,OperationType const& operationType,TenantManagementWorkload* const& self) 
															#line 11398 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		 : Actor<TenantMapEntry>(),
		   GetTenantImplActorState<GetTenantImplActor>(tr, tenant, operationType, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getTenantImpl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(437177009536090368UL, 7309896219411848704UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getTenantImpl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getTenantImpl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetTenantImplActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetTenantImplActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetTenantImplActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1138 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
[[nodiscard]] static Future<TenantMapEntry> getTenantImpl( Reference<ReadYourWritesTransaction> const& tr, TenantName const& tenant, OperationType const& operationType, TenantManagementWorkload* const& self ) {
															#line 1138 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	return Future<TenantMapEntry>(new GetTenantImplActor(tr, tenant, operationType, self));
															#line 11432 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
}

#line 1159 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"

																#line 11437 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
// This generated class is to be used only via getTenant()
															#line 1160 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
template <class GetTenantActor>
															#line 1160 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
class GetTenantActorState {
															#line 11443 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
public:
															#line 1160 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	GetTenantActorState(TenantManagementWorkload* const& self) 
															#line 1160 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
															#line 1160 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		 : self(self),
															#line 1161 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   tenant(self->chooseTenantName(true)),
															#line 1162 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   operationType(self->randomOperationType()),
															#line 1163 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   tr(makeReference<ReadYourWritesTransaction>(self->dataDb))
															#line 11456 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("getTenant", reinterpret_cast<unsigned long>(this));

	}
	~GetTenantActorState() 
	{
		fdb_probe_actor_destroy("getTenant", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1166 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			auto itr = self->createdTenants.find(tenant);
															#line 1167 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			alreadyExists = itr != self->createdTenants.end() && !(operationType == OperationType::METACLUSTER && !self->useMetacluster);
															#line 1169 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			tenantData = alreadyExists ? itr->second : TenantTestData();
															#line 1171 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			;
															#line 11477 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetTenantActorState();
		static_cast<GetTenantActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1174 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			entryId = int64_t();
															#line 1175 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			tGroup = Optional<TenantGroupName>();
															#line 1176 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (operationType == OperationType::METACLUSTER)
															#line 11512 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			{
															#line 1177 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				StrictFuture<metacluster::MetaclusterTenantMapEntry> __when_expr_0 = metacluster::getTenant(self->mvDb, tenant);
															#line 1177 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				if (static_cast<GetTenantActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11518 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetTenantActor*>(this)->actor_wait_state = 1;
															#line 1177 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetTenantActor, 0, metacluster::MetaclusterTenantMapEntry >*>(static_cast<GetTenantActor*>(this)));
															#line 11523 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 1182 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				StrictFuture<TenantMapEntry> __when_expr_1 = getTenantImpl(tr, tenant, operationType, self);
															#line 1182 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				if (static_cast<GetTenantActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11532 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
				static_cast<GetTenantActor*>(this)->actor_wait_state = 2;
															#line 1182 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetTenantActor, 1, TenantMapEntry >*>(static_cast<GetTenantActor*>(this)));
															#line 11537 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1192 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			retry = false;
															#line 1193 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			error = e;
															#line 1195 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (e.code() == error_code_tenant_not_found)
															#line 11564 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			{
															#line 1196 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				ASSERT(!alreadyExists);
															#line 1197 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				if (!static_cast<GetTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetTenantActorState(); static_cast<GetTenantActor*>(this)->destroy(); return 0; }
															#line 11570 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				new (&static_cast<GetTenantActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~GetTenantActorState();
				static_cast<GetTenantActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 1201 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				if (operationType == OperationType::MANAGEMENT_TRANSACTION || operationType == OperationType::SPECIAL_KEYS)
															#line 11580 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				{
					try {
															#line 1204 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						retry = true;
															#line 1205 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						StrictFuture<Void> __when_expr_3 = tr->onError(e);
															#line 1205 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						if (static_cast<GetTenantActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1Catch1(actor_cancelled(), loopDepth);
															#line 11589 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
						if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
						static_cast<GetTenantActor*>(this)->actor_wait_state = 4;
															#line 1205 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetTenantActor, 3, Void >*>(static_cast<GetTenantActor*>(this)));
															#line 11594 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
						loopDepth = 0;
					}
					catch (Error& error) {
						loopDepth = a_body1loopBody1Catch1Catch1(error, loopDepth);
					} catch (...) {
						loopDepth = a_body1loopBody1Catch1Catch1(unknown_error(), loopDepth);
					}
				}
				else
				{
					loopDepth = a_body1loopBody1Catch1cont3(loopDepth);
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 1186 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT(alreadyExists);
															#line 1187 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT(entryId == tenantData.tenant->id());
															#line 1188 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT(tGroup == tenantData.tenantGroup);
															#line 1189 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_2 = checkTenantContents(self, tenant, tenantData);
															#line 1189 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (static_cast<GetTenantActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11629 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<GetTenantActor*>(this)->actor_wait_state = 3;
															#line 1189 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetTenantActor, 2, Void >*>(static_cast<GetTenantActor*>(this)));
															#line 11634 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 1179 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		entryId = metaEntry.id;
															#line 1180 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		tGroup = metaEntry.tenantGroup;
															#line 11645 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(metacluster::MetaclusterTenantMapEntry const& __metaEntry,int loopDepth) 
	{
															#line 1177 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		metaEntry = __metaEntry;
															#line 11654 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(metacluster::MetaclusterTenantMapEntry && __metaEntry,int loopDepth) 
	{
		metaEntry = std::move(__metaEntry);
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetTenantActor*>(this)->actor_wait_state > 0) static_cast<GetTenantActor*>(this)->actor_wait_state = 0;
		static_cast<GetTenantActor*>(this)->ActorCallback< GetTenantActor, 0, metacluster::MetaclusterTenantMapEntry >::remove();

	}
	void a_callback_fire(ActorCallback< GetTenantActor, 0, metacluster::MetaclusterTenantMapEntry >*,metacluster::MetaclusterTenantMapEntry const& value) 
	{
		fdb_probe_actor_enter("getTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetTenantActor, 0, metacluster::MetaclusterTenantMapEntry >*,metacluster::MetaclusterTenantMapEntry && value) 
	{
		fdb_probe_actor_enter("getTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetTenantActor, 0, metacluster::MetaclusterTenantMapEntry >*,Error err) 
	{
		fdb_probe_actor_enter("getTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
															#line 1183 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		entryId = normalEntry.id;
															#line 1184 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		tGroup = normalEntry.tenantGroup;
															#line 11735 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(TenantMapEntry const& __normalEntry,int loopDepth) 
	{
															#line 1182 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		normalEntry = __normalEntry;
															#line 11744 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(TenantMapEntry && __normalEntry,int loopDepth) 
	{
		normalEntry = std::move(__normalEntry);
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetTenantActor*>(this)->actor_wait_state > 0) static_cast<GetTenantActor*>(this)->actor_wait_state = 0;
		static_cast<GetTenantActor*>(this)->ActorCallback< GetTenantActor, 1, TenantMapEntry >::remove();

	}
	void a_callback_fire(ActorCallback< GetTenantActor, 1, TenantMapEntry >*,TenantMapEntry const& value) 
	{
		fdb_probe_actor_enter("getTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetTenantActor, 1, TenantMapEntry >*,TenantMapEntry && value) 
	{
		fdb_probe_actor_enter("getTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetTenantActor, 1, TenantMapEntry >*,Error err) 
	{
		fdb_probe_actor_enter("getTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont7(Void const& _,int loopDepth) 
	{
															#line 1190 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (!static_cast<GetTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetTenantActorState(); static_cast<GetTenantActor*>(this)->destroy(); return 0; }
															#line 11823 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		new (&static_cast<GetTenantActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetTenantActorState();
		static_cast<GetTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void && _,int loopDepth) 
	{
															#line 1190 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (!static_cast<GetTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetTenantActorState(); static_cast<GetTenantActor*>(this)->destroy(); return 0; }
															#line 11835 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		new (&static_cast<GetTenantActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetTenantActorState();
		static_cast<GetTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetTenantActor*>(this)->actor_wait_state > 0) static_cast<GetTenantActor*>(this)->actor_wait_state = 0;
		static_cast<GetTenantActor*>(this)->ActorCallback< GetTenantActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetTenantActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getTenant", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenant", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetTenantActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getTenant", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenant", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetTenantActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getTenant", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenant", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
															#line 1213 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (!retry)
															#line 11922 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		{
															#line 1214 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			TraceEvent(SevError, "GetTenantFailure").errorUnsuppressed(error).detail("TenantName", tenant);
															#line 1215 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			ASSERT(false);
															#line 11928 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont4(int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1208 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			error = e;
															#line 1209 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			retry = false;
															#line 11953 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = a_body1loopBody1Catch1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont5(Void const& _,int loopDepth) 
	{
															#line 1206 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		retry = true;
															#line 11968 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1Catch1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont5(Void && _,int loopDepth) 
	{
															#line 1206 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		retry = true;
															#line 11977 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1Catch1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<GetTenantActor*>(this)->actor_wait_state > 0) static_cast<GetTenantActor*>(this)->actor_wait_state = 0;
		static_cast<GetTenantActor*>(this)->ActorCallback< GetTenantActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetTenantActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getTenant", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenant", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetTenantActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getTenant", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenant", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetTenantActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getTenant", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenant", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1Catch1cont7(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1Catch1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 1160 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	TenantManagementWorkload* self;
															#line 1161 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	TenantName tenant;
															#line 1162 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	OperationType operationType;
															#line 1163 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1167 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	bool alreadyExists;
															#line 1169 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	TenantTestData tenantData;
															#line 1174 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	int64_t entryId;
															#line 1175 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	Optional<TenantGroupName> tGroup;
															#line 1177 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	metacluster::MetaclusterTenantMapEntry metaEntry;
															#line 1182 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	TenantMapEntry normalEntry;
															#line 1192 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	bool retry;
															#line 1193 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	Error error;
															#line 12094 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
};
// This generated class is to be used only via getTenant()
															#line 1160 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
class GetTenantActor final : public Actor<Void>, public ActorCallback< GetTenantActor, 0, metacluster::MetaclusterTenantMapEntry >, public ActorCallback< GetTenantActor, 1, TenantMapEntry >, public ActorCallback< GetTenantActor, 2, Void >, public ActorCallback< GetTenantActor, 3, Void >, public FastAllocated<GetTenantActor>, public GetTenantActorState<GetTenantActor> {
															#line 12099 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
public:
	using FastAllocated<GetTenantActor>::operator new;
	using FastAllocated<GetTenantActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(177646084114455808UL, 7821289326722476800UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetTenantActor, 0, metacluster::MetaclusterTenantMapEntry >;
friend struct ActorCallback< GetTenantActor, 1, TenantMapEntry >;
friend struct ActorCallback< GetTenantActor, 2, Void >;
friend struct ActorCallback< GetTenantActor, 3, Void >;
															#line 1160 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	GetTenantActor(TenantManagementWorkload* const& self) 
															#line 12119 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   GetTenantActorState<GetTenantActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getTenant", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5539216869899646464UL, 17063241412762073856UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getTenant");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getTenant", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetTenantActor, 0, metacluster::MetaclusterTenantMapEntry >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetTenantActor, 1, TenantMapEntry >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetTenantActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< GetTenantActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1160 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
[[nodiscard]] static Future<Void> getTenant( TenantManagementWorkload* const& self ) {
															#line 1160 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	return Future<Void>(new GetTenantActor(self));
															#line 12154 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
}

#line 1220 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"

	// Gets a list of tenants using the specified operation type
																#line 12160 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
// This generated class is to be used only via listTenantsImpl()
															#line 1222 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
template <class ListTenantsImplActor>
															#line 1222 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
class ListTenantsImplActorState {
															#line 12166 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
public:
															#line 1222 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	ListTenantsImplActorState(Reference<ReadYourWritesTransaction> const& tr,TenantName const& beginTenant,TenantName const& endTenant,int const& limit,OperationType const& operationType,TenantManagementWorkload* const& self) 
															#line 1222 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
															#line 1222 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		 : tr(tr),
															#line 1222 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   beginTenant(beginTenant),
															#line 1222 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   endTenant(endTenant),
															#line 1222 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   limit(limit),
															#line 1222 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   operationType(operationType),
															#line 1222 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   self(self),
															#line 1229 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   tenants()
															#line 12185 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("listTenantsImpl", reinterpret_cast<unsigned long>(this));

	}
	~ListTenantsImplActorState() 
	{
		fdb_probe_actor_destroy("listTenantsImpl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1231 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (operationType == OperationType::SPECIAL_KEYS)
															#line 12200 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			{
															#line 1232 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				KeyRange range = KeyRangeRef(beginTenant, endTenant).withPrefix(self->specialKeysTenantMapPrefix);
															#line 1233 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				StrictFuture<RangeResult> __when_expr_0 = tr->getRange(range, limit);
															#line 1233 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				if (static_cast<ListTenantsImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12208 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ListTenantsImplActor*>(this)->actor_wait_state = 1;
															#line 1233 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ListTenantsImplActor, 0, RangeResult >*>(static_cast<ListTenantsImplActor*>(this)));
															#line 12213 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 1238 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				if (operationType == OperationType::MANAGEMENT_DATABASE)
															#line 12220 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				{
															#line 1239 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					StrictFuture<Void> __when_expr_1 = store(tenants, TenantAPI::listTenantMetadata(self->dataDb.getReference(), beginTenant, endTenant, limit));
															#line 1239 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					if (static_cast<ListTenantsImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12226 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
					static_cast<ListTenantsImplActor*>(this)->actor_wait_state = 2;
															#line 1239 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ListTenantsImplActor, 1, Void >*>(static_cast<ListTenantsImplActor*>(this)));
															#line 12231 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 1241 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					if (operationType == OperationType::MANAGEMENT_TRANSACTION)
															#line 12238 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					{
															#line 1242 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 1243 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						StrictFuture<Void> __when_expr_2 = store(tenants, TenantAPI::listTenantMetadataTransaction(tr, beginTenant, endTenant, limit));
															#line 1243 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						if (static_cast<ListTenantsImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12246 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
						if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1when3(__when_expr_2.get(), loopDepth); };
						static_cast<ListTenantsImplActor*>(this)->actor_wait_state = 3;
															#line 1243 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ListTenantsImplActor, 2, Void >*>(static_cast<ListTenantsImplActor*>(this)));
															#line 12251 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
						loopDepth = 0;
					}
					else
					{
						loopDepth = a_body1cont7(loopDepth);
					}
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ListTenantsImplActorState();
		static_cast<ListTenantsImplActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1246 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (!static_cast<ListTenantsImplActor*>(this)->SAV<std::vector<std::pair<TenantName, TenantMapEntry>>>::futures) { (void)(tenants); this->~ListTenantsImplActorState(); static_cast<ListTenantsImplActor*>(this)->destroy(); return 0; }
															#line 12281 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		new (&static_cast<ListTenantsImplActor*>(this)->SAV< std::vector<std::pair<TenantName, TenantMapEntry>> >::value()) std::vector<std::pair<TenantName, TenantMapEntry>>(std::move(tenants)); // state_var_RVO
		this->~ListTenantsImplActorState();
		static_cast<ListTenantsImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(RangeResult const& results,int loopDepth) 
	{
															#line 1234 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		for( auto result : results ) {
															#line 1235 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			tenants.push_back(std::make_pair(result.key.removePrefix(self->specialKeysTenantMapPrefix), TenantManagementWorkload::jsonToTenantMapEntry(result.value)));
															#line 12295 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(RangeResult && results,int loopDepth) 
	{
															#line 1234 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		for( auto result : results ) {
															#line 1235 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			tenants.push_back(std::make_pair(result.key.removePrefix(self->specialKeysTenantMapPrefix), TenantManagementWorkload::jsonToTenantMapEntry(result.value)));
															#line 12307 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult const& results,int loopDepth) 
	{
		loopDepth = a_body1cont2(results, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && results,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(results), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ListTenantsImplActor*>(this)->actor_wait_state > 0) static_cast<ListTenantsImplActor*>(this)->actor_wait_state = 0;
		static_cast<ListTenantsImplActor*>(this)->ActorCallback< ListTenantsImplActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ListTenantsImplActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("listTenantsImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantsImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantsImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ListTenantsImplActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("listTenantsImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantsImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantsImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ListTenantsImplActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("listTenantsImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantsImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantsImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont5(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ListTenantsImplActor*>(this)->actor_wait_state > 0) static_cast<ListTenantsImplActor*>(this)->actor_wait_state = 0;
		static_cast<ListTenantsImplActor*>(this)->ActorCallback< ListTenantsImplActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ListTenantsImplActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("listTenantsImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantsImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantsImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ListTenantsImplActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("listTenantsImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantsImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantsImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ListTenantsImplActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("listTenantsImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantsImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantsImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont7(int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ListTenantsImplActor*>(this)->actor_wait_state > 0) static_cast<ListTenantsImplActor*>(this)->actor_wait_state = 0;
		static_cast<ListTenantsImplActor*>(this)->ActorCallback< ListTenantsImplActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ListTenantsImplActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("listTenantsImpl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantsImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantsImpl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ListTenantsImplActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("listTenantsImpl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantsImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantsImpl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ListTenantsImplActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("listTenantsImpl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantsImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantsImpl", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1222 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1222 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	TenantName beginTenant;
															#line 1222 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	TenantName endTenant;
															#line 1222 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	int limit;
															#line 1222 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	OperationType operationType;
															#line 1222 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	TenantManagementWorkload* self;
															#line 1229 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	std::vector<std::pair<TenantName, TenantMapEntry>> tenants;
															#line 12588 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
};
// This generated class is to be used only via listTenantsImpl()
															#line 1222 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
class ListTenantsImplActor final : public Actor<std::vector<std::pair<TenantName, TenantMapEntry>>>, public ActorCallback< ListTenantsImplActor, 0, RangeResult >, public ActorCallback< ListTenantsImplActor, 1, Void >, public ActorCallback< ListTenantsImplActor, 2, Void >, public FastAllocated<ListTenantsImplActor>, public ListTenantsImplActorState<ListTenantsImplActor> {
															#line 12593 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
public:
	using FastAllocated<ListTenantsImplActor>::operator new;
	using FastAllocated<ListTenantsImplActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9372876729625523456UL, 17143574919964413952UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<std::pair<TenantName, TenantMapEntry>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ListTenantsImplActor, 0, RangeResult >;
friend struct ActorCallback< ListTenantsImplActor, 1, Void >;
friend struct ActorCallback< ListTenantsImplActor, 2, Void >;
															#line 1222 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	ListTenantsImplActor(Reference<ReadYourWritesTransaction> const& tr,TenantName const& beginTenant,TenantName const& endTenant,int const& limit,OperationType const& operationType,TenantManagementWorkload* const& self) 
															#line 12612 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		 : Actor<std::vector<std::pair<TenantName, TenantMapEntry>>>(),
		   ListTenantsImplActorState<ListTenantsImplActor>(tr, beginTenant, endTenant, limit, operationType, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("listTenantsImpl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2375980233564395520UL, 15511024046131561216UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantsImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("listTenantsImpl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("listTenantsImpl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ListTenantsImplActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ListTenantsImplActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ListTenantsImplActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1222 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
[[nodiscard]] static Future<std::vector<std::pair<TenantName, TenantMapEntry>>> listTenantsImpl( Reference<ReadYourWritesTransaction> const& tr, TenantName const& beginTenant, TenantName const& endTenant, int const& limit, OperationType const& operationType, TenantManagementWorkload* const& self ) {
															#line 1222 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	return Future<std::vector<std::pair<TenantName, TenantMapEntry>>>(new ListTenantsImplActor(tr, beginTenant, endTenant, limit, operationType, self));
															#line 12646 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
}

#line 1248 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"

	template <class TenantMapEntryImpl>
	static Future<Void> verifyTenantList(TenantManagementWorkload* self,
	                                     std::vector<std::pair<TenantName, TenantMapEntryImpl>> tenants,
	                                     int limit,
	                                     TenantName beginTenant,
	                                     TenantName endTenant,
	                                     Optional<TenantGroupName> tenantGroup) {
		ASSERT(tenants.size() <= limit);

		// Compare the resulting tenant list to the list we expected to get
		auto localItr = self->createdTenants.lower_bound(beginTenant);
		auto tenantMapItr = tenants.begin();
		for (; tenantMapItr != tenants.end(); ++tenantMapItr, ++localItr) {
			if (tenantGroup.present()) {
				while (localItr != self->createdTenants.end() && localItr->second.tenantGroup != tenantGroup) {
					++localItr;
				}
			}
			ASSERT(localItr != self->createdTenants.end());
			ASSERT(localItr->first == tenantMapItr->first);
		}
		// "tenants" exhausted to end. If tenantGroup was specified,
		// continue iterating localItr until end to verify there are no matches
		if (tenantGroup.present() && tenants.size() < limit) {
			CODE_PROBE(localItr != self->createdTenants.end() && localItr->first < endTenant,
			           "Listed range contained extra tenants not in group");
			while (localItr != self->createdTenants.end() && localItr->first < endTenant) {
				ASSERT(localItr->second.tenantGroup != tenantGroup);
				++localItr;
			}
		}

		// Make sure the list terminated at the right spot
		ASSERT(tenants.size() == limit || localItr == self->createdTenants.end() || localItr->first >= endTenant);
		return Void();
	}

																#line 12688 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
// This generated class is to be used only via listTenants()
															#line 1286 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
template <class ListTenantsActor>
															#line 1286 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
class ListTenantsActorState {
															#line 12694 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
public:
															#line 1286 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	ListTenantsActorState(TenantManagementWorkload* const& self) 
															#line 1286 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
															#line 1286 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		 : self(self),
															#line 1287 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   beginTenant(self->chooseTenantName(false)),
															#line 1288 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   endTenant(self->chooseTenantName(false)),
															#line 1289 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   limit(std::min(CLIENT_KNOBS->MAX_TENANTS_PER_CLUSTER + 1, deterministicRandom()->randomInt(1, self->maxTenants * 2))),
															#line 1291 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   operationType(self->useMetacluster ? OperationType::METACLUSTER : self->randomOperationType()),
															#line 1293 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   tr(makeReference<ReadYourWritesTransaction>(self->dataDb)),
															#line 1294 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   tGroup(deterministicRandom()->coinflip() ? self->chooseTenantGroup(false, false) : Optional<TenantGroupName>())
															#line 12713 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("listTenants", reinterpret_cast<unsigned long>(this));

	}
	~ListTenantsActorState() 
	{
		fdb_probe_actor_destroy("listTenants", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1297 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (beginTenant > endTenant)
															#line 12728 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			{
															#line 1298 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				std::swap(beginTenant, endTenant);
															#line 12732 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			}
															#line 1301 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			;
															#line 12736 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ListTenantsActorState();
		static_cast<ListTenantsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1303 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (self->useMetacluster)
															#line 12767 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			{
															#line 1304 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				StrictFuture<std::vector<std::pair<TenantName, metacluster::MetaclusterTenantMapEntry>>> __when_expr_0 = metacluster::listTenantMetadata(self->mvDb, beginTenant, endTenant, limit, 0, std::vector<metacluster::TenantState>(), tGroup);
															#line 1304 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				if (static_cast<ListTenantsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 12773 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ListTenantsActor*>(this)->actor_wait_state = 1;
															#line 1304 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ListTenantsActor, 0, std::vector<std::pair<TenantName, metacluster::MetaclusterTenantMapEntry>> >*>(static_cast<ListTenantsActor*>(this)));
															#line 12778 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 1315 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				if (tGroup.present())
															#line 12785 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				{
															#line 1316 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					StrictFuture<std::vector<std::pair<TenantName, int64_t>>> __when_expr_1 = TenantAPI::listTenantGroupTenants(self->mvDb, tGroup.get(), beginTenant, endTenant, limit);
															#line 1316 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					if (static_cast<ListTenantsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 12791 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
					static_cast<ListTenantsActor*>(this)->actor_wait_state = 2;
															#line 1316 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ListTenantsActor, 1, std::vector<std::pair<TenantName, int64_t>> >*>(static_cast<ListTenantsActor*>(this)));
															#line 12796 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 1320 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					StrictFuture<std::vector<std::pair<TenantName, TenantMapEntry>>> __when_expr_2 = listTenantsImpl(tr, beginTenant, endTenant, limit, operationType, self);
															#line 1320 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					if (static_cast<ListTenantsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 12805 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1when3(__when_expr_2.get(), loopDepth); };
					static_cast<ListTenantsActor*>(this)->actor_wait_state = 3;
															#line 1320 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ListTenantsActor, 2, std::vector<std::pair<TenantName, TenantMapEntry>> >*>(static_cast<ListTenantsActor*>(this)));
															#line 12810 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					loopDepth = 0;
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1331 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			retry = false;
															#line 1332 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			error = e;
															#line 1335 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (!self->useMetacluster && (operationType == OperationType::MANAGEMENT_TRANSACTION || operationType == OperationType::SPECIAL_KEYS))
															#line 12838 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			{
				try {
															#line 1338 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					retry = true;
															#line 1339 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					StrictFuture<Void> __when_expr_3 = tr->onError(e);
															#line 1339 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					if (static_cast<ListTenantsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1Catch1(actor_cancelled(), loopDepth);
															#line 12847 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
					static_cast<ListTenantsActor*>(this)->actor_wait_state = 4;
															#line 1339 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ListTenantsActor, 3, Void >*>(static_cast<ListTenantsActor*>(this)));
															#line 12852 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					loopDepth = 0;
				}
				catch (Error& error) {
					loopDepth = a_body1loopBody1Catch1Catch1(error, loopDepth);
				} catch (...) {
					loopDepth = a_body1loopBody1Catch1Catch1(unknown_error(), loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1loopBody1Catch1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 1329 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (!static_cast<ListTenantsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ListTenantsActorState(); static_cast<ListTenantsActor*>(this)->destroy(); return 0; }
															#line 12878 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		new (&static_cast<ListTenantsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ListTenantsActorState();
		static_cast<ListTenantsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 1312 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		verifyTenantList<metacluster::MetaclusterTenantMapEntry>( self, metaTenants, limit, beginTenant, endTenant, tGroup);
															#line 12890 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<std::pair<TenantName, metacluster::MetaclusterTenantMapEntry>> const& __metaTenants,int loopDepth) 
	{
															#line 1304 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		metaTenants = __metaTenants;
															#line 12899 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<std::pair<TenantName, metacluster::MetaclusterTenantMapEntry>> && __metaTenants,int loopDepth) 
	{
		metaTenants = std::move(__metaTenants);
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ListTenantsActor*>(this)->actor_wait_state > 0) static_cast<ListTenantsActor*>(this)->actor_wait_state = 0;
		static_cast<ListTenantsActor*>(this)->ActorCallback< ListTenantsActor, 0, std::vector<std::pair<TenantName, metacluster::MetaclusterTenantMapEntry>> >::remove();

	}
	void a_callback_fire(ActorCallback< ListTenantsActor, 0, std::vector<std::pair<TenantName, metacluster::MetaclusterTenantMapEntry>> >*,std::vector<std::pair<TenantName, metacluster::MetaclusterTenantMapEntry>> const& value) 
	{
		fdb_probe_actor_enter("listTenants", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenants", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ListTenantsActor, 0, std::vector<std::pair<TenantName, metacluster::MetaclusterTenantMapEntry>> >*,std::vector<std::pair<TenantName, metacluster::MetaclusterTenantMapEntry>> && value) 
	{
		fdb_probe_actor_enter("listTenants", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenants", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ListTenantsActor, 0, std::vector<std::pair<TenantName, metacluster::MetaclusterTenantMapEntry>> >*,Error err) 
	{
		fdb_probe_actor_enter("listTenants", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenants", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
															#line 1318 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		verifyTenantList<int64_t>(self, tenantsFiltered, limit, beginTenant, endTenant, tGroup);
															#line 12984 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(std::vector<std::pair<TenantName, int64_t>> const& __tenantsFiltered,int loopDepth) 
	{
															#line 1316 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		tenantsFiltered = __tenantsFiltered;
															#line 12993 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(std::vector<std::pair<TenantName, int64_t>> && __tenantsFiltered,int loopDepth) 
	{
		tenantsFiltered = std::move(__tenantsFiltered);
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ListTenantsActor*>(this)->actor_wait_state > 0) static_cast<ListTenantsActor*>(this)->actor_wait_state = 0;
		static_cast<ListTenantsActor*>(this)->ActorCallback< ListTenantsActor, 1, std::vector<std::pair<TenantName, int64_t>> >::remove();

	}
	void a_callback_fire(ActorCallback< ListTenantsActor, 1, std::vector<std::pair<TenantName, int64_t>> >*,std::vector<std::pair<TenantName, int64_t>> const& value) 
	{
		fdb_probe_actor_enter("listTenants", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenants", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ListTenantsActor, 1, std::vector<std::pair<TenantName, int64_t>> >*,std::vector<std::pair<TenantName, int64_t>> && value) 
	{
		fdb_probe_actor_enter("listTenants", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenants", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ListTenantsActor, 1, std::vector<std::pair<TenantName, int64_t>> >*,Error err) 
	{
		fdb_probe_actor_enter("listTenants", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenants", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont8(int loopDepth) 
	{
															#line 1322 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (operationType == OperationType::METACLUSTER)
															#line 13072 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		{
															#line 1323 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			ASSERT_EQ(tenants.size(), 0);
															#line 1324 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (!static_cast<ListTenantsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ListTenantsActorState(); static_cast<ListTenantsActor*>(this)->destroy(); return 0; }
															#line 13078 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			new (&static_cast<ListTenantsActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~ListTenantsActorState();
			static_cast<ListTenantsActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1326 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		verifyTenantList<TenantMapEntry>(self, tenants, limit, beginTenant, endTenant, tGroup);
															#line 13086 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(std::vector<std::pair<TenantName, TenantMapEntry>> const& __tenants,int loopDepth) 
	{
															#line 1320 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		tenants = __tenants;
															#line 13095 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(std::vector<std::pair<TenantName, TenantMapEntry>> && __tenants,int loopDepth) 
	{
		tenants = std::move(__tenants);
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ListTenantsActor*>(this)->actor_wait_state > 0) static_cast<ListTenantsActor*>(this)->actor_wait_state = 0;
		static_cast<ListTenantsActor*>(this)->ActorCallback< ListTenantsActor, 2, std::vector<std::pair<TenantName, TenantMapEntry>> >::remove();

	}
	void a_callback_fire(ActorCallback< ListTenantsActor, 2, std::vector<std::pair<TenantName, TenantMapEntry>> >*,std::vector<std::pair<TenantName, TenantMapEntry>> const& value) 
	{
		fdb_probe_actor_enter("listTenants", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenants", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ListTenantsActor, 2, std::vector<std::pair<TenantName, TenantMapEntry>> >*,std::vector<std::pair<TenantName, TenantMapEntry>> && value) 
	{
		fdb_probe_actor_enter("listTenants", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenants", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ListTenantsActor, 2, std::vector<std::pair<TenantName, TenantMapEntry>> >*,Error err) 
	{
		fdb_probe_actor_enter("listTenants", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenants", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
															#line 1346 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (!retry)
															#line 13174 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		{
															#line 1347 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			TraceEvent(SevError, "ListTenantFailure") .errorUnsuppressed(error) .detail("BeginTenant", beginTenant) .detail("EndTenant", endTenant);
															#line 1352 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			ASSERT(false);
															#line 13180 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1341 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			error = e;
															#line 1342 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			retry = false;
															#line 13199 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = a_body1loopBody1Catch1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ListTenantsActor*>(this)->actor_wait_state > 0) static_cast<ListTenantsActor*>(this)->actor_wait_state = 0;
		static_cast<ListTenantsActor*>(this)->ActorCallback< ListTenantsActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ListTenantsActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("listTenants", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenants", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ListTenantsActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("listTenants", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenants", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ListTenantsActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("listTenants", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenants", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1Catch1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1Catch1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 1286 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	TenantManagementWorkload* self;
															#line 1287 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	TenantName beginTenant;
															#line 1288 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	TenantName endTenant;
															#line 1289 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	int limit;
															#line 1291 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	OperationType operationType;
															#line 1293 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1294 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	Optional<TenantGroupName> tGroup;
															#line 1304 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	std::vector<std::pair<TenantName, metacluster::MetaclusterTenantMapEntry>> metaTenants;
															#line 1316 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	std::vector<std::pair<TenantName, int64_t>> tenantsFiltered;
															#line 1320 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	std::vector<std::pair<TenantName, TenantMapEntry>> tenants;
															#line 1331 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	bool retry;
															#line 1332 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	Error error;
															#line 13334 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
};
// This generated class is to be used only via listTenants()
															#line 1286 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
class ListTenantsActor final : public Actor<Void>, public ActorCallback< ListTenantsActor, 0, std::vector<std::pair<TenantName, metacluster::MetaclusterTenantMapEntry>> >, public ActorCallback< ListTenantsActor, 1, std::vector<std::pair<TenantName, int64_t>> >, public ActorCallback< ListTenantsActor, 2, std::vector<std::pair<TenantName, TenantMapEntry>> >, public ActorCallback< ListTenantsActor, 3, Void >, public FastAllocated<ListTenantsActor>, public ListTenantsActorState<ListTenantsActor> {
															#line 13339 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
public:
	using FastAllocated<ListTenantsActor>::operator new;
	using FastAllocated<ListTenantsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17306800282592380928UL, 1940387241249772800UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ListTenantsActor, 0, std::vector<std::pair<TenantName, metacluster::MetaclusterTenantMapEntry>> >;
friend struct ActorCallback< ListTenantsActor, 1, std::vector<std::pair<TenantName, int64_t>> >;
friend struct ActorCallback< ListTenantsActor, 2, std::vector<std::pair<TenantName, TenantMapEntry>> >;
friend struct ActorCallback< ListTenantsActor, 3, Void >;
															#line 1286 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	ListTenantsActor(TenantManagementWorkload* const& self) 
															#line 13359 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   ListTenantsActorState<ListTenantsActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("listTenants", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11697288208682202880UL, 12510431615211719168UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("listTenants");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("listTenants", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ListTenantsActor, 0, std::vector<std::pair<TenantName, metacluster::MetaclusterTenantMapEntry>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ListTenantsActor, 1, std::vector<std::pair<TenantName, int64_t>> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ListTenantsActor, 2, std::vector<std::pair<TenantName, TenantMapEntry>> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ListTenantsActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1286 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
[[nodiscard]] static Future<Void> listTenants( TenantManagementWorkload* const& self ) {
															#line 1286 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	return Future<Void>(new ListTenantsActor(self));
															#line 13394 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
}

#line 1357 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"

	// Helper function that checks tenant keyspace and updates internal Tenant Map after a rename operation
																#line 13400 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
// This generated class is to be used only via verifyTenantRename()
															#line 1359 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
template <class VerifyTenantRenameActor>
															#line 1359 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
class VerifyTenantRenameActorState {
															#line 13406 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
public:
															#line 1359 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	VerifyTenantRenameActorState(TenantManagementWorkload* const& self,TenantName const& oldTenantName,TenantName const& newTenantName) 
															#line 1359 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
															#line 1359 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		 : self(self),
															#line 1359 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   oldTenantName(oldTenantName),
															#line 1359 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   newTenantName(newTenantName)
															#line 13417 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("verifyTenantRename", reinterpret_cast<unsigned long>(this));

	}
	~VerifyTenantRenameActorState() 
	{
		fdb_probe_actor_destroy("verifyTenantRename", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1362 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			StrictFuture<Optional<TenantMapEntry>> __when_expr_0 = TenantAPI::tryGetTenant(self->dataDb.getReference(), oldTenantName);
															#line 1362 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (static_cast<VerifyTenantRenameActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13434 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<VerifyTenantRenameActor*>(this)->actor_wait_state = 1;
															#line 1362 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< VerifyTenantRenameActor, 0, Optional<TenantMapEntry> >*>(static_cast<VerifyTenantRenameActor*>(this)));
															#line 13439 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~VerifyTenantRenameActorState();
		static_cast<VerifyTenantRenameActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1364 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		StrictFuture<Optional<TenantMapEntry>> __when_expr_1 = TenantAPI::tryGetTenant(self->dataDb.getReference(), newTenantName);
															#line 1364 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (static_cast<VerifyTenantRenameActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13464 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<VerifyTenantRenameActor*>(this)->actor_wait_state = 2;
															#line 1364 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< VerifyTenantRenameActor, 1, Optional<TenantMapEntry> >*>(static_cast<VerifyTenantRenameActor*>(this)));
															#line 13469 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Optional<TenantMapEntry> const& __oldTenantEntry,int loopDepth) 
	{
															#line 1362 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		oldTenantEntry = __oldTenantEntry;
															#line 13478 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<TenantMapEntry> && __oldTenantEntry,int loopDepth) 
	{
		oldTenantEntry = std::move(__oldTenantEntry);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<VerifyTenantRenameActor*>(this)->actor_wait_state > 0) static_cast<VerifyTenantRenameActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyTenantRenameActor*>(this)->ActorCallback< VerifyTenantRenameActor, 0, Optional<TenantMapEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyTenantRenameActor, 0, Optional<TenantMapEntry> >*,Optional<TenantMapEntry> const& value) 
	{
		fdb_probe_actor_enter("verifyTenantRename", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyTenantRenameActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyTenantRename", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< VerifyTenantRenameActor, 0, Optional<TenantMapEntry> >*,Optional<TenantMapEntry> && value) 
	{
		fdb_probe_actor_enter("verifyTenantRename", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyTenantRenameActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyTenantRename", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< VerifyTenantRenameActor, 0, Optional<TenantMapEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("verifyTenantRename", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyTenantRenameActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyTenantRename", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1366 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT(!oldTenantEntry.present());
															#line 1367 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT(newTenantEntry.present());
															#line 1368 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		TenantTestData tData = self->createdTenants[oldTenantName];
															#line 1369 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		tData.tenant->name = newTenantName;
															#line 1370 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		self->createdTenants[newTenantName] = tData;
															#line 1371 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		self->createdTenants.erase(oldTenantName);
															#line 1372 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		insertTr = Transaction(self->dataDb, tData.tenant);
															#line 1373 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (!tData.empty)
															#line 13571 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		{
															#line 1374 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			;
															#line 13575 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = a_body1cont2loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(Optional<TenantMapEntry> const& __newTenantEntry,int loopDepth) 
	{
															#line 1364 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		newTenantEntry = __newTenantEntry;
															#line 13589 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<TenantMapEntry> && __newTenantEntry,int loopDepth) 
	{
		newTenantEntry = std::move(__newTenantEntry);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<VerifyTenantRenameActor*>(this)->actor_wait_state > 0) static_cast<VerifyTenantRenameActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyTenantRenameActor*>(this)->ActorCallback< VerifyTenantRenameActor, 1, Optional<TenantMapEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyTenantRenameActor, 1, Optional<TenantMapEntry> >*,Optional<TenantMapEntry> const& value) 
	{
		fdb_probe_actor_enter("verifyTenantRename", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyTenantRenameActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyTenantRename", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< VerifyTenantRenameActor, 1, Optional<TenantMapEntry> >*,Optional<TenantMapEntry> && value) 
	{
		fdb_probe_actor_enter("verifyTenantRename", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyTenantRenameActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyTenantRename", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< VerifyTenantRenameActor, 1, Optional<TenantMapEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("verifyTenantRename", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyTenantRenameActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyTenantRename", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 1385 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (!static_cast<VerifyTenantRenameActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~VerifyTenantRenameActorState(); static_cast<VerifyTenantRenameActor*>(this)->destroy(); return 0; }
															#line 13668 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		new (&static_cast<VerifyTenantRenameActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~VerifyTenantRenameActorState();
		static_cast<VerifyTenantRenameActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
		try {
															#line 1376 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			insertTr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1377 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			insertTr.set(self->keyName, newTenantName);
															#line 1378 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_2 = insertTr.commit();
															#line 1378 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (static_cast<VerifyTenantRenameActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 13700 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont2loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<VerifyTenantRenameActor*>(this)->actor_wait_state = 3;
															#line 1378 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< VerifyTenantRenameActor, 2, Void >*>(static_cast<VerifyTenantRenameActor*>(this)));
															#line 13705 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1381 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_3 = insertTr.onError(e);
															#line 1381 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (static_cast<VerifyTenantRenameActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 13742 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<VerifyTenantRenameActor*>(this)->actor_wait_state = 4;
															#line 1381 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< VerifyTenantRenameActor, 3, Void >*>(static_cast<VerifyTenantRenameActor*>(this)));
															#line 13747 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<VerifyTenantRenameActor*>(this)->actor_wait_state > 0) static_cast<VerifyTenantRenameActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyTenantRenameActor*>(this)->ActorCallback< VerifyTenantRenameActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyTenantRenameActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("verifyTenantRename", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyTenantRenameActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyTenantRename", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< VerifyTenantRenameActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("verifyTenantRename", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyTenantRenameActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyTenantRename", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< VerifyTenantRenameActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("verifyTenantRename", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyTenantRenameActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyTenantRename", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont2loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<VerifyTenantRenameActor*>(this)->actor_wait_state > 0) static_cast<VerifyTenantRenameActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyTenantRenameActor*>(this)->ActorCallback< VerifyTenantRenameActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyTenantRenameActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("verifyTenantRename", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyTenantRenameActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyTenantRename", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< VerifyTenantRenameActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("verifyTenantRename", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyTenantRenameActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyTenantRename", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< VerifyTenantRenameActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("verifyTenantRename", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyTenantRenameActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyTenantRename", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 1359 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	TenantManagementWorkload* self;
															#line 1359 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	TenantName oldTenantName;
															#line 1359 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	TenantName newTenantName;
															#line 1362 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	Optional<TenantMapEntry> oldTenantEntry;
															#line 1364 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	Optional<TenantMapEntry> newTenantEntry;
															#line 1372 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	Transaction insertTr;
															#line 13944 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
};
// This generated class is to be used only via verifyTenantRename()
															#line 1359 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
class VerifyTenantRenameActor final : public Actor<Void>, public ActorCallback< VerifyTenantRenameActor, 0, Optional<TenantMapEntry> >, public ActorCallback< VerifyTenantRenameActor, 1, Optional<TenantMapEntry> >, public ActorCallback< VerifyTenantRenameActor, 2, Void >, public ActorCallback< VerifyTenantRenameActor, 3, Void >, public FastAllocated<VerifyTenantRenameActor>, public VerifyTenantRenameActorState<VerifyTenantRenameActor> {
															#line 13949 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
public:
	using FastAllocated<VerifyTenantRenameActor>::operator new;
	using FastAllocated<VerifyTenantRenameActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6519734571440682240UL, 14635471204825640960UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< VerifyTenantRenameActor, 0, Optional<TenantMapEntry> >;
friend struct ActorCallback< VerifyTenantRenameActor, 1, Optional<TenantMapEntry> >;
friend struct ActorCallback< VerifyTenantRenameActor, 2, Void >;
friend struct ActorCallback< VerifyTenantRenameActor, 3, Void >;
															#line 1359 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	VerifyTenantRenameActor(TenantManagementWorkload* const& self,TenantName const& oldTenantName,TenantName const& newTenantName) 
															#line 13969 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   VerifyTenantRenameActorState<VerifyTenantRenameActor>(self, oldTenantName, newTenantName),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("verifyTenantRename", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13912052224310319872UL, 8413125017319915264UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyTenantRenameActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("verifyTenantRename");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("verifyTenantRename", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< VerifyTenantRenameActor, 0, Optional<TenantMapEntry> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< VerifyTenantRenameActor, 1, Optional<TenantMapEntry> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< VerifyTenantRenameActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< VerifyTenantRenameActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1359 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
[[nodiscard]] static Future<Void> verifyTenantRename( TenantManagementWorkload* const& self, TenantName const& oldTenantName, TenantName const& newTenantName ) {
															#line 1359 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	return Future<Void>(new VerifyTenantRenameActor(self, oldTenantName, newTenantName));
															#line 14004 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
}

#line 1387 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"

																#line 14009 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
// This generated class is to be used only via verifyTenantRenames()
															#line 1388 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
template <class VerifyTenantRenamesActor>
															#line 1388 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
class VerifyTenantRenamesActorState {
															#line 14015 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
public:
															#line 1388 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	VerifyTenantRenamesActorState(TenantManagementWorkload* const& self,std::map<TenantName, TenantName> const& tenantRenames) 
															#line 1388 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
															#line 1388 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		 : self(self),
															#line 1388 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   tenantRenames(tenantRenames),
															#line 1390 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   tenantRenamesCopy(tenantRenames),
															#line 1391 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   iter(tenantRenamesCopy.begin())
															#line 14028 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("verifyTenantRenames", reinterpret_cast<unsigned long>(this));

	}
	~VerifyTenantRenamesActorState() 
	{
		fdb_probe_actor_destroy("verifyTenantRenames", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1392 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			;
															#line 14043 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~VerifyTenantRenamesActorState();
		static_cast<VerifyTenantRenamesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1396 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (!static_cast<VerifyTenantRenamesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~VerifyTenantRenamesActorState(); static_cast<VerifyTenantRenamesActor*>(this)->destroy(); return 0; }
															#line 14066 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		new (&static_cast<VerifyTenantRenamesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~VerifyTenantRenamesActorState();
		static_cast<VerifyTenantRenamesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1392 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (!(iter != tenantRenamesCopy.end()))
															#line 14085 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1393 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_0 = verifyTenantRename(self, iter->first, iter->second);
															#line 1393 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (static_cast<VerifyTenantRenamesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14093 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<VerifyTenantRenamesActor*>(this)->actor_wait_state = 1;
															#line 1393 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< VerifyTenantRenamesActor, 0, Void >*>(static_cast<VerifyTenantRenamesActor*>(this)));
															#line 14098 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 1394 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = checkTenantContents(self, iter->second, self->createdTenants[iter->second]);
															#line 1394 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (static_cast<VerifyTenantRenamesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14122 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<VerifyTenantRenamesActor*>(this)->actor_wait_state = 2;
															#line 1394 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< VerifyTenantRenamesActor, 1, Void >*>(static_cast<VerifyTenantRenamesActor*>(this)));
															#line 14127 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 1394 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = checkTenantContents(self, iter->second, self->createdTenants[iter->second]);
															#line 1394 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (static_cast<VerifyTenantRenamesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14138 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<VerifyTenantRenamesActor*>(this)->actor_wait_state = 2;
															#line 1394 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< VerifyTenantRenamesActor, 1, Void >*>(static_cast<VerifyTenantRenamesActor*>(this)));
															#line 14143 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<VerifyTenantRenamesActor*>(this)->actor_wait_state > 0) static_cast<VerifyTenantRenamesActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyTenantRenamesActor*>(this)->ActorCallback< VerifyTenantRenamesActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyTenantRenamesActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("verifyTenantRenames", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyTenantRenamesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyTenantRenames", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< VerifyTenantRenamesActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("verifyTenantRenames", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyTenantRenamesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyTenantRenames", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< VerifyTenantRenamesActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("verifyTenantRenames", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyTenantRenamesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyTenantRenames", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 1392 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		++iter;
															#line 14227 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 1392 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		++iter;
															#line 14236 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<VerifyTenantRenamesActor*>(this)->actor_wait_state > 0) static_cast<VerifyTenantRenamesActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyTenantRenamesActor*>(this)->ActorCallback< VerifyTenantRenamesActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyTenantRenamesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("verifyTenantRenames", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyTenantRenamesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyTenantRenames", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< VerifyTenantRenamesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("verifyTenantRenames", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyTenantRenamesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyTenantRenames", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< VerifyTenantRenamesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("verifyTenantRenames", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyTenantRenamesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyTenantRenames", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1388 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	TenantManagementWorkload* self;
															#line 1388 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	std::map<TenantName, TenantName> tenantRenames;
															#line 1390 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	std::map<TenantName, TenantName> tenantRenamesCopy;
															#line 1391 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	std::map<TenantName, TenantName>::iterator iter;
															#line 14324 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
};
// This generated class is to be used only via verifyTenantRenames()
															#line 1388 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
class VerifyTenantRenamesActor final : public Actor<Void>, public ActorCallback< VerifyTenantRenamesActor, 0, Void >, public ActorCallback< VerifyTenantRenamesActor, 1, Void >, public FastAllocated<VerifyTenantRenamesActor>, public VerifyTenantRenamesActorState<VerifyTenantRenamesActor> {
															#line 14329 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
public:
	using FastAllocated<VerifyTenantRenamesActor>::operator new;
	using FastAllocated<VerifyTenantRenamesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12810400246061752832UL, 3888222800888751616UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< VerifyTenantRenamesActor, 0, Void >;
friend struct ActorCallback< VerifyTenantRenamesActor, 1, Void >;
															#line 1388 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	VerifyTenantRenamesActor(TenantManagementWorkload* const& self,std::map<TenantName, TenantName> const& tenantRenames) 
															#line 14347 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   VerifyTenantRenamesActorState<VerifyTenantRenamesActor>(self, tenantRenames),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("verifyTenantRenames", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5338824594989659136UL, 13642618853544501248UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyTenantRenamesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("verifyTenantRenames");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("verifyTenantRenames", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< VerifyTenantRenamesActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< VerifyTenantRenamesActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1388 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
[[nodiscard]] static Future<Void> verifyTenantRenames( TenantManagementWorkload* const& self, std::map<TenantName, TenantName> const& tenantRenames ) {
															#line 1388 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	return Future<Void>(new VerifyTenantRenamesActor(self, tenantRenames));
															#line 14380 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
}

#line 1398 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"

																#line 14385 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
// This generated class is to be used only via renameTenantImpl()
															#line 1399 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
template <class RenameTenantImplActor>
															#line 1399 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
class RenameTenantImplActorState {
															#line 14391 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
public:
															#line 1399 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	RenameTenantImplActorState(TenantManagementWorkload* const& self,Reference<ReadYourWritesTransaction> const& tr,OperationType const& operationType,std::map<TenantName, TenantName> const& tenantRenames,bool const& tenantNotFound,bool const& tenantExists) 
															#line 1399 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
															#line 1399 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		 : self(self),
															#line 1399 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   tr(tr),
															#line 1399 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   operationType(operationType),
															#line 1399 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   tenantRenames(tenantRenames),
															#line 1399 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   tenantNotFound(tenantNotFound),
															#line 1399 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   tenantExists(tenantExists)
															#line 14408 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("renameTenantImpl", reinterpret_cast<unsigned long>(this));

	}
	~RenameTenantImplActorState() 
	{
		fdb_probe_actor_destroy("renameTenantImpl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1405 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (operationType == OperationType::SPECIAL_KEYS)
															#line 14423 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			{
															#line 1406 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				tr->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 1407 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				for( auto& iter : tenantRenames ) {
															#line 1408 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					tr->set(self->specialKeysTenantRenamePrefix.withSuffix(iter.first), iter.second);
															#line 14431 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				}
															#line 1410 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				StrictFuture<Void> __when_expr_0 = tr->commit();
															#line 1410 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				if (static_cast<RenameTenantImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14437 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<RenameTenantImplActor*>(this)->actor_wait_state = 1;
															#line 1410 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RenameTenantImplActor, 0, Void >*>(static_cast<RenameTenantImplActor*>(this)));
															#line 14442 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 1411 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				if (operationType == OperationType::MANAGEMENT_DATABASE)
															#line 14449 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				{
															#line 1412 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					ASSERT(tenantRenames.size() == 1);
															#line 1413 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					auto iter = tenantRenames.begin();
															#line 1414 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					StrictFuture<Void> __when_expr_1 = TenantAPI::renameTenant(self->dataDb.getReference(), iter->first, iter->second);
															#line 1414 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					if (static_cast<RenameTenantImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14459 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
					static_cast<RenameTenantImplActor*>(this)->actor_wait_state = 2;
															#line 1414 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RenameTenantImplActor, 1, Void >*>(static_cast<RenameTenantImplActor*>(this)));
															#line 14464 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 1416 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					if (operationType == OperationType::MANAGEMENT_TRANSACTION)
															#line 14471 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					{
															#line 1417 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1418 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						std::vector<Future<Void>> renameFutures;
															#line 1419 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						for( auto& iter : tenantRenames ) {
															#line 1420 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
							renameFutures.push_back(success(TenantAPI::renameTenantTransaction(tr, iter.first, iter.second)));
															#line 14481 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
						}
															#line 1422 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						StrictFuture<Void> __when_expr_2 = waitForAll(renameFutures);
															#line 1422 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						if (static_cast<RenameTenantImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14487 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
						if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1when3(__when_expr_2.get(), loopDepth); };
						static_cast<RenameTenantImplActor*>(this)->actor_wait_state = 3;
															#line 1422 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RenameTenantImplActor, 2, Void >*>(static_cast<RenameTenantImplActor*>(this)));
															#line 14492 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
						loopDepth = 0;
					}
					else
					{
															#line 1426 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						ASSERT(tenantRenames.size() == 1);
															#line 1427 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						auto iter = tenantRenames.begin();
															#line 1428 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						StrictFuture<Void> __when_expr_4 = metacluster::renameTenant(self->mvDb, iter->first, iter->second);
															#line 1428 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						if (static_cast<RenameTenantImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14505 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
						if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1when4(__when_expr_4.get(), loopDepth); };
						static_cast<RenameTenantImplActor*>(this)->actor_wait_state = 5;
															#line 1428 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RenameTenantImplActor, 4, Void >*>(static_cast<RenameTenantImplActor*>(this)));
															#line 14510 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
						loopDepth = 0;
					}
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RenameTenantImplActorState();
		static_cast<RenameTenantImplActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1430 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (!static_cast<RenameTenantImplActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RenameTenantImplActorState(); static_cast<RenameTenantImplActor*>(this)->destroy(); return 0; }
															#line 14536 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		new (&static_cast<RenameTenantImplActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RenameTenantImplActorState();
		static_cast<RenameTenantImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RenameTenantImplActor*>(this)->actor_wait_state > 0) static_cast<RenameTenantImplActor*>(this)->actor_wait_state = 0;
		static_cast<RenameTenantImplActor*>(this)->ActorCallback< RenameTenantImplActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RenameTenantImplActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("renameTenantImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenantImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RenameTenantImplActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("renameTenantImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenantImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RenameTenantImplActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("renameTenantImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenantImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 1415 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT(!tenantNotFound && !tenantExists);
															#line 14641 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 1415 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT(!tenantNotFound && !tenantExists);
															#line 14650 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RenameTenantImplActor*>(this)->actor_wait_state > 0) static_cast<RenameTenantImplActor*>(this)->actor_wait_state = 0;
		static_cast<RenameTenantImplActor*>(this)->ActorCallback< RenameTenantImplActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RenameTenantImplActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("renameTenantImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenantImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RenameTenantImplActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("renameTenantImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenantImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RenameTenantImplActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("renameTenantImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenantImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont7(int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
															#line 1423 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_3 = tr->commit();
															#line 1423 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (static_cast<RenameTenantImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14742 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont8when1(__when_expr_3.get(), loopDepth); };
		static_cast<RenameTenantImplActor*>(this)->actor_wait_state = 4;
															#line 1423 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RenameTenantImplActor, 3, Void >*>(static_cast<RenameTenantImplActor*>(this)));
															#line 14747 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
															#line 1423 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_3 = tr->commit();
															#line 1423 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (static_cast<RenameTenantImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14758 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont8when1(__when_expr_3.get(), loopDepth); };
		static_cast<RenameTenantImplActor*>(this)->actor_wait_state = 4;
															#line 1423 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RenameTenantImplActor, 3, Void >*>(static_cast<RenameTenantImplActor*>(this)));
															#line 14763 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RenameTenantImplActor*>(this)->actor_wait_state > 0) static_cast<RenameTenantImplActor*>(this)->actor_wait_state = 0;
		static_cast<RenameTenantImplActor*>(this)->ActorCallback< RenameTenantImplActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RenameTenantImplActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("renameTenantImpl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenantImpl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RenameTenantImplActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("renameTenantImpl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenantImpl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RenameTenantImplActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("renameTenantImpl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenantImpl", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont10(Void const& _,int loopDepth) 
	{
															#line 1424 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT(!tenantNotFound && !tenantExists);
															#line 14847 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont10(Void && _,int loopDepth) 
	{
															#line 1424 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT(!tenantNotFound && !tenantExists);
															#line 14856 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RenameTenantImplActor*>(this)->actor_wait_state > 0) static_cast<RenameTenantImplActor*>(this)->actor_wait_state = 0;
		static_cast<RenameTenantImplActor*>(this)->ActorCallback< RenameTenantImplActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RenameTenantImplActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("renameTenantImpl", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenantImpl", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RenameTenantImplActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("renameTenantImpl", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenantImpl", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RenameTenantImplActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("renameTenantImpl", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenantImpl", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont11(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont11(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1when4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1when4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<RenameTenantImplActor*>(this)->actor_wait_state > 0) static_cast<RenameTenantImplActor*>(this)->actor_wait_state = 0;
		static_cast<RenameTenantImplActor*>(this)->ActorCallback< RenameTenantImplActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RenameTenantImplActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("renameTenantImpl", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenantImpl", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< RenameTenantImplActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("renameTenantImpl", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenantImpl", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< RenameTenantImplActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("renameTenantImpl", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenantImpl", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 1399 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	TenantManagementWorkload* self;
															#line 1399 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1399 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	OperationType operationType;
															#line 1399 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	std::map<TenantName, TenantName> tenantRenames;
															#line 1399 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	bool tenantNotFound;
															#line 1399 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	bool tenantExists;
															#line 15035 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
};
// This generated class is to be used only via renameTenantImpl()
															#line 1399 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
class RenameTenantImplActor final : public Actor<Void>, public ActorCallback< RenameTenantImplActor, 0, Void >, public ActorCallback< RenameTenantImplActor, 1, Void >, public ActorCallback< RenameTenantImplActor, 2, Void >, public ActorCallback< RenameTenantImplActor, 3, Void >, public ActorCallback< RenameTenantImplActor, 4, Void >, public FastAllocated<RenameTenantImplActor>, public RenameTenantImplActorState<RenameTenantImplActor> {
															#line 15040 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
public:
	using FastAllocated<RenameTenantImplActor>::operator new;
	using FastAllocated<RenameTenantImplActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8125457681486674176UL, 17824715132867873280UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RenameTenantImplActor, 0, Void >;
friend struct ActorCallback< RenameTenantImplActor, 1, Void >;
friend struct ActorCallback< RenameTenantImplActor, 2, Void >;
friend struct ActorCallback< RenameTenantImplActor, 3, Void >;
friend struct ActorCallback< RenameTenantImplActor, 4, Void >;
															#line 1399 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	RenameTenantImplActor(TenantManagementWorkload* const& self,Reference<ReadYourWritesTransaction> const& tr,OperationType const& operationType,std::map<TenantName, TenantName> const& tenantRenames,bool const& tenantNotFound,bool const& tenantExists) 
															#line 15061 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   RenameTenantImplActorState<RenameTenantImplActor>(self, tr, operationType, tenantRenames, tenantNotFound, tenantExists),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("renameTenantImpl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5672583306721737216UL, 16046134024679803392UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("renameTenantImpl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("renameTenantImpl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RenameTenantImplActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RenameTenantImplActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RenameTenantImplActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RenameTenantImplActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< RenameTenantImplActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1399 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
[[nodiscard]] static Future<Void> renameTenantImpl( TenantManagementWorkload* const& self, Reference<ReadYourWritesTransaction> const& tr, OperationType const& operationType, std::map<TenantName, TenantName> const& tenantRenames, bool const& tenantNotFound, bool const& tenantExists ) {
															#line 1399 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	return Future<Void>(new RenameTenantImplActor(self, tr, operationType, tenantRenames, tenantNotFound, tenantExists));
															#line 15097 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
}

#line 1432 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"

																#line 15102 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
// This generated class is to be used only via renameTenant()
															#line 1433 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
template <class RenameTenantActor>
															#line 1433 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
class RenameTenantActorState {
															#line 15108 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
public:
															#line 1433 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	RenameTenantActorState(TenantManagementWorkload* const& self) 
															#line 1433 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
															#line 1433 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		 : self(self),
															#line 1434 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   operationType(self->randomOperationType()),
															#line 1435 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   numTenants(1),
															#line 1436 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   tr(self->dataDb->createTransaction())
															#line 15121 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("renameTenant", reinterpret_cast<unsigned long>(this));

	}
	~RenameTenantActorState() 
	{
		fdb_probe_actor_destroy("renameTenant", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1438 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (operationType == OperationType::SPECIAL_KEYS || operationType == OperationType::MANAGEMENT_TRANSACTION)
															#line 15136 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			{
															#line 1439 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				numTenants = deterministicRandom()->randomInt(1, 5);
															#line 15140 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			}
															#line 1442 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			tenantRenames = std::map<TenantName, TenantName>();
															#line 1443 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			allTenantNames = std::set<TenantName>();
															#line 1446 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			tenantExists = false;
															#line 1447 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			tenantNotFound = false;
															#line 1448 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			tenantOverlap = false;
															#line 1449 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			unknownResult = false;
															#line 1451 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			for(int i = 0;i < numTenants;++i) {
															#line 1452 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				TenantName oldTenant = self->chooseTenantName(false);
															#line 1453 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				TenantName newTenant = self->chooseTenantName(false);
															#line 1454 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				bool checkOverlap = oldTenant == newTenant || allTenantNames.contains(oldTenant) || allTenantNames.contains(newTenant);
															#line 1458 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				if (checkOverlap && (operationType == OperationType::MANAGEMENT_TRANSACTION || operationType == OperationType::MANAGEMENT_DATABASE))
															#line 15164 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				{
															#line 1460 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					--i;
															#line 15168 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					continue;
				}
															#line 1463 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				tenantOverlap = tenantOverlap || checkOverlap;
															#line 1464 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				tenantRenames[oldTenant] = newTenant;
															#line 1465 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				allTenantNames.insert(oldTenant);
															#line 1466 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				allTenantNames.insert(newTenant);
															#line 1467 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				if (!self->createdTenants.contains(oldTenant))
															#line 15181 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				{
															#line 1468 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					tenantNotFound = true;
															#line 15185 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				}
															#line 1470 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				if (self->createdTenants.contains(newTenant))
															#line 15189 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				{
															#line 1471 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					tenantExists = true;
															#line 15193 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				}
			}
															#line 1475 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			CODE_PROBE(tenantOverlap, "Attempting overlapping tenant renames");
															#line 1477 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			StrictFuture<Version> __when_expr_0 = self->getLatestReadVersion(self, operationType);
															#line 1477 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (static_cast<RenameTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15202 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RenameTenantActor*>(this)->actor_wait_state = 1;
															#line 1477 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RenameTenantActor, 0, Version >*>(static_cast<RenameTenantActor*>(this)));
															#line 15207 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RenameTenantActorState();
		static_cast<RenameTenantActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1478 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		;
															#line 15230 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Version const& __originalReadVersion,int loopDepth) 
	{
															#line 1477 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		originalReadVersion = __originalReadVersion;
															#line 15239 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Version && __originalReadVersion,int loopDepth) 
	{
		originalReadVersion = std::move(__originalReadVersion);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RenameTenantActor*>(this)->actor_wait_state > 0) static_cast<RenameTenantActor*>(this)->actor_wait_state = 0;
		static_cast<RenameTenantActor*>(this)->ActorCallback< RenameTenantActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< RenameTenantActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RenameTenantActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RenameTenantActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 1480 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_1 = renameTenantImpl(self, tr, operationType, tenantRenames, tenantNotFound, tenantExists);
															#line 1480 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (static_cast<RenameTenantActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 15328 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<RenameTenantActor*>(this)->actor_wait_state = 2;
															#line 1480 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RenameTenantActor, 1, Void >*>(static_cast<RenameTenantActor*>(this)));
															#line 15333 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1488 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (e.code() == error_code_tenant_not_found)
															#line 15355 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			{
															#line 1489 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				if (unknownResult)
															#line 15359 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				{
															#line 1490 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					StrictFuture<Void> __when_expr_4 = verifyTenantRenames(self, tenantRenames);
															#line 1490 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					if (static_cast<RenameTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15365 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
					static_cast<RenameTenantActor*>(this)->actor_wait_state = 5;
															#line 1490 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RenameTenantActor, 4, Void >*>(static_cast<RenameTenantActor*>(this)));
															#line 15370 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 1492 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					ASSERT(tenantNotFound);
															#line 15377 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					loopDepth = a_body1cont1loopBody1Catch1cont2(loopDepth);
				}
			}
			else
			{
															#line 1495 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				if (e.code() == error_code_tenant_already_exists)
															#line 15385 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				{
															#line 1496 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					if (unknownResult)
															#line 15389 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					{
															#line 1497 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						StrictFuture<Void> __when_expr_5 = verifyTenantRenames(self, tenantRenames);
															#line 1497 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						if (static_cast<RenameTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15395 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
						if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when2(__when_expr_5.get(), loopDepth); };
						static_cast<RenameTenantActor*>(this)->actor_wait_state = 6;
															#line 1497 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< RenameTenantActor, 5, Void >*>(static_cast<RenameTenantActor*>(this)));
															#line 15400 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
						loopDepth = 0;
					}
					else
					{
															#line 1499 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						ASSERT(tenantExists);
															#line 15407 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
						loopDepth = a_body1cont1loopBody1Catch1cont7(loopDepth);
					}
				}
				else
				{
															#line 1502 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					if (e.code() == error_code_special_keys_api_failure)
															#line 15415 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					{
															#line 1503 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						ASSERT(tenantOverlap);
															#line 1504 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						if (!static_cast<RenameTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RenameTenantActorState(); static_cast<RenameTenantActor*>(this)->destroy(); return 0; }
															#line 15421 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
						new (&static_cast<RenameTenantActor*>(this)->SAV< Void >::value()) Void(Void());
						this->~RenameTenantActorState();
						static_cast<RenameTenantActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
					else
					{
															#line 1505 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						if (e.code() == error_code_invalid_metacluster_operation)
															#line 15431 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
						{
															#line 1506 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
							ASSERT(operationType == OperationType::METACLUSTER != self->useMetacluster);
															#line 1507 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
							if (!static_cast<RenameTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RenameTenantActorState(); static_cast<RenameTenantActor*>(this)->destroy(); return 0; }
															#line 15437 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
							new (&static_cast<RenameTenantActor*>(this)->SAV< Void >::value()) Void(Void());
							this->~RenameTenantActorState();
							static_cast<RenameTenantActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
						else
						{
															#line 1508 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
							if (e.code() == error_code_cluster_no_capacity)
															#line 15447 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
							{
															#line 1511 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
								ASSERT(operationType == OperationType::METACLUSTER);
															#line 1512 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
								if (!static_cast<RenameTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RenameTenantActorState(); static_cast<RenameTenantActor*>(this)->destroy(); return 0; }
															#line 15453 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
								new (&static_cast<RenameTenantActor*>(this)->SAV< Void >::value()) Void(Void());
								this->~RenameTenantActorState();
								static_cast<RenameTenantActor*>(this)->finishSendAndDelPromiseRef();
								return 0;
							}
							else
							{
								try {
															#line 1518 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
									if (e.code() == error_code_commit_unknown_result)
															#line 15464 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
									{
															#line 1519 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
										ASSERT(operationType != OperationType::MANAGEMENT_DATABASE && operationType != OperationType::METACLUSTER);
															#line 1521 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
										unknownResult = true;
															#line 15470 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
									}
															#line 1523 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
									StrictFuture<Void> __when_expr_6 = tr->onError(e);
															#line 1523 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
									if (static_cast<RenameTenantActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1Catch1(actor_cancelled(), loopDepth);
															#line 15476 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
									if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont1loopBody1Catch1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont1loopBody1Catch1when3(__when_expr_6.get(), loopDepth); };
									static_cast<RenameTenantActor*>(this)->actor_wait_state = 7;
															#line 1523 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
									__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< RenameTenantActor, 6, Void >*>(static_cast<RenameTenantActor*>(this)));
															#line 15481 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
									loopDepth = 0;
								}
								catch (Error& error) {
									loopDepth = a_body1cont1loopBody1Catch1Catch1(error, loopDepth);
								} catch (...) {
									loopDepth = a_body1cont1loopBody1Catch1Catch1(unknown_error(), loopDepth);
								}
							}
						}
					}
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 1481 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_2 = verifyTenantRenames(self, tenantRenames);
															#line 1481 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (static_cast<RenameTenantActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 15509 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<RenameTenantActor*>(this)->actor_wait_state = 3;
															#line 1481 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RenameTenantActor, 2, Void >*>(static_cast<RenameTenantActor*>(this)));
															#line 15514 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 1481 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_2 = verifyTenantRenames(self, tenantRenames);
															#line 1481 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (static_cast<RenameTenantActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 15525 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<RenameTenantActor*>(this)->actor_wait_state = 3;
															#line 1481 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RenameTenantActor, 2, Void >*>(static_cast<RenameTenantActor*>(this)));
															#line 15530 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RenameTenantActor*>(this)->actor_wait_state > 0) static_cast<RenameTenantActor*>(this)->actor_wait_state = 0;
		static_cast<RenameTenantActor*>(this)->ActorCallback< RenameTenantActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RenameTenantActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RenameTenantActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RenameTenantActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 1482 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		StrictFuture<Versionstamp> __when_expr_3 = getLastTenantModification(self, operationType);
															#line 1482 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (static_cast<RenameTenantActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 15616 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<RenameTenantActor*>(this)->actor_wait_state = 4;
															#line 1482 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RenameTenantActor, 3, Versionstamp >*>(static_cast<RenameTenantActor*>(this)));
															#line 15621 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 1482 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		StrictFuture<Versionstamp> __when_expr_3 = getLastTenantModification(self, operationType);
															#line 1482 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (static_cast<RenameTenantActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 15632 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<RenameTenantActor*>(this)->actor_wait_state = 4;
															#line 1482 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RenameTenantActor, 3, Versionstamp >*>(static_cast<RenameTenantActor*>(this)));
															#line 15637 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RenameTenantActor*>(this)->actor_wait_state > 0) static_cast<RenameTenantActor*>(this)->actor_wait_state = 0;
		static_cast<RenameTenantActor*>(this)->ActorCallback< RenameTenantActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RenameTenantActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RenameTenantActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RenameTenantActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont4(Versionstamp const& currentVersionstamp,int loopDepth) 
	{
															#line 1483 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT_GT(currentVersionstamp.version, originalReadVersion);
															#line 1485 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT(self->useMetacluster == (operationType == OperationType::METACLUSTER));
															#line 1486 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (!static_cast<RenameTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RenameTenantActorState(); static_cast<RenameTenantActor*>(this)->destroy(); return 0; }
															#line 15725 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		new (&static_cast<RenameTenantActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RenameTenantActorState();
		static_cast<RenameTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4(Versionstamp && currentVersionstamp,int loopDepth) 
	{
															#line 1483 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT_GT(currentVersionstamp.version, originalReadVersion);
															#line 1485 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT(self->useMetacluster == (operationType == OperationType::METACLUSTER));
															#line 1486 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (!static_cast<RenameTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RenameTenantActorState(); static_cast<RenameTenantActor*>(this)->destroy(); return 0; }
															#line 15741 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		new (&static_cast<RenameTenantActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RenameTenantActorState();
		static_cast<RenameTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Versionstamp const& currentVersionstamp,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(currentVersionstamp, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Versionstamp && currentVersionstamp,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(std::move(currentVersionstamp), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RenameTenantActor*>(this)->actor_wait_state > 0) static_cast<RenameTenantActor*>(this)->actor_wait_state = 0;
		static_cast<RenameTenantActor*>(this)->ActorCallback< RenameTenantActor, 3, Versionstamp >::remove();

	}
	void a_callback_fire(ActorCallback< RenameTenantActor, 3, Versionstamp >*,Versionstamp const& value) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RenameTenantActor, 3, Versionstamp >*,Versionstamp && value) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RenameTenantActor, 3, Versionstamp >*,Error err) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont2(int loopDepth) 
	{
															#line 1494 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (!static_cast<RenameTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RenameTenantActorState(); static_cast<RenameTenantActor*>(this)->destroy(); return 0; }
															#line 15834 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		new (&static_cast<RenameTenantActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RenameTenantActorState();
		static_cast<RenameTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<RenameTenantActor*>(this)->actor_wait_state > 0) static_cast<RenameTenantActor*>(this)->actor_wait_state = 0;
		static_cast<RenameTenantActor*>(this)->ActorCallback< RenameTenantActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RenameTenantActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< RenameTenantActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< RenameTenantActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont1loopBody1Catch1cont6(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont7(int loopDepth) 
	{
															#line 1501 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (!static_cast<RenameTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RenameTenantActorState(); static_cast<RenameTenantActor*>(this)->destroy(); return 0; }
															#line 15939 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		new (&static_cast<RenameTenantActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RenameTenantActorState();
		static_cast<RenameTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<RenameTenantActor*>(this)->actor_wait_state > 0) static_cast<RenameTenantActor*>(this)->actor_wait_state = 0;
		static_cast<RenameTenantActor*>(this)->ActorCallback< RenameTenantActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RenameTenantActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1Catch1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< RenameTenantActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1Catch1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< RenameTenantActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont1loopBody1Catch1cont11(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont13(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont15(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont13(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont17(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont15(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1525 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			TraceEvent(SevError, "RenameTenantFailure") .errorUnsuppressed(e) .detail("TenantRenames", describe(tenantRenames));
															#line 1528 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			ASSERT(false);
															#line 16065 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = a_body1cont1loopBody1Catch1cont17(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont18(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont18cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont18(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont18cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont18(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont18(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<RenameTenantActor*>(this)->actor_wait_state > 0) static_cast<RenameTenantActor*>(this)->actor_wait_state = 0;
		static_cast<RenameTenantActor*>(this)->ActorCallback< RenameTenantActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RenameTenantActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1Catch1when3(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< RenameTenantActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1Catch1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< RenameTenantActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1Catch1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont1loopBody1Catch1cont18cont1(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1Catch1cont17(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 1433 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	TenantManagementWorkload* self;
															#line 1434 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	OperationType operationType;
															#line 1435 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	int numTenants;
															#line 1436 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1442 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	std::map<TenantName, TenantName> tenantRenames;
															#line 1443 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	std::set<TenantName> allTenantNames;
															#line 1446 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	bool tenantExists;
															#line 1447 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	bool tenantNotFound;
															#line 1448 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	bool tenantOverlap;
															#line 1449 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	bool unknownResult;
															#line 1477 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	Version originalReadVersion;
															#line 16198 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
};
// This generated class is to be used only via renameTenant()
															#line 1433 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
class RenameTenantActor final : public Actor<Void>, public ActorCallback< RenameTenantActor, 0, Version >, public ActorCallback< RenameTenantActor, 1, Void >, public ActorCallback< RenameTenantActor, 2, Void >, public ActorCallback< RenameTenantActor, 3, Versionstamp >, public ActorCallback< RenameTenantActor, 4, Void >, public ActorCallback< RenameTenantActor, 5, Void >, public ActorCallback< RenameTenantActor, 6, Void >, public FastAllocated<RenameTenantActor>, public RenameTenantActorState<RenameTenantActor> {
															#line 16203 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
public:
	using FastAllocated<RenameTenantActor>::operator new;
	using FastAllocated<RenameTenantActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16275841402370056960UL, 1844137742769936896UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RenameTenantActor, 0, Version >;
friend struct ActorCallback< RenameTenantActor, 1, Void >;
friend struct ActorCallback< RenameTenantActor, 2, Void >;
friend struct ActorCallback< RenameTenantActor, 3, Versionstamp >;
friend struct ActorCallback< RenameTenantActor, 4, Void >;
friend struct ActorCallback< RenameTenantActor, 5, Void >;
friend struct ActorCallback< RenameTenantActor, 6, Void >;
															#line 1433 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	RenameTenantActor(TenantManagementWorkload* const& self) 
															#line 16226 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   RenameTenantActorState<RenameTenantActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(972264867922354944UL, 1896563828629082368UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("renameTenant");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RenameTenantActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RenameTenantActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RenameTenantActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RenameTenantActor, 3, Versionstamp >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< RenameTenantActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< RenameTenantActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< RenameTenantActor, 6, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1433 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
[[nodiscard]] static Future<Void> renameTenant( TenantManagementWorkload* const& self ) {
															#line 1433 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	return Future<Void>(new RenameTenantActor(self));
															#line 16264 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
}

#line 1534 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"

	// Changes the configuration of a tenant
																#line 16270 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
// This generated class is to be used only via configureTenantImpl()
															#line 1536 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
template <class ConfigureTenantImplActor>
															#line 1536 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
class ConfigureTenantImplActorState {
															#line 16276 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
public:
															#line 1536 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	ConfigureTenantImplActorState(Reference<ReadYourWritesTransaction> const& tr,TenantName const& tenant,std::map<Standalone<StringRef>, Optional<Value>> const& configParameters,OperationType const& operationType,bool const& specialKeysUseInvalidTuple,TenantManagementWorkload* const& self) 
															#line 1536 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
															#line 1536 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		 : tr(tr),
															#line 1536 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   tenant(tenant),
															#line 1536 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   configParameters(configParameters),
															#line 1536 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   operationType(operationType),
															#line 1536 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   specialKeysUseInvalidTuple(specialKeysUseInvalidTuple),
															#line 1536 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   self(self)
															#line 16293 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("configureTenantImpl", reinterpret_cast<unsigned long>(this));

	}
	~ConfigureTenantImplActorState() 
	{
		fdb_probe_actor_destroy("configureTenantImpl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1542 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (operationType == OperationType::SPECIAL_KEYS)
															#line 16308 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			{
															#line 1543 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				tr->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 1544 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				for( auto const& [config, value] : configParameters ) {
															#line 1545 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					Tuple t;
															#line 1546 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					if (specialKeysUseInvalidTuple)
															#line 16318 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					{
															#line 1548 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						if (deterministicRandom()->coinflip())
															#line 16322 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
						{
															#line 1549 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
							int numItems = deterministicRandom()->randomInt(0, 3);
															#line 1550 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
							if (numItems > 0)
															#line 16328 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
							{
															#line 1551 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
								t.append(tenant);
															#line 16332 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
							}
															#line 1553 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
							if (numItems > 1)
															#line 16336 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
							{
															#line 1554 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
								t.append(config).append(""_sr);
															#line 16340 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
							}
						}
						else
						{
															#line 1559 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
							if (deterministicRandom()->coinflip())
															#line 16347 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
							{
															#line 1560 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
								t.append(0).append(config);
															#line 16351 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
							}
							else
							{
															#line 1562 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
								t.append(tenant).append(0);
															#line 16357 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
							}
						}
					}
					else
					{
															#line 1566 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						t.append(tenant).append(config);
															#line 16365 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					}
															#line 1568 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					if (value.present())
															#line 16369 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					{
															#line 1569 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						tr->set(self->specialKeysTenantConfigPrefix.withSuffix(t.pack()), value.get());
															#line 16373 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					}
					else
					{
															#line 1571 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						tr->clear(self->specialKeysTenantConfigPrefix.withSuffix(t.pack()));
															#line 16379 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					}
				}
															#line 1575 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				StrictFuture<Void> __when_expr_0 = tr->commit();
															#line 1575 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				if (static_cast<ConfigureTenantImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16386 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ConfigureTenantImplActor*>(this)->actor_wait_state = 1;
															#line 1575 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ConfigureTenantImplActor, 0, Void >*>(static_cast<ConfigureTenantImplActor*>(this)));
															#line 16391 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 1577 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				if (operationType == OperationType::METACLUSTER)
															#line 16398 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				{
															#line 1578 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					StrictFuture<Void> __when_expr_1 = metacluster::configureTenant(self->mvDb, tenant, configParameters, metacluster::IgnoreCapacityLimit(deterministicRandom()->coinflip()));
															#line 1578 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					if (static_cast<ConfigureTenantImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16404 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
					static_cast<ConfigureTenantImplActor*>(this)->actor_wait_state = 2;
															#line 1578 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ConfigureTenantImplActor, 1, Void >*>(static_cast<ConfigureTenantImplActor*>(this)));
															#line 16409 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 1584 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					ASSERT(false);
															#line 16416 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					loopDepth = a_body1cont15(loopDepth);
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ConfigureTenantImplActorState();
		static_cast<ConfigureTenantImplActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1587 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (!static_cast<ConfigureTenantImplActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ConfigureTenantImplActorState(); static_cast<ConfigureTenantImplActor*>(this)->destroy(); return 0; }
															#line 16441 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		new (&static_cast<ConfigureTenantImplActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ConfigureTenantImplActorState();
		static_cast<ConfigureTenantImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1576 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT(!specialKeysUseInvalidTuple);
															#line 16453 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1576 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT(!specialKeysUseInvalidTuple);
															#line 16462 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ConfigureTenantImplActor*>(this)->actor_wait_state > 0) static_cast<ConfigureTenantImplActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigureTenantImplActor*>(this)->ActorCallback< ConfigureTenantImplActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigureTenantImplActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("configureTenantImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureTenantImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ConfigureTenantImplActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("configureTenantImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureTenantImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ConfigureTenantImplActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("configureTenantImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureTenantImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont15(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont16(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont15(loopDepth);

		return loopDepth;
	}
	int a_body1cont16(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont15(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont16(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont16(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ConfigureTenantImplActor*>(this)->actor_wait_state > 0) static_cast<ConfigureTenantImplActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigureTenantImplActor*>(this)->ActorCallback< ConfigureTenantImplActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigureTenantImplActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("configureTenantImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureTenantImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ConfigureTenantImplActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("configureTenantImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureTenantImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ConfigureTenantImplActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("configureTenantImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureTenantImpl", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1536 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1536 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	TenantName tenant;
															#line 1536 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	std::map<Standalone<StringRef>, Optional<Value>> configParameters;
															#line 1536 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	OperationType operationType;
															#line 1536 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	bool specialKeysUseInvalidTuple;
															#line 1536 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	TenantManagementWorkload* self;
															#line 16647 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
};
// This generated class is to be used only via configureTenantImpl()
															#line 1536 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
class ConfigureTenantImplActor final : public Actor<Void>, public ActorCallback< ConfigureTenantImplActor, 0, Void >, public ActorCallback< ConfigureTenantImplActor, 1, Void >, public FastAllocated<ConfigureTenantImplActor>, public ConfigureTenantImplActorState<ConfigureTenantImplActor> {
															#line 16652 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
public:
	using FastAllocated<ConfigureTenantImplActor>::operator new;
	using FastAllocated<ConfigureTenantImplActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5430565747762714624UL, 6829080478526264832UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ConfigureTenantImplActor, 0, Void >;
friend struct ActorCallback< ConfigureTenantImplActor, 1, Void >;
															#line 1536 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	ConfigureTenantImplActor(Reference<ReadYourWritesTransaction> const& tr,TenantName const& tenant,std::map<Standalone<StringRef>, Optional<Value>> const& configParameters,OperationType const& operationType,bool const& specialKeysUseInvalidTuple,TenantManagementWorkload* const& self) 
															#line 16670 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   ConfigureTenantImplActorState<ConfigureTenantImplActor>(tr, tenant, configParameters, operationType, specialKeysUseInvalidTuple, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("configureTenantImpl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11325140694572620032UL, 18239763548606552576UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("configureTenantImpl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("configureTenantImpl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ConfigureTenantImplActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ConfigureTenantImplActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1536 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
[[nodiscard]] static Future<Void> configureTenantImpl( Reference<ReadYourWritesTransaction> const& tr, TenantName const& tenant, std::map<Standalone<StringRef>, Optional<Value>> const& configParameters, OperationType const& operationType, bool const& specialKeysUseInvalidTuple, TenantManagementWorkload* const& self ) {
															#line 1536 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	return Future<Void>(new ConfigureTenantImplActor(tr, tenant, configParameters, operationType, specialKeysUseInvalidTuple, self));
															#line 16703 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
}

#line 1589 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"

																#line 16708 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
// This generated class is to be used only via configureTenant()
															#line 1590 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
template <class ConfigureTenantActor>
															#line 1590 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
class ConfigureTenantActorState {
															#line 16714 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
public:
															#line 1590 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	ConfigureTenantActorState(TenantManagementWorkload* const& self) 
															#line 1590 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
															#line 1590 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		 : self(self),
															#line 1591 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   operationType(deterministicRandom()->coinflip() ? OperationType::SPECIAL_KEYS : OperationType::METACLUSTER),
															#line 1594 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   tenant(self->chooseTenantName(true))
															#line 16725 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("configureTenant", reinterpret_cast<unsigned long>(this));

	}
	~ConfigureTenantActorState() 
	{
		fdb_probe_actor_destroy("configureTenant", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1595 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			auto itr = self->createdTenants.find(tenant);
															#line 1596 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			exists = itr != self->createdTenants.end();
															#line 1597 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			tr = makeReference<ReadYourWritesTransaction>(self->dataDb);
															#line 1599 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			configuration = std::map<Standalone<StringRef>, Optional<Value>>();
															#line 1600 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			newTenantGroup = Optional<TenantGroupName>();
															#line 1603 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			hasSystemTenantGroup = false;
															#line 1605 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			specialKeysUseInvalidTuple = operationType == OperationType::SPECIAL_KEYS && deterministicRandom()->random01() < 0.1;
															#line 1609 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			tenantGroupChanging = false;
															#line 1613 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (deterministicRandom()->coinflip())
															#line 16756 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			{
															#line 1614 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				newTenantGroup = self->chooseTenantGroup(true);
															#line 1615 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				hasSystemTenantGroup = hasSystemTenantGroup || newTenantGroup.orDefault(""_sr).startsWith("\xff"_sr);
															#line 1616 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				configuration["tenant_group"_sr] = newTenantGroup;
															#line 1617 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				if (exists && itr->second.tenantGroup != newTenantGroup)
															#line 16766 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				{
															#line 1618 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					tenantGroupChanging = true;
															#line 16770 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				}
			}
															#line 1623 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			assignToDifferentCluster = false;
															#line 1624 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (operationType == OperationType::METACLUSTER && deterministicRandom()->coinflip())
															#line 16777 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			{
															#line 1625 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				ClusterName newClusterName = "newcluster"_sr;
															#line 1626 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				if (deterministicRandom()->coinflip())
															#line 16783 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				{
															#line 1627 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					newClusterName = self->dataClusterName;
															#line 16787 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				}
															#line 1629 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				configuration["assigned_cluster"_sr] = newClusterName;
															#line 1630 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				assignToDifferentCluster = (newClusterName != self->dataClusterName);
															#line 16793 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			}
															#line 1635 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			configurationChanging = tenantGroupChanging;
															#line 1638 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			hasInvalidOption = false;
															#line 1639 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (configuration.empty() || deterministicRandom()->coinflip())
															#line 16801 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			{
															#line 1640 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				configuration["invalid_option"_sr] = ""_sr;
															#line 1641 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				hasInvalidOption = true;
															#line 16807 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			}
															#line 1644 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			StrictFuture<Version> __when_expr_0 = self->getLatestReadVersion(self, operationType);
															#line 1644 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (static_cast<ConfigureTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16813 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ConfigureTenantActor*>(this)->actor_wait_state = 1;
															#line 1644 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ConfigureTenantActor, 0, Version >*>(static_cast<ConfigureTenantActor*>(this)));
															#line 16818 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ConfigureTenantActorState();
		static_cast<ConfigureTenantActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1645 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		;
															#line 16841 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Version const& __originalReadVersion,int loopDepth) 
	{
															#line 1644 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		originalReadVersion = __originalReadVersion;
															#line 16850 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Version && __originalReadVersion,int loopDepth) 
	{
		originalReadVersion = std::move(__originalReadVersion);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ConfigureTenantActor*>(this)->actor_wait_state > 0) static_cast<ConfigureTenantActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigureTenantActor*>(this)->ActorCallback< ConfigureTenantActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigureTenantActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("configureTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ConfigureTenantActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("configureTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ConfigureTenantActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("configureTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 1647 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_1 = configureTenantImpl(tr, tenant, configuration, operationType, specialKeysUseInvalidTuple, self);
															#line 1647 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (static_cast<ConfigureTenantActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 16939 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ConfigureTenantActor*>(this)->actor_wait_state = 2;
															#line 1647 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ConfigureTenantActor, 1, Void >*>(static_cast<ConfigureTenantActor*>(this)));
															#line 16944 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1676 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			error = e;
															#line 1677 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (e.code() == error_code_tenant_not_found)
															#line 16968 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			{
															#line 1678 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				ASSERT(!exists);
															#line 1679 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				if (!static_cast<ConfigureTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ConfigureTenantActorState(); static_cast<ConfigureTenantActor*>(this)->destroy(); return 0; }
															#line 16974 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				new (&static_cast<ConfigureTenantActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~ConfigureTenantActorState();
				static_cast<ConfigureTenantActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 1680 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				if (e.code() == error_code_special_keys_api_failure)
															#line 16984 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				{
															#line 1681 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					ASSERT(hasInvalidOption || specialKeysUseInvalidTuple);
															#line 1682 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					if (!static_cast<ConfigureTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ConfigureTenantActorState(); static_cast<ConfigureTenantActor*>(this)->destroy(); return 0; }
															#line 16990 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					new (&static_cast<ConfigureTenantActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~ConfigureTenantActorState();
					static_cast<ConfigureTenantActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
				else
				{
															#line 1683 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					if (e.code() == error_code_invalid_tenant_configuration)
															#line 17000 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					{
															#line 1684 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						ASSERT(hasInvalidOption || assignToDifferentCluster);
															#line 1685 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						if (!static_cast<ConfigureTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ConfigureTenantActorState(); static_cast<ConfigureTenantActor*>(this)->destroy(); return 0; }
															#line 17006 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
						new (&static_cast<ConfigureTenantActor*>(this)->SAV< Void >::value()) Void(Void());
						this->~ConfigureTenantActorState();
						static_cast<ConfigureTenantActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
					else
					{
															#line 1686 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
						if (e.code() == error_code_invalid_metacluster_operation)
															#line 17016 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
						{
															#line 1687 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
							ASSERT(operationType == OperationType::METACLUSTER != self->useMetacluster);
															#line 1688 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
							if (!static_cast<ConfigureTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ConfigureTenantActorState(); static_cast<ConfigureTenantActor*>(this)->destroy(); return 0; }
															#line 17022 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
							new (&static_cast<ConfigureTenantActor*>(this)->SAV< Void >::value()) Void(Void());
							this->~ConfigureTenantActorState();
							static_cast<ConfigureTenantActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
						else
						{
															#line 1689 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
							if (e.code() == error_code_invalid_tenant_group_name)
															#line 17032 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
							{
															#line 1690 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
								ASSERT(hasSystemTenantGroup);
															#line 1691 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
								if (!static_cast<ConfigureTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ConfigureTenantActorState(); static_cast<ConfigureTenantActor*>(this)->destroy(); return 0; }
															#line 17038 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
								new (&static_cast<ConfigureTenantActor*>(this)->SAV< Void >::value()) Void(Void());
								this->~ConfigureTenantActorState();
								static_cast<ConfigureTenantActor*>(this)->finishSendAndDelPromiseRef();
								return 0;
							}
						}
					}
				}
			}
			try {
															#line 1695 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				StrictFuture<Void> __when_expr_3 = tr->onError(e);
															#line 1695 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				if (static_cast<ConfigureTenantActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1Catch1(actor_cancelled(), loopDepth);
															#line 17053 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1Catch1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
				static_cast<ConfigureTenantActor*>(this)->actor_wait_state = 4;
															#line 1695 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ConfigureTenantActor, 3, Void >*>(static_cast<ConfigureTenantActor*>(this)));
															#line 17058 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont1loopBody1Catch1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont1loopBody1Catch1Catch1(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 1649 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT(exists);
															#line 1650 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT(!hasInvalidOption);
															#line 1651 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT(!hasSystemTenantGroup);
															#line 1652 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT(!specialKeysUseInvalidTuple);
															#line 1653 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT(!assignToDifferentCluster);
															#line 1654 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT_EQ(operationType == OperationType::METACLUSTER, self->useMetacluster);
															#line 1655 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		StrictFuture<Versionstamp> __when_expr_2 = getLastTenantModification(self, operationType);
															#line 1655 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (static_cast<ConfigureTenantActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 17093 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<ConfigureTenantActor*>(this)->actor_wait_state = 3;
															#line 1655 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ConfigureTenantActor, 2, Versionstamp >*>(static_cast<ConfigureTenantActor*>(this)));
															#line 17098 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 1649 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT(exists);
															#line 1650 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT(!hasInvalidOption);
															#line 1651 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT(!hasSystemTenantGroup);
															#line 1652 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT(!specialKeysUseInvalidTuple);
															#line 1653 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT(!assignToDifferentCluster);
															#line 1654 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT_EQ(operationType == OperationType::METACLUSTER, self->useMetacluster);
															#line 1655 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		StrictFuture<Versionstamp> __when_expr_2 = getLastTenantModification(self, operationType);
															#line 1655 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (static_cast<ConfigureTenantActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 17121 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<ConfigureTenantActor*>(this)->actor_wait_state = 3;
															#line 1655 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ConfigureTenantActor, 2, Versionstamp >*>(static_cast<ConfigureTenantActor*>(this)));
															#line 17126 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ConfigureTenantActor*>(this)->actor_wait_state > 0) static_cast<ConfigureTenantActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigureTenantActor*>(this)->ActorCallback< ConfigureTenantActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigureTenantActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("configureTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ConfigureTenantActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("configureTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ConfigureTenantActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("configureTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont3(Versionstamp const& currentVersionstamp,int loopDepth) 
	{
															#line 1656 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (configurationChanging)
															#line 17210 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		{
															#line 1657 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			ASSERT_GT(currentVersionstamp.version, originalReadVersion);
															#line 17214 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		}
															#line 1659 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (tenantGroupChanging)
															#line 17218 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		{
															#line 1660 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			ASSERT(configuration.contains("tenant_group"_sr));
															#line 1661 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			auto itr = self->createdTenants.find(tenant);
															#line 1662 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (itr->second.tenantGroup.present())
															#line 17226 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			{
															#line 1663 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				auto tenantGroupItr = self->createdTenantGroups.find(itr->second.tenantGroup.get());
															#line 1664 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				ASSERT(tenantGroupItr != self->createdTenantGroups.end());
															#line 1665 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				if (--tenantGroupItr->second.tenantCount == 0)
															#line 17234 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				{
															#line 1666 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					self->createdTenantGroups.erase(tenantGroupItr);
															#line 17238 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				}
			}
															#line 1669 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (newTenantGroup.present())
															#line 17243 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			{
															#line 1670 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				self->createdTenantGroups[newTenantGroup.get()].tenantCount++;
															#line 17247 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			}
															#line 1672 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			itr->second.tenantGroup = newTenantGroup;
															#line 17251 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		}
															#line 1674 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (!static_cast<ConfigureTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ConfigureTenantActorState(); static_cast<ConfigureTenantActor*>(this)->destroy(); return 0; }
															#line 17255 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		new (&static_cast<ConfigureTenantActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ConfigureTenantActorState();
		static_cast<ConfigureTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Versionstamp && currentVersionstamp,int loopDepth) 
	{
															#line 1656 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (configurationChanging)
															#line 17267 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		{
															#line 1657 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			ASSERT_GT(currentVersionstamp.version, originalReadVersion);
															#line 17271 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		}
															#line 1659 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (tenantGroupChanging)
															#line 17275 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		{
															#line 1660 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			ASSERT(configuration.contains("tenant_group"_sr));
															#line 1661 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			auto itr = self->createdTenants.find(tenant);
															#line 1662 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (itr->second.tenantGroup.present())
															#line 17283 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			{
															#line 1663 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				auto tenantGroupItr = self->createdTenantGroups.find(itr->second.tenantGroup.get());
															#line 1664 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				ASSERT(tenantGroupItr != self->createdTenantGroups.end());
															#line 1665 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				if (--tenantGroupItr->second.tenantCount == 0)
															#line 17291 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				{
															#line 1666 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					self->createdTenantGroups.erase(tenantGroupItr);
															#line 17295 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				}
			}
															#line 1669 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (newTenantGroup.present())
															#line 17300 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			{
															#line 1670 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				self->createdTenantGroups[newTenantGroup.get()].tenantCount++;
															#line 17304 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			}
															#line 1672 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			itr->second.tenantGroup = newTenantGroup;
															#line 17308 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		}
															#line 1674 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (!static_cast<ConfigureTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ConfigureTenantActorState(); static_cast<ConfigureTenantActor*>(this)->destroy(); return 0; }
															#line 17312 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		new (&static_cast<ConfigureTenantActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ConfigureTenantActorState();
		static_cast<ConfigureTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Versionstamp const& currentVersionstamp,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(currentVersionstamp, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Versionstamp && currentVersionstamp,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(currentVersionstamp), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ConfigureTenantActor*>(this)->actor_wait_state > 0) static_cast<ConfigureTenantActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigureTenantActor*>(this)->ActorCallback< ConfigureTenantActor, 2, Versionstamp >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigureTenantActor, 2, Versionstamp >*,Versionstamp const& value) 
	{
		fdb_probe_actor_enter("configureTenant", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureTenant", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ConfigureTenantActor, 2, Versionstamp >*,Versionstamp && value) 
	{
		fdb_probe_actor_enter("configureTenant", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureTenant", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ConfigureTenantActor, 2, Versionstamp >*,Error err) 
	{
		fdb_probe_actor_enter("configureTenant", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureTenant", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1Catch1(const Error& __current_error,int loopDepth=0) 
	{
		try {
															#line 1697 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			TraceEvent(SevError, "ConfigureTenantFailure") .errorUnsuppressed(error) .detail("TenantName", tenant);
															#line 1700 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			ASSERT(false);
															#line 17408 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = a_body1cont1loopBody1Catch1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont11(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont11cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont11(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont11cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ConfigureTenantActor*>(this)->actor_wait_state > 0) static_cast<ConfigureTenantActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigureTenantActor*>(this)->ActorCallback< ConfigureTenantActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigureTenantActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("configureTenant", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureTenant", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ConfigureTenantActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("configureTenant", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureTenant", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ConfigureTenantActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("configureTenant", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureTenant", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1Catch1cont11cont1(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1Catch1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 1590 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	TenantManagementWorkload* self;
															#line 1591 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	OperationType operationType;
															#line 1594 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	TenantName tenant;
															#line 1596 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	bool exists;
															#line 1597 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1599 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	std::map<Standalone<StringRef>, Optional<Value>> configuration;
															#line 1600 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	Optional<TenantGroupName> newTenantGroup;
															#line 1603 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	bool hasSystemTenantGroup;
															#line 1605 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	bool specialKeysUseInvalidTuple;
															#line 1609 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	bool tenantGroupChanging;
															#line 1623 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	bool assignToDifferentCluster;
															#line 1635 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	bool configurationChanging;
															#line 1638 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	bool hasInvalidOption;
															#line 1644 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	Version originalReadVersion;
															#line 1676 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	Error error;
															#line 17549 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
};
// This generated class is to be used only via configureTenant()
															#line 1590 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
class ConfigureTenantActor final : public Actor<Void>, public ActorCallback< ConfigureTenantActor, 0, Version >, public ActorCallback< ConfigureTenantActor, 1, Void >, public ActorCallback< ConfigureTenantActor, 2, Versionstamp >, public ActorCallback< ConfigureTenantActor, 3, Void >, public FastAllocated<ConfigureTenantActor>, public ConfigureTenantActorState<ConfigureTenantActor> {
															#line 17554 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
public:
	using FastAllocated<ConfigureTenantActor>::operator new;
	using FastAllocated<ConfigureTenantActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4132680352064087040UL, 14411386685488185088UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ConfigureTenantActor, 0, Version >;
friend struct ActorCallback< ConfigureTenantActor, 1, Void >;
friend struct ActorCallback< ConfigureTenantActor, 2, Versionstamp >;
friend struct ActorCallback< ConfigureTenantActor, 3, Void >;
															#line 1590 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	ConfigureTenantActor(TenantManagementWorkload* const& self) 
															#line 17574 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   ConfigureTenantActorState<ConfigureTenantActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("configureTenant", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7048885742222706688UL, 1739664772098993408UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("configureTenant");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("configureTenant", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ConfigureTenantActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ConfigureTenantActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ConfigureTenantActor, 2, Versionstamp >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ConfigureTenantActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1590 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
[[nodiscard]] static Future<Void> configureTenant( TenantManagementWorkload* const& self ) {
															#line 1590 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	return Future<Void>(new ConfigureTenantActor(self));
															#line 17609 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
}

#line 1705 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"

	// Gets the metadata for a tenant group using the specified operation type
																#line 17615 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
// This generated class is to be used only via getTenantGroupImpl()
															#line 1707 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
template <class GetTenantGroupImplActor>
															#line 1707 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
class GetTenantGroupImplActorState {
															#line 17621 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
public:
															#line 1707 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	GetTenantGroupImplActorState(Reference<ReadYourWritesTransaction> const& tr,TenantGroupName const& tenantGroupName,OperationType const& operationType,TenantManagementWorkload* const& self) 
															#line 1707 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
															#line 1707 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		 : tr(tr),
															#line 1707 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   tenantGroupName(tenantGroupName),
															#line 1707 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   operationType(operationType),
															#line 1707 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   self(self),
															#line 1711 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   entry()
															#line 17636 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("getTenantGroupImpl", reinterpret_cast<unsigned long>(this));

	}
	~GetTenantGroupImplActorState() 
	{
		fdb_probe_actor_destroy("getTenantGroupImpl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1712 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (operationType == OperationType::MANAGEMENT_DATABASE)
															#line 17651 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			{
															#line 1713 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				StrictFuture<Void> __when_expr_0 = store(entry, TenantAPI::tryGetTenantGroup(self->dataDb.getReference(), tenantGroupName));
															#line 1713 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				if (static_cast<GetTenantGroupImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17657 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetTenantGroupImplActor*>(this)->actor_wait_state = 1;
															#line 1713 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetTenantGroupImplActor, 0, Void >*>(static_cast<GetTenantGroupImplActor*>(this)));
															#line 17662 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 1714 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				if (operationType == OperationType::MANAGEMENT_TRANSACTION || operationType == OperationType::SPECIAL_KEYS)
															#line 17669 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				{
															#line 1718 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 1719 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					StrictFuture<Void> __when_expr_1 = store(entry, TenantAPI::tryGetTenantGroupTransaction(tr, tenantGroupName));
															#line 1719 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					if (static_cast<GetTenantGroupImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17677 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
					static_cast<GetTenantGroupImplActor*>(this)->actor_wait_state = 2;
															#line 1719 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetTenantGroupImplActor, 1, Void >*>(static_cast<GetTenantGroupImplActor*>(this)));
															#line 17682 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 1721 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					UNREACHABLE();
															#line 17689 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					loopDepth = a_body1cont3(loopDepth);
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetTenantGroupImplActorState();
		static_cast<GetTenantGroupImplActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1724 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (!static_cast<GetTenantGroupImplActor*>(this)->SAV<Optional<TenantGroupEntry>>::futures) { (void)(entry); this->~GetTenantGroupImplActorState(); static_cast<GetTenantGroupImplActor*>(this)->destroy(); return 0; }
															#line 17714 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		new (&static_cast<GetTenantGroupImplActor*>(this)->SAV< Optional<TenantGroupEntry> >::value()) Optional<TenantGroupEntry>(std::move(entry)); // state_var_RVO
		this->~GetTenantGroupImplActorState();
		static_cast<GetTenantGroupImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetTenantGroupImplActor*>(this)->actor_wait_state > 0) static_cast<GetTenantGroupImplActor*>(this)->actor_wait_state = 0;
		static_cast<GetTenantGroupImplActor*>(this)->ActorCallback< GetTenantGroupImplActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetTenantGroupImplActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getTenantGroupImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantGroupImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenantGroupImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetTenantGroupImplActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getTenantGroupImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantGroupImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenantGroupImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetTenantGroupImplActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getTenantGroupImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantGroupImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenantGroupImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetTenantGroupImplActor*>(this)->actor_wait_state > 0) static_cast<GetTenantGroupImplActor*>(this)->actor_wait_state = 0;
		static_cast<GetTenantGroupImplActor*>(this)->ActorCallback< GetTenantGroupImplActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetTenantGroupImplActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getTenantGroupImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantGroupImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenantGroupImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetTenantGroupImplActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getTenantGroupImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantGroupImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenantGroupImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetTenantGroupImplActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getTenantGroupImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantGroupImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenantGroupImpl", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1707 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1707 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	TenantGroupName tenantGroupName;
															#line 1707 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	OperationType operationType;
															#line 1707 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	TenantManagementWorkload* self;
															#line 1711 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	Optional<TenantGroupEntry> entry;
															#line 17912 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
};
// This generated class is to be used only via getTenantGroupImpl()
															#line 1707 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
class GetTenantGroupImplActor final : public Actor<Optional<TenantGroupEntry>>, public ActorCallback< GetTenantGroupImplActor, 0, Void >, public ActorCallback< GetTenantGroupImplActor, 1, Void >, public FastAllocated<GetTenantGroupImplActor>, public GetTenantGroupImplActorState<GetTenantGroupImplActor> {
															#line 17917 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
public:
	using FastAllocated<GetTenantGroupImplActor>::operator new;
	using FastAllocated<GetTenantGroupImplActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(123385499289890048UL, 7196929868349832704UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<TenantGroupEntry>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetTenantGroupImplActor, 0, Void >;
friend struct ActorCallback< GetTenantGroupImplActor, 1, Void >;
															#line 1707 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	GetTenantGroupImplActor(Reference<ReadYourWritesTransaction> const& tr,TenantGroupName const& tenantGroupName,OperationType const& operationType,TenantManagementWorkload* const& self) 
															#line 17935 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		 : Actor<Optional<TenantGroupEntry>>(),
		   GetTenantGroupImplActorState<GetTenantGroupImplActor>(tr, tenantGroupName, operationType, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getTenantGroupImpl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(702739182925225216UL, 11757544294286648576UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantGroupImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getTenantGroupImpl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getTenantGroupImpl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetTenantGroupImplActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetTenantGroupImplActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1707 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
[[nodiscard]] static Future<Optional<TenantGroupEntry>> getTenantGroupImpl( Reference<ReadYourWritesTransaction> const& tr, TenantGroupName const& tenantGroupName, OperationType const& operationType, TenantManagementWorkload* const& self ) {
															#line 1707 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	return Future<Optional<TenantGroupEntry>>(new GetTenantGroupImplActor(tr, tenantGroupName, operationType, self));
															#line 17968 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
}

#line 1726 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"

																#line 17973 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
// This generated class is to be used only via getTenantGroup()
															#line 1727 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
template <class GetTenantGroupActor>
															#line 1727 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
class GetTenantGroupActorState {
															#line 17979 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
public:
															#line 1727 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	GetTenantGroupActorState(TenantManagementWorkload* const& self) 
															#line 1727 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
															#line 1727 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		 : self(self),
															#line 1728 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   tenantGroup(self->chooseTenantGroup(true, false).get()),
															#line 1729 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   operationType(self->randomOperationType()),
															#line 1730 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		   tr(makeReference<ReadYourWritesTransaction>(self->dataDb))
															#line 17992 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("getTenantGroup", reinterpret_cast<unsigned long>(this));

	}
	~GetTenantGroupActorState() 
	{
		fdb_probe_actor_destroy("getTenantGroup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1733 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			auto itr = self->createdTenantGroups.find(tenantGroup);
															#line 1734 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			alreadyExists = itr != self->createdTenantGroups.end() && !(operationType == OperationType::METACLUSTER && !self->useMetacluster);
															#line 1737 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			;
															#line 18011 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetTenantGroupActorState();
		static_cast<GetTenantGroupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1740 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (operationType == OperationType::METACLUSTER)
															#line 18042 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			{
															#line 1741 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				StrictFuture<Optional<metacluster::MetaclusterTenantGroupEntry>> __when_expr_0 = metacluster::tryGetTenantGroup(self->mvDb, tenantGroup);
															#line 1741 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				if (static_cast<GetTenantGroupActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 18048 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetTenantGroupActor*>(this)->actor_wait_state = 1;
															#line 1741 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetTenantGroupActor, 0, Optional<metacluster::MetaclusterTenantGroupEntry> >*>(static_cast<GetTenantGroupActor*>(this)));
															#line 18053 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 1745 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				StrictFuture<Optional<TenantGroupEntry>> __when_expr_1 = getTenantGroupImpl(tr, tenantGroup, operationType, self);
															#line 1745 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				if (static_cast<GetTenantGroupActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 18062 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
				static_cast<GetTenantGroupActor*>(this)->actor_wait_state = 2;
															#line 1745 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetTenantGroupActor, 1, Optional<TenantGroupEntry> >*>(static_cast<GetTenantGroupActor*>(this)));
															#line 18067 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1751 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			retry = false;
															#line 1752 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			error = e;
															#line 1755 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			if (operationType == OperationType::MANAGEMENT_TRANSACTION || operationType == OperationType::SPECIAL_KEYS)
															#line 18094 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			{
				try {
															#line 1758 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					StrictFuture<Void> __when_expr_2 = tr->onError(e);
															#line 1758 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					if (static_cast<GetTenantGroupActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1Catch1(actor_cancelled(), loopDepth);
															#line 18101 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
					static_cast<GetTenantGroupActor*>(this)->actor_wait_state = 3;
															#line 1758 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
					__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetTenantGroupActor, 2, Void >*>(static_cast<GetTenantGroupActor*>(this)));
															#line 18106 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
					loopDepth = 0;
				}
				catch (Error& error) {
					loopDepth = a_body1loopBody1Catch1Catch1(error, loopDepth);
				} catch (...) {
					loopDepth = a_body1loopBody1Catch1Catch1(unknown_error(), loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1loopBody1Catch1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 1749 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (!static_cast<GetTenantGroupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetTenantGroupActorState(); static_cast<GetTenantGroupActor*>(this)->destroy(); return 0; }
															#line 18132 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		new (&static_cast<GetTenantGroupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetTenantGroupActorState();
		static_cast<GetTenantGroupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 1743 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT(alreadyExists == mEntry.present());
															#line 18144 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<metacluster::MetaclusterTenantGroupEntry> const& __mEntry,int loopDepth) 
	{
															#line 1741 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		mEntry = __mEntry;
															#line 18153 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<metacluster::MetaclusterTenantGroupEntry> && __mEntry,int loopDepth) 
	{
		mEntry = std::move(__mEntry);
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetTenantGroupActor*>(this)->actor_wait_state > 0) static_cast<GetTenantGroupActor*>(this)->actor_wait_state = 0;
		static_cast<GetTenantGroupActor*>(this)->ActorCallback< GetTenantGroupActor, 0, Optional<metacluster::MetaclusterTenantGroupEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< GetTenantGroupActor, 0, Optional<metacluster::MetaclusterTenantGroupEntry> >*,Optional<metacluster::MetaclusterTenantGroupEntry> const& value) 
	{
		fdb_probe_actor_enter("getTenantGroup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantGroupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenantGroup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetTenantGroupActor, 0, Optional<metacluster::MetaclusterTenantGroupEntry> >*,Optional<metacluster::MetaclusterTenantGroupEntry> && value) 
	{
		fdb_probe_actor_enter("getTenantGroup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantGroupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenantGroup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetTenantGroupActor, 0, Optional<metacluster::MetaclusterTenantGroupEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("getTenantGroup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantGroupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenantGroup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
															#line 1747 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		ASSERT(alreadyExists == entry.present());
															#line 18232 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Optional<TenantGroupEntry> const& __entry,int loopDepth) 
	{
															#line 1745 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		entry = __entry;
															#line 18241 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Optional<TenantGroupEntry> && __entry,int loopDepth) 
	{
		entry = std::move(__entry);
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetTenantGroupActor*>(this)->actor_wait_state > 0) static_cast<GetTenantGroupActor*>(this)->actor_wait_state = 0;
		static_cast<GetTenantGroupActor*>(this)->ActorCallback< GetTenantGroupActor, 1, Optional<TenantGroupEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< GetTenantGroupActor, 1, Optional<TenantGroupEntry> >*,Optional<TenantGroupEntry> const& value) 
	{
		fdb_probe_actor_enter("getTenantGroup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantGroupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenantGroup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetTenantGroupActor, 1, Optional<TenantGroupEntry> >*,Optional<TenantGroupEntry> && value) 
	{
		fdb_probe_actor_enter("getTenantGroup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantGroupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenantGroup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetTenantGroupActor, 1, Optional<TenantGroupEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("getTenantGroup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantGroupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenantGroup", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
															#line 1766 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		if (!retry)
															#line 18320 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		{
															#line 1767 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			TraceEvent(SevError, "GetTenantGroupFailure") .errorUnsuppressed(error) .detail("TenantGroupName", tenantGroup);
															#line 1770 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			ASSERT(false);
															#line 18326 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1761 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			error = e;
															#line 1762 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
			retry = false;
															#line 18345 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
			loopDepth = a_body1loopBody1Catch1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(Void const& _,int loopDepth) 
	{
															#line 1759 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		retry = true;
															#line 18360 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1Catch1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(Void && _,int loopDepth) 
	{
															#line 1759 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
		retry = true;
															#line 18369 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1Catch1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetTenantGroupActor*>(this)->actor_wait_state > 0) static_cast<GetTenantGroupActor*>(this)->actor_wait_state = 0;
		static_cast<GetTenantGroupActor*>(this)->ActorCallback< GetTenantGroupActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetTenantGroupActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getTenantGroup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantGroupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenantGroup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetTenantGroupActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getTenantGroup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantGroupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenantGroup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetTenantGroupActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getTenantGroup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantGroupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenantGroup", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1Catch1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 1727 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	TenantManagementWorkload* self;
															#line 1728 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	TenantGroupName tenantGroup;
															#line 1729 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	OperationType operationType;
															#line 1730 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1734 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	bool alreadyExists;
															#line 1741 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	Optional<metacluster::MetaclusterTenantGroupEntry> mEntry;
															#line 1745 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	Optional<TenantGroupEntry> entry;
															#line 1751 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	bool retry;
															#line 1752 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/TenantManagementWorkload.actor.cpp"
	Error error;
															#line 18480 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantManagementWorkload.actor.g.cpp"
};
// This generated class is to be used only via getTenantGroup()
															#line 1727 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/fdbserver/workloads/T