#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
/*
 * dining_philosophers.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2025 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fmt/format.h"
#include "flow/flow.h"
#include "flow/Platform.h"
#include "flow/DeterministicRandom.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/ReadYourWrites.h"
#include "flow/TLSConfig.actor.h"
#include <functional>
#include <unordered_map>
#include <memory>
#include <iostream>
#include "flow/actorcompiler.h"

// Flow solution to Dining Philosophers problem
// (https://en.wikipedia.org/wiki/Dining_philosophers_problem; or
// https://leetcode.com/problems/the-dining-philosophers/description/,
// but note that that calls for a single process/threaded solution
// and here we implement a distributed solution).
//
// This uses most of the techniques illustrated in tutorial.actor.cpp.
// A server is used to track "fork ownership".  The dining
// philosophers are modeled as clients who must request and obtain
// ownership of forks prior to eating.
//
// To do this exercise, delete the code below down to main(), then
// implement it using techniques you see in tutorial.actor.cpp.

enum DPEndpoints {
	WLTOKEN_DP_SERVER = WLTOKEN_FIRST_AVAILABLE,
	DP_ENDPOINT_COUNT,
};

struct DPServerInterface {
	constexpr static FileIdentifier file_identifier = 9957031;
	RequestStream<struct GetInterfaceRequest> getInterface;
	RequestStream<struct GetForkRequest> getFork;
	RequestStream<struct ReleaseForkRequest> releaseFork;

	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, getInterface, getFork, releaseFork);
	}
};

struct GetInterfaceRequest {
	constexpr static FileIdentifier file_identifier = 13789052;
	ReplyPromise<DPServerInterface> reply;

	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, reply);
	}
};

// This is sent in both requests and responses.
// NOTE: it seems better to have reply types be structs with
// file_identifier members and serialize() overrides.
// tutorial.actor.cpp has an example where a std::string is sent
// directly.  Attempts to do similar things with base types like int
// will run into trouble.  (Caveat: I didn't try uint32_t or the like;
// maybe those work.)
struct ForkState {
	constexpr static FileIdentifier file_identifier = 998236;
	// ID [0, N) of the philospher requesting this fork.
	uint32_t clientId;
	// The number of the fork we are requesting, also [0, N).
	// Philosophers numbered i request forks i and (i + 1) % N,
	// not necessarily in that order.
	uint32_t forkNumber;
	ForkState() : clientId(0), forkNumber(0) {}
	ForkState(int c, int f) : clientId(c), forkNumber(f) {}

	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, clientId, forkNumber);
	}
};

struct GetForkRequest {
	constexpr static FileIdentifier file_identifier = 14904213;

	ForkState forkState;
	ReplyPromise<ForkState> reply;

	GetForkRequest(ForkState fork_state) : forkState(fork_state) {}
	GetForkRequest() {}

	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, forkState, reply);
	}
};

struct ReleaseForkRequest {
	constexpr static FileIdentifier file_identifier = 5914324;
	ForkState forkState;
	ReplyPromise<ForkState> reply;

	ReleaseForkRequest(ForkState fork_state) : forkState(fork_state) {}
	ReleaseForkRequest() {}

	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, forkState, reply);
	}
};

															#line 130 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
namespace {
// This generated class is to be used only via dpClient()
															#line 128 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
template <class DpClientActor>
															#line 128 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
class DpClientActorState {
															#line 137 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
public:
															#line 128 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
	DpClientActorState(NetworkAddress const& serverAddress,int const& idnum,int const& numEaters) 
															#line 128 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
															#line 128 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		 : serverAddress(serverAddress),
															#line 128 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		   idnum(idnum),
															#line 128 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		   numEaters(numEaters)
															#line 148 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
	{
		fdb_probe_actor_create("dpClient", reinterpret_cast<unsigned long>(this));

	}
	~DpClientActorState() 
	{
		fdb_probe_actor_destroy("dpClient", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 129 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
			std::cout << format( "dpClient: starting philosopher #%d, server address [%s]\n", idnum, serverAddress.toString().c_str());
															#line 132 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
			server = DPServerInterface();
															#line 133 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
			server.getInterface = RequestStream<GetInterfaceRequest>(Endpoint::wellKnown({ serverAddress }, WLTOKEN_DP_SERVER));
															#line 134 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
			StrictFuture<DPServerInterface> __when_expr_0 = server.getInterface.getReply(GetInterfaceRequest());
															#line 134 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
			if (static_cast<DpClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 171 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DpClientActor*>(this)->actor_wait_state = 1;
															#line 134 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DpClientActor, 0, DPServerInterface >*>(static_cast<DpClientActor*>(this)));
															#line 176 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DpClientActorState();
		static_cast<DpClientActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(DPServerInterface const& s,int loopDepth) 
	{
															#line 135 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		server = s;
															#line 137 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		firstfork = int();
															#line 138 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		secondfork = int();
															#line 139 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		gf1 = GetForkRequest();
															#line 140 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		gf2 = GetForkRequest();
															#line 141 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		rf1 = ReleaseForkRequest();
															#line 142 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		rf2 = ReleaseForkRequest();
															#line 145 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		bool CAUSE_DEADLOCK = false;
															#line 147 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		if (CAUSE_DEADLOCK)
															#line 215 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
		{
															#line 148 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
			firstfork = idnum;
															#line 149 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
			secondfork = (idnum + 1) % numEaters;
															#line 221 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
		}
		else
		{
															#line 156 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
			if (idnum % 2)
															#line 227 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
			{
															#line 157 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
				firstfork = idnum;
															#line 158 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
				secondfork = (idnum + 1) % numEaters;
															#line 233 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
			}
			else
			{
															#line 160 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
				firstfork = (idnum + 1) % numEaters;
															#line 161 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
				secondfork = idnum;
															#line 241 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
			}
		}
															#line 165 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		msec = double();
															#line 166 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		meals_eaten = 0;
															#line 248 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
		try {
															#line 169 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
			;
															#line 252 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
			loopDepth = a_body1cont1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(DPServerInterface && s,int loopDepth) 
	{
															#line 135 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		server = s;
															#line 137 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		firstfork = int();
															#line 138 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		secondfork = int();
															#line 139 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		gf1 = GetForkRequest();
															#line 140 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		gf2 = GetForkRequest();
															#line 141 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		rf1 = ReleaseForkRequest();
															#line 142 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		rf2 = ReleaseForkRequest();
															#line 145 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		bool CAUSE_DEADLOCK = false;
															#line 147 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		if (CAUSE_DEADLOCK)
															#line 283 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
		{
															#line 148 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
			firstfork = idnum;
															#line 149 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
			secondfork = (idnum + 1) % numEaters;
															#line 289 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
		}
		else
		{
															#line 156 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
			if (idnum % 2)
															#line 295 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
			{
															#line 157 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
				firstfork = idnum;
															#line 158 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
				secondfork = (idnum + 1) % numEaters;
															#line 301 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
			}
			else
			{
															#line 160 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
				firstfork = (idnum + 1) % numEaters;
															#line 161 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
				secondfork = idnum;
															#line 309 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
			}
		}
															#line 165 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		msec = double();
															#line 166 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		meals_eaten = 0;
															#line 316 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
		try {
															#line 169 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
			;
															#line 320 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
			loopDepth = a_body1cont1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(DPServerInterface const& s,int loopDepth) 
	{
		loopDepth = a_body1cont1(s, loopDepth);

		return loopDepth;
	}
	int a_body1when1(DPServerInterface && s,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(s), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DpClientActor*>(this)->actor_wait_state > 0) static_cast<DpClientActor*>(this)->actor_wait_state = 0;
		static_cast<DpClientActor*>(this)->ActorCallback< DpClientActor, 0, DPServerInterface >::remove();

	}
	void a_callback_fire(ActorCallback< DpClientActor, 0, DPServerInterface >*,DPServerInterface const& value) 
	{
		fdb_probe_actor_enter("dpClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DpClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dpClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DpClientActor, 0, DPServerInterface >*,DPServerInterface && value) 
	{
		fdb_probe_actor_enter("dpClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DpClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dpClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DpClientActor, 0, DPServerInterface >*,Error err) 
	{
		fdb_probe_actor_enter("dpClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DpClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dpClient", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 203 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		std::cout << format("dpClient: philosopher #%d finished.\n", idnum);
															#line 204 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		if (!static_cast<DpClientActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DpClientActorState(); static_cast<DpClientActor*>(this)->destroy(); return 0; }
															#line 412 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
		new (&static_cast<DpClientActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DpClientActorState();
		static_cast<DpClientActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 200 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
			std::cerr << format("dpClient: caught Error code %s, %s\n", e.code(), e.what());
															#line 425 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 170 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		std::cout << format("dpClient: eater [%d] WANTS TO EAT...\n", idnum);
															#line 172 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		gf1 = GetForkRequest(ForkState(idnum, firstfork));
															#line 173 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		StrictFuture<ForkState> __when_expr_1 = server.getFork.getReply(gf1);
															#line 173 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		if (static_cast<DpClientActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 453 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DpClientActor*>(this)->actor_wait_state = 2;
															#line 173 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DpClientActor, 1, ForkState >*>(static_cast<DpClientActor*>(this)));
															#line 458 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(ForkState const& reply,int loopDepth) 
	{
															#line 174 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		ASSERT(reply.clientId == idnum);
															#line 175 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		ASSERT(reply.forkNumber == firstfork);
															#line 177 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		gf2 = GetForkRequest(ForkState(idnum, secondfork));
															#line 178 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		StrictFuture<ForkState> __when_expr_2 = server.getFork.getReply(gf2);
															#line 178 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		if (static_cast<DpClientActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 475 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<DpClientActor*>(this)->actor_wait_state = 3;
															#line 178 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DpClientActor, 2, ForkState >*>(static_cast<DpClientActor*>(this)));
															#line 480 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(ForkState && reply,int loopDepth) 
	{
															#line 174 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		ASSERT(reply.clientId == idnum);
															#line 175 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		ASSERT(reply.forkNumber == firstfork);
															#line 177 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		gf2 = GetForkRequest(ForkState(idnum, secondfork));
															#line 178 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		StrictFuture<ForkState> __when_expr_2 = server.getFork.getReply(gf2);
															#line 178 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		if (static_cast<DpClientActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 497 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<DpClientActor*>(this)->actor_wait_state = 3;
															#line 178 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DpClientActor, 2, ForkState >*>(static_cast<DpClientActor*>(this)));
															#line 502 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(ForkState const& reply,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(reply, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(ForkState && reply,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(reply), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DpClientActor*>(this)->actor_wait_state > 0) static_cast<DpClientActor*>(this)->actor_wait_state = 0;
		static_cast<DpClientActor*>(this)->ActorCallback< DpClientActor, 1, ForkState >::remove();

	}
	void a_callback_fire(ActorCallback< DpClientActor, 1, ForkState >*,ForkState const& value) 
	{
		fdb_probe_actor_enter("dpClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DpClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dpClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DpClientActor, 1, ForkState >*,ForkState && value) 
	{
		fdb_probe_actor_enter("dpClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DpClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dpClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DpClientActor, 1, ForkState >*,Error err) 
	{
		fdb_probe_actor_enter("dpClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DpClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dpClient", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont2(ForkState const& reply2,int loopDepth) 
	{
															#line 179 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		ASSERT(reply2.clientId == idnum);
															#line 180 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		ASSERT(reply2.forkNumber == secondfork);
															#line 182 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		std::cout << format("dpClient: eater [%d] NOW EATING...\n", idnum);
															#line 183 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		msec = deterministicRandom()->randomInt(0, 1000) / 1000.0 + 1;
															#line 184 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(msec);
															#line 184 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		if (static_cast<DpClientActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 596 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont2when1(__when_expr_3.get(), loopDepth); };
		static_cast<DpClientActor*>(this)->actor_wait_state = 4;
															#line 184 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DpClientActor, 3, Void >*>(static_cast<DpClientActor*>(this)));
															#line 601 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(ForkState && reply2,int loopDepth) 
	{
															#line 179 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		ASSERT(reply2.clientId == idnum);
															#line 180 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		ASSERT(reply2.forkNumber == secondfork);
															#line 182 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		std::cout << format("dpClient: eater [%d] NOW EATING...\n", idnum);
															#line 183 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		msec = deterministicRandom()->randomInt(0, 1000) / 1000.0 + 1;
															#line 184 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(msec);
															#line 184 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		if (static_cast<DpClientActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 620 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont2when1(__when_expr_3.get(), loopDepth); };
		static_cast<DpClientActor*>(this)->actor_wait_state = 4;
															#line 184 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DpClientActor, 3, Void >*>(static_cast<DpClientActor*>(this)));
															#line 625 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(ForkState const& reply2,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(reply2, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(ForkState && reply2,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(reply2), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DpClientActor*>(this)->actor_wait_state > 0) static_cast<DpClientActor*>(this)->actor_wait_state = 0;
		static_cast<DpClientActor*>(this)->ActorCallback< DpClientActor, 2, ForkState >::remove();

	}
	void a_callback_fire(ActorCallback< DpClientActor, 2, ForkState >*,ForkState const& value) 
	{
		fdb_probe_actor_enter("dpClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DpClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dpClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DpClientActor, 2, ForkState >*,ForkState && value) 
	{
		fdb_probe_actor_enter("dpClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DpClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dpClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DpClientActor, 2, ForkState >*,Error err) 
	{
		fdb_probe_actor_enter("dpClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DpClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dpClient", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 185 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		meals_eaten++;
															#line 187 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		rf1 = ReleaseForkRequest(ForkState(idnum, firstfork));
															#line 188 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		StrictFuture<ForkState> __when_expr_4 = server.releaseFork.getReply(rf1);
															#line 188 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		if (static_cast<DpClientActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 715 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont3when1(__when_expr_4.get(), loopDepth); };
		static_cast<DpClientActor*>(this)->actor_wait_state = 5;
															#line 188 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< DpClientActor, 4, ForkState >*>(static_cast<DpClientActor*>(this)));
															#line 720 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 185 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		meals_eaten++;
															#line 187 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		rf1 = ReleaseForkRequest(ForkState(idnum, firstfork));
															#line 188 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		StrictFuture<ForkState> __when_expr_4 = server.releaseFork.getReply(rf1);
															#line 188 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		if (static_cast<DpClientActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 735 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont3when1(__when_expr_4.get(), loopDepth); };
		static_cast<DpClientActor*>(this)->actor_wait_state = 5;
															#line 188 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< DpClientActor, 4, ForkState >*>(static_cast<DpClientActor*>(this)));
															#line 740 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<DpClientActor*>(this)->actor_wait_state > 0) static_cast<DpClientActor*>(this)->actor_wait_state = 0;
		static_cast<DpClientActor*>(this)->ActorCallback< DpClientActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DpClientActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("dpClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DpClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dpClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< DpClientActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("dpClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DpClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dpClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< DpClientActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("dpClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DpClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dpClient", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont4(ForkState const& reply3,int loopDepth) 
	{
															#line 190 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		rf2 = ReleaseForkRequest(ForkState(idnum, secondfork));
															#line 191 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		StrictFuture<ForkState> __when_expr_5 = server.releaseFork.getReply(rf2);
															#line 191 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		if (static_cast<DpClientActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 828 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont4when1(__when_expr_5.get(), loopDepth); };
		static_cast<DpClientActor*>(this)->actor_wait_state = 6;
															#line 191 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< DpClientActor, 5, ForkState >*>(static_cast<DpClientActor*>(this)));
															#line 833 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4(ForkState && reply3,int loopDepth) 
	{
															#line 190 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		rf2 = ReleaseForkRequest(ForkState(idnum, secondfork));
															#line 191 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		StrictFuture<ForkState> __when_expr_5 = server.releaseFork.getReply(rf2);
															#line 191 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		if (static_cast<DpClientActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 846 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont4when1(__when_expr_5.get(), loopDepth); };
		static_cast<DpClientActor*>(this)->actor_wait_state = 6;
															#line 191 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< DpClientActor, 5, ForkState >*>(static_cast<DpClientActor*>(this)));
															#line 851 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(ForkState const& reply3,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(reply3, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(ForkState && reply3,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(std::move(reply3), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<DpClientActor*>(this)->actor_wait_state > 0) static_cast<DpClientActor*>(this)->actor_wait_state = 0;
		static_cast<DpClientActor*>(this)->ActorCallback< DpClientActor, 4, ForkState >::remove();

	}
	void a_callback_fire(ActorCallback< DpClientActor, 4, ForkState >*,ForkState const& value) 
	{
		fdb_probe_actor_enter("dpClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DpClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dpClient", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< DpClientActor, 4, ForkState >*,ForkState && value) 
	{
		fdb_probe_actor_enter("dpClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DpClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dpClient", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< DpClientActor, 4, ForkState >*,Error err) 
	{
		fdb_probe_actor_enter("dpClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DpClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dpClient", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont1loopBody1cont5(ForkState const& reply4,int loopDepth) 
	{
															#line 194 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		std::cout << format("dpClient: eater [%d] HAS RELEASED ITS FORKS (%d meals eaten)\n", idnum, meals_eaten);
															#line 196 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		msec = deterministicRandom()->randomInt(0, 1000) / 1000.0 + 1;
															#line 197 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		StrictFuture<Void> __when_expr_6 = delay(msec);
															#line 197 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		if (static_cast<DpClientActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 941 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont5when1(__when_expr_6.get(), loopDepth); };
		static_cast<DpClientActor*>(this)->actor_wait_state = 7;
															#line 197 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< DpClientActor, 6, Void >*>(static_cast<DpClientActor*>(this)));
															#line 946 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5(ForkState && reply4,int loopDepth) 
	{
															#line 194 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		std::cout << format("dpClient: eater [%d] HAS RELEASED ITS FORKS (%d meals eaten)\n", idnum, meals_eaten);
															#line 196 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		msec = deterministicRandom()->randomInt(0, 1000) / 1000.0 + 1;
															#line 197 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		StrictFuture<Void> __when_expr_6 = delay(msec);
															#line 197 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		if (static_cast<DpClientActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 961 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont5when1(__when_expr_6.get(), loopDepth); };
		static_cast<DpClientActor*>(this)->actor_wait_state = 7;
															#line 197 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< DpClientActor, 6, Void >*>(static_cast<DpClientActor*>(this)));
															#line 966 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4when1(ForkState const& reply4,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5(reply4, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4when1(ForkState && reply4,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5(std::move(reply4), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<DpClientActor*>(this)->actor_wait_state > 0) static_cast<DpClientActor*>(this)->actor_wait_state = 0;
		static_cast<DpClientActor*>(this)->ActorCallback< DpClientActor, 5, ForkState >::remove();

	}
	void a_callback_fire(ActorCallback< DpClientActor, 5, ForkState >*,ForkState const& value) 
	{
		fdb_probe_actor_enter("dpClient", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DpClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dpClient", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< DpClientActor, 5, ForkState >*,ForkState && value) 
	{
		fdb_probe_actor_enter("dpClient", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DpClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dpClient", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< DpClientActor, 5, ForkState >*,Error err) 
	{
		fdb_probe_actor_enter("dpClient", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DpClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dpClient", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont1loopBody1cont6(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<DpClientActor*>(this)->actor_wait_state > 0) static_cast<DpClientActor*>(this)->actor_wait_state = 0;
		static_cast<DpClientActor*>(this)->ActorCallback< DpClientActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DpClientActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("dpClient", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DpClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dpClient", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< DpClientActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("dpClient", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DpClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dpClient", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< DpClientActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("dpClient", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DpClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dpClient", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 128 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
	NetworkAddress serverAddress;
															#line 128 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
	int idnum;
															#line 128 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
	int numEaters;
															#line 132 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
	DPServerInterface server;
															#line 137 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
	int firstfork;
															#line 138 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
	int secondfork;
															#line 139 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
	GetForkRequest gf1;
															#line 140 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
	GetForkRequest gf2;
															#line 141 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
	ReleaseForkRequest rf1;
															#line 142 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
	ReleaseForkRequest rf2;
															#line 165 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
	double msec;
															#line 166 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
	int meals_eaten;
															#line 1157 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
};
// This generated class is to be used only via dpClient()
															#line 128 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
class DpClientActor final : public Actor<Void>, public ActorCallback< DpClientActor, 0, DPServerInterface >, public ActorCallback< DpClientActor, 1, ForkState >, public ActorCallback< DpClientActor, 2, ForkState >, public ActorCallback< DpClientActor, 3, Void >, public ActorCallback< DpClientActor, 4, ForkState >, public ActorCallback< DpClientActor, 5, ForkState >, public ActorCallback< DpClientActor, 6, Void >, public FastAllocated<DpClientActor>, public DpClientActorState<DpClientActor> {
															#line 1162 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
public:
	using FastAllocated<DpClientActor>::operator new;
	using FastAllocated<DpClientActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18044608544011825664UL, 18176418871139005440UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DpClientActor, 0, DPServerInterface >;
friend struct ActorCallback< DpClientActor, 1, ForkState >;
friend struct ActorCallback< DpClientActor, 2, ForkState >;
friend struct ActorCallback< DpClientActor, 3, Void >;
friend struct ActorCallback< DpClientActor, 4, ForkState >;
friend struct ActorCallback< DpClientActor, 5, ForkState >;
friend struct ActorCallback< DpClientActor, 6, Void >;
															#line 128 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
	DpClientActor(NetworkAddress const& serverAddress,int const& idnum,int const& numEaters) 
															#line 1185 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
		 : Actor<Void>(),
		   DpClientActorState<DpClientActor>(serverAddress, idnum, numEaters),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("dpClient", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1848920599870231552UL, 10050264237807578624UL);
		ActorExecutionContextHelper __helper(static_cast<DpClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("dpClient");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("dpClient", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DpClientActor, 0, DPServerInterface >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DpClientActor, 1, ForkState >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DpClientActor, 2, ForkState >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< DpClientActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< DpClientActor, 4, ForkState >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< DpClientActor, 5, ForkState >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< DpClientActor, 6, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 128 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
[[nodiscard]] Future<Void> dpClient( NetworkAddress const& serverAddress, int const& idnum, int const& numEaters ) {
															#line 128 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
	return Future<Void>(new DpClientActor(serverAddress, idnum, numEaters));
															#line 1224 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
}

#line 206 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"

															#line 1229 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
namespace {
// This generated class is to be used only via dpServerLoop()
															#line 207 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
template <class DpServerLoopActor>
															#line 207 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
class DpServerLoopActorState {
															#line 1236 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
public:
															#line 207 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
	DpServerLoopActorState() 
															#line 207 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
															#line 208 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		 : dpServer()
															#line 1243 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
	{
		fdb_probe_actor_create("dpServerLoop", reinterpret_cast<unsigned long>(this));

	}
	~DpServerLoopActorState() 
	{
		fdb_probe_actor_destroy("dpServerLoop", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 209 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
			dpServer.getInterface.makeWellKnownEndpoint(WLTOKEN_DP_SERVER, TaskPriority::DefaultEndpoint);
															#line 211 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
			std::cout << format("dpServer: starting...\n");
															#line 214 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
			forkOwners = std::map<int, int>();
															#line 221 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
			pending = std::map<int, GetForkRequest>();
															#line 223 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
			;
															#line 1266 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DpServerLoopActorState();
		static_cast<DpServerLoopActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 226 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
			auto __when_expr_0 = dpServer.getInterface.getFuture();
															#line 1297 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
			static_assert(std::is_same<decltype(__when_expr_0), FutureStream<GetInterfaceRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<GetInterfaceRequest>>::value, "invalid type");
															#line 225 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
			if (static_cast<DpServerLoopActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1301 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
															#line 229 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
			auto __when_expr_1 = dpServer.getFork.getFuture();
															#line 1305 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
			static_assert(std::is_same<decltype(__when_expr_1), FutureStream<GetForkRequest>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<GetForkRequest>>::value, "invalid type");
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1when2(__when_expr_1.pop(), loopDepth); };
															#line 245 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
			auto __when_expr_2 = dpServer.releaseFork.getFuture();
															#line 1310 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
			static_assert(std::is_same<decltype(__when_expr_2), FutureStream<ReleaseForkRequest>>::value || std::is_same<decltype(__when_expr_2), ThreadFutureStream<ReleaseForkRequest>>::value, "invalid type");
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1when3(__when_expr_2.pop(), loopDepth); };
			static_cast<DpServerLoopActor*>(this)->actor_wait_state = 1;
															#line 226 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< DpServerLoopActor, 0, GetInterfaceRequest >*>(static_cast<DpServerLoopActor*>(this)));
															#line 229 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< DpServerLoopActor, 1, GetForkRequest >*>(static_cast<DpServerLoopActor*>(this)));
															#line 245 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorSingleCallback< DpServerLoopActor, 2, ReleaseForkRequest >*>(static_cast<DpServerLoopActor*>(this)));
															#line 1320 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 285 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
			if (e.code() != error_code_operation_obsolete)
															#line 1342 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
			{
															#line 286 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
				std::cerr << format("dpServerLoop: Error %d / %s\n", e.code(), e.what());
															#line 287 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 1348 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
			}
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetInterfaceRequest const& req,int loopDepth) 
	{
															#line 227 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		req.reply.send(dpServer);
															#line 1370 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetInterfaceRequest && req,int loopDepth) 
	{
															#line 227 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		req.reply.send(dpServer);
															#line 1379 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(GetForkRequest const& req,int loopDepth) 
	{
															#line 230 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		int clientId = req.forkState.clientId;
															#line 231 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		int forkNo = req.forkState.forkNumber;
															#line 232 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		auto it = forkOwners.find(forkNo);
															#line 233 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		if (it == forkOwners.end())
															#line 1394 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
		{
															#line 235 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
			std::cout << format("dpServerLoop: eater %d gets fork %d\n", clientId, forkNo);
															#line 236 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
			forkOwners[forkNo] = clientId;
															#line 237 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
			req.reply.send(req.forkState);
															#line 1402 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
		}
		else
		{
															#line 239 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
			auto it2 = pending.find(forkNo);
															#line 240 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
			ASSERT(it2 == pending.end());
															#line 241 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
			std::cout << format("dpServerLoop: eater %d has to wait for fork %d\n", clientId, forkNo);
															#line 242 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
			pending[forkNo] = req;
															#line 1414 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(GetForkRequest && req,int loopDepth) 
	{
															#line 230 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		int clientId = req.forkState.clientId;
															#line 231 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		int forkNo = req.forkState.forkNumber;
															#line 232 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		auto it = forkOwners.find(forkNo);
															#line 233 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		if (it == forkOwners.end())
															#line 1430 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
		{
															#line 235 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
			std::cout << format("dpServerLoop: eater %d gets fork %d\n", clientId, forkNo);
															#line 236 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
			forkOwners[forkNo] = clientId;
															#line 237 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
			req.reply.send(req.forkState);
															#line 1438 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
		}
		else
		{
															#line 239 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
			auto it2 = pending.find(forkNo);
															#line 240 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
			ASSERT(it2 == pending.end());
															#line 241 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
			std::cout << format("dpServerLoop: eater %d has to wait for fork %d\n", clientId, forkNo);
															#line 242 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
			pending[forkNo] = req;
															#line 1450 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(ReleaseForkRequest const& req,int loopDepth) 
	{
															#line 246 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		int clientId = req.forkState.clientId;
															#line 247 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		int forkNo = req.forkState.forkNumber;
															#line 248 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		auto it = forkOwners.find(forkNo);
															#line 249 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		if (it == forkOwners.end())
															#line 1466 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
		{
															#line 250 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
			std::cerr << format( "dpServerLoop: request from clientId %d to free fork %d which is not owned by anybody\n", clientId, forkNo);
															#line 1470 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
		}
		else
		{
															#line 254 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
			if (it->second != clientId)
															#line 1476 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
			{
															#line 255 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
				std::cerr << format("dpServerLoop: request from clientId %d to free fork %d whichis owned by " "somebody else [%d]\n ", clientId, forkNo, it->second);
															#line 1480 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
			}
			else
			{
															#line 261 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
				std::cout << format("dpServerLoop: eater %d is freeing fork %d\n", clientId, forkNo);
															#line 262 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
				forkOwners.erase(it);
															#line 263 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
				auto it2 = pending.find(forkNo);
															#line 264 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
				if (it2 == pending.end())
															#line 1492 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
				{
															#line 265 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
					std::cout << format( "dpServerLoop: eater %d, fork %d: nobody is waiting on this fork\n", clientId, forkNo);
															#line 267 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
					req.reply.send(req.forkState);
															#line 1498 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
				}
				else
				{
															#line 269 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
					GetForkRequest pending_req = it2->second;
															#line 270 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
					pending.erase(it2);
															#line 271 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
					int nextClient = pending_req.forkState.clientId;
															#line 272 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
					std::cout << format("dpServerLoop: eater %d fork %d: giving to waiting eater %d\n", clientId, forkNo, nextClient);
															#line 276 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
					forkOwners[forkNo] = nextClient;
															#line 277 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
					req.reply.send(req.forkState);
															#line 278 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
					pending_req.reply.send(pending_req.forkState);
															#line 1516 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
				}
			}
		}
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(ReleaseForkRequest && req,int loopDepth) 
	{
															#line 246 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		int clientId = req.forkState.clientId;
															#line 247 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		int forkNo = req.forkState.forkNumber;
															#line 248 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		auto it = forkOwners.find(forkNo);
															#line 249 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
		if (it == forkOwners.end())
															#line 1534 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
		{
															#line 250 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
			std::cerr << format( "dpServerLoop: request from clientId %d to free fork %d which is not owned by anybody\n", clientId, forkNo);
															#line 1538 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
		}
		else
		{
															#line 254 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
			if (it->second != clientId)
															#line 1544 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
			{
															#line 255 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
				std::cerr << format("dpServerLoop: request from clientId %d to free fork %d whichis owned by " "somebody else [%d]\n ", clientId, forkNo, it->second);
															#line 1548 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
			}
			else
			{
															#line 261 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
				std::cout << format("dpServerLoop: eater %d is freeing fork %d\n", clientId, forkNo);
															#line 262 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
				forkOwners.erase(it);
															#line 263 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
				auto it2 = pending.find(forkNo);
															#line 264 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
				if (it2 == pending.end())
															#line 1560 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
				{
															#line 265 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
					std::cout << format( "dpServerLoop: eater %d, fork %d: nobody is waiting on this fork\n", clientId, forkNo);
															#line 267 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
					req.reply.send(req.forkState);
															#line 1566 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
				}
				else
				{
															#line 269 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
					GetForkRequest pending_req = it2->second;
															#line 270 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
					pending.erase(it2);
															#line 271 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
					int nextClient = pending_req.forkState.clientId;
															#line 272 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
					std::cout << format("dpServerLoop: eater %d fork %d: giving to waiting eater %d\n", clientId, forkNo, nextClient);
															#line 276 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
					forkOwners[forkNo] = nextClient;
															#line 277 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
					req.reply.send(req.forkState);
															#line 278 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
					pending_req.reply.send(pending_req.forkState);
															#line 1584 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
				}
			}
		}
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DpServerLoopActor*>(this)->actor_wait_state > 0) static_cast<DpServerLoopActor*>(this)->actor_wait_state = 0;
		static_cast<DpServerLoopActor*>(this)->ActorSingleCallback< DpServerLoopActor, 0, GetInterfaceRequest >::remove();
		static_cast<DpServerLoopActor*>(this)->ActorSingleCallback< DpServerLoopActor, 1, GetForkRequest >::remove();
		static_cast<DpServerLoopActor*>(this)->ActorSingleCallback< DpServerLoopActor, 2, ReleaseForkRequest >::remove();

	}
	void a_callback_fire(ActorSingleCallback< DpServerLoopActor, 0, GetInterfaceRequest >*,GetInterfaceRequest const& value) 
	{
		fdb_probe_actor_enter("dpServerLoop", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DpServerLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dpServerLoop", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< DpServerLoopActor, 0, GetInterfaceRequest >*,GetInterfaceRequest && value) 
	{
		fdb_probe_actor_enter("dpServerLoop", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DpServerLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dpServerLoop", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< DpServerLoopActor, 0, GetInterfaceRequest >*,Error err) 
	{
		fdb_probe_actor_enter("dpServerLoop", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DpServerLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dpServerLoop", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< DpServerLoopActor, 1, GetForkRequest >*,GetForkRequest const& value) 
	{
		fdb_probe_actor_enter("dpServerLoop", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DpServerLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dpServerLoop", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< DpServerLoopActor, 1, GetForkRequest >*,GetForkRequest && value) 
	{
		fdb_probe_actor_enter("dpServerLoop", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DpServerLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dpServerLoop", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< DpServerLoopActor, 1, GetForkRequest >*,Error err) 
	{
		fdb_probe_actor_enter("dpServerLoop", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DpServerLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dpServerLoop", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< DpServerLoopActor, 2, ReleaseForkRequest >*,ReleaseForkRequest const& value) 
	{
		fdb_probe_actor_enter("dpServerLoop", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DpServerLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dpServerLoop", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorSingleCallback< DpServerLoopActor, 2, ReleaseForkRequest >*,ReleaseForkRequest && value) 
	{
		fdb_probe_actor_enter("dpServerLoop", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DpServerLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dpServerLoop", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorSingleCallback< DpServerLoopActor, 2, ReleaseForkRequest >*,Error err) 
	{
		fdb_probe_actor_enter("dpServerLoop", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DpServerLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dpServerLoop", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 208 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
	DPServerInterface dpServer;
															#line 214 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
	std::map<int, int> forkOwners;
															#line 221 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
	std::map<int, GetForkRequest> pending;
															#line 1790 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
};
// This generated class is to be used only via dpServerLoop()
															#line 207 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
class DpServerLoopActor final : public Actor<Void>, public ActorSingleCallback< DpServerLoopActor, 0, GetInterfaceRequest >, public ActorSingleCallback< DpServerLoopActor, 1, GetForkRequest >, public ActorSingleCallback< DpServerLoopActor, 2, ReleaseForkRequest >, public FastAllocated<DpServerLoopActor>, public DpServerLoopActorState<DpServerLoopActor> {
															#line 1795 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
public:
	using FastAllocated<DpServerLoopActor>::operator new;
	using FastAllocated<DpServerLoopActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15679969799256946432UL, 15571553565553949952UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< DpServerLoopActor, 0, GetInterfaceRequest >;
friend struct ActorSingleCallback< DpServerLoopActor, 1, GetForkRequest >;
friend struct ActorSingleCallback< DpServerLoopActor, 2, ReleaseForkRequest >;
															#line 207 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
	DpServerLoopActor() 
															#line 1814 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
		 : Actor<Void>(),
		   DpServerLoopActorState<DpServerLoopActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("dpServerLoop", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11761240557832094976UL, 16923402719757356800UL);
		ActorExecutionContextHelper __helper(static_cast<DpServerLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("dpServerLoop");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("dpServerLoop", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< DpServerLoopActor, 0, GetInterfaceRequest >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 207 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
[[nodiscard]] Future<Void> dpServerLoop(  ) {
															#line 207 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"
	return Future<Void>(new DpServerLoopActor());
															#line 1847 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/build_output/documentation/tutorial/dining_philosophers.actor.g.cpp"
}

#line 292 "/codebuild/output/src72390971/src/github.com/apple/foundationdb/documentation/tutorial/dining_philosophers.actor.cpp"

static void usage(const char* argv0) {
	std::cerr << format("Usage: %s -p portNum | -s serverAddress\n", argv0);
}

int main(int argc, char** argv) {
	// Cargo-culted from tutorial.actor.cpp.
	platformInit();
	g_network = newNet2(TLSConfig(), /*useThreadPool=*/false, /*useMetrics=*/true);

	if (argc != 3) {
		usage(argv[0]);
		return 1;
	}

	NetworkAddress serverAddress;
	bool isServer = false;

	if (0 == strcmp(argv[1], "-p")) {
		isServer = true;
		serverAddress = NetworkAddress::parse("0.0.0.0:" + std::string(argv[2]));
	} else if (0 == strcmp(argv[1], "-s")) {
		serverAddress = NetworkAddress::parse(argv[2]);
	} else {
		usage(argv[0]);
		return 1;
	}

	FlowTransport::createInstance(!isServer, 0, DP_ENDPOINT_COUNT);

	std::vector<Future<Void>> all;
	if (isServer) {
		try {
			auto listenError = FlowTransport::transport().bind(serverAddress, serverAddress);
			if (listenError.isError()) {
				listenError.get();
			}
		} catch (Error& e) {
			std::cerr << format(
			    "Error binding to address [%s]: %d, %s\n", serverAddress.toString().c_str(), e.code(), e.what());
			return 2;
		}
		all.emplace_back(dpServerLoop());
	} else {
		for (int i = 0; i < 5; i++) {
			all.emplace_back(dpClient(serverAddress, i, 5));
		}
	}

	auto f = stopAfter(waitForAll(all));
	g_network->run();

	return 0;
}
