/*
 * Options.swift
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2016-2018 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// WARNING: This file is automatically generated, and must not be edited by hand.

public extension FDB {
    /** A set of options that can be set globally for the FoundationDB API. */
    enum NetworkOption: UInt32, Sendable {
        @available(*, deprecated)
        public static let localAddress = Self(rawValue: 10)

        @available(*, deprecated)
        public static let clusterFile = Self(rawValue: 20)

        /** Enables trace output to a file in a directory of the clients choosing */
        case traceEnable = 30

        /** Sets the maximum size in bytes of a single trace output file. This value should be in the range ``[0, INT64_MAX]``. If the value is set to 0, there is no limit on individual file size. The default is a maximum size of 10,485,760 bytes. */
        case traceRollSize = 31

        /** Sets the maximum size of all the trace output files put together. This value should be in the range ``[0, INT64_MAX]``. If the value is set to 0, there is no limit on the total size of the files. The default is a maximum size of 104,857,600 bytes. If the default roll size is used, this means that a maximum of 10 trace files will be written at a time. */
        case traceMaxLogsSize = 32

        /** Sets the 'LogGroup' attribute with the specified value for all events in the trace output files. The default log group is 'default'. */
        case traceLogGroup = 33

        /** Select the format of the log files. xml (the default) and json are supported. */
        case traceFormat = 34

        /** Select clock source for trace files. now (the default) or realtime are supported. */
        case traceClockSource = 35

        /** Once provided, this string will be used to replace the port/PID in the log file names. */
        case traceFileIdentifier = 36

        /** Use the same base trace file name for all client threads as it did before version 7.2. The current default behavior is to use distinct trace file names for client threads by including their version and thread index. */
        case traceShareAmongClientThreads = 37

        /** Initialize trace files on network setup, determine the local IP later. Otherwise tracing is initialized when opening the first database. */
        case traceInitializeOnSetup = 38

        /** Set file suffix for partially written log files. */
        case tracePartialFileSuffix = 39

        /** Set internal tuning or debugging knobs */
        case knob = 40

        @available(*, deprecated)
        public static let tlsPlugin = Self(rawValue: 41)

        /** Set the certificate chain */
        case tlsCertBytes = 42

        /** Set the file from which to load the certificate chain */
        case tlsCertPath = 43

        /** Set the private key corresponding to your own certificate */
        case tlsKeyBytes = 45

        /** Set the file from which to load the private key corresponding to your own certificate */
        case tlsKeyPath = 46

        /** Set the peer certificate field verification criteria */
        case tlsVerifyPeers = 47

        case buggifyEnable = 48

        case buggifyDisable = 49

        /** Set the probability of a BUGGIFY section being active for the current execution.  Only applies to code paths first traversed AFTER this option is changed. */
        case buggifySectionActivatedProbability = 50

        /** Set the probability of an active BUGGIFY section being fired */
        case buggifySectionFiredProbability = 51

        /** Set the ca bundle */
        case tlsCaBytes = 52

        /** Set the file from which to load the certificate authority bundle */
        case tlsCaPath = 53

        /** Set the passphrase for encrypted private key. Password should be set before setting the key for the password to be used. */
        case tlsPassword = 54

        /** Prevent client from connecting to a non-TLS endpoint by throwing network connection failed error. */
        case tlsDisablePlaintextConnection = 55

        /** Disables the multi-version client API and instead uses the local client directly. Must be set before setting up the network. */
        case disableMultiVersionClientApi = 60

        /** If set, callbacks from external client libraries can be called from threads created by the FoundationDB client library. Otherwise, callbacks will be called from either the thread used to add the callback or the network thread. Setting this option can improve performance when connected using an external client, but may not be safe to use in all environments. Must be set before setting up the network. WARNING: This feature is considered experimental at this time. */
        case callbacksOnExternalThreads = 61

        /** Adds an external client library for use by the multi-version client API. Must be set before setting up the network. */
        case externalClientLibrary = 62

        /** Searches the specified path for dynamic libraries and adds them to the list of client libraries for use by the multi-version client API. Must be set before setting up the network. */
        case externalClientDirectory = 63

        /** Prevents connections through the local client, allowing only connections through externally loaded client libraries. */
        case disableLocalClient = 64

        /** Spawns multiple worker threads for each version of the client that is loaded.  Setting this to a number greater than one implies disable_local_client. */
        case clientThreadsPerVersion = 65

        /** Adds an external client library to be used with a future version protocol. This option can be used testing purposes only! */
        case futureVersionClientLibrary = 66

        /** Retain temporary external client library copies that are created for enabling multi-threading. */
        case retainClientLibraryCopies = 67

        /** Ignore the failure to initialize some of the external clients */
        case ignoreExternalClientFailures = 68

        /** Fail with an error if there is no client matching the server version the client is connecting to */
        case failIncompatibleClient = 69

        /** Disables logging of client statistics, such as sampled transaction activity. */
        case disableClientStatisticsLogging = 70

        @available(*, deprecated)
        public static let enableSlowTaskProfiling = Self(rawValue: 71)

        /** Enables debugging feature to perform run loop profiling. Requires trace logging to be enabled. WARNING: this feature is not recommended for use in production. */
        case enableRunLoopProfiling = 71

        /** Prevents the multi-version client API from being disabled, even if no external clients are configured. This option is required to use GRV caching. */
        case disableClientBypass = 72

        /** Enable client buggify - will make requests randomly fail (intended for client testing) */
        case clientBuggifyEnable = 80

        /** Disable client buggify */
        case clientBuggifyDisable = 81

        /** Set the probability of a CLIENT_BUGGIFY section being active for the current execution. */
        case clientBuggifySectionActivatedProbability = 82

        /** Set the probability of an active CLIENT_BUGGIFY section being fired. A section will only fire if it was activated */
        case clientBuggifySectionFiredProbability = 83

        /** Set a tracer to run on the client. Should be set to the same value as the tracer set on the server. */
        case distributedClientTracer = 90

        /** Sets the directory for storing temporary files created by FDB client, such as temporary copies of client libraries. Defaults to /tmp */
        case clientTmpDir = 91

        /** This option is set automatically to communicate the list of supported clients to the active client. */
        case supportedClientVersions = 1000

        /** This option is set automatically on all clients loaded externally using the multi-version API. */
        case externalClient = 1001

        /** This option tells a child on a multiversion client what transport ID to use. */
        case externalClientTransportId = 1002
    }

    /** A set of options that can be set on a database. */
    enum DatabaseOption: UInt32, Sendable {
        /** Set the size of the client location cache. Raising this value can boost performance in very large databases where clients access data in a near-random pattern. Defaults to 100000. */
        case locationCacheSize = 10

        /** Set the maximum number of watches allowed to be outstanding on a database connection. Increasing this number could result in increased resource usage. Reducing this number will not cancel any outstanding watches. Defaults to 10000 and cannot be larger than 1000000. */
        case maxWatches = 20

        /** Specify the machine ID that was passed to fdbserver processes running on the same machine as this client, for better location-aware load balancing. */
        case machineId = 21

        /** Specify the datacenter ID that was passed to fdbserver processes running in the same datacenter as this client, for better location-aware load balancing. */
        case datacenterId = 22

        /** Snapshot read operations will see the results of writes done in the same transaction. This is the default behavior. */
        case snapshotRywEnable = 26

        /** Snapshot read operations will not see the results of writes done in the same transaction. This was the default behavior prior to API version 300. */
        case snapshotRywDisable = 27

        /** Sets the maximum escaped length of key and value fields to be logged to the trace file via the LOG_TRANSACTION option. This sets the ``transaction_logging_max_field_length`` option of each transaction created by this database. See the transaction option description for more information. */
        case transactionLoggingMaxFieldLength = 405

        /** Set a timeout in milliseconds which, when elapsed, will cause each transaction automatically to be cancelled. This sets the ``timeout`` option of each transaction created by this database. See the transaction option description for more information. Using this option requires that the API version is 610 or higher. */
        case transactionTimeout = 500

        /** Set a maximum number of retries after which additional calls to ``onError`` will throw the most recently seen error code. This sets the ``retry_limit`` option of each transaction created by this database. See the transaction option description for more information. */
        case transactionRetryLimit = 501

        /** Set the maximum amount of backoff delay incurred in the call to ``onError`` if the error is retryable. This sets the ``max_retry_delay`` option of each transaction created by this database. See the transaction option description for more information. */
        case transactionMaxRetryDelay = 502

        /** Set the maximum transaction size in bytes. This sets the ``size_limit`` option on each transaction created by this database. See the transaction option description for more information. */
        case transactionSizeLimit = 503

        /** The read version will be committed, and usually will be the latest committed, but might not be the latest committed in the event of a simultaneous fault and misbehaving clock. */
        case transactionCausalReadRisky = 504

        /** Deprecated. Addresses returned by get_addresses_for_key include the port when enabled. As of api version 630, this option is enabled by default and setting this has no effect. */
        case transactionIncludePortInAddress = 505

        /** Set a random idempotency id for all transactions. See the transaction option description for more information. This feature is in development and not ready for general use. */
        case transactionAutomaticIdempotency = 506

        /** Allows ``get`` operations to read from sections of keyspace that have become unreadable because of versionstamp operations. This sets the ``bypass_unreadable`` option of each transaction created by this database. See the transaction option description for more information. */
        case transactionBypassUnreadable = 700

        /** By default, operations that are performed on a transaction while it is being committed will not only fail themselves, but they will attempt to fail other in-flight operations (such as the commit) as well. This behavior is intended to help developers discover situations where operations could be unintentionally executed after the transaction has been reset. Setting this option removes that protection, causing only the offending operation to fail. */
        case transactionUsedDuringCommitProtectionDisable = 701

        /** Enables conflicting key reporting on all transactions, allowing them to retrieve the keys that are conflicting with other transactions. */
        case transactionReportConflictingKeys = 702

        /** Use configuration database. */
        case useConfigDatabase = 800

        /** Enables verification of causal read risky by checking whether clients are able to read stale data when they detect a recovery, and logging an error if so. */
        case testCausalReadRisky = 900
    }

    /** A set of options that can be set on a transaction. */
    enum TransactionOption: UInt32, Sendable {
        /** The transaction, if not self-conflicting, may be committed a second time after commit succeeds, in the event of a fault */
        case causalWriteRisky = 10

        /** The read version will be committed, and usually will be the latest committed, but might not be the latest committed in the event of a simultaneous fault and misbehaving clock. */
        case causalReadRisky = 20

        case causalReadDisable = 21

        /** Addresses returned by get_addresses_for_key include the port when enabled. As of api version 630, this option is enabled by default and setting this has no effect. */
        case includePortInAddress = 23

        /** The next write performed on this transaction will not generate a write conflict range. As a result, other transactions which read the key(s) being modified by the next write will not conflict with this transaction. Care needs to be taken when using this option on a transaction that is shared between multiple threads. When setting this option, write conflict ranges will be disabled on the next write operation, regardless of what thread it is on. */
        case nextWriteNoWriteConflictRange = 30

        /** Committing this transaction will bypass the normal load balancing across commit proxies and go directly to the specifically nominated 'first commit proxy'. */
        case commitOnFirstProxy = 40

        case checkWritesEnable = 50

        /** Reads performed by a transaction will not see any prior mutations that occurred in that transaction, instead seeing the value which was in the database at the transaction's read version. This option may provide a small performance benefit for the client, but also disables a number of client-side optimizations which are beneficial for transactions which tend to read and write the same keys within a single transaction. It is an error to set this option after performing any reads or writes on the transaction. */
        case readYourWritesDisable = 51

        @available(*, deprecated)
        public static let readAheadDisable = Self(rawValue: 52)

        /** Storage server should cache disk blocks needed for subsequent read requests in this transaction.  This is the default behavior. */
        case readServerSideCacheEnable = 507

        /** Storage server should not cache disk blocks needed for subsequent read requests in this transaction.  This can be used to avoid cache pollution for reads not expected to be repeated. */
        case readServerSideCacheDisable = 508

        /** Use normal read priority for subsequent read requests in this transaction.  This is the default read priority. */
        case readPriorityNormal = 509

        /** Use low read priority for subsequent read requests in this transaction. */
        case readPriorityLow = 510

        /** Use high read priority for subsequent read requests in this transaction. */
        case readPriorityHigh = 511

        case durabilityDatacenter = 110

        case durabilityRisky = 120

        @available(*, deprecated)
        public static let durabilityDevNullIsWebScale = Self(rawValue: 130)

        /** Specifies that this transaction should be treated as highest priority and that lower priority transactions should block behind this one. Use is discouraged outside of low-level tools */
        case prioritySystemImmediate = 200

        /** Specifies that this transaction should be treated as low priority and that default priority transactions will be processed first. Batch priority transactions will also be throttled at load levels smaller than for other types of transactions and may be fully cut off in the event of machine failures. Useful for doing batch work simultaneously with latency-sensitive work */
        case priorityBatch = 201

        /** This is a write-only transaction which sets the initial configuration. This option is designed for use by database system tools only. */
        case initializeNewDatabase = 300

        /** Allows this transaction to read and modify system keys (those that start with the byte 0xFF). Implies raw_access. */
        case accessSystemKeys = 301

        /** Allows this transaction to read system keys (those that start with the byte 0xFF). Implies raw_access. */
        case readSystemKeys = 302

        /** Allows this transaction to access the raw key-space when tenant mode is on. */
        case rawAccess = 303

        /** Allows this transaction to bypass storage quota enforcement. Should only be used for transactions that directly or indirectly decrease the size of the tenant group's data. */
        case bypassStorageQuota = 304

        case debugDump = 400

        case debugRetryLogging = 401

        @available(*, deprecated)
        public static let transactionLoggingEnable = Self(rawValue: 402)

        /** Sets a client provided identifier for the transaction that will be used in scenarios like tracing or profiling. Client trace logging or transaction profiling must be separately enabled. */
        case debugTransactionIdentifier = 403

        /** Enables tracing for this transaction and logs results to the client trace logs. The DEBUG_TRANSACTION_IDENTIFIER option must be set before using this option, and client trace logging must be enabled to get log output. */
        case logTransaction = 404

        /** Sets the maximum escaped length of key and value fields to be logged to the trace file via the LOG_TRANSACTION option, after which the field will be truncated. A negative value disables truncation. */
        case transactionLoggingMaxFieldLength = 405

        /** Sets an identifier for server tracing of this transaction. When committed, this identifier triggers logging when each part of the transaction authority encounters it, which is helpful in diagnosing slowness in misbehaving clusters. The identifier is randomly generated. When there is also a debug_transaction_identifier, both IDs are logged together. */
        case serverRequestTracing = 406

        /** Set a timeout in milliseconds which, when elapsed, will cause the transaction automatically to be cancelled. Valid parameter values are ``[0, INT_MAX]``. If set to 0, will disable all timeouts. All pending and any future uses of the transaction will throw an exception. The transaction can be used again after it is reset. Prior to API version 610, like all other transaction options, the timeout must be reset after a call to ``onError``. If the API version is 610 or greater, the timeout is not reset after an ``onError`` call. This allows the user to specify a longer timeout on specific transactions than the default timeout specified through the ``transaction_timeout`` database option without the shorter database timeout cancelling transactions that encounter a retryable error. Note that at all API versions, it is safe and legal to set the timeout each time the transaction begins, so most code written assuming the older behavior can be upgraded to the newer behavior without requiring any modification, and the caller is not required to implement special logic in retry loops to only conditionally set this option. */
        case timeout = 500

        /** Set a maximum number of retries after which additional calls to ``onError`` will throw the most recently seen error code. Valid parameter values are ``[-1, INT_MAX]``. If set to -1, will disable the retry limit. Prior to API version 610, like all other transaction options, the retry limit must be reset after a call to ``onError``. If the API version is 610 or greater, the retry limit is not reset after an ``onError`` call. Note that at all API versions, it is safe and legal to set the retry limit each time the transaction begins, so most code written assuming the older behavior can be upgraded to the newer behavior without requiring any modification, and the caller is not required to implement special logic in retry loops to only conditionally set this option. */
        case retryLimit = 501

        /** Set the maximum amount of backoff delay incurred in the call to ``onError`` if the error is retryable. Defaults to 1000 ms. Valid parameter values are ``[0, INT_MAX]``. If the maximum retry delay is less than the current retry delay of the transaction, then the current retry delay will be clamped to the maximum retry delay. Prior to API version 610, like all other transaction options, the maximum retry delay must be reset after a call to ``onError``. If the API version is 610 or greater, the retry limit is not reset after an ``onError`` call. Note that at all API versions, it is safe and legal to set the maximum retry delay each time the transaction begins, so most code written assuming the older behavior can be upgraded to the newer behavior without requiring any modification, and the caller is not required to implement special logic in retry loops to only conditionally set this option. */
        case maxRetryDelay = 502

        /** Set the transaction size limit in bytes. The size is calculated by combining the sizes of all keys and values written or mutated, all key ranges cleared, and all read and write conflict ranges. (In other words, it includes the total size of all data included in the request to the cluster to commit the transaction.) Large transactions can cause performance problems on FoundationDB clusters, so setting this limit to a smaller value than the default can help prevent the client from accidentally degrading the cluster's performance. This value must be at least 32 and cannot be set to higher than 10,000,000, the default transaction size limit. */
        case sizeLimit = 503

        /** Associate this transaction with this ID for the purpose of checking whether or not this transaction has already committed. Must be at least 16 bytes and less than 256 bytes. This feature is in development and not ready for general use. Unless the automatic_idempotency option is set after this option, the client will not automatically attempt to remove this id from the cluster after a successful commit. */
        case idempotencyId = 504

        /** Automatically assign a random 16 byte idempotency id for this transaction. Prevents commits from failing with ``commit_unknown_result``. WARNING: If you are also using the multiversion client or transaction timeouts, if either cluster_version_changed or transaction_timed_out was thrown during a commit, then that commit may have already succeeded or may succeed in the future. This feature is in development and not ready for general use. */
        case automaticIdempotency = 505

        /** Snapshot read operations will see the results of writes done in the same transaction. This is the default behavior. */
        case snapshotRywEnable = 600

        /** Snapshot read operations will not see the results of writes done in the same transaction. This was the default behavior prior to API version 300. */
        case snapshotRywDisable = 601

        /** The transaction can read and write to locked databases, and is responsible for checking that it took the lock. */
        case lockAware = 700

        /** By default, operations that are performed on a transaction while it is being committed will not only fail themselves, but they will attempt to fail other in-flight operations (such as the commit) as well. This behavior is intended to help developers discover situations where operations could be unintentionally executed after the transaction has been reset. Setting this option removes that protection, causing only the offending operation to fail. */
        case usedDuringCommitProtectionDisable = 701

        /** The transaction can read from locked databases. */
        case readLockAware = 702

        /** No other transactions will be applied before this transaction within the same commit version. */
        case firstInBatch = 710

        /** This option should only be used by tools which change the database configuration. */
        case useProvisionalProxies = 711

        /** The transaction can retrieve keys that are conflicting with other transactions. */
        case reportConflictingKeys = 712

        /** By default, the special key space will only allow users to read from exactly one module (a subspace in the special key space). Use this option to allow reading from zero or more modules. Users who set this option should be prepared for new modules, which may have different behaviors than the modules they're currently reading. For example, a new module might block or return an error. */
        case specialKeySpaceRelaxed = 713

        /** By default, users are not allowed to write to special keys. Enable this option will implicitly enable all options required to achieve the configuration change. */
        case specialKeySpaceEnableWrites = 714

        /** Adds a tag to the transaction that can be used to apply manual targeted throttling. At most 5 tags can be set on a transaction. */
        case tag = 800

        /** Adds a tag to the transaction that can be used to apply manual or automatic targeted throttling. At most 5 tags can be set on a transaction. */
        case autoThrottleTag = 801

        /** Adds a parent to the Span of this transaction. Used for transaction tracing. A span can be identified with a 33 bytes serialized binary format which consists of: 8 bytes protocol version, e.g. ``0x0FDB00B073000000LL`` in little-endian format, 16 bytes trace id, 8 bytes span id, 1 byte set to 1 if sampling is enabled */
        case spanParent = 900

        /** Asks storage servers for how many bytes a clear key range contains. Otherwise uses the location cache to roughly estimate this. */
        case expensiveClearCostEstimationEnable = 1000

        /** Allows ``get`` operations to read from sections of keyspace that have become unreadable because of versionstamp operations. These reads will view versionstamp operations as if they were set operations that did not fill in the versionstamp. */
        case bypassUnreadable = 1100

        /** Allows this transaction to use cached GRV from the database context. Defaults to off. Upon first usage, starts a background updater to periodically update the cache to avoid stale read versions. The disable_client_bypass option must also be set. */
        case useGrvCache = 1101

        /** Specifically instruct this transaction to NOT use cached GRV. Primarily used for the read version cache's background updater to avoid attempting to read a cached entry in specific situations. */
        case skipGrvCache = 1102

        /** Attach given authorization token to the transaction such that subsequent tenant-aware requests are authorized */
        case authorizationToken = 2000

        /** Enables replica consistency check, which compares the results returned by storage server replicas (as many as specified by consistency_check_required_replicas option) for a given read request, in client-side load balancer. */
        case enableReplicaConsistencyCheck = 4000

        /** Specifies the number of storage server replica results that the load balancer needs to compare when enable_replica_consistency_check option is set. */
        case consistencyCheckRequiredReplicas = 4001
    }

    /** Options that control the way the binding performs range reads. */
    enum StreamingMode: Int32, Sendable {
        /** Client intends to consume the entire range and would like it all transferred as early as possible. */
        case wantAll = -2

        /** The default. The client doesn't know how much of the range it is likely to used and wants different performance concerns to be balanced. Only a small portion of data is transferred to the client initially (in order to minimize costs if the client doesn't read the entire range), and as the caller iterates over more items in the range larger batches will be transferred in order to minimize latency. After enough iterations, the iterator mode will eventually reach the same byte limit as ``WANT_ALL`` */
        case iterator = -1

        /** Infrequently used. The client has passed a specific row limit and wants that many rows delivered in a single batch. Because of iterator operation in client drivers make request batches transparent to the user, consider ``WANT_ALL`` StreamingMode instead. A row limit must be specified if this mode is used. */
        case exact = 0

        /** Infrequently used. Transfer data in batches small enough to not be much more expensive than reading individual rows, to minimize cost if iteration stops early. */
        case small = 1

        /** Infrequently used. Transfer data in batches sized in between small and large. */
        case medium = 2

        /** Infrequently used. Transfer data in batches large enough to be, in a high-concurrency environment, nearly as efficient as possible. If the client stops iteration early, some disk and network bandwidth may be wasted. The batch size may still be too small to allow a single client to get high throughput from the database, so if that is what you need consider the SERIAL StreamingMode. */
        case large = 3

        /** Transfer data in batches large enough that an individual client can get reasonable read bandwidth from the database. If the client stops iteration early, considerable disk and network bandwidth may be wasted. */
        case serial = 4
    }

    /** A set of operations that can be performed atomically on a database. */
    enum MutationType: UInt32, Sendable {
        /** Performs an addition of little-endian integers. If the existing value in the database is not present or shorter than ``param``, it is first extended to the length of ``param`` with zero bytes.  If ``param`` is shorter than the existing value in the database, the existing value is truncated to match the length of ``param``. The integers to be added must be stored in a little-endian representation.  They can be signed in two's complement representation or unsigned. You can add to an integer at a known offset in the value by prepending the appropriate number of zero bytes to ``param`` and padding with zero bytes to match the length of the value. However, this offset technique requires that you know the addition will not cause the integer field within the value to overflow. */
        case add = 2

        @available(*, deprecated)
        public static let and = Self(rawValue: 6)

        /** Performs a bitwise ``and`` operation.  If the existing value in the database is not present, then ``param`` is stored in the database. If the existing value in the database is shorter than ``param``, it is first extended to the length of ``param`` with zero bytes.  If ``param`` is shorter than the existing value in the database, the existing value is truncated to match the length of ``param``. */
        case bitAnd = 6

        @available(*, deprecated)
        public static let or = Self(rawValue: 7)

        /** Performs a bitwise ``or`` operation.  If the existing value in the database is not present or shorter than ``param``, it is first extended to the length of ``param`` with zero bytes.  If ``param`` is shorter than the existing value in the database, the existing value is truncated to match the length of ``param``. */
        case bitOr = 7

        @available(*, deprecated)
        public static let xor = Self(rawValue: 8)

        /** Performs a bitwise ``xor`` operation.  If the existing value in the database is not present or shorter than ``param``, it is first extended to the length of ``param`` with zero bytes.  If ``param`` is shorter than the existing value in the database, the existing value is truncated to match the length of ``param``. */
        case bitXor = 8

        /** Appends ``param`` to the end of the existing value already in the database at the given key (or creates the key and sets the value to ``param`` if the key is empty). This will only append the value if the final concatenated value size is less than or equal to the maximum value size (i.e., if it fits). WARNING: No error is surfaced back to the user if the final value is too large because the mutation will not be applied until after the transaction has been committed. Therefore, it is only safe to use this mutation type if one can guarantee that one will keep the total value size under the maximum size. */
        case appendIfFits = 9

        /** Performs a little-endian comparison of byte strings. If the existing value in the database is not present or shorter than ``param``, it is first extended to the length of ``param`` with zero bytes.  If ``param`` is shorter than the existing value in the database, the existing value is truncated to match the length of ``param``. The larger of the two values is then stored in the database. */
        case max = 12

        /** Performs a little-endian comparison of byte strings. If the existing value in the database is not present, then ``param`` is stored in the database. If the existing value in the database is shorter than ``param``, it is first extended to the length of ``param`` with zero bytes.  If ``param`` is shorter than the existing value in the database, the existing value is truncated to match the length of ``param``. The smaller of the two values is then stored in the database. */
        case min = 13

        /** Transforms ``key`` using a versionstamp for the transaction. Sets the transformed key in the database to ``param``. The key is transformed by removing the final four bytes from the key and reading those as a little-Endian 32-bit integer to get a position ``pos``. The 10 bytes of the key from ``pos`` to ``pos + 10`` are replaced with the versionstamp of the transaction used. The first byte of the key is position 0. A versionstamp is a 10 byte, unique, monotonically (but not sequentially) increasing value for each committed transaction. The first 8 bytes are the committed version of the database (serialized in big-Endian order). The last 2 bytes are monotonic in the serialization order for transactions. WARNING: At this time, versionstamps are compatible with the Tuple layer only in the Java, Python, and Go bindings. Also, note that prior to API version 520, the offset was computed from only the final two bytes rather than the final four bytes. */
        case setVersionstampedKey = 14

        /** Transforms ``param`` using a versionstamp for the transaction. Sets the ``key`` given to the transformed ``param``. The parameter is transformed by removing the final four bytes from ``param`` and reading those as a little-Endian 32-bit integer to get a position ``pos``. The 10 bytes of the parameter from ``pos`` to ``pos + 10`` are replaced with the versionstamp of the transaction used. The first byte of the parameter is position 0. A versionstamp is a 10 byte, unique, monotonically (but not sequentially) increasing value for each committed transaction. The first 8 bytes are the committed version of the database (serialized in big-Endian order). The last 2 bytes are monotonic in the serialization order for transactions. WARNING: At this time, versionstamps are compatible with the Tuple layer only in the Java, Python, and Go bindings. Also, note that prior to API version 520, the versionstamp was always placed at the beginning of the parameter rather than computing an offset. */
        case setVersionstampedValue = 15

        /** Performs lexicographic comparison of byte strings. If the existing value in the database is not present, then ``param`` is stored. Otherwise the smaller of the two values is then stored in the database. */
        case byteMin = 16

        /** Performs lexicographic comparison of byte strings. If the existing value in the database is not present, then ``param`` is stored. Otherwise the larger of the two values is then stored in the database. */
        case byteMax = 17

        /** Performs an atomic ``compare and clear`` operation. If the existing value in the database is equal to the given value, then given key is cleared. */
        case compareAndClear = 20
    }

    /** Conflict range types used internally by the C API. */
    enum ConflictRangeType: UInt32, Sendable {
        /** Used to add a read conflict range */
        case read = 0

        /** Used to add a write conflict range */
        case write = 1
    }

    /** Error code predicates for binding writers and non-standard layer implementers. */
    enum ErrorPredicate: UInt32, Sendable {
        /** Returns ``true`` if the error indicates the operations in the transactions should be retried because of transient error. */
        case retryable = 50000

        /** Returns ``true`` if the error indicates the transaction may have succeeded, though not in a way the system can verify. */
        case maybeCommitted = 50001

        /** Returns ``true`` if the error indicates the transaction has not committed, though in a way that can be retried. */
        case retryableNotCommitted = 50002
    }
}
