#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
/*
 * S3ClientWorkload.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2025 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbserver/MockS3Server.h"
#include "fdbserver/MockS3ServerChaos.h"

#include "fdbrpc/HTTP.h"
#include "fdbrpc/simulator.h"
#include "flow/Trace.h"
#include "flow/ActorCollection.h"
#include "flow/IRandom.h"
#include "flow/serialize.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/S3Client.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/BulkLoadUtil.actor.h"
#include "flow/Platform.h"

#include <string>
#include <vector>
#include <libgen.h>

#include "flow/actorcompiler.h" // This must be the last #include.

// Test s3client operations against s3.
// Run this workload with ../build_output/bin/fdbserver -r simulation -f
// ../src/foundationdb/tests/slow/S3ClientWorkload.toml
struct S3ClientWorkload : TestWorkload {
	static constexpr auto NAME = "S3ClientWorkload";
	const bool enabled;
	bool pass;
	std::string s3Url;
	std::string credentials;
	std::string simfdbDir;

	// Chaos injection options
	bool enableChaos;
	double errorRate;
	double throttleRate;
	double delayRate;
	double corruptionRate;
	double maxDelay;

	S3ClientWorkload(WorkloadContext const& wcx) : TestWorkload(wcx), enabled(true), pass(true) {
		s3Url = getOption(options, "s3Url"_sr, ""_sr).toString();
		if (s3Url.empty()) {
			// Default location for s3 instance.
			s3Url = "blobstore://127.0.0.1:8333";
		}
		simfdbDir = getOption(options, "simfdb"_sr, "simfdb"_sr).toString();
		// Place credentials file in the simulation root, NOT inside the server's data dir (simfdbDir)
		credentials = "S3ClientWorkload.blob-credentials.json";

		// Initialize chaos options
		enableChaos = getOption(options, "enableChaos"_sr, false);
		errorRate = getOption(options, "errorRate"_sr, 0.1);
		throttleRate = getOption(options, "throttleRate"_sr, 0.05);
		delayRate = getOption(options, "delayRate"_sr, 0.1);
		corruptionRate = getOption(options, "corruptionRate"_sr, 0.01);
		maxDelay = getOption(options, "maxDelay"_sr, 2.0);
	}
	~S3ClientWorkload() {
		if (pass) {
			TraceEvent("S3ClientWorkloadPass");
		} else {
			TraceEvent("S3ClientWorkloadFail");
		}
	}

	Future<Void> setup(Database const& cx) override {
		if (!enabled)
			return Void();
		return _setup(this, cx);
	}

	Future<Void> start(Database const& cx) override { return _start(this, cx); }

	Future<bool> check(Database const& cx) override { return true; }

	void getMetrics(std::vector<PerfMetric>& m) override {}

private:
	void setupCredentialsFile() {
		// Write the credentials file content -- hardcoded and nonsense for now. It just needs to be present.
		writeFile(
		    credentials,
		    "{\"accounts\":{\"@host\":{\"api_key\":\"seaweedfs\",\"secret\":\"tot4llys3cure\",\"token\":\"TOKEN\"}}}");

		// Set the credentials file path into the global network configuration
		auto* blobCredFiles = (std::vector<std::string>*)g_network->global(INetwork::enBlobCredentialFiles);
		if (!blobCredFiles) {
			blobCredFiles = new std::vector<std::string>();
			g_network->setGlobal(INetwork::enBlobCredentialFiles, blobCredFiles);
		}
		blobCredFiles->push_back(credentials);
	}

	// Add the basename of a file to the URL path
	// Uses S3BlobStoreEndpoint::fromString() for robust URL parsing (similar to
	// BlobMetadataUtils::getBlobMetadataPartitionedURL)
	static std::string addFileToUrl(std::string filePath, std::string baseUrl) {
		std::string basename = ::basename(const_cast<char*>(filePath.c_str()));

		try {
			std::string resource;
			std::string error;
			S3BlobStoreEndpoint::ParametersT parameters;
			Reference<S3BlobStoreEndpoint> endpoint =
			    S3BlobStoreEndpoint::fromString(baseUrl, {}, &resource, &error, &parameters);

			if (!error.empty() || !endpoint) {
				TraceEvent(SevError, "S3ClientWorkloadURLParseError").detail("URL", baseUrl).detail("Error", error);
				throw backup_invalid_url();
			}

			// If there's an existing resource in the URL, find it and append the basename after it
			if (!resource.empty()) {
				size_t resourceStart = baseUrl.find(resource);
				if (resourceStart == std::string::npos) {
					throw backup_invalid_url();
				}
				// Insert "/basename" after the existing resource
				std::string separator = (resource.back() == '/') ? "" : "/";
				return baseUrl.insert(resourceStart + resource.size(), separator + basename);
			} else {
				// No resource in URL, need to insert before query string
				size_t queryStart = baseUrl.find('?');
				if (queryStart != std::string::npos) {
					return baseUrl.insert(queryStart, "/" + basename);
				} else {
					return baseUrl + "/" + basename;
				}
			}
		} catch (Error& e) {
			TraceEvent(SevError, "S3ClientWorkloadURLParseError")
			    .error(e)
			    .detail("URL", baseUrl)
			    .detail("Path", filePath);
			throw;
		}
	}

																#line 162 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
// This generated class is to be used only via _start()
															#line 160 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
template <class _startActor>
															#line 160 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
class _startActorState {
															#line 168 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
public:
															#line 160 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
	_startActorState(S3ClientWorkload* const& self,Database const& cx) 
															#line 160 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
															#line 160 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		 : self(self),
															#line 160 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		   cx(cx)
															#line 177 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 161 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			if (self->clientId != 0)
															#line 192 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
			{
															#line 164 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
				if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 196 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
				new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~_startActorState();
				static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 166 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			if (g_network->isSimulated())
															#line 204 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
			{
															#line 170 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
				disableConnectionFailures("BulkLoading");
															#line 208 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
			}
															#line 174 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			download_path_to_clean = "downloaded_credentials";
															#line 212 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
			try {
															#line 177 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
				if (fileExists(self->credentials))
															#line 216 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
				{
															#line 178 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
					deleteFile(self->credentials);
															#line 179 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
					TraceEvent(SevDebug, "S3ClientWorkloadCleanedPreExistingFile").detail("File", self->credentials);
															#line 222 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
				}
															#line 183 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
				platform::eraseDirectoryRecursive(download_path_to_clean);
															#line 184 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
				TraceEvent(SevDebug, "S3ClientWorkloadAttemptedCleanPreExistingDownload") .detail("Path", download_path_to_clean);
															#line 228 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
				loopDepth = a_body1cont6(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 197 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		uniqueRunDir = joinPath(self->simfdbDir, format("s3_workload_run_%08x_%08x", self->clientId, deterministicRandom()->randomInt(0, 1000000)));
															#line 257 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
		try {
															#line 201 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			platform::createDirectory(uniqueRunDir);
															#line 202 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			TraceEvent(SevDebug, "S3ClientWorkloadCreatedRunDir").detail("Dir", uniqueRunDir);
															#line 263 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
			loopDepth = a_body1cont9(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 188 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			TraceEvent(SevWarn, "S3ClientWorkloadPreCleanupError").errorUnsuppressed(e);
															#line 279 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7(int loopDepth) 
	{
															#line 210 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		self->credentials = joinPath(uniqueRunDir, "S3ClientWorkload.blob-credentials.json");
															#line 211 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		download = joinPath(uniqueRunDir, "downloaded_credentials");
															#line 214 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		self->setupCredentialsFile();
															#line 217 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		std::string baseFilename = ::basename(const_cast<char*>(self->credentials.c_str()));
															#line 221 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		std::string deterministicId = format("%08x_%08x", self->clientId, deterministicRandom()->randomInt(0, 1000000));
															#line 222 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		std::string uniqueObjectKey = baseFilename + "_" + deterministicId;
															#line 223 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		file_url = self->addFileToUrl(uniqueObjectKey, self->s3Url);
															#line 224 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		uploaded = false;
															#line 225 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		errorToThrow = Optional<Error>();
															#line 323 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
		try {
															#line 229 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = copyUpFile(self->credentials, file_url);
															#line 229 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont7Catch1(actor_cancelled(), loopDepth);
															#line 329 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1cont7Catch1(__when_expr_0.getError(), loopDepth); else return a_body1cont7when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 229 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 334 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont7Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont7Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 204 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			TraceEvent(SevError, "S3ClientWorkloadCreateRunDirError").errorUnsuppressed(e).detail("Dir", uniqueRunDir);
															#line 205 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 352 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont9(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10(int loopDepth) 
	{
															#line 259 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		if (errorToThrow.present())
															#line 379 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
		{
															#line 260 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			return a_body1Catch1(errorToThrow.get(), loopDepth);
															#line 383 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
		}
															#line 265 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		std::string originalContent = readFileBytes(self->credentials, 1024 * 1024);
															#line 266 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		std::string downloadedContent = readFileBytes(download, 1024 * 1024);
															#line 267 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		if (originalContent != downloadedContent)
															#line 391 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
		{
															#line 268 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			TraceEvent(SevError, "S3ClientWorkloadContentMismatch") .detailf("OriginalSize", "%zu", originalContent.size()) .detailf("DownloadedSize", "%zu", downloadedContent.size());
															#line 271 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			return a_body1Catch1(file_not_found(), loopDepth);
															#line 397 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
		}
		try {
															#line 277 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			if (fileExists(self->credentials))
															#line 402 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
			{
															#line 278 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
				deleteFile(self->credentials);
															#line 279 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
				TraceEvent(SevDebug, "S3ClientWorkloadDeletedCredentials").detail("File", self->credentials);
															#line 408 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont10cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont10Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont10Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 234 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			TraceEvent(SevError, "S3ClientWorkloadError") .error(e) .detail("S3URL", file_url) .detail("Path", self->credentials) .detail("Download", download);
															#line 241 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			errorToThrow = e;
															#line 244 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			if (uploaded)
															#line 429 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
			{
				try {
															#line 246 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
					StrictFuture<Void> __when_expr_3 = deleteResource(file_url);
															#line 246 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
					if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont7Catch1Catch1(actor_cancelled(), loopDepth);
															#line 436 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
					if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont7Catch1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont7Catch1when1(__when_expr_3.get(), loopDepth); };
					static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 246 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
					__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 441 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				catch (Error& error) {
					loopDepth = a_body1cont7Catch1Catch1(error, loopDepth);
				} catch (...) {
					loopDepth = a_body1cont7Catch1Catch1(unknown_error(), loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1cont7Catch1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11(Void const& _,int loopDepth) 
	{
															#line 230 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		uploaded = true;
															#line 231 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = copyDownFile(file_url, download);
															#line 231 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont7Catch1(actor_cancelled(), loopDepth);
															#line 471 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont7Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont11when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 231 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 476 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11(Void && _,int loopDepth) 
	{
															#line 230 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		uploaded = true;
															#line 231 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = copyDownFile(file_url, download);
															#line 231 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont7Catch1(actor_cancelled(), loopDepth);
															#line 489 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont7Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont11when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 231 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 494 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont7Catch1(error, 0);
		} catch (...) {
			a_body1cont7Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont7Catch1(error, 0);
		} catch (...) {
			a_body1cont7Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1cont7Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont7Catch1(error, 0);
		} catch (...) {
			a_body1cont7Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont11cont1(Void const& _,int loopDepth) 
	{
															#line 232 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_2 = deleteResource(file_url);
															#line 232 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont7Catch1(actor_cancelled(), loopDepth);
															#line 580 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont7Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont11cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 232 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 585 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont1(Void && _,int loopDepth) 
	{
															#line 232 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_2 = deleteResource(file_url);
															#line 232 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont7Catch1(actor_cancelled(), loopDepth);
															#line 596 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont7Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont11cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 232 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 601 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont7Catch1(error, 0);
		} catch (...) {
			a_body1cont7Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont7Catch1(error, 0);
		} catch (...) {
			a_body1cont7Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont7Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont7Catch1(error, 0);
		} catch (...) {
			a_body1cont7Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont11cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont11cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont7Catch1(error, 0);
		} catch (...) {
			a_body1cont7Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont11cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont7Catch1(error, 0);
		} catch (...) {
			a_body1cont7Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont7Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont7Catch1(error, 0);
		} catch (...) {
			a_body1cont7Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont11cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont10(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont7Catch1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont7Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7Catch1Catch1(const Error& cleanup_e,int loopDepth=0) 
	{
		try {
															#line 250 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			TraceEvent(SevWarn, "S3ClientWorkloadS3CleanupError") .errorUnsuppressed(cleanup_e) .detail("S3URL", file_url);
															#line 798 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
			loopDepth = a_body1cont7Catch1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7Catch1cont3(Void const& _,int loopDepth) 
	{
															#line 247 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		TraceEvent(SevWarn, "S3ClientWorkloadCleanedS3AfterError").detail("S3URL", file_url);
															#line 813 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
		loopDepth = a_body1cont7Catch1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont7Catch1cont3(Void && _,int loopDepth) 
	{
															#line 247 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		TraceEvent(SevWarn, "S3ClientWorkloadCleanedS3AfterError").detail("S3URL", file_url);
															#line 822 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
		loopDepth = a_body1cont7Catch1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont7Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7Catch1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7Catch1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont7Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont7Catch1Catch1(error, 0);
		} catch (...) {
			a_body1cont7Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont7Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont7Catch1Catch1(error, 0);
		} catch (...) {
			a_body1cont7Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont7Catch1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont7Catch1Catch1(error, 0);
		} catch (...) {
			a_body1cont7Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont7Catch1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont7Catch1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont1(int loopDepth) 
	{
		try {
															#line 287 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			if (fileExists(download))
															#line 920 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
			{
															#line 288 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
				deleteFile(download);
															#line 289 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
				TraceEvent(SevDebug, "S3ClientWorkloadDeletedDownload").detail("File", download);
															#line 926 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont10cont10(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont10cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont10cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 282 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			TraceEvent(SevWarn, "S3ClientWorkloadCredentialsCleanupFailed").error(e).detail("File", self->credentials);
															#line 943 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
			loopDepth = a_body1cont10cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont10cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont7(int loopDepth) 
	{
		try {
															#line 297 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			platform::eraseDirectoryRecursive(uniqueRunDir);
															#line 298 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			TraceEvent(SevInfo, "S3ClientWorkloadCleanedRunDir").detail("Dir", uniqueRunDir);
															#line 974 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
			loopDepth = a_body1cont10cont13(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont10cont7Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont10cont7Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 292 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			TraceEvent(SevWarn, "S3ClientWorkloadDownloadCleanupFailed").error(e).detail("File", download);
															#line 990 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
			loopDepth = a_body1cont10cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont10cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont11(int loopDepth) 
	{
															#line 306 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 1018 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10cont7Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 300 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			TraceEvent(SevWarn, "S3ClientWorkloadRunDirCleanupFailed") .error(e) .detail("Dir", uniqueRunDir) .detail("Reason", "Non-fatal in simulation");
															#line 1031 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
			loopDepth = a_body1cont10cont11(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont13(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont10cont11(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 160 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
	S3ClientWorkload* self;
															#line 160 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
	Database cx;
															#line 174 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
	std::string download_path_to_clean;
															#line 197 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
	std::string uniqueRunDir;
															#line 211 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
	std::string download;
															#line 223 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
	std::string file_url;
															#line 224 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
	bool uploaded;
															#line 225 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
	Optional<Error> errorToThrow;
															#line 1071 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _start()
															#line 160 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, Void >, public ActorCallback< _startActor, 3, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 1076 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7453957347483757568UL, 17775626738947394816UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, Void >;
friend struct ActorCallback< _startActor, 3, Void >;
															#line 160 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
	_startActor(S3ClientWorkload* const& self,Database const& cx) 
															#line 1096 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _startActorState<_startActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 160 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
[[nodiscard]] Future<Void> _start( S3ClientWorkload* const& self, Database const& cx ) {
															#line 160 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
	return Future<Void>(new _startActor(self, cx));
															#line 1131 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
}

#line 308 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"

																#line 1136 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
// This generated class is to be used only via _setup()
															#line 309 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
template <class _setupActor>
															#line 309 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
class _setupActorState {
															#line 1142 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
public:
															#line 309 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
	_setupActorState(S3ClientWorkload* const& self,Database const& cx) 
															#line 309 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
															#line 309 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		 : self(self),
															#line 309 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		   cx(cx)
															#line 1151 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_setup", reinterpret_cast<unsigned long>(this));

	}
	~_setupActorState() 
	{
		fdb_probe_actor_destroy("_setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 312 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			if (self->clientId == 0)
															#line 1166 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
			{
															#line 314 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
				bool useMockS3 = self->s3Url.find("127.0.0.1") != std::string::npos || self->s3Url.find("localhost") != std::string::npos || self->s3Url.find("mock-s3-server") != std::string::npos;
															#line 318 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
				if (useMockS3 && g_network->isSimulated())
															#line 1172 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
				{
															#line 320 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
					std::string serverKey = "127.0.0.1:8080";
															#line 321 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
					bool alreadyRegistered = g_simulator->httpHandlers.count(serverKey) > 0;
															#line 323 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
					if (alreadyRegistered)
															#line 1180 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
					{
															#line 324 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
						TraceEvent("S3ClientWorkload") .detail("Phase", "MockS3Server Already Registered") .detail("Address", serverKey) .detail("ChaosRequested", self->enableChaos) .detail("Reason", "Reusing existing HTTP handler from previous test");
															#line 1184 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
						loopDepth = a_body1cont3(loopDepth);
					}
					else
					{
															#line 329 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
						if (self->enableChaos)
															#line 1191 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
						{
															#line 330 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
							TraceEvent("S3ClientWorkload") .detail("Phase", "Starting MockS3ServerChaos") .detail("URL", self->s3Url);
															#line 335 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
							NetworkAddress listenAddress(IPAddress(0x7f000001), 8080);
															#line 336 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
							StrictFuture<Void> __when_expr_0 = startMockS3ServerChaos(listenAddress);
															#line 336 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
							if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1201 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
							if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
							static_cast<_setupActor*>(this)->actor_wait_state = 1;
															#line 336 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
							__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 0, Void >*>(static_cast<_setupActor*>(this)));
															#line 1206 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
							loopDepth = 0;
						}
						else
						{
															#line 342 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
							TraceEvent("S3ClientWorkload") .detail("Phase", "Registering MockS3Server") .detail("URL", self->s3Url);
															#line 348 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
							StrictFuture<Void> __when_expr_1 = registerMockS3Server("127.0.0.1", "8080");
															#line 348 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
							if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1217 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
							if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
							static_cast<_setupActor*>(this)->actor_wait_state = 2;
															#line 348 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
							__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 1, Void >*>(static_cast<_setupActor*>(this)));
															#line 1222 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
							loopDepth = 0;
						}
					}
				}
				else
				{
					loopDepth = a_body1cont2(loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 359 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		if (self->enableChaos && g_network->isSimulated())
															#line 1257 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
		{
															#line 360 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			auto injector = S3FaultInjector::injector();
															#line 361 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			injector->setErrorRate(self->errorRate);
															#line 362 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			injector->setThrottleRate(self->throttleRate);
															#line 363 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			injector->setDelayRate(self->delayRate);
															#line 364 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			injector->setCorruptionRate(self->corruptionRate);
															#line 365 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			injector->setMaxDelay(self->maxDelay);
															#line 367 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			TraceEvent("S3ClientWorkload") .detail("Phase", "Chaos Configured") .detail("ClientID", self->clientId) .detail("ErrorRate", self->errorRate) .detail("ThrottleRate", self->throttleRate) .detail("DelayRate", self->delayRate) .detail("CorruptionRate", self->corruptionRate);
															#line 1273 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
		}
															#line 376 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 1277 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 338 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		TraceEvent("S3ClientWorkload") .detail("Phase", "MockS3ServerChaos Started") .detail("Address", "127.0.0.1:8080");
															#line 1307 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 338 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		TraceEvent("S3ClientWorkload") .detail("Phase", "MockS3ServerChaos Started") .detail("Address", "127.0.0.1:8080");
															#line 1316 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _setupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
															#line 350 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		TraceEvent("S3ClientWorkload") .detail("Phase", "MockS3Server Registered") .detail("Address", "127.0.0.1:8080");
															#line 1400 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
															#line 350 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		TraceEvent("S3ClientWorkload") .detail("Phase", "MockS3Server Registered") .detail("Address", "127.0.0.1:8080");
															#line 1409 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _setupActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 309 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
	S3ClientWorkload* self;
															#line 309 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
	Database cx;
															#line 1493 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _setup()
															#line 309 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
class _setupActor final : public Actor<Void>, public ActorCallback< _setupActor, 0, Void >, public ActorCallback< _setupActor, 1, Void >, public FastAllocated<_setupActor>, public _setupActorState<_setupActor> {
															#line 1498 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
public:
	using FastAllocated<_setupActor>::operator new;
	using FastAllocated<_setupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5829925852880017408UL, 1407942709822270976UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _setupActor, 0, Void >;
friend struct ActorCallback< _setupActor, 1, Void >;
															#line 309 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
	_setupActor(S3ClientWorkload* const& self,Database const& cx) 
															#line 1516 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _setupActorState<_setupActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3044502327521131520UL, 13387266639422932480UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _setupActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _setupActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 309 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
[[nodiscard]] Future<Void> _setup( S3ClientWorkload* const& self, Database const& cx ) {
															#line 309 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
	return Future<Void>(new _setupActor(self, cx));
															#line 1549 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp.py_gen"
}

#line 378 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
};

WorkloadFactory<S3ClientWorkload> S3ClientWorkloadFactory;
