#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
/*
 * RestoreCommon.actor.h
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// This file includes the code copied from the old restore in FDB 5.2
// The functions and structure declared in this file can be shared by
// the old restore and the new performant restore systems

#pragma once
#if defined(NO_INTELLISENSE) && !defined(FDBSERVER_RESTORECOMMON_ACTOR_G_H)
#define FDBSERVER_RESTORECOMMON_ACTOR_G_H
#include "fdbserver/RestoreCommon.actor.g.h"
#elif !defined(FDBSERVER_RESTORECOMMON_ACTOR_H)
#define FDBSERVER_RESTORECOMMON_ACTOR_H

#include "flow/flow.h"
#include "flow/genericactors.actor.h"
#include "fdbclient/Tuple.h"
#include "fdbclient/NativeAPI.actor.h"
#include "flow/IAsyncFile.h"
#include "fdbclient/BackupAgent.actor.h"
#include "fdbserver/Knobs.h"

#include "flow/actorcompiler.h" // has to be last include

// RestoreConfig copied from FileBackupAgent.actor.cpp
// We copy RestoreConfig instead of using (and potentially changing) it in place
// to avoid conflict with the existing code.
// We also made minor changes to allow RestoreConfig to be ReferenceCounted
// TODO: Merge this RestoreConfig with the original RestoreConfig in FileBackupAgent.actor.cpp
// For convenience
typedef FileBackupAgent::ERestoreState ERestoreState;

struct RestoreFileFR;

// We copy RestoreConfig copied from FileBackupAgent.actor.cpp instead of using (and potentially changing) it in place
// to avoid conflict with the existing code Split RestoreConfig defined in FileBackupAgent.actor.cpp to declaration in
// Restore.actor.h and implementation in RestoreCommon.actor.cpp, so that we can use in both the existing restore and
// the new fast restore subsystems. We use RestoreConfig as a Reference<RestoreConfig>, which leads to some
// non-functional changes in RestoreConfig
class RestoreConfigFR : public KeyBackedTaskConfig, public ReferenceCounted<RestoreConfigFR> {
public:
	RestoreConfigFR(UID uid = UID()) : KeyBackedTaskConfig(fileRestorePrefixRange.begin, uid) {}
	RestoreConfigFR(Reference<Task> task) : KeyBackedTaskConfig(fileRestorePrefixRange.begin, task) {}

	KeyBackedProperty<ERestoreState> stateEnum();

	Future<StringRef> stateText(Reference<ReadYourWritesTransaction> tr);

	KeyBackedProperty<Key> addPrefix();

	KeyBackedProperty<Key> removePrefix();

	// XXX: Remove restoreRange() once it is safe to remove. It has been changed to restoreRanges
	KeyBackedProperty<KeyRange> restoreRange();

	KeyBackedProperty<std::vector<KeyRange>> restoreRanges();

	KeyBackedProperty<Key> batchFuture();

	KeyBackedProperty<Version> restoreVersion();

	KeyBackedProperty<Reference<IBackupContainer>> sourceContainer();

	// Get the source container as a bare URL, without creating a container instance
	KeyBackedProperty<Value> sourceContainerURL();

	// Total bytes written by all log and range restore tasks.
	KeyBackedBinaryValue<int64_t> bytesWritten();

	// File blocks that have had tasks created for them by the Dispatch task
	KeyBackedBinaryValue<int64_t> filesBlocksDispatched();

	// File blocks whose tasks have finished
	KeyBackedBinaryValue<int64_t> fileBlocksFinished();

	// Total number of files in the fileMap
	KeyBackedBinaryValue<int64_t> fileCount();

	// Total number of file blocks in the fileMap
	KeyBackedBinaryValue<int64_t> fileBlockCount();

	Future<std::vector<KeyRange>> getRestoreRangesOrDefault(Reference<ReadYourWritesTransaction> tr);
																#line 102 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreCommon.actor.g.h.py_gen"
[[nodiscard]] static Future<std::vector<KeyRange>> getRestoreRangesOrDefault_impl( RestoreConfigFR* const& self, Reference<ReadYourWritesTransaction> const& tr );
template <class> friend class RestoreConfigFR_GetRestoreRangesOrDefault_implActorState;

#line 102 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"

	// Describes a file to load blocks from during restore.  Ordered by version and then fileName to enable
	// incrementally advancing through the map, saving the version and path of the next starting point.
	struct RestoreFile {
		Version version;
		std::string fileName;
		bool isRange; // false for log file
		int64_t blockSize;
		int64_t fileSize;
		Version endVersion; // not meaningful for range files

		Tuple pack() const {
			// fprintf(stderr, "Filename:%s\n", fileName.c_str());
			return Tuple::makeTuple(version, fileName, (int)isRange, fileSize, blockSize, endVersion);
		}
		static RestoreFile unpack(Tuple const& t) {
			RestoreFile r;
			int i = 0;
			r.version = t.getInt(i++);
			r.fileName = t.getString(i++).toString();
			r.isRange = t.getInt(i++) != 0;
			r.fileSize = t.getInt(i++);
			r.blockSize = t.getInt(i++);
			r.endVersion = t.getInt(i++);
			return r;
		}
	};

	// typedef KeyBackedSet<RestoreFile> FileSetT;
	KeyBackedSet<RestoreFile> fileSet();

	Future<bool> isRunnable(Reference<ReadYourWritesTransaction> tr);

	Future<Void> logError(Database cx, Error e, std::string const& details, void* taskInstance = nullptr);

	Key mutationLogPrefix();

	Key applyMutationsMapPrefix();

																#line 146 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreCommon.actor.g.h.py_gen"
[[nodiscard]] Future<int64_t> getApplyVersionLag_impl( Reference<ReadYourWritesTransaction> const& tr, UID const& uid );
template <class> friend class RestoreConfigFR_GetApplyVersionLag_implActorState;

#line 142 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"

	Future<int64_t> getApplyVersionLag(Reference<ReadYourWritesTransaction> tr);

	void initApplyMutations(Reference<ReadYourWritesTransaction> tr, Key addPrefix, Key removePrefix);

	void clearApplyMutationsKeys(Reference<ReadYourWritesTransaction> tr);

	void setApplyBeginVersion(Reference<ReadYourWritesTransaction> tr, Version ver);

	void setApplyEndVersion(Reference<ReadYourWritesTransaction> tr, Version ver);

	Future<Version> getApplyEndVersion(Reference<ReadYourWritesTransaction> tr);

																#line 164 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreCommon.actor.g.h.py_gen"
[[nodiscard]] static Future<std::string> getProgress_impl( Reference<RestoreConfigFR> const& restore, Reference<ReadYourWritesTransaction> const& tr );
template <class> friend class RestoreConfigFR_GetProgress_implActorState;

#line 157 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
	Future<std::string> getProgress(Reference<ReadYourWritesTransaction> tr);

																#line 171 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreCommon.actor.g.h.py_gen"
[[nodiscard]] static Future<std::string> getFullStatus_impl( Reference<RestoreConfigFR> const& restore, Reference<ReadYourWritesTransaction> const& tr );
template <class> friend class RestoreConfigFR_GetFullStatus_implActorState;

#line 161 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
	Future<std::string> getFullStatus(Reference<ReadYourWritesTransaction> tr);

	std::string toString(); // Added by Meng
};

// typedef RestoreConfigFR::RestoreFile RestoreFile;

// Describes a file to load blocks from during restore.  Ordered by version and then fileName to enable
// incrementally advancing through the map, saving the version and path of the next starting point.
// NOTE: The struct RestoreFileFR can NOT be named RestoreFile, because compiler will get confused in linking which
// RestoreFile should be used. If we use RestoreFile, compilation succeeds, but weird segmentation fault will happen.
struct RestoreFileFR {
	Version version;
	std::string fileName;
	bool isRange; // false for log file
	int64_t blockSize;
	int64_t fileSize;
	Version endVersion; // not meaningful for range files
	Version beginVersion; // range file's beginVersion == endVersion; log file contains mutations in version
	                      // [beginVersion, endVersion)
	int64_t cursor; // The start block location to be restored. All blocks before cursor have been scheduled to load and
	                // restore
	int fileIndex; // index of backup file. Must be identical per file.
	int partitionId = -1; // Partition ID (Log Router Tag ID) for mutation files.

	Tuple pack() const {
		return Tuple::makeTuple(version,
		                        fileName,
		                        (int)isRange,
		                        fileSize,
		                        blockSize,
		                        endVersion,
		                        beginVersion,
		                        cursor,
		                        fileIndex,
		                        partitionId);
	}
	static RestoreFileFR unpack(Tuple const& t) {
		RestoreFileFR r;
		int i = 0;
		r.version = t.getInt(i++);
		r.fileName = t.getString(i++).toString();
		r.isRange = t.getInt(i++) != 0;
		r.fileSize = t.getInt(i++);
		r.blockSize = t.getInt(i++);
		r.endVersion = t.getInt(i++);
		r.beginVersion = t.getInt(i++);
		r.cursor = t.getInt(i++);
		r.fileIndex = t.getInt(i++);
		r.partitionId = t.getInt(i++);
		return r;
	}

	bool operator<(const RestoreFileFR& rhs) const {
		return std::tie(beginVersion, endVersion, fileIndex, fileName) <
		       std::tie(rhs.beginVersion, rhs.endVersion, rhs.fileIndex, rhs.fileName);
	}

	RestoreFileFR()
	  : version(invalidVersion), isRange(false), blockSize(0), fileSize(0), endVersion(invalidVersion),
	    beginVersion(invalidVersion), cursor(0), fileIndex(0) {}

	explicit RestoreFileFR(const RangeFile& f)
	  : version(f.version), fileName(f.fileName), isRange(true), blockSize(f.blockSize), fileSize(f.fileSize),
	    endVersion(f.version), beginVersion(f.version), cursor(0), fileIndex(0) {}

	explicit RestoreFileFR(const LogFile& f)
	  : version(f.beginVersion), fileName(f.fileName), isRange(false), blockSize(f.blockSize), fileSize(f.fileSize),
	    endVersion(f.endVersion), beginVersion(f.beginVersion), cursor(0), fileIndex(0), partitionId(f.tagId) {}

	std::string toString() const {
		std::stringstream ss;
		ss << "version:" << version << " fileName:" << fileName << " isRange:" << isRange << " blockSize:" << blockSize
		   << " fileSize:" << fileSize << " endVersion:" << endVersion << " beginVersion:" << beginVersion
		   << " cursor:" << cursor << " fileIndex:" << fileIndex << " partitionId:" << partitionId;
		return ss.str();
	}
};

namespace parallelFileRestore {
															#line 256 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreCommon.actor.g.h.py_gen"
[[nodiscard]] Future<Standalone<VectorRef<KeyValueRef>>> decodeLogFileBlock( Reference<IAsyncFile> const& file, int64_t const& offset, int const& len );

#line 244 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
} // namespace parallelFileRestore

// Send each request in requests via channel of the request's interface.
// Save replies to replies if replies != nullptr
// The UID in a request is the UID of the interface to handle the request
															#line 265 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreCommon.actor.g.h.py_gen"
namespace {
// This generated class is to be used only via getBatchReplies()
															#line 249 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
template <class Interface, class Request, class GetBatchRepliesActor>
															#line 249 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
class GetBatchRepliesActorState {
															#line 272 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreCommon.actor.g.h.py_gen"
public:
															#line 249 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
	GetBatchRepliesActorState(RequestStream<Request> Interface::* const& channel,std::map<UID, Interface> const& interfaces,std::vector<std::pair<UID, Request>> const& requests,std::vector<REPLY_TYPE(Request)>* const& replies,TaskPriority const& taskID = TaskPriority::Low,bool const& trackRequestLatency = true) 
															#line 249 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
															#line 249 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
		 : channel(channel),
															#line 249 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
		   interfaces(interfaces),
															#line 249 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
		   requests(requests),
															#line 249 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
		   replies(replies),
															#line 249 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
		   taskID(taskID),
															#line 249 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
		   trackRequestLatency(trackRequestLatency)
															#line 289 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreCommon.actor.g.h.py_gen"
	{
		fdb_probe_actor_create("getBatchReplies", reinterpret_cast<unsigned long>(this));

	}
	~GetBatchRepliesActorState() 
	{
		fdb_probe_actor_destroy("getBatchReplies", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 256 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
			if (requests.empty())
															#line 304 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreCommon.actor.g.h.py_gen"
			{
															#line 257 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
				if (!static_cast<GetBatchRepliesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetBatchRepliesActorState(); static_cast<GetBatchRepliesActor*>(this)->destroy(); return 0; }
															#line 308 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreCommon.actor.g.h.py_gen"
				new (&static_cast<GetBatchRepliesActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~GetBatchRepliesActorState();
				static_cast<GetBatchRepliesActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 260 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
			start = now();
															#line 261 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
			oustandingReplies = requests.size();
															#line 262 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
			;
															#line 320 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreCommon.actor.g.h.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetBatchRepliesActorState();
		static_cast<GetBatchRepliesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 375 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
		if (!static_cast<GetBatchRepliesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetBatchRepliesActorState(); static_cast<GetBatchRepliesActor*>(this)->destroy(); return 0; }
															#line 343 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreCommon.actor.g.h.py_gen"
		new (&static_cast<GetBatchRepliesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetBatchRepliesActorState();
		static_cast<GetBatchRepliesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 264 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
			cmdReplies = std::vector<Future<REPLY_TYPE(Request)>>();
															#line 265 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
			replyDurations = std::vector<std::tuple<UID, Request, double>>();
															#line 266 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
			for( auto& request : requests ) {
															#line 267 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
				RequestStream<Request> const* stream = &(interfaces[request.first].*channel);
															#line 268 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
				cmdReplies.push_back(stream->getReply(request.second, taskID));
															#line 269 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
				replyDurations.emplace_back(request.first, request.second, 0);
															#line 373 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreCommon.actor.g.h.py_gen"
			}
															#line 272 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
			ongoingReplies = std::vector<Future<REPLY_TYPE(Request)>>();
															#line 273 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
			ongoingRepliesIndex = std::vector<int>();
															#line 274 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
			;
															#line 381 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreCommon.actor.g.h.py_gen"
			loopDepth = a_body1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 361 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
			if (e.code() == error_code_operation_cancelled)
															#line 416 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreCommon.actor.g.h.py_gen"
			{
				return a_body1break1(loopDepth==0?0:loopDepth-1); // break
			}
															#line 364 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
			TraceEvent(SevWarn, "FastRestoreSendBatchRequests").error(e);
															#line 365 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
			for( auto& request : requests ) {
															#line 366 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
				TraceEvent(SevWarn, "FastRestoreSendBatchRequests") .detail("SendBatchRequests", requests.size()) .detail("RequestID", request.first) .detail("Request", request.second.toString());
															#line 370 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
				resetReply(request.second);
															#line 428 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreCommon.actor.g.h.py_gen"
			}
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 316 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
		ASSERT(oustandingReplies == 0);
															#line 317 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
		if (trackRequestLatency && SERVER_KNOBS->FASTRESTORE_TRACK_REQUEST_LATENCY)
															#line 446 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreCommon.actor.g.h.py_gen"
		{
															#line 319 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
			std::map<UID, double> maxEndTime;
															#line 320 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
			UID bathcID = deterministicRandom()->randomUniqueID();
															#line 321 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
			for(int i = 0;i < replyDurations.size();++i) {
															#line 322 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
				double endTime = std::get<2>(replyDurations[i]);
															#line 323 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
				TraceEvent(SevInfo, "ProfileSendRequestBatchLatency", bathcID) .detail("Node", std::get<0>(replyDurations[i])) .detail("Request", std::get<1>(replyDurations[i]).toString()) .detail("Duration", endTime - start);
															#line 327 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
				auto item = maxEndTime.emplace(std::get<0>(replyDurations[i]), endTime);
															#line 328 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
				item.first->second = std::max(item.first->second, endTime);
															#line 462 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreCommon.actor.g.h.py_gen"
			}
															#line 331 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
			double earliest = std::numeric_limits<double>::max();
															#line 332 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
			double latest = std::numeric_limits<double>::min();
															#line 333 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
			UID earliestNode, latestNode;
															#line 335 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
			for( auto& endTime : maxEndTime ) {
															#line 336 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
				if (earliest > endTime.second)
															#line 474 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreCommon.actor.g.h.py_gen"
				{
															#line 337 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
					earliest = endTime.second;
															#line 338 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
					earliestNode = endTime.first;
															#line 480 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreCommon.actor.g.h.py_gen"
				}
															#line 340 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
				if (latest < endTime.second)
															#line 484 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreCommon.actor.g.h.py_gen"
				{
															#line 341 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
					latest = endTime.second;
															#line 342 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
					latestNode = endTime.first;
															#line 490 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreCommon.actor.g.h.py_gen"
				}
			}
															#line 345 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
			if (latest - earliest > SERVER_KNOBS->FASTRESTORE_STRAGGLER_THRESHOLD_SECONDS)
															#line 495 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreCommon.actor.g.h.py_gen"
			{
															#line 346 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
				TraceEvent(SevWarn, "ProfileSendRequestBatchLatencyFoundStraggler", bathcID) .detail("SlowestNode", latestNode) .detail("FatestNode", earliestNode) .detail("EarliestEndtime", earliest) .detail("LagTime", latest - earliest);
															#line 499 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreCommon.actor.g.h.py_gen"
			}
		}
															#line 354 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
		if (replies != nullptr)
															#line 504 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreCommon.actor.g.h.py_gen"
		{
															#line 355 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
			for(int i = 0;i < cmdReplies.size();++i) {
															#line 356 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
				replies->emplace_back(cmdReplies[i].get());
															#line 510 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreCommon.actor.g.h.py_gen"
			}
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 275 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
		ongoingReplies.clear();
															#line 276 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
		ongoingRepliesIndex.clear();
															#line 277 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
		for(int i = 0;i < cmdReplies.size();++i) {
															#line 278 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
			if (SERVER_KNOBS->FASTRESTORE_REQBATCH_LOG)
															#line 534 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreCommon.actor.g.h.py_gen"
			{
															#line 279 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
				TraceEvent(SevInfo, "FastRestoreGetBatchReplies") .suppressFor(1.0) .detail("Requests", requests.size()) .detail("OutstandingReplies", oustandingReplies) .detail("ReplyIndex", i) .detail("ReplyIsReady", cmdReplies[i].isReady()) .detail("ReplyIsError", cmdReplies[i].isError()) .detail("RequestNode", requests[i].first) .detail("Request", requests[i].second.toString());
															#line 538 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreCommon.actor.g.h.py_gen"
			}
															#line 289 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
			if (!cmdReplies[i].isReady())
															#line 542 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreCommon.actor.g.h.py_gen"
			{
															#line 290 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
				ongoingReplies.push_back(cmdReplies[i]);
															#line 291 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
				ongoingRepliesIndex.push_back(i);
															#line 548 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreCommon.actor.g.h.py_gen"
			}
		}
															#line 294 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
		ASSERT(ongoingReplies.size() == oustandingReplies);
															#line 295 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
		if (ongoingReplies.empty())
															#line 555 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreCommon.actor.g.h.py_gen"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
		else
		{
															#line 298 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
			StrictFuture<Void> __when_expr_0 = quorum(ongoingReplies, std::min((int)SERVER_KNOBS->FASTRESTORE_REQBATCH_PARALLEL, (int)ongoingReplies.size()));
															#line 298 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
			if (static_cast<GetBatchRepliesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 565 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreCommon.actor.g.h.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetBatchRepliesActor*>(this)->actor_wait_state = 1;
															#line 298 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetBatchRepliesActor, 0, Void >*>(static_cast<GetBatchRepliesActor*>(this)));
															#line 570 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreCommon.actor.g.h.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
															#line 303 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
		for(int j = 0;j < ongoingReplies.size();++j) {
															#line 304 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
			if (ongoingReplies[j].isReady())
															#line 595 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreCommon.actor.g.h.py_gen"
			{
															#line 305 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
				std::get<2>(replyDurations[ongoingRepliesIndex[j]]) = now();
															#line 306 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
				--oustandingReplies;
															#line 601 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreCommon.actor.g.h.py_gen"
			}
			else
			{
															#line 307 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
				if (ongoingReplies[j].isError())
															#line 607 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreCommon.actor.g.h.py_gen"
				{
															#line 310 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
					TraceEvent(SevError, "FastRestoreGetBatchRepliesReplyError") .detail("OngoingReplyIndex", j) .detail("FutureError", ongoingReplies[j].getError().what());
															#line 611 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreCommon.actor.g.h.py_gen"
				}
			}
		}
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetBatchRepliesActor*>(this)->actor_wait_state > 0) static_cast<GetBatchRepliesActor*>(this)->actor_wait_state = 0;
		static_cast<GetBatchRepliesActor*>(this)->ActorCallback< GetBatchRepliesActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetBatchRepliesActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getBatchReplies", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBatchRepliesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBatchReplies", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetBatchRepliesActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getBatchReplies", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBatchRepliesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBatchReplies", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetBatchRepliesActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getBatchReplies", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetBatchRepliesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBatchReplies", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 249 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
	RequestStream<Request> Interface::* channel;
															#line 249 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
	std::map<UID, Interface> interfaces;
															#line 249 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
	std::vector<std::pair<UID, Request>> requests;
															#line 249 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
	std::vector<REPLY_TYPE(Request)>* replies;
															#line 249 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
	TaskPriority taskID;
															#line 249 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
	bool trackRequestLatency;
															#line 260 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
	double start;
															#line 261 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
	int oustandingReplies;
															#line 264 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
	std::vector<Future<REPLY_TYPE(Request)>> cmdReplies;
															#line 265 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
	std::vector<std::tuple<UID, Request, double>> replyDurations;
															#line 272 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
	std::vector<Future<REPLY_TYPE(Request)>> ongoingReplies;
															#line 273 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
	std::vector<int> ongoingRepliesIndex;
															#line 730 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreCommon.actor.g.h.py_gen"
};
// This generated class is to be used only via getBatchReplies()
															#line 249 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
template <class Interface, class Request>
															#line 249 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
class GetBatchRepliesActor final : public Actor<Void>, public ActorCallback< GetBatchRepliesActor<Interface, Request>, 0, Void >, public FastAllocated<GetBatchRepliesActor<Interface, Request>>, public GetBatchRepliesActorState<Interface, Request, GetBatchRepliesActor<Interface, Request>> {
															#line 737 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreCommon.actor.g.h.py_gen"
public:
	using FastAllocated<GetBatchRepliesActor<Interface, Request>>::operator new;
	using FastAllocated<GetBatchRepliesActor<Interface, Request>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18198296257831745024UL, 8447274576575831296UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetBatchRepliesActor<Interface, Request>, 0, Void >;
															#line 249 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
	GetBatchRepliesActor(RequestStream<Request> Interface::* const& channel,std::map<UID, Interface> const& interfaces,std::vector<std::pair<UID, Request>> const& requests,std::vector<REPLY_TYPE(Request)>* const& replies,TaskPriority const& taskID = TaskPriority::Low,bool const& trackRequestLatency = true) 
															#line 754 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreCommon.actor.g.h.py_gen"
		 : Actor<Void>(),
		   GetBatchRepliesActorState<Interface, Request, GetBatchRepliesActor<Interface, Request>>(channel, interfaces, requests, replies, taskID, trackRequestLatency),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getBatchReplies", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11133916450650825728UL, 12557723596887386880UL);
		ActorExecutionContextHelper __helper(static_cast<GetBatchRepliesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getBatchReplies");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getBatchReplies", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetBatchRepliesActor<Interface, Request>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 249 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
template <class Interface, class Request>
															#line 249 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
[[nodiscard]] Future<Void> getBatchReplies( RequestStream<Request> Interface::* const& channel, std::map<UID, Interface> const& interfaces, std::vector<std::pair<UID, Request>> const& requests, std::vector<REPLY_TYPE(Request)>* const& replies, TaskPriority const& taskID = TaskPriority::Low, bool const& trackRequestLatency = true ) {
															#line 249 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
	return Future<Void>(new GetBatchRepliesActor<Interface, Request>(channel, interfaces, requests, replies, taskID, trackRequestLatency));
															#line 789 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreCommon.actor.g.h.py_gen"
}

#line 377 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"

// Similar to getBatchReplies except that the caller does not expect to process the reply info.
															#line 795 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreCommon.actor.g.h.py_gen"
namespace {
// This generated class is to be used only via sendBatchRequests()
															#line 379 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
template <class Interface, class Request, class SendBatchRequestsActor>
															#line 379 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
class SendBatchRequestsActorState {
															#line 802 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreCommon.actor.g.h.py_gen"
public:
															#line 379 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
	SendBatchRequestsActorState(RequestStream<Request> Interface::* const& channel,std::map<UID, Interface> const& interfaces,std::vector<std::pair<UID, Request>> const& requests,TaskPriority const& taskID = TaskPriority::Low,bool const& trackRequestLatency = true) 
															#line 379 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
															#line 379 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
		 : channel(channel),
															#line 379 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
		   interfaces(interfaces),
															#line 379 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
		   requests(requests),
															#line 379 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
		   taskID(taskID),
															#line 379 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
		   trackRequestLatency(trackRequestLatency)
															#line 817 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreCommon.actor.g.h.py_gen"
	{
		fdb_probe_actor_create("sendBatchRequests", reinterpret_cast<unsigned long>(this));

	}
	~SendBatchRequestsActorState() 
	{
		fdb_probe_actor_destroy("sendBatchRequests", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 385 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
			StrictFuture<Void> __when_expr_0 = getBatchReplies(channel, interfaces, requests, nullptr, taskID, trackRequestLatency);
															#line 385 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
			if (static_cast<SendBatchRequestsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 834 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreCommon.actor.g.h.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SendBatchRequestsActor*>(this)->actor_wait_state = 1;
															#line 385 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SendBatchRequestsActor, 0, Void >*>(static_cast<SendBatchRequestsActor*>(this)));
															#line 839 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreCommon.actor.g.h.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SendBatchRequestsActorState();
		static_cast<SendBatchRequestsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 387 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
		if (!static_cast<SendBatchRequestsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SendBatchRequestsActorState(); static_cast<SendBatchRequestsActor*>(this)->destroy(); return 0; }
															#line 862 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreCommon.actor.g.h.py_gen"
		new (&static_cast<SendBatchRequestsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SendBatchRequestsActorState();
		static_cast<SendBatchRequestsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 387 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
		if (!static_cast<SendBatchRequestsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SendBatchRequestsActorState(); static_cast<SendBatchRequestsActor*>(this)->destroy(); return 0; }
															#line 874 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreCommon.actor.g.h.py_gen"
		new (&static_cast<SendBatchRequestsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SendBatchRequestsActorState();
		static_cast<SendBatchRequestsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SendBatchRequestsActor*>(this)->actor_wait_state > 0) static_cast<SendBatchRequestsActor*>(this)->actor_wait_state = 0;
		static_cast<SendBatchRequestsActor*>(this)->ActorCallback< SendBatchRequestsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SendBatchRequestsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("sendBatchRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SendBatchRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendBatchRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SendBatchRequestsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("sendBatchRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SendBatchRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendBatchRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SendBatchRequestsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("sendBatchRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SendBatchRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendBatchRequests", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 379 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
	RequestStream<Request> Interface::* channel;
															#line 379 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
	std::map<UID, Interface> interfaces;
															#line 379 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
	std::vector<std::pair<UID, Request>> requests;
															#line 379 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
	TaskPriority taskID;
															#line 379 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
	bool trackRequestLatency;
															#line 967 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreCommon.actor.g.h.py_gen"
};
// This generated class is to be used only via sendBatchRequests()
															#line 379 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
template <class Interface, class Request>
															#line 379 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
class SendBatchRequestsActor final : public Actor<Void>, public ActorCallback< SendBatchRequestsActor<Interface, Request>, 0, Void >, public FastAllocated<SendBatchRequestsActor<Interface, Request>>, public SendBatchRequestsActorState<Interface, Request, SendBatchRequestsActor<Interface, Request>> {
															#line 974 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreCommon.actor.g.h.py_gen"
public:
	using FastAllocated<SendBatchRequestsActor<Interface, Request>>::operator new;
	using FastAllocated<SendBatchRequestsActor<Interface, Request>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12892705043610530048UL, 8038114614605273856UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SendBatchRequestsActor<Interface, Request>, 0, Void >;
															#line 379 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
	SendBatchRequestsActor(RequestStream<Request> Interface::* const& channel,std::map<UID, Interface> const& interfaces,std::vector<std::pair<UID, Request>> const& requests,TaskPriority const& taskID = TaskPriority::Low,bool const& trackRequestLatency = true) 
															#line 991 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreCommon.actor.g.h.py_gen"
		 : Actor<Void>(),
		   SendBatchRequestsActorState<Interface, Request, SendBatchRequestsActor<Interface, Request>>(channel, interfaces, requests, taskID, trackRequestLatency),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("sendBatchRequests", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6305790459860192256UL, 2430421386439006464UL);
		ActorExecutionContextHelper __helper(static_cast<SendBatchRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("sendBatchRequests");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("sendBatchRequests", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SendBatchRequestsActor<Interface, Request>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 379 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
template <class Interface, class Request>
															#line 379 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
[[nodiscard]] Future<Void> sendBatchRequests( RequestStream<Request> Interface::* const& channel, std::map<UID, Interface> const& interfaces, std::vector<std::pair<UID, Request>> const& requests, TaskPriority const& taskID = TaskPriority::Low, bool const& trackRequestLatency = true ) {
															#line 379 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"
	return Future<Void>(new SendBatchRequestsActor<Interface, Request>(channel, interfaces, requests, taskID, trackRequestLatency));
															#line 1026 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreCommon.actor.g.h.py_gen"
}

#line 389 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreCommon.actor.h"

#include "flow/unactorcompiler.h"
#endif // FDBSERVER_RESTORECOMMON_ACTOR_H
