#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
/*
 * TagThrottler.h
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 *
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbserver/TagThrottler.h"
#include "fdbserver/RkTagThrottleCollection.h"
#include "flow/actorcompiler.h" // must be last include

class TagThrottlerImpl {
	Database db;
	UID id;
	RkTagThrottleCollection throttledTags;
	uint64_t throttledTagChangeId{ 0 };
	bool autoThrottlingEnabled{ false };
	Future<Void> expiredTagThrottleCleanup;

																#line 36 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
// This generated class is to be used only via monitorThrottlingChanges()
															#line 34 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
template <class MonitorThrottlingChangesActor>
															#line 34 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
class MonitorThrottlingChangesActorState {
															#line 42 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
public:
															#line 34 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
	MonitorThrottlingChangesActorState(TagThrottlerImpl* const& self) 
															#line 34 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
															#line 34 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
		 : self(self),
															#line 35 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
		   committed(false)
															#line 51 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("monitorThrottlingChanges", reinterpret_cast<unsigned long>(this));

	}
	~MonitorThrottlingChangesActorState() 
	{
		fdb_probe_actor_destroy("monitorThrottlingChanges", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 36 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
			;
															#line 66 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorThrottlingChangesActorState();
		static_cast<MonitorThrottlingChangesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 37 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
		tr = ReadYourWritesTransaction(self->db);
															#line 39 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
		;
															#line 98 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 41 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 42 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 44 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
			throttledTagKeys = tr.getRange(tagThrottleKeys, CLIENT_KNOBS->TOO_MANY);
															#line 45 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
			autoThrottlingEnabled = tr.get(tagThrottleAutoEnabledKey);
															#line 47 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
			if (!committed)
															#line 129 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
			{
															#line 48 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
				BinaryWriter limitWriter(Unversioned());
															#line 49 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
				limitWriter << SERVER_KNOBS->MAX_MANUAL_THROTTLED_TRANSACTION_TAGS;
															#line 50 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
				tr.set(tagThrottleLimitKey, limitWriter.toValue());
															#line 137 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
			}
															#line 53 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(throttledTagKeys) && success(autoThrottlingEnabled);
															#line 53 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
			if (static_cast<MonitorThrottlingChangesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 143 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MonitorThrottlingChangesActor*>(this)->actor_wait_state = 1;
															#line 53 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorThrottlingChangesActor, 0, Void >*>(static_cast<MonitorThrottlingChangesActor*>(this)));
															#line 148 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 131 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
			TraceEvent("RatekeeperMonitorThrottlingChangesError", self->id).error(e);
															#line 132 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 132 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
			if (static_cast<MonitorThrottlingChangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 187 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<MonitorThrottlingChangesActor*>(this)->actor_wait_state = 4;
															#line 132 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorThrottlingChangesActor, 3, Void >*>(static_cast<MonitorThrottlingChangesActor*>(this)));
															#line 192 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 55 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
		if (autoThrottlingEnabled.get().present() && autoThrottlingEnabled.get().get() == "0"_sr)
															#line 207 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
		{
															#line 56 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
			CODE_PROBE(true, "Auto-throttling disabled");
															#line 57 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
			if (self->autoThrottlingEnabled)
															#line 213 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
			{
															#line 58 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
				TraceEvent("AutoTagThrottlingDisabled", self->id).log();
															#line 217 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
			}
															#line 60 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
			self->autoThrottlingEnabled = false;
															#line 221 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
		}
		else
		{
															#line 61 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
			if (autoThrottlingEnabled.get().present() && autoThrottlingEnabled.get().get() == "1"_sr)
															#line 227 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
			{
															#line 62 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
				CODE_PROBE(true, "Auto-throttling enabled");
															#line 63 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
				if (!self->autoThrottlingEnabled)
															#line 233 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
				{
															#line 64 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
					TraceEvent("AutoTagThrottlingEnabled", self->id).log();
															#line 237 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
				}
															#line 66 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
				self->autoThrottlingEnabled = true;
															#line 241 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
			}
			else
			{
															#line 68 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
				CODE_PROBE(true, "Auto-throttling unspecified");
															#line 69 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
				if (autoThrottlingEnabled.get().present())
															#line 249 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
				{
															#line 70 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
					TraceEvent(SevWarnAlways, "InvalidAutoTagThrottlingValue", self->id) .detail("Value", autoThrottlingEnabled.get().get());
															#line 253 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
				}
															#line 73 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
				self->autoThrottlingEnabled = SERVER_KNOBS->AUTO_TAG_THROTTLING_ENABLED;
															#line 74 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
				if (!committed)
															#line 259 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
				{
															#line 75 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
					tr.set(tagThrottleAutoEnabledKey, self->autoThrottlingEnabled ? "1"_sr : "0"_sr);
															#line 263 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
				}
			}
		}
															#line 78 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
		RkTagThrottleCollection updatedTagThrottles;
															#line 80 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
		TraceEvent("RatekeeperReadThrottledTags", self->id) .detail("NumThrottledTags", throttledTagKeys.get().size());
															#line 82 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
		for( auto entry : throttledTagKeys.get() ) {
															#line 83 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
			TagThrottleKey tagKey = TagThrottleKey::fromKey(entry.key);
															#line 84 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
			TagThrottleValue tagValue = TagThrottleValue::fromValue(entry.value);
															#line 86 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
			ASSERT(tagKey.tags.size() == 1);
															#line 88 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
			if (tagValue.expirationTime == 0 || tagValue.expirationTime > now() + tagValue.initialDuration)
															#line 281 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
			{
															#line 90 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
				CODE_PROBE(true, "Converting tag throttle duration to absolute time");
															#line 91 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
				tagValue.expirationTime = now() + tagValue.initialDuration;
															#line 92 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
				BinaryWriter wr(IncludeVersion(ProtocolVersion::withTagThrottleValueReason()));
															#line 93 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
				wr << tagValue;
															#line 94 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
				value = wr.toValue();
															#line 96 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
				tr.set(entry.key, value);
															#line 295 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
			}
															#line 99 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
			if (tagValue.expirationTime > now())
															#line 299 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
			{
															#line 100 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
				TransactionTag tag = *tagKey.tags.begin();
															#line 101 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
				Optional<ClientTagThrottleLimits> oldLimits = self->throttledTags.getManualTagThrottleLimits(tag, tagKey.priority);
															#line 104 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
				if (tagKey.throttleType == TagThrottleType::AUTO)
															#line 307 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
				{
															#line 105 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
					updatedTagThrottles.autoThrottleTag( self->id, tag, 0, tagValue.tpsRate, tagValue.expirationTime);
															#line 107 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
					updatedTagThrottles.incrementBusyTagCount(tagValue.reason);
															#line 313 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
				}
				else
				{
															#line 109 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
					updatedTagThrottles.manualThrottleTag(self->id, tag, tagKey.priority, tagValue.tpsRate, tagValue.expirationTime, oldLimits);
															#line 319 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
				}
			}
		}
															#line 119 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
		self->throttledTags = std::move(updatedTagThrottles);
															#line 120 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
		++self->throttledTagChangeId;
															#line 122 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
		watchFuture = tr.watch(tagThrottleSignalKey);
															#line 123 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 123 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
		if (static_cast<MonitorThrottlingChangesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 333 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorThrottlingChangesActor*>(this)->actor_wait_state = 2;
															#line 123 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorThrottlingChangesActor, 1, Void >*>(static_cast<MonitorThrottlingChangesActor*>(this)));
															#line 338 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 55 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
		if (autoThrottlingEnabled.get().present() && autoThrottlingEnabled.get().get() == "0"_sr)
															#line 347 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
		{
															#line 56 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
			CODE_PROBE(true, "Auto-throttling disabled");
															#line 57 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
			if (self->autoThrottlingEnabled)
															#line 353 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
			{
															#line 58 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
				TraceEvent("AutoTagThrottlingDisabled", self->id).log();
															#line 357 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
			}
															#line 60 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
			self->autoThrottlingEnabled = false;
															#line 361 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
		}
		else
		{
															#line 61 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
			if (autoThrottlingEnabled.get().present() && autoThrottlingEnabled.get().get() == "1"_sr)
															#line 367 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
			{
															#line 62 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
				CODE_PROBE(true, "Auto-throttling enabled");
															#line 63 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
				if (!self->autoThrottlingEnabled)
															#line 373 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
				{
															#line 64 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
					TraceEvent("AutoTagThrottlingEnabled", self->id).log();
															#line 377 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
				}
															#line 66 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
				self->autoThrottlingEnabled = true;
															#line 381 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
			}
			else
			{
															#line 68 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
				CODE_PROBE(true, "Auto-throttling unspecified");
															#line 69 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
				if (autoThrottlingEnabled.get().present())
															#line 389 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
				{
															#line 70 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
					TraceEvent(SevWarnAlways, "InvalidAutoTagThrottlingValue", self->id) .detail("Value", autoThrottlingEnabled.get().get());
															#line 393 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
				}
															#line 73 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
				self->autoThrottlingEnabled = SERVER_KNOBS->AUTO_TAG_THROTTLING_ENABLED;
															#line 74 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
				if (!committed)
															#line 399 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
				{
															#line 75 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
					tr.set(tagThrottleAutoEnabledKey, self->autoThrottlingEnabled ? "1"_sr : "0"_sr);
															#line 403 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
				}
			}
		}
															#line 78 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
		RkTagThrottleCollection updatedTagThrottles;
															#line 80 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
		TraceEvent("RatekeeperReadThrottledTags", self->id) .detail("NumThrottledTags", throttledTagKeys.get().size());
															#line 82 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
		for( auto entry : throttledTagKeys.get() ) {
															#line 83 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
			TagThrottleKey tagKey = TagThrottleKey::fromKey(entry.key);
															#line 84 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
			TagThrottleValue tagValue = TagThrottleValue::fromValue(entry.value);
															#line 86 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
			ASSERT(tagKey.tags.size() == 1);
															#line 88 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
			if (tagValue.expirationTime == 0 || tagValue.expirationTime > now() + tagValue.initialDuration)
															#line 421 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
			{
															#line 90 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
				CODE_PROBE(true, "Converting tag throttle duration to absolute time");
															#line 91 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
				tagValue.expirationTime = now() + tagValue.initialDuration;
															#line 92 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
				BinaryWriter wr(IncludeVersion(ProtocolVersion::withTagThrottleValueReason()));
															#line 93 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
				wr << tagValue;
															#line 94 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
				value = wr.toValue();
															#line 96 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
				tr.set(entry.key, value);
															#line 435 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
			}
															#line 99 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
			if (tagValue.expirationTime > now())
															#line 439 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
			{
															#line 100 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
				TransactionTag tag = *tagKey.tags.begin();
															#line 101 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
				Optional<ClientTagThrottleLimits> oldLimits = self->throttledTags.getManualTagThrottleLimits(tag, tagKey.priority);
															#line 104 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
				if (tagKey.throttleType == TagThrottleType::AUTO)
															#line 447 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
				{
															#line 105 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
					updatedTagThrottles.autoThrottleTag( self->id, tag, 0, tagValue.tpsRate, tagValue.expirationTime);
															#line 107 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
					updatedTagThrottles.incrementBusyTagCount(tagValue.reason);
															#line 453 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
				}
				else
				{
															#line 109 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
					updatedTagThrottles.manualThrottleTag(self->id, tag, tagKey.priority, tagValue.tpsRate, tagValue.expirationTime, oldLimits);
															#line 459 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
				}
			}
		}
															#line 119 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
		self->throttledTags = std::move(updatedTagThrottles);
															#line 120 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
		++self->throttledTagChangeId;
															#line 122 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
		watchFuture = tr.watch(tagThrottleSignalKey);
															#line 123 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 123 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
		if (static_cast<MonitorThrottlingChangesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 473 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorThrottlingChangesActor*>(this)->actor_wait_state = 2;
															#line 123 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorThrottlingChangesActor, 1, Void >*>(static_cast<MonitorThrottlingChangesActor*>(this)));
															#line 478 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorThrottlingChangesActor*>(this)->actor_wait_state > 0) static_cast<MonitorThrottlingChangesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorThrottlingChangesActor*>(this)->ActorCallback< MonitorThrottlingChangesActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorThrottlingChangesActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorThrottlingChanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorThrottlingChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorThrottlingChanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorThrottlingChangesActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorThrottlingChanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorThrottlingChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorThrottlingChanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorThrottlingChangesActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorThrottlingChanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorThrottlingChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorThrottlingChanges", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 124 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
		committed = true;
															#line 126 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
		StrictFuture<Void> __when_expr_2 = watchFuture;
															#line 126 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
		if (static_cast<MonitorThrottlingChangesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 566 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1loopBody1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorThrottlingChangesActor*>(this)->actor_wait_state = 3;
															#line 126 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorThrottlingChangesActor, 2, Void >*>(static_cast<MonitorThrottlingChangesActor*>(this)));
															#line 571 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 124 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
		committed = true;
															#line 126 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
		StrictFuture<Void> __when_expr_2 = watchFuture;
															#line 126 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
		if (static_cast<MonitorThrottlingChangesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 584 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1loopBody1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorThrottlingChangesActor*>(this)->actor_wait_state = 3;
															#line 126 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorThrottlingChangesActor, 2, Void >*>(static_cast<MonitorThrottlingChangesActor*>(this)));
															#line 589 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorThrottlingChangesActor*>(this)->actor_wait_state > 0) static_cast<MonitorThrottlingChangesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorThrottlingChangesActor*>(this)->ActorCallback< MonitorThrottlingChangesActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorThrottlingChangesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorThrottlingChanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorThrottlingChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorThrottlingChanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorThrottlingChangesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorThrottlingChanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorThrottlingChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorThrottlingChanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorThrottlingChangesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorThrottlingChanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorThrottlingChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorThrottlingChanges", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1loopBody1cont18(Void const& _,int loopDepth) 
	{
															#line 127 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
		TraceEvent("RatekeeperThrottleSignaled", self->id).log();
															#line 128 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
		CODE_PROBE(true, "Tag throttle changes detected");
															#line 675 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont18(Void && _,int loopDepth) 
	{
															#line 127 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
		TraceEvent("RatekeeperThrottleSignaled", self->id).log();
															#line 128 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
		CODE_PROBE(true, "Tag throttle changes detected");
															#line 686 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont18(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont18(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MonitorThrottlingChangesActor*>(this)->actor_wait_state > 0) static_cast<MonitorThrottlingChangesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorThrottlingChangesActor*>(this)->ActorCallback< MonitorThrottlingChangesActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorThrottlingChangesActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorThrottlingChanges", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorThrottlingChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorThrottlingChanges", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorThrottlingChangesActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorThrottlingChanges", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorThrottlingChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorThrottlingChanges", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorThrottlingChangesActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorThrottlingChanges", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorThrottlingChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorThrottlingChanges", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<MonitorThrottlingChangesActor*>(this)->actor_wait_state > 0) static_cast<MonitorThrottlingChangesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorThrottlingChangesActor*>(this)->ActorCallback< MonitorThrottlingChangesActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorThrottlingChangesActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorThrottlingChanges", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorThrottlingChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorThrottlingChanges", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MonitorThrottlingChangesActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorThrottlingChanges", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorThrottlingChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorThrottlingChanges", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MonitorThrottlingChangesActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorThrottlingChanges", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorThrottlingChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorThrottlingChanges", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 34 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
	TagThrottlerImpl* self;
															#line 35 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
	bool committed;
															#line 37 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 44 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
	Future<RangeResult> throttledTagKeys;
															#line 45 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
	Future<Optional<Value>> autoThrottlingEnabled;
															#line 94 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
	Value value;
															#line 122 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
	Future<Void> watchFuture;
															#line 867 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
};
// This generated class is to be used only via monitorThrottlingChanges()
															#line 34 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
class MonitorThrottlingChangesActor final : public Actor<Void>, public ActorCallback< MonitorThrottlingChangesActor, 0, Void >, public ActorCallback< MonitorThrottlingChangesActor, 1, Void >, public ActorCallback< MonitorThrottlingChangesActor, 2, Void >, public ActorCallback< MonitorThrottlingChangesActor, 3, Void >, public FastAllocated<MonitorThrottlingChangesActor>, public MonitorThrottlingChangesActorState<MonitorThrottlingChangesActor> {
															#line 872 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
public:
	using FastAllocated<MonitorThrottlingChangesActor>::operator new;
	using FastAllocated<MonitorThrottlingChangesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6575283550644814592UL, 6934174184362956800UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorThrottlingChangesActor, 0, Void >;
friend struct ActorCallback< MonitorThrottlingChangesActor, 1, Void >;
friend struct ActorCallback< MonitorThrottlingChangesActor, 2, Void >;
friend struct ActorCallback< MonitorThrottlingChangesActor, 3, Void >;
															#line 34 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
	MonitorThrottlingChangesActor(TagThrottlerImpl* const& self) 
															#line 892 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   MonitorThrottlingChangesActorState<MonitorThrottlingChangesActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorThrottlingChanges", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10553190831330820864UL, 13570587432161133824UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorThrottlingChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorThrottlingChanges");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorThrottlingChanges", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorThrottlingChangesActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorThrottlingChangesActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MonitorThrottlingChangesActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< MonitorThrottlingChangesActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 34 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
[[nodiscard]] static Future<Void> monitorThrottlingChanges( TagThrottlerImpl* const& self ) {
															#line 34 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"
	return Future<Void>(new MonitorThrottlingChangesActor(self));
															#line 927 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/TagThrottler.actor.g.cpp.py_gen"
}

#line 137 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/TagThrottler.actor.cpp"

	Future<Void> tryUpdateAutoThrottling(TransactionTag tag, double rate, double busyness, TagThrottledReason reason) {
		// NOTE: before the comparison with MIN_TAG_COST, the busiest tag rate also compares with MIN_TAG_PAGES_RATE
		// currently MIN_TAG_PAGES_RATE > MIN_TAG_COST in our default knobs.
		if (busyness > SERVER_KNOBS->AUTO_THROTTLE_TARGET_TAG_BUSYNESS && rate > SERVER_KNOBS->MIN_TAG_COST) {
			CODE_PROBE(true, "Transaction tag auto-throttled");
			Optional<double> clientRate = throttledTags.autoThrottleTag(id, tag, busyness);
			// TODO: Increment tag throttle counts here?
			if (clientRate.present()) {
				TagSet tags;
				tags.addTag(tag);

				Reference<DatabaseContext> dbRef = Reference<DatabaseContext>::addRef(db.getPtr());
				return ThrottleApi::throttleTags(dbRef,
				                                 tags,
				                                 clientRate.get(),
				                                 SERVER_KNOBS->AUTO_TAG_THROTTLE_DURATION,
				                                 TagThrottleType::AUTO,
				                                 TransactionPriority::DEFAULT,
				                                 now() + SERVER_KNOBS->AUTO_TAG_THROTTLE_DURATION,
				                                 reason);
			}
		}
		return Void();
	}

public:
	TagThrottlerImpl(Database db, UID id) : db(db), id(id) {
		expiredTagThrottleCleanup = recurring([this]() { ThrottleApi::expire(this->db.getReference()); },
		                                      SERVER_KNOBS->TAG_THROTTLE_EXPIRED_CLEANUP_INTERVAL);
	}
	Future<Void> monitorThrottlingChanges() { return monitorThrottlingChanges(this); }

	void addRequests(TransactionTag tag, int count) { throttledTags.addRequests(tag, count); }
	uint64_t getThrottledTagChangeId() const { return throttledTagChangeId; }
	PrioritizedTransactionTagMap<ClientTagThrottleLimits> getClientRates() {
		return throttledTags.getClientRates(autoThrottlingEnabled);
	}
	int64_t autoThrottleCount() const { return throttledTags.autoThrottleCount(); }
	uint32_t busyReadTagCount() const { return throttledTags.getBusyReadTagCount(); }
	uint32_t busyWriteTagCount() const { return throttledTags.getBusyWriteTagCount(); }
	int64_t manualThrottleCount() const { return throttledTags.manualThrottleCount(); }
	bool isAutoThrottlingEnabled() const { return autoThrottlingEnabled; }

	Future<Void> tryUpdateAutoThrottling(StorageQueueInfo const& ss) {
		// NOTE: we just keep it simple and don't differentiate write-saturation and read-saturation at the moment. In
		// most of situation, this works. More indicators besides queue size and durability lag could be investigated in
		// the future
		auto storageQueue = ss.getStorageQueueBytes();
		auto storageDurabilityLag = ss.getDurabilityLag();
		std::vector<Future<Void>> futures;
		if (storageQueue > SERVER_KNOBS->AUTO_TAG_THROTTLE_STORAGE_QUEUE_BYTES ||
		    storageDurabilityLag > SERVER_KNOBS->AUTO_TAG_THROTTLE_DURABILITY_LAG_VERSIONS) {
			for (const auto& busyWriteTag : ss.busiestWriteTags) {
				futures.push_back(tryUpdateAutoThrottling(busyWriteTag.tag,
				                                          busyWriteTag.rate,
				                                          busyWriteTag.fractionalBusyness,
				                                          TagThrottledReason::BUSY_WRITE));
			}
			for (const auto& busyReadTag : ss.busiestReadTags) {
				futures.push_back(tryUpdateAutoThrottling(
				    busyReadTag.tag, busyReadTag.rate, busyReadTag.fractionalBusyness, TagThrottledReason::BUSY_READ));
			}
		}
		return waitForAll(futures);
	}

}; // class TagThrottlerImpl

TagThrottler::TagThrottler(Database db, UID id) : impl(PImpl<TagThrottlerImpl>::create(db, id)) {}
TagThrottler::~TagThrottler() = default;
Future<Void> TagThrottler::monitorThrottlingChanges() {
	return impl->monitorThrottlingChanges();
}
void TagThrottler::addRequests(TransactionTag tag, int count) {
	impl->addRequests(tag, count);
}
uint64_t TagThrottler::getThrottledTagChangeId() const {
	return impl->getThrottledTagChangeId();
}
PrioritizedTransactionTagMap<ClientTagThrottleLimits> TagThrottler::getClientRates() {
	return impl->getClientRates();
}
int64_t TagThrottler::autoThrottleCount() const {
	return impl->autoThrottleCount();
}
uint32_t TagThrottler::busyReadTagCount() const {
	return impl->busyReadTagCount();
}
uint32_t TagThrottler::busyWriteTagCount() const {
	return impl->busyWriteTagCount();
}
int64_t TagThrottler::manualThrottleCount() const {
	return impl->manualThrottleCount();
}
bool TagThrottler::isAutoThrottlingEnabled() const {
	return impl->isAutoThrottlingEnabled();
}
Future<Void> TagThrottler::tryUpdateAutoThrottling(StorageQueueInfo const& ss) {
	return impl->tryUpdateAutoThrottling(ss);
}
