#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/RocksDBLogForwarder.actor.cpp"
/*
 * RocksDBLogForwarder.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifdef WITH_ROCKSDB
#include "fdbserver/RocksDBLogForwarder.h"

#include "flow/network.h"
#include "flow/Trace.h"
#include "fdbrpc/simulator.h"

#include "flow/actorcompiler.h" // This must be the last include file

using InfoLogLevel = rocksdb::InfoLogLevel;

namespace {

Severity getSeverityFromLogLevel(const InfoLogLevel& log_level) {
	switch (log_level) {
	case InfoLogLevel::DEBUG_LEVEL:
		return SevDebug;
	case InfoLogLevel::INFO_LEVEL:
		return SevInfo;
	case InfoLogLevel::WARN_LEVEL:
		return SevWarn;
	case InfoLogLevel::ERROR_LEVEL:
		return SevError;
	case InfoLogLevel::FATAL_LEVEL:
		return SevError;
	case InfoLogLevel::HEADER_LEVEL:
		return SevVerbose;
	case InfoLogLevel::NUM_INFO_LOG_LEVELS:
		ASSERT(false);
	}
	UNREACHABLE();
}

} // namespace

namespace details {

void logTraceEvent(const RocksDBLogRecord& record) {
	TraceEvent event = TraceEvent(record.severity, "RocksDBLogRecord", record.uid);
	event.detail("RocksDBLogTime", record.logReceiveTime);

	{
		std::stringstream ss;
		ss << record.threadID;
		event.detail("RocksDBThreadID", ss.str());
	}

	for (const auto& [k, v] : record.kvPairs) {
		event.detail(k.c_str(), v);
	}
}

															#line 75 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBLogForwarder.actor.g.cpp.py_gen"
// This generated class is to be used only via rocksDBPeriodicallyLogger()
															#line 73 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/RocksDBLogForwarder.actor.cpp"
template <class RocksDBPeriodicallyLoggerActor>
															#line 73 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/RocksDBLogForwarder.actor.cpp"
class RocksDBPeriodicallyLoggerActorState {
															#line 81 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBLogForwarder.actor.g.cpp.py_gen"
public:
															#line 73 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/RocksDBLogForwarder.actor.cpp"
	RocksDBPeriodicallyLoggerActorState(RocksDBLogger* const& pRecords) 
															#line 73 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/RocksDBLogForwarder.actor.cpp"
															#line 73 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/RocksDBLogForwarder.actor.cpp"
		 : pRecords(pRecords)
															#line 88 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBLogForwarder.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("rocksDBPeriodicallyLogger", reinterpret_cast<unsigned long>(this));

	}
	~RocksDBPeriodicallyLoggerActorState() 
	{
		fdb_probe_actor_destroy("rocksDBPeriodicallyLogger", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 74 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/RocksDBLogForwarder.actor.cpp"
			;
															#line 103 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBLogForwarder.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RocksDBPeriodicallyLoggerActorState();
		static_cast<RocksDBPeriodicallyLoggerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 75 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/RocksDBLogForwarder.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(0.1);
															#line 74 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/RocksDBLogForwarder.actor.cpp"
		if (static_cast<RocksDBPeriodicallyLoggerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 135 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBLogForwarder.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<RocksDBPeriodicallyLoggerActor*>(this)->actor_wait_state = 1;
															#line 75 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/RocksDBLogForwarder.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RocksDBPeriodicallyLoggerActor, 0, Void >*>(static_cast<RocksDBPeriodicallyLoggerActor*>(this)));
															#line 140 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBLogForwarder.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 76 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/RocksDBLogForwarder.actor.cpp"
		pRecords->consume();
															#line 155 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBLogForwarder.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 76 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/RocksDBLogForwarder.actor.cpp"
		pRecords->consume();
															#line 164 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBLogForwarder.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RocksDBPeriodicallyLoggerActor*>(this)->actor_wait_state > 0) static_cast<RocksDBPeriodicallyLoggerActor*>(this)->actor_wait_state = 0;
		static_cast<RocksDBPeriodicallyLoggerActor*>(this)->ActorCallback< RocksDBPeriodicallyLoggerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RocksDBPeriodicallyLoggerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("rocksDBPeriodicallyLogger", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RocksDBPeriodicallyLoggerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rocksDBPeriodicallyLogger", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RocksDBPeriodicallyLoggerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("rocksDBPeriodicallyLogger", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RocksDBPeriodicallyLoggerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rocksDBPeriodicallyLogger", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RocksDBPeriodicallyLoggerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("rocksDBPeriodicallyLogger", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RocksDBPeriodicallyLoggerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rocksDBPeriodicallyLogger", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 73 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/RocksDBLogForwarder.actor.cpp"
	RocksDBLogger* pRecords;
															#line 234 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBLogForwarder.actor.g.cpp.py_gen"
};
// This generated class is to be used only via rocksDBPeriodicallyLogger()
															#line 73 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/RocksDBLogForwarder.actor.cpp"
class RocksDBPeriodicallyLoggerActor final : public Actor<Void>, public ActorCallback< RocksDBPeriodicallyLoggerActor, 0, Void >, public FastAllocated<RocksDBPeriodicallyLoggerActor>, public RocksDBPeriodicallyLoggerActorState<RocksDBPeriodicallyLoggerActor> {
															#line 239 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBLogForwarder.actor.g.cpp.py_gen"
public:
	using FastAllocated<RocksDBPeriodicallyLoggerActor>::operator new;
	using FastAllocated<RocksDBPeriodicallyLoggerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3787468140207122176UL, 18389532390782448128UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RocksDBPeriodicallyLoggerActor, 0, Void >;
															#line 73 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/RocksDBLogForwarder.actor.cpp"
	RocksDBPeriodicallyLoggerActor(RocksDBLogger* const& pRecords) 
															#line 256 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBLogForwarder.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   RocksDBPeriodicallyLoggerActorState<RocksDBPeriodicallyLoggerActor>(pRecords),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("rocksDBPeriodicallyLogger", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4181743507064150272UL, 5416333443863315200UL);
		ActorExecutionContextHelper __helper(static_cast<RocksDBPeriodicallyLoggerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("rocksDBPeriodicallyLogger");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("rocksDBPeriodicallyLogger", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RocksDBPeriodicallyLoggerActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 73 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/RocksDBLogForwarder.actor.cpp"
[[nodiscard]] Future<Void> rocksDBPeriodicallyLogger( RocksDBLogger* const& pRecords ) {
															#line 73 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/RocksDBLogForwarder.actor.cpp"
	return Future<Void>(new RocksDBPeriodicallyLoggerActor(pRecords));
															#line 288 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbserver/RocksDBLogForwarder.actor.g.cpp.py_gen"
}

#line 80 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbserver/RocksDBLogForwarder.actor.cpp"

RocksDBLogger::RocksDBLogger()
  : mainThreadId(std::this_thread::get_id()), periodicLogger(rocksDBPeriodicallyLogger(this)) {}

void RocksDBLogger::inject(RocksDBLogRecord&& record) {
	const std::thread::id threadId = std::this_thread::get_id();
	if (threadId == mainThreadId) {
		// In the main thread, it is *NOT* necessary to cache the record.
		logTraceEvent(record);

		consume();
	} else {
		const std::lock_guard<std::mutex> lockGuard(recordsMutex);

		logRecords.emplace_back();
		logRecords.back() = std::move(record);
	}
}

void RocksDBLogger::consume() {
	std::vector<RocksDBLogRecord> currentRecords;
	{
		const std::lock_guard<std::mutex> lockGuard(recordsMutex);
		currentRecords.swap(logRecords);
	}

	for (const auto& record : currentRecords) {
		logTraceEvent(record);
	}
}

} // namespace details

RocksDBLogForwarder::RocksDBLogForwarder(const UID& id_, const InfoLogLevel log_level)
  : rocksdb::Logger(log_level), id(id_), logger() {
	TraceEvent(SevInfo, "RocksDBLoggerStart", id);
}

RocksDBLogForwarder::~RocksDBLogForwarder() {
	TraceEvent(SevInfo, "RocksDBLoggerStop", id);
}

void RocksDBLogForwarder::Logv(const char* format, va_list ap) {
	Logv(InfoLogLevel::INFO_LEVEL, format, ap);
}

void RocksDBLogForwarder::Logv(const InfoLogLevel log_level, const char* format, va_list ap) {
	const std::thread::id threadID = std::this_thread::get_id();

	// FIXME: Restrict the RocksDB log level to warn in order to prevent almost all simulation test failure. This has to
	// be reconsidered.
	const Severity severity = std::min(getSeverityFromLogLevel(log_level), SevWarn);

	// TODO: Parse the log information into KV pairs
	// At this stage vsnprintf is used
	char buf[1024];
	vsnprintf(buf, 1024, format, ap);
	if (severity < SevError) {
		logger.inject(details::RocksDBLogRecord{ now(), severity, id, threadID, { { "Text", std::string(buf) } } });
	} else {
		logger.inject(details::RocksDBLogRecord{
		    now(),
		    severity,
		    id,
		    threadID,
		    { { "Text", std::string(buf) }, { "OriginalBacktrace", platform::get_backtrace() } } });
	}
}

#endif // WITH_ROCKSDB
