#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
/*
 * fdbcli.actor.h
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once

// When actually compiled (NO_INTELLISENSE), include the generated
// version of this file.  In intellisense use the source version.
#if defined(NO_INTELLISENSE) && !defined(FDBCLI_FDBCLI_ACTOR_G_H)
#define FDBCLI_FDBCLI_ACTOR_G_H
#include "fdbcli/fdbcli.actor.g.h"
#elif !defined(FDBCLI_FDBCLI_ACTOR_H)
#define FDBCLI_FDBCLI_ACTOR_H

#include "fdbcli/FlowLineNoise.h"

#include "fdbclient/CoordinationInterface.h"
#include "fdbclient/IClientApi.h"
#include "fdbclient/StatusClient.h"
#include "fdbclient/StorageServerInterface.h"
#include "flow/Arena.h"

#include "flow/actorcompiler.h" // This must be the last #include.

namespace fdb_cli {

constexpr char msgTypeKey[] = "type";
constexpr char msgClusterKey[] = "cluster";
constexpr char msgClusterTypeKey[] = "cluster_type";
constexpr char msgDataClustersKey[] = "data_clusters";
constexpr char msgCapacityKey[] = "capacity";
constexpr char msgAllocatedKey[] = "allocated";
constexpr char msgErrorKey[] = "error";

struct CommandHelp {
	std::string usage;
	std::string short_desc;
	std::string long_desc;
	CommandHelp() {}
	CommandHelp(const char* usage, const char* short_desc, const char* long_desc)
	  : usage(usage), short_desc(short_desc), long_desc(long_desc) {}
};

void arrayGenerator(const char* text, const char* line, const char** options, std::vector<std::string>& lc);

struct CommandFactory {
	typedef void (*CompletionGeneratorFunc)(const char* text,
	                                        const char* line,
	                                        std::vector<std::string>& lc,
	                                        std::vector<StringRef> const& tokens);

	typedef std::vector<const char*> (*HintGeneratorFunc)(std::vector<StringRef> const& tokens, bool inArgument);

	CommandFactory(const char* name,
	               CommandHelp help,
	               CompletionGeneratorFunc completionFunc = nullptr,
	               HintGeneratorFunc hintFunc = nullptr) {
		commands()[name] = help;
		if (completionFunc) {
			completionGenerators()[name] = completionFunc;
		}
		if (hintFunc) {
			hintGenerators()[name] = hintFunc;
		}
	}
	CommandFactory(const char* name) { hiddenCommands().insert(name); }
	static std::map<std::string, CommandHelp>& commands() {
		static std::map<std::string, CommandHelp> helpMap;
		return helpMap;
	}
	static std::set<std::string>& hiddenCommands() {
		static std::set<std::string> commands;
		return commands;
	}
	static std::map<std::string, CompletionGeneratorFunc>& completionGenerators() {
		static std::map<std::string, CompletionGeneratorFunc> completionMap;
		return completionMap;
	}
	static std::map<std::string, HintGeneratorFunc>& hintGenerators() {
		static std::map<std::string, HintGeneratorFunc> hintMap;
		return hintMap;
	}
};

// Special keys used by fdbcli commands

extern const KeyRef advanceVersionSpecialKey;
extern const KeyRef consistencyCheckSpecialKey;
extern const KeyRef clusterDescriptionSpecialKey;
extern const KeyRef configDBSpecialKey;
extern const KeyRef coordinatorsAutoSpecialKey;
extern const KeyRef coordinatorsProcessSpecialKey;
extern const KeyRef ddModeSpecialKey;
extern const KeyRef ddIgnoreRebalanceSpecialKey;

extern const KeyRangeRef excludedServersSpecialKeyRange;
extern const KeyRangeRef failedServersSpecialKeyRange;
extern const KeyRangeRef excludedLocalitySpecialKeyRange;
extern const KeyRangeRef failedLocalitySpecialKeyRange;
extern const KeyRef excludedForceOptionSpecialKey;
extern const KeyRef failedForceOptionSpecialKey;
extern const KeyRef excludedLocalityForceOptionSpecialKey;
extern const KeyRef failedLocalityForceOptionSpecialKey;
extern const KeyRangeRef exclusionInProgressSpecialKeyRange;

extern const KeyRef lockSpecialKey;

extern const KeyRangeRef maintenanceSpecialKeyRange;
extern const KeyRef ignoreSSFailureSpecialKey;

extern const KeyRangeRef processClassSourceSpecialKeyRange;
extern const KeyRangeRef processClassTypeSpecialKeyRange;

inline const KeyRef errorMsgSpecialKey = "\xff\xff/error_message"_sr;
inline const KeyRef workerInterfacesVerifyOptionSpecialKey = "\xff\xff/management/options/worker_interfaces/verify"_sr;

															#line 135 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h.py_gen"
[[nodiscard]] Future<bool> getWorkers( Reference<IDatabase> const& db, std::vector<ProcessData>* const& workers );

#line 134 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
															#line 139 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h.py_gen"
[[nodiscard]] Future<Void> getStorageServerInterfaces( Reference<IDatabase> const& db, std::map<std::string, StorageServerInterface>* const& interfaces );

#line 136 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"

bool tokencmp(StringRef token, const char* command);
void printUsage(StringRef command);
void printLongDesc(StringRef command);

// Pre: tr failed with special_keys_api_failure error
// Read the error message special key and return the message
															#line 150 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h.py_gen"
[[nodiscard]] Future<std::string> getSpecialKeysFailureErrorMessage( Reference<ITransaction> const& tr );

#line 144 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// Using \xff\xff/worker_interfaces/ special key, get all worker interfaces.
// A worker list will be returned from CC.
// If verify, we will try to establish connections to all workers returned.
// In particular, it will deserialize \xff\xff/worker_interfaces/<address>:=<ClientInterface> kv pairs and issue RPC
// calls, then only return interfaces(kv pairs) the client can talk to
															#line 159 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h.py_gen"
[[nodiscard]] Future<Void> getWorkerInterfaces( Reference<ITransaction> const& tr, std::map<Key, std::pair<Value, ClientLeaderRegInterface>>* const& address_interface, bool const& verify = false );

#line 152 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// print cluster status info
void printStatus(StatusObjectReader statusObj,
                 StatusClient::StatusLevel level,
                 bool displayDatabaseAvailable = true,
                 bool hideErrorMessages = false);

// All fdbcli commands (alphabetically)
// All below actors return true if the command is executed successfully
// advanceversion command
															#line 172 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h.py_gen"
[[nodiscard]] Future<bool> advanceVersionCommandActor( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens );

#line 162 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// configure command
															#line 177 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h.py_gen"
[[nodiscard]] Future<bool> configureCommandActor( Reference<IDatabase> const& db, Database const& localDb, std::vector<StringRef> const& tokens, LineNoise* const& linenoise, Future<Void> const& warn );

#line 168 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// consistency command
															#line 182 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h.py_gen"
[[nodiscard]] Future<bool> consistencyCheckCommandActor( Reference<ITransaction> const& tr, std::vector<StringRef> const& tokens, bool const& intrans );

#line 172 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// consistency scan command
															#line 187 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h.py_gen"
[[nodiscard]] Future<bool> consistencyScanCommandActor( Database const& localDb, std::vector<StringRef> const& tokens );

#line 174 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// coordinators command
															#line 192 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h.py_gen"
[[nodiscard]] Future<bool> coordinatorsCommandActor( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens );

#line 176 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// datadistribution command
															#line 197 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h.py_gen"
[[nodiscard]] Future<bool> dataDistributionCommandActor( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens );

#line 178 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// exclude command
															#line 202 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h.py_gen"
[[nodiscard]] Future<bool> excludeCommandActor( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens, Future<Void> const& warn );

#line 180 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// expensive_data_check command
															#line 207 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h.py_gen"
[[nodiscard]] Future<bool> expensiveDataCheckCommandActor( Reference<IDatabase> const& db, Reference<ITransaction> const& tr, std::vector<StringRef> const& tokens, std::map<Key, std::pair<Value, ClientLeaderRegInterface>>* const& address_interface );

#line 186 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// fileconfigure command
															#line 212 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h.py_gen"
[[nodiscard]] Future<bool> fileConfigureCommandActor( Reference<IDatabase> const& db, std::string const& filePath, bool const& isNewDatabase, bool const& force );

#line 191 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// Trigger audit storage
															#line 217 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h.py_gen"
[[nodiscard]] Future<UID> auditStorageCommandActor( Reference<IClusterConnectionRecord> const& clusterFile, std::vector<StringRef> const& tokens );

#line 194 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// Retrieve audit storage status
															#line 222 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h.py_gen"
[[nodiscard]] Future<bool> getAuditStatusCommandActor( Database const& cx, std::vector<StringRef> const& tokens );

#line 196 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// Retrieve shard information command
															#line 227 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h.py_gen"
[[nodiscard]] Future<bool> locationMetadataCommandActor( Database const& cx, std::vector<StringRef> const& tokens );

#line 198 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// Bulk loading command
															#line 232 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h.py_gen"
[[nodiscard]] Future<UID> bulkLoadCommandActor( Database const& cx, std::vector<StringRef> const& tokens );

#line 200 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// Bulk dumping command
															#line 237 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h.py_gen"
[[nodiscard]] Future<UID> bulkDumpCommandActor( Database const& cx, std::vector<StringRef> const& tokens );

#line 202 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// force_recovery_with_data_loss command
															#line 242 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h.py_gen"
[[nodiscard]] Future<bool> forceRecoveryWithDataLossCommandActor( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens );

#line 204 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// include command
															#line 247 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h.py_gen"
[[nodiscard]] Future<bool> includeCommandActor( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens );

#line 206 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// kill command
															#line 252 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h.py_gen"
[[nodiscard]] Future<bool> killCommandActor( Reference<IDatabase> const& db, Reference<ITransaction> const& tr, std::vector<StringRef> const& tokens, std::map<Key, std::pair<Value, ClientLeaderRegInterface>>* const& address_interface );

#line 211 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// lock/unlock command
															#line 257 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h.py_gen"
[[nodiscard]] Future<bool> lockCommandActor( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens );

#line 213 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
															#line 261 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h.py_gen"
[[nodiscard]] Future<bool> unlockDatabaseActor( Reference<IDatabase> const& db, UID const& uid );

#line 214 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"

// blobrestore command
															#line 267 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h.py_gen"
[[nodiscard]] Future<bool> blobRestoreCommandActor( Database const& localDb, std::vector<StringRef> const& tokens );

#line 217 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// hotrange command
															#line 272 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h.py_gen"
[[nodiscard]] Future<bool> hotRangeCommandActor( Database const& localDb, Reference<IDatabase> const& db, std::vector<StringRef> const& tokens, std::map<std::string, StorageServerInterface>* const& storage_interface );

#line 222 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"

// maintenance command
															#line 278 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h.py_gen"
[[nodiscard]] Future<bool> setHealthyZone( Reference<IDatabase> const& db, StringRef const& zoneId, double const& seconds, bool const& printWarning = false );

#line 225 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
															#line 282 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h.py_gen"
[[nodiscard]] Future<bool> clearHealthyZone( Reference<IDatabase> const& db, bool const& printWarning = false, bool const& clearSSFailureZoneString = false );

#line 228 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
															#line 286 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h.py_gen"
[[nodiscard]] Future<bool> maintenanceCommandActor( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens );

#line 229 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// profile command
															#line 291 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h.py_gen"
[[nodiscard]] Future<bool> profileCommandActor( Database const& db, Reference<ITransaction> const& tr, std::vector<StringRef> const& tokens, bool const& intrans );

#line 234 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// quota command
															#line 296 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h.py_gen"
[[nodiscard]] Future<bool> quotaCommandActor( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens );

#line 236 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// setclass command
															#line 301 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h.py_gen"
[[nodiscard]] Future<bool> setClassCommandActor( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens );

#line 238 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// snapshot command
															#line 306 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h.py_gen"
[[nodiscard]] Future<bool> snapshotCommandActor( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens );

#line 240 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// status command
															#line 311 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h.py_gen"
[[nodiscard]] Future<bool> statusCommandActor( Reference<IDatabase> const& db, Database const& localDb, std::vector<StringRef> const& tokens, bool const& isExecMode = false );

#line 245 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// suspend command
															#line 316 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h.py_gen"
[[nodiscard]] Future<bool> suspendCommandActor( Reference<IDatabase> const& db, Reference<ITransaction> const& tr, std::vector<StringRef> const& tokens, std::map<Key, std::pair<Value, ClientLeaderRegInterface>>* const& address_interface );

#line 250 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// throttle command
															#line 321 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h.py_gen"
[[nodiscard]] Future<bool> throttleCommandActor( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens );

#line 252 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// triggerteaminfolog command
															#line 326 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h.py_gen"
[[nodiscard]] Future<bool> triggerddteaminfologCommandActor( Reference<IDatabase> const& db );

#line 254 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// tssq command
															#line 331 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h.py_gen"
[[nodiscard]] Future<bool> tssqCommandActor( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens );

#line 256 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// versionepoch command
															#line 336 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h.py_gen"
[[nodiscard]] Future<bool> versionEpochCommandActor( Reference<IDatabase> const& db, Database const& cx, std::vector<StringRef> const& tokens );

#line 258 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// targetversion command
															#line 341 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h.py_gen"
[[nodiscard]] Future<bool> targetVersionCommandActor( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens );

#line 260 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
// idempotencyids command
															#line 346 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h.py_gen"
[[nodiscard]] Future<bool> idempotencyIdsCommandActor( Database const& cx, std::vector<StringRef> const& tokens );

#line 262 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"

// rangeconfig command
															#line 352 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h.py_gen"
[[nodiscard]] Future<bool> rangeConfigCommandActor( Database const& cx, std::vector<StringRef> const& tokens );

#line 265 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"

// debug commands: getlocation, getall
															#line 358 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h.py_gen"
[[nodiscard]] Future<bool> getLocationCommandActor( Database const& cx, std::vector<StringRef> const& tokens );

#line 268 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
															#line 362 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h.py_gen"
[[nodiscard]] Future<bool> getallCommandActor( Database const& cx, std::vector<StringRef> const& tokens, Version const& version );

#line 269 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
															#line 366 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/build_output/fdbcli/include/fdbcli/fdbcli.actor.g.h.py_gen"
[[nodiscard]] Future<bool> checkallCommandActor( Database const& cx, std::vector<StringRef> const& tokens );

#line 270 "/codebuild/output/src1317373735/src/github.com/apple/foundationdb/fdbcli/include/fdbcli/fdbcli.actor.h"
} // namespace fdb_cli

#include "flow/unactorcompiler.h"
#endif
