#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
/*
 * LoadBalance.actor.h
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once

// When actually compiled (NO_INTELLISENSE), include the generated version of this file.  In intellisense use the source
// version.
#if defined(NO_INTELLISENSE) && !defined(FLOW_LOADBALANCE_ACTOR_G_H)
#define FLOW_LOADBALANCE_ACTOR_G_H
#include "fdbrpc/LoadBalance.actor.g.h"
#elif !defined(FLOW_LOADBALANCE_ACTOR_H)
#define FLOW_LOADBALANCE_ACTOR_H

#include "flow/BooleanParam.h"
#include "flow/flow.h"
#include "flow/Error.h"
#include "flow/Knobs.h"

#include "fdbrpc/FailureMonitor.h"
#include "fdbrpc/fdbrpc.h"
#include "fdbrpc/Locality.h"
#include "fdbrpc/QueueModel.h"
#include "fdbrpc/MultiInterface.h"
#include "fdbrpc/simulator.h" // for checking tss simulation mode
#include "fdbrpc/TSSComparison.h"
#include "flow/actorcompiler.h" // This must be the last #include.

															#line 47 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
[[nodiscard]] Future<Void> allAlternativesFailedDelay( Future<Void> const& okFuture );

#line 46 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"

enum ComparisonType { TSS_COMPARISON, REPLICA_COMPARISON };

enum RequiredReplicas { BEST_EFFORT = -2, ALL_REPLICAS = -1 };

struct ModelHolder : NonCopyable, public ReferenceCounted<ModelHolder> {
	QueueModel* model;
	bool released;
	double startTime;
	double delta;
	uint64_t token;

	ModelHolder(QueueModel* model, uint64_t token) : model(model), released(false), startTime(now()), token(token) {
		if (model) {
			delta = model->addRequest(token);
		}
	}

	void release(bool clean, bool futureVersion, double penalty, bool measureLatency = true) {
		if (model && !released) {
			released = true;
			double latency = (clean || measureLatency) ? now() - startTime : 0.0;
			model->endRequest(token, latency, penalty, delta, clean, futureVersion);
		}
	}

	~ModelHolder() { release(false, false, -1.0, false); }
};

// Subclasses must initialize all members in their default constructors
// Subclasses must serialize all members
struct LoadBalancedReply {
	double penalty;
	Optional<Error> error;
	LoadBalancedReply() : penalty(1.0) {}
};

Optional<LoadBalancedReply> getLoadBalancedReply(const LoadBalancedReply* reply);
Optional<LoadBalancedReply> getLoadBalancedReply(const void*);

// FIXME: use a less obscure name than `P` here
															#line 92 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
namespace {
// This generated class is to be used only via tssComparison()
															#line 87 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
template <class Req, class Resp, class Interface, class Multi, bool P, class TssComparisonActor>
															#line 87 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
class TssComparisonActorState {
															#line 99 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
public:
															#line 87 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	TssComparisonActorState(Req const& req,Future<ErrorOr<Resp>> const& fSource,Future<ErrorOr<Resp>> const& fTss,TSSEndpointData const& tssData,uint64_t const& srcEndpointId,Reference<MultiInterface<Multi>> const& ssTeam,RequestStream<Req, P> Interface::* const& channel) 
															#line 87 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
															#line 87 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		 : req(req),
															#line 87 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   fSource(fSource),
															#line 87 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   fTss(fTss),
															#line 87 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   tssData(tssData),
															#line 87 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   srcEndpointId(srcEndpointId),
															#line 87 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   ssTeam(ssTeam),
															#line 87 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   channel(channel),
															#line 95 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   startTime(now()),
															#line 96 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   fTssWithTimeout(timeout(fTss, FLOW_KNOBS->LOAD_BALANCE_TSS_TIMEOUT)),
															#line 97 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   finished(0),
															#line 98 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   srcEndTime(),
															#line 99 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   tssEndTime(),
															#line 101 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   srcErrorCode(error_code_success),
															#line 102 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   tssErrorCode(error_code_success),
															#line 103 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   src(),
															#line 104 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   tss()
															#line 136 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
	{
		fdb_probe_actor_create("tssComparison", reinterpret_cast<unsigned long>(this));

	}
	~TssComparisonActorState() 
	{
		fdb_probe_actor_destroy("tssComparison", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 106 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			;
															#line 151 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TssComparisonActorState();
		static_cast<TssComparisonActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 126 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		++tssData.metrics->requests;
															#line 128 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (src.isError())
															#line 176 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 129 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			srcErrorCode = src.getError().code();
															#line 130 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			tssData.metrics->ssError(srcErrorCode);
															#line 182 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		}
															#line 132 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (!tss.present())
															#line 186 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 133 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			++tssData.metrics->tssTimeouts;
															#line 190 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		}
		else
		{
															#line 134 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (tss.get().isError())
															#line 196 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 135 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				tssErrorCode = tss.get().getError().code();
															#line 136 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				tssData.metrics->tssError(tssErrorCode);
															#line 202 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			}
		}
															#line 138 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (!src.isError() && tss.present() && !tss.get().isError())
															#line 207 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 139 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			Optional<LoadBalancedReply> srcLB = getLoadBalancedReply(&src.get());
															#line 140 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			Optional<LoadBalancedReply> tssLB = getLoadBalancedReply(&tss.get().get());
															#line 141 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			ASSERT(srcLB.present() == tssLB.present());
															#line 145 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (!srcLB.present() || (!srcLB.get().error.present() && !tssLB.get().error.present()))
															#line 217 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 148 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				tssData.metrics->recordLatency(req, srcEndTime - startTime, tssEndTime - startTime);
															#line 150 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				if (!TSS_doCompare(src.get(), tss.get().get()))
															#line 223 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				{
															#line 151 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					CODE_PROBE(true, "TSS Mismatch");
															#line 152 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					mismatchEvent = TraceEvent((g_network->isSimulated() && g_simulator->tssMode == ISimulator::TSSMode::EnabledDropMutations) ? SevWarnAlways : SevError, LB_mismatchTraceName(req, TSS_COMPARISON));
															#line 157 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					mismatchEvent.setMaxEventLength(FLOW_KNOBS->TSS_LARGE_TRACE_SIZE);
															#line 158 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					mismatchEvent.detail("TSSID", tssData.tssId);
															#line 160 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					if (FLOW_KNOBS->LOAD_BALANCE_TSS_MISMATCH_VERIFY_SS && ssTeam->size() > 1)
															#line 235 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					{
															#line 161 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						CODE_PROBE(true, "checking TSS mismatch against rest of storage team");
															#line 165 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						restOfTeamFutures = std::vector<Future<ErrorOr<Resp>>>();
															#line 166 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						restOfTeamFutures.reserve(ssTeam->size() - 1);
															#line 167 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						for(int i = 0;i < ssTeam->size();i++) {
															#line 168 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
							RequestStream<Req, P> const* si = &ssTeam->get(i, channel);
															#line 169 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
							if (si->getEndpoint().token.first() != srcEndpointId)
															#line 249 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
							{
															#line 171 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
								resetReply(req);
															#line 172 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
								restOfTeamFutures.push_back(si->tryGetReply(req));
															#line 255 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
							}
						}
															#line 176 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						StrictFuture<Void> __when_expr_2 = waitForAllReady(restOfTeamFutures);
															#line 176 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						if (static_cast<TssComparisonActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 262 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
						if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when1(__when_expr_2.get(), loopDepth); };
						static_cast<TssComparisonActor*>(this)->actor_wait_state = 2;
															#line 176 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TssComparisonActor, 2, Void >*>(static_cast<TssComparisonActor*>(this)));
															#line 267 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
						loopDepth = 0;
					}
					else
					{
						loopDepth = a_body1cont9(loopDepth);
					}
				}
				else
				{
					loopDepth = a_body1cont8(loopDepth);
				}
			}
			else
			{
															#line 228 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				if (tssLB.present() && tssLB.get().error.present())
															#line 284 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				{
															#line 229 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					tssErrorCode = tssLB.get().error.get().code();
															#line 230 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					tssData.metrics->tssError(tssErrorCode);
															#line 290 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				}
				else
				{
															#line 231 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					if (srcLB.present() && srcLB.get().error.present())
															#line 296 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					{
															#line 232 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						srcErrorCode = srcLB.get().error.get().code();
															#line 233 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						tssData.metrics->ssError(srcErrorCode);
															#line 302 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					}
				}
				loopDepth = a_body1cont7(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 108 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		StrictFuture<Void> __when_expr_0 = store(src, fSource);
															#line 107 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (static_cast<TssComparisonActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 328 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 116 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		StrictFuture<Void> __when_expr_1 = store(tss, fTssWithTimeout);
															#line 332 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<TssComparisonActor*>(this)->actor_wait_state = 1;
															#line 108 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TssComparisonActor, 0, Void >*>(static_cast<TssComparisonActor*>(this)));
															#line 116 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TssComparisonActor, 1, Void >*>(static_cast<TssComparisonActor*>(this)));
															#line 339 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 109 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		srcEndTime = now();
															#line 110 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		fSource = Never();
															#line 111 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		finished++;
															#line 112 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (finished == 2)
															#line 373 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 109 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		srcEndTime = now();
															#line 110 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		fSource = Never();
															#line 111 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		finished++;
															#line 112 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (finished == 2)
															#line 391 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 117 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		tssEndTime = now();
															#line 118 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		fTssWithTimeout = Never();
															#line 119 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		finished++;
															#line 120 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (finished == 2)
															#line 409 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 117 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		tssEndTime = now();
															#line 118 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		fTssWithTimeout = Never();
															#line 119 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		finished++;
															#line 120 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (finished == 2)
															#line 427 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TssComparisonActor*>(this)->actor_wait_state > 0) static_cast<TssComparisonActor*>(this)->actor_wait_state = 0;
		static_cast<TssComparisonActor*>(this)->ActorCallback< TssComparisonActor, 0, Void >::remove();
		static_cast<TssComparisonActor*>(this)->ActorCallback< TssComparisonActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TssComparisonActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tssComparison", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TssComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssComparison", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TssComparisonActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tssComparison", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TssComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssComparison", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TssComparisonActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tssComparison", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TssComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssComparison", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TssComparisonActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tssComparison", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TssComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssComparison", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TssComparisonActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tssComparison", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TssComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssComparison", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TssComparisonActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tssComparison", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TssComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssComparison", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 237 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (srcErrorCode != error_code_success && tssErrorCode != error_code_success && srcErrorCode != tssErrorCode)
															#line 560 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 239 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			TraceEvent("TSSErrorMismatch") .suppressFor(1.0) .detail("TSSID", tssData.tssId) .detail("SSError", srcErrorCode) .detail("TSSError", tssErrorCode);
															#line 564 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		}
															#line 246 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (!static_cast<TssComparisonActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TssComparisonActorState(); static_cast<TssComparisonActor*>(this)->destroy(); return 0; }
															#line 568 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		new (&static_cast<TssComparisonActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TssComparisonActorState();
		static_cast<TssComparisonActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7(int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont9(int loopDepth) 
	{
															#line 203 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (tssData.metrics->shouldRecordDetailedMismatch())
															#line 592 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 204 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			TSS_traceMismatch(mismatchEvent, req, src.get(), tss.get().get(), TSS_COMPARISON);
															#line 206 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			CODE_PROBE(FLOW_KNOBS->LOAD_BALANCE_TSS_MISMATCH_TRACE_FULL, "Tracing Full TSS Mismatch");
															#line 207 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			CODE_PROBE(!FLOW_KNOBS->LOAD_BALANCE_TSS_MISMATCH_TRACE_FULL, "Tracing Partial TSS Mismatch and storing the rest in FDB");
															#line 210 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (!FLOW_KNOBS->LOAD_BALANCE_TSS_MISMATCH_TRACE_FULL)
															#line 602 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 211 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				mismatchEvent.disable();
															#line 212 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				UID mismatchUID = deterministicRandom()->randomUniqueID();
															#line 213 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				tssData.metrics->recordDetailedMismatchData(mismatchUID, mismatchEvent.getFields().toString());
															#line 216 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				TraceEvent summaryEvent((g_network->isSimulated() && g_simulator->tssMode == ISimulator::TSSMode::EnabledDropMutations) ? SevWarnAlways : SevError, LB_mismatchTraceName(req, TSS_COMPARISON));
															#line 221 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				summaryEvent.detail("TSSID", tssData.tssId).detail("MismatchId", mismatchUID);
															#line 614 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			}
		}
		else
		{
															#line 225 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			mismatchEvent.disable();
															#line 621 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		}
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont10(Void const& _,int loopDepth) 
	{
															#line 178 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		int numError = 0;
															#line 179 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		int numMatchSS = 0;
															#line 180 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		int numMatchTSS = 0;
															#line 181 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		int numMatchNeither = 0;
															#line 182 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		for( Future<ErrorOr<Resp>> f : restOfTeamFutures ) {
															#line 183 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (!f.canGet() || f.get().isError())
															#line 641 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 184 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				numError++;
															#line 645 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			}
			else
			{
															#line 186 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				Optional<LoadBalancedReply> fLB = getLoadBalancedReply(&f.get().get());
															#line 187 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				if (fLB.present() && fLB.get().error.present())
															#line 653 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				{
															#line 188 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					numError++;
															#line 657 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				}
				else
				{
															#line 189 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					if (TSS_doCompare(src.get(), f.get().get()))
															#line 663 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					{
															#line 190 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						numMatchSS++;
															#line 667 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					}
					else
					{
															#line 191 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						if (TSS_doCompare(tss.get().get(), f.get().get()))
															#line 673 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
						{
															#line 192 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
							numMatchTSS++;
															#line 677 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
						}
						else
						{
															#line 194 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
							numMatchNeither++;
															#line 683 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
						}
					}
				}
			}
		}
															#line 198 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		mismatchEvent.detail("TeamCheckErrors", numError) .detail("TeamCheckMatchSS", numMatchSS) .detail("TeamCheckMatchTSS", numMatchTSS) .detail("TeamCheckMatchNeither", numMatchNeither);
															#line 691 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont10(Void && _,int loopDepth) 
	{
															#line 178 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		int numError = 0;
															#line 179 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		int numMatchSS = 0;
															#line 180 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		int numMatchTSS = 0;
															#line 181 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		int numMatchNeither = 0;
															#line 182 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		for( Future<ErrorOr<Resp>> f : restOfTeamFutures ) {
															#line 183 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (!f.canGet() || f.get().isError())
															#line 710 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 184 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				numError++;
															#line 714 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			}
			else
			{
															#line 186 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				Optional<LoadBalancedReply> fLB = getLoadBalancedReply(&f.get().get());
															#line 187 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				if (fLB.present() && fLB.get().error.present())
															#line 722 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				{
															#line 188 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					numError++;
															#line 726 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				}
				else
				{
															#line 189 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					if (TSS_doCompare(src.get(), f.get().get()))
															#line 732 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					{
															#line 190 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						numMatchSS++;
															#line 736 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					}
					else
					{
															#line 191 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						if (TSS_doCompare(tss.get().get(), f.get().get()))
															#line 742 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
						{
															#line 192 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
							numMatchTSS++;
															#line 746 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
						}
						else
						{
															#line 194 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
							numMatchNeither++;
															#line 752 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
						}
					}
				}
			}
		}
															#line 198 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		mismatchEvent.detail("TeamCheckErrors", numError) .detail("TeamCheckMatchSS", numMatchSS) .detail("TeamCheckMatchTSS", numMatchTSS) .detail("TeamCheckMatchNeither", numMatchNeither);
															#line 760 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TssComparisonActor*>(this)->actor_wait_state > 0) static_cast<TssComparisonActor*>(this)->actor_wait_state = 0;
		static_cast<TssComparisonActor*>(this)->ActorCallback< TssComparisonActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TssComparisonActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tssComparison", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TssComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssComparison", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TssComparisonActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tssComparison", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TssComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssComparison", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TssComparisonActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tssComparison", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TssComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssComparison", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 87 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	Req req;
															#line 87 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	Future<ErrorOr<Resp>> fSource;
															#line 87 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	Future<ErrorOr<Resp>> fTss;
															#line 87 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	TSSEndpointData tssData;
															#line 87 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	uint64_t srcEndpointId;
															#line 87 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	Reference<MultiInterface<Multi>> ssTeam;
															#line 87 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	RequestStream<Req, P> Interface::* channel;
															#line 95 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	double startTime;
															#line 96 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	Future<Optional<ErrorOr<Resp>>> fTssWithTimeout;
															#line 97 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	int finished;
															#line 98 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	double srcEndTime;
															#line 99 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	double tssEndTime;
															#line 101 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	int srcErrorCode;
															#line 102 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	int tssErrorCode;
															#line 103 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	ErrorOr<Resp> src;
															#line 104 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	Optional<ErrorOr<Resp>> tss;
															#line 152 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	TraceEvent mismatchEvent;
															#line 165 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	std::vector<Future<ErrorOr<Resp>>> restOfTeamFutures;
															#line 876 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
};
// This generated class is to be used only via tssComparison()
															#line 87 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
template <class Req, class Resp, class Interface, class Multi, bool P>
															#line 87 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
class TssComparisonActor final : public Actor<Void>, public ActorCallback< TssComparisonActor<Req, Resp, Interface, Multi, P>, 0, Void >, public ActorCallback< TssComparisonActor<Req, Resp, Interface, Multi, P>, 1, Void >, public ActorCallback< TssComparisonActor<Req, Resp, Interface, Multi, P>, 2, Void >, public FastAllocated<TssComparisonActor<Req, Resp, Interface, Multi, P>>, public TssComparisonActorState<Req, Resp, Interface, Multi, P, TssComparisonActor<Req, Resp, Interface, Multi, P>> {
															#line 883 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
public:
	using FastAllocated<TssComparisonActor<Req, Resp, Interface, Multi, P>>::operator new;
	using FastAllocated<TssComparisonActor<Req, Resp, Interface, Multi, P>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13862798706067506176UL, 18161641783135375360UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TssComparisonActor<Req, Resp, Interface, Multi, P>, 0, Void >;
friend struct ActorCallback< TssComparisonActor<Req, Resp, Interface, Multi, P>, 1, Void >;
friend struct ActorCallback< TssComparisonActor<Req, Resp, Interface, Multi, P>, 2, Void >;
															#line 87 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	TssComparisonActor(Req const& req,Future<ErrorOr<Resp>> const& fSource,Future<ErrorOr<Resp>> const& fTss,TSSEndpointData const& tssData,uint64_t const& srcEndpointId,Reference<MultiInterface<Multi>> const& ssTeam,RequestStream<Req, P> Interface::* const& channel) 
															#line 902 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		 : Actor<Void>(),
		   TssComparisonActorState<Req, Resp, Interface, Multi, P, TssComparisonActor<Req, Resp, Interface, Multi, P>>(req, fSource, fTss, tssData, srcEndpointId, ssTeam, channel),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tssComparison", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8553245748359799296UL, 10319318729022024192UL);
		ActorExecutionContextHelper __helper(static_cast<TssComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tssComparison");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tssComparison", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TssComparisonActor<Req, Resp, Interface, Multi, P>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TssComparisonActor<Req, Resp, Interface, Multi, P>, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 87 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
template <class Req, class Resp, class Interface, class Multi, bool P>
															#line 87 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
[[nodiscard]] Future<Void> tssComparison( Req const& req, Future<ErrorOr<Resp>> const& fSource, Future<ErrorOr<Resp>> const& fTss, TSSEndpointData const& tssData, uint64_t const& srcEndpointId, Reference<MultiInterface<Multi>> const& ssTeam, RequestStream<Req, P> Interface::* const& channel ) {
															#line 87 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	return Future<Void>(new TssComparisonActor<Req, Resp, Interface, Multi, P>(req, fSource, fTss, tssData, srcEndpointId, ssTeam, channel));
															#line 938 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
}

#line 248 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"

															#line 943 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
namespace {
// This generated class is to be used only via waitForQuorumReplies()
															#line 249 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
template <class Resp, class WaitForQuorumRepliesActor>
															#line 249 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
class WaitForQuorumRepliesActorState {
															#line 950 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
public:
															#line 249 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	WaitForQuorumRepliesActorState(std::vector<Future<Optional<ErrorOr<Resp>>>>* const& replies,int const& required) 
															#line 249 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
															#line 249 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		 : replies(replies),
															#line 249 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   required(required),
															#line 251 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   outstandingReplies((int)replies->size()),
															#line 252 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   requiredReplies(std::min(required, (int)replies->size())),
															#line 253 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   ongoingReplies()
															#line 965 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
	{
		fdb_probe_actor_create("waitForQuorumReplies", reinterpret_cast<unsigned long>(this));

	}
	~WaitForQuorumRepliesActorState() 
	{
		fdb_probe_actor_destroy("waitForQuorumReplies", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 254 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			;
															#line 980 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitForQuorumRepliesActorState();
		static_cast<WaitForQuorumRepliesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 282 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (!static_cast<WaitForQuorumRepliesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitForQuorumRepliesActorState(); static_cast<WaitForQuorumRepliesActor*>(this)->destroy(); return 0; }
															#line 1003 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		new (&static_cast<WaitForQuorumRepliesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WaitForQuorumRepliesActorState();
		static_cast<WaitForQuorumRepliesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 255 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		ongoingReplies.clear();
															#line 256 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		for( auto& reply : (*replies) ) {
															#line 257 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (!reply.isReady())
															#line 1026 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 258 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				ongoingReplies.push_back(reply);
															#line 1030 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			}
		}
															#line 261 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		ASSERT(ongoingReplies.size() == outstandingReplies);
															#line 263 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (requiredReplies == 0 || outstandingReplies == 0)
															#line 1037 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 267 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		StrictFuture<Void> __when_expr_0 = quorum(ongoingReplies, std::min(requiredReplies, outstandingReplies));
															#line 267 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (static_cast<WaitForQuorumRepliesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1045 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<WaitForQuorumRepliesActor*>(this)->actor_wait_state = 1;
															#line 267 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitForQuorumRepliesActor, 0, Void >*>(static_cast<WaitForQuorumRepliesActor*>(this)));
															#line 1050 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 269 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		for( auto& reply : ongoingReplies ) {
															#line 270 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (reply.isReady())
															#line 1074 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 271 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				outstandingReplies--;
															#line 272 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				if (!reply.isError() && reply.get().present() && !reply.get().get().isError())
															#line 1080 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				{
															#line 273 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					Optional<LoadBalancedReply> lbReply = getLoadBalancedReply(&reply.get().get().get());
															#line 274 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					if (lbReply.present() && !lbReply.get().error.present())
															#line 1086 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					{
															#line 275 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						requiredReplies--;
															#line 1090 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					}
				}
			}
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 269 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		for( auto& reply : ongoingReplies ) {
															#line 270 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (reply.isReady())
															#line 1105 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 271 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				outstandingReplies--;
															#line 272 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				if (!reply.isError() && reply.get().present() && !reply.get().get().isError())
															#line 1111 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				{
															#line 273 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					Optional<LoadBalancedReply> lbReply = getLoadBalancedReply(&reply.get().get().get());
															#line 274 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					if (lbReply.present() && !lbReply.get().error.present())
															#line 1117 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					{
															#line 275 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						requiredReplies--;
															#line 1121 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					}
				}
			}
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitForQuorumRepliesActor*>(this)->actor_wait_state > 0) static_cast<WaitForQuorumRepliesActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForQuorumRepliesActor*>(this)->ActorCallback< WaitForQuorumRepliesActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForQuorumRepliesActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForQuorumReplies", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuorumRepliesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuorumReplies", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitForQuorumRepliesActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForQuorumReplies", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuorumRepliesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuorumReplies", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitForQuorumRepliesActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForQuorumReplies", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuorumRepliesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuorumReplies", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 249 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	std::vector<Future<Optional<ErrorOr<Resp>>>>* replies;
															#line 249 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	int required;
															#line 251 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	int outstandingReplies;
															#line 252 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	int requiredReplies;
															#line 253 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	std::vector<Future<Optional<ErrorOr<Resp>>>> ongoingReplies;
															#line 1215 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
};
// This generated class is to be used only via waitForQuorumReplies()
															#line 249 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
template <class Resp>
															#line 249 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
class WaitForQuorumRepliesActor final : public Actor<Void>, public ActorCallback< WaitForQuorumRepliesActor<Resp>, 0, Void >, public FastAllocated<WaitForQuorumRepliesActor<Resp>>, public WaitForQuorumRepliesActorState<Resp, WaitForQuorumRepliesActor<Resp>> {
															#line 1222 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
public:
	using FastAllocated<WaitForQuorumRepliesActor<Resp>>::operator new;
	using FastAllocated<WaitForQuorumRepliesActor<Resp>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6326890038475081216UL, 3106916423152950528UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitForQuorumRepliesActor<Resp>, 0, Void >;
															#line 249 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	WaitForQuorumRepliesActor(std::vector<Future<Optional<ErrorOr<Resp>>>>* const& replies,int const& required) 
															#line 1239 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		 : Actor<Void>(),
		   WaitForQuorumRepliesActorState<Resp, WaitForQuorumRepliesActor<Resp>>(replies, required),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitForQuorumReplies", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16083508386102982912UL, 1306394814074811392UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuorumRepliesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitForQuorumReplies");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitForQuorumReplies", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitForQuorumRepliesActor<Resp>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 249 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
template <class Resp>
															#line 249 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
[[nodiscard]] Future<Void> waitForQuorumReplies( std::vector<Future<Optional<ErrorOr<Resp>>>>* const& replies, int const& required ) {
															#line 249 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	return Future<Void>(new WaitForQuorumRepliesActor<Resp>(replies, required));
															#line 1274 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
}

#line 284 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"

															#line 1279 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
namespace {
// This generated class is to be used only via replicaComparison()
															#line 285 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
template <class Req, class Resp, class Interface, class Multi, bool P, class ReplicaComparisonActor>
															#line 285 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
class ReplicaComparisonActorState {
															#line 1286 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
public:
															#line 285 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	ReplicaComparisonActorState(Req const& req,Future<ErrorOr<Resp>> const& fSource,uint64_t const& srcEndpointId,Reference<MultiInterface<Multi>> const& ssTeam,RequestStream<Req, P> Interface::* const& channel,int const& requiredReplicas) 
															#line 285 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
															#line 285 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		 : req(req),
															#line 285 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   fSource(fSource),
															#line 285 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   srcEndpointId(srcEndpointId),
															#line 285 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   ssTeam(ssTeam),
															#line 285 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   channel(channel),
															#line 285 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   requiredReplicas(requiredReplicas),
															#line 292 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   src()
															#line 1305 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
	{
		fdb_probe_actor_create("replicaComparison", reinterpret_cast<unsigned long>(this));

	}
	~ReplicaComparisonActorState() 
	{
		fdb_probe_actor_destroy("replicaComparison", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 294 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (ssTeam->size() <= 1 || requiredReplicas == 0)
															#line 1320 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 295 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				if (!static_cast<ReplicaComparisonActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReplicaComparisonActorState(); static_cast<ReplicaComparisonActor*>(this)->destroy(); return 0; }
															#line 1324 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				new (&static_cast<ReplicaComparisonActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~ReplicaComparisonActorState();
				static_cast<ReplicaComparisonActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 298 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			StrictFuture<Void> __when_expr_0 = store(src, fSource);
															#line 298 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (static_cast<ReplicaComparisonActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1334 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ReplicaComparisonActor*>(this)->actor_wait_state = 1;
															#line 298 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReplicaComparisonActor, 0, Void >*>(static_cast<ReplicaComparisonActor*>(this)));
															#line 1339 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReplicaComparisonActorState();
		static_cast<ReplicaComparisonActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 300 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (src.isError())
															#line 1362 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 301 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			ASSERT_WE_THINK(false);
															#line 302 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (requiredReplicas == ALL_REPLICAS)
															#line 1368 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 303 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				return a_body1Catch1(src.getError(), loopDepth);
															#line 1372 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			}
			loopDepth = a_body1cont3(loopDepth);
		}
		else
		{
															#line 306 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			srcLB = getLoadBalancedReply(&src.get());
															#line 308 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (srcLB.present() && srcLB.get().error.present())
															#line 1382 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 309 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				ASSERT_WE_THINK(false);
															#line 310 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				if (requiredReplicas == ALL_REPLICAS)
															#line 1388 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				{
															#line 311 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					return a_body1Catch1(srcLB.get().error.get(), loopDepth);
															#line 1392 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				}
				loopDepth = a_body1cont6(loopDepth);
			}
			else
			{
															#line 313 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				if (!srcLB.present() || !srcLB.get().error.present())
															#line 1400 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				{
															#line 315 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					std::vector<uint64_t> candidates;
															#line 318 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					for(int i = 0;i < ssTeam->size();i++) {
															#line 319 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						RequestStream<Req, P> const* si = &ssTeam->get(i, channel);
															#line 320 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						if (si->getEndpoint().token.first() == srcEndpointId)
															#line 1410 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
						{
							continue;
						}
															#line 324 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						if (!IFailureMonitor::failureMonitor().getState(si->getEndpoint()).failed)
															#line 1416 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
						{
															#line 325 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
							candidates.push_back(si->getEndpoint().token.first());
															#line 1420 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
						}
						else
						{
															#line 326 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
							if (requiredReplicas == ALL_REPLICAS)
															#line 1426 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
							{
															#line 327 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
								TraceEvent(SevWarnAlways, "UnreachableStorageServer").detail("SSID", ssTeam->getInterface(i).id());
															#line 328 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
								return a_body1Catch1(unreachable_storage_replica(), loopDepth);
															#line 1432 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
							}
						}
					}
															#line 331 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					int numReplicaToRead = candidates.size();
															#line 332 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					if (requiredReplicas != BEST_EFFORT && requiredReplicas != ALL_REPLICAS)
															#line 1440 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					{
															#line 333 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						ASSERT(requiredReplicas > 0);
															#line 334 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						numReplicaToRead = std::min((int)candidates.size(), requiredReplicas);
															#line 335 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						if (FLOW_KNOBS->ENABLE_WARNING_READ_CONSISTENCY_CHECK_NOT_ENOUGH_REPLICA && candidates.size() < requiredReplicas)
															#line 1448 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
						{
															#line 337 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
							TraceEvent(SevWarn, "ReplicaConsistencyCheckNotEnoughReplica") .suppressFor(5.0) .detail("RequiredReplicas", requiredReplicas) .detail("AvailableReplicas", candidates.size());
															#line 1452 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
						}
					}
															#line 343 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					restOfTeamFutures = std::vector<Future<Optional<ErrorOr<Resp>>>>();
															#line 344 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					restOfTeamFutures.reserve(numReplicaToRead);
															#line 346 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					deterministicRandom()->randomShuffle(candidates);
															#line 347 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					candidates.erase(candidates.begin() + numReplicaToRead, candidates.end());
															#line 348 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					std::unordered_set<uint64_t> ssToRead(candidates.begin(), candidates.end());
															#line 350 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					for(int i = 0;i < ssTeam->size();i++) {
															#line 351 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						RequestStream<Req, P> const* si = &ssTeam->get(i, channel);
															#line 352 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						if (!ssToRead.contains(si->getEndpoint().token.first()))
															#line 1471 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
						{
							continue;
						}
															#line 356 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						resetReply(req);
															#line 357 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						restOfTeamFutures.push_back( (requiredReplicas == BEST_EFFORT ? timeout(si->tryGetReply(req), FLOW_KNOBS->LOAD_BALANCE_FETCH_REPLICA_TIMEOUT) : timeout(errorOr(si->getReply(req)), FLOW_KNOBS->LOAD_BALANCE_FETCH_REPLICA_TIMEOUT)));
															#line 1479 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					}
															#line 363 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					StrictFuture<Void> __when_expr_1 = waitForAllReady(restOfTeamFutures);
															#line 363 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					if (static_cast<ReplicaComparisonActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1485 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
					static_cast<ReplicaComparisonActor*>(this)->actor_wait_state = 2;
															#line 363 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReplicaComparisonActor, 1, Void >*>(static_cast<ReplicaComparisonActor*>(this)));
															#line 1490 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont9(loopDepth);
				}
			}
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 300 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (src.isError())
															#line 1506 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 301 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			ASSERT_WE_THINK(false);
															#line 302 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (requiredReplicas == ALL_REPLICAS)
															#line 1512 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 303 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				return a_body1Catch1(src.getError(), loopDepth);
															#line 1516 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			}
			loopDepth = a_body1cont3(loopDepth);
		}
		else
		{
															#line 306 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			srcLB = getLoadBalancedReply(&src.get());
															#line 308 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (srcLB.present() && srcLB.get().error.present())
															#line 1526 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 309 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				ASSERT_WE_THINK(false);
															#line 310 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				if (requiredReplicas == ALL_REPLICAS)
															#line 1532 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				{
															#line 311 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					return a_body1Catch1(srcLB.get().error.get(), loopDepth);
															#line 1536 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				}
				loopDepth = a_body1cont6(loopDepth);
			}
			else
			{
															#line 313 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				if (!srcLB.present() || !srcLB.get().error.present())
															#line 1544 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				{
															#line 315 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					std::vector<uint64_t> candidates;
															#line 318 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					for(int i = 0;i < ssTeam->size();i++) {
															#line 319 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						RequestStream<Req, P> const* si = &ssTeam->get(i, channel);
															#line 320 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						if (si->getEndpoint().token.first() == srcEndpointId)
															#line 1554 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
						{
							continue;
						}
															#line 324 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						if (!IFailureMonitor::failureMonitor().getState(si->getEndpoint()).failed)
															#line 1560 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
						{
															#line 325 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
							candidates.push_back(si->getEndpoint().token.first());
															#line 1564 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
						}
						else
						{
															#line 326 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
							if (requiredReplicas == ALL_REPLICAS)
															#line 1570 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
							{
															#line 327 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
								TraceEvent(SevWarnAlways, "UnreachableStorageServer").detail("SSID", ssTeam->getInterface(i).id());
															#line 328 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
								return a_body1Catch1(unreachable_storage_replica(), loopDepth);
															#line 1576 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
							}
						}
					}
															#line 331 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					int numReplicaToRead = candidates.size();
															#line 332 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					if (requiredReplicas != BEST_EFFORT && requiredReplicas != ALL_REPLICAS)
															#line 1584 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					{
															#line 333 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						ASSERT(requiredReplicas > 0);
															#line 334 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						numReplicaToRead = std::min((int)candidates.size(), requiredReplicas);
															#line 335 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						if (FLOW_KNOBS->ENABLE_WARNING_READ_CONSISTENCY_CHECK_NOT_ENOUGH_REPLICA && candidates.size() < requiredReplicas)
															#line 1592 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
						{
															#line 337 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
							TraceEvent(SevWarn, "ReplicaConsistencyCheckNotEnoughReplica") .suppressFor(5.0) .detail("RequiredReplicas", requiredReplicas) .detail("AvailableReplicas", candidates.size());
															#line 1596 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
						}
					}
															#line 343 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					restOfTeamFutures = std::vector<Future<Optional<ErrorOr<Resp>>>>();
															#line 344 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					restOfTeamFutures.reserve(numReplicaToRead);
															#line 346 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					deterministicRandom()->randomShuffle(candidates);
															#line 347 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					candidates.erase(candidates.begin() + numReplicaToRead, candidates.end());
															#line 348 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					std::unordered_set<uint64_t> ssToRead(candidates.begin(), candidates.end());
															#line 350 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					for(int i = 0;i < ssTeam->size();i++) {
															#line 351 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						RequestStream<Req, P> const* si = &ssTeam->get(i, channel);
															#line 352 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						if (!ssToRead.contains(si->getEndpoint().token.first()))
															#line 1615 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
						{
							continue;
						}
															#line 356 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						resetReply(req);
															#line 357 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						restOfTeamFutures.push_back( (requiredReplicas == BEST_EFFORT ? timeout(si->tryGetReply(req), FLOW_KNOBS->LOAD_BALANCE_FETCH_REPLICA_TIMEOUT) : timeout(errorOr(si->getReply(req)), FLOW_KNOBS->LOAD_BALANCE_FETCH_REPLICA_TIMEOUT)));
															#line 1623 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					}
															#line 363 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					StrictFuture<Void> __when_expr_1 = waitForAllReady(restOfTeamFutures);
															#line 363 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					if (static_cast<ReplicaComparisonActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1629 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
					static_cast<ReplicaComparisonActor*>(this)->actor_wait_state = 2;
															#line 363 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReplicaComparisonActor, 1, Void >*>(static_cast<ReplicaComparisonActor*>(this)));
															#line 1634 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont9(loopDepth);
				}
			}
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReplicaComparisonActor*>(this)->actor_wait_state > 0) static_cast<ReplicaComparisonActor*>(this)->actor_wait_state = 0;
		static_cast<ReplicaComparisonActor*>(this)->ActorCallback< ReplicaComparisonActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReplicaComparisonActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("replicaComparison", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReplicaComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("replicaComparison", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReplicaComparisonActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("replicaComparison", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReplicaComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("replicaComparison", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReplicaComparisonActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("replicaComparison", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReplicaComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("replicaComparison", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 446 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (!static_cast<ReplicaComparisonActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReplicaComparisonActorState(); static_cast<ReplicaComparisonActor*>(this)->destroy(); return 0; }
															#line 1725 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		new (&static_cast<ReplicaComparisonActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ReplicaComparisonActorState();
		static_cast<ReplicaComparisonActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont9(int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont10(Void const& _,int loopDepth) 
	{
															#line 365 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		int numError = 0;
															#line 366 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		int numMismatch = 0;
															#line 367 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		int numFetchReplicaTimeout = 0;
															#line 368 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		int replicaErrorCode = error_code_success;
															#line 369 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		int successfulReplies = 0;
															#line 370 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		for( Future<Optional<ErrorOr<Resp>>> f : restOfTeamFutures ) {
															#line 371 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (!f.isReady())
															#line 1761 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 372 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				ASSERT(requiredReplicas > 0);
															#line 1765 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				continue;
			}
															#line 375 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (f.isError())
															#line 1770 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 376 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				numError++;
															#line 377 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				replicaErrorCode = f.getError().code();
															#line 1776 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			}
			else
			{
															#line 378 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				if (!f.get().present())
															#line 1782 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				{
															#line 379 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					numFetchReplicaTimeout++;
															#line 380 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					replicaErrorCode = error_code_timed_out;
															#line 1788 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				}
				else
				{
															#line 381 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					if (f.get().get().isError())
															#line 1794 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					{
															#line 382 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						numError++;
															#line 383 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						replicaErrorCode = f.get().get().getError().code();
															#line 1800 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					}
					else
					{
															#line 385 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						Optional<LoadBalancedReply> fLB = getLoadBalancedReply(&f.get().get().get());
															#line 387 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						ASSERT(srcLB.present() == fLB.present());
															#line 390 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						if (fLB.present())
															#line 1810 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
						{
															#line 391 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
							if (fLB.get().error.present())
															#line 1814 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
							{
															#line 392 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
								numError++;
															#line 393 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
								replicaErrorCode = fLB.get().error.get().code();
															#line 1820 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
							}
							else
							{
															#line 395 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
								if (!TSS_doCompare( src.get(), f.get().get().get()))
															#line 1826 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
								{
															#line 398 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
									numMismatch++;
															#line 399 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
									TraceEvent mismatchEvent( (requiredReplicas == BEST_EFFORT || requiredReplicas == ALL_REPLICAS) ? SevError : SevWarnAlways, LB_mismatchTraceName(req, REPLICA_COMPARISON));
															#line 404 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
									mismatchEvent.detail("ReplicaFetchErrors", numError) .detail("ReplicaFetchTimeouts", numFetchReplicaTimeout);
															#line 407 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
									TSS_traceMismatch( mismatchEvent, req, src.get(), f.get().get().get(), REPLICA_COMPARISON);
															#line 1836 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
								}
															#line 410 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
								if (++successfulReplies == requiredReplicas)
															#line 1840 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
								{
									break;
								}
							}
						}
					}
				}
			}
															#line 419 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (replicaErrorCode == error_code_wrong_shard_server)
															#line 1851 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 420 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				TraceEvent(SevWarnAlways, "ReplicaComparisonReadError") .suppressFor(1.0) .detail("TeamSize", restOfTeamFutures.size() + 1) .detail("RequiredReplies", requiredReplicas) .detail("SSError", error_code_wrong_shard_server);
															#line 425 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				return a_body1Catch1(wrong_shard_server(), loopDepth);
															#line 1857 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			}
		}
															#line 429 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (numMismatch)
															#line 1862 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 430 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			return a_body1Catch1(storage_replica_comparison_error(), loopDepth);
															#line 1866 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		}
		else
		{
															#line 431 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (((numError || numFetchReplicaTimeout) && (requiredReplicas == ALL_REPLICAS)) || (successfulReplies != requiredReplicas && requiredReplicas > 0 && restOfTeamFutures.size() >= requiredReplicas))
															#line 1872 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 434 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				const char* type = numError ? "ReplicaComparisonReadError" : "ReplicaComparisonTimeoutError";
															#line 435 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				TraceEvent(SevWarnAlways, type) .detail("TeamSize", restOfTeamFutures.size() + 1) .detail("RequiredReplies", requiredReplicas) .detail("SuccessfulReplies", successfulReplies) .detail("SSError", replicaErrorCode);
															#line 441 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				return a_body1Catch1(Error((requiredReplicas == ALL_REPLICAS) ? replicaErrorCode : error_code_unreachable_storage_replica), loopDepth);
															#line 1880 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			}
		}
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont10(Void && _,int loopDepth) 
	{
															#line 365 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		int numError = 0;
															#line 366 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		int numMismatch = 0;
															#line 367 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		int numFetchReplicaTimeout = 0;
															#line 368 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		int replicaErrorCode = error_code_success;
															#line 369 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		int successfulReplies = 0;
															#line 370 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		for( Future<Optional<ErrorOr<Resp>>> f : restOfTeamFutures ) {
															#line 371 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (!f.isReady())
															#line 1903 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 372 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				ASSERT(requiredReplicas > 0);
															#line 1907 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				continue;
			}
															#line 375 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (f.isError())
															#line 1912 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 376 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				numError++;
															#line 377 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				replicaErrorCode = f.getError().code();
															#line 1918 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			}
			else
			{
															#line 378 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				if (!f.get().present())
															#line 1924 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				{
															#line 379 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					numFetchReplicaTimeout++;
															#line 380 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					replicaErrorCode = error_code_timed_out;
															#line 1930 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				}
				else
				{
															#line 381 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					if (f.get().get().isError())
															#line 1936 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					{
															#line 382 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						numError++;
															#line 383 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						replicaErrorCode = f.get().get().getError().code();
															#line 1942 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					}
					else
					{
															#line 385 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						Optional<LoadBalancedReply> fLB = getLoadBalancedReply(&f.get().get().get());
															#line 387 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						ASSERT(srcLB.present() == fLB.present());
															#line 390 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						if (fLB.present())
															#line 1952 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
						{
															#line 391 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
							if (fLB.get().error.present())
															#line 1956 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
							{
															#line 392 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
								numError++;
															#line 393 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
								replicaErrorCode = fLB.get().error.get().code();
															#line 1962 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
							}
							else
							{
															#line 395 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
								if (!TSS_doCompare( src.get(), f.get().get().get()))
															#line 1968 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
								{
															#line 398 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
									numMismatch++;
															#line 399 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
									TraceEvent mismatchEvent( (requiredReplicas == BEST_EFFORT || requiredReplicas == ALL_REPLICAS) ? SevError : SevWarnAlways, LB_mismatchTraceName(req, REPLICA_COMPARISON));
															#line 404 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
									mismatchEvent.detail("ReplicaFetchErrors", numError) .detail("ReplicaFetchTimeouts", numFetchReplicaTimeout);
															#line 407 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
									TSS_traceMismatch( mismatchEvent, req, src.get(), f.get().get().get(), REPLICA_COMPARISON);
															#line 1978 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
								}
															#line 410 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
								if (++successfulReplies == requiredReplicas)
															#line 1982 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
								{
									break;
								}
							}
						}
					}
				}
			}
															#line 419 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (replicaErrorCode == error_code_wrong_shard_server)
															#line 1993 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 420 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				TraceEvent(SevWarnAlways, "ReplicaComparisonReadError") .suppressFor(1.0) .detail("TeamSize", restOfTeamFutures.size() + 1) .detail("RequiredReplies", requiredReplicas) .detail("SSError", error_code_wrong_shard_server);
															#line 425 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				return a_body1Catch1(wrong_shard_server(), loopDepth);
															#line 1999 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			}
		}
															#line 429 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (numMismatch)
															#line 2004 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 430 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			return a_body1Catch1(storage_replica_comparison_error(), loopDepth);
															#line 2008 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		}
		else
		{
															#line 431 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (((numError || numFetchReplicaTimeout) && (requiredReplicas == ALL_REPLICAS)) || (successfulReplies != requiredReplicas && requiredReplicas > 0 && restOfTeamFutures.size() >= requiredReplicas))
															#line 2014 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 434 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				const char* type = numError ? "ReplicaComparisonReadError" : "ReplicaComparisonTimeoutError";
															#line 435 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				TraceEvent(SevWarnAlways, type) .detail("TeamSize", restOfTeamFutures.size() + 1) .detail("RequiredReplies", requiredReplicas) .detail("SuccessfulReplies", successfulReplies) .detail("SSError", replicaErrorCode);
															#line 441 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				return a_body1Catch1(Error((requiredReplicas == ALL_REPLICAS) ? replicaErrorCode : error_code_unreachable_storage_replica), loopDepth);
															#line 2022 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			}
		}
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReplicaComparisonActor*>(this)->actor_wait_state > 0) static_cast<ReplicaComparisonActor*>(this)->actor_wait_state = 0;
		static_cast<ReplicaComparisonActor*>(this)->ActorCallback< ReplicaComparisonActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReplicaComparisonActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("replicaComparison", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReplicaComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("replicaComparison", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReplicaComparisonActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("replicaComparison", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReplicaComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("replicaComparison", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReplicaComparisonActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("replicaComparison", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReplicaComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("replicaComparison", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 285 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	Req req;
															#line 285 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	Future<ErrorOr<Resp>> fSource;
															#line 285 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	uint64_t srcEndpointId;
															#line 285 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	Reference<MultiInterface<Multi>> ssTeam;
															#line 285 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	RequestStream<Req, P> Interface::* channel;
															#line 285 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	int requiredReplicas;
															#line 292 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	ErrorOr<Resp> src;
															#line 306 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	Optional<LoadBalancedReply> srcLB;
															#line 343 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	std::vector<Future<Optional<ErrorOr<Resp>>>> restOfTeamFutures;
															#line 2122 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
};
// This generated class is to be used only via replicaComparison()
															#line 285 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
template <class Req, class Resp, class Interface, class Multi, bool P>
															#line 285 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
class ReplicaComparisonActor final : public Actor<Void>, public ActorCallback< ReplicaComparisonActor<Req, Resp, Interface, Multi, P>, 0, Void >, public ActorCallback< ReplicaComparisonActor<Req, Resp, Interface, Multi, P>, 1, Void >, public FastAllocated<ReplicaComparisonActor<Req, Resp, Interface, Multi, P>>, public ReplicaComparisonActorState<Req, Resp, Interface, Multi, P, ReplicaComparisonActor<Req, Resp, Interface, Multi, P>> {
															#line 2129 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
public:
	using FastAllocated<ReplicaComparisonActor<Req, Resp, Interface, Multi, P>>::operator new;
	using FastAllocated<ReplicaComparisonActor<Req, Resp, Interface, Multi, P>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11947963019331035136UL, 5205368488276739328UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReplicaComparisonActor<Req, Resp, Interface, Multi, P>, 0, Void >;
friend struct ActorCallback< ReplicaComparisonActor<Req, Resp, Interface, Multi, P>, 1, Void >;
															#line 285 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	ReplicaComparisonActor(Req const& req,Future<ErrorOr<Resp>> const& fSource,uint64_t const& srcEndpointId,Reference<MultiInterface<Multi>> const& ssTeam,RequestStream<Req, P> Interface::* const& channel,int const& requiredReplicas) 
															#line 2147 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		 : Actor<Void>(),
		   ReplicaComparisonActorState<Req, Resp, Interface, Multi, P, ReplicaComparisonActor<Req, Resp, Interface, Multi, P>>(req, fSource, srcEndpointId, ssTeam, channel, requiredReplicas),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("replicaComparison", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1852103863548525312UL, 15097773629334850048UL);
		ActorExecutionContextHelper __helper(static_cast<ReplicaComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("replicaComparison");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("replicaComparison", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReplicaComparisonActor<Req, Resp, Interface, Multi, P>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReplicaComparisonActor<Req, Resp, Interface, Multi, P>, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 285 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
template <class Req, class Resp, class Interface, class Multi, bool P>
															#line 285 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
[[nodiscard]] Future<Void> replicaComparison( Req const& req, Future<ErrorOr<Resp>> const& fSource, uint64_t const& srcEndpointId, Reference<MultiInterface<Multi>> const& ssTeam, RequestStream<Req, P> Interface::* const& channel, int const& requiredReplicas ) {
															#line 285 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	return Future<Void>(new ReplicaComparisonActor<Req, Resp, Interface, Multi, P>(req, fSource, srcEndpointId, ssTeam, channel, requiredReplicas));
															#line 2183 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
}

#line 448 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"

FDB_BOOLEAN_PARAM(AtMostOnce);
FDB_BOOLEAN_PARAM(TriedAllOptions);

// Stores state for a request made by the load balancer
template <class Request, class Interface, class Multi, bool P>
struct RequestData : NonCopyable {
	typedef ErrorOr<REPLY_TYPE(Request)> Reply;

	Future<Reply> response;
	Reference<ModelHolder> modelHolder;
	TriedAllOptions triedAllOptions{ false };
	RequestStream<Request, P> const* requestStream = nullptr;

	bool requestStarted = false; // true once the request has been sent to an alternative
	bool requestProcessed = false; // true once a response has been received and handled by checkAndProcessResult

	bool compareReplicas = false;
	Future<Void> comparisonResult;

	RequestData(bool compareReplicas = false) : compareReplicas(compareReplicas) {}

	// Whether or not the response future is valid
	// This is true once setupRequest is called, even though at that point the response is Never().
	bool isValid() { return response.isValid(); }

	static void maybeDuplicateTSSRequest(RequestStream<Request, P> const* stream,
	                                     Request& request,
	                                     QueueModel* model,
	                                     Future<Reply> ssResponse,
	                                     Reference<MultiInterface<Multi>> alternatives,
	                                     RequestStream<Request, P> Interface::* channel) {
		if (model) {
			// Send parallel request to TSS pair, if it exists
			Optional<TSSEndpointData> tssData = model->getTssData(stream->getEndpoint().token.first());

			if (tssData.present()) {
				CODE_PROBE(true, "duplicating request to TSS");
				resetReply(request);
				// FIXME: optimize to avoid creating new netNotifiedQueue for each message
				RequestStream<Request, P> tssRequestStream(tssData.get().endpoint);
				Future<ErrorOr<REPLY_TYPE(Request)>> fTssResult = tssRequestStream.tryGetReply(request);
				model->addActor.send(tssComparison(request,
				                                   ssResponse,
				                                   fTssResult,
				                                   tssData.get(),
				                                   stream->getEndpoint().token.first(),
				                                   alternatives,
				                                   channel));
			}
		}
	}

	Future<Void> maybeDoReplicaComparison(Request& request,
	                                      QueueModel* model,
	                                      Reference<MultiInterface<Multi>> alternatives,
	                                      RequestStream<Request, P> Interface::* channel,
	                                      int requiredReplicas) {
		if (model && (compareReplicas || FLOW_KNOBS->ENABLE_REPLICA_CONSISTENCY_CHECK_ON_READS)) {
			ASSERT(requestStream != nullptr);
			if (compareReplicas) {
				// In case compareReplicas == true, we may read extra requiredReplicas replica.
				// The value of compareReplicas is decided by the caller and the knobs.
				// If the caller is fetchKeys, when ENABLE_REPLICA_CONSISTENCY_CHECK_ON_DATA_MOVEMENT is on,
				// the value is DATAMOVE_CONSISTENCY_CHECK_REQUIRED_REPLICAS.
				// If the caller is backup agents, when ENABLE_REPLICA_CONSISTENCY_CHECK_ON_BACKUP_READS is on,
				// the value is BACKUP_CONSISTENCY_CHECK_REQUIRED_REPLICAS.
				// Otherwise, the value is 0.
				return replicaComparison(request,
				                         response,
				                         requestStream->getEndpoint().token.first(),
				                         alternatives,
				                         channel,
				                         requiredReplicas);
			}
			// In case ENABLE_REPLICA_CONSISTENCY_CHECK_ON_READS is on, we read extra
			// READ_CONSISTENCY_CHECK_REQUIRED_REPLICAS replica and conduct consistency
			// check among replica for any read request.
			return replicaComparison(request,
			                         response,
			                         requestStream->getEndpoint().token.first(),
			                         alternatives,
			                         channel,
			                         FLOW_KNOBS->READ_CONSISTENCY_CHECK_REQUIRED_REPLICAS);
		}
		return Void();
	}

	// Initializes the request state and starts it, possibly after a backoff delay
	void startRequest(
	    double backoff,
	    TriedAllOptions triedAllOptions,
	    RequestStream<Request, P> const* stream,
	    Request& request,
	    QueueModel* model,
	    Reference<MultiInterface<Multi>> alternatives, // alternatives and channel passed through for TSS check
	    RequestStream<Request, P> Interface::* channel) {
		modelHolder = Reference<ModelHolder>();
		requestStream = stream;
		requestStarted = false;

		if (backoff > 0) {
			response = mapAsync(delay(backoff), [this, stream, &request, model, alternatives, channel](Void _) {
				requestStarted = true;
				modelHolder = Reference<ModelHolder>(new ModelHolder(model, stream->getEndpoint().token.first()));
				Future<Reply> resp = stream->tryGetReply(request);
				maybeDuplicateTSSRequest(stream, request, model, resp, alternatives, channel);
				return resp;
			});
		} else {
			requestStarted = true;
			modelHolder = Reference<ModelHolder>(new ModelHolder(model, stream->getEndpoint().token.first()));
			response = stream->tryGetReply(request);
			maybeDuplicateTSSRequest(stream, request, model, response, alternatives, channel);
		}

		requestProcessed = false;
		this->triedAllOptions = triedAllOptions;
	}

	// Implementation of the logic to handle a response.
	// Checks the state of the response, updates the queue model, and returns one of the following outcomes:
	// A return value of true means that the request completed successfully
	// A return value of false means that the request failed but should be retried
	// A return value with an error means that the error should be thrown back to original caller
	static ErrorOr<bool> checkAndProcessResultImpl(Reply const& result,
	                                               Reference<ModelHolder> modelHolder,
	                                               AtMostOnce atMostOnce,
	                                               TriedAllOptions triedAllOptions) {
		ASSERT(modelHolder);

		Optional<LoadBalancedReply> loadBalancedReply;
		if (!result.isError()) {
			loadBalancedReply = getLoadBalancedReply(&result.get());
		}

		int errCode;
		if (loadBalancedReply.present()) {
			errCode = loadBalancedReply.get().error.present() ? loadBalancedReply.get().error.get().code()
			                                                  : error_code_success;
		} else {
			errCode = result.isError() ? result.getError().code() : error_code_success;
		}

		bool maybeDelivered = errCode == error_code_broken_promise || errCode == error_code_request_maybe_delivered;
		bool receivedResponse =
		    loadBalancedReply.present() ? !loadBalancedReply.get().error.present() : result.present();
		receivedResponse = receivedResponse || (!maybeDelivered && errCode != error_code_process_behind);
		bool futureVersion = errCode == error_code_future_version || errCode == error_code_process_behind;

		modelHolder->release(
		    receivedResponse, futureVersion, loadBalancedReply.present() ? loadBalancedReply.get().penalty : -1.0);

		if (errCode == error_code_server_overloaded) {
			return false;
		}

		if (loadBalancedReply.present() && !loadBalancedReply.get().error.present()) {
			return true;
		}

		if (!loadBalancedReply.present() && result.present()) {
			return true;
		}

		if (receivedResponse) {
			return loadBalancedReply.present() ? loadBalancedReply.get().error.get() : result.getError();
		}

		if (atMostOnce && maybeDelivered) {
			return request_maybe_delivered();
		}

		if (triedAllOptions && errCode == error_code_process_behind) {
			return process_behind();
		}

		return false;
	}

	// Checks the state of the response, updates the queue model, and returns one of the following outcomes:
	// A return value of true means that the request completed successfully
	// A return value of false means that the request failed but should be retried
	// In the event of a non-retryable failure, an error is thrown indicating the failure
	bool checkAndProcessResult(AtMostOnce atMostOnce) {
		ASSERT(response.isReady());
		requestProcessed = true;

		ErrorOr<bool> outcome =
		    checkAndProcessResultImpl(response.get(), std::move(modelHolder), atMostOnce, triedAllOptions);

		if (outcome.isError()) {
			throw outcome.getError();
		} else if (!outcome.get()) {
			response = Future<Reply>();
		}

		return outcome.get();
	}

	// Convert this request to a lagging request. Such a request is no longer being waited on, but it still needs to be
	// processed so we can update the queue model.
	void makeLaggingRequest() {
		ASSERT(response.isValid());
		ASSERT(modelHolder);
		ASSERT(modelHolder->model);

		QueueModel* model = modelHolder->model;
		if (model->laggingRequestCount > FLOW_KNOBS->MAX_LAGGING_REQUESTS_OUTSTANDING ||
		    model->laggingRequests.isReady()) {
			model->laggingRequests.cancel();
			model->laggingRequestCount = 0;
			model->addActor = PromiseStream<Future<Void>>();
			model->laggingRequests = actorCollection(model->addActor.getFuture(), &model->laggingRequestCount);
		}

		// We need to process the lagging request in order to update the queue model
		Reference<ModelHolder> holderCapture = std::move(modelHolder);
		auto triedAllOptionsCapture = triedAllOptions;
		Future<Void> updateModel = map(response, [holderCapture, triedAllOptionsCapture](Reply result) {
			checkAndProcessResultImpl(result, holderCapture, AtMostOnce::False, triedAllOptionsCapture);
			return Void();
		});
		model->addActor.send(updateModel);
	}

	~RequestData() {
		// If the request has been started but hasn't completed, mark it as a lagging request
		if (requestStarted && !requestProcessed && modelHolder && modelHolder->model) {
			makeLaggingRequest();
		}
	}
};

// Try to get a reply from one of the alternatives until success, cancellation, or certain errors.
// Load balancing has a budget to race requests to a second alternative if the first request is slow.
// Tries to take into account failMon's information for load balancing and avoiding failed servers.
// If ALL the servers are failed and the list of servers is not fresh, throws an exception to let the caller refresh the
// list of servers.
// When model is set, load balance among alternatives in the same DC aims to balance request queue length on these
// interfaces. If too many interfaces in the same DC are bad, try remote interfaces.
// If compareReplicas is set, does a consistency check by fetching and comparing results from storage
// replicas (as many as specified by "requiredReplicas") and throws an exception if an inconsistency is found.
// FIXME: reformat this minus the long inline comment about one parameter, so that the indentation of
// the parameters is more to the right and not confusingly lined up with the code of this function.
															#line 2432 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
namespace {
// This generated class is to be used only via loadBalance()
															#line 693 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
template <class Interface, class Request, class Multi, bool P, class LoadBalanceActor>
															#line 693 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
class LoadBalanceActorState {
															#line 2439 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
public:
															#line 693 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	LoadBalanceActorState(Reference<MultiInterface<Multi>> const& alternatives,RequestStream<Request, P> Interface::* const& channel,Request const& request = Request(),TaskPriority const& taskID = TaskPriority::DefaultPromiseEndpoint,AtMostOnce const& atMostOnce = AtMostOnce::False,QueueModel* const& model = nullptr,bool const& compareReplicas = false,int const& requiredReplicas = 0) 
															#line 693 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
															#line 693 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		 : alternatives(alternatives),
															#line 693 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   channel(channel),
															#line 693 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   request(request),
															#line 693 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   taskID(taskID),
															#line 693 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   atMostOnce(atMostOnce),
															#line 693 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   model(model),
															#line 693 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   compareReplicas(compareReplicas),
															#line 693 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   requiredReplicas(requiredReplicas),
															#line 705 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   firstRequestData(compareReplicas),
															#line 706 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   secondRequestData(compareReplicas),
															#line 708 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   firstRequestEndpoint(),
															#line 709 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   secondDelay(Never()),
															#line 711 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   requestFinished(),
															#line 712 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   startTime(now()),
															#line 714 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   triedAllOptions(TriedAllOptions::False)
															#line 2474 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
	{
		fdb_probe_actor_create("loadBalance", reinterpret_cast<unsigned long>(this));

	}
	~LoadBalanceActorState() 
	{
		fdb_probe_actor_destroy("loadBalance", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 716 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			setReplyPriority(request, taskID);
															#line 717 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (!alternatives)
															#line 2491 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 718 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				this->~LoadBalanceActorState();
															#line 2495 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				static_cast<LoadBalanceActor*>(this)->sendAndDelPromiseRef(Never());
				return 0;
			}
															#line 720 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			ASSERT(alternatives->size());
															#line 722 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			bestAlt = deterministicRandom()->randomInt(0, alternatives->countBest());
															#line 723 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			nextAlt = deterministicRandom()->randomInt(0, std::max(alternatives->size() - 1, 1));
															#line 724 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (nextAlt >= bestAlt)
															#line 2507 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 725 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				nextAlt++;
															#line 2511 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			}
															#line 727 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (model)
															#line 2515 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 728 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				double bestMetric = 1e9;
															#line 729 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				double nextMetric = 1e9;
															#line 730 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				double bestTime = 1e9;
															#line 731 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				double nextTime = 1e9;
															#line 732 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				int badServers = 0;
															#line 734 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				for(int i = 0;i < alternatives->size();i++) {
															#line 737 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					if (badServers < std::min(i, FLOW_KNOBS->LOAD_BALANCE_MAX_BAD_OPTIONS + 1) && i == alternatives->countBest())
															#line 2531 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					{
						break;
					}
					else
					{
															#line 743 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						if (badServers == alternatives->countBest() && i == badServers)
															#line 2539 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
						{
															#line 744 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
							TraceEvent("AllLocalAlternativesFailed") .suppressFor(1.0) .detail("Alternatives", alternatives->description()) .detail("Total", alternatives->size()) .detail("Best", alternatives->countBest());
															#line 2543 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
						}
					}
															#line 751 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					RequestStream<Request, P> const* thisStream = &alternatives->get(i, channel);
															#line 752 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					if (!IFailureMonitor::failureMonitor().getState(thisStream->getEndpoint()).failed)
															#line 2550 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					{
															#line 753 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						auto const& qd = model->getMeasurement(thisStream->getEndpoint().token.first());
															#line 754 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						if (now() > qd.failedUntil)
															#line 2556 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
						{
															#line 755 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
							double thisMetric = qd.smoothOutstanding.smoothTotal();
															#line 756 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
							double thisTime = qd.latency;
															#line 757 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
							if (FLOW_KNOBS->LOAD_BALANCE_PENALTY_IS_BAD && qd.penalty > 1.001)
															#line 2564 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
							{
															#line 761 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
								++badServers;
															#line 2568 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
							}
															#line 764 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
							if (thisMetric < bestMetric)
															#line 2572 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
							{
															#line 765 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
								if (i != bestAlt)
															#line 2576 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
								{
															#line 766 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
									nextAlt = bestAlt;
															#line 767 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
									nextMetric = bestMetric;
															#line 768 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
									nextTime = bestTime;
															#line 2584 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
								}
															#line 770 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
								bestAlt = i;
															#line 771 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
								bestMetric = thisMetric;
															#line 772 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
								bestTime = thisTime;
															#line 2592 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
							}
							else
							{
															#line 773 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
								if (thisMetric < nextMetric)
															#line 2598 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
								{
															#line 774 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
									nextAlt = i;
															#line 775 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
									nextMetric = thisMetric;
															#line 776 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
									nextTime = thisTime;
															#line 2606 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
								}
							}
						}
						else
						{
															#line 779 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
							++badServers;
															#line 2614 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
						}
					}
					else
					{
															#line 782 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						++badServers;
															#line 2621 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					}
				}
															#line 785 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				if (nextMetric > 1e8)
															#line 2626 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				{
															#line 789 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					for(int i = alternatives->countBest();i < alternatives->size();i++) {
															#line 790 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						RequestStream<Request, P> const* thisStream = &alternatives->get(i, channel);
															#line 791 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						if (!IFailureMonitor::failureMonitor().getState(thisStream->getEndpoint()).failed)
															#line 2634 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
						{
															#line 792 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
							auto const& qd = model->getMeasurement(thisStream->getEndpoint().token.first());
															#line 793 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
							if (now() > qd.failedUntil)
															#line 2640 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
							{
															#line 794 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
								double thisMetric = qd.smoothOutstanding.smoothTotal();
															#line 795 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
								double thisTime = qd.latency;
															#line 797 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
								if (thisMetric < nextMetric)
															#line 2648 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
								{
															#line 798 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
									nextAlt = i;
															#line 799 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
									nextMetric = thisMetric;
															#line 800 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
									nextTime = thisTime;
															#line 2656 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
								}
							}
						}
					}
				}
															#line 807 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				if (nextTime < 1e9)
															#line 2664 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				{
															#line 809 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					if (bestTime > FLOW_KNOBS->INSTANT_SECOND_REQUEST_MULTIPLIER * (model->secondMultiplier * (nextTime) + FLOW_KNOBS->BASE_SECOND_REQUEST_TIME))
															#line 2668 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					{
															#line 811 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						secondDelay = Void();
															#line 2672 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					}
					else
					{
															#line 813 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						secondDelay = delay(model->secondMultiplier * nextTime + FLOW_KNOBS->BASE_SECOND_REQUEST_TIME);
															#line 2678 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					}
				}
				else
				{
															#line 816 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					secondDelay = Never();
															#line 2685 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				}
			}
															#line 820 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			startAlt = nextAlt;
															#line 821 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			startDistance = (bestAlt + alternatives->size() - startAlt) % alternatives->size();
															#line 823 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			numAttempts = 0;
															#line 824 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			backoff = 0;
															#line 826 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			;
															#line 2698 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LoadBalanceActorState();
		static_cast<LoadBalanceActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 827 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (now() - startTime > (g_network->isSimulated() ? 30.0 : 600.0))
															#line 2728 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 828 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			TraceEvent ev(g_network->isSimulated() ? SevWarn : SevWarnAlways, "LoadBalanceTooLong");
															#line 829 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			ev.suppressFor(1.0);
															#line 830 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			ev.detail("Duration", now() - startTime);
															#line 831 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			ev.detail("NumAttempts", numAttempts);
															#line 832 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			ev.detail("Backoff", backoff);
															#line 833 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			ev.detail("TriedAllOptions", triedAllOptions);
															#line 834 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (ev.isEnabled())
															#line 2744 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 835 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				ev.log();
															#line 836 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				for(int alternativeNum = 0;alternativeNum < alternatives->size();alternativeNum++) {
															#line 837 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					RequestStream<Request, P> const* thisStream = &alternatives->get(alternativeNum, channel);
															#line 838 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					TraceEvent(SevWarn, "LoadBalanceTooLongEndpoint") .detail("Addr", thisStream->getEndpoint().getPrimaryAddress()) .detail("Token", thisStream->getEndpoint().token) .detail("Failed", IFailureMonitor::failureMonitor().getState(thisStream->getEndpoint()).failed);
															#line 2754 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				}
			}
		}
															#line 849 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		stream = nullptr;
															#line 850 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		distance = LBDistance::Type();
															#line 851 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		for(int alternativeNum = 0;alternativeNum < alternatives->size();alternativeNum++) {
															#line 852 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			int useAlt = nextAlt;
															#line 853 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (nextAlt == startAlt)
															#line 2768 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 854 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				useAlt = bestAlt;
															#line 2772 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			}
			else
			{
															#line 855 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				if ((nextAlt + alternatives->size() - startAlt) % alternatives->size() <= startDistance)
															#line 2778 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				{
															#line 856 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					useAlt = (nextAlt + alternatives->size() - 1) % alternatives->size();
															#line 2782 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				}
			}
															#line 858 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			stream = &alternatives->get(useAlt, channel);
															#line 859 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			distance = alternatives->getDistance(useAlt);
															#line 860 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (!IFailureMonitor::failureMonitor().getState(stream->getEndpoint()).failed && (!firstRequestEndpoint.present() || stream->getEndpoint().token.first() != firstRequestEndpoint.get()))
															#line 2791 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
				break;
			}
															#line 863 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			nextAlt = (nextAlt + 1) % alternatives->size();
															#line 864 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (nextAlt == startAlt)
															#line 2799 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 865 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				triedAllOptions = TriedAllOptions::True;
															#line 2803 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			}
															#line 866 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			stream = nullptr;
															#line 867 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			distance = LBDistance::DISTANT;
															#line 2809 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		}
															#line 870 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (!stream && !firstRequestData.isValid())
															#line 2813 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 873 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			std::vector<Future<Void>> ok(alternatives->size());
															#line 874 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			for(int i = 0;i < ok.size();i++) {
															#line 875 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				ok[i] = IFailureMonitor::failureMonitor().onStateEqual(alternatives->get(i, channel).getEndpoint(), FailureStatus(false));
															#line 2821 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			}
															#line 879 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			Future<Void> okFuture = quorum(ok, 1);
															#line 881 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (!alternatives->alwaysFresh())
															#line 2827 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 883 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				if (now() - g_network->networkInfo.newestAlternativesFailure > 1 || deterministicRandom()->random01() < 0.01)
															#line 2831 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				{
															#line 885 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					TraceEvent("AllAlternativesFailed").detail("Alternatives", alternatives->description());
															#line 2835 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				}
															#line 887 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				StrictFuture<Void> __when_expr_0 = allAlternativesFailedDelay(okFuture);
															#line 887 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				if (static_cast<LoadBalanceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2841 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
				static_cast<LoadBalanceActor*>(this)->actor_wait_state = 1;
															#line 887 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LoadBalanceActor, 0, Void >*>(static_cast<LoadBalanceActor*>(this)));
															#line 2846 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				loopDepth = 0;
			}
			else
			{
															#line 889 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				StrictFuture<Void> __when_expr_1 = okFuture;
															#line 889 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				if (static_cast<LoadBalanceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2855 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
				static_cast<LoadBalanceActor*>(this)->actor_wait_state = 2;
															#line 889 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LoadBalanceActor, 1, Void >*>(static_cast<LoadBalanceActor*>(this)));
															#line 2860 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				loopDepth = 0;
			}
		}
		else
		{
															#line 893 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (!stream)
															#line 2868 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 895 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				StrictFuture<Void> __when_expr_2 = success(firstRequestData.response);
															#line 895 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				if (static_cast<LoadBalanceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2874 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when3(__when_expr_2.get(), loopDepth); };
				static_cast<LoadBalanceActor*>(this)->actor_wait_state = 3;
															#line 895 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< LoadBalanceActor, 2, Void >*>(static_cast<LoadBalanceActor*>(this)));
															#line 2879 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				loopDepth = 0;
			}
			else
			{
															#line 906 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				if (firstRequestData.isValid())
															#line 2886 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				{
															#line 908 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					if (distance == LBDistance::DISTANT)
															#line 2890 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					{
															#line 909 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						TraceEvent("LBDistant2nd") .suppressFor(0.1) .detail("Distance", (int)distance) .detail("BackOff", backoff) .detail("TriedAllOptions", triedAllOptions) .detail("Alternatives", alternatives->description()) .detail("Token", stream->getEndpoint().token) .detail("Total", alternatives->size()) .detail("Best", alternatives->countBest()) .detail("Attempts", numAttempts);
															#line 2894 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					}
															#line 920 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					secondRequestData.startRequest(backoff, triedAllOptions, stream, request, model, alternatives, channel);
															#line 922 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					firstRequestSuccessful = false;
															#line 923 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					secondRequestSuccessful = false;
															#line 925 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					;
															#line 2904 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					loopDepth = a_body1loopBody1loopHead1(loopDepth);
				}
				else
				{
															#line 960 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					if (distance == LBDistance::DISTANT)
															#line 2911 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					{
															#line 961 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						TraceEvent("LBDistant") .suppressFor(0.1) .detail("Distance", (int)distance) .detail("BackOff", backoff) .detail("TriedAllOptions", triedAllOptions) .detail("Alternatives", alternatives->description()) .detail("Token", stream->getEndpoint().token) .detail("Total", alternatives->size()) .detail("Best", alternatives->countBest()) .detail("Attempts", numAttempts);
															#line 2915 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					}
															#line 972 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					firstRequestData.startRequest(backoff, triedAllOptions, stream, request, model, alternatives, channel);
															#line 973 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					firstRequestEndpoint = stream->getEndpoint().token.first();
															#line 975 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					;
															#line 2923 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					loopDepth = a_body1loopBody1loopHead2(loopDepth);
				}
			}
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 1016 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		nextAlt = (nextAlt + 1) % alternatives->size();
															#line 1017 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (nextAlt == startAlt)
															#line 2937 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 1018 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			triedAllOptions = TriedAllOptions::True;
															#line 2941 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		}
															#line 1019 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		resetReply(request, taskID);
															#line 1020 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		secondDelay = Never();
															#line 2947 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont11(int loopDepth) 
	{
															#line 892 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		numAttempts = 0;
															#line 2956 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont13(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont13(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont13(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont13(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LoadBalanceActor*>(this)->actor_wait_state > 0) static_cast<LoadBalanceActor*>(this)->actor_wait_state = 0;
		static_cast<LoadBalanceActor*>(this)->ActorCallback< LoadBalanceActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadBalanceActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LoadBalanceActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LoadBalanceActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont15(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont15(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont15(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont15(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<LoadBalanceActor*>(this)->actor_wait_state > 0) static_cast<LoadBalanceActor*>(this)->actor_wait_state = 0;
		static_cast<LoadBalanceActor*>(this)->ActorCallback< LoadBalanceActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadBalanceActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< LoadBalanceActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< LoadBalanceActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont16(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont17(Void const& _,int loopDepth) 
	{
															#line 896 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (firstRequestData.checkAndProcessResult(atMostOnce))
															#line 3145 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 898 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			StrictFuture<Void> __when_expr_3 = firstRequestData.maybeDoReplicaComparison(request, model, alternatives, channel, requiredReplicas);
															#line 898 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (static_cast<LoadBalanceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3151 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont17when1(__when_expr_3.get(), loopDepth); };
			static_cast<LoadBalanceActor*>(this)->actor_wait_state = 4;
															#line 898 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< LoadBalanceActor, 3, Void >*>(static_cast<LoadBalanceActor*>(this)));
															#line 3156 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont17cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont17(Void && _,int loopDepth) 
	{
															#line 896 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (firstRequestData.checkAndProcessResult(atMostOnce))
															#line 3170 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 898 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			StrictFuture<Void> __when_expr_3 = firstRequestData.maybeDoReplicaComparison(request, model, alternatives, channel, requiredReplicas);
															#line 898 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (static_cast<LoadBalanceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3176 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont17when1(__when_expr_3.get(), loopDepth); };
			static_cast<LoadBalanceActor*>(this)->actor_wait_state = 4;
															#line 898 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< LoadBalanceActor, 3, Void >*>(static_cast<LoadBalanceActor*>(this)));
															#line 3181 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont17cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont17(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont17(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<LoadBalanceActor*>(this)->actor_wait_state > 0) static_cast<LoadBalanceActor*>(this)->actor_wait_state = 0;
		static_cast<LoadBalanceActor*>(this)->ActorCallback< LoadBalanceActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadBalanceActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< LoadBalanceActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< LoadBalanceActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont17cont1(int loopDepth) 
	{
															#line 905 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		firstRequestEndpoint = Optional<uint64_t>();
															#line 3270 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		loopDepth = a_body1loopBody1cont16(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont17cont2(Void const& _,int loopDepth) 
	{
															#line 901 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		ASSERT(firstRequestData.response.isReady());
															#line 902 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (!static_cast<LoadBalanceActor*>(this)->SAV<REPLY_TYPE(Request)>::futures) { (void)(firstRequestData.response.get().get()); this->~LoadBalanceActorState(); static_cast<LoadBalanceActor*>(this)->destroy(); return 0; }
															#line 3281 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		new (&static_cast<LoadBalanceActor*>(this)->SAV< REPLY_TYPE(Request) >::value()) REPLY_TYPE(Request)(firstRequestData.response.get().get());
		this->~LoadBalanceActorState();
		static_cast<LoadBalanceActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont17cont2(Void && _,int loopDepth) 
	{
															#line 901 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		ASSERT(firstRequestData.response.isReady());
															#line 902 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (!static_cast<LoadBalanceActor*>(this)->SAV<REPLY_TYPE(Request)>::futures) { (void)(firstRequestData.response.get().get()); this->~LoadBalanceActorState(); static_cast<LoadBalanceActor*>(this)->destroy(); return 0; }
															#line 3295 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		new (&static_cast<LoadBalanceActor*>(this)->SAV< REPLY_TYPE(Request) >::value()) REPLY_TYPE(Request)(firstRequestData.response.get().get());
		this->~LoadBalanceActorState();
		static_cast<LoadBalanceActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont17when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont17cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont17when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont17cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<LoadBalanceActor*>(this)->actor_wait_state > 0) static_cast<LoadBalanceActor*>(this)->actor_wait_state = 0;
		static_cast<LoadBalanceActor*>(this)->ActorCallback< LoadBalanceActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadBalanceActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont17when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< LoadBalanceActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont17when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< LoadBalanceActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont18(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont16(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont19(int loopDepth) 
	{
															#line 943 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (firstRequestSuccessful || secondRequestSuccessful)
															#line 3388 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 945 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			requestData = firstRequestSuccessful ? &firstRequestData : &secondRequestData;
															#line 947 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			StrictFuture<Void> __when_expr_6 = requestData->maybeDoReplicaComparison(request, model, alternatives, channel, requiredReplicas);
															#line 947 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (static_cast<LoadBalanceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3396 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont19when1(__when_expr_6.get(), loopDepth); };
			static_cast<LoadBalanceActor*>(this)->actor_wait_state = 6;
															#line 947 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< LoadBalanceActor, 6, Void >*>(static_cast<LoadBalanceActor*>(this)));
															#line 3401 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont19cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 926 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		StrictFuture<Void> __when_expr_4 = success(firstRequestData.response.isValid() ? firstRequestData.response : Never());
															#line 925 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (static_cast<LoadBalanceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 3424 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1when1(__when_expr_4.get(), loopDepth); };
															#line 934 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		StrictFuture<Void> __when_expr_5 = success(secondRequestData.response);
															#line 3428 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1when2(__when_expr_5.get(), loopDepth); };
		static_cast<LoadBalanceActor*>(this)->actor_wait_state = 5;
															#line 926 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< LoadBalanceActor, 4, Void >*>(static_cast<LoadBalanceActor*>(this)));
															#line 934 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< LoadBalanceActor, 5, Void >*>(static_cast<LoadBalanceActor*>(this)));
															#line 3435 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont19(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 927 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (firstRequestData.checkAndProcessResult(atMostOnce))
															#line 3463 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 928 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			firstRequestSuccessful = true;
															#line 3467 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 932 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		firstRequestEndpoint = Optional<uint64_t>();
															#line 3472 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 927 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (firstRequestData.checkAndProcessResult(atMostOnce))
															#line 3481 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 928 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			firstRequestSuccessful = true;
															#line 3485 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 932 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		firstRequestEndpoint = Optional<uint64_t>();
															#line 3490 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 935 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (secondRequestData.checkAndProcessResult(atMostOnce))
															#line 3499 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 936 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			secondRequestSuccessful = true;
															#line 3503 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		}
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 935 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (secondRequestData.checkAndProcessResult(atMostOnce))
															#line 3513 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 936 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			secondRequestSuccessful = true;
															#line 3517 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		}
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<LoadBalanceActor*>(this)->actor_wait_state > 0) static_cast<LoadBalanceActor*>(this)->actor_wait_state = 0;
		static_cast<LoadBalanceActor*>(this)->ActorCallback< LoadBalanceActor, 4, Void >::remove();
		static_cast<LoadBalanceActor*>(this)->ActorCallback< LoadBalanceActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadBalanceActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< LoadBalanceActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< LoadBalanceActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< LoadBalanceActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< LoadBalanceActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< LoadBalanceActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1cont19cont1(int loopDepth) 
	{
															#line 953 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (++numAttempts >= alternatives->size())
															#line 3648 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 954 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			backoff = std::min( FLOW_KNOBS->LOAD_BALANCE_MAX_BACKOFF, std::max(FLOW_KNOBS->LOAD_BALANCE_START_BACKOFF, backoff * FLOW_KNOBS->LOAD_BALANCE_BACKOFF_RATE));
															#line 3652 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		}
		loopDepth = a_body1loopBody1cont18(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont19cont2(Void const& _,int loopDepth) 
	{
															#line 949 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		ASSERT(requestData->response.isReady());
															#line 950 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (!static_cast<LoadBalanceActor*>(this)->SAV<REPLY_TYPE(Request)>::futures) { (void)(requestData->response.get().get()); this->~LoadBalanceActorState(); static_cast<LoadBalanceActor*>(this)->destroy(); return 0; }
															#line 3664 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		new (&static_cast<LoadBalanceActor*>(this)->SAV< REPLY_TYPE(Request) >::value()) REPLY_TYPE(Request)(requestData->response.get().get());
		this->~LoadBalanceActorState();
		static_cast<LoadBalanceActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont19cont2(Void && _,int loopDepth) 
	{
															#line 949 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		ASSERT(requestData->response.isReady());
															#line 950 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (!static_cast<LoadBalanceActor*>(this)->SAV<REPLY_TYPE(Request)>::futures) { (void)(requestData->response.get().get()); this->~LoadBalanceActorState(); static_cast<LoadBalanceActor*>(this)->destroy(); return 0; }
															#line 3678 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		new (&static_cast<LoadBalanceActor*>(this)->SAV< REPLY_TYPE(Request) >::value()) REPLY_TYPE(Request)(requestData->response.get().get());
		this->~LoadBalanceActorState();
		static_cast<LoadBalanceActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont19when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont19cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont19when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont19cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<LoadBalanceActor*>(this)->actor_wait_state > 0) static_cast<LoadBalanceActor*>(this)->actor_wait_state = 0;
		static_cast<LoadBalanceActor*>(this)->ActorCallback< LoadBalanceActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadBalanceActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont19when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< LoadBalanceActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont19when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< LoadBalanceActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1loopBody1cont21(int loopDepth) 
	{
															#line 1009 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (++numAttempts >= alternatives->size())
															#line 3765 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 1010 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			backoff = std::min( FLOW_KNOBS->LOAD_BALANCE_MAX_BACKOFF, std::max(FLOW_KNOBS->LOAD_BALANCE_START_BACKOFF, backoff * FLOW_KNOBS->LOAD_BALANCE_BACKOFF_RATE));
															#line 3769 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		}
		loopDepth = a_body1loopBody1cont18(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopHead2(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody2(int loopDepth) 
	{
															#line 977 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		StrictFuture<Void> __when_expr_7 = success(firstRequestData.response);
															#line 976 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (static_cast<LoadBalanceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 3788 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody2when1(__when_expr_7.get(), loopDepth); };
															#line 998 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		StrictFuture<Void> __when_expr_8 = secondDelay;
															#line 3792 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody2when2(__when_expr_8.get(), loopDepth); };
		static_cast<LoadBalanceActor*>(this)->actor_wait_state = 7;
															#line 977 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< LoadBalanceActor, 7, Void >*>(static_cast<LoadBalanceActor*>(this)));
															#line 998 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< LoadBalanceActor, 8, Void >*>(static_cast<LoadBalanceActor*>(this)));
															#line 3799 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1break2(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont21(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody2cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead2(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody2when1(Void const& _,int loopDepth) 
	{
															#line 978 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (model)
															#line 3827 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 979 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			model->secondMultiplier = std::max(model->secondMultiplier - FLOW_KNOBS->SECOND_REQUEST_MULTIPLIER_DECAY, 1.0);
															#line 981 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			model->secondBudget = std::min(model->secondBudget + FLOW_KNOBS->SECOND_REQUEST_BUDGET_GROWTH, FLOW_KNOBS->SECOND_REQUEST_MAX_BUDGET);
															#line 3833 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		}
															#line 986 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (firstRequestData.checkAndProcessResult(atMostOnce))
															#line 3837 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 988 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			StrictFuture<Void> __when_expr_9 = firstRequestData.maybeDoReplicaComparison( request, model, alternatives, channel, requiredReplicas);
															#line 988 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (static_cast<LoadBalanceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 3843 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody2when1when1(__when_expr_9.get(), loopDepth); };
			static_cast<LoadBalanceActor*>(this)->actor_wait_state = 8;
															#line 988 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< LoadBalanceActor, 9, Void >*>(static_cast<LoadBalanceActor*>(this)));
															#line 3848 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1loopBody2when1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody2when1(Void && _,int loopDepth) 
	{
															#line 978 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (model)
															#line 3862 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 979 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			model->secondMultiplier = std::max(model->secondMultiplier - FLOW_KNOBS->SECOND_REQUEST_MULTIPLIER_DECAY, 1.0);
															#line 981 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			model->secondBudget = std::min(model->secondBudget + FLOW_KNOBS->SECOND_REQUEST_BUDGET_GROWTH, FLOW_KNOBS->SECOND_REQUEST_MAX_BUDGET);
															#line 3868 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		}
															#line 986 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (firstRequestData.checkAndProcessResult(atMostOnce))
															#line 3872 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 988 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			StrictFuture<Void> __when_expr_9 = firstRequestData.maybeDoReplicaComparison( request, model, alternatives, channel, requiredReplicas);
															#line 988 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (static_cast<LoadBalanceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 3878 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody2when1when1(__when_expr_9.get(), loopDepth); };
			static_cast<LoadBalanceActor*>(this)->actor_wait_state = 8;
															#line 988 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< LoadBalanceActor, 9, Void >*>(static_cast<LoadBalanceActor*>(this)));
															#line 3883 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1loopBody2when1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody2when2(Void const& _,int loopDepth) 
	{
															#line 999 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		secondDelay = Never();
															#line 1000 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (model && model->secondBudget >= 1.0)
															#line 3899 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 1001 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			model->secondMultiplier += FLOW_KNOBS->SECOND_REQUEST_MULTIPLIER_GROWTH;
															#line 1002 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			model->secondBudget -= 1.0;
															#line 3905 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			return a_body1loopBody1break2(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1loopBody2cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody2when2(Void && _,int loopDepth) 
	{
															#line 999 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		secondDelay = Never();
															#line 1000 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (model && model->secondBudget >= 1.0)
															#line 3918 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 1001 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			model->secondMultiplier += FLOW_KNOBS->SECOND_REQUEST_MULTIPLIER_GROWTH;
															#line 1002 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			model->secondBudget -= 1.0;
															#line 3924 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			return a_body1loopBody1break2(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1loopBody2cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<LoadBalanceActor*>(this)->actor_wait_state > 0) static_cast<LoadBalanceActor*>(this)->actor_wait_state = 0;
		static_cast<LoadBalanceActor*>(this)->ActorCallback< LoadBalanceActor, 7, Void >::remove();
		static_cast<LoadBalanceActor*>(this)->ActorCallback< LoadBalanceActor, 8, Void >::remove();

	}
	int a_body1loopBody1loopBody2when1cont1(int loopDepth) 
	{
															#line 995 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		firstRequestEndpoint = Optional<uint64_t>();
															#line 3942 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		return a_body1loopBody1break2(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody2when1cont3(Void const& _,int loopDepth) 
	{
															#line 991 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		ASSERT(firstRequestData.response.isReady());
															#line 992 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (!static_cast<LoadBalanceActor*>(this)->SAV<REPLY_TYPE(Request)>::futures) { (void)(firstRequestData.response.get().get()); this->~LoadBalanceActorState(); static_cast<LoadBalanceActor*>(this)->destroy(); return 0; }
															#line 3953 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		new (&static_cast<LoadBalanceActor*>(this)->SAV< REPLY_TYPE(Request) >::value()) REPLY_TYPE(Request)(firstRequestData.response.get().get());
		this->~LoadBalanceActorState();
		static_cast<LoadBalanceActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody2when1cont3(Void && _,int loopDepth) 
	{
															#line 991 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		ASSERT(firstRequestData.response.isReady());
															#line 992 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (!static_cast<LoadBalanceActor*>(this)->SAV<REPLY_TYPE(Request)>::futures) { (void)(firstRequestData.response.get().get()); this->~LoadBalanceActorState(); static_cast<LoadBalanceActor*>(this)->destroy(); return 0; }
															#line 3967 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		new (&static_cast<LoadBalanceActor*>(this)->SAV< REPLY_TYPE(Request) >::value()) REPLY_TYPE(Request)(firstRequestData.response.get().get());
		this->~LoadBalanceActorState();
		static_cast<LoadBalanceActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody2when1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody2when1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody2when1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody2when1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<LoadBalanceActor*>(this)->actor_wait_state > 0) static_cast<LoadBalanceActor*>(this)->actor_wait_state = 0;
		static_cast<LoadBalanceActor*>(this)->ActorCallback< LoadBalanceActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadBalanceActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1loopBody2when1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< LoadBalanceActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1loopBody2when1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< LoadBalanceActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< LoadBalanceActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1loopBody2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< LoadBalanceActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1loopBody2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< LoadBalanceActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< LoadBalanceActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1loopBody2when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< LoadBalanceActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1loopBody2when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< LoadBalanceActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 8);

	}
															#line 693 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	Reference<MultiInterface<Multi>> alternatives;
															#line 693 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	RequestStream<Request, P> Interface::* channel;
															#line 693 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	Request request;
															#line 693 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	TaskPriority taskID;
															#line 693 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	AtMostOnce atMostOnce;
															#line 693 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	QueueModel* model;
															#line 693 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	bool compareReplicas;
															#line 693 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	int requiredReplicas;
															#line 705 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	RequestData<Request, Interface, Multi, P> firstRequestData;
															#line 706 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	RequestData<Request, Interface, Multi, P> secondRequestData;
															#line 708 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	Optional<uint64_t> firstRequestEndpoint;
															#line 709 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	Future<Void> secondDelay;
															#line 711 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	Promise<Void> requestFinished;
															#line 712 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	double startTime;
															#line 714 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	TriedAllOptions triedAllOptions;
															#line 722 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	int bestAlt;
															#line 723 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	int nextAlt;
															#line 820 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	int startAlt;
															#line 821 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	int startDistance;
															#line 823 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	int numAttempts;
															#line 824 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	double backoff;
															#line 849 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	RequestStream<Request, P> const* stream;
															#line 850 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	LBDistance::Type distance;
															#line 922 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	bool firstRequestSuccessful;
															#line 923 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	bool secondRequestSuccessful;
															#line 945 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	RequestData<Request, Interface, Multi, P>* requestData;
															#line 4216 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
};
// This generated class is to be used only via loadBalance()
															#line 693 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
template <class Interface, class Request, class Multi, bool P>
															#line 693 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
class LoadBalanceActor final : public Actor<REPLY_TYPE(Request)>, public ActorCallback< LoadBalanceActor<Interface, Request, Multi, P>, 0, Void >, public ActorCallback< LoadBalanceActor<Interface, Request, Multi, P>, 1, Void >, public ActorCallback< LoadBalanceActor<Interface, Request, Multi, P>, 2, Void >, public ActorCallback< LoadBalanceActor<Interface, Request, Multi, P>, 3, Void >, public ActorCallback< LoadBalanceActor<Interface, Request, Multi, P>, 4, Void >, public ActorCallback< LoadBalanceActor<Interface, Request, Multi, P>, 5, Void >, public ActorCallback< LoadBalanceActor<Interface, Request, Multi, P>, 6, Void >, public ActorCallback< LoadBalanceActor<Interface, Request, Multi, P>, 7, Void >, public ActorCallback< LoadBalanceActor<Interface, Request, Multi, P>, 9, Void >, public ActorCallback< LoadBalanceActor<Interface, Request, Multi, P>, 8, Void >, public FastAllocated<LoadBalanceActor<Interface, Request, Multi, P>>, public LoadBalanceActorState<Interface, Request, Multi, P, LoadBalanceActor<Interface, Request, Multi, P>> {
															#line 4223 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
public:
	using FastAllocated<LoadBalanceActor<Interface, Request, Multi, P>>::operator new;
	using FastAllocated<LoadBalanceActor<Interface, Request, Multi, P>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11595064932442208512UL, 1988016229884056576UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<REPLY_TYPE(Request)>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LoadBalanceActor<Interface, Request, Multi, P>, 0, Void >;
friend struct ActorCallback< LoadBalanceActor<Interface, Request, Multi, P>, 1, Void >;
friend struct ActorCallback< LoadBalanceActor<Interface, Request, Multi, P>, 2, Void >;
friend struct ActorCallback< LoadBalanceActor<Interface, Request, Multi, P>, 3, Void >;
friend struct ActorCallback< LoadBalanceActor<Interface, Request, Multi, P>, 4, Void >;
friend struct ActorCallback< LoadBalanceActor<Interface, Request, Multi, P>, 5, Void >;
friend struct ActorCallback< LoadBalanceActor<Interface, Request, Multi, P>, 6, Void >;
friend struct ActorCallback< LoadBalanceActor<Interface, Request, Multi, P>, 7, Void >;
friend struct ActorCallback< LoadBalanceActor<Interface, Request, Multi, P>, 9, Void >;
friend struct ActorCallback< LoadBalanceActor<Interface, Request, Multi, P>, 8, Void >;
															#line 693 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	LoadBalanceActor(Reference<MultiInterface<Multi>> const& alternatives,RequestStream<Request, P> Interface::* const& channel,Request const& request = Request(),TaskPriority const& taskID = TaskPriority::DefaultPromiseEndpoint,AtMostOnce const& atMostOnce = AtMostOnce::False,QueueModel* const& model = nullptr,bool const& compareReplicas = false,int const& requiredReplicas = 0) 
															#line 4249 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		 : Actor<REPLY_TYPE(Request)>(),
		   LoadBalanceActorState<Interface, Request, Multi, P, LoadBalanceActor<Interface, Request, Multi, P>>(alternatives, channel, request, taskID, atMostOnce, model, compareReplicas, requiredReplicas),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12051063900488922880UL, 14234974990573568000UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("loadBalance");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LoadBalanceActor<Interface, Request, Multi, P>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< LoadBalanceActor<Interface, Request, Multi, P>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< LoadBalanceActor<Interface, Request, Multi, P>, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< LoadBalanceActor<Interface, Request, Multi, P>, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< LoadBalanceActor<Interface, Request, Multi, P>, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< LoadBalanceActor<Interface, Request, Multi, P>, 6, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< LoadBalanceActor<Interface, Request, Multi, P>, 7, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< LoadBalanceActor<Interface, Request, Multi, P>, 9, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 693 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
template <class Interface, class Request, class Multi, bool P>
															#line 693 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
[[nodiscard]] Future<REPLY_TYPE(Request)> loadBalance( Reference<MultiInterface<Multi>> const& alternatives, RequestStream<Request, P> Interface::* const& channel, Request const& request = Request(), TaskPriority const& taskID = TaskPriority::DefaultPromiseEndpoint, AtMostOnce const& atMostOnce = AtMostOnce::False, QueueModel* const& model = nullptr, bool const& compareReplicas = false, int const& requiredReplicas = 0 ) {
															#line 693 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	return Future<REPLY_TYPE(Request)>(new LoadBalanceActor<Interface, Request, Multi, P>(alternatives, channel, request, taskID, atMostOnce, model, compareReplicas, requiredReplicas));
															#line 4291 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
}

#line 1023 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"

// Subclasses must initialize all members in their default constructors
// Subclasses must serialize all members
struct BasicLoadBalancedReply {
	int processBusyTime;
	BasicLoadBalancedReply() : processBusyTime(0) {}
};

Optional<BasicLoadBalancedReply> getBasicLoadBalancedReply(const BasicLoadBalancedReply* reply);
Optional<BasicLoadBalancedReply> getBasicLoadBalancedReply(const void*);

// A simpler version of LoadBalance that does not send second requests where the list of servers are always fresh
//
// If |alternativeChosen| is not null, then atMostOnce must be True, and if the returned future completes successfully
// then *alternativeChosen will be the alternative to which the message was sent. *alternativeChosen must outlive the
// returned future.
															#line 4311 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
namespace {
// This generated class is to be used only via basicLoadBalance()
															#line 1039 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
template <class Interface, class Request, class Multi, bool P, class BasicLoadBalanceActor>
															#line 1039 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
class BasicLoadBalanceActorState {
															#line 4318 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
public:
															#line 1039 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	BasicLoadBalanceActorState(Reference<ModelInterface<Multi>> const& alternatives,RequestStream<Request, P> Interface::* const& channel,Request const& request = Request(),TaskPriority const& taskID = TaskPriority::DefaultPromiseEndpoint,AtMostOnce const& atMostOnce = AtMostOnce::False,int* const& alternativeChosen = nullptr) 
															#line 1039 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
															#line 1039 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		 : alternatives(alternatives),
															#line 1039 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   channel(channel),
															#line 1039 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   request(request),
															#line 1039 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   taskID(taskID),
															#line 1039 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   atMostOnce(atMostOnce),
															#line 1039 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   alternativeChosen(alternativeChosen)
															#line 4335 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
	{
		fdb_probe_actor_create("basicLoadBalance", reinterpret_cast<unsigned long>(this));

	}
	~BasicLoadBalanceActorState() 
	{
		fdb_probe_actor_destroy("basicLoadBalance", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1046 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			ASSERT(alternativeChosen == nullptr || atMostOnce == AtMostOnce::True);
															#line 1047 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			setReplyPriority(request, taskID);
															#line 1048 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (!alternatives)
															#line 4354 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 1049 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				this->~BasicLoadBalanceActorState();
															#line 4358 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				static_cast<BasicLoadBalanceActor*>(this)->sendAndDelPromiseRef(Never());
				return 0;
			}
															#line 1051 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			ASSERT(alternatives->size() && alternatives->alwaysFresh());
															#line 1053 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			bestAlt = alternatives->getBest();
															#line 1054 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			nextAlt = deterministicRandom()->randomInt(0, std::max(alternatives->size() - 1, 1));
															#line 1055 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (nextAlt >= bestAlt)
															#line 4370 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 1056 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				nextAlt++;
															#line 4374 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			}
															#line 1058 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			startAlt = nextAlt;
															#line 1059 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			startDistance = (bestAlt + alternatives->size() - startAlt) % alternatives->size();
															#line 1061 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			numAttempts = 0;
															#line 1062 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			backoff = 0;
															#line 1063 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			useAlt = int();
															#line 1064 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			;
															#line 4388 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BasicLoadBalanceActorState();
		static_cast<BasicLoadBalanceActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1066 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		stream = nullptr;
															#line 1067 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		for(int alternativeNum = 0;alternativeNum < alternatives->size();alternativeNum++) {
															#line 1068 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			useAlt = nextAlt;
															#line 1069 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (nextAlt == startAlt)
															#line 4424 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 1070 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				useAlt = bestAlt;
															#line 4428 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			}
			else
			{
															#line 1071 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				if ((nextAlt + alternatives->size() - startAlt) % alternatives->size() <= startDistance)
															#line 4434 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				{
															#line 1072 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					useAlt = (nextAlt + alternatives->size() - 1) % alternatives->size();
															#line 4438 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				}
			}
															#line 1074 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			stream = &alternatives->get(useAlt, channel);
															#line 1075 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (alternativeChosen != nullptr)
															#line 4445 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 1076 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				*alternativeChosen = useAlt;
															#line 4449 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			}
															#line 1078 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (!IFailureMonitor::failureMonitor().getState(stream->getEndpoint()).failed)
															#line 4453 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
				break;
			}
															#line 1080 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			nextAlt = (nextAlt + 1) % alternatives->size();
															#line 1081 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			stream = nullptr;
															#line 4461 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		}
															#line 1084 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (!stream)
															#line 4465 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 1087 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			std::vector<Future<Void>> ok(alternatives->size());
															#line 1088 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			for(int i = 0;i < ok.size();i++) {
															#line 1089 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				ok[i] = IFailureMonitor::failureMonitor().onStateEqual(alternatives->get(i, channel).getEndpoint(), FailureStatus(false));
															#line 4473 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			}
															#line 1092 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			StrictFuture<Void> __when_expr_0 = quorum(ok, 1);
															#line 1092 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (static_cast<BasicLoadBalanceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4479 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<BasicLoadBalanceActor*>(this)->actor_wait_state = 1;
															#line 1092 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BasicLoadBalanceActor, 0, Void >*>(static_cast<BasicLoadBalanceActor*>(this)));
															#line 4484 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			loopDepth = 0;
		}
		else
		{
															#line 1096 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (backoff > 0.0)
															#line 4491 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 1097 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				StrictFuture<Void> __when_expr_1 = delay(backoff);
															#line 1097 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				if (static_cast<BasicLoadBalanceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4497 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
				static_cast<BasicLoadBalanceActor*>(this)->actor_wait_state = 2;
															#line 1097 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< BasicLoadBalanceActor, 1, Void >*>(static_cast<BasicLoadBalanceActor*>(this)));
															#line 4502 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1cont11(loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 1127 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		nextAlt = (nextAlt + 1) % alternatives->size();
															#line 1128 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		resetReply(request, taskID);
															#line 4519 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void const& _,int loopDepth) 
	{
															#line 1094 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		numAttempts = 0;
															#line 4528 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void && _,int loopDepth) 
	{
															#line 1094 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		numAttempts = 0;
															#line 4537 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BasicLoadBalanceActor*>(this)->actor_wait_state > 0) static_cast<BasicLoadBalanceActor*>(this)->actor_wait_state = 0;
		static_cast<BasicLoadBalanceActor*>(this)->ActorCallback< BasicLoadBalanceActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BasicLoadBalanceActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("basicLoadBalance", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BasicLoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("basicLoadBalance", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BasicLoadBalanceActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("basicLoadBalance", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BasicLoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("basicLoadBalance", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BasicLoadBalanceActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("basicLoadBalance", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BasicLoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("basicLoadBalance", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont11(int loopDepth) 
	{
															#line 1100 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		StrictFuture<ErrorOr<REPLY_TYPE(Request)>> __when_expr_2 = stream->tryGetReply(request);
															#line 1100 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (static_cast<BasicLoadBalanceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4623 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont11when1(__when_expr_2.get(), loopDepth); };
		static_cast<BasicLoadBalanceActor*>(this)->actor_wait_state = 3;
															#line 1100 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< BasicLoadBalanceActor, 2, ErrorOr<REPLY_TYPE(Request)> >*>(static_cast<BasicLoadBalanceActor*>(this)));
															#line 4628 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont12(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont12(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<BasicLoadBalanceActor*>(this)->actor_wait_state > 0) static_cast<BasicLoadBalanceActor*>(this)->actor_wait_state = 0;
		static_cast<BasicLoadBalanceActor*>(this)->ActorCallback< BasicLoadBalanceActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BasicLoadBalanceActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("basicLoadBalance", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BasicLoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("basicLoadBalance", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< BasicLoadBalanceActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("basicLoadBalance", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BasicLoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("basicLoadBalance", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< BasicLoadBalanceActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("basicLoadBalance", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BasicLoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("basicLoadBalance", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont11cont1(ErrorOr<REPLY_TYPE(Request)> const& result,int loopDepth) 
	{
															#line 1102 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (result.present())
															#line 4724 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 1103 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			Optional<BasicLoadBalancedReply> loadBalancedReply = getBasicLoadBalancedReply(&result.get());
															#line 1104 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (loadBalancedReply.present())
															#line 4730 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 1105 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				alternatives->updateRecent(useAlt, loadBalancedReply.get().processBusyTime);
															#line 4734 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			}
															#line 1108 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (!static_cast<BasicLoadBalanceActor*>(this)->SAV<REPLY_TYPE(Request)>::futures) { (void)(result.get()); this->~BasicLoadBalanceActorState(); static_cast<BasicLoadBalanceActor*>(this)->destroy(); return 0; }
															#line 4738 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			new (&static_cast<BasicLoadBalanceActor*>(this)->SAV< REPLY_TYPE(Request) >::value()) REPLY_TYPE(Request)(result.get());
			this->~BasicLoadBalanceActorState();
			static_cast<BasicLoadBalanceActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1111 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (result.getError().code() != error_code_broken_promise && result.getError().code() != error_code_request_maybe_delivered)
															#line 4746 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 1113 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			return a_body1Catch1(result.getError(), std::max(0, loopDepth - 1));
															#line 4750 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		}
															#line 1116 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (atMostOnce)
															#line 4754 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 1117 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			return a_body1Catch1(request_maybe_delivered(), std::max(0, loopDepth - 1));
															#line 4758 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		}
															#line 1120 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (++numAttempts >= alternatives->size())
															#line 4762 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 1121 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			backoff = std::min( FLOW_KNOBS->LOAD_BALANCE_MAX_BACKOFF, std::max(FLOW_KNOBS->LOAD_BALANCE_START_BACKOFF, backoff * FLOW_KNOBS->LOAD_BALANCE_BACKOFF_RATE));
															#line 4766 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont11cont1(ErrorOr<REPLY_TYPE(Request)> && result,int loopDepth) 
	{
															#line 1102 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (result.present())
															#line 4776 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 1103 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			Optional<BasicLoadBalancedReply> loadBalancedReply = getBasicLoadBalancedReply(&result.get());
															#line 1104 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (loadBalancedReply.present())
															#line 4782 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 1105 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				alternatives->updateRecent(useAlt, loadBalancedReply.get().processBusyTime);
															#line 4786 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			}
															#line 1108 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (!static_cast<BasicLoadBalanceActor*>(this)->SAV<REPLY_TYPE(Request)>::futures) { (void)(result.get()); this->~BasicLoadBalanceActorState(); static_cast<BasicLoadBalanceActor*>(this)->destroy(); return 0; }
															#line 4790 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			new (&static_cast<BasicLoadBalanceActor*>(this)->SAV< REPLY_TYPE(Request) >::value()) REPLY_TYPE(Request)(result.get());
			this->~BasicLoadBalanceActorState();
			static_cast<BasicLoadBalanceActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1111 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (result.getError().code() != error_code_broken_promise && result.getError().code() != error_code_request_maybe_delivered)
															#line 4798 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 1113 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			return a_body1Catch1(result.getError(), std::max(0, loopDepth - 1));
															#line 4802 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		}
															#line 1116 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (atMostOnce)
															#line 4806 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 1117 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			return a_body1Catch1(request_maybe_delivered(), std::max(0, loopDepth - 1));
															#line 4810 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		}
															#line 1120 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (++numAttempts >= alternatives->size())
															#line 4814 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 1121 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			backoff = std::min( FLOW_KNOBS->LOAD_BALANCE_MAX_BACKOFF, std::max(FLOW_KNOBS->LOAD_BALANCE_START_BACKOFF, backoff * FLOW_KNOBS->LOAD_BALANCE_BACKOFF_RATE));
															#line 4818 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont11when1(ErrorOr<REPLY_TYPE(Request)> const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11cont1(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont11when1(ErrorOr<REPLY_TYPE(Request)> && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11cont1(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<BasicLoadBalanceActor*>(this)->actor_wait_state > 0) static_cast<BasicLoadBalanceActor*>(this)->actor_wait_state = 0;
		static_cast<BasicLoadBalanceActor*>(this)->ActorCallback< BasicLoadBalanceActor, 2, ErrorOr<REPLY_TYPE(Request)> >::remove();

	}
	void a_callback_fire(ActorCallback< BasicLoadBalanceActor, 2, ErrorOr<REPLY_TYPE(Request)> >*,ErrorOr<REPLY_TYPE(Request)> const& value) 
	{
		fdb_probe_actor_enter("basicLoadBalance", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BasicLoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("basicLoadBalance", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< BasicLoadBalanceActor, 2, ErrorOr<REPLY_TYPE(Request)> >*,ErrorOr<REPLY_TYPE(Request)> && value) 
	{
		fdb_probe_actor_enter("basicLoadBalance", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BasicLoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("basicLoadBalance", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< BasicLoadBalanceActor, 2, ErrorOr<REPLY_TYPE(Request)> >*,Error err) 
	{
		fdb_probe_actor_enter("basicLoadBalance", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BasicLoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("basicLoadBalance", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1039 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	Reference<ModelInterface<Multi>> alternatives;
															#line 1039 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	RequestStream<Request, P> Interface::* channel;
															#line 1039 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	Request request;
															#line 1039 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	TaskPriority taskID;
															#line 1039 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	AtMostOnce atMostOnce;
															#line 1039 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	int* alternativeChosen;
															#line 1053 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	int bestAlt;
															#line 1054 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	int nextAlt;
															#line 1058 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	int startAlt;
															#line 1059 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	int startDistance;
															#line 1061 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	int numAttempts;
															#line 1062 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	double backoff;
															#line 1063 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	int useAlt;
															#line 1066 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	RequestStream<Request, P> const* stream;
															#line 4927 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
};
// This generated class is to be used only via basicLoadBalance()
															#line 1039 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
template <class Interface, class Request, class Multi, bool P>
															#line 1039 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
class BasicLoadBalanceActor final : public Actor<REPLY_TYPE(Request)>, public ActorCallback< BasicLoadBalanceActor<Interface, Request, Multi, P>, 0, Void >, public ActorCallback< BasicLoadBalanceActor<Interface, Request, Multi, P>, 1, Void >, public ActorCallback< BasicLoadBalanceActor<Interface, Request, Multi, P>, 2, ErrorOr<REPLY_TYPE(Request)> >, public FastAllocated<BasicLoadBalanceActor<Interface, Request, Multi, P>>, public BasicLoadBalanceActorState<Interface, Request, Multi, P, BasicLoadBalanceActor<Interface, Request, Multi, P>> {
															#line 4934 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
public:
	using FastAllocated<BasicLoadBalanceActor<Interface, Request, Multi, P>>::operator new;
	using FastAllocated<BasicLoadBalanceActor<Interface, Request, Multi, P>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16327632596957671680UL, 500452394182082304UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<REPLY_TYPE(Request)>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BasicLoadBalanceActor<Interface, Request, Multi, P>, 0, Void >;
friend struct ActorCallback< BasicLoadBalanceActor<Interface, Request, Multi, P>, 1, Void >;
friend struct ActorCallback< BasicLoadBalanceActor<Interface, Request, Multi, P>, 2, ErrorOr<REPLY_TYPE(Request)> >;
															#line 1039 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	BasicLoadBalanceActor(Reference<ModelInterface<Multi>> const& alternatives,RequestStream<Request, P> Interface::* const& channel,Request const& request = Request(),TaskPriority const& taskID = TaskPriority::DefaultPromiseEndpoint,AtMostOnce const& atMostOnce = AtMostOnce::False,int* const& alternativeChosen = nullptr) 
															#line 4953 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		 : Actor<REPLY_TYPE(Request)>(),
		   BasicLoadBalanceActorState<Interface, Request, Multi, P, BasicLoadBalanceActor<Interface, Request, Multi, P>>(alternatives, channel, request, taskID, atMostOnce, alternativeChosen),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("basicLoadBalance", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5600668509463549440UL, 16700316307983848448UL);
		ActorExecutionContextHelper __helper(static_cast<BasicLoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("basicLoadBalance");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("basicLoadBalance", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BasicLoadBalanceActor<Interface, Request, Multi, P>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< BasicLoadBalanceActor<Interface, Request, Multi, P>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< BasicLoadBalanceActor<Interface, Request, Multi, P>, 2, ErrorOr<REPLY_TYPE(Request)> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1039 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
template <class Interface, class Request, class Multi, bool P>
															#line 1039 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
[[nodiscard]] Future<REPLY_TYPE(Request)> basicLoadBalance( Reference<ModelInterface<Multi>> const& alternatives, RequestStream<Request, P> Interface::* const& channel, Request const& request = Request(), TaskPriority const& taskID = TaskPriority::DefaultPromiseEndpoint, AtMostOnce const& atMostOnce = AtMostOnce::False, int* const& alternativeChosen = nullptr ) {
															#line 1039 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	return Future<REPLY_TYPE(Request)>(new BasicLoadBalanceActor<Interface, Request, Multi, P>(alternatives, channel, request, taskID, atMostOnce, alternativeChosen));
															#line 4990 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
}

#line 1131 "/codebuild/output/src35625984/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"

#include "flow/unactorcompiler.h"

#endif
