#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
/*
 * RestoreCluster.actor.h
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once
#if defined(NO_INTELLISENSE) && !defined(METACLUSTER_RESTORECLUSTER_ACTOR_G_H)
#define METACLUSTER_RESTORECLUSTER_ACTOR_G_H
#include "metacluster/RestoreCluster.actor.g.h"
#elif !defined(METACLUSTER_RESTORECLUSTER_ACTOR_H)
#define METACLUSTER_RESTORECLUSTER_ACTOR_H

#include "fdbclient/Tenant.h"
#include "flow/flow.h"
#include "flow/genericactors.actor.h"

#include "metacluster/ConfigureCluster.h"
#include "metacluster/GetTenant.actor.h"
#include "metacluster/MetaclusterInternal.actor.h"
#include "metacluster/MetaclusterOperationContext.actor.h"
#include "metacluster/MetaclusterTypes.h"
#include "metacluster/MetaclusterUtil.actor.h"
#include "metacluster/UpdateTenantGroups.actor.h"

#include "flow/actorcompiler.h" // has to be last include

namespace metacluster {

FDB_BOOLEAN_PARAM(ApplyManagementClusterUpdates);
FDB_BOOLEAN_PARAM(RestoreDryRun);
FDB_BOOLEAN_PARAM(ForceJoin);
FDB_BOOLEAN_PARAM(ForceReuseTenantIdPrefix);

namespace internal {
template <class DB>
struct RestoreClusterImpl {
	// This prefix is used during a cluster restore if the desired name is in use
	//
	// SOMEDAY: this should probably live in the `\xff` tenant namespace, but other parts of the code are not able to
	// work with `\xff` tenants yet. In the unlikely event that we have regular tenants using this prefix, we have a
	// rename cycle, and we have a collision between the names, a restore will fail with an error. This error can be
	// resolved manually using tenant rename commands.
	static inline const StringRef metaclusterTemporaryRenamePrefix = "\xfe/restoreTenant/"_sr;

	MetaclusterOperationContext<DB> ctx;

	// Initialization parameters
	ClusterName clusterName;
	ClusterConnectionString connectionString;
	ApplyManagementClusterUpdates applyManagementClusterUpdates;
	RestoreDryRun restoreDryRun;
	ForceJoin forceJoin;
	ForceReuseTenantIdPrefix forceReuseTenantIdPrefix;
	std::vector<std::string>& messages;

	// Unique ID generated for this restore. Used to avoid concurrent restores
	metadata::RestoreId restoreId;

	// Loaded from the management cluster
	int64_t tenantIdPrefix;
	Optional<int64_t> lastManagementClusterTenantId;

	// Loaded from the data cluster
	UID dataClusterId;
	Optional<int64_t> lastDataClusterTenantId;
	Optional<int64_t> newLastDataClusterTenantId;

	// Tenant list from data and management clusters
	std::unordered_map<int64_t, TenantMapEntry> dataClusterTenantMap;
	std::unordered_set<TenantName> dataClusterTenantNames;
	std::unordered_map<int64_t, MetaclusterTenantMapEntry> mgmtClusterTenantMap;
	std::unordered_set<int64_t> mgmtClusterTenantSetForCurrentDataCluster;

	RestoreClusterImpl(Reference<DB> managementDb,
	                   ClusterName clusterName,
	                   ClusterConnectionString connectionString,
	                   ApplyManagementClusterUpdates applyManagementClusterUpdates,
	                   RestoreDryRun restoreDryRun,
	                   ForceJoin forceJoin,
	                   ForceReuseTenantIdPrefix forceReuseTenantIdPrefix,
	                   std::vector<std::string>& messages)
	  : ctx(managementDb, {}, { DataClusterState::RESTORING }), clusterName(clusterName),
	    connectionString(connectionString), applyManagementClusterUpdates(applyManagementClusterUpdates),
	    restoreDryRun(restoreDryRun), forceJoin(forceJoin), forceReuseTenantIdPrefix(forceReuseTenantIdPrefix),
	    messages(messages) {}

																#line 104 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
// This generated class is to be used only via checkRestoreId()
															#line 102 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
template <class Transaction, class CheckRestoreIdActor>
															#line 102 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
class CheckRestoreIdActorState {
															#line 110 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
public:
															#line 102 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	CheckRestoreIdActorState(RestoreClusterImpl* const& self,Transaction const& tr) 
															#line 102 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
															#line 102 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		 : self(self),
															#line 102 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		   tr(tr)
															#line 119 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
	{
		fdb_probe_actor_create("checkRestoreId", reinterpret_cast<unsigned long>(this));

	}
	~CheckRestoreIdActorState() 
	{
		fdb_probe_actor_destroy("checkRestoreId", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 104 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (!self->restoreDryRun)
															#line 134 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			{
															#line 105 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				StrictFuture<Optional<metadata::RestoreId>> __when_expr_0 = metadata::activeRestoreIds().get(tr, self->clusterName);
															#line 105 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				if (static_cast<CheckRestoreIdActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 140 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<CheckRestoreIdActor*>(this)->actor_wait_state = 1;
															#line 105 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckRestoreIdActor, 0, Optional<metadata::RestoreId> >*>(static_cast<CheckRestoreIdActor*>(this)));
															#line 145 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckRestoreIdActorState();
		static_cast<CheckRestoreIdActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 113 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!static_cast<CheckRestoreIdActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckRestoreIdActorState(); static_cast<CheckRestoreIdActor*>(this)->destroy(); return 0; }
															#line 173 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		new (&static_cast<CheckRestoreIdActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckRestoreIdActorState();
		static_cast<CheckRestoreIdActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Optional<metadata::RestoreId> const& activeRestoreId,int loopDepth) 
	{
															#line 107 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!activeRestoreId.present() || activeRestoreId.get() != self->restoreId)
															#line 185 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 108 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			CODE_PROBE(true, "Conflicting restore detected");
															#line 109 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			return a_body1Catch1(conflicting_restore(), loopDepth);
															#line 191 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Optional<metadata::RestoreId> && activeRestoreId,int loopDepth) 
	{
															#line 107 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!activeRestoreId.present() || activeRestoreId.get() != self->restoreId)
															#line 201 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 108 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			CODE_PROBE(true, "Conflicting restore detected");
															#line 109 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			return a_body1Catch1(conflicting_restore(), loopDepth);
															#line 207 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<metadata::RestoreId> const& activeRestoreId,int loopDepth) 
	{
		loopDepth = a_body1cont2(activeRestoreId, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<metadata::RestoreId> && activeRestoreId,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(activeRestoreId), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckRestoreIdActor*>(this)->actor_wait_state > 0) static_cast<CheckRestoreIdActor*>(this)->actor_wait_state = 0;
		static_cast<CheckRestoreIdActor*>(this)->ActorCallback< CheckRestoreIdActor, 0, Optional<metadata::RestoreId> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckRestoreIdActor, 0, Optional<metadata::RestoreId> >*,Optional<metadata::RestoreId> const& value) 
	{
		fdb_probe_actor_enter("checkRestoreId", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRestoreIdActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRestoreId", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckRestoreIdActor, 0, Optional<metadata::RestoreId> >*,Optional<metadata::RestoreId> && value) 
	{
		fdb_probe_actor_enter("checkRestoreId", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRestoreIdActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRestoreId", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckRestoreIdActor, 0, Optional<metadata::RestoreId> >*,Error err) 
	{
		fdb_probe_actor_enter("checkRestoreId", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRestoreIdActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRestoreId", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 102 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	RestoreClusterImpl* self;
															#line 102 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	Transaction tr;
															#line 292 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
};
// This generated class is to be used only via checkRestoreId()
															#line 102 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
template <class Transaction>
															#line 102 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
class CheckRestoreIdActor final : public Actor<Void>, public ActorCallback< CheckRestoreIdActor<Transaction>, 0, Optional<metadata::RestoreId> >, public FastAllocated<CheckRestoreIdActor<Transaction>>, public CheckRestoreIdActorState<Transaction, CheckRestoreIdActor<Transaction>> {
															#line 299 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
public:
	using FastAllocated<CheckRestoreIdActor<Transaction>>::operator new;
	using FastAllocated<CheckRestoreIdActor<Transaction>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2073487250142415872UL, 3672200784552965376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckRestoreIdActor<Transaction>, 0, Optional<metadata::RestoreId> >;
															#line 102 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	CheckRestoreIdActor(RestoreClusterImpl* const& self,Transaction const& tr) 
															#line 316 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		 : Actor<Void>(),
		   CheckRestoreIdActorState<Transaction, CheckRestoreIdActor<Transaction>>(self, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkRestoreId", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2029324423683173376UL, 3761409239523084288UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRestoreIdActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkRestoreId");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkRestoreId", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckRestoreIdActor<Transaction>, 0, Optional<metadata::RestoreId> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 102 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
template <class Transaction>
															#line 102 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
[[nodiscard]] static Future<Void> checkRestoreId( RestoreClusterImpl* const& self, Transaction const& tr ) {
															#line 102 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	return Future<Void>(new CheckRestoreIdActor<Transaction>(self, tr));
															#line 350 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
}

#line 115 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"

	// Returns true if the restore ID was erased
																#line 356 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
// This generated class is to be used only via eraseRestoreId()
															#line 117 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
template <class Transaction, class EraseRestoreIdActor>
															#line 117 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
class EraseRestoreIdActorState {
															#line 362 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
public:
															#line 117 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	EraseRestoreIdActorState(RestoreClusterImpl* const& self,Transaction const& tr) 
															#line 117 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
															#line 117 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		 : self(self),
															#line 117 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		   tr(tr)
															#line 371 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
	{
		fdb_probe_actor_create("eraseRestoreId", reinterpret_cast<unsigned long>(this));

	}
	~EraseRestoreIdActorState() 
	{
		fdb_probe_actor_destroy("eraseRestoreId", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 119 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			StrictFuture<Optional<metadata::RestoreId>> __when_expr_0 = metadata::activeRestoreIds().get(tr, self->clusterName);
															#line 119 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (static_cast<EraseRestoreIdActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 388 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<EraseRestoreIdActor*>(this)->actor_wait_state = 1;
															#line 119 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< EraseRestoreIdActor, 0, Optional<metadata::RestoreId> >*>(static_cast<EraseRestoreIdActor*>(this)));
															#line 393 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~EraseRestoreIdActorState();
		static_cast<EraseRestoreIdActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<metadata::RestoreId> const& transactionId,int loopDepth) 
	{
															#line 120 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!transactionId.present())
															#line 416 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 121 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			CODE_PROBE(true, "Erasing non-existent restore ID");
															#line 122 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (!static_cast<EraseRestoreIdActor*>(this)->SAV<bool>::futures) { (void)(false); this->~EraseRestoreIdActorState(); static_cast<EraseRestoreIdActor*>(this)->destroy(); return 0; }
															#line 422 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			new (&static_cast<EraseRestoreIdActor*>(this)->SAV< bool >::value()) bool(false);
			this->~EraseRestoreIdActorState();
			static_cast<EraseRestoreIdActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 123 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (transactionId.get() != self->restoreId)
															#line 432 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			{
															#line 124 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				CODE_PROBE(true, "Conflicting restore detected while erasing restore ID");
															#line 125 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				return a_body1Catch1(conflicting_restore(), loopDepth);
															#line 438 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			}
			else
			{
															#line 127 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				metadata::activeRestoreIds().addReadConflictKey(tr, self->clusterName);
															#line 128 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				metadata::activeRestoreIds().erase(tr, self->clusterName);
															#line 446 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			}
		}
															#line 131 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!static_cast<EraseRestoreIdActor*>(this)->SAV<bool>::futures) { (void)(true); this->~EraseRestoreIdActorState(); static_cast<EraseRestoreIdActor*>(this)->destroy(); return 0; }
															#line 451 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		new (&static_cast<EraseRestoreIdActor*>(this)->SAV< bool >::value()) bool(true);
		this->~EraseRestoreIdActorState();
		static_cast<EraseRestoreIdActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<metadata::RestoreId> && transactionId,int loopDepth) 
	{
															#line 120 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!transactionId.present())
															#line 463 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 121 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			CODE_PROBE(true, "Erasing non-existent restore ID");
															#line 122 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (!static_cast<EraseRestoreIdActor*>(this)->SAV<bool>::futures) { (void)(false); this->~EraseRestoreIdActorState(); static_cast<EraseRestoreIdActor*>(this)->destroy(); return 0; }
															#line 469 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			new (&static_cast<EraseRestoreIdActor*>(this)->SAV< bool >::value()) bool(false);
			this->~EraseRestoreIdActorState();
			static_cast<EraseRestoreIdActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 123 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (transactionId.get() != self->restoreId)
															#line 479 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			{
															#line 124 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				CODE_PROBE(true, "Conflicting restore detected while erasing restore ID");
															#line 125 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				return a_body1Catch1(conflicting_restore(), loopDepth);
															#line 485 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			}
			else
			{
															#line 127 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				metadata::activeRestoreIds().addReadConflictKey(tr, self->clusterName);
															#line 128 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				metadata::activeRestoreIds().erase(tr, self->clusterName);
															#line 493 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			}
		}
															#line 131 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!static_cast<EraseRestoreIdActor*>(this)->SAV<bool>::futures) { (void)(true); this->~EraseRestoreIdActorState(); static_cast<EraseRestoreIdActor*>(this)->destroy(); return 0; }
															#line 498 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		new (&static_cast<EraseRestoreIdActor*>(this)->SAV< bool >::value()) bool(true);
		this->~EraseRestoreIdActorState();
		static_cast<EraseRestoreIdActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<metadata::RestoreId> const& transactionId,int loopDepth) 
	{
		loopDepth = a_body1cont1(transactionId, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<metadata::RestoreId> && transactionId,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(transactionId), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<EraseRestoreIdActor*>(this)->actor_wait_state > 0) static_cast<EraseRestoreIdActor*>(this)->actor_wait_state = 0;
		static_cast<EraseRestoreIdActor*>(this)->ActorCallback< EraseRestoreIdActor, 0, Optional<metadata::RestoreId> >::remove();

	}
	void a_callback_fire(ActorCallback< EraseRestoreIdActor, 0, Optional<metadata::RestoreId> >*,Optional<metadata::RestoreId> const& value) 
	{
		fdb_probe_actor_enter("eraseRestoreId", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EraseRestoreIdActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("eraseRestoreId", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< EraseRestoreIdActor, 0, Optional<metadata::RestoreId> >*,Optional<metadata::RestoreId> && value) 
	{
		fdb_probe_actor_enter("eraseRestoreId", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EraseRestoreIdActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("eraseRestoreId", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< EraseRestoreIdActor, 0, Optional<metadata::RestoreId> >*,Error err) 
	{
		fdb_probe_actor_enter("eraseRestoreId", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<EraseRestoreIdActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("eraseRestoreId", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 117 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	RestoreClusterImpl* self;
															#line 117 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	Transaction tr;
															#line 585 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
};
// This generated class is to be used only via eraseRestoreId()
															#line 117 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
template <class Transaction>
															#line 117 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
class EraseRestoreIdActor final : public Actor<bool>, public ActorCallback< EraseRestoreIdActor<Transaction>, 0, Optional<metadata::RestoreId> >, public FastAllocated<EraseRestoreIdActor<Transaction>>, public EraseRestoreIdActorState<Transaction, EraseRestoreIdActor<Transaction>> {
															#line 592 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
public:
	using FastAllocated<EraseRestoreIdActor<Transaction>>::operator new;
	using FastAllocated<EraseRestoreIdActor<Transaction>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4158906892526725888UL, 9944274610550421504UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< EraseRestoreIdActor<Transaction>, 0, Optional<metadata::RestoreId> >;
															#line 117 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	EraseRestoreIdActor(RestoreClusterImpl* const& self,Transaction const& tr) 
															#line 609 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		 : Actor<bool>(),
		   EraseRestoreIdActorState<Transaction, EraseRestoreIdActor<Transaction>>(self, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("eraseRestoreId", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15628692420194429696UL, 14014460841028445696UL);
		ActorExecutionContextHelper __helper(static_cast<EraseRestoreIdActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("eraseRestoreId");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("eraseRestoreId", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< EraseRestoreIdActor<Transaction>, 0, Optional<metadata::RestoreId> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 117 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
template <class Transaction>
															#line 117 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
[[nodiscard]] static Future<bool> eraseRestoreId( RestoreClusterImpl* const& self, Transaction const& tr ) {
															#line 117 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	return Future<bool>(new EraseRestoreIdActor<Transaction>(self, tr));
															#line 643 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
}

#line 133 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"

	template <class Function>
	Future<decltype(std::declval<Function>()(Reference<typename DB::TransactionT>()).getValue())>
	runRestoreManagementTransaction(Function func) {
		return ctx.runManagementTransaction([this, func](Reference<typename DB::TransactionT> tr) {
			return joinWith(func(tr), checkRestoreId(this, tr));
		});
	}

	template <class Function>
	Future<decltype(std::declval<Function>()(Reference<typename DB::TransactionT>()).getValue())>
	runRestoreDataClusterTransaction(
	    Function func,
	    RunOnDisconnectedCluster runOnDisconnectedCluster = RunOnDisconnectedCluster::False,
	    RunOnMismatchedCluster runOnMismatchedCluster = RunOnMismatchedCluster::False) {
		return ctx.runDataClusterTransaction(
		    [this, func](Reference<ITransaction> tr) { return joinWith(func(tr), checkRestoreId(this, tr)); },
		    runOnDisconnectedCluster,
		    runOnMismatchedCluster);
	}

	// If restoring a data cluster, verify that it has a matching registration entry
																#line 669 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
// This generated class is to be used only via loadDataClusterRegistration()
															#line 155 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
template <class LoadDataClusterRegistrationActor>
															#line 155 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
class LoadDataClusterRegistrationActorState {
															#line 675 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
public:
															#line 155 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	LoadDataClusterRegistrationActorState(RestoreClusterImpl* const& self) 
															#line 155 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
															#line 155 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		 : self(self)
															#line 682 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
	{
		fdb_probe_actor_create("loadDataClusterRegistration", reinterpret_cast<unsigned long>(this));

	}
	~LoadDataClusterRegistrationActorState() 
	{
		fdb_probe_actor_destroy("loadDataClusterRegistration", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 156 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			StrictFuture<Reference<IDatabase>> __when_expr_0 = util::openDatabase(self->connectionString);
															#line 156 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (static_cast<LoadDataClusterRegistrationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 699 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<LoadDataClusterRegistrationActor*>(this)->actor_wait_state = 1;
															#line 156 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LoadDataClusterRegistrationActor, 0, Reference<IDatabase> >*>(static_cast<LoadDataClusterRegistrationActor*>(this)));
															#line 704 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LoadDataClusterRegistrationActorState();
		static_cast<LoadDataClusterRegistrationActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 157 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		tr = db->createTransaction();
															#line 159 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		;
															#line 729 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IDatabase> const& __db,int loopDepth) 
	{
															#line 156 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		db = __db;
															#line 738 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IDatabase> && __db,int loopDepth) 
	{
		db = std::move(__db);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LoadDataClusterRegistrationActor*>(this)->actor_wait_state > 0) static_cast<LoadDataClusterRegistrationActor*>(this)->actor_wait_state = 0;
		static_cast<LoadDataClusterRegistrationActor*>(this)->ActorCallback< LoadDataClusterRegistrationActor, 0, Reference<IDatabase> >::remove();

	}
	void a_callback_fire(ActorCallback< LoadDataClusterRegistrationActor, 0, Reference<IDatabase> >*,Reference<IDatabase> const& value) 
	{
		fdb_probe_actor_enter("loadDataClusterRegistration", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadDataClusterRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadDataClusterRegistration", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LoadDataClusterRegistrationActor, 0, Reference<IDatabase> >*,Reference<IDatabase> && value) 
	{
		fdb_probe_actor_enter("loadDataClusterRegistration", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadDataClusterRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadDataClusterRegistration", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LoadDataClusterRegistrationActor, 0, Reference<IDatabase> >*,Error err) 
	{
		fdb_probe_actor_enter("loadDataClusterRegistration", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadDataClusterRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadDataClusterRegistration", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 161 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 162 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			StrictFuture<Optional<MetaclusterRegistrationEntry>> __when_expr_1 = metadata::metaclusterRegistration().get(tr);
															#line 162 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (static_cast<LoadDataClusterRegistrationActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 829 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<LoadDataClusterRegistrationActor*>(this)->actor_wait_state = 2;
															#line 162 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LoadDataClusterRegistrationActor, 1, Optional<MetaclusterRegistrationEntry> >*>(static_cast<LoadDataClusterRegistrationActor*>(this)));
															#line 834 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 202 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			StrictFuture<Void> __when_expr_3 = safeThreadFutureToFuture(tr->onError(e));
															#line 202 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (static_cast<LoadDataClusterRegistrationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 858 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<LoadDataClusterRegistrationActor*>(this)->actor_wait_state = 4;
															#line 202 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< LoadDataClusterRegistrationActor, 3, Void >*>(static_cast<LoadDataClusterRegistrationActor*>(this)));
															#line 863 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(int loopDepth) 
	{
															#line 165 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!metaclusterRegistration.present())
															#line 878 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 166 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			CODE_PROBE(true, "Restore non-data cluster");
															#line 167 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			return a_body1cont1loopBody1Catch1(invalid_data_cluster(), loopDepth);
															#line 884 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		}
		else
		{
															#line 168 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (!metaclusterRegistration.get().matches(self->ctx.metaclusterRegistration.get()))
															#line 890 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			{
															#line 169 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				if (!self->forceJoin)
															#line 894 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
				{
															#line 170 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
					TraceEvent(SevWarn, "MetaclusterRestoreClusterMismatch") .detail("ExistingRegistration", metaclusterRegistration.get()) .detail("ManagementClusterRegistration", self->ctx.metaclusterRegistration.get());
															#line 173 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
					CODE_PROBE(true, "Restore cluster that is already registered");
															#line 174 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
					return a_body1cont1loopBody1Catch1(cluster_already_registered(), loopDepth);
															#line 902 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
				}
				else
				{
															#line 175 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
					if (!self->restoreDryRun)
															#line 908 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
					{
															#line 176 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
						ASSERT(self->ctx.metaclusterRegistration.get().clusterType == ClusterType::METACLUSTER_DATA);
															#line 177 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
						metadata::metaclusterRegistration().set(tr, self->ctx.metaclusterRegistration.get());
															#line 914 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
					}
					else
					{
															#line 179 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
						self->messages.push_back(fmt::format("Move data cluster to new metacluster\n" "        original: {}\n" "        updated:  {}", metaclusterRegistration.get().toString(), self->ctx.metaclusterRegistration.get().toString()));
															#line 920 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
					}
				}
			}
			else
			{
															#line 185 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				if (metaclusterRegistration.get().name != self->clusterName)
															#line 928 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
				{
															#line 186 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
					TraceEvent(SevWarn, "MetaclusterRestoreClusterNameMismatch") .detail("ExistingName", metaclusterRegistration.get().name) .detail("ManagementClusterRegistration", self->clusterName);
															#line 189 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
					CODE_PROBE(true, "Restore cluster with incorrect name");
															#line 190 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
					return a_body1cont1loopBody1Catch1(cluster_already_registered(), loopDepth);
															#line 936 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
				}
			}
		}
															#line 193 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		self->dataClusterId = metaclusterRegistration.get().id;
															#line 194 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		self->ctx.dataClusterDb = db;
															#line 196 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!self->restoreDryRun)
															#line 946 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 197 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			StrictFuture<Void> __when_expr_2 = buggifiedCommit(tr, BUGGIFY_WITH_PROB(0.1));
															#line 197 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (static_cast<LoadDataClusterRegistrationActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 952 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<LoadDataClusterRegistrationActor*>(this)->actor_wait_state = 3;
															#line 197 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< LoadDataClusterRegistrationActor, 2, Void >*>(static_cast<LoadDataClusterRegistrationActor*>(this)));
															#line 957 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Optional<MetaclusterRegistrationEntry> const& __metaclusterRegistration,int loopDepth) 
	{
															#line 162 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		metaclusterRegistration = __metaclusterRegistration;
															#line 971 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Optional<MetaclusterRegistrationEntry> && __metaclusterRegistration,int loopDepth) 
	{
		metaclusterRegistration = std::move(__metaclusterRegistration);
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<LoadDataClusterRegistrationActor*>(this)->actor_wait_state > 0) static_cast<LoadDataClusterRegistrationActor*>(this)->actor_wait_state = 0;
		static_cast<LoadDataClusterRegistrationActor*>(this)->ActorCallback< LoadDataClusterRegistrationActor, 1, Optional<MetaclusterRegistrationEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< LoadDataClusterRegistrationActor, 1, Optional<MetaclusterRegistrationEntry> >*,Optional<MetaclusterRegistrationEntry> const& value) 
	{
		fdb_probe_actor_enter("loadDataClusterRegistration", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadDataClusterRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadDataClusterRegistration", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< LoadDataClusterRegistrationActor, 1, Optional<MetaclusterRegistrationEntry> >*,Optional<MetaclusterRegistrationEntry> && value) 
	{
		fdb_probe_actor_enter("loadDataClusterRegistration", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadDataClusterRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadDataClusterRegistration", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< LoadDataClusterRegistrationActor, 1, Optional<MetaclusterRegistrationEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("loadDataClusterRegistration", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadDataClusterRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadDataClusterRegistration", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont3(int loopDepth) 
	{
															#line 200 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!static_cast<LoadDataClusterRegistrationActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LoadDataClusterRegistrationActorState(); static_cast<LoadDataClusterRegistrationActor*>(this)->destroy(); return 0; }
															#line 1050 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		new (&static_cast<LoadDataClusterRegistrationActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~LoadDataClusterRegistrationActorState();
		static_cast<LoadDataClusterRegistrationActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<LoadDataClusterRegistrationActor*>(this)->actor_wait_state > 0) static_cast<LoadDataClusterRegistrationActor*>(this)->actor_wait_state = 0;
		static_cast<LoadDataClusterRegistrationActor*>(this)->ActorCallback< LoadDataClusterRegistrationActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadDataClusterRegistrationActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadDataClusterRegistration", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadDataClusterRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadDataClusterRegistration", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< LoadDataClusterRegistrationActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadDataClusterRegistration", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadDataClusterRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadDataClusterRegistration", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< LoadDataClusterRegistrationActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadDataClusterRegistration", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadDataClusterRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadDataClusterRegistration", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<LoadDataClusterRegistrationActor*>(this)->actor_wait_state > 0) static_cast<LoadDataClusterRegistrationActor*>(this)->actor_wait_state = 0;
		static_cast<LoadDataClusterRegistrationActor*>(this)->ActorCallback< LoadDataClusterRegistrationActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadDataClusterRegistrationActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadDataClusterRegistration", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadDataClusterRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadDataClusterRegistration", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< LoadDataClusterRegistrationActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadDataClusterRegistration", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadDataClusterRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadDataClusterRegistration", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< LoadDataClusterRegistrationActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadDataClusterRegistration", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadDataClusterRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadDataClusterRegistration", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 155 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	RestoreClusterImpl* self;
															#line 156 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	Reference<IDatabase> db;
															#line 157 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	Reference<ITransaction> tr;
															#line 162 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	Optional<MetaclusterRegistrationEntry> metaclusterRegistration;
															#line 1240 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
};
// This generated class is to be used only via loadDataClusterRegistration()
															#line 155 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
class LoadDataClusterRegistrationActor final : public Actor<Void>, public ActorCallback< LoadDataClusterRegistrationActor, 0, Reference<IDatabase> >, public ActorCallback< LoadDataClusterRegistrationActor, 1, Optional<MetaclusterRegistrationEntry> >, public ActorCallback< LoadDataClusterRegistrationActor, 2, Void >, public ActorCallback< LoadDataClusterRegistrationActor, 3, Void >, public FastAllocated<LoadDataClusterRegistrationActor>, public LoadDataClusterRegistrationActorState<LoadDataClusterRegistrationActor> {
															#line 1245 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
public:
	using FastAllocated<LoadDataClusterRegistrationActor>::operator new;
	using FastAllocated<LoadDataClusterRegistrationActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15233965310271663872UL, 18010737536322067200UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LoadDataClusterRegistrationActor, 0, Reference<IDatabase> >;
friend struct ActorCallback< LoadDataClusterRegistrationActor, 1, Optional<MetaclusterRegistrationEntry> >;
friend struct ActorCallback< LoadDataClusterRegistrationActor, 2, Void >;
friend struct ActorCallback< LoadDataClusterRegistrationActor, 3, Void >;
															#line 155 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	LoadDataClusterRegistrationActor(RestoreClusterImpl* const& self) 
															#line 1265 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		 : Actor<Void>(),
		   LoadDataClusterRegistrationActorState<LoadDataClusterRegistrationActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("loadDataClusterRegistration", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3973756286316965888UL, 17880002941383647488UL);
		ActorExecutionContextHelper __helper(static_cast<LoadDataClusterRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("loadDataClusterRegistration");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("loadDataClusterRegistration", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LoadDataClusterRegistrationActor, 0, Reference<IDatabase> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< LoadDataClusterRegistrationActor, 1, Optional<MetaclusterRegistrationEntry> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< LoadDataClusterRegistrationActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< LoadDataClusterRegistrationActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 155 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
[[nodiscard]] static Future<Void> loadDataClusterRegistration( RestoreClusterImpl* const& self ) {
															#line 155 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	return Future<Void>(new LoadDataClusterRegistrationActor(self));
															#line 1300 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
}

#line 206 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"

																#line 1305 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
// This generated class is to be used only via loadTenantIdData()
															#line 207 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
template <class LoadTenantIdDataActor>
															#line 207 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
class LoadTenantIdDataActorState {
															#line 1311 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
public:
															#line 207 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	LoadTenantIdDataActorState(RestoreClusterImpl* const& self,Reference<typename DB::TransactionT> const& tr) 
															#line 207 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
															#line 207 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		 : self(self),
															#line 207 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		   tr(tr)
															#line 1320 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
	{
		fdb_probe_actor_create("loadTenantIdData", reinterpret_cast<unsigned long>(this));

	}
	~LoadTenantIdDataActorState() 
	{
		fdb_probe_actor_destroy("loadTenantIdData", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 208 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			StrictFuture<Void> __when_expr_0 = store(self->lastManagementClusterTenantId, metadata::management::tenantMetadata().lastTenantId.get(tr));
															#line 208 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (static_cast<LoadTenantIdDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1337 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<LoadTenantIdDataActor*>(this)->actor_wait_state = 1;
															#line 208 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LoadTenantIdDataActor, 0, Void >*>(static_cast<LoadTenantIdDataActor*>(this)));
															#line 1342 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LoadTenantIdDataActorState();
		static_cast<LoadTenantIdDataActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 210 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!self->lastManagementClusterTenantId.present())
															#line 1365 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 211 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			StrictFuture<Optional<int64_t>> __when_expr_1 = TenantMetadata::tenantIdPrefix().get(tr);
															#line 211 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (static_cast<LoadTenantIdDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1371 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<LoadTenantIdDataActor*>(this)->actor_wait_state = 2;
															#line 211 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LoadTenantIdDataActor, 1, Optional<int64_t> >*>(static_cast<LoadTenantIdDataActor*>(this)));
															#line 1376 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = 0;
		}
		else
		{
															#line 215 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			self->tenantIdPrefix = TenantAPI::getTenantIdPrefix(self->lastManagementClusterTenantId.get());
															#line 1383 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 210 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!self->lastManagementClusterTenantId.present())
															#line 1393 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 211 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			StrictFuture<Optional<int64_t>> __when_expr_1 = TenantMetadata::tenantIdPrefix().get(tr);
															#line 211 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (static_cast<LoadTenantIdDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1399 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<LoadTenantIdDataActor*>(this)->actor_wait_state = 2;
															#line 211 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LoadTenantIdDataActor, 1, Optional<int64_t> >*>(static_cast<LoadTenantIdDataActor*>(this)));
															#line 1404 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = 0;
		}
		else
		{
															#line 215 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			self->tenantIdPrefix = TenantAPI::getTenantIdPrefix(self->lastManagementClusterTenantId.get());
															#line 1411 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LoadTenantIdDataActor*>(this)->actor_wait_state > 0) static_cast<LoadTenantIdDataActor*>(this)->actor_wait_state = 0;
		static_cast<LoadTenantIdDataActor*>(this)->ActorCallback< LoadTenantIdDataActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadTenantIdDataActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadTenantIdData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadTenantIdDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadTenantIdData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LoadTenantIdDataActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadTenantIdData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadTenantIdDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadTenantIdData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LoadTenantIdDataActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadTenantIdData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadTenantIdDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadTenantIdData", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 218 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!static_cast<LoadTenantIdDataActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LoadTenantIdDataActorState(); static_cast<LoadTenantIdDataActor*>(this)->destroy(); return 0; }
															#line 1496 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		new (&static_cast<LoadTenantIdDataActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~LoadTenantIdDataActorState();
		static_cast<LoadTenantIdDataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Optional<int64_t> const& prefix,int loopDepth) 
	{
															#line 212 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		ASSERT(prefix.present());
															#line 213 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		self->tenantIdPrefix = prefix.get();
															#line 1510 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Optional<int64_t> && prefix,int loopDepth) 
	{
															#line 212 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		ASSERT(prefix.present());
															#line 213 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		self->tenantIdPrefix = prefix.get();
															#line 1521 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<int64_t> const& prefix,int loopDepth) 
	{
		loopDepth = a_body1cont3(prefix, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<int64_t> && prefix,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(prefix), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<LoadTenantIdDataActor*>(this)->actor_wait_state > 0) static_cast<LoadTenantIdDataActor*>(this)->actor_wait_state = 0;
		static_cast<LoadTenantIdDataActor*>(this)->ActorCallback< LoadTenantIdDataActor, 1, Optional<int64_t> >::remove();

	}
	void a_callback_fire(ActorCallback< LoadTenantIdDataActor, 1, Optional<int64_t> >*,Optional<int64_t> const& value) 
	{
		fdb_probe_actor_enter("loadTenantIdData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadTenantIdDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadTenantIdData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< LoadTenantIdDataActor, 1, Optional<int64_t> >*,Optional<int64_t> && value) 
	{
		fdb_probe_actor_enter("loadTenantIdData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadTenantIdDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadTenantIdData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< LoadTenantIdDataActor, 1, Optional<int64_t> >*,Error err) 
	{
		fdb_probe_actor_enter("loadTenantIdData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadTenantIdDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadTenantIdData", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 207 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	RestoreClusterImpl* self;
															#line 207 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	Reference<typename DB::TransactionT> tr;
															#line 1605 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
};
// This generated class is to be used only via loadTenantIdData()
															#line 207 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
class LoadTenantIdDataActor final : public Actor<Void>, public ActorCallback< LoadTenantIdDataActor, 0, Void >, public ActorCallback< LoadTenantIdDataActor, 1, Optional<int64_t> >, public FastAllocated<LoadTenantIdDataActor>, public LoadTenantIdDataActorState<LoadTenantIdDataActor> {
															#line 1610 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
public:
	using FastAllocated<LoadTenantIdDataActor>::operator new;
	using FastAllocated<LoadTenantIdDataActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8583698940599942656UL, 1001983480216765696UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LoadTenantIdDataActor, 0, Void >;
friend struct ActorCallback< LoadTenantIdDataActor, 1, Optional<int64_t> >;
															#line 207 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	LoadTenantIdDataActor(RestoreClusterImpl* const& self,Reference<typename DB::TransactionT> const& tr) 
															#line 1628 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		 : Actor<Void>(),
		   LoadTenantIdDataActorState<LoadTenantIdDataActor>(self, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("loadTenantIdData", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10304547718074842880UL, 10463797932701799680UL);
		ActorExecutionContextHelper __helper(static_cast<LoadTenantIdDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("loadTenantIdData");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("loadTenantIdData", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LoadTenantIdDataActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< LoadTenantIdDataActor, 1, Optional<int64_t> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 207 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
[[nodiscard]] static Future<Void> loadTenantIdData( RestoreClusterImpl* const& self, Reference<typename DB::TransactionT> const& tr ) {
															#line 207 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	return Future<Void>(new LoadTenantIdDataActor(self, tr));
															#line 1661 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
}

#line 220 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"

	// Store the cluster entry for the restored cluster
																#line 1667 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
// This generated class is to be used only via registerRestoringClusterInManagementCluster()
															#line 222 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
template <class RegisterRestoringClusterInManagementClusterActor>
															#line 222 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
class RegisterRestoringClusterInManagementClusterActorState {
															#line 1673 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
public:
															#line 222 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	RegisterRestoringClusterInManagementClusterActorState(RestoreClusterImpl* const& self,Reference<typename DB::TransactionT> const& tr) 
															#line 222 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
															#line 222 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		 : self(self),
															#line 222 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		   tr(tr)
															#line 1682 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
	{
		fdb_probe_actor_create("registerRestoringClusterInManagementCluster", reinterpret_cast<unsigned long>(this));

	}
	~RegisterRestoringClusterInManagementClusterActorState() 
	{
		fdb_probe_actor_destroy("registerRestoringClusterInManagementCluster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 225 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			StrictFuture<Optional<DataClusterMetadata>> __when_expr_0 = tryGetClusterTransaction(tr, self->clusterName);
															#line 225 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (static_cast<RegisterRestoringClusterInManagementClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1699 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RegisterRestoringClusterInManagementClusterActor*>(this)->actor_wait_state = 1;
															#line 225 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RegisterRestoringClusterInManagementClusterActor, 0, Optional<DataClusterMetadata> >*>(static_cast<RegisterRestoringClusterInManagementClusterActor*>(this)));
															#line 1704 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RegisterRestoringClusterInManagementClusterActorState();
		static_cast<RegisterRestoringClusterInManagementClusterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 226 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (dataClusterMetadata.present() && (dataClusterMetadata.get().entry.clusterState != DataClusterState::RESTORING || !self->dataClusterId.isValid() || dataClusterMetadata.get().entry.id != self->dataClusterId))
															#line 1727 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 229 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			TraceEvent("RestoredClusterAlreadyExists").detail("ClusterName", self->clusterName);
															#line 230 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			CODE_PROBE(true, "Restoring cluster that already exists");
															#line 231 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			return a_body1Catch1(cluster_already_exists(), loopDepth);
															#line 1735 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		}
		else
		{
															#line 232 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (!self->restoreDryRun)
															#line 1741 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			{
															#line 233 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				metadata::activeRestoreIds().addReadConflictKey(tr, self->clusterName);
															#line 234 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				metadata::RestoreId restoreId = metadata::RestoreId::createRestoreId(tr, metadata::activeRestoreIds(), self->clusterName);
															#line 237 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				if (!dataClusterMetadata.present())
															#line 1749 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
				{
															#line 238 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
					self->dataClusterId = deterministicRandom()->randomUniqueID();
															#line 1753 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
				}
															#line 241 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				DataClusterEntry clusterEntry;
															#line 242 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				clusterEntry.id = self->dataClusterId;
															#line 243 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				clusterEntry.clusterState = DataClusterState::RESTORING;
															#line 245 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				metadata::management::dataClusters().set(tr, self->clusterName, clusterEntry);
															#line 246 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				metadata::management::dataClusterConnectionRecords().set(tr, self->clusterName, self->connectionString);
															#line 248 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				TraceEvent("RegisteredRestoringDataCluster") .detail("ClusterName", self->clusterName) .detail("ClusterID", clusterEntry.id) .detail("Capacity", clusterEntry.capacity) .detail("Version", tr->getCommittedVersion()) .detail("ConnectionString", self->connectionString.toString());
															#line 255 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				if (!static_cast<RegisterRestoringClusterInManagementClusterActor*>(this)->SAV<metadata::RestoreId>::futures) { (void)(restoreId); this->~RegisterRestoringClusterInManagementClusterActorState(); static_cast<RegisterRestoringClusterInManagementClusterActor*>(this)->destroy(); return 0; }
															#line 1769 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
				new (&static_cast<RegisterRestoringClusterInManagementClusterActor*>(this)->SAV< metadata::RestoreId >::value()) metadata::RestoreId(restoreId);
				this->~RegisterRestoringClusterInManagementClusterActorState();
				static_cast<RegisterRestoringClusterInManagementClusterActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 258 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!static_cast<RegisterRestoringClusterInManagementClusterActor*>(this)->SAV<metadata::RestoreId>::futures) { (void)(metadata::RestoreId()); this->~RegisterRestoringClusterInManagementClusterActorState(); static_cast<RegisterRestoringClusterInManagementClusterActor*>(this)->destroy(); return 0; }
															#line 1778 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		new (&static_cast<RegisterRestoringClusterInManagementClusterActor*>(this)->SAV< metadata::RestoreId >::value()) metadata::RestoreId(metadata::RestoreId());
		this->~RegisterRestoringClusterInManagementClusterActorState();
		static_cast<RegisterRestoringClusterInManagementClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<DataClusterMetadata> const& __dataClusterMetadata,int loopDepth) 
	{
															#line 225 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		dataClusterMetadata = __dataClusterMetadata;
															#line 1790 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<DataClusterMetadata> && __dataClusterMetadata,int loopDepth) 
	{
		dataClusterMetadata = std::move(__dataClusterMetadata);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RegisterRestoringClusterInManagementClusterActor*>(this)->actor_wait_state > 0) static_cast<RegisterRestoringClusterInManagementClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RegisterRestoringClusterInManagementClusterActor*>(this)->ActorCallback< RegisterRestoringClusterInManagementClusterActor, 0, Optional<DataClusterMetadata> >::remove();

	}
	void a_callback_fire(ActorCallback< RegisterRestoringClusterInManagementClusterActor, 0, Optional<DataClusterMetadata> >*,Optional<DataClusterMetadata> const& value) 
	{
		fdb_probe_actor_enter("registerRestoringClusterInManagementCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterRestoringClusterInManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerRestoringClusterInManagementCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RegisterRestoringClusterInManagementClusterActor, 0, Optional<DataClusterMetadata> >*,Optional<DataClusterMetadata> && value) 
	{
		fdb_probe_actor_enter("registerRestoringClusterInManagementCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterRestoringClusterInManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerRestoringClusterInManagementCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RegisterRestoringClusterInManagementClusterActor, 0, Optional<DataClusterMetadata> >*,Error err) 
	{
		fdb_probe_actor_enter("registerRestoringClusterInManagementCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterRestoringClusterInManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerRestoringClusterInManagementCluster", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 222 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	RestoreClusterImpl* self;
															#line 222 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	Reference<typename DB::TransactionT> tr;
															#line 225 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	Optional<DataClusterMetadata> dataClusterMetadata;
															#line 1871 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
};
// This generated class is to be used only via registerRestoringClusterInManagementCluster()
															#line 222 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
class RegisterRestoringClusterInManagementClusterActor final : public Actor<metadata::RestoreId>, public ActorCallback< RegisterRestoringClusterInManagementClusterActor, 0, Optional<DataClusterMetadata> >, public FastAllocated<RegisterRestoringClusterInManagementClusterActor>, public RegisterRestoringClusterInManagementClusterActorState<RegisterRestoringClusterInManagementClusterActor> {
															#line 1876 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
public:
	using FastAllocated<RegisterRestoringClusterInManagementClusterActor>::operator new;
	using FastAllocated<RegisterRestoringClusterInManagementClusterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5930499336643410432UL, 17167455139427355136UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<metadata::RestoreId>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RegisterRestoringClusterInManagementClusterActor, 0, Optional<DataClusterMetadata> >;
															#line 222 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	RegisterRestoringClusterInManagementClusterActor(RestoreClusterImpl* const& self,Reference<typename DB::TransactionT> const& tr) 
															#line 1893 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		 : Actor<metadata::RestoreId>(),
		   RegisterRestoringClusterInManagementClusterActorState<RegisterRestoringClusterInManagementClusterActor>(self, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("registerRestoringClusterInManagementCluster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9868436650237924608UL, 17872427476006966528UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterRestoringClusterInManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("registerRestoringClusterInManagementCluster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("registerRestoringClusterInManagementCluster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RegisterRestoringClusterInManagementClusterActor, 0, Optional<DataClusterMetadata> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 222 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
[[nodiscard]] static Future<metadata::RestoreId> registerRestoringClusterInManagementCluster( RestoreClusterImpl* const& self, Reference<typename DB::TransactionT> const& tr ) {
															#line 222 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	return Future<metadata::RestoreId>(new RegisterRestoringClusterInManagementClusterActor(self, tr));
															#line 1925 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
}

#line 260 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"

	// If adding a data cluster to a restored management cluster, write a metacluster registration entry
	// to attach it
																#line 1932 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
// This generated class is to be used only via writeDataClusterRegistration()
															#line 263 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
template <class WriteDataClusterRegistrationActor>
															#line 263 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
class WriteDataClusterRegistrationActorState {
															#line 1938 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
public:
															#line 263 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	WriteDataClusterRegistrationActorState(RestoreClusterImpl* const& self) 
															#line 263 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
															#line 263 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		 : self(self)
															#line 1945 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
	{
		fdb_probe_actor_create("writeDataClusterRegistration", reinterpret_cast<unsigned long>(this));

	}
	~WriteDataClusterRegistrationActorState() 
	{
		fdb_probe_actor_destroy("writeDataClusterRegistration", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 264 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			StrictFuture<Reference<IDatabase>> __when_expr_0 = util::openDatabase(self->connectionString);
															#line 264 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (static_cast<WriteDataClusterRegistrationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1962 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WriteDataClusterRegistrationActor*>(this)->actor_wait_state = 1;
															#line 264 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WriteDataClusterRegistrationActor, 0, Reference<IDatabase> >*>(static_cast<WriteDataClusterRegistrationActor*>(this)));
															#line 1967 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WriteDataClusterRegistrationActorState();
		static_cast<WriteDataClusterRegistrationActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 265 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		tr = db->createTransaction();
															#line 267 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		;
															#line 1992 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IDatabase> const& __db,int loopDepth) 
	{
															#line 264 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		db = __db;
															#line 2001 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IDatabase> && __db,int loopDepth) 
	{
		db = std::move(__db);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WriteDataClusterRegistrationActor*>(this)->actor_wait_state > 0) static_cast<WriteDataClusterRegistrationActor*>(this)->actor_wait_state = 0;
		static_cast<WriteDataClusterRegistrationActor*>(this)->ActorCallback< WriteDataClusterRegistrationActor, 0, Reference<IDatabase> >::remove();

	}
	void a_callback_fire(ActorCallback< WriteDataClusterRegistrationActor, 0, Reference<IDatabase> >*,Reference<IDatabase> const& value) 
	{
		fdb_probe_actor_enter("writeDataClusterRegistration", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteDataClusterRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeDataClusterRegistration", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WriteDataClusterRegistrationActor, 0, Reference<IDatabase> >*,Reference<IDatabase> && value) 
	{
		fdb_probe_actor_enter("writeDataClusterRegistration", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteDataClusterRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeDataClusterRegistration", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WriteDataClusterRegistrationActor, 0, Reference<IDatabase> >*,Error err) 
	{
		fdb_probe_actor_enter("writeDataClusterRegistration", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteDataClusterRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeDataClusterRegistration", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 323 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!static_cast<WriteDataClusterRegistrationActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteDataClusterRegistrationActorState(); static_cast<WriteDataClusterRegistrationActor*>(this)->destroy(); return 0; }
															#line 2080 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		new (&static_cast<WriteDataClusterRegistrationActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteDataClusterRegistrationActorState();
		static_cast<WriteDataClusterRegistrationActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 269 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 270 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			tombstoneFuture = metadata::registrationTombstones().exists(tr, self->dataClusterId);
															#line 272 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			lastTenantIdFuture = store(self->lastDataClusterTenantId, TenantMetadata::lastTenantId().get(tr));
															#line 275 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			StrictFuture<Optional<MetaclusterRegistrationEntry>> __when_expr_1 = metadata::metaclusterRegistration().get(tr);
															#line 275 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (static_cast<WriteDataClusterRegistrationActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2108 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<WriteDataClusterRegistrationActor*>(this)->actor_wait_state = 2;
															#line 275 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteDataClusterRegistrationActor, 1, Optional<MetaclusterRegistrationEntry> >*>(static_cast<WriteDataClusterRegistrationActor*>(this)));
															#line 2113 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 319 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			StrictFuture<Void> __when_expr_6 = safeThreadFutureToFuture(tr->onError(e));
															#line 319 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (static_cast<WriteDataClusterRegistrationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2150 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_6.get(), loopDepth); };
			static_cast<WriteDataClusterRegistrationActor*>(this)->actor_wait_state = 7;
															#line 319 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< WriteDataClusterRegistrationActor, 6, Void >*>(static_cast<WriteDataClusterRegistrationActor*>(this)));
															#line 2155 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(int loopDepth) 
	{
															#line 279 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		StrictFuture<bool> __when_expr_2 = tombstoneFuture;
															#line 279 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (static_cast<WriteDataClusterRegistrationActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2172 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<WriteDataClusterRegistrationActor*>(this)->actor_wait_state = 3;
															#line 279 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WriteDataClusterRegistrationActor, 2, bool >*>(static_cast<WriteDataClusterRegistrationActor*>(this)));
															#line 2177 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Optional<MetaclusterRegistrationEntry> const& __metaclusterRegistration,int loopDepth) 
	{
															#line 275 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		metaclusterRegistration = __metaclusterRegistration;
															#line 2186 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Optional<MetaclusterRegistrationEntry> && __metaclusterRegistration,int loopDepth) 
	{
		metaclusterRegistration = std::move(__metaclusterRegistration);
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WriteDataClusterRegistrationActor*>(this)->actor_wait_state > 0) static_cast<WriteDataClusterRegistrationActor*>(this)->actor_wait_state = 0;
		static_cast<WriteDataClusterRegistrationActor*>(this)->ActorCallback< WriteDataClusterRegistrationActor, 1, Optional<MetaclusterRegistrationEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< WriteDataClusterRegistrationActor, 1, Optional<MetaclusterRegistrationEntry> >*,Optional<MetaclusterRegistrationEntry> const& value) 
	{
		fdb_probe_actor_enter("writeDataClusterRegistration", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteDataClusterRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeDataClusterRegistration", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WriteDataClusterRegistrationActor, 1, Optional<MetaclusterRegistrationEntry> >*,Optional<MetaclusterRegistrationEntry> && value) 
	{
		fdb_probe_actor_enter("writeDataClusterRegistration", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteDataClusterRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeDataClusterRegistration", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WriteDataClusterRegistrationActor, 1, Optional<MetaclusterRegistrationEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("writeDataClusterRegistration", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteDataClusterRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeDataClusterRegistration", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont3(bool const& tombstone,int loopDepth) 
	{
															#line 280 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (tombstone)
															#line 2265 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 281 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			CODE_PROBE(true, "Restored cluster removed concurrently");
															#line 282 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			return a_body1cont1loopBody1Catch1(cluster_removed(), loopDepth);
															#line 2271 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		}
															#line 285 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		StrictFuture<Void> __when_expr_3 = lastTenantIdFuture;
															#line 285 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (static_cast<WriteDataClusterRegistrationActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2277 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<WriteDataClusterRegistrationActor*>(this)->actor_wait_state = 4;
															#line 285 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WriteDataClusterRegistrationActor, 3, Void >*>(static_cast<WriteDataClusterRegistrationActor*>(this)));
															#line 2282 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(bool && tombstone,int loopDepth) 
	{
															#line 280 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (tombstone)
															#line 2291 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 281 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			CODE_PROBE(true, "Restored cluster removed concurrently");
															#line 282 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			return a_body1cont1loopBody1Catch1(cluster_removed(), loopDepth);
															#line 2297 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		}
															#line 285 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		StrictFuture<Void> __when_expr_3 = lastTenantIdFuture;
															#line 285 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (static_cast<WriteDataClusterRegistrationActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2303 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<WriteDataClusterRegistrationActor*>(this)->actor_wait_state = 4;
															#line 285 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WriteDataClusterRegistrationActor, 3, Void >*>(static_cast<WriteDataClusterRegistrationActor*>(this)));
															#line 2308 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(bool const& tombstone,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(tombstone, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(bool && tombstone,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(tombstone), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WriteDataClusterRegistrationActor*>(this)->actor_wait_state > 0) static_cast<WriteDataClusterRegistrationActor*>(this)->actor_wait_state = 0;
		static_cast<WriteDataClusterRegistrationActor*>(this)->ActorCallback< WriteDataClusterRegistrationActor, 2, bool >::remove();

	}
	void a_callback_fire(ActorCallback< WriteDataClusterRegistrationActor, 2, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("writeDataClusterRegistration", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteDataClusterRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeDataClusterRegistration", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WriteDataClusterRegistrationActor, 2, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("writeDataClusterRegistration", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteDataClusterRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeDataClusterRegistration", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WriteDataClusterRegistrationActor, 2, bool >*,Error err) 
	{
		fdb_probe_actor_enter("writeDataClusterRegistration", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteDataClusterRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeDataClusterRegistration", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 287 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		dataClusterEntry = self->ctx.metaclusterRegistration.get().toDataClusterRegistration(self->clusterName, self->dataClusterId);
															#line 291 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (metaclusterRegistration.present())
															#line 2394 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 292 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (dataClusterEntry.matches(metaclusterRegistration.get()))
															#line 2398 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			{
				return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
			}
															#line 296 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			TraceEvent(SevWarn, "MetaclusterRestoreClusterAlreadyRegistered") .detail("ExistingRegistration", metaclusterRegistration.get()) .detail("NewRegistration", dataClusterEntry);
															#line 299 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			CODE_PROBE(true, "Restored cluster already registered");
															#line 300 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			return a_body1cont1loopBody1Catch1(cluster_already_registered(), loopDepth);
															#line 2408 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		}
															#line 303 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!self->restoreDryRun)
															#line 2412 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 304 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			StrictFuture<Versionstamp> __when_expr_4 = metadata::maxRestoreId().getD(tr, Snapshot::False, Versionstamp());
															#line 304 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (static_cast<WriteDataClusterRegistrationActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2418 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont1loopBody1cont4when1(__when_expr_4.get(), loopDepth); };
			static_cast<WriteDataClusterRegistrationActor*>(this)->actor_wait_state = 5;
															#line 304 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< WriteDataClusterRegistrationActor, 4, Versionstamp >*>(static_cast<WriteDataClusterRegistrationActor*>(this)));
															#line 2423 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 287 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		dataClusterEntry = self->ctx.metaclusterRegistration.get().toDataClusterRegistration(self->clusterName, self->dataClusterId);
															#line 291 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (metaclusterRegistration.present())
															#line 2439 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 292 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (dataClusterEntry.matches(metaclusterRegistration.get()))
															#line 2443 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			{
				return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
			}
															#line 296 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			TraceEvent(SevWarn, "MetaclusterRestoreClusterAlreadyRegistered") .detail("ExistingRegistration", metaclusterRegistration.get()) .detail("NewRegistration", dataClusterEntry);
															#line 299 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			CODE_PROBE(true, "Restored cluster already registered");
															#line 300 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			return a_body1cont1loopBody1Catch1(cluster_already_registered(), loopDepth);
															#line 2453 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		}
															#line 303 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!self->restoreDryRun)
															#line 2457 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 304 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			StrictFuture<Versionstamp> __when_expr_4 = metadata::maxRestoreId().getD(tr, Snapshot::False, Versionstamp());
															#line 304 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (static_cast<WriteDataClusterRegistrationActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2463 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont1loopBody1cont4when1(__when_expr_4.get(), loopDepth); };
			static_cast<WriteDataClusterRegistrationActor*>(this)->actor_wait_state = 5;
															#line 304 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< WriteDataClusterRegistrationActor, 4, Versionstamp >*>(static_cast<WriteDataClusterRegistrationActor*>(this)));
															#line 2468 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<WriteDataClusterRegistrationActor*>(this)->actor_wait_state > 0) static_cast<WriteDataClusterRegistrationActor*>(this)->actor_wait_state = 0;
		static_cast<WriteDataClusterRegistrationActor*>(this)->ActorCallback< WriteDataClusterRegistrationActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteDataClusterRegistrationActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeDataClusterRegistration", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteDataClusterRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeDataClusterRegistration", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< WriteDataClusterRegistrationActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeDataClusterRegistration", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteDataClusterRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeDataClusterRegistration", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< WriteDataClusterRegistrationActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeDataClusterRegistration", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteDataClusterRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeDataClusterRegistration", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont6(int loopDepth) 
	{
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont9(Versionstamp const& maxRestoreId,int loopDepth) 
	{
															#line 306 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!self->restoreId.replaces(maxRestoreId))
															#line 2563 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 307 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			return a_body1cont1loopBody1Catch1(conflicting_restore(), loopDepth);
															#line 2567 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		}
															#line 310 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		metadata::metaclusterRegistration().set(tr, dataClusterEntry);
															#line 311 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		metadata::activeRestoreIds().addReadConflictKey(tr, self->clusterName);
															#line 312 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		metadata::activeRestoreIds().set(tr, self->clusterName, self->restoreId);
															#line 313 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		metadata::maxRestoreId().set(tr, self->restoreId.versionstamp);
															#line 314 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		StrictFuture<Void> __when_expr_5 = buggifiedCommit(tr, BUGGIFY_WITH_PROB(0.1));
															#line 314 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (static_cast<WriteDataClusterRegistrationActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2581 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont1loopBody1cont9when1(__when_expr_5.get(), loopDepth); };
		static_cast<WriteDataClusterRegistrationActor*>(this)->actor_wait_state = 6;
															#line 314 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< WriteDataClusterRegistrationActor, 5, Void >*>(static_cast<WriteDataClusterRegistrationActor*>(this)));
															#line 2586 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont9(Versionstamp && maxRestoreId,int loopDepth) 
	{
															#line 306 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!self->restoreId.replaces(maxRestoreId))
															#line 2595 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 307 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			return a_body1cont1loopBody1Catch1(conflicting_restore(), loopDepth);
															#line 2599 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		}
															#line 310 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		metadata::metaclusterRegistration().set(tr, dataClusterEntry);
															#line 311 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		metadata::activeRestoreIds().addReadConflictKey(tr, self->clusterName);
															#line 312 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		metadata::activeRestoreIds().set(tr, self->clusterName, self->restoreId);
															#line 313 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		metadata::maxRestoreId().set(tr, self->restoreId.versionstamp);
															#line 314 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		StrictFuture<Void> __when_expr_5 = buggifiedCommit(tr, BUGGIFY_WITH_PROB(0.1));
															#line 314 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (static_cast<WriteDataClusterRegistrationActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2613 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont1loopBody1cont9when1(__when_expr_5.get(), loopDepth); };
		static_cast<WriteDataClusterRegistrationActor*>(this)->actor_wait_state = 6;
															#line 314 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< WriteDataClusterRegistrationActor, 5, Void >*>(static_cast<WriteDataClusterRegistrationActor*>(this)));
															#line 2618 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4when1(Versionstamp const& maxRestoreId,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont9(maxRestoreId, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4when1(Versionstamp && maxRestoreId,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont9(std::move(maxRestoreId), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<WriteDataClusterRegistrationActor*>(this)->actor_wait_state > 0) static_cast<WriteDataClusterRegistrationActor*>(this)->actor_wait_state = 0;
		static_cast<WriteDataClusterRegistrationActor*>(this)->ActorCallback< WriteDataClusterRegistrationActor, 4, Versionstamp >::remove();

	}
	void a_callback_fire(ActorCallback< WriteDataClusterRegistrationActor, 4, Versionstamp >*,Versionstamp const& value) 
	{
		fdb_probe_actor_enter("writeDataClusterRegistration", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteDataClusterRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeDataClusterRegistration", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< WriteDataClusterRegistrationActor, 4, Versionstamp >*,Versionstamp && value) 
	{
		fdb_probe_actor_enter("writeDataClusterRegistration", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteDataClusterRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeDataClusterRegistration", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< WriteDataClusterRegistrationActor, 4, Versionstamp >*,Error err) 
	{
		fdb_probe_actor_enter("writeDataClusterRegistration", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteDataClusterRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeDataClusterRegistration", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont1loopBody1cont10(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont10(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<WriteDataClusterRegistrationActor*>(this)->actor_wait_state > 0) static_cast<WriteDataClusterRegistrationActor*>(this)->actor_wait_state = 0;
		static_cast<WriteDataClusterRegistrationActor*>(this)->ActorCallback< WriteDataClusterRegistrationActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteDataClusterRegistrationActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeDataClusterRegistration", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteDataClusterRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeDataClusterRegistration", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< WriteDataClusterRegistrationActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeDataClusterRegistration", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteDataClusterRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeDataClusterRegistration", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< WriteDataClusterRegistrationActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeDataClusterRegistration", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteDataClusterRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeDataClusterRegistration", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<WriteDataClusterRegistrationActor*>(this)->actor_wait_state > 0) static_cast<WriteDataClusterRegistrationActor*>(this)->actor_wait_state = 0;
		static_cast<WriteDataClusterRegistrationActor*>(this)->ActorCallback< WriteDataClusterRegistrationActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteDataClusterRegistrationActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeDataClusterRegistration", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteDataClusterRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeDataClusterRegistration", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< WriteDataClusterRegistrationActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeDataClusterRegistration", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteDataClusterRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeDataClusterRegistration", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< WriteDataClusterRegistrationActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeDataClusterRegistration", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteDataClusterRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeDataClusterRegistration", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 263 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	RestoreClusterImpl* self;
															#line 264 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	Reference<IDatabase> db;
															#line 265 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	Reference<ITransaction> tr;
															#line 270 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	Future<bool> tombstoneFuture;
															#line 272 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	Future<Void> lastTenantIdFuture;
															#line 275 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	Optional<MetaclusterRegistrationEntry> metaclusterRegistration;
															#line 287 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	MetaclusterRegistrationEntry dataClusterEntry;
															#line 2886 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
};
// This generated class is to be used only via writeDataClusterRegistration()
															#line 263 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
class WriteDataClusterRegistrationActor final : public Actor<Void>, public ActorCallback< WriteDataClusterRegistrationActor, 0, Reference<IDatabase> >, public ActorCallback< WriteDataClusterRegistrationActor, 1, Optional<MetaclusterRegistrationEntry> >, public ActorCallback< WriteDataClusterRegistrationActor, 2, bool >, public ActorCallback< WriteDataClusterRegistrationActor, 3, Void >, public ActorCallback< WriteDataClusterRegistrationActor, 4, Versionstamp >, public ActorCallback< WriteDataClusterRegistrationActor, 5, Void >, public ActorCallback< WriteDataClusterRegistrationActor, 6, Void >, public FastAllocated<WriteDataClusterRegistrationActor>, public WriteDataClusterRegistrationActorState<WriteDataClusterRegistrationActor> {
															#line 2891 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
public:
	using FastAllocated<WriteDataClusterRegistrationActor>::operator new;
	using FastAllocated<WriteDataClusterRegistrationActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15296070566656260096UL, 13919497087845893120UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WriteDataClusterRegistrationActor, 0, Reference<IDatabase> >;
friend struct ActorCallback< WriteDataClusterRegistrationActor, 1, Optional<MetaclusterRegistrationEntry> >;
friend struct ActorCallback< WriteDataClusterRegistrationActor, 2, bool >;
friend struct ActorCallback< WriteDataClusterRegistrationActor, 3, Void >;
friend struct ActorCallback< WriteDataClusterRegistrationActor, 4, Versionstamp >;
friend struct ActorCallback< WriteDataClusterRegistrationActor, 5, Void >;
friend struct ActorCallback< WriteDataClusterRegistrationActor, 6, Void >;
															#line 263 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	WriteDataClusterRegistrationActor(RestoreClusterImpl* const& self) 
															#line 2914 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		 : Actor<Void>(),
		   WriteDataClusterRegistrationActorState<WriteDataClusterRegistrationActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("writeDataClusterRegistration", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2237345957463001088UL, 17919399585933296640UL);
		ActorExecutionContextHelper __helper(static_cast<WriteDataClusterRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("writeDataClusterRegistration");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("writeDataClusterRegistration", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WriteDataClusterRegistrationActor, 0, Reference<IDatabase> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WriteDataClusterRegistrationActor, 1, Optional<MetaclusterRegistrationEntry> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WriteDataClusterRegistrationActor, 2, bool >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< WriteDataClusterRegistrationActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< WriteDataClusterRegistrationActor, 4, Versionstamp >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< WriteDataClusterRegistrationActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< WriteDataClusterRegistrationActor, 6, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 263 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
[[nodiscard]] static Future<Void> writeDataClusterRegistration( RestoreClusterImpl* const& self ) {
															#line 263 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	return Future<Void>(new WriteDataClusterRegistrationActor(self));
															#line 2952 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
}

#line 325 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"

																#line 2957 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
// This generated class is to be used only via markClusterRestoring()
															#line 326 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
template <class MarkClusterRestoringActor>
															#line 326 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
class MarkClusterRestoringActorState {
															#line 2963 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
public:
															#line 326 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	MarkClusterRestoringActorState(RestoreClusterImpl* const& self,Reference<typename DB::TransactionT> const& tr) 
															#line 326 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
															#line 326 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		 : self(self),
															#line 326 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		   tr(tr)
															#line 2972 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
	{
		fdb_probe_actor_create("markClusterRestoring", reinterpret_cast<unsigned long>(this));

	}
	~MarkClusterRestoringActorState() 
	{
		fdb_probe_actor_destroy("markClusterRestoring", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 328 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			metadata::activeRestoreIds().addReadConflictKey(tr, self->clusterName);
															#line 329 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			restoreId = metadata::RestoreId::createRestoreId(tr, metadata::activeRestoreIds(), self->clusterName);
															#line 331 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (self->ctx.dataClusterMetadata.get().entry.clusterState != DataClusterState::RESTORING)
															#line 2991 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			{
															#line 332 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				DataClusterEntry updatedEntry = self->ctx.dataClusterMetadata.get().entry;
															#line 333 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				updatedEntry.clusterState = DataClusterState::RESTORING;
															#line 335 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				updateClusterMetadata( tr, self->clusterName, self->ctx.dataClusterMetadata.get(), self->connectionString, updatedEntry);
															#line 340 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				DataClusterEntry noCapacityEntry = updatedEntry;
															#line 341 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				noCapacityEntry.capacity.numTenantGroups = 0;
															#line 342 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				internal::updateClusterCapacityIndex(tr, self->clusterName, updatedEntry, noCapacityEntry);
															#line 3005 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			}
			else
			{
															#line 344 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				CODE_PROBE(true, "Mark cluster restoring already complete");
															#line 3011 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			}
															#line 347 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			StrictFuture<Void> __when_expr_0 = loadTenantIdData(self, tr);
															#line 347 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (static_cast<MarkClusterRestoringActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3017 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MarkClusterRestoringActor*>(this)->actor_wait_state = 1;
															#line 347 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MarkClusterRestoringActor, 0, Void >*>(static_cast<MarkClusterRestoringActor*>(this)));
															#line 3022 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MarkClusterRestoringActorState();
		static_cast<MarkClusterRestoringActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 349 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		TraceEvent("MarkedDataClusterRestoring").detail("Name", self->clusterName);
															#line 350 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!static_cast<MarkClusterRestoringActor*>(this)->SAV<metadata::RestoreId>::futures) { (void)(restoreId); this->~MarkClusterRestoringActorState(); static_cast<MarkClusterRestoringActor*>(this)->destroy(); return 0; }
															#line 3047 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		new (&static_cast<MarkClusterRestoringActor*>(this)->SAV< metadata::RestoreId >::value()) metadata::RestoreId(std::move(restoreId)); // state_var_RVO
		this->~MarkClusterRestoringActorState();
		static_cast<MarkClusterRestoringActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 349 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		TraceEvent("MarkedDataClusterRestoring").detail("Name", self->clusterName);
															#line 350 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!static_cast<MarkClusterRestoringActor*>(this)->SAV<metadata::RestoreId>::futures) { (void)(restoreId); this->~MarkClusterRestoringActorState(); static_cast<MarkClusterRestoringActor*>(this)->destroy(); return 0; }
															#line 3061 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		new (&static_cast<MarkClusterRestoringActor*>(this)->SAV< metadata::RestoreId >::value()) metadata::RestoreId(std::move(restoreId)); // state_var_RVO
		this->~MarkClusterRestoringActorState();
		static_cast<MarkClusterRestoringActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MarkClusterRestoringActor*>(this)->actor_wait_state > 0) static_cast<MarkClusterRestoringActor*>(this)->actor_wait_state = 0;
		static_cast<MarkClusterRestoringActor*>(this)->ActorCallback< MarkClusterRestoringActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MarkClusterRestoringActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("markClusterRestoring", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MarkClusterRestoringActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("markClusterRestoring", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MarkClusterRestoringActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("markClusterRestoring", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MarkClusterRestoringActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("markClusterRestoring", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MarkClusterRestoringActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("markClusterRestoring", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MarkClusterRestoringActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("markClusterRestoring", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 326 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	RestoreClusterImpl* self;
															#line 326 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	Reference<typename DB::TransactionT> tr;
															#line 329 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	metadata::RestoreId restoreId;
															#line 3150 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
};
// This generated class is to be used only via markClusterRestoring()
															#line 326 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
class MarkClusterRestoringActor final : public Actor<metadata::RestoreId>, public ActorCallback< MarkClusterRestoringActor, 0, Void >, public FastAllocated<MarkClusterRestoringActor>, public MarkClusterRestoringActorState<MarkClusterRestoringActor> {
															#line 3155 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
public:
	using FastAllocated<MarkClusterRestoringActor>::operator new;
	using FastAllocated<MarkClusterRestoringActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10152566968778956800UL, 4416274679839135232UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<metadata::RestoreId>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MarkClusterRestoringActor, 0, Void >;
															#line 326 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	MarkClusterRestoringActor(RestoreClusterImpl* const& self,Reference<typename DB::TransactionT> const& tr) 
															#line 3172 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		 : Actor<metadata::RestoreId>(),
		   MarkClusterRestoringActorState<MarkClusterRestoringActor>(self, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("markClusterRestoring", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3321941822977004288UL, 6982904015475757056UL);
		ActorExecutionContextHelper __helper(static_cast<MarkClusterRestoringActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("markClusterRestoring");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("markClusterRestoring", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MarkClusterRestoringActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 326 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
[[nodiscard]] static Future<metadata::RestoreId> markClusterRestoring( RestoreClusterImpl* const& self, Reference<typename DB::TransactionT> const& tr ) {
															#line 326 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	return Future<metadata::RestoreId>(new MarkClusterRestoringActor(self, tr));
															#line 3204 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
}

#line 352 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"

	Future<Void> markClusterAsReady(Reference<typename DB::TransactionT> tr) {
		if (ctx.dataClusterMetadata.get().entry.clusterState == DataClusterState::RESTORING) {
			DataClusterEntry updatedEntry = ctx.dataClusterMetadata.get().entry;
			updatedEntry.clusterState = DataClusterState::READY;

			updateClusterMetadata(tr, clusterName, ctx.dataClusterMetadata.get(), {}, updatedEntry);

			// Add this cluster back to the cluster capacity index so that it can be assigned to again.
			DataClusterEntry noCapacityEntry = updatedEntry;
			noCapacityEntry.capacity.numTenantGroups = 0;
			internal::updateClusterCapacityIndex(tr, clusterName, noCapacityEntry, updatedEntry);

			return success(eraseRestoreId(this, tr));
		} else {
			CODE_PROBE(true, "Mark cluster ready already complete");
		}

		return Void();
	}

																#line 3229 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
// This generated class is to be used only via markManagementTenantsAsError()
															#line 373 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
template <class MarkManagementTenantsAsErrorActor>
															#line 373 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
class MarkManagementTenantsAsErrorActorState {
															#line 3235 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
public:
															#line 373 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	MarkManagementTenantsAsErrorActorState(RestoreClusterImpl* const& self,Reference<typename DB::TransactionT> const& tr,std::vector<int64_t> const& tenants) 
															#line 373 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
															#line 373 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		 : self(self),
															#line 373 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		   tr(tr),
															#line 373 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		   tenants(tenants)
															#line 3246 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
	{
		fdb_probe_actor_create("markManagementTenantsAsError", reinterpret_cast<unsigned long>(this));

	}
	~MarkManagementTenantsAsErrorActorState() 
	{
		fdb_probe_actor_destroy("markManagementTenantsAsError", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 376 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			ASSERT(!self->restoreDryRun);
															#line 377 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			getFutures = std::vector<Future<Optional<MetaclusterTenantMapEntry>>>();
															#line 378 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			for( auto tenantId : tenants ) {
															#line 379 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				getFutures.push_back(tryGetTenantTransaction(tr, tenantId));
															#line 3267 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			}
															#line 382 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			StrictFuture<Void> __when_expr_0 = waitForAll(getFutures);
															#line 382 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (static_cast<MarkManagementTenantsAsErrorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3273 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MarkManagementTenantsAsErrorActor*>(this)->actor_wait_state = 1;
															#line 382 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MarkManagementTenantsAsErrorActor, 0, Void >*>(static_cast<MarkManagementTenantsAsErrorActor*>(this)));
															#line 3278 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MarkManagementTenantsAsErrorActorState();
		static_cast<MarkManagementTenantsAsErrorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 384 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		for( auto const& f : getFutures ) {
															#line 385 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (!f.get().present())
															#line 3303 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			{
				continue;
			}
															#line 389 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			MetaclusterTenantMapEntry entry = f.get().get();
															#line 390 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			entry.tenantState = TenantState::ERROR;
															#line 391 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			entry.error = "The tenant is missing after restoring its data cluster";
															#line 392 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			metadata::management::tenantMetadata().tenantMap.set(tr, entry.id, entry);
															#line 394 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			CODE_PROBE(true, "Mark management tenant in error state");
															#line 3317 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		}
															#line 397 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!static_cast<MarkManagementTenantsAsErrorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MarkManagementTenantsAsErrorActorState(); static_cast<MarkManagementTenantsAsErrorActor*>(this)->destroy(); return 0; }
															#line 3321 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		new (&static_cast<MarkManagementTenantsAsErrorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~MarkManagementTenantsAsErrorActorState();
		static_cast<MarkManagementTenantsAsErrorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 384 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		for( auto const& f : getFutures ) {
															#line 385 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (!f.get().present())
															#line 3335 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			{
				continue;
			}
															#line 389 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			MetaclusterTenantMapEntry entry = f.get().get();
															#line 390 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			entry.tenantState = TenantState::ERROR;
															#line 391 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			entry.error = "The tenant is missing after restoring its data cluster";
															#line 392 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			metadata::management::tenantMetadata().tenantMap.set(tr, entry.id, entry);
															#line 394 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			CODE_PROBE(true, "Mark management tenant in error state");
															#line 3349 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		}
															#line 397 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!static_cast<MarkManagementTenantsAsErrorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MarkManagementTenantsAsErrorActorState(); static_cast<MarkManagementTenantsAsErrorActor*>(this)->destroy(); return 0; }
															#line 3353 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		new (&static_cast<MarkManagementTenantsAsErrorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~MarkManagementTenantsAsErrorActorState();
		static_cast<MarkManagementTenantsAsErrorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MarkManagementTenantsAsErrorActor*>(this)->actor_wait_state > 0) static_cast<MarkManagementTenantsAsErrorActor*>(this)->actor_wait_state = 0;
		static_cast<MarkManagementTenantsAsErrorActor*>(this)->ActorCallback< MarkManagementTenantsAsErrorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MarkManagementTenantsAsErrorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("markManagementTenantsAsError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MarkManagementTenantsAsErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("markManagementTenantsAsError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MarkManagementTenantsAsErrorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("markManagementTenantsAsError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MarkManagementTenantsAsErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("markManagementTenantsAsError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MarkManagementTenantsAsErrorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("markManagementTenantsAsError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MarkManagementTenantsAsErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("markManagementTenantsAsError", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 373 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	RestoreClusterImpl* self;
															#line 373 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	Reference<typename DB::TransactionT> tr;
															#line 373 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	std::vector<int64_t> tenants;
															#line 377 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	std::vector<Future<Optional<MetaclusterTenantMapEntry>>> getFutures;
															#line 3444 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
};
// This generated class is to be used only via markManagementTenantsAsError()
															#line 373 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
class MarkManagementTenantsAsErrorActor final : public Actor<Void>, public ActorCallback< MarkManagementTenantsAsErrorActor, 0, Void >, public FastAllocated<MarkManagementTenantsAsErrorActor>, public MarkManagementTenantsAsErrorActorState<MarkManagementTenantsAsErrorActor> {
															#line 3449 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
public:
	using FastAllocated<MarkManagementTenantsAsErrorActor>::operator new;
	using FastAllocated<MarkManagementTenantsAsErrorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9582293223365846016UL, 13275313202736998144UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MarkManagementTenantsAsErrorActor, 0, Void >;
															#line 373 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	MarkManagementTenantsAsErrorActor(RestoreClusterImpl* const& self,Reference<typename DB::TransactionT> const& tr,std::vector<int64_t> const& tenants) 
															#line 3466 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		 : Actor<Void>(),
		   MarkManagementTenantsAsErrorActorState<MarkManagementTenantsAsErrorActor>(self, tr, tenants),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("markManagementTenantsAsError", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13195600400243457536UL, 1662614133080850944UL);
		ActorExecutionContextHelper __helper(static_cast<MarkManagementTenantsAsErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("markManagementTenantsAsError");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("markManagementTenantsAsError", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MarkManagementTenantsAsErrorActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 373 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
[[nodiscard]] static Future<Void> markManagementTenantsAsError( RestoreClusterImpl* const& self, Reference<typename DB::TransactionT> const& tr, std::vector<int64_t> const& tenants ) {
															#line 373 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	return Future<Void>(new MarkManagementTenantsAsErrorActor(self, tr, tenants));
															#line 3498 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
}

#line 399 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"

																#line 3503 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
// This generated class is to be used only via getTenantsFromDataCluster()
															#line 400 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
template <class GetTenantsFromDataClusterActor>
															#line 400 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
class GetTenantsFromDataClusterActorState {
															#line 3509 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
public:
															#line 400 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	GetTenantsFromDataClusterActorState(RestoreClusterImpl* const& self,Reference<ITransaction> const& tr) 
															#line 400 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
															#line 400 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		 : self(self),
															#line 400 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		   tr(tr)
															#line 3518 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
	{
		fdb_probe_actor_create("getTenantsFromDataCluster", reinterpret_cast<unsigned long>(this));

	}
	~GetTenantsFromDataClusterActorState() 
	{
		fdb_probe_actor_destroy("getTenantsFromDataCluster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 401 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			StrictFuture<KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>>> __when_expr_0 = TenantMetadata::tenantMap().getRange(tr, {}, {}, CLIENT_KNOBS->MAX_TENANTS_PER_CLUSTER);
															#line 401 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (static_cast<GetTenantsFromDataClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3535 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetTenantsFromDataClusterActor*>(this)->actor_wait_state = 1;
															#line 401 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetTenantsFromDataClusterActor, 0, KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> >*>(static_cast<GetTenantsFromDataClusterActor*>(this)));
															#line 3540 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetTenantsFromDataClusterActorState();
		static_cast<GetTenantsFromDataClusterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 404 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		for( auto const& t : tenants.results ) {
															#line 405 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			self->dataClusterTenantMap.emplace(t.first, t.second);
															#line 406 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			self->dataClusterTenantNames.insert(t.second.tenantName);
															#line 3567 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		}
															#line 409 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!static_cast<GetTenantsFromDataClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetTenantsFromDataClusterActorState(); static_cast<GetTenantsFromDataClusterActor*>(this)->destroy(); return 0; }
															#line 3571 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		new (&static_cast<GetTenantsFromDataClusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetTenantsFromDataClusterActorState();
		static_cast<GetTenantsFromDataClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> const& __tenants,int loopDepth) 
	{
															#line 401 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		tenants = __tenants;
															#line 3583 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> && __tenants,int loopDepth) 
	{
		tenants = std::move(__tenants);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetTenantsFromDataClusterActor*>(this)->actor_wait_state > 0) static_cast<GetTenantsFromDataClusterActor*>(this)->actor_wait_state = 0;
		static_cast<GetTenantsFromDataClusterActor*>(this)->ActorCallback< GetTenantsFromDataClusterActor, 0, KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> >::remove();

	}
	void a_callback_fire(ActorCallback< GetTenantsFromDataClusterActor, 0, KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> >*,KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> const& value) 
	{
		fdb_probe_actor_enter("getTenantsFromDataCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantsFromDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenantsFromDataCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetTenantsFromDataClusterActor, 0, KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> >*,KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> && value) 
	{
		fdb_probe_actor_enter("getTenantsFromDataCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantsFromDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenantsFromDataCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetTenantsFromDataClusterActor, 0, KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> >*,Error err) 
	{
		fdb_probe_actor_enter("getTenantsFromDataCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantsFromDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenantsFromDataCluster", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 400 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	RestoreClusterImpl* self;
															#line 400 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	Reference<ITransaction> tr;
															#line 401 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> tenants;
															#line 3664 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
};
// This generated class is to be used only via getTenantsFromDataCluster()
															#line 400 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
class GetTenantsFromDataClusterActor final : public Actor<Void>, public ActorCallback< GetTenantsFromDataClusterActor, 0, KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> >, public FastAllocated<GetTenantsFromDataClusterActor>, public GetTenantsFromDataClusterActorState<GetTenantsFromDataClusterActor> {
															#line 3669 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
public:
	using FastAllocated<GetTenantsFromDataClusterActor>::operator new;
	using FastAllocated<GetTenantsFromDataClusterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12694546632440871168UL, 2538616130013799936UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetTenantsFromDataClusterActor, 0, KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> >;
															#line 400 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	GetTenantsFromDataClusterActor(RestoreClusterImpl* const& self,Reference<ITransaction> const& tr) 
															#line 3686 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		 : Actor<Void>(),
		   GetTenantsFromDataClusterActorState<GetTenantsFromDataClusterActor>(self, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getTenantsFromDataCluster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3160030221519466752UL, 7026392273507991552UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantsFromDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getTenantsFromDataCluster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getTenantsFromDataCluster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetTenantsFromDataClusterActor, 0, KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 400 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
[[nodiscard]] static Future<Void> getTenantsFromDataCluster( RestoreClusterImpl* const& self, Reference<ITransaction> const& tr ) {
															#line 400 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	return Future<Void>(new GetTenantsFromDataClusterActor(self, tr));
															#line 3718 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
}

#line 411 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"

																#line 3723 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
// This generated class is to be used only via getTenantsFromManagementCluster()
															#line 412 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
template <class GetTenantsFromManagementClusterActor>
															#line 412 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
class GetTenantsFromManagementClusterActorState {
															#line 3729 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
public:
															#line 412 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	GetTenantsFromManagementClusterActorState(RestoreClusterImpl* const& self,Reference<typename DB::TransactionT> const& tr,int64_t const& initialTenantId) 
															#line 412 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
															#line 412 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		 : self(self),
															#line 412 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		   tr(tr),
															#line 412 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		   initialTenantId(initialTenantId)
															#line 3740 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
	{
		fdb_probe_actor_create("getTenantsFromManagementCluster", reinterpret_cast<unsigned long>(this));

	}
	~GetTenantsFromManagementClusterActorState() 
	{
		fdb_probe_actor_destroy("getTenantsFromManagementCluster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 415 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			StrictFuture<KeyBackedRangeResult<std::pair<int64_t, MetaclusterTenantMapEntry>>> __when_expr_0 = metadata::management::tenantMetadata().tenantMap.getRange( tr, initialTenantId, {}, CLIENT_KNOBS->MAX_TENANTS_PER_CLUSTER);
															#line 415 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (static_cast<GetTenantsFromManagementClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3757 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetTenantsFromManagementClusterActor*>(this)->actor_wait_state = 1;
															#line 415 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetTenantsFromManagementClusterActor, 0, KeyBackedRangeResult<std::pair<int64_t, MetaclusterTenantMapEntry>> >*>(static_cast<GetTenantsFromManagementClusterActor*>(this)));
															#line 3762 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetTenantsFromManagementClusterActorState();
		static_cast<GetTenantsFromManagementClusterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 418 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		for( auto const& t : tenants.results ) {
															#line 419 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			self->mgmtClusterTenantMap.emplace(t.first, t.second);
															#line 420 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (self->clusterName == t.second.assignedCluster)
															#line 3789 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			{
															#line 421 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				self->mgmtClusterTenantSetForCurrentDataCluster.emplace(t.first);
															#line 3793 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			}
		}
															#line 425 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!static_cast<GetTenantsFromManagementClusterActor*>(this)->SAV<Optional<int64_t>>::futures) { (void)(tenants.more ? Optional<int64_t>(tenants.results.rbegin()->first + 1) : Optional<int64_t>()); this->~GetTenantsFromManagementClusterActorState(); static_cast<GetTenantsFromManagementClusterActor*>(this)->destroy(); return 0; }
															#line 3798 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		new (&static_cast<GetTenantsFromManagementClusterActor*>(this)->SAV< Optional<int64_t> >::value()) Optional<int64_t>(tenants.more ? Optional<int64_t>(tenants.results.rbegin()->first + 1) : Optional<int64_t>());
		this->~GetTenantsFromManagementClusterActorState();
		static_cast<GetTenantsFromManagementClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(KeyBackedRangeResult<std::pair<int64_t, MetaclusterTenantMapEntry>> const& __tenants,int loopDepth) 
	{
															#line 415 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		tenants = __tenants;
															#line 3810 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(KeyBackedRangeResult<std::pair<int64_t, MetaclusterTenantMapEntry>> && __tenants,int loopDepth) 
	{
		tenants = std::move(__tenants);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetTenantsFromManagementClusterActor*>(this)->actor_wait_state > 0) static_cast<GetTenantsFromManagementClusterActor*>(this)->actor_wait_state = 0;
		static_cast<GetTenantsFromManagementClusterActor*>(this)->ActorCallback< GetTenantsFromManagementClusterActor, 0, KeyBackedRangeResult<std::pair<int64_t, MetaclusterTenantMapEntry>> >::remove();

	}
	void a_callback_fire(ActorCallback< GetTenantsFromManagementClusterActor, 0, KeyBackedRangeResult<std::pair<int64_t, MetaclusterTenantMapEntry>> >*,KeyBackedRangeResult<std::pair<int64_t, MetaclusterTenantMapEntry>> const& value) 
	{
		fdb_probe_actor_enter("getTenantsFromManagementCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantsFromManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenantsFromManagementCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetTenantsFromManagementClusterActor, 0, KeyBackedRangeResult<std::pair<int64_t, MetaclusterTenantMapEntry>> >*,KeyBackedRangeResult<std::pair<int64_t, MetaclusterTenantMapEntry>> && value) 
	{
		fdb_probe_actor_enter("getTenantsFromManagementCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantsFromManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenantsFromManagementCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetTenantsFromManagementClusterActor, 0, KeyBackedRangeResult<std::pair<int64_t, MetaclusterTenantMapEntry>> >*,Error err) 
	{
		fdb_probe_actor_enter("getTenantsFromManagementCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantsFromManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenantsFromManagementCluster", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 412 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	RestoreClusterImpl* self;
															#line 412 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	Reference<typename DB::TransactionT> tr;
															#line 412 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	int64_t initialTenantId;
															#line 415 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	KeyBackedRangeResult<std::pair<int64_t, MetaclusterTenantMapEntry>> tenants;
															#line 3893 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
};
// This generated class is to be used only via getTenantsFromManagementCluster()
															#line 412 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
class GetTenantsFromManagementClusterActor final : public Actor<Optional<int64_t>>, public ActorCallback< GetTenantsFromManagementClusterActor, 0, KeyBackedRangeResult<std::pair<int64_t, MetaclusterTenantMapEntry>> >, public FastAllocated<GetTenantsFromManagementClusterActor>, public GetTenantsFromManagementClusterActorState<GetTenantsFromManagementClusterActor> {
															#line 3898 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
public:
	using FastAllocated<GetTenantsFromManagementClusterActor>::operator new;
	using FastAllocated<GetTenantsFromManagementClusterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14087454245498840832UL, 7823050081030342144UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<int64_t>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetTenantsFromManagementClusterActor, 0, KeyBackedRangeResult<std::pair<int64_t, MetaclusterTenantMapEntry>> >;
															#line 412 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	GetTenantsFromManagementClusterActor(RestoreClusterImpl* const& self,Reference<typename DB::TransactionT> const& tr,int64_t const& initialTenantId) 
															#line 3915 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		 : Actor<Optional<int64_t>>(),
		   GetTenantsFromManagementClusterActorState<GetTenantsFromManagementClusterActor>(self, tr, initialTenantId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getTenantsFromManagementCluster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(40269620399493376UL, 16103939707198421248UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantsFromManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getTenantsFromManagementCluster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getTenantsFromManagementCluster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetTenantsFromManagementClusterActor, 0, KeyBackedRangeResult<std::pair<int64_t, MetaclusterTenantMapEntry>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 412 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
[[nodiscard]] static Future<Optional<int64_t>> getTenantsFromManagementCluster( RestoreClusterImpl* const& self, Reference<typename DB::TransactionT> const& tr, int64_t const& initialTenantId ) {
															#line 412 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	return Future<Optional<int64_t>>(new GetTenantsFromManagementClusterActor(self, tr, initialTenantId));
															#line 3947 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
}

#line 427 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"

																#line 3952 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
// This generated class is to be used only via getAllTenantsFromManagementCluster()
															#line 428 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
template <class GetAllTenantsFromManagementClusterActor>
															#line 428 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
class GetAllTenantsFromManagementClusterActorState {
															#line 3958 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
public:
															#line 428 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	GetAllTenantsFromManagementClusterActorState(RestoreClusterImpl* const& self) 
															#line 428 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
															#line 428 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		 : self(self),
															#line 430 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		   beginTenant(0)
															#line 3967 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
	{
		fdb_probe_actor_create("getAllTenantsFromManagementCluster", reinterpret_cast<unsigned long>(this));

	}
	~GetAllTenantsFromManagementClusterActorState() 
	{
		fdb_probe_actor_destroy("getAllTenantsFromManagementCluster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 431 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			;
															#line 3982 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetAllTenantsFromManagementClusterActorState();
		static_cast<GetAllTenantsFromManagementClusterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 440 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!static_cast<GetAllTenantsFromManagementClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetAllTenantsFromManagementClusterActorState(); static_cast<GetAllTenantsFromManagementClusterActor*>(this)->destroy(); return 0; }
															#line 4005 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		new (&static_cast<GetAllTenantsFromManagementClusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetAllTenantsFromManagementClusterActorState();
		static_cast<GetAllTenantsFromManagementClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 431 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!(beginTenant.present()))
															#line 4024 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 432 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		StrictFuture<Void> __when_expr_0 = store(beginTenant, self->runRestoreManagementTransaction( [self = self, beginTenant = beginTenant](Reference<typename DB::TransactionT> tr) { return getTenantsFromManagementCluster(self, tr, beginTenant.get()); }));
															#line 432 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (static_cast<GetAllTenantsFromManagementClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4032 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<GetAllTenantsFromManagementClusterActor*>(this)->actor_wait_state = 1;
															#line 432 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetAllTenantsFromManagementClusterActor, 0, Void >*>(static_cast<GetAllTenantsFromManagementClusterActor*>(this)));
															#line 4037 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 437 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		CODE_PROBE(beginTenant.present(), "Multiple management cluster tenant batches");
															#line 4059 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 437 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		CODE_PROBE(beginTenant.present(), "Multiple management cluster tenant batches");
															#line 4068 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetAllTenantsFromManagementClusterActor*>(this)->actor_wait_state > 0) static_cast<GetAllTenantsFromManagementClusterActor*>(this)->actor_wait_state = 0;
		static_cast<GetAllTenantsFromManagementClusterActor*>(this)->ActorCallback< GetAllTenantsFromManagementClusterActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetAllTenantsFromManagementClusterActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getAllTenantsFromManagementCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAllTenantsFromManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAllTenantsFromManagementCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetAllTenantsFromManagementClusterActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getAllTenantsFromManagementCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAllTenantsFromManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAllTenantsFromManagementCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetAllTenantsFromManagementClusterActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getAllTenantsFromManagementCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAllTenantsFromManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAllTenantsFromManagementCluster", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 428 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	RestoreClusterImpl* self;
															#line 430 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	Optional<int64_t> beginTenant;
															#line 4152 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
};
// This generated class is to be used only via getAllTenantsFromManagementCluster()
															#line 428 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
class GetAllTenantsFromManagementClusterActor final : public Actor<Void>, public ActorCallback< GetAllTenantsFromManagementClusterActor, 0, Void >, public FastAllocated<GetAllTenantsFromManagementClusterActor>, public GetAllTenantsFromManagementClusterActorState<GetAllTenantsFromManagementClusterActor> {
															#line 4157 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
public:
	using FastAllocated<GetAllTenantsFromManagementClusterActor>::operator new;
	using FastAllocated<GetAllTenantsFromManagementClusterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9710515023864884992UL, 14429950748013435136UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetAllTenantsFromManagementClusterActor, 0, Void >;
															#line 428 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	GetAllTenantsFromManagementClusterActor(RestoreClusterImpl* const& self) 
															#line 4174 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		 : Actor<Void>(),
		   GetAllTenantsFromManagementClusterActorState<GetAllTenantsFromManagementClusterActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getAllTenantsFromManagementCluster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10043327586874685696UL, 13525779184841989376UL);
		ActorExecutionContextHelper __helper(static_cast<GetAllTenantsFromManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getAllTenantsFromManagementCluster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getAllTenantsFromManagementCluster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetAllTenantsFromManagementClusterActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 428 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
[[nodiscard]] static Future<Void> getAllTenantsFromManagementCluster( RestoreClusterImpl* const& self ) {
															#line 428 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	return Future<Void>(new GetAllTenantsFromManagementClusterActor(self));
															#line 4206 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
}

#line 442 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"

																#line 4211 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
// This generated class is to be used only via renameTenant()
															#line 443 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
template <class RenameTenantActor>
															#line 443 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
class RenameTenantActorState {
															#line 4217 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
public:
															#line 443 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	RenameTenantActorState(RestoreClusterImpl* const& self,Reference<ITransaction> const& tr,int64_t const& tenantId,TenantName const& oldTenantName,TenantName const& newTenantName,int const& configurationSequenceNum) 
															#line 443 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
															#line 443 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		 : self(self),
															#line 443 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		   tr(tr),
															#line 443 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		   tenantId(tenantId),
															#line 443 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		   oldTenantName(oldTenantName),
															#line 443 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		   newTenantName(newTenantName),
															#line 443 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		   configurationSequenceNum(configurationSequenceNum),
															#line 449 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		   entry(),
															#line 450 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		   newId()
															#line 4238 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
	{
		fdb_probe_actor_create("renameTenant", reinterpret_cast<unsigned long>(this));

	}
	~RenameTenantActorState() 
	{
		fdb_probe_actor_destroy("renameTenant", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 452 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			StrictFuture<Void> __when_expr_0 = store(entry, TenantAPI::tryGetTenantTransaction(tr, tenantId)) && store(newId, TenantMetadata::tenantNameIndex().get(tr, newTenantName));
															#line 452 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (static_cast<RenameTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4255 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RenameTenantActor*>(this)->actor_wait_state = 1;
															#line 452 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RenameTenantActor, 0, Void >*>(static_cast<RenameTenantActor*>(this)));
															#line 4260 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RenameTenantActorState();
		static_cast<RenameTenantActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 455 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (entry.present())
															#line 4283 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 456 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (entry.get().tenantName == oldTenantName && !newId.present())
															#line 4287 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			{
															#line 457 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				StrictFuture<Void> __when_expr_1 = TenantAPI::renameTenantTransaction(tr, oldTenantName, newTenantName, tenantId, ClusterType::METACLUSTER_DATA, configurationSequenceNum);
															#line 457 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				if (static_cast<RenameTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4293 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
				static_cast<RenameTenantActor*>(this)->actor_wait_state = 2;
															#line 457 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RenameTenantActor, 1, Void >*>(static_cast<RenameTenantActor*>(this)));
															#line 4298 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
				loopDepth = 0;
			}
			else
			{
															#line 465 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				if (entry.get().tenantName == newTenantName && newId.present() && newId.get() == tenantId)
															#line 4305 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
				{
															#line 467 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
					CODE_PROBE(true, "Rename tenant during cluster restore already completed");
															#line 468 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
					if (!static_cast<RenameTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RenameTenantActorState(); static_cast<RenameTenantActor*>(this)->destroy(); return 0; }
															#line 4311 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
					new (&static_cast<RenameTenantActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~RenameTenantActorState();
					static_cast<RenameTenantActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
				loopDepth = a_body1cont3(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 455 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (entry.present())
															#line 4331 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 456 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (entry.get().tenantName == oldTenantName && !newId.present())
															#line 4335 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			{
															#line 457 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				StrictFuture<Void> __when_expr_1 = TenantAPI::renameTenantTransaction(tr, oldTenantName, newTenantName, tenantId, ClusterType::METACLUSTER_DATA, configurationSequenceNum);
															#line 457 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				if (static_cast<RenameTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4341 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
				static_cast<RenameTenantActor*>(this)->actor_wait_state = 2;
															#line 457 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RenameTenantActor, 1, Void >*>(static_cast<RenameTenantActor*>(this)));
															#line 4346 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
				loopDepth = 0;
			}
			else
			{
															#line 465 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				if (entry.get().tenantName == newTenantName && newId.present() && newId.get() == tenantId)
															#line 4353 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
				{
															#line 467 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
					CODE_PROBE(true, "Rename tenant during cluster restore already completed");
															#line 468 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
					if (!static_cast<RenameTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RenameTenantActorState(); static_cast<RenameTenantActor*>(this)->destroy(); return 0; }
															#line 4359 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
					new (&static_cast<RenameTenantActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~RenameTenantActorState();
					static_cast<RenameTenantActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
				loopDepth = a_body1cont3(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RenameTenantActor*>(this)->actor_wait_state > 0) static_cast<RenameTenantActor*>(this)->actor_wait_state = 0;
		static_cast<RenameTenantActor*>(this)->ActorCallback< RenameTenantActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RenameTenantActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RenameTenantActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RenameTenantActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 472 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		TraceEvent(SevWarnAlways, "RestoreDataClusterRenameError") .detail("OldName", oldTenantName) .detail("NewName", newTenantName) .detail("TenantID", tenantId) .detail("ActualTenantName", entry.map(&TenantMapEntry::tenantName)) .detail("OldEntryPresent", entry.present()) .detail("NewEntryPresent", newId.present());
															#line 480 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (newId.present())
															#line 4456 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 481 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			CODE_PROBE(true, "Rename tenant already exists");
															#line 482 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			self->messages.push_back( fmt::format("Failed to rename the tenant `{}' to `{}' because the new name is already in use", printable(oldTenantName), printable(newTenantName)));
															#line 486 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			return a_body1Catch1(tenant_already_exists(), loopDepth);
															#line 4464 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		}
		else
		{
															#line 488 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			CODE_PROBE(true, "Rename tenant wrong ID");
															#line 489 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			self->messages.push_back(fmt::format( "Failed to rename the tenant `{}' to `{}' because the tenant did not have the expected ID {}", printable(oldTenantName), printable(newTenantName), tenantId));
															#line 494 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			return a_body1Catch1(tenant_not_found(), loopDepth);
															#line 4474 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		}

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 463 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		CODE_PROBE(true, "Rename tenant during cluster restore");
															#line 464 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!static_cast<RenameTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RenameTenantActorState(); static_cast<RenameTenantActor*>(this)->destroy(); return 0; }
															#line 4491 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		new (&static_cast<RenameTenantActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RenameTenantActorState();
		static_cast<RenameTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 463 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		CODE_PROBE(true, "Rename tenant during cluster restore");
															#line 464 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!static_cast<RenameTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RenameTenantActorState(); static_cast<RenameTenantActor*>(this)->destroy(); return 0; }
															#line 4505 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		new (&static_cast<RenameTenantActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RenameTenantActorState();
		static_cast<RenameTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RenameTenantActor*>(this)->actor_wait_state > 0) static_cast<RenameTenantActor*>(this)->actor_wait_state = 0;
		static_cast<RenameTenantActor*>(this)->ActorCallback< RenameTenantActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RenameTenantActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RenameTenantActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RenameTenantActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 443 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	RestoreClusterImpl* self;
															#line 443 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	Reference<ITransaction> tr;
															#line 443 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	int64_t tenantId;
															#line 443 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	TenantName oldTenantName;
															#line 443 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	TenantName newTenantName;
															#line 443 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	int configurationSequenceNum;
															#line 449 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	Optional<TenantMapEntry> entry;
															#line 450 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	Optional<int64_t> newId;
															#line 4604 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
};
// This generated class is to be used only via renameTenant()
															#line 443 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
class RenameTenantActor final : public Actor<Void>, public ActorCallback< RenameTenantActor, 0, Void >, public ActorCallback< RenameTenantActor, 1, Void >, public FastAllocated<RenameTenantActor>, public RenameTenantActorState<RenameTenantActor> {
															#line 4609 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
public:
	using FastAllocated<RenameTenantActor>::operator new;
	using FastAllocated<RenameTenantActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16082230551404810496UL, 12925925651273713664UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RenameTenantActor, 0, Void >;
friend struct ActorCallback< RenameTenantActor, 1, Void >;
															#line 443 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	RenameTenantActor(RestoreClusterImpl* const& self,Reference<ITransaction> const& tr,int64_t const& tenantId,TenantName const& oldTenantName,TenantName const& newTenantName,int const& configurationSequenceNum) 
															#line 4627 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		 : Actor<Void>(),
		   RenameTenantActorState<RenameTenantActor>(self, tr, tenantId, oldTenantName, newTenantName, configurationSequenceNum),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(972264867922354944UL, 1896563828629082368UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("renameTenant");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RenameTenantActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RenameTenantActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 443 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
[[nodiscard]] static Future<Void> renameTenant( RestoreClusterImpl* const& self, Reference<ITransaction> const& tr, int64_t const& tenantId, TenantName const& oldTenantName, TenantName const& newTenantName, int const& configurationSequenceNum ) {
															#line 443 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	return Future<Void>(new RenameTenantActor(self, tr, tenantId, oldTenantName, newTenantName, configurationSequenceNum));
															#line 4660 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
}

#line 497 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"

																#line 4665 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
// This generated class is to be used only via updateTenantConfiguration()
															#line 498 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
template <class UpdateTenantConfigurationActor>
															#line 498 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
class UpdateTenantConfigurationActorState {
															#line 4671 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
public:
															#line 498 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	UpdateTenantConfigurationActorState(RestoreClusterImpl* const& self,Reference<ITransaction> const& tr,int64_t const& tenantId,TenantMapEntry const& updatedEntry) 
															#line 498 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
															#line 498 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		 : self(self),
															#line 498 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		   tr(tr),
															#line 498 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		   tenantId(tenantId),
															#line 498 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		   updatedEntry(updatedEntry)
															#line 4684 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
	{
		fdb_probe_actor_create("updateTenantConfiguration", reinterpret_cast<unsigned long>(this));

	}
	~UpdateTenantConfigurationActorState() 
	{
		fdb_probe_actor_destroy("updateTenantConfiguration", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 502 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			StrictFuture<TenantMapEntry> __when_expr_0 = TenantAPI::getTenantTransaction(tr, tenantId);
															#line 502 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (static_cast<UpdateTenantConfigurationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4701 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UpdateTenantConfigurationActor*>(this)->actor_wait_state = 1;
															#line 502 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateTenantConfigurationActor, 0, TenantMapEntry >*>(static_cast<UpdateTenantConfigurationActor*>(this)));
															#line 4706 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateTenantConfigurationActorState();
		static_cast<UpdateTenantConfigurationActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(TenantMapEntry const& existingEntry,int loopDepth) 
	{
															#line 507 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (existingEntry.tenantName != updatedEntry.tenantName)
															#line 4729 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 508 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (!existingEntry.tenantName.startsWith(metaclusterTemporaryRenamePrefix))
															#line 4733 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			{
															#line 510 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				CODE_PROBE(true, "Tenant restore rename mismatch due to concurrency", probe::decoration::rare);
															#line 511 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				if (!static_cast<UpdateTenantConfigurationActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateTenantConfigurationActorState(); static_cast<UpdateTenantConfigurationActor*>(this)->destroy(); return 0; }
															#line 4739 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
				new (&static_cast<UpdateTenantConfigurationActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~UpdateTenantConfigurationActorState();
				static_cast<UpdateTenantConfigurationActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 514 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			CODE_PROBE(true, "Configure tenant update to temporary name");
															#line 515 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			updatedEntry.tenantName = existingEntry.tenantName;
															#line 4749 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		}
															#line 518 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (existingEntry.configurationSequenceNum <= updatedEntry.configurationSequenceNum)
															#line 4753 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 519 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			CODE_PROBE(true, "Configure tenant during restore");
															#line 520 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			StrictFuture<Void> __when_expr_1 = TenantAPI::configureTenantTransaction(tr, existingEntry, updatedEntry);
															#line 520 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (static_cast<UpdateTenantConfigurationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4761 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<UpdateTenantConfigurationActor*>(this)->actor_wait_state = 2;
															#line 520 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdateTenantConfigurationActor, 1, Void >*>(static_cast<UpdateTenantConfigurationActor*>(this)));
															#line 4766 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(TenantMapEntry && existingEntry,int loopDepth) 
	{
															#line 507 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (existingEntry.tenantName != updatedEntry.tenantName)
															#line 4780 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 508 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (!existingEntry.tenantName.startsWith(metaclusterTemporaryRenamePrefix))
															#line 4784 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			{
															#line 510 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				CODE_PROBE(true, "Tenant restore rename mismatch due to concurrency", probe::decoration::rare);
															#line 511 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				if (!static_cast<UpdateTenantConfigurationActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateTenantConfigurationActorState(); static_cast<UpdateTenantConfigurationActor*>(this)->destroy(); return 0; }
															#line 4790 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
				new (&static_cast<UpdateTenantConfigurationActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~UpdateTenantConfigurationActorState();
				static_cast<UpdateTenantConfigurationActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 514 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			CODE_PROBE(true, "Configure tenant update to temporary name");
															#line 515 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			updatedEntry.tenantName = existingEntry.tenantName;
															#line 4800 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		}
															#line 518 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (existingEntry.configurationSequenceNum <= updatedEntry.configurationSequenceNum)
															#line 4804 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 519 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			CODE_PROBE(true, "Configure tenant during restore");
															#line 520 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			StrictFuture<Void> __when_expr_1 = TenantAPI::configureTenantTransaction(tr, existingEntry, updatedEntry);
															#line 520 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (static_cast<UpdateTenantConfigurationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4812 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<UpdateTenantConfigurationActor*>(this)->actor_wait_state = 2;
															#line 520 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdateTenantConfigurationActor, 1, Void >*>(static_cast<UpdateTenantConfigurationActor*>(this)));
															#line 4817 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(TenantMapEntry const& existingEntry,int loopDepth) 
	{
		loopDepth = a_body1cont1(existingEntry, loopDepth);

		return loopDepth;
	}
	int a_body1when1(TenantMapEntry && existingEntry,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(existingEntry), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateTenantConfigurationActor*>(this)->actor_wait_state > 0) static_cast<UpdateTenantConfigurationActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateTenantConfigurationActor*>(this)->ActorCallback< UpdateTenantConfigurationActor, 0, TenantMapEntry >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateTenantConfigurationActor, 0, TenantMapEntry >*,TenantMapEntry const& value) 
	{
		fdb_probe_actor_enter("updateTenantConfiguration", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateTenantConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateTenantConfiguration", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateTenantConfigurationActor, 0, TenantMapEntry >*,TenantMapEntry && value) 
	{
		fdb_probe_actor_enter("updateTenantConfiguration", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateTenantConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateTenantConfiguration", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateTenantConfigurationActor, 0, TenantMapEntry >*,Error err) 
	{
		fdb_probe_actor_enter("updateTenantConfiguration", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateTenantConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateTenantConfiguration", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 523 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!static_cast<UpdateTenantConfigurationActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateTenantConfigurationActorState(); static_cast<UpdateTenantConfigurationActor*>(this)->destroy(); return 0; }
															#line 4906 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		new (&static_cast<UpdateTenantConfigurationActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateTenantConfigurationActorState();
		static_cast<UpdateTenantConfigurationActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UpdateTenantConfigurationActor*>(this)->actor_wait_state > 0) static_cast<UpdateTenantConfigurationActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateTenantConfigurationActor*>(this)->ActorCallback< UpdateTenantConfigurationActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateTenantConfigurationActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateTenantConfiguration", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateTenantConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateTenantConfiguration", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UpdateTenantConfigurationActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateTenantConfiguration", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateTenantConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateTenantConfiguration", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UpdateTenantConfigurationActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateTenantConfiguration", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateTenantConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateTenantConfiguration", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 498 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	RestoreClusterImpl* self;
															#line 498 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	Reference<ITransaction> tr;
															#line 498 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	int64_t tenantId;
															#line 498 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	TenantMapEntry updatedEntry;
															#line 5009 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
};
// This generated class is to be used only via updateTenantConfiguration()
															#line 498 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
class UpdateTenantConfigurationActor final : public Actor<Void>, public ActorCallback< UpdateTenantConfigurationActor, 0, TenantMapEntry >, public ActorCallback< UpdateTenantConfigurationActor, 1, Void >, public FastAllocated<UpdateTenantConfigurationActor>, public UpdateTenantConfigurationActorState<UpdateTenantConfigurationActor> {
															#line 5014 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
public:
	using FastAllocated<UpdateTenantConfigurationActor>::operator new;
	using FastAllocated<UpdateTenantConfigurationActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4939979155518253056UL, 9488440820321820928UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateTenantConfigurationActor, 0, TenantMapEntry >;
friend struct ActorCallback< UpdateTenantConfigurationActor, 1, Void >;
															#line 498 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	UpdateTenantConfigurationActor(RestoreClusterImpl* const& self,Reference<ITransaction> const& tr,int64_t const& tenantId,TenantMapEntry const& updatedEntry) 
															#line 5032 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		 : Actor<Void>(),
		   UpdateTenantConfigurationActorState<UpdateTenantConfigurationActor>(self, tr, tenantId, updatedEntry),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateTenantConfiguration", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18116093997302684672UL, 9266740508308196352UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateTenantConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateTenantConfiguration");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateTenantConfiguration", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateTenantConfigurationActor, 0, TenantMapEntry >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UpdateTenantConfigurationActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 498 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
[[nodiscard]] static Future<Void> updateTenantConfiguration( RestoreClusterImpl* const& self, Reference<ITransaction> const& tr, int64_t const& tenantId, TenantMapEntry const& updatedEntry ) {
															#line 498 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	return Future<Void>(new UpdateTenantConfigurationActor(self, tr, tenantId, updatedEntry));
															#line 5065 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
}

#line 525 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"

	// Updates a tenant to match the management cluster state
	// Returns the name of the tenant after it has been reconciled
																#line 5072 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
// This generated class is to be used only via reconcileTenant()
															#line 528 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
template <class ReconcileTenantActor>
															#line 528 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
class ReconcileTenantActorState {
															#line 5078 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
public:
															#line 528 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	ReconcileTenantActorState(RestoreClusterImpl* const& self,TenantMapEntry const& tenantEntry) 
															#line 528 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
															#line 528 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		 : self(self),
															#line 528 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		   tenantEntry(tenantEntry),
															#line 531 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		   managementEntry(self->mgmtClusterTenantMap.find(tenantEntry.id))
															#line 5089 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
	{
		fdb_probe_actor_create("reconcileTenant", reinterpret_cast<unsigned long>(this));

	}
	~ReconcileTenantActorState() 
	{
		fdb_probe_actor_destroy("reconcileTenant", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 535 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (managementEntry == self->mgmtClusterTenantMap.end() || managementEntry->second.assignedCluster != self->clusterName || managementEntry->second.tenantState == TenantState::REMOVING)
															#line 5104 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			{
															#line 538 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				if (self->restoreDryRun)
															#line 5108 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
				{
															#line 539 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
					if (managementEntry == self->mgmtClusterTenantMap.end())
															#line 5112 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
					{
															#line 540 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
						self->messages.push_back(fmt::format("Delete missing tenant `{}' with ID {} on data cluster", printable(tenantEntry.tenantName), tenantEntry.id));
															#line 5116 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
					}
					else
					{
															#line 543 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
						if (managementEntry->second.assignedCluster != self->clusterName)
															#line 5122 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
						{
															#line 544 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
							self->messages.push_back(fmt::format( "Delete tenant `{}' with ID {} on data cluster because it is now located on the cluster `{}'", printable(tenantEntry.tenantName), tenantEntry.id, printable(managementEntry->second.assignedCluster)));
															#line 5126 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
						}
						else
						{
															#line 550 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
							self->messages.push_back( fmt::format("Delete tenant `{}' with ID {} on data cluster because it is in the REMOVING state", printable(tenantEntry.tenantName), tenantEntry.id));
															#line 5132 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
						}
					}
					loopDepth = a_body1cont2(loopDepth);
				}
				else
				{
															#line 556 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
					CODE_PROBE(true, "Delete tenant during restore");
															#line 557 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
					StrictFuture<Void> __when_expr_0 = self->runRestoreDataClusterTransaction([tenantEntry = tenantEntry](Reference<ITransaction> tr) { return TenantAPI::deleteTenantTransaction(tr, tenantEntry.id, ClusterType::METACLUSTER_DATA); });
															#line 557 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
					if (static_cast<ReconcileTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5145 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<ReconcileTenantActor*>(this)->actor_wait_state = 1;
															#line 557 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReconcileTenantActor, 0, Void >*>(static_cast<ReconcileTenantActor*>(this)));
															#line 5150 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
					loopDepth = 0;
				}
			}
			else
			{
															#line 564 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				tenantName = tenantEntry.tenantName;
															#line 565 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				managementTenant = managementEntry->second;
															#line 568 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				managementTenantName = managementTenant.tenantState != TenantState::RENAMING ? managementTenant.tenantName : managementTenant.renameDestination.get();
															#line 571 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				renamed = tenantName != managementTenantName;
															#line 572 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				if (renamed)
															#line 5166 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
				{
															#line 573 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
					temporaryName = TenantName();
															#line 574 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
					usingTemporaryName = self->dataClusterTenantNames.count(managementTenantName) > 0;
															#line 575 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
					if (usingTemporaryName)
															#line 5174 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
					{
															#line 576 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
						CODE_PROBE(true, "Restore break tenant rename cycle");
															#line 577 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
						temporaryName = metaclusterTemporaryRenamePrefix.withSuffix(managementTenantName);
															#line 5180 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
					}
					else
					{
															#line 579 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
						temporaryName = managementTenantName;
															#line 5186 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
					}
															#line 582 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
					if (self->restoreDryRun)
															#line 5190 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
					{
															#line 583 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
						self->messages.push_back(fmt::format("Rename tenant `{}' with ID {} to `{}' on data cluster{}", printable(tenantEntry.tenantName), tenantEntry.id, printable(managementTenantName), usingTemporaryName ? " via temporary name" : ""));
															#line 5194 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
						loopDepth = a_body1cont11(loopDepth);
					}
					else
					{
															#line 589 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
						StrictFuture<Void> __when_expr_1 = self->runRestoreDataClusterTransaction( [self = self, tenantName = tenantName, temporaryName = temporaryName, tenantEntry = tenantEntry, managementTenant = managementTenant](Reference<ITransaction> tr) { return renameTenant(self, tr, tenantEntry.id, tenantName, temporaryName, managementTenant.configurationSequenceNum); });
															#line 589 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
						if (static_cast<ReconcileTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5203 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
						if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
						static_cast<ReconcileTenantActor*>(this)->actor_wait_state = 2;
															#line 589 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
						__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReconcileTenantActor, 1, Void >*>(static_cast<ReconcileTenantActor*>(this)));
															#line 5208 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
						loopDepth = 0;
					}
				}
				else
				{
					loopDepth = a_body1cont10(loopDepth);
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReconcileTenantActorState();
		static_cast<ReconcileTenantActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 562 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!static_cast<ReconcileTenantActor*>(this)->SAV<Optional<std::pair<TenantName, MetaclusterTenantMapEntry>>>::futures) { (void)(Optional<std::pair<TenantName, MetaclusterTenantMapEntry>>()); this->~ReconcileTenantActorState(); static_cast<ReconcileTenantActor*>(this)->destroy(); return 0; }
															#line 5238 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		new (&static_cast<ReconcileTenantActor*>(this)->SAV< Optional<std::pair<TenantName, MetaclusterTenantMapEntry>> >::value()) Optional<std::pair<TenantName, MetaclusterTenantMapEntry>>(Optional<std::pair<TenantName, MetaclusterTenantMapEntry>>());
		this->~ReconcileTenantActorState();
		static_cast<ReconcileTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReconcileTenantActor*>(this)->actor_wait_state > 0) static_cast<ReconcileTenantActor*>(this)->actor_wait_state = 0;
		static_cast<ReconcileTenantActor*>(this)->ActorCallback< ReconcileTenantActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReconcileTenantActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("reconcileTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReconcileTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reconcileTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReconcileTenantActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("reconcileTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReconcileTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reconcileTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReconcileTenantActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("reconcileTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReconcileTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reconcileTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont10(int loopDepth) 
	{
															#line 609 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		bool configurationChanged = !managementTenant.matchesConfiguration(tenantEntry);
															#line 610 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (configurationChanged || managementTenant.configurationSequenceNum != tenantEntry.configurationSequenceNum)
															#line 5339 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 612 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (self->restoreDryRun)
															#line 5343 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			{
															#line 616 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				if (configurationChanged || !renamed)
															#line 5347 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
				{
															#line 617 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
					self->messages.push_back( fmt::format("Update tenant configuration for tenant `{}' with ID {} on data cluster{}", printable(tenantEntry.tenantName), tenantEntry.id, configurationChanged ? "" : " (internal metadata only)"));
															#line 5351 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
				}
				loopDepth = a_body1cont10cont2(loopDepth);
			}
			else
			{
															#line 624 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				StrictFuture<Void> __when_expr_2 = self->runRestoreDataClusterTransaction([self = self, managementTenant = managementTenant, tenantEntry = tenantEntry, tenantName = tenantName](Reference<ITransaction> tr) { ASSERT_GE(managementTenant.configurationSequenceNum, tenantEntry.configurationSequenceNum); TenantMapEntry updatedEntry = managementTenant.toTenantMapEntry(); updatedEntry.tenantName = tenantName; return updateTenantConfiguration(self, tr, managementTenant.id, updatedEntry); });
															#line 624 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				if (static_cast<ReconcileTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5361 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont10when1(__when_expr_2.get(), loopDepth); };
				static_cast<ReconcileTenantActor*>(this)->actor_wait_state = 3;
															#line 624 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ReconcileTenantActor, 2, Void >*>(static_cast<ReconcileTenantActor*>(this)));
															#line 5366 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
				loopDepth = 0;
			}
		}
		else
		{
			loopDepth = a_body1cont10cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11(int loopDepth) 
	{
															#line 605 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		tenantName = temporaryName;
															#line 5381 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont15(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont15(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont15(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont15(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReconcileTenantActor*>(this)->actor_wait_state > 0) static_cast<ReconcileTenantActor*>(this)->actor_wait_state = 0;
		static_cast<ReconcileTenantActor*>(this)->ActorCallback< ReconcileTenantActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReconcileTenantActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("reconcileTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReconcileTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reconcileTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReconcileTenantActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("reconcileTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReconcileTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reconcileTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReconcileTenantActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("reconcileTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReconcileTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reconcileTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont10cont1(int loopDepth) 
	{
															#line 638 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!static_cast<ReconcileTenantActor*>(this)->SAV<Optional<std::pair<TenantName, MetaclusterTenantMapEntry>>>::futures) { (void)(std::make_pair(tenantName, managementTenant)); this->~ReconcileTenantActorState(); static_cast<ReconcileTenantActor*>(this)->destroy(); return 0; }
															#line 5477 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		new (&static_cast<ReconcileTenantActor*>(this)->SAV< Optional<std::pair<TenantName, MetaclusterTenantMapEntry>> >::value()) Optional<std::pair<TenantName, MetaclusterTenantMapEntry>>(std::make_pair(tenantName, managementTenant));
		this->~ReconcileTenantActorState();
		static_cast<ReconcileTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10cont2(int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ReconcileTenantActor*>(this)->actor_wait_state > 0) static_cast<ReconcileTenantActor*>(this)->actor_wait_state = 0;
		static_cast<ReconcileTenantActor*>(this)->ActorCallback< ReconcileTenantActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReconcileTenantActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("reconcileTenant", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReconcileTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reconcileTenant", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ReconcileTenantActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("reconcileTenant", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReconcileTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reconcileTenant", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ReconcileTenantActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("reconcileTenant", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReconcileTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reconcileTenant", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 528 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	RestoreClusterImpl* self;
															#line 528 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	TenantMapEntry tenantEntry;
															#line 531 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	std::unordered_map<int64_t, MetaclusterTenantMapEntry>::iterator managementEntry;
															#line 564 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	TenantName tenantName;
															#line 565 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	MetaclusterTenantMapEntry managementTenant;
															#line 568 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	TenantName managementTenantName;
															#line 571 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	bool renamed;
															#line 573 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	TenantName temporaryName;
															#line 574 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	bool usingTemporaryName;
															#line 5596 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
};
// This generated class is to be used only via reconcileTenant()
															#line 528 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
class ReconcileTenantActor final : public Actor<Optional<std::pair<TenantName, MetaclusterTenantMapEntry>>>, public ActorCallback< ReconcileTenantActor, 0, Void >, public ActorCallback< ReconcileTenantActor, 1, Void >, public ActorCallback< ReconcileTenantActor, 2, Void >, public FastAllocated<ReconcileTenantActor>, public ReconcileTenantActorState<ReconcileTenantActor> {
															#line 5601 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
public:
	using FastAllocated<ReconcileTenantActor>::operator new;
	using FastAllocated<ReconcileTenantActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6495037878371391744UL, 14226945804223362816UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<std::pair<TenantName, MetaclusterTenantMapEntry>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReconcileTenantActor, 0, Void >;
friend struct ActorCallback< ReconcileTenantActor, 1, Void >;
friend struct ActorCallback< ReconcileTenantActor, 2, Void >;
															#line 528 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	ReconcileTenantActor(RestoreClusterImpl* const& self,TenantMapEntry const& tenantEntry) 
															#line 5620 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		 : Actor<Optional<std::pair<TenantName, MetaclusterTenantMapEntry>>>(),
		   ReconcileTenantActorState<ReconcileTenantActor>(self, tenantEntry),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("reconcileTenant", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11571003451974916608UL, 2834832945045158144UL);
		ActorExecutionContextHelper __helper(static_cast<ReconcileTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("reconcileTenant");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("reconcileTenant", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReconcileTenantActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReconcileTenantActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ReconcileTenantActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 528 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
[[nodiscard]] static Future<Optional<std::pair<TenantName, MetaclusterTenantMapEntry>>> reconcileTenant( RestoreClusterImpl* const& self, TenantMapEntry const& tenantEntry ) {
															#line 528 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	return Future<Optional<std::pair<TenantName, MetaclusterTenantMapEntry>>>(new ReconcileTenantActor(self, tenantEntry));
															#line 5654 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
}

#line 641 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"

	Future<Void> renameTenantBatch(std::map<TenantName, TenantMapEntry> tenantsToRename) {
		return runRestoreDataClusterTransaction([this, tenantsToRename](Reference<ITransaction> tr) {
			std::vector<Future<Void>> renameFutures;
			for (auto t : tenantsToRename) {
				renameFutures.push_back(renameTenant(
				    this, tr, t.second.id, t.first, t.second.tenantName, t.second.configurationSequenceNum));
			}
			return waitForAll(renameFutures);
		});
	}

																#line 5670 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
// This generated class is to be used only via reconcileTenants()
															#line 653 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
template <class ReconcileTenantsActor>
															#line 653 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
class ReconcileTenantsActorState {
															#line 5676 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
public:
															#line 653 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	ReconcileTenantsActorState(RestoreClusterImpl* const& self) 
															#line 653 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
															#line 653 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		 : self(self),
															#line 654 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		   reconcileFutures()
															#line 5685 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
	{
		fdb_probe_actor_create("reconcileTenants", reinterpret_cast<unsigned long>(this));

	}
	~ReconcileTenantsActorState() 
	{
		fdb_probe_actor_destroy("reconcileTenants", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 655 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			for(auto itr = self->dataClusterTenantMap.begin();itr != self->dataClusterTenantMap.end();++itr) {
															#line 656 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				reconcileFutures.push_back(reconcileTenant(self, itr->second));
															#line 5702 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			}
															#line 659 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			StrictFuture<Void> __when_expr_0 = waitForAll(reconcileFutures);
															#line 659 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (static_cast<ReconcileTenantsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5708 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ReconcileTenantsActor*>(this)->actor_wait_state = 1;
															#line 659 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReconcileTenantsActor, 0, Void >*>(static_cast<ReconcileTenantsActor*>(this)));
															#line 5713 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReconcileTenantsActorState();
		static_cast<ReconcileTenantsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 661 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!self->restoreDryRun)
															#line 5736 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 662 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			reconcileIndex = int();
															#line 663 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			tenantsToRename = std::map<TenantName, TenantMapEntry>();
															#line 664 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			reconcileIndex = 0;
															#line 5744 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = a_body1cont1loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 661 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!self->restoreDryRun)
															#line 5758 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 662 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			reconcileIndex = int();
															#line 663 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			tenantsToRename = std::map<TenantName, TenantMapEntry>();
															#line 664 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			reconcileIndex = 0;
															#line 5766 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = a_body1cont1loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReconcileTenantsActor*>(this)->actor_wait_state > 0) static_cast<ReconcileTenantsActor*>(this)->actor_wait_state = 0;
		static_cast<ReconcileTenantsActor*>(this)->ActorCallback< ReconcileTenantsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReconcileTenantsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("reconcileTenants", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReconcileTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reconcileTenants", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReconcileTenantsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("reconcileTenants", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReconcileTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reconcileTenants", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReconcileTenantsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("reconcileTenants", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReconcileTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reconcileTenants", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 689 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!static_cast<ReconcileTenantsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReconcileTenantsActorState(); static_cast<ReconcileTenantsActor*>(this)->destroy(); return 0; }
															#line 5855 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		new (&static_cast<ReconcileTenantsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ReconcileTenantsActorState();
		static_cast<ReconcileTenantsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(int loopDepth) 
	{
															#line 684 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!tenantsToRename.empty())
															#line 5867 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 685 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			StrictFuture<Void> __when_expr_2 = self->renameTenantBatch(tenantsToRename);
															#line 685 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (static_cast<ReconcileTenantsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5873 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont4when1(__when_expr_2.get(), loopDepth); };
			static_cast<ReconcileTenantsActor*>(this)->actor_wait_state = 3;
															#line 685 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ReconcileTenantsActor, 2, Void >*>(static_cast<ReconcileTenantsActor*>(this)));
															#line 5878 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 664 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!(reconcileIndex < reconcileFutures.size()))
															#line 5899 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 665 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		Optional<std::pair<TenantName, MetaclusterTenantMapEntry>> const& result = reconcileFutures[reconcileIndex].get();
															#line 668 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (result.present() && result.get().first.startsWith(metaclusterTemporaryRenamePrefix))
															#line 5907 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 669 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			TenantMapEntry destinationTenant = result.get().second.toTenantMapEntry();
															#line 670 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (result.get().second.renameDestination.present())
															#line 5913 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			{
															#line 671 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				destinationTenant.tenantName = result.get().second.renameDestination.get();
															#line 5917 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			}
															#line 674 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (result.get().first != destinationTenant.tenantName)
															#line 5921 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			{
															#line 675 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				tenantsToRename[result.get().first] = destinationTenant;
															#line 677 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				if (tenantsToRename.size() >= CLIENT_KNOBS->METACLUSTER_RESTORE_BATCH_SIZE)
															#line 5927 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
				{
															#line 678 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
					StrictFuture<Void> __when_expr_1 = self->renameTenantBatch(tenantsToRename);
															#line 678 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
					if (static_cast<ReconcileTenantsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5933 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
					static_cast<ReconcileTenantsActor*>(this)->actor_wait_state = 2;
															#line 678 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReconcileTenantsActor, 1, Void >*>(static_cast<ReconcileTenantsActor*>(this)));
															#line 5938 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont1loopBody1cont5(loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1cont1loopBody1cont3(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 664 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		++reconcileIndex;
															#line 5975 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReconcileTenantsActor*>(this)->actor_wait_state > 0) static_cast<ReconcileTenantsActor*>(this)->actor_wait_state = 0;
		static_cast<ReconcileTenantsActor*>(this)->ActorCallback< ReconcileTenantsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReconcileTenantsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("reconcileTenants", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReconcileTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reconcileTenants", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReconcileTenantsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("reconcileTenants", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReconcileTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reconcileTenants", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReconcileTenantsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("reconcileTenants", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReconcileTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reconcileTenants", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ReconcileTenantsActor*>(this)->actor_wait_state > 0) static_cast<ReconcileTenantsActor*>(this)->actor_wait_state = 0;
		static_cast<ReconcileTenantsActor*>(this)->ActorCallback< ReconcileTenantsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReconcileTenantsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("reconcileTenants", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReconcileTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reconcileTenants", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ReconcileTenantsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("reconcileTenants", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReconcileTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reconcileTenants", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ReconcileTenantsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("reconcileTenants", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReconcileTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reconcileTenants", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 653 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	RestoreClusterImpl* self;
															#line 654 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	std::vector<Future<Optional<std::pair<TenantName, MetaclusterTenantMapEntry>>>> reconcileFutures;
															#line 662 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	int reconcileIndex;
															#line 663 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	std::map<TenantName, TenantMapEntry> tenantsToRename;
															#line 6180 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
};
// This generated class is to be used only via reconcileTenants()
															#line 653 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
class ReconcileTenantsActor final : public Actor<Void>, public ActorCallback< ReconcileTenantsActor, 0, Void >, public ActorCallback< ReconcileTenantsActor, 1, Void >, public ActorCallback< ReconcileTenantsActor, 2, Void >, public FastAllocated<ReconcileTenantsActor>, public ReconcileTenantsActorState<ReconcileTenantsActor> {
															#line 6185 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
public:
	using FastAllocated<ReconcileTenantsActor>::operator new;
	using FastAllocated<ReconcileTenantsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1668941983618384640UL, 13204372360789970176UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReconcileTenantsActor, 0, Void >;
friend struct ActorCallback< ReconcileTenantsActor, 1, Void >;
friend struct ActorCallback< ReconcileTenantsActor, 2, Void >;
															#line 653 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	ReconcileTenantsActor(RestoreClusterImpl* const& self) 
															#line 6204 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		 : Actor<Void>(),
		   ReconcileTenantsActorState<ReconcileTenantsActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("reconcileTenants", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2935043159839500800UL, 9218843341942268928UL);
		ActorExecutionContextHelper __helper(static_cast<ReconcileTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("reconcileTenants");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("reconcileTenants", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReconcileTenantsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReconcileTenantsActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ReconcileTenantsActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 653 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
[[nodiscard]] static Future<Void> reconcileTenants( RestoreClusterImpl* const& self ) {
															#line 653 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	return Future<Void>(new ReconcileTenantsActor(self));
															#line 6238 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
}

#line 691 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"

																#line 6243 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
// This generated class is to be used only via processMissingTenants()
															#line 692 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
template <class ProcessMissingTenantsActor>
															#line 692 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
class ProcessMissingTenantsActorState {
															#line 6249 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
public:
															#line 692 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	ProcessMissingTenantsActorState(RestoreClusterImpl* const& self) 
															#line 692 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
															#line 692 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		 : self(self),
															#line 693 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		   setItr(self->mgmtClusterTenantSetForCurrentDataCluster.begin()),
															#line 694 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		   missingTenants(),
															#line 695 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		   missingTenantCount(0)
															#line 6262 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
	{
		fdb_probe_actor_create("processMissingTenants", reinterpret_cast<unsigned long>(this));

	}
	~ProcessMissingTenantsActorState() 
	{
		fdb_probe_actor_destroy("processMissingTenants", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 696 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			;
															#line 6277 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ProcessMissingTenantsActorState();
		static_cast<ProcessMissingTenantsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 734 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!self->restoreDryRun && missingTenants.size() > 0)
															#line 6300 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 735 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			StrictFuture<Void> __when_expr_1 = self->runRestoreManagementTransaction( [self = self, missingTenants = missingTenants](Reference<typename DB::TransactionT> tr) { return markManagementTenantsAsError(self, tr, missingTenants); });
															#line 735 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (static_cast<ProcessMissingTenantsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6306 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ProcessMissingTenantsActor*>(this)->actor_wait_state = 2;
															#line 735 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ProcessMissingTenantsActor, 1, Void >*>(static_cast<ProcessMissingTenantsActor*>(this)));
															#line 6311 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 696 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!(setItr != self->mgmtClusterTenantSetForCurrentDataCluster.end()))
															#line 6332 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 697 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		int64_t tenantId = *setItr;
															#line 698 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		MetaclusterTenantMapEntry const& managementTenant = self->mgmtClusterTenantMap[tenantId];
															#line 706 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (self->dataClusterTenantMap.find(tenantId) == self->dataClusterTenantMap.end() && managementTenant.tenantState != TenantState::REGISTERING && managementTenant.tenantState != TenantState::REMOVING)
															#line 6342 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 709 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (self->restoreDryRun)
															#line 6346 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			{
															#line 710 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				self->messages.push_back(fmt::format("The tenant `{}' with ID {} is missing on the data cluster", printable(managementTenant.tenantName), tenantId));
															#line 6350 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
				loopDepth = a_body1loopBody1cont3(loopDepth);
			}
			else
			{
															#line 717 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				++missingTenantCount;
															#line 718 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				if (managementTenant.tenantState != TenantState::ERROR)
															#line 6359 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
				{
															#line 719 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
					missingTenants.push_back(tenantId);
															#line 720 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
					if (missingTenants.size() == CLIENT_KNOBS->METACLUSTER_RESTORE_BATCH_SIZE)
															#line 6365 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
					{
															#line 721 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
						CODE_PROBE(true, "Mark tenants as error batch");
															#line 722 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
						StrictFuture<Void> __when_expr_0 = self->runRestoreManagementTransaction([self = self, missingTenants = missingTenants]( Reference<typename DB::TransactionT> tr) { return markManagementTenantsAsError(self, tr, missingTenants); });
															#line 722 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
						if (static_cast<ProcessMissingTenantsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6373 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
						if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
						static_cast<ProcessMissingTenantsActor*>(this)->actor_wait_state = 1;
															#line 722 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
						__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ProcessMissingTenantsActor, 0, Void >*>(static_cast<ProcessMissingTenantsActor*>(this)));
															#line 6378 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
						loopDepth = 0;
					}
					else
					{
						loopDepth = a_body1loopBody1cont6(loopDepth);
					}
				}
				else
				{
					loopDepth = a_body1loopBody1cont5(loopDepth);
				}
			}
		}
		else
		{
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 731 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		++setItr;
															#line 6416 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void const& _,int loopDepth) 
	{
															#line 726 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		missingTenants.clear();
															#line 6443 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void && _,int loopDepth) 
	{
															#line 726 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		missingTenants.clear();
															#line 6452 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ProcessMissingTenantsActor*>(this)->actor_wait_state > 0) static_cast<ProcessMissingTenantsActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessMissingTenantsActor*>(this)->ActorCallback< ProcessMissingTenantsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessMissingTenantsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("processMissingTenants", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessMissingTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processMissingTenants", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ProcessMissingTenantsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("processMissingTenants", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessMissingTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processMissingTenants", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ProcessMissingTenantsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("processMissingTenants", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessMissingTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processMissingTenants", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 741 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (missingTenantCount > 0)
															#line 6536 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 742 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			self->messages.push_back(fmt::format( "The metacluster has {} tenants that are missing in the restored data cluster", missingTenantCount));
															#line 6540 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		}
															#line 745 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!static_cast<ProcessMissingTenantsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ProcessMissingTenantsActorState(); static_cast<ProcessMissingTenantsActor*>(this)->destroy(); return 0; }
															#line 6544 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		new (&static_cast<ProcessMissingTenantsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ProcessMissingTenantsActorState();
		static_cast<ProcessMissingTenantsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ProcessMissingTenantsActor*>(this)->actor_wait_state > 0) static_cast<ProcessMissingTenantsActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessMissingTenantsActor*>(this)->ActorCallback< ProcessMissingTenantsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessMissingTenantsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("processMissingTenants", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessMissingTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processMissingTenants", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ProcessMissingTenantsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("processMissingTenants", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessMissingTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processMissingTenants", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ProcessMissingTenantsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("processMissingTenants", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessMissingTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processMissingTenants", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 692 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	RestoreClusterImpl* self;
															#line 693 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	std::unordered_set<int64_t>::iterator setItr;
															#line 694 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	std::vector<int64_t> missingTenants;
															#line 695 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	int64_t missingTenantCount;
															#line 6647 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
};
// This generated class is to be used only via processMissingTenants()
															#line 692 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
class ProcessMissingTenantsActor final : public Actor<Void>, public ActorCallback< ProcessMissingTenantsActor, 0, Void >, public ActorCallback< ProcessMissingTenantsActor, 1, Void >, public FastAllocated<ProcessMissingTenantsActor>, public ProcessMissingTenantsActorState<ProcessMissingTenantsActor> {
															#line 6652 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
public:
	using FastAllocated<ProcessMissingTenantsActor>::operator new;
	using FastAllocated<ProcessMissingTenantsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13803625322318078208UL, 7368422469082822400UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ProcessMissingTenantsActor, 0, Void >;
friend struct ActorCallback< ProcessMissingTenantsActor, 1, Void >;
															#line 692 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	ProcessMissingTenantsActor(RestoreClusterImpl* const& self) 
															#line 6670 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		 : Actor<Void>(),
		   ProcessMissingTenantsActorState<ProcessMissingTenantsActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("processMissingTenants", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13161628187581138176UL, 11736489600501471488UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessMissingTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("processMissingTenants");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("processMissingTenants", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ProcessMissingTenantsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ProcessMissingTenantsActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 692 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
[[nodiscard]] static Future<Void> processMissingTenants( RestoreClusterImpl* const& self ) {
															#line 692 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	return Future<Void>(new ProcessMissingTenantsActor(self));
															#line 6703 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
}

#line 747 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"

	// Returns true if the group needs to be created
																#line 6709 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
// This generated class is to be used only via addTenantToManagementCluster()
															#line 749 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
template <class AddTenantToManagementClusterActor>
															#line 749 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
class AddTenantToManagementClusterActorState {
															#line 6715 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
public:
															#line 749 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	AddTenantToManagementClusterActorState(RestoreClusterImpl* const& self,Reference<ITransaction> const& tr,TenantMapEntry const& tenantEntry) 
															#line 749 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
															#line 749 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		 : self(self),
															#line 749 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		   tr(tr),
															#line 749 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		   tenantEntry(tenantEntry),
															#line 752 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		   tenantGroupEntry(Optional<MetaclusterTenantGroupEntry>())
															#line 6728 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
	{
		fdb_probe_actor_create("addTenantToManagementCluster", reinterpret_cast<unsigned long>(this));

	}
	~AddTenantToManagementClusterActorState() 
	{
		fdb_probe_actor_destroy("addTenantToManagementCluster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 753 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (tenantEntry.tenantGroup.present())
															#line 6743 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			{
															#line 754 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				tenantGroupEntry = metadata::management::tenantMetadata().tenantGroupMap.get(tr, tenantEntry.tenantGroup.get());
															#line 6747 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			}
															#line 758 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (self->lastDataClusterTenantId.present() && TenantAPI::getTenantIdPrefix(tenantEntry.id) == TenantAPI::getTenantIdPrefix(self->lastDataClusterTenantId.get()) && !self->restoreDryRun)
															#line 6751 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			{
															#line 762 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				ASSERT_LE(tenantEntry.id, self->lastDataClusterTenantId.get());
															#line 6755 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			}
															#line 765 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			StrictFuture<Optional<MetaclusterTenantMapEntry>> __when_expr_0 = tryGetTenantTransaction(tr, tenantEntry.tenantName);
															#line 765 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (static_cast<AddTenantToManagementClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6761 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AddTenantToManagementClusterActor*>(this)->actor_wait_state = 1;
															#line 765 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AddTenantToManagementClusterActor, 0, Optional<MetaclusterTenantMapEntry> >*>(static_cast<AddTenantToManagementClusterActor*>(this)));
															#line 6766 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AddTenantToManagementClusterActorState();
		static_cast<AddTenantToManagementClusterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<MetaclusterTenantMapEntry> const& existingEntry,int loopDepth) 
	{
															#line 766 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (existingEntry.present())
															#line 6789 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 767 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (existingEntry.get().assignedCluster == self->clusterName)
															#line 6793 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			{
															#line 768 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				if (existingEntry.get().id != tenantEntry.id || !existingEntry.get().matchesConfiguration(tenantEntry))
															#line 6797 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
				{
															#line 770 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
					CODE_PROBE(true, "Tenant modified during restore dry-run");
															#line 771 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
					ASSERT(self->restoreDryRun);
															#line 772 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
					self->messages.push_back( fmt::format("The tenant `{}' was modified concurrently with the restore dry-run", printable(tenantEntry.tenantName)));
															#line 775 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
					return a_body1Catch1(tenant_already_exists(), loopDepth);
															#line 6807 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
				}
															#line 779 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				if (!static_cast<AddTenantToManagementClusterActor*>(this)->SAV<bool>::futures) { (void)(false); this->~AddTenantToManagementClusterActorState(); static_cast<AddTenantToManagementClusterActor*>(this)->destroy(); return 0; }
															#line 6811 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
				new (&static_cast<AddTenantToManagementClusterActor*>(this)->SAV< bool >::value()) bool(false);
				this->~AddTenantToManagementClusterActorState();
				static_cast<AddTenantToManagementClusterActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 781 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				CODE_PROBE(true, "Tenant exists on different cluster");
															#line 782 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				self->messages.push_back(fmt::format("The tenant `{}' already exists on cluster `{}'", printable(tenantEntry.tenantName), printable(existingEntry.get().assignedCluster)));
															#line 785 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				return a_body1Catch1(tenant_already_exists(), loopDepth);
															#line 6825 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			}
		}
															#line 789 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		managementEntry = MetaclusterTenantMapEntry::fromTenantMapEntry(tenantEntry);
															#line 790 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		managementEntry.assignedCluster = self->clusterName;
															#line 792 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!self->restoreDryRun)
															#line 6834 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 793 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			metadata::management::tenantMetadata().tenantMap.set(tr, managementEntry.id, managementEntry);
															#line 794 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			metadata::management::tenantMetadata().tenantNameIndex.set( tr, managementEntry.tenantName, managementEntry.id);
															#line 797 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			metadata::management::tenantMetadata().tenantCount.atomicOp(tr, 1, MutationRef::AddValue);
															#line 798 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			metadata::management::clusterTenantCount().atomicOp( tr, managementEntry.assignedCluster, 1, MutationRef::AddValue);
															#line 802 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			metadata::management::clusterTenantIndex().insert( tr, Tuple::makeTuple(managementEntry.assignedCluster, managementEntry.tenantName, managementEntry.id));
															#line 6846 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		}
															#line 806 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		StrictFuture<Void> __when_expr_1 = success(tenantGroupEntry);
															#line 806 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (static_cast<AddTenantToManagementClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6852 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AddTenantToManagementClusterActor*>(this)->actor_wait_state = 2;
															#line 806 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AddTenantToManagementClusterActor, 1, Void >*>(static_cast<AddTenantToManagementClusterActor*>(this)));
															#line 6857 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<MetaclusterTenantMapEntry> && existingEntry,int loopDepth) 
	{
															#line 766 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (existingEntry.present())
															#line 6866 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 767 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (existingEntry.get().assignedCluster == self->clusterName)
															#line 6870 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			{
															#line 768 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				if (existingEntry.get().id != tenantEntry.id || !existingEntry.get().matchesConfiguration(tenantEntry))
															#line 6874 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
				{
															#line 770 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
					CODE_PROBE(true, "Tenant modified during restore dry-run");
															#line 771 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
					ASSERT(self->restoreDryRun);
															#line 772 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
					self->messages.push_back( fmt::format("The tenant `{}' was modified concurrently with the restore dry-run", printable(tenantEntry.tenantName)));
															#line 775 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
					return a_body1Catch1(tenant_already_exists(), loopDepth);
															#line 6884 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
				}
															#line 779 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				if (!static_cast<AddTenantToManagementClusterActor*>(this)->SAV<bool>::futures) { (void)(false); this->~AddTenantToManagementClusterActorState(); static_cast<AddTenantToManagementClusterActor*>(this)->destroy(); return 0; }
															#line 6888 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
				new (&static_cast<AddTenantToManagementClusterActor*>(this)->SAV< bool >::value()) bool(false);
				this->~AddTenantToManagementClusterActorState();
				static_cast<AddTenantToManagementClusterActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 781 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				CODE_PROBE(true, "Tenant exists on different cluster");
															#line 782 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				self->messages.push_back(fmt::format("The tenant `{}' already exists on cluster `{}'", printable(tenantEntry.tenantName), printable(existingEntry.get().assignedCluster)));
															#line 785 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				return a_body1Catch1(tenant_already_exists(), loopDepth);
															#line 6902 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			}
		}
															#line 789 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		managementEntry = MetaclusterTenantMapEntry::fromTenantMapEntry(tenantEntry);
															#line 790 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		managementEntry.assignedCluster = self->clusterName;
															#line 792 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!self->restoreDryRun)
															#line 6911 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 793 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			metadata::management::tenantMetadata().tenantMap.set(tr, managementEntry.id, managementEntry);
															#line 794 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			metadata::management::tenantMetadata().tenantNameIndex.set( tr, managementEntry.tenantName, managementEntry.id);
															#line 797 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			metadata::management::tenantMetadata().tenantCount.atomicOp(tr, 1, MutationRef::AddValue);
															#line 798 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			metadata::management::clusterTenantCount().atomicOp( tr, managementEntry.assignedCluster, 1, MutationRef::AddValue);
															#line 802 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			metadata::management::clusterTenantIndex().insert( tr, Tuple::makeTuple(managementEntry.assignedCluster, managementEntry.tenantName, managementEntry.id));
															#line 6923 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		}
															#line 806 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		StrictFuture<Void> __when_expr_1 = success(tenantGroupEntry);
															#line 806 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (static_cast<AddTenantToManagementClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6929 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AddTenantToManagementClusterActor*>(this)->actor_wait_state = 2;
															#line 806 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AddTenantToManagementClusterActor, 1, Void >*>(static_cast<AddTenantToManagementClusterActor*>(this)));
															#line 6934 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Optional<MetaclusterTenantMapEntry> const& existingEntry,int loopDepth) 
	{
		loopDepth = a_body1cont1(existingEntry, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<MetaclusterTenantMapEntry> && existingEntry,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(existingEntry), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AddTenantToManagementClusterActor*>(this)->actor_wait_state > 0) static_cast<AddTenantToManagementClusterActor*>(this)->actor_wait_state = 0;
		static_cast<AddTenantToManagementClusterActor*>(this)->ActorCallback< AddTenantToManagementClusterActor, 0, Optional<MetaclusterTenantMapEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< AddTenantToManagementClusterActor, 0, Optional<MetaclusterTenantMapEntry> >*,Optional<MetaclusterTenantMapEntry> const& value) 
	{
		fdb_probe_actor_enter("addTenantToManagementCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddTenantToManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTenantToManagementCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AddTenantToManagementClusterActor, 0, Optional<MetaclusterTenantMapEntry> >*,Optional<MetaclusterTenantMapEntry> && value) 
	{
		fdb_probe_actor_enter("addTenantToManagementCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddTenantToManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTenantToManagementCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AddTenantToManagementClusterActor, 0, Optional<MetaclusterTenantMapEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("addTenantToManagementCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddTenantToManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTenantToManagementCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 808 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (tenantGroupEntry.get().present() && tenantGroupEntry.get().get().assignedCluster != self->clusterName)
															#line 7018 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 809 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			self->messages.push_back( fmt::format("The tenant `{}' is part of a tenant group `{}' that already exists on cluster `{}'", printable(managementEntry.tenantName), printable(managementEntry.tenantGroup.get()), printable(tenantGroupEntry.get().get().assignedCluster)));
															#line 814 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			CODE_PROBE(true, "Tenant group exists on different cluster");
															#line 815 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			return a_body1Catch1(invalid_tenant_configuration(), loopDepth);
															#line 7026 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		}
															#line 818 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!self->restoreDryRun)
															#line 7030 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 819 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			internal::managementClusterAddTenantToGroup(tr, managementEntry, &self->ctx.dataClusterMetadata.get(), GroupAlreadyExists(tenantGroupEntry.get().present()), IgnoreCapacityLimit::True, IsRestoring::True);
															#line 7034 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		}
															#line 827 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!static_cast<AddTenantToManagementClusterActor*>(this)->SAV<bool>::futures) { (void)(!tenantGroupEntry.get().present()); this->~AddTenantToManagementClusterActorState(); static_cast<AddTenantToManagementClusterActor*>(this)->destroy(); return 0; }
															#line 7038 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		new (&static_cast<AddTenantToManagementClusterActor*>(this)->SAV< bool >::value()) bool(!tenantGroupEntry.get().present());
		this->~AddTenantToManagementClusterActorState();
		static_cast<AddTenantToManagementClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 808 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (tenantGroupEntry.get().present() && tenantGroupEntry.get().get().assignedCluster != self->clusterName)
															#line 7050 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 809 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			self->messages.push_back( fmt::format("The tenant `{}' is part of a tenant group `{}' that already exists on cluster `{}'", printable(managementEntry.tenantName), printable(managementEntry.tenantGroup.get()), printable(tenantGroupEntry.get().get().assignedCluster)));
															#line 814 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			CODE_PROBE(true, "Tenant group exists on different cluster");
															#line 815 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			return a_body1Catch1(invalid_tenant_configuration(), loopDepth);
															#line 7058 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		}
															#line 818 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!self->restoreDryRun)
															#line 7062 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 819 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			internal::managementClusterAddTenantToGroup(tr, managementEntry, &self->ctx.dataClusterMetadata.get(), GroupAlreadyExists(tenantGroupEntry.get().present()), IgnoreCapacityLimit::True, IsRestoring::True);
															#line 7066 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		}
															#line 827 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!static_cast<AddTenantToManagementClusterActor*>(this)->SAV<bool>::futures) { (void)(!tenantGroupEntry.get().present()); this->~AddTenantToManagementClusterActorState(); static_cast<AddTenantToManagementClusterActor*>(this)->destroy(); return 0; }
															#line 7070 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		new (&static_cast<AddTenantToManagementClusterActor*>(this)->SAV< bool >::value()) bool(!tenantGroupEntry.get().present());
		this->~AddTenantToManagementClusterActorState();
		static_cast<AddTenantToManagementClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AddTenantToManagementClusterActor*>(this)->actor_wait_state > 0) static_cast<AddTenantToManagementClusterActor*>(this)->actor_wait_state = 0;
		static_cast<AddTenantToManagementClusterActor*>(this)->ActorCallback< AddTenantToManagementClusterActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AddTenantToManagementClusterActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("addTenantToManagementCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddTenantToManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTenantToManagementCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AddTenantToManagementClusterActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("addTenantToManagementCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddTenantToManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTenantToManagementCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AddTenantToManagementClusterActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("addTenantToManagementCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddTenantToManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTenantToManagementCluster", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 749 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	RestoreClusterImpl* self;
															#line 749 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	Reference<ITransaction> tr;
															#line 749 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	TenantMapEntry tenantEntry;
															#line 752 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	Future<Optional<MetaclusterTenantGroupEntry>> tenantGroupEntry;
															#line 789 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	MetaclusterTenantMapEntry managementEntry;
															#line 7163 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
};
// This generated class is to be used only via addTenantToManagementCluster()
															#line 749 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
class AddTenantToManagementClusterActor final : public Actor<bool>, public ActorCallback< AddTenantToManagementClusterActor, 0, Optional<MetaclusterTenantMapEntry> >, public ActorCallback< AddTenantToManagementClusterActor, 1, Void >, public FastAllocated<AddTenantToManagementClusterActor>, public AddTenantToManagementClusterActorState<AddTenantToManagementClusterActor> {
															#line 7168 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
public:
	using FastAllocated<AddTenantToManagementClusterActor>::operator new;
	using FastAllocated<AddTenantToManagementClusterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5630173252672017152UL, 11993919084661456640UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AddTenantToManagementClusterActor, 0, Optional<MetaclusterTenantMapEntry> >;
friend struct ActorCallback< AddTenantToManagementClusterActor, 1, Void >;
															#line 749 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	AddTenantToManagementClusterActor(RestoreClusterImpl* const& self,Reference<ITransaction> const& tr,TenantMapEntry const& tenantEntry) 
															#line 7186 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		 : Actor<bool>(),
		   AddTenantToManagementClusterActorState<AddTenantToManagementClusterActor>(self, tr, tenantEntry),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("addTenantToManagementCluster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1268304299189218048UL, 879178118947309568UL);
		ActorExecutionContextHelper __helper(static_cast<AddTenantToManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("addTenantToManagementCluster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("addTenantToManagementCluster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AddTenantToManagementClusterActor, 0, Optional<MetaclusterTenantMapEntry> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AddTenantToManagementClusterActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 749 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
[[nodiscard]] static Future<bool> addTenantToManagementCluster( RestoreClusterImpl* const& self, Reference<ITransaction> const& tr, TenantMapEntry const& tenantEntry ) {
															#line 749 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	return Future<bool>(new AddTenantToManagementClusterActor(self, tr, tenantEntry));
															#line 7219 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
}

#line 829 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"

																#line 7224 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
// This generated class is to be used only via addTenantBatchToManagementCluster()
															#line 830 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
template <class AddTenantBatchToManagementClusterActor>
															#line 830 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
class AddTenantBatchToManagementClusterActorState {
															#line 7230 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
public:
															#line 830 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	AddTenantBatchToManagementClusterActorState(RestoreClusterImpl* const& self,Reference<typename DB::TransactionT> const& tr,std::vector<TenantMapEntry> const& tenants) 
															#line 830 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
															#line 830 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		 : self(self),
															#line 830 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		   tr(tr),
															#line 830 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		   tenants(tenants),
															#line 833 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		   futures(),
															#line 834 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		   maxId(-1)
															#line 7245 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
	{
		fdb_probe_actor_create("addTenantBatchToManagementCluster", reinterpret_cast<unsigned long>(this));

	}
	~AddTenantBatchToManagementClusterActorState() 
	{
		fdb_probe_actor_destroy("addTenantBatchToManagementCluster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 835 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			for( auto const& t : tenants ) {
															#line 836 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				if (TenantAPI::getTenantIdPrefix(t.id) == self->tenantIdPrefix)
															#line 7262 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
				{
															#line 837 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
					maxId = std::max(maxId, t.id);
															#line 838 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
					self->newLastDataClusterTenantId = std::max(t.id, self->newLastDataClusterTenantId.orDefault(0));
															#line 7268 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
				}
															#line 840 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				futures.push_back(addTenantToManagementCluster(self, tr, t));
															#line 7272 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			}
															#line 843 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			StrictFuture<Void> __when_expr_0 = waitForAll(futures);
															#line 843 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (static_cast<AddTenantBatchToManagementClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7278 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AddTenantBatchToManagementClusterActor*>(this)->actor_wait_state = 1;
															#line 843 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AddTenantBatchToManagementClusterActor, 0, Void >*>(static_cast<AddTenantBatchToManagementClusterActor*>(this)));
															#line 7283 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AddTenantBatchToManagementClusterActorState();
		static_cast<AddTenantBatchToManagementClusterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 845 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		std::set<TenantGroupName> groupsCreated;
															#line 846 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		numGroupsCreated = 0;
															#line 847 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		for(int i = 0;i < tenants.size();++i) {
															#line 848 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (futures[i].get())
															#line 7312 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			{
															#line 849 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				if (tenants[i].tenantGroup.present())
															#line 7316 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
				{
															#line 850 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
					groupsCreated.insert(tenants[i].tenantGroup.get());
															#line 7320 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
				}
				else
				{
															#line 852 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
					++numGroupsCreated;
															#line 7326 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
				}
			}
		}
															#line 857 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		numGroupsCreated += groupsCreated.size();
															#line 859 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!self->restoreDryRun)
															#line 7334 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 860 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (numGroupsCreated > 0)
															#line 7338 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			{
															#line 861 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				DataClusterEntry updatedEntry = self->ctx.dataClusterMetadata.get().entry;
															#line 862 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				if (updatedEntry.clusterState != DataClusterState::RESTORING)
															#line 7344 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
				{
															#line 863 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
					CODE_PROBE(true, "Conflicting restore");
															#line 864 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
					return a_body1Catch1(conflicting_restore(), loopDepth);
															#line 7350 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
				}
															#line 866 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				updatedEntry.allocated.numTenantGroups += numGroupsCreated;
															#line 867 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				updateClusterMetadata(tr, self->clusterName, self->ctx.dataClusterMetadata.get(), Optional<ClusterConnectionString>(), updatedEntry, IsRestoring::True);
															#line 7356 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			}
															#line 875 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			StrictFuture<int64_t> __when_expr_1 = metadata::management::tenantMetadata().lastTenantId.getD(tr, Snapshot::False, -1);
															#line 875 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (static_cast<AddTenantBatchToManagementClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7362 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<AddTenantBatchToManagementClusterActor*>(this)->actor_wait_state = 2;
															#line 875 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AddTenantBatchToManagementClusterActor, 1, int64_t >*>(static_cast<AddTenantBatchToManagementClusterActor*>(this)));
															#line 7367 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 845 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		std::set<TenantGroupName> groupsCreated;
															#line 846 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		numGroupsCreated = 0;
															#line 847 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		for(int i = 0;i < tenants.size();++i) {
															#line 848 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (futures[i].get())
															#line 7387 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			{
															#line 849 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				if (tenants[i].tenantGroup.present())
															#line 7391 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
				{
															#line 850 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
					groupsCreated.insert(tenants[i].tenantGroup.get());
															#line 7395 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
				}
				else
				{
															#line 852 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
					++numGroupsCreated;
															#line 7401 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
				}
			}
		}
															#line 857 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		numGroupsCreated += groupsCreated.size();
															#line 859 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!self->restoreDryRun)
															#line 7409 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 860 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (numGroupsCreated > 0)
															#line 7413 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			{
															#line 861 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				DataClusterEntry updatedEntry = self->ctx.dataClusterMetadata.get().entry;
															#line 862 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				if (updatedEntry.clusterState != DataClusterState::RESTORING)
															#line 7419 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
				{
															#line 863 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
					CODE_PROBE(true, "Conflicting restore");
															#line 864 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
					return a_body1Catch1(conflicting_restore(), loopDepth);
															#line 7425 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
				}
															#line 866 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				updatedEntry.allocated.numTenantGroups += numGroupsCreated;
															#line 867 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				updateClusterMetadata(tr, self->clusterName, self->ctx.dataClusterMetadata.get(), Optional<ClusterConnectionString>(), updatedEntry, IsRestoring::True);
															#line 7431 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			}
															#line 875 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			StrictFuture<int64_t> __when_expr_1 = metadata::management::tenantMetadata().lastTenantId.getD(tr, Snapshot::False, -1);
															#line 875 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (static_cast<AddTenantBatchToManagementClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7437 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<AddTenantBatchToManagementClusterActor*>(this)->actor_wait_state = 2;
															#line 875 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AddTenantBatchToManagementClusterActor, 1, int64_t >*>(static_cast<AddTenantBatchToManagementClusterActor*>(this)));
															#line 7442 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AddTenantBatchToManagementClusterActor*>(this)->actor_wait_state > 0) static_cast<AddTenantBatchToManagementClusterActor*>(this)->actor_wait_state = 0;
		static_cast<AddTenantBatchToManagementClusterActor*>(this)->ActorCallback< AddTenantBatchToManagementClusterActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AddTenantBatchToManagementClusterActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("addTenantBatchToManagementCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddTenantBatchToManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTenantBatchToManagementCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AddTenantBatchToManagementClusterActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("addTenantBatchToManagementCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddTenantBatchToManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTenantBatchToManagementCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AddTenantBatchToManagementClusterActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("addTenantBatchToManagementCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddTenantBatchToManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTenantBatchToManagementCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 885 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!static_cast<AddTenantBatchToManagementClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AddTenantBatchToManagementClusterActorState(); static_cast<AddTenantBatchToManagementClusterActor*>(this)->destroy(); return 0; }
															#line 7531 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		new (&static_cast<AddTenantBatchToManagementClusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~AddTenantBatchToManagementClusterActorState();
		static_cast<AddTenantBatchToManagementClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont9(int64_t const& lastTenantId,int loopDepth) 
	{
															#line 878 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (maxId > lastTenantId)
															#line 7543 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 879 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			metadata::management::tenantMetadata().lastTenantId.set(tr, maxId);
															#line 7547 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		}
															#line 882 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		metadata::management::tenantMetadata().lastTenantModification.setVersionstamp(tr, Versionstamp(), 0);
															#line 7551 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont9(int64_t && lastTenantId,int loopDepth) 
	{
															#line 878 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (maxId > lastTenantId)
															#line 7560 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 879 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			metadata::management::tenantMetadata().lastTenantId.set(tr, maxId);
															#line 7564 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		}
															#line 882 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		metadata::management::tenantMetadata().lastTenantModification.setVersionstamp(tr, Versionstamp(), 0);
															#line 7568 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(int64_t const& lastTenantId,int loopDepth) 
	{
		loopDepth = a_body1cont9(lastTenantId, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(int64_t && lastTenantId,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(lastTenantId), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AddTenantBatchToManagementClusterActor*>(this)->actor_wait_state > 0) static_cast<AddTenantBatchToManagementClusterActor*>(this)->actor_wait_state = 0;
		static_cast<AddTenantBatchToManagementClusterActor*>(this)->ActorCallback< AddTenantBatchToManagementClusterActor, 1, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< AddTenantBatchToManagementClusterActor, 1, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("addTenantBatchToManagementCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddTenantBatchToManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTenantBatchToManagementCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AddTenantBatchToManagementClusterActor, 1, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("addTenantBatchToManagementCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddTenantBatchToManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTenantBatchToManagementCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AddTenantBatchToManagementClusterActor, 1, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("addTenantBatchToManagementCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddTenantBatchToManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTenantBatchToManagementCluster", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 830 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	RestoreClusterImpl* self;
															#line 830 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	Reference<typename DB::TransactionT> tr;
															#line 830 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	std::vector<TenantMapEntry> tenants;
															#line 833 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	std::vector<Future<bool>> futures;
															#line 834 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	int64_t maxId;
															#line 846 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	int numGroupsCreated;
															#line 7660 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
};
// This generated class is to be used only via addTenantBatchToManagementCluster()
															#line 830 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
class AddTenantBatchToManagementClusterActor final : public Actor<Void>, public ActorCallback< AddTenantBatchToManagementClusterActor, 0, Void >, public ActorCallback< AddTenantBatchToManagementClusterActor, 1, int64_t >, public FastAllocated<AddTenantBatchToManagementClusterActor>, public AddTenantBatchToManagementClusterActorState<AddTenantBatchToManagementClusterActor> {
															#line 7665 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
public:
	using FastAllocated<AddTenantBatchToManagementClusterActor>::operator new;
	using FastAllocated<AddTenantBatchToManagementClusterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5994176422842921728UL, 475472943305472UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AddTenantBatchToManagementClusterActor, 0, Void >;
friend struct ActorCallback< AddTenantBatchToManagementClusterActor, 1, int64_t >;
															#line 830 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	AddTenantBatchToManagementClusterActor(RestoreClusterImpl* const& self,Reference<typename DB::TransactionT> const& tr,std::vector<TenantMapEntry> const& tenants) 
															#line 7683 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		 : Actor<Void>(),
		   AddTenantBatchToManagementClusterActorState<AddTenantBatchToManagementClusterActor>(self, tr, tenants),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("addTenantBatchToManagementCluster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5133468163617375232UL, 5912551069685300992UL);
		ActorExecutionContextHelper __helper(static_cast<AddTenantBatchToManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("addTenantBatchToManagementCluster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("addTenantBatchToManagementCluster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AddTenantBatchToManagementClusterActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AddTenantBatchToManagementClusterActor, 1, int64_t >*)0, actor_cancelled()); break;
		}

	}
};
															#line 830 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
[[nodiscard]] static Future<Void> addTenantBatchToManagementCluster( RestoreClusterImpl* const& self, Reference<typename DB::TransactionT> const& tr, std::vector<TenantMapEntry> const& tenants ) {
															#line 830 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	return Future<Void>(new AddTenantBatchToManagementClusterActor(self, tr, tenants));
															#line 7716 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
}

#line 887 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"

																#line 7721 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
// This generated class is to be used only via updateLastTenantId()
															#line 888 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
template <class UpdateLastTenantIdActor>
															#line 888 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
class UpdateLastTenantIdActorState {
															#line 7727 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
public:
															#line 888 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	UpdateLastTenantIdActorState(RestoreClusterImpl* const& self,Reference<typename DB::TransactionT> const& tr) 
															#line 888 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
															#line 888 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		 : self(self),
															#line 888 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		   tr(tr)
															#line 7736 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
	{
		fdb_probe_actor_create("updateLastTenantId", reinterpret_cast<unsigned long>(this));

	}
	~UpdateLastTenantIdActorState() 
	{
		fdb_probe_actor_destroy("updateLastTenantId", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 889 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			StrictFuture<Void> __when_expr_0 = loadTenantIdData(self, tr);
															#line 889 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (static_cast<UpdateLastTenantIdActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7753 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UpdateLastTenantIdActor*>(this)->actor_wait_state = 1;
															#line 889 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateLastTenantIdActor, 0, Void >*>(static_cast<UpdateLastTenantIdActor*>(this)));
															#line 7758 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateLastTenantIdActorState();
		static_cast<UpdateLastTenantIdActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 891 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (self->lastDataClusterTenantId.present() && self->tenantIdPrefix == TenantAPI::getTenantIdPrefix(self->lastDataClusterTenantId.get()))
															#line 7781 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 893 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (!self->forceReuseTenantIdPrefix)
															#line 7785 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			{
															#line 894 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				self->messages.push_back(fmt::format( "The data cluster being added is using the same tenant ID prefix {} as the management cluster.", self->tenantIdPrefix));
															#line 897 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				CODE_PROBE(true, "Reusing tenant ID without force reuse option");
															#line 898 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				return a_body1Catch1(invalid_metacluster_configuration(), loopDepth);
															#line 7793 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			}
			else
			{
															#line 899 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				if (!self->restoreDryRun && self->lastDataClusterTenantId.get() > self->lastManagementClusterTenantId.orDefault(-1))
															#line 7799 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
				{
															#line 901 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
					CODE_PROBE(true, "Reusing tenant ID prefix and increase existing ID");
															#line 902 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
					metadata::management::tenantMetadata().lastTenantId.set(tr, self->lastDataClusterTenantId.get());
															#line 7805 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
				}
			}
															#line 905 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			CODE_PROBE(true, "Reusing tenant ID prefix");
															#line 906 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			self->newLastDataClusterTenantId = self->lastDataClusterTenantId;
															#line 7812 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		}
															#line 909 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!static_cast<UpdateLastTenantIdActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateLastTenantIdActorState(); static_cast<UpdateLastTenantIdActor*>(this)->destroy(); return 0; }
															#line 7816 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		new (&static_cast<UpdateLastTenantIdActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateLastTenantIdActorState();
		static_cast<UpdateLastTenantIdActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 891 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (self->lastDataClusterTenantId.present() && self->tenantIdPrefix == TenantAPI::getTenantIdPrefix(self->lastDataClusterTenantId.get()))
															#line 7828 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 893 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (!self->forceReuseTenantIdPrefix)
															#line 7832 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			{
															#line 894 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				self->messages.push_back(fmt::format( "The data cluster being added is using the same tenant ID prefix {} as the management cluster.", self->tenantIdPrefix));
															#line 897 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				CODE_PROBE(true, "Reusing tenant ID without force reuse option");
															#line 898 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				return a_body1Catch1(invalid_metacluster_configuration(), loopDepth);
															#line 7840 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			}
			else
			{
															#line 899 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				if (!self->restoreDryRun && self->lastDataClusterTenantId.get() > self->lastManagementClusterTenantId.orDefault(-1))
															#line 7846 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
				{
															#line 901 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
					CODE_PROBE(true, "Reusing tenant ID prefix and increase existing ID");
															#line 902 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
					metadata::management::tenantMetadata().lastTenantId.set(tr, self->lastDataClusterTenantId.get());
															#line 7852 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
				}
			}
															#line 905 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			CODE_PROBE(true, "Reusing tenant ID prefix");
															#line 906 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			self->newLastDataClusterTenantId = self->lastDataClusterTenantId;
															#line 7859 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		}
															#line 909 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!static_cast<UpdateLastTenantIdActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateLastTenantIdActorState(); static_cast<UpdateLastTenantIdActor*>(this)->destroy(); return 0; }
															#line 7863 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		new (&static_cast<UpdateLastTenantIdActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateLastTenantIdActorState();
		static_cast<UpdateLastTenantIdActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateLastTenantIdActor*>(this)->actor_wait_state > 0) static_cast<UpdateLastTenantIdActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateLastTenantIdActor*>(this)->ActorCallback< UpdateLastTenantIdActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateLastTenantIdActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateLastTenantId", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLastTenantIdActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLastTenantId", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateLastTenantIdActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateLastTenantId", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLastTenantIdActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLastTenantId", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateLastTenantIdActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateLastTenantId", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLastTenantIdActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLastTenantId", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 888 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	RestoreClusterImpl* self;
															#line 888 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	Reference<typename DB::TransactionT> tr;
															#line 7950 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
};
// This generated class is to be used only via updateLastTenantId()
															#line 888 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
class UpdateLastTenantIdActor final : public Actor<Void>, public ActorCallback< UpdateLastTenantIdActor, 0, Void >, public FastAllocated<UpdateLastTenantIdActor>, public UpdateLastTenantIdActorState<UpdateLastTenantIdActor> {
															#line 7955 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
public:
	using FastAllocated<UpdateLastTenantIdActor>::operator new;
	using FastAllocated<UpdateLastTenantIdActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16152547079467579136UL, 14036914361891855104UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateLastTenantIdActor, 0, Void >;
															#line 888 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	UpdateLastTenantIdActor(RestoreClusterImpl* const& self,Reference<typename DB::TransactionT> const& tr) 
															#line 7972 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		 : Actor<Void>(),
		   UpdateLastTenantIdActorState<UpdateLastTenantIdActor>(self, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateLastTenantId", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11588164997519479040UL, 11808998488897734656UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLastTenantIdActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateLastTenantId");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateLastTenantId", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateLastTenantIdActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 888 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
[[nodiscard]] static Future<Void> updateLastTenantId( RestoreClusterImpl* const& self, Reference<typename DB::TransactionT> const& tr ) {
															#line 888 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	return Future<Void>(new UpdateLastTenantIdActor(self, tr));
															#line 8004 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
}

#line 911 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"

																#line 8009 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
// This generated class is to be used only via addTenantsToManagementCluster()
															#line 912 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
template <class AddTenantsToManagementClusterActor>
															#line 912 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
class AddTenantsToManagementClusterActorState {
															#line 8015 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
public:
															#line 912 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	AddTenantsToManagementClusterActorState(RestoreClusterImpl* const& self) 
															#line 912 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
															#line 912 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		 : self(self),
															#line 913 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		   itr(),
															#line 914 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		   tenantBatch(),
															#line 915 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		   tenantsToAdd(0)
															#line 8028 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
	{
		fdb_probe_actor_create("addTenantsToManagementCluster", reinterpret_cast<unsigned long>(this));

	}
	~AddTenantsToManagementClusterActorState() 
	{
		fdb_probe_actor_destroy("addTenantsToManagementCluster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 917 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			StrictFuture<Void> __when_expr_0 = self->runRestoreManagementTransaction( [self = self](Reference<typename DB::TransactionT> tr) { return updateLastTenantId(self, tr); });
															#line 917 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (static_cast<AddTenantsToManagementClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8045 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AddTenantsToManagementClusterActor*>(this)->actor_wait_state = 1;
															#line 917 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AddTenantsToManagementClusterActor, 0, Void >*>(static_cast<AddTenantsToManagementClusterActor*>(this)));
															#line 8050 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AddTenantsToManagementClusterActorState();
		static_cast<AddTenantsToManagementClusterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 920 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		itr = self->dataClusterTenantMap.begin();
															#line 8073 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 920 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		itr = self->dataClusterTenantMap.begin();
															#line 8082 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AddTenantsToManagementClusterActor*>(this)->actor_wait_state > 0) static_cast<AddTenantsToManagementClusterActor*>(this)->actor_wait_state = 0;
		static_cast<AddTenantsToManagementClusterActor*>(this)->ActorCallback< AddTenantsToManagementClusterActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AddTenantsToManagementClusterActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("addTenantsToManagementCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddTenantsToManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTenantsToManagementCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AddTenantsToManagementClusterActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("addTenantsToManagementCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddTenantsToManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTenantsToManagementCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AddTenantsToManagementClusterActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("addTenantsToManagementCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddTenantsToManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTenantsToManagementCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 949 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!tenantBatch.empty())
															#line 8166 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 950 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			StrictFuture<Void> __when_expr_2 = self->runRestoreManagementTransaction( [self = self, tenantBatch = tenantBatch](Reference<typename DB::TransactionT> tr) { tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS); return addTenantBatchToManagementCluster(self, tr, tenantBatch); });
															#line 950 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (static_cast<AddTenantsToManagementClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8172 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<AddTenantsToManagementClusterActor*>(this)->actor_wait_state = 3;
															#line 950 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< AddTenantsToManagementClusterActor, 2, Void >*>(static_cast<AddTenantsToManagementClusterActor*>(this)));
															#line 8177 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 920 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!(itr != self->dataClusterTenantMap.end()))
															#line 8198 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 921 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		managementEntry = self->mgmtClusterTenantMap.find(itr->second.id);
															#line 923 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (managementEntry == self->mgmtClusterTenantMap.end())
															#line 8206 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 924 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			++tenantsToAdd;
															#line 925 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			tenantBatch.push_back(itr->second);
															#line 8212 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		}
		else
		{
															#line 926 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (managementEntry->second.tenantName != itr->second.tenantName || managementEntry->second.assignedCluster != self->clusterName || !managementEntry->second.matchesConfiguration(itr->second))
															#line 8218 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			{
															#line 929 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				self->messages.push_back( fmt::format("The tenant `{}' has the same ID {} as an existing tenant `{}' on cluster `{}'", printable(itr->second.tenantName), itr->second.id, printable(managementEntry->second.tenantName), printable(managementEntry->second.assignedCluster)));
															#line 935 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				CODE_PROBE(true, "Restoring tenant with duplicate ID");
															#line 936 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				return a_body1Catch1(tenant_already_exists(), std::max(0, loopDepth - 1));
															#line 8226 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			}
		}
															#line 939 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (tenantBatch.size() == CLIENT_KNOBS->METACLUSTER_RESTORE_BATCH_SIZE)
															#line 8231 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 940 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			StrictFuture<Void> __when_expr_1 = self->runRestoreManagementTransaction( [self = self, tenantBatch = tenantBatch](Reference<typename DB::TransactionT> tr) { tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS); return addTenantBatchToManagementCluster(self, tr, tenantBatch); });
															#line 940 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (static_cast<AddTenantsToManagementClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8237 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<AddTenantsToManagementClusterActor*>(this)->actor_wait_state = 2;
															#line 940 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AddTenantsToManagementClusterActor, 1, Void >*>(static_cast<AddTenantsToManagementClusterActor*>(this)));
															#line 8242 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 920 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		++itr;
															#line 8269 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 945 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		tenantBatch.clear();
															#line 8278 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 945 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		tenantBatch.clear();
															#line 8287 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AddTenantsToManagementClusterActor*>(this)->actor_wait_state > 0) static_cast<AddTenantsToManagementClusterActor*>(this)->actor_wait_state = 0;
		static_cast<AddTenantsToManagementClusterActor*>(this)->ActorCallback< AddTenantsToManagementClusterActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AddTenantsToManagementClusterActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("addTenantsToManagementCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddTenantsToManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTenantsToManagementCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AddTenantsToManagementClusterActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("addTenantsToManagementCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddTenantsToManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTenantsToManagementCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AddTenantsToManagementClusterActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("addTenantsToManagementCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddTenantsToManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTenantsToManagementCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 957 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (self->restoreDryRun)
															#line 8371 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 958 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			self->messages.push_back( fmt::format("Restore will add {} tenant(s) to the management cluster from the data cluster `{}'", tenantsToAdd, printable(self->clusterName)));
															#line 8375 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		}
															#line 964 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!static_cast<AddTenantsToManagementClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AddTenantsToManagementClusterActorState(); static_cast<AddTenantsToManagementClusterActor*>(this)->destroy(); return 0; }
															#line 8379 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		new (&static_cast<AddTenantsToManagementClusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~AddTenantsToManagementClusterActorState();
		static_cast<AddTenantsToManagementClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<AddTenantsToManagementClusterActor*>(this)->actor_wait_state > 0) static_cast<AddTenantsToManagementClusterActor*>(this)->actor_wait_state = 0;
		static_cast<AddTenantsToManagementClusterActor*>(this)->ActorCallback< AddTenantsToManagementClusterActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AddTenantsToManagementClusterActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("addTenantsToManagementCluster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddTenantsToManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTenantsToManagementCluster", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< AddTenantsToManagementClusterActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("addTenantsToManagementCluster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddTenantsToManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTenantsToManagementCluster", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< AddTenantsToManagementClusterActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("addTenantsToManagementCluster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddTenantsToManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTenantsToManagementCluster", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 912 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	RestoreClusterImpl* self;
															#line 913 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	std::unordered_map<int64_t, TenantMapEntry>::iterator itr;
															#line 914 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	std::vector<TenantMapEntry> tenantBatch;
															#line 915 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	int64_t tenantsToAdd;
															#line 921 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	std::unordered_map<int64_t, MetaclusterTenantMapEntry>::iterator managementEntry;
															#line 8484 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
};
// This generated class is to be used only via addTenantsToManagementCluster()
															#line 912 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
class AddTenantsToManagementClusterActor final : public Actor<Void>, public ActorCallback< AddTenantsToManagementClusterActor, 0, Void >, public ActorCallback< AddTenantsToManagementClusterActor, 1, Void >, public ActorCallback< AddTenantsToManagementClusterActor, 2, Void >, public FastAllocated<AddTenantsToManagementClusterActor>, public AddTenantsToManagementClusterActorState<AddTenantsToManagementClusterActor> {
															#line 8489 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
public:
	using FastAllocated<AddTenantsToManagementClusterActor>::operator new;
	using FastAllocated<AddTenantsToManagementClusterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13014598655633050624UL, 14485524169179183616UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AddTenantsToManagementClusterActor, 0, Void >;
friend struct ActorCallback< AddTenantsToManagementClusterActor, 1, Void >;
friend struct ActorCallback< AddTenantsToManagementClusterActor, 2, Void >;
															#line 912 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	AddTenantsToManagementClusterActor(RestoreClusterImpl* const& self) 
															#line 8508 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		 : Actor<Void>(),
		   AddTenantsToManagementClusterActorState<AddTenantsToManagementClusterActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("addTenantsToManagementCluster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5579572921989369600UL, 16851087383894825216UL);
		ActorExecutionContextHelper __helper(static_cast<AddTenantsToManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("addTenantsToManagementCluster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("addTenantsToManagementCluster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AddTenantsToManagementClusterActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AddTenantsToManagementClusterActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< AddTenantsToManagementClusterActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 912 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
[[nodiscard]] static Future<Void> addTenantsToManagementCluster( RestoreClusterImpl* const& self ) {
															#line 912 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	return Future<Void>(new AddTenantsToManagementClusterActor(self));
															#line 8542 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
}

#line 966 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"

																#line 8547 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
// This generated class is to be used only via finalizeDataClusterAfterRepopulate()
															#line 967 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
template <class FinalizeDataClusterAfterRepopulateActor>
															#line 967 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
class FinalizeDataClusterAfterRepopulateActorState {
															#line 8553 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
public:
															#line 967 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	FinalizeDataClusterAfterRepopulateActorState(RestoreClusterImpl* const& self,Reference<ITransaction> const& tr) 
															#line 967 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
															#line 967 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		 : self(self),
															#line 967 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		   tr(tr)
															#line 8562 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
	{
		fdb_probe_actor_create("finalizeDataClusterAfterRepopulate", reinterpret_cast<unsigned long>(this));

	}
	~FinalizeDataClusterAfterRepopulateActorState() 
	{
		fdb_probe_actor_destroy("finalizeDataClusterAfterRepopulate", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 968 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			StrictFuture<bool> __when_expr_0 = eraseRestoreId(self, tr);
															#line 968 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (static_cast<FinalizeDataClusterAfterRepopulateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8579 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FinalizeDataClusterAfterRepopulateActor*>(this)->actor_wait_state = 1;
															#line 968 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FinalizeDataClusterAfterRepopulateActor, 0, bool >*>(static_cast<FinalizeDataClusterAfterRepopulateActor*>(this)));
															#line 8584 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FinalizeDataClusterAfterRepopulateActorState();
		static_cast<FinalizeDataClusterAfterRepopulateActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(bool const& erased,int loopDepth) 
	{
															#line 969 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (erased)
															#line 8607 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 970 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			TenantMetadata::tenantIdPrefix().set(tr, self->tenantIdPrefix);
															#line 971 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (self->newLastDataClusterTenantId.present())
															#line 8613 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			{
															#line 972 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				TenantMetadata::lastTenantId().set(tr, self->newLastDataClusterTenantId.get());
															#line 8617 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			}
			else
			{
															#line 974 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				TenantMetadata::lastTenantId().clear(tr);
															#line 8623 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			}
															#line 977 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			StrictFuture<Optional<TenantTombstoneCleanupData>> __when_expr_1 = TenantMetadata::tombstoneCleanupData().get(tr);
															#line 977 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (static_cast<FinalizeDataClusterAfterRepopulateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8629 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<FinalizeDataClusterAfterRepopulateActor*>(this)->actor_wait_state = 2;
															#line 977 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FinalizeDataClusterAfterRepopulateActor, 1, Optional<TenantTombstoneCleanupData> >*>(static_cast<FinalizeDataClusterAfterRepopulateActor*>(this)));
															#line 8634 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(bool && erased,int loopDepth) 
	{
															#line 969 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (erased)
															#line 8648 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 970 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			TenantMetadata::tenantIdPrefix().set(tr, self->tenantIdPrefix);
															#line 971 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (self->newLastDataClusterTenantId.present())
															#line 8654 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			{
															#line 972 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				TenantMetadata::lastTenantId().set(tr, self->newLastDataClusterTenantId.get());
															#line 8658 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			}
			else
			{
															#line 974 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
				TenantMetadata::lastTenantId().clear(tr);
															#line 8664 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			}
															#line 977 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			StrictFuture<Optional<TenantTombstoneCleanupData>> __when_expr_1 = TenantMetadata::tombstoneCleanupData().get(tr);
															#line 977 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (static_cast<FinalizeDataClusterAfterRepopulateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8670 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<FinalizeDataClusterAfterRepopulateActor*>(this)->actor_wait_state = 2;
															#line 977 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FinalizeDataClusterAfterRepopulateActor, 1, Optional<TenantTombstoneCleanupData> >*>(static_cast<FinalizeDataClusterAfterRepopulateActor*>(this)));
															#line 8675 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(bool const& erased,int loopDepth) 
	{
		loopDepth = a_body1cont1(erased, loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool && erased,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(erased), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FinalizeDataClusterAfterRepopulateActor*>(this)->actor_wait_state > 0) static_cast<FinalizeDataClusterAfterRepopulateActor*>(this)->actor_wait_state = 0;
		static_cast<FinalizeDataClusterAfterRepopulateActor*>(this)->ActorCallback< FinalizeDataClusterAfterRepopulateActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< FinalizeDataClusterAfterRepopulateActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("finalizeDataClusterAfterRepopulate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinalizeDataClusterAfterRepopulateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finalizeDataClusterAfterRepopulate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FinalizeDataClusterAfterRepopulateActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("finalizeDataClusterAfterRepopulate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinalizeDataClusterAfterRepopulateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finalizeDataClusterAfterRepopulate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FinalizeDataClusterAfterRepopulateActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("finalizeDataClusterAfterRepopulate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinalizeDataClusterAfterRepopulateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finalizeDataClusterAfterRepopulate", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 989 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!static_cast<FinalizeDataClusterAfterRepopulateActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FinalizeDataClusterAfterRepopulateActorState(); static_cast<FinalizeDataClusterAfterRepopulateActor*>(this)->destroy(); return 0; }
															#line 8764 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		new (&static_cast<FinalizeDataClusterAfterRepopulateActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FinalizeDataClusterAfterRepopulateActorState();
		static_cast<FinalizeDataClusterAfterRepopulateActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Optional<TenantTombstoneCleanupData> const& tombstoneCleanupData,int loopDepth) 
	{
															#line 981 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!tombstoneCleanupData.present() || TenantAPI::getTenantIdPrefix(tombstoneCleanupData.get().nextTombstoneEraseId) != self->tenantIdPrefix)
															#line 8776 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 983 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			CODE_PROBE(true, "Remove tombstone cleanup data during management cluster repopulate");
															#line 984 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			TenantMetadata::tenantTombstones().clear(tr);
															#line 985 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			TenantMetadata::tombstoneCleanupData().clear(tr);
															#line 8784 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		}
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Optional<TenantTombstoneCleanupData> && tombstoneCleanupData,int loopDepth) 
	{
															#line 981 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!tombstoneCleanupData.present() || TenantAPI::getTenantIdPrefix(tombstoneCleanupData.get().nextTombstoneEraseId) != self->tenantIdPrefix)
															#line 8794 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 983 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			CODE_PROBE(true, "Remove tombstone cleanup data during management cluster repopulate");
															#line 984 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			TenantMetadata::tenantTombstones().clear(tr);
															#line 985 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			TenantMetadata::tombstoneCleanupData().clear(tr);
															#line 8802 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		}
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<TenantTombstoneCleanupData> const& tombstoneCleanupData,int loopDepth) 
	{
		loopDepth = a_body1cont3(tombstoneCleanupData, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<TenantTombstoneCleanupData> && tombstoneCleanupData,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(tombstoneCleanupData), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FinalizeDataClusterAfterRepopulateActor*>(this)->actor_wait_state > 0) static_cast<FinalizeDataClusterAfterRepopulateActor*>(this)->actor_wait_state = 0;
		static_cast<FinalizeDataClusterAfterRepopulateActor*>(this)->ActorCallback< FinalizeDataClusterAfterRepopulateActor, 1, Optional<TenantTombstoneCleanupData> >::remove();

	}
	void a_callback_fire(ActorCallback< FinalizeDataClusterAfterRepopulateActor, 1, Optional<TenantTombstoneCleanupData> >*,Optional<TenantTombstoneCleanupData> const& value) 
	{
		fdb_probe_actor_enter("finalizeDataClusterAfterRepopulate", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinalizeDataClusterAfterRepopulateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finalizeDataClusterAfterRepopulate", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FinalizeDataClusterAfterRepopulateActor, 1, Optional<TenantTombstoneCleanupData> >*,Optional<TenantTombstoneCleanupData> && value) 
	{
		fdb_probe_actor_enter("finalizeDataClusterAfterRepopulate", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinalizeDataClusterAfterRepopulateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finalizeDataClusterAfterRepopulate", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FinalizeDataClusterAfterRepopulateActor, 1, Optional<TenantTombstoneCleanupData> >*,Error err) 
	{
		fdb_probe_actor_enter("finalizeDataClusterAfterRepopulate", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinalizeDataClusterAfterRepopulateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finalizeDataClusterAfterRepopulate", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 967 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	RestoreClusterImpl* self;
															#line 967 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	Reference<ITransaction> tr;
															#line 8887 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
};
// This generated class is to be used only via finalizeDataClusterAfterRepopulate()
															#line 967 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
class FinalizeDataClusterAfterRepopulateActor final : public Actor<Void>, public ActorCallback< FinalizeDataClusterAfterRepopulateActor, 0, bool >, public ActorCallback< FinalizeDataClusterAfterRepopulateActor, 1, Optional<TenantTombstoneCleanupData> >, public FastAllocated<FinalizeDataClusterAfterRepopulateActor>, public FinalizeDataClusterAfterRepopulateActorState<FinalizeDataClusterAfterRepopulateActor> {
															#line 8892 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
public:
	using FastAllocated<FinalizeDataClusterAfterRepopulateActor>::operator new;
	using FastAllocated<FinalizeDataClusterAfterRepopulateActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1918950757972557568UL, 15908763831911385344UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FinalizeDataClusterAfterRepopulateActor, 0, bool >;
friend struct ActorCallback< FinalizeDataClusterAfterRepopulateActor, 1, Optional<TenantTombstoneCleanupData> >;
															#line 967 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	FinalizeDataClusterAfterRepopulateActor(RestoreClusterImpl* const& self,Reference<ITransaction> const& tr) 
															#line 8910 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		 : Actor<Void>(),
		   FinalizeDataClusterAfterRepopulateActorState<FinalizeDataClusterAfterRepopulateActor>(self, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("finalizeDataClusterAfterRepopulate", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13204561525274493696UL, 8619959898184553728UL);
		ActorExecutionContextHelper __helper(static_cast<FinalizeDataClusterAfterRepopulateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("finalizeDataClusterAfterRepopulate");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("finalizeDataClusterAfterRepopulate", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FinalizeDataClusterAfterRepopulateActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FinalizeDataClusterAfterRepopulateActor, 1, Optional<TenantTombstoneCleanupData> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 967 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
[[nodiscard]] static Future<Void> finalizeDataClusterAfterRepopulate( RestoreClusterImpl* const& self, Reference<ITransaction> const& tr ) {
															#line 967 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	return Future<Void>(new FinalizeDataClusterAfterRepopulateActor(self, tr));
															#line 8943 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
}

#line 991 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"

																#line 8948 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
// This generated class is to be used only via updateDataClusterMetadata()
															#line 992 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
template <class UpdateDataClusterMetadataActor>
															#line 992 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
class UpdateDataClusterMetadataActorState {
															#line 8954 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
public:
															#line 992 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	UpdateDataClusterMetadataActorState(RestoreClusterImpl* const& self,Reference<ITransaction> const& tr) 
															#line 992 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
															#line 992 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		 : self(self),
															#line 992 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		   tr(tr)
															#line 8963 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
	{
		fdb_probe_actor_create("updateDataClusterMetadata", reinterpret_cast<unsigned long>(this));

	}
	~UpdateDataClusterMetadataActorState() 
	{
		fdb_probe_actor_destroy("updateDataClusterMetadata", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 993 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			StrictFuture<Versionstamp> __when_expr_0 = metadata::maxRestoreId().getD(tr, Snapshot::False, Versionstamp());
															#line 993 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (static_cast<UpdateDataClusterMetadataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8980 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UpdateDataClusterMetadataActor*>(this)->actor_wait_state = 1;
															#line 993 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateDataClusterMetadataActor, 0, Versionstamp >*>(static_cast<UpdateDataClusterMetadataActor*>(this)));
															#line 8985 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateDataClusterMetadataActorState();
		static_cast<UpdateDataClusterMetadataActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Versionstamp const& maxRestoreId,int loopDepth) 
	{
															#line 994 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!self->restoreId.replaces(maxRestoreId))
															#line 9008 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 995 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			return a_body1Catch1(conflicting_restore(), loopDepth);
															#line 9012 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		}
															#line 998 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		metadata::activeRestoreIds().addReadConflictKey(tr, self->clusterName);
															#line 999 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		metadata::activeRestoreIds().set(tr, self->clusterName, self->restoreId);
															#line 1000 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		metadata::maxRestoreId().set(tr, self->restoreId.versionstamp);
															#line 1001 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		TenantMetadata::tenantIdPrefix().set(tr, self->tenantIdPrefix);
															#line 1002 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (self->lastManagementClusterTenantId.present())
															#line 9024 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 1003 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			TenantMetadata::lastTenantId().set(tr, self->lastManagementClusterTenantId.get());
															#line 9028 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		}
		else
		{
															#line 1005 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			TenantMetadata::lastTenantId().clear(tr);
															#line 9034 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		}
															#line 1008 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		StrictFuture<Optional<TenantTombstoneCleanupData>> __when_expr_1 = TenantMetadata::tombstoneCleanupData().get(tr);
															#line 1008 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (static_cast<UpdateDataClusterMetadataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9040 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<UpdateDataClusterMetadataActor*>(this)->actor_wait_state = 2;
															#line 1008 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdateDataClusterMetadataActor, 1, Optional<TenantTombstoneCleanupData> >*>(static_cast<UpdateDataClusterMetadataActor*>(this)));
															#line 9045 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Versionstamp && maxRestoreId,int loopDepth) 
	{
															#line 994 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!self->restoreId.replaces(maxRestoreId))
															#line 9054 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 995 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			return a_body1Catch1(conflicting_restore(), loopDepth);
															#line 9058 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		}
															#line 998 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		metadata::activeRestoreIds().addReadConflictKey(tr, self->clusterName);
															#line 999 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		metadata::activeRestoreIds().set(tr, self->clusterName, self->restoreId);
															#line 1000 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		metadata::maxRestoreId().set(tr, self->restoreId.versionstamp);
															#line 1001 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		TenantMetadata::tenantIdPrefix().set(tr, self->tenantIdPrefix);
															#line 1002 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (self->lastManagementClusterTenantId.present())
															#line 9070 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 1003 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			TenantMetadata::lastTenantId().set(tr, self->lastManagementClusterTenantId.get());
															#line 9074 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		}
		else
		{
															#line 1005 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			TenantMetadata::lastTenantId().clear(tr);
															#line 9080 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		}
															#line 1008 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		StrictFuture<Optional<TenantTombstoneCleanupData>> __when_expr_1 = TenantMetadata::tombstoneCleanupData().get(tr);
															#line 1008 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (static_cast<UpdateDataClusterMetadataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9086 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<UpdateDataClusterMetadataActor*>(this)->actor_wait_state = 2;
															#line 1008 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdateDataClusterMetadataActor, 1, Optional<TenantTombstoneCleanupData> >*>(static_cast<UpdateDataClusterMetadataActor*>(this)));
															#line 9091 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Versionstamp const& maxRestoreId,int loopDepth) 
	{
		loopDepth = a_body1cont1(maxRestoreId, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Versionstamp && maxRestoreId,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(maxRestoreId), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateDataClusterMetadataActor*>(this)->actor_wait_state > 0) static_cast<UpdateDataClusterMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateDataClusterMetadataActor*>(this)->ActorCallback< UpdateDataClusterMetadataActor, 0, Versionstamp >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateDataClusterMetadataActor, 0, Versionstamp >*,Versionstamp const& value) 
	{
		fdb_probe_actor_enter("updateDataClusterMetadata", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDataClusterMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDataClusterMetadata", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateDataClusterMetadataActor, 0, Versionstamp >*,Versionstamp && value) 
	{
		fdb_probe_actor_enter("updateDataClusterMetadata", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDataClusterMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDataClusterMetadata", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateDataClusterMetadataActor, 0, Versionstamp >*,Error err) 
	{
		fdb_probe_actor_enter("updateDataClusterMetadata", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDataClusterMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDataClusterMetadata", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Optional<TenantTombstoneCleanupData> const& tombstoneCleanupData,int loopDepth) 
	{
															#line 1012 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!tombstoneCleanupData.present() || TenantAPI::getTenantIdPrefix(tombstoneCleanupData.get().nextTombstoneEraseId) != self->tenantIdPrefix)
															#line 9175 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 1014 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			CODE_PROBE(true, "Remove tombstone cleanup data during data cluster restore");
															#line 1015 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			TenantMetadata::tenantTombstones().clear(tr);
															#line 1016 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			TenantMetadata::tombstoneCleanupData().clear(tr);
															#line 9183 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		}
															#line 1019 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!static_cast<UpdateDataClusterMetadataActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateDataClusterMetadataActorState(); static_cast<UpdateDataClusterMetadataActor*>(this)->destroy(); return 0; }
															#line 9187 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		new (&static_cast<UpdateDataClusterMetadataActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateDataClusterMetadataActorState();
		static_cast<UpdateDataClusterMetadataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Optional<TenantTombstoneCleanupData> && tombstoneCleanupData,int loopDepth) 
	{
															#line 1012 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!tombstoneCleanupData.present() || TenantAPI::getTenantIdPrefix(tombstoneCleanupData.get().nextTombstoneEraseId) != self->tenantIdPrefix)
															#line 9199 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 1014 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			CODE_PROBE(true, "Remove tombstone cleanup data during data cluster restore");
															#line 1015 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			TenantMetadata::tenantTombstones().clear(tr);
															#line 1016 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			TenantMetadata::tombstoneCleanupData().clear(tr);
															#line 9207 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		}
															#line 1019 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!static_cast<UpdateDataClusterMetadataActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateDataClusterMetadataActorState(); static_cast<UpdateDataClusterMetadataActor*>(this)->destroy(); return 0; }
															#line 9211 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		new (&static_cast<UpdateDataClusterMetadataActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateDataClusterMetadataActorState();
		static_cast<UpdateDataClusterMetadataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Optional<TenantTombstoneCleanupData> const& tombstoneCleanupData,int loopDepth) 
	{
		loopDepth = a_body1cont2(tombstoneCleanupData, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<TenantTombstoneCleanupData> && tombstoneCleanupData,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(tombstoneCleanupData), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UpdateDataClusterMetadataActor*>(this)->actor_wait_state > 0) static_cast<UpdateDataClusterMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateDataClusterMetadataActor*>(this)->ActorCallback< UpdateDataClusterMetadataActor, 1, Optional<TenantTombstoneCleanupData> >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateDataClusterMetadataActor, 1, Optional<TenantTombstoneCleanupData> >*,Optional<TenantTombstoneCleanupData> const& value) 
	{
		fdb_probe_actor_enter("updateDataClusterMetadata", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDataClusterMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDataClusterMetadata", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UpdateDataClusterMetadataActor, 1, Optional<TenantTombstoneCleanupData> >*,Optional<TenantTombstoneCleanupData> && value) 
	{
		fdb_probe_actor_enter("updateDataClusterMetadata", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDataClusterMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDataClusterMetadata", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UpdateDataClusterMetadataActor, 1, Optional<TenantTombstoneCleanupData> >*,Error err) 
	{
		fdb_probe_actor_enter("updateDataClusterMetadata", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDataClusterMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDataClusterMetadata", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 992 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	RestoreClusterImpl* self;
															#line 992 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	Reference<ITransaction> tr;
															#line 9298 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
};
// This generated class is to be used only via updateDataClusterMetadata()
															#line 992 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
class UpdateDataClusterMetadataActor final : public Actor<Void>, public ActorCallback< UpdateDataClusterMetadataActor, 0, Versionstamp >, public ActorCallback< UpdateDataClusterMetadataActor, 1, Optional<TenantTombstoneCleanupData> >, public FastAllocated<UpdateDataClusterMetadataActor>, public UpdateDataClusterMetadataActorState<UpdateDataClusterMetadataActor> {
															#line 9303 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
public:
	using FastAllocated<UpdateDataClusterMetadataActor>::operator new;
	using FastAllocated<UpdateDataClusterMetadataActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1827124857365853696UL, 4401283540347223296UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateDataClusterMetadataActor, 0, Versionstamp >;
friend struct ActorCallback< UpdateDataClusterMetadataActor, 1, Optional<TenantTombstoneCleanupData> >;
															#line 992 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	UpdateDataClusterMetadataActor(RestoreClusterImpl* const& self,Reference<ITransaction> const& tr) 
															#line 9321 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		 : Actor<Void>(),
		   UpdateDataClusterMetadataActorState<UpdateDataClusterMetadataActor>(self, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateDataClusterMetadata", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1356554398170150400UL, 7173545064001627904UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDataClusterMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateDataClusterMetadata");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateDataClusterMetadata", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateDataClusterMetadataActor, 0, Versionstamp >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UpdateDataClusterMetadataActor, 1, Optional<TenantTombstoneCleanupData> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 992 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
[[nodiscard]] static Future<Void> updateDataClusterMetadata( RestoreClusterImpl* const& self, Reference<ITransaction> const& tr ) {
															#line 992 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	return Future<Void>(new UpdateDataClusterMetadataActor(self, tr));
															#line 9354 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
}

#line 1021 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"

																#line 9359 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
// This generated class is to be used only via runDataClusterRestore()
															#line 1022 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
template <class RunDataClusterRestoreActor>
															#line 1022 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
class RunDataClusterRestoreActorState {
															#line 9365 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
public:
															#line 1022 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	RunDataClusterRestoreActorState(RestoreClusterImpl* const& self) 
															#line 1022 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
															#line 1022 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		 : self(self)
															#line 9372 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
	{
		fdb_probe_actor_create("runDataClusterRestore", reinterpret_cast<unsigned long>(this));

	}
	~RunDataClusterRestoreActorState() 
	{
		fdb_probe_actor_destroy("runDataClusterRestore", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1023 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			CODE_PROBE(self->restoreDryRun, "Data cluster restore dry-run");
															#line 1024 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			CODE_PROBE(self->forceJoin, "Data cluster restore force join");
															#line 1027 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			StrictFuture<Void> __when_expr_0 = self->ctx.runManagementTransaction([self = self](Reference<typename DB::TransactionT> tr) { return self->ctx.setCluster(tr, self->clusterName); });
															#line 1027 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9393 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state = 1;
															#line 1027 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunDataClusterRestoreActor, 0, Void >*>(static_cast<RunDataClusterRestoreActor*>(this)));
															#line 9398 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunDataClusterRestoreActorState();
		static_cast<RunDataClusterRestoreActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1033 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		StrictFuture<Void> __when_expr_1 = loadDataClusterRegistration(self);
															#line 1033 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9423 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state = 2;
															#line 1033 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunDataClusterRestoreActor, 1, Void >*>(static_cast<RunDataClusterRestoreActor*>(this)));
															#line 9428 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1033 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		StrictFuture<Void> __when_expr_1 = loadDataClusterRegistration(self);
															#line 1033 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9439 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state = 2;
															#line 1033 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunDataClusterRestoreActor, 1, Void >*>(static_cast<RunDataClusterRestoreActor*>(this)));
															#line 9444 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state > 0) static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state = 0;
		static_cast<RunDataClusterRestoreActor*>(this)->ActorCallback< RunDataClusterRestoreActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunDataClusterRestoreActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunDataClusterRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunDataClusterRestoreActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunDataClusterRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunDataClusterRestoreActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunDataClusterRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1036 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!self->restoreDryRun)
															#line 9528 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 1037 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			StrictFuture<Void> __when_expr_2 = store(self->restoreId, self->ctx.runManagementTransaction([self = self](Reference<typename DB::TransactionT> tr) { return markClusterRestoring(self, tr); }));
															#line 1037 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9534 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state = 3;
															#line 1037 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunDataClusterRestoreActor, 2, Void >*>(static_cast<RunDataClusterRestoreActor*>(this)));
															#line 9539 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1036 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!self->restoreDryRun)
															#line 9553 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 1037 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			StrictFuture<Void> __when_expr_2 = store(self->restoreId, self->ctx.runManagementTransaction([self = self](Reference<typename DB::TransactionT> tr) { return markClusterRestoring(self, tr); }));
															#line 1037 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9559 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state = 3;
															#line 1037 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunDataClusterRestoreActor, 2, Void >*>(static_cast<RunDataClusterRestoreActor*>(this)));
															#line 9564 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state > 0) static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state = 0;
		static_cast<RunDataClusterRestoreActor*>(this)->ActorCallback< RunDataClusterRestoreActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunDataClusterRestoreActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunDataClusterRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunDataClusterRestoreActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunDataClusterRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunDataClusterRestoreActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunDataClusterRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 1046 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!self->restoreDryRun)
															#line 9653 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 1047 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			StrictFuture<Void> __when_expr_4 = self->ctx.runDataClusterTransaction( [self = self](Reference<ITransaction> tr) { return updateDataClusterMetadata(self, tr); });
															#line 1047 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9659 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont3when1(__when_expr_4.get(), loopDepth); };
			static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state = 5;
															#line 1047 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RunDataClusterRestoreActor, 4, Void >*>(static_cast<RunDataClusterRestoreActor*>(this)));
															#line 9664 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 1042 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		StrictFuture<Void> __when_expr_3 = self->restoreId.onSet();
															#line 1042 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9680 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state = 4;
															#line 1042 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RunDataClusterRestoreActor, 3, Void >*>(static_cast<RunDataClusterRestoreActor*>(this)));
															#line 9685 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 1042 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		StrictFuture<Void> __when_expr_3 = self->restoreId.onSet();
															#line 1042 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9696 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state = 4;
															#line 1042 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RunDataClusterRestoreActor, 3, Void >*>(static_cast<RunDataClusterRestoreActor*>(this)));
															#line 9701 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state > 0) static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state = 0;
		static_cast<RunDataClusterRestoreActor*>(this)->ActorCallback< RunDataClusterRestoreActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunDataClusterRestoreActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunDataClusterRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RunDataClusterRestoreActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunDataClusterRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RunDataClusterRestoreActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunDataClusterRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state > 0) static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state = 0;
		static_cast<RunDataClusterRestoreActor*>(this)->ActorCallback< RunDataClusterRestoreActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunDataClusterRestoreActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunDataClusterRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RunDataClusterRestoreActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunDataClusterRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RunDataClusterRestoreActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunDataClusterRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont6(int loopDepth) 
	{
															#line 1052 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		StrictFuture<Void> __when_expr_5 = getAllTenantsFromManagementCluster(self);
															#line 1052 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9874 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state = 6;
															#line 1052 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< RunDataClusterRestoreActor, 5, Void >*>(static_cast<RunDataClusterRestoreActor*>(this)));
															#line 9879 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state > 0) static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state = 0;
		static_cast<RunDataClusterRestoreActor*>(this)->ActorCallback< RunDataClusterRestoreActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunDataClusterRestoreActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunDataClusterRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< RunDataClusterRestoreActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunDataClusterRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< RunDataClusterRestoreActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunDataClusterRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
															#line 1055 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		StrictFuture<Void> __when_expr_6 = self->runRestoreDataClusterTransaction( [self = self](Reference<ITransaction> tr) { return getTenantsFromDataCluster(self, tr); }, RunOnDisconnectedCluster::False, RunOnMismatchedCluster(self->restoreDryRun && self->forceJoin));
															#line 1055 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9977 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont8when1(__when_expr_6.get(), loopDepth); };
		static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state = 7;
															#line 1055 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< RunDataClusterRestoreActor, 6, Void >*>(static_cast<RunDataClusterRestoreActor*>(this)));
															#line 9982 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
															#line 1055 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		StrictFuture<Void> __when_expr_6 = self->runRestoreDataClusterTransaction( [self = self](Reference<ITransaction> tr) { return getTenantsFromDataCluster(self, tr); }, RunOnDisconnectedCluster::False, RunOnMismatchedCluster(self->restoreDryRun && self->forceJoin));
															#line 1055 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9993 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont8when1(__when_expr_6.get(), loopDepth); };
		static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state = 7;
															#line 1055 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< RunDataClusterRestoreActor, 6, Void >*>(static_cast<RunDataClusterRestoreActor*>(this)));
															#line 9998 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state > 0) static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state = 0;
		static_cast<RunDataClusterRestoreActor*>(this)->ActorCallback< RunDataClusterRestoreActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunDataClusterRestoreActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunDataClusterRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< RunDataClusterRestoreActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunDataClusterRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< RunDataClusterRestoreActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunDataClusterRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont9(Void const& _,int loopDepth) 
	{
															#line 1061 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		StrictFuture<Void> __when_expr_7 = reconcileTenants(self);
															#line 1061 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10084 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont9when1(__when_expr_7.get(), loopDepth); };
		static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state = 8;
															#line 1061 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< RunDataClusterRestoreActor, 7, Void >*>(static_cast<RunDataClusterRestoreActor*>(this)));
															#line 10089 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9(Void && _,int loopDepth) 
	{
															#line 1061 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		StrictFuture<Void> __when_expr_7 = reconcileTenants(self);
															#line 1061 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10100 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont9when1(__when_expr_7.get(), loopDepth); };
		static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state = 8;
															#line 1061 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< RunDataClusterRestoreActor, 7, Void >*>(static_cast<RunDataClusterRestoreActor*>(this)));
															#line 10105 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state > 0) static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state = 0;
		static_cast<RunDataClusterRestoreActor*>(this)->ActorCallback< RunDataClusterRestoreActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunDataClusterRestoreActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunDataClusterRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< RunDataClusterRestoreActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunDataClusterRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< RunDataClusterRestoreActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunDataClusterRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont10(Void const& _,int loopDepth) 
	{
															#line 1064 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		StrictFuture<Void> __when_expr_8 = processMissingTenants(self);
															#line 1064 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10191 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont10when1(__when_expr_8.get(), loopDepth); };
		static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state = 9;
															#line 1064 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< RunDataClusterRestoreActor, 8, Void >*>(static_cast<RunDataClusterRestoreActor*>(this)));
															#line 10196 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10(Void && _,int loopDepth) 
	{
															#line 1064 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		StrictFuture<Void> __when_expr_8 = processMissingTenants(self);
															#line 1064 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10207 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont10when1(__when_expr_8.get(), loopDepth); };
		static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state = 9;
															#line 1064 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< RunDataClusterRestoreActor, 8, Void >*>(static_cast<RunDataClusterRestoreActor*>(this)));
															#line 10212 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state > 0) static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state = 0;
		static_cast<RunDataClusterRestoreActor*>(this)->ActorCallback< RunDataClusterRestoreActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunDataClusterRestoreActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunDataClusterRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< RunDataClusterRestoreActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunDataClusterRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< RunDataClusterRestoreActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunDataClusterRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont10cont1(Void const& _,int loopDepth) 
	{
															#line 1066 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!self->restoreDryRun)
															#line 10296 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 1068 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			StrictFuture<Void> __when_expr_9 = self->ctx.runDataClusterTransaction( [self = self](Reference<ITransaction> tr) { return success(eraseRestoreId(self, tr)); });
															#line 1068 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10302 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont10cont1when1(__when_expr_9.get(), loopDepth); };
			static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state = 10;
															#line 1068 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< RunDataClusterRestoreActor, 9, Void >*>(static_cast<RunDataClusterRestoreActor*>(this)));
															#line 10307 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont10cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont1(Void && _,int loopDepth) 
	{
															#line 1066 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!self->restoreDryRun)
															#line 10321 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 1068 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			StrictFuture<Void> __when_expr_9 = self->ctx.runDataClusterTransaction( [self = self](Reference<ITransaction> tr) { return success(eraseRestoreId(self, tr)); });
															#line 1068 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10327 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont10cont1when1(__when_expr_9.get(), loopDepth); };
			static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state = 10;
															#line 1068 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< RunDataClusterRestoreActor, 9, Void >*>(static_cast<RunDataClusterRestoreActor*>(this)));
															#line 10332 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont10cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state > 0) static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state = 0;
		static_cast<RunDataClusterRestoreActor*>(this)->ActorCallback< RunDataClusterRestoreActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunDataClusterRestoreActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunDataClusterRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< RunDataClusterRestoreActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunDataClusterRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< RunDataClusterRestoreActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunDataClusterRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont10cont2(int loopDepth) 
	{
															#line 1079 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!static_cast<RunDataClusterRestoreActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunDataClusterRestoreActorState(); static_cast<RunDataClusterRestoreActor*>(this)->destroy(); return 0; }
															#line 10421 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		new (&static_cast<RunDataClusterRestoreActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunDataClusterRestoreActorState();
		static_cast<RunDataClusterRestoreActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10cont3(Void const& _,int loopDepth) 
	{
															#line 1072 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		StrictFuture<Void> __when_expr_10 = self->ctx.runManagementTransaction( [self = self](Reference<typename DB::TransactionT> tr) { return self->markClusterAsReady(tr); });
															#line 1072 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10435 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont10cont3when1(__when_expr_10.get(), loopDepth); };
		static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state = 11;
															#line 1072 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< RunDataClusterRestoreActor, 10, Void >*>(static_cast<RunDataClusterRestoreActor*>(this)));
															#line 10440 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont3(Void && _,int loopDepth) 
	{
															#line 1072 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		StrictFuture<Void> __when_expr_10 = self->ctx.runManagementTransaction( [self = self](Reference<typename DB::TransactionT> tr) { return self->markClusterAsReady(tr); });
															#line 1072 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10451 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont10cont3when1(__when_expr_10.get(), loopDepth); };
		static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state = 11;
															#line 1072 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< RunDataClusterRestoreActor, 10, Void >*>(static_cast<RunDataClusterRestoreActor*>(this)));
															#line 10456 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state > 0) static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state = 0;
		static_cast<RunDataClusterRestoreActor*>(this)->ActorCallback< RunDataClusterRestoreActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunDataClusterRestoreActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunDataClusterRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< RunDataClusterRestoreActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunDataClusterRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< RunDataClusterRestoreActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunDataClusterRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont10cont4(Void const& _,int loopDepth) 
	{
															#line 1074 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		TraceEvent("MetaclusterRepopulatedFromDataCluster") .detail("Name", self->clusterName) .detail("RestoreId", self->restoreId);
															#line 10540 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		loopDepth = a_body1cont10cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont4(Void && _,int loopDepth) 
	{
															#line 1074 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		TraceEvent("MetaclusterRepopulatedFromDataCluster") .detail("Name", self->clusterName) .detail("RestoreId", self->restoreId);
															#line 10549 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		loopDepth = a_body1cont10cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state > 0) static_cast<RunDataClusterRestoreActor*>(this)->actor_wait_state = 0;
		static_cast<RunDataClusterRestoreActor*>(this)->ActorCallback< RunDataClusterRestoreActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunDataClusterRestoreActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunDataClusterRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont10cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< RunDataClusterRestoreActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunDataClusterRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont10cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< RunDataClusterRestoreActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunDataClusterRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runDataClusterRestore", reinterpret_cast<unsigned long>(this), 10);

	}
															#line 1022 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	RestoreClusterImpl* self;
															#line 10631 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
};
// This generated class is to be used only via runDataClusterRestore()
															#line 1022 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
class RunDataClusterRestoreActor final : public Actor<Void>, public ActorCallback< RunDataClusterRestoreActor, 0, Void >, public ActorCallback< RunDataClusterRestoreActor, 1, Void >, public ActorCallback< RunDataClusterRestoreActor, 2, Void >, public ActorCallback< RunDataClusterRestoreActor, 3, Void >, public ActorCallback< RunDataClusterRestoreActor, 4, Void >, public ActorCallback< RunDataClusterRestoreActor, 5, Void >, public ActorCallback< RunDataClusterRestoreActor, 6, Void >, public ActorCallback< RunDataClusterRestoreActor, 7, Void >, public ActorCallback< RunDataClusterRestoreActor, 8, Void >, public ActorCallback< RunDataClusterRestoreActor, 9, Void >, public ActorCallback< RunDataClusterRestoreActor, 10, Void >, public FastAllocated<RunDataClusterRestoreActor>, public RunDataClusterRestoreActorState<RunDataClusterRestoreActor> {
															#line 10636 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
public:
	using FastAllocated<RunDataClusterRestoreActor>::operator new;
	using FastAllocated<RunDataClusterRestoreActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16282889737558613248UL, 15491799452931589632UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunDataClusterRestoreActor, 0, Void >;
friend struct ActorCallback< RunDataClusterRestoreActor, 1, Void >;
friend struct ActorCallback< RunDataClusterRestoreActor, 2, Void >;
friend struct ActorCallback< RunDataClusterRestoreActor, 3, Void >;
friend struct ActorCallback< RunDataClusterRestoreActor, 4, Void >;
friend struct ActorCallback< RunDataClusterRestoreActor, 5, Void >;
friend struct ActorCallback< RunDataClusterRestoreActor, 6, Void >;
friend struct ActorCallback< RunDataClusterRestoreActor, 7, Void >;
friend struct ActorCallback< RunDataClusterRestoreActor, 8, Void >;
friend struct ActorCallback< RunDataClusterRestoreActor, 9, Void >;
friend struct ActorCallback< RunDataClusterRestoreActor, 10, Void >;
															#line 1022 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	RunDataClusterRestoreActor(RestoreClusterImpl* const& self) 
															#line 10663 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		 : Actor<Void>(),
		   RunDataClusterRestoreActorState<RunDataClusterRestoreActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runDataClusterRestore", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4387060229633042688UL, 5756807945060508928UL);
		ActorExecutionContextHelper __helper(static_cast<RunDataClusterRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runDataClusterRestore");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runDataClusterRestore", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunDataClusterRestoreActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunDataClusterRestoreActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RunDataClusterRestoreActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RunDataClusterRestoreActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< RunDataClusterRestoreActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< RunDataClusterRestoreActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< RunDataClusterRestoreActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< RunDataClusterRestoreActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< RunDataClusterRestoreActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< RunDataClusterRestoreActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< RunDataClusterRestoreActor, 10, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1022 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
[[nodiscard]] static Future<Void> runDataClusterRestore( RestoreClusterImpl* const& self ) {
															#line 1022 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	return Future<Void>(new RunDataClusterRestoreActor(self));
															#line 10705 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
}

#line 1081 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"

																#line 10710 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
// This generated class is to be used only via runManagementClusterRepopulate()
															#line 1082 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
template <class RunManagementClusterRepopulateActor>
															#line 1082 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
class RunManagementClusterRepopulateActorState {
															#line 10716 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
public:
															#line 1082 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	RunManagementClusterRepopulateActorState(RestoreClusterImpl* const& self) 
															#line 1082 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
															#line 1082 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		 : self(self)
															#line 10723 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
	{
		fdb_probe_actor_create("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this));

	}
	~RunManagementClusterRepopulateActorState() 
	{
		fdb_probe_actor_destroy("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1083 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			CODE_PROBE(self->restoreDryRun, "Management cluster restore dry-run");
															#line 1084 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			CODE_PROBE(self->forceReuseTenantIdPrefix, "Management cluster restore force reuse tenant ID prefix");
															#line 1087 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			StrictFuture<metadata::RestoreId> __when_expr_0 = self->ctx.runManagementTransaction([self = self](Reference<typename DB::TransactionT> tr) { return registerRestoringClusterInManagementCluster(self, tr); });
															#line 1087 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (static_cast<RunManagementClusterRepopulateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10744 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RunManagementClusterRepopulateActor*>(this)->actor_wait_state = 1;
															#line 1087 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunManagementClusterRepopulateActor, 0, metadata::RestoreId >*>(static_cast<RunManagementClusterRepopulateActor*>(this)));
															#line 10749 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunManagementClusterRepopulateActorState();
		static_cast<RunManagementClusterRepopulateActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1092 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!self->restoreDryRun)
															#line 10772 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 1093 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			StrictFuture<Void> __when_expr_1 = restoreId.onSet();
															#line 1093 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (static_cast<RunManagementClusterRepopulateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10778 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<RunManagementClusterRepopulateActor*>(this)->actor_wait_state = 2;
															#line 1093 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunManagementClusterRepopulateActor, 1, Void >*>(static_cast<RunManagementClusterRepopulateActor*>(this)));
															#line 10783 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(metadata::RestoreId const& __restoreId,int loopDepth) 
	{
															#line 1087 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		restoreId = __restoreId;
															#line 10797 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(metadata::RestoreId && __restoreId,int loopDepth) 
	{
		restoreId = std::move(__restoreId);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunManagementClusterRepopulateActor*>(this)->actor_wait_state > 0) static_cast<RunManagementClusterRepopulateActor*>(this)->actor_wait_state = 0;
		static_cast<RunManagementClusterRepopulateActor*>(this)->ActorCallback< RunManagementClusterRepopulateActor, 0, metadata::RestoreId >::remove();

	}
	void a_callback_fire(ActorCallback< RunManagementClusterRepopulateActor, 0, metadata::RestoreId >*,metadata::RestoreId const& value) 
	{
		fdb_probe_actor_enter("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunManagementClusterRepopulateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunManagementClusterRepopulateActor, 0, metadata::RestoreId >*,metadata::RestoreId && value) 
	{
		fdb_probe_actor_enter("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunManagementClusterRepopulateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunManagementClusterRepopulateActor, 0, metadata::RestoreId >*,Error err) 
	{
		fdb_probe_actor_enter("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunManagementClusterRepopulateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1098 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		StrictFuture<Void> __when_expr_2 = writeDataClusterRegistration(self);
															#line 1098 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (static_cast<RunManagementClusterRepopulateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10878 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<RunManagementClusterRepopulateActor*>(this)->actor_wait_state = 3;
															#line 1098 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunManagementClusterRepopulateActor, 2, Void >*>(static_cast<RunManagementClusterRepopulateActor*>(this)));
															#line 10883 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 1094 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		self->restoreId = restoreId;
															#line 10892 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 1094 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		self->restoreId = restoreId;
															#line 10901 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunManagementClusterRepopulateActor*>(this)->actor_wait_state > 0) static_cast<RunManagementClusterRepopulateActor*>(this)->actor_wait_state = 0;
		static_cast<RunManagementClusterRepopulateActor*>(this)->ActorCallback< RunManagementClusterRepopulateActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunManagementClusterRepopulateActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunManagementClusterRepopulateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunManagementClusterRepopulateActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunManagementClusterRepopulateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunManagementClusterRepopulateActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunManagementClusterRepopulateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 1100 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!self->restoreDryRun)
															#line 10985 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 1101 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			StrictFuture<Void> __when_expr_3 = self->runRestoreManagementTransaction([self = self](Reference<typename DB::TransactionT> tr) { return self->ctx.setCluster(tr, self->clusterName); });
															#line 1101 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (static_cast<RunManagementClusterRepopulateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10991 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
			static_cast<RunManagementClusterRepopulateActor*>(this)->actor_wait_state = 4;
															#line 1101 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RunManagementClusterRepopulateActor, 3, Void >*>(static_cast<RunManagementClusterRepopulateActor*>(this)));
															#line 10996 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 1100 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!self->restoreDryRun)
															#line 11010 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 1101 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			StrictFuture<Void> __when_expr_3 = self->runRestoreManagementTransaction([self = self](Reference<typename DB::TransactionT> tr) { return self->ctx.setCluster(tr, self->clusterName); });
															#line 1101 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (static_cast<RunManagementClusterRepopulateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11016 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
			static_cast<RunManagementClusterRepopulateActor*>(this)->actor_wait_state = 4;
															#line 1101 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RunManagementClusterRepopulateActor, 3, Void >*>(static_cast<RunManagementClusterRepopulateActor*>(this)));
															#line 11021 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RunManagementClusterRepopulateActor*>(this)->actor_wait_state > 0) static_cast<RunManagementClusterRepopulateActor*>(this)->actor_wait_state = 0;
		static_cast<RunManagementClusterRepopulateActor*>(this)->ActorCallback< RunManagementClusterRepopulateActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunManagementClusterRepopulateActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunManagementClusterRepopulateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RunManagementClusterRepopulateActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunManagementClusterRepopulateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RunManagementClusterRepopulateActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunManagementClusterRepopulateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(int loopDepth) 
	{
															#line 1107 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		StrictFuture<Void> __when_expr_4 = getAllTenantsFromManagementCluster(self);
															#line 1107 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (static_cast<RunManagementClusterRepopulateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11112 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont6when1(__when_expr_4.get(), loopDepth); };
		static_cast<RunManagementClusterRepopulateActor*>(this)->actor_wait_state = 5;
															#line 1107 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RunManagementClusterRepopulateActor, 4, Void >*>(static_cast<RunManagementClusterRepopulateActor*>(this)));
															#line 11117 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RunManagementClusterRepopulateActor*>(this)->actor_wait_state > 0) static_cast<RunManagementClusterRepopulateActor*>(this)->actor_wait_state = 0;
		static_cast<RunManagementClusterRepopulateActor*>(this)->ActorCallback< RunManagementClusterRepopulateActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunManagementClusterRepopulateActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunManagementClusterRepopulateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RunManagementClusterRepopulateActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunManagementClusterRepopulateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RunManagementClusterRepopulateActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunManagementClusterRepopulateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
															#line 1109 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (self->restoreDryRun)
															#line 11213 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 1110 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			StrictFuture<Void> __when_expr_5 = store(self->ctx.dataClusterDb, util::openDatabase(self->connectionString));
															#line 1110 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (static_cast<RunManagementClusterRepopulateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11219 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont8when1(__when_expr_5.get(), loopDepth); };
			static_cast<RunManagementClusterRepopulateActor*>(this)->actor_wait_state = 6;
															#line 1110 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< RunManagementClusterRepopulateActor, 5, Void >*>(static_cast<RunManagementClusterRepopulateActor*>(this)));
															#line 11224 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont9(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
															#line 1109 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (self->restoreDryRun)
															#line 11238 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 1110 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			StrictFuture<Void> __when_expr_5 = store(self->ctx.dataClusterDb, util::openDatabase(self->connectionString));
															#line 1110 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (static_cast<RunManagementClusterRepopulateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11244 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont8when1(__when_expr_5.get(), loopDepth); };
			static_cast<RunManagementClusterRepopulateActor*>(this)->actor_wait_state = 6;
															#line 1110 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< RunManagementClusterRepopulateActor, 5, Void >*>(static_cast<RunManagementClusterRepopulateActor*>(this)));
															#line 11249 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont9(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<RunManagementClusterRepopulateActor*>(this)->actor_wait_state > 0) static_cast<RunManagementClusterRepopulateActor*>(this)->actor_wait_state = 0;
		static_cast<RunManagementClusterRepopulateActor*>(this)->ActorCallback< RunManagementClusterRepopulateActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunManagementClusterRepopulateActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunManagementClusterRepopulateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< RunManagementClusterRepopulateActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunManagementClusterRepopulateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< RunManagementClusterRepopulateActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunManagementClusterRepopulateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont9(int loopDepth) 
	{
															#line 1114 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		StrictFuture<Void> __when_expr_6 = self->runRestoreDataClusterTransaction( [self = self](Reference<ITransaction> tr) { return getTenantsFromDataCluster(self, tr); }, RunOnDisconnectedCluster(self->restoreDryRun));
															#line 1114 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (static_cast<RunManagementClusterRepopulateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11340 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont9when1(__when_expr_6.get(), loopDepth); };
		static_cast<RunManagementClusterRepopulateActor*>(this)->actor_wait_state = 7;
															#line 1114 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< RunManagementClusterRepopulateActor, 6, Void >*>(static_cast<RunManagementClusterRepopulateActor*>(this)));
															#line 11345 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont10(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<RunManagementClusterRepopulateActor*>(this)->actor_wait_state > 0) static_cast<RunManagementClusterRepopulateActor*>(this)->actor_wait_state = 0;
		static_cast<RunManagementClusterRepopulateActor*>(this)->ActorCallback< RunManagementClusterRepopulateActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunManagementClusterRepopulateActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunManagementClusterRepopulateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< RunManagementClusterRepopulateActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunManagementClusterRepopulateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< RunManagementClusterRepopulateActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunManagementClusterRepopulateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont11(Void const& _,int loopDepth) 
	{
															#line 1119 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		StrictFuture<Void> __when_expr_7 = addTenantsToManagementCluster(self);
															#line 1119 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (static_cast<RunManagementClusterRepopulateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11443 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont11when1(__when_expr_7.get(), loopDepth); };
		static_cast<RunManagementClusterRepopulateActor*>(this)->actor_wait_state = 8;
															#line 1119 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< RunManagementClusterRepopulateActor, 7, Void >*>(static_cast<RunManagementClusterRepopulateActor*>(this)));
															#line 11448 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11(Void && _,int loopDepth) 
	{
															#line 1119 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		StrictFuture<Void> __when_expr_7 = addTenantsToManagementCluster(self);
															#line 1119 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (static_cast<RunManagementClusterRepopulateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11459 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont11when1(__when_expr_7.get(), loopDepth); };
		static_cast<RunManagementClusterRepopulateActor*>(this)->actor_wait_state = 8;
															#line 1119 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< RunManagementClusterRepopulateActor, 7, Void >*>(static_cast<RunManagementClusterRepopulateActor*>(this)));
															#line 11464 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<RunManagementClusterRepopulateActor*>(this)->actor_wait_state > 0) static_cast<RunManagementClusterRepopulateActor*>(this)->actor_wait_state = 0;
		static_cast<RunManagementClusterRepopulateActor*>(this)->ActorCallback< RunManagementClusterRepopulateActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunManagementClusterRepopulateActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunManagementClusterRepopulateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< RunManagementClusterRepopulateActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunManagementClusterRepopulateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< RunManagementClusterRepopulateActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunManagementClusterRepopulateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont11cont1(Void const& _,int loopDepth) 
	{
															#line 1121 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!self->restoreDryRun)
															#line 11548 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 1123 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			StrictFuture<Void> __when_expr_8 = self->ctx.runDataClusterTransaction( [self = self](Reference<ITransaction> tr) { return finalizeDataClusterAfterRepopulate(self, tr); });
															#line 1123 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (static_cast<RunManagementClusterRepopulateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11554 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont11cont1when1(__when_expr_8.get(), loopDepth); };
			static_cast<RunManagementClusterRepopulateActor*>(this)->actor_wait_state = 9;
															#line 1123 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< RunManagementClusterRepopulateActor, 8, Void >*>(static_cast<RunManagementClusterRepopulateActor*>(this)));
															#line 11559 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont11cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont1(Void && _,int loopDepth) 
	{
															#line 1121 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!self->restoreDryRun)
															#line 11573 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		{
															#line 1123 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			StrictFuture<Void> __when_expr_8 = self->ctx.runDataClusterTransaction( [self = self](Reference<ITransaction> tr) { return finalizeDataClusterAfterRepopulate(self, tr); });
															#line 1123 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (static_cast<RunManagementClusterRepopulateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11579 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont11cont1when1(__when_expr_8.get(), loopDepth); };
			static_cast<RunManagementClusterRepopulateActor*>(this)->actor_wait_state = 9;
															#line 1123 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< RunManagementClusterRepopulateActor, 8, Void >*>(static_cast<RunManagementClusterRepopulateActor*>(this)));
															#line 11584 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont11cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<RunManagementClusterRepopulateActor*>(this)->actor_wait_state > 0) static_cast<RunManagementClusterRepopulateActor*>(this)->actor_wait_state = 0;
		static_cast<RunManagementClusterRepopulateActor*>(this)->ActorCallback< RunManagementClusterRepopulateActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunManagementClusterRepopulateActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunManagementClusterRepopulateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< RunManagementClusterRepopulateActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunManagementClusterRepopulateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< RunManagementClusterRepopulateActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunManagementClusterRepopulateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont11cont2(int loopDepth) 
	{
															#line 1132 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!static_cast<RunManagementClusterRepopulateActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunManagementClusterRepopulateActorState(); static_cast<RunManagementClusterRepopulateActor*>(this)->destroy(); return 0; }
															#line 11673 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		new (&static_cast<RunManagementClusterRepopulateActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunManagementClusterRepopulateActorState();
		static_cast<RunManagementClusterRepopulateActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont11cont3(Void const& _,int loopDepth) 
	{
															#line 1127 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		StrictFuture<Void> __when_expr_9 = self->ctx.runManagementTransaction( [self = self](Reference<typename DB::TransactionT> tr) { return self->markClusterAsReady(tr); });
															#line 1127 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (static_cast<RunManagementClusterRepopulateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11687 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont11cont3when1(__when_expr_9.get(), loopDepth); };
		static_cast<RunManagementClusterRepopulateActor*>(this)->actor_wait_state = 10;
															#line 1127 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< RunManagementClusterRepopulateActor, 9, Void >*>(static_cast<RunManagementClusterRepopulateActor*>(this)));
															#line 11692 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont3(Void && _,int loopDepth) 
	{
															#line 1127 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		StrictFuture<Void> __when_expr_9 = self->ctx.runManagementTransaction( [self = self](Reference<typename DB::TransactionT> tr) { return self->markClusterAsReady(tr); });
															#line 1127 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (static_cast<RunManagementClusterRepopulateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11703 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont11cont3when1(__when_expr_9.get(), loopDepth); };
		static_cast<RunManagementClusterRepopulateActor*>(this)->actor_wait_state = 10;
															#line 1127 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< RunManagementClusterRepopulateActor, 9, Void >*>(static_cast<RunManagementClusterRepopulateActor*>(this)));
															#line 11708 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<RunManagementClusterRepopulateActor*>(this)->actor_wait_state > 0) static_cast<RunManagementClusterRepopulateActor*>(this)->actor_wait_state = 0;
		static_cast<RunManagementClusterRepopulateActor*>(this)->ActorCallback< RunManagementClusterRepopulateActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunManagementClusterRepopulateActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunManagementClusterRepopulateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont11cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< RunManagementClusterRepopulateActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunManagementClusterRepopulateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont11cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< RunManagementClusterRepopulateActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunManagementClusterRepopulateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont11cont4(Void const& _,int loopDepth) 
	{
															#line 1129 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		TraceEvent("DataClusterRestoredToMetacluster").detail("Name", self->clusterName);
															#line 11792 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		loopDepth = a_body1cont11cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont4(Void && _,int loopDepth) 
	{
															#line 1129 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		TraceEvent("DataClusterRestoredToMetacluster").detail("Name", self->clusterName);
															#line 11801 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		loopDepth = a_body1cont11cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<RunManagementClusterRepopulateActor*>(this)->actor_wait_state > 0) static_cast<RunManagementClusterRepopulateActor*>(this)->actor_wait_state = 0;
		static_cast<RunManagementClusterRepopulateActor*>(this)->ActorCallback< RunManagementClusterRepopulateActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunManagementClusterRepopulateActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunManagementClusterRepopulateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont11cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< RunManagementClusterRepopulateActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunManagementClusterRepopulateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont11cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< RunManagementClusterRepopulateActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunManagementClusterRepopulateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), 9);

	}
															#line 1082 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	RestoreClusterImpl* self;
															#line 1087 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	metadata::RestoreId restoreId;
															#line 11885 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
};
// This generated class is to be used only via runManagementClusterRepopulate()
															#line 1082 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
class RunManagementClusterRepopulateActor final : public Actor<Void>, public ActorCallback< RunManagementClusterRepopulateActor, 0, metadata::RestoreId >, public ActorCallback< RunManagementClusterRepopulateActor, 1, Void >, public ActorCallback< RunManagementClusterRepopulateActor, 2, Void >, public ActorCallback< RunManagementClusterRepopulateActor, 3, Void >, public ActorCallback< RunManagementClusterRepopulateActor, 4, Void >, public ActorCallback< RunManagementClusterRepopulateActor, 5, Void >, public ActorCallback< RunManagementClusterRepopulateActor, 6, Void >, public ActorCallback< RunManagementClusterRepopulateActor, 7, Void >, public ActorCallback< RunManagementClusterRepopulateActor, 8, Void >, public ActorCallback< RunManagementClusterRepopulateActor, 9, Void >, public FastAllocated<RunManagementClusterRepopulateActor>, public RunManagementClusterRepopulateActorState<RunManagementClusterRepopulateActor> {
															#line 11890 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
public:
	using FastAllocated<RunManagementClusterRepopulateActor>::operator new;
	using FastAllocated<RunManagementClusterRepopulateActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6603381107070061312UL, 16691886447787350016UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunManagementClusterRepopulateActor, 0, metadata::RestoreId >;
friend struct ActorCallback< RunManagementClusterRepopulateActor, 1, Void >;
friend struct ActorCallback< RunManagementClusterRepopulateActor, 2, Void >;
friend struct ActorCallback< RunManagementClusterRepopulateActor, 3, Void >;
friend struct ActorCallback< RunManagementClusterRepopulateActor, 4, Void >;
friend struct ActorCallback< RunManagementClusterRepopulateActor, 5, Void >;
friend struct ActorCallback< RunManagementClusterRepopulateActor, 6, Void >;
friend struct ActorCallback< RunManagementClusterRepopulateActor, 7, Void >;
friend struct ActorCallback< RunManagementClusterRepopulateActor, 8, Void >;
friend struct ActorCallback< RunManagementClusterRepopulateActor, 9, Void >;
															#line 1082 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	RunManagementClusterRepopulateActor(RestoreClusterImpl* const& self) 
															#line 11916 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		 : Actor<Void>(),
		   RunManagementClusterRepopulateActorState<RunManagementClusterRepopulateActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5697716666089969152UL, 15720744748161203712UL);
		ActorExecutionContextHelper __helper(static_cast<RunManagementClusterRepopulateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runManagementClusterRepopulate");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runManagementClusterRepopulate", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunManagementClusterRepopulateActor, 0, metadata::RestoreId >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunManagementClusterRepopulateActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RunManagementClusterRepopulateActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RunManagementClusterRepopulateActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< RunManagementClusterRepopulateActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< RunManagementClusterRepopulateActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< RunManagementClusterRepopulateActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< RunManagementClusterRepopulateActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< RunManagementClusterRepopulateActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< RunManagementClusterRepopulateActor, 9, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1082 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
[[nodiscard]] static Future<Void> runManagementClusterRepopulate( RestoreClusterImpl* const& self ) {
															#line 1082 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	return Future<Void>(new RunManagementClusterRepopulateActor(self));
															#line 11957 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
}

#line 1134 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"

	Future<Void> run() {
		if (applyManagementClusterUpdates) {
			return runDataClusterRestore(this);
		} else {
			return runManagementClusterRepopulate(this);
		}
	}
};
} // namespace internal

															#line 11972 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
// This generated class is to be used only via restoreCluster()
															#line 1145 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
template <class DB, class RestoreClusterActor>
															#line 1145 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
class RestoreClusterActorState {
															#line 11978 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
public:
															#line 1145 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	RestoreClusterActorState(Reference<DB> const& db,ClusterName const& name,ClusterConnectionString const& connectionString,ApplyManagementClusterUpdates const& applyManagementClusterUpdates,RestoreDryRun const& restoreDryRun,ForceJoin const& forceJoin,ForceReuseTenantIdPrefix const& forceReuseTenantIdPrefix,std::vector<std::string>* const& messages) 
															#line 1145 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
															#line 1145 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		 : db(db),
															#line 1145 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		   name(name),
															#line 1145 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		   connectionString(connectionString),
															#line 1145 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		   applyManagementClusterUpdates(applyManagementClusterUpdates),
															#line 1145 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		   restoreDryRun(restoreDryRun),
															#line 1145 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		   forceJoin(forceJoin),
															#line 1145 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		   forceReuseTenantIdPrefix(forceReuseTenantIdPrefix),
															#line 1145 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		   messages(messages),
															#line 1154 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		   impl(db, name, connectionString, applyManagementClusterUpdates, restoreDryRun, forceJoin, forceReuseTenantIdPrefix, *messages)
															#line 12001 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
	{
		fdb_probe_actor_create("restoreCluster", reinterpret_cast<unsigned long>(this));

	}
	~RestoreClusterActorState() 
	{
		fdb_probe_actor_destroy("restoreCluster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1162 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			StrictFuture<Void> __when_expr_0 = impl.run();
															#line 1162 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			if (static_cast<RestoreClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12018 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RestoreClusterActor*>(this)->actor_wait_state = 1;
															#line 1162 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RestoreClusterActor, 0, Void >*>(static_cast<RestoreClusterActor*>(this)));
															#line 12023 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RestoreClusterActorState();
		static_cast<RestoreClusterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1163 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!static_cast<RestoreClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RestoreClusterActorState(); static_cast<RestoreClusterActor*>(this)->destroy(); return 0; }
															#line 12046 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		new (&static_cast<RestoreClusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RestoreClusterActorState();
		static_cast<RestoreClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1163 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
		if (!static_cast<RestoreClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RestoreClusterActorState(); static_cast<RestoreClusterActor*>(this)->destroy(); return 0; }
															#line 12058 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		new (&static_cast<RestoreClusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RestoreClusterActorState();
		static_cast<RestoreClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RestoreClusterActor*>(this)->actor_wait_state > 0) static_cast<RestoreClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreClusterActor*>(this)->ActorCallback< RestoreClusterActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RestoreClusterActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("restoreCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RestoreClusterActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("restoreCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RestoreClusterActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("restoreCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreCluster", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1145 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	Reference<DB> db;
															#line 1145 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	ClusterName name;
															#line 1145 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	ClusterConnectionString connectionString;
															#line 1145 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	ApplyManagementClusterUpdates applyManagementClusterUpdates;
															#line 1145 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	RestoreDryRun restoreDryRun;
															#line 1145 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	ForceJoin forceJoin;
															#line 1145 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	ForceReuseTenantIdPrefix forceReuseTenantIdPrefix;
															#line 1145 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	std::vector<std::string>* messages;
															#line 1154 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	internal::RestoreClusterImpl<DB> impl;
															#line 12159 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
};
// This generated class is to be used only via restoreCluster()
															#line 1145 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
template <class DB>
															#line 1145 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
class RestoreClusterActor final : public Actor<Void>, public ActorCallback< RestoreClusterActor<DB>, 0, Void >, public FastAllocated<RestoreClusterActor<DB>>, public RestoreClusterActorState<DB, RestoreClusterActor<DB>> {
															#line 12166 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
public:
	using FastAllocated<RestoreClusterActor<DB>>::operator new;
	using FastAllocated<RestoreClusterActor<DB>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(496012675486918656UL, 14067587719926120448UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RestoreClusterActor<DB>, 0, Void >;
															#line 1145 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	RestoreClusterActor(Reference<DB> const& db,ClusterName const& name,ClusterConnectionString const& connectionString,ApplyManagementClusterUpdates const& applyManagementClusterUpdates,RestoreDryRun const& restoreDryRun,ForceJoin const& forceJoin,ForceReuseTenantIdPrefix const& forceReuseTenantIdPrefix,std::vector<std::string>* const& messages) 
															#line 12183 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
		 : Actor<Void>(),
		   RestoreClusterActorState<DB, RestoreClusterActor<DB>>(db, name, connectionString, applyManagementClusterUpdates, restoreDryRun, forceJoin, forceReuseTenantIdPrefix, messages),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("restoreCluster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12143823830767418880UL, 265345168070311680UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("restoreCluster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("restoreCluster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RestoreClusterActor<DB>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1145 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
template <class DB>
															#line 1145 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
[[nodiscard]] Future<Void> restoreCluster( Reference<DB> const& db, ClusterName const& name, ClusterConnectionString const& connectionString, ApplyManagementClusterUpdates const& applyManagementClusterUpdates, RestoreDryRun const& restoreDryRun, ForceJoin const& forceJoin, ForceReuseTenantIdPrefix const& forceReuseTenantIdPrefix, std::vector<std::string>* const& messages ) {
															#line 1145 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"
	return Future<Void>(new RestoreClusterActor<DB>(db, name, connectionString, applyManagementClusterUpdates, restoreDryRun, forceJoin, forceReuseTenantIdPrefix, messages));
															#line 12217 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RestoreCluster.actor.g.h"
}

#line 1165 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/metacluster/include/metacluster/RestoreCluster.actor.h"

} // namespace metacluster

#include "flow/unactorcompiler.h"
#endif
