#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
/*
 * Sideband.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct SidebandMessage {
	constexpr static FileIdentifier file_identifier = 11862046;
	uint64_t key;
	Version commitVersion;

	SidebandMessage() {}
	SidebandMessage(uint64_t key, Version commitVersion) : key(key), commitVersion(commitVersion) {}

	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, key, commitVersion);
	}
};

struct SidebandInterface {
	constexpr static FileIdentifier file_identifier = 15950544;
	RequestStream<SidebandMessage> updates;

	UID id() const { return updates.getEndpoint().token; }

	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, updates);
	}
};

struct SidebandWorkload : TestWorkload {
	static constexpr auto NAME = "Sideband";

	double testDuration, operationsPerSecond;
	SidebandInterface interf;

	std::vector<Future<Void>> clients;
	PerfIntCounter messages, consistencyErrors, keysUnexpectedlyPresent;

	SidebandWorkload(WorkloadContext const& wcx)
	  : TestWorkload(wcx), messages("Messages"), consistencyErrors("Causal Consistency Errors"),
	    keysUnexpectedlyPresent("KeysUnexpectedlyPresent") {
		testDuration = getOption(options, "testDuration"_sr, 10.0);
		operationsPerSecond = getOption(options, "operationsPerSecond"_sr, 50.0);
	}

	Future<Void> setup(Database const& cx) override { return persistInterface(this, cx->clone()); }
	Future<Void> start(Database const& cx) override {
		clients.push_back(mutator(this, cx->clone()));
		clients.push_back(checker(this, cx->clone()));
		return delay(testDuration);
	}
	Future<bool> check(Database const& cx) override {
		int errors = 0;
		for (int c = 0; c < clients.size(); c++)
			errors += clients[c].isError();
		if (errors)
			TraceEvent(SevError, "TestFailure").detail("Reason", "There were client errors.");
		clients.clear();
		if (consistencyErrors.getValue())
			TraceEvent(SevError, "TestFailure").detail("Reason", "There were causal consistency errors.");
		return !errors && !consistencyErrors.getValue();
	}

	void getMetrics(std::vector<PerfMetric>& m) override {
		m.push_back(messages.getMetric());
		m.push_back(consistencyErrors.getMetric());
		m.push_back(keysUnexpectedlyPresent.getMetric());
	}

																#line 94 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
// This generated class is to be used only via persistInterface()
															#line 92 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
template <class PersistInterfaceActor>
															#line 92 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
class PersistInterfaceActorState {
															#line 100 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
public:
															#line 92 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
	PersistInterfaceActorState(SidebandWorkload* const& self,Database const& cx) 
															#line 92 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
															#line 92 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		 : self(self),
															#line 92 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		   cx(cx),
															#line 93 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		   tr(cx)
															#line 111 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
	{
		fdb_probe_actor_create("persistInterface", reinterpret_cast<unsigned long>(this));

	}
	~PersistInterfaceActorState() 
	{
		fdb_probe_actor_destroy("persistInterface", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 94 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
			BinaryWriter wr(IncludeVersion());
															#line 95 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
			wr << self->interf;
															#line 96 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
			serializedInterface = wr.toValue();
															#line 97 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
			;
															#line 132 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PersistInterfaceActorState();
		static_cast<PersistInterfaceActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 112 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		TraceEvent("SidebandPersisted", self->interf.id()).detail("ClientIdx", self->clientId);
															#line 113 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		if (!static_cast<PersistInterfaceActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PersistInterfaceActorState(); static_cast<PersistInterfaceActor*>(this)->destroy(); return 0; }
															#line 157 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
		new (&static_cast<PersistInterfaceActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PersistInterfaceActorState();
		static_cast<PersistInterfaceActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 99 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(StringRef(format("Sideband/Client/%d", self->clientId)));
															#line 99 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
			if (static_cast<PersistInterfaceActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 179 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PersistInterfaceActor*>(this)->actor_wait_state = 1;
															#line 99 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PersistInterfaceActor, 0, Optional<Value> >*>(static_cast<PersistInterfaceActor*>(this)));
															#line 184 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 109 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 109 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
			if (static_cast<PersistInterfaceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 221 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<PersistInterfaceActor*>(this)->actor_wait_state = 3;
															#line 109 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PersistInterfaceActor, 2, Void >*>(static_cast<PersistInterfaceActor*>(this)));
															#line 226 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& val,int loopDepth) 
	{
															#line 100 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		if (val.present())
															#line 241 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
		{
															#line 101 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
			if (val.get() != serializedInterface)
															#line 245 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
			{
															#line 102 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
				return a_body1loopBody1Catch1(operation_failed(), loopDepth);
															#line 249 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
			}
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 105 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		tr.set(format("Sideband/Client/%d", self->clientId), serializedInterface);
															#line 106 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 106 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		if (static_cast<PersistInterfaceActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 259 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<PersistInterfaceActor*>(this)->actor_wait_state = 2;
															#line 106 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PersistInterfaceActor, 1, Void >*>(static_cast<PersistInterfaceActor*>(this)));
															#line 264 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && val,int loopDepth) 
	{
															#line 100 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		if (val.present())
															#line 273 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
		{
															#line 101 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
			if (val.get() != serializedInterface)
															#line 277 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
			{
															#line 102 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
				return a_body1loopBody1Catch1(operation_failed(), loopDepth);
															#line 281 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
			}
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 105 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		tr.set(format("Sideband/Client/%d", self->clientId), serializedInterface);
															#line 106 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 106 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		if (static_cast<PersistInterfaceActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 291 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<PersistInterfaceActor*>(this)->actor_wait_state = 2;
															#line 106 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PersistInterfaceActor, 1, Void >*>(static_cast<PersistInterfaceActor*>(this)));
															#line 296 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(val, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PersistInterfaceActor*>(this)->actor_wait_state > 0) static_cast<PersistInterfaceActor*>(this)->actor_wait_state = 0;
		static_cast<PersistInterfaceActor*>(this)->ActorCallback< PersistInterfaceActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< PersistInterfaceActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("persistInterface", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistInterface", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PersistInterfaceActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("persistInterface", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistInterface", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PersistInterfaceActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("persistInterface", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PersistInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistInterface", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PersistInterfaceActor*>(this)->actor_wait_state > 0) static_cast<PersistInterfaceActor*>(this)->actor_wait_state = 0;
		static_cast<PersistInterfaceActor*>(this)->ActorCallback< PersistInterfaceActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PersistInterfaceActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("persistInterface", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistInterface", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PersistInterfaceActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("persistInterface", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistInterface", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PersistInterfaceActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("persistInterface", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PersistInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistInterface", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<PersistInterfaceActor*>(this)->actor_wait_state > 0) static_cast<PersistInterfaceActor*>(this)->actor_wait_state = 0;
		static_cast<PersistInterfaceActor*>(this)->ActorCallback< PersistInterfaceActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PersistInterfaceActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("persistInterface", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistInterface", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< PersistInterfaceActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("persistInterface", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistInterface", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< PersistInterfaceActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("persistInterface", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PersistInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistInterface", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 92 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
	SidebandWorkload* self;
															#line 92 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
	Database cx;
															#line 93 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
	Transaction tr;
															#line 96 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
	Standalone<StringRef> serializedInterface;
															#line 558 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
};
// This generated class is to be used only via persistInterface()
															#line 92 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
class PersistInterfaceActor final : public Actor<Void>, public ActorCallback< PersistInterfaceActor, 0, Optional<Value> >, public ActorCallback< PersistInterfaceActor, 1, Void >, public ActorCallback< PersistInterfaceActor, 2, Void >, public FastAllocated<PersistInterfaceActor>, public PersistInterfaceActorState<PersistInterfaceActor> {
															#line 563 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
public:
	using FastAllocated<PersistInterfaceActor>::operator new;
	using FastAllocated<PersistInterfaceActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10308428914070401536UL, 11028811500322516480UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PersistInterfaceActor, 0, Optional<Value> >;
friend struct ActorCallback< PersistInterfaceActor, 1, Void >;
friend struct ActorCallback< PersistInterfaceActor, 2, Void >;
															#line 92 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
	PersistInterfaceActor(SidebandWorkload* const& self,Database const& cx) 
															#line 582 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
		 : Actor<Void>(),
		   PersistInterfaceActorState<PersistInterfaceActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("persistInterface", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(399411798609655552UL, 427757437812594432UL);
		ActorExecutionContextHelper __helper(static_cast<PersistInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("persistInterface");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("persistInterface", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PersistInterfaceActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PersistInterfaceActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< PersistInterfaceActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 92 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
[[nodiscard]] Future<Void> persistInterface( SidebandWorkload* const& self, Database const& cx ) {
															#line 92 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
	return Future<Void>(new PersistInterfaceActor(self, cx));
															#line 616 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
}

#line 115 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"

																#line 621 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
// This generated class is to be used only via fetchSideband()
															#line 116 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
template <class FetchSidebandActor>
															#line 116 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
class FetchSidebandActorState {
															#line 627 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
public:
															#line 116 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
	FetchSidebandActorState(SidebandWorkload* const& self,Database const& cx) 
															#line 116 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
															#line 116 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		 : self(self),
															#line 116 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		   cx(cx),
															#line 117 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		   tr(cx)
															#line 638 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
	{
		fdb_probe_actor_create("fetchSideband", reinterpret_cast<unsigned long>(this));

	}
	~FetchSidebandActorState() 
	{
		fdb_probe_actor_destroy("fetchSideband", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 118 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
			;
															#line 653 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FetchSidebandActorState();
		static_cast<FetchSidebandActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 120 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(StringRef(format("Sideband/Client/%d", (self->clientId + 1) % self->clientCount)));
															#line 120 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
			if (static_cast<FetchSidebandActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 686 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FetchSidebandActor*>(this)->actor_wait_state = 1;
															#line 120 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FetchSidebandActor, 0, Optional<Value> >*>(static_cast<FetchSidebandActor*>(this)));
															#line 691 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 131 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 131 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
			if (static_cast<FetchSidebandActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 715 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<FetchSidebandActor*>(this)->actor_wait_state = 2;
															#line 131 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FetchSidebandActor, 1, Void >*>(static_cast<FetchSidebandActor*>(this)));
															#line 720 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& val,int loopDepth) 
	{
															#line 122 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		if (!val.present())
															#line 735 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
		{
															#line 123 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
			return a_body1loopBody1Catch1(operation_failed(), loopDepth);
															#line 739 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
		}
															#line 125 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		SidebandInterface sideband;
															#line 126 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		BinaryReader br(val.get(), IncludeVersion());
															#line 127 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		br >> sideband;
															#line 128 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		TraceEvent("SidebandFetched", sideband.id()).detail("ClientIdx", self->clientId);
															#line 129 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		if (!static_cast<FetchSidebandActor*>(this)->SAV<SidebandInterface>::futures) { (void)(sideband); this->~FetchSidebandActorState(); static_cast<FetchSidebandActor*>(this)->destroy(); return 0; }
															#line 751 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
		new (&static_cast<FetchSidebandActor*>(this)->SAV< SidebandInterface >::value()) SidebandInterface(sideband);
		this->~FetchSidebandActorState();
		static_cast<FetchSidebandActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && val,int loopDepth) 
	{
															#line 122 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		if (!val.present())
															#line 763 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
		{
															#line 123 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
			return a_body1loopBody1Catch1(operation_failed(), loopDepth);
															#line 767 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
		}
															#line 125 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		SidebandInterface sideband;
															#line 126 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		BinaryReader br(val.get(), IncludeVersion());
															#line 127 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		br >> sideband;
															#line 128 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		TraceEvent("SidebandFetched", sideband.id()).detail("ClientIdx", self->clientId);
															#line 129 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		if (!static_cast<FetchSidebandActor*>(this)->SAV<SidebandInterface>::futures) { (void)(sideband); this->~FetchSidebandActorState(); static_cast<FetchSidebandActor*>(this)->destroy(); return 0; }
															#line 779 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
		new (&static_cast<FetchSidebandActor*>(this)->SAV< SidebandInterface >::value()) SidebandInterface(sideband);
		this->~FetchSidebandActorState();
		static_cast<FetchSidebandActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(val, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FetchSidebandActor*>(this)->actor_wait_state > 0) static_cast<FetchSidebandActor*>(this)->actor_wait_state = 0;
		static_cast<FetchSidebandActor*>(this)->ActorCallback< FetchSidebandActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< FetchSidebandActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("fetchSideband", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchSidebandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchSideband", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FetchSidebandActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("fetchSideband", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchSidebandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchSideband", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FetchSidebandActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("fetchSideband", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchSidebandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchSideband", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FetchSidebandActor*>(this)->actor_wait_state > 0) static_cast<FetchSidebandActor*>(this)->actor_wait_state = 0;
		static_cast<FetchSidebandActor*>(this)->ActorCallback< FetchSidebandActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FetchSidebandActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchSideband", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchSidebandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchSideband", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FetchSidebandActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchSideband", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchSidebandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchSideband", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FetchSidebandActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchSideband", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchSidebandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchSideband", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 116 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
	SidebandWorkload* self;
															#line 116 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
	Database cx;
															#line 117 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
	Transaction tr;
															#line 955 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
};
// This generated class is to be used only via fetchSideband()
															#line 116 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
class FetchSidebandActor final : public Actor<SidebandInterface>, public ActorCallback< FetchSidebandActor, 0, Optional<Value> >, public ActorCallback< FetchSidebandActor, 1, Void >, public FastAllocated<FetchSidebandActor>, public FetchSidebandActorState<FetchSidebandActor> {
															#line 960 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
public:
	using FastAllocated<FetchSidebandActor>::operator new;
	using FastAllocated<FetchSidebandActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17694019219252025344UL, 3109575905474532352UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<SidebandInterface>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FetchSidebandActor, 0, Optional<Value> >;
friend struct ActorCallback< FetchSidebandActor, 1, Void >;
															#line 116 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
	FetchSidebandActor(SidebandWorkload* const& self,Database const& cx) 
															#line 978 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
		 : Actor<SidebandInterface>(),
		   FetchSidebandActorState<FetchSidebandActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fetchSideband", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5468858920144089344UL, 11408048005881081088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchSidebandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fetchSideband");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fetchSideband", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FetchSidebandActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FetchSidebandActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 116 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
[[nodiscard]] Future<SidebandInterface> fetchSideband( SidebandWorkload* const& self, Database const& cx ) {
															#line 116 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
	return Future<SidebandInterface>(new FetchSidebandActor(self, cx));
															#line 1011 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
}

#line 135 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"

																#line 1016 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
// This generated class is to be used only via mutator()
															#line 136 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
template <class MutatorActor>
															#line 136 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
class MutatorActorState {
															#line 1022 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
public:
															#line 136 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
	MutatorActorState(SidebandWorkload* const& self,Database const& cx) 
															#line 136 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
															#line 136 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		 : self(self),
															#line 136 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		   cx(cx)
															#line 1031 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
	{
		fdb_probe_actor_create("mutator", reinterpret_cast<unsigned long>(this));

	}
	~MutatorActorState() 
	{
		fdb_probe_actor_destroy("mutator", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 137 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
			StrictFuture<SidebandInterface> __when_expr_0 = self->fetchSideband(self, cx->clone());
															#line 137 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
			if (static_cast<MutatorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1048 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MutatorActor*>(this)->actor_wait_state = 1;
															#line 137 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MutatorActor, 0, SidebandInterface >*>(static_cast<MutatorActor*>(this)));
															#line 1053 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MutatorActorState();
		static_cast<MutatorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 138 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		lastTime = now();
															#line 139 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		commitVersion = Version();
															#line 141 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		;
															#line 1080 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(SidebandInterface const& __checker,int loopDepth) 
	{
															#line 137 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		checker = __checker;
															#line 1089 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(SidebandInterface && __checker,int loopDepth) 
	{
		checker = std::move(__checker);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MutatorActor*>(this)->actor_wait_state > 0) static_cast<MutatorActor*>(this)->actor_wait_state = 0;
		static_cast<MutatorActor*>(this)->ActorCallback< MutatorActor, 0, SidebandInterface >::remove();

	}
	void a_callback_fire(ActorCallback< MutatorActor, 0, SidebandInterface >*,SidebandInterface const& value) 
	{
		fdb_probe_actor_enter("mutator", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MutatorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mutator", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MutatorActor, 0, SidebandInterface >*,SidebandInterface && value) 
	{
		fdb_probe_actor_enter("mutator", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MutatorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mutator", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MutatorActor, 0, SidebandInterface >*,Error err) 
	{
		fdb_probe_actor_enter("mutator", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MutatorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mutator", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 142 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		StrictFuture<Void> __when_expr_1 = poisson(&lastTime, 1.0 / self->operationsPerSecond);
															#line 142 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		if (static_cast<MutatorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1177 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<MutatorActor*>(this)->actor_wait_state = 2;
															#line 142 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MutatorActor, 1, Void >*>(static_cast<MutatorActor*>(this)));
															#line 1182 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 143 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		tr = Transaction(cx);
															#line 144 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		key = deterministicRandom()->randomUniqueID().hash();
															#line 146 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		messageKey = Standalone<StringRef>(format("Sideband/Message/%llx", key));
															#line 147 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		;
															#line 1197 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 143 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		tr = Transaction(cx);
															#line 144 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		key = deterministicRandom()->randomUniqueID().hash();
															#line 146 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		messageKey = Standalone<StringRef>(format("Sideband/Message/%llx", key));
															#line 147 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		;
															#line 1212 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MutatorActor*>(this)->actor_wait_state > 0) static_cast<MutatorActor*>(this)->actor_wait_state = 0;
		static_cast<MutatorActor*>(this)->ActorCallback< MutatorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MutatorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("mutator", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MutatorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mutator", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MutatorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("mutator", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MutatorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mutator", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MutatorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("mutator", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MutatorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mutator", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont2(int loopDepth) 
	{
															#line 163 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		++self->messages;
															#line 164 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		checker.updates.send(SidebandMessage(key, commitVersion));
															#line 1298 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 149 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_2 = tr.get(messageKey);
															#line 149 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
			if (static_cast<MutatorActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1317 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont1loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<MutatorActor*>(this)->actor_wait_state = 3;
															#line 149 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MutatorActor, 2, Optional<Value> >*>(static_cast<MutatorActor*>(this)));
															#line 1322 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 160 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
			StrictFuture<Void> __when_expr_4 = tr.onError(e);
															#line 160 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
			if (static_cast<MutatorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1359 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1cont1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<MutatorActor*>(this)->actor_wait_state = 5;
															#line 160 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< MutatorActor, 4, Void >*>(static_cast<MutatorActor*>(this)));
															#line 1364 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1cont2(Optional<Value> const& val,int loopDepth) 
	{
															#line 150 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		if (val.present())
															#line 1379 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
		{
															#line 151 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
			commitVersion = tr.getReadVersion().get();
															#line 152 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
			++self->keysUnexpectedlyPresent;
															#line 1385 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
			return a_body1cont1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 155 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		tr.set(messageKey, "deadbeef"_sr);
															#line 156 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		StrictFuture<Void> __when_expr_3 = tr.commit();
															#line 156 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		if (static_cast<MutatorActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1394 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1cont1loopBody1cont2when1(__when_expr_3.get(), loopDepth); };
		static_cast<MutatorActor*>(this)->actor_wait_state = 4;
															#line 156 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MutatorActor, 3, Void >*>(static_cast<MutatorActor*>(this)));
															#line 1399 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1cont2(Optional<Value> && val,int loopDepth) 
	{
															#line 150 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		if (val.present())
															#line 1408 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
		{
															#line 151 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
			commitVersion = tr.getReadVersion().get();
															#line 152 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
			++self->keysUnexpectedlyPresent;
															#line 1414 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
			return a_body1cont1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 155 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		tr.set(messageKey, "deadbeef"_sr);
															#line 156 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		StrictFuture<Void> __when_expr_3 = tr.commit();
															#line 156 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		if (static_cast<MutatorActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1423 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1cont1loopBody1cont2when1(__when_expr_3.get(), loopDepth); };
		static_cast<MutatorActor*>(this)->actor_wait_state = 4;
															#line 156 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MutatorActor, 3, Void >*>(static_cast<MutatorActor*>(this)));
															#line 1428 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1loopBody1cont2(val, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1loopBody1cont2(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MutatorActor*>(this)->actor_wait_state > 0) static_cast<MutatorActor*>(this)->actor_wait_state = 0;
		static_cast<MutatorActor*>(this)->ActorCallback< MutatorActor, 2, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< MutatorActor, 2, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("mutator", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MutatorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mutator", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MutatorActor, 2, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("mutator", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MutatorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mutator", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MutatorActor, 2, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("mutator", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MutatorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mutator", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 157 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		commitVersion = tr.getCommittedVersion();
															#line 1512 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
		return a_body1cont1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 157 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		commitVersion = tr.getCommittedVersion();
															#line 1521 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
		return a_body1cont1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<MutatorActor*>(this)->actor_wait_state > 0) static_cast<MutatorActor*>(this)->actor_wait_state = 0;
		static_cast<MutatorActor*>(this)->ActorCallback< MutatorActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MutatorActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("mutator", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MutatorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mutator", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MutatorActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("mutator", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MutatorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mutator", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MutatorActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("mutator", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MutatorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mutator", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<MutatorActor*>(this)->actor_wait_state > 0) static_cast<MutatorActor*>(this)->actor_wait_state = 0;
		static_cast<MutatorActor*>(this)->ActorCallback< MutatorActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MutatorActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("mutator", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MutatorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mutator", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< MutatorActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("mutator", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MutatorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mutator", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< MutatorActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("mutator", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MutatorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mutator", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 136 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
	SidebandWorkload* self;
															#line 136 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
	Database cx;
															#line 137 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
	SidebandInterface checker;
															#line 138 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
	double lastTime;
															#line 139 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
	Version commitVersion;
															#line 143 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
	Transaction tr;
															#line 144 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
	uint64_t key;
															#line 146 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
	Standalone<StringRef> messageKey;
															#line 1704 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
};
// This generated class is to be used only via mutator()
															#line 136 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
class MutatorActor final : public Actor<Void>, public ActorCallback< MutatorActor, 0, SidebandInterface >, public ActorCallback< MutatorActor, 1, Void >, public ActorCallback< MutatorActor, 2, Optional<Value> >, public ActorCallback< MutatorActor, 3, Void >, public ActorCallback< MutatorActor, 4, Void >, public FastAllocated<MutatorActor>, public MutatorActorState<MutatorActor> {
															#line 1709 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
public:
	using FastAllocated<MutatorActor>::operator new;
	using FastAllocated<MutatorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18308847695825250560UL, 2166365832706983680UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MutatorActor, 0, SidebandInterface >;
friend struct ActorCallback< MutatorActor, 1, Void >;
friend struct ActorCallback< MutatorActor, 2, Optional<Value> >;
friend struct ActorCallback< MutatorActor, 3, Void >;
friend struct ActorCallback< MutatorActor, 4, Void >;
															#line 136 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
	MutatorActor(SidebandWorkload* const& self,Database const& cx) 
															#line 1730 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
		 : Actor<Void>(),
		   MutatorActorState<MutatorActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("mutator", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5815853074451583744UL, 2307273088879991296UL);
		ActorExecutionContextHelper __helper(static_cast<MutatorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("mutator");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("mutator", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MutatorActor, 0, SidebandInterface >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MutatorActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MutatorActor, 2, Optional<Value> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< MutatorActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< MutatorActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 136 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
[[nodiscard]] Future<Void> mutator( SidebandWorkload* const& self, Database const& cx ) {
															#line 136 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
	return Future<Void>(new MutatorActor(self, cx));
															#line 1766 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
}

#line 167 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"

																#line 1771 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
// This generated class is to be used only via checker()
															#line 168 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
template <class CheckerActor>
															#line 168 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
class CheckerActorState {
															#line 1777 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
public:
															#line 168 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
	CheckerActorState(SidebandWorkload* const& self,Database const& cx) 
															#line 168 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
															#line 168 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		 : self(self),
															#line 168 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		   cx(cx)
															#line 1786 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
	{
		fdb_probe_actor_create("checker", reinterpret_cast<unsigned long>(this));

	}
	~CheckerActorState() 
	{
		fdb_probe_actor_destroy("checker", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 169 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
			;
															#line 1801 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckerActorState();
		static_cast<CheckerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 170 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		auto __when_expr_0 = self->interf.updates.getFuture();
															#line 1831 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<SidebandMessage>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<SidebandMessage>>::value, "invalid type");
															#line 170 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		if (static_cast<CheckerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1835 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
		static_cast<CheckerActor*>(this)->actor_wait_state = 1;
															#line 170 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< CheckerActor, 0, SidebandMessage >*>(static_cast<CheckerActor*>(this)));
															#line 1840 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 171 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		messageKey = Standalone<StringRef>(format("Sideband/Message/%llx", message.key));
															#line 172 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		tr = Transaction(cx);
															#line 173 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		;
															#line 1853 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(SidebandMessage const& __message,int loopDepth) 
	{
															#line 170 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		message = __message;
															#line 1862 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(SidebandMessage && __message,int loopDepth) 
	{
		message = std::move(__message);
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckerActor*>(this)->actor_wait_state > 0) static_cast<CheckerActor*>(this)->actor_wait_state = 0;
		static_cast<CheckerActor*>(this)->ActorSingleCallback< CheckerActor, 0, SidebandMessage >::remove();

	}
	void a_callback_fire(ActorSingleCallback< CheckerActor, 0, SidebandMessage >*,SidebandMessage const& value) 
	{
		fdb_probe_actor_enter("checker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< CheckerActor, 0, SidebandMessage >*,SidebandMessage && value) 
	{
		fdb_probe_actor_enter("checker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< CheckerActor, 0, SidebandMessage >*,Error err) 
	{
		fdb_probe_actor_enter("checker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checker", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 175 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_1 = tr.get(messageKey);
															#line 175 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
			if (static_cast<CheckerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1957 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CheckerActor*>(this)->actor_wait_state = 2;
															#line 175 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckerActor, 1, Optional<Value> >*>(static_cast<CheckerActor*>(this)));
															#line 1962 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 186 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 186 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
			if (static_cast<CheckerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1999 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<CheckerActor*>(this)->actor_wait_state = 3;
															#line 186 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CheckerActor, 2, Void >*>(static_cast<CheckerActor*>(this)));
															#line 2004 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2(Optional<Value> const& val,int loopDepth) 
	{
															#line 176 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		if (!val.present())
															#line 2019 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
		{
															#line 177 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
			TraceEvent(SevError, "CausalConsistencyError", self->interf.id()) .detail("MessageKey", messageKey.toString().c_str()) .detail("RemoteCommitVersion", message.commitVersion) .detail("LocalReadVersion", tr.getReadVersion().get());
															#line 182 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
			++self->consistencyErrors;
															#line 2025 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
		}
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2(Optional<Value> && val,int loopDepth) 
	{
															#line 176 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
		if (!val.present())
															#line 2035 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
		{
															#line 177 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
			TraceEvent(SevError, "CausalConsistencyError", self->interf.id()) .detail("MessageKey", messageKey.toString().c_str()) .detail("RemoteCommitVersion", message.commitVersion) .detail("LocalReadVersion", tr.getReadVersion().get());
															#line 182 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
			++self->consistencyErrors;
															#line 2041 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
		}
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont2(val, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont2(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckerActor*>(this)->actor_wait_state > 0) static_cast<CheckerActor*>(this)->actor_wait_state = 0;
		static_cast<CheckerActor*>(this)->ActorCallback< CheckerActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckerActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("checker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckerActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("checker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckerActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("checker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checker", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CheckerActor*>(this)->actor_wait_state > 0) static_cast<CheckerActor*>(this)->actor_wait_state = 0;
		static_cast<CheckerActor*>(this)->ActorCallback< CheckerActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckerActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CheckerActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CheckerActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checker", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 168 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
	SidebandWorkload* self;
															#line 168 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
	Database cx;
															#line 170 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
	SidebandMessage message;
															#line 171 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
	Standalone<StringRef> messageKey;
															#line 172 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
	Transaction tr;
															#line 2219 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
};
// This generated class is to be used only via checker()
															#line 168 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
class CheckerActor final : public Actor<Void>, public ActorSingleCallback< CheckerActor, 0, SidebandMessage >, public ActorCallback< CheckerActor, 1, Optional<Value> >, public ActorCallback< CheckerActor, 2, Void >, public FastAllocated<CheckerActor>, public CheckerActorState<CheckerActor> {
															#line 2224 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
public:
	using FastAllocated<CheckerActor>::operator new;
	using FastAllocated<CheckerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7390050444559636224UL, 14078593389823452928UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< CheckerActor, 0, SidebandMessage >;
friend struct ActorCallback< CheckerActor, 1, Optional<Value> >;
friend struct ActorCallback< CheckerActor, 2, Void >;
															#line 168 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
	CheckerActor(SidebandWorkload* const& self,Database const& cx) 
															#line 2243 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
		 : Actor<Void>(),
		   CheckerActorState<CheckerActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checker", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8562182272201437184UL, 15617388284688477440UL);
		ActorExecutionContextHelper __helper(static_cast<CheckerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checker");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checker", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< CheckerActor, 0, SidebandMessage >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckerActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CheckerActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 168 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
[[nodiscard]] Future<Void> checker( SidebandWorkload* const& self, Database const& cx ) {
															#line 168 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
	return Future<Void>(new CheckerActor(self, cx));
															#line 2277 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Sideband.actor.g.cpp"
}

#line 191 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/Sideband.actor.cpp"
};

WorkloadFactory<SidebandWorkload> SidebandWorkloadFactory;
