#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
/*
 * RandomSelector.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct RandomSelectorWorkload : TestWorkload {
	static constexpr auto NAME = "RandomSelector";

	int minOperationsPerTransaction, maxOperationsPerTransaction, maxKeySpace, maxOffset, minInitialAmount,
	    maxInitialAmount;
	double testDuration;
	bool fail;

	std::vector<Future<Void>> clients;
	PerfIntCounter transactions, retries;

	RandomSelectorWorkload(WorkloadContext const& wcx)
	  : TestWorkload(wcx), transactions("Transactions"), retries("Retries") {

		minOperationsPerTransaction = getOption(options, "minOperationsPerTransaction"_sr, 10);
		maxOperationsPerTransaction = getOption(options, "minOperationsPerTransaction"_sr, 50);
		maxKeySpace = getOption(options, "maxKeySpace"_sr, 20);
		maxOffset = getOption(options, "maxOffset"_sr, 5);
		minInitialAmount = getOption(options, "minInitialAmount"_sr, 5);
		maxInitialAmount = getOption(options, "maxInitialAmount"_sr, 10);
		testDuration = getOption(options, "testDuration"_sr, 10.0);
		fail = false;
	}

	Future<Void> setup(Database const& cx) override { return randomSelectorSetup(cx->clone(), this); }

	Future<Void> start(Database const& cx) override {
		clients.push_back(timeout(randomSelectorClient(cx->clone(), this), testDuration, Void()));
		return delay(testDuration);
	}

	Future<bool> check(Database const& cx) override {
		clients.clear();
		return !fail;
	}

	void getMetrics(std::vector<PerfMetric>& m) override {
		m.push_back(transactions.getMetric());
		m.push_back(retries.getMetric());
	}

																#line 70 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
// This generated class is to be used only via randomSelectorSetup()
															#line 68 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
template <class RandomSelectorSetupActor>
															#line 68 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
class RandomSelectorSetupActorState {
															#line 76 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
public:
															#line 68 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
	RandomSelectorSetupActorState(Database const& cx,RandomSelectorWorkload* const& self) 
															#line 68 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
															#line 68 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		 : cx(cx),
															#line 68 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		   self(self),
															#line 69 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		   myValue(StringRef(format("%d", deterministicRandom()->randomInt(0, 10000000)))),
															#line 70 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		   tr(cx),
															#line 71 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		   clientID()
															#line 91 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
	{
		fdb_probe_actor_create("randomSelectorSetup", reinterpret_cast<unsigned long>(this));

	}
	~RandomSelectorSetupActorState() 
	{
		fdb_probe_actor_destroy("randomSelectorSetup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 73 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			clientID = format("%08d", self->clientId);
															#line 74 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			;
															#line 108 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RandomSelectorSetupActorState();
		static_cast<RandomSelectorSetupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 89 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		if (!static_cast<RandomSelectorSetupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RandomSelectorSetupActorState(); static_cast<RandomSelectorSetupActor*>(this)->destroy(); return 0; }
															#line 131 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		new (&static_cast<RandomSelectorSetupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RandomSelectorSetupActorState();
		static_cast<RandomSelectorSetupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 76 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			for(int i = 0;i < self->maxOffset;i++) {
															#line 77 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
				tr.set(StringRef(clientID + "a/" + format("%010d", i)), myValue);
															#line 78 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
				tr.set(StringRef(clientID + "c/" + format("%010d", i)), myValue);
															#line 79 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
				tr.set(StringRef(clientID + "e/" + format("%010d", i)), myValue);
															#line 157 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			}
															#line 81 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 81 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (static_cast<RandomSelectorSetupActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 163 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RandomSelectorSetupActor*>(this)->actor_wait_state = 1;
															#line 81 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RandomSelectorSetupActor, 0, Void >*>(static_cast<RandomSelectorSetupActor*>(this)));
															#line 168 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 84 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 84 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (static_cast<RandomSelectorSetupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 205 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<RandomSelectorSetupActor*>(this)->actor_wait_state = 2;
															#line 84 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RandomSelectorSetupActor, 1, Void >*>(static_cast<RandomSelectorSetupActor*>(this)));
															#line 210 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RandomSelectorSetupActor*>(this)->actor_wait_state > 0) static_cast<RandomSelectorSetupActor*>(this)->actor_wait_state = 0;
		static_cast<RandomSelectorSetupActor*>(this)->ActorCallback< RandomSelectorSetupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomSelectorSetupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomSelectorSetup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorSetup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RandomSelectorSetupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomSelectorSetup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorSetup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RandomSelectorSetupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomSelectorSetup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorSetup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 85 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		tr.reset();
															#line 312 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 85 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		tr.reset();
															#line 321 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RandomSelectorSetupActor*>(this)->actor_wait_state > 0) static_cast<RandomSelectorSetupActor*>(this)->actor_wait_state = 0;
		static_cast<RandomSelectorSetupActor*>(this)->ActorCallback< RandomSelectorSetupActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomSelectorSetupActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomSelectorSetup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorSetup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RandomSelectorSetupActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomSelectorSetup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorSetup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RandomSelectorSetupActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomSelectorSetup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorSetup", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 68 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
	Database cx;
															#line 68 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
	RandomSelectorWorkload* self;
															#line 69 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
	Value myValue;
															#line 70 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
	Transaction tr;
															#line 71 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
	std::string clientID;
															#line 411 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
};
// This generated class is to be used only via randomSelectorSetup()
															#line 68 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
class RandomSelectorSetupActor final : public Actor<Void>, public ActorCallback< RandomSelectorSetupActor, 0, Void >, public ActorCallback< RandomSelectorSetupActor, 1, Void >, public FastAllocated<RandomSelectorSetupActor>, public RandomSelectorSetupActorState<RandomSelectorSetupActor> {
															#line 416 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
public:
	using FastAllocated<RandomSelectorSetupActor>::operator new;
	using FastAllocated<RandomSelectorSetupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10157095948034462976UL, 7260198438026512128UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RandomSelectorSetupActor, 0, Void >;
friend struct ActorCallback< RandomSelectorSetupActor, 1, Void >;
															#line 68 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
	RandomSelectorSetupActor(Database const& cx,RandomSelectorWorkload* const& self) 
															#line 434 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		 : Actor<Void>(),
		   RandomSelectorSetupActorState<RandomSelectorSetupActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("randomSelectorSetup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17515601131771708160UL, 9842541877757991680UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("randomSelectorSetup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("randomSelectorSetup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RandomSelectorSetupActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RandomSelectorSetupActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 68 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
[[nodiscard]] Future<Void> randomSelectorSetup( Database const& cx, RandomSelectorWorkload* const& self ) {
															#line 68 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
	return Future<Void>(new RandomSelectorSetupActor(cx, self));
															#line 467 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
}

#line 91 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"

																#line 472 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
// This generated class is to be used only via randomSelectorClient()
															#line 92 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
template <class RandomSelectorClientActor>
															#line 92 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
class RandomSelectorClientActorState {
															#line 478 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
public:
															#line 92 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
	RandomSelectorClientActorState(Database const& cx,RandomSelectorWorkload* const& self) 
															#line 92 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
															#line 92 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		 : cx(cx),
															#line 92 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		   self(self),
															#line 93 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		   i(),
															#line 94 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		   j(),
															#line 95 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		   clientID(),
															#line 96 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		   myKeyA(),
															#line 97 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		   myKeyB(),
															#line 98 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		   myValue(),
															#line 99 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		   myRandomIDKey(),
															#line 100 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		   onEqualA(),
															#line 101 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		   onEqualB(),
															#line 102 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		   offsetA(),
															#line 103 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		   offsetB(),
															#line 104 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		   randomLimit(),
															#line 105 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		   randomByteLimit(),
															#line 106 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		   reverse(Reverse::False),
															#line 107 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		   error()
															#line 517 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
	{
		fdb_probe_actor_create("randomSelectorClient", reinterpret_cast<unsigned long>(this));

	}
	~RandomSelectorClientActorState() 
	{
		fdb_probe_actor_destroy("randomSelectorClient", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 109 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			clientID = format("%08d", self->clientId);
															#line 111 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			;
															#line 534 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RandomSelectorClientActorState();
		static_cast<RandomSelectorClientActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 112 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		tr = Transaction(cx);
															#line 114 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		;
															#line 566 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 135 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		trRYOW = ReadYourWritesTransaction(cx);
															#line 575 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		try {
															#line 138 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			i = 0;
															#line 579 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 116 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			tr.clear(KeyRangeRef(StringRef(clientID + "b/"), StringRef(clientID + "c/")));
															#line 117 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			tr.clear(KeyRangeRef(StringRef(clientID + "d/"), StringRef(clientID + "e/")));
															#line 118 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			for(i = 0;i < deterministicRandom()->randomInt(self->minInitialAmount, self->maxInitialAmount + 1);i++) {
															#line 121 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
				myKeyA = format("%010d", deterministicRandom()->randomInt(0, self->maxKeySpace + 1));
															#line 122 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
				myValue = format("%d", deterministicRandom()->randomInt(0, 10000000));
															#line 123 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
				tr.set(StringRef(clientID + "b/" + myKeyA), myValue);
															#line 124 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
				tr.set(StringRef(clientID + "d/" + myKeyA), myValue);
															#line 614 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			}
															#line 127 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 127 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 620 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 1;
															#line 127 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RandomSelectorClientActor, 0, Void >*>(static_cast<RandomSelectorClientActor*>(this)));
															#line 625 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 131 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 131 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 662 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 2;
															#line 131 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RandomSelectorClientActor, 1, Void >*>(static_cast<RandomSelectorClientActor*>(this)));
															#line 667 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 128 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		tr.reset();
															#line 682 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 128 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		tr.reset();
															#line 691 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state > 0) static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 0;
		static_cast<RandomSelectorClientActor*>(this)->ActorCallback< RandomSelectorClientActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RandomSelectorClientActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state > 0) static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 0;
		static_cast<RandomSelectorClientActor*>(this)->ActorCallback< RandomSelectorClientActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RandomSelectorClientActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 567 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			StrictFuture<Void> __when_expr_45 = trRYOW.onError(e);
															#line 567 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 871 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			if (__when_expr_45.isReady()) { if (__when_expr_45.isError()) return a_body1Catch1(__when_expr_45.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1Catch1when1(__when_expr_45.get(), loopDepth); };
			static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 46;
															#line 567 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			__when_expr_45.addCallbackAndClear(static_cast<ActorCallback< RandomSelectorClientActor, 45, Void >*>(static_cast<RandomSelectorClientActor*>(this)));
															#line 876 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 532 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		StrictFuture<Void> __when_expr_41 = trRYOW.commit();
															#line 532 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 893 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		if (__when_expr_41.isReady()) { if (__when_expr_41.isError()) return a_body1loopBody1cont1Catch1(__when_expr_41.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_41.get(), loopDepth); };
		static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 42;
															#line 532 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		__when_expr_41.addCallbackAndClear(static_cast<ActorCallback< RandomSelectorClientActor, 41, Void >*>(static_cast<RandomSelectorClientActor*>(this)));
															#line 898 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1(int loopDepth) 
	{
															#line 138 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		if (!(i < deterministicRandom()->randomInt(self->minOperationsPerTransaction, self->maxOperationsPerTransaction + 1)))
															#line 914 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		{
			return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 141 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		j = deterministicRandom()->randomInt(0, 16);
															#line 142 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		if (j < 3)
															#line 922 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		{
															#line 143 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			myKeyA = format("%010d", deterministicRandom()->randomInt(0, self->maxKeySpace + 1));
															#line 144 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			myValue = format("%d", deterministicRandom()->randomInt(0, 10000000));
															#line 147 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			trRYOW.set(StringRef(clientID + "b/" + myKeyA), myValue);
															#line 149 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			;
															#line 932 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			loopDepth = a_body1loopBody1cont1loopBody1loopHead1(loopDepth);
		}
		else
		{
															#line 159 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (j < 4)
															#line 939 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			{
															#line 160 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
				myKeyA = format("%010d", deterministicRandom()->randomInt(0, self->maxKeySpace + 1));
															#line 162 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
				trRYOW.clear(StringRef(clientID + "b/" + myKeyA));
															#line 164 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
				;
															#line 947 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
				loopDepth = a_body1loopBody1cont1loopBody1loopHead2(loopDepth);
			}
			else
			{
															#line 175 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
				if (j < 5)
															#line 954 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
				{
															#line 176 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
					int a = deterministicRandom()->randomInt(1, self->maxKeySpace + 1);
															#line 177 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
					int b = deterministicRandom()->randomInt(1, self->maxKeySpace + 1);
															#line 178 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
					myKeyA = format("%010d", std::min(a, b) - 1);
															#line 179 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
					myKeyB = format("%010d", std::max(a, b));
															#line 182 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
					trRYOW.clear( KeyRangeRef(StringRef(clientID + "b/" + myKeyA), StringRef(clientID + "b/" + myKeyB)));
															#line 185 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
					;
															#line 968 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
					loopDepth = a_body1loopBody1cont1loopBody1loopHead3(loopDepth);
				}
				else
				{
															#line 196 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
					if (j < 6)
															#line 975 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
					{
															#line 197 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
						myKeyA = format("%010d", deterministicRandom()->randomInt(0, self->maxKeySpace + 1));
															#line 199 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
						getTest1 = Optional<Value>();
															#line 201 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
						StrictFuture<Optional<Value>> __when_expr_8 = trRYOW.get(StringRef(clientID + "b/" + myKeyA));
															#line 201 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
						if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 985 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
						if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1loopBody1cont1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1loopBody1when1(__when_expr_8.get(), loopDepth); };
						static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 9;
															#line 201 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
						__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< RandomSelectorClientActor, 8, Optional<Value> >*>(static_cast<RandomSelectorClientActor*>(this)));
															#line 990 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
						loopDepth = 0;
					}
					else
					{
															#line 226 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
						if (j < 7)
															#line 997 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
						{
															#line 227 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
							myKeyA = format("%010d", deterministicRandom()->randomInt(0, self->maxKeySpace + 1));
															#line 228 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
							myRandomIDKey = format("%010d", deterministicRandom()->randomInt(0, 1000000000));
															#line 229 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
							myValue = format("%d", deterministicRandom()->randomInt(0, 10000000));
															#line 231 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
							trRYOW.atomicOp(StringRef(clientID + "b/" + myKeyA), myValue, MutationRef::AddValue);
															#line 233 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
							;
															#line 1009 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
							loopDepth = a_body1loopBody1cont1loopBody1loopHead4(loopDepth);
						}
						else
						{
															#line 250 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
							if (j < 8)
															#line 1016 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
							{
															#line 251 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
								myKeyA = format("%010d", deterministicRandom()->randomInt(0, self->maxKeySpace + 1));
															#line 252 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
								myRandomIDKey = format("%010d", deterministicRandom()->randomInt(0, 1000000000));
															#line 253 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
								myValue = format("%d", deterministicRandom()->randomInt(0, 10000000));
															#line 255 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
								trRYOW.atomicOp(StringRef(clientID + "b/" + myKeyA), myValue, MutationRef::AppendIfFits);
															#line 257 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
								;
															#line 1028 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
								loopDepth = a_body1loopBody1cont1loopBody1loopHead5(loopDepth);
							}
							else
							{
															#line 274 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
								if (j < 9)
															#line 1035 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
								{
															#line 275 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
									myKeyA = format("%010d", deterministicRandom()->randomInt(0, self->maxKeySpace + 1));
															#line 276 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
									myRandomIDKey = format("%010d", deterministicRandom()->randomInt(0, 1000000000));
															#line 277 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
									myValue = format("%d", deterministicRandom()->randomInt(0, 10000000));
															#line 279 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
									trRYOW.atomicOp(StringRef(clientID + "b/" + myKeyA), myValue, MutationRef::And);
															#line 281 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
									;
															#line 1047 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
									loopDepth = a_body1loopBody1cont1loopBody1loopHead6(loopDepth);
								}
								else
								{
															#line 298 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
									if (j < 10)
															#line 1054 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
									{
															#line 299 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
										myKeyA = format("%010d", deterministicRandom()->randomInt(0, self->maxKeySpace + 1));
															#line 300 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
										myRandomIDKey = format("%010d", deterministicRandom()->randomInt(0, 1000000000));
															#line 301 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
										myValue = format("%d", deterministicRandom()->randomInt(0, 10000000));
															#line 303 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
										trRYOW.atomicOp(StringRef(clientID + "b/" + myKeyA), myValue, MutationRef::Or);
															#line 305 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
										;
															#line 1066 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
										loopDepth = a_body1loopBody1cont1loopBody1loopHead7(loopDepth);
									}
									else
									{
															#line 322 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
										if (j < 11)
															#line 1073 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
										{
															#line 323 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
											myKeyA = format("%010d", deterministicRandom()->randomInt(0, self->maxKeySpace + 1));
															#line 324 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
											myRandomIDKey = format("%010d", deterministicRandom()->randomInt(0, 1000000000));
															#line 325 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
											myValue = format("%d", deterministicRandom()->randomInt(0, 10000000));
															#line 327 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
											trRYOW.atomicOp(StringRef(clientID + "b/" + myKeyA), myValue, MutationRef::Xor);
															#line 329 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
											;
															#line 1085 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
											loopDepth = a_body1loopBody1cont1loopBody1loopHead8(loopDepth);
										}
										else
										{
															#line 346 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
											if (j < 12)
															#line 1092 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
											{
															#line 347 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
												myKeyA = format("%010d", deterministicRandom()->randomInt(0, self->maxKeySpace + 1));
															#line 348 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
												myRandomIDKey = format("%010d", deterministicRandom()->randomInt(0, 1000000000));
															#line 349 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
												myValue = format("%d", deterministicRandom()->randomInt(0, 10000000));
															#line 351 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
												trRYOW.atomicOp(StringRef(clientID + "b/" + myKeyA), myValue, MutationRef::Max);
															#line 353 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
												;
															#line 1104 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
												loopDepth = a_body1loopBody1cont1loopBody1loopHead9(loopDepth);
											}
											else
											{
															#line 370 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
												if (j < 13)
															#line 1111 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
												{
															#line 371 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
													myKeyA = format("%010d", deterministicRandom()->randomInt(0, self->maxKeySpace + 1));
															#line 372 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
													myRandomIDKey = format("%010d", deterministicRandom()->randomInt(0, 1000000000));
															#line 373 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
													myValue = format("%d", deterministicRandom()->randomInt(0, 10000000));
															#line 375 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
													trRYOW.atomicOp(StringRef(clientID + "b/" + myKeyA), myValue, MutationRef::Min);
															#line 377 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
													;
															#line 1123 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
													loopDepth = a_body1loopBody1cont1loopBody1loopHead10(loopDepth);
												}
												else
												{
															#line 394 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
													if (j < 14)
															#line 1130 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
													{
															#line 395 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
														myKeyA = format("%010d", deterministicRandom()->randomInt(0, self->maxKeySpace + 1));
															#line 396 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
														myRandomIDKey = format("%010d", deterministicRandom()->randomInt(0, 1000000000));
															#line 397 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
														myValue = format("%d", deterministicRandom()->randomInt(0, 10000000));
															#line 399 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
														trRYOW.atomicOp(StringRef(clientID + "b/" + myKeyA), myValue, MutationRef::ByteMin);
															#line 401 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
														;
															#line 1142 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
														loopDepth = a_body1loopBody1cont1loopBody1loopHead11(loopDepth);
													}
													else
													{
															#line 418 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
														if (j < 15)
															#line 1149 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
														{
															#line 419 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
															myKeyA = format("%010d", deterministicRandom()->randomInt(0, self->maxKeySpace + 1));
															#line 420 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
															myRandomIDKey = format("%010d", deterministicRandom()->randomInt(0, 1000000000));
															#line 421 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
															myValue = format("%d", deterministicRandom()->randomInt(0, 10000000));
															#line 423 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
															trRYOW.atomicOp(StringRef(clientID + "b/" + myKeyA), myValue, MutationRef::ByteMax);
															#line 425 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
															;
															#line 1161 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
															loopDepth = a_body1loopBody1cont1loopBody1loopHead12(loopDepth);
														}
														else
														{
															#line 443 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
															int a = deterministicRandom()->randomInt(1, self->maxKeySpace + 1);
															#line 444 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
															int b = deterministicRandom()->randomInt(1, self->maxKeySpace + 1);
															#line 445 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
															myKeyA = format("%010d", std::min(a, b) - 1);
															#line 446 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
															myKeyB = format("%010d", std::max(a, b));
															#line 447 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
															onEqualA = deterministicRandom()->randomInt(0, 2) != 0;
															#line 448 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
															onEqualB = deterministicRandom()->randomInt(0, 2) != 0;
															#line 449 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
															offsetA = deterministicRandom()->randomInt(-1 * self->maxOffset / 2, self->maxOffset / 2);
															#line 450 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
															offsetB = deterministicRandom()->randomInt(-1 * self->maxOffset / 2, self->maxOffset / 2);
															#line 451 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
															randomLimit = deterministicRandom()->randomInt(0, 2 * self->maxOffset + self->maxKeySpace);
															#line 452 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
															randomByteLimit = deterministicRandom()->randomInt(0, (self->maxOffset + self->maxKeySpace) * 512);
															#line 454 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
															reverse.set(deterministicRandom()->coinflip());
															#line 458 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
															getRangeTest1 = RangeResult();
															#line 459 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
															StrictFuture<RangeResult> __when_expr_38 = trRYOW.getRange(KeySelectorRef(StringRef(clientID + "b/" + myKeyA), onEqualA, offsetA), KeySelectorRef(StringRef(clientID + "b/" + myKeyB), onEqualB, offsetB), randomLimit, Snapshot::False, reverse);
															#line 459 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
															if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1194 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
															if (__when_expr_38.isReady()) { if (__when_expr_38.isError()) return a_body1loopBody1cont1Catch1(__when_expr_38.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1loopBody1when2(__when_expr_38.get(), loopDepth); };
															static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 39;
															#line 459 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
															__when_expr_38.addCallbackAndClear(static_cast<ActorCallback< RandomSelectorClientActor, 38, RangeResult >*>(static_cast<RandomSelectorClientActor*>(this)));
															#line 1199 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
															loopDepth = 0;
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(int loopDepth) 
	{
															#line 138 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		i++;
															#line 1234 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 151 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			tr.set(StringRef(clientID + "d/" + myKeyA), myValue);
															#line 152 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 152 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1261 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1cont1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 3;
															#line 152 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RandomSelectorClientActor, 2, Void >*>(static_cast<RandomSelectorClientActor*>(this)));
															#line 1266 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 156 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 156 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1303 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1cont1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 4;
															#line 156 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RandomSelectorClientActor, 3, Void >*>(static_cast<RandomSelectorClientActor*>(this)));
															#line 1308 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 153 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		tr.reset();
															#line 1323 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		return a_body1loopBody1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 153 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		tr.reset();
															#line 1332 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		return a_body1loopBody1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state > 0) static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 0;
		static_cast<RandomSelectorClientActor*>(this)->ActorCallback< RandomSelectorClientActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RandomSelectorClientActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state > 0) static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 0;
		static_cast<RandomSelectorClientActor*>(this)->ActorCallback< RandomSelectorClientActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RandomSelectorClientActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont1loopBody1cont4(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont5(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopHead2(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1loopBody2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody2(int loopDepth) 
	{
		try {
															#line 166 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			tr.clear(StringRef(clientID + "d/" + myKeyA));
															#line 167 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			StrictFuture<Void> __when_expr_4 = tr.commit();
															#line 167 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1loopBody2Catch1(actor_cancelled(), loopDepth);
															#line 1527 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1cont1loopBody1loopBody2Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1loopBody2when1(__when_expr_4.get(), loopDepth); };
			static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 5;
															#line 167 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RandomSelectorClientActor, 4, Void >*>(static_cast<RandomSelectorClientActor*>(this)));
															#line 1532 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1loopBody2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1loopBody2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1break2(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1loopBody1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody2cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopBody1loopHead2(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 171 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			StrictFuture<Void> __when_expr_5 = tr.onError(e);
															#line 171 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1569 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1cont1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1loopBody2Catch1when1(__when_expr_5.get(), loopDepth); };
			static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 6;
															#line 171 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< RandomSelectorClientActor, 5, Void >*>(static_cast<RandomSelectorClientActor*>(this)));
															#line 1574 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody2cont2(Void const& _,int loopDepth) 
	{
															#line 168 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		tr.reset();
															#line 1589 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		return a_body1loopBody1cont1loopBody1break2(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody2cont2(Void && _,int loopDepth) 
	{
															#line 168 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		tr.reset();
															#line 1598 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		return a_body1loopBody1cont1loopBody1break2(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody2cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody2cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state > 0) static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 0;
		static_cast<RandomSelectorClientActor*>(this)->ActorCallback< RandomSelectorClientActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont1loopBody1loopBody2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1loopBody2Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1loopBody2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont1loopBody1loopBody2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1loopBody2Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1loopBody2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< RandomSelectorClientActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont1loopBody1loopBody2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1loopBody2Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1loopBody2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont1loopBody1loopBody2Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody2cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody2Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody2cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody2Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody2Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody2Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody2Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state > 0) static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 0;
		static_cast<RandomSelectorClientActor*>(this)->ActorCallback< RandomSelectorClientActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont1loopBody1loopBody2Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont1loopBody1loopBody2Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< RandomSelectorClientActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1cont1loopBody1cont6(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont7(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopHead3(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1loopBody3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody3(int loopDepth) 
	{
		try {
															#line 187 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			tr.clear(KeyRangeRef(StringRef(clientID + "d/" + myKeyA), StringRef(clientID + "d/" + myKeyB)));
															#line 189 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			StrictFuture<Void> __when_expr_6 = tr.commit();
															#line 189 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1loopBody3Catch1(actor_cancelled(), loopDepth);
															#line 1793 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1loopBody1cont1loopBody1loopBody3Catch1(__when_expr_6.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1loopBody3when1(__when_expr_6.get(), loopDepth); };
			static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 7;
															#line 189 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< RandomSelectorClientActor, 6, Void >*>(static_cast<RandomSelectorClientActor*>(this)));
															#line 1798 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1loopBody3Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1loopBody3Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1break3(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1loopBody1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody3cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopBody1loopHead3(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody3Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 193 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			StrictFuture<Void> __when_expr_7 = tr.onError(e);
															#line 193 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1835 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1loopBody1cont1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1loopBody3Catch1when1(__when_expr_7.get(), loopDepth); };
			static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 8;
															#line 193 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< RandomSelectorClientActor, 7, Void >*>(static_cast<RandomSelectorClientActor*>(this)));
															#line 1840 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody3cont2(Void const& _,int loopDepth) 
	{
															#line 190 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		tr.reset();
															#line 1855 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		return a_body1loopBody1cont1loopBody1break3(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody3cont2(Void && _,int loopDepth) 
	{
															#line 190 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		tr.reset();
															#line 1864 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		return a_body1loopBody1cont1loopBody1break3(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody3cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody3cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state > 0) static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 0;
		static_cast<RandomSelectorClientActor*>(this)->ActorCallback< RandomSelectorClientActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1cont1loopBody1loopBody3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1loopBody3Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1loopBody3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1cont1loopBody1loopBody3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1loopBody3Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1loopBody3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< RandomSelectorClientActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1cont1loopBody1loopBody3Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1loopBody3Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1loopBody3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1loopBody1cont1loopBody1loopBody3Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody3cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody3Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody3cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody3Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody3Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody3Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody3Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state > 0) static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 0;
		static_cast<RandomSelectorClientActor*>(this)->ActorCallback< RandomSelectorClientActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1cont1loopBody1loopBody3Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1cont1loopBody1loopBody3Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< RandomSelectorClientActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1loopBody1cont1loopBody1cont8(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont9(Optional<Value> const& getTest,int loopDepth) 
	{
															#line 202 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		getTest1 = getTest;
															#line 204 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		;
															#line 2043 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopBody1cont9loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont9(Optional<Value> && getTest,int loopDepth) 
	{
															#line 202 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		getTest1 = getTest;
															#line 204 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		;
															#line 2054 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopBody1cont9loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Optional<Value> const& getTest,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont9(getTest, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Optional<Value> && getTest,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont9(std::move(getTest), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state > 0) static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 0;
		static_cast<RandomSelectorClientActor*>(this)->ActorCallback< RandomSelectorClientActor, 8, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 8, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 8, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< RandomSelectorClientActor, 8, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1loopBody1cont1loopBody1cont10(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont9loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1cont9loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont9loopBody1(int loopDepth) 
	{
		try {
															#line 206 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_9 = tr.get(StringRef(clientID + "d/" + myKeyA));
															#line 206 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1cont9loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2154 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1loopBody1cont1loopBody1cont9loopBody1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont9loopBody1when1(__when_expr_9.get(), loopDepth); };
			static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 10;
															#line 206 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< RandomSelectorClientActor, 9, Optional<Value> >*>(static_cast<RandomSelectorClientActor*>(this)));
															#line 2159 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1cont9loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1cont9loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont9break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1loopBody1cont10(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont9loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopBody1cont9loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont9loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 222 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			StrictFuture<Void> __when_expr_10 = tr.onError(e);
															#line 222 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 2196 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1loopBody1cont1Catch1(__when_expr_10.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1cont9loopBody1Catch1when1(__when_expr_10.get(), loopDepth); };
			static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 11;
															#line 222 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< RandomSelectorClientActor, 10, Void >*>(static_cast<RandomSelectorClientActor*>(this)));
															#line 2201 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont9loopBody1cont2(Optional<Value> const& getTest2,int loopDepth) 
	{
															#line 208 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		if ((getTest1.present() && (!getTest2.present() || getTest1.get() != getTest2.get())) || (!getTest1.present() && getTest2.present()))
															#line 2216 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		{
															#line 210 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			TraceEvent(SevError, "RanSelTestFailure") .detail("Reason", "The get results did not match") .detail("KeyA", myKeyA) .detail("RYOW", getTest1.present() ? printable(getTest1.get()) : "Not Present") .detail("Regular", getTest2.present() ? printable(getTest2.get()) : "Not Present");
															#line 216 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			self->fail = true;
															#line 2222 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		}
															#line 219 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		tr.reset();
															#line 2226 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		return a_body1loopBody1cont1loopBody1cont9break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont9loopBody1cont2(Optional<Value> && getTest2,int loopDepth) 
	{
															#line 208 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		if ((getTest1.present() && (!getTest2.present() || getTest1.get() != getTest2.get())) || (!getTest1.present() && getTest2.present()))
															#line 2235 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		{
															#line 210 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			TraceEvent(SevError, "RanSelTestFailure") .detail("Reason", "The get results did not match") .detail("KeyA", myKeyA) .detail("RYOW", getTest1.present() ? printable(getTest1.get()) : "Not Present") .detail("Regular", getTest2.present() ? printable(getTest2.get()) : "Not Present");
															#line 216 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			self->fail = true;
															#line 2241 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		}
															#line 219 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		tr.reset();
															#line 2245 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		return a_body1loopBody1cont1loopBody1cont9break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont9loopBody1when1(Optional<Value> const& getTest2,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont9loopBody1cont2(getTest2, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont9loopBody1when1(Optional<Value> && getTest2,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont9loopBody1cont2(std::move(getTest2), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state > 0) static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 0;
		static_cast<RandomSelectorClientActor*>(this)->ActorCallback< RandomSelectorClientActor, 9, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 9, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody1cont1loopBody1cont9loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1cont9loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1cont9loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 9, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody1cont1loopBody1cont9loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1cont9loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1cont9loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< RandomSelectorClientActor, 9, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody1cont1loopBody1cont9loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1cont9loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1cont9loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1loopBody1cont1loopBody1cont9loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 223 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		tr.reset();
															#line 2329 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopBody1cont9loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont9loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 223 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		tr.reset();
															#line 2338 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopBody1cont9loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont9loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont9loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont9loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont9loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state > 0) static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 0;
		static_cast<RandomSelectorClientActor*>(this)->ActorCallback< RandomSelectorClientActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1loopBody1cont1loopBody1cont9loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1loopBody1cont1loopBody1cont9loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< RandomSelectorClientActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1loopBody1cont1loopBody1cont11(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont12(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopHead4(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1loopBody4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody4(int loopDepth) 
	{
		try {
															#line 235 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			tr.set(StringRef(clientID + "z/" + myRandomIDKey), StringRef());
															#line 236 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			tr.atomicOp(StringRef(clientID + "d/" + myKeyA), myValue, MutationRef::AddValue);
															#line 237 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			StrictFuture<Void> __when_expr_11 = tr.commit();
															#line 237 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1loopBody4Catch1(actor_cancelled(), loopDepth);
															#line 2448 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1loopBody1cont1loopBody1loopBody4Catch1(__when_expr_11.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1loopBody4when1(__when_expr_11.get(), loopDepth); };
			static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 12;
															#line 237 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< RandomSelectorClientActor, 11, Void >*>(static_cast<RandomSelectorClientActor*>(this)));
															#line 2453 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1loopBody4Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1loopBody4Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1break4(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1loopBody1cont12(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody4cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopBody1loopHead4(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody4Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 241 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			error = e;
															#line 242 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			StrictFuture<Void> __when_expr_12 = tr.onError(e);
															#line 242 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 2492 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1loopBody1cont1Catch1(__when_expr_12.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1loopBody4Catch1when1(__when_expr_12.get(), loopDepth); };
			static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 13;
															#line 242 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< RandomSelectorClientActor, 12, Void >*>(static_cast<RandomSelectorClientActor*>(this)));
															#line 2497 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody4cont2(Void const& _,int loopDepth) 
	{
															#line 238 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		tr.reset();
															#line 2512 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		return a_body1loopBody1cont1loopBody1break4(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody4cont2(Void && _,int loopDepth) 
	{
															#line 238 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		tr.reset();
															#line 2521 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		return a_body1loopBody1cont1loopBody1break4(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody4cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody4cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state > 0) static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 0;
		static_cast<RandomSelectorClientActor*>(this)->ActorCallback< RandomSelectorClientActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1loopBody1cont1loopBody1loopBody4when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1loopBody4Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1loopBody4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1loopBody1cont1loopBody1loopBody4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1loopBody4Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1loopBody4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< RandomSelectorClientActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1loopBody1cont1loopBody1loopBody4Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1loopBody4Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1loopBody4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1loopBody1cont1loopBody1loopBody4Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 243 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		if (error.code() == error_code_commit_unknown_result)
															#line 2605 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		{
															#line 244 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_13 = tr.get(StringRef(clientID + "z/" + myRandomIDKey));
															#line 244 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 2611 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1loopBody1cont1Catch1(__when_expr_13.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1loopBody4Catch1cont1when1(__when_expr_13.get(), loopDepth); };
			static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 14;
															#line 244 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< RandomSelectorClientActor, 13, Optional<Value> >*>(static_cast<RandomSelectorClientActor*>(this)));
															#line 2616 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont1loopBody1loopBody4Catch1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody4Catch1cont1(Void && _,int loopDepth) 
	{
															#line 243 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		if (error.code() == error_code_commit_unknown_result)
															#line 2630 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		{
															#line 244 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_13 = tr.get(StringRef(clientID + "z/" + myRandomIDKey));
															#line 244 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 2636 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1loopBody1cont1Catch1(__when_expr_13.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1loopBody4Catch1cont1when1(__when_expr_13.get(), loopDepth); };
			static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 14;
															#line 244 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< RandomSelectorClientActor, 13, Optional<Value> >*>(static_cast<RandomSelectorClientActor*>(this)));
															#line 2641 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont1loopBody1loopBody4Catch1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody4Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody4Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody4Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody4Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state > 0) static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 0;
		static_cast<RandomSelectorClientActor*>(this)->ActorCallback< RandomSelectorClientActor, 12, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 12, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1loopBody1cont1loopBody1loopBody4Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 12, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1loopBody1cont1loopBody1loopBody4Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< RandomSelectorClientActor, 12, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 12);

	}
	int a_body1loopBody1cont1loopBody1loopBody4Catch1cont2(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody4cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody4Catch1cont3(Optional<Value> const& thing,int loopDepth) 
	{
															#line 245 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		if (thing.present())
															#line 2736 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		{
			return a_body1loopBody1cont1loopBody1break4(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont1loopBody1loopBody4Catch1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody4Catch1cont3(Optional<Value> && thing,int loopDepth) 
	{
															#line 245 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		if (thing.present())
															#line 2748 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		{
			return a_body1loopBody1cont1loopBody1break4(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont1loopBody1loopBody4Catch1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody4Catch1cont1when1(Optional<Value> const& thing,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody4Catch1cont3(thing, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody4Catch1cont1when1(Optional<Value> && thing,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody4Catch1cont3(std::move(thing), loopDepth);

		return loopDepth;
	}
	void a_exitChoose14() 
	{
		if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state > 0) static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 0;
		static_cast<RandomSelectorClientActor*>(this)->ActorCallback< RandomSelectorClientActor, 13, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 13, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1loopBody1cont1loopBody1loopBody4Catch1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 13, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1loopBody1cont1loopBody1loopBody4Catch1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorCallback< RandomSelectorClientActor, 13, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 13);

	}
	int a_body1loopBody1cont1loopBody1cont13(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont14(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont13(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopHead5(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1loopBody5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody5(int loopDepth) 
	{
		try {
															#line 259 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			tr.set(StringRef(clientID + "z/" + myRandomIDKey), StringRef());
															#line 260 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			tr.atomicOp(StringRef(clientID + "d/" + myKeyA), myValue, MutationRef::AppendIfFits);
															#line 261 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			StrictFuture<Void> __when_expr_14 = tr.commit();
															#line 261 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1loopBody5Catch1(actor_cancelled(), loopDepth);
															#line 2861 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1loopBody1cont1loopBody1loopBody5Catch1(__when_expr_14.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1loopBody5when1(__when_expr_14.get(), loopDepth); };
			static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 15;
															#line 261 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< RandomSelectorClientActor, 14, Void >*>(static_cast<RandomSelectorClientActor*>(this)));
															#line 2866 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1loopBody5Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1loopBody5Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1break5(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1loopBody1cont14(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody5cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopBody1loopHead5(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody5Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 265 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			error = e;
															#line 266 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			StrictFuture<Void> __when_expr_15 = tr.onError(e);
															#line 266 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 2905 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1loopBody1cont1Catch1(__when_expr_15.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1loopBody5Catch1when1(__when_expr_15.get(), loopDepth); };
			static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 16;
															#line 266 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			__when_expr_15.addCallbackAndClear(static_cast<ActorCallback< RandomSelectorClientActor, 15, Void >*>(static_cast<RandomSelectorClientActor*>(this)));
															#line 2910 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody5cont2(Void const& _,int loopDepth) 
	{
															#line 262 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		tr.reset();
															#line 2925 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		return a_body1loopBody1cont1loopBody1break5(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody5cont2(Void && _,int loopDepth) 
	{
															#line 262 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		tr.reset();
															#line 2934 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		return a_body1loopBody1cont1loopBody1break5(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody5cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody5cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose15() 
	{
		if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state > 0) static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 0;
		static_cast<RandomSelectorClientActor*>(this)->ActorCallback< RandomSelectorClientActor, 14, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 14, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1loopBody1cont1loopBody1loopBody5when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1loopBody5Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1loopBody5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 14, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1loopBody1cont1loopBody1loopBody5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1loopBody5Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1loopBody5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_error(ActorCallback< RandomSelectorClientActor, 14, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1loopBody1cont1loopBody1loopBody5Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1loopBody5Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1loopBody5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 14);

	}
	int a_body1loopBody1cont1loopBody1loopBody5Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 267 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		if (error.code() == error_code_commit_unknown_result)
															#line 3018 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		{
															#line 268 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_16 = tr.get(StringRef(clientID + "z/" + myRandomIDKey));
															#line 268 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 3024 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			if (__when_expr_16.isReady()) { if (__when_expr_16.isError()) return a_body1loopBody1cont1Catch1(__when_expr_16.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1loopBody5Catch1cont1when1(__when_expr_16.get(), loopDepth); };
			static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 17;
															#line 268 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			__when_expr_16.addCallbackAndClear(static_cast<ActorCallback< RandomSelectorClientActor, 16, Optional<Value> >*>(static_cast<RandomSelectorClientActor*>(this)));
															#line 3029 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont1loopBody1loopBody5Catch1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody5Catch1cont1(Void && _,int loopDepth) 
	{
															#line 267 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		if (error.code() == error_code_commit_unknown_result)
															#line 3043 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		{
															#line 268 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_16 = tr.get(StringRef(clientID + "z/" + myRandomIDKey));
															#line 268 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 3049 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			if (__when_expr_16.isReady()) { if (__when_expr_16.isError()) return a_body1loopBody1cont1Catch1(__when_expr_16.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1loopBody5Catch1cont1when1(__when_expr_16.get(), loopDepth); };
			static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 17;
															#line 268 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			__when_expr_16.addCallbackAndClear(static_cast<ActorCallback< RandomSelectorClientActor, 16, Optional<Value> >*>(static_cast<RandomSelectorClientActor*>(this)));
															#line 3054 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont1loopBody1loopBody5Catch1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody5Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody5Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody5Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody5Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose16() 
	{
		if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state > 0) static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 0;
		static_cast<RandomSelectorClientActor*>(this)->ActorCallback< RandomSelectorClientActor, 15, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 15, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1loopBody1cont1loopBody1loopBody5Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 15, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1loopBody1cont1loopBody1loopBody5Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_error(ActorCallback< RandomSelectorClientActor, 15, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 15);

	}
	int a_body1loopBody1cont1loopBody1loopBody5Catch1cont2(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody5cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody5Catch1cont3(Optional<Value> const& thing,int loopDepth) 
	{
															#line 269 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		if (thing.present())
															#line 3149 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		{
			return a_body1loopBody1cont1loopBody1break5(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont1loopBody1loopBody5Catch1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody5Catch1cont3(Optional<Value> && thing,int loopDepth) 
	{
															#line 269 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		if (thing.present())
															#line 3161 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		{
			return a_body1loopBody1cont1loopBody1break5(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont1loopBody1loopBody5Catch1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody5Catch1cont1when1(Optional<Value> const& thing,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody5Catch1cont3(thing, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody5Catch1cont1when1(Optional<Value> && thing,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody5Catch1cont3(std::move(thing), loopDepth);

		return loopDepth;
	}
	void a_exitChoose17() 
	{
		if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state > 0) static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 0;
		static_cast<RandomSelectorClientActor*>(this)->ActorCallback< RandomSelectorClientActor, 16, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 16, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1loopBody1cont1loopBody1loopBody5Catch1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 16, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1loopBody1cont1loopBody1loopBody5Catch1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_error(ActorCallback< RandomSelectorClientActor, 16, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 16);

	}
	int a_body1loopBody1cont1loopBody1cont15(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont13(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont16(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont15(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopHead6(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1loopBody6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody6(int loopDepth) 
	{
		try {
															#line 283 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			tr.set(StringRef(clientID + "z/" + myRandomIDKey), StringRef());
															#line 284 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			tr.atomicOp(StringRef(clientID + "d/" + myKeyA), myValue, MutationRef::And);
															#line 285 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			StrictFuture<Void> __when_expr_17 = tr.commit();
															#line 285 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1loopBody6Catch1(actor_cancelled(), loopDepth);
															#line 3274 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			if (__when_expr_17.isReady()) { if (__when_expr_17.isError()) return a_body1loopBody1cont1loopBody1loopBody6Catch1(__when_expr_17.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1loopBody6when1(__when_expr_17.get(), loopDepth); };
			static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 18;
															#line 285 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			__when_expr_17.addCallbackAndClear(static_cast<ActorCallback< RandomSelectorClientActor, 17, Void >*>(static_cast<RandomSelectorClientActor*>(this)));
															#line 3279 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1loopBody6Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1loopBody6Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1break6(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1loopBody1cont16(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody6cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopBody1loopHead6(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody6Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 289 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			error = e;
															#line 290 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			StrictFuture<Void> __when_expr_18 = tr.onError(e);
															#line 290 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 3318 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			if (__when_expr_18.isReady()) { if (__when_expr_18.isError()) return a_body1loopBody1cont1Catch1(__when_expr_18.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1loopBody6Catch1when1(__when_expr_18.get(), loopDepth); };
			static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 19;
															#line 290 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			__when_expr_18.addCallbackAndClear(static_cast<ActorCallback< RandomSelectorClientActor, 18, Void >*>(static_cast<RandomSelectorClientActor*>(this)));
															#line 3323 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody6cont2(Void const& _,int loopDepth) 
	{
															#line 286 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		tr.reset();
															#line 3338 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		return a_body1loopBody1cont1loopBody1break6(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody6cont2(Void && _,int loopDepth) 
	{
															#line 286 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		tr.reset();
															#line 3347 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		return a_body1loopBody1cont1loopBody1break6(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody6cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody6cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose18() 
	{
		if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state > 0) static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 0;
		static_cast<RandomSelectorClientActor*>(this)->ActorCallback< RandomSelectorClientActor, 17, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 17, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1loopBody1cont1loopBody1loopBody6when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1loopBody6Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1loopBody6Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 17, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1loopBody1cont1loopBody1loopBody6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1loopBody6Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1loopBody6Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_error(ActorCallback< RandomSelectorClientActor, 17, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1loopBody1cont1loopBody1loopBody6Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1loopBody6Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1loopBody6Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 17);

	}
	int a_body1loopBody1cont1loopBody1loopBody6Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 291 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		if (error.code() == error_code_commit_unknown_result)
															#line 3431 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		{
															#line 292 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_19 = tr.get(StringRef(clientID + "z/" + myRandomIDKey));
															#line 292 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 3437 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			if (__when_expr_19.isReady()) { if (__when_expr_19.isError()) return a_body1loopBody1cont1Catch1(__when_expr_19.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1loopBody6Catch1cont1when1(__when_expr_19.get(), loopDepth); };
			static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 20;
															#line 292 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			__when_expr_19.addCallbackAndClear(static_cast<ActorCallback< RandomSelectorClientActor, 19, Optional<Value> >*>(static_cast<RandomSelectorClientActor*>(this)));
															#line 3442 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont1loopBody1loopBody6Catch1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody6Catch1cont1(Void && _,int loopDepth) 
	{
															#line 291 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		if (error.code() == error_code_commit_unknown_result)
															#line 3456 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		{
															#line 292 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_19 = tr.get(StringRef(clientID + "z/" + myRandomIDKey));
															#line 292 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 3462 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			if (__when_expr_19.isReady()) { if (__when_expr_19.isError()) return a_body1loopBody1cont1Catch1(__when_expr_19.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1loopBody6Catch1cont1when1(__when_expr_19.get(), loopDepth); };
			static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 20;
															#line 292 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			__when_expr_19.addCallbackAndClear(static_cast<ActorCallback< RandomSelectorClientActor, 19, Optional<Value> >*>(static_cast<RandomSelectorClientActor*>(this)));
															#line 3467 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont1loopBody1loopBody6Catch1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody6Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody6Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody6Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody6Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose19() 
	{
		if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state > 0) static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 0;
		static_cast<RandomSelectorClientActor*>(this)->ActorCallback< RandomSelectorClientActor, 18, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 18, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1loopBody1cont1loopBody1loopBody6Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 18, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1loopBody1cont1loopBody1loopBody6Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_error(ActorCallback< RandomSelectorClientActor, 18, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 18);

	}
	int a_body1loopBody1cont1loopBody1loopBody6Catch1cont2(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody6cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody6Catch1cont3(Optional<Value> const& thing,int loopDepth) 
	{
															#line 293 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		if (thing.present())
															#line 3562 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		{
			return a_body1loopBody1cont1loopBody1break6(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont1loopBody1loopBody6Catch1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody6Catch1cont3(Optional<Value> && thing,int loopDepth) 
	{
															#line 293 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		if (thing.present())
															#line 3574 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		{
			return a_body1loopBody1cont1loopBody1break6(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont1loopBody1loopBody6Catch1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody6Catch1cont1when1(Optional<Value> const& thing,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody6Catch1cont3(thing, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody6Catch1cont1when1(Optional<Value> && thing,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody6Catch1cont3(std::move(thing), loopDepth);

		return loopDepth;
	}
	void a_exitChoose20() 
	{
		if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state > 0) static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 0;
		static_cast<RandomSelectorClientActor*>(this)->ActorCallback< RandomSelectorClientActor, 19, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 19, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1loopBody1cont1loopBody1loopBody6Catch1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 19);

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 19, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1loopBody1cont1loopBody1loopBody6Catch1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 19);

	}
	void a_callback_error(ActorCallback< RandomSelectorClientActor, 19, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 19);

	}
	int a_body1loopBody1cont1loopBody1cont17(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont15(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont18(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont17(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopHead7(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1loopBody7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody7(int loopDepth) 
	{
		try {
															#line 307 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			tr.set(StringRef(clientID + "z/" + myRandomIDKey), StringRef());
															#line 308 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			tr.atomicOp(StringRef(clientID + "d/" + myKeyA), myValue, MutationRef::Or);
															#line 309 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			StrictFuture<Void> __when_expr_20 = tr.commit();
															#line 309 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1loopBody7Catch1(actor_cancelled(), loopDepth);
															#line 3687 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			if (__when_expr_20.isReady()) { if (__when_expr_20.isError()) return a_body1loopBody1cont1loopBody1loopBody7Catch1(__when_expr_20.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1loopBody7when1(__when_expr_20.get(), loopDepth); };
			static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 21;
															#line 309 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			__when_expr_20.addCallbackAndClear(static_cast<ActorCallback< RandomSelectorClientActor, 20, Void >*>(static_cast<RandomSelectorClientActor*>(this)));
															#line 3692 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1loopBody7Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1loopBody7Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1break7(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1loopBody1cont18(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody7cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopBody1loopHead7(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody7Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 313 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			error = e;
															#line 314 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			StrictFuture<Void> __when_expr_21 = tr.onError(e);
															#line 314 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 3731 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			if (__when_expr_21.isReady()) { if (__when_expr_21.isError()) return a_body1loopBody1cont1Catch1(__when_expr_21.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1loopBody7Catch1when1(__when_expr_21.get(), loopDepth); };
			static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 22;
															#line 314 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			__when_expr_21.addCallbackAndClear(static_cast<ActorCallback< RandomSelectorClientActor, 21, Void >*>(static_cast<RandomSelectorClientActor*>(this)));
															#line 3736 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody7cont2(Void const& _,int loopDepth) 
	{
															#line 310 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		tr.reset();
															#line 3751 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		return a_body1loopBody1cont1loopBody1break7(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody7cont2(Void && _,int loopDepth) 
	{
															#line 310 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		tr.reset();
															#line 3760 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		return a_body1loopBody1cont1loopBody1break7(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody7cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody7cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose21() 
	{
		if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state > 0) static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 0;
		static_cast<RandomSelectorClientActor*>(this)->ActorCallback< RandomSelectorClientActor, 20, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 20, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose21();
		try {
			a_body1loopBody1cont1loopBody1loopBody7when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1loopBody7Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1loopBody7Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 20);

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 20, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose21();
		try {
			a_body1loopBody1cont1loopBody1loopBody7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1loopBody7Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1loopBody7Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 20);

	}
	void a_callback_error(ActorCallback< RandomSelectorClientActor, 20, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose21();
		try {
			a_body1loopBody1cont1loopBody1loopBody7Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1loopBody7Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1loopBody7Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 20);

	}
	int a_body1loopBody1cont1loopBody1loopBody7Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 315 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		if (error.code() == error_code_commit_unknown_result)
															#line 3844 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		{
															#line 316 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_22 = tr.get(StringRef(clientID + "z/" + myRandomIDKey));
															#line 316 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 3850 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			if (__when_expr_22.isReady()) { if (__when_expr_22.isError()) return a_body1loopBody1cont1Catch1(__when_expr_22.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1loopBody7Catch1cont1when1(__when_expr_22.get(), loopDepth); };
			static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 23;
															#line 316 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			__when_expr_22.addCallbackAndClear(static_cast<ActorCallback< RandomSelectorClientActor, 22, Optional<Value> >*>(static_cast<RandomSelectorClientActor*>(this)));
															#line 3855 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont1loopBody1loopBody7Catch1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody7Catch1cont1(Void && _,int loopDepth) 
	{
															#line 315 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		if (error.code() == error_code_commit_unknown_result)
															#line 3869 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		{
															#line 316 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_22 = tr.get(StringRef(clientID + "z/" + myRandomIDKey));
															#line 316 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 3875 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			if (__when_expr_22.isReady()) { if (__when_expr_22.isError()) return a_body1loopBody1cont1Catch1(__when_expr_22.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1loopBody7Catch1cont1when1(__when_expr_22.get(), loopDepth); };
			static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 23;
															#line 316 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			__when_expr_22.addCallbackAndClear(static_cast<ActorCallback< RandomSelectorClientActor, 22, Optional<Value> >*>(static_cast<RandomSelectorClientActor*>(this)));
															#line 3880 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont1loopBody1loopBody7Catch1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody7Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody7Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody7Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody7Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose22() 
	{
		if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state > 0) static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 0;
		static_cast<RandomSelectorClientActor*>(this)->ActorCallback< RandomSelectorClientActor, 21, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 21, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 21);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose22();
		try {
			a_body1loopBody1cont1loopBody1loopBody7Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 21);

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 21, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 21);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose22();
		try {
			a_body1loopBody1cont1loopBody1loopBody7Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 21);

	}
	void a_callback_error(ActorCallback< RandomSelectorClientActor, 21, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 21);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose22();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 21);

	}
	int a_body1loopBody1cont1loopBody1loopBody7Catch1cont2(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody7cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody7Catch1cont3(Optional<Value> const& thing,int loopDepth) 
	{
															#line 317 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		if (thing.present())
															#line 3975 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		{
			return a_body1loopBody1cont1loopBody1break7(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont1loopBody1loopBody7Catch1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody7Catch1cont3(Optional<Value> && thing,int loopDepth) 
	{
															#line 317 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		if (thing.present())
															#line 3987 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		{
			return a_body1loopBody1cont1loopBody1break7(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont1loopBody1loopBody7Catch1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody7Catch1cont1when1(Optional<Value> const& thing,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody7Catch1cont3(thing, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody7Catch1cont1when1(Optional<Value> && thing,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody7Catch1cont3(std::move(thing), loopDepth);

		return loopDepth;
	}
	void a_exitChoose23() 
	{
		if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state > 0) static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 0;
		static_cast<RandomSelectorClientActor*>(this)->ActorCallback< RandomSelectorClientActor, 22, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 22, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 22);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose23();
		try {
			a_body1loopBody1cont1loopBody1loopBody7Catch1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 22);

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 22, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 22);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose23();
		try {
			a_body1loopBody1cont1loopBody1loopBody7Catch1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 22);

	}
	void a_callback_error(ActorCallback< RandomSelectorClientActor, 22, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 22);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose23();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 22);

	}
	int a_body1loopBody1cont1loopBody1cont19(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont17(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont20(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont19(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopHead8(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1loopBody8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody8(int loopDepth) 
	{
		try {
															#line 331 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			tr.set(StringRef(clientID + "z/" + myRandomIDKey), StringRef());
															#line 332 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			tr.atomicOp(StringRef(clientID + "d/" + myKeyA), myValue, MutationRef::Xor);
															#line 333 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			StrictFuture<Void> __when_expr_23 = tr.commit();
															#line 333 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1loopBody8Catch1(actor_cancelled(), loopDepth);
															#line 4100 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			if (__when_expr_23.isReady()) { if (__when_expr_23.isError()) return a_body1loopBody1cont1loopBody1loopBody8Catch1(__when_expr_23.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1loopBody8when1(__when_expr_23.get(), loopDepth); };
			static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 24;
															#line 333 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			__when_expr_23.addCallbackAndClear(static_cast<ActorCallback< RandomSelectorClientActor, 23, Void >*>(static_cast<RandomSelectorClientActor*>(this)));
															#line 4105 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1loopBody8Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1loopBody8Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1break8(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1loopBody1cont20(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody8cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopBody1loopHead8(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody8Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 337 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			error = e;
															#line 338 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			StrictFuture<Void> __when_expr_24 = tr.onError(e);
															#line 338 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 4144 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			if (__when_expr_24.isReady()) { if (__when_expr_24.isError()) return a_body1loopBody1cont1Catch1(__when_expr_24.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1loopBody8Catch1when1(__when_expr_24.get(), loopDepth); };
			static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 25;
															#line 338 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			__when_expr_24.addCallbackAndClear(static_cast<ActorCallback< RandomSelectorClientActor, 24, Void >*>(static_cast<RandomSelectorClientActor*>(this)));
															#line 4149 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody8cont2(Void const& _,int loopDepth) 
	{
															#line 334 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		tr.reset();
															#line 4164 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		return a_body1loopBody1cont1loopBody1break8(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody8cont2(Void && _,int loopDepth) 
	{
															#line 334 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		tr.reset();
															#line 4173 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		return a_body1loopBody1cont1loopBody1break8(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody8cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody8cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose24() 
	{
		if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state > 0) static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 0;
		static_cast<RandomSelectorClientActor*>(this)->ActorCallback< RandomSelectorClientActor, 23, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 23, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 23);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose24();
		try {
			a_body1loopBody1cont1loopBody1loopBody8when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1loopBody8Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1loopBody8Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 23);

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 23, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 23);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose24();
		try {
			a_body1loopBody1cont1loopBody1loopBody8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1loopBody8Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1loopBody8Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 23);

	}
	void a_callback_error(ActorCallback< RandomSelectorClientActor, 23, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 23);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose24();
		try {
			a_body1loopBody1cont1loopBody1loopBody8Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1loopBody8Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1loopBody8Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 23);

	}
	int a_body1loopBody1cont1loopBody1loopBody8Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 339 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		if (error.code() == error_code_commit_unknown_result)
															#line 4257 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		{
															#line 340 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_25 = tr.get(StringRef(clientID + "z/" + myRandomIDKey));
															#line 340 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 4263 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			if (__when_expr_25.isReady()) { if (__when_expr_25.isError()) return a_body1loopBody1cont1Catch1(__when_expr_25.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1loopBody8Catch1cont1when1(__when_expr_25.get(), loopDepth); };
			static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 26;
															#line 340 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			__when_expr_25.addCallbackAndClear(static_cast<ActorCallback< RandomSelectorClientActor, 25, Optional<Value> >*>(static_cast<RandomSelectorClientActor*>(this)));
															#line 4268 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont1loopBody1loopBody8Catch1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody8Catch1cont1(Void && _,int loopDepth) 
	{
															#line 339 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		if (error.code() == error_code_commit_unknown_result)
															#line 4282 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		{
															#line 340 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_25 = tr.get(StringRef(clientID + "z/" + myRandomIDKey));
															#line 340 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 4288 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			if (__when_expr_25.isReady()) { if (__when_expr_25.isError()) return a_body1loopBody1cont1Catch1(__when_expr_25.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1loopBody8Catch1cont1when1(__when_expr_25.get(), loopDepth); };
			static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 26;
															#line 340 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			__when_expr_25.addCallbackAndClear(static_cast<ActorCallback< RandomSelectorClientActor, 25, Optional<Value> >*>(static_cast<RandomSelectorClientActor*>(this)));
															#line 4293 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont1loopBody1loopBody8Catch1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody8Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody8Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody8Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody8Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose25() 
	{
		if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state > 0) static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 0;
		static_cast<RandomSelectorClientActor*>(this)->ActorCallback< RandomSelectorClientActor, 24, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 24, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 24);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose25();
		try {
			a_body1loopBody1cont1loopBody1loopBody8Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 24);

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 24, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 24);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose25();
		try {
			a_body1loopBody1cont1loopBody1loopBody8Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 24);

	}
	void a_callback_error(ActorCallback< RandomSelectorClientActor, 24, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 24);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose25();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 24);

	}
	int a_body1loopBody1cont1loopBody1loopBody8Catch1cont2(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody8cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody8Catch1cont3(Optional<Value> const& thing,int loopDepth) 
	{
															#line 341 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		if (thing.present())
															#line 4388 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		{
			return a_body1loopBody1cont1loopBody1break8(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont1loopBody1loopBody8Catch1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody8Catch1cont3(Optional<Value> && thing,int loopDepth) 
	{
															#line 341 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		if (thing.present())
															#line 4400 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		{
			return a_body1loopBody1cont1loopBody1break8(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont1loopBody1loopBody8Catch1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody8Catch1cont1when1(Optional<Value> const& thing,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody8Catch1cont3(thing, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody8Catch1cont1when1(Optional<Value> && thing,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody8Catch1cont3(std::move(thing), loopDepth);

		return loopDepth;
	}
	void a_exitChoose26() 
	{
		if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state > 0) static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 0;
		static_cast<RandomSelectorClientActor*>(this)->ActorCallback< RandomSelectorClientActor, 25, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 25, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 25);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose26();
		try {
			a_body1loopBody1cont1loopBody1loopBody8Catch1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 25);

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 25, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 25);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose26();
		try {
			a_body1loopBody1cont1loopBody1loopBody8Catch1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 25);

	}
	void a_callback_error(ActorCallback< RandomSelectorClientActor, 25, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 25);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose26();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 25);

	}
	int a_body1loopBody1cont1loopBody1cont21(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont19(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont22(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont21(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopHead9(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1loopBody9(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody9(int loopDepth) 
	{
		try {
															#line 355 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			tr.set(StringRef(clientID + "z/" + myRandomIDKey), StringRef());
															#line 356 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			tr.atomicOp(StringRef(clientID + "d/" + myKeyA), myValue, MutationRef::Max);
															#line 357 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			StrictFuture<Void> __when_expr_26 = tr.commit();
															#line 357 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1loopBody9Catch1(actor_cancelled(), loopDepth);
															#line 4513 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			if (__when_expr_26.isReady()) { if (__when_expr_26.isError()) return a_body1loopBody1cont1loopBody1loopBody9Catch1(__when_expr_26.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1loopBody9when1(__when_expr_26.get(), loopDepth); };
			static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 27;
															#line 357 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			__when_expr_26.addCallbackAndClear(static_cast<ActorCallback< RandomSelectorClientActor, 26, Void >*>(static_cast<RandomSelectorClientActor*>(this)));
															#line 4518 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1loopBody9Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1loopBody9Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1break9(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1loopBody1cont22(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody9cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopBody1loopHead9(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody9Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 361 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			error = e;
															#line 362 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			StrictFuture<Void> __when_expr_27 = tr.onError(e);
															#line 362 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 4557 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			if (__when_expr_27.isReady()) { if (__when_expr_27.isError()) return a_body1loopBody1cont1Catch1(__when_expr_27.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1loopBody9Catch1when1(__when_expr_27.get(), loopDepth); };
			static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 28;
															#line 362 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			__when_expr_27.addCallbackAndClear(static_cast<ActorCallback< RandomSelectorClientActor, 27, Void >*>(static_cast<RandomSelectorClientActor*>(this)));
															#line 4562 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody9cont2(Void const& _,int loopDepth) 
	{
															#line 358 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		tr.reset();
															#line 4577 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		return a_body1loopBody1cont1loopBody1break9(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody9cont2(Void && _,int loopDepth) 
	{
															#line 358 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		tr.reset();
															#line 4586 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		return a_body1loopBody1cont1loopBody1break9(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody9cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody9cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose27() 
	{
		if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state > 0) static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 0;
		static_cast<RandomSelectorClientActor*>(this)->ActorCallback< RandomSelectorClientActor, 26, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 26, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 26);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose27();
		try {
			a_body1loopBody1cont1loopBody1loopBody9when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1loopBody9Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1loopBody9Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 26);

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 26, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 26);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose27();
		try {
			a_body1loopBody1cont1loopBody1loopBody9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1loopBody9Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1loopBody9Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 26);

	}
	void a_callback_error(ActorCallback< RandomSelectorClientActor, 26, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 26);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose27();
		try {
			a_body1loopBody1cont1loopBody1loopBody9Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1loopBody9Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1loopBody9Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 26);

	}
	int a_body1loopBody1cont1loopBody1loopBody9Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 363 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		if (error.code() == error_code_commit_unknown_result)
															#line 4670 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		{
															#line 364 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_28 = tr.get(StringRef(clientID + "z/" + myRandomIDKey));
															#line 364 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 4676 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			if (__when_expr_28.isReady()) { if (__when_expr_28.isError()) return a_body1loopBody1cont1Catch1(__when_expr_28.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1loopBody9Catch1cont1when1(__when_expr_28.get(), loopDepth); };
			static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 29;
															#line 364 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			__when_expr_28.addCallbackAndClear(static_cast<ActorCallback< RandomSelectorClientActor, 28, Optional<Value> >*>(static_cast<RandomSelectorClientActor*>(this)));
															#line 4681 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont1loopBody1loopBody9Catch1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody9Catch1cont1(Void && _,int loopDepth) 
	{
															#line 363 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		if (error.code() == error_code_commit_unknown_result)
															#line 4695 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		{
															#line 364 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_28 = tr.get(StringRef(clientID + "z/" + myRandomIDKey));
															#line 364 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 4701 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			if (__when_expr_28.isReady()) { if (__when_expr_28.isError()) return a_body1loopBody1cont1Catch1(__when_expr_28.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1loopBody9Catch1cont1when1(__when_expr_28.get(), loopDepth); };
			static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 29;
															#line 364 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			__when_expr_28.addCallbackAndClear(static_cast<ActorCallback< RandomSelectorClientActor, 28, Optional<Value> >*>(static_cast<RandomSelectorClientActor*>(this)));
															#line 4706 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont1loopBody1loopBody9Catch1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody9Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody9Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody9Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody9Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose28() 
	{
		if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state > 0) static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 0;
		static_cast<RandomSelectorClientActor*>(this)->ActorCallback< RandomSelectorClientActor, 27, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 27, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 27);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose28();
		try {
			a_body1loopBody1cont1loopBody1loopBody9Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 27);

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 27, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 27);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose28();
		try {
			a_body1loopBody1cont1loopBody1loopBody9Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 27);

	}
	void a_callback_error(ActorCallback< RandomSelectorClientActor, 27, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 27);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose28();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 27);

	}
	int a_body1loopBody1cont1loopBody1loopBody9Catch1cont2(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody9cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody9Catch1cont3(Optional<Value> const& thing,int loopDepth) 
	{
															#line 365 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		if (thing.present())
															#line 4801 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		{
			return a_body1loopBody1cont1loopBody1break9(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont1loopBody1loopBody9Catch1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody9Catch1cont3(Optional<Value> && thing,int loopDepth) 
	{
															#line 365 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		if (thing.present())
															#line 4813 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		{
			return a_body1loopBody1cont1loopBody1break9(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont1loopBody1loopBody9Catch1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody9Catch1cont1when1(Optional<Value> const& thing,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody9Catch1cont3(thing, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody9Catch1cont1when1(Optional<Value> && thing,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody9Catch1cont3(std::move(thing), loopDepth);

		return loopDepth;
	}
	void a_exitChoose29() 
	{
		if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state > 0) static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 0;
		static_cast<RandomSelectorClientActor*>(this)->ActorCallback< RandomSelectorClientActor, 28, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 28, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 28);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose29();
		try {
			a_body1loopBody1cont1loopBody1loopBody9Catch1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 28);

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 28, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 28);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose29();
		try {
			a_body1loopBody1cont1loopBody1loopBody9Catch1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 28);

	}
	void a_callback_error(ActorCallback< RandomSelectorClientActor, 28, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 28);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose29();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 28);

	}
	int a_body1loopBody1cont1loopBody1cont23(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont21(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont24(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont23(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopHead10(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1loopBody10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody10(int loopDepth) 
	{
		try {
															#line 379 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			tr.set(StringRef(clientID + "z/" + myRandomIDKey), StringRef());
															#line 380 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			tr.atomicOp(StringRef(clientID + "d/" + myKeyA), myValue, MutationRef::Min);
															#line 381 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			StrictFuture<Void> __when_expr_29 = tr.commit();
															#line 381 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1loopBody10Catch1(actor_cancelled(), loopDepth);
															#line 4926 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			if (__when_expr_29.isReady()) { if (__when_expr_29.isError()) return a_body1loopBody1cont1loopBody1loopBody10Catch1(__when_expr_29.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1loopBody10when1(__when_expr_29.get(), loopDepth); };
			static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 30;
															#line 381 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			__when_expr_29.addCallbackAndClear(static_cast<ActorCallback< RandomSelectorClientActor, 29, Void >*>(static_cast<RandomSelectorClientActor*>(this)));
															#line 4931 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1loopBody10Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1loopBody10Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1break10(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1loopBody1cont24(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody10cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopBody1loopHead10(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody10Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 385 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			error = e;
															#line 386 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			StrictFuture<Void> __when_expr_30 = tr.onError(e);
															#line 386 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 4970 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			if (__when_expr_30.isReady()) { if (__when_expr_30.isError()) return a_body1loopBody1cont1Catch1(__when_expr_30.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1loopBody10Catch1when1(__when_expr_30.get(), loopDepth); };
			static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 31;
															#line 386 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			__when_expr_30.addCallbackAndClear(static_cast<ActorCallback< RandomSelectorClientActor, 30, Void >*>(static_cast<RandomSelectorClientActor*>(this)));
															#line 4975 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody10cont2(Void const& _,int loopDepth) 
	{
															#line 382 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		tr.reset();
															#line 4990 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		return a_body1loopBody1cont1loopBody1break10(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody10cont2(Void && _,int loopDepth) 
	{
															#line 382 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		tr.reset();
															#line 4999 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		return a_body1loopBody1cont1loopBody1break10(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody10when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody10cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody10when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody10cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose30() 
	{
		if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state > 0) static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 0;
		static_cast<RandomSelectorClientActor*>(this)->ActorCallback< RandomSelectorClientActor, 29, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 29, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 29);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose30();
		try {
			a_body1loopBody1cont1loopBody1loopBody10when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1loopBody10Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1loopBody10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 29);

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 29, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 29);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose30();
		try {
			a_body1loopBody1cont1loopBody1loopBody10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1loopBody10Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1loopBody10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 29);

	}
	void a_callback_error(ActorCallback< RandomSelectorClientActor, 29, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 29);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose30();
		try {
			a_body1loopBody1cont1loopBody1loopBody10Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1loopBody10Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1loopBody10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 29);

	}
	int a_body1loopBody1cont1loopBody1loopBody10Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 387 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		if (error.code() == error_code_commit_unknown_result)
															#line 5083 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		{
															#line 388 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_31 = tr.get(StringRef(clientID + "z/" + myRandomIDKey));
															#line 388 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 5089 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			if (__when_expr_31.isReady()) { if (__when_expr_31.isError()) return a_body1loopBody1cont1Catch1(__when_expr_31.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1loopBody10Catch1cont1when1(__when_expr_31.get(), loopDepth); };
			static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 32;
															#line 388 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			__when_expr_31.addCallbackAndClear(static_cast<ActorCallback< RandomSelectorClientActor, 31, Optional<Value> >*>(static_cast<RandomSelectorClientActor*>(this)));
															#line 5094 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont1loopBody1loopBody10Catch1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody10Catch1cont1(Void && _,int loopDepth) 
	{
															#line 387 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		if (error.code() == error_code_commit_unknown_result)
															#line 5108 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		{
															#line 388 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_31 = tr.get(StringRef(clientID + "z/" + myRandomIDKey));
															#line 388 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 5114 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			if (__when_expr_31.isReady()) { if (__when_expr_31.isError()) return a_body1loopBody1cont1Catch1(__when_expr_31.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1loopBody10Catch1cont1when1(__when_expr_31.get(), loopDepth); };
			static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 32;
															#line 388 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			__when_expr_31.addCallbackAndClear(static_cast<ActorCallback< RandomSelectorClientActor, 31, Optional<Value> >*>(static_cast<RandomSelectorClientActor*>(this)));
															#line 5119 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont1loopBody1loopBody10Catch1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody10Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody10Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody10Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody10Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose31() 
	{
		if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state > 0) static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 0;
		static_cast<RandomSelectorClientActor*>(this)->ActorCallback< RandomSelectorClientActor, 30, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 30, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 30);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose31();
		try {
			a_body1loopBody1cont1loopBody1loopBody10Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 30);

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 30, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 30);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose31();
		try {
			a_body1loopBody1cont1loopBody1loopBody10Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 30);

	}
	void a_callback_error(ActorCallback< RandomSelectorClientActor, 30, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 30);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose31();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 30);

	}
	int a_body1loopBody1cont1loopBody1loopBody10Catch1cont2(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody10Catch1cont3(Optional<Value> const& thing,int loopDepth) 
	{
															#line 389 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		if (thing.present())
															#line 5214 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		{
			return a_body1loopBody1cont1loopBody1break10(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont1loopBody1loopBody10Catch1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody10Catch1cont3(Optional<Value> && thing,int loopDepth) 
	{
															#line 389 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		if (thing.present())
															#line 5226 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		{
			return a_body1loopBody1cont1loopBody1break10(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont1loopBody1loopBody10Catch1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody10Catch1cont1when1(Optional<Value> const& thing,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody10Catch1cont3(thing, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody10Catch1cont1when1(Optional<Value> && thing,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody10Catch1cont3(std::move(thing), loopDepth);

		return loopDepth;
	}
	void a_exitChoose32() 
	{
		if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state > 0) static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 0;
		static_cast<RandomSelectorClientActor*>(this)->ActorCallback< RandomSelectorClientActor, 31, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 31, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 31);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose32();
		try {
			a_body1loopBody1cont1loopBody1loopBody10Catch1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 31);

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 31, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 31);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose32();
		try {
			a_body1loopBody1cont1loopBody1loopBody10Catch1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 31);

	}
	void a_callback_error(ActorCallback< RandomSelectorClientActor, 31, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 31);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose32();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 31);

	}
	int a_body1loopBody1cont1loopBody1cont25(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont23(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont26(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont25(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopHead11(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1loopBody11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody11(int loopDepth) 
	{
		try {
															#line 403 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			tr.set(StringRef(clientID + "z/" + myRandomIDKey), StringRef());
															#line 404 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			tr.atomicOp(StringRef(clientID + "d/" + myKeyA), myValue, MutationRef::ByteMin);
															#line 405 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			StrictFuture<Void> __when_expr_32 = tr.commit();
															#line 405 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1loopBody11Catch1(actor_cancelled(), loopDepth);
															#line 5339 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			if (__when_expr_32.isReady()) { if (__when_expr_32.isError()) return a_body1loopBody1cont1loopBody1loopBody11Catch1(__when_expr_32.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1loopBody11when1(__when_expr_32.get(), loopDepth); };
			static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 33;
															#line 405 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			__when_expr_32.addCallbackAndClear(static_cast<ActorCallback< RandomSelectorClientActor, 32, Void >*>(static_cast<RandomSelectorClientActor*>(this)));
															#line 5344 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1loopBody11Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1loopBody11Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1break11(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1loopBody1cont26(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody11cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopBody1loopHead11(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody11Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 409 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			error = e;
															#line 410 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			StrictFuture<Void> __when_expr_33 = tr.onError(e);
															#line 410 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 5383 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			if (__when_expr_33.isReady()) { if (__when_expr_33.isError()) return a_body1loopBody1cont1Catch1(__when_expr_33.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1loopBody11Catch1when1(__when_expr_33.get(), loopDepth); };
			static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 34;
															#line 410 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			__when_expr_33.addCallbackAndClear(static_cast<ActorCallback< RandomSelectorClientActor, 33, Void >*>(static_cast<RandomSelectorClientActor*>(this)));
															#line 5388 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody11cont2(Void const& _,int loopDepth) 
	{
															#line 406 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		tr.reset();
															#line 5403 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		return a_body1loopBody1cont1loopBody1break11(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody11cont2(Void && _,int loopDepth) 
	{
															#line 406 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		tr.reset();
															#line 5412 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		return a_body1loopBody1cont1loopBody1break11(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody11when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody11cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody11when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody11cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose33() 
	{
		if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state > 0) static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 0;
		static_cast<RandomSelectorClientActor*>(this)->ActorCallback< RandomSelectorClientActor, 32, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 32, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 32);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose33();
		try {
			a_body1loopBody1cont1loopBody1loopBody11when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1loopBody11Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1loopBody11Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 32);

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 32, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 32);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose33();
		try {
			a_body1loopBody1cont1loopBody1loopBody11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1loopBody11Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1loopBody11Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 32);

	}
	void a_callback_error(ActorCallback< RandomSelectorClientActor, 32, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 32);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose33();
		try {
			a_body1loopBody1cont1loopBody1loopBody11Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1loopBody11Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1loopBody11Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 32);

	}
	int a_body1loopBody1cont1loopBody1loopBody11Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 411 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		if (error.code() == error_code_commit_unknown_result)
															#line 5496 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		{
															#line 412 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_34 = tr.get(StringRef(clientID + "z/" + myRandomIDKey));
															#line 412 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 5502 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			if (__when_expr_34.isReady()) { if (__when_expr_34.isError()) return a_body1loopBody1cont1Catch1(__when_expr_34.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1loopBody11Catch1cont1when1(__when_expr_34.get(), loopDepth); };
			static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 35;
															#line 412 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			__when_expr_34.addCallbackAndClear(static_cast<ActorCallback< RandomSelectorClientActor, 34, Optional<Value> >*>(static_cast<RandomSelectorClientActor*>(this)));
															#line 5507 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont1loopBody1loopBody11Catch1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody11Catch1cont1(Void && _,int loopDepth) 
	{
															#line 411 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		if (error.code() == error_code_commit_unknown_result)
															#line 5521 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		{
															#line 412 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_34 = tr.get(StringRef(clientID + "z/" + myRandomIDKey));
															#line 412 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 5527 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			if (__when_expr_34.isReady()) { if (__when_expr_34.isError()) return a_body1loopBody1cont1Catch1(__when_expr_34.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1loopBody11Catch1cont1when1(__when_expr_34.get(), loopDepth); };
			static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 35;
															#line 412 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			__when_expr_34.addCallbackAndClear(static_cast<ActorCallback< RandomSelectorClientActor, 34, Optional<Value> >*>(static_cast<RandomSelectorClientActor*>(this)));
															#line 5532 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont1loopBody1loopBody11Catch1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody11Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody11Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody11Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody11Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose34() 
	{
		if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state > 0) static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 0;
		static_cast<RandomSelectorClientActor*>(this)->ActorCallback< RandomSelectorClientActor, 33, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 33, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 33);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose34();
		try {
			a_body1loopBody1cont1loopBody1loopBody11Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 33);

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 33, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 33);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose34();
		try {
			a_body1loopBody1cont1loopBody1loopBody11Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 33);

	}
	void a_callback_error(ActorCallback< RandomSelectorClientActor, 33, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 33);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose34();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 33);

	}
	int a_body1loopBody1cont1loopBody1loopBody11Catch1cont2(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody11cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody11Catch1cont3(Optional<Value> const& thing,int loopDepth) 
	{
															#line 413 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		if (thing.present())
															#line 5627 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		{
			return a_body1loopBody1cont1loopBody1break11(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont1loopBody1loopBody11Catch1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody11Catch1cont3(Optional<Value> && thing,int loopDepth) 
	{
															#line 413 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		if (thing.present())
															#line 5639 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		{
			return a_body1loopBody1cont1loopBody1break11(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont1loopBody1loopBody11Catch1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody11Catch1cont1when1(Optional<Value> const& thing,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody11Catch1cont3(thing, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody11Catch1cont1when1(Optional<Value> && thing,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody11Catch1cont3(std::move(thing), loopDepth);

		return loopDepth;
	}
	void a_exitChoose35() 
	{
		if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state > 0) static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 0;
		static_cast<RandomSelectorClientActor*>(this)->ActorCallback< RandomSelectorClientActor, 34, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 34, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 34);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose35();
		try {
			a_body1loopBody1cont1loopBody1loopBody11Catch1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 34);

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 34, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 34);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose35();
		try {
			a_body1loopBody1cont1loopBody1loopBody11Catch1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 34);

	}
	void a_callback_error(ActorCallback< RandomSelectorClientActor, 34, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 34);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose35();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 34);

	}
	int a_body1loopBody1cont1loopBody1cont27(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont25(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont28(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont27(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopHead12(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1loopBody12(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody12(int loopDepth) 
	{
		try {
															#line 427 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			tr.set(StringRef(clientID + "z/" + myRandomIDKey), StringRef());
															#line 428 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			tr.atomicOp(StringRef(clientID + "d/" + myKeyA), myValue, MutationRef::ByteMax);
															#line 429 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			StrictFuture<Void> __when_expr_35 = tr.commit();
															#line 429 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1loopBody12Catch1(actor_cancelled(), loopDepth);
															#line 5752 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			if (__when_expr_35.isReady()) { if (__when_expr_35.isError()) return a_body1loopBody1cont1loopBody1loopBody12Catch1(__when_expr_35.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1loopBody12when1(__when_expr_35.get(), loopDepth); };
			static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 36;
															#line 429 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			__when_expr_35.addCallbackAndClear(static_cast<ActorCallback< RandomSelectorClientActor, 35, Void >*>(static_cast<RandomSelectorClientActor*>(this)));
															#line 5757 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1loopBody12Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1loopBody12Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1break12(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1loopBody1cont28(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody12cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopBody1loopHead12(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody12Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 433 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			error = e;
															#line 434 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			StrictFuture<Void> __when_expr_36 = tr.onError(e);
															#line 434 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 5796 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			if (__when_expr_36.isReady()) { if (__when_expr_36.isError()) return a_body1loopBody1cont1Catch1(__when_expr_36.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1loopBody12Catch1when1(__when_expr_36.get(), loopDepth); };
			static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 37;
															#line 434 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			__when_expr_36.addCallbackAndClear(static_cast<ActorCallback< RandomSelectorClientActor, 36, Void >*>(static_cast<RandomSelectorClientActor*>(this)));
															#line 5801 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody12cont2(Void const& _,int loopDepth) 
	{
															#line 430 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		tr.reset();
															#line 5816 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		return a_body1loopBody1cont1loopBody1break12(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody12cont2(Void && _,int loopDepth) 
	{
															#line 430 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		tr.reset();
															#line 5825 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		return a_body1loopBody1cont1loopBody1break12(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody12when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody12cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody12when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody12cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose36() 
	{
		if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state > 0) static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 0;
		static_cast<RandomSelectorClientActor*>(this)->ActorCallback< RandomSelectorClientActor, 35, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 35, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 35);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose36();
		try {
			a_body1loopBody1cont1loopBody1loopBody12when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1loopBody12Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1loopBody12Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 35);

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 35, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 35);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose36();
		try {
			a_body1loopBody1cont1loopBody1loopBody12when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1loopBody12Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1loopBody12Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 35);

	}
	void a_callback_error(ActorCallback< RandomSelectorClientActor, 35, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 35);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose36();
		try {
			a_body1loopBody1cont1loopBody1loopBody12Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1loopBody12Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1loopBody12Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 35);

	}
	int a_body1loopBody1cont1loopBody1loopBody12Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 435 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		if (error.code() == error_code_commit_unknown_result)
															#line 5909 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		{
															#line 436 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_37 = tr.get(StringRef(clientID + "z/" + myRandomIDKey));
															#line 436 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 5915 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			if (__when_expr_37.isReady()) { if (__when_expr_37.isError()) return a_body1loopBody1cont1Catch1(__when_expr_37.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1loopBody12Catch1cont1when1(__when_expr_37.get(), loopDepth); };
			static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 38;
															#line 436 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			__when_expr_37.addCallbackAndClear(static_cast<ActorCallback< RandomSelectorClientActor, 37, Optional<Value> >*>(static_cast<RandomSelectorClientActor*>(this)));
															#line 5920 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont1loopBody1loopBody12Catch1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody12Catch1cont1(Void && _,int loopDepth) 
	{
															#line 435 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		if (error.code() == error_code_commit_unknown_result)
															#line 5934 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		{
															#line 436 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_37 = tr.get(StringRef(clientID + "z/" + myRandomIDKey));
															#line 436 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 5940 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			if (__when_expr_37.isReady()) { if (__when_expr_37.isError()) return a_body1loopBody1cont1Catch1(__when_expr_37.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1loopBody12Catch1cont1when1(__when_expr_37.get(), loopDepth); };
			static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 38;
															#line 436 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			__when_expr_37.addCallbackAndClear(static_cast<ActorCallback< RandomSelectorClientActor, 37, Optional<Value> >*>(static_cast<RandomSelectorClientActor*>(this)));
															#line 5945 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont1loopBody1loopBody12Catch1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody12Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody12Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody12Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody12Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose37() 
	{
		if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state > 0) static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 0;
		static_cast<RandomSelectorClientActor*>(this)->ActorCallback< RandomSelectorClientActor, 36, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 36, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 36);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose37();
		try {
			a_body1loopBody1cont1loopBody1loopBody12Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 36);

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 36, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 36);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose37();
		try {
			a_body1loopBody1cont1loopBody1loopBody12Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 36);

	}
	void a_callback_error(ActorCallback< RandomSelectorClientActor, 36, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 36);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose37();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 36);

	}
	int a_body1loopBody1cont1loopBody1loopBody12Catch1cont2(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody12cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody12Catch1cont3(Optional<Value> const& thing,int loopDepth) 
	{
															#line 437 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		if (thing.present())
															#line 6040 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		{
			return a_body1loopBody1cont1loopBody1break12(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont1loopBody1loopBody12Catch1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody12Catch1cont3(Optional<Value> && thing,int loopDepth) 
	{
															#line 437 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		if (thing.present())
															#line 6052 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		{
			return a_body1loopBody1cont1loopBody1break12(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont1loopBody1loopBody12Catch1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody12Catch1cont1when1(Optional<Value> const& thing,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody12Catch1cont3(thing, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody12Catch1cont1when1(Optional<Value> && thing,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody12Catch1cont3(std::move(thing), loopDepth);

		return loopDepth;
	}
	void a_exitChoose38() 
	{
		if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state > 0) static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 0;
		static_cast<RandomSelectorClientActor*>(this)->ActorCallback< RandomSelectorClientActor, 37, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 37, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 37);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose38();
		try {
			a_body1loopBody1cont1loopBody1loopBody12Catch1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 37);

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 37, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 37);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose38();
		try {
			a_body1loopBody1cont1loopBody1loopBody12Catch1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 37);

	}
	void a_callback_error(ActorCallback< RandomSelectorClientActor, 37, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 37);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose38();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 37);

	}
	int a_body1loopBody1cont1loopBody1cont29(RangeResult const& getRangeTest,int loopDepth) 
	{
															#line 465 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		getRangeTest1 = getRangeTest;
															#line 467 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		;
															#line 6141 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopBody1cont29loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont29(RangeResult && getRangeTest,int loopDepth) 
	{
															#line 465 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		getRangeTest1 = getRangeTest;
															#line 467 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		;
															#line 6152 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopBody1cont29loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when2(RangeResult const& getRangeTest,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont29(getRangeTest, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when2(RangeResult && getRangeTest,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont29(std::move(getRangeTest), loopDepth);

		return loopDepth;
	}
	void a_exitChoose39() 
	{
		if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state > 0) static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 0;
		static_cast<RandomSelectorClientActor*>(this)->ActorCallback< RandomSelectorClientActor, 38, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 38, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 38);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose39();
		try {
			a_body1loopBody1cont1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 38);

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 38, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 38);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose39();
		try {
			a_body1loopBody1cont1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 38);

	}
	void a_callback_error(ActorCallback< RandomSelectorClientActor, 38, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 38);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose39();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 38);

	}
	int a_body1loopBody1cont1loopBody1cont29cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont27(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont29loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1cont29loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont29loopBody1(int loopDepth) 
	{
		try {
															#line 469 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			StrictFuture<RangeResult> __when_expr_39 = tr.getRange(KeySelectorRef(StringRef(clientID + "d/" + myKeyA), onEqualA, offsetA), KeySelectorRef(StringRef(clientID + "d/" + myKeyB), onEqualB, offsetB), randomLimit, Snapshot::False, reverse);
															#line 469 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1cont29loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6252 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			if (__when_expr_39.isReady()) { if (__when_expr_39.isError()) return a_body1loopBody1cont1loopBody1cont29loopBody1Catch1(__when_expr_39.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont29loopBody1when1(__when_expr_39.get(), loopDepth); };
			static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 40;
															#line 469 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			__when_expr_39.addCallbackAndClear(static_cast<ActorCallback< RandomSelectorClientActor, 39, RangeResult >*>(static_cast<RandomSelectorClientActor*>(this)));
															#line 6257 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1cont29loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1cont29loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont29break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1loopBody1cont29cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont29loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopBody1cont29loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont29loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 526 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			StrictFuture<Void> __when_expr_40 = tr.onError(e);
															#line 526 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 6294 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			if (__when_expr_40.isReady()) { if (__when_expr_40.isError()) return a_body1loopBody1cont1Catch1(__when_expr_40.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1cont29loopBody1Catch1when1(__when_expr_40.get(), loopDepth); };
			static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 41;
															#line 526 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			__when_expr_40.addCallbackAndClear(static_cast<ActorCallback< RandomSelectorClientActor, 40, Void >*>(static_cast<RandomSelectorClientActor*>(this)));
															#line 6299 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont29loopBody1cont2(RangeResult const& getRangeTest2,int loopDepth) 
	{
															#line 476 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		bool fail = false;
															#line 477 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		if (getRangeTest1.size() != getRangeTest2.size())
															#line 6316 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		{
															#line 478 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			TraceEvent(SevError, "RanSelTestFailure") .detail("Reason", "The getRange results did not match sizes") .detail("Size1", getRangeTest1.size()) .detail("Size2", getRangeTest2.size()) .detail("Limit", randomLimit) .detail("ByteLimit", randomByteLimit) .detail("Bytes1", getRangeTest1.expectedSize()) .detail("Bytes2", getRangeTest2.expectedSize()) .detail("Reverse", reverse);
															#line 487 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			fail = true;
															#line 488 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			self->fail = true;
															#line 6324 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		}
															#line 490 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		for(int k = 0;k < std::min(getRangeTest1.size(), getRangeTest2.size());k++) {
															#line 491 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (getRangeTest1[k].value != getRangeTest2[k].value)
															#line 6330 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			{
															#line 492 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
				std::string keyA = printable(getRangeTest1[k].key);
															#line 493 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
				std::string valueA = printable(getRangeTest1[k].value);
															#line 494 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
				std::string keyB = printable(getRangeTest2[k].key);
															#line 495 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
				std::string valueB = printable(getRangeTest2[k].value);
															#line 496 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
				TraceEvent(SevError, "RanSelTestFailure") .detail("Reason", "The getRange results did not match contents") .detail("KeyA", keyA) .detail("ValueA", valueA) .detail("KeyB", keyB) .detail("ValueB", valueB) .detail("Reverse", reverse);
															#line 503 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
				fail = true;
															#line 504 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
				self->fail = true;
															#line 6346 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			}
		}
															#line 507 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		if (fail)
															#line 6351 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		{
															#line 508 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			std::string outStr1 = "";
															#line 509 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			for(int k = 0;k < getRangeTest1.size();k++) {
															#line 510 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
				outStr1 = outStr1 + printable(getRangeTest1[k].key) + " " + format("%d", getRangeTest1[k].value.size()) + " ";
															#line 6359 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			}
															#line 514 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			std::string outStr2 = "";
															#line 515 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			for(int k = 0;k < getRangeTest2.size();k++) {
															#line 516 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
				outStr2 = outStr2 + printable(getRangeTest2[k].key) + " " + format("%d", getRangeTest2[k].value.size()) + " ";
															#line 6367 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			}
															#line 520 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			TraceEvent("RanSelTestLog").detail("RYOW", outStr1).detail("Normal", outStr2);
															#line 6371 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		}
															#line 523 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		tr.reset();
															#line 6375 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		return a_body1loopBody1cont1loopBody1cont29break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont29loopBody1cont2(RangeResult && getRangeTest2,int loopDepth) 
	{
															#line 476 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		bool fail = false;
															#line 477 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		if (getRangeTest1.size() != getRangeTest2.size())
															#line 6386 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		{
															#line 478 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			TraceEvent(SevError, "RanSelTestFailure") .detail("Reason", "The getRange results did not match sizes") .detail("Size1", getRangeTest1.size()) .detail("Size2", getRangeTest2.size()) .detail("Limit", randomLimit) .detail("ByteLimit", randomByteLimit) .detail("Bytes1", getRangeTest1.expectedSize()) .detail("Bytes2", getRangeTest2.expectedSize()) .detail("Reverse", reverse);
															#line 487 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			fail = true;
															#line 488 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			self->fail = true;
															#line 6394 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		}
															#line 490 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		for(int k = 0;k < std::min(getRangeTest1.size(), getRangeTest2.size());k++) {
															#line 491 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (getRangeTest1[k].value != getRangeTest2[k].value)
															#line 6400 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			{
															#line 492 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
				std::string keyA = printable(getRangeTest1[k].key);
															#line 493 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
				std::string valueA = printable(getRangeTest1[k].value);
															#line 494 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
				std::string keyB = printable(getRangeTest2[k].key);
															#line 495 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
				std::string valueB = printable(getRangeTest2[k].value);
															#line 496 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
				TraceEvent(SevError, "RanSelTestFailure") .detail("Reason", "The getRange results did not match contents") .detail("KeyA", keyA) .detail("ValueA", valueA) .detail("KeyB", keyB) .detail("ValueB", valueB) .detail("Reverse", reverse);
															#line 503 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
				fail = true;
															#line 504 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
				self->fail = true;
															#line 6416 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			}
		}
															#line 507 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		if (fail)
															#line 6421 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		{
															#line 508 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			std::string outStr1 = "";
															#line 509 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			for(int k = 0;k < getRangeTest1.size();k++) {
															#line 510 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
				outStr1 = outStr1 + printable(getRangeTest1[k].key) + " " + format("%d", getRangeTest1[k].value.size()) + " ";
															#line 6429 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			}
															#line 514 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			std::string outStr2 = "";
															#line 515 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			for(int k = 0;k < getRangeTest2.size();k++) {
															#line 516 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
				outStr2 = outStr2 + printable(getRangeTest2[k].key) + " " + format("%d", getRangeTest2[k].value.size()) + " ";
															#line 6437 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			}
															#line 520 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			TraceEvent("RanSelTestLog").detail("RYOW", outStr1).detail("Normal", outStr2);
															#line 6441 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		}
															#line 523 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		tr.reset();
															#line 6445 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		return a_body1loopBody1cont1loopBody1cont29break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont29loopBody1when1(RangeResult const& getRangeTest2,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont29loopBody1cont2(getRangeTest2, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont29loopBody1when1(RangeResult && getRangeTest2,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont29loopBody1cont2(std::move(getRangeTest2), loopDepth);

		return loopDepth;
	}
	void a_exitChoose40() 
	{
		if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state > 0) static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 0;
		static_cast<RandomSelectorClientActor*>(this)->ActorCallback< RandomSelectorClientActor, 39, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 39, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 39);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose40();
		try {
			a_body1loopBody1cont1loopBody1cont29loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1cont29loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1cont29loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 39);

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 39, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 39);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose40();
		try {
			a_body1loopBody1cont1loopBody1cont29loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1cont29loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1cont29loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 39);

	}
	void a_callback_error(ActorCallback< RandomSelectorClientActor, 39, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 39);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose40();
		try {
			a_body1loopBody1cont1loopBody1cont29loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1cont29loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1cont29loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 39);

	}
	int a_body1loopBody1cont1loopBody1cont29loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont29loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont29loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont29loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont29loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont29loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont29loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont29loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose41() 
	{
		if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state > 0) static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 0;
		static_cast<RandomSelectorClientActor*>(this)->ActorCallback< RandomSelectorClientActor, 40, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 40, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 40);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose41();
		try {
			a_body1loopBody1cont1loopBody1cont29loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 40);

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 40, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 40);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose41();
		try {
			a_body1loopBody1cont1loopBody1cont29loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 40);

	}
	void a_callback_error(ActorCallback< RandomSelectorClientActor, 40, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 40);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose41();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 40);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 534 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		++self->transactions;
															#line 536 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		finalTransaction = Transaction(cx);
															#line 538 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		;
															#line 6620 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		loopDepth = a_body1loopBody1cont4loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 534 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		++self->transactions;
															#line 536 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		finalTransaction = Transaction(cx);
															#line 538 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		;
															#line 6633 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		loopDepth = a_body1loopBody1cont4loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose42() 
	{
		if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state > 0) static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 0;
		static_cast<RandomSelectorClientActor*>(this)->ActorCallback< RandomSelectorClientActor, 41, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 41, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 41);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose42();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 41);

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 41, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 41);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose42();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 41);

	}
	void a_callback_error(ActorCallback< RandomSelectorClientActor, 41, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 41);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose42();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 41);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont4loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4loopBody1(int loopDepth) 
	{
		try {
															#line 540 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			StrictFuture<RangeResult> __when_expr_42 = finalTransaction.getRange( KeyRangeRef(StringRef(clientID + "b/"), StringRef(clientID + "c/")), self->maxKeySpace);
															#line 540 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont4loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6733 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			if (__when_expr_42.isReady()) { if (__when_expr_42.isError()) return a_body1loopBody1cont4loopBody1Catch1(__when_expr_42.getError(), loopDepth); else return a_body1loopBody1cont4loopBody1when1(__when_expr_42.get(), loopDepth); };
			static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 43;
															#line 540 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			__when_expr_42.addCallbackAndClear(static_cast<ActorCallback< RandomSelectorClientActor, 42, RangeResult >*>(static_cast<RandomSelectorClientActor*>(this)));
															#line 6738 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont4loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont4loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont4break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont4loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont4loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 563 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			StrictFuture<Void> __when_expr_44 = finalTransaction.onError(e);
															#line 563 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6775 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			if (__when_expr_44.isReady()) { if (__when_expr_44.isError()) return a_body1loopBody1cont1Catch1(__when_expr_44.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont4loopBody1Catch1when1(__when_expr_44.get(), loopDepth); };
			static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 45;
															#line 563 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			__when_expr_44.addCallbackAndClear(static_cast<ActorCallback< RandomSelectorClientActor, 44, Void >*>(static_cast<RandomSelectorClientActor*>(this)));
															#line 6780 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont4loopBody1cont2(int loopDepth) 
	{
															#line 542 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		StrictFuture<RangeResult> __when_expr_43 = finalTransaction.getRange( KeyRangeRef(StringRef(clientID + "d/"), StringRef(clientID + "e/")), self->maxKeySpace);
															#line 542 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont4loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6797 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		if (__when_expr_43.isReady()) { if (__when_expr_43.isError()) return a_body1loopBody1cont4loopBody1Catch1(__when_expr_43.getError(), loopDepth); else return a_body1loopBody1cont4loopBody1cont2when1(__when_expr_43.get(), loopDepth); };
		static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 44;
															#line 542 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		__when_expr_43.addCallbackAndClear(static_cast<ActorCallback< RandomSelectorClientActor, 43, RangeResult >*>(static_cast<RandomSelectorClientActor*>(this)));
															#line 6802 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4loopBody1when1(RangeResult const& __finalTest1,int loopDepth) 
	{
															#line 540 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		finalTest1 = __finalTest1;
															#line 6811 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		loopDepth = a_body1loopBody1cont4loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4loopBody1when1(RangeResult && __finalTest1,int loopDepth) 
	{
		finalTest1 = std::move(__finalTest1);
		loopDepth = a_body1loopBody1cont4loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose43() 
	{
		if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state > 0) static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 0;
		static_cast<RandomSelectorClientActor*>(this)->ActorCallback< RandomSelectorClientActor, 42, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 42, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 42);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose43();
		try {
			a_body1loopBody1cont4loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 42);

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 42, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 42);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose43();
		try {
			a_body1loopBody1cont4loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 42);

	}
	void a_callback_error(ActorCallback< RandomSelectorClientActor, 42, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 42);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose43();
		try {
			a_body1loopBody1cont4loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 42);

	}
	int a_body1loopBody1cont4loopBody1cont3(RangeResult const& finalTest2,int loopDepth) 
	{
															#line 545 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		if (finalTest1.size() != finalTest2.size())
															#line 6890 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		{
															#line 546 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			TraceEvent(SevError, "RanSelTestFailure") .detail("Reason", "The final results did not match sizes");
															#line 548 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			self->fail = true;
															#line 6896 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		}
															#line 550 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		for(int k = 0;k < finalTest1.size();k++) {
															#line 551 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (finalTest1[k].value != finalTest2[k].value)
															#line 6902 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			{
															#line 552 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
				TraceEvent(SevError, "RanSelTestFailure") .detail("Reason", "The final results did not match contents") .detail("KeyA", printable(finalTest1[k].key)) .detail("ValueA", printable(finalTest1[k].value)) .detail("KeyB", printable(finalTest2[k].key)) .detail("ValueB", printable(finalTest2[k].value)) .detail("Reverse", reverse);
															#line 559 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
				self->fail = true;
															#line 6908 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			}
		}
		return a_body1loopBody1cont4break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont4loopBody1cont3(RangeResult && finalTest2,int loopDepth) 
	{
															#line 545 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		if (finalTest1.size() != finalTest2.size())
															#line 6919 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		{
															#line 546 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			TraceEvent(SevError, "RanSelTestFailure") .detail("Reason", "The final results did not match sizes");
															#line 548 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			self->fail = true;
															#line 6925 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		}
															#line 550 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		for(int k = 0;k < finalTest1.size();k++) {
															#line 551 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
			if (finalTest1[k].value != finalTest2[k].value)
															#line 6931 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			{
															#line 552 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
				TraceEvent(SevError, "RanSelTestFailure") .detail("Reason", "The final results did not match contents") .detail("KeyA", printable(finalTest1[k].key)) .detail("ValueA", printable(finalTest1[k].value)) .detail("KeyB", printable(finalTest2[k].key)) .detail("ValueB", printable(finalTest2[k].value)) .detail("Reverse", reverse);
															#line 559 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
				self->fail = true;
															#line 6937 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
			}
		}
		return a_body1loopBody1cont4break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont4loopBody1cont2when1(RangeResult const& finalTest2,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4loopBody1cont3(finalTest2, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4loopBody1cont2when1(RangeResult && finalTest2,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4loopBody1cont3(std::move(finalTest2), loopDepth);

		return loopDepth;
	}
	void a_exitChoose44() 
	{
		if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state > 0) static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 0;
		static_cast<RandomSelectorClientActor*>(this)->ActorCallback< RandomSelectorClientActor, 43, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 43, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 43);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose44();
		try {
			a_body1loopBody1cont4loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 43);

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 43, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 43);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose44();
		try {
			a_body1loopBody1cont4loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 43);

	}
	void a_callback_error(ActorCallback< RandomSelectorClientActor, 43, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 43);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose44();
		try {
			a_body1loopBody1cont4loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 43);

	}
	int a_body1loopBody1cont4loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose45() 
	{
		if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state > 0) static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 0;
		static_cast<RandomSelectorClientActor*>(this)->ActorCallback< RandomSelectorClientActor, 44, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 44, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 44);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose45();
		try {
			a_body1loopBody1cont4loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 44);

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 44, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 44);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose45();
		try {
			a_body1loopBody1cont4loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 44);

	}
	void a_callback_error(ActorCallback< RandomSelectorClientActor, 44, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 44);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose45();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 44);

	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 568 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		++self->retries;
															#line 7123 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 568 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
		++self->retries;
															#line 7132 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose46() 
	{
		if (static_cast<RandomSelectorClientActor*>(this)->actor_wait_state > 0) static_cast<RandomSelectorClientActor*>(this)->actor_wait_state = 0;
		static_cast<RandomSelectorClientActor*>(this)->ActorCallback< RandomSelectorClientActor, 45, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 45, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 45);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose46();
		try {
			a_body1loopBody1cont1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 45);

	}
	void a_callback_fire(ActorCallback< RandomSelectorClientActor, 45, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 45);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose46();
		try {
			a_body1loopBody1cont1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 45);

	}
	void a_callback_error(ActorCallback< RandomSelectorClientActor, 45, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), 45);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose46();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), 45);

	}
															#line 92 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
	Database cx;
															#line 92 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
	RandomSelectorWorkload* self;
															#line 93 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
	int i;
															#line 94 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
	int j;
															#line 95 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
	std::string clientID;
															#line 96 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
	std::string myKeyA;
															#line 97 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
	std::string myKeyB;
															#line 98 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
	std::string myValue;
															#line 99 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
	std::string myRandomIDKey;
															#line 100 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
	bool onEqualA;
															#line 101 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
	bool onEqualB;
															#line 102 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
	int offsetA;
															#line 103 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
	int offsetB;
															#line 104 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
	int randomLimit;
															#line 105 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
	int randomByteLimit;
															#line 106 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
	Reverse reverse;
															#line 107 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
	Error error;
															#line 112 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
	Transaction tr;
															#line 135 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
	ReadYourWritesTransaction trRYOW;
															#line 199 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
	Optional<Value> getTest1;
															#line 458 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
	RangeResult getRangeTest1;
															#line 536 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
	Transaction finalTransaction;
															#line 540 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
	RangeResult finalTest1;
															#line 7258 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
};
// This generated class is to be used only via randomSelectorClient()
															#line 92 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
class RandomSelectorClientActor final : public Actor<Void>, public ActorCallback< RandomSelectorClientActor, 0, Void >, public ActorCallback< RandomSelectorClientActor, 1, Void >, public ActorCallback< RandomSelectorClientActor, 2, Void >, public ActorCallback< RandomSelectorClientActor, 3, Void >, public ActorCallback< RandomSelectorClientActor, 4, Void >, public ActorCallback< RandomSelectorClientActor, 5, Void >, public ActorCallback< RandomSelectorClientActor, 6, Void >, public ActorCallback< RandomSelectorClientActor, 7, Void >, public ActorCallback< RandomSelectorClientActor, 8, Optional<Value> >, public ActorCallback< RandomSelectorClientActor, 9, Optional<Value> >, public ActorCallback< RandomSelectorClientActor, 10, Void >, public ActorCallback< RandomSelectorClientActor, 11, Void >, public ActorCallback< RandomSelectorClientActor, 12, Void >, public ActorCallback< RandomSelectorClientActor, 13, Optional<Value> >, public ActorCallback< RandomSelectorClientActor, 14, Void >, public ActorCallback< RandomSelectorClientActor, 15, Void >, public ActorCallback< RandomSelectorClientActor, 16, Optional<Value> >, public ActorCallback< RandomSelectorClientActor, 17, Void >, public ActorCallback< RandomSelectorClientActor, 18, Void >, public ActorCallback< RandomSelectorClientActor, 19, Optional<Value> >, public ActorCallback< RandomSelectorClientActor, 20, Void >, public ActorCallback< RandomSelectorClientActor, 21, Void >, public ActorCallback< RandomSelectorClientActor, 22, Optional<Value> >, public ActorCallback< RandomSelectorClientActor, 23, Void >, public ActorCallback< RandomSelectorClientActor, 24, Void >, public ActorCallback< RandomSelectorClientActor, 25, Optional<Value> >, public ActorCallback< RandomSelectorClientActor, 26, Void >, public ActorCallback< RandomSelectorClientActor, 27, Void >, public ActorCallback< RandomSelectorClientActor, 28, Optional<Value> >, public ActorCallback< RandomSelectorClientActor, 29, Void >, public ActorCallback< RandomSelectorClientActor, 30, Void >, public ActorCallback< RandomSelectorClientActor, 31, Optional<Value> >, public ActorCallback< RandomSelectorClientActor, 32, Void >, public ActorCallback< RandomSelectorClientActor, 33, Void >, public ActorCallback< RandomSelectorClientActor, 34, Optional<Value> >, public ActorCallback< RandomSelectorClientActor, 35, Void >, public ActorCallback< RandomSelectorClientActor, 36, Void >, public ActorCallback< RandomSelectorClientActor, 37, Optional<Value> >, public ActorCallback< RandomSelectorClientActor, 38, RangeResult >, public ActorCallback< RandomSelectorClientActor, 39, RangeResult >, public ActorCallback< RandomSelectorClientActor, 40, Void >, public ActorCallback< RandomSelectorClientActor, 41, Void >, public ActorCallback< RandomSelectorClientActor, 42, RangeResult >, public ActorCallback< RandomSelectorClientActor, 43, RangeResult >, public ActorCallback< RandomSelectorClientActor, 44, Void >, public ActorCallback< RandomSelectorClientActor, 45, Void >, public FastAllocated<RandomSelectorClientActor>, public RandomSelectorClientActorState<RandomSelectorClientActor> {
															#line 7263 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
public:
	using FastAllocated<RandomSelectorClientActor>::operator new;
	using FastAllocated<RandomSelectorClientActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(413964927032094208UL, 5667350087745340160UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RandomSelectorClientActor, 0, Void >;
friend struct ActorCallback< RandomSelectorClientActor, 1, Void >;
friend struct ActorCallback< RandomSelectorClientActor, 2, Void >;
friend struct ActorCallback< RandomSelectorClientActor, 3, Void >;
friend struct ActorCallback< RandomSelectorClientActor, 4, Void >;
friend struct ActorCallback< RandomSelectorClientActor, 5, Void >;
friend struct ActorCallback< RandomSelectorClientActor, 6, Void >;
friend struct ActorCallback< RandomSelectorClientActor, 7, Void >;
friend struct ActorCallback< RandomSelectorClientActor, 8, Optional<Value> >;
friend struct ActorCallback< RandomSelectorClientActor, 9, Optional<Value> >;
friend struct ActorCallback< RandomSelectorClientActor, 10, Void >;
friend struct ActorCallback< RandomSelectorClientActor, 11, Void >;
friend struct ActorCallback< RandomSelectorClientActor, 12, Void >;
friend struct ActorCallback< RandomSelectorClientActor, 13, Optional<Value> >;
friend struct ActorCallback< RandomSelectorClientActor, 14, Void >;
friend struct ActorCallback< RandomSelectorClientActor, 15, Void >;
friend struct ActorCallback< RandomSelectorClientActor, 16, Optional<Value> >;
friend struct ActorCallback< RandomSelectorClientActor, 17, Void >;
friend struct ActorCallback< RandomSelectorClientActor, 18, Void >;
friend struct ActorCallback< RandomSelectorClientActor, 19, Optional<Value> >;
friend struct ActorCallback< RandomSelectorClientActor, 20, Void >;
friend struct ActorCallback< RandomSelectorClientActor, 21, Void >;
friend struct ActorCallback< RandomSelectorClientActor, 22, Optional<Value> >;
friend struct ActorCallback< RandomSelectorClientActor, 23, Void >;
friend struct ActorCallback< RandomSelectorClientActor, 24, Void >;
friend struct ActorCallback< RandomSelectorClientActor, 25, Optional<Value> >;
friend struct ActorCallback< RandomSelectorClientActor, 26, Void >;
friend struct ActorCallback< RandomSelectorClientActor, 27, Void >;
friend struct ActorCallback< RandomSelectorClientActor, 28, Optional<Value> >;
friend struct ActorCallback< RandomSelectorClientActor, 29, Void >;
friend struct ActorCallback< RandomSelectorClientActor, 30, Void >;
friend struct ActorCallback< RandomSelectorClientActor, 31, Optional<Value> >;
friend struct ActorCallback< RandomSelectorClientActor, 32, Void >;
friend struct ActorCallback< RandomSelectorClientActor, 33, Void >;
friend struct ActorCallback< RandomSelectorClientActor, 34, Optional<Value> >;
friend struct ActorCallback< RandomSelectorClientActor, 35, Void >;
friend struct ActorCallback< RandomSelectorClientActor, 36, Void >;
friend struct ActorCallback< RandomSelectorClientActor, 37, Optional<Value> >;
friend struct ActorCallback< RandomSelectorClientActor, 38, RangeResult >;
friend struct ActorCallback< RandomSelectorClientActor, 39, RangeResult >;
friend struct ActorCallback< RandomSelectorClientActor, 40, Void >;
friend struct ActorCallback< RandomSelectorClientActor, 41, Void >;
friend struct ActorCallback< RandomSelectorClientActor, 42, RangeResult >;
friend struct ActorCallback< RandomSelectorClientActor, 43, RangeResult >;
friend struct ActorCallback< RandomSelectorClientActor, 44, Void >;
friend struct ActorCallback< RandomSelectorClientActor, 45, Void >;
															#line 92 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
	RandomSelectorClientActor(Database const& cx,RandomSelectorWorkload* const& self) 
															#line 7325 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
		 : Actor<Void>(),
		   RandomSelectorClientActorState<RandomSelectorClientActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("randomSelectorClient", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11768015545681629952UL, 5649653060262788608UL);
		ActorExecutionContextHelper __helper(static_cast<RandomSelectorClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("randomSelectorClient");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("randomSelectorClient", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RandomSelectorClientActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RandomSelectorClientActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RandomSelectorClientActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RandomSelectorClientActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< RandomSelectorClientActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< RandomSelectorClientActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< RandomSelectorClientActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< RandomSelectorClientActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< RandomSelectorClientActor, 8, Optional<Value> >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< RandomSelectorClientActor, 9, Optional<Value> >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< RandomSelectorClientActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< RandomSelectorClientActor, 11, Void >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< RandomSelectorClientActor, 12, Void >*)0, actor_cancelled()); break;
		case 14: this->a_callback_error((ActorCallback< RandomSelectorClientActor, 13, Optional<Value> >*)0, actor_cancelled()); break;
		case 15: this->a_callback_error((ActorCallback< RandomSelectorClientActor, 14, Void >*)0, actor_cancelled()); break;
		case 16: this->a_callback_error((ActorCallback< RandomSelectorClientActor, 15, Void >*)0, actor_cancelled()); break;
		case 17: this->a_callback_error((ActorCallback< RandomSelectorClientActor, 16, Optional<Value> >*)0, actor_cancelled()); break;
		case 18: this->a_callback_error((ActorCallback< RandomSelectorClientActor, 17, Void >*)0, actor_cancelled()); break;
		case 19: this->a_callback_error((ActorCallback< RandomSelectorClientActor, 18, Void >*)0, actor_cancelled()); break;
		case 20: this->a_callback_error((ActorCallback< RandomSelectorClientActor, 19, Optional<Value> >*)0, actor_cancelled()); break;
		case 21: this->a_callback_error((ActorCallback< RandomSelectorClientActor, 20, Void >*)0, actor_cancelled()); break;
		case 22: this->a_callback_error((ActorCallback< RandomSelectorClientActor, 21, Void >*)0, actor_cancelled()); break;
		case 23: this->a_callback_error((ActorCallback< RandomSelectorClientActor, 22, Optional<Value> >*)0, actor_cancelled()); break;
		case 24: this->a_callback_error((ActorCallback< RandomSelectorClientActor, 23, Void >*)0, actor_cancelled()); break;
		case 25: this->a_callback_error((ActorCallback< RandomSelectorClientActor, 24, Void >*)0, actor_cancelled()); break;
		case 26: this->a_callback_error((ActorCallback< RandomSelectorClientActor, 25, Optional<Value> >*)0, actor_cancelled()); break;
		case 27: this->a_callback_error((ActorCallback< RandomSelectorClientActor, 26, Void >*)0, actor_cancelled()); break;
		case 28: this->a_callback_error((ActorCallback< RandomSelectorClientActor, 27, Void >*)0, actor_cancelled()); break;
		case 29: this->a_callback_error((ActorCallback< RandomSelectorClientActor, 28, Optional<Value> >*)0, actor_cancelled()); break;
		case 30: this->a_callback_error((ActorCallback< RandomSelectorClientActor, 29, Void >*)0, actor_cancelled()); break;
		case 31: this->a_callback_error((ActorCallback< RandomSelectorClientActor, 30, Void >*)0, actor_cancelled()); break;
		case 32: this->a_callback_error((ActorCallback< RandomSelectorClientActor, 31, Optional<Value> >*)0, actor_cancelled()); break;
		case 33: this->a_callback_error((ActorCallback< RandomSelectorClientActor, 32, Void >*)0, actor_cancelled()); break;
		case 34: this->a_callback_error((ActorCallback< RandomSelectorClientActor, 33, Void >*)0, actor_cancelled()); break;
		case 35: this->a_callback_error((ActorCallback< RandomSelectorClientActor, 34, Optional<Value> >*)0, actor_cancelled()); break;
		case 36: this->a_callback_error((ActorCallback< RandomSelectorClientActor, 35, Void >*)0, actor_cancelled()); break;
		case 37: this->a_callback_error((ActorCallback< RandomSelectorClientActor, 36, Void >*)0, actor_cancelled()); break;
		case 38: this->a_callback_error((ActorCallback< RandomSelectorClientActor, 37, Optional<Value> >*)0, actor_cancelled()); break;
		case 39: this->a_callback_error((ActorCallback< RandomSelectorClientActor, 38, RangeResult >*)0, actor_cancelled()); break;
		case 40: this->a_callback_error((ActorCallback< RandomSelectorClientActor, 39, RangeResult >*)0, actor_cancelled()); break;
		case 41: this->a_callback_error((ActorCallback< RandomSelectorClientActor, 40, Void >*)0, actor_cancelled()); break;
		case 42: this->a_callback_error((ActorCallback< RandomSelectorClientActor, 41, Void >*)0, actor_cancelled()); break;
		case 43: this->a_callback_error((ActorCallback< RandomSelectorClientActor, 42, RangeResult >*)0, actor_cancelled()); break;
		case 44: this->a_callback_error((ActorCallback< RandomSelectorClientActor, 43, RangeResult >*)0, actor_cancelled()); break;
		case 45: this->a_callback_error((ActorCallback< RandomSelectorClientActor, 44, Void >*)0, actor_cancelled()); break;
		case 46: this->a_callback_error((ActorCallback< RandomSelectorClientActor, 45, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 92 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
[[nodiscard]] Future<Void> randomSelectorClient( Database const& cx, RandomSelectorWorkload* const& self ) {
															#line 92 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
	return Future<Void>(new RandomSelectorClientActor(cx, self));
															#line 7402 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomSelector.actor.g.cpp"
}

#line 572 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/RandomSelector.actor.cpp"
};

WorkloadFactory<RandomSelectorWorkload> RandomSelectorWorkloadFactory;
