#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/ProtocolVersion.actor.cpp"
/*
 * ProtocolVersion.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbserver/workloads/workloads.actor.h"
#include "fdbrpc/SimulatorProcessInfo.h"
#include "flow/actorcompiler.h" // This must be the last include

struct ProtocolVersionWorkload : TestWorkload {
	static constexpr auto NAME = "ProtocolVersion";

	ProtocolVersionWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {}

	Future<Void> start(Database const& cx) override { return _start(this, cx); }

																#line 34 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ProtocolVersion.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 32 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/ProtocolVersion.actor.cpp"
template <class _startActor>
															#line 32 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/ProtocolVersion.actor.cpp"
class _startActorState {
															#line 40 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ProtocolVersion.actor.g.cpp"
public:
															#line 32 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/ProtocolVersion.actor.cpp"
	_startActorState(ProtocolVersionWorkload* const& self,Database const& cx) 
															#line 32 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/ProtocolVersion.actor.cpp"
															#line 32 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/ProtocolVersion.actor.cpp"
		 : self(self),
															#line 32 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/ProtocolVersion.actor.cpp"
		   cx(cx),
															#line 33 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/ProtocolVersion.actor.cpp"
		   allProcesses(g_simulator->getAllProcesses()),
															#line 34 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/ProtocolVersion.actor.cpp"
		   diffVersionProcess(find_if(allProcesses.begin(), allProcesses.end(), [](const ISimulator::ProcessInfo* p) { return p->protocolVersion != currentProtocolVersion(); }))
															#line 53 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ProtocolVersion.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 39 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/ProtocolVersion.actor.cpp"
			ASSERT(diffVersionProcess != allProcesses.end());
															#line 41 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/ProtocolVersion.actor.cpp"
			RequestStream<ProtocolInfoRequest> requestStream{ Endpoint::wellKnown({ (*diffVersionProcess)->addresses }, WLTOKEN_PROTOCOL_INFO) };
															#line 43 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/ProtocolVersion.actor.cpp"
			StrictFuture<ProtocolInfoReply> __when_expr_0 = retryBrokenPromise(requestStream, ProtocolInfoRequest{});
															#line 43 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/ProtocolVersion.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 74 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ProtocolVersion.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 43 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/ProtocolVersion.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, ProtocolInfoReply >*>(static_cast<_startActor*>(this)));
															#line 79 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ProtocolVersion.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(ProtocolInfoReply const& reply,int loopDepth) 
	{
															#line 45 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/ProtocolVersion.actor.cpp"
		ASSERT(reply.version != g_network->protocolVersion());
															#line 46 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/ProtocolVersion.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 104 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ProtocolVersion.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(ProtocolInfoReply && reply,int loopDepth) 
	{
															#line 45 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/ProtocolVersion.actor.cpp"
		ASSERT(reply.version != g_network->protocolVersion());
															#line 46 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/ProtocolVersion.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 118 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ProtocolVersion.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(ProtocolInfoReply const& reply,int loopDepth) 
	{
		loopDepth = a_body1cont1(reply, loopDepth);

		return loopDepth;
	}
	int a_body1when1(ProtocolInfoReply && reply,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(reply), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, ProtocolInfoReply >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, ProtocolInfoReply >*,ProtocolInfoReply const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, ProtocolInfoReply >*,ProtocolInfoReply && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, ProtocolInfoReply >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 32 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/ProtocolVersion.actor.cpp"
	ProtocolVersionWorkload* self;
															#line 32 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/ProtocolVersion.actor.cpp"
	Database cx;
															#line 33 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/ProtocolVersion.actor.cpp"
	std::vector<ISimulator::ProcessInfo*> allProcesses;
															#line 34 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/ProtocolVersion.actor.cpp"
	std::vector<ISimulator::ProcessInfo*>::iterator diffVersionProcess;
															#line 209 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ProtocolVersion.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 32 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/ProtocolVersion.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, ProtocolInfoReply >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 214 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ProtocolVersion.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13865026544995386624UL, 8445290920625152000UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, ProtocolInfoReply >;
															#line 32 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/ProtocolVersion.actor.cpp"
	_startActor(ProtocolVersionWorkload* const& self,Database const& cx) 
															#line 231 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ProtocolVersion.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, ProtocolInfoReply >*)0, actor_cancelled()); break;
		}

	}
};
															#line 32 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/ProtocolVersion.actor.cpp"
[[nodiscard]] Future<Void> _start( ProtocolVersionWorkload* const& self, Database const& cx ) {
															#line 32 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/ProtocolVersion.actor.cpp"
	return Future<Void>(new _startActor(self, cx));
															#line 263 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ProtocolVersion.actor.g.cpp"
}

#line 48 "/codebuild/output/src2809880643/src/github.com/apple/foundationdb/fdbserver/workloads/ProtocolVersion.actor.cpp"

	Future<bool> check(Database const& cx) override { return true; }

	void getMetrics(std::vector<PerfMetric>& m) override {}
};

WorkloadFactory<ProtocolVersionWorkload> ProtocolVersionWorkloadFactory;
