/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb;

import com.apple.foundationdb.Database;
import com.apple.foundationdb.FDBException;
import com.apple.foundationdb.FDBTransaction;
import com.apple.foundationdb.FutureResults;
import com.apple.foundationdb.KeySelector;
import com.apple.foundationdb.KeyValue;
import com.apple.foundationdb.RangeResult;
import com.apple.foundationdb.RangeResultInfo;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public class FakeFDBTransaction
extends FDBTransaction {
    private final NavigableMap<byte[], byte[]> backingData = new TreeMap<byte[], byte[]>(ByteArrayUtil.comparator());
    private final Executor executor;
    private int numRangeCalls = 0;

    protected FakeFDBTransaction(long l, Database database, Executor executor) {
        super(l, database, executor);
        this.executor = executor;
    }

    public FakeFDBTransaction(Map<byte[], byte[]> map, long l, Database database, Executor executor) {
        this(l, database, executor);
        this.backingData.putAll(map);
    }

    public FakeFDBTransaction(Collection<Map.Entry<byte[], byte[]>> collection, long l, Database database, Executor executor) {
        this(l, database, executor);
        for (Map.Entry<byte[], byte[]> entry : collection) {
            this.backingData.put(entry.getKey(), entry.getValue());
        }
    }

    public FakeFDBTransaction(List<KeyValue> list, long l, Database database, Executor executor) {
        this(l, database, executor);
        for (KeyValue keyValue : list) {
            this.backingData.put(keyValue.getKey(), keyValue.getValue());
        }
    }

    public CompletableFuture<byte[]> get(byte[] byArray) {
        return CompletableFuture.completedFuture((byte[])this.backingData.get(byArray));
    }

    public int getNumRangeCalls() {
        return this.numRangeCalls;
    }

    protected FutureResults getRange_internal(KeySelector keySelector, KeySelector keySelector2, final int n, final int n2, int n3, int n4, boolean bl, boolean bl2) {
        ++this.numRangeCalls;
        NavigableMap<byte[], byte[]> navigableMap = this.backingData.subMap(keySelector.getKey(), keySelector.orEqual(), keySelector2.getKey(), keySelector2.orEqual());
        if (bl2) {
            navigableMap = navigableMap.descendingMap();
        }
        final NavigableMap<byte[], byte[]> navigableMap2 = navigableMap;
        FutureResults futureResults = new FutureResults(-1L, false, this.executor, null){

            protected void registerMarshalCallback(Executor executor) {
            }

            protected RangeResultInfo getIfDone_internal(long l) throws FDBException {
                return new RangeResultInfo((FutureResults)this);
            }

            public RangeResult getResults() {
                ArrayList<KeyValue> arrayList = new ArrayList<KeyValue>();
                boolean bl = false;
                int n3 = 0;
                int n22 = 0;
                for (Map.Entry entry : navigableMap2.entrySet()) {
                    arrayList.add(new KeyValue((byte[])entry.getKey(), (byte[])entry.getValue()));
                    if (n > 0 && ++n3 == n) {
                        bl = true;
                        break;
                    }
                    if (n2 <= 0 || (n22 += ((byte[])entry.getKey()).length + ((byte[])entry.getValue()).length) < n2) continue;
                    bl = true;
                    break;
                }
                return new RangeResult(arrayList, bl);
            }

            public void close() {
            }
        };
        futureResults.complete((Object)new RangeResultInfo(futureResults));
        return futureResults;
    }

    protected void closeInternal(long l) {
    }

    public void close() {
    }

    protected void finalize() throws Throwable {
    }
}

