#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/IKeyValueStore.actor.h"
/*
 * IKeyValueStore.actor.h
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once

#if defined(NO_INTELLISENSE) && !defined(FDBCLIENT_IKEYVALUESTORE_ACTOR_G_H)
#define FDBCLIENT_IKEYVALUESTORE_ACTOR_G_H
#include "fdbclient/IKeyValueStore.actor.g.h"
#elif !defined(FDBCLIENT_IKEYVALUESTORE_ACTOR_H)
#define FDBCLIENT_IKEYVALUESTORE_ACTOR_H

#include "flow/Trace.h"
#include "fdbclient/FDBTypes.h"
#include "fdbclient/StorageCheckpoint.h"
#include "fdbclient/IClosable.h"
#include "fdbclient/KeyRangeMap.h"
#include "flow/flow.h"

#include "flow/actorcompiler.h" // This must be the last #include.

struct CheckpointRequest {
	const Version version; // The FDB version at which the checkpoint is created.
	const std::vector<KeyRange> ranges; // Keyranges this checkpoint must contain.
	const CheckpointFormat format;
	const UID checkpointID;
	const std::string checkpointDir; // The local directory where the checkpoint file will be created.

	CheckpointRequest(const Version version,
	                  const std::vector<KeyRange>& ranges,
	                  const CheckpointFormat format,
	                  const UID& id,
	                  const std::string& checkpointDir)
	  : version(version), ranges(ranges), format(format), checkpointID(id), checkpointDir(checkpointDir) {}
};

															#line 55 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/IKeyValueStore.actor.g.h.py_gen"
[[nodiscard]] static Future<Void> replaceRange_impl( class IKeyValueStore* const& self, KeyRange const& range, Standalone<VectorRef<KeyValueRef>> const& data );

#line 56 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/IKeyValueStore.actor.h"

class IKeyValueStore : public IClosable {
public:
	virtual KeyValueStoreType getType() const = 0;
	virtual bool getReplaceContent() const { return false; };
	// Returns true if the KV store supports shards, i.e., implements addRange(), removeRange(), and
	// persistRangeMapping().
	virtual bool shardAware() const { return false; }
	// Returns true if the store supports external SST file ingestion.
	virtual bool supportsSstIngestion() const { return false; }
	virtual void set(KeyValueRef keyValue, const Arena* arena = nullptr) = 0;
	virtual void clear(KeyRangeRef range, const Arena* arena = nullptr) = 0;
	virtual Future<Void> canCommit() { return Void(); }
	virtual Future<Void> commit(
	    bool sequential = false) = 0; // returns when prior sets and clears are (atomically) durable

	virtual Future<Optional<Value>> readValue(KeyRef key, Optional<ReadOptions> options = Optional<ReadOptions>()) = 0;

	// Like readValue(), but returns only the first maxLength bytes of the value if it is longer
	virtual Future<Optional<Value>> readValuePrefix(KeyRef key,
	                                                int maxLength,
	                                                Optional<ReadOptions> options = Optional<ReadOptions>()) = 0;

	// If rowLimit>=0, reads first rows sorted ascending, otherwise reads last rows sorted descending
	// The total size of the returned value (less the last entry) will be less than byteLimit
	virtual Future<RangeResult> readRange(KeyRangeRef keys,
	                                      int rowLimit = 1 << 30,
	                                      int byteLimit = 1 << 30,
	                                      Optional<ReadOptions> options = Optional<ReadOptions>()) = 0;

	// Shard management APIs.
	// Adds key range to a physical shard.
	virtual Future<Void> addRange(KeyRangeRef range, std::string id, bool active = true) { return Void(); }

	// Removes a key range from KVS and returns a list of empty physical shards after the removal.
	virtual std::vector<std::string> removeRange(KeyRangeRef range) { return std::vector<std::string>(); }

	// Replace the specified range, the default implementation ignores `blockRange` and writes the key one by one.
	virtual Future<Void> replaceRange(KeyRange range, Standalone<VectorRef<KeyValueRef>> data) {
		return replaceRange_impl(this, range, data);
	}

	// Marks a key range as active and prepares it for future read.
	virtual void markRangeAsActive(KeyRangeRef range) {}

	// Persists key range and physical shard mapping.
	virtual void persistRangeMapping(KeyRangeRef range, bool isAdd) {}

	// Returns key range to physical shard mapping.
	virtual CoalescedKeyRangeMap<std::string> getExistingRanges() { throw not_implemented(); }

	// To debug MEMORY_RADIXTREE type ONLY
	// Returns (1) how many key & value pairs have been inserted (2) how many nodes have been created (3) how many
	// key size is less than 12 bytes
	virtual std::tuple<size_t, size_t, size_t> getSize() const { return std::make_tuple(0, 0, 0); }

	// Returns the amount of free and total space for this store, in bytes
	virtual StorageBytes getStorageBytes() const = 0;

	virtual void logRecentRocksDBBackgroundWorkStats(UID ssId, std::string logReason) { throw not_implemented(); }

	virtual void resyncLog() {}

	virtual void enableSnapshot() {}

	// Create a checkpoint.
	virtual Future<CheckpointMetaData> checkpoint(const CheckpointRequest& request) { throw not_implemented(); }

	// Restore from a checkpoint.
	virtual Future<Void> restore(const std::vector<CheckpointMetaData>& checkpoints) { throw not_implemented(); }

	// Same as above, with a target shardId, and a list of target ranges, ranges must be a subset of the checkpoint
	// ranges.
	virtual Future<Void> restore(const std::string& shardId,
	                             const std::vector<KeyRange>& ranges,
	                             const std::vector<CheckpointMetaData>& checkpoints) {
		throw not_implemented();
	}

	// Delete a checkpoint.
	virtual Future<Void> deleteCheckpoint(const CheckpointMetaData& checkpoint) { throw not_implemented(); }

	// Compact a range of keys in the store
	virtual Future<Void> compactRange(KeyRangeRef range) { throw not_implemented(); }

	/*
	Concurrency contract
	    Causal consistency:
	        A read which begins after a commit ends sees the effects of the commit.
	        A read which ends before a commit begins does not see the effects of the commit.

	    Thus, a read returns a version as of a call to commit which began before the read ends such that no subsequent
	commit ended before the read begins:

	        commit()		// can't be this version (subsequent commit ends before read begins)
	            endcommit()
	        commit()		// could be this or any later version (no subsequent commit ends before read begins)
	            endcommit()
	        commit()
	        read()
	*/
	// `init()` MUST be idempotent as it will be called more than once on a KeyValueStore in case
	// of a rollback.
	virtual Future<Void> init() { return Void(); }

	// Obtain the encryption mode of the storage. The encryption mode needs to match the encryption mode of the cluster.
	virtual Future<EncryptionAtRestMode> encryptionMode() = 0;

	// the files in localFileSets.
	// Throws an error if the store does not support SST ingestion or if ingestion fails.
	// It is the responsibility of the caller to ensure the directory exists and the fileSetMap is valid.
	virtual Future<Void> ingestSSTFiles(std::shared_ptr<BulkLoadFileSetKeyMap> localFileSets) {
		throw not_implemented();
	}

protected:
	virtual ~IKeyValueStore() {}
};

															#line 178 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/IKeyValueStore.actor.g.h.py_gen"
namespace {
// This generated class is to be used only via replaceRange_impl()
															#line 175 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/IKeyValueStore.actor.h"
template <class ReplaceRange_implActor>
															#line 175 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/IKeyValueStore.actor.h"
class ReplaceRange_implActorState {
															#line 185 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/IKeyValueStore.actor.g.h.py_gen"
public:
															#line 175 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/IKeyValueStore.actor.h"
	ReplaceRange_implActorState(IKeyValueStore* const& self,KeyRange const& range,Standalone<VectorRef<KeyValueRef>> const& data) 
															#line 175 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/IKeyValueStore.actor.h"
															#line 175 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/IKeyValueStore.actor.h"
		 : self(self),
															#line 175 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/IKeyValueStore.actor.h"
		   range(range),
															#line 175 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/IKeyValueStore.actor.h"
		   data(data),
															#line 178 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/IKeyValueStore.actor.h"
		   sinceYield(0),
															#line 179 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/IKeyValueStore.actor.h"
		   kvItr(data.begin()),
															#line 180 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/IKeyValueStore.actor.h"
		   rangeRef(range)
															#line 202 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/IKeyValueStore.actor.g.h.py_gen"
	{
		fdb_probe_actor_create("replaceRange_impl", reinterpret_cast<unsigned long>(this));

	}
	~ReplaceRange_implActorState() 
	{
		fdb_probe_actor_destroy("replaceRange_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 181 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/IKeyValueStore.actor.h"
			if (rangeRef.empty())
															#line 217 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/IKeyValueStore.actor.g.h.py_gen"
			{
															#line 182 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/IKeyValueStore.actor.h"
				if (!static_cast<ReplaceRange_implActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReplaceRange_implActorState(); static_cast<ReplaceRange_implActor*>(this)->destroy(); return 0; }
															#line 221 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/IKeyValueStore.actor.g.h.py_gen"
				new (&static_cast<ReplaceRange_implActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~ReplaceRange_implActorState();
				static_cast<ReplaceRange_implActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 184 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/IKeyValueStore.actor.h"
			self->clear(rangeRef);
															#line 185 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/IKeyValueStore.actor.h"
			;
															#line 231 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/IKeyValueStore.actor.g.h.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReplaceRange_implActorState();
		static_cast<ReplaceRange_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 192 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/IKeyValueStore.actor.h"
		if (!static_cast<ReplaceRange_implActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReplaceRange_implActorState(); static_cast<ReplaceRange_implActor*>(this)->destroy(); return 0; }
															#line 254 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/IKeyValueStore.actor.g.h.py_gen"
		new (&static_cast<ReplaceRange_implActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ReplaceRange_implActorState();
		static_cast<ReplaceRange_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 185 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/IKeyValueStore.actor.h"
		if (!(kvItr != data.end()))
															#line 273 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/IKeyValueStore.actor.g.h.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 186 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/IKeyValueStore.actor.h"
		self->set(*kvItr);
															#line 187 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/IKeyValueStore.actor.h"
		if (++sinceYield > 1000)
															#line 281 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/IKeyValueStore.actor.g.h.py_gen"
		{
															#line 188 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/IKeyValueStore.actor.h"
			StrictFuture<Void> __when_expr_0 = yield();
															#line 188 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/IKeyValueStore.actor.h"
			if (static_cast<ReplaceRange_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 287 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/IKeyValueStore.actor.g.h.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ReplaceRange_implActor*>(this)->actor_wait_state = 1;
															#line 188 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/IKeyValueStore.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReplaceRange_implActor, 0, Void >*>(static_cast<ReplaceRange_implActor*>(this)));
															#line 292 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/IKeyValueStore.actor.g.h.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 185 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/IKeyValueStore.actor.h"
		kvItr++;
															#line 319 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/IKeyValueStore.actor.g.h.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 189 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/IKeyValueStore.actor.h"
		sinceYield = 0;
															#line 328 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/IKeyValueStore.actor.g.h.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 189 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/IKeyValueStore.actor.h"
		sinceYield = 0;
															#line 337 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/IKeyValueStore.actor.g.h.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReplaceRange_implActor*>(this)->actor_wait_state > 0) static_cast<ReplaceRange_implActor*>(this)->actor_wait_state = 0;
		static_cast<ReplaceRange_implActor*>(this)->ActorCallback< ReplaceRange_implActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReplaceRange_implActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("replaceRange_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReplaceRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("replaceRange_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReplaceRange_implActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("replaceRange_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReplaceRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("replaceRange_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReplaceRange_implActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("replaceRange_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReplaceRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("replaceRange_impl", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 175 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/IKeyValueStore.actor.h"
	IKeyValueStore* self;
															#line 175 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/IKeyValueStore.actor.h"
	KeyRange range;
															#line 175 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/IKeyValueStore.actor.h"
	Standalone<VectorRef<KeyValueRef>> data;
															#line 178 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/IKeyValueStore.actor.h"
	int sinceYield;
															#line 179 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/IKeyValueStore.actor.h"
	const KeyValueRef* kvItr;
															#line 180 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/IKeyValueStore.actor.h"
	KeyRangeRef rangeRef;
															#line 429 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/IKeyValueStore.actor.g.h.py_gen"
};
// This generated class is to be used only via replaceRange_impl()
															#line 175 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/IKeyValueStore.actor.h"
class ReplaceRange_implActor final : public Actor<Void>, public ActorCallback< ReplaceRange_implActor, 0, Void >, public FastAllocated<ReplaceRange_implActor>, public ReplaceRange_implActorState<ReplaceRange_implActor> {
															#line 434 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/IKeyValueStore.actor.g.h.py_gen"
public:
	using FastAllocated<ReplaceRange_implActor>::operator new;
	using FastAllocated<ReplaceRange_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15217781118545829376UL, 2619258888125617920UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReplaceRange_implActor, 0, Void >;
															#line 175 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/IKeyValueStore.actor.h"
	ReplaceRange_implActor(IKeyValueStore* const& self,KeyRange const& range,Standalone<VectorRef<KeyValueRef>> const& data) 
															#line 451 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/IKeyValueStore.actor.g.h.py_gen"
		 : Actor<Void>(),
		   ReplaceRange_implActorState<ReplaceRange_implActor>(self, range, data),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("replaceRange_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16322104239388350464UL, 791934041982933248UL);
		ActorExecutionContextHelper __helper(static_cast<ReplaceRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("replaceRange_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("replaceRange_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReplaceRange_implActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 175 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/IKeyValueStore.actor.h"
[[nodiscard]] static Future<Void> replaceRange_impl( IKeyValueStore* const& self, KeyRange const& range, Standalone<VectorRef<KeyValueRef>> const& data ) {
															#line 175 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/IKeyValueStore.actor.h"
	return Future<Void>(new ReplaceRange_implActor(self, range, data));
															#line 484 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/IKeyValueStore.actor.g.h.py_gen"
}

#line 194 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/IKeyValueStore.actor.h"

#include "flow/unactorcompiler.h"
#endif
