#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
/*
 * KeyRangeMap.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/KeyRangeMap.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/CommitTransaction.h"
#include "fdbclient/FDBTypes.h"
#include "fdbclient/ReadYourWrites.h"
#include "flow/UnitTest.h"
#include "flow/actorcompiler.h" // has to be last include

void KeyRangeActorMap::getRangesAffectedByInsertion(const KeyRangeRef& keys, std::vector<KeyRange>& affectedRanges) {
	auto s = map.rangeContaining(keys.begin);
	if (s.begin() != keys.begin && s.value().isValid() && !s.value().isReady())
		affectedRanges.push_back(KeyRangeRef(s.begin(), keys.begin));
	affectedRanges.push_back(keys);
	auto e = map.rangeContaining(keys.end);
	if (e.begin() != keys.end && e.value().isValid() && !e.value().isReady())
		affectedRanges.push_back(KeyRangeRef(keys.end, e.end()));
}

RangeResult krmDecodeRanges(KeyRef mapPrefix, KeyRange keys, RangeResult kv, bool align) {
	ASSERT(!kv.more || kv.size() > 1);
	KeyRange withPrefix =
	    KeyRangeRef(mapPrefix.toString() + keys.begin.toString(), mapPrefix.toString() + keys.end.toString());

	RangeResult result;
	result.arena().dependsOn(kv.arena());
	result.arena().dependsOn(keys.arena());

	// Always push a kv pair <= keys.begin.
	KeyRef beginKey = keys.begin;
	if (!align && !kv.empty() && kv.front().key.startsWith(mapPrefix) && kv.front().key < withPrefix.begin) {
		beginKey = kv[0].key.removePrefix(mapPrefix);
	}
	ValueRef beginValue;
	if (!kv.empty() && kv.front().key.startsWith(mapPrefix) && kv.front().key <= withPrefix.begin) {
		beginValue = kv.front().value;
	}
	result.push_back(result.arena(), KeyValueRef(beginKey, beginValue));

	for (int i = 0; i < kv.size(); i++) {
		if (kv[i].key > withPrefix.begin && kv[i].key < withPrefix.end) {
			KeyRef k = kv[i].key.removePrefix(mapPrefix);
			result.push_back(result.arena(), KeyValueRef(k, kv[i].value));
		} else if (kv[i].key >= withPrefix.end) {
			kv.more = false;
			// There should be at most 1 value past mapPrefix + keys.end.
			ASSERT(i == kv.size() - 1);
			break;
		}
	}

	if (!kv.more) {
		KeyRef endKey = keys.end;
		if (!align && !kv.empty() && kv.back().key.startsWith(mapPrefix) && kv.back().key >= withPrefix.end) {
			endKey = kv.back().key.removePrefix(mapPrefix);
		}
		ValueRef endValue;
		if (!kv.empty()) {
			// In the aligned case, carry the last value to be the end value.
			if (align && kv.back().key.startsWith(mapPrefix) && kv.back().key > withPrefix.end) {
				endValue = result.back().value;
			} else {
				endValue = kv.back().value;
			}
		}
		result.push_back(result.arena(), KeyValueRef(endKey, endValue));
	}
	result.more = kv.more;

	return result;
}

// Returns keys.begin, all transitional points in keys, and keys.end, and their values
															#line 95 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via krmGetRanges()
															#line 93 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
template <class KrmGetRangesActor>
															#line 93 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
class KrmGetRangesActorState {
															#line 102 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
public:
															#line 93 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	KrmGetRangesActorState(Transaction* const& tr,Key const& mapPrefix,KeyRange const& keys,int const& limit,int const& limitBytes) 
															#line 93 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
															#line 93 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		 : tr(tr),
															#line 93 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		   mapPrefix(mapPrefix),
															#line 93 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		   keys(keys),
															#line 93 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		   limit(limit),
															#line 93 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		   limitBytes(limitBytes)
															#line 117 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("krmGetRanges", reinterpret_cast<unsigned long>(this));

	}
	~KrmGetRangesActorState() 
	{
		fdb_probe_actor_destroy("krmGetRanges", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 94 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			KeyRange withPrefix = KeyRangeRef(mapPrefix.toString() + keys.begin.toString(), mapPrefix.toString() + keys.end.toString());
															#line 97 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			limits = GetRangeLimits(limit, limitBytes);
															#line 98 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			limits.minRows = 2;
															#line 99 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr->getRange(lastLessOrEqual(withPrefix.begin), firstGreaterThan(withPrefix.end), limits);
															#line 99 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			if (static_cast<KrmGetRangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 140 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<KrmGetRangesActor*>(this)->actor_wait_state = 1;
															#line 99 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< KrmGetRangesActor, 0, RangeResult >*>(static_cast<KrmGetRangesActor*>(this)));
															#line 145 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~KrmGetRangesActorState();
		static_cast<KrmGetRangesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult const& kv,int loopDepth) 
	{
															#line 101 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		if (!static_cast<KrmGetRangesActor*>(this)->SAV<RangeResult>::futures) { (void)(krmDecodeRanges(mapPrefix, keys, kv)); this->~KrmGetRangesActorState(); static_cast<KrmGetRangesActor*>(this)->destroy(); return 0; }
															#line 168 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
		new (&static_cast<KrmGetRangesActor*>(this)->SAV< RangeResult >::value()) RangeResult(krmDecodeRanges(mapPrefix, keys, kv));
		this->~KrmGetRangesActorState();
		static_cast<KrmGetRangesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult && kv,int loopDepth) 
	{
															#line 101 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		if (!static_cast<KrmGetRangesActor*>(this)->SAV<RangeResult>::futures) { (void)(krmDecodeRanges(mapPrefix, keys, kv)); this->~KrmGetRangesActorState(); static_cast<KrmGetRangesActor*>(this)->destroy(); return 0; }
															#line 180 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
		new (&static_cast<KrmGetRangesActor*>(this)->SAV< RangeResult >::value()) RangeResult(krmDecodeRanges(mapPrefix, keys, kv));
		this->~KrmGetRangesActorState();
		static_cast<KrmGetRangesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(RangeResult const& kv,int loopDepth) 
	{
		loopDepth = a_body1cont1(kv, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && kv,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(kv), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<KrmGetRangesActor*>(this)->actor_wait_state > 0) static_cast<KrmGetRangesActor*>(this)->actor_wait_state = 0;
		static_cast<KrmGetRangesActor*>(this)->ActorCallback< KrmGetRangesActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< KrmGetRangesActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("krmGetRanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KrmGetRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("krmGetRanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< KrmGetRangesActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("krmGetRanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KrmGetRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("krmGetRanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< KrmGetRangesActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("krmGetRanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<KrmGetRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("krmGetRanges", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 93 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	Transaction* tr;
															#line 93 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	Key mapPrefix;
															#line 93 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	KeyRange keys;
															#line 93 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	int limit;
															#line 93 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	int limitBytes;
															#line 97 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	GetRangeLimits limits;
															#line 275 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
};
// This generated class is to be used only via krmGetRanges()
															#line 93 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
class KrmGetRangesActor final : public Actor<RangeResult>, public ActorCallback< KrmGetRangesActor, 0, RangeResult >, public FastAllocated<KrmGetRangesActor>, public KrmGetRangesActorState<KrmGetRangesActor> {
															#line 280 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
public:
	using FastAllocated<KrmGetRangesActor>::operator new;
	using FastAllocated<KrmGetRangesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12986396164783300864UL, 7411955629984579072UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RangeResult>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< KrmGetRangesActor, 0, RangeResult >;
															#line 93 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	KrmGetRangesActor(Transaction* const& tr,Key const& mapPrefix,KeyRange const& keys,int const& limit,int const& limitBytes) 
															#line 297 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
		 : Actor<RangeResult>(),
		   KrmGetRangesActorState<KrmGetRangesActor>(tr, mapPrefix, keys, limit, limitBytes),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("krmGetRanges", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13795759781759462144UL, 1618297057399835648UL);
		ActorExecutionContextHelper __helper(static_cast<KrmGetRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("krmGetRanges");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("krmGetRanges", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< KrmGetRangesActor, 0, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 93 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
[[nodiscard]] Future<RangeResult> krmGetRanges( Transaction* const& tr, Key const& mapPrefix, KeyRange const& keys, int const& limit, int const& limitBytes ) {
															#line 93 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	return Future<RangeResult>(new KrmGetRangesActor(tr, mapPrefix, keys, limit, limitBytes));
															#line 330 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
}

#line 103 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"

															#line 335 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via krmGetRanges()
															#line 104 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
template <class KrmGetRangesActor1>
															#line 104 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
class KrmGetRangesActor1State {
															#line 342 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
public:
															#line 104 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	KrmGetRangesActor1State(Reference<ReadYourWritesTransaction> const& tr,Key const& mapPrefix,KeyRange const& keys,int const& limit,int const& limitBytes) 
															#line 104 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
															#line 104 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		 : tr(tr),
															#line 104 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		   mapPrefix(mapPrefix),
															#line 104 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		   keys(keys),
															#line 104 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		   limit(limit),
															#line 104 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		   limitBytes(limitBytes)
															#line 357 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("krmGetRanges", reinterpret_cast<unsigned long>(this));

	}
	~KrmGetRangesActor1State() 
	{
		fdb_probe_actor_destroy("krmGetRanges", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 109 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			KeyRange withPrefix = KeyRangeRef(mapPrefix.toString() + keys.begin.toString(), mapPrefix.toString() + keys.end.toString());
															#line 112 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			limits = GetRangeLimits(limit, limitBytes);
															#line 113 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			limits.minRows = 2;
															#line 114 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr->getRange(lastLessOrEqual(withPrefix.begin), firstGreaterThan(withPrefix.end), limits);
															#line 114 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			if (static_cast<KrmGetRangesActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 380 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<KrmGetRangesActor1*>(this)->actor_wait_state = 1;
															#line 114 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< KrmGetRangesActor1, 0, RangeResult >*>(static_cast<KrmGetRangesActor1*>(this)));
															#line 385 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~KrmGetRangesActor1State();
		static_cast<KrmGetRangesActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult const& kv,int loopDepth) 
	{
															#line 116 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		if (!static_cast<KrmGetRangesActor1*>(this)->SAV<RangeResult>::futures) { (void)(krmDecodeRanges(mapPrefix, keys, kv)); this->~KrmGetRangesActor1State(); static_cast<KrmGetRangesActor1*>(this)->destroy(); return 0; }
															#line 408 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
		new (&static_cast<KrmGetRangesActor1*>(this)->SAV< RangeResult >::value()) RangeResult(krmDecodeRanges(mapPrefix, keys, kv));
		this->~KrmGetRangesActor1State();
		static_cast<KrmGetRangesActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult && kv,int loopDepth) 
	{
															#line 116 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		if (!static_cast<KrmGetRangesActor1*>(this)->SAV<RangeResult>::futures) { (void)(krmDecodeRanges(mapPrefix, keys, kv)); this->~KrmGetRangesActor1State(); static_cast<KrmGetRangesActor1*>(this)->destroy(); return 0; }
															#line 420 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
		new (&static_cast<KrmGetRangesActor1*>(this)->SAV< RangeResult >::value()) RangeResult(krmDecodeRanges(mapPrefix, keys, kv));
		this->~KrmGetRangesActor1State();
		static_cast<KrmGetRangesActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(RangeResult const& kv,int loopDepth) 
	{
		loopDepth = a_body1cont1(kv, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && kv,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(kv), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<KrmGetRangesActor1*>(this)->actor_wait_state > 0) static_cast<KrmGetRangesActor1*>(this)->actor_wait_state = 0;
		static_cast<KrmGetRangesActor1*>(this)->ActorCallback< KrmGetRangesActor1, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< KrmGetRangesActor1, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("krmGetRanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KrmGetRangesActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("krmGetRanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< KrmGetRangesActor1, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("krmGetRanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KrmGetRangesActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("krmGetRanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< KrmGetRangesActor1, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("krmGetRanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<KrmGetRangesActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("krmGetRanges", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 104 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 104 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	Key mapPrefix;
															#line 104 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	KeyRange keys;
															#line 104 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	int limit;
															#line 104 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	int limitBytes;
															#line 112 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	GetRangeLimits limits;
															#line 515 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
};
// This generated class is to be used only via krmGetRanges()
															#line 104 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
class KrmGetRangesActor1 final : public Actor<RangeResult>, public ActorCallback< KrmGetRangesActor1, 0, RangeResult >, public FastAllocated<KrmGetRangesActor1>, public KrmGetRangesActor1State<KrmGetRangesActor1> {
															#line 520 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
public:
	using FastAllocated<KrmGetRangesActor1>::operator new;
	using FastAllocated<KrmGetRangesActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12986396164783300864UL, 7411955629984579072UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RangeResult>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< KrmGetRangesActor1, 0, RangeResult >;
															#line 104 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	KrmGetRangesActor1(Reference<ReadYourWritesTransaction> const& tr,Key const& mapPrefix,KeyRange const& keys,int const& limit,int const& limitBytes) 
															#line 537 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
		 : Actor<RangeResult>(),
		   KrmGetRangesActor1State<KrmGetRangesActor1>(tr, mapPrefix, keys, limit, limitBytes),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("krmGetRanges", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14976711779412651776UL, 13902446956425408000UL);
		ActorExecutionContextHelper __helper(static_cast<KrmGetRangesActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("krmGetRanges");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("krmGetRanges", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< KrmGetRangesActor1, 0, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 104 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
[[nodiscard]] Future<RangeResult> krmGetRanges( Reference<ReadYourWritesTransaction> const& tr, Key const& mapPrefix, KeyRange const& keys, int const& limit, int const& limitBytes ) {
															#line 104 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	return Future<RangeResult>(new KrmGetRangesActor1(tr, mapPrefix, keys, limit, limitBytes));
															#line 570 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
}

#line 118 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"

// Returns keys.begin, all transitional points in keys, and keys.end, and their values
															#line 576 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via krmGetRangesUnaligned()
															#line 120 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
template <class KrmGetRangesUnalignedActor>
															#line 120 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
class KrmGetRangesUnalignedActorState {
															#line 583 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
public:
															#line 120 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	KrmGetRangesUnalignedActorState(Transaction* const& tr,Key const& mapPrefix,KeyRange const& keys,int const& limit,int const& limitBytes) 
															#line 120 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
															#line 120 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		 : tr(tr),
															#line 120 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		   mapPrefix(mapPrefix),
															#line 120 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		   keys(keys),
															#line 120 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		   limit(limit),
															#line 120 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		   limitBytes(limitBytes)
															#line 598 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("krmGetRangesUnaligned", reinterpret_cast<unsigned long>(this));

	}
	~KrmGetRangesUnalignedActorState() 
	{
		fdb_probe_actor_destroy("krmGetRangesUnaligned", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 125 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			KeyRange withPrefix = KeyRangeRef(mapPrefix.toString() + keys.begin.toString(), mapPrefix.toString() + keys.end.toString());
															#line 128 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			limits = GetRangeLimits(limit, limitBytes);
															#line 129 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			limits.minRows = 2;
															#line 132 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr->getRange(lastLessOrEqual(withPrefix.begin), KeySelectorRef(withPrefix.end, false, +2), limits);
															#line 132 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			if (static_cast<KrmGetRangesUnalignedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 621 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<KrmGetRangesUnalignedActor*>(this)->actor_wait_state = 1;
															#line 132 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< KrmGetRangesUnalignedActor, 0, RangeResult >*>(static_cast<KrmGetRangesUnalignedActor*>(this)));
															#line 626 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~KrmGetRangesUnalignedActorState();
		static_cast<KrmGetRangesUnalignedActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult const& kv,int loopDepth) 
	{
															#line 135 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		if (!static_cast<KrmGetRangesUnalignedActor*>(this)->SAV<RangeResult>::futures) { (void)(krmDecodeRanges(mapPrefix, keys, kv, false)); this->~KrmGetRangesUnalignedActorState(); static_cast<KrmGetRangesUnalignedActor*>(this)->destroy(); return 0; }
															#line 649 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
		new (&static_cast<KrmGetRangesUnalignedActor*>(this)->SAV< RangeResult >::value()) RangeResult(krmDecodeRanges(mapPrefix, keys, kv, false));
		this->~KrmGetRangesUnalignedActorState();
		static_cast<KrmGetRangesUnalignedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult && kv,int loopDepth) 
	{
															#line 135 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		if (!static_cast<KrmGetRangesUnalignedActor*>(this)->SAV<RangeResult>::futures) { (void)(krmDecodeRanges(mapPrefix, keys, kv, false)); this->~KrmGetRangesUnalignedActorState(); static_cast<KrmGetRangesUnalignedActor*>(this)->destroy(); return 0; }
															#line 661 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
		new (&static_cast<KrmGetRangesUnalignedActor*>(this)->SAV< RangeResult >::value()) RangeResult(krmDecodeRanges(mapPrefix, keys, kv, false));
		this->~KrmGetRangesUnalignedActorState();
		static_cast<KrmGetRangesUnalignedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(RangeResult const& kv,int loopDepth) 
	{
		loopDepth = a_body1cont1(kv, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && kv,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(kv), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<KrmGetRangesUnalignedActor*>(this)->actor_wait_state > 0) static_cast<KrmGetRangesUnalignedActor*>(this)->actor_wait_state = 0;
		static_cast<KrmGetRangesUnalignedActor*>(this)->ActorCallback< KrmGetRangesUnalignedActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< KrmGetRangesUnalignedActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("krmGetRangesUnaligned", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KrmGetRangesUnalignedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("krmGetRangesUnaligned", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< KrmGetRangesUnalignedActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("krmGetRangesUnaligned", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KrmGetRangesUnalignedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("krmGetRangesUnaligned", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< KrmGetRangesUnalignedActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("krmGetRangesUnaligned", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<KrmGetRangesUnalignedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("krmGetRangesUnaligned", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 120 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	Transaction* tr;
															#line 120 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	Key mapPrefix;
															#line 120 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	KeyRange keys;
															#line 120 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	int limit;
															#line 120 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	int limitBytes;
															#line 128 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	GetRangeLimits limits;
															#line 756 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
};
// This generated class is to be used only via krmGetRangesUnaligned()
															#line 120 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
class KrmGetRangesUnalignedActor final : public Actor<RangeResult>, public ActorCallback< KrmGetRangesUnalignedActor, 0, RangeResult >, public FastAllocated<KrmGetRangesUnalignedActor>, public KrmGetRangesUnalignedActorState<KrmGetRangesUnalignedActor> {
															#line 761 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
public:
	using FastAllocated<KrmGetRangesUnalignedActor>::operator new;
	using FastAllocated<KrmGetRangesUnalignedActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1673177124605206272UL, 847746000527315200UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RangeResult>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< KrmGetRangesUnalignedActor, 0, RangeResult >;
															#line 120 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	KrmGetRangesUnalignedActor(Transaction* const& tr,Key const& mapPrefix,KeyRange const& keys,int const& limit,int const& limitBytes) 
															#line 778 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
		 : Actor<RangeResult>(),
		   KrmGetRangesUnalignedActorState<KrmGetRangesUnalignedActor>(tr, mapPrefix, keys, limit, limitBytes),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("krmGetRangesUnaligned", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12219080355080412160UL, 17427625736326182400UL);
		ActorExecutionContextHelper __helper(static_cast<KrmGetRangesUnalignedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("krmGetRangesUnaligned");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("krmGetRangesUnaligned", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< KrmGetRangesUnalignedActor, 0, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 120 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
[[nodiscard]] Future<RangeResult> krmGetRangesUnaligned( Transaction* const& tr, Key const& mapPrefix, KeyRange const& keys, int const& limit, int const& limitBytes ) {
															#line 120 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	return Future<RangeResult>(new KrmGetRangesUnalignedActor(tr, mapPrefix, keys, limit, limitBytes));
															#line 811 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
}

#line 137 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"

															#line 816 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via krmGetRangesUnaligned()
															#line 138 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
template <class KrmGetRangesUnalignedActor1>
															#line 138 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
class KrmGetRangesUnalignedActor1State {
															#line 823 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
public:
															#line 138 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	KrmGetRangesUnalignedActor1State(Reference<ReadYourWritesTransaction> const& tr,Key const& mapPrefix,KeyRange const& keys,int const& limit,int const& limitBytes) 
															#line 138 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
															#line 138 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		 : tr(tr),
															#line 138 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		   mapPrefix(mapPrefix),
															#line 138 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		   keys(keys),
															#line 138 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		   limit(limit),
															#line 138 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		   limitBytes(limitBytes)
															#line 838 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("krmGetRangesUnaligned", reinterpret_cast<unsigned long>(this));

	}
	~KrmGetRangesUnalignedActor1State() 
	{
		fdb_probe_actor_destroy("krmGetRangesUnaligned", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 143 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			KeyRange withPrefix = KeyRangeRef(mapPrefix.toString() + keys.begin.toString(), mapPrefix.toString() + keys.end.toString());
															#line 146 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			limits = GetRangeLimits(limit, limitBytes);
															#line 147 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			limits.minRows = 2;
															#line 150 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr->getRange(lastLessOrEqual(withPrefix.begin), KeySelectorRef(withPrefix.end, false, +2), limits);
															#line 150 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			if (static_cast<KrmGetRangesUnalignedActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 861 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<KrmGetRangesUnalignedActor1*>(this)->actor_wait_state = 1;
															#line 150 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< KrmGetRangesUnalignedActor1, 0, RangeResult >*>(static_cast<KrmGetRangesUnalignedActor1*>(this)));
															#line 866 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~KrmGetRangesUnalignedActor1State();
		static_cast<KrmGetRangesUnalignedActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult const& kv,int loopDepth) 
	{
															#line 153 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		if (!static_cast<KrmGetRangesUnalignedActor1*>(this)->SAV<RangeResult>::futures) { (void)(krmDecodeRanges(mapPrefix, keys, kv, false)); this->~KrmGetRangesUnalignedActor1State(); static_cast<KrmGetRangesUnalignedActor1*>(this)->destroy(); return 0; }
															#line 889 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
		new (&static_cast<KrmGetRangesUnalignedActor1*>(this)->SAV< RangeResult >::value()) RangeResult(krmDecodeRanges(mapPrefix, keys, kv, false));
		this->~KrmGetRangesUnalignedActor1State();
		static_cast<KrmGetRangesUnalignedActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult && kv,int loopDepth) 
	{
															#line 153 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		if (!static_cast<KrmGetRangesUnalignedActor1*>(this)->SAV<RangeResult>::futures) { (void)(krmDecodeRanges(mapPrefix, keys, kv, false)); this->~KrmGetRangesUnalignedActor1State(); static_cast<KrmGetRangesUnalignedActor1*>(this)->destroy(); return 0; }
															#line 901 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
		new (&static_cast<KrmGetRangesUnalignedActor1*>(this)->SAV< RangeResult >::value()) RangeResult(krmDecodeRanges(mapPrefix, keys, kv, false));
		this->~KrmGetRangesUnalignedActor1State();
		static_cast<KrmGetRangesUnalignedActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(RangeResult const& kv,int loopDepth) 
	{
		loopDepth = a_body1cont1(kv, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && kv,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(kv), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<KrmGetRangesUnalignedActor1*>(this)->actor_wait_state > 0) static_cast<KrmGetRangesUnalignedActor1*>(this)->actor_wait_state = 0;
		static_cast<KrmGetRangesUnalignedActor1*>(this)->ActorCallback< KrmGetRangesUnalignedActor1, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< KrmGetRangesUnalignedActor1, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("krmGetRangesUnaligned", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KrmGetRangesUnalignedActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("krmGetRangesUnaligned", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< KrmGetRangesUnalignedActor1, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("krmGetRangesUnaligned", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KrmGetRangesUnalignedActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("krmGetRangesUnaligned", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< KrmGetRangesUnalignedActor1, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("krmGetRangesUnaligned", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<KrmGetRangesUnalignedActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("krmGetRangesUnaligned", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 138 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 138 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	Key mapPrefix;
															#line 138 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	KeyRange keys;
															#line 138 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	int limit;
															#line 138 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	int limitBytes;
															#line 146 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	GetRangeLimits limits;
															#line 996 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
};
// This generated class is to be used only via krmGetRangesUnaligned()
															#line 138 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
class KrmGetRangesUnalignedActor1 final : public Actor<RangeResult>, public ActorCallback< KrmGetRangesUnalignedActor1, 0, RangeResult >, public FastAllocated<KrmGetRangesUnalignedActor1>, public KrmGetRangesUnalignedActor1State<KrmGetRangesUnalignedActor1> {
															#line 1001 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
public:
	using FastAllocated<KrmGetRangesUnalignedActor1>::operator new;
	using FastAllocated<KrmGetRangesUnalignedActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1673177124605206272UL, 847746000527315200UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RangeResult>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< KrmGetRangesUnalignedActor1, 0, RangeResult >;
															#line 138 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	KrmGetRangesUnalignedActor1(Reference<ReadYourWritesTransaction> const& tr,Key const& mapPrefix,KeyRange const& keys,int const& limit,int const& limitBytes) 
															#line 1018 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
		 : Actor<RangeResult>(),
		   KrmGetRangesUnalignedActor1State<KrmGetRangesUnalignedActor1>(tr, mapPrefix, keys, limit, limitBytes),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("krmGetRangesUnaligned", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3382900249396337920UL, 5784484002577918720UL);
		ActorExecutionContextHelper __helper(static_cast<KrmGetRangesUnalignedActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("krmGetRangesUnaligned");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("krmGetRangesUnaligned", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< KrmGetRangesUnalignedActor1, 0, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 138 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
[[nodiscard]] Future<RangeResult> krmGetRangesUnaligned( Reference<ReadYourWritesTransaction> const& tr, Key const& mapPrefix, KeyRange const& keys, int const& limit, int const& limitBytes ) {
															#line 138 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	return Future<RangeResult>(new KrmGetRangesUnalignedActor1(tr, mapPrefix, keys, limit, limitBytes));
															#line 1051 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
}

#line 155 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"

void krmSetPreviouslyEmptyRange(Transaction* tr,
                                const KeyRef& mapPrefix,
                                const KeyRangeRef& keys,
                                const ValueRef& newValue,
                                const ValueRef& oldEndValue) {
	KeyRange withPrefix =
	    KeyRangeRef(mapPrefix.toString() + keys.begin.toString(), mapPrefix.toString() + keys.end.toString());
	tr->set(withPrefix.begin, newValue);
	tr->set(withPrefix.end, oldEndValue);
}

void krmSetPreviouslyEmptyRange(CommitTransactionRef& tr,
                                Arena& trArena,
                                const KeyRef& mapPrefix,
                                const KeyRangeRef& keys,
                                const ValueRef& newValue,
                                const ValueRef& oldEndValue) {
	KeyRange withPrefix =
	    KeyRangeRef(mapPrefix.toString() + keys.begin.toString(), mapPrefix.toString() + keys.end.toString());
	tr.set(trArena, withPrefix.begin, newValue);
	tr.set(trArena, withPrefix.end, oldEndValue);
}

															#line 1079 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via krmSetRange()
															#line 179 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
template <class KrmSetRangeActor>
															#line 179 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
class KrmSetRangeActorState {
															#line 1086 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
public:
															#line 179 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	KrmSetRangeActorState(Transaction* const& tr,Key const& mapPrefix,KeyRange const& range,Value const& value) 
															#line 179 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
															#line 179 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		 : tr(tr),
															#line 179 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		   mapPrefix(mapPrefix),
															#line 179 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		   range(range),
															#line 179 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		   value(value),
															#line 180 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		   withPrefix(KeyRangeRef(mapPrefix.toString() + range.begin.toString(), mapPrefix.toString() + range.end.toString()))
															#line 1101 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("krmSetRange", reinterpret_cast<unsigned long>(this));

	}
	~KrmSetRangeActorState() 
	{
		fdb_probe_actor_destroy("krmSetRange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 182 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr->getRange(lastLessOrEqual(withPrefix.end), firstGreaterThan(withPrefix.end), 1, Snapshot::True);
															#line 182 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			if (static_cast<KrmSetRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1118 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<KrmSetRangeActor*>(this)->actor_wait_state = 1;
															#line 182 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< KrmSetRangeActor, 0, RangeResult >*>(static_cast<KrmSetRangeActor*>(this)));
															#line 1123 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~KrmSetRangeActorState();
		static_cast<KrmSetRangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult const& old,int loopDepth) 
	{
															#line 185 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		Value oldValue;
															#line 186 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		bool hasResult = old.size() > 0 && old[0].key.startsWith(mapPrefix);
															#line 187 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		if (hasResult)
															#line 1150 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
		{
															#line 188 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			oldValue = old[0].value;
															#line 1154 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
		}
															#line 190 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		KeyRange conflictRange = KeyRangeRef(hasResult ? old[0].key : mapPrefix.toString(), keyAfter(withPrefix.end));
															#line 191 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		if (!conflictRange.empty())
															#line 1160 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
		{
															#line 192 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			tr->addReadConflictRange(conflictRange);
															#line 1164 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
		}
															#line 194 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		tr->clear(withPrefix);
															#line 195 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		tr->set(withPrefix.begin, value);
															#line 196 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		tr->set(withPrefix.end, oldValue);
															#line 198 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		if (!static_cast<KrmSetRangeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~KrmSetRangeActorState(); static_cast<KrmSetRangeActor*>(this)->destroy(); return 0; }
															#line 1174 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
		new (&static_cast<KrmSetRangeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~KrmSetRangeActorState();
		static_cast<KrmSetRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult && old,int loopDepth) 
	{
															#line 185 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		Value oldValue;
															#line 186 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		bool hasResult = old.size() > 0 && old[0].key.startsWith(mapPrefix);
															#line 187 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		if (hasResult)
															#line 1190 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
		{
															#line 188 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			oldValue = old[0].value;
															#line 1194 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
		}
															#line 190 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		KeyRange conflictRange = KeyRangeRef(hasResult ? old[0].key : mapPrefix.toString(), keyAfter(withPrefix.end));
															#line 191 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		if (!conflictRange.empty())
															#line 1200 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
		{
															#line 192 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			tr->addReadConflictRange(conflictRange);
															#line 1204 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
		}
															#line 194 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		tr->clear(withPrefix);
															#line 195 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		tr->set(withPrefix.begin, value);
															#line 196 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		tr->set(withPrefix.end, oldValue);
															#line 198 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		if (!static_cast<KrmSetRangeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~KrmSetRangeActorState(); static_cast<KrmSetRangeActor*>(this)->destroy(); return 0; }
															#line 1214 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
		new (&static_cast<KrmSetRangeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~KrmSetRangeActorState();
		static_cast<KrmSetRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(RangeResult const& old,int loopDepth) 
	{
		loopDepth = a_body1cont1(old, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && old,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(old), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<KrmSetRangeActor*>(this)->actor_wait_state > 0) static_cast<KrmSetRangeActor*>(this)->actor_wait_state = 0;
		static_cast<KrmSetRangeActor*>(this)->ActorCallback< KrmSetRangeActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< KrmSetRangeActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("krmSetRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KrmSetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("krmSetRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< KrmSetRangeActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("krmSetRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KrmSetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("krmSetRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< KrmSetRangeActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("krmSetRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<KrmSetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("krmSetRange", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 179 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	Transaction* tr;
															#line 179 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	Key mapPrefix;
															#line 179 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	KeyRange range;
															#line 179 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	Value value;
															#line 180 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	KeyRange withPrefix;
															#line 1307 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
};
// This generated class is to be used only via krmSetRange()
															#line 179 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
class KrmSetRangeActor final : public Actor<Void>, public ActorCallback< KrmSetRangeActor, 0, RangeResult >, public FastAllocated<KrmSetRangeActor>, public KrmSetRangeActorState<KrmSetRangeActor> {
															#line 1312 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
public:
	using FastAllocated<KrmSetRangeActor>::operator new;
	using FastAllocated<KrmSetRangeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6828942763931762944UL, 10403392908931502336UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< KrmSetRangeActor, 0, RangeResult >;
															#line 179 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	KrmSetRangeActor(Transaction* const& tr,Key const& mapPrefix,KeyRange const& range,Value const& value) 
															#line 1329 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   KrmSetRangeActorState<KrmSetRangeActor>(tr, mapPrefix, range, value),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("krmSetRange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11817283831847622400UL, 312000902216975872UL);
		ActorExecutionContextHelper __helper(static_cast<KrmSetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("krmSetRange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("krmSetRange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< KrmSetRangeActor, 0, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 179 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
[[nodiscard]] Future<Void> krmSetRange( Transaction* const& tr, Key const& mapPrefix, KeyRange const& range, Value const& value ) {
															#line 179 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	return Future<Void>(new KrmSetRangeActor(tr, mapPrefix, range, value));
															#line 1362 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
}

#line 200 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"

															#line 1367 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via krmSetRange()
															#line 201 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
template <class KrmSetRangeActor1>
															#line 201 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
class KrmSetRangeActor1State {
															#line 1374 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
public:
															#line 201 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	KrmSetRangeActor1State(Reference<ReadYourWritesTransaction> const& tr,Key const& mapPrefix,KeyRange const& range,Value const& value) 
															#line 201 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
															#line 201 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		 : tr(tr),
															#line 201 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		   mapPrefix(mapPrefix),
															#line 201 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		   range(range),
															#line 201 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		   value(value),
															#line 202 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		   withPrefix(KeyRangeRef(mapPrefix.toString() + range.begin.toString(), mapPrefix.toString() + range.end.toString()))
															#line 1389 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("krmSetRange", reinterpret_cast<unsigned long>(this));

	}
	~KrmSetRangeActor1State() 
	{
		fdb_probe_actor_destroy("krmSetRange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 204 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr->getRange(lastLessOrEqual(withPrefix.end), firstGreaterThan(withPrefix.end), 1, Snapshot::True);
															#line 204 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			if (static_cast<KrmSetRangeActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1406 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<KrmSetRangeActor1*>(this)->actor_wait_state = 1;
															#line 204 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< KrmSetRangeActor1, 0, RangeResult >*>(static_cast<KrmSetRangeActor1*>(this)));
															#line 1411 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~KrmSetRangeActor1State();
		static_cast<KrmSetRangeActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult const& old,int loopDepth) 
	{
															#line 207 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		Value oldValue;
															#line 208 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		bool hasResult = old.size() > 0 && old[0].key.startsWith(mapPrefix);
															#line 209 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		if (hasResult)
															#line 1438 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
		{
															#line 210 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			oldValue = old[0].value;
															#line 1442 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
		}
															#line 212 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		KeyRange conflictRange = KeyRangeRef(hasResult ? old[0].key : mapPrefix.toString(), keyAfter(withPrefix.end));
															#line 213 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		if (!conflictRange.empty())
															#line 1448 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
		{
															#line 214 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			tr->addReadConflictRange(conflictRange);
															#line 1452 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
		}
															#line 216 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		tr->clear(withPrefix);
															#line 217 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		tr->set(withPrefix.begin, value);
															#line 220 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		tr->set(withPrefix.end, oldValue);
															#line 222 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		if (!static_cast<KrmSetRangeActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~KrmSetRangeActor1State(); static_cast<KrmSetRangeActor1*>(this)->destroy(); return 0; }
															#line 1462 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
		new (&static_cast<KrmSetRangeActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~KrmSetRangeActor1State();
		static_cast<KrmSetRangeActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult && old,int loopDepth) 
	{
															#line 207 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		Value oldValue;
															#line 208 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		bool hasResult = old.size() > 0 && old[0].key.startsWith(mapPrefix);
															#line 209 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		if (hasResult)
															#line 1478 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
		{
															#line 210 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			oldValue = old[0].value;
															#line 1482 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
		}
															#line 212 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		KeyRange conflictRange = KeyRangeRef(hasResult ? old[0].key : mapPrefix.toString(), keyAfter(withPrefix.end));
															#line 213 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		if (!conflictRange.empty())
															#line 1488 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
		{
															#line 214 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			tr->addReadConflictRange(conflictRange);
															#line 1492 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
		}
															#line 216 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		tr->clear(withPrefix);
															#line 217 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		tr->set(withPrefix.begin, value);
															#line 220 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		tr->set(withPrefix.end, oldValue);
															#line 222 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		if (!static_cast<KrmSetRangeActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~KrmSetRangeActor1State(); static_cast<KrmSetRangeActor1*>(this)->destroy(); return 0; }
															#line 1502 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
		new (&static_cast<KrmSetRangeActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~KrmSetRangeActor1State();
		static_cast<KrmSetRangeActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(RangeResult const& old,int loopDepth) 
	{
		loopDepth = a_body1cont1(old, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && old,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(old), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<KrmSetRangeActor1*>(this)->actor_wait_state > 0) static_cast<KrmSetRangeActor1*>(this)->actor_wait_state = 0;
		static_cast<KrmSetRangeActor1*>(this)->ActorCallback< KrmSetRangeActor1, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< KrmSetRangeActor1, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("krmSetRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KrmSetRangeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("krmSetRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< KrmSetRangeActor1, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("krmSetRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KrmSetRangeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("krmSetRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< KrmSetRangeActor1, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("krmSetRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<KrmSetRangeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("krmSetRange", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 201 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 201 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	Key mapPrefix;
															#line 201 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	KeyRange range;
															#line 201 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	Value value;
															#line 202 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	KeyRange withPrefix;
															#line 1595 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
};
// This generated class is to be used only via krmSetRange()
															#line 201 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
class KrmSetRangeActor1 final : public Actor<Void>, public ActorCallback< KrmSetRangeActor1, 0, RangeResult >, public FastAllocated<KrmSetRangeActor1>, public KrmSetRangeActor1State<KrmSetRangeActor1> {
															#line 1600 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
public:
	using FastAllocated<KrmSetRangeActor1>::operator new;
	using FastAllocated<KrmSetRangeActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6828942763931762944UL, 10403392908931502336UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< KrmSetRangeActor1, 0, RangeResult >;
															#line 201 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	KrmSetRangeActor1(Reference<ReadYourWritesTransaction> const& tr,Key const& mapPrefix,KeyRange const& range,Value const& value) 
															#line 1617 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   KrmSetRangeActor1State<KrmSetRangeActor1>(tr, mapPrefix, range, value),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("krmSetRange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3065547193003535616UL, 9725632332236508160UL);
		ActorExecutionContextHelper __helper(static_cast<KrmSetRangeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("krmSetRange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("krmSetRange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< KrmSetRangeActor1, 0, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 201 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
[[nodiscard]] Future<Void> krmSetRange( Reference<ReadYourWritesTransaction> const& tr, Key const& mapPrefix, KeyRange const& range, Value const& value ) {
															#line 201 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	return Future<Void>(new KrmSetRangeActor1(tr, mapPrefix, range, value));
															#line 1650 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
}

#line 224 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"

// Sets a range of keys in a key range map, coalescing with adjacent regions if the values match
// Ranges outside of maxRange will not be coalesced
// CAUTION: use care when attempting to coalesce multiple ranges in the same prefix in a single transaction
															#line 1658 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via krmSetRangeCoalescing_()
															#line 228 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
template <class Transaction, class KrmSetRangeCoalescing_Actor>
															#line 228 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
class KrmSetRangeCoalescing_ActorState {
															#line 1665 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
public:
															#line 228 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	KrmSetRangeCoalescing_ActorState(Transaction* const& tr,Key const& mapPrefix,KeyRange const& range,KeyRange const& maxRange,Value const& value) 
															#line 228 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
															#line 228 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		 : tr(tr),
															#line 228 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		   mapPrefix(mapPrefix),
															#line 228 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		   range(range),
															#line 228 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		   maxRange(maxRange),
															#line 228 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		   value(value)
															#line 1680 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("krmSetRangeCoalescing_", reinterpret_cast<unsigned long>(this));

	}
	~KrmSetRangeCoalescing_ActorState() 
	{
		fdb_probe_actor_destroy("krmSetRangeCoalescing_", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 234 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			ASSERT(maxRange.contains(range));
															#line 236 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			withPrefix = KeyRangeRef(mapPrefix.toString() + range.begin.toString(), mapPrefix.toString() + range.end.toString());
															#line 238 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			maxWithPrefix = KeyRangeRef(mapPrefix.toString() + maxRange.begin.toString(), mapPrefix.toString() + maxRange.end.toString());
															#line 241 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			keys = std::vector<Future<RangeResult>>();
															#line 242 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			keys.push_back( tr->getRange(lastLessThan(withPrefix.begin), firstGreaterOrEqual(withPrefix.begin), 1, Snapshot::True));
															#line 244 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			keys.push_back( tr->getRange(lastLessOrEqual(withPrefix.end), firstGreaterThan(withPrefix.end) + 1, 2, Snapshot::True));
															#line 246 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(keys);
															#line 246 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			if (static_cast<KrmSetRangeCoalescing_Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1709 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<KrmSetRangeCoalescing_Actor*>(this)->actor_wait_state = 1;
															#line 246 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< KrmSetRangeCoalescing_Actor, 0, Void >*>(static_cast<KrmSetRangeCoalescing_Actor*>(this)));
															#line 1714 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~KrmSetRangeCoalescing_ActorState();
		static_cast<KrmSetRangeCoalescing_Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 249 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		auto beginRange = keys[0].get();
															#line 250 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		bool hasBegin = beginRange.size() > 0 && beginRange[0].key.startsWith(mapPrefix);
															#line 251 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		Value beginValue = hasBegin ? beginRange[0].value : ""_sr;
															#line 253 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		beginKey = withPrefix.begin;
															#line 254 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		if (beginValue == value)
															#line 1745 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
		{
															#line 255 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			bool outsideRange = !hasBegin || beginRange[0].key < maxWithPrefix.begin;
															#line 256 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			beginKey = outsideRange ? maxWithPrefix.begin : beginRange[0].key;
															#line 1751 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
		}
															#line 260 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		auto endRange = keys[1].get();
															#line 261 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		bool hasEnd = endRange.size() >= 1 && endRange[0].key.startsWith(mapPrefix) && endRange[0].key <= withPrefix.end;
															#line 262 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		bool hasNext = (endRange.size() == 2 && endRange[1].key.startsWith(mapPrefix)) || (endRange.size() == 1 && withPrefix.end < endRange[0].key && endRange[0].key.startsWith(mapPrefix));
															#line 264 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		Value existingValue = hasEnd ? endRange[0].value : ""_sr;
															#line 265 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		bool valueMatches = value == existingValue;
															#line 267 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		KeyRange conflictRange = KeyRangeRef(hasBegin ? beginRange[0].key : mapPrefix, withPrefix.begin);
															#line 268 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		if (!conflictRange.empty())
															#line 1767 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
		{
															#line 269 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			tr->addReadConflictRange(conflictRange);
															#line 1771 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
		}
															#line 271 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		conflictRange = KeyRangeRef(hasEnd ? endRange[0].key : mapPrefix, hasNext ? keyAfter(endRange.end()[-1].key) : strinc(mapPrefix));
															#line 273 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		if (!conflictRange.empty())
															#line 1777 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
		{
															#line 274 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			tr->addReadConflictRange(conflictRange);
															#line 1781 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
		}
															#line 276 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		endKey = Key();
															#line 277 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		endValue = Value();
															#line 280 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		if (hasNext && endRange.end()[-1].key <= maxWithPrefix.end && valueMatches)
															#line 1789 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
		{
															#line 281 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			endKey = endRange.end()[-1].key;
															#line 282 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			endValue = endRange.end()[-1].value;
															#line 1795 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
		}
		else
		{
															#line 286 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			if (valueMatches)
															#line 1801 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
			{
															#line 287 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
				endKey = maxWithPrefix.end;
															#line 288 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
				endValue = existingValue;
															#line 1807 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
			}
			else
			{
															#line 293 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
				endKey = withPrefix.end;
															#line 294 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
				endValue = existingValue;
															#line 1815 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
			}
		}
															#line 297 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		tr->clear(KeyRangeRef(beginKey, endKey));
															#line 299 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		ASSERT(value != endValue || endKey == maxWithPrefix.end);
															#line 300 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		tr->set(beginKey, value);
															#line 301 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		tr->set(endKey, endValue);
															#line 303 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		if (!static_cast<KrmSetRangeCoalescing_Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~KrmSetRangeCoalescing_ActorState(); static_cast<KrmSetRangeCoalescing_Actor*>(this)->destroy(); return 0; }
															#line 1828 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
		new (&static_cast<KrmSetRangeCoalescing_Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~KrmSetRangeCoalescing_ActorState();
		static_cast<KrmSetRangeCoalescing_Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 249 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		auto beginRange = keys[0].get();
															#line 250 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		bool hasBegin = beginRange.size() > 0 && beginRange[0].key.startsWith(mapPrefix);
															#line 251 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		Value beginValue = hasBegin ? beginRange[0].value : ""_sr;
															#line 253 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		beginKey = withPrefix.begin;
															#line 254 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		if (beginValue == value)
															#line 1848 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
		{
															#line 255 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			bool outsideRange = !hasBegin || beginRange[0].key < maxWithPrefix.begin;
															#line 256 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			beginKey = outsideRange ? maxWithPrefix.begin : beginRange[0].key;
															#line 1854 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
		}
															#line 260 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		auto endRange = keys[1].get();
															#line 261 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		bool hasEnd = endRange.size() >= 1 && endRange[0].key.startsWith(mapPrefix) && endRange[0].key <= withPrefix.end;
															#line 262 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		bool hasNext = (endRange.size() == 2 && endRange[1].key.startsWith(mapPrefix)) || (endRange.size() == 1 && withPrefix.end < endRange[0].key && endRange[0].key.startsWith(mapPrefix));
															#line 264 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		Value existingValue = hasEnd ? endRange[0].value : ""_sr;
															#line 265 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		bool valueMatches = value == existingValue;
															#line 267 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		KeyRange conflictRange = KeyRangeRef(hasBegin ? beginRange[0].key : mapPrefix, withPrefix.begin);
															#line 268 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		if (!conflictRange.empty())
															#line 1870 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
		{
															#line 269 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			tr->addReadConflictRange(conflictRange);
															#line 1874 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
		}
															#line 271 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		conflictRange = KeyRangeRef(hasEnd ? endRange[0].key : mapPrefix, hasNext ? keyAfter(endRange.end()[-1].key) : strinc(mapPrefix));
															#line 273 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		if (!conflictRange.empty())
															#line 1880 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
		{
															#line 274 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			tr->addReadConflictRange(conflictRange);
															#line 1884 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
		}
															#line 276 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		endKey = Key();
															#line 277 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		endValue = Value();
															#line 280 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		if (hasNext && endRange.end()[-1].key <= maxWithPrefix.end && valueMatches)
															#line 1892 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
		{
															#line 281 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			endKey = endRange.end()[-1].key;
															#line 282 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			endValue = endRange.end()[-1].value;
															#line 1898 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
		}
		else
		{
															#line 286 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			if (valueMatches)
															#line 1904 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
			{
															#line 287 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
				endKey = maxWithPrefix.end;
															#line 288 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
				endValue = existingValue;
															#line 1910 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
			}
			else
			{
															#line 293 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
				endKey = withPrefix.end;
															#line 294 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
				endValue = existingValue;
															#line 1918 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
			}
		}
															#line 297 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		tr->clear(KeyRangeRef(beginKey, endKey));
															#line 299 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		ASSERT(value != endValue || endKey == maxWithPrefix.end);
															#line 300 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		tr->set(beginKey, value);
															#line 301 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		tr->set(endKey, endValue);
															#line 303 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		if (!static_cast<KrmSetRangeCoalescing_Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~KrmSetRangeCoalescing_ActorState(); static_cast<KrmSetRangeCoalescing_Actor*>(this)->destroy(); return 0; }
															#line 1931 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
		new (&static_cast<KrmSetRangeCoalescing_Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~KrmSetRangeCoalescing_ActorState();
		static_cast<KrmSetRangeCoalescing_Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<KrmSetRangeCoalescing_Actor*>(this)->actor_wait_state > 0) static_cast<KrmSetRangeCoalescing_Actor*>(this)->actor_wait_state = 0;
		static_cast<KrmSetRangeCoalescing_Actor*>(this)->ActorCallback< KrmSetRangeCoalescing_Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< KrmSetRangeCoalescing_Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("krmSetRangeCoalescing_", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KrmSetRangeCoalescing_Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("krmSetRangeCoalescing_", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< KrmSetRangeCoalescing_Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("krmSetRangeCoalescing_", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KrmSetRangeCoalescing_Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("krmSetRangeCoalescing_", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< KrmSetRangeCoalescing_Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("krmSetRangeCoalescing_", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<KrmSetRangeCoalescing_Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("krmSetRangeCoalescing_", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 228 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	Transaction* tr;
															#line 228 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	Key mapPrefix;
															#line 228 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	KeyRange range;
															#line 228 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	KeyRange maxRange;
															#line 228 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	Value value;
															#line 236 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	KeyRange withPrefix;
															#line 238 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	KeyRange maxWithPrefix;
															#line 241 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	std::vector<Future<RangeResult>> keys;
															#line 253 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	Key beginKey;
															#line 276 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	Key endKey;
															#line 277 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	Value endValue;
															#line 2036 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
};
// This generated class is to be used only via krmSetRangeCoalescing_()
															#line 228 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
template <class Transaction>
															#line 228 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
class KrmSetRangeCoalescing_Actor final : public Actor<Void>, public ActorCallback< KrmSetRangeCoalescing_Actor<Transaction>, 0, Void >, public FastAllocated<KrmSetRangeCoalescing_Actor<Transaction>>, public KrmSetRangeCoalescing_ActorState<Transaction, KrmSetRangeCoalescing_Actor<Transaction>> {
															#line 2043 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
public:
	using FastAllocated<KrmSetRangeCoalescing_Actor<Transaction>>::operator new;
	using FastAllocated<KrmSetRangeCoalescing_Actor<Transaction>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5285702283845844480UL, 15947583425890918656UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< KrmSetRangeCoalescing_Actor<Transaction>, 0, Void >;
															#line 228 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	KrmSetRangeCoalescing_Actor(Transaction* const& tr,Key const& mapPrefix,KeyRange const& range,KeyRange const& maxRange,Value const& value) 
															#line 2060 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   KrmSetRangeCoalescing_ActorState<Transaction, KrmSetRangeCoalescing_Actor<Transaction>>(tr, mapPrefix, range, maxRange, value),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("krmSetRangeCoalescing_", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8561569776165908736UL, 10748430322264670464UL);
		ActorExecutionContextHelper __helper(static_cast<KrmSetRangeCoalescing_Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("krmSetRangeCoalescing_");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("krmSetRangeCoalescing_", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< KrmSetRangeCoalescing_Actor<Transaction>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 228 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
template <class Transaction>
															#line 228 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
[[nodiscard]] static Future<Void> krmSetRangeCoalescing_( Transaction* const& tr, Key const& mapPrefix, KeyRange const& range, KeyRange const& maxRange, Value const& value ) {
															#line 228 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	return Future<Void>(new KrmSetRangeCoalescing_Actor<Transaction>(tr, mapPrefix, range, maxRange, value));
															#line 2095 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
}

#line 305 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
Future<Void> krmSetRangeCoalescing(Transaction* const& tr,
                                   Key const& mapPrefix,
                                   KeyRange const& range,
                                   KeyRange const& maxRange,
                                   Value const& value) {
	return krmSetRangeCoalescing_(tr, mapPrefix, range, maxRange, value);
}
Future<Void> krmSetRangeCoalescing(Reference<ReadYourWritesTransaction> const& tr,
                                   Key const& mapPrefix,
                                   KeyRange const& range,
                                   KeyRange const& maxRange,
                                   Value const& value) {
	return holdWhile(tr, krmSetRangeCoalescing_(tr.getPtr(), mapPrefix, range, maxRange, value));
}

															#line 2114 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via flowTestCase320()
															#line 320 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
template <class FlowTestCase320Actor>
															#line 320 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
class FlowTestCase320ActorState {
															#line 2121 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
public:
															#line 320 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	FlowTestCase320ActorState(UnitTestParameters const& params) 
															#line 320 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
															#line 320 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		 : params(params)
															#line 2128 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase320", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase320ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase320", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 321 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			Arena arena;
															#line 322 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			Key prefix = "/prefix/"_sr;
															#line 323 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			StringRef fullKeyA = StringRef(arena, "/prefix/a"_sr);
															#line 324 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			StringRef fullKeyB = StringRef(arena, "/prefix/b"_sr);
															#line 325 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			StringRef fullKeyC = StringRef(arena, "/prefix/c"_sr);
															#line 326 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			StringRef fullKeyD = StringRef(arena, "/prefix/d"_sr);
															#line 328 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			StringRef keyA = StringRef(arena, "a"_sr);
															#line 329 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			StringRef keyB = StringRef(arena, "b"_sr);
															#line 330 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			StringRef keyC = StringRef(arena, "c"_sr);
															#line 331 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			StringRef keyD = StringRef(arena, "d"_sr);
															#line 332 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			StringRef keyE = StringRef(arena, "e"_sr);
															#line 333 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			StringRef keyAB = StringRef(arena, "ab"_sr);
															#line 334 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			StringRef keyAC = StringRef(arena, "ac"_sr);
															#line 335 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			StringRef keyCD = StringRef(arena, "cd"_sr);
															#line 338 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			RangeResult kv;
															#line 339 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			kv.push_back(arena, KeyValueRef(fullKeyA, keyA));
															#line 340 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			kv.push_back(arena, KeyValueRef(fullKeyB, keyB));
															#line 343 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			RangeResult decodedRanges = krmDecodeRanges(prefix, KeyRangeRef(keyAB, keyAC), kv);
															#line 344 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			ASSERT(decodedRanges.size() == 2);
															#line 345 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			ASSERT(decodedRanges.front().key == keyAB);
															#line 346 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			ASSERT(decodedRanges.front().value == keyA);
															#line 347 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			ASSERT(decodedRanges.back().key == keyAC);
															#line 348 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			ASSERT(decodedRanges.back().value == keyA);
															#line 350 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			kv.push_back(arena, KeyValueRef(fullKeyC, keyC));
															#line 351 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			kv.push_back(arena, KeyValueRef(fullKeyD, keyD));
															#line 354 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			decodedRanges = krmDecodeRanges(prefix, KeyRangeRef(keyAB, keyCD), kv);
															#line 355 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			ASSERT(decodedRanges.size() == 4);
															#line 356 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			ASSERT(decodedRanges.front().key == keyAB);
															#line 357 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			ASSERT(decodedRanges.front().value == keyA);
															#line 358 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			ASSERT(decodedRanges.back().key == keyCD);
															#line 359 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			ASSERT(decodedRanges.back().value == keyC);
															#line 362 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			decodedRanges = krmDecodeRanges(prefix, KeyRangeRef(StringRef(), keyE), kv);
															#line 363 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			ASSERT(decodedRanges.size() == 6);
															#line 364 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			ASSERT(decodedRanges.front().key == StringRef());
															#line 365 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			ASSERT(decodedRanges.front().value == StringRef());
															#line 366 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			ASSERT(decodedRanges.back().key == keyE);
															#line 367 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			ASSERT(decodedRanges.back().value == keyD);
															#line 369 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			if (!static_cast<FlowTestCase320Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase320ActorState(); static_cast<FlowTestCase320Actor*>(this)->destroy(); return 0; }
															#line 2217 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
			new (&static_cast<FlowTestCase320Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase320ActorState();
			static_cast<FlowTestCase320Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase320ActorState();
		static_cast<FlowTestCase320Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 320 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	UnitTestParameters params;
															#line 2241 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase320()
															#line 320 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
class FlowTestCase320Actor final : public Actor<Void>, public FastAllocated<FlowTestCase320Actor>, public FlowTestCase320ActorState<FlowTestCase320Actor> {
															#line 2246 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase320Actor>::operator new;
	using FastAllocated<FlowTestCase320Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14148762671312006656UL, 2722863089484096768UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 320 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	FlowTestCase320Actor(UnitTestParameters const& params) 
															#line 2262 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase320ActorState<FlowTestCase320Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase320", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8128052982833405440UL, 1736792504670414848UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase320Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase320");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase320", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 320 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
static Future<Void> flowTestCase320( UnitTestParameters const& params ) {
															#line 320 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	return Future<Void>(new FlowTestCase320Actor(params));
															#line 2294 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase320, "/keyrangemap/decoderange/aligned")

#line 371 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"

															#line 2300 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via flowTestCase372()
															#line 372 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
template <class FlowTestCase372Actor>
															#line 372 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
class FlowTestCase372ActorState {
															#line 2307 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
public:
															#line 372 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	FlowTestCase372ActorState(UnitTestParameters const& params) 
															#line 372 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
															#line 372 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
		 : params(params)
															#line 2314 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase372", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase372ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase372", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 373 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			Arena arena;
															#line 374 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			Key prefix = "/prefix/"_sr;
															#line 375 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			StringRef fullKeyA = StringRef(arena, "/prefix/a"_sr);
															#line 376 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			StringRef fullKeyB = StringRef(arena, "/prefix/b"_sr);
															#line 377 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			StringRef fullKeyC = StringRef(arena, "/prefix/c"_sr);
															#line 378 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			StringRef fullKeyD = StringRef(arena, "/prefix/d"_sr);
															#line 380 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			StringRef keyA = StringRef(arena, "a"_sr);
															#line 381 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			StringRef keyB = StringRef(arena, "b"_sr);
															#line 382 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			StringRef keyC = StringRef(arena, "c"_sr);
															#line 383 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			StringRef keyD = StringRef(arena, "d"_sr);
															#line 384 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			StringRef keyE = StringRef(arena, "e"_sr);
															#line 385 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			StringRef keyAB = StringRef(arena, "ab"_sr);
															#line 386 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			StringRef keyAC = StringRef(arena, "ac"_sr);
															#line 387 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			StringRef keyCD = StringRef(arena, "cd"_sr);
															#line 390 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			RangeResult kv;
															#line 391 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			kv.push_back(arena, KeyValueRef(fullKeyA, keyA));
															#line 392 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			kv.push_back(arena, KeyValueRef(fullKeyB, keyB));
															#line 395 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			RangeResult decodedRanges = krmDecodeRanges(prefix, KeyRangeRef(keyAB, keyAC), kv, false);
															#line 396 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			ASSERT(decodedRanges.size() == 2);
															#line 397 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			ASSERT(decodedRanges.front().key == keyA);
															#line 398 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			ASSERT(decodedRanges.front().value == keyA);
															#line 399 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			ASSERT(decodedRanges.back().key == keyB);
															#line 400 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			ASSERT(decodedRanges.back().value == keyB);
															#line 402 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			kv.push_back(arena, KeyValueRef(fullKeyC, keyC));
															#line 403 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			kv.push_back(arena, KeyValueRef(fullKeyD, keyD));
															#line 406 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			decodedRanges = krmDecodeRanges(prefix, KeyRangeRef(keyAB, keyCD), kv, false);
															#line 407 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			ASSERT(decodedRanges.size() == 4);
															#line 408 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			ASSERT(decodedRanges.front().key == keyA);
															#line 409 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			ASSERT(decodedRanges.front().value == keyA);
															#line 410 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			ASSERT(decodedRanges.back().key == keyD);
															#line 411 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			ASSERT(decodedRanges.back().value == keyD);
															#line 414 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			decodedRanges = krmDecodeRanges(prefix, KeyRangeRef(StringRef(), keyE), kv, false);
															#line 415 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			ASSERT(decodedRanges.size() == 6);
															#line 416 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			ASSERT(decodedRanges.front().key == StringRef());
															#line 417 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			ASSERT(decodedRanges.front().value == StringRef());
															#line 418 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			ASSERT(decodedRanges.back().key == keyE);
															#line 419 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			ASSERT(decodedRanges.back().value == keyD);
															#line 421 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
			if (!static_cast<FlowTestCase372Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase372ActorState(); static_cast<FlowTestCase372Actor*>(this)->destroy(); return 0; }
															#line 2403 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
			new (&static_cast<FlowTestCase372Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase372ActorState();
			static_cast<FlowTestCase372Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase372ActorState();
		static_cast<FlowTestCase372Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 372 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	UnitTestParameters params;
															#line 2427 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase372()
															#line 372 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
class FlowTestCase372Actor final : public Actor<Void>, public FastAllocated<FlowTestCase372Actor>, public FlowTestCase372ActorState<FlowTestCase372Actor> {
															#line 2432 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase372Actor>::operator new;
	using FastAllocated<FlowTestCase372Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16289776917419917568UL, 9603574948012798208UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 372 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	FlowTestCase372Actor(UnitTestParameters const& params) 
															#line 2448 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase372ActorState<FlowTestCase372Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase372", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8945147341887503872UL, 16724689031163741184UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase372Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase372");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase372", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 372 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
static Future<Void> flowTestCase372( UnitTestParameters const& params ) {
															#line 372 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/KeyRangeMap.actor.cpp"
	return Future<Void>(new FlowTestCase372Actor(params));
															#line 2480 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/KeyRangeMap.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase372, "/keyrangemap/decoderange/unaligned")

