#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
/*
 * AuditUtils.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/AuditUtils.actor.h"

#include "fdbclient/Audit.h"
#include "fdbclient/FDBTypes.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbclient/ClientKnobs.h"
#include <fmt/format.h>

#include "flow/actorcompiler.h" // has to be last include

void clearAuditProgressMetadata(Transaction* tr, AuditType auditType, UID auditId) {
	// There are two possible places to store AuditProgressMetadata:
	// (1) auditServerBasedProgressRangeFor or (2) auditRangeBasedProgressRangeFor
	// Which place stores the progress metadata is decided by DDAudit design
	// This function enforces the DDAudit design when clear the progress metadata
	// Design: for replica/ha/locationMetadata, the audit always writes to RangeBased space
	// for SSShard, the audit always writes to ServerBased space
	// This function clears the progress metadata accordingly
	if (auditType == AuditType::ValidateStorageServerShard) {
		tr->clear(auditServerBasedProgressRangeFor(auditType, auditId));
	} else if (auditType == AuditType::ValidateHA) {
		tr->clear(auditRangeBasedProgressRangeFor(auditType, auditId));
	} else if (auditType == AuditType::ValidateReplica) {
		tr->clear(auditRangeBasedProgressRangeFor(auditType, auditId));
	} else if (auditType == AuditType::ValidateLocationMetadata) {
		tr->clear(auditRangeBasedProgressRangeFor(auditType, auditId));
	} else if (auditType == AuditType::ValidateRestore) {
		tr->clear(auditRangeBasedProgressRangeFor(auditType, auditId));
	} else {
		UNREACHABLE();
	}
	return;
}

															#line 58 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via checkStorageServerRemoved()
															#line 56 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
template <class CheckStorageServerRemovedActor>
															#line 56 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class CheckStorageServerRemovedActorState {
															#line 65 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
															#line 56 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	CheckStorageServerRemovedActorState(Database const& cx,UID const& ssid) 
															#line 56 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
															#line 56 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		 : cx(cx),
															#line 56 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   ssid(ssid),
															#line 57 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   res(false),
															#line 58 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   tr(cx)
															#line 78 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("checkStorageServerRemoved", reinterpret_cast<unsigned long>(this));

	}
	~CheckStorageServerRemovedActorState() 
	{
		fdb_probe_actor_destroy("checkStorageServerRemoved", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 59 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(SevDebug, "AuditUtilStorageServerRemovedStart").detail("StorageServer", ssid);
															#line 61 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			;
															#line 95 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckStorageServerRemovedActorState();
		static_cast<CheckStorageServerRemovedActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 79 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		TraceEvent(SevDebug, "AuditUtilStorageServerRemovedEnd").detail("StorageServer", ssid).detail("Removed", res);
															#line 80 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!static_cast<CheckStorageServerRemovedActor*>(this)->SAV<bool>::futures) { (void)(res); this->~CheckStorageServerRemovedActorState(); static_cast<CheckStorageServerRemovedActor*>(this)->destroy(); return 0; }
															#line 120 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		new (&static_cast<CheckStorageServerRemovedActor*>(this)->SAV< bool >::value()) bool(std::move(res)); // state_var_RVO
		this->~CheckStorageServerRemovedActorState();
		static_cast<CheckStorageServerRemovedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 63 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 64 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 65 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 66 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(serverListKeyFor(ssid));
															#line 66 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<CheckStorageServerRemovedActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 148 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckStorageServerRemovedActor*>(this)->actor_wait_state = 1;
															#line 66 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckStorageServerRemovedActor, 0, Optional<Value> >*>(static_cast<CheckStorageServerRemovedActor*>(this)));
															#line 153 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 72 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(SevDebug, "AuditUtilStorageServerRemovedError") .errorUnsuppressed(e) .detail("StorageServer", ssid);
															#line 75 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 75 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<CheckStorageServerRemovedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 192 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CheckStorageServerRemovedActor*>(this)->actor_wait_state = 2;
															#line 75 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckStorageServerRemovedActor, 1, Void >*>(static_cast<CheckStorageServerRemovedActor*>(this)));
															#line 197 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& serverListValue,int loopDepth) 
	{
															#line 67 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!serverListValue.present())
															#line 212 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 68 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			res = true;
															#line 216 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && serverListValue,int loopDepth) 
	{
															#line 67 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!serverListValue.present())
															#line 226 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 68 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			res = true;
															#line 230 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& serverListValue,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(serverListValue, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && serverListValue,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(serverListValue), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckStorageServerRemovedActor*>(this)->actor_wait_state > 0) static_cast<CheckStorageServerRemovedActor*>(this)->actor_wait_state = 0;
		static_cast<CheckStorageServerRemovedActor*>(this)->ActorCallback< CheckStorageServerRemovedActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckStorageServerRemovedActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("checkStorageServerRemoved", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckStorageServerRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkStorageServerRemoved", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckStorageServerRemovedActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("checkStorageServerRemoved", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckStorageServerRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkStorageServerRemoved", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckStorageServerRemovedActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("checkStorageServerRemoved", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckStorageServerRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkStorageServerRemoved", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckStorageServerRemovedActor*>(this)->actor_wait_state > 0) static_cast<CheckStorageServerRemovedActor*>(this)->actor_wait_state = 0;
		static_cast<CheckStorageServerRemovedActor*>(this)->ActorCallback< CheckStorageServerRemovedActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckStorageServerRemovedActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkStorageServerRemoved", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckStorageServerRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkStorageServerRemoved", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckStorageServerRemovedActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkStorageServerRemoved", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckStorageServerRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkStorageServerRemoved", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckStorageServerRemovedActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkStorageServerRemoved", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckStorageServerRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkStorageServerRemoved", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 56 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Database cx;
															#line 56 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	UID ssid;
															#line 57 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	bool res;
															#line 58 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Transaction tr;
															#line 406 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
};
// This generated class is to be used only via checkStorageServerRemoved()
															#line 56 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class CheckStorageServerRemovedActor final : public Actor<bool>, public ActorCallback< CheckStorageServerRemovedActor, 0, Optional<Value> >, public ActorCallback< CheckStorageServerRemovedActor, 1, Void >, public FastAllocated<CheckStorageServerRemovedActor>, public CheckStorageServerRemovedActorState<CheckStorageServerRemovedActor> {
															#line 411 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
	using FastAllocated<CheckStorageServerRemovedActor>::operator new;
	using FastAllocated<CheckStorageServerRemovedActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13285475943842002944UL, 8565017483266228224UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckStorageServerRemovedActor, 0, Optional<Value> >;
friend struct ActorCallback< CheckStorageServerRemovedActor, 1, Void >;
															#line 56 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	CheckStorageServerRemovedActor(Database const& cx,UID const& ssid) 
															#line 429 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   CheckStorageServerRemovedActorState<CheckStorageServerRemovedActor>(cx, ssid),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkStorageServerRemoved", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12273032095068269824UL, 16824334513600268800UL);
		ActorExecutionContextHelper __helper(static_cast<CheckStorageServerRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkStorageServerRemoved");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkStorageServerRemoved", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckStorageServerRemovedActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckStorageServerRemovedActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 56 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
[[nodiscard]] Future<bool> checkStorageServerRemoved( Database const& cx, UID const& ssid ) {
															#line 56 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	return Future<bool>(new CheckStorageServerRemovedActor(cx, ssid));
															#line 463 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
}

#line 82 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"

															#line 468 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via cancelAuditMetadata()
															#line 83 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
template <class CancelAuditMetadataActor>
															#line 83 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class CancelAuditMetadataActorState {
															#line 475 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
															#line 83 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	CancelAuditMetadataActorState(Database const& cx,AuditType const& auditType,UID const& auditId) 
															#line 83 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
															#line 83 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		 : cx(cx),
															#line 83 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   auditType(auditType),
															#line 83 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   auditId(auditId)
															#line 486 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("cancelAuditMetadata", reinterpret_cast<unsigned long>(this));

	}
	~CancelAuditMetadataActorState() 
	{
		fdb_probe_actor_destroy("cancelAuditMetadata", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 85 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				tr = Transaction(cx);
															#line 86 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				TraceEvent(SevInfo, "AuditUtilCancelAuditMetadataStart", auditId) .detail("AuditKey", auditKey(auditType, auditId));
															#line 88 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				;
															#line 506 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CancelAuditMetadataActorState();
		static_cast<CancelAuditMetadataActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 116 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!static_cast<CancelAuditMetadataActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CancelAuditMetadataActorState(); static_cast<CancelAuditMetadataActor*>(this)->destroy(); return 0; }
															#line 535 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		new (&static_cast<CancelAuditMetadataActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CancelAuditMetadataActorState();
		static_cast<CancelAuditMetadataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 114 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			return a_body1Catch1(cancel_audit_storage_failed(), loopDepth);
															#line 548 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 90 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 91 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 92 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 93 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(auditKey(auditType, auditId));
															#line 93 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<CancelAuditMetadataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 584 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CancelAuditMetadataActor*>(this)->actor_wait_state = 1;
															#line 93 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CancelAuditMetadataActor, 0, Optional<Value> >*>(static_cast<CancelAuditMetadataActor*>(this)));
															#line 589 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 108 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(SevWarn, "AuditUtilCancelAuditMetadataError", auditId) .detail("AuditKey", auditKey(auditType, auditId));
															#line 110 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 110 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<CancelAuditMetadataActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 628 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<CancelAuditMetadataActor*>(this)->actor_wait_state = 3;
															#line 110 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CancelAuditMetadataActor, 2, Void >*>(static_cast<CancelAuditMetadataActor*>(this)));
															#line 633 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& res_,int loopDepth) 
	{
															#line 94 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!res_.present())
															#line 648 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 97 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		toCancelState = decodeAuditStorageState(res_.get());
															#line 99 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		ASSERT(toCancelState.id == auditId && toCancelState.getType() == auditType);
															#line 100 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		toCancelState.setPhase(AuditPhase::Failed);
															#line 101 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		tr.set(auditKey(toCancelState.getType(), toCancelState.id), auditStorageStateValue(toCancelState));
															#line 102 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		clearAuditProgressMetadata(&tr, toCancelState.getType(), toCancelState.id);
															#line 103 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 103 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (static_cast<CancelAuditMetadataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 666 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CancelAuditMetadataActor*>(this)->actor_wait_state = 2;
															#line 103 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CancelAuditMetadataActor, 1, Void >*>(static_cast<CancelAuditMetadataActor*>(this)));
															#line 671 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && res_,int loopDepth) 
	{
															#line 94 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!res_.present())
															#line 680 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 97 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		toCancelState = decodeAuditStorageState(res_.get());
															#line 99 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		ASSERT(toCancelState.id == auditId && toCancelState.getType() == auditType);
															#line 100 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		toCancelState.setPhase(AuditPhase::Failed);
															#line 101 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		tr.set(auditKey(toCancelState.getType(), toCancelState.id), auditStorageStateValue(toCancelState));
															#line 102 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		clearAuditProgressMetadata(&tr, toCancelState.getType(), toCancelState.id);
															#line 103 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 103 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (static_cast<CancelAuditMetadataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 698 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CancelAuditMetadataActor*>(this)->actor_wait_state = 2;
															#line 103 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CancelAuditMetadataActor, 1, Void >*>(static_cast<CancelAuditMetadataActor*>(this)));
															#line 703 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& res_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(res_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && res_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(res_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CancelAuditMetadataActor*>(this)->actor_wait_state > 0) static_cast<CancelAuditMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<CancelAuditMetadataActor*>(this)->ActorCallback< CancelAuditMetadataActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< CancelAuditMetadataActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("cancelAuditMetadata", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CancelAuditMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cancelAuditMetadata", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CancelAuditMetadataActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("cancelAuditMetadata", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CancelAuditMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cancelAuditMetadata", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CancelAuditMetadataActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("cancelAuditMetadata", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CancelAuditMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cancelAuditMetadata", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 104 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		TraceEvent(SevInfo, "AuditUtilCancelAuditMetadataEnd", auditId) .detail("AuditKey", auditKey(auditType, auditId));
															#line 787 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 104 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		TraceEvent(SevInfo, "AuditUtilCancelAuditMetadataEnd", auditId) .detail("AuditKey", auditKey(auditType, auditId));
															#line 796 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CancelAuditMetadataActor*>(this)->actor_wait_state > 0) static_cast<CancelAuditMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<CancelAuditMetadataActor*>(this)->ActorCallback< CancelAuditMetadataActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CancelAuditMetadataActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cancelAuditMetadata", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CancelAuditMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cancelAuditMetadata", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CancelAuditMetadataActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cancelAuditMetadata", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CancelAuditMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cancelAuditMetadata", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CancelAuditMetadataActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cancelAuditMetadata", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CancelAuditMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cancelAuditMetadata", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CancelAuditMetadataActor*>(this)->actor_wait_state > 0) static_cast<CancelAuditMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<CancelAuditMetadataActor*>(this)->ActorCallback< CancelAuditMetadataActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CancelAuditMetadataActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cancelAuditMetadata", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CancelAuditMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cancelAuditMetadata", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CancelAuditMetadataActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cancelAuditMetadata", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CancelAuditMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cancelAuditMetadata", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CancelAuditMetadataActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cancelAuditMetadata", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CancelAuditMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cancelAuditMetadata", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 83 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Database cx;
															#line 83 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	AuditType auditType;
															#line 83 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	UID auditId;
															#line 85 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Transaction tr;
															#line 97 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	AuditStorageState toCancelState;
															#line 986 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
};
// This generated class is to be used only via cancelAuditMetadata()
															#line 83 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class CancelAuditMetadataActor final : public Actor<Void>, public ActorCallback< CancelAuditMetadataActor, 0, Optional<Value> >, public ActorCallback< CancelAuditMetadataActor, 1, Void >, public ActorCallback< CancelAuditMetadataActor, 2, Void >, public FastAllocated<CancelAuditMetadataActor>, public CancelAuditMetadataActorState<CancelAuditMetadataActor> {
															#line 991 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
	using FastAllocated<CancelAuditMetadataActor>::operator new;
	using FastAllocated<CancelAuditMetadataActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16386333825321015040UL, 11915604490254204416UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CancelAuditMetadataActor, 0, Optional<Value> >;
friend struct ActorCallback< CancelAuditMetadataActor, 1, Void >;
friend struct ActorCallback< CancelAuditMetadataActor, 2, Void >;
															#line 83 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	CancelAuditMetadataActor(Database const& cx,AuditType const& auditType,UID const& auditId) 
															#line 1010 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   CancelAuditMetadataActorState<CancelAuditMetadataActor>(cx, auditType, auditId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("cancelAuditMetadata", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12148951812118840320UL, 11785627702551069952UL);
		ActorExecutionContextHelper __helper(static_cast<CancelAuditMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("cancelAuditMetadata");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("cancelAuditMetadata", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CancelAuditMetadataActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CancelAuditMetadataActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CancelAuditMetadataActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 83 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
[[nodiscard]] Future<Void> cancelAuditMetadata( Database const& cx, AuditType const& auditType, UID const& auditId ) {
															#line 83 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	return Future<Void>(new CancelAuditMetadataActor(cx, auditType, auditId));
															#line 1045 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
}

#line 118 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"

AuditPhase stringToAuditPhase(std::string auditPhaseStr) {
	// Convert chars of auditPhaseStr to lower case
	std::transform(auditPhaseStr.begin(), auditPhaseStr.end(), auditPhaseStr.begin(), [](unsigned char c) {
		return std::tolower(c);
	});
	if (auditPhaseStr == "running") {
		return AuditPhase::Running;
	} else if (auditPhaseStr == "complete") {
		return AuditPhase::Complete;
	} else if (auditPhaseStr == "failed") {
		return AuditPhase::Failed;
	} else if (auditPhaseStr == "error") {
		return AuditPhase::Error;
	} else {
		return AuditPhase::Invalid;
	}
}

// This is not transactional
															#line 1069 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getAuditStates()
															#line 138 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
template <class GetAuditStatesActor>
															#line 138 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class GetAuditStatesActorState {
															#line 1076 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
															#line 138 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	GetAuditStatesActorState(Database const& cx,AuditType const& auditType,bool const& newFirst,Optional<int> const& num,Optional<AuditPhase> const& phase) 
															#line 138 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
															#line 138 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		 : cx(cx),
															#line 138 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   auditType(auditType),
															#line 138 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   newFirst(newFirst),
															#line 138 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   num(num),
															#line 138 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   phase(phase),
															#line 143 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   tr(cx),
															#line 144 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   auditStates(),
															#line 145 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   readBegin(),
															#line 146 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   readEnd(),
															#line 147 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   reverse(newFirst ? Reverse::True : Reverse::False)
															#line 1101 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getAuditStates", reinterpret_cast<unsigned long>(this));

	}
	~GetAuditStatesActorState() 
	{
		fdb_probe_actor_destroy("getAuditStates", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 148 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (num.present() && num.get() == 0)
															#line 1116 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
															#line 149 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				if (!static_cast<GetAuditStatesActor*>(this)->SAV<std::vector<AuditStorageState>>::futures) { (void)(auditStates); this->~GetAuditStatesActorState(); static_cast<GetAuditStatesActor*>(this)->destroy(); return 0; }
															#line 1120 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				new (&static_cast<GetAuditStatesActor*>(this)->SAV< std::vector<AuditStorageState> >::value()) std::vector<AuditStorageState>(std::move(auditStates)); // state_var_RVO
				this->~GetAuditStatesActorState();
				static_cast<GetAuditStatesActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 151 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			;
															#line 1128 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetAuditStatesActorState();
		static_cast<GetAuditStatesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 190 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!static_cast<GetAuditStatesActor*>(this)->SAV<std::vector<AuditStorageState>>::futures) { (void)(auditStates); this->~GetAuditStatesActorState(); static_cast<GetAuditStatesActor*>(this)->destroy(); return 0; }
															#line 1151 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		new (&static_cast<GetAuditStatesActor*>(this)->SAV< std::vector<AuditStorageState> >::value()) std::vector<AuditStorageState>(std::move(auditStates)); // state_var_RVO
		this->~GetAuditStatesActorState();
		static_cast<GetAuditStatesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 153 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			readBegin = auditKeyRange(auditType).begin;
															#line 154 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			readEnd = auditKeyRange(auditType).end;
															#line 155 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			auditStates.clear();
															#line 156 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			;
															#line 1177 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = a_body1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 187 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 187 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<GetAuditStatesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1214 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetAuditStatesActor*>(this)->actor_wait_state = 2;
															#line 187 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetAuditStatesActor, 1, Void >*>(static_cast<GetAuditStatesActor*>(this)));
															#line 1219 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 157 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 158 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 159 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 160 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		KeyRangeRef rangeToRead(readBegin, readEnd);
															#line 161 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		StrictFuture<RangeResult> __when_expr_0 = tr.getRange(rangeToRead, num.present() ? GetRangeLimits(num.get()) : GetRangeLimits(), Snapshot::False, reverse);
															#line 161 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (static_cast<GetAuditStatesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1257 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<GetAuditStatesActor*>(this)->actor_wait_state = 1;
															#line 161 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetAuditStatesActor, 0, RangeResult >*>(static_cast<GetAuditStatesActor*>(this)));
															#line 1262 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
															#line 165 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		for(int i = 0;i < res.size();++i) {
															#line 166 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			const AuditStorageState auditState = decodeAuditStorageState(res[i].value);
															#line 167 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (phase.present() && auditState.getPhase() != phase.get())
															#line 1288 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
				continue;
			}
															#line 170 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			auditStates.push_back(auditState);
															#line 171 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (num.present() && auditStates.size() == num.get())
															#line 1296 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
															#line 172 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				if (!static_cast<GetAuditStatesActor*>(this)->SAV<std::vector<AuditStorageState>>::futures) { (void)(auditStates); this->~GetAuditStatesActorState(); static_cast<GetAuditStatesActor*>(this)->destroy(); return 0; }
															#line 1300 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				new (&static_cast<GetAuditStatesActor*>(this)->SAV< std::vector<AuditStorageState> >::value()) std::vector<AuditStorageState>(std::move(auditStates)); // state_var_RVO
				this->~GetAuditStatesActorState();
				static_cast<GetAuditStatesActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 175 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!res.more)
															#line 1309 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 178 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (newFirst)
															#line 1315 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 179 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			readEnd = res.front().key;
															#line 1319 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
		else
		{
															#line 181 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			readBegin = keyAfter(res.back().key);
															#line 1325 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 183 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		tr.reset();
															#line 1329 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(RangeResult const& __res,int loopDepth) 
	{
															#line 161 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		res = __res;
															#line 1338 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(RangeResult && __res,int loopDepth) 
	{
		res = std::move(__res);
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetAuditStatesActor*>(this)->actor_wait_state > 0) static_cast<GetAuditStatesActor*>(this)->actor_wait_state = 0;
		static_cast<GetAuditStatesActor*>(this)->ActorCallback< GetAuditStatesActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetAuditStatesActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getAuditStates", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStatesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStates", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetAuditStatesActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getAuditStates", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStatesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStates", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetAuditStatesActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getAuditStates", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStatesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStates", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetAuditStatesActor*>(this)->actor_wait_state > 0) static_cast<GetAuditStatesActor*>(this)->actor_wait_state = 0;
		static_cast<GetAuditStatesActor*>(this)->ActorCallback< GetAuditStatesActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetAuditStatesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getAuditStates", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStatesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStates", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetAuditStatesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getAuditStates", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStatesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStates", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetAuditStatesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getAuditStates", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStatesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStates", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 138 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Database cx;
															#line 138 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	AuditType auditType;
															#line 138 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	bool newFirst;
															#line 138 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Optional<int> num;
															#line 138 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Optional<AuditPhase> phase;
															#line 143 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Transaction tr;
															#line 144 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	std::vector<AuditStorageState> auditStates;
															#line 145 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Key readBegin;
															#line 146 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Key readEnd;
															#line 147 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Reverse reverse;
															#line 161 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	RangeResult res;
															#line 1522 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getAuditStates()
															#line 138 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class GetAuditStatesActor final : public Actor<std::vector<AuditStorageState>>, public ActorCallback< GetAuditStatesActor, 0, RangeResult >, public ActorCallback< GetAuditStatesActor, 1, Void >, public FastAllocated<GetAuditStatesActor>, public GetAuditStatesActorState<GetAuditStatesActor> {
															#line 1527 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetAuditStatesActor>::operator new;
	using FastAllocated<GetAuditStatesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4478248550293512704UL, 16190988542178837248UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<AuditStorageState>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetAuditStatesActor, 0, RangeResult >;
friend struct ActorCallback< GetAuditStatesActor, 1, Void >;
															#line 138 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	GetAuditStatesActor(Database const& cx,AuditType const& auditType,bool const& newFirst,Optional<int> const& num,Optional<AuditPhase> const& phase) 
															#line 1545 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		 : Actor<std::vector<AuditStorageState>>(),
		   GetAuditStatesActorState<GetAuditStatesActor>(cx, auditType, newFirst, num, phase),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getAuditStates", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3167609632865366528UL, 13809905943605247488UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStatesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getAuditStates");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getAuditStates", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetAuditStatesActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetAuditStatesActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 138 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
[[nodiscard]] Future<std::vector<AuditStorageState>> getAuditStates( Database const& cx, AuditType const& auditType, bool const& newFirst, Optional<int> const& num, Optional<AuditPhase> const& phase ) {
															#line 138 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	return Future<std::vector<AuditStorageState>>(new GetAuditStatesActor(cx, auditType, newFirst, num, phase));
															#line 1579 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
}

#line 192 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"

															#line 1584 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via clearAuditMetadataForType()
															#line 193 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
template <class ClearAuditMetadataForTypeActor>
															#line 193 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class ClearAuditMetadataForTypeActorState {
															#line 1591 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
															#line 193 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	ClearAuditMetadataForTypeActorState(Database const& cx,AuditType const& auditType,UID const& maxAuditIdToClear,int const& numFinishAuditToKeep) 
															#line 193 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
															#line 193 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		 : cx(cx),
															#line 193 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   auditType(auditType),
															#line 193 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   maxAuditIdToClear(maxAuditIdToClear),
															#line 193 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   numFinishAuditToKeep(numFinishAuditToKeep),
															#line 197 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   tr(cx),
															#line 198 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   numFinishAuditCleaned(0)
															#line 1608 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("clearAuditMetadataForType", reinterpret_cast<unsigned long>(this));

	}
	~ClearAuditMetadataForTypeActorState() 
	{
		fdb_probe_actor_destroy("clearAuditMetadataForType", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 199 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(SevDebug, "AuditUtilClearAuditMetadataForTypeStart") .detail("AuditType", auditType) .detail("MaxAuditIdToClear", maxAuditIdToClear);
															#line 1623 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			try {
															#line 204 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				;
															#line 1627 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClearAuditMetadataForTypeActorState();
		static_cast<ClearAuditMetadataForTypeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 264 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!static_cast<ClearAuditMetadataForTypeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClearAuditMetadataForTypeActorState(); static_cast<ClearAuditMetadataForTypeActor*>(this)->destroy(); return 0; }
															#line 1656 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		new (&static_cast<ClearAuditMetadataForTypeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClearAuditMetadataForTypeActorState();
		static_cast<ClearAuditMetadataForTypeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 258 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(SevInfo, "AuditUtilClearAuditMetadataForTypeError") .detail("AuditType", auditType) .errorUnsuppressed(e);
															#line 1669 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 206 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<std::vector<AuditStorageState>> __when_expr_0 = getAuditStates(cx, auditType, false);
															#line 206 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<ClearAuditMetadataForTypeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1700 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ClearAuditMetadataForTypeActor*>(this)->actor_wait_state = 1;
															#line 206 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClearAuditMetadataForTypeActor, 0, std::vector<AuditStorageState> >*>(static_cast<ClearAuditMetadataForTypeActor*>(this)));
															#line 1705 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 254 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 254 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<ClearAuditMetadataForTypeActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1742 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<ClearAuditMetadataForTypeActor*>(this)->actor_wait_state = 3;
															#line 254 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ClearAuditMetadataForTypeActor, 2, Void >*>(static_cast<ClearAuditMetadataForTypeActor*>(this)));
															#line 1747 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 211 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		int numFinishAudit = 0;
															#line 212 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		for( const auto& auditState : auditStates ) {
															#line 213 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (auditState.id.first() > maxAuditIdToClear.first())
															#line 1766 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
				continue;
			}
															#line 216 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (auditState.getPhase() == AuditPhase::Complete || auditState.getPhase() == AuditPhase::Failed)
															#line 1772 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
															#line 217 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				numFinishAudit++;
															#line 1776 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			}
		}
															#line 220 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		const int numFinishAuditToClean = numFinishAudit - numFinishAuditToKeep;
															#line 221 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		numFinishAuditCleaned = 0;
															#line 222 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 223 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 224 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 225 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		for( const auto& auditState : auditStates ) {
															#line 226 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (auditState.id.first() > maxAuditIdToClear.first())
															#line 1793 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
				continue;
			}
															#line 229 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			ASSERT(auditState.getType() == auditType);
															#line 230 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (auditState.getPhase() == AuditPhase::Complete && numFinishAuditCleaned < numFinishAuditToClean)
															#line 1801 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
															#line 233 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				tr.clear(auditKey(auditType, auditState.id));
															#line 236 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				numFinishAuditCleaned++;
															#line 1807 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			}
			else
			{
															#line 237 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				if (auditState.getPhase() == AuditPhase::Failed && numFinishAuditCleaned < numFinishAuditToClean)
															#line 1813 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				{
															#line 240 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
					tr.clear(auditKey(auditType, auditState.id));
															#line 242 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
					clearAuditProgressMetadata(&tr, auditType, auditState.id);
															#line 243 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
					numFinishAuditCleaned++;
															#line 1821 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				}
			}
		}
															#line 247 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 247 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (static_cast<ClearAuditMetadataForTypeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1829 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ClearAuditMetadataForTypeActor*>(this)->actor_wait_state = 2;
															#line 247 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClearAuditMetadataForTypeActor, 1, Void >*>(static_cast<ClearAuditMetadataForTypeActor*>(this)));
															#line 1834 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<AuditStorageState> const& __auditStates,int loopDepth) 
	{
															#line 206 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		auditStates = __auditStates;
															#line 1843 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<AuditStorageState> && __auditStates,int loopDepth) 
	{
		auditStates = std::move(__auditStates);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClearAuditMetadataForTypeActor*>(this)->actor_wait_state > 0) static_cast<ClearAuditMetadataForTypeActor*>(this)->actor_wait_state = 0;
		static_cast<ClearAuditMetadataForTypeActor*>(this)->ActorCallback< ClearAuditMetadataForTypeActor, 0, std::vector<AuditStorageState> >::remove();

	}
	void a_callback_fire(ActorCallback< ClearAuditMetadataForTypeActor, 0, std::vector<AuditStorageState> >*,std::vector<AuditStorageState> const& value) 
	{
		fdb_probe_actor_enter("clearAuditMetadataForType", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAuditMetadataForTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAuditMetadataForType", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClearAuditMetadataForTypeActor, 0, std::vector<AuditStorageState> >*,std::vector<AuditStorageState> && value) 
	{
		fdb_probe_actor_enter("clearAuditMetadataForType", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAuditMetadataForTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAuditMetadataForType", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClearAuditMetadataForTypeActor, 0, std::vector<AuditStorageState> >*,Error err) 
	{
		fdb_probe_actor_enter("clearAuditMetadataForType", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAuditMetadataForTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAuditMetadataForType", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 248 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		TraceEvent(SevDebug, "AuditUtilClearAuditMetadataForTypeEnd") .detail("AuditType", auditType) .detail("NumCleanedFinishAudits", numFinishAuditCleaned);
															#line 1922 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 248 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		TraceEvent(SevDebug, "AuditUtilClearAuditMetadataForTypeEnd") .detail("AuditType", auditType) .detail("NumCleanedFinishAudits", numFinishAuditCleaned);
															#line 1931 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ClearAuditMetadataForTypeActor*>(this)->actor_wait_state > 0) static_cast<ClearAuditMetadataForTypeActor*>(this)->actor_wait_state = 0;
		static_cast<ClearAuditMetadataForTypeActor*>(this)->ActorCallback< ClearAuditMetadataForTypeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClearAuditMetadataForTypeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clearAuditMetadataForType", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAuditMetadataForTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAuditMetadataForType", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClearAuditMetadataForTypeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clearAuditMetadataForType", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAuditMetadataForTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAuditMetadataForType", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClearAuditMetadataForTypeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clearAuditMetadataForType", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAuditMetadataForTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAuditMetadataForType", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ClearAuditMetadataForTypeActor*>(this)->actor_wait_state > 0) static_cast<ClearAuditMetadataForTypeActor*>(this)->actor_wait_state = 0;
		static_cast<ClearAuditMetadataForTypeActor*>(this)->ActorCallback< ClearAuditMetadataForTypeActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClearAuditMetadataForTypeActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clearAuditMetadataForType", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAuditMetadataForTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAuditMetadataForType", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ClearAuditMetadataForTypeActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clearAuditMetadataForType", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAuditMetadataForTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAuditMetadataForType", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ClearAuditMetadataForTypeActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clearAuditMetadataForType", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAuditMetadataForTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAuditMetadataForType", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 193 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Database cx;
															#line 193 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	AuditType auditType;
															#line 193 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	UID maxAuditIdToClear;
															#line 193 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	int numFinishAuditToKeep;
															#line 197 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Transaction tr;
															#line 198 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	int numFinishAuditCleaned;
															#line 206 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	std::vector<AuditStorageState> auditStates;
															#line 2125 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
};
// This generated class is to be used only via clearAuditMetadataForType()
															#line 193 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class ClearAuditMetadataForTypeActor final : public Actor<Void>, public ActorCallback< ClearAuditMetadataForTypeActor, 0, std::vector<AuditStorageState> >, public ActorCallback< ClearAuditMetadataForTypeActor, 1, Void >, public ActorCallback< ClearAuditMetadataForTypeActor, 2, Void >, public FastAllocated<ClearAuditMetadataForTypeActor>, public ClearAuditMetadataForTypeActorState<ClearAuditMetadataForTypeActor> {
															#line 2130 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
	using FastAllocated<ClearAuditMetadataForTypeActor>::operator new;
	using FastAllocated<ClearAuditMetadataForTypeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11000370120684222976UL, 17901563720056064512UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClearAuditMetadataForTypeActor, 0, std::vector<AuditStorageState> >;
friend struct ActorCallback< ClearAuditMetadataForTypeActor, 1, Void >;
friend struct ActorCallback< ClearAuditMetadataForTypeActor, 2, Void >;
															#line 193 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	ClearAuditMetadataForTypeActor(Database const& cx,AuditType const& auditType,UID const& maxAuditIdToClear,int const& numFinishAuditToKeep) 
															#line 2149 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ClearAuditMetadataForTypeActorState<ClearAuditMetadataForTypeActor>(cx, auditType, maxAuditIdToClear, numFinishAuditToKeep),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clearAuditMetadataForType", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2691779984664438272UL, 7749499684062243584UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAuditMetadataForTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clearAuditMetadataForType");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clearAuditMetadataForType", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClearAuditMetadataForTypeActor, 0, std::vector<AuditStorageState> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ClearAuditMetadataForTypeActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ClearAuditMetadataForTypeActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 193 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
[[nodiscard]] Future<Void> clearAuditMetadataForType( Database const& cx, AuditType const& auditType, UID const& maxAuditIdToClear, int const& numFinishAuditToKeep ) {
															#line 193 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	return Future<Void>(new ClearAuditMetadataForTypeActor(cx, auditType, maxAuditIdToClear, numFinishAuditToKeep));
															#line 2184 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
}

#line 266 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"

															#line 2189 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via checkMoveKeysLockForAudit()
															#line 267 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
template <class CheckMoveKeysLockForAuditActor>
															#line 267 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class CheckMoveKeysLockForAuditActorState {
															#line 2196 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
															#line 267 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	CheckMoveKeysLockForAuditActorState(Transaction* const& tr,MoveKeyLockInfo const& lock,bool const& isDDEnabled,bool const& isWrite = true) 
															#line 267 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
															#line 267 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		 : tr(tr),
															#line 267 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   lock(lock),
															#line 267 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   isDDEnabled(isDDEnabled),
															#line 267 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   isWrite(isWrite)
															#line 2209 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("checkMoveKeysLockForAudit", reinterpret_cast<unsigned long>(this));

	}
	~CheckMoveKeysLockForAuditActorState() 
	{
		fdb_probe_actor_destroy("checkMoveKeysLockForAudit", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 271 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 272 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (!isDDEnabled)
															#line 2226 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
															#line 273 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				TraceEvent(SevDebug, "AuditUtilDisabledByInMemoryCheck").log();
															#line 274 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				return a_body1Catch1(movekeys_conflict(), loopDepth);
															#line 2232 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			}
															#line 276 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr->get(moveKeysLockOwnerKey);
															#line 276 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<CheckMoveKeysLockForAuditActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2238 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckMoveKeysLockForAuditActor*>(this)->actor_wait_state = 1;
															#line 276 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckMoveKeysLockForAuditActor, 0, Optional<Value> >*>(static_cast<CheckMoveKeysLockForAuditActor*>(this)));
															#line 2243 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckMoveKeysLockForAuditActorState();
		static_cast<CheckMoveKeysLockForAuditActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& readVal,int loopDepth) 
	{
															#line 277 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		UID currentOwner = readVal.present() ? BinaryReader::fromStringRef<UID>(readVal.get(), Unversioned()) : UID();
															#line 279 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (currentOwner == lock.prevOwner)
															#line 2268 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 281 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_1 = tr->get(moveKeysLockWriteKey);
															#line 281 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<CheckMoveKeysLockForAuditActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2274 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CheckMoveKeysLockForAuditActor*>(this)->actor_wait_state = 2;
															#line 281 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckMoveKeysLockForAuditActor, 1, Optional<Value> >*>(static_cast<CheckMoveKeysLockForAuditActor*>(this)));
															#line 2279 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 303 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (currentOwner == lock.myOwner)
															#line 2286 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
															#line 304 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				if (isWrite)
															#line 2290 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				{
															#line 306 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
					BinaryWriter wrLastWrite(Unversioned());
															#line 307 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
					wrLastWrite << deterministicRandom()->randomUniqueID();
															#line 308 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
					tr->set(moveKeysLockWriteKey, wrLastWrite.toValue());
															#line 310 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
					tr->makeSelfConflicting();
															#line 2300 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				}
															#line 312 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				if (!static_cast<CheckMoveKeysLockForAuditActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckMoveKeysLockForAuditActorState(); static_cast<CheckMoveKeysLockForAuditActor*>(this)->destroy(); return 0; }
															#line 2304 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				new (&static_cast<CheckMoveKeysLockForAuditActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~CheckMoveKeysLockForAuditActorState();
				static_cast<CheckMoveKeysLockForAuditActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 314 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				TraceEvent(SevDebug, "AuditUtilConflictWithNewOwner") .detail("CurrentOwner", currentOwner.toString()) .detail("PrevOwner", lock.prevOwner.toString()) .detail("PrevWrite", lock.prevWrite.toString()) .detail("MyOwner", lock.myOwner.toString());
															#line 319 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				return a_body1Catch1(movekeys_conflict(), loopDepth);
															#line 2316 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			}
		}

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && readVal,int loopDepth) 
	{
															#line 277 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		UID currentOwner = readVal.present() ? BinaryReader::fromStringRef<UID>(readVal.get(), Unversioned()) : UID();
															#line 279 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (currentOwner == lock.prevOwner)
															#line 2328 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 281 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_1 = tr->get(moveKeysLockWriteKey);
															#line 281 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<CheckMoveKeysLockForAuditActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2334 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CheckMoveKeysLockForAuditActor*>(this)->actor_wait_state = 2;
															#line 281 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckMoveKeysLockForAuditActor, 1, Optional<Value> >*>(static_cast<CheckMoveKeysLockForAuditActor*>(this)));
															#line 2339 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 303 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (currentOwner == lock.myOwner)
															#line 2346 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
															#line 304 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				if (isWrite)
															#line 2350 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				{
															#line 306 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
					BinaryWriter wrLastWrite(Unversioned());
															#line 307 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
					wrLastWrite << deterministicRandom()->randomUniqueID();
															#line 308 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
					tr->set(moveKeysLockWriteKey, wrLastWrite.toValue());
															#line 310 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
					tr->makeSelfConflicting();
															#line 2360 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				}
															#line 312 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				if (!static_cast<CheckMoveKeysLockForAuditActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckMoveKeysLockForAuditActorState(); static_cast<CheckMoveKeysLockForAuditActor*>(this)->destroy(); return 0; }
															#line 2364 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				new (&static_cast<CheckMoveKeysLockForAuditActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~CheckMoveKeysLockForAuditActorState();
				static_cast<CheckMoveKeysLockForAuditActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 314 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				TraceEvent(SevDebug, "AuditUtilConflictWithNewOwner") .detail("CurrentOwner", currentOwner.toString()) .detail("PrevOwner", lock.prevOwner.toString()) .detail("PrevWrite", lock.prevWrite.toString()) .detail("MyOwner", lock.myOwner.toString());
															#line 319 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				return a_body1Catch1(movekeys_conflict(), loopDepth);
															#line 2376 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			}
		}

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& readVal,int loopDepth) 
	{
		loopDepth = a_body1cont1(readVal, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && readVal,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(readVal), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckMoveKeysLockForAuditActor*>(this)->actor_wait_state > 0) static_cast<CheckMoveKeysLockForAuditActor*>(this)->actor_wait_state = 0;
		static_cast<CheckMoveKeysLockForAuditActor*>(this)->ActorCallback< CheckMoveKeysLockForAuditActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckMoveKeysLockForAuditActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("checkMoveKeysLockForAudit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckMoveKeysLockForAuditActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkMoveKeysLockForAudit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckMoveKeysLockForAuditActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("checkMoveKeysLockForAudit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckMoveKeysLockForAuditActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkMoveKeysLockForAudit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckMoveKeysLockForAuditActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("checkMoveKeysLockForAudit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckMoveKeysLockForAuditActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkMoveKeysLockForAudit", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(Optional<Value> const& readVal,int loopDepth) 
	{
															#line 282 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		UID lastWrite = readVal.present() ? BinaryReader::fromStringRef<UID>(readVal.get(), Unversioned()) : UID();
															#line 283 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (lastWrite != lock.prevWrite)
															#line 2463 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 284 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(SevDebug, "ConflictWithPreviousOwner");
															#line 285 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			return a_body1Catch1(movekeys_conflict(), loopDepth);
															#line 2469 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 288 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (isWrite)
															#line 2473 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 289 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			BinaryWriter wrMyOwner(Unversioned());
															#line 290 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			wrMyOwner << lock.myOwner;
															#line 291 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr->set(moveKeysLockOwnerKey, wrMyOwner.toValue());
															#line 292 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			BinaryWriter wrLastWrite(Unversioned());
															#line 293 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			UID lastWriter = deterministicRandom()->randomUniqueID();
															#line 294 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			wrLastWrite << lastWriter;
															#line 295 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr->set(moveKeysLockWriteKey, wrLastWrite.toValue());
															#line 296 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent("AuditUtilCheckMoveKeysLock") .detail("PrevOwner", lock.prevOwner.toString()) .detail("PrevWrite", lock.prevWrite.toString()) .detail("MyOwner", lock.myOwner.toString()) .detail("Writer", lastWriter.toString());
															#line 2491 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 302 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!static_cast<CheckMoveKeysLockForAuditActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckMoveKeysLockForAuditActorState(); static_cast<CheckMoveKeysLockForAuditActor*>(this)->destroy(); return 0; }
															#line 2495 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		new (&static_cast<CheckMoveKeysLockForAuditActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckMoveKeysLockForAuditActorState();
		static_cast<CheckMoveKeysLockForAuditActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Optional<Value> && readVal,int loopDepth) 
	{
															#line 282 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		UID lastWrite = readVal.present() ? BinaryReader::fromStringRef<UID>(readVal.get(), Unversioned()) : UID();
															#line 283 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (lastWrite != lock.prevWrite)
															#line 2509 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 284 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(SevDebug, "ConflictWithPreviousOwner");
															#line 285 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			return a_body1Catch1(movekeys_conflict(), loopDepth);
															#line 2515 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 288 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (isWrite)
															#line 2519 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 289 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			BinaryWriter wrMyOwner(Unversioned());
															#line 290 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			wrMyOwner << lock.myOwner;
															#line 291 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr->set(moveKeysLockOwnerKey, wrMyOwner.toValue());
															#line 292 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			BinaryWriter wrLastWrite(Unversioned());
															#line 293 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			UID lastWriter = deterministicRandom()->randomUniqueID();
															#line 294 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			wrLastWrite << lastWriter;
															#line 295 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr->set(moveKeysLockWriteKey, wrLastWrite.toValue());
															#line 296 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent("AuditUtilCheckMoveKeysLock") .detail("PrevOwner", lock.prevOwner.toString()) .detail("PrevWrite", lock.prevWrite.toString()) .detail("MyOwner", lock.myOwner.toString()) .detail("Writer", lastWriter.toString());
															#line 2537 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 302 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!static_cast<CheckMoveKeysLockForAuditActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckMoveKeysLockForAuditActorState(); static_cast<CheckMoveKeysLockForAuditActor*>(this)->destroy(); return 0; }
															#line 2541 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		new (&static_cast<CheckMoveKeysLockForAuditActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckMoveKeysLockForAuditActorState();
		static_cast<CheckMoveKeysLockForAuditActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Value> const& readVal,int loopDepth) 
	{
		loopDepth = a_body1cont4(readVal, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Value> && readVal,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(readVal), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckMoveKeysLockForAuditActor*>(this)->actor_wait_state > 0) static_cast<CheckMoveKeysLockForAuditActor*>(this)->actor_wait_state = 0;
		static_cast<CheckMoveKeysLockForAuditActor*>(this)->ActorCallback< CheckMoveKeysLockForAuditActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckMoveKeysLockForAuditActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("checkMoveKeysLockForAudit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckMoveKeysLockForAuditActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkMoveKeysLockForAudit", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckMoveKeysLockForAuditActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("checkMoveKeysLockForAudit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckMoveKeysLockForAuditActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkMoveKeysLockForAudit", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckMoveKeysLockForAuditActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("checkMoveKeysLockForAudit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckMoveKeysLockForAuditActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkMoveKeysLockForAudit", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 267 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Transaction* tr;
															#line 267 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	MoveKeyLockInfo lock;
															#line 267 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	bool isDDEnabled;
															#line 267 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	bool isWrite;
															#line 2632 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
};
// This generated class is to be used only via checkMoveKeysLockForAudit()
															#line 267 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class CheckMoveKeysLockForAuditActor final : public Actor<Void>, public ActorCallback< CheckMoveKeysLockForAuditActor, 0, Optional<Value> >, public ActorCallback< CheckMoveKeysLockForAuditActor, 1, Optional<Value> >, public FastAllocated<CheckMoveKeysLockForAuditActor>, public CheckMoveKeysLockForAuditActorState<CheckMoveKeysLockForAuditActor> {
															#line 2637 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
	using FastAllocated<CheckMoveKeysLockForAuditActor>::operator new;
	using FastAllocated<CheckMoveKeysLockForAuditActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14908174209592959744UL, 6706119844531712000UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckMoveKeysLockForAuditActor, 0, Optional<Value> >;
friend struct ActorCallback< CheckMoveKeysLockForAuditActor, 1, Optional<Value> >;
															#line 267 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	CheckMoveKeysLockForAuditActor(Transaction* const& tr,MoveKeyLockInfo const& lock,bool const& isDDEnabled,bool const& isWrite = true) 
															#line 2655 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   CheckMoveKeysLockForAuditActorState<CheckMoveKeysLockForAuditActor>(tr, lock, isDDEnabled, isWrite),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkMoveKeysLockForAudit", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17967583375086042368UL, 8101399529876800512UL);
		ActorExecutionContextHelper __helper(static_cast<CheckMoveKeysLockForAuditActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkMoveKeysLockForAudit");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkMoveKeysLockForAudit", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckMoveKeysLockForAuditActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckMoveKeysLockForAuditActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 267 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
[[nodiscard]] static Future<Void> checkMoveKeysLockForAudit( Transaction* const& tr, MoveKeyLockInfo const& lock, bool const& isDDEnabled, bool const& isWrite = true ) {
															#line 267 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	return Future<Void>(new CheckMoveKeysLockForAuditActor(tr, lock, isDDEnabled, isWrite));
															#line 2689 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
}

#line 322 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"

															#line 2694 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via persistNewAuditState()
															#line 323 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
template <class PersistNewAuditStateActor>
															#line 323 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class PersistNewAuditStateActorState {
															#line 2701 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
															#line 323 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	PersistNewAuditStateActorState(Database const& cx,AuditStorageState const& auditState,MoveKeyLockInfo const& lock,bool const& ddEnabled) 
															#line 323 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
															#line 323 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		 : cx(cx),
															#line 323 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   auditState(auditState),
															#line 323 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   lock(lock),
															#line 323 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   ddEnabled(ddEnabled)
															#line 2714 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("persistNewAuditState", reinterpret_cast<unsigned long>(this));

	}
	~PersistNewAuditStateActorState() 
	{
		fdb_probe_actor_destroy("persistNewAuditState", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 327 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			ASSERT(!auditState.id.isValid());
															#line 328 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr = Transaction(cx);
															#line 329 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			auditId = UID();
															#line 330 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			latestExistingAuditState = AuditStorageState();
															#line 331 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(SevDebug, "AuditUtilPersistedNewAuditStateStart", auditId);
															#line 2737 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			try {
															#line 333 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				;
															#line 2741 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PersistNewAuditStateActorState();
		static_cast<PersistNewAuditStateActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 389 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!static_cast<PersistNewAuditStateActor*>(this)->SAV<UID>::futures) { (void)(auditId); this->~PersistNewAuditStateActorState(); static_cast<PersistNewAuditStateActor*>(this)->destroy(); return 0; }
															#line 2770 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		new (&static_cast<PersistNewAuditStateActor*>(this)->SAV< UID >::value()) UID(std::move(auditId)); // state_var_RVO
		this->~PersistNewAuditStateActorState();
		static_cast<PersistNewAuditStateActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 378 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(SevWarn, "AuditUtilPersistedNewAuditStateUnretriableError", auditId) .errorUnsuppressed(e) .detail("AuditKey", auditKey(auditState.getType(), auditId));
															#line 381 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			ASSERT_WE_THINK(e.code() == error_code_actor_cancelled || e.code() == error_code_movekeys_conflict);
															#line 382 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 2787 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
															#line 383 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 2791 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			}
			else
			{
															#line 385 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				return a_body1Catch1(persist_new_audit_metadata_error(), loopDepth);
															#line 2797 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 335 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 336 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 337 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 338 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<Void> __when_expr_0 = checkMoveKeysLockForAudit(&tr, lock, ddEnabled, true);
															#line 338 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<PersistNewAuditStateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2834 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PersistNewAuditStateActor*>(this)->actor_wait_state = 1;
															#line 338 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PersistNewAuditStateActor, 0, Void >*>(static_cast<PersistNewAuditStateActor*>(this)));
															#line 2839 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 371 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(SevDebug, "AuditUtilPersistedNewAuditStateError", auditId) .errorUnsuppressed(e) .detail("AuditKey", auditKey(auditState.getType(), auditId));
															#line 374 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 374 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<PersistNewAuditStateActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2878 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch2(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<PersistNewAuditStateActor*>(this)->actor_wait_state = 4;
															#line 374 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< PersistNewAuditStateActor, 3, Void >*>(static_cast<PersistNewAuditStateActor*>(this)));
															#line 2883 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 339 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = tr.getRange(auditKeyRange(auditState.getType()), 1, Snapshot::False, Reverse::True);
															#line 339 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (static_cast<PersistNewAuditStateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2900 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<PersistNewAuditStateActor*>(this)->actor_wait_state = 2;
															#line 339 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PersistNewAuditStateActor, 1, RangeResult >*>(static_cast<PersistNewAuditStateActor*>(this)));
															#line 2905 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 339 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = tr.getRange(auditKeyRange(auditState.getType()), 1, Snapshot::False, Reverse::True);
															#line 339 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (static_cast<PersistNewAuditStateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2916 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<PersistNewAuditStateActor*>(this)->actor_wait_state = 2;
															#line 339 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PersistNewAuditStateActor, 1, RangeResult >*>(static_cast<PersistNewAuditStateActor*>(this)));
															#line 2921 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PersistNewAuditStateActor*>(this)->actor_wait_state > 0) static_cast<PersistNewAuditStateActor*>(this)->actor_wait_state = 0;
		static_cast<PersistNewAuditStateActor*>(this)->ActorCallback< PersistNewAuditStateActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PersistNewAuditStateActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("persistNewAuditState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistNewAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistNewAuditState", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PersistNewAuditStateActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("persistNewAuditState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistNewAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistNewAuditState", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PersistNewAuditStateActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("persistNewAuditState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PersistNewAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistNewAuditState", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(RangeResult const& res,int loopDepth) 
	{
															#line 341 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		ASSERT(res.size() == 0 || res.size() == 1);
															#line 342 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		uint64_t nextId = 1;
															#line 343 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!res.empty())
															#line 3009 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 344 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			latestExistingAuditState = decodeAuditStorageState(res[0].value);
															#line 345 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (auditId.isValid())
															#line 3015 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
															#line 347 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				ASSERT(latestExistingAuditState.id.first() <= auditId.first());
															#line 348 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				if (latestExistingAuditState.id.first() == auditId.first())
															#line 3021 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				{
															#line 351 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
					if (!static_cast<PersistNewAuditStateActor*>(this)->SAV<UID>::futures) { (void)(auditId); this->~PersistNewAuditStateActorState(); static_cast<PersistNewAuditStateActor*>(this)->destroy(); return 0; }
															#line 3025 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
					new (&static_cast<PersistNewAuditStateActor*>(this)->SAV< UID >::value()) UID(std::move(auditId)); // state_var_RVO
					this->~PersistNewAuditStateActorState();
					static_cast<PersistNewAuditStateActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
				else
				{
															#line 356 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
					ASSERT(auditId.first() == latestExistingAuditState.id.first() + 1);
															#line 3035 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				}
			}
															#line 359 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			nextId = latestExistingAuditState.id.first() + 1;
															#line 3040 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 361 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		auditId = UID(nextId, 0LL);
															#line 362 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		auditState.id = auditId;
															#line 363 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		TraceEvent(SevVerbose, "AuditUtilPersistedNewAuditStateIdSelected", auditId) .detail("AuditKey", auditKey(auditState.getType(), auditId));
															#line 365 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		tr.set(auditKey(auditState.getType(), auditId), auditStorageStateValue(auditState));
															#line 366 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 366 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (static_cast<PersistNewAuditStateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3054 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<PersistNewAuditStateActor*>(this)->actor_wait_state = 3;
															#line 366 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PersistNewAuditStateActor, 2, Void >*>(static_cast<PersistNewAuditStateActor*>(this)));
															#line 3059 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(RangeResult && res,int loopDepth) 
	{
															#line 341 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		ASSERT(res.size() == 0 || res.size() == 1);
															#line 342 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		uint64_t nextId = 1;
															#line 343 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!res.empty())
															#line 3072 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 344 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			latestExistingAuditState = decodeAuditStorageState(res[0].value);
															#line 345 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (auditId.isValid())
															#line 3078 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
															#line 347 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				ASSERT(latestExistingAuditState.id.first() <= auditId.first());
															#line 348 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				if (latestExistingAuditState.id.first() == auditId.first())
															#line 3084 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				{
															#line 351 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
					if (!static_cast<PersistNewAuditStateActor*>(this)->SAV<UID>::futures) { (void)(auditId); this->~PersistNewAuditStateActorState(); static_cast<PersistNewAuditStateActor*>(this)->destroy(); return 0; }
															#line 3088 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
					new (&static_cast<PersistNewAuditStateActor*>(this)->SAV< UID >::value()) UID(std::move(auditId)); // state_var_RVO
					this->~PersistNewAuditStateActorState();
					static_cast<PersistNewAuditStateActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
				else
				{
															#line 356 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
					ASSERT(auditId.first() == latestExistingAuditState.id.first() + 1);
															#line 3098 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				}
			}
															#line 359 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			nextId = latestExistingAuditState.id.first() + 1;
															#line 3103 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 361 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		auditId = UID(nextId, 0LL);
															#line 362 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		auditState.id = auditId;
															#line 363 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		TraceEvent(SevVerbose, "AuditUtilPersistedNewAuditStateIdSelected", auditId) .detail("AuditKey", auditKey(auditState.getType(), auditId));
															#line 365 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		tr.set(auditKey(auditState.getType(), auditId), auditStorageStateValue(auditState));
															#line 366 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 366 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (static_cast<PersistNewAuditStateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3117 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<PersistNewAuditStateActor*>(this)->actor_wait_state = 3;
															#line 366 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PersistNewAuditStateActor, 2, Void >*>(static_cast<PersistNewAuditStateActor*>(this)));
															#line 3122 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult const& res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(res, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult && res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PersistNewAuditStateActor*>(this)->actor_wait_state > 0) static_cast<PersistNewAuditStateActor*>(this)->actor_wait_state = 0;
		static_cast<PersistNewAuditStateActor*>(this)->ActorCallback< PersistNewAuditStateActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< PersistNewAuditStateActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("persistNewAuditState", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistNewAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistNewAuditState", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PersistNewAuditStateActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("persistNewAuditState", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistNewAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistNewAuditState", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PersistNewAuditStateActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("persistNewAuditState", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PersistNewAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistNewAuditState", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 367 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		TraceEvent(SevDebug, "AuditUtilPersistedNewAuditState", auditId) .detail("AuditKey", auditKey(auditState.getType(), auditId));
															#line 3206 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 367 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		TraceEvent(SevDebug, "AuditUtilPersistedNewAuditState", auditId) .detail("AuditKey", auditKey(auditState.getType(), auditId));
															#line 3215 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<PersistNewAuditStateActor*>(this)->actor_wait_state > 0) static_cast<PersistNewAuditStateActor*>(this)->actor_wait_state = 0;
		static_cast<PersistNewAuditStateActor*>(this)->ActorCallback< PersistNewAuditStateActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PersistNewAuditStateActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("persistNewAuditState", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistNewAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistNewAuditState", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< PersistNewAuditStateActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("persistNewAuditState", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistNewAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistNewAuditState", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< PersistNewAuditStateActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("persistNewAuditState", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PersistNewAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistNewAuditState", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<PersistNewAuditStateActor*>(this)->actor_wait_state > 0) static_cast<PersistNewAuditStateActor*>(this)->actor_wait_state = 0;
		static_cast<PersistNewAuditStateActor*>(this)->ActorCallback< PersistNewAuditStateActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PersistNewAuditStateActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("persistNewAuditState", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistNewAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistNewAuditState", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< PersistNewAuditStateActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("persistNewAuditState", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistNewAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistNewAuditState", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< PersistNewAuditStateActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("persistNewAuditState", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PersistNewAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistNewAuditState", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 323 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Database cx;
															#line 323 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	AuditStorageState auditState;
															#line 323 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	MoveKeyLockInfo lock;
															#line 323 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	bool ddEnabled;
															#line 328 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Transaction tr;
															#line 329 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	UID auditId;
															#line 330 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	AuditStorageState latestExistingAuditState;
															#line 3409 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
};
// This generated class is to be used only via persistNewAuditState()
															#line 323 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class PersistNewAuditStateActor final : public Actor<UID>, public ActorCallback< PersistNewAuditStateActor, 0, Void >, public ActorCallback< PersistNewAuditStateActor, 1, RangeResult >, public ActorCallback< PersistNewAuditStateActor, 2, Void >, public ActorCallback< PersistNewAuditStateActor, 3, Void >, public FastAllocated<PersistNewAuditStateActor>, public PersistNewAuditStateActorState<PersistNewAuditStateActor> {
															#line 3414 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
	using FastAllocated<PersistNewAuditStateActor>::operator new;
	using FastAllocated<PersistNewAuditStateActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10915997700645903872UL, 12005463966504256512UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<UID>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PersistNewAuditStateActor, 0, Void >;
friend struct ActorCallback< PersistNewAuditStateActor, 1, RangeResult >;
friend struct ActorCallback< PersistNewAuditStateActor, 2, Void >;
friend struct ActorCallback< PersistNewAuditStateActor, 3, Void >;
															#line 323 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	PersistNewAuditStateActor(Database const& cx,AuditStorageState const& auditState,MoveKeyLockInfo const& lock,bool const& ddEnabled) 
															#line 3434 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		 : Actor<UID>(),
		   PersistNewAuditStateActorState<PersistNewAuditStateActor>(cx, auditState, lock, ddEnabled),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("persistNewAuditState", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10305488094696748544UL, 8284581294054826496UL);
		ActorExecutionContextHelper __helper(static_cast<PersistNewAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("persistNewAuditState");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("persistNewAuditState", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PersistNewAuditStateActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PersistNewAuditStateActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< PersistNewAuditStateActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< PersistNewAuditStateActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 323 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
[[nodiscard]] Future<UID> persistNewAuditState( Database const& cx, AuditStorageState const& auditState, MoveKeyLockInfo const& lock, bool const& ddEnabled ) {
															#line 323 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	return Future<UID>(new PersistNewAuditStateActor(cx, auditState, lock, ddEnabled));
															#line 3470 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
}

#line 391 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"

															#line 3475 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via persistAuditState()
															#line 392 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
template <class PersistAuditStateActor>
															#line 392 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class PersistAuditStateActorState {
															#line 3482 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
															#line 392 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	PersistAuditStateActorState(Database const& cx,AuditStorageState const& auditState,std::string const& context,MoveKeyLockInfo const& lock,bool const& ddEnabled) 
															#line 392 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
															#line 392 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		 : cx(cx),
															#line 392 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   auditState(auditState),
															#line 392 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   context(context),
															#line 392 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   lock(lock),
															#line 392 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   ddEnabled(ddEnabled),
															#line 397 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   tr(cx),
															#line 398 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   auditPhase(auditState.getPhase())
															#line 3501 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("persistAuditState", reinterpret_cast<unsigned long>(this));

	}
	~PersistAuditStateActorState() 
	{
		fdb_probe_actor_destroy("persistAuditState", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 399 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			ASSERT(auditPhase == AuditPhase::Complete || auditPhase == AuditPhase::Failed || auditPhase == AuditPhase::Error);
															#line 401 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			;
															#line 3518 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PersistAuditStateActorState();
		static_cast<PersistAuditStateActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 444 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!static_cast<PersistAuditStateActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PersistAuditStateActorState(); static_cast<PersistAuditStateActor*>(this)->destroy(); return 0; }
															#line 3541 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		new (&static_cast<PersistAuditStateActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PersistAuditStateActorState();
		static_cast<PersistAuditStateActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 403 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 404 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 405 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 406 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<Void> __when_expr_0 = checkMoveKeysLockForAudit(&tr, lock, ddEnabled, true);
															#line 406 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<PersistAuditStateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3569 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PersistAuditStateActor*>(this)->actor_wait_state = 1;
															#line 406 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PersistAuditStateActor, 0, Void >*>(static_cast<PersistAuditStateActor*>(this)));
															#line 3574 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 433 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(SevWarn, "AuditUtilPersistAuditStateError", auditState.id) .errorUnsuppressed(e) .detail("AuditID", auditState.id) .detail("AuditType", auditState.getType()) .detail("AuditPhase", auditPhase) .detail("AuditKey", auditKey(auditState.getType(), auditState.id)) .detail("Context", context);
															#line 440 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 440 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<PersistAuditStateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3613 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<PersistAuditStateActor*>(this)->actor_wait_state = 4;
															#line 440 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< PersistAuditStateActor, 3, Void >*>(static_cast<PersistAuditStateActor*>(this)));
															#line 3618 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 408 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (auditPhase == AuditPhase::Complete)
															#line 3633 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 409 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			clearAuditProgressMetadata(&tr, auditState.getType(), auditState.id);
															#line 3637 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 412 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_1 = tr.get(auditKey(auditState.getType(), auditState.id));
															#line 412 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (static_cast<PersistAuditStateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3643 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<PersistAuditStateActor*>(this)->actor_wait_state = 2;
															#line 412 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PersistAuditStateActor, 1, Optional<Value> >*>(static_cast<PersistAuditStateActor*>(this)));
															#line 3648 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 408 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (auditPhase == AuditPhase::Complete)
															#line 3657 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 409 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			clearAuditProgressMetadata(&tr, auditState.getType(), auditState.id);
															#line 3661 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 412 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_1 = tr.get(auditKey(auditState.getType(), auditState.id));
															#line 412 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (static_cast<PersistAuditStateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3667 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<PersistAuditStateActor*>(this)->actor_wait_state = 2;
															#line 412 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PersistAuditStateActor, 1, Optional<Value> >*>(static_cast<PersistAuditStateActor*>(this)));
															#line 3672 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PersistAuditStateActor*>(this)->actor_wait_state > 0) static_cast<PersistAuditStateActor*>(this)->actor_wait_state = 0;
		static_cast<PersistAuditStateActor*>(this)->ActorCallback< PersistAuditStateActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PersistAuditStateActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("persistAuditState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditState", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PersistAuditStateActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("persistAuditState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditState", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PersistAuditStateActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("persistAuditState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditState", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Optional<Value> const& res_,int loopDepth) 
	{
															#line 413 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!res_.present())
															#line 3756 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 414 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			return a_body1loopBody1Catch1(audit_storage_cancelled(), loopDepth);
															#line 3760 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
		else
		{
															#line 416 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			const AuditStorageState currentState = decodeAuditStorageState(res_.get());
															#line 417 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			ASSERT(currentState.id == auditState.id && currentState.getType() == auditState.getType());
															#line 418 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (currentState.getPhase() == AuditPhase::Failed)
															#line 3770 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
															#line 419 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				return a_body1loopBody1Catch1(audit_storage_cancelled(), loopDepth);
															#line 3774 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			}
		}
															#line 423 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		tr.set(auditKey(auditState.getType(), auditState.id), auditStorageStateValue(auditState));
															#line 424 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 424 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (static_cast<PersistAuditStateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3783 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<PersistAuditStateActor*>(this)->actor_wait_state = 3;
															#line 424 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PersistAuditStateActor, 2, Void >*>(static_cast<PersistAuditStateActor*>(this)));
															#line 3788 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Optional<Value> && res_,int loopDepth) 
	{
															#line 413 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!res_.present())
															#line 3797 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 414 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			return a_body1loopBody1Catch1(audit_storage_cancelled(), loopDepth);
															#line 3801 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
		else
		{
															#line 416 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			const AuditStorageState currentState = decodeAuditStorageState(res_.get());
															#line 417 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			ASSERT(currentState.id == auditState.id && currentState.getType() == auditState.getType());
															#line 418 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (currentState.getPhase() == AuditPhase::Failed)
															#line 3811 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
															#line 419 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				return a_body1loopBody1Catch1(audit_storage_cancelled(), loopDepth);
															#line 3815 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			}
		}
															#line 423 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		tr.set(auditKey(auditState.getType(), auditState.id), auditStorageStateValue(auditState));
															#line 424 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 424 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (static_cast<PersistAuditStateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3824 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<PersistAuditStateActor*>(this)->actor_wait_state = 3;
															#line 424 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PersistAuditStateActor, 2, Void >*>(static_cast<PersistAuditStateActor*>(this)));
															#line 3829 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Optional<Value> const& res_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(res_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Optional<Value> && res_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(res_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PersistAuditStateActor*>(this)->actor_wait_state > 0) static_cast<PersistAuditStateActor*>(this)->actor_wait_state = 0;
		static_cast<PersistAuditStateActor*>(this)->ActorCallback< PersistAuditStateActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< PersistAuditStateActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("persistAuditState", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditState", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PersistAuditStateActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("persistAuditState", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditState", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PersistAuditStateActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("persistAuditState", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditState", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 425 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		TraceEvent(SevInfo, "AuditUtilPersistAuditState", auditState.id) .detail("AuditID", auditState.id) .detail("AuditType", auditState.getType()) .detail("AuditPhase", auditPhase) .detail("AuditKey", auditKey(auditState.getType(), auditState.id)) .detail("Context", context);
															#line 3913 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 425 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		TraceEvent(SevInfo, "AuditUtilPersistAuditState", auditState.id) .detail("AuditID", auditState.id) .detail("AuditType", auditState.getType()) .detail("AuditPhase", auditPhase) .detail("AuditKey", auditKey(auditState.getType(), auditState.id)) .detail("Context", context);
															#line 3922 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<PersistAuditStateActor*>(this)->actor_wait_state > 0) static_cast<PersistAuditStateActor*>(this)->actor_wait_state = 0;
		static_cast<PersistAuditStateActor*>(this)->ActorCallback< PersistAuditStateActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PersistAuditStateActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("persistAuditState", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditState", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< PersistAuditStateActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("persistAuditState", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditState", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< PersistAuditStateActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("persistAuditState", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditState", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<PersistAuditStateActor*>(this)->actor_wait_state > 0) static_cast<PersistAuditStateActor*>(this)->actor_wait_state = 0;
		static_cast<PersistAuditStateActor*>(this)->ActorCallback< PersistAuditStateActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PersistAuditStateActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("persistAuditState", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditState", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< PersistAuditStateActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("persistAuditState", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditState", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< PersistAuditStateActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("persistAuditState", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditState", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 392 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Database cx;
															#line 392 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	AuditStorageState auditState;
															#line 392 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	std::string context;
															#line 392 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	MoveKeyLockInfo lock;
															#line 392 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	bool ddEnabled;
															#line 397 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Transaction tr;
															#line 398 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	AuditPhase auditPhase;
															#line 4103 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
};
// This generated class is to be used only via persistAuditState()
															#line 392 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class PersistAuditStateActor final : public Actor<Void>, public ActorCallback< PersistAuditStateActor, 0, Void >, public ActorCallback< PersistAuditStateActor, 1, Optional<Value> >, public ActorCallback< PersistAuditStateActor, 2, Void >, public ActorCallback< PersistAuditStateActor, 3, Void >, public FastAllocated<PersistAuditStateActor>, public PersistAuditStateActorState<PersistAuditStateActor> {
															#line 4108 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
	using FastAllocated<PersistAuditStateActor>::operator new;
	using FastAllocated<PersistAuditStateActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6534374245937690880UL, 12643174776893178880UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PersistAuditStateActor, 0, Void >;
friend struct ActorCallback< PersistAuditStateActor, 1, Optional<Value> >;
friend struct ActorCallback< PersistAuditStateActor, 2, Void >;
friend struct ActorCallback< PersistAuditStateActor, 3, Void >;
															#line 392 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	PersistAuditStateActor(Database const& cx,AuditStorageState const& auditState,std::string const& context,MoveKeyLockInfo const& lock,bool const& ddEnabled) 
															#line 4128 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   PersistAuditStateActorState<PersistAuditStateActor>(cx, auditState, context, lock, ddEnabled),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("persistAuditState", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1344343807573194240UL, 3027519602546182400UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("persistAuditState");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("persistAuditState", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PersistAuditStateActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PersistAuditStateActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< PersistAuditStateActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< PersistAuditStateActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 392 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
[[nodiscard]] Future<Void> persistAuditState( Database const& cx, AuditStorageState const& auditState, std::string const& context, MoveKeyLockInfo const& lock, bool const& ddEnabled ) {
															#line 392 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	return Future<Void>(new PersistAuditStateActor(cx, auditState, context, lock, ddEnabled));
															#line 4164 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
}

#line 446 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"

															#line 4169 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getAuditState()
															#line 447 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
template <class GetAuditStateActor>
															#line 447 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class GetAuditStateActorState {
															#line 4176 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
															#line 447 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	GetAuditStateActorState(Database const& cx,AuditType const& type,UID const& id) 
															#line 447 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
															#line 447 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		 : cx(cx),
															#line 447 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   type(type),
															#line 447 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   id(id),
															#line 448 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   tr(cx),
															#line 449 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   res()
															#line 4191 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getAuditState", reinterpret_cast<unsigned long>(this));

	}
	~GetAuditStateActorState() 
	{
		fdb_probe_actor_destroy("getAuditState", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 451 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			;
															#line 4206 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetAuditStateActorState();
		static_cast<GetAuditStateActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 473 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!res.present())
															#line 4229 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 474 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			return a_body1Catch1(key_not_found(), loopDepth);
															#line 4233 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 477 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!static_cast<GetAuditStateActor*>(this)->SAV<AuditStorageState>::futures) { (void)(decodeAuditStorageState(res.get())); this->~GetAuditStateActorState(); static_cast<GetAuditStateActor*>(this)->destroy(); return 0; }
															#line 4237 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		new (&static_cast<GetAuditStateActor*>(this)->SAV< AuditStorageState >::value()) AuditStorageState(decodeAuditStorageState(res.get()));
		this->~GetAuditStateActorState();
		static_cast<GetAuditStateActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 453 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 454 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 455 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 456 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(auditKey(type, id));
															#line 456 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<GetAuditStateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4265 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetAuditStateActor*>(this)->actor_wait_state = 1;
															#line 456 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetAuditStateActor, 0, Optional<Value> >*>(static_cast<GetAuditStateActor*>(this)));
															#line 4270 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 464 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(SevDebug, "AuditUtilReadAuditStateError", id) .errorUnsuppressed(e) .detail("AuditID", id) .detail("AuditType", type) .detail("AuditKey", auditKey(type, id));
															#line 469 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 469 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<GetAuditStateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4309 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetAuditStateActor*>(this)->actor_wait_state = 2;
															#line 469 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetAuditStateActor, 1, Void >*>(static_cast<GetAuditStateActor*>(this)));
															#line 4314 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& res_,int loopDepth) 
	{
															#line 457 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		res = res_;
															#line 458 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		TraceEvent(SevDebug, "AuditUtilReadAuditState", id) .detail("AuditID", id) .detail("AuditType", type) .detail("AuditKey", auditKey(type, id));
															#line 4331 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && res_,int loopDepth) 
	{
															#line 457 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		res = res_;
															#line 458 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		TraceEvent(SevDebug, "AuditUtilReadAuditState", id) .detail("AuditID", id) .detail("AuditType", type) .detail("AuditKey", auditKey(type, id));
															#line 4342 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& res_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(res_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && res_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(res_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetAuditStateActor*>(this)->actor_wait_state > 0) static_cast<GetAuditStateActor*>(this)->actor_wait_state = 0;
		static_cast<GetAuditStateActor*>(this)->ActorCallback< GetAuditStateActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetAuditStateActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("getAuditState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditState", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetAuditStateActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("getAuditState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditState", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetAuditStateActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("getAuditState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditState", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetAuditStateActor*>(this)->actor_wait_state > 0) static_cast<GetAuditStateActor*>(this)->actor_wait_state = 0;
		static_cast<GetAuditStateActor*>(this)->ActorCallback< GetAuditStateActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetAuditStateActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getAuditState", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditState", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetAuditStateActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getAuditState", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditState", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetAuditStateActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getAuditState", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditState", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 447 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Database cx;
															#line 447 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	AuditType type;
															#line 447 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	UID id;
															#line 448 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Transaction tr;
															#line 449 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Optional<Value> res;
															#line 4519 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getAuditState()
															#line 447 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class GetAuditStateActor final : public Actor<AuditStorageState>, public ActorCallback< GetAuditStateActor, 0, Optional<Value> >, public ActorCallback< GetAuditStateActor, 1, Void >, public FastAllocated<GetAuditStateActor>, public GetAuditStateActorState<GetAuditStateActor> {
															#line 4524 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetAuditStateActor>::operator new;
	using FastAllocated<GetAuditStateActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1469679554186541056UL, 8938232495603101696UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<AuditStorageState>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetAuditStateActor, 0, Optional<Value> >;
friend struct ActorCallback< GetAuditStateActor, 1, Void >;
															#line 447 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	GetAuditStateActor(Database const& cx,AuditType const& type,UID const& id) 
															#line 4542 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		 : Actor<AuditStorageState>(),
		   GetAuditStateActorState<GetAuditStateActor>(cx, type, id),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getAuditState", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14929657578609179648UL, 1747181064157270016UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getAuditState");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getAuditState", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetAuditStateActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetAuditStateActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 447 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
[[nodiscard]] Future<AuditStorageState> getAuditState( Database const& cx, AuditType const& type, UID const& id ) {
															#line 447 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	return Future<AuditStorageState>(new GetAuditStateActor(cx, type, id));
															#line 4576 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
}

#line 479 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"

															#line 4581 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via persistAuditStateByRange()
															#line 480 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
template <class PersistAuditStateByRangeActor>
															#line 480 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class PersistAuditStateByRangeActorState {
															#line 4588 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
															#line 480 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	PersistAuditStateByRangeActorState(Database const& cx,AuditStorageState const& auditState) 
															#line 480 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
															#line 480 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		 : cx(cx),
															#line 480 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   auditState(auditState),
															#line 481 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   tr(cx)
															#line 4599 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("persistAuditStateByRange", reinterpret_cast<unsigned long>(this));

	}
	~PersistAuditStateByRangeActorState() 
	{
		fdb_probe_actor_destroy("persistAuditStateByRange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 483 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			;
															#line 4614 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PersistAuditStateByRangeActorState();
		static_cast<PersistAuditStateByRangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 526 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!static_cast<PersistAuditStateByRangeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PersistAuditStateByRangeActorState(); static_cast<PersistAuditStateByRangeActor*>(this)->destroy(); return 0; }
															#line 4637 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		new (&static_cast<PersistAuditStateByRangeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PersistAuditStateByRangeActorState();
		static_cast<PersistAuditStateByRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 485 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 486 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 487 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 488 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(auditKey(auditState.getType(), auditState.id));
															#line 488 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<PersistAuditStateByRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4665 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PersistAuditStateByRangeActor*>(this)->actor_wait_state = 1;
															#line 488 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PersistAuditStateByRangeActor, 0, Optional<Value> >*>(static_cast<PersistAuditStateByRangeActor*>(this)));
															#line 4670 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 517 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(SevDebug, "AuditUtilPersistAuditStateByRangeError") .errorUnsuppressed(e) .detail("AuditID", auditState.id) .detail("AuditType", auditState.getType()) .detail("AuditPhase", auditState.getPhase());
															#line 522 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 522 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<PersistAuditStateByRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4709 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<PersistAuditStateByRangeActor*>(this)->actor_wait_state = 4;
															#line 522 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< PersistAuditStateByRangeActor, 3, Void >*>(static_cast<PersistAuditStateByRangeActor*>(this)));
															#line 4714 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& ddAuditState_,int loopDepth) 
	{
															#line 489 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!ddAuditState_.present())
															#line 4729 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 490 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			return a_body1loopBody1Catch1(audit_storage_cancelled(), loopDepth);
															#line 4733 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 492 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		AuditStorageState ddAuditState = decodeAuditStorageState(ddAuditState_.get());
															#line 493 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		ASSERT(ddAuditState.ddId.isValid());
															#line 494 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (ddAuditState.ddId != auditState.ddId)
															#line 4741 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 497 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			auditState.ddId = ddAuditState.ddId;
															#line 4745 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 502 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (ddAuditState.getPhase() == AuditPhase::Complete)
															#line 4749 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 506 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		ASSERT(ddAuditState.getPhase() == AuditPhase::Running || ddAuditState.getPhase() == AuditPhase::Failed);
															#line 507 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (ddAuditState.getPhase() == AuditPhase::Failed)
															#line 4757 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 508 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			return a_body1loopBody1Catch1(audit_storage_cancelled(), loopDepth);
															#line 4761 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 510 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		StrictFuture<Void> __when_expr_1 = krmSetRange(&tr, auditRangeBasedProgressPrefixFor(auditState.getType(), auditState.id), auditState.range, auditStorageStateValue(auditState));
															#line 510 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (static_cast<PersistAuditStateByRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4767 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<PersistAuditStateByRangeActor*>(this)->actor_wait_state = 2;
															#line 510 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PersistAuditStateByRangeActor, 1, Void >*>(static_cast<PersistAuditStateByRangeActor*>(this)));
															#line 4772 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && ddAuditState_,int loopDepth) 
	{
															#line 489 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!ddAuditState_.present())
															#line 4781 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 490 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			return a_body1loopBody1Catch1(audit_storage_cancelled(), loopDepth);
															#line 4785 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 492 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		AuditStorageState ddAuditState = decodeAuditStorageState(ddAuditState_.get());
															#line 493 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		ASSERT(ddAuditState.ddId.isValid());
															#line 494 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (ddAuditState.ddId != auditState.ddId)
															#line 4793 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 497 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			auditState.ddId = ddAuditState.ddId;
															#line 4797 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 502 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (ddAuditState.getPhase() == AuditPhase::Complete)
															#line 4801 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 506 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		ASSERT(ddAuditState.getPhase() == AuditPhase::Running || ddAuditState.getPhase() == AuditPhase::Failed);
															#line 507 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (ddAuditState.getPhase() == AuditPhase::Failed)
															#line 4809 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 508 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			return a_body1loopBody1Catch1(audit_storage_cancelled(), loopDepth);
															#line 4813 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 510 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		StrictFuture<Void> __when_expr_1 = krmSetRange(&tr, auditRangeBasedProgressPrefixFor(auditState.getType(), auditState.id), auditState.range, auditStorageStateValue(auditState));
															#line 510 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (static_cast<PersistAuditStateByRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4819 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<PersistAuditStateByRangeActor*>(this)->actor_wait_state = 2;
															#line 510 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PersistAuditStateByRangeActor, 1, Void >*>(static_cast<PersistAuditStateByRangeActor*>(this)));
															#line 4824 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& ddAuditState_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(ddAuditState_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && ddAuditState_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(ddAuditState_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PersistAuditStateByRangeActor*>(this)->actor_wait_state > 0) static_cast<PersistAuditStateByRangeActor*>(this)->actor_wait_state = 0;
		static_cast<PersistAuditStateByRangeActor*>(this)->ActorCallback< PersistAuditStateByRangeActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< PersistAuditStateByRangeActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PersistAuditStateByRangeActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PersistAuditStateByRangeActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 514 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 514 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (static_cast<PersistAuditStateByRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4910 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<PersistAuditStateByRangeActor*>(this)->actor_wait_state = 3;
															#line 514 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PersistAuditStateByRangeActor, 2, Void >*>(static_cast<PersistAuditStateByRangeActor*>(this)));
															#line 4915 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 514 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 514 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (static_cast<PersistAuditStateByRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4926 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<PersistAuditStateByRangeActor*>(this)->actor_wait_state = 3;
															#line 514 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PersistAuditStateByRangeActor, 2, Void >*>(static_cast<PersistAuditStateByRangeActor*>(this)));
															#line 4931 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PersistAuditStateByRangeActor*>(this)->actor_wait_state > 0) static_cast<PersistAuditStateByRangeActor*>(this)->actor_wait_state = 0;
		static_cast<PersistAuditStateByRangeActor*>(this)->ActorCallback< PersistAuditStateByRangeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PersistAuditStateByRangeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PersistAuditStateByRangeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PersistAuditStateByRangeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont8(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<PersistAuditStateByRangeActor*>(this)->actor_wait_state > 0) static_cast<PersistAuditStateByRangeActor*>(this)->actor_wait_state = 0;
		static_cast<PersistAuditStateByRangeActor*>(this)->ActorCallback< PersistAuditStateByRangeActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PersistAuditStateByRangeActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< PersistAuditStateByRangeActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< PersistAuditStateByRangeActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<PersistAuditStateByRangeActor*>(this)->actor_wait_state > 0) static_cast<PersistAuditStateByRangeActor*>(this)->actor_wait_state = 0;
		static_cast<PersistAuditStateByRangeActor*>(this)->ActorCallback< PersistAuditStateByRangeActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PersistAuditStateByRangeActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< PersistAuditStateByRangeActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< PersistAuditStateByRangeActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 480 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Database cx;
															#line 480 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	AuditStorageState auditState;
															#line 481 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Transaction tr;
															#line 5191 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
};
// This generated class is to be used only via persistAuditStateByRange()
															#line 480 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class PersistAuditStateByRangeActor final : public Actor<Void>, public ActorCallback< PersistAuditStateByRangeActor, 0, Optional<Value> >, public ActorCallback< PersistAuditStateByRangeActor, 1, Void >, public ActorCallback< PersistAuditStateByRangeActor, 2, Void >, public ActorCallback< PersistAuditStateByRangeActor, 3, Void >, public FastAllocated<PersistAuditStateByRangeActor>, public PersistAuditStateByRangeActorState<PersistAuditStateByRangeActor> {
															#line 5196 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
	using FastAllocated<PersistAuditStateByRangeActor>::operator new;
	using FastAllocated<PersistAuditStateByRangeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7591789645951048960UL, 15237701149217769216UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PersistAuditStateByRangeActor, 0, Optional<Value> >;
friend struct ActorCallback< PersistAuditStateByRangeActor, 1, Void >;
friend struct ActorCallback< PersistAuditStateByRangeActor, 2, Void >;
friend struct ActorCallback< PersistAuditStateByRangeActor, 3, Void >;
															#line 480 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	PersistAuditStateByRangeActor(Database const& cx,AuditStorageState const& auditState) 
															#line 5216 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   PersistAuditStateByRangeActorState<PersistAuditStateByRangeActor>(cx, auditState),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12978781156159195648UL, 11031502681131358976UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("persistAuditStateByRange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PersistAuditStateByRangeActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PersistAuditStateByRangeActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< PersistAuditStateByRangeActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< PersistAuditStateByRangeActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 480 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
[[nodiscard]] Future<Void> persistAuditStateByRange( Database const& cx, AuditStorageState const& auditState ) {
															#line 480 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	return Future<Void>(new PersistAuditStateByRangeActor(cx, auditState));
															#line 5252 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
}

#line 528 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"

															#line 5257 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getAuditStateByRange()
															#line 529 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
template <class GetAuditStateByRangeActor>
															#line 529 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class GetAuditStateByRangeActorState {
															#line 5264 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
															#line 529 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	GetAuditStateByRangeActorState(Database const& cx,AuditType const& type,UID const& auditId,KeyRange const& range) 
															#line 529 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
															#line 529 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		 : cx(cx),
															#line 529 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   type(type),
															#line 529 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   auditId(auditId),
															#line 529 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   range(range),
															#line 533 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   auditStates(),
															#line 534 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   tr(cx)
															#line 5281 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getAuditStateByRange", reinterpret_cast<unsigned long>(this));

	}
	~GetAuditStateByRangeActorState() 
	{
		fdb_probe_actor_destroy("getAuditStateByRange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 536 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			;
															#line 5296 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetAuditStateByRangeActorState();
		static_cast<GetAuditStateByRangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 558 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		std::vector<AuditStorageState> res;
															#line 559 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		for(int i = 0;i < auditStates.size() - 1;++i) {
															#line 560 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			KeyRange currentRange = KeyRangeRef(auditStates[i].key, auditStates[i + 1].key);
															#line 561 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			AuditStorageState auditState(auditId, currentRange, type);
															#line 562 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (!auditStates[i].value.empty())
															#line 5327 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
															#line 563 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				AuditStorageState auditState_ = decodeAuditStorageState(auditStates[i].value);
															#line 564 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				auditState.setPhase(auditState_.getPhase());
															#line 565 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				auditState.error = auditState_.error;
															#line 5335 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			}
															#line 567 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			res.push_back(auditState);
															#line 5339 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 570 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!static_cast<GetAuditStateByRangeActor*>(this)->SAV<std::vector<AuditStorageState>>::futures) { (void)(res); this->~GetAuditStateByRangeActorState(); static_cast<GetAuditStateByRangeActor*>(this)->destroy(); return 0; }
															#line 5343 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		new (&static_cast<GetAuditStateByRangeActor*>(this)->SAV< std::vector<AuditStorageState> >::value()) std::vector<AuditStorageState>(res);
		this->~GetAuditStateByRangeActorState();
		static_cast<GetAuditStateByRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 538 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 539 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 540 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 541 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = krmGetRanges(&tr, auditRangeBasedProgressPrefixFor(type, auditId), range, CLIENT_KNOBS->KRM_GET_RANGE_LIMIT, CLIENT_KNOBS->KRM_GET_RANGE_LIMIT_BYTES);
															#line 541 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<GetAuditStateByRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5371 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetAuditStateByRangeActor*>(this)->actor_wait_state = 1;
															#line 541 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetAuditStateByRangeActor, 0, RangeResult >*>(static_cast<GetAuditStateByRangeActor*>(this)));
															#line 5376 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 549 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(SevDebug, "AuditUtilGetAuditStateForRangeError").errorUnsuppressed(e).detail("AuditID", auditId);
															#line 550 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 550 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<GetAuditStateByRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5415 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetAuditStateByRangeActor*>(this)->actor_wait_state = 2;
															#line 550 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetAuditStateByRangeActor, 1, Void >*>(static_cast<GetAuditStateByRangeActor*>(this)));
															#line 5420 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult const& res_,int loopDepth) 
	{
															#line 546 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		auditStates = res_;
															#line 5435 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult && res_,int loopDepth) 
	{
															#line 546 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		auditStates = res_;
															#line 5444 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& res_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(res_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && res_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(res_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetAuditStateByRangeActor*>(this)->actor_wait_state > 0) static_cast<GetAuditStateByRangeActor*>(this)->actor_wait_state = 0;
		static_cast<GetAuditStateByRangeActor*>(this)->ActorCallback< GetAuditStateByRangeActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetAuditStateByRangeActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getAuditStateByRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStateByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStateByRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetAuditStateByRangeActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getAuditStateByRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStateByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStateByRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetAuditStateByRangeActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getAuditStateByRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStateByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStateByRange", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetAuditStateByRangeActor*>(this)->actor_wait_state > 0) static_cast<GetAuditStateByRangeActor*>(this)->actor_wait_state = 0;
		static_cast<GetAuditStateByRangeActor*>(this)->ActorCallback< GetAuditStateByRangeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetAuditStateByRangeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getAuditStateByRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStateByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStateByRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetAuditStateByRangeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getAuditStateByRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStateByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStateByRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetAuditStateByRangeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getAuditStateByRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStateByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStateByRange", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 529 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Database cx;
															#line 529 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	AuditType type;
															#line 529 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	UID auditId;
															#line 529 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	KeyRange range;
															#line 533 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	RangeResult auditStates;
															#line 534 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Transaction tr;
															#line 5623 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getAuditStateByRange()
															#line 529 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class GetAuditStateByRangeActor final : public Actor<std::vector<AuditStorageState>>, public ActorCallback< GetAuditStateByRangeActor, 0, RangeResult >, public ActorCallback< GetAuditStateByRangeActor, 1, Void >, public FastAllocated<GetAuditStateByRangeActor>, public GetAuditStateByRangeActorState<GetAuditStateByRangeActor> {
															#line 5628 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetAuditStateByRangeActor>::operator new;
	using FastAllocated<GetAuditStateByRangeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(805364639734253568UL, 5647227109803952384UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<AuditStorageState>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetAuditStateByRangeActor, 0, RangeResult >;
friend struct ActorCallback< GetAuditStateByRangeActor, 1, Void >;
															#line 529 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	GetAuditStateByRangeActor(Database const& cx,AuditType const& type,UID const& auditId,KeyRange const& range) 
															#line 5646 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		 : Actor<std::vector<AuditStorageState>>(),
		   GetAuditStateByRangeActorState<GetAuditStateByRangeActor>(cx, type, auditId, range),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getAuditStateByRange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9019552324261391360UL, 16492306215431648768UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStateByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getAuditStateByRange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getAuditStateByRange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetAuditStateByRangeActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetAuditStateByRangeActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 529 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
[[nodiscard]] Future<std::vector<AuditStorageState>> getAuditStateByRange( Database const& cx, AuditType const& type, UID const& auditId, KeyRange const& range ) {
															#line 529 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	return Future<std::vector<AuditStorageState>>(new GetAuditStateByRangeActor(cx, type, auditId, range));
															#line 5680 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
}

#line 572 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"

															#line 5685 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via persistAuditStateByServer()
															#line 573 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
template <class PersistAuditStateByServerActor>
															#line 573 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class PersistAuditStateByServerActorState {
															#line 5692 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
															#line 573 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	PersistAuditStateByServerActorState(Database const& cx,AuditStorageState const& auditState) 
															#line 573 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
															#line 573 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		 : cx(cx),
															#line 573 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   auditState(auditState),
															#line 574 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   tr(cx)
															#line 5703 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("persistAuditStateByServer", reinterpret_cast<unsigned long>(this));

	}
	~PersistAuditStateByServerActorState() 
	{
		fdb_probe_actor_destroy("persistAuditStateByServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 576 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			;
															#line 5718 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PersistAuditStateByServerActorState();
		static_cast<PersistAuditStateByServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 621 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!static_cast<PersistAuditStateByServerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PersistAuditStateByServerActorState(); static_cast<PersistAuditStateByServerActor*>(this)->destroy(); return 0; }
															#line 5741 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		new (&static_cast<PersistAuditStateByServerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PersistAuditStateByServerActorState();
		static_cast<PersistAuditStateByServerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 578 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 579 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 580 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 581 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(auditKey(auditState.getType(), auditState.id));
															#line 581 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<PersistAuditStateByServerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5769 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PersistAuditStateByServerActor*>(this)->actor_wait_state = 1;
															#line 581 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PersistAuditStateByServerActor, 0, Optional<Value> >*>(static_cast<PersistAuditStateByServerActor*>(this)));
															#line 5774 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 611 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(SevDebug, "AuditUtilPersistAuditStateByRangeError") .errorUnsuppressed(e) .detail("AuditID", auditState.id) .detail("AuditType", auditState.getType()) .detail("AuditPhase", auditState.getPhase()) .detail("AuditServerID", auditState.auditServerId);
															#line 617 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 617 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<PersistAuditStateByServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5813 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<PersistAuditStateByServerActor*>(this)->actor_wait_state = 4;
															#line 617 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< PersistAuditStateByServerActor, 3, Void >*>(static_cast<PersistAuditStateByServerActor*>(this)));
															#line 5818 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& ddAuditState_,int loopDepth) 
	{
															#line 582 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!ddAuditState_.present())
															#line 5833 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 583 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			return a_body1loopBody1Catch1(audit_storage_cancelled(), loopDepth);
															#line 5837 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 585 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		AuditStorageState ddAuditState = decodeAuditStorageState(ddAuditState_.get());
															#line 586 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		ASSERT(ddAuditState.ddId.isValid());
															#line 587 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (ddAuditState.ddId != auditState.ddId)
															#line 5845 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 590 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			auditState.ddId = ddAuditState.ddId;
															#line 5849 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 595 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (ddAuditState.getPhase() == AuditPhase::Complete)
															#line 5853 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 599 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		ASSERT(ddAuditState.getPhase() == AuditPhase::Running || ddAuditState.getPhase() == AuditPhase::Failed);
															#line 600 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (ddAuditState.getPhase() == AuditPhase::Failed)
															#line 5861 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 601 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			return a_body1loopBody1Catch1(audit_storage_cancelled(), loopDepth);
															#line 5865 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 603 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		StrictFuture<Void> __when_expr_1 = krmSetRange( &tr, auditServerBasedProgressPrefixFor(auditState.getType(), auditState.id, auditState.auditServerId), auditState.range, auditStorageStateValue(auditState));
															#line 603 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (static_cast<PersistAuditStateByServerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5871 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<PersistAuditStateByServerActor*>(this)->actor_wait_state = 2;
															#line 603 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PersistAuditStateByServerActor, 1, Void >*>(static_cast<PersistAuditStateByServerActor*>(this)));
															#line 5876 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && ddAuditState_,int loopDepth) 
	{
															#line 582 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!ddAuditState_.present())
															#line 5885 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 583 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			return a_body1loopBody1Catch1(audit_storage_cancelled(), loopDepth);
															#line 5889 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 585 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		AuditStorageState ddAuditState = decodeAuditStorageState(ddAuditState_.get());
															#line 586 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		ASSERT(ddAuditState.ddId.isValid());
															#line 587 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (ddAuditState.ddId != auditState.ddId)
															#line 5897 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 590 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			auditState.ddId = ddAuditState.ddId;
															#line 5901 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 595 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (ddAuditState.getPhase() == AuditPhase::Complete)
															#line 5905 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 599 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		ASSERT(ddAuditState.getPhase() == AuditPhase::Running || ddAuditState.getPhase() == AuditPhase::Failed);
															#line 600 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (ddAuditState.getPhase() == AuditPhase::Failed)
															#line 5913 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 601 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			return a_body1loopBody1Catch1(audit_storage_cancelled(), loopDepth);
															#line 5917 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 603 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		StrictFuture<Void> __when_expr_1 = krmSetRange( &tr, auditServerBasedProgressPrefixFor(auditState.getType(), auditState.id, auditState.auditServerId), auditState.range, auditStorageStateValue(auditState));
															#line 603 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (static_cast<PersistAuditStateByServerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5923 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<PersistAuditStateByServerActor*>(this)->actor_wait_state = 2;
															#line 603 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PersistAuditStateByServerActor, 1, Void >*>(static_cast<PersistAuditStateByServerActor*>(this)));
															#line 5928 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& ddAuditState_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(ddAuditState_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && ddAuditState_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(ddAuditState_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PersistAuditStateByServerActor*>(this)->actor_wait_state > 0) static_cast<PersistAuditStateByServerActor*>(this)->actor_wait_state = 0;
		static_cast<PersistAuditStateByServerActor*>(this)->ActorCallback< PersistAuditStateByServerActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< PersistAuditStateByServerActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("persistAuditStateByServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditStateByServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PersistAuditStateByServerActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("persistAuditStateByServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditStateByServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PersistAuditStateByServerActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("persistAuditStateByServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditStateByServer", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 608 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 608 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (static_cast<PersistAuditStateByServerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6014 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<PersistAuditStateByServerActor*>(this)->actor_wait_state = 3;
															#line 608 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PersistAuditStateByServerActor, 2, Void >*>(static_cast<PersistAuditStateByServerActor*>(this)));
															#line 6019 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 608 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 608 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (static_cast<PersistAuditStateByServerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6030 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<PersistAuditStateByServerActor*>(this)->actor_wait_state = 3;
															#line 608 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PersistAuditStateByServerActor, 2, Void >*>(static_cast<PersistAuditStateByServerActor*>(this)));
															#line 6035 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PersistAuditStateByServerActor*>(this)->actor_wait_state > 0) static_cast<PersistAuditStateByServerActor*>(this)->actor_wait_state = 0;
		static_cast<PersistAuditStateByServerActor*>(this)->ActorCallback< PersistAuditStateByServerActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PersistAuditStateByServerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("persistAuditStateByServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditStateByServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PersistAuditStateByServerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("persistAuditStateByServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditStateByServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PersistAuditStateByServerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("persistAuditStateByServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditStateByServer", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont8(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<PersistAuditStateByServerActor*>(this)->actor_wait_state > 0) static_cast<PersistAuditStateByServerActor*>(this)->actor_wait_state = 0;
		static_cast<PersistAuditStateByServerActor*>(this)->ActorCallback< PersistAuditStateByServerActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PersistAuditStateByServerActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("persistAuditStateByServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditStateByServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< PersistAuditStateByServerActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("persistAuditStateByServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditStateByServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< PersistAuditStateByServerActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("persistAuditStateByServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditStateByServer", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<PersistAuditStateByServerActor*>(this)->actor_wait_state > 0) static_cast<PersistAuditStateByServerActor*>(this)->actor_wait_state = 0;
		static_cast<PersistAuditStateByServerActor*>(this)->ActorCallback< PersistAuditStateByServerActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PersistAuditStateByServerActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("persistAuditStateByServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditStateByServer", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< PersistAuditStateByServerActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("persistAuditStateByServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditStateByServer", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< PersistAuditStateByServerActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("persistAuditStateByServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditStateByServer", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 573 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Database cx;
															#line 573 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	AuditStorageState auditState;
															#line 574 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Transaction tr;
															#line 6295 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
};
// This generated class is to be used only via persistAuditStateByServer()
															#line 573 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class PersistAuditStateByServerActor final : public Actor<Void>, public ActorCallback< PersistAuditStateByServerActor, 0, Optional<Value> >, public ActorCallback< PersistAuditStateByServerActor, 1, Void >, public ActorCallback< PersistAuditStateByServerActor, 2, Void >, public ActorCallback< PersistAuditStateByServerActor, 3, Void >, public FastAllocated<PersistAuditStateByServerActor>, public PersistAuditStateByServerActorState<PersistAuditStateByServerActor> {
															#line 6300 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
	using FastAllocated<PersistAuditStateByServerActor>::operator new;
	using FastAllocated<PersistAuditStateByServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17277222126720092160UL, 5966701846302233088UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PersistAuditStateByServerActor, 0, Optional<Value> >;
friend struct ActorCallback< PersistAuditStateByServerActor, 1, Void >;
friend struct ActorCallback< PersistAuditStateByServerActor, 2, Void >;
friend struct ActorCallback< PersistAuditStateByServerActor, 3, Void >;
															#line 573 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	PersistAuditStateByServerActor(Database const& cx,AuditStorageState const& auditState) 
															#line 6320 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   PersistAuditStateByServerActorState<PersistAuditStateByServerActor>(cx, auditState),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("persistAuditStateByServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16835651359936887296UL, 15337111470123838976UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("persistAuditStateByServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("persistAuditStateByServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PersistAuditStateByServerActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PersistAuditStateByServerActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< PersistAuditStateByServerActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< PersistAuditStateByServerActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 573 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
[[nodiscard]] Future<Void> persistAuditStateByServer( Database const& cx, AuditStorageState const& auditState ) {
															#line 573 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	return Future<Void>(new PersistAuditStateByServerActor(cx, auditState));
															#line 6356 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
}

#line 623 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"

															#line 6361 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getAuditStateByServer()
															#line 624 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
template <class GetAuditStateByServerActor>
															#line 624 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class GetAuditStateByServerActorState {
															#line 6368 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
															#line 624 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	GetAuditStateByServerActorState(Database const& cx,AuditType const& type,UID const& auditId,UID const& auditServerId,KeyRange const& range) 
															#line 624 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
															#line 624 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		 : cx(cx),
															#line 624 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   type(type),
															#line 624 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   auditId(auditId),
															#line 624 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   auditServerId(auditServerId),
															#line 624 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   range(range),
															#line 629 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   auditStates(),
															#line 630 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   tr(cx)
															#line 6387 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getAuditStateByServer", reinterpret_cast<unsigned long>(this));

	}
	~GetAuditStateByServerActorState() 
	{
		fdb_probe_actor_destroy("getAuditStateByServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 632 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			;
															#line 6402 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetAuditStateByServerActorState();
		static_cast<GetAuditStateByServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 658 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		std::vector<AuditStorageState> res;
															#line 659 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		for(int i = 0;i < auditStates.size() - 1;++i) {
															#line 660 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			KeyRange currentRange = KeyRangeRef(auditStates[i].key, auditStates[i + 1].key);
															#line 661 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			AuditStorageState auditState(auditId, currentRange, type);
															#line 662 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (!auditStates[i].value.empty())
															#line 6433 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
															#line 663 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				AuditStorageState auditState_ = decodeAuditStorageState(auditStates[i].value);
															#line 664 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				auditState.setPhase(auditState_.getPhase());
															#line 665 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				auditState.error = auditState_.error;
															#line 6441 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			}
															#line 667 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			res.push_back(auditState);
															#line 6445 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 670 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!static_cast<GetAuditStateByServerActor*>(this)->SAV<std::vector<AuditStorageState>>::futures) { (void)(res); this->~GetAuditStateByServerActorState(); static_cast<GetAuditStateByServerActor*>(this)->destroy(); return 0; }
															#line 6449 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		new (&static_cast<GetAuditStateByServerActor*>(this)->SAV< std::vector<AuditStorageState> >::value()) std::vector<AuditStorageState>(res);
		this->~GetAuditStateByServerActorState();
		static_cast<GetAuditStateByServerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 634 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 635 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 636 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 637 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = krmGetRanges(&tr, auditServerBasedProgressPrefixFor(type, auditId, auditServerId), range, CLIENT_KNOBS->KRM_GET_RANGE_LIMIT, CLIENT_KNOBS->KRM_GET_RANGE_LIMIT_BYTES);
															#line 637 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<GetAuditStateByServerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6477 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetAuditStateByServerActor*>(this)->actor_wait_state = 1;
															#line 637 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetAuditStateByServerActor, 0, RangeResult >*>(static_cast<GetAuditStateByServerActor*>(this)));
															#line 6482 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 645 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(SevDebug, "AuditUtilGetAuditStateForRangeError") .errorUnsuppressed(e) .detail("AuditID", auditId) .detail("AuditType", type) .detail("AuditServerID", auditServerId);
															#line 650 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 650 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<GetAuditStateByServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6521 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetAuditStateByServerActor*>(this)->actor_wait_state = 2;
															#line 650 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetAuditStateByServerActor, 1, Void >*>(static_cast<GetAuditStateByServerActor*>(this)));
															#line 6526 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult const& res_,int loopDepth) 
	{
															#line 642 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		auditStates = res_;
															#line 6541 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult && res_,int loopDepth) 
	{
															#line 642 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		auditStates = res_;
															#line 6550 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& res_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(res_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && res_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(res_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetAuditStateByServerActor*>(this)->actor_wait_state > 0) static_cast<GetAuditStateByServerActor*>(this)->actor_wait_state = 0;
		static_cast<GetAuditStateByServerActor*>(this)->ActorCallback< GetAuditStateByServerActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetAuditStateByServerActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getAuditStateByServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStateByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStateByServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetAuditStateByServerActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getAuditStateByServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStateByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStateByServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetAuditStateByServerActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getAuditStateByServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStateByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStateByServer", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetAuditStateByServerActor*>(this)->actor_wait_state > 0) static_cast<GetAuditStateByServerActor*>(this)->actor_wait_state = 0;
		static_cast<GetAuditStateByServerActor*>(this)->ActorCallback< GetAuditStateByServerActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetAuditStateByServerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getAuditStateByServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStateByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStateByServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetAuditStateByServerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getAuditStateByServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStateByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStateByServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetAuditStateByServerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getAuditStateByServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStateByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStateByServer", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 624 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Database cx;
															#line 624 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	AuditType type;
															#line 624 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	UID auditId;
															#line 624 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	UID auditServerId;
															#line 624 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	KeyRange range;
															#line 629 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	RangeResult auditStates;
															#line 630 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Transaction tr;
															#line 6731 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getAuditStateByServer()
															#line 624 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class GetAuditStateByServerActor final : public Actor<std::vector<AuditStorageState>>, public ActorCallback< GetAuditStateByServerActor, 0, RangeResult >, public ActorCallback< GetAuditStateByServerActor, 1, Void >, public FastAllocated<GetAuditStateByServerActor>, public GetAuditStateByServerActorState<GetAuditStateByServerActor> {
															#line 6736 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetAuditStateByServerActor>::operator new;
	using FastAllocated<GetAuditStateByServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18440014954163648768UL, 17216218498246850816UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<AuditStorageState>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetAuditStateByServerActor, 0, RangeResult >;
friend struct ActorCallback< GetAuditStateByServerActor, 1, Void >;
															#line 624 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	GetAuditStateByServerActor(Database const& cx,AuditType const& type,UID const& auditId,UID const& auditServerId,KeyRange const& range) 
															#line 6754 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		 : Actor<std::vector<AuditStorageState>>(),
		   GetAuditStateByServerActorState<GetAuditStateByServerActor>(cx, type, auditId, auditServerId, range),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getAuditStateByServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8717234915021857024UL, 13842049359504508416UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStateByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getAuditStateByServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getAuditStateByServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetAuditStateByServerActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetAuditStateByServerActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 624 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
[[nodiscard]] Future<std::vector<AuditStorageState>> getAuditStateByServer( Database const& cx, AuditType const& type, UID const& auditId, UID const& auditServerId, KeyRange const& range ) {
															#line 624 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	return Future<std::vector<AuditStorageState>>(new GetAuditStateByServerActor(cx, type, auditId, auditServerId, range));
															#line 6788 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
}

#line 672 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"

															#line 6793 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via checkAuditProgressCompleteByRange()
															#line 673 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
template <class CheckAuditProgressCompleteByRangeActor>
															#line 673 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class CheckAuditProgressCompleteByRangeActorState {
															#line 6800 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
															#line 673 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	CheckAuditProgressCompleteByRangeActorState(Database const& cx,AuditType const& auditType,UID const& auditId,KeyRange const& auditRange) 
															#line 673 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
															#line 673 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		 : cx(cx),
															#line 673 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   auditType(auditType),
															#line 673 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   auditId(auditId),
															#line 673 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   auditRange(auditRange)
															#line 6813 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("checkAuditProgressCompleteByRange", reinterpret_cast<unsigned long>(this));

	}
	~CheckAuditProgressCompleteByRangeActorState() 
	{
		fdb_probe_actor_destroy("checkAuditProgressCompleteByRange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 677 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			ASSERT(auditType == AuditType::ValidateHA || auditType == AuditType::ValidateReplica || auditType == AuditType::ValidateLocationMetadata || auditType == AuditType::ValidateRestore);
															#line 679 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			rangeToRead = auditRange;
															#line 680 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			rangeToReadBegin = auditRange.begin;
															#line 681 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			retryCount = 0;
															#line 682 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			;
															#line 6836 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckAuditProgressCompleteByRangeActorState();
		static_cast<CheckAuditProgressCompleteByRangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 717 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		TraceEvent(SevInfo, "AuditUtilCheckAuditProgressFinish") .detail("AuditID", auditId) .detail("AuditRange", auditRange) .detail("AuditType", auditType);
															#line 721 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!static_cast<CheckAuditProgressCompleteByRangeActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckAuditProgressCompleteByRangeActorState(); static_cast<CheckAuditProgressCompleteByRangeActor*>(this)->destroy(); return 0; }
															#line 6861 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		new (&static_cast<CheckAuditProgressCompleteByRangeActor*>(this)->SAV< bool >::value()) bool(true);
		this->~CheckAuditProgressCompleteByRangeActorState();
		static_cast<CheckAuditProgressCompleteByRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 682 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!(rangeToReadBegin < auditRange.end))
															#line 6880 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 683 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		;
															#line 6886 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 685 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			rangeToRead = KeyRangeRef(rangeToReadBegin, auditRange.end);
															#line 686 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<std::vector<AuditStorageState>> __when_expr_0 = getAuditStateByRange(cx, auditType, auditId, rangeToRead);
															#line 686 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<CheckAuditProgressCompleteByRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6926 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckAuditProgressCompleteByRangeActor*>(this)->actor_wait_state = 1;
															#line 686 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckAuditProgressCompleteByRangeActor, 0, std::vector<AuditStorageState> >*>(static_cast<CheckAuditProgressCompleteByRangeActor*>(this)));
															#line 6931 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 702 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 6966 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
															#line 703 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 2));
															#line 6970 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			}
															#line 705 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (retryCount > 30)
															#line 6974 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
															#line 706 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				TraceEvent(SevWarn, "AuditUtilCheckAuditProgressFailed") .detail("AuditID", auditId) .detail("AuditRange", auditRange) .detail("AuditType", auditType);
															#line 710 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				return a_body1Catch1(audit_storage_failed(), std::max(0, loopDepth - 2));
															#line 6980 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			}
															#line 712 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(0.5);
															#line 712 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<CheckAuditProgressCompleteByRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 6986 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CheckAuditProgressCompleteByRangeActor*>(this)->actor_wait_state = 2;
															#line 712 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckAuditProgressCompleteByRangeActor, 1, Void >*>(static_cast<CheckAuditProgressCompleteByRangeActor*>(this)));
															#line 6991 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(int loopDepth) 
	{
															#line 688 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		for(int i = 0;i < auditStates.size();i++) {
															#line 689 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			AuditPhase phase = auditStates[i].getPhase();
															#line 690 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (phase == AuditPhase::Invalid)
															#line 7010 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
															#line 691 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				TraceEvent(SevWarn, "AuditUtilCheckAuditProgressNotFinished") .detail("AuditID", auditId) .detail("AuditRange", auditRange) .detail("AuditType", auditType) .detail("UnfinishedRange", auditStates[i].range);
															#line 696 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				if (!static_cast<CheckAuditProgressCompleteByRangeActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckAuditProgressCompleteByRangeActorState(); static_cast<CheckAuditProgressCompleteByRangeActor*>(this)->destroy(); return 0; }
															#line 7016 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				new (&static_cast<CheckAuditProgressCompleteByRangeActor*>(this)->SAV< bool >::value()) bool(false);
				this->~CheckAuditProgressCompleteByRangeActorState();
				static_cast<CheckAuditProgressCompleteByRangeActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 699 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		rangeToReadBegin = auditStates.back().range.end;
															#line 7025 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(std::vector<AuditStorageState> const& __auditStates,int loopDepth) 
	{
															#line 686 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		auditStates = __auditStates;
															#line 7034 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(std::vector<AuditStorageState> && __auditStates,int loopDepth) 
	{
		auditStates = std::move(__auditStates);
		loopDepth = a_body1loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckAuditProgressCompleteByRangeActor*>(this)->actor_wait_state > 0) static_cast<CheckAuditProgressCompleteByRangeActor*>(this)->actor_wait_state = 0;
		static_cast<CheckAuditProgressCompleteByRangeActor*>(this)->ActorCallback< CheckAuditProgressCompleteByRangeActor, 0, std::vector<AuditStorageState> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckAuditProgressCompleteByRangeActor, 0, std::vector<AuditStorageState> >*,std::vector<AuditStorageState> const& value) 
	{
		fdb_probe_actor_enter("checkAuditProgressCompleteByRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAuditProgressCompleteByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAuditProgressCompleteByRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckAuditProgressCompleteByRangeActor, 0, std::vector<AuditStorageState> >*,std::vector<AuditStorageState> && value) 
	{
		fdb_probe_actor_enter("checkAuditProgressCompleteByRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAuditProgressCompleteByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAuditProgressCompleteByRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckAuditProgressCompleteByRangeActor, 0, std::vector<AuditStorageState> >*,Error err) 
	{
		fdb_probe_actor_enter("checkAuditProgressCompleteByRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAuditProgressCompleteByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAuditProgressCompleteByRange", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 713 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		retryCount++;
															#line 7113 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 713 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		retryCount++;
															#line 7122 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckAuditProgressCompleteByRangeActor*>(this)->actor_wait_state > 0) static_cast<CheckAuditProgressCompleteByRangeActor*>(this)->actor_wait_state = 0;
		static_cast<CheckAuditProgressCompleteByRangeActor*>(this)->ActorCallback< CheckAuditProgressCompleteByRangeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckAuditProgressCompleteByRangeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkAuditProgressCompleteByRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAuditProgressCompleteByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAuditProgressCompleteByRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckAuditProgressCompleteByRangeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkAuditProgressCompleteByRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAuditProgressCompleteByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAuditProgressCompleteByRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckAuditProgressCompleteByRangeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkAuditProgressCompleteByRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAuditProgressCompleteByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAuditProgressCompleteByRange", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 673 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Database cx;
															#line 673 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	AuditType auditType;
															#line 673 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	UID auditId;
															#line 673 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	KeyRange auditRange;
															#line 679 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	KeyRange rangeToRead;
															#line 680 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Key rangeToReadBegin;
															#line 681 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	int retryCount;
															#line 686 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	std::vector<AuditStorageState> auditStates;
															#line 7218 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
};
// This generated class is to be used only via checkAuditProgressCompleteByRange()
															#line 673 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class CheckAuditProgressCompleteByRangeActor final : public Actor<bool>, public ActorCallback< CheckAuditProgressCompleteByRangeActor, 0, std::vector<AuditStorageState> >, public ActorCallback< CheckAuditProgressCompleteByRangeActor, 1, Void >, public FastAllocated<CheckAuditProgressCompleteByRangeActor>, public CheckAuditProgressCompleteByRangeActorState<CheckAuditProgressCompleteByRangeActor> {
															#line 7223 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
	using FastAllocated<CheckAuditProgressCompleteByRangeActor>::operator new;
	using FastAllocated<CheckAuditProgressCompleteByRangeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15588176570140928000UL, 959022233139194624UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckAuditProgressCompleteByRangeActor, 0, std::vector<AuditStorageState> >;
friend struct ActorCallback< CheckAuditProgressCompleteByRangeActor, 1, Void >;
															#line 673 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	CheckAuditProgressCompleteByRangeActor(Database const& cx,AuditType const& auditType,UID const& auditId,KeyRange const& auditRange) 
															#line 7241 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   CheckAuditProgressCompleteByRangeActorState<CheckAuditProgressCompleteByRangeActor>(cx, auditType, auditId, auditRange),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkAuditProgressCompleteByRange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3026521694061770240UL, 13785155459301910272UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAuditProgressCompleteByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkAuditProgressCompleteByRange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkAuditProgressCompleteByRange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckAuditProgressCompleteByRangeActor, 0, std::vector<AuditStorageState> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckAuditProgressCompleteByRangeActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 673 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
[[nodiscard]] Future<bool> checkAuditProgressCompleteByRange( Database const& cx, AuditType const& auditType, UID const& auditId, KeyRange const& auditRange ) {
															#line 673 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	return Future<bool>(new CheckAuditProgressCompleteByRangeActor(cx, auditType, auditId, auditRange));
															#line 7275 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
}

#line 723 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"

															#line 7280 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via checkAuditProgressCompleteByServer()
															#line 724 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
template <class CheckAuditProgressCompleteByServerActor>
															#line 724 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class CheckAuditProgressCompleteByServerActorState {
															#line 7287 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
															#line 724 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	CheckAuditProgressCompleteByServerActorState(Database const& cx,AuditType const& auditType,UID const& auditId,KeyRange const& auditRange,UID const& serverId,std::shared_ptr<AsyncVar<int>> const& checkProgressBudget) 
															#line 724 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
															#line 724 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		 : cx(cx),
															#line 724 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   auditType(auditType),
															#line 724 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   auditId(auditId),
															#line 724 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   auditRange(auditRange),
															#line 724 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   serverId(serverId),
															#line 724 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   checkProgressBudget(checkProgressBudget)
															#line 7304 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("checkAuditProgressCompleteByServer", reinterpret_cast<unsigned long>(this));

	}
	~CheckAuditProgressCompleteByServerActorState() 
	{
		fdb_probe_actor_destroy("checkAuditProgressCompleteByServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 730 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			ASSERT(auditType == AuditType::ValidateStorageServerShard);
															#line 731 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			rangeToRead = auditRange;
															#line 732 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			rangeToReadBegin = auditRange.begin;
															#line 733 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			retryCount = 0;
															#line 734 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			;
															#line 7327 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckAuditProgressCompleteByServerActorState();
		static_cast<CheckAuditProgressCompleteByServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 773 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		checkProgressBudget->set(checkProgressBudget->get() + 1);
															#line 774 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		TraceEvent(SevInfo, "AuditUtilCheckAuditProgressFinish") .detail("ServerID", serverId) .detail("AuditID", auditId) .detail("AuditRange", auditRange) .detail("AuditType", auditType);
															#line 779 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!static_cast<CheckAuditProgressCompleteByServerActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckAuditProgressCompleteByServerActorState(); static_cast<CheckAuditProgressCompleteByServerActor*>(this)->destroy(); return 0; }
															#line 7354 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		new (&static_cast<CheckAuditProgressCompleteByServerActor*>(this)->SAV< bool >::value()) bool(true);
		this->~CheckAuditProgressCompleteByServerActorState();
		static_cast<CheckAuditProgressCompleteByServerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 734 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!(rangeToReadBegin < auditRange.end))
															#line 7373 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 735 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		;
															#line 7379 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 737 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			rangeToRead = KeyRangeRef(rangeToReadBegin, auditRange.end);
															#line 738 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<std::vector<AuditStorageState>> __when_expr_0 = getAuditStateByServer(cx, auditType, auditId, serverId, rangeToRead);
															#line 738 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<CheckAuditProgressCompleteByServerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7419 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckAuditProgressCompleteByServerActor*>(this)->actor_wait_state = 1;
															#line 738 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckAuditProgressCompleteByServerActor, 0, std::vector<AuditStorageState> >*>(static_cast<CheckAuditProgressCompleteByServerActor*>(this)));
															#line 7424 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 756 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 7459 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
															#line 757 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 2));
															#line 7463 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			}
															#line 759 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (retryCount > 30)
															#line 7467 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
															#line 760 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				TraceEvent(SevWarn, "AuditUtilCheckAuditProgressFailed") .detail("ServerID", serverId) .detail("AuditID", auditId) .detail("AuditRange", auditRange) .detail("AuditType", auditType);
															#line 765 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				checkProgressBudget->set(checkProgressBudget->get() + 1);
															#line 766 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				return a_body1Catch1(audit_storage_failed(), std::max(0, loopDepth - 2));
															#line 7475 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			}
															#line 768 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(0.5);
															#line 768 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<CheckAuditProgressCompleteByServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 7481 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CheckAuditProgressCompleteByServerActor*>(this)->actor_wait_state = 2;
															#line 768 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckAuditProgressCompleteByServerActor, 1, Void >*>(static_cast<CheckAuditProgressCompleteByServerActor*>(this)));
															#line 7486 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(int loopDepth) 
	{
															#line 740 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		for(int i = 0;i < auditStates.size();i++) {
															#line 741 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			AuditPhase phase = auditStates[i].getPhase();
															#line 742 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (phase == AuditPhase::Invalid)
															#line 7505 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
															#line 743 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				TraceEvent(SevWarn, "AuditUtilCheckAuditProgressNotFinished") .detail("ServerID", serverId) .detail("AuditID", auditId) .detail("AuditRange", auditRange) .detail("AuditType", auditType) .detail("UnfinishedRange", auditStates[i].range);
															#line 749 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				checkProgressBudget->set(checkProgressBudget->get() + 1);
															#line 750 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				if (!static_cast<CheckAuditProgressCompleteByServerActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckAuditProgressCompleteByServerActorState(); static_cast<CheckAuditProgressCompleteByServerActor*>(this)->destroy(); return 0; }
															#line 7513 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				new (&static_cast<CheckAuditProgressCompleteByServerActor*>(this)->SAV< bool >::value()) bool(false);
				this->~CheckAuditProgressCompleteByServerActorState();
				static_cast<CheckAuditProgressCompleteByServerActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 753 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		rangeToReadBegin = auditStates.back().range.end;
															#line 7522 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(std::vector<AuditStorageState> const& __auditStates,int loopDepth) 
	{
															#line 738 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		auditStates = __auditStates;
															#line 7531 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(std::vector<AuditStorageState> && __auditStates,int loopDepth) 
	{
		auditStates = std::move(__auditStates);
		loopDepth = a_body1loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckAuditProgressCompleteByServerActor*>(this)->actor_wait_state > 0) static_cast<CheckAuditProgressCompleteByServerActor*>(this)->actor_wait_state = 0;
		static_cast<CheckAuditProgressCompleteByServerActor*>(this)->ActorCallback< CheckAuditProgressCompleteByServerActor, 0, std::vector<AuditStorageState> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckAuditProgressCompleteByServerActor, 0, std::vector<AuditStorageState> >*,std::vector<AuditStorageState> const& value) 
	{
		fdb_probe_actor_enter("checkAuditProgressCompleteByServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAuditProgressCompleteByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAuditProgressCompleteByServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckAuditProgressCompleteByServerActor, 0, std::vector<AuditStorageState> >*,std::vector<AuditStorageState> && value) 
	{
		fdb_probe_actor_enter("checkAuditProgressCompleteByServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAuditProgressCompleteByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAuditProgressCompleteByServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckAuditProgressCompleteByServerActor, 0, std::vector<AuditStorageState> >*,Error err) 
	{
		fdb_probe_actor_enter("checkAuditProgressCompleteByServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAuditProgressCompleteByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAuditProgressCompleteByServer", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 769 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		retryCount++;
															#line 7610 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 769 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		retryCount++;
															#line 7619 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckAuditProgressCompleteByServerActor*>(this)->actor_wait_state > 0) static_cast<CheckAuditProgressCompleteByServerActor*>(this)->actor_wait_state = 0;
		static_cast<CheckAuditProgressCompleteByServerActor*>(this)->ActorCallback< CheckAuditProgressCompleteByServerActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckAuditProgressCompleteByServerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkAuditProgressCompleteByServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAuditProgressCompleteByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAuditProgressCompleteByServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckAuditProgressCompleteByServerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkAuditProgressCompleteByServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAuditProgressCompleteByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAuditProgressCompleteByServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckAuditProgressCompleteByServerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkAuditProgressCompleteByServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAuditProgressCompleteByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAuditProgressCompleteByServer", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 724 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Database cx;
															#line 724 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	AuditType auditType;
															#line 724 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	UID auditId;
															#line 724 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	KeyRange auditRange;
															#line 724 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	UID serverId;
															#line 724 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	std::shared_ptr<AsyncVar<int>> checkProgressBudget;
															#line 731 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	KeyRange rangeToRead;
															#line 732 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Key rangeToReadBegin;
															#line 733 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	int retryCount;
															#line 738 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	std::vector<AuditStorageState> auditStates;
															#line 7719 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
};
// This generated class is to be used only via checkAuditProgressCompleteByServer()
															#line 724 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class CheckAuditProgressCompleteByServerActor final : public Actor<bool>, public ActorCallback< CheckAuditProgressCompleteByServerActor, 0, std::vector<AuditStorageState> >, public ActorCallback< CheckAuditProgressCompleteByServerActor, 1, Void >, public FastAllocated<CheckAuditProgressCompleteByServerActor>, public CheckAuditProgressCompleteByServerActorState<CheckAuditProgressCompleteByServerActor> {
															#line 7724 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
	using FastAllocated<CheckAuditProgressCompleteByServerActor>::operator new;
	using FastAllocated<CheckAuditProgressCompleteByServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4364875714346746368UL, 12394724140292109056UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckAuditProgressCompleteByServerActor, 0, std::vector<AuditStorageState> >;
friend struct ActorCallback< CheckAuditProgressCompleteByServerActor, 1, Void >;
															#line 724 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	CheckAuditProgressCompleteByServerActor(Database const& cx,AuditType const& auditType,UID const& auditId,KeyRange const& auditRange,UID const& serverId,std::shared_ptr<AsyncVar<int>> const& checkProgressBudget) 
															#line 7742 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   CheckAuditProgressCompleteByServerActorState<CheckAuditProgressCompleteByServerActor>(cx, auditType, auditId, auditRange, serverId, checkProgressBudget),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkAuditProgressCompleteByServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14129580192873401344UL, 6628265393131345664UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAuditProgressCompleteByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkAuditProgressCompleteByServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkAuditProgressCompleteByServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckAuditProgressCompleteByServerActor, 0, std::vector<AuditStorageState> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckAuditProgressCompleteByServerActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 724 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
[[nodiscard]] Future<bool> checkAuditProgressCompleteByServer( Database const& cx, AuditType const& auditType, UID const& auditId, KeyRange const& auditRange, UID const& serverId, std::shared_ptr<AsyncVar<int>> const& checkProgressBudget ) {
															#line 724 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	return Future<bool>(new CheckAuditProgressCompleteByServerActor(cx, auditType, auditId, auditRange, serverId, checkProgressBudget));
															#line 7776 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
}

#line 781 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"

// Load RUNNING audit states to resume, clean up COMPLETE and FAILED audit states
// Update ddId for RUNNING audit states
															#line 7783 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via initAuditMetadata()
															#line 784 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
template <class InitAuditMetadataActor>
															#line 784 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class InitAuditMetadataActorState {
															#line 7790 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
															#line 784 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	InitAuditMetadataActorState(Database const& cx,MoveKeyLockInfo const& lock,bool const& ddEnabled,UID const& dataDistributorId,int const& persistFinishAuditCount) 
															#line 784 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
															#line 784 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		 : cx(cx),
															#line 784 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   lock(lock),
															#line 784 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   ddEnabled(ddEnabled),
															#line 784 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   dataDistributorId(dataDistributorId),
															#line 784 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   persistFinishAuditCount(persistFinishAuditCount),
															#line 789 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   existingAuditStates(),
															#line 790 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   auditStatesToResume(),
															#line 791 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   tr(cx),
															#line 792 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   retryCount(0)
															#line 7813 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("initAuditMetadata", reinterpret_cast<unsigned long>(this));

	}
	~InitAuditMetadataActorState() 
	{
		fdb_probe_actor_destroy("initAuditMetadata", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 793 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			;
															#line 7828 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~InitAuditMetadataActorState();
		static_cast<InitAuditMetadataActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 892 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!static_cast<InitAuditMetadataActor*>(this)->SAV<std::vector<AuditStorageState>>::futures) { (void)(auditStatesToResume); this->~InitAuditMetadataActorState(); static_cast<InitAuditMetadataActor*>(this)->destroy(); return 0; }
															#line 7851 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		new (&static_cast<InitAuditMetadataActor*>(this)->SAV< std::vector<AuditStorageState> >::value()) std::vector<AuditStorageState>(std::move(auditStatesToResume)); // state_var_RVO
		this->~InitAuditMetadataActorState();
		static_cast<InitAuditMetadataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 796 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			existingAuditStates.clear();
															#line 797 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			auditStatesToResume.clear();
															#line 798 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 799 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 800 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 801 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<Void> __when_expr_0 = checkMoveKeysLockForAudit(&tr, lock, ddEnabled, true);
															#line 801 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<InitAuditMetadataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7883 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<InitAuditMetadataActor*>(this)->actor_wait_state = 1;
															#line 801 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< InitAuditMetadataActor, 0, Void >*>(static_cast<InitAuditMetadataActor*>(this)));
															#line 7888 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 876 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (e.code() == error_code_actor_cancelled || e.code() == error_code_movekeys_conflict)
															#line 7923 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
															#line 877 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 7927 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			}
															#line 879 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (retryCount > 50)
															#line 7931 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
															#line 880 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				TraceEvent(SevWarnAlways, "AuditUtilInitAuditMetadataExceedRetryMax", dataDistributorId) .errorUnsuppressed(e);
															#line 7935 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				return a_body1break1(loopDepth==0?0:loopDepth-1); // break
			}
			try {
															#line 885 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 885 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				if (static_cast<InitAuditMetadataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1Catch1(actor_cancelled(), loopDepth);
															#line 7943 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
				static_cast<InitAuditMetadataActor*>(this)->actor_wait_state = 4;
															#line 885 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< InitAuditMetadataActor, 3, Void >*>(static_cast<InitAuditMetadataActor*>(this)));
															#line 7948 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1loopBody1Catch1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1loopBody1Catch1Catch1(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 802 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = tr.getRange(auditKeys, CLIENT_KNOBS->TOO_MANY);
															#line 802 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (static_cast<InitAuditMetadataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7971 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<InitAuditMetadataActor*>(this)->actor_wait_state = 2;
															#line 802 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< InitAuditMetadataActor, 1, RangeResult >*>(static_cast<InitAuditMetadataActor*>(this)));
															#line 7976 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 802 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = tr.getRange(auditKeys, CLIENT_KNOBS->TOO_MANY);
															#line 802 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (static_cast<InitAuditMetadataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7987 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<InitAuditMetadataActor*>(this)->actor_wait_state = 2;
															#line 802 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< InitAuditMetadataActor, 1, RangeResult >*>(static_cast<InitAuditMetadataActor*>(this)));
															#line 7992 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<InitAuditMetadataActor*>(this)->actor_wait_state > 0) static_cast<InitAuditMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<InitAuditMetadataActor*>(this)->ActorCallback< InitAuditMetadataActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< InitAuditMetadataActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("initAuditMetadata", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitAuditMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initAuditMetadata", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< InitAuditMetadataActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("initAuditMetadata", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitAuditMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initAuditMetadata", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< InitAuditMetadataActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("initAuditMetadata", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InitAuditMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initAuditMetadata", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(RangeResult const& result,int loopDepth) 
	{
															#line 803 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (result.more || result.size() >= CLIENT_KNOBS->TOO_MANY)
															#line 8076 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 804 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(g_network->isSimulated() ? SevError : SevWarnAlways, "AuditUtilLoadMetadataIncomplete", dataDistributorId) .detail("ResMore", result.more) .detail("ResSize", result.size());
															#line 8080 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 810 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		for(int i = 0;i < result.size();++i) {
															#line 811 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			auto auditState = decodeAuditStorageState(result[i].value);
															#line 812 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(SevVerbose, "AuditUtilLoadMetadataEach", dataDistributorId) .detail("CurrentDDID", dataDistributorId) .detail("AuditDDID", auditState.ddId) .detail("AuditType", auditState.getType()) .detail("AuditID", auditState.id) .detail("AuditPhase", auditState.getPhase());
															#line 818 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (auditState.getPhase() == AuditPhase::Running)
															#line 8090 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
															#line 819 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				AuditStorageState toUpdate = auditState;
															#line 820 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				toUpdate.ddId = dataDistributorId;
															#line 821 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				tr.set(auditKey(toUpdate.getType(), toUpdate.id), auditStorageStateValue(toUpdate));
															#line 8098 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			}
															#line 823 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			existingAuditStates[auditState.getType()].push_back(auditState);
															#line 8102 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 826 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		for( const auto& [auditType, _] : existingAuditStates ) {
															#line 827 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			int numFinishAudit = 0;
															#line 828 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			for( const auto& auditState : existingAuditStates[auditType] ) {
															#line 829 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				if (auditState.getPhase() == AuditPhase::Complete || auditState.getPhase() == AuditPhase::Failed)
															#line 8112 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				{
															#line 830 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
					numFinishAudit++;
															#line 8116 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				}
			}
															#line 833 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			const int numFinishAuditsToClear = numFinishAudit - persistFinishAuditCount;
															#line 834 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			int numFinishAuditsCleared = 0;
															#line 835 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			std::sort(existingAuditStates[auditType].begin(), existingAuditStates[auditType].end(), [](AuditStorageState a, AuditStorageState b) { return a.id < b.id; });
															#line 840 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			for( const auto& auditState : existingAuditStates[auditType] ) {
															#line 841 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				if (auditState.getPhase() == AuditPhase::Failed)
															#line 8129 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				{
															#line 842 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
					if (numFinishAuditsCleared < numFinishAuditsToClear)
															#line 8133 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
					{
															#line 844 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
						tr.clear(auditKey(auditState.getType(), auditState.id));
															#line 845 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
						clearAuditProgressMetadata(&tr, auditState.getType(), auditState.id);
															#line 846 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
						numFinishAuditsCleared++;
															#line 847 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
						TraceEvent(SevInfo, "AuditUtilMetadataCleared", dataDistributorId) .detail("AuditID", auditState.id) .detail("AuditType", auditState.getType()) .detail("AuditRange", auditState.range);
															#line 8143 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
					}
				}
				else
				{
															#line 852 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
					if (auditState.getPhase() == AuditPhase::Complete)
															#line 8150 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
					{
															#line 853 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
						if (numFinishAuditsCleared < numFinishAuditsToClear)
															#line 8154 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
						{
															#line 857 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
							tr.clear(auditKey(auditState.getType(), auditState.id));
															#line 858 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
							numFinishAuditsCleared++;
															#line 859 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
							TraceEvent(SevInfo, "AuditUtilMetadataCleared", dataDistributorId) .detail("AuditID", auditState.id) .detail("AuditType", auditState.getType()) .detail("AuditRange", auditState.range);
															#line 8162 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
						}
					}
					else
					{
															#line 864 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
						if (auditState.getPhase() == AuditPhase::Running)
															#line 8169 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
						{
															#line 865 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
							auditStatesToResume.push_back(auditState);
															#line 866 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
							TraceEvent(SevInfo, "AuditUtilMetadataAddedToResume", dataDistributorId) .detail("AuditID", auditState.id) .detail("AuditType", auditState.getType()) .detail("AuditRange", auditState.range);
															#line 8175 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
						}
					}
				}
			}
		}
															#line 873 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 873 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (static_cast<InitAuditMetadataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8185 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<InitAuditMetadataActor*>(this)->actor_wait_state = 3;
															#line 873 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< InitAuditMetadataActor, 2, Void >*>(static_cast<InitAuditMetadataActor*>(this)));
															#line 8190 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(RangeResult && result,int loopDepth) 
	{
															#line 803 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (result.more || result.size() >= CLIENT_KNOBS->TOO_MANY)
															#line 8199 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 804 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(g_network->isSimulated() ? SevError : SevWarnAlways, "AuditUtilLoadMetadataIncomplete", dataDistributorId) .detail("ResMore", result.more) .detail("ResSize", result.size());
															#line 8203 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 810 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		for(int i = 0;i < result.size();++i) {
															#line 811 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			auto auditState = decodeAuditStorageState(result[i].value);
															#line 812 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(SevVerbose, "AuditUtilLoadMetadataEach", dataDistributorId) .detail("CurrentDDID", dataDistributorId) .detail("AuditDDID", auditState.ddId) .detail("AuditType", auditState.getType()) .detail("AuditID", auditState.id) .detail("AuditPhase", auditState.getPhase());
															#line 818 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (auditState.getPhase() == AuditPhase::Running)
															#line 8213 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
															#line 819 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				AuditStorageState toUpdate = auditState;
															#line 820 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				toUpdate.ddId = dataDistributorId;
															#line 821 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				tr.set(auditKey(toUpdate.getType(), toUpdate.id), auditStorageStateValue(toUpdate));
															#line 8221 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			}
															#line 823 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			existingAuditStates[auditState.getType()].push_back(auditState);
															#line 8225 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 826 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		for( const auto& [auditType, _] : existingAuditStates ) {
															#line 827 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			int numFinishAudit = 0;
															#line 828 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			for( const auto& auditState : existingAuditStates[auditType] ) {
															#line 829 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				if (auditState.getPhase() == AuditPhase::Complete || auditState.getPhase() == AuditPhase::Failed)
															#line 8235 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				{
															#line 830 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
					numFinishAudit++;
															#line 8239 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				}
			}
															#line 833 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			const int numFinishAuditsToClear = numFinishAudit - persistFinishAuditCount;
															#line 834 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			int numFinishAuditsCleared = 0;
															#line 835 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			std::sort(existingAuditStates[auditType].begin(), existingAuditStates[auditType].end(), [](AuditStorageState a, AuditStorageState b) { return a.id < b.id; });
															#line 840 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			for( const auto& auditState : existingAuditStates[auditType] ) {
															#line 841 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				if (auditState.getPhase() == AuditPhase::Failed)
															#line 8252 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				{
															#line 842 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
					if (numFinishAuditsCleared < numFinishAuditsToClear)
															#line 8256 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
					{
															#line 844 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
						tr.clear(auditKey(auditState.getType(), auditState.id));
															#line 845 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
						clearAuditProgressMetadata(&tr, auditState.getType(), auditState.id);
															#line 846 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
						numFinishAuditsCleared++;
															#line 847 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
						TraceEvent(SevInfo, "AuditUtilMetadataCleared", dataDistributorId) .detail("AuditID", auditState.id) .detail("AuditType", auditState.getType()) .detail("AuditRange", auditState.range);
															#line 8266 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
					}
				}
				else
				{
															#line 852 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
					if (auditState.getPhase() == AuditPhase::Complete)
															#line 8273 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
					{
															#line 853 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
						if (numFinishAuditsCleared < numFinishAuditsToClear)
															#line 8277 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
						{
															#line 857 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
							tr.clear(auditKey(auditState.getType(), auditState.id));
															#line 858 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
							numFinishAuditsCleared++;
															#line 859 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
							TraceEvent(SevInfo, "AuditUtilMetadataCleared", dataDistributorId) .detail("AuditID", auditState.id) .detail("AuditType", auditState.getType()) .detail("AuditRange", auditState.range);
															#line 8285 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
						}
					}
					else
					{
															#line 864 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
						if (auditState.getPhase() == AuditPhase::Running)
															#line 8292 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
						{
															#line 865 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
							auditStatesToResume.push_back(auditState);
															#line 866 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
							TraceEvent(SevInfo, "AuditUtilMetadataAddedToResume", dataDistributorId) .detail("AuditID", auditState.id) .detail("AuditType", auditState.getType()) .detail("AuditRange", auditState.range);
															#line 8298 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
						}
					}
				}
			}
		}
															#line 873 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 873 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (static_cast<InitAuditMetadataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8308 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<InitAuditMetadataActor*>(this)->actor_wait_state = 3;
															#line 873 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< InitAuditMetadataActor, 2, Void >*>(static_cast<InitAuditMetadataActor*>(this)));
															#line 8313 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<InitAuditMetadataActor*>(this)->actor_wait_state > 0) static_cast<InitAuditMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<InitAuditMetadataActor*>(this)->ActorCallback< InitAuditMetadataActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< InitAuditMetadataActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("initAuditMetadata", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitAuditMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initAuditMetadata", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< InitAuditMetadataActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("initAuditMetadata", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitAuditMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initAuditMetadata", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< InitAuditMetadataActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("initAuditMetadata", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InitAuditMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initAuditMetadata", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<InitAuditMetadataActor*>(this)->actor_wait_state > 0) static_cast<InitAuditMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<InitAuditMetadataActor*>(this)->ActorCallback< InitAuditMetadataActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< InitAuditMetadataActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("initAuditMetadata", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitAuditMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initAuditMetadata", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< InitAuditMetadataActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("initAuditMetadata", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitAuditMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initAuditMetadata", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< InitAuditMetadataActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("initAuditMetadata", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InitAuditMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initAuditMetadata", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 887 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			retryCount++;
															#line 888 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.reset();
															#line 8493 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = a_body1loopBody1Catch1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<InitAuditMetadataActor*>(this)->actor_wait_state > 0) static_cast<InitAuditMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<InitAuditMetadataActor*>(this)->ActorCallback< InitAuditMetadataActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< InitAuditMetadataActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("initAuditMetadata", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitAuditMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initAuditMetadata", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< InitAuditMetadataActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("initAuditMetadata", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitAuditMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initAuditMetadata", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< InitAuditMetadataActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("initAuditMetadata", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InitAuditMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initAuditMetadata", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1Catch1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1Catch1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 784 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Database cx;
															#line 784 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	MoveKeyLockInfo lock;
															#line 784 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	bool ddEnabled;
															#line 784 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	UID dataDistributorId;
															#line 784 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	int persistFinishAuditCount;
															#line 789 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	std::unordered_map<AuditType, std::vector<AuditStorageState>> existingAuditStates;
															#line 790 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	std::vector<AuditStorageState> auditStatesToResume;
															#line 791 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Transaction tr;
															#line 792 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	int retryCount;
															#line 8622 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
};
// This generated class is to be used only via initAuditMetadata()
															#line 784 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class InitAuditMetadataActor final : public Actor<std::vector<AuditStorageState>>, public ActorCallback< InitAuditMetadataActor, 0, Void >, public ActorCallback< InitAuditMetadataActor, 1, RangeResult >, public ActorCallback< InitAuditMetadataActor, 2, Void >, public ActorCallback< InitAuditMetadataActor, 3, Void >, public FastAllocated<InitAuditMetadataActor>, public InitAuditMetadataActorState<InitAuditMetadataActor> {
															#line 8627 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
	using FastAllocated<InitAuditMetadataActor>::operator new;
	using FastAllocated<InitAuditMetadataActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11266158090750718976UL, 9833200227014941440UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<AuditStorageState>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< InitAuditMetadataActor, 0, Void >;
friend struct ActorCallback< InitAuditMetadataActor, 1, RangeResult >;
friend struct ActorCallback< InitAuditMetadataActor, 2, Void >;
friend struct ActorCallback< InitAuditMetadataActor, 3, Void >;
															#line 784 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	InitAuditMetadataActor(Database const& cx,MoveKeyLockInfo const& lock,bool const& ddEnabled,UID const& dataDistributorId,int const& persistFinishAuditCount) 
															#line 8647 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		 : Actor<std::vector<AuditStorageState>>(),
		   InitAuditMetadataActorState<InitAuditMetadataActor>(cx, lock, ddEnabled, dataDistributorId, persistFinishAuditCount),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("initAuditMetadata", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5137575058642904320UL, 475804656007697920UL);
		ActorExecutionContextHelper __helper(static_cast<InitAuditMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("initAuditMetadata");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("initAuditMetadata", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< InitAuditMetadataActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< InitAuditMetadataActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< InitAuditMetadataActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< InitAuditMetadataActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 784 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
[[nodiscard]] Future<std::vector<AuditStorageState>> initAuditMetadata( Database const& cx, MoveKeyLockInfo const& lock, bool const& ddEnabled, UID const& dataDistributorId, int const& persistFinishAuditCount ) {
															#line 784 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	return Future<std::vector<AuditStorageState>>(new InitAuditMetadataActor(cx, lock, ddEnabled, dataDistributorId, persistFinishAuditCount));
															#line 8683 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
}

#line 894 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"

// Check if any pair of ranges are exclusive with each other
// This is not a part in consistency check of audit metadata
// This is used for checking the validity of inputs to rangesSame()
bool elementsAreExclusiveWithEachOther(std::vector<KeyRange> ranges) {
	ASSERT(std::is_sorted(ranges.begin(), ranges.end(), KeyRangeRef::ArbitraryOrder()));
	for (int i = 0; i < ranges.size() - 1; ++i) {
		if (ranges[i].end > ranges[i + 1].begin) {
			TraceEvent(SevError, "AuditUtilElementsAreNotExclusiveWithEachOther").detail("Ranges", describe(ranges));
			return false;
		}
	}
	return true;
}

// Check if any range is empty in the given list of ranges
// This is not a part in consistency check of audit metadata
// This is used for checking the validity of inputs to rangesSame()
bool noEmptyRangeInRanges(std::vector<KeyRange> ranges) {
	for (const auto& range : ranges) {
		if (range.empty()) {
			return false;
		}
	}
	return true;
}

// Given a list of ranges, where ranges can overlap with each other
// Return a list of exclusive ranges which covers the ranges exactly
// the same as the input list of ranges
std::vector<KeyRange> coalesceRangeList(std::vector<KeyRange> ranges) {
	std::sort(ranges.begin(), ranges.end(), [](KeyRange a, KeyRange b) { return a.begin < b.begin; });
	std::vector<KeyRange> res;
	for (const auto& range : ranges) {
		if (res.empty()) {
			res.push_back(range);
			continue;
		}
		if (range.begin <= res.back().end) {
			if (range.end > res.back().end) { // update res.back if current range extends the back range
				KeyRange newBack = Standalone(KeyRangeRef(res.back().begin, range.end));
				res.pop_back();
				res.push_back(newBack);
			}
		} else {
			res.push_back(range);
		}
	}
	return res;
}

// Given two lists of ranges --- rangesA and rangesB, check if two lists are identical
// If not, return the mismatched two ranges of rangeA and rangeB respectively
Optional<std::pair<KeyRange, KeyRange>> rangesSame(std::vector<KeyRange> rangesA, std::vector<KeyRange> rangesB) {
	if (g_network->isSimulated()) {
		ASSERT(noEmptyRangeInRanges(rangesA));
		ASSERT(noEmptyRangeInRanges(rangesB));
	}
	KeyRange emptyRange;
	if (rangesA.empty() && rangesB.empty()) { // no mismatch
		return Optional<std::pair<KeyRange, KeyRange>>();
	} else if (rangesA.empty() && !rangesB.empty()) { // rangesA is empty while rangesB has a range
		return std::make_pair(emptyRange, rangesB.front());
	} else if (!rangesA.empty() && rangesB.empty()) { // rangesB is empty while rangesA has a range
		return std::make_pair(rangesA.front(), emptyRange);
	}
	TraceEvent(SevVerbose, "AuditUtilRangesSameBeforeSort").detail("RangesA", rangesA).detail("Rangesb", rangesB);
	// sort in ascending order
	std::sort(rangesA.begin(), rangesA.end(), [](KeyRange a, KeyRange b) { return a.begin < b.begin; });
	std::sort(rangesB.begin(), rangesB.end(), [](KeyRange a, KeyRange b) { return a.begin < b.begin; });
	TraceEvent(SevVerbose, "AuditUtilRangesSameAfterSort").detail("RangesA", rangesA).detail("Rangesb", rangesB);
	if (g_network->isSimulated()) {
		ASSERT(elementsAreExclusiveWithEachOther(rangesA));
		ASSERT(elementsAreExclusiveWithEachOther(rangesB));
	}
	if (rangesA.front().begin != rangesB.front().begin) { // rangeList heads mismatch
		return std::make_pair(rangesA.front(), rangesB.front());
	} else if (rangesA.back().end != rangesB.back().end) { // rangeList backs mismatch
		return std::make_pair(rangesA.back(), rangesB.back());
	}
	int ia = 0;
	int ib = 0;
	KeyRangeRef rangeA = rangesA[0];
	KeyRangeRef rangeB = rangesB[0];
	KeyRange lastRangeA = Standalone(rangeA);
	KeyRange lastRangeB = Standalone(rangeB);
	while (true) {
		if (rangeA.begin == rangeB.begin) {
			if (rangeA.end == rangeB.end) {
				if (rangeA.end == rangesA.back().end) {
					break;
				}
				++ia;
				++ib;
				rangeA = rangesA[ia];
				rangeB = rangesB[ib];
				lastRangeA = Standalone(rangeA);
				lastRangeB = Standalone(rangeB);
			} else if (rangeA.end > rangeB.end) {
				rangeA = KeyRangeRef(rangeB.end, rangeA.end);
				++ib;
				rangeB = rangesB[ib];
				lastRangeB = Standalone(rangeB);
			} else {
				rangeB = KeyRangeRef(rangeA.end, rangeB.end);
				++ia;
				rangeA = rangesA[ia];
				lastRangeA = Standalone(rangeA);
			}
		} else {
			return std::make_pair(lastRangeA, lastRangeB);
		}
	}
	return Optional<std::pair<KeyRange, KeyRange>>();
}

// Given an input server, get ranges within the input range via the input transaction
// from the perspective of ServerKeys system key space
// Input: (1) SS id; (2) transaction tr; (3) within range
// Return AuditGetServerKeysRes, including: (1) complete range by a single read range;
// (2) version of the read; (3) ranges of the input SS
															#line 8808 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getThisServerKeysFromServerKeys()
															#line 1015 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
template <class GetThisServerKeysFromServerKeysActor>
															#line 1015 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class GetThisServerKeysFromServerKeysActorState {
															#line 8815 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
															#line 1015 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	GetThisServerKeysFromServerKeysActorState(UID const& serverID,Transaction* const& tr,KeyRange const& range) 
															#line 1015 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
															#line 1015 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		 : serverID(serverID),
															#line 1015 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   tr(tr),
															#line 1015 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   range(range),
															#line 1016 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   readResult(),
															#line 1017 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   res()
															#line 8830 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getThisServerKeysFromServerKeys", reinterpret_cast<unsigned long>(this));

	}
	~GetThisServerKeysFromServerKeysActorState() 
	{
		fdb_probe_actor_destroy("getThisServerKeysFromServerKeys", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1020 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				StrictFuture<Void> __when_expr_0 = store(readResult, krmGetRanges(tr, serverKeysPrefixFor(serverID), range, CLIENT_KNOBS->KRM_GET_RANGE_LIMIT, CLIENT_KNOBS->KRM_GET_RANGE_LIMIT_BYTES));
															#line 1020 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				if (static_cast<GetThisServerKeysFromServerKeysActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 8848 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetThisServerKeysFromServerKeysActor*>(this)->actor_wait_state = 1;
															#line 1020 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetThisServerKeysFromServerKeysActor, 0, Void >*>(static_cast<GetThisServerKeysFromServerKeysActor*>(this)));
															#line 8853 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetThisServerKeysFromServerKeysActorState();
		static_cast<GetThisServerKeysFromServerKeysActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1068 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!static_cast<GetThisServerKeysFromServerKeysActor*>(this)->SAV<AuditGetServerKeysRes>::futures) { (void)(res); this->~GetThisServerKeysFromServerKeysActorState(); static_cast<GetThisServerKeysFromServerKeysActor*>(this)->destroy(); return 0; }
															#line 8882 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		new (&static_cast<GetThisServerKeysFromServerKeysActor*>(this)->SAV< AuditGetServerKeysRes >::value()) AuditGetServerKeysRes(std::move(res)); // state_var_RVO
		this->~GetThisServerKeysFromServerKeysActorState();
		static_cast<GetThisServerKeysFromServerKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1062 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(SevDebug, "AuditUtilGetThisServerKeysError", serverID) .errorUnsuppressed(e) .detail("AuditServerID", serverID);
															#line 1065 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 8897 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1026 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		Future<Version> grvF = tr->getReadVersion();
															#line 1027 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!grvF.isReady())
															#line 8913 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 1028 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(SevWarnAlways, "AuditUtilReadServerKeysGRVError", serverID);
															#line 1029 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			return a_body1Catch2(audit_storage_cancelled(), loopDepth);
															#line 8919 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 1031 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		Version readAtVersion = grvF.get();
															#line 1033 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		TraceEvent(SevVerbose, "AuditUtilGetThisServerKeysFromServerKeysReadDone", serverID) .detail("Range", range) .detail("Prefix", serverKeysPrefixFor(serverID)) .detail("ResultSize", readResult.size()) .detail("AuditServerID", serverID);
															#line 1039 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		std::vector<KeyRange> ownRanges;
															#line 1040 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		for(int i = 0;i < readResult.size() - 1;++i) {
															#line 1041 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(SevVerbose, "AuditUtilGetThisServerKeysFromServerKeysAddToResult", serverID) .detail("ValueIsServerKeysFalse", readResult[i].value == serverKeysFalse) .detail("ServerHasKey", serverHasKey(readResult[i].value)) .detail("Range", KeyRangeRef(readResult[i].key, readResult[i + 1].key)) .detail("AuditServerID", serverID);
															#line 1046 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (serverHasKey(readResult[i].value))
															#line 8933 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
															#line 1047 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				KeyRange shardRange;
															#line 1048 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				ownRanges.push_back(Standalone(KeyRangeRef(readResult[i].key, readResult[i + 1].key)));
															#line 8939 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			}
		}
															#line 1051 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		const KeyRange completeRange = Standalone(KeyRangeRef(range.begin, readResult.back().key));
															#line 1052 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		TraceEvent(SevVerbose, "AuditUtilGetThisServerKeysFromServerKeysEnd", serverID) .detail("AuditServerID", serverID) .detail("Range", range) .detail("Prefix", serverKeysPrefixFor(serverID)) .detail("ReadAtVersion", readAtVersion) .detail("CompleteRange", completeRange) .detail("ResultSize", ownRanges.size());
															#line 1059 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		res = AuditGetServerKeysRes(completeRange, readAtVersion, serverID, ownRanges, readResult.logicalSize());
															#line 8948 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1026 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		Future<Version> grvF = tr->getReadVersion();
															#line 1027 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!grvF.isReady())
															#line 8959 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 1028 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(SevWarnAlways, "AuditUtilReadServerKeysGRVError", serverID);
															#line 1029 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			return a_body1Catch2(audit_storage_cancelled(), loopDepth);
															#line 8965 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 1031 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		Version readAtVersion = grvF.get();
															#line 1033 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		TraceEvent(SevVerbose, "AuditUtilGetThisServerKeysFromServerKeysReadDone", serverID) .detail("Range", range) .detail("Prefix", serverKeysPrefixFor(serverID)) .detail("ResultSize", readResult.size()) .detail("AuditServerID", serverID);
															#line 1039 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		std::vector<KeyRange> ownRanges;
															#line 1040 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		for(int i = 0;i < readResult.size() - 1;++i) {
															#line 1041 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(SevVerbose, "AuditUtilGetThisServerKeysFromServerKeysAddToResult", serverID) .detail("ValueIsServerKeysFalse", readResult[i].value == serverKeysFalse) .detail("ServerHasKey", serverHasKey(readResult[i].value)) .detail("Range", KeyRangeRef(readResult[i].key, readResult[i + 1].key)) .detail("AuditServerID", serverID);
															#line 1046 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (serverHasKey(readResult[i].value))
															#line 8979 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
															#line 1047 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				KeyRange shardRange;
															#line 1048 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				ownRanges.push_back(Standalone(KeyRangeRef(readResult[i].key, readResult[i + 1].key)));
															#line 8985 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			}
		}
															#line 1051 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		const KeyRange completeRange = Standalone(KeyRangeRef(range.begin, readResult.back().key));
															#line 1052 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		TraceEvent(SevVerbose, "AuditUtilGetThisServerKeysFromServerKeysEnd", serverID) .detail("AuditServerID", serverID) .detail("Range", range) .detail("Prefix", serverKeysPrefixFor(serverID)) .detail("ReadAtVersion", readAtVersion) .detail("CompleteRange", completeRange) .detail("ResultSize", ownRanges.size());
															#line 1059 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		res = AuditGetServerKeysRes(completeRange, readAtVersion, serverID, ownRanges, readResult.logicalSize());
															#line 8994 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetThisServerKeysFromServerKeysActor*>(this)->actor_wait_state > 0) static_cast<GetThisServerKeysFromServerKeysActor*>(this)->actor_wait_state = 0;
		static_cast<GetThisServerKeysFromServerKeysActor*>(this)->ActorCallback< GetThisServerKeysFromServerKeysActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetThisServerKeysFromServerKeysActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getThisServerKeysFromServerKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetThisServerKeysFromServerKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getThisServerKeysFromServerKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetThisServerKeysFromServerKeysActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getThisServerKeysFromServerKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetThisServerKeysFromServerKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getThisServerKeysFromServerKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetThisServerKeysFromServerKeysActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getThisServerKeysFromServerKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetThisServerKeysFromServerKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getThisServerKeysFromServerKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont7(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1015 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	UID serverID;
															#line 1015 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Transaction* tr;
															#line 1015 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	KeyRange range;
															#line 1016 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	RangeResult readResult;
															#line 1017 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	AuditGetServerKeysRes res;
															#line 9097 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getThisServerKeysFromServerKeys()
															#line 1015 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class GetThisServerKeysFromServerKeysActor final : public Actor<AuditGetServerKeysRes>, public ActorCallback< GetThisServerKeysFromServerKeysActor, 0, Void >, public FastAllocated<GetThisServerKeysFromServerKeysActor>, public GetThisServerKeysFromServerKeysActorState<GetThisServerKeysFromServerKeysActor> {
															#line 9102 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetThisServerKeysFromServerKeysActor>::operator new;
	using FastAllocated<GetThisServerKeysFromServerKeysActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15901262480900611328UL, 14709488398474610944UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<AuditGetServerKeysRes>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetThisServerKeysFromServerKeysActor, 0, Void >;
															#line 1015 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	GetThisServerKeysFromServerKeysActor(UID const& serverID,Transaction* const& tr,KeyRange const& range) 
															#line 9119 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		 : Actor<AuditGetServerKeysRes>(),
		   GetThisServerKeysFromServerKeysActorState<GetThisServerKeysFromServerKeysActor>(serverID, tr, range),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getThisServerKeysFromServerKeys", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8956952993459453952UL, 3712613669581083392UL);
		ActorExecutionContextHelper __helper(static_cast<GetThisServerKeysFromServerKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getThisServerKeysFromServerKeys");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getThisServerKeysFromServerKeys", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetThisServerKeysFromServerKeysActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1015 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
[[nodiscard]] Future<AuditGetServerKeysRes> getThisServerKeysFromServerKeys( UID const& serverID, Transaction* const& tr, KeyRange const& range ) {
															#line 1015 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	return Future<AuditGetServerKeysRes>(new GetThisServerKeysFromServerKeysActor(serverID, tr, range));
															#line 9152 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
}

#line 1070 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"

// Given an input server, get ranges within the input range via the input transaction
// from the perspective of KeyServers system key space
// Input: (1) Audit Server ID (for logging); (2) transaction tr; (3) within range
// Return AuditGetKeyServersRes, including : (1) complete range by a single read range; (2) version of the read;
// (3) map between SSes and their ranges --- in KeyServers space, a range corresponds to multiple SSes
															#line 9162 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getShardMapFromKeyServers()
															#line 1076 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
template <class GetShardMapFromKeyServersActor>
															#line 1076 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class GetShardMapFromKeyServersActorState {
															#line 9169 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
															#line 1076 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	GetShardMapFromKeyServersActorState(UID const& auditServerId,Transaction* const& tr,KeyRange const& range) 
															#line 1076 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
															#line 1076 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		 : auditServerId(auditServerId),
															#line 1076 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   tr(tr),
															#line 1076 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   range(range),
															#line 1077 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   res(),
															#line 1078 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   actors(),
															#line 1079 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   readResult(),
															#line 1080 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   UIDtoTagMap(),
															#line 1081 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   totalShardsCount(0),
															#line 1082 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   shardsInAnonymousPhysicalShardCount(0)
															#line 9192 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getShardMapFromKeyServers", reinterpret_cast<unsigned long>(this));

	}
	~GetShardMapFromKeyServersActorState() 
	{
		fdb_probe_actor_destroy("getShardMapFromKeyServers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1086 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				actors.push_back(store(readResult, krmGetRanges(tr, keyServersPrefix, range, CLIENT_KNOBS->KRM_GET_RANGE_LIMIT, CLIENT_KNOBS->KRM_GET_RANGE_LIMIT_BYTES)));
															#line 1092 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				actors.push_back(store(UIDtoTagMap, tr->getRange(serverTagKeys, CLIENT_KNOBS->TOO_MANY)));
															#line 1093 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				StrictFuture<Void> __when_expr_0 = waitForAll(actors);
															#line 1093 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				if (static_cast<GetShardMapFromKeyServersActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 9214 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetShardMapFromKeyServersActor*>(this)->actor_wait_state = 1;
															#line 1093 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetShardMapFromKeyServersActor, 0, Void >*>(static_cast<GetShardMapFromKeyServersActor*>(this)));
															#line 9219 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetShardMapFromKeyServersActorState();
		static_cast<GetShardMapFromKeyServersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1146 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!static_cast<GetShardMapFromKeyServersActor*>(this)->SAV<AuditGetKeyServersRes>::futures) { (void)(res); this->~GetShardMapFromKeyServersActorState(); static_cast<GetShardMapFromKeyServersActor*>(this)->destroy(); return 0; }
															#line 9248 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		new (&static_cast<GetShardMapFromKeyServersActor*>(this)->SAV< AuditGetKeyServersRes >::value()) AuditGetKeyServersRes(std::move(res)); // state_var_RVO
		this->~GetShardMapFromKeyServersActorState();
		static_cast<GetShardMapFromKeyServersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1140 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(SevDebug, "AuditUtilGetThisServerKeysFromKeyServersError", auditServerId) .errorUnsuppressed(e) .detail("AuditServerId", auditServerId);
															#line 1143 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 9263 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1094 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (UIDtoTagMap.more || UIDtoTagMap.size() >= CLIENT_KNOBS->TOO_MANY)
															#line 9277 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 1095 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(g_network->isSimulated() ? SevError : SevWarnAlways, "AuditUtilReadKeyServersReadTagError", auditServerId);
															#line 1098 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			return a_body1Catch2(audit_storage_cancelled(), loopDepth);
															#line 9283 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 1100 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		Future<Version> grvF = tr->getReadVersion();
															#line 1101 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!grvF.isReady())
															#line 9289 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 1102 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(SevWarnAlways, "AuditUtilReadKeyServersGRVError", auditServerId);
															#line 1103 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			return a_body1Catch2(audit_storage_cancelled(), loopDepth);
															#line 9295 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 1105 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		Version readAtVersion = grvF.get();
															#line 1107 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		TraceEvent(SevVerbose, "AuditUtilGetThisServerKeysFromKeyServersReadDone", auditServerId) .detail("Range", range) .detail("ResultSize", readResult.size()) .detail("AuditServerID", auditServerId);
															#line 1113 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		std::unordered_map<UID, std::vector<KeyRange>> serverOwnRanges;
															#line 1114 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		for(int i = 0;i < readResult.size() - 1;++i) {
															#line 1115 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			std::vector<UID> src;
															#line 1116 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			std::vector<UID> dest;
															#line 1117 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			UID srcID;
															#line 1118 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			UID destID;
															#line 1119 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			decodeKeyServersValue(UIDtoTagMap, readResult[i].value, src, dest, srcID, destID);
															#line 1120 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (srcID == anonymousShardId)
															#line 9317 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
															#line 1121 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				shardsInAnonymousPhysicalShardCount++;
															#line 9321 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			}
															#line 1123 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			totalShardsCount++;
															#line 1124 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			std::vector<UID> servers(src.size() + dest.size());
															#line 1125 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			std::merge(src.begin(), src.end(), dest.begin(), dest.end(), servers.begin());
															#line 1126 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			for( auto& ssid : servers ) {
															#line 1127 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				serverOwnRanges[ssid].push_back(Standalone(KeyRangeRef(readResult[i].key, readResult[i + 1].key)));
															#line 9333 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			}
		}
															#line 1130 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		const KeyRange completeRange = Standalone(KeyRangeRef(range.begin, readResult.back().key));
															#line 1131 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		TraceEvent(SevInfo, "AuditUtilGetThisServerKeysFromKeyServersEnd", auditServerId) .detail("Range", range) .detail("CompleteRange", completeRange) .detail("AtVersion", readAtVersion) .detail("ShardsInAnonymousPhysicalShardCount", shardsInAnonymousPhysicalShardCount) .detail("TotalShardsCount", totalShardsCount);
															#line 1137 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		res = AuditGetKeyServersRes(completeRange, readAtVersion, serverOwnRanges, readResult.logicalSize());
															#line 9342 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1094 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (UIDtoTagMap.more || UIDtoTagMap.size() >= CLIENT_KNOBS->TOO_MANY)
															#line 9351 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 1095 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(g_network->isSimulated() ? SevError : SevWarnAlways, "AuditUtilReadKeyServersReadTagError", auditServerId);
															#line 1098 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			return a_body1Catch2(audit_storage_cancelled(), loopDepth);
															#line 9357 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 1100 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		Future<Version> grvF = tr->getReadVersion();
															#line 1101 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!grvF.isReady())
															#line 9363 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 1102 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(SevWarnAlways, "AuditUtilReadKeyServersGRVError", auditServerId);
															#line 1103 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			return a_body1Catch2(audit_storage_cancelled(), loopDepth);
															#line 9369 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 1105 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		Version readAtVersion = grvF.get();
															#line 1107 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		TraceEvent(SevVerbose, "AuditUtilGetThisServerKeysFromKeyServersReadDone", auditServerId) .detail("Range", range) .detail("ResultSize", readResult.size()) .detail("AuditServerID", auditServerId);
															#line 1113 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		std::unordered_map<UID, std::vector<KeyRange>> serverOwnRanges;
															#line 1114 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		for(int i = 0;i < readResult.size() - 1;++i) {
															#line 1115 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			std::vector<UID> src;
															#line 1116 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			std::vector<UID> dest;
															#line 1117 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			UID srcID;
															#line 1118 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			UID destID;
															#line 1119 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			decodeKeyServersValue(UIDtoTagMap, readResult[i].value, src, dest, srcID, destID);
															#line 1120 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (srcID == anonymousShardId)
															#line 9391 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
															#line 1121 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				shardsInAnonymousPhysicalShardCount++;
															#line 9395 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			}
															#line 1123 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			totalShardsCount++;
															#line 1124 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			std::vector<UID> servers(src.size() + dest.size());
															#line 1125 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			std::merge(src.begin(), src.end(), dest.begin(), dest.end(), servers.begin());
															#line 1126 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			for( auto& ssid : servers ) {
															#line 1127 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				serverOwnRanges[ssid].push_back(Standalone(KeyRangeRef(readResult[i].key, readResult[i + 1].key)));
															#line 9407 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			}
		}
															#line 1130 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		const KeyRange completeRange = Standalone(KeyRangeRef(range.begin, readResult.back().key));
															#line 1131 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		TraceEvent(SevInfo, "AuditUtilGetThisServerKeysFromKeyServersEnd", auditServerId) .detail("Range", range) .detail("CompleteRange", completeRange) .detail("AtVersion", readAtVersion) .detail("ShardsInAnonymousPhysicalShardCount", shardsInAnonymousPhysicalShardCount) .detail("TotalShardsCount", totalShardsCount);
															#line 1137 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		res = AuditGetKeyServersRes(completeRange, readAtVersion, serverOwnRanges, readResult.logicalSize());
															#line 9416 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetShardMapFromKeyServersActor*>(this)->actor_wait_state > 0) static_cast<GetShardMapFromKeyServersActor*>(this)->actor_wait_state = 0;
		static_cast<GetShardMapFromKeyServersActor*>(this)->ActorCallback< GetShardMapFromKeyServersActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetShardMapFromKeyServersActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getShardMapFromKeyServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetShardMapFromKeyServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getShardMapFromKeyServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetShardMapFromKeyServersActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getShardMapFromKeyServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetShardMapFromKeyServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getShardMapFromKeyServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetShardMapFromKeyServersActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getShardMapFromKeyServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetShardMapFromKeyServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getShardMapFromKeyServers", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont9(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1076 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	UID auditServerId;
															#line 1076 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Transaction* tr;
															#line 1076 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	KeyRange range;
															#line 1077 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	AuditGetKeyServersRes res;
															#line 1078 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	std::vector<Future<Void>> actors;
															#line 1079 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	RangeResult readResult;
															#line 1080 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	RangeResult UIDtoTagMap;
															#line 1081 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	int64_t totalShardsCount;
															#line 1082 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	int64_t shardsInAnonymousPhysicalShardCount;
															#line 9527 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getShardMapFromKeyServers()
															#line 1076 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class GetShardMapFromKeyServersActor final : public Actor<AuditGetKeyServersRes>, public ActorCallback< GetShardMapFromKeyServersActor, 0, Void >, public FastAllocated<GetShardMapFromKeyServersActor>, public GetShardMapFromKeyServersActorState<GetShardMapFromKeyServersActor> {
															#line 9532 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetShardMapFromKeyServersActor>::operator new;
	using FastAllocated<GetShardMapFromKeyServersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1909990346039763968UL, 8314291603780203264UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<AuditGetKeyServersRes>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetShardMapFromKeyServersActor, 0, Void >;
															#line 1076 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	GetShardMapFromKeyServersActor(UID const& auditServerId,Transaction* const& tr,KeyRange const& range) 
															#line 9549 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		 : Actor<AuditGetKeyServersRes>(),
		   GetShardMapFromKeyServersActorState<GetShardMapFromKeyServersActor>(auditServerId, tr, range),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getShardMapFromKeyServers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3833684394082341632UL, 14546150940928992768UL);
		ActorExecutionContextHelper __helper(static_cast<GetShardMapFromKeyServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getShardMapFromKeyServers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getShardMapFromKeyServers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetShardMapFromKeyServersActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1076 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
[[nodiscard]] Future<AuditGetKeyServersRes> getShardMapFromKeyServers( UID const& auditServerId, Transaction* const& tr, KeyRange const& range ) {
															#line 1076 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	return Future<AuditGetKeyServersRes>(new GetShardMapFromKeyServersActor(auditServerId, tr, range));
															#line 9582 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
}

#line 1148 "/codebuild/output/src1682381553/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
