#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
/*
 * ThreadSafety.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbrpc/simulator.h"
#include "flow/DeterministicRandom.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/ServerDBInfo.h"
#include "fdbclient/ThreadSafeTransaction.h"
#include "fdbclient/MultiVersionTransaction.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct ThreadSafetyWorkload;

// Parameters passed to each thread
struct ThreadInfo {
	int id;
	ThreadSafetyWorkload* self;

	Promise<Void> done;
	DeterministicRandom random;

	ThreadInfo(int id, ThreadSafetyWorkload* self)
	  : id(id), self(self), random(deterministicRandom()->randomInt(1, 1e9)) {}
};

// A thread barrier implementation. Reached() method blocks until the required number of threads reach it.
struct Barrier {
	Mutex mutex;
	std::vector<Event*> events;

	int numRequired;
	int numReached;

	Barrier() : numRequired(0), numReached(0) {}

	~Barrier() { fire(); }

	void decrementNumRequired() {
		mutex.enter();
		if (--numRequired == numReached)
			fire();
		mutex.leave();
	}

	void setNumRequired(int numRequired) {
		mutex.enter();
		this->numRequired = numRequired;
		if (numRequired > 0 && numRequired <= numReached)
			fire();
		mutex.leave();
	}

	// Called by each thread to signal that the barrier has been reached.
	// Blocks until <numRequired> threads have called this function.
	void reached() {
		mutex.enter();
		bool ready = (++numReached == numRequired);
		Event* myEvent = nullptr;

		if (ready)
			fire();
		else {
			myEvent = new Event();
			events.push_back(myEvent);
		}
		mutex.leave();

		if (!ready) {
			myEvent->block();
			delete myEvent;
		}
	}

private:
	void fire() {
		numReached = 0;
		for (int i = 0; i < events.size(); ++i)
			events[i]->set();

		events.clear();
	}
};

// A workload which uses the thread safe API from multiple threads
struct ThreadSafetyWorkload : TestWorkload {
	static constexpr auto NAME = "ThreadSafety";

	int threadsPerClient;
	double threadDuration;

	// Used to generate keys for the workload. This is the number of keys that will be available for operations.
	int numKeys;

	bool success;
	bool stopped;

	Mutex mutex;
	Barrier commitBarrier;

	Reference<IDatabase> db;

	// ThreadFutures are not thread safe, so they must be copied in other threads inside of mutexes
	ThreadFuture<Void> commitFuture;

	Reference<ITransaction> tr;

	ThreadSafetyWorkload(WorkloadContext const& wcx) : TestWorkload(wcx), stopped(false) {

		threadsPerClient = getOption(options, "threadsPerClient"_sr, 3);
		threadDuration = getOption(options, "threadDuration"_sr, 60.0);
		numKeys = getOption(options, "numKeys"_sr, 100);

		commitBarrier.setNumRequired(threadsPerClient);

		success = true;

		// This test is not deterministic
		noUnseed = true;
	}

	Future<Void> setup(Database const& cx) override { return Void(); }

	Future<Void> start(Database const& cx) override { return _start(cx, this); }

																#line 145 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ThreadSafety.actor.g.cpp.py_gen"
// This generated class is to be used only via _start()
															#line 143 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
template <class _startActor>
															#line 143 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
class _startActorState {
															#line 151 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ThreadSafety.actor.g.cpp.py_gen"
public:
															#line 143 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
	_startActorState(Database const& cx,ThreadSafetyWorkload* const& self) 
															#line 143 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
															#line 143 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
		 : cx(cx),
															#line 143 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
		   self(self),
															#line 144 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
		   threadInfo()
															#line 162 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ThreadSafety.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 146 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
			StrictFuture<Reference<IDatabase>> __when_expr_0 = unsafeThreadFutureToFuture(ThreadSafeDatabase::createFromExistingDatabase(cx));
															#line 146 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 179 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ThreadSafety.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 146 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Reference<IDatabase> >*>(static_cast<_startActor*>(this)));
															#line 184 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ThreadSafety.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Reference<IDatabase> const& dbRef,int loopDepth) 
	{
															#line 148 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
		self->db = dbRef;
															#line 150 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
		if (deterministicRandom()->coinflip())
															#line 209 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ThreadSafety.actor.g.cpp.py_gen"
		{
															#line 151 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
			MultiVersionApi::api->selectApiVersion(cx->apiVersion.version());
															#line 152 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
			self->db = MultiVersionDatabase::debugCreateFromExistingDatabase(dbRef);
															#line 215 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ThreadSafety.actor.g.cpp.py_gen"
		}
															#line 155 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
		i = int();
															#line 156 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
		for(i = 0;i < self->threadsPerClient;++i) {
															#line 157 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
			threadInfo.push_back(new ThreadInfo(i, self));
															#line 158 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
			g_network->startThread(self->threadStart, threadInfo[i]);
															#line 225 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ThreadSafety.actor.g.cpp.py_gen"
		}
															#line 161 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(self->threadDuration);
															#line 161 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 231 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ThreadSafety.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 161 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 236 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ThreadSafety.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Reference<IDatabase> && dbRef,int loopDepth) 
	{
															#line 148 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
		self->db = dbRef;
															#line 150 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
		if (deterministicRandom()->coinflip())
															#line 247 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ThreadSafety.actor.g.cpp.py_gen"
		{
															#line 151 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
			MultiVersionApi::api->selectApiVersion(cx->apiVersion.version());
															#line 152 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
			self->db = MultiVersionDatabase::debugCreateFromExistingDatabase(dbRef);
															#line 253 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ThreadSafety.actor.g.cpp.py_gen"
		}
															#line 155 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
		i = int();
															#line 156 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
		for(i = 0;i < self->threadsPerClient;++i) {
															#line 157 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
			threadInfo.push_back(new ThreadInfo(i, self));
															#line 158 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
			g_network->startThread(self->threadStart, threadInfo[i]);
															#line 263 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ThreadSafety.actor.g.cpp.py_gen"
		}
															#line 161 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(self->threadDuration);
															#line 161 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 269 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ThreadSafety.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 161 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 274 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ThreadSafety.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Reference<IDatabase> const& dbRef,int loopDepth) 
	{
		loopDepth = a_body1cont1(dbRef, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IDatabase> && dbRef,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(dbRef), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Reference<IDatabase> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Reference<IDatabase> >*,Reference<IDatabase> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Reference<IDatabase> >*,Reference<IDatabase> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Reference<IDatabase> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 164 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
		self->mutex.enter();
															#line 165 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
		self->stopped = true;
															#line 166 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
		self->mutex.leave();
															#line 168 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
		i = 0;
															#line 364 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ThreadSafety.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 164 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
		self->mutex.enter();
															#line 165 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
		self->stopped = true;
															#line 166 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
		self->mutex.leave();
															#line 168 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
		i = 0;
															#line 379 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ThreadSafety.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 180 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 463 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ThreadSafety.actor.g.cpp.py_gen"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 168 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
		if (!(i < threadInfo.size()))
															#line 482 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ThreadSafety.actor.g.cpp.py_gen"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
		try {
															#line 170 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
			StrictFuture<Void> __when_expr_2 = threadInfo[i]->done.getFuture();
															#line 170 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 491 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ThreadSafety.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont2loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 170 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 496 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ThreadSafety.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
															#line 177 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
		delete threadInfo[i];
															#line 168 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
		++i;
															#line 526 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ThreadSafety.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 172 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
			self->success = false;
															#line 173 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
			printf("Thread %d.%d failed: %s\n", self->clientId, i, e.name());
															#line 174 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
			TraceEvent(SevError, "ThreadSafety_ThreadFailed").error(e);
															#line 540 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ThreadSafety.actor.g.cpp.py_gen"
			loopDepth = a_body1cont2loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont2loopBody1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont2loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 143 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
	Database cx;
															#line 143 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
	ThreadSafetyWorkload* self;
															#line 144 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
	std::vector<ThreadInfo*> threadInfo;
															#line 155 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
	int i;
															#line 659 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ThreadSafety.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _start()
															#line 143 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Reference<IDatabase> >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 664 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ThreadSafety.actor.g.cpp.py_gen"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16502441173045030656UL, 10508466837628521472UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Reference<IDatabase> >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, Void >;
															#line 143 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
	_startActor(Database const& cx,ThreadSafetyWorkload* const& self) 
															#line 683 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ThreadSafety.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Reference<IDatabase> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 143 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
[[nodiscard]] Future<Void> _start( Database const& cx, ThreadSafetyWorkload* const& self ) {
															#line 143 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 717 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ThreadSafety.actor.g.cpp.py_gen"
}

#line 182 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/ThreadSafety.actor.cpp"

	THREAD_FUNC threadStart(void* arg) {
		ThreadInfo* info = (ThreadInfo*)arg;

		Error error(error_code_success);
		try {
			info->self->runTest(info);
		} catch (Error& e) {
			error = e;
		}

		info->self->commitBarrier.decrementNumRequired();

		// Signal completion back to the main thread
		onMainThreadVoid([=]() {
			if (error.code() != error_code_success)
				info->done.sendError(error);
			else
				info->done.send(Void());
		});

		THREAD_RETURN;
	}

	Key getRandomKey(DeterministicRandom& random) {
		return StringRef(format("ThreadSafetyKey%010d", random.randomInt(0, numKeys)));
	}

	void runTest(ThreadInfo* info) {
		// Create a new transaction
		mutex.enter();
		if (!tr) {
			try {
				tr = db->createTransaction();
			} catch (Error&) {
				mutex.leave();
				throw;
			}
		}
		mutex.leave();

		loop {
			// Perform a sequence of random operations
			for (int i = 0; i < info->random.randomInt(1, 10); ++i) {
				int operation = info->random.randomInt(0, 6);

				try {
					if (operation == 0)
						tr->set(getRandomKey(info->random),
						        StringRef(std::string(info->random.randomInt(0, 100), 'x')));
					else if (operation == 1)
						tr->get(getRandomKey(info->random)).getBlocking();
					else if (operation == 2)
						tr->getKey(KeySelectorRef(getRandomKey(info->random),
						                          info->random.randomInt(0, 2) == 1,
						                          info->random.randomInt(-10, 11)))
						    .getBlocking();
					else if (operation == 3) {
						Key key1 = getRandomKey(info->random);
						Key key2 = getRandomKey(info->random);
						GetRangeLimits limits(info->random.randomInt(1, 1000), info->random.randomInt(1, 1e6));
						tr->getRange(KeyRangeRef(std::min(key1, key2), std::max(key1, key2)),
						             limits,
						             info->random.randomInt(0, 2) != 0,
						             info->random.randomInt(0, 2) != 0)
						    .getBlocking();
					} else if (operation == 4)
						tr->clear(getRandomKey(info->random));
					else if (operation == 5) {
						Key key1 = getRandomKey(info->random);
						Key key2 = getRandomKey(info->random);
						tr->clear(KeyRangeRef(std::min(key1, key2), std::max(key1, key2)));
					}
				} catch (Error&) {
					break;
				}
			}

			commitBarrier.reached();

			// One thread starts a commit, and all threads wait on that commit
			mutex.enter();
			if (!commitFuture.isValid())
				commitFuture = tr->commit();
			ThreadFuture<Void> commit = commitFuture;
			mutex.leave();

			try {
				commit.getBlocking();
			} catch (Error&) {
			}

			commitBarrier.reached();

			mutex.enter();
			if (commitFuture.isValid())
				commitFuture = ThreadFuture<Void>();

			if (stopped) {
				mutex.leave();
				break;
			}

			mutex.leave();
		}
	}

	Future<bool> check(Database const& cx) override { return success; }

	void getMetrics(std::vector<PerfMetric>& m) override {}
};

WorkloadFactory<ThreadSafetyWorkload> ThreadSafetyWorkloadFactory;
