#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
/*
 * SpecialKeySpaceCorrectness.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "boost/lexical_cast.hpp"
#include "boost/algorithm/string.hpp"

#include "fdbclient/GlobalConfig.actor.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbclient/Schemas.h"
#include "fdbclient/SpecialKeySpace.actor.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/IRandom.h"
#include "flow/actorcompiler.h"

struct SpecialKeySpaceCorrectnessWorkload : TestWorkload {
	static constexpr auto NAME = "SpecialKeySpaceCorrectness";

	int actorCount, minKeysPerRange, maxKeysPerRange, rangeCount, keyBytes, valBytes, conflictRangeSizeFactor;
	double testDuration, absoluteRandomProb, transactionsPerSecond;
	PerfIntCounter wrongResults, keysCount;
	Reference<ReadYourWritesTransaction> ryw; // used to store all populated data
	std::vector<std::shared_ptr<SKSCTestRWImpl>> rwImpls;
	std::vector<std::shared_ptr<SKSCTestAsyncReadImpl>> asyncReadImpls;
	Standalone<VectorRef<KeyRangeRef>> keys;
	Standalone<VectorRef<KeyRangeRef>> rwKeys;

	SpecialKeySpaceCorrectnessWorkload(WorkloadContext const& wcx)
	  : TestWorkload(wcx), wrongResults("Wrong Results"), keysCount("Number of generated keys") {
		minKeysPerRange = getOption(options, "minKeysPerRange"_sr, 1);
		maxKeysPerRange = getOption(options, "maxKeysPerRange"_sr, 100);
		rangeCount = getOption(options, "rangeCount"_sr, 10);
		keyBytes = getOption(options, "keyBytes"_sr, 16);
		valBytes = getOption(options, "valueBytes"_sr, 16);
		testDuration = getOption(options, "testDuration"_sr, 10.0);
		transactionsPerSecond = getOption(options, "transactionsPerSecond"_sr, 100.0);
		actorCount = getOption(options, "actorCount"_sr, 1);
		absoluteRandomProb = getOption(options, "absoluteRandomProb"_sr, 0.5);
		// Controls the relative size of read/write conflict ranges and the number of random getranges
		conflictRangeSizeFactor = getOption(options, "conflictRangeSizeFactor"_sr, 10);
		ASSERT(conflictRangeSizeFactor >= 1);
	}

	Future<Void> setup(Database const& cx) override { return _setup(cx, this); }
	Future<Void> start(Database const& cx) override { return _start(cx, this); }
	Future<bool> check(Database const& cx) override { return wrongResults.getValue() == 0; }
	void getMetrics(std::vector<PerfMetric>& m) override {}
	// disable the default timeout setting
	double getCheckTimeout() const override { return std::numeric_limits<double>::max(); }

	void disableFailureInjectionWorkloads(std::set<std::string>& out) const override {
		// Failure injection workloads like Rollback, Attrition and so on are interfering with the test.
		// In particular, the test aims to test special keys' functions on monitoring and managing the cluster.
		// It expects the FDB cluster is healthy and not doing unexpected configuration changes.
		// All changes should come from special keys' operations' outcome.
		// Consequently, we disable all failure injection workloads in background for this test
		out.insert("all");
	}

	Future<Void> _setup(Database cx, SpecialKeySpaceCorrectnessWorkload* self) {
		cx->specialKeySpace = std::make_unique<SpecialKeySpace>();
		self->ryw = makeReference<ReadYourWritesTransaction>(cx);
		self->ryw->setOption(FDBTransactionOptions::RAW_ACCESS);
		self->ryw->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_RELAXED);
		self->ryw->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
		self->ryw->setVersion(100);
		self->ryw->clear(normalKeys);
		// generate key ranges
		for (int i = 0; i < self->rangeCount; ++i) {
			std::string baseKey = deterministicRandom()->randomAlphaNumeric(i + 1);
			Key startKey(baseKey + "/");
			Key endKey(baseKey + "/\xff");
			self->keys.push_back_deep(self->keys.arena(), KeyRangeRef(startKey, endKey));
			if (deterministicRandom()->random01() < 0.2 && !self->rwImpls.empty()) {
				self->asyncReadImpls.push_back(std::make_shared<SKSCTestAsyncReadImpl>(KeyRangeRef(startKey, endKey)));
				cx->specialKeySpace->registerKeyRange(SpecialKeySpace::MODULE::TESTONLY,
				                                      SpecialKeySpace::IMPLTYPE::READONLY,
				                                      self->keys.back(),
				                                      self->asyncReadImpls.back().get());
			} else {
				self->rwImpls.push_back(std::make_shared<SKSCTestRWImpl>(KeyRangeRef(startKey, endKey)));
				// Although there are already ranges registered, the testing range will replace them
				cx->specialKeySpace->registerKeyRange(SpecialKeySpace::MODULE::TESTONLY,
				                                      SpecialKeySpace::IMPLTYPE::READWRITE,
				                                      self->keys.back(),
				                                      self->rwImpls.back().get());
			}
			// generate keys in each key range
			int keysInRange = deterministicRandom()->randomInt(self->minKeysPerRange, self->maxKeysPerRange + 1);
			self->keysCount += keysInRange;
			for (int j = 0; j < keysInRange; ++j) {
				self->ryw->set(Key(deterministicRandom()->randomAlphaNumeric(self->keyBytes)).withPrefix(startKey),
				               Value(deterministicRandom()->randomAlphaNumeric(self->valBytes)));
			}
		}
		ASSERT(rwImpls.size() > 0);

		return Void();
	}
																#line 122 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via _start()
															#line 120 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
template <class _startActor>
															#line 120 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
class _startActorState {
															#line 128 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
public:
															#line 120 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	_startActorState(Database const& cx,SpecialKeySpaceCorrectnessWorkload* const& self) 
															#line 120 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
															#line 120 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		 : cx(cx),
															#line 120 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		   self(self)
															#line 137 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 121 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			testRywLifetime(cx);
															#line 122 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_0 = timeout(self->testSpecialKeySpaceErrors(cx, self) && self->getRangeCallActor(cx, self) && testConflictRanges(cx, true, self) && testConflictRanges(cx, false, self) && self->metricsApiCorrectnessActor(cx, self), self->testDuration, Void());
															#line 122 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 156 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 122 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 161 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 128 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (self->clientId == 0)
															#line 184 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		{
															#line 129 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_1 = self->managementApiCorrectnessActor(cx, self);
															#line 129 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 190 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 129 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 195 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 128 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (self->clientId == 0)
															#line 209 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		{
															#line 129 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_1 = self->managementApiCorrectnessActor(cx, self);
															#line 129 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 215 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 129 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 220 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 130 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 309 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 120 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	Database cx;
															#line 120 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	SpecialKeySpaceCorrectnessWorkload* self;
															#line 408 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _start()
															#line 120 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 413 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4864469221418309376UL, 7731804919999602176UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
															#line 120 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	_startActor(Database const& cx,SpecialKeySpaceCorrectnessWorkload* const& self) 
															#line 431 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 120 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
[[nodiscard]] Future<Void> _start( Database const& cx, SpecialKeySpaceCorrectnessWorkload* const& self ) {
															#line 120 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 464 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
}

#line 132 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"

	// This would be a unit test except we need a Database to create an ryw transaction
	static void testRywLifetime(Database cx) {
		Future<Void> f;
		{
			ReadYourWritesTransaction ryw{ cx->clone() };
			if (!ryw.getDatabase()->apiVersionAtLeast(630)) {
				// This test is not valid for API versions smaller than 630
				return;
			}
			f = success(ryw.get("\xff\xff/status/json"_sr));
			CODE_PROBE(!f.isReady(), "status json not ready");
		}
		ASSERT(f.isError());
		ASSERT(f.getError().code() == error_code_transaction_cancelled);
	}

																#line 485 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via getRangeCallActor()
															#line 149 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
template <class GetRangeCallActorActor>
															#line 149 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
class GetRangeCallActorActorState {
															#line 491 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
public:
															#line 149 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	GetRangeCallActorActorState(Database const& cx,SpecialKeySpaceCorrectnessWorkload* const& self) 
															#line 149 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
															#line 149 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		 : cx(cx),
															#line 149 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		   self(self),
															#line 150 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		   lastTime(now()),
															#line 151 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		   reverse(Reverse::False)
															#line 504 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getRangeCallActor", reinterpret_cast<unsigned long>(this));

	}
	~GetRangeCallActorActorState() 
	{
		fdb_probe_actor_destroy("getRangeCallActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 152 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			;
															#line 519 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetRangeCallActorActorState();
		static_cast<GetRangeCallActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 153 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_0 = poisson(&lastTime, 1.0 / self->transactionsPerSecond);
															#line 153 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<GetRangeCallActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 551 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<GetRangeCallActorActor*>(this)->actor_wait_state = 1;
															#line 153 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetRangeCallActorActor, 0, Void >*>(static_cast<GetRangeCallActorActor*>(this)));
															#line 556 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 154 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		reverse.set(deterministicRandom()->coinflip());
															#line 155 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		limit = self->randomLimits();
															#line 156 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		begin = self->randomKeySelector();
															#line 157 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		end = self->randomKeySelector();
															#line 158 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto correctResultFuture = self->ryw->getRange(begin, end, limit, Snapshot::False, reverse);
															#line 159 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(correctResultFuture.isReady());
															#line 160 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto correctResult = correctResultFuture.getValue();
															#line 161 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto testResultFuture = cx->specialKeySpace->getRange(self->ryw.getPtr(), begin, end, limit, reverse);
															#line 162 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(testResultFuture.isReady());
															#line 163 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto testResult = testResultFuture.getValue();
															#line 166 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (!self->compareRangeResult(correctResult, testResult))
															#line 585 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		{
															#line 167 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			TraceEvent(SevError, "TestFailure") .detail("Reason", "Results from getRange are inconsistent") .detail("Begin", begin) .detail("End", end) .detail("LimitRows", limit.rows) .detail("LimitBytes", limit.bytes) .detail("Reverse", reverse);
															#line 174 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			++self->wrongResults;
															#line 591 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		}
															#line 178 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		KeyRange rkr = self->randomRWKeyRange();
															#line 179 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		KeyRef rkey1 = rkr.begin;
															#line 180 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		KeyRef rkey2 = rkr.end;
															#line 182 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (deterministicRandom()->coinflip())
															#line 601 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		{
															#line 183 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			Value rvalue1 = self->randomValue();
															#line 184 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			cx->specialKeySpace->set(self->ryw.getPtr(), rkey1, rvalue1);
															#line 185 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			self->ryw->set(rkey1, rvalue1);
															#line 186 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			Value rvalue2 = self->randomValue();
															#line 187 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			cx->specialKeySpace->set(self->ryw.getPtr(), rkey2, rvalue2);
															#line 188 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			self->ryw->set(rkey2, rvalue2);
															#line 615 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		}
		else
		{
															#line 189 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (deterministicRandom()->coinflip())
															#line 621 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			{
															#line 190 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				cx->specialKeySpace->clear(self->ryw.getPtr(), rkey1);
															#line 191 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				self->ryw->clear(rkey1);
															#line 192 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				cx->specialKeySpace->clear(self->ryw.getPtr(), rkey2);
															#line 193 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				self->ryw->clear(rkey2);
															#line 631 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			}
			else
			{
															#line 195 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				cx->specialKeySpace->clear(self->ryw.getPtr(), rkr);
															#line 196 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				self->ryw->clear(rkr);
															#line 639 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			}
		}
															#line 199 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto correctRywResultFuture = self->ryw->getRange(begin, end, limit, Snapshot::False, reverse);
															#line 200 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(correctRywResultFuture.isReady());
															#line 201 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto correctRywResult = correctRywResultFuture.getValue();
															#line 202 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto testRywResultFuture = cx->specialKeySpace->getRange(self->ryw.getPtr(), begin, end, limit, reverse);
															#line 203 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(testRywResultFuture.isReady());
															#line 204 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto testRywResult = testRywResultFuture.getValue();
															#line 207 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (!self->compareRangeResult(correctRywResult, testRywResult))
															#line 656 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		{
															#line 208 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			TraceEvent(SevError, "TestFailure") .detail("Reason", "Results from getRange(ryw) are inconsistent") .detail("Begin", begin) .detail("End", end) .detail("LimitRows", limit.rows) .detail("LimitBytes", limit.bytes) .detail("Reverse", reverse);
															#line 215 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			++self->wrongResults;
															#line 662 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 154 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		reverse.set(deterministicRandom()->coinflip());
															#line 155 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		limit = self->randomLimits();
															#line 156 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		begin = self->randomKeySelector();
															#line 157 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		end = self->randomKeySelector();
															#line 158 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto correctResultFuture = self->ryw->getRange(begin, end, limit, Snapshot::False, reverse);
															#line 159 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(correctResultFuture.isReady());
															#line 160 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto correctResult = correctResultFuture.getValue();
															#line 161 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto testResultFuture = cx->specialKeySpace->getRange(self->ryw.getPtr(), begin, end, limit, reverse);
															#line 162 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(testResultFuture.isReady());
															#line 163 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto testResult = testResultFuture.getValue();
															#line 166 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (!self->compareRangeResult(correctResult, testResult))
															#line 692 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		{
															#line 167 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			TraceEvent(SevError, "TestFailure") .detail("Reason", "Results from getRange are inconsistent") .detail("Begin", begin) .detail("End", end) .detail("LimitRows", limit.rows) .detail("LimitBytes", limit.bytes) .detail("Reverse", reverse);
															#line 174 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			++self->wrongResults;
															#line 698 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		}
															#line 178 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		KeyRange rkr = self->randomRWKeyRange();
															#line 179 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		KeyRef rkey1 = rkr.begin;
															#line 180 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		KeyRef rkey2 = rkr.end;
															#line 182 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (deterministicRandom()->coinflip())
															#line 708 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		{
															#line 183 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			Value rvalue1 = self->randomValue();
															#line 184 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			cx->specialKeySpace->set(self->ryw.getPtr(), rkey1, rvalue1);
															#line 185 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			self->ryw->set(rkey1, rvalue1);
															#line 186 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			Value rvalue2 = self->randomValue();
															#line 187 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			cx->specialKeySpace->set(self->ryw.getPtr(), rkey2, rvalue2);
															#line 188 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			self->ryw->set(rkey2, rvalue2);
															#line 722 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		}
		else
		{
															#line 189 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (deterministicRandom()->coinflip())
															#line 728 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			{
															#line 190 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				cx->specialKeySpace->clear(self->ryw.getPtr(), rkey1);
															#line 191 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				self->ryw->clear(rkey1);
															#line 192 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				cx->specialKeySpace->clear(self->ryw.getPtr(), rkey2);
															#line 193 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				self->ryw->clear(rkey2);
															#line 738 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			}
			else
			{
															#line 195 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				cx->specialKeySpace->clear(self->ryw.getPtr(), rkr);
															#line 196 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				self->ryw->clear(rkr);
															#line 746 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			}
		}
															#line 199 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto correctRywResultFuture = self->ryw->getRange(begin, end, limit, Snapshot::False, reverse);
															#line 200 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(correctRywResultFuture.isReady());
															#line 201 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto correctRywResult = correctRywResultFuture.getValue();
															#line 202 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto testRywResultFuture = cx->specialKeySpace->getRange(self->ryw.getPtr(), begin, end, limit, reverse);
															#line 203 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(testRywResultFuture.isReady());
															#line 204 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto testRywResult = testRywResultFuture.getValue();
															#line 207 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (!self->compareRangeResult(correctRywResult, testRywResult))
															#line 763 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		{
															#line 208 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			TraceEvent(SevError, "TestFailure") .detail("Reason", "Results from getRange(ryw) are inconsistent") .detail("Begin", begin) .detail("End", end) .detail("LimitRows", limit.rows) .detail("LimitBytes", limit.bytes) .detail("Reverse", reverse);
															#line 215 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			++self->wrongResults;
															#line 769 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetRangeCallActorActor*>(this)->actor_wait_state > 0) static_cast<GetRangeCallActorActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeCallActorActor*>(this)->ActorCallback< GetRangeCallActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeCallActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getRangeCallActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeCallActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeCallActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetRangeCallActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getRangeCallActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeCallActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeCallActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetRangeCallActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeCallActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeCallActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeCallActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 149 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	Database cx;
															#line 149 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	SpecialKeySpaceCorrectnessWorkload* self;
															#line 150 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	double lastTime;
															#line 151 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	Reverse reverse;
															#line 155 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	GetRangeLimits limit;
															#line 156 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	KeySelector begin;
															#line 157 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	KeySelector end;
															#line 864 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getRangeCallActor()
															#line 149 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
class GetRangeCallActorActor final : public Actor<Void>, public ActorCallback< GetRangeCallActorActor, 0, Void >, public FastAllocated<GetRangeCallActorActor>, public GetRangeCallActorActorState<GetRangeCallActorActor> {
															#line 869 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetRangeCallActorActor>::operator new;
	using FastAllocated<GetRangeCallActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8571606523082144768UL, 1753968500088790272UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetRangeCallActorActor, 0, Void >;
															#line 149 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	GetRangeCallActorActor(Database const& cx,SpecialKeySpaceCorrectnessWorkload* const& self) 
															#line 886 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   GetRangeCallActorActorState<GetRangeCallActorActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getRangeCallActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8464877911471062784UL, 4537410763034963968UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeCallActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getRangeCallActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getRangeCallActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetRangeCallActorActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 149 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
[[nodiscard]] Future<Void> getRangeCallActor( Database const& cx, SpecialKeySpaceCorrectnessWorkload* const& self ) {
															#line 149 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	return Future<Void>(new GetRangeCallActorActor(cx, self));
															#line 918 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
}

#line 219 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"

	bool compareRangeResult(RangeResult const& res1, RangeResult const& res2) {
		if ((res1.more != res2.more) || (res1.readToBegin != res2.readToBegin) ||
		    (res1.readThroughEnd != res2.readThroughEnd)) {
			TraceEvent(SevError, "TestFailure")
			    .detail("Reason", "RangeResultRef flags are inconsistent")
			    .detail("More", res1.more)
			    .detail("ReadToBegin", res1.readToBegin)
			    .detail("ReadThroughEnd", res1.readThroughEnd)
			    .detail("More2", res2.more)
			    .detail("ReadToBegin2", res2.readToBegin)
			    .detail("ReadThroughEnd2", res2.readThroughEnd);
			return false;
		}
		if (res1.size() != res2.size()) {
			TraceEvent(SevError, "TestFailure")
			    .detail("Reason", "Results' sizes are inconsistent")
			    .detail("CorrestResultSize", res1.size())
			    .detail("TestResultSize", res2.size());
			return false;
		}
		for (int i = 0; i < res1.size(); ++i) {
			if (res1[i].key != res2[i].key) {
				TraceEvent(SevError, "TestFailure")
				    .detail("Reason", "Keys are inconsistent")
				    .detail("Index", i)
				    .detail("CorrectKey", printable(res1[i].key))
				    .detail("TestKey", printable(res2[i].key));
				return false;
			}
			if (res1[i].value != res2[i].value) {
				TraceEvent(SevError, "TestFailure")
				    .detail("Reason", "Values are inconsistent")
				    .detail("Index", i)
				    .detail("CorrectValue", printable(res1[i].value))
				    .detail("TestValue", printable(res2[i].value));
				return false;
			}
			CODE_PROBE(true, "Special key space keys equal");
		}
		return true;
	}

	KeyRange randomRWKeyRange() {
		ASSERT(rwImpls.size() > 0);
		Key prefix = rwImpls[deterministicRandom()->randomInt(0, rwImpls.size())]->getKeyRange().begin;
		Key rkey1 = Key(deterministicRandom()->randomAlphaNumeric(deterministicRandom()->randomInt(0, keyBytes)))
		                .withPrefix(prefix);
		Key rkey2 = Key(deterministicRandom()->randomAlphaNumeric(deterministicRandom()->randomInt(0, keyBytes)))
		                .withPrefix(prefix);
		return rkey1 <= rkey2 ? KeyRangeRef(rkey1, rkey2) : KeyRangeRef(rkey2, rkey1);
	}

	Key randomKey() {
		Key randomKey;
		if (deterministicRandom()->random01() < absoluteRandomProb) {
			Key prefix;
			if (deterministicRandom()->random01() < absoluteRandomProb)
				// prefix length is randomly generated
				prefix =
				    Key(deterministicRandom()->randomAlphaNumeric(deterministicRandom()->randomInt(1, rangeCount + 1)) +
				        "/");
			else
				// pick up an existing prefix
				prefix = keys[deterministicRandom()->randomInt(0, rangeCount)].begin;
			randomKey = Key(deterministicRandom()->randomAlphaNumeric(keyBytes)).withPrefix(prefix);
		} else {
			// pick up existing keys from registered key ranges
			KeyRangeRef randomKeyRangeRef = keys[deterministicRandom()->randomInt(0, keys.size())];
			randomKey = deterministicRandom()->coinflip() ? randomKeyRangeRef.begin : randomKeyRangeRef.end;
		}
		return randomKey;
	}

	Value randomValue() { return Value(deterministicRandom()->randomAlphaNumeric(valBytes)); }

	KeySelector randomKeySelector() {
		// covers corner cases where offset points outside the key space
		int offset = deterministicRandom()->randomInt(-keysCount.getValue() - 1, keysCount.getValue() + 2);
		return KeySelectorRef(randomKey(), deterministicRandom()->coinflip(), offset);
	}

	GetRangeLimits randomLimits() {
		// TODO : fix knobs for row_unlimited
		int rowLimits = deterministicRandom()->randomInt(0, keysCount.getValue() + 1);
		// The largest key's bytes is longest prefix bytes + 1(for '/') + generated key bytes
		// 8 here refers to bytes of KeyValueRef
		int byteLimits = deterministicRandom()->randomInt(
		    1, keysCount.getValue() * (keyBytes + (rangeCount + 1) + valBytes + 8) + 1);

		auto limit = GetRangeLimits(rowLimits, byteLimits);
		// minRows is always initialized to 1
		if (limit.rows == 0)
			limit.minRows = 0;
		return limit;
	}

																#line 1019 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via testSpecialKeySpaceErrors()
															#line 316 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
template <class TestSpecialKeySpaceErrorsActor>
															#line 316 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
class TestSpecialKeySpaceErrorsActorState {
															#line 1025 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
public:
															#line 316 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	TestSpecialKeySpaceErrorsActorState(Database const& cx_,SpecialKeySpaceCorrectnessWorkload* const& self) 
															#line 316 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
															#line 316 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		 : cx_(cx_),
															#line 316 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		   self(self),
															#line 317 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		   cx(cx_->clone()),
															#line 319 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		   tx(makeReference<ReadYourWritesTransaction>(cx)),
															#line 320 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		   defaultTx1(makeReference<ReadYourWritesTransaction>(cx)),
															#line 321 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		   defaultTx2(makeReference<ReadYourWritesTransaction>(cx)),
															#line 322 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		   disableRyw(deterministicRandom()->coinflip())
															#line 1044 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this));

	}
	~TestSpecialKeySpaceErrorsActorState() 
	{
		fdb_probe_actor_destroy("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			{
															#line 328 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				readresult1 = RangeResult();
															#line 329 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				readresult2 = RangeResult();
															#line 330 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				writeResult1 = RangeResult();
															#line 331 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				writeResult2 = RangeResult();
															#line 1066 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
				try {
															#line 333 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
					if (disableRyw)
															#line 1070 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
					{
															#line 334 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
						defaultTx1->setOption(FDBTransactionOptions::READ_YOUR_WRITES_DISABLE);
															#line 1074 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
					}
															#line 336 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
					defaultTx1->addReadConflictRange(singleKeyRange("testKeylll"_sr));
															#line 337 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
					defaultTx1->addWriteConflictRange(singleKeyRange("testKeylll"_sr));
															#line 338 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
					StrictFuture<Void> __when_expr_0 = store(readresult1, defaultTx1->getRange(readConflictRangeKeysRange, CLIENT_KNOBS->TOO_MANY));
															#line 338 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
					if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1084 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 1;
															#line 338 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 0, Void >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 1089 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				catch (Error& error) {
					loopDepth = a_body1Catch2(error, loopDepth);
				} catch (...) {
					loopDepth = a_body1Catch2(unknown_error(), loopDepth);
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestSpecialKeySpaceErrorsActorState();
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 354 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		;
															#line 1119 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 347 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_3 = store(readresult2, defaultTx1->getRange(readConflictRangeKeysRange, CLIENT_KNOBS->TOO_MANY));
															#line 347 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1130 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont2when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 4;
															#line 347 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 3, Void >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 1135 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 343 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 1145 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			{
															#line 344 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 1149 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			}
															#line 345 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			CODE_PROBE(true, "conflict range commit error thrown");
															#line 1153 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 339 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = store(writeResult1, defaultTx1->getRange(writeConflictRangeKeysRange, CLIENT_KNOBS->TOO_MANY));
															#line 339 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1170 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont3when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 2;
															#line 339 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 1, Void >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 1175 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 339 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = store(writeResult1, defaultTx1->getRange(writeConflictRangeKeysRange, CLIENT_KNOBS->TOO_MANY));
															#line 339 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1186 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont3when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 2;
															#line 339 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 1, Void >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 1191 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 340 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_2 = defaultTx1->commit();
															#line 340 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1277 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont5when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 3;
															#line 340 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 2, Void >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 1282 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 340 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_2 = defaultTx1->commit();
															#line 340 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1293 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont5when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 3;
															#line 340 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 2, Void >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 1298 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 341 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		CODE_PROBE(true, "conflict range commit succeeded");
															#line 1382 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 341 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		CODE_PROBE(true, "conflict range commit succeeded");
															#line 1391 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont9(Void const& _,int loopDepth) 
	{
															#line 348 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_4 = store(writeResult2, defaultTx1->getRange(writeConflictRangeKeysRange, CLIENT_KNOBS->TOO_MANY));
															#line 348 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1490 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont9when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 5;
															#line 348 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 4, Void >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 1495 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9(Void && _,int loopDepth) 
	{
															#line 348 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_4 = store(writeResult2, defaultTx1->getRange(writeConflictRangeKeysRange, CLIENT_KNOBS->TOO_MANY));
															#line 348 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1506 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont9when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 5;
															#line 348 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 4, Void >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 1511 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont10(Void const& _,int loopDepth) 
	{
															#line 349 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(readresult1 == readresult2);
															#line 350 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(writeResult1 == writeResult2);
															#line 351 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		defaultTx1->reset();
															#line 1599 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10(Void && _,int loopDepth) 
	{
															#line 349 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(readresult1 == readresult2);
															#line 350 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(writeResult1 == writeResult2);
															#line 351 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		defaultTx1->reset();
															#line 1612 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont11(int loopDepth) 
	{
		try {
															#line 404 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 405 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_15 = success(tx->getRange(KeyRangeRef("\xff\xff/transactio"_sr, "\xff\xff/transaction0"_sr), CLIENT_KNOBS->TOO_MANY));
															#line 405 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont11Catch1(actor_cancelled(), loopDepth);
															#line 1701 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1cont11Catch1(__when_expr_15.getError(), loopDepth); else return a_body1cont11when1(__when_expr_15.get(), loopDepth); };
			static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 16;
															#line 405 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_15.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 15, Void >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 1706 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont11Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont11Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 356 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (disableRyw)
															#line 1729 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			{
															#line 357 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				defaultTx1->setOption(FDBTransactionOptions::READ_YOUR_WRITES_DISABLE);
															#line 358 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				defaultTx2->setOption(FDBTransactionOptions::READ_YOUR_WRITES_DISABLE);
															#line 1735 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			}
															#line 360 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			defaultTx1->setOption(FDBTransactionOptions::REPORT_CONFLICTING_KEYS);
															#line 361 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			defaultTx2->setOption(FDBTransactionOptions::REPORT_CONFLICTING_KEYS);
															#line 362 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_5 = success(defaultTx1->getReadVersion());
															#line 362 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1745 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_5.get(), loopDepth); };
			static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 6;
															#line 362 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 5, Void >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 1750 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont11(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 397 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 1785 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			{
															#line 398 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 1789 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			}
															#line 399 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_14 = defaultTx2->onError(e);
															#line 399 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1795 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1Catch1(__when_expr_14.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_14.get(), loopDepth); };
			static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 15;
															#line 399 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 14, Void >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 1800 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 363 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_6 = success(defaultTx2->getReadVersion());
															#line 363 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1817 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_6.get(), loopDepth); };
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 7;
															#line 363 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 6, Void >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 1822 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 363 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_6 = success(defaultTx2->getReadVersion());
															#line 363 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1833 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_6.get(), loopDepth); };
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 7;
															#line 363 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 6, Void >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 1838 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 364 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		defaultTx1->addReadConflictRange(singleKeyRange("foo"_sr));
															#line 365 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		defaultTx1->addWriteConflictRange(singleKeyRange("foo"_sr));
															#line 366 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		defaultTx2->addWriteConflictRange(singleKeyRange("foo"_sr));
															#line 367 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_7 = defaultTx2->commit();
															#line 367 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1930 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont1loopBody1cont4when1(__when_expr_7.get(), loopDepth); };
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 8;
															#line 367 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 7, Void >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 1935 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 364 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		defaultTx1->addReadConflictRange(singleKeyRange("foo"_sr));
															#line 365 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		defaultTx1->addWriteConflictRange(singleKeyRange("foo"_sr));
															#line 366 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		defaultTx2->addWriteConflictRange(singleKeyRange("foo"_sr));
															#line 367 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_7 = defaultTx2->commit();
															#line 367 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1952 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont1loopBody1cont4when1(__when_expr_7.get(), loopDepth); };
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 8;
															#line 367 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 7, Void >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 1957 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont1loopBody1cont5(Void const& _,int loopDepth) 
	{
		try {
															#line 369 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_8 = defaultTx1->commit();
															#line 369 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont5Catch1(actor_cancelled(), loopDepth);
															#line 2044 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont1loopBody1cont5Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont1loopBody1cont5when1(__when_expr_8.get(), loopDepth); };
			static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 9;
															#line 369 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 8, Void >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 2049 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont5Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont5Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5(Void && _,int loopDepth) 
	{
		try {
															#line 369 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_8 = defaultTx1->commit();
															#line 369 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont5Catch1(actor_cancelled(), loopDepth);
															#line 2067 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont1loopBody1cont5Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont1loopBody1cont5when1(__when_expr_8.get(), loopDepth); };
			static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 9;
															#line 369 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 8, Void >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 2072 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont5Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont5Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont1loopBody1cont6(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 372 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			err = e;
															#line 373 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (err.code() != error_code_not_committed)
															#line 2171 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			{
															#line 374 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				StrictFuture<Void> __when_expr_9 = defaultTx1->onError(err);
															#line 374 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2177 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
				if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont1loopBody1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont1loopBody1cont5Catch1when1(__when_expr_9.get(), loopDepth); };
				static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 10;
															#line 374 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 9, Void >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 2182 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1loopBody1cont5Catch1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont7(Void const& _,int loopDepth) 
	{
															#line 370 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(false);
															#line 2202 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont7(Void && _,int loopDepth) 
	{
															#line 370 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(false);
															#line 2211 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1loopBody1cont5Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont1loopBody1cont9(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5Catch1cont1(int loopDepth) 
	{
															#line 378 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<RangeResult> __when_expr_11 = defaultTx1->getRange(readConflictRangeKeysRange, CLIENT_KNOBS->TOO_MANY);
															#line 378 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2310 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1cont1loopBody1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont1loopBody1cont5Catch1cont1when1(__when_expr_11.get(), loopDepth); };
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 12;
															#line 378 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 11, RangeResult >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 2315 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5Catch1cont2(Void const& _,int loopDepth) 
	{
															#line 375 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_10 = defaultTx2->onError(err);
															#line 375 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2326 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1cont1loopBody1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont1loopBody1cont5Catch1cont2when1(__when_expr_10.get(), loopDepth); };
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 11;
															#line 375 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 10, Void >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 2331 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5Catch1cont2(Void && _,int loopDepth) 
	{
															#line 375 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_10 = defaultTx2->onError(err);
															#line 375 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2342 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1cont1loopBody1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont1loopBody1cont5Catch1cont2when1(__when_expr_10.get(), loopDepth); };
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 11;
															#line 375 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 10, Void >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 2347 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont1loopBody1cont5Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont1loopBody1cont5Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont1loopBody1cont5Catch1cont3(Void const& _,int loopDepth) 
	{
		return a_body1cont1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5Catch1cont3(Void && _,int loopDepth) 
	{
		return a_body1cont1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5Catch1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5Catch1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5Catch1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5Catch1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont1loopBody1cont5Catch1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont1loopBody1cont5Catch1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont1loopBody1cont5Catch1cont5(int loopDepth) 
	{
															#line 380 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<RangeResult> __when_expr_12 = defaultTx1->getRange(writeConflictRangeKeysRange, CLIENT_KNOBS->TOO_MANY);
															#line 380 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2520 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1cont1loopBody1Catch1(__when_expr_12.getError(), loopDepth); else return a_body1cont1loopBody1cont5Catch1cont5when1(__when_expr_12.get(), loopDepth); };
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 13;
															#line 380 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 12, RangeResult >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 2525 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5Catch1cont1when1(RangeResult const& __readConflictRange,int loopDepth) 
	{
															#line 378 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		readConflictRange = __readConflictRange;
															#line 2534 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont5Catch1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5Catch1cont1when1(RangeResult && __readConflictRange,int loopDepth) 
	{
		readConflictRange = std::move(__readConflictRange);
		loopDepth = a_body1cont1loopBody1cont5Catch1cont5(loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 11, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 11, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont1loopBody1cont5Catch1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 11, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont1loopBody1cont5Catch1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 11, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1cont1loopBody1cont5Catch1cont6(int loopDepth) 
	{
															#line 382 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<RangeResult> __when_expr_13 = defaultTx1->getRange(conflictingKeysRange, CLIENT_KNOBS->TOO_MANY);
															#line 382 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2615 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1cont1loopBody1Catch1(__when_expr_13.getError(), loopDepth); else return a_body1cont1loopBody1cont5Catch1cont6when1(__when_expr_13.get(), loopDepth); };
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 14;
															#line 382 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 13, RangeResult >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 2620 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5Catch1cont5when1(RangeResult const& __writeConflictRange,int loopDepth) 
	{
															#line 380 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		writeConflictRange = __writeConflictRange;
															#line 2629 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont5Catch1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5Catch1cont5when1(RangeResult && __writeConflictRange,int loopDepth) 
	{
		writeConflictRange = std::move(__writeConflictRange);
		loopDepth = a_body1cont1loopBody1cont5Catch1cont6(loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 12, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 12, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont1loopBody1cont5Catch1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 12, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont1loopBody1cont5Catch1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 12, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 12);

	}
	int a_body1cont1loopBody1cont5Catch1cont7(int loopDepth) 
	{
															#line 386 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(readConflictRange.size() == 2 && readConflictRange.begin()->key == readConflictRangeKeysRange.begin.withSuffix("foo"_sr));
															#line 388 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(writeConflictRange.size() == 2 && writeConflictRange.begin()->key == writeConflictRangeKeysRange.begin.withSuffix("foo"_sr));
															#line 390 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(conflictKeys.size() == 2 && conflictKeys.begin()->key == conflictingKeysRange.begin.withSuffix("foo"_sr));
															#line 392 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		defaultTx1->reset();
															#line 393 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		defaultTx2->reset();
															#line 2716 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5Catch1cont6when1(RangeResult const& __conflictKeys,int loopDepth) 
	{
															#line 382 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		conflictKeys = __conflictKeys;
															#line 2725 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont5Catch1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5Catch1cont6when1(RangeResult && __conflictKeys,int loopDepth) 
	{
		conflictKeys = std::move(__conflictKeys);
		loopDepth = a_body1cont1loopBody1cont5Catch1cont7(loopDepth);

		return loopDepth;
	}
	void a_exitChoose14() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 13, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 13, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont1loopBody1cont5Catch1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 13, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont1loopBody1cont5Catch1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 13, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 13);

	}
	int a_body1cont1loopBody1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose15() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 14, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 14, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 14, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 14, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 14);

	}
	int a_body1cont11cont1(int loopDepth) 
	{
		try {
															#line 416 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 417 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_16 = success(tx->getRange(KeyRangeRef("\xff\xff/transaction/"_sr, "\xff\xff/transaction1"_sr), CLIENT_KNOBS->TOO_MANY));
															#line 417 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont11cont1Catch1(actor_cancelled(), loopDepth);
															#line 2909 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_16.isReady()) { if (__when_expr_16.isError()) return a_body1cont11cont1Catch1(__when_expr_16.getError(), loopDepth); else return a_body1cont11cont1when1(__when_expr_16.get(), loopDepth); };
			static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 17;
															#line 417 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_16.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 16, Void >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 2914 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont11cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont11cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 409 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 2930 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			{
															#line 410 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 2934 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			}
															#line 411 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			ASSERT(e.code() == error_code_special_keys_cross_module_read);
															#line 412 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->reset();
															#line 2940 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			loopDepth = a_body1cont11cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont2(Void const& _,int loopDepth) 
	{
															#line 407 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(false);
															#line 2955 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont11cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont2(Void && _,int loopDepth) 
	{
															#line 407 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(false);
															#line 2964 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont11cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont11when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose16() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 15, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 15, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11Catch1(error, 0);
		} catch (...) {
			a_body1cont11Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 15, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11Catch1(error, 0);
		} catch (...) {
			a_body1cont11Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 15, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont11Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11Catch1(error, 0);
		} catch (...) {
			a_body1cont11Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 15);

	}
	int a_body1cont11cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont11cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont5(int loopDepth) 
	{
		try {
															#line 428 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 429 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_17 = success(tx->getRange(KeyRangeRef("\xff\xff/transaction"_sr, "\xff\xff/transaction1"_sr), CLIENT_KNOBS->TOO_MANY));
															#line 429 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont11cont5Catch1(actor_cancelled(), loopDepth);
															#line 3066 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_17.isReady()) { if (__when_expr_17.isError()) return a_body1cont11cont5Catch1(__when_expr_17.getError(), loopDepth); else return a_body1cont11cont5when1(__when_expr_17.get(), loopDepth); };
			static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 18;
															#line 429 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_17.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 17, Void >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 3071 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont11cont5Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont11cont5Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 421 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 3087 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			{
															#line 422 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 3091 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			}
															#line 423 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			ASSERT(e.code() == error_code_special_keys_cross_module_read);
															#line 424 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->reset();
															#line 3097 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			loopDepth = a_body1cont11cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont6(Void const& _,int loopDepth) 
	{
															#line 419 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(false);
															#line 3112 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont11cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont6(Void && _,int loopDepth) 
	{
															#line 419 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(false);
															#line 3121 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont11cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose17() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 16, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 16, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont11cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 16, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont11cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 16, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont11cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 16);

	}
	int a_body1cont11cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont11cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont9(int loopDepth) 
	{
		try {
															#line 440 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 441 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_18 = success(tx->getRange(KeyRangeRef("\xff\xff/transaction/"_sr, "\xff\xff/transaction0"_sr), CLIENT_KNOBS->TOO_MANY));
															#line 441 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont11cont9Catch1(actor_cancelled(), loopDepth);
															#line 3223 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_18.isReady()) { if (__when_expr_18.isError()) return a_body1cont11cont9Catch1(__when_expr_18.getError(), loopDepth); else return a_body1cont11cont9when1(__when_expr_18.get(), loopDepth); };
			static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 19;
															#line 441 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_18.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 18, Void >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 3228 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont11cont9Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont11cont9Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont5Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 433 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 3244 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			{
															#line 434 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 3248 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			}
															#line 435 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			ASSERT(e.code() == error_code_special_keys_cross_module_read);
															#line 436 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->reset();
															#line 3254 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			loopDepth = a_body1cont11cont9(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont10(Void const& _,int loopDepth) 
	{
															#line 431 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(false);
															#line 3269 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont11cont10cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont10(Void && _,int loopDepth) 
	{
															#line 431 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(false);
															#line 3278 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont11cont10cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose18() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 17, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 17, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont11cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 17, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont11cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 17, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont11cont5Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 17);

	}
	int a_body1cont11cont10cont2(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont11cont9(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11(int loopDepth) 
	{
		try {
															#line 450 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 451 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_RELAXED);
															#line 452 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			const KeyRef startKey = "\xff\xff/transactio"_sr;
															#line 453 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			const KeyRef endKey = "\xff\xff/transaction1"_sr;
															#line 454 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<RangeResult> __when_expr_19 = tx->getRange(KeyRangeRef(startKey, endKey), GetRangeLimits(CLIENT_KNOBS->TOO_MANY));
															#line 454 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont11cont11Catch1(actor_cancelled(), loopDepth);
															#line 3386 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_19.isReady()) { if (__when_expr_19.isError()) return a_body1cont11cont11Catch1(__when_expr_19.getError(), loopDepth); else return a_body1cont11cont11when1(__when_expr_19.get(), loopDepth); };
			static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 20;
															#line 454 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_19.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 19, RangeResult >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 3391 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont11cont11Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont11cont11Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont9Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 446 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 3407 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont12(Void const& _,int loopDepth) 
	{
															#line 443 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		CODE_PROBE(true, "read transaction special keyrange");
															#line 444 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 3423 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont11cont12cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont12(Void && _,int loopDepth) 
	{
															#line 443 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		CODE_PROBE(true, "read transaction special keyrange");
															#line 444 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 3434 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont11cont12cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose19() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 18, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 18, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1cont11cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont9Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont9Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 18, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1cont11cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont9Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont9Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 18, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1cont11cont9Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont9Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont9Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 18);

	}
	int a_body1cont11cont12cont2(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont11cont11(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont1(int loopDepth) 
	{
		try {
															#line 464 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 465 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->addReadConflictRange(singleKeyRange("testKey"_sr));
															#line 466 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			KeySelector begin = KeySelectorRef(readConflictRangeKeysRange.begin, false, 1);
															#line 467 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			KeySelector end = KeySelectorRef("\xff\xff/transaction0"_sr, false, 0);
															#line 468 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_20 = success(tx->getRange(begin, end, GetRangeLimits(CLIENT_KNOBS->TOO_MANY)));
															#line 468 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont11cont11cont1Catch1(actor_cancelled(), loopDepth);
															#line 3542 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_20.isReady()) { if (__when_expr_20.isError()) return a_body1cont11cont11cont1Catch1(__when_expr_20.getError(), loopDepth); else return a_body1cont11cont11cont1when1(__when_expr_20.get(), loopDepth); };
			static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 21;
															#line 468 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_20.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 20, Void >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 3547 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont11cont11cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont11cont11cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 460 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 3563 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont2(RangeResult const& result,int loopDepth) 
	{
															#line 457 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(!result.size());
															#line 458 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 3579 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont11cont11cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont2(RangeResult && result,int loopDepth) 
	{
															#line 457 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(!result.size());
															#line 458 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 3590 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont11cont11cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11when1(RangeResult const& result,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont2(result, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11when1(RangeResult && result,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont2(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose20() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 19, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 19, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1cont11cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 19);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 19, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1cont11cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont11Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 19);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 19, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1cont11cont11Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 19);

	}
	int a_body1cont11cont11cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont11cont11cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont5(int loopDepth) 
	{
		try {
															#line 476 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 477 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_21 = success(tx->getRange( KeyRangeRef("\xff\xff/A_no_module_related_prefix"_sr, "\xff\xff/I_am_also_not_in_any_module"_sr), CLIENT_KNOBS->TOO_MANY));
															#line 477 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont11cont11cont5Catch1(actor_cancelled(), loopDepth);
															#line 3692 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_21.isReady()) { if (__when_expr_21.isError()) return a_body1cont11cont11cont5Catch1(__when_expr_21.getError(), loopDepth); else return a_body1cont11cont11cont5when1(__when_expr_21.get(), loopDepth); };
			static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 22;
															#line 477 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_21.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 21, Void >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 3697 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont11cont11cont5Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont11cont11cont5Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 472 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 3713 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont6(Void const& _,int loopDepth) 
	{
															#line 469 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		CODE_PROBE(true, "end key selector inside module range");
															#line 470 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 3729 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont11cont11cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont6(Void && _,int loopDepth) 
	{
															#line 469 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		CODE_PROBE(true, "end key selector inside module range");
															#line 470 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 3740 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont11cont11cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose21() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 20, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 20, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose21();
		try {
			a_body1cont11cont11cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 20);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 20, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose21();
		try {
			a_body1cont11cont11cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 20);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 20, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose21();
		try {
			a_body1cont11cont11cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 20);

	}
	int a_body1cont11cont11cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont11cont11cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont9(int loopDepth) 
	{
		try {
															#line 489 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 490 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			KeySelector begin = KeySelectorRef("\xff\xff/zzz_i_am_not_a_module"_sr, false, 1);
															#line 491 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			KeySelector end = KeySelectorRef("\xff\xff/zzz_to_be_the_final_one"_sr, false, 2);
															#line 492 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_22 = success(tx->getRange(begin, end, CLIENT_KNOBS->TOO_MANY));
															#line 492 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont11cont11cont9Catch1(actor_cancelled(), loopDepth);
															#line 3846 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_22.isReady()) { if (__when_expr_22.isError()) return a_body1cont11cont11cont9Catch1(__when_expr_22.getError(), loopDepth); else return a_body1cont11cont11cont9when1(__when_expr_22.get(), loopDepth); };
			static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 23;
															#line 492 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_22.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 22, Void >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 3851 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont11cont11cont9Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont11cont11cont9Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont5Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 482 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 3867 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			{
															#line 483 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 3871 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			}
															#line 484 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			ASSERT(e.code() == error_code_special_keys_no_module_found);
															#line 485 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->reset();
															#line 3877 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			loopDepth = a_body1cont11cont11cont9(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont10(Void const& _,int loopDepth) 
	{
															#line 480 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(false);
															#line 3892 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont11cont11cont10cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont10(Void && _,int loopDepth) 
	{
															#line 480 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(false);
															#line 3901 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont11cont11cont10cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose22() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 21, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 21, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 21);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose22();
		try {
			a_body1cont11cont11cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 21);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 21, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 21);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose22();
		try {
			a_body1cont11cont11cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 21);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 21, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 21);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose22();
		try {
			a_body1cont11cont11cont5Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 21);

	}
	int a_body1cont11cont11cont10cont2(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont11cont11cont9(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11(int loopDepth) 
	{
		try {
															#line 502 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 503 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			const KeyRef key = "\xff\xff/cluster_file_path"_sr;
															#line 504 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			KeySelector begin = KeySelectorRef(key, false, 0);
															#line 505 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			KeySelector end = KeySelectorRef(keyAfter(key), false, 2);
															#line 506 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<RangeResult> __when_expr_23 = tx->getRange(begin, end, GetRangeLimits(CLIENT_KNOBS->TOO_MANY));
															#line 506 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont11cont11cont11Catch1(actor_cancelled(), loopDepth);
															#line 4009 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_23.isReady()) { if (__when_expr_23.isError()) return a_body1cont11cont11cont11Catch1(__when_expr_23.getError(), loopDepth); else return a_body1cont11cont11cont11when1(__when_expr_23.get(), loopDepth); };
			static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 24;
															#line 506 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_23.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 23, RangeResult >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 4014 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont11cont11cont11Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont11cont11cont11Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont9Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 495 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 4030 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			{
															#line 496 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 4034 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			}
															#line 497 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			ASSERT(e.code() == error_code_special_keys_no_module_found);
															#line 498 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->reset();
															#line 4040 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			loopDepth = a_body1cont11cont11cont11(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont12(Void const& _,int loopDepth) 
	{
															#line 493 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(false);
															#line 4055 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont11cont11cont12cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont12(Void && _,int loopDepth) 
	{
															#line 493 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(false);
															#line 4064 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont11cont11cont12cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose23() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 22, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 22, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 22);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose23();
		try {
			a_body1cont11cont11cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont9Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont9Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 22);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 22, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 22);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose23();
		try {
			a_body1cont11cont11cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont9Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont9Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 22);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 22, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 22);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose23();
		try {
			a_body1cont11cont11cont9Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont9Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont9Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 22);

	}
	int a_body1cont11cont11cont12cont2(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont11cont11cont11(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont1(int loopDepth) 
	{
		try {
															#line 513 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 514 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->addReadConflictRange(singleKeyRange("readKey"_sr));
															#line 515 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			const KeyRef key = "\xff\xff/transaction/a_to_be_the_first"_sr;
															#line 516 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			KeySelector begin = KeySelectorRef(key, false, 0);
															#line 517 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			KeySelector end = KeySelectorRef(key, false, 2);
															#line 518 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<RangeResult> __when_expr_24 = tx->getRange(begin, end, GetRangeLimits(CLIENT_KNOBS->TOO_MANY));
															#line 518 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont11cont11cont11cont1Catch1(actor_cancelled(), loopDepth);
															#line 4174 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_24.isReady()) { if (__when_expr_24.isError()) return a_body1cont11cont11cont11cont1Catch1(__when_expr_24.getError(), loopDepth); else return a_body1cont11cont11cont11cont1when1(__when_expr_24.get(), loopDepth); };
			static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 25;
															#line 518 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_24.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 24, RangeResult >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 4179 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont11cont11cont11cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont11cont11cont11cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 510 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 4195 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont2(RangeResult const& result,int loopDepth) 
	{
															#line 507 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(result.readToBegin && result.readThroughEnd);
															#line 508 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 4211 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont11cont11cont11cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont2(RangeResult && result,int loopDepth) 
	{
															#line 507 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(result.readToBegin && result.readThroughEnd);
															#line 508 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 4222 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont11cont11cont11cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont11when1(RangeResult const& result,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont11cont2(result, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont11when1(RangeResult && result,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont11cont2(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose24() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 23, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 23, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 23);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose24();
		try {
			a_body1cont11cont11cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont11Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont11Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 23);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 23, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 23);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose24();
		try {
			a_body1cont11cont11cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont11Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont11Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 23);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 23, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 23);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose24();
		try {
			a_body1cont11cont11cont11Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont11Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont11Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 23);

	}
	int a_body1cont11cont11cont11cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont11cont11cont11cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont5(int loopDepth) 
	{
		try {
															#line 527 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 528 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->set("\xff\xff/I_am_not_a_range_can_be_written"_sr, ValueRef());
															#line 4322 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			loopDepth = a_body1cont11cont11cont11cont11(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont11cont11cont11cont5Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont11cont11cont11cont5Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 522 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 4338 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont6(RangeResult const& result,int loopDepth) 
	{
															#line 519 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(result.readToBegin && !result.readThroughEnd);
															#line 520 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 4354 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont11cont11cont11cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont6(RangeResult && result,int loopDepth) 
	{
															#line 519 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(result.readToBegin && !result.readThroughEnd);
															#line 520 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 4365 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont11cont11cont11cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont1when1(RangeResult const& result,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont11cont6(result, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont1when1(RangeResult && result,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont11cont6(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose25() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 24, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 24, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 24);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose25();
		try {
			a_body1cont11cont11cont11cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont11cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont11cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 24);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 24, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 24);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose25();
		try {
			a_body1cont11cont11cont11cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont11cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont11cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 24);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 24, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 24);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose25();
		try {
			a_body1cont11cont11cont11cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont11cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont11cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 24);

	}
	int a_body1cont11cont11cont11cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont11cont11cont11cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont9(int loopDepth) 
	{
		try {
															#line 537 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 538 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 539 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->set("\xff\xff/I_am_not_a_range_can_be_written"_sr, ValueRef());
															#line 540 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			ASSERT(false);
															#line 4469 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			loopDepth = a_body1cont11cont11cont11cont14(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont11cont11cont11cont9Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont11cont11cont11cont9Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont5Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 530 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 4485 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			{
															#line 531 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 4489 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			}
															#line 532 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			ASSERT(e.code() == error_code_special_keys_write_disabled);
															#line 533 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->reset();
															#line 4495 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			loopDepth = a_body1cont11cont11cont11cont9(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont11(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont11cont11cont11cont9(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont12(int loopDepth) 
	{
		try {
															#line 549 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 550 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 551 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->clear(KeyRangeRef(SpecialKeySpace::getManagementApiCommandRange("exclude").begin, SpecialKeySpace::getManagementApiCommandRange("failed").end));
															#line 553 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			ASSERT(false);
															#line 4530 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			loopDepth = a_body1cont11cont11cont11cont12cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont11cont11cont11cont12Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont11cont11cont11cont12Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont9Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 542 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 4546 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			{
															#line 543 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 4550 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			}
															#line 544 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			ASSERT(e.code() == error_code_special_keys_no_write_module_found);
															#line 545 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->reset();
															#line 4556 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			loopDepth = a_body1cont11cont11cont11cont12(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont14(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont11cont11cont11cont12(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont12cont1(int loopDepth) 
	{
		try {
															#line 562 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 563 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			const KeySelector startKeySelector = KeySelectorRef("\xff\xff/test"_sr, true, -200);
															#line 564 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			const KeySelector endKeySelector = KeySelectorRef("test"_sr, true, -10);
															#line 565 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<RangeResult> __when_expr_25 = tx->getRange(startKeySelector, endKeySelector, GetRangeLimits(CLIENT_KNOBS->TOO_MANY));
															#line 565 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont11cont11cont11cont12cont1Catch1(actor_cancelled(), loopDepth);
															#line 4593 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_25.isReady()) { if (__when_expr_25.isError()) return a_body1cont11cont11cont11cont12cont1Catch1(__when_expr_25.getError(), loopDepth); else return a_body1cont11cont11cont11cont12cont1when1(__when_expr_25.get(), loopDepth); };
			static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 26;
															#line 565 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_25.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 25, RangeResult >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 4598 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont11cont11cont11cont12cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont11cont11cont11cont12cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont12Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 555 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 4614 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			{
															#line 556 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 4618 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			}
															#line 557 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			ASSERT(e.code() == error_code_special_keys_cross_module_clear);
															#line 558 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->reset();
															#line 4624 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			loopDepth = a_body1cont11cont11cont11cont12cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont12cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont11cont11cont11cont12cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont12cont4(int loopDepth) 
	{
		try {
															#line 576 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 577 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<RangeResult> __when_expr_26 = tx->getRange(KeyRangeRef("\xff\xff/worker_interfaces/"_sr, "\xff\xff/worker_interfaces0"_sr), CLIENT_KNOBS->TOO_MANY);
															#line 577 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont11cont11cont11cont12cont4Catch1(actor_cancelled(), loopDepth);
															#line 4657 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_26.isReady()) { if (__when_expr_26.isError()) return a_body1cont11cont11cont11cont12cont4Catch1(__when_expr_26.getError(), loopDepth); else return a_body1cont11cont11cont11cont12cont4when1(__when_expr_26.get(), loopDepth); };
			static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 27;
															#line 577 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_26.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 26, RangeResult >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 4662 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont11cont11cont11cont12cont4Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont11cont11cont11cont12cont4Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont12cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 569 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 4678 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			{
															#line 570 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 4682 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			}
															#line 571 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			ASSERT(e.code() == error_code_key_outside_legal_range);
															#line 572 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->reset();
															#line 4688 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			loopDepth = a_body1cont11cont11cont11cont12cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont12cont5(RangeResult const& result,int loopDepth) 
	{
															#line 567 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(false);
															#line 4703 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont11cont11cont11cont12cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont12cont5(RangeResult && result,int loopDepth) 
	{
															#line 567 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(false);
															#line 4712 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont11cont11cont11cont12cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont12cont1when1(RangeResult const& result,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont11cont12cont5(result, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont12cont1when1(RangeResult && result,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont11cont12cont5(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose26() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 25, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 25, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 25);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose26();
		try {
			a_body1cont11cont11cont11cont12cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont11cont12cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont11cont12cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 25);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 25, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 25);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose26();
		try {
			a_body1cont11cont11cont11cont12cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont11cont12cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont11cont12cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 25);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 25, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 25);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose26();
		try {
			a_body1cont11cont11cont11cont12cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont11cont12cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont11cont12cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 25);

	}
	int a_body1cont11cont11cont11cont12cont7(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont11cont11cont11cont12cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont12cont8(int loopDepth) 
	{
															#line 592 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (!static_cast<TestSpecialKeySpaceErrorsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestSpecialKeySpaceErrorsActorState(); static_cast<TestSpecialKeySpaceErrorsActor*>(this)->destroy(); return 0; }
															#line 4809 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<TestSpecialKeySpaceErrorsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestSpecialKeySpaceErrorsActorState();
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont12cont4Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 589 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_28 = tx->onError(e);
															#line 589 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4824 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_28.isReady()) { if (__when_expr_28.isError()) return a_body1Catch1(__when_expr_28.getError(), loopDepth); else return a_body1cont11cont11cont11cont12cont4Catch1when1(__when_expr_28.get(), loopDepth); };
			static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 29;
															#line 589 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_28.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 28, Void >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 4829 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont12cont9(int loopDepth) 
	{
															#line 581 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (result.size())
															#line 4844 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		{
															#line 582 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			entry = deterministicRandom()->randomChoice(result);
															#line 583 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_27 = tx->get(entry.key);
															#line 583 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont11cont11cont11cont12cont4Catch1(actor_cancelled(), loopDepth);
															#line 4852 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_27.isReady()) { if (__when_expr_27.isError()) return a_body1cont11cont11cont11cont12cont4Catch1(__when_expr_27.getError(), loopDepth); else return a_body1cont11cont11cont11cont12cont9when1(__when_expr_27.get(), loopDepth); };
			static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 28;
															#line 583 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_27.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 27, Optional<Value> >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 4857 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont11cont11cont11cont12cont10(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont12cont4when1(RangeResult const& __result,int loopDepth) 
	{
															#line 577 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		result = __result;
															#line 4871 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont11cont11cont11cont12cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont12cont4when1(RangeResult && __result,int loopDepth) 
	{
		result = std::move(__result);
		loopDepth = a_body1cont11cont11cont11cont12cont9(loopDepth);

		return loopDepth;
	}
	void a_exitChoose27() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 26, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 26, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 26);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose27();
		try {
			a_body1cont11cont11cont11cont12cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont11cont12cont4Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont11cont12cont4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 26);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 26, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 26);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose27();
		try {
			a_body1cont11cont11cont11cont12cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont11cont12cont4Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont11cont12cont4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 26);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 26, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 26);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose27();
		try {
			a_body1cont11cont11cont11cont12cont4Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont11cont12cont4Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont11cont12cont4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 26);

	}
	int a_body1cont11cont11cont11cont12cont10(int loopDepth) 
	{
															#line 587 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 4950 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont11cont11cont11cont12cont10cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont12cont11(Optional<Value> const& singleRes,int loopDepth) 
	{
															#line 584 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (singleRes.present())
															#line 4959 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		{
															#line 585 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			ASSERT(singleRes.get() == entry.value);
															#line 4963 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont11cont11cont11cont12cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont12cont11(Optional<Value> && singleRes,int loopDepth) 
	{
															#line 584 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (singleRes.present())
															#line 4973 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		{
															#line 585 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			ASSERT(singleRes.get() == entry.value);
															#line 4977 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont11cont11cont11cont12cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont12cont9when1(Optional<Value> const& singleRes,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont11cont12cont11(singleRes, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont12cont9when1(Optional<Value> && singleRes,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont11cont12cont11(std::move(singleRes), loopDepth);

		return loopDepth;
	}
	void a_exitChoose28() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 27, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 27, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 27);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose28();
		try {
			a_body1cont11cont11cont11cont12cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont11cont12cont4Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont11cont12cont4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 27);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 27, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 27);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose28();
		try {
			a_body1cont11cont11cont11cont12cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont11cont12cont4Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont11cont12cont4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 27);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 27, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 27);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose28();
		try {
			a_body1cont11cont11cont11cont12cont4Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont11cont12cont4Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont11cont12cont4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 27);

	}
	int a_body1cont11cont11cont11cont12cont10cont2(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont11cont11cont11cont12cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont12cont4Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont11cont12cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont12cont4Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont11cont12cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont12cont4Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont11cont12cont4Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont12cont4Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont11cont12cont4Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose29() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 28, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 28, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 28);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose29();
		try {
			a_body1cont11cont11cont11cont12cont4Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 28);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 28, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 28);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose29();
		try {
			a_body1cont11cont11cont11cont12cont4Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 28);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 28, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 28);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose29();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 28);

	}
															#line 316 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	Database cx_;
															#line 316 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	SpecialKeySpaceCorrectnessWorkload* self;
															#line 317 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	Database cx;
															#line 319 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	Reference<ReadYourWritesTransaction> tx;
															#line 320 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	Reference<ReadYourWritesTransaction> defaultTx1;
															#line 321 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	Reference<ReadYourWritesTransaction> defaultTx2;
															#line 322 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	bool disableRyw;
															#line 328 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	RangeResult readresult1;
															#line 329 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	RangeResult readresult2;
															#line 330 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	RangeResult writeResult1;
															#line 331 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	RangeResult writeResult2;
															#line 372 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	Error err;
															#line 378 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	RangeResult readConflictRange;
															#line 380 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	RangeResult writeConflictRange;
															#line 382 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	RangeResult conflictKeys;
															#line 577 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	RangeResult result;
															#line 582 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	KeyValueRef entry;
															#line 5192 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via testSpecialKeySpaceErrors()
															#line 316 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
class TestSpecialKeySpaceErrorsActor final : public Actor<Void>, public ActorCallback< TestSpecialKeySpaceErrorsActor, 0, Void >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 1, Void >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 2, Void >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 3, Void >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 4, Void >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 5, Void >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 6, Void >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 7, Void >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 8, Void >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 9, Void >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 10, Void >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 11, RangeResult >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 12, RangeResult >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 13, RangeResult >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 14, Void >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 15, Void >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 16, Void >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 17, Void >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 18, Void >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 19, RangeResult >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 20, Void >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 21, Void >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 22, Void >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 23, RangeResult >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 24, RangeResult >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 25, RangeResult >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 26, RangeResult >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 27, Optional<Value> >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 28, Void >, public FastAllocated<TestSpecialKeySpaceErrorsActor>, public TestSpecialKeySpaceErrorsActorState<TestSpecialKeySpaceErrorsActor> {
															#line 5197 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<TestSpecialKeySpaceErrorsActor>::operator new;
	using FastAllocated<TestSpecialKeySpaceErrorsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11630942216253874176UL, 1505450777231126784UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 0, Void >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 1, Void >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 2, Void >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 3, Void >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 4, Void >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 5, Void >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 6, Void >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 7, Void >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 8, Void >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 9, Void >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 10, Void >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 11, RangeResult >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 12, RangeResult >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 13, RangeResult >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 14, Void >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 15, Void >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 16, Void >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 17, Void >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 18, Void >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 19, RangeResult >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 20, Void >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 21, Void >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 22, Void >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 23, RangeResult >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 24, RangeResult >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 25, RangeResult >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 26, RangeResult >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 27, Optional<Value> >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 28, Void >;
															#line 316 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	TestSpecialKeySpaceErrorsActor(Database const& cx_,SpecialKeySpaceCorrectnessWorkload* const& self) 
															#line 5242 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TestSpecialKeySpaceErrorsActorState<TestSpecialKeySpaceErrorsActor>(cx_, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5687135045384554752UL, 8946962685745539072UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testSpecialKeySpaceErrors");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 11, RangeResult >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 12, RangeResult >*)0, actor_cancelled()); break;
		case 14: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 13, RangeResult >*)0, actor_cancelled()); break;
		case 15: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 14, Void >*)0, actor_cancelled()); break;
		case 16: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 15, Void >*)0, actor_cancelled()); break;
		case 17: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 16, Void >*)0, actor_cancelled()); break;
		case 18: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 17, Void >*)0, actor_cancelled()); break;
		case 19: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 18, Void >*)0, actor_cancelled()); break;
		case 20: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 19, RangeResult >*)0, actor_cancelled()); break;
		case 21: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 20, Void >*)0, actor_cancelled()); break;
		case 22: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 21, Void >*)0, actor_cancelled()); break;
		case 23: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 22, Void >*)0, actor_cancelled()); break;
		case 24: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 23, RangeResult >*)0, actor_cancelled()); break;
		case 25: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 24, RangeResult >*)0, actor_cancelled()); break;
		case 26: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 25, RangeResult >*)0, actor_cancelled()); break;
		case 27: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 26, RangeResult >*)0, actor_cancelled()); break;
		case 28: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 27, Optional<Value> >*)0, actor_cancelled()); break;
		case 29: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 28, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 316 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
[[nodiscard]] Future<Void> testSpecialKeySpaceErrors( Database const& cx_, SpecialKeySpaceCorrectnessWorkload* const& self ) {
															#line 316 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	return Future<Void>(new TestSpecialKeySpaceErrorsActor(cx_, self));
															#line 5302 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
}

#line 594 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"

																#line 5307 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via testConflictRanges()
															#line 595 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
template <class TestConflictRangesActor>
															#line 595 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
class TestConflictRangesActorState {
															#line 5313 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
public:
															#line 595 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	TestConflictRangesActorState(Database const& cx_,bool const& read,SpecialKeySpaceCorrectnessWorkload* const& self) 
															#line 595 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
															#line 595 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		 : cx_(cx_),
															#line 595 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		   read(read),
															#line 595 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		   self(self),
															#line 596 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		   prefix(read ? readConflictRangeKeysRange.begin : writeConflictRangeKeysRange.begin)
															#line 5326 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("testConflictRanges", reinterpret_cast<unsigned long>(this));

	}
	~TestConflictRangesActorState() 
	{
		fdb_probe_actor_destroy("testConflictRanges", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 597 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			CODE_PROBE(read, "test read conflict range special key implementation");
															#line 598 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			CODE_PROBE(!read, "test write conflict range special key implementation");
															#line 600 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			Database cx = cx_->clone();
															#line 601 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx = makeReference<ReadYourWritesTransaction>(cx);
															#line 602 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			referenceTx = makeReference<ReadYourWritesTransaction>(cx);
															#line 603 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			ryw = deterministicRandom()->coinflip();
															#line 604 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 605 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (!ryw)
															#line 5355 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			{
															#line 606 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				tx->setOption(FDBTransactionOptions::READ_YOUR_WRITES_DISABLE);
															#line 5359 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			}
															#line 608 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			referenceTx->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 609 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			referenceTx->setVersion(100);
															#line 610 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			referenceTx->clear(normalKeys);
															#line 611 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			int numKeys = deterministicRandom()->randomInt(1, self->conflictRangeSizeFactor) * 4;
															#line 612 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			keys = std::vector<std::string>();
															#line 613 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			keys.resize(numKeys);
															#line 614 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			int lastKey = 0;
															#line 615 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			for( auto& key : keys ) {
															#line 616 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				key = std::to_string(lastKey++);
															#line 5379 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			}
															#line 618 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (deterministicRandom()->coinflip())
															#line 5383 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			{
															#line 620 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				keys.push_back("");
															#line 5387 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			}
															#line 622 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (deterministicRandom()->coinflip())
															#line 5391 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			{
															#line 624 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				keys.push_back("\xff");
															#line 5395 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			}
															#line 626 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			std::mt19937 g(deterministicRandom()->randomUInt32());
															#line 627 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			std::shuffle(keys.begin(), keys.end(), g);
															#line 630 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			std::sort(keys.begin(), keys.begin() + keys.size() / 2);
															#line 631 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			for(auto iter = keys.begin();iter + 1 < keys.begin() + keys.size() / 2;iter += 2) {
															#line 632 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				Standalone<KeyRangeRef> range = KeyRangeRef(*iter, *(iter + 1));
															#line 633 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				if (read)
															#line 5409 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
				{
															#line 634 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
					tx->addReadConflictRange(range);
															#line 636 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
					tx->addReadConflictRange(range);
															#line 5415 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
				}
				else
				{
															#line 638 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
					tx->addWriteConflictRange(range);
															#line 639 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
					tx->addWriteConflictRange(range);
															#line 5423 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
				}
															#line 642 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				referenceTx->set(range.begin, "1"_sr);
															#line 643 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				referenceTx->set(range.end, "0"_sr);
															#line 5429 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			}
															#line 645 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (!read && deterministicRandom()->coinflip())
															#line 5433 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			{
				try {
															#line 647 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
					StrictFuture<Void> __when_expr_0 = tx->commit();
															#line 647 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
					if (static_cast<TestConflictRangesActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 5440 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<TestConflictRangesActor*>(this)->actor_wait_state = 1;
															#line 647 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestConflictRangesActor, 0, Void >*>(static_cast<TestConflictRangesActor*>(this)));
															#line 5445 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				catch (Error& error) {
					loopDepth = a_body1Catch2(error, loopDepth);
				} catch (...) {
					loopDepth = a_body1Catch2(unknown_error(), loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestConflictRangesActorState();
		static_cast<TestConflictRangesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
		try {
															#line 656 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_1 = success(tx->get("\xff\xff/1314109/i_hope_this_isn't_registered"_sr));
															#line 656 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<TestConflictRangesActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 5482 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TestConflictRangesActor*>(this)->actor_wait_state = 2;
															#line 656 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestConflictRangesActor, 1, Void >*>(static_cast<TestConflictRangesActor*>(this)));
															#line 5487 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont9(int loopDepth) 
	{
															#line 653 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		CODE_PROBE(true, "Read write conflict range of committed transaction");
															#line 5502 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 649 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 5512 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			{
															#line 650 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 5516 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			}
															#line 651 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (!static_cast<TestConflictRangesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestConflictRangesActorState(); static_cast<TestConflictRangesActor*>(this)->destroy(); return 0; }
															#line 5520 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			new (&static_cast<TestConflictRangesActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~TestConflictRangesActorState();
			static_cast<TestConflictRangesActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestConflictRangesActor*>(this)->actor_wait_state > 0) static_cast<TestConflictRangesActor*>(this)->actor_wait_state = 0;
		static_cast<TestConflictRangesActor*>(this)->ActorCallback< TestConflictRangesActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestConflictRangesActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testConflictRanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestConflictRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testConflictRanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestConflictRangesActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testConflictRanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestConflictRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testConflictRanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestConflictRangesActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testConflictRanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestConflictRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testConflictRanges", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont10cont1(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont9(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12(int loopDepth) 
	{
															#line 663 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		for(int i = 0;i < self->conflictRangeSizeFactor;++i) {
															#line 664 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			GetRangeLimits limit;
															#line 665 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			KeySelector begin;
															#line 666 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			KeySelector end;
															#line 667 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			for(;;) {
															#line 668 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				begin = firstGreaterOrEqual(deterministicRandom()->randomChoice(keys));
															#line 669 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				end = firstGreaterOrEqual(deterministicRandom()->randomChoice(keys));
															#line 670 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				if (begin.getKey() < end.getKey())
															#line 5652 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
				{
					break;
				}
			}
															#line 673 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			Reverse reverse{ deterministicRandom()->coinflip() };
															#line 675 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			auto correctResultFuture = referenceTx->getRange(begin, end, limit, Snapshot::False, reverse);
															#line 676 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			ASSERT(correctResultFuture.isReady());
															#line 677 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			begin.setKey(begin.getKey().withPrefix(prefix, begin.arena()));
															#line 678 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			end.setKey(end.getKey().withPrefix(prefix, begin.arena()));
															#line 679 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			auto testResultFuture = tx->getRange(begin, end, limit, Snapshot::False, reverse);
															#line 680 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			ASSERT(testResultFuture.isReady());
															#line 681 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			auto correct_iter = correctResultFuture.get().begin();
															#line 682 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			auto test_iter = testResultFuture.get().begin();
															#line 683 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			bool had_error = false;
															#line 684 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			for(;correct_iter != correctResultFuture.get().end() && test_iter != testResultFuture.get().end();) {
															#line 685 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				if (correct_iter->key != test_iter->key.removePrefix(prefix) || correct_iter->value != test_iter->value)
															#line 5681 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
				{
															#line 687 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
					TraceEvent(SevError, "TestFailure") .detail("Reason", "Mismatched keys") .detail("ConflictType", read ? "read" : "write") .detail("CorrectKey", correct_iter->key) .detail("TestKey", test_iter->key) .detail("CorrectValue", correct_iter->value) .detail("TestValue", test_iter->value) .detail("Begin", begin) .detail("End", end) .detail("Ryw", ryw);
															#line 697 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
					had_error = true;
															#line 698 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
					++self->wrongResults;
															#line 5689 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
				}
															#line 700 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				++correct_iter;
															#line 701 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				++test_iter;
															#line 5695 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			}
															#line 703 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			for(;correct_iter != correctResultFuture.get().end();) {
															#line 704 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				TraceEvent(SevError, "TestFailure") .detail("Reason", "Extra correct key") .detail("ConflictType", read ? "read" : "write") .detail("CorrectKey", correct_iter->key) .detail("CorrectValue", correct_iter->value) .detail("Begin", begin) .detail("End", end) .detail("Ryw", ryw);
															#line 712 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				++correct_iter;
															#line 713 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				had_error = true;
															#line 714 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				++self->wrongResults;
															#line 5707 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			}
															#line 716 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			for(;test_iter != testResultFuture.get().end();) {
															#line 717 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				TraceEvent(SevError, "TestFailure") .detail("Reason", "Extra test key") .detail("ConflictType", read ? "read" : "write") .detail("TestKey", test_iter->key) .detail("TestValue", test_iter->value) .detail("Begin", begin) .detail("End", end) .detail("Ryw", ryw);
															#line 725 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				++test_iter;
															#line 726 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				had_error = true;
															#line 727 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				++self->wrongResults;
															#line 5719 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			}
															#line 729 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (had_error)
															#line 5723 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			{
				break;
			}
		}
															#line 732 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (!static_cast<TestConflictRangesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestConflictRangesActorState(); static_cast<TestConflictRangesActor*>(this)->destroy(); return 0; }
															#line 5730 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<TestConflictRangesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestConflictRangesActorState();
		static_cast<TestConflictRangesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 659 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 5743 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			{
															#line 660 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 5747 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			}
															#line 661 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			ASSERT(e.code() == error_code_special_keys_no_module_found);
															#line 5751 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			loopDepth = a_body1cont12(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont13(Void const& _,int loopDepth) 
	{
															#line 657 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(false);
															#line 5766 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont13cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont13(Void && _,int loopDepth) 
	{
															#line 657 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(false);
															#line 5775 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont13cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont13(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont13(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestConflictRangesActor*>(this)->actor_wait_state > 0) static_cast<TestConflictRangesActor*>(this)->actor_wait_state = 0;
		static_cast<TestConflictRangesActor*>(this)->ActorCallback< TestConflictRangesActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestConflictRangesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testConflictRanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestConflictRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testConflictRanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestConflictRangesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testConflictRanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestConflictRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testConflictRanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestConflictRangesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testConflictRanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestConflictRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testConflictRanges", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont13cont2(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont12(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 595 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	Database cx_;
															#line 595 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	bool read;
															#line 595 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	SpecialKeySpaceCorrectnessWorkload* self;
															#line 596 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	StringRef prefix;
															#line 601 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	Reference<ReadYourWritesTransaction> tx;
															#line 602 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	Reference<ReadYourWritesTransaction> referenceTx;
															#line 603 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	bool ryw;
															#line 612 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	std::vector<std::string> keys;
															#line 5884 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via testConflictRanges()
															#line 595 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
class TestConflictRangesActor final : public Actor<Void>, public ActorCallback< TestConflictRangesActor, 0, Void >, public ActorCallback< TestConflictRangesActor, 1, Void >, public FastAllocated<TestConflictRangesActor>, public TestConflictRangesActorState<TestConflictRangesActor> {
															#line 5889 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<TestConflictRangesActor>::operator new;
	using FastAllocated<TestConflictRangesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13568543405793798144UL, 13204391296558129408UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestConflictRangesActor, 0, Void >;
friend struct ActorCallback< TestConflictRangesActor, 1, Void >;
															#line 595 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	TestConflictRangesActor(Database const& cx_,bool const& read,SpecialKeySpaceCorrectnessWorkload* const& self) 
															#line 5907 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TestConflictRangesActorState<TestConflictRangesActor>(cx_, read, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testConflictRanges", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15893482590276846336UL, 2356409910050837504UL);
		ActorExecutionContextHelper __helper(static_cast<TestConflictRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testConflictRanges");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testConflictRanges", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestConflictRangesActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestConflictRangesActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 595 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
[[nodiscard]] static Future<Void> testConflictRanges( Database const& cx_, bool const& read, SpecialKeySpaceCorrectnessWorkload* const& self ) {
															#line 595 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	return Future<Void>(new TestConflictRangesActor(cx_, read, self));
															#line 5940 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
}

#line 734 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"

	bool getRangeResultInOrder(const RangeResult& result) {
		for (int i = 0; i < result.size() - 1; ++i) {
			if (result[i].key >= result[i + 1].key) {
				TraceEvent(SevError, "TestFailure")
				    .detail("Reason", "GetRangeResultNotInOrder")
				    .detail("Index", i)
				    .detail("Key1", result[i].key)
				    .detail("Key2", result[i + 1].key);
				return false;
			}
		}
		return true;
	}

																#line 5959 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via managementApiCorrectnessActor()
															#line 749 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
template <class ManagementApiCorrectnessActorActor>
															#line 749 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
class ManagementApiCorrectnessActorActorState {
															#line 5965 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
public:
															#line 749 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	ManagementApiCorrectnessActorActorState(Database const& cx_,SpecialKeySpaceCorrectnessWorkload* const& self) 
															#line 749 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
															#line 749 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		 : cx_(cx_),
															#line 749 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		   self(self),
															#line 751 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		   cx(cx_->clone()),
															#line 752 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		   tx(makeReference<ReadYourWritesTransaction>(cx))
															#line 5978 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this));

	}
	~ManagementApiCorrectnessActorActorState() 
	{
		fdb_probe_actor_destroy("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			{
															#line 756 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				new_cluster_description = std::string();
															#line 757 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				new_coordinator_process = std::string();
															#line 758 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				old_coordinators_processes = std::vector<std::string>();
															#line 759 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				possible_to_add_coordinator = bool();
															#line 760 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				coordinators_key_range = KeyRangeRef("process/"_sr, "process0"_sr) .withPrefix(SpecialKeySpace::getManagementApiCommandPrefix("coordinators"));
															#line 763 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				retries = 0;
															#line 764 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				changeCoordinatorsSucceeded = true;
															#line 765 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				;
															#line 6008 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
				loopDepth = a_body1loopHead1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ManagementApiCorrectnessActorActorState();
		static_cast<ManagementApiCorrectnessActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 939 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		;
															#line 6032 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 806 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		TraceEvent(SevDebug, "CoordinatorsManualChange") .detail("NewCoordinator", possible_to_add_coordinator ? new_coordinator_process : "") .detail("NewClusterDescription", new_cluster_description);
															#line 809 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (possible_to_add_coordinator)
															#line 6043 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		{
															#line 810 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			;
															#line 6047 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			loopDepth = a_body1cont2loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 767 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 768 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tx->get(coordinatorsKey);
															#line 768 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6073 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 1;
															#line 768 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 0, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 6078 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 802 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tx->onError(e);
															#line 802 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6115 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 4;
															#line 802 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 3, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 6120 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& ccStrValue,int loopDepth) 
	{
															#line 769 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(ccStrValue.present());
															#line 770 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ClusterConnectionString ccStr(ccStrValue.get().toString());
															#line 772 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		new_cluster_description = SERVER_KNOBS->ENABLE_CROSS_CLUSTER_SUPPORT ? deterministicRandom()->randomAlphaNumeric(8) : ccStr.clusterKeyName().toString();
															#line 776 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_1 = tx->get( "processes"_sr.withPrefix(SpecialKeySpace::getManagementApiCommandPrefix("coordinators")));
															#line 776 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6143 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 2;
															#line 776 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 1, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 6148 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && ccStrValue,int loopDepth) 
	{
															#line 769 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(ccStrValue.present());
															#line 770 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ClusterConnectionString ccStr(ccStrValue.get().toString());
															#line 772 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		new_cluster_description = SERVER_KNOBS->ENABLE_CROSS_CLUSTER_SUPPORT ? deterministicRandom()->randomAlphaNumeric(8) : ccStr.clusterKeyName().toString();
															#line 776 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_1 = tx->get( "processes"_sr.withPrefix(SpecialKeySpace::getManagementApiCommandPrefix("coordinators")));
															#line 776 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6165 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 2;
															#line 776 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 1, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 6170 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& ccStrValue,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(ccStrValue, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && ccStrValue,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(ccStrValue), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Optional<Value> const& processes_key,int loopDepth) 
	{
															#line 778 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(processes_key.present());
															#line 779 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		boost::split( old_coordinators_processes, processes_key.get().toString(), [](char c) { return c == ','; });
															#line 782 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<std::vector<ProcessData>> __when_expr_2 = getWorkers(&tx->getTransaction());
															#line 782 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6260 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 3;
															#line 782 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 2, std::vector<ProcessData> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 6265 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Optional<Value> && processes_key,int loopDepth) 
	{
															#line 778 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(processes_key.present());
															#line 779 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		boost::split( old_coordinators_processes, processes_key.get().toString(), [](char c) { return c == ','; });
															#line 782 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<std::vector<ProcessData>> __when_expr_2 = getWorkers(&tx->getTransaction());
															#line 782 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6280 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 3;
															#line 782 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 2, std::vector<ProcessData> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 6285 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Optional<Value> const& processes_key,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(processes_key, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Optional<Value> && processes_key,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(processes_key), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(std::vector<ProcessData> const& workers,int loopDepth) 
	{
															#line 783 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		std::string old_coordinators_processes_string = describe(old_coordinators_processes);
															#line 784 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		TraceEvent(SevDebug, "CoordinatorsManualChange") .detail("OldCoordinators", old_coordinators_processes_string) .detail("WorkerSize", workers.size());
															#line 787 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (workers.size() > old_coordinators_processes.size())
															#line 6373 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		{
															#line 788 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			for(;;) {
															#line 789 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				auto worker = deterministicRandom()->randomChoice(workers);
															#line 790 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				new_coordinator_process = worker.address.toString();
															#line 791 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				if (old_coordinators_processes_string.find(new_coordinator_process) == std::string::npos)
															#line 6383 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
				{
					break;
				}
			}
															#line 795 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			possible_to_add_coordinator = true;
															#line 6390 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		}
		else
		{
															#line 797 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			possible_to_add_coordinator = false;
															#line 6396 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		}
															#line 799 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 6400 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont4(std::vector<ProcessData> && workers,int loopDepth) 
	{
															#line 783 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		std::string old_coordinators_processes_string = describe(old_coordinators_processes);
															#line 784 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		TraceEvent(SevDebug, "CoordinatorsManualChange") .detail("OldCoordinators", old_coordinators_processes_string) .detail("WorkerSize", workers.size());
															#line 787 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (workers.size() > old_coordinators_processes.size())
															#line 6413 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		{
															#line 788 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			for(;;) {
															#line 789 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				auto worker = deterministicRandom()->randomChoice(workers);
															#line 790 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				new_coordinator_process = worker.address.toString();
															#line 791 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				if (old_coordinators_processes_string.find(new_coordinator_process) == std::string::npos)
															#line 6423 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
				{
					break;
				}
			}
															#line 795 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			possible_to_add_coordinator = true;
															#line 6430 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		}
		else
		{
															#line 797 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			possible_to_add_coordinator = false;
															#line 6436 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		}
															#line 799 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 6440 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(std::vector<ProcessData> const& workers,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(workers, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(std::vector<ProcessData> && workers,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(workers), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 2, std::vector<ProcessData> >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 2, std::vector<ProcessData> >*,std::vector<ProcessData> const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 2, std::vector<ProcessData> >*,std::vector<ProcessData> && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 2, std::vector<ProcessData> >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 803 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_4 = delay(FLOW_KNOBS->PREVENT_FAST_SPIN_DELAY);
															#line 803 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6526 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1cont1when1(__when_expr_4.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 5;
															#line 803 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 4, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 6531 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 803 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_4 = delay(FLOW_KNOBS->PREVENT_FAST_SPIN_DELAY);
															#line 803 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6542 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1cont1when1(__when_expr_4.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 5;
															#line 803 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 4, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 6547 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1Catch1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(int loopDepth) 
	{
		try {
															#line 867 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 868 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_9 = tx->get(coordinatorsKey);
															#line 868 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont4Catch1(actor_cancelled(), loopDepth);
															#line 6729 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont4Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont4when1(__when_expr_9.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 10;
															#line 868 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 9, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 6734 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont4Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont4Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
		try {
															#line 812 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			std::string new_processes_key(new_coordinator_process);
															#line 813 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 814 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 815 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			for( const auto& address : old_coordinators_processes ) {
															#line 816 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				new_processes_key += "," + address;
															#line 6765 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			}
															#line 818 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->set( "processes"_sr.withPrefix(SpecialKeySpace::getManagementApiCommandPrefix("coordinators")), Value(new_processes_key));
															#line 822 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->set("cluster_description"_sr.withPrefix( SpecialKeySpace::getManagementApiCommandPrefix("coordinators")), Value(new_cluster_description));
															#line 825 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_5 = tx->commit();
															#line 825 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6775 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont2loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont2loopBody1when1(__when_expr_5.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 6;
															#line 825 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 5, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 6780 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 828 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			TraceEvent(SevDebug, "CoordinatorsManualChange").error(e);
															#line 831 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (e.code() == error_code_special_keys_api_failure)
															#line 6817 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			{
															#line 832 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				StrictFuture<Optional<Value>> __when_expr_6 = tx->get(SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::ERRORMSG).begin);
															#line 832 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6823 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
				if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1Catch1when1(__when_expr_6.get(), loopDepth); };
				static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 7;
															#line 832 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 6, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 6828 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 860 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				StrictFuture<Void> __when_expr_7 = tx->onError(e);
															#line 860 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6837 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
				if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1Catch1when2(__when_expr_7.get(), loopDepth); };
				static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 8;
															#line 860 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 7, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 6842 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 826 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(false);
															#line 6858 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 826 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(false);
															#line 6867 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont2loopBody1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont2loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1cont1(int loopDepth) 
	{
															#line 862 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_8 = delay(FLOW_KNOBS->PREVENT_FAST_SPIN_DELAY);
															#line 862 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6966 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1Catch1cont1when1(__when_expr_8.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 9;
															#line 862 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 8, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 6971 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1cont2(Optional<Value> const& errorMsg,int loopDepth) 
	{
															#line 834 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(errorMsg.present());
															#line 835 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		std::string errorStr;
															#line 836 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto valueObj = readJSONStrictly(errorMsg.get().toString()).get_obj();
															#line 837 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto schema = readJSONStrictly(JSONSchemas::managementApiErrorSchema.toString()).get_obj();
															#line 839 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(schemaMatch(schema, valueObj, errorStr, SevError, true));
															#line 840 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		TraceEvent(SevDebug, "CoordinatorsManualChange") .detail("ErrorMessage", valueObj["message"].get_str());
															#line 842 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(valueObj["command"].get_str() == "coordinators");
															#line 843 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (valueObj["retriable"].get_bool())
															#line 6994 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		{
															#line 844 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (++retries >= 10)
															#line 6998 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			{
															#line 845 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				CODE_PROBE( true, "ChangeCoordinators Exceeded retry limit", probe::decoration::rare);
															#line 847 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				changeCoordinatorsSucceeded = false;
															#line 848 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				tx->reset();
															#line 7006 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
				return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
			}
															#line 851 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->reset();
															#line 7011 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		}
		else
		{
															#line 853 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			ASSERT(valueObj["message"].get_str() == "No change (existing configuration satisfies request)");
															#line 855 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->reset();
															#line 856 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			CODE_PROBE(true, "Successfully changed coordinators");
															#line 7021 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1cont2loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1cont2(Optional<Value> && errorMsg,int loopDepth) 
	{
															#line 834 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(errorMsg.present());
															#line 835 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		std::string errorStr;
															#line 836 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto valueObj = readJSONStrictly(errorMsg.get().toString()).get_obj();
															#line 837 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto schema = readJSONStrictly(JSONSchemas::managementApiErrorSchema.toString()).get_obj();
															#line 839 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(schemaMatch(schema, valueObj, errorStr, SevError, true));
															#line 840 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		TraceEvent(SevDebug, "CoordinatorsManualChange") .detail("ErrorMessage", valueObj["message"].get_str());
															#line 842 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(valueObj["command"].get_str() == "coordinators");
															#line 843 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (valueObj["retriable"].get_bool())
															#line 7046 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		{
															#line 844 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (++retries >= 10)
															#line 7050 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			{
															#line 845 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				CODE_PROBE( true, "ChangeCoordinators Exceeded retry limit", probe::decoration::rare);
															#line 847 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				changeCoordinatorsSucceeded = false;
															#line 848 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				tx->reset();
															#line 7058 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
				return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
			}
															#line 851 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->reset();
															#line 7063 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		}
		else
		{
															#line 853 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			ASSERT(valueObj["message"].get_str() == "No change (existing configuration satisfies request)");
															#line 855 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->reset();
															#line 856 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			CODE_PROBE(true, "Successfully changed coordinators");
															#line 7073 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1cont2loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1when1(Optional<Value> const& errorMsg,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont2(errorMsg, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1when1(Optional<Value> && errorMsg,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont2(std::move(errorMsg), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 6, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 6, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont2loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 6, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont2loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 6, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont2loopBody1Catch1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont2loopBody1Catch1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont2loopBody1Catch1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont2loopBody1Catch1cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont2loopBody1Catch1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont2loopBody1Catch1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 891 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		;
															#line 7333 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont5loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 887 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_11 = tx->onError(e);
															#line 887 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7345 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont4Catch1when1(__when_expr_11.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 12;
															#line 887 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 11, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 7350 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6(Optional<Value> const& res,int loopDepth) 
	{
															#line 869 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(res.present());
															#line 870 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ClusterConnectionString csNew(res.get().toString());
															#line 872 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(!changeCoordinatorsSucceeded || new_cluster_description == csNew.clusterKeyName().toString());
															#line 874 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(!changeCoordinatorsSucceeded || csNew.hostnames.size() + csNew.coords.size() == old_coordinators_processes.size() + 1);
															#line 876 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<std::vector<NetworkAddress>> __when_expr_10 = csNew.tryResolveHostnames();
															#line 876 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont4Catch1(actor_cancelled(), loopDepth);
															#line 7375 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1cont4Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont6when1(__when_expr_10.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 11;
															#line 876 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 10, std::vector<NetworkAddress> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 7380 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Optional<Value> && res,int loopDepth) 
	{
															#line 869 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(res.present());
															#line 870 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ClusterConnectionString csNew(res.get().toString());
															#line 872 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(!changeCoordinatorsSucceeded || new_cluster_description == csNew.clusterKeyName().toString());
															#line 874 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(!changeCoordinatorsSucceeded || csNew.hostnames.size() + csNew.coords.size() == old_coordinators_processes.size() + 1);
															#line 876 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<std::vector<NetworkAddress>> __when_expr_10 = csNew.tryResolveHostnames();
															#line 876 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont4Catch1(actor_cancelled(), loopDepth);
															#line 7399 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1cont4Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont6when1(__when_expr_10.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 11;
															#line 876 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 10, std::vector<NetworkAddress> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 7404 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(Optional<Value> const& res,int loopDepth) 
	{
		loopDepth = a_body1cont6(res, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Optional<Value> && res,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 9, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 9, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont4Catch1(error, 0);
		} catch (...) {
			a_body1cont4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 9, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont4Catch1(error, 0);
		} catch (...) {
			a_body1cont4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 9, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont4Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont4Catch1(error, 0);
		} catch (...) {
			a_body1cont4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont7(std::vector<NetworkAddress> const& newCoordinators,int loopDepth) 
	{
															#line 878 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		for( const auto& network_address : newCoordinators ) {
															#line 879 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			std::string address_str = network_address.toString();
															#line 880 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			ASSERT(std::find(old_coordinators_processes.begin(), old_coordinators_processes.end(), address_str) != old_coordinators_processes.end() || new_coordinator_process == address_str);
															#line 7492 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		}
															#line 885 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 7496 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(std::vector<NetworkAddress> && newCoordinators,int loopDepth) 
	{
															#line 878 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		for( const auto& network_address : newCoordinators ) {
															#line 879 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			std::string address_str = network_address.toString();
															#line 880 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			ASSERT(std::find(old_coordinators_processes.begin(), old_coordinators_processes.end(), address_str) != old_coordinators_processes.end() || new_coordinator_process == address_str);
															#line 7509 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		}
															#line 885 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 7513 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(std::vector<NetworkAddress> const& newCoordinators,int loopDepth) 
	{
		loopDepth = a_body1cont7(newCoordinators, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(std::vector<NetworkAddress> && newCoordinators,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(newCoordinators), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 10, std::vector<NetworkAddress> >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 10, std::vector<NetworkAddress> >*,std::vector<NetworkAddress> const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont4Catch1(error, 0);
		} catch (...) {
			a_body1cont4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 10, std::vector<NetworkAddress> >*,std::vector<NetworkAddress> && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont4Catch1(error, 0);
		} catch (...) {
			a_body1cont4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 10, std::vector<NetworkAddress> >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont4Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont4Catch1(error, 0);
		} catch (...) {
			a_body1cont4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 888 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_12 = delay(FLOW_KNOBS->PREVENT_FAST_SPIN_DELAY);
															#line 888 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7612 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch1(__when_expr_12.getError(), loopDepth); else return a_body1cont4Catch1cont1when1(__when_expr_12.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 13;
															#line 888 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 12, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 7617 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4Catch1cont1(Void && _,int loopDepth) 
	{
															#line 888 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_12 = delay(FLOW_KNOBS->PREVENT_FAST_SPIN_DELAY);
															#line 888 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7628 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch1(__when_expr_12.getError(), loopDepth); else return a_body1cont4Catch1cont1when1(__when_expr_12.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 13;
															#line 888 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 12, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 7633 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont4Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont4Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1cont4Catch1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont4Catch1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont4Catch1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4Catch1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 12, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 12, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont4Catch1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 12, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont4Catch1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 12, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 12);

	}
	int a_body1cont11(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont5loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1(int loopDepth) 
	{
															#line 891 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (!(changeCoordinatorsSucceeded))
															#line 7817 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		{
			return a_body1cont5break1(loopDepth==0?0:loopDepth-1); // break
		}
		try {
															#line 893 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			std::string new_processes_key;
															#line 894 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 895 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 896 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			for( const auto& address : old_coordinators_processes ) {
															#line 897 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				new_processes_key += new_processes_key.size() ? "," : "";
															#line 898 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				new_processes_key += address;
															#line 7834 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			}
															#line 900 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->set( "processes"_sr.withPrefix(SpecialKeySpace::getManagementApiCommandPrefix("coordinators")), Value(new_processes_key));
															#line 903 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_13 = tx->commit();
															#line 903 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont5loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7842 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1cont5loopBody1Catch1(__when_expr_13.getError(), loopDepth); else return a_body1cont5loopBody1when1(__when_expr_13.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 14;
															#line 903 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 13, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 7847 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont5loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont5loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5break1(int loopDepth) 
	{
		try {
			return a_body1cont11(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont5loopHead1(0);

		return loopDepth;
	}
	int a_body1cont5loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 906 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			TraceEvent(SevDebug, "CoordinatorsManualChangeRevert").error(e);
															#line 907 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (e.code() == error_code_special_keys_api_failure)
															#line 7884 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			{
															#line 908 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				StrictFuture<Optional<Value>> __when_expr_14 = tx->get(SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::ERRORMSG).begin);
															#line 908 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7890 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
				if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1Catch1(__when_expr_14.getError(), std::max(0, loopDepth - 1)); else return a_body1cont5loopBody1Catch1when1(__when_expr_14.get(), loopDepth); };
				static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 15;
															#line 908 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 14, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 7895 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 931 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				StrictFuture<Void> __when_expr_15 = tx->onError(e);
															#line 931 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7904 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
				if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1Catch1(__when_expr_15.getError(), std::max(0, loopDepth - 1)); else return a_body1cont5loopBody1Catch1when2(__when_expr_15.get(), loopDepth); };
				static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 16;
															#line 931 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				__when_expr_15.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 15, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 7909 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont5loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 904 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(false);
															#line 7925 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont5loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 904 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(false);
															#line 7934 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont5loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose14() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 13, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 13, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont5loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont5loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont5loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 13, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont5loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont5loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont5loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 13, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont5loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont5loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont5loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 13);

	}
	int a_body1cont5loopBody1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont5loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont5loopBody1Catch1cont1(int loopDepth) 
	{
															#line 933 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_16 = delay(FLOW_KNOBS->PREVENT_FAST_SPIN_DELAY);
															#line 933 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8033 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_16.isReady()) { if (__when_expr_16.isError()) return a_body1Catch1(__when_expr_16.getError(), std::max(0, loopDepth - 1)); else return a_body1cont5loopBody1Catch1cont1when1(__when_expr_16.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 17;
															#line 933 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_16.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 16, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 8038 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5loopBody1Catch1cont2(Optional<Value> const& errorMsg,int loopDepth) 
	{
															#line 910 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(errorMsg.present());
															#line 911 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		std::string errorStr;
															#line 912 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto valueObj = readJSONStrictly(errorMsg.get().toString()).get_obj();
															#line 913 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto schema = readJSONStrictly(JSONSchemas::managementApiErrorSchema.toString()).get_obj();
															#line 915 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(schemaMatch(schema, valueObj, errorStr, SevError, true));
															#line 916 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		TraceEvent(SevDebug, "CoordinatorsManualChangeRevert") .detail("ErrorMessage", valueObj["message"].get_str());
															#line 918 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(valueObj["command"].get_str() == "coordinators");
															#line 919 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (valueObj["retriable"].get_bool())
															#line 8061 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		{
															#line 920 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->reset();
															#line 8065 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		}
		else
		{
															#line 921 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (valueObj["message"].get_str() == "No change (existing configuration satisfies request)")
															#line 8071 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			{
															#line 923 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				tx->reset();
															#line 8075 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
				return a_body1cont5break1(loopDepth==0?0:loopDepth-1); // break
			}
			else
			{
															#line 926 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				TraceEvent(SevError, "CoordinatorsManualChangeRevert") .detail("UnexpectedError", valueObj["message"].get_str());
															#line 928 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				return a_body1Catch1(special_keys_api_failure(), std::max(0, loopDepth - 1));
															#line 8084 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			}
		}
		loopDepth = a_body1cont5loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1Catch1cont2(Optional<Value> && errorMsg,int loopDepth) 
	{
															#line 910 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(errorMsg.present());
															#line 911 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		std::string errorStr;
															#line 912 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto valueObj = readJSONStrictly(errorMsg.get().toString()).get_obj();
															#line 913 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto schema = readJSONStrictly(JSONSchemas::managementApiErrorSchema.toString()).get_obj();
															#line 915 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(schemaMatch(schema, valueObj, errorStr, SevError, true));
															#line 916 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		TraceEvent(SevDebug, "CoordinatorsManualChangeRevert") .detail("ErrorMessage", valueObj["message"].get_str());
															#line 918 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(valueObj["command"].get_str() == "coordinators");
															#line 919 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (valueObj["retriable"].get_bool())
															#line 8109 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		{
															#line 920 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->reset();
															#line 8113 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		}
		else
		{
															#line 921 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (valueObj["message"].get_str() == "No change (existing configuration satisfies request)")
															#line 8119 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			{
															#line 923 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				tx->reset();
															#line 8123 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
				return a_body1cont5break1(loopDepth==0?0:loopDepth-1); // break
			}
			else
			{
															#line 926 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				TraceEvent(SevError, "CoordinatorsManualChangeRevert") .detail("UnexpectedError", valueObj["message"].get_str());
															#line 928 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				return a_body1Catch1(special_keys_api_failure(), std::max(0, loopDepth - 1));
															#line 8132 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			}
		}
		loopDepth = a_body1cont5loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1Catch1when1(Optional<Value> const& errorMsg,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1Catch1cont2(errorMsg, loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1Catch1when1(Optional<Value> && errorMsg,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1Catch1cont2(std::move(errorMsg), loopDepth);

		return loopDepth;
	}
	void a_exitChoose15() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 14, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 14, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont5loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 14, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont5loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 14, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 14);

	}
	int a_body1cont5loopBody1Catch1cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1Catch1cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1Catch1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1Catch1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1Catch1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1Catch1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose16() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 15, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 15, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont5loopBody1Catch1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 15, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont5loopBody1Catch1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 15, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 15);

	}
	int a_body1cont5loopBody1Catch1cont9(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1Catch1cont9(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1Catch1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1Catch1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1Catch1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1Catch1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose17() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 16, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 16, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont5loopBody1Catch1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 16, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont5loopBody1Catch1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 16, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 16);

	}
	int a_body1cont12(int loopDepth) 
	{
		{
															#line 965 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			;
															#line 8393 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			loopDepth = a_body1cont12loopHead1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 942 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<RangeResult> __when_expr_17 = tx->getRange(SpecialKeySpace::getManagementApiCommandRange("maintenance"), CLIENT_KNOBS->TOO_MANY);
															#line 942 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8413 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_17.isReady()) { if (__when_expr_17.isError()) return a_body1cont1loopBody1Catch1(__when_expr_17.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_17.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 18;
															#line 942 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_17.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 17, RangeResult >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 8418 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont12(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 958 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			TraceEvent(SevDebug, "MaintenanceGet").error(e);
															#line 959 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_19 = tx->onError(e);
															#line 959 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8457 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_19.isReady()) { if (__when_expr_19.isError()) return a_body1Catch1(__when_expr_19.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_19.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 20;
															#line 959 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_19.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 19, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 8462 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(RangeResult const& maintenanceKVs,int loopDepth) 
	{
															#line 945 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(!maintenanceKVs.more && !maintenanceKVs.size());
															#line 947 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<RangeResult> __when_expr_18 = tx->getRange(SpecialKeySpace::getManagementApiCommandRange("datadistribution"), CLIENT_KNOBS->TOO_MANY);
															#line 947 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8481 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_18.isReady()) { if (__when_expr_18.isError()) return a_body1cont1loopBody1Catch1(__when_expr_18.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_18.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 19;
															#line 947 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_18.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 18, RangeResult >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 8486 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(RangeResult && maintenanceKVs,int loopDepth) 
	{
															#line 945 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(!maintenanceKVs.more && !maintenanceKVs.size());
															#line 947 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<RangeResult> __when_expr_18 = tx->getRange(SpecialKeySpace::getManagementApiCommandRange("datadistribution"), CLIENT_KNOBS->TOO_MANY);
															#line 947 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8499 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_18.isReady()) { if (__when_expr_18.isError()) return a_body1cont1loopBody1Catch1(__when_expr_18.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_18.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 19;
															#line 947 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_18.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 18, RangeResult >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 8504 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(RangeResult const& maintenanceKVs,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(maintenanceKVs, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(RangeResult && maintenanceKVs,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(maintenanceKVs), loopDepth);

		return loopDepth;
	}
	void a_exitChoose18() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 17, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 17, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 17, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 17, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 17);

	}
	int a_body1cont1loopBody1cont3(RangeResult const& ddKVs,int loopDepth) 
	{
															#line 950 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(!ddKVs.more && ddKVs.size() == 1);
															#line 951 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(ddKVs[0].key == "mode"_sr.withPrefix(SpecialKeySpace::getManagementApiCommandPrefix("datadistribution")));
															#line 953 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		TraceEvent("DDKVsValue").detail("Value", ddKVs[0].value);
															#line 954 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(ddKVs[0].value == Value(boost::lexical_cast<std::string>(-1)));
															#line 955 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 8596 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(RangeResult && ddKVs,int loopDepth) 
	{
															#line 950 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(!ddKVs.more && ddKVs.size() == 1);
															#line 951 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(ddKVs[0].key == "mode"_sr.withPrefix(SpecialKeySpace::getManagementApiCommandPrefix("datadistribution")));
															#line 953 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		TraceEvent("DDKVsValue").detail("Value", ddKVs[0].value);
															#line 954 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(ddKVs[0].value == Value(boost::lexical_cast<std::string>(-1)));
															#line 955 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 8613 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(RangeResult const& ddKVs,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(ddKVs, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(RangeResult && ddKVs,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(ddKVs), loopDepth);

		return loopDepth;
	}
	void a_exitChoose19() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 18, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 18, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 18, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 18, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 18);

	}
	int a_body1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose20() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 19, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 19, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 19);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 19, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 19);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 19, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 19);

	}
	int a_body1cont12cont1(int loopDepth) 
	{
															#line 1125 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (!static_cast<ManagementApiCorrectnessActorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ManagementApiCorrectnessActorActorState(); static_cast<ManagementApiCorrectnessActorActor*>(this)->destroy(); return 0; }
															#line 8784 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<ManagementApiCorrectnessActorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ManagementApiCorrectnessActorActorState();
		static_cast<ManagementApiCorrectnessActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont12cont2(int loopDepth) 
	{
															#line 1001 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ignoreSSFailuresRetry = 0;
															#line 1002 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		;
															#line 8798 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont12cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont12loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1(int loopDepth) 
	{
		try {
															#line 967 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 968 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 969 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->set(Key(deterministicRandom()->randomAlphaNumeric(8)) .withPrefix(SpecialKeySpace::getManagementApiCommandPrefix("maintenance")), Value(boost::lexical_cast<std::string>(deterministicRandom()->randomInt(1, 100))));
															#line 973 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->set(Key(deterministicRandom()->randomAlphaNumeric(9)) .withPrefix(SpecialKeySpace::getManagementApiCommandPrefix("maintenance")), Value(boost::lexical_cast<std::string>(deterministicRandom()->randomInt(1, 100))));
															#line 976 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_20 = tx->commit();
															#line 976 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont12loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8825 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_20.isReady()) { if (__when_expr_20.isError()) return a_body1cont12loopBody1Catch1(__when_expr_20.getError(), loopDepth); else return a_body1cont12loopBody1when1(__when_expr_20.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 21;
															#line 976 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_20.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 20, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 8830 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont12loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont12loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12break1(int loopDepth) 
	{
		try {
			return a_body1cont12cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont12loopHead1(0);

		return loopDepth;
	}
	int a_body1cont12loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 979 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			TraceEvent(SevDebug, "MaintenanceSetMoreThanOneZone").error(e);
															#line 980 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (e.code() == error_code_special_keys_api_failure)
															#line 8867 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			{
															#line 981 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				StrictFuture<Optional<Value>> __when_expr_21 = tx->get(SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::ERRORMSG).begin);
															#line 981 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8873 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
				if (__when_expr_21.isReady()) { if (__when_expr_21.isError()) return a_body1Catch1(__when_expr_21.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1Catch1when1(__when_expr_21.get(), loopDepth); };
				static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 22;
															#line 981 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				__when_expr_21.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 21, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 8878 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 995 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				StrictFuture<Void> __when_expr_22 = tx->onError(e);
															#line 995 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8887 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
				if (__when_expr_22.isReady()) { if (__when_expr_22.isError()) return a_body1Catch1(__when_expr_22.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1Catch1when2(__when_expr_22.get(), loopDepth); };
				static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 23;
															#line 995 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				__when_expr_22.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 22, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 8892 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont12loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 977 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(false);
															#line 8908 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont12loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 977 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(false);
															#line 8917 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont12loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose21() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 20, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 20, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose21();
		try {
			a_body1cont12loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 20);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 20, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose21();
		try {
			a_body1cont12loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 20);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 20, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose21();
		try {
			a_body1cont12loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 20);

	}
	int a_body1cont12loopBody1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont12loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont12loopBody1Catch1cont1(int loopDepth) 
	{
															#line 997 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_23 = delay(FLOW_KNOBS->PREVENT_FAST_SPIN_DELAY);
															#line 997 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9016 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_23.isReady()) { if (__when_expr_23.isError()) return a_body1Catch1(__when_expr_23.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1Catch1cont1when1(__when_expr_23.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 24;
															#line 997 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_23.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 23, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 9021 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12loopBody1Catch1cont2(Optional<Value> const& errorMsg,int loopDepth) 
	{
															#line 983 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(errorMsg.present());
															#line 984 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		std::string errorStr;
															#line 985 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto valueObj = readJSONStrictly(errorMsg.get().toString()).get_obj();
															#line 986 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto schema = readJSONStrictly(JSONSchemas::managementApiErrorSchema.toString()).get_obj();
															#line 988 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(schemaMatch(schema, valueObj, errorStr, SevError, true));
															#line 989 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(valueObj["command"].get_str() == "maintenance" && !valueObj["retriable"].get_bool());
															#line 990 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		TraceEvent(SevDebug, "MaintenanceSetMoreThanOneZone") .detail("ErrorMessage", valueObj["message"].get_str());
															#line 992 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 9044 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		return a_body1cont12break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont12loopBody1Catch1cont2(Optional<Value> && errorMsg,int loopDepth) 
	{
															#line 983 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(errorMsg.present());
															#line 984 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		std::string errorStr;
															#line 985 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto valueObj = readJSONStrictly(errorMsg.get().toString()).get_obj();
															#line 986 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto schema = readJSONStrictly(JSONSchemas::managementApiErrorSchema.toString()).get_obj();
															#line 988 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(schemaMatch(schema, valueObj, errorStr, SevError, true));
															#line 989 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(valueObj["command"].get_str() == "maintenance" && !valueObj["retriable"].get_bool());
															#line 990 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		TraceEvent(SevDebug, "MaintenanceSetMoreThanOneZone") .detail("ErrorMessage", valueObj["message"].get_str());
															#line 992 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 9067 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		return a_body1cont12break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont12loopBody1Catch1when1(Optional<Value> const& errorMsg,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1Catch1cont2(errorMsg, loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1Catch1when1(Optional<Value> && errorMsg,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1Catch1cont2(std::move(errorMsg), loopDepth);

		return loopDepth;
	}
	void a_exitChoose22() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 21, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 21, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 21);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose22();
		try {
			a_body1cont12loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 21);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 21, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 21);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose22();
		try {
			a_body1cont12loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 21);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 21, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 21);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose22();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 21);

	}
	int a_body1cont12loopBody1Catch1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1Catch1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1Catch1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1Catch1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1Catch1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1Catch1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose23() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 22, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 22, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 22);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose23();
		try {
			a_body1cont12loopBody1Catch1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 22);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 22, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 22);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose23();
		try {
			a_body1cont12loopBody1Catch1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 22);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 22, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 22);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose23();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 22);

	}
	int a_body1cont12loopBody1Catch1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1Catch1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1Catch1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1Catch1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1Catch1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1Catch1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose24() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 23, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 23, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 23);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose24();
		try {
			a_body1cont12loopBody1Catch1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 23);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 23, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 23);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose24();
		try {
			a_body1cont12loopBody1Catch1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 23);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 23, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 23);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose24();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 23);

	}
	int a_body1cont12cont3(int loopDepth) 
	{
															#line 1041 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ddIgnoreValue = DDIgnore::NONE;
															#line 1042 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (deterministicRandom()->coinflip())
															#line 9327 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		{
															#line 1043 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			ddIgnoreValue |= DDIgnore::REBALANCE_READ;
															#line 9331 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		}
															#line 1045 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (deterministicRandom()->coinflip())
															#line 9335 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		{
															#line 1046 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			ddIgnoreValue |= DDIgnore::REBALANCE_DISK;
															#line 9339 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		}
															#line 1048 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		;
															#line 9343 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont12cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont12cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1(int loopDepth) 
	{
		try {
															#line 1004 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 1005 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 1006 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->set(ignoreSSFailuresZoneString.withPrefix( SpecialKeySpace::getManagementApiCommandPrefix("maintenance")), Value(boost::lexical_cast<std::string>(0)));
															#line 1009 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_24 = tx->commit();
															#line 1009 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont12cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9368 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_24.isReady()) { if (__when_expr_24.isError()) return a_body1cont12cont2loopBody1Catch1(__when_expr_24.getError(), loopDepth); else return a_body1cont12cont2loopBody1when1(__when_expr_24.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 25;
															#line 1009 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_24.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 24, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 9373 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont12cont2loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont12cont2loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont12cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont12cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1014 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			TraceEvent(SevDebug, "MaintenanceDDIgnoreSSFailures").error(e);
															#line 1017 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (e.code() == error_code_special_keys_api_failure)
															#line 9410 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			{
															#line 1018 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				StrictFuture<Optional<Value>> __when_expr_26 = tx->get(SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::ERRORMSG).begin);
															#line 1018 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9416 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
				if (__when_expr_26.isReady()) { if (__when_expr_26.isError()) return a_body1Catch1(__when_expr_26.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12cont2loopBody1Catch1when1(__when_expr_26.get(), loopDepth); };
				static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 27;
															#line 1018 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				__when_expr_26.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 26, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 9421 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 1034 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				StrictFuture<Void> __when_expr_27 = tx->onError(e);
															#line 1034 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9430 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
				if (__when_expr_27.isReady()) { if (__when_expr_27.isError()) return a_body1Catch1(__when_expr_27.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12cont2loopBody1Catch1when2(__when_expr_27.get(), loopDepth); };
				static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 28;
															#line 1034 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				__when_expr_27.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 27, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 9435 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 1010 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 1011 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ignoreSSFailuresRetry++;
															#line 1012 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_25 = delay(FLOW_KNOBS->PREVENT_FAST_SPIN_DELAY);
															#line 1012 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont12cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9457 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_25.isReady()) { if (__when_expr_25.isError()) return a_body1cont12cont2loopBody1Catch1(__when_expr_25.getError(), loopDepth); else return a_body1cont12cont2loopBody1cont2when1(__when_expr_25.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 26;
															#line 1012 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_25.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 25, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 9462 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 1010 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 1011 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ignoreSSFailuresRetry++;
															#line 1012 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_25 = delay(FLOW_KNOBS->PREVENT_FAST_SPIN_DELAY);
															#line 1012 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont12cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9477 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_25.isReady()) { if (__when_expr_25.isError()) return a_body1cont12cont2loopBody1Catch1(__when_expr_25.getError(), loopDepth); else return a_body1cont12cont2loopBody1cont2when1(__when_expr_25.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 26;
															#line 1012 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_25.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 25, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 9482 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose25() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 24, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 24, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 24);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose25();
		try {
			a_body1cont12cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont12cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 24);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 24, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 24);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose25();
		try {
			a_body1cont12cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont12cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 24);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 24, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 24);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose25();
		try {
			a_body1cont12cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont12cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 24);

	}
	int a_body1cont12cont2loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose26() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 25, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 25, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 25);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose26();
		try {
			a_body1cont12cont2loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont12cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 25);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 25, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 25);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose26();
		try {
			a_body1cont12cont2loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont12cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 25);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 25, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 25);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose26();
		try {
			a_body1cont12cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont12cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 25);

	}
	int a_body1cont12cont2loopBody1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont12cont2loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1Catch1cont1(int loopDepth) 
	{
															#line 1036 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ignoreSSFailuresRetry++;
															#line 1037 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_28 = delay(FLOW_KNOBS->PREVENT_FAST_SPIN_DELAY);
															#line 1037 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9670 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_28.isReady()) { if (__when_expr_28.isError()) return a_body1Catch1(__when_expr_28.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12cont2loopBody1Catch1cont1when1(__when_expr_28.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 29;
															#line 1037 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_28.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 28, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 9675 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1Catch1cont2(Optional<Value> const& errorMsg,int loopDepth) 
	{
															#line 1020 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(errorMsg.present());
															#line 1021 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		std::string errorStr;
															#line 1022 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto valueObj = readJSONStrictly(errorMsg.get().toString()).get_obj();
															#line 1023 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto schema = readJSONStrictly(JSONSchemas::managementApiErrorSchema.toString()).get_obj();
															#line 1025 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(schemaMatch(schema, valueObj, errorStr, SevError, true));
															#line 1026 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(valueObj["command"].get_str() == "maintenance" && !valueObj["retriable"].get_bool());
															#line 1027 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(ignoreSSFailuresRetry > 0);
															#line 1028 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		TraceEvent(SevDebug, "MaintenanceDDIgnoreSSFailures") .detail("Retry", ignoreSSFailuresRetry) .detail("ErrorMessage", valueObj["message"].get_str());
															#line 1031 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 9700 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		return a_body1cont12cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1Catch1cont2(Optional<Value> && errorMsg,int loopDepth) 
	{
															#line 1020 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(errorMsg.present());
															#line 1021 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		std::string errorStr;
															#line 1022 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto valueObj = readJSONStrictly(errorMsg.get().toString()).get_obj();
															#line 1023 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto schema = readJSONStrictly(JSONSchemas::managementApiErrorSchema.toString()).get_obj();
															#line 1025 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(schemaMatch(schema, valueObj, errorStr, SevError, true));
															#line 1026 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(valueObj["command"].get_str() == "maintenance" && !valueObj["retriable"].get_bool());
															#line 1027 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(ignoreSSFailuresRetry > 0);
															#line 1028 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		TraceEvent(SevDebug, "MaintenanceDDIgnoreSSFailures") .detail("Retry", ignoreSSFailuresRetry) .detail("ErrorMessage", valueObj["message"].get_str());
															#line 1031 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 9725 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		return a_body1cont12cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1Catch1when1(Optional<Value> const& errorMsg,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1Catch1cont2(errorMsg, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1Catch1when1(Optional<Value> && errorMsg,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1Catch1cont2(std::move(errorMsg), loopDepth);

		return loopDepth;
	}
	void a_exitChoose27() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 26, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 26, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 26);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose27();
		try {
			a_body1cont12cont2loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 26);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 26, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 26);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose27();
		try {
			a_body1cont12cont2loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 26);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 26, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 26);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose27();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 26);

	}
	int a_body1cont12cont2loopBody1Catch1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1Catch1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1Catch1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1Catch1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1Catch1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1Catch1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose28() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 27, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 27, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 27);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose28();
		try {
			a_body1cont12cont2loopBody1Catch1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 27);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 27, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 27);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose28();
		try {
			a_body1cont12cont2loopBody1Catch1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 27);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 27, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 27);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose28();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 27);

	}
	int a_body1cont12cont2loopBody1Catch1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1Catch1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1Catch1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1Catch1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1Catch1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1Catch1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose29() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 28, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 28, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 28);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose29();
		try {
			a_body1cont12cont2loopBody1Catch1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 28);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 28, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 28);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose29();
		try {
			a_body1cont12cont2loopBody1Catch1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 28);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 28, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 28);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose29();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 28);

	}
	int a_body1cont12cont4(int loopDepth) 
	{
															#line 1065 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		;
															#line 9983 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont12cont4loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont12cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont3loopBody1(int loopDepth) 
	{
		try {
															#line 1050 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 1051 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 1052 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			KeyRef ddPrefix = SpecialKeySpace::getManagementApiCommandPrefix("datadistribution");
															#line 1053 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->set("mode"_sr.withPrefix(ddPrefix), "0"_sr);
															#line 1054 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->set("rebalance_ignored"_sr.withPrefix(ddPrefix), BinaryWriter::toValue(ddIgnoreValue, Unversioned()));
															#line 1056 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_29 = tx->commit();
															#line 1056 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont12cont3loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10012 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_29.isReady()) { if (__when_expr_29.isError()) return a_body1cont12cont3loopBody1Catch1(__when_expr_29.getError(), loopDepth); else return a_body1cont12cont3loopBody1when1(__when_expr_29.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 30;
															#line 1056 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_29.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 29, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 10017 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont12cont3loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont12cont3loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont3break1(int loopDepth) 
	{
		try {
			return a_body1cont12cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont3loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont12cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont12cont3loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1060 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			TraceEvent(SevDebug, "DataDistributionDisableModeAndRebalance").error(e);
															#line 1061 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_30 = tx->onError(e);
															#line 1061 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10056 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_30.isReady()) { if (__when_expr_30.isError()) return a_body1Catch1(__when_expr_30.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12cont3loopBody1Catch1when1(__when_expr_30.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 31;
															#line 1061 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_30.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 30, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 10061 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont12cont3loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 1057 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 10076 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		return a_body1cont12cont3break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont12cont3loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 1057 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 10085 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		return a_body1cont12cont3break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont12cont3loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont3loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont3loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont3loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose30() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 29, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 29, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 29);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose30();
		try {
			a_body1cont12cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont12cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 29);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 29, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 29);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose30();
		try {
			a_body1cont12cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont12cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 29);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 29, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 29);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose30();
		try {
			a_body1cont12cont3loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont12cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 29);

	}
	int a_body1cont12cont3loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont3loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont3loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont3loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont3loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont3loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose31() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 30, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 30, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 30);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose31();
		try {
			a_body1cont12cont3loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 30);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 30, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 30);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose31();
		try {
			a_body1cont12cont3loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 30);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 30, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 30);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose31();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 30);

	}
	int a_body1cont12cont7(int loopDepth) 
	{
															#line 1089 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		;
															#line 10256 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont12cont7loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont4loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont12cont4loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont4loopBody1(int loopDepth) 
	{
		try {
															#line 1067 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 1069 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_31 = tx->get(healthyZoneKey);
															#line 1069 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont12cont4loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10277 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_31.isReady()) { if (__when_expr_31.isError()) return a_body1cont12cont4loopBody1Catch1(__when_expr_31.getError(), loopDepth); else return a_body1cont12cont4loopBody1when1(__when_expr_31.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 32;
															#line 1069 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_31.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 31, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 10282 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont12cont4loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont12cont4loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont4break1(int loopDepth) 
	{
		try {
			return a_body1cont12cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont4loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont12cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont12cont4loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1085 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_34 = tx->onError(e);
															#line 1085 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10319 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_34.isReady()) { if (__when_expr_34.isError()) return a_body1Catch1(__when_expr_34.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12cont4loopBody1Catch1when1(__when_expr_34.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 35;
															#line 1085 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_34.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 34, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 10324 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont12cont4loopBody1cont2(Optional<Value> const& val1,int loopDepth) 
	{
															#line 1070 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(val1.present());
															#line 1071 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto healthyZone = decodeHealthyZoneValue(val1.get());
															#line 1072 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(healthyZone.first == ignoreSSFailuresZoneString);
															#line 1074 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_32 = tx->get(dataDistributionModeKey);
															#line 1074 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont12cont4loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10347 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_32.isReady()) { if (__when_expr_32.isError()) return a_body1cont12cont4loopBody1Catch1(__when_expr_32.getError(), loopDepth); else return a_body1cont12cont4loopBody1cont2when1(__when_expr_32.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 33;
															#line 1074 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_32.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 32, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 10352 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont4loopBody1cont2(Optional<Value> && val1,int loopDepth) 
	{
															#line 1070 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(val1.present());
															#line 1071 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto healthyZone = decodeHealthyZoneValue(val1.get());
															#line 1072 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(healthyZone.first == ignoreSSFailuresZoneString);
															#line 1074 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_32 = tx->get(dataDistributionModeKey);
															#line 1074 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont12cont4loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10369 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_32.isReady()) { if (__when_expr_32.isError()) return a_body1cont12cont4loopBody1Catch1(__when_expr_32.getError(), loopDepth); else return a_body1cont12cont4loopBody1cont2when1(__when_expr_32.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 33;
															#line 1074 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_32.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 32, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 10374 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont4loopBody1when1(Optional<Value> const& val1,int loopDepth) 
	{
		loopDepth = a_body1cont12cont4loopBody1cont2(val1, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont4loopBody1when1(Optional<Value> && val1,int loopDepth) 
	{
		loopDepth = a_body1cont12cont4loopBody1cont2(std::move(val1), loopDepth);

		return loopDepth;
	}
	void a_exitChoose32() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 31, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 31, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 31);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose32();
		try {
			a_body1cont12cont4loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont12cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 31);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 31, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 31);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose32();
		try {
			a_body1cont12cont4loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont12cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 31);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 31, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 31);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose32();
		try {
			a_body1cont12cont4loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont12cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 31);

	}
	int a_body1cont12cont4loopBody1cont3(Optional<Value> const& val2,int loopDepth) 
	{
															#line 1075 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(val2.present());
															#line 1077 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(BinaryReader::fromStringRef<int>(val2.get(), Unversioned()) == 0);
															#line 1079 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_33 = tx->get(rebalanceDDIgnoreKey);
															#line 1079 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont12cont4loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10464 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_33.isReady()) { if (__when_expr_33.isError()) return a_body1cont12cont4loopBody1Catch1(__when_expr_33.getError(), loopDepth); else return a_body1cont12cont4loopBody1cont3when1(__when_expr_33.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 34;
															#line 1079 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_33.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 33, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 10469 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont4loopBody1cont3(Optional<Value> && val2,int loopDepth) 
	{
															#line 1075 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(val2.present());
															#line 1077 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(BinaryReader::fromStringRef<int>(val2.get(), Unversioned()) == 0);
															#line 1079 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_33 = tx->get(rebalanceDDIgnoreKey);
															#line 1079 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont12cont4loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10484 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_33.isReady()) { if (__when_expr_33.isError()) return a_body1cont12cont4loopBody1Catch1(__when_expr_33.getError(), loopDepth); else return a_body1cont12cont4loopBody1cont3when1(__when_expr_33.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 34;
															#line 1079 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_33.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 33, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 10489 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont4loopBody1cont2when1(Optional<Value> const& val2,int loopDepth) 
	{
		loopDepth = a_body1cont12cont4loopBody1cont3(val2, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont4loopBody1cont2when1(Optional<Value> && val2,int loopDepth) 
	{
		loopDepth = a_body1cont12cont4loopBody1cont3(std::move(val2), loopDepth);

		return loopDepth;
	}
	void a_exitChoose33() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 32, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 32, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 32);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose33();
		try {
			a_body1cont12cont4loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont12cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 32);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 32, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 32);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose33();
		try {
			a_body1cont12cont4loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont12cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 32);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 32, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 32);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose33();
		try {
			a_body1cont12cont4loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont12cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 32);

	}
	int a_body1cont12cont4loopBody1cont4(Optional<Value> const& val3,int loopDepth) 
	{
															#line 1080 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(val3.present() && BinaryReader::fromStringRef<uint8_t>(val3.get(), Unversioned()) == ddIgnoreValue);
															#line 1082 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 10575 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		return a_body1cont12cont4break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont12cont4loopBody1cont4(Optional<Value> && val3,int loopDepth) 
	{
															#line 1080 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(val3.present() && BinaryReader::fromStringRef<uint8_t>(val3.get(), Unversioned()) == ddIgnoreValue);
															#line 1082 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 10586 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		return a_body1cont12cont4break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont12cont4loopBody1cont3when1(Optional<Value> const& val3,int loopDepth) 
	{
		loopDepth = a_body1cont12cont4loopBody1cont4(val3, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont4loopBody1cont3when1(Optional<Value> && val3,int loopDepth) 
	{
		loopDepth = a_body1cont12cont4loopBody1cont4(std::move(val3), loopDepth);

		return loopDepth;
	}
	void a_exitChoose34() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 33, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 33, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 33);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose34();
		try {
			a_body1cont12cont4loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont12cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 33);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 33, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 33);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose34();
		try {
			a_body1cont12cont4loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont12cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 33);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 33, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 33);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose34();
		try {
			a_body1cont12cont4loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont12cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 33);

	}
	int a_body1cont12cont4loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont4loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont4loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont4loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont4loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont4loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont4loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont4loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose35() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 34, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 34, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 34);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose35();
		try {
			a_body1cont12cont4loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 34);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 34, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 34);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose35();
		try {
			a_body1cont12cont4loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 34);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 34, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 34);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose35();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 34);

	}
	int a_body1cont12cont8(int loopDepth) 
	{
															#line 1106 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		;
															#line 10757 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont12cont8loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont7loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont12cont7loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont7loopBody1(int loopDepth) 
	{
		try {
															#line 1091 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 1092 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 1093 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->clear(ignoreSSFailuresZoneString.withPrefix( SpecialKeySpace::getManagementApiCommandPrefix("maintenance")));
															#line 1095 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			KeyRef ddPrefix = SpecialKeySpace::getManagementApiCommandPrefix("datadistribution");
															#line 1096 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->clear("mode"_sr.withPrefix(ddPrefix));
															#line 1097 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->clear("rebalance_ignored"_sr.withPrefix(ddPrefix));
															#line 1098 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_35 = tx->commit();
															#line 1098 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont12cont7loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10788 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_35.isReady()) { if (__when_expr_35.isError()) return a_body1cont12cont7loopBody1Catch1(__when_expr_35.getError(), loopDepth); else return a_body1cont12cont7loopBody1when1(__when_expr_35.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 36;
															#line 1098 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_35.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 35, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 10793 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont12cont7loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont12cont7loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont7break1(int loopDepth) 
	{
		try {
			return a_body1cont12cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont7loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont12cont7loopHead1(0);

		return loopDepth;
	}
	int a_body1cont12cont7loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1102 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_36 = tx->onError(e);
															#line 1102 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10830 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_36.isReady()) { if (__when_expr_36.isError()) return a_body1Catch1(__when_expr_36.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12cont7loopBody1Catch1when1(__when_expr_36.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 37;
															#line 1102 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_36.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 36, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 10835 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont12cont7loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 1099 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 10850 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		return a_body1cont12cont7break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont12cont7loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 1099 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 10859 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		return a_body1cont12cont7break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont12cont7loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont7loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont7loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont7loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose36() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 35, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 35, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 35);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose36();
		try {
			a_body1cont12cont7loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont12cont7loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont7loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 35);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 35, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 35);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose36();
		try {
			a_body1cont12cont7loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont12cont7loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont7loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 35);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 35, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 35);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose36();
		try {
			a_body1cont12cont7loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont12cont7loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont7loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 35);

	}
	int a_body1cont12cont7loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont7loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont7loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont7loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont7loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont7loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont7loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont7loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose37() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 36, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 36, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 36);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose37();
		try {
			a_body1cont12cont7loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 36);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 36, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 36);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose37();
		try {
			a_body1cont12cont7loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 36);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 36, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 36);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose37();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 36);

	}
	int a_body1cont12cont9(int loopDepth) 
	{
		loopDepth = a_body1cont12cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont8loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont12cont8loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont8loopBody1(int loopDepth) 
	{
		try {
															#line 1108 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 1110 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_37 = tx->get(healthyZoneKey);
															#line 1110 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont12cont8loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11048 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_37.isReady()) { if (__when_expr_37.isError()) return a_body1cont12cont8loopBody1Catch1(__when_expr_37.getError(), loopDepth); else return a_body1cont12cont8loopBody1when1(__when_expr_37.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 38;
															#line 1110 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_37.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 37, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 11053 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont12cont8loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont12cont8loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont8break1(int loopDepth) 
	{
		try {
			return a_body1cont12cont9(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont8loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont12cont8loopHead1(0);

		return loopDepth;
	}
	int a_body1cont12cont8loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1121 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_40 = tx->onError(e);
															#line 1121 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11090 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_40.isReady()) { if (__when_expr_40.isError()) return a_body1Catch1(__when_expr_40.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12cont8loopBody1Catch1when1(__when_expr_40.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 41;
															#line 1121 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_40.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 40, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 11095 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont12cont8loopBody1cont2(Optional<Value> const& val1,int loopDepth) 
	{
															#line 1111 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(!val1.present());
															#line 1113 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_38 = tx->get(dataDistributionModeKey);
															#line 1113 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont12cont8loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11114 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_38.isReady()) { if (__when_expr_38.isError()) return a_body1cont12cont8loopBody1Catch1(__when_expr_38.getError(), loopDepth); else return a_body1cont12cont8loopBody1cont2when1(__when_expr_38.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 39;
															#line 1113 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_38.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 38, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 11119 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont8loopBody1cont2(Optional<Value> && val1,int loopDepth) 
	{
															#line 1111 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(!val1.present());
															#line 1113 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_38 = tx->get(dataDistributionModeKey);
															#line 1113 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont12cont8loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11132 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_38.isReady()) { if (__when_expr_38.isError()) return a_body1cont12cont8loopBody1Catch1(__when_expr_38.getError(), loopDepth); else return a_body1cont12cont8loopBody1cont2when1(__when_expr_38.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 39;
															#line 1113 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_38.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 38, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 11137 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont8loopBody1when1(Optional<Value> const& val1,int loopDepth) 
	{
		loopDepth = a_body1cont12cont8loopBody1cont2(val1, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont8loopBody1when1(Optional<Value> && val1,int loopDepth) 
	{
		loopDepth = a_body1cont12cont8loopBody1cont2(std::move(val1), loopDepth);

		return loopDepth;
	}
	void a_exitChoose38() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 37, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 37, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 37);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose38();
		try {
			a_body1cont12cont8loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont12cont8loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont8loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 37);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 37, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 37);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose38();
		try {
			a_body1cont12cont8loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont12cont8loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont8loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 37);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 37, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 37);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose38();
		try {
			a_body1cont12cont8loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont12cont8loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont8loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 37);

	}
	int a_body1cont12cont8loopBody1cont3(Optional<Value> const& val2,int loopDepth) 
	{
															#line 1114 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(!val2.present());
															#line 1116 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_39 = tx->get(rebalanceDDIgnoreKey);
															#line 1116 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont12cont8loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11225 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_39.isReady()) { if (__when_expr_39.isError()) return a_body1cont12cont8loopBody1Catch1(__when_expr_39.getError(), loopDepth); else return a_body1cont12cont8loopBody1cont3when1(__when_expr_39.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 40;
															#line 1116 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_39.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 39, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 11230 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont8loopBody1cont3(Optional<Value> && val2,int loopDepth) 
	{
															#line 1114 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(!val2.present());
															#line 1116 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_39 = tx->get(rebalanceDDIgnoreKey);
															#line 1116 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont12cont8loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11243 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_39.isReady()) { if (__when_expr_39.isError()) return a_body1cont12cont8loopBody1Catch1(__when_expr_39.getError(), loopDepth); else return a_body1cont12cont8loopBody1cont3when1(__when_expr_39.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 40;
															#line 1116 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_39.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 39, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 11248 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont8loopBody1cont2when1(Optional<Value> const& val2,int loopDepth) 
	{
		loopDepth = a_body1cont12cont8loopBody1cont3(val2, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont8loopBody1cont2when1(Optional<Value> && val2,int loopDepth) 
	{
		loopDepth = a_body1cont12cont8loopBody1cont3(std::move(val2), loopDepth);

		return loopDepth;
	}
	void a_exitChoose39() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 38, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 38, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 38);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose39();
		try {
			a_body1cont12cont8loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont12cont8loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont8loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 38);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 38, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 38);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose39();
		try {
			a_body1cont12cont8loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont12cont8loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont8loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 38);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 38, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 38);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose39();
		try {
			a_body1cont12cont8loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont12cont8loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont8loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 38);

	}
	int a_body1cont12cont8loopBody1cont4(Optional<Value> const& val3,int loopDepth) 
	{
															#line 1117 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(!val3.present());
															#line 1118 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 11334 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		return a_body1cont12cont8break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont12cont8loopBody1cont4(Optional<Value> && val3,int loopDepth) 
	{
															#line 1117 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(!val3.present());
															#line 1118 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 11345 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		return a_body1cont12cont8break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont12cont8loopBody1cont3when1(Optional<Value> const& val3,int loopDepth) 
	{
		loopDepth = a_body1cont12cont8loopBody1cont4(val3, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont8loopBody1cont3when1(Optional<Value> && val3,int loopDepth) 
	{
		loopDepth = a_body1cont12cont8loopBody1cont4(std::move(val3), loopDepth);

		return loopDepth;
	}
	void a_exitChoose40() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 39, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 39, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 39);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose40();
		try {
			a_body1cont12cont8loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont12cont8loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont8loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 39);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 39, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 39);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose40();
		try {
			a_body1cont12cont8loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont12cont8loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont8loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 39);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 39, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 39);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose40();
		try {
			a_body1cont12cont8loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont12cont8loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont8loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 39);

	}
	int a_body1cont12cont8loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont8loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont8loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont8loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont8loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont8loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont8loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont8loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose41() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 40, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 40, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 40);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose41();
		try {
			a_body1cont12cont8loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 40);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 40, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 40);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose41();
		try {
			a_body1cont12cont8loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 40);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 40, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 40);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose41();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 40);

	}
															#line 749 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	Database cx_;
															#line 749 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	SpecialKeySpaceCorrectnessWorkload* self;
															#line 751 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	Database cx;
															#line 752 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	Reference<ReadYourWritesTransaction> tx;
															#line 756 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	std::string new_cluster_description;
															#line 757 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	std::string new_coordinator_process;
															#line 758 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	std::vector<std::string> old_coordinators_processes;
															#line 759 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	bool possible_to_add_coordinator;
															#line 760 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	KeyRange coordinators_key_range;
															#line 763 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	unsigned retries;
															#line 764 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	bool changeCoordinatorsSucceeded;
															#line 1001 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	int ignoreSSFailuresRetry;
															#line 1041 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	uint8_t ddIgnoreValue;
															#line 11538 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via managementApiCorrectnessActor()
															#line 749 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
class ManagementApiCorrectnessActorActor final : public Actor<Void>, public ActorCallback< ManagementApiCorrectnessActorActor, 0, Optional<Value> >, public ActorCallback< ManagementApiCorrectnessActorActor, 1, Optional<Value> >, public ActorCallback< ManagementApiCorrectnessActorActor, 2, std::vector<ProcessData> >, public ActorCallback< ManagementApiCorrectnessActorActor, 3, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 4, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 5, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 6, Optional<Value> >, public ActorCallback< ManagementApiCorrectnessActorActor, 7, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 8, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 9, Optional<Value> >, public ActorCallback< ManagementApiCorrectnessActorActor, 10, std::vector<NetworkAddress> >, public ActorCallback< ManagementApiCorrectnessActorActor, 11, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 12, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 13, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 14, Optional<Value> >, public ActorCallback< ManagementApiCorrectnessActorActor, 15, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 16, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 17, RangeResult >, public ActorCallback< ManagementApiCorrectnessActorActor, 18, RangeResult >, public ActorCallback< ManagementApiCorrectnessActorActor, 19, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 20, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 21, Optional<Value> >, public ActorCallback< ManagementApiCorrectnessActorActor, 22, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 23, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 24, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 25, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 26, Optional<Value> >, public ActorCallback< ManagementApiCorrectnessActorActor, 27, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 28, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 29, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 30, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 31, Optional<Value> >, public ActorCallback< ManagementApiCorrectnessActorActor, 32, Optional<Value> >, public ActorCallback< ManagementApiCorrectnessActorActor, 33, Optional<Value> >, public ActorCallback< ManagementApiCorrectnessActorActor, 34, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 35, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 36, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 37, Optional<Value> >, public ActorCallback< ManagementApiCorrectnessActorActor, 38, Optional<Value> >, public ActorCallback< ManagementApiCorrectnessActorActor, 39, Optional<Value> >, public ActorCallback< ManagementApiCorrectnessActorActor, 40, Void >, public FastAllocated<ManagementApiCorrectnessActorActor>, public ManagementApiCorrectnessActorActorState<ManagementApiCorrectnessActorActor> {
															#line 11543 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<ManagementApiCorrectnessActorActor>::operator new;
	using FastAllocated<ManagementApiCorrectnessActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17233544606212484864UL, 8028354526961336064UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 0, Optional<Value> >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 1, Optional<Value> >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 2, std::vector<ProcessData> >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 3, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 4, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 5, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 6, Optional<Value> >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 7, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 8, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 9, Optional<Value> >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 10, std::vector<NetworkAddress> >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 11, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 12, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 13, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 14, Optional<Value> >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 15, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 16, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 17, RangeResult >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 18, RangeResult >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 19, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 20, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 21, Optional<Value> >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 22, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 23, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 24, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 25, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 26, Optional<Value> >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 27, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 28, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 29, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 30, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 31, Optional<Value> >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 32, Optional<Value> >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 33, Optional<Value> >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 34, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 35, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 36, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 37, Optional<Value> >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 38, Optional<Value> >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 39, Optional<Value> >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 40, Void >;
															#line 749 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	ManagementApiCorrectnessActorActor(Database const& cx_,SpecialKeySpaceCorrectnessWorkload* const& self) 
															#line 11600 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ManagementApiCorrectnessActorActorState<ManagementApiCorrectnessActorActor>(cx_, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15613886550486222848UL, 15598498704839473152UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("managementApiCorrectnessActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 2, std::vector<ProcessData> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 6, Optional<Value> >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 9, Optional<Value> >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 10, std::vector<NetworkAddress> >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 11, Void >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 12, Void >*)0, actor_cancelled()); break;
		case 14: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 13, Void >*)0, actor_cancelled()); break;
		case 15: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 14, Optional<Value> >*)0, actor_cancelled()); break;
		case 16: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 15, Void >*)0, actor_cancelled()); break;
		case 17: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 16, Void >*)0, actor_cancelled()); break;
		case 18: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 17, RangeResult >*)0, actor_cancelled()); break;
		case 19: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 18, RangeResult >*)0, actor_cancelled()); break;
		case 20: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 19, Void >*)0, actor_cancelled()); break;
		case 21: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 20, Void >*)0, actor_cancelled()); break;
		case 22: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 21, Optional<Value> >*)0, actor_cancelled()); break;
		case 23: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 22, Void >*)0, actor_cancelled()); break;
		case 24: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 23, Void >*)0, actor_cancelled()); break;
		case 25: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 24, Void >*)0, actor_cancelled()); break;
		case 26: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 25, Void >*)0, actor_cancelled()); break;
		case 27: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 26, Optional<Value> >*)0, actor_cancelled()); break;
		case 28: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 27, Void >*)0, actor_cancelled()); break;
		case 29: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 28, Void >*)0, actor_cancelled()); break;
		case 30: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 29, Void >*)0, actor_cancelled()); break;
		case 31: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 30, Void >*)0, actor_cancelled()); break;
		case 32: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 31, Optional<Value> >*)0, actor_cancelled()); break;
		case 33: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 32, Optional<Value> >*)0, actor_cancelled()); break;
		case 34: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 33, Optional<Value> >*)0, actor_cancelled()); break;
		case 35: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 34, Void >*)0, actor_cancelled()); break;
		case 36: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 35, Void >*)0, actor_cancelled()); break;
		case 37: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 36, Void >*)0, actor_cancelled()); break;
		case 38: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 37, Optional<Value> >*)0, actor_cancelled()); break;
		case 39: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 38, Optional<Value> >*)0, actor_cancelled()); break;
		case 40: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 39, Optional<Value> >*)0, actor_cancelled()); break;
		case 41: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 40, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 749 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
[[nodiscard]] Future<Void> managementApiCorrectnessActor( Database const& cx_, SpecialKeySpaceCorrectnessWorkload* const& self ) {
															#line 749 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	return Future<Void>(new ManagementApiCorrectnessActorActor(cx_, self));
															#line 11672 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
}

#line 1127 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"

																#line 11677 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via metricsApiCorrectnessActor()
															#line 1128 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
template <class MetricsApiCorrectnessActorActor>
															#line 1128 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
class MetricsApiCorrectnessActorActorState {
															#line 11683 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
public:
															#line 1128 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	MetricsApiCorrectnessActorActorState(Database const& cx_,SpecialKeySpaceCorrectnessWorkload* const& self) 
															#line 1128 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
															#line 1128 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		 : cx_(cx_),
															#line 1128 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		   self(self),
															#line 1129 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		   cx(cx_->clone()),
															#line 1130 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		   tx(makeReference<ReadYourWritesTransaction>(cx))
															#line 11696 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("metricsApiCorrectnessActor", reinterpret_cast<unsigned long>(this));

	}
	~MetricsApiCorrectnessActorActorState() 
	{
		fdb_probe_actor_destroy("metricsApiCorrectnessActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1131 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 11711 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
			{
															#line 1133 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				StrictFuture<Optional<Value>> __when_expr_0 = tx->get("fault_tolerance_metrics_json"_sr.withPrefix( SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::METRICS).begin));
															#line 1133 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				if (static_cast<MetricsApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11717 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<MetricsApiCorrectnessActorActor*>(this)->actor_wait_state = 1;
															#line 1133 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MetricsApiCorrectnessActorActor, 0, Optional<Value> >*>(static_cast<MetricsApiCorrectnessActorActor*>(this)));
															#line 11722 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MetricsApiCorrectnessActorActorState();
		static_cast<MetricsApiCorrectnessActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1141 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (!static_cast<MetricsApiCorrectnessActorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MetricsApiCorrectnessActorActorState(); static_cast<MetricsApiCorrectnessActorActor*>(this)->destroy(); return 0; }
															#line 11746 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<MetricsApiCorrectnessActorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~MetricsApiCorrectnessActorActorState();
		static_cast<MetricsApiCorrectnessActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Optional<Value> const& metrics,int loopDepth) 
	{
															#line 1135 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(metrics.present());
															#line 1136 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto metricsObj = readJSONStrictly(metrics.get().toString()).get_obj();
															#line 1137 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto schema = readJSONStrictly(JSONSchemas::faultToleranceStatusSchema.toString()).get_obj();
															#line 1138 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		std::string errorStr;
															#line 1139 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(schemaMatch(schema, metricsObj, errorStr, SevError, true));
															#line 11766 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Optional<Value> && metrics,int loopDepth) 
	{
															#line 1135 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(metrics.present());
															#line 1136 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto metricsObj = readJSONStrictly(metrics.get().toString()).get_obj();
															#line 1137 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto schema = readJSONStrictly(JSONSchemas::faultToleranceStatusSchema.toString()).get_obj();
															#line 1138 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		std::string errorStr;
															#line 1139 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(schemaMatch(schema, metricsObj, errorStr, SevError, true));
															#line 11783 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& metrics,int loopDepth) 
	{
		loopDepth = a_body1cont2(metrics, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && metrics,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(metrics), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MetricsApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<MetricsApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<MetricsApiCorrectnessActorActor*>(this)->ActorCallback< MetricsApiCorrectnessActorActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< MetricsApiCorrectnessActorActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("metricsApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MetricsApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metricsApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MetricsApiCorrectnessActorActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("metricsApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MetricsApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metricsApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MetricsApiCorrectnessActorActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("metricsApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MetricsApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metricsApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1128 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	Database cx_;
															#line 1128 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	SpecialKeySpaceCorrectnessWorkload* self;
															#line 1129 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	Database cx;
															#line 1130 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	Reference<ReadYourWritesTransaction> tx;
															#line 11871 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via metricsApiCorrectnessActor()
															#line 1128 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
class MetricsApiCorrectnessActorActor final : public Actor<Void>, public ActorCallback< MetricsApiCorrectnessActorActor, 0, Optional<Value> >, public FastAllocated<MetricsApiCorrectnessActorActor>, public MetricsApiCorrectnessActorActorState<MetricsApiCorrectnessActorActor> {
															#line 11876 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<MetricsApiCorrectnessActorActor>::operator new;
	using FastAllocated<MetricsApiCorrectnessActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13534978526639702272UL, 11990942516446021376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MetricsApiCorrectnessActorActor, 0, Optional<Value> >;
															#line 1128 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	MetricsApiCorrectnessActorActor(Database const& cx_,SpecialKeySpaceCorrectnessWorkload* const& self) 
															#line 11893 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   MetricsApiCorrectnessActorActorState<MetricsApiCorrectnessActorActor>(cx_, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("metricsApiCorrectnessActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17798466712909914112UL, 1737899628299752960UL);
		ActorExecutionContextHelper __helper(static_cast<MetricsApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("metricsApiCorrectnessActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("metricsApiCorrectnessActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MetricsApiCorrectnessActorActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1128 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
[[nodiscard]] Future<Void> metricsApiCorrectnessActor( Database const& cx_, SpecialKeySpaceCorrectnessWorkload* const& self ) {
															#line 1128 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	return Future<Void>(new MetricsApiCorrectnessActorActor(cx_, self));
															#line 11925 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp.py_gen"
}

#line 1143 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
};

WorkloadFactory<SpecialKeySpaceCorrectnessWorkload> SpecialKeySpaceCorrectnessFactory;
