#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
/*
 * DataDistributionMetrics.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <boost/lexical_cast.hpp>

#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbclient/Schemas.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/actorcompiler.h" // This must be the last include

struct DataDistributionMetricsWorkload : KVWorkload {
	static constexpr auto NAME = "DataDistributionMetrics";

	int numShards, readPerTx, writePerTx;
	int64_t avgBytes, transactionTimeLimit;
	double testDuration;
	std::string keyPrefix;
	PerfIntCounter commits, errors;
	double delayPerLoop;

	DataDistributionMetricsWorkload(WorkloadContext const& wcx)
	  : KVWorkload(wcx), numShards(0), avgBytes(0), commits("Commits"), errors("Errors") {
		testDuration = getOption(options, "testDuration"_sr, 10.0);
		// transaction time out duration(ms)
		transactionTimeLimit = getOption(options, "transactionTimeLimit"_sr, 10000);
		keyPrefix = getOption(options, "keyPrefix"_sr, "DDMetrics"_sr).toString();
		readPerTx = getOption(options, "readPerTransaction"_sr, 1);
		writePerTx = getOption(options, "writePerTransaction"_sr, 5 * readPerTx);
		delayPerLoop = getOption(options, "delayPerLoop"_sr, 0.1); // throttling dd rpc calls
		ASSERT(nodeCount > 1);
	}

	static Value getRandomValue() {
		return Standalone<StringRef>(format("Value/%08d", deterministicRandom()->randomInt(0, 10e6)));
	}

	Key keyForIndex(int n) { return doubleToTestKey((double)n / nodeCount, keyPrefix); }

																#line 59 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
// This generated class is to be used only via ddRWClient()
															#line 57 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
template <class DdRWClientActor>
															#line 57 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
class DdRWClientActorState {
															#line 65 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
public:
															#line 57 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
	DdRWClientActorState(Database const& cx,DataDistributionMetricsWorkload* const& self) 
															#line 57 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
															#line 57 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		 : cx(cx),
															#line 57 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		   self(self)
															#line 74 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("ddRWClient", reinterpret_cast<unsigned long>(this));

	}
	~DdRWClientActorState() 
	{
		fdb_probe_actor_destroy("ddRWClient", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 58 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
			;
															#line 89 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DdRWClientActorState();
		static_cast<DdRWClientActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 59 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		tr = ReadYourWritesTransaction(cx);
															#line 60 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		i = int();
															#line 121 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
		try {
															#line 62 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
			i = 0;
															#line 125 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
			loopDepth = a_body1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 71 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 71 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
			if (static_cast<DdRWClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 149 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<DdRWClientActor*>(this)->actor_wait_state = 3;
															#line 71 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DdRWClientActor, 2, Void >*>(static_cast<DdRWClientActor*>(this)));
															#line 154 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 65 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		for(i = 0;i < self->writePerTx;++i) {
															#line 66 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
			tr.set(self->keyForIndex(deterministicRandom()->randomInt(0, self->nodeCount)), getRandomValue());
															#line 171 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
		}
															#line 68 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 68 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		if (static_cast<DdRWClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 177 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<DdRWClientActor*>(this)->actor_wait_state = 2;
															#line 68 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DdRWClientActor, 1, Void >*>(static_cast<DdRWClientActor*>(this)));
															#line 182 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 62 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		if (!(i < self->readPerTx))
															#line 198 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 63 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		StrictFuture<Void> __when_expr_0 = success( tr.get(self->keyForIndex(deterministicRandom()->randomInt(0, self->nodeCount))));
															#line 63 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		if (static_cast<DdRWClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 206 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<DdRWClientActor*>(this)->actor_wait_state = 1;
															#line 63 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DdRWClientActor, 0, Void >*>(static_cast<DdRWClientActor*>(this)));
															#line 211 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 62 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		++i;
															#line 233 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 62 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		++i;
															#line 242 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DdRWClientActor*>(this)->actor_wait_state > 0) static_cast<DdRWClientActor*>(this)->actor_wait_state = 0;
		static_cast<DdRWClientActor*>(this)->ActorCallback< DdRWClientActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DdRWClientActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("ddRWClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DdRWClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddRWClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DdRWClientActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("ddRWClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DdRWClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddRWClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DdRWClientActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("ddRWClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DdRWClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddRWClient", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 69 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		++self->commits;
															#line 326 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 69 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		++self->commits;
															#line 335 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DdRWClientActor*>(this)->actor_wait_state > 0) static_cast<DdRWClientActor*>(this)->actor_wait_state = 0;
		static_cast<DdRWClientActor*>(this)->ActorCallback< DdRWClientActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DdRWClientActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("ddRWClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DdRWClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddRWClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DdRWClientActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("ddRWClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DdRWClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddRWClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DdRWClientActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("ddRWClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DdRWClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddRWClient", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DdRWClientActor*>(this)->actor_wait_state > 0) static_cast<DdRWClientActor*>(this)->actor_wait_state = 0;
		static_cast<DdRWClientActor*>(this)->ActorCallback< DdRWClientActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DdRWClientActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("ddRWClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DdRWClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddRWClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DdRWClientActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("ddRWClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DdRWClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddRWClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DdRWClientActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("ddRWClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DdRWClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddRWClient", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 57 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
	Database cx;
															#line 57 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
	DataDistributionMetricsWorkload* self;
															#line 59 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 60 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
	int i;
															#line 523 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
};
// This generated class is to be used only via ddRWClient()
															#line 57 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
class DdRWClientActor final : public Actor<Void>, public ActorCallback< DdRWClientActor, 0, Void >, public ActorCallback< DdRWClientActor, 1, Void >, public ActorCallback< DdRWClientActor, 2, Void >, public FastAllocated<DdRWClientActor>, public DdRWClientActorState<DdRWClientActor> {
															#line 528 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
public:
	using FastAllocated<DdRWClientActor>::operator new;
	using FastAllocated<DdRWClientActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12225376639919631872UL, 2399682227310727424UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DdRWClientActor, 0, Void >;
friend struct ActorCallback< DdRWClientActor, 1, Void >;
friend struct ActorCallback< DdRWClientActor, 2, Void >;
															#line 57 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
	DdRWClientActor(Database const& cx,DataDistributionMetricsWorkload* const& self) 
															#line 547 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   DdRWClientActorState<DdRWClientActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("ddRWClient", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16704507292215352576UL, 4947550550886555904UL);
		ActorExecutionContextHelper __helper(static_cast<DdRWClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("ddRWClient");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("ddRWClient", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DdRWClientActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DdRWClientActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DdRWClientActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 57 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
[[nodiscard]] static Future<Void> ddRWClient( Database const& cx, DataDistributionMetricsWorkload* const& self ) {
															#line 57 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
	return Future<Void>(new DdRWClientActor(cx, self));
															#line 581 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
}

#line 75 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"

																#line 586 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
// This generated class is to be used only via resultConsistencyCheckClient()
															#line 76 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
template <class ResultConsistencyCheckClientActor>
															#line 76 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
class ResultConsistencyCheckClientActorState {
															#line 592 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
public:
															#line 76 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
	ResultConsistencyCheckClientActorState(Database const& cx,DataDistributionMetricsWorkload* const& self) 
															#line 76 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
															#line 76 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		 : cx(cx),
															#line 76 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		   self(self),
															#line 77 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		   tr(makeReference<ReadYourWritesTransaction>(cx))
															#line 603 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("resultConsistencyCheckClient", reinterpret_cast<unsigned long>(this));

	}
	~ResultConsistencyCheckClientActorState() 
	{
		fdb_probe_actor_destroy("resultConsistencyCheckClient", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 78 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
			;
															#line 618 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ResultConsistencyCheckClientActorState();
		static_cast<ResultConsistencyCheckClientActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 79 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		tr->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 80 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		tr->setOption(FDBTransactionOptions::TIMEOUT, StringRef((uint8_t*)&self->transactionTimeLimit, sizeof(int64_t)));
															#line 650 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
		try {
															#line 83 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(self->delayPerLoop);
															#line 83 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
			if (static_cast<ResultConsistencyCheckClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 656 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ResultConsistencyCheckClientActor*>(this)->actor_wait_state = 1;
															#line 83 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ResultConsistencyCheckClientActor, 0, Void >*>(static_cast<ResultConsistencyCheckClientActor*>(this)));
															#line 661 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 133 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
			if (e.code() == error_code_timed_out || e.code() == error_code_transaction_timed_out)
															#line 683 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
			{
															#line 134 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
				tr->reset();
															#line 687 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
				return a_body1loopHead1(loopDepth); // continue
			}
															#line 137 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr->onError(e);
															#line 137 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
			if (static_cast<ResultConsistencyCheckClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 694 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<ResultConsistencyCheckClientActor*>(this)->actor_wait_state = 3;
															#line 137 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ResultConsistencyCheckClientActor, 2, Void >*>(static_cast<ResultConsistencyCheckClientActor*>(this)));
															#line 699 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 84 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		int startIndex = deterministicRandom()->randomInt(0, self->nodeCount - 1);
															#line 85 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		int endIndex = deterministicRandom()->randomInt(startIndex + 1, self->nodeCount);
															#line 86 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		startKey = self->keyForIndex(startIndex);
															#line 87 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		endKey = self->keyForIndex(endIndex);
															#line 91 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		begin = KeySelectorRef(startKey.withPrefix(ddStatsRange.begin, startKey.arena()), true, 0);
															#line 96 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		end = KeySelectorRef(endKey.withPrefix(ddStatsRange.begin, endKey.arena()), false, 2);
															#line 97 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = tr->getRange(begin, end, GetRangeLimits(CLIENT_KNOBS->TOO_MANY));
															#line 97 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		if (static_cast<ResultConsistencyCheckClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 728 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ResultConsistencyCheckClientActor*>(this)->actor_wait_state = 2;
															#line 97 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ResultConsistencyCheckClientActor, 1, RangeResult >*>(static_cast<ResultConsistencyCheckClientActor*>(this)));
															#line 733 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 84 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		int startIndex = deterministicRandom()->randomInt(0, self->nodeCount - 1);
															#line 85 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		int endIndex = deterministicRandom()->randomInt(startIndex + 1, self->nodeCount);
															#line 86 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		startKey = self->keyForIndex(startIndex);
															#line 87 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		endKey = self->keyForIndex(endIndex);
															#line 91 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		begin = KeySelectorRef(startKey.withPrefix(ddStatsRange.begin, startKey.arena()), true, 0);
															#line 96 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		end = KeySelectorRef(endKey.withPrefix(ddStatsRange.begin, endKey.arena()), false, 2);
															#line 97 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = tr->getRange(begin, end, GetRangeLimits(CLIENT_KNOBS->TOO_MANY));
															#line 97 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		if (static_cast<ResultConsistencyCheckClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 756 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ResultConsistencyCheckClientActor*>(this)->actor_wait_state = 2;
															#line 97 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ResultConsistencyCheckClientActor, 1, RangeResult >*>(static_cast<ResultConsistencyCheckClientActor*>(this)));
															#line 761 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ResultConsistencyCheckClientActor*>(this)->actor_wait_state > 0) static_cast<ResultConsistencyCheckClientActor*>(this)->actor_wait_state = 0;
		static_cast<ResultConsistencyCheckClientActor*>(this)->ActorCallback< ResultConsistencyCheckClientActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ResultConsistencyCheckClientActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("resultConsistencyCheckClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResultConsistencyCheckClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resultConsistencyCheckClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ResultConsistencyCheckClientActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("resultConsistencyCheckClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResultConsistencyCheckClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resultConsistencyCheckClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ResultConsistencyCheckClientActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("resultConsistencyCheckClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ResultConsistencyCheckClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resultConsistencyCheckClient", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(RangeResult const& result,int loopDepth) 
	{
															#line 99 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		if (result.size() > 1)
															#line 845 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
		{
															#line 100 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
			if (result[0].key > begin.getKey() || result[1].key <= begin.getKey())
															#line 849 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
			{
															#line 101 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
				++self->errors;
															#line 102 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
				TraceEvent(SevError, "TestFailure") .detail("Reason", "Result mismatches the given begin selector") .detail("Size", result.size()) .detail("FirstKey", result[0].key) .detail("SecondKey", result[1].key) .detail("BeginKeySelector", begin);
															#line 855 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
			}
															#line 109 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
			if (!result.readThroughEnd && (result[result.size() - 1].key < end.getKey() || result[result.size() - 2].key >= end.getKey()))
															#line 859 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
			{
															#line 111 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
				++self->errors;
															#line 112 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
				TraceEvent(SevError, "TestFailure") .detail("Reason", "Result mismatches the given end selector") .detail("Size", result.size()) .detail("LastKey", result[result.size() - 1].key) .detail("SecondLastKey", result[result.size() - 2].key) .detail("EndKeySelector", end);
															#line 865 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
			}
		}
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(RangeResult && result,int loopDepth) 
	{
															#line 99 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		if (result.size() > 1)
															#line 876 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
		{
															#line 100 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
			if (result[0].key > begin.getKey() || result[1].key <= begin.getKey())
															#line 880 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
			{
															#line 101 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
				++self->errors;
															#line 102 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
				TraceEvent(SevError, "TestFailure") .detail("Reason", "Result mismatches the given begin selector") .detail("Size", result.size()) .detail("FirstKey", result[0].key) .detail("SecondKey", result[1].key) .detail("BeginKeySelector", begin);
															#line 886 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
			}
															#line 109 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
			if (!result.readThroughEnd && (result[result.size() - 1].key < end.getKey() || result[result.size() - 2].key >= end.getKey()))
															#line 890 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
			{
															#line 111 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
				++self->errors;
															#line 112 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
				TraceEvent(SevError, "TestFailure") .detail("Reason", "Result mismatches the given end selector") .detail("Size", result.size()) .detail("LastKey", result[result.size() - 1].key) .detail("SecondLastKey", result[result.size() - 2].key) .detail("EndKeySelector", end);
															#line 896 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
			}
		}
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ResultConsistencyCheckClientActor*>(this)->actor_wait_state > 0) static_cast<ResultConsistencyCheckClientActor*>(this)->actor_wait_state = 0;
		static_cast<ResultConsistencyCheckClientActor*>(this)->ActorCallback< ResultConsistencyCheckClientActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ResultConsistencyCheckClientActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("resultConsistencyCheckClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResultConsistencyCheckClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resultConsistencyCheckClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ResultConsistencyCheckClientActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("resultConsistencyCheckClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResultConsistencyCheckClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resultConsistencyCheckClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ResultConsistencyCheckClientActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("resultConsistencyCheckClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ResultConsistencyCheckClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resultConsistencyCheckClient", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ResultConsistencyCheckClientActor*>(this)->actor_wait_state > 0) static_cast<ResultConsistencyCheckClientActor*>(this)->actor_wait_state = 0;
		static_cast<ResultConsistencyCheckClientActor*>(this)->ActorCallback< ResultConsistencyCheckClientActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ResultConsistencyCheckClientActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("resultConsistencyCheckClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResultConsistencyCheckClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resultConsistencyCheckClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ResultConsistencyCheckClientActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("resultConsistencyCheckClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResultConsistencyCheckClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resultConsistencyCheckClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ResultConsistencyCheckClientActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("resultConsistencyCheckClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ResultConsistencyCheckClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resultConsistencyCheckClient", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 76 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
	Database cx;
															#line 76 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
	DataDistributionMetricsWorkload* self;
															#line 77 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 86 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
	Key startKey;
															#line 87 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
	Key endKey;
															#line 91 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
	KeySelector begin;
															#line 96 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
	KeySelector end;
															#line 1092 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
};
// This generated class is to be used only via resultConsistencyCheckClient()
															#line 76 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
class ResultConsistencyCheckClientActor final : public Actor<Void>, public ActorCallback< ResultConsistencyCheckClientActor, 0, Void >, public ActorCallback< ResultConsistencyCheckClientActor, 1, RangeResult >, public ActorCallback< ResultConsistencyCheckClientActor, 2, Void >, public FastAllocated<ResultConsistencyCheckClientActor>, public ResultConsistencyCheckClientActorState<ResultConsistencyCheckClientActor> {
															#line 1097 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
public:
	using FastAllocated<ResultConsistencyCheckClientActor>::operator new;
	using FastAllocated<ResultConsistencyCheckClientActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16938192067136378112UL, 205840078997538304UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ResultConsistencyCheckClientActor, 0, Void >;
friend struct ActorCallback< ResultConsistencyCheckClientActor, 1, RangeResult >;
friend struct ActorCallback< ResultConsistencyCheckClientActor, 2, Void >;
															#line 76 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
	ResultConsistencyCheckClientActor(Database const& cx,DataDistributionMetricsWorkload* const& self) 
															#line 1116 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ResultConsistencyCheckClientActorState<ResultConsistencyCheckClientActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("resultConsistencyCheckClient", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10959958522020507136UL, 15077693384773582592UL);
		ActorExecutionContextHelper __helper(static_cast<ResultConsistencyCheckClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("resultConsistencyCheckClient");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("resultConsistencyCheckClient", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ResultConsistencyCheckClientActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ResultConsistencyCheckClientActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ResultConsistencyCheckClientActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 76 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
[[nodiscard]] Future<Void> resultConsistencyCheckClient( Database const& cx, DataDistributionMetricsWorkload* const& self ) {
															#line 76 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
	return Future<Void>(new ResultConsistencyCheckClientActor(cx, self));
															#line 1150 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
}

#line 141 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"

																#line 1155 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
// This generated class is to be used only via _check()
															#line 142 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
template <class _checkActor>
															#line 142 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
class _checkActorState {
															#line 1161 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
public:
															#line 142 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
	_checkActorState(Database const& cx,DataDistributionMetricsWorkload* const& self) 
															#line 142 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
															#line 142 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		 : cx(cx),
															#line 142 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		   self(self)
															#line 1170 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_check", reinterpret_cast<unsigned long>(this));

	}
	~_checkActorState() 
	{
		fdb_probe_actor_destroy("_check", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 143 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
			if (self->errors.getValue() > 0)
															#line 1185 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
			{
															#line 144 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
				TraceEvent(SevError, "TestFailure").detail("Reason", "GetRange Results Inconsistent");
															#line 145 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
				if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(false); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 1191 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
				new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(false);
				this->~_checkActorState();
				static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 149 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
			tr = makeReference<ReadYourWritesTransaction>(cx);
															#line 150 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
			i = int();
															#line 151 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
			retries = 0;
															#line 152 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
			;
															#line 1205 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 190 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(true); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 1228 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
		new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(true);
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 153 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		tr->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 154 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		tr->setOption(FDBTransactionOptions::TIMEOUT, StringRef((uint8_t*)&self->transactionTimeLimit, sizeof(int64_t)));
															#line 1249 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
		try {
															#line 157 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr->getRange(ddStatsRange, CLIENT_KNOBS->TOO_MANY);
															#line 157 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1255 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 1;
															#line 157 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 0, RangeResult >*>(static_cast<_checkActor*>(this)));
															#line 1260 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 180 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
			if (e.code() == error_code_timed_out || e.code() == error_code_transaction_timed_out)
															#line 1295 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
			{
															#line 181 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
				tr->reset();
															#line 183 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
				if (++retries > 10)
															#line 1301 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
				{
					return a_body1break1(loopDepth==0?0:loopDepth-1); // break
				}
				return a_body1loopHead1(loopDepth); // continue
			}
															#line 187 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr->onError(e);
															#line 187 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1311 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 2;
															#line 187 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 1, Void >*>(static_cast<_checkActor*>(this)));
															#line 1316 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 158 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		ASSERT(!result.more);
															#line 159 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		self->numShards = result.size();
															#line 161 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		ASSERT(self->numShards >= 1);
															#line 162 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		totalBytes = 0;
															#line 163 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		auto schema = readJSONStrictly(JSONSchemas::dataDistributionStatsSchema.toString()).get_obj();
															#line 164 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		for(i = 0;i < result.size();++i) {
															#line 165 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
			ASSERT(result[i].key.startsWith(ddStatsRange.begin));
															#line 166 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
			std::string errorStr;
															#line 167 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
			auto valueObj = readJSONStrictly(result[i].value.toString()).get_obj();
															#line 168 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
			CODE_PROBE(true, "data_distribution_stats schema validation");
															#line 169 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
			if (!schemaMatch(schema, valueObj, errorStr, SevError, true))
															#line 1351 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
			{
															#line 170 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
				TraceEvent(SevError, "DataDistributionStatsSchemaValidationFailed") .detail("ErrorStr", errorStr.c_str()) .detail("JSON", json_spirit::write_string(json_spirit::mValue(result[i].value.toString())));
															#line 173 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
				if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(false); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 1357 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
				new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(false);
				this->~_checkActorState();
				static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 175 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
			totalBytes += valueObj["shard_bytes"].get_int64();
															#line 1365 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
		}
															#line 177 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		self->avgBytes = totalBytes / self->numShards;
															#line 1369 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& __result,int loopDepth) 
	{
															#line 157 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		result = __result;
															#line 1378 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && __result,int loopDepth) 
	{
		result = std::move(__result);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _checkActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _checkActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _checkActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _checkActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 142 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
	Database cx;
															#line 142 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
	DataDistributionMetricsWorkload* self;
															#line 149 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 150 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
	int i;
															#line 151 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
	int retries;
															#line 157 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
	RangeResult result;
															#line 162 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
	int64_t totalBytes;
															#line 1554 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _check()
															#line 142 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
class _checkActor final : public Actor<bool>, public ActorCallback< _checkActor, 0, RangeResult >, public ActorCallback< _checkActor, 1, Void >, public FastAllocated<_checkActor>, public _checkActorState<_checkActor> {
															#line 1559 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
public:
	using FastAllocated<_checkActor>::operator new;
	using FastAllocated<_checkActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13791233627007149056UL, 14399780756597936896UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _checkActor, 0, RangeResult >;
friend struct ActorCallback< _checkActor, 1, Void >;
															#line 142 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
	_checkActor(Database const& cx,DataDistributionMetricsWorkload* const& self) 
															#line 1577 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   _checkActorState<_checkActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18414574916690025728UL, 14115196402046968064UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_check");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _checkActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _checkActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 142 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
[[nodiscard]] static Future<bool> _check( Database const& cx, DataDistributionMetricsWorkload* const& self ) {
															#line 142 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
	return Future<bool>(new _checkActor(cx, self));
															#line 1610 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
}

#line 192 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"

																#line 1615 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
// This generated class is to be used only via _start()
															#line 193 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
template <class _startActor>
															#line 193 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
class _startActorState {
															#line 1621 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
public:
															#line 193 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
	_startActorState(Database const& cx,DataDistributionMetricsWorkload* const& self) 
															#line 193 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
															#line 193 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		 : cx(cx),
															#line 193 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		   self(self)
															#line 1630 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 194 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
			std::vector<Future<Void>> clients;
															#line 195 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
			clients.push_back(self->resultConsistencyCheckClient(cx, self));
															#line 196 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
			for(int i = 0;i < self->actorCount;++i) {
															#line 197 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
				clients.push_back(self->ddRWClient(cx, self));
															#line 1651 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
			}
															#line 198 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
			StrictFuture<Void> __when_expr_0 = timeout(waitForAll(clients), self->testDuration, Void());
															#line 198 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1657 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 198 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 1662 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 199 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(5.0);
															#line 199 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1687 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 199 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 1692 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 199 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(5.0);
															#line 199 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1703 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 199 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 1708 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 200 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 1792 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 200 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 1804 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 193 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
	Database cx;
															#line 193 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
	DataDistributionMetricsWorkload* self;
															#line 1891 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _start()
															#line 193 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 1896 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17744793320265389824UL, 13116386857227169024UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
															#line 193 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
	_startActor(Database const& cx,DataDistributionMetricsWorkload* const& self) 
															#line 1914 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 193 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
[[nodiscard]] Future<Void> _start( Database const& cx, DataDistributionMetricsWorkload* const& self ) {
															#line 193 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 1947 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataDistributionMetrics.actor.g.cpp.py_gen"
}

#line 202 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/workloads/DataDistributionMetrics.actor.cpp"

	Future<Void> setup(Database const& cx) override { return Void(); }
	Future<Void> start(Database const& cx) override { return _start(cx, this); }

	Future<bool> check(Database const& cx) override {
		if (clientId == 0)
			return _check(cx, this);
		return true;
	}

	void getMetrics(std::vector<PerfMetric>& m) override {
		m.emplace_back("NumShards", numShards, Averaged::True);
		m.emplace_back("AvgBytes", avgBytes, Averaged::True);
		m.push_back(commits.getMetric());
	}
};

WorkloadFactory<DataDistributionMetricsWorkload> DataDistributionMetricsWorkloadFactory;
