#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
/*
 * WaitFailure.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbrpc/FailureMonitor.h"
#include "fdbrpc/fdbrpc.h"
#include "flow/Deque.h"
#include "fdbserver/Knobs.h"

#include "flow/actorcompiler.h" // This must be the last #include.

															#line 30 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via waitFailureServer()
															#line 28 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
template <class WaitFailureServerActor>
															#line 28 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
class WaitFailureServerActorState {
															#line 37 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
public:
															#line 28 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
	WaitFailureServerActorState(FutureStream<ReplyPromise<Void>> const& waitFailure) 
															#line 28 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
															#line 28 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
		 : waitFailure(waitFailure),
															#line 30 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
		   queue()
															#line 46 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("waitFailureServer", reinterpret_cast<unsigned long>(this));

	}
	~WaitFailureServerActorState() 
	{
		fdb_probe_actor_destroy("waitFailureServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 31 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
			;
															#line 61 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitFailureServerActorState();
		static_cast<WaitFailureServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 32 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
		auto __when_expr_0 = waitFailure;
															#line 91 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<ReplyPromise<Void>>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<ReplyPromise<Void>>>::value, "invalid type");
															#line 32 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
		if (static_cast<WaitFailureServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 95 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
		static_cast<WaitFailureServerActor*>(this)->actor_wait_state = 1;
															#line 32 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< WaitFailureServerActor, 0, ReplyPromise<Void> >*>(static_cast<WaitFailureServerActor*>(this)));
															#line 100 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(ReplyPromise<Void> const& P,int loopDepth) 
	{
															#line 33 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
		queue.push_back(P);
															#line 34 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
		if (queue.size() > SERVER_KNOBS->MAX_OUTSTANDING_WAIT_FAILURE_REQUESTS)
															#line 111 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
		{
															#line 35 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
			CODE_PROBE(true, "wait server queue full");
															#line 36 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
			queue.front().send(Void());
															#line 37 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
			queue.pop_front();
															#line 119 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(ReplyPromise<Void> && P,int loopDepth) 
	{
															#line 33 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
		queue.push_back(P);
															#line 34 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
		if (queue.size() > SERVER_KNOBS->MAX_OUTSTANDING_WAIT_FAILURE_REQUESTS)
															#line 131 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
		{
															#line 35 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
			CODE_PROBE(true, "wait server queue full");
															#line 36 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
			queue.front().send(Void());
															#line 37 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
			queue.pop_front();
															#line 139 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(ReplyPromise<Void> const& P,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(P, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(ReplyPromise<Void> && P,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(P), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitFailureServerActor*>(this)->actor_wait_state > 0) static_cast<WaitFailureServerActor*>(this)->actor_wait_state = 0;
		static_cast<WaitFailureServerActor*>(this)->ActorSingleCallback< WaitFailureServerActor, 0, ReplyPromise<Void> >::remove();

	}
	void a_callback_fire(ActorSingleCallback< WaitFailureServerActor, 0, ReplyPromise<Void> >*,ReplyPromise<Void> const& value) 
	{
		fdb_probe_actor_enter("waitFailureServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFailureServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitFailureServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< WaitFailureServerActor, 0, ReplyPromise<Void> >*,ReplyPromise<Void> && value) 
	{
		fdb_probe_actor_enter("waitFailureServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFailureServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitFailureServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< WaitFailureServerActor, 0, ReplyPromise<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("waitFailureServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFailureServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitFailureServer", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 28 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
	FutureStream<ReplyPromise<Void>> waitFailure;
															#line 30 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
	Deque<ReplyPromise<Void>> queue;
															#line 224 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
};
// This generated class is to be used only via waitFailureServer()
															#line 28 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
class WaitFailureServerActor final : public Actor<Void>, public ActorSingleCallback< WaitFailureServerActor, 0, ReplyPromise<Void> >, public FastAllocated<WaitFailureServerActor>, public WaitFailureServerActorState<WaitFailureServerActor> {
															#line 229 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
public:
	using FastAllocated<WaitFailureServerActor>::operator new;
	using FastAllocated<WaitFailureServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16141483308081772032UL, 10305051422436597504UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< WaitFailureServerActor, 0, ReplyPromise<Void> >;
															#line 28 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
	WaitFailureServerActor(FutureStream<ReplyPromise<Void>> const& waitFailure) 
															#line 246 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   WaitFailureServerActorState<WaitFailureServerActor>(waitFailure),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitFailureServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7425974089644435456UL, 13829823827853307392UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFailureServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitFailureServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitFailureServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< WaitFailureServerActor, 0, ReplyPromise<Void> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 28 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
[[nodiscard]] Future<Void> waitFailureServer( FutureStream<ReplyPromise<Void>> const& waitFailure ) {
															#line 28 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
	return Future<Void>(new WaitFailureServerActor(waitFailure));
															#line 279 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
}

#line 41 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"

															#line 284 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via waitFailureClient()
															#line 42 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
template <class WaitFailureClientActor>
															#line 42 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
class WaitFailureClientActorState {
															#line 291 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
public:
															#line 42 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
	WaitFailureClientActorState(RequestStream<ReplyPromise<Void>> const& waitFailure,double const& reactionTime,double const& reactionSlope,bool const& trace,Optional<Standalone<StringRef>> const& traceMsg,TaskPriority const& taskID) 
															#line 42 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
															#line 42 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
		 : waitFailure(waitFailure),
															#line 42 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
		   reactionTime(reactionTime),
															#line 42 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
		   reactionSlope(reactionSlope),
															#line 42 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
		   trace(trace),
															#line 42 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
		   traceMsg(traceMsg),
															#line 42 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
		   taskID(taskID)
															#line 308 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("waitFailureClient", reinterpret_cast<unsigned long>(this));

	}
	~WaitFailureClientActorState() 
	{
		fdb_probe_actor_destroy("waitFailureClient", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 48 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
			;
															#line 323 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitFailureClientActorState();
		static_cast<WaitFailureClientActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 50 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
			start = now();
															#line 51 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
			StrictFuture<ErrorOr<Void>> __when_expr_0 = waitFailure.getReplyUnlessFailedFor(ReplyPromise<Void>(), reactionTime, reactionSlope, taskID);
															#line 51 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
			if (static_cast<WaitFailureClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 358 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WaitFailureClientActor*>(this)->actor_wait_state = 1;
															#line 51 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitFailureClientActor, 0, ErrorOr<Void> >*>(static_cast<WaitFailureClientActor*>(this)));
															#line 363 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 68 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 385 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
			{
															#line 69 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 389 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
			}
															#line 70 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
			TraceEvent(SevError, "WaitFailureClientError").error(e);
															#line 71 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
			ASSERT(false);
															#line 395 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(ErrorOr<Void> const& x,int loopDepth) 
	{
															#line 53 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
		if (!x.present())
															#line 410 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
		{
															#line 54 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
			if (trace)
															#line 414 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
			{
															#line 55 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
				TraceEvent te("WaitFailureClient");
															#line 56 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
				te.detail("FailedEndpoint", waitFailure.getEndpoint().getPrimaryAddress().toString()) .detail("Token", waitFailure.getEndpoint().token);
															#line 58 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
				if (traceMsg.present())
															#line 422 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
				{
															#line 59 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
					te.detail("Context", traceMsg.get());
															#line 426 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
				}
			}
															#line 62 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
			if (!static_cast<WaitFailureClientActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitFailureClientActorState(); static_cast<WaitFailureClientActor*>(this)->destroy(); return 0; }
															#line 431 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
			new (&static_cast<WaitFailureClientActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~WaitFailureClientActorState();
			static_cast<WaitFailureClientActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 64 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
		double w = start + SERVER_KNOBS->WAIT_FAILURE_DELAY_LIMIT - now();
															#line 65 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
		if (w > 0)
															#line 441 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
		{
															#line 66 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(w, taskID);
															#line 66 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
			if (static_cast<WaitFailureClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 447 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<WaitFailureClientActor*>(this)->actor_wait_state = 2;
															#line 66 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitFailureClientActor, 1, Void >*>(static_cast<WaitFailureClientActor*>(this)));
															#line 452 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(ErrorOr<Void> && x,int loopDepth) 
	{
															#line 53 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
		if (!x.present())
															#line 466 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
		{
															#line 54 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
			if (trace)
															#line 470 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
			{
															#line 55 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
				TraceEvent te("WaitFailureClient");
															#line 56 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
				te.detail("FailedEndpoint", waitFailure.getEndpoint().getPrimaryAddress().toString()) .detail("Token", waitFailure.getEndpoint().token);
															#line 58 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
				if (traceMsg.present())
															#line 478 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
				{
															#line 59 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
					te.detail("Context", traceMsg.get());
															#line 482 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
				}
			}
															#line 62 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
			if (!static_cast<WaitFailureClientActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitFailureClientActorState(); static_cast<WaitFailureClientActor*>(this)->destroy(); return 0; }
															#line 487 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
			new (&static_cast<WaitFailureClientActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~WaitFailureClientActorState();
			static_cast<WaitFailureClientActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 64 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
		double w = start + SERVER_KNOBS->WAIT_FAILURE_DELAY_LIMIT - now();
															#line 65 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
		if (w > 0)
															#line 497 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
		{
															#line 66 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(w, taskID);
															#line 66 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
			if (static_cast<WaitFailureClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 503 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<WaitFailureClientActor*>(this)->actor_wait_state = 2;
															#line 66 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitFailureClientActor, 1, Void >*>(static_cast<WaitFailureClientActor*>(this)));
															#line 508 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(ErrorOr<Void> const& x,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(x, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(ErrorOr<Void> && x,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(x), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitFailureClientActor*>(this)->actor_wait_state > 0) static_cast<WaitFailureClientActor*>(this)->actor_wait_state = 0;
		static_cast<WaitFailureClientActor*>(this)->ActorCallback< WaitFailureClientActor, 0, ErrorOr<Void> >::remove();

	}
	void a_callback_fire(ActorCallback< WaitFailureClientActor, 0, ErrorOr<Void> >*,ErrorOr<Void> const& value) 
	{
		fdb_probe_actor_enter("waitFailureClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFailureClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitFailureClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitFailureClientActor, 0, ErrorOr<Void> >*,ErrorOr<Void> && value) 
	{
		fdb_probe_actor_enter("waitFailureClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFailureClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitFailureClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitFailureClientActor, 0, ErrorOr<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("waitFailureClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFailureClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitFailureClient", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WaitFailureClientActor*>(this)->actor_wait_state > 0) static_cast<WaitFailureClientActor*>(this)->actor_wait_state = 0;
		static_cast<WaitFailureClientActor*>(this)->ActorCallback< WaitFailureClientActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitFailureClientActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitFailureClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFailureClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitFailureClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WaitFailureClientActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitFailureClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFailureClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitFailureClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WaitFailureClientActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitFailureClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFailureClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitFailureClient", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 42 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
	RequestStream<ReplyPromise<Void>> waitFailure;
															#line 42 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
	double reactionTime;
															#line 42 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
	double reactionSlope;
															#line 42 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
	bool trace;
															#line 42 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
	Optional<Standalone<StringRef>> traceMsg;
															#line 42 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
	TaskPriority taskID;
															#line 50 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
	double start;
															#line 713 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
};
// This generated class is to be used only via waitFailureClient()
															#line 42 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
class WaitFailureClientActor final : public Actor<Void>, public ActorCallback< WaitFailureClientActor, 0, ErrorOr<Void> >, public ActorCallback< WaitFailureClientActor, 1, Void >, public FastAllocated<WaitFailureClientActor>, public WaitFailureClientActorState<WaitFailureClientActor> {
															#line 718 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
public:
	using FastAllocated<WaitFailureClientActor>::operator new;
	using FastAllocated<WaitFailureClientActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17312485458726350336UL, 12025216823710102272UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitFailureClientActor, 0, ErrorOr<Void> >;
friend struct ActorCallback< WaitFailureClientActor, 1, Void >;
															#line 42 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
	WaitFailureClientActor(RequestStream<ReplyPromise<Void>> const& waitFailure,double const& reactionTime,double const& reactionSlope,bool const& trace,Optional<Standalone<StringRef>> const& traceMsg,TaskPriority const& taskID) 
															#line 736 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   WaitFailureClientActorState<WaitFailureClientActor>(waitFailure, reactionTime, reactionSlope, trace, traceMsg, taskID),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitFailureClient", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16988761196834749184UL, 15110614678624696832UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFailureClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitFailureClient");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitFailureClient", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitFailureClientActor, 0, ErrorOr<Void> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WaitFailureClientActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 42 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
[[nodiscard]] Future<Void> waitFailureClient( RequestStream<ReplyPromise<Void>> const& waitFailure, double const& reactionTime, double const& reactionSlope, bool const& trace, Optional<Standalone<StringRef>> const& traceMsg, TaskPriority const& taskID ) {
															#line 42 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
	return Future<Void>(new WaitFailureClientActor(waitFailure, reactionTime, reactionSlope, trace, traceMsg, taskID));
															#line 770 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
}

#line 75 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"

															#line 775 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via waitFailureClientStrict()
															#line 76 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
template <class WaitFailureClientStrictActor>
															#line 76 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
class WaitFailureClientStrictActorState {
															#line 782 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
public:
															#line 76 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
	WaitFailureClientStrictActorState(RequestStream<ReplyPromise<Void>> const& waitFailure,double const& failureReactionTime,TaskPriority const& taskID) 
															#line 76 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
															#line 76 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
		 : waitFailure(waitFailure),
															#line 76 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
		   failureReactionTime(failureReactionTime),
															#line 76 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
		   taskID(taskID)
															#line 793 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("waitFailureClientStrict", reinterpret_cast<unsigned long>(this));

	}
	~WaitFailureClientStrictActorState() 
	{
		fdb_probe_actor_destroy("waitFailureClientStrict", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 79 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
			;
															#line 808 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitFailureClientStrictActorState();
		static_cast<WaitFailureClientStrictActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 80 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
		StrictFuture<Void> __when_expr_0 = waitFailureClient(waitFailure, 0, 0, false, Optional<Standalone<StringRef>>(), taskID);
															#line 80 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
		if (static_cast<WaitFailureClientStrictActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 840 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<WaitFailureClientStrictActor*>(this)->actor_wait_state = 1;
															#line 80 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitFailureClientStrictActor, 0, Void >*>(static_cast<WaitFailureClientStrictActor*>(this)));
															#line 845 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 86 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(failureReactionTime, taskID) || IFailureMonitor::failureMonitor().onStateEqual(waitFailure.getEndpoint(), FailureStatus(false));
															#line 86 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
		if (static_cast<WaitFailureClientStrictActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 856 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WaitFailureClientStrictActor*>(this)->actor_wait_state = 2;
															#line 86 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitFailureClientStrictActor, 1, Void >*>(static_cast<WaitFailureClientStrictActor*>(this)));
															#line 861 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 86 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(failureReactionTime, taskID) || IFailureMonitor::failureMonitor().onStateEqual(waitFailure.getEndpoint(), FailureStatus(false));
															#line 86 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
		if (static_cast<WaitFailureClientStrictActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 872 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WaitFailureClientStrictActor*>(this)->actor_wait_state = 2;
															#line 86 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitFailureClientStrictActor, 1, Void >*>(static_cast<WaitFailureClientStrictActor*>(this)));
															#line 877 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitFailureClientStrictActor*>(this)->actor_wait_state > 0) static_cast<WaitFailureClientStrictActor*>(this)->actor_wait_state = 0;
		static_cast<WaitFailureClientStrictActor*>(this)->ActorCallback< WaitFailureClientStrictActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitFailureClientStrictActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitFailureClientStrict", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFailureClientStrictActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitFailureClientStrict", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitFailureClientStrictActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitFailureClientStrict", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFailureClientStrictActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitFailureClientStrict", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitFailureClientStrictActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitFailureClientStrict", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFailureClientStrictActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitFailureClientStrict", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 88 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
		if (IFailureMonitor::failureMonitor().getState(waitFailure.getEndpoint()).isFailed())
															#line 961 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
		{
															#line 89 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
			if (!static_cast<WaitFailureClientStrictActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitFailureClientStrictActorState(); static_cast<WaitFailureClientStrictActor*>(this)->destroy(); return 0; }
															#line 965 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
			new (&static_cast<WaitFailureClientStrictActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~WaitFailureClientStrictActorState();
			static_cast<WaitFailureClientStrictActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 88 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
		if (IFailureMonitor::failureMonitor().getState(waitFailure.getEndpoint()).isFailed())
															#line 979 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
		{
															#line 89 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
			if (!static_cast<WaitFailureClientStrictActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitFailureClientStrictActorState(); static_cast<WaitFailureClientStrictActor*>(this)->destroy(); return 0; }
															#line 983 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
			new (&static_cast<WaitFailureClientStrictActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~WaitFailureClientStrictActorState();
			static_cast<WaitFailureClientStrictActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WaitFailureClientStrictActor*>(this)->actor_wait_state > 0) static_cast<WaitFailureClientStrictActor*>(this)->actor_wait_state = 0;
		static_cast<WaitFailureClientStrictActor*>(this)->ActorCallback< WaitFailureClientStrictActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitFailureClientStrictActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitFailureClientStrict", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFailureClientStrictActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitFailureClientStrict", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WaitFailureClientStrictActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitFailureClientStrict", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFailureClientStrictActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitFailureClientStrict", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WaitFailureClientStrictActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitFailureClientStrict", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFailureClientStrictActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitFailureClientStrict", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 76 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
	RequestStream<ReplyPromise<Void>> waitFailure;
															#line 76 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
	double failureReactionTime;
															#line 76 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
	TaskPriority taskID;
															#line 1074 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
};
// This generated class is to be used only via waitFailureClientStrict()
															#line 76 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
class WaitFailureClientStrictActor final : public Actor<Void>, public ActorCallback< WaitFailureClientStrictActor, 0, Void >, public ActorCallback< WaitFailureClientStrictActor, 1, Void >, public FastAllocated<WaitFailureClientStrictActor>, public WaitFailureClientStrictActorState<WaitFailureClientStrictActor> {
															#line 1079 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
public:
	using FastAllocated<WaitFailureClientStrictActor>::operator new;
	using FastAllocated<WaitFailureClientStrictActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1130104600918091264UL, 7589552089304636672UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitFailureClientStrictActor, 0, Void >;
friend struct ActorCallback< WaitFailureClientStrictActor, 1, Void >;
															#line 76 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
	WaitFailureClientStrictActor(RequestStream<ReplyPromise<Void>> const& waitFailure,double const& failureReactionTime,TaskPriority const& taskID) 
															#line 1097 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   WaitFailureClientStrictActorState<WaitFailureClientStrictActor>(waitFailure, failureReactionTime, taskID),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitFailureClientStrict", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12373665344169346048UL, 6112124518788876288UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFailureClientStrictActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitFailureClientStrict");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitFailureClientStrict", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitFailureClientStrictActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WaitFailureClientStrictActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 76 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
[[nodiscard]] Future<Void> waitFailureClientStrict( RequestStream<ReplyPromise<Void>> const& waitFailure, double const& failureReactionTime, TaskPriority const& taskID ) {
															#line 76 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
	return Future<Void>(new WaitFailureClientStrictActor(waitFailure, failureReactionTime, taskID));
															#line 1131 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
}

#line 93 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"

															#line 1136 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via waitFailureTracker()
															#line 94 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
template <class WaitFailureTrackerActor>
															#line 94 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
class WaitFailureTrackerActorState {
															#line 1143 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
public:
															#line 94 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
	WaitFailureTrackerActorState(RequestStream<ReplyPromise<Void>> const& waitFailure,Reference<AsyncVar<bool>> const& failed,double const& reactionTime,double const& reactionSlope,TaskPriority const& taskID) 
															#line 94 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
															#line 94 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
		 : waitFailure(waitFailure),
															#line 94 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
		   failed(failed),
															#line 94 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
		   reactionTime(reactionTime),
															#line 94 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
		   reactionSlope(reactionSlope),
															#line 94 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
		   taskID(taskID)
															#line 1158 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("waitFailureTracker", reinterpret_cast<unsigned long>(this));

	}
	~WaitFailureTrackerActorState() 
	{
		fdb_probe_actor_destroy("waitFailureTracker", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 99 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
			;
															#line 1173 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitFailureTrackerActorState();
		static_cast<WaitFailureTrackerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 101 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
			failed->set(IFailureMonitor::failureMonitor().getState(waitFailure.getEndpoint()).isFailed());
															#line 102 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
			if (failed->get())
															#line 1206 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
			{
															#line 103 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
				StrictFuture<Void> __when_expr_0 = IFailureMonitor::failureMonitor().onStateChanged(waitFailure.getEndpoint());
															#line 103 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
				if (static_cast<WaitFailureTrackerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1212 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
				static_cast<WaitFailureTrackerActor*>(this)->actor_wait_state = 1;
															#line 103 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitFailureTrackerActor, 0, Void >*>(static_cast<WaitFailureTrackerActor*>(this)));
															#line 1217 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 105 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
				start = now();
															#line 106 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
				StrictFuture<ErrorOr<Void>> __when_expr_1 = waitFailure.getReplyUnlessFailedFor(ReplyPromise<Void>(), reactionTime, reactionSlope, taskID);
															#line 106 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
				if (static_cast<WaitFailureTrackerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1228 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
				static_cast<WaitFailureTrackerActor*>(this)->actor_wait_state = 2;
															#line 106 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitFailureTrackerActor, 1, ErrorOr<Void> >*>(static_cast<WaitFailureTrackerActor*>(this)));
															#line 1233 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 115 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 1256 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
			{
															#line 116 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 1260 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
			}
															#line 117 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
			TraceEvent(SevError, "WaitFailureClientError").error(e);
															#line 118 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
			ASSERT(false);
															#line 1266 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitFailureTrackerActor*>(this)->actor_wait_state > 0) static_cast<WaitFailureTrackerActor*>(this)->actor_wait_state = 0;
		static_cast<WaitFailureTrackerActor*>(this)->ActorCallback< WaitFailureTrackerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitFailureTrackerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitFailureTracker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFailureTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitFailureTracker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitFailureTrackerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitFailureTracker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFailureTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitFailureTracker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitFailureTrackerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitFailureTracker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFailureTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitFailureTracker", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(ErrorOr<Void> const& x,int loopDepth) 
	{
															#line 108 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
		if (x.present())
															#line 1374 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
		{
															#line 109 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
			double w = start + SERVER_KNOBS->WAIT_FAILURE_DELAY_LIMIT - now();
															#line 110 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
			if (w > 0)
															#line 1380 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
			{
															#line 111 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
				StrictFuture<Void> __when_expr_2 = delay(w, taskID);
															#line 111 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
				if (static_cast<WaitFailureTrackerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1386 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont4when1(__when_expr_2.get(), loopDepth); };
				static_cast<WaitFailureTrackerActor*>(this)->actor_wait_state = 3;
															#line 111 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WaitFailureTrackerActor, 2, Void >*>(static_cast<WaitFailureTrackerActor*>(this)));
															#line 1391 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1cont6(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont4(ErrorOr<Void> && x,int loopDepth) 
	{
															#line 108 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
		if (x.present())
															#line 1410 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
		{
															#line 109 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
			double w = start + SERVER_KNOBS->WAIT_FAILURE_DELAY_LIMIT - now();
															#line 110 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
			if (w > 0)
															#line 1416 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
			{
															#line 111 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
				StrictFuture<Void> __when_expr_2 = delay(w, taskID);
															#line 111 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
				if (static_cast<WaitFailureTrackerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1422 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont4when1(__when_expr_2.get(), loopDepth); };
				static_cast<WaitFailureTrackerActor*>(this)->actor_wait_state = 3;
															#line 111 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WaitFailureTrackerActor, 2, Void >*>(static_cast<WaitFailureTrackerActor*>(this)));
															#line 1427 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1cont6(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when2(ErrorOr<Void> const& x,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(x, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(ErrorOr<Void> && x,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(x), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WaitFailureTrackerActor*>(this)->actor_wait_state > 0) static_cast<WaitFailureTrackerActor*>(this)->actor_wait_state = 0;
		static_cast<WaitFailureTrackerActor*>(this)->ActorCallback< WaitFailureTrackerActor, 1, ErrorOr<Void> >::remove();

	}
	void a_callback_fire(ActorCallback< WaitFailureTrackerActor, 1, ErrorOr<Void> >*,ErrorOr<Void> const& value) 
	{
		fdb_probe_actor_enter("waitFailureTracker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFailureTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitFailureTracker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WaitFailureTrackerActor, 1, ErrorOr<Void> >*,ErrorOr<Void> && value) 
	{
		fdb_probe_actor_enter("waitFailureTracker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFailureTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitFailureTracker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WaitFailureTrackerActor, 1, ErrorOr<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("waitFailureTracker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFailureTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitFailureTracker", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WaitFailureTrackerActor*>(this)->actor_wait_state > 0) static_cast<WaitFailureTrackerActor*>(this)->actor_wait_state = 0;
		static_cast<WaitFailureTrackerActor*>(this)->ActorCallback< WaitFailureTrackerActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitFailureTrackerActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitFailureTracker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFailureTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitFailureTracker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WaitFailureTrackerActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitFailureTracker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFailureTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitFailureTracker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WaitFailureTrackerActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitFailureTracker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFailureTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitFailureTracker", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 94 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
	RequestStream<ReplyPromise<Void>> waitFailure;
															#line 94 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
	Reference<AsyncVar<bool>> failed;
															#line 94 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
	double reactionTime;
															#line 94 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
	double reactionSlope;
															#line 94 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
	TaskPriority taskID;
															#line 105 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
	double start;
															#line 1641 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
};
// This generated class is to be used only via waitFailureTracker()
															#line 94 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
class WaitFailureTrackerActor final : public Actor<Void>, public ActorCallback< WaitFailureTrackerActor, 0, Void >, public ActorCallback< WaitFailureTrackerActor, 1, ErrorOr<Void> >, public ActorCallback< WaitFailureTrackerActor, 2, Void >, public FastAllocated<WaitFailureTrackerActor>, public WaitFailureTrackerActorState<WaitFailureTrackerActor> {
															#line 1646 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
public:
	using FastAllocated<WaitFailureTrackerActor>::operator new;
	using FastAllocated<WaitFailureTrackerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(441251568090675456UL, 12013311721038691584UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitFailureTrackerActor, 0, Void >;
friend struct ActorCallback< WaitFailureTrackerActor, 1, ErrorOr<Void> >;
friend struct ActorCallback< WaitFailureTrackerActor, 2, Void >;
															#line 94 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
	WaitFailureTrackerActor(RequestStream<ReplyPromise<Void>> const& waitFailure,Reference<AsyncVar<bool>> const& failed,double const& reactionTime,double const& reactionSlope,TaskPriority const& taskID) 
															#line 1665 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   WaitFailureTrackerActorState<WaitFailureTrackerActor>(waitFailure, failed, reactionTime, reactionSlope, taskID),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitFailureTracker", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17684403957785554432UL, 7288679679853281280UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFailureTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitFailureTracker");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitFailureTracker", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitFailureTrackerActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WaitFailureTrackerActor, 1, ErrorOr<Void> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WaitFailureTrackerActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 94 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
[[nodiscard]] Future<Void> waitFailureTracker( RequestStream<ReplyPromise<Void>> const& waitFailure, Reference<AsyncVar<bool>> const& failed, double const& reactionTime, double const& reactionSlope, TaskPriority const& taskID ) {
															#line 94 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
	return Future<Void>(new WaitFailureTrackerActor(waitFailure, failed, reactionTime, reactionSlope, taskID));
															#line 1700 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/WaitFailure.actor.g.cpp.py_gen"
}

#line 122 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/WaitFailure.actor.cpp"
