#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
/*
 * DataDistributionTracker.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/FDBTypes.h"
#include "fdbclient/StorageServerInterface.h"
#include "fdbrpc/FailureMonitor.h"
#include "fdbclient/SystemData.h"
#include "fdbserver/DataDistribution.actor.h"
#include "fdbserver/DDSharedContext.h"
#include "fdbserver/Knobs.h"
#include "flow/ActorCollection.h"
#include "flow/Arena.h"
#include "flow/CodeProbe.h"
#include "flow/FastRef.h"
#include "flow/Trace.h"
#include "fdbserver/DDShardTracker.h"
#include "flow/actorcompiler.h" // This must be the last #include.

// The used bandwidth of a shard. The higher the value is, the busier the shard is.
enum BandwidthStatus { BandwidthStatusLow, BandwidthStatusNormal, BandwidthStatusHigh };

enum ReadBandwidthStatus { ReadBandwidthStatusNormal, ReadBandwidthStatusHigh };

BandwidthStatus getBandwidthStatus(StorageMetrics const& metrics) {
	if (metrics.bytesWrittenPerKSecond > SERVER_KNOBS->SHARD_MAX_BYTES_PER_KSEC)
		return BandwidthStatusHigh;
	else if (metrics.bytesWrittenPerKSecond < SERVER_KNOBS->SHARD_MIN_BYTES_PER_KSEC)
		return BandwidthStatusLow;

	return BandwidthStatusNormal;
}

ReadBandwidthStatus getReadBandwidthStatus(StorageMetrics const& metrics) {
	if (metrics.bytesReadPerKSecond <= SERVER_KNOBS->SHARD_READ_HOT_BANDWIDTH_MIN_PER_KSECONDS ||
	    metrics.bytesReadPerKSecond <= SERVER_KNOBS->SHARD_MAX_READ_DENSITY_RATIO * metrics.bytes *
	                                       SERVER_KNOBS->STORAGE_METRICS_AVERAGE_INTERVAL_PER_KSECONDS) {
		return ReadBandwidthStatusNormal;
	} else {
		return ReadBandwidthStatusHigh;
	}
}

															#line 62 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via updateMaxShardSize()
															#line 60 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
template <class UpdateMaxShardSizeActor>
															#line 60 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class UpdateMaxShardSizeActorState {
															#line 69 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
public:
															#line 60 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	UpdateMaxShardSizeActorState(Reference<AsyncVar<int64_t>> const& dbSizeEstimate,Reference<AsyncVar<Optional<int64_t>>> const& maxShardSize) 
															#line 60 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
															#line 60 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		 : dbSizeEstimate(dbSizeEstimate),
															#line 60 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   maxShardSize(maxShardSize),
															#line 62 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   lastDbSize(0),
															#line 63 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   granularity(g_network->isSimulated() ? SERVER_KNOBS->DD_SHARD_SIZE_GRANULARITY_SIM : SERVER_KNOBS->DD_SHARD_SIZE_GRANULARITY)
															#line 82 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("updateMaxShardSize", reinterpret_cast<unsigned long>(this));

	}
	~UpdateMaxShardSizeActorState() 
	{
		fdb_probe_actor_destroy("updateMaxShardSize", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 65 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			;
															#line 97 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateMaxShardSizeActorState();
		static_cast<UpdateMaxShardSizeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 66 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		auto sizeDelta = std::abs(dbSizeEstimate->get() - lastDbSize);
															#line 67 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (sizeDelta > granularity || !maxShardSize->get().present())
															#line 129 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		{
															#line 68 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			auto v = getMaxShardSize(dbSizeEstimate->get());
															#line 69 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			maxShardSize->set(v);
															#line 70 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			lastDbSize = dbSizeEstimate->get();
															#line 137 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		}
															#line 72 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		StrictFuture<Void> __when_expr_0 = dbSizeEstimate->onChange();
															#line 72 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (static_cast<UpdateMaxShardSizeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 143 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<UpdateMaxShardSizeActor*>(this)->actor_wait_state = 1;
															#line 72 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateMaxShardSizeActor, 0, Void >*>(static_cast<UpdateMaxShardSizeActor*>(this)));
															#line 148 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateMaxShardSizeActor*>(this)->actor_wait_state > 0) static_cast<UpdateMaxShardSizeActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateMaxShardSizeActor*>(this)->ActorCallback< UpdateMaxShardSizeActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateMaxShardSizeActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateMaxShardSize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateMaxShardSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateMaxShardSize", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateMaxShardSizeActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateMaxShardSize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateMaxShardSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateMaxShardSize", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateMaxShardSizeActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateMaxShardSize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateMaxShardSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateMaxShardSize", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 60 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	Reference<AsyncVar<int64_t>> dbSizeEstimate;
															#line 60 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	Reference<AsyncVar<Optional<int64_t>>> maxShardSize;
															#line 62 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	int64_t lastDbSize;
															#line 63 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	int64_t granularity;
															#line 248 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via updateMaxShardSize()
															#line 60 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class UpdateMaxShardSizeActor final : public Actor<Void>, public ActorCallback< UpdateMaxShardSizeActor, 0, Void >, public FastAllocated<UpdateMaxShardSizeActor>, public UpdateMaxShardSizeActorState<UpdateMaxShardSizeActor> {
															#line 253 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
public:
	using FastAllocated<UpdateMaxShardSizeActor>::operator new;
	using FastAllocated<UpdateMaxShardSizeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1726915427966902528UL, 2557919434022121216UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateMaxShardSizeActor, 0, Void >;
															#line 60 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	UpdateMaxShardSizeActor(Reference<AsyncVar<int64_t>> const& dbSizeEstimate,Reference<AsyncVar<Optional<int64_t>>> const& maxShardSize) 
															#line 270 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   UpdateMaxShardSizeActorState<UpdateMaxShardSizeActor>(dbSizeEstimate, maxShardSize),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateMaxShardSize", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17771926794046547712UL, 18273101803754460160UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateMaxShardSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateMaxShardSize");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateMaxShardSize", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateMaxShardSizeActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 60 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
[[nodiscard]] Future<Void> updateMaxShardSize( Reference<AsyncVar<int64_t>> const& dbSizeEstimate, Reference<AsyncVar<Optional<int64_t>>> const& maxShardSize ) {
															#line 60 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	return Future<Void>(new UpdateMaxShardSizeActor(dbSizeEstimate, maxShardSize));
															#line 303 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
}

#line 75 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"

void restartShardTrackers(DataDistributionTracker* self,
                          KeyRangeRef keys,
                          Optional<ShardMetrics> startingMetrics = Optional<ShardMetrics>(),
                          bool whenDDInit = false);

// Gets the permitted size and IO bounds for a shard. A shard that starts at allKeys.begin
//  (i.e. '') will have a permitted size of 0, since the database can contain no data.
ShardSizeBounds getShardSizeBounds(KeyRangeRef shard, int64_t maxShardSize) {
	ShardSizeBounds bounds;

	if (shard.begin >= keyServersKeys.begin) {
		bounds.max.bytes = SERVER_KNOBS->KEY_SERVER_SHARD_BYTES;
	} else {
		bounds.max.bytes = maxShardSize;
	}

	bounds.max.bytesWrittenPerKSecond = bounds.max.infinity;
	bounds.max.iosPerKSecond = bounds.max.infinity;
	bounds.max.bytesReadPerKSecond = bounds.max.infinity;
	bounds.max.opsReadPerKSecond = bounds.max.infinity;

	// The first shard can have arbitrarily small size
	if (shard.begin == allKeys.begin) {
		bounds.min.bytes = 0;
	} else {
		bounds.min.bytes = maxShardSize / SERVER_KNOBS->SHARD_BYTES_RATIO;
	}

	bounds.min.bytesWrittenPerKSecond = 0;
	bounds.min.iosPerKSecond = 0;
	bounds.min.bytesReadPerKSecond = 0;
	bounds.min.opsReadPerKSecond = 0;

	// The permitted error is 1/3 of the general-case minimum bytes (even in the special case where this is the last
	// shard)
	bounds.permittedError.bytes = bounds.max.bytes / SERVER_KNOBS->SHARD_BYTES_RATIO / 3;
	bounds.permittedError.bytesWrittenPerKSecond = bounds.permittedError.infinity;
	bounds.permittedError.iosPerKSecond = bounds.permittedError.infinity;
	bounds.permittedError.bytesReadPerKSecond = bounds.permittedError.infinity;
	bounds.permittedError.opsReadPerKSecond = bounds.permittedError.infinity;

	return bounds;
}

int64_t getMaxShardSize(double dbSizeEstimate) {
	int64_t size = std::min((SERVER_KNOBS->MIN_SHARD_BYTES + (int64_t)std::sqrt(std::max<double>(dbSizeEstimate, 0)) *
	                                                             SERVER_KNOBS->SHARD_BYTES_PER_SQRT_BYTES) *
	                            SERVER_KNOBS->SHARD_BYTES_RATIO,
	                        (int64_t)SERVER_KNOBS->MAX_SHARD_BYTES);
	if (SERVER_KNOBS->ALLOW_LARGE_SHARD) {
		size = std::max(size, static_cast<int64_t>(SERVER_KNOBS->MAX_LARGE_SHARD_BYTES));
	}

	TraceEvent("MaxShardSize")
	    .suppressFor(60.0)
	    .detail("Bytes", size)
	    .detail("EstimatedDbSize", dbSizeEstimate)
	    .detail("SqrtBytes", SERVER_KNOBS->SHARD_BYTES_PER_SQRT_BYTES)
	    .detail("AllowLargeShard", SERVER_KNOBS->ALLOW_LARGE_SHARD);
	return size;
}

bool ddLargeTeamEnabled() {
	return SERVER_KNOBS->DD_MAX_SHARDS_ON_LARGE_TEAMS > 0 && !SERVER_KNOBS->SHARD_ENCODE_LOCATION_METADATA;
}

// Returns the shard size bounds as well as whether `keys` a read hot shard.
std::pair<ShardSizeBounds, bool> calculateShardSizeBounds(
    const KeyRange& keys,
    const Reference<AsyncVar<Optional<ShardMetrics>>>& shardMetrics,
    const BandwidthStatus& bandwidthStatus) {
	ShardSizeBounds bounds = ShardSizeBounds::shardSizeBoundsBeforeTrack();
	bool readHotShard = false;
	if (shardMetrics->get().present()) {
		auto bytes = shardMetrics->get().get().metrics.bytes;
		auto readBandwidthStatus = getReadBandwidthStatus(shardMetrics->get().get().metrics);

		// 1. bytes bound
		bounds.max.bytes = std::max(int64_t(bytes * 1.1), (int64_t)SERVER_KNOBS->MIN_SHARD_BYTES);
		bounds.min.bytes = std::min(int64_t(bytes * 0.9),
		                            std::max(int64_t(bytes - (SERVER_KNOBS->MIN_SHARD_BYTES * 0.1)), (int64_t)0));
		bounds.permittedError.bytes = bytes * 0.1;

		// 2. bytes written bound
		if (bandwidthStatus == BandwidthStatusNormal) { // Not high or low
			bounds.max.bytesWrittenPerKSecond = SERVER_KNOBS->SHARD_MAX_BYTES_PER_KSEC;
			bounds.min.bytesWrittenPerKSecond = SERVER_KNOBS->SHARD_MIN_BYTES_PER_KSEC;
			bounds.permittedError.bytesWrittenPerKSecond = bounds.min.bytesWrittenPerKSecond / 4;
		} else if (bandwidthStatus == BandwidthStatusHigh) { // > 10MB/sec for 100MB shard, proportionally lower
			                                                 // for smaller shard, > 200KB/sec no matter what
			bounds.max.bytesWrittenPerKSecond = bounds.max.infinity;
			bounds.min.bytesWrittenPerKSecond = SERVER_KNOBS->SHARD_MAX_BYTES_PER_KSEC;
			bounds.permittedError.bytesWrittenPerKSecond = bounds.min.bytesWrittenPerKSecond / 4;
		} else if (bandwidthStatus == BandwidthStatusLow) { // < 10KB/sec
			bounds.max.bytesWrittenPerKSecond = SERVER_KNOBS->SHARD_MIN_BYTES_PER_KSEC;
			bounds.min.bytesWrittenPerKSecond = 0;
			bounds.permittedError.bytesWrittenPerKSecond = bounds.max.bytesWrittenPerKSecond / 4;
		} else {
			ASSERT(false);
		}

		// 3. read bandwidth bound
		if (readBandwidthStatus == ReadBandwidthStatusNormal) {
			bounds.max.bytesReadPerKSecond =
			    std::max((int64_t)(SERVER_KNOBS->SHARD_MAX_READ_DENSITY_RATIO * bytes *
			                       SERVER_KNOBS->STORAGE_METRICS_AVERAGE_INTERVAL_PER_KSECONDS *
			                       (1.0 + SERVER_KNOBS->SHARD_MAX_BYTES_READ_PER_KSEC_JITTER)),
			             SERVER_KNOBS->SHARD_READ_HOT_BANDWIDTH_MIN_PER_KSECONDS);
			bounds.min.bytesReadPerKSecond = 0;
			bounds.permittedError.bytesReadPerKSecond = bounds.min.bytesReadPerKSecond / 4;
		} else if (readBandwidthStatus == ReadBandwidthStatusHigh) {
			bounds.max.bytesReadPerKSecond = bounds.max.infinity;
			bounds.min.bytesReadPerKSecond = SERVER_KNOBS->SHARD_MAX_READ_DENSITY_RATIO * bytes *
			                                 SERVER_KNOBS->STORAGE_METRICS_AVERAGE_INTERVAL_PER_KSECONDS *
			                                 (1.0 - SERVER_KNOBS->SHARD_MAX_BYTES_READ_PER_KSEC_JITTER);
			bounds.permittedError.bytesReadPerKSecond = bounds.min.bytesReadPerKSecond / 4;

			readHotShard = true;
		} else {
			ASSERT(false);
		}

		// 4. read ops bound
		if (shardMetrics->get()->metrics.opsReadPerKSecond > SERVER_KNOBS->SHARD_MAX_READ_OPS_PER_KSEC) {
			readHotShard = true;
		}
		// update when the read ops changed drastically
		int64_t currentReadOps = shardMetrics->get()->metrics.opsReadPerKSecond;
		bounds.max.opsReadPerKSecond = currentReadOps + SERVER_KNOBS->SHARD_READ_OPS_CHANGE_THRESHOLD;
		bounds.min.opsReadPerKSecond =
		    std::max((int64_t)0, currentReadOps - SERVER_KNOBS->SHARD_READ_OPS_CHANGE_THRESHOLD);
		bounds.permittedError.opsReadPerKSecond = currentReadOps * 0.25;
	}
	return { bounds, readHotShard };
}

															#line 444 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via shardUsableRegions()
															#line 212 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
template <class ShardUsableRegionsActor>
															#line 212 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class ShardUsableRegionsActorState {
															#line 451 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
public:
															#line 212 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	ShardUsableRegionsActorState(DataDistributionTracker::SafeAccessor const& self,KeyRange const& keys) 
															#line 212 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
															#line 212 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		 : self(self),
															#line 212 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   keys(keys)
															#line 460 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("shardUsableRegions", reinterpret_cast<unsigned long>(this));

	}
	~ShardUsableRegionsActorState() 
	{
		fdb_probe_actor_destroy("shardUsableRegions", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 213 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			ASSERT(SERVER_KNOBS->SHARD_ENCODE_LOCATION_METADATA);
															#line 214 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			ASSERT(SERVER_KNOBS->DD_SHARD_USABLE_REGION_CHECK_RATE > 0);
															#line 215 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = yieldedFuture(self()->readyToStart.getFuture());
															#line 215 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (static_cast<ShardUsableRegionsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 481 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ShardUsableRegionsActor*>(this)->actor_wait_state = 1;
															#line 215 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ShardUsableRegionsActor, 0, Void >*>(static_cast<ShardUsableRegionsActor*>(this)));
															#line 486 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ShardUsableRegionsActorState();
		static_cast<ShardUsableRegionsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 216 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		double expectedCompletionSeconds = self()->shards->size() * 1.0 / SERVER_KNOBS->DD_SHARD_USABLE_REGION_CHECK_RATE;
															#line 217 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		double delayTime = deterministicRandom()->random01() * expectedCompletionSeconds;
															#line 218 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delayJittered(delayTime);
															#line 218 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (static_cast<ShardUsableRegionsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 515 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ShardUsableRegionsActor*>(this)->actor_wait_state = 2;
															#line 218 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ShardUsableRegionsActor, 1, Void >*>(static_cast<ShardUsableRegionsActor*>(this)));
															#line 520 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 216 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		double expectedCompletionSeconds = self()->shards->size() * 1.0 / SERVER_KNOBS->DD_SHARD_USABLE_REGION_CHECK_RATE;
															#line 217 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		double delayTime = deterministicRandom()->random01() * expectedCompletionSeconds;
															#line 218 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delayJittered(delayTime);
															#line 218 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (static_cast<ShardUsableRegionsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 535 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ShardUsableRegionsActor*>(this)->actor_wait_state = 2;
															#line 218 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ShardUsableRegionsActor, 1, Void >*>(static_cast<ShardUsableRegionsActor*>(this)));
															#line 540 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ShardUsableRegionsActor*>(this)->actor_wait_state > 0) static_cast<ShardUsableRegionsActor*>(this)->actor_wait_state = 0;
		static_cast<ShardUsableRegionsActor*>(this)->ActorCallback< ShardUsableRegionsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ShardUsableRegionsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("shardUsableRegions", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShardUsableRegionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardUsableRegions", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ShardUsableRegionsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("shardUsableRegions", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShardUsableRegionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardUsableRegions", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ShardUsableRegionsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("shardUsableRegions", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ShardUsableRegionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardUsableRegions", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 219 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		auto [newTeam, previousTeam] = self()->shardsAffectedByTeamFailure->getTeamsForFirstShard(keys);
															#line 220 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (newTeam.size() < self()->usableRegions)
															#line 626 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		{
															#line 221 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			TraceEvent(SevWarn, "ShardUsableRegionMismatch", self()->distributorId) .suppressFor(5.0) .detail("NewTeamSize", newTeam.size()) .detail("PreviousTeamSize", previousTeam.size()) .detail("NewServers", describe(newTeam)) .detail("PreviousServers", describe(previousTeam)) .detail("UsableRegion", self()->usableRegions) .detail("Shard", keys);
															#line 229 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			RelocateShard rs(keys, DataMovementReason::POPULATE_REGION, RelocateReason::OTHER);
															#line 230 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			self()->output.send(rs);
															#line 634 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		}
															#line 232 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!static_cast<ShardUsableRegionsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ShardUsableRegionsActorState(); static_cast<ShardUsableRegionsActor*>(this)->destroy(); return 0; }
															#line 638 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		new (&static_cast<ShardUsableRegionsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ShardUsableRegionsActorState();
		static_cast<ShardUsableRegionsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 219 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		auto [newTeam, previousTeam] = self()->shardsAffectedByTeamFailure->getTeamsForFirstShard(keys);
															#line 220 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (newTeam.size() < self()->usableRegions)
															#line 652 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		{
															#line 221 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			TraceEvent(SevWarn, "ShardUsableRegionMismatch", self()->distributorId) .suppressFor(5.0) .detail("NewTeamSize", newTeam.size()) .detail("PreviousTeamSize", previousTeam.size()) .detail("NewServers", describe(newTeam)) .detail("PreviousServers", describe(previousTeam)) .detail("UsableRegion", self()->usableRegions) .detail("Shard", keys);
															#line 229 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			RelocateShard rs(keys, DataMovementReason::POPULATE_REGION, RelocateReason::OTHER);
															#line 230 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			self()->output.send(rs);
															#line 660 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		}
															#line 232 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!static_cast<ShardUsableRegionsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ShardUsableRegionsActorState(); static_cast<ShardUsableRegionsActor*>(this)->destroy(); return 0; }
															#line 664 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		new (&static_cast<ShardUsableRegionsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ShardUsableRegionsActorState();
		static_cast<ShardUsableRegionsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ShardUsableRegionsActor*>(this)->actor_wait_state > 0) static_cast<ShardUsableRegionsActor*>(this)->actor_wait_state = 0;
		static_cast<ShardUsableRegionsActor*>(this)->ActorCallback< ShardUsableRegionsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ShardUsableRegionsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("shardUsableRegions", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShardUsableRegionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardUsableRegions", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ShardUsableRegionsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("shardUsableRegions", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShardUsableRegionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardUsableRegions", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ShardUsableRegionsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("shardUsableRegions", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ShardUsableRegionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardUsableRegions", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 212 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	DataDistributionTracker::SafeAccessor self;
															#line 212 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	KeyRange keys;
															#line 751 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via shardUsableRegions()
															#line 212 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class ShardUsableRegionsActor final : public Actor<Void>, public ActorCallback< ShardUsableRegionsActor, 0, Void >, public ActorCallback< ShardUsableRegionsActor, 1, Void >, public FastAllocated<ShardUsableRegionsActor>, public ShardUsableRegionsActorState<ShardUsableRegionsActor> {
															#line 756 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
public:
	using FastAllocated<ShardUsableRegionsActor>::operator new;
	using FastAllocated<ShardUsableRegionsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7632826470749054208UL, 15377837953104067840UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ShardUsableRegionsActor, 0, Void >;
friend struct ActorCallback< ShardUsableRegionsActor, 1, Void >;
															#line 212 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	ShardUsableRegionsActor(DataDistributionTracker::SafeAccessor const& self,KeyRange const& keys) 
															#line 774 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ShardUsableRegionsActorState<ShardUsableRegionsActor>(self, keys),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("shardUsableRegions", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7379208784678766848UL, 649665179754772480UL);
		ActorExecutionContextHelper __helper(static_cast<ShardUsableRegionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("shardUsableRegions");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("shardUsableRegions", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ShardUsableRegionsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ShardUsableRegionsActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 212 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
[[nodiscard]] Future<Void> shardUsableRegions( DataDistributionTracker::SafeAccessor const& self, KeyRange const& keys ) {
															#line 212 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	return Future<Void>(new ShardUsableRegionsActor(self, keys));
															#line 808 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
}

#line 234 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"

															#line 813 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via trackShardMetrics()
															#line 235 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
template <class TrackShardMetricsActor>
															#line 235 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class TrackShardMetricsActorState {
															#line 820 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
public:
															#line 235 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	TrackShardMetricsActorState(DataDistributionTracker::SafeAccessor const& self,KeyRange const& keys,Reference<AsyncVar<Optional<ShardMetrics>>> const& shardMetrics,bool const& whenDDInit) 
															#line 235 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
															#line 235 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		 : self(self),
															#line 235 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   keys(keys),
															#line 235 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   shardMetrics(shardMetrics),
															#line 235 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   whenDDInit(whenDDInit),
															#line 239 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   bandwidthStatus(shardMetrics->get().present() ? getBandwidthStatus(shardMetrics->get().get().metrics) : BandwidthStatusNormal),
															#line 241 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   lastLowBandwidthStartTime(shardMetrics->get().present() ? shardMetrics->get().get().lastLowBandwidthStartTime : now()),
															#line 243 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   shardCount(shardMetrics->get().present() ? shardMetrics->get().get().shardCount : 1),
															#line 244 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   initWithNewMetrics(whenDDInit)
															#line 841 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("trackShardMetrics", reinterpret_cast<unsigned long>(this));

	}
	~TrackShardMetricsActorState() 
	{
		fdb_probe_actor_destroy("trackShardMetrics", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 245 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(0, TaskPriority::DataDistribution);
															#line 245 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (static_cast<TrackShardMetricsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 858 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TrackShardMetricsActor*>(this)->actor_wait_state = 1;
															#line 245 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TrackShardMetricsActor, 0, Void >*>(static_cast<TrackShardMetricsActor*>(this)));
															#line 863 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TrackShardMetricsActorState();
		static_cast<TrackShardMetricsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 247 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		DisabledTraceEvent(SevDebug, "TrackShardMetricsStarting", self()->distributorId) .detail("Keys", keys) .detail("TrackedBytesInitiallyPresent", shardMetrics->get().present()) .detail("StartingMetrics", shardMetrics->get().present() ? shardMetrics->get().get().metrics.bytes : 0);
															#line 886 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		try {
															#line 253 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			;
															#line 890 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 247 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		DisabledTraceEvent(SevDebug, "TrackShardMetricsStarting", self()->distributorId) .detail("Keys", keys) .detail("TrackedBytesInitiallyPresent", shardMetrics->get().present()) .detail("StartingMetrics", shardMetrics->get().present() ? shardMetrics->get().get().metrics.bytes : 0);
															#line 905 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		try {
															#line 253 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			;
															#line 909 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TrackShardMetricsActor*>(this)->actor_wait_state > 0) static_cast<TrackShardMetricsActor*>(this)->actor_wait_state = 0;
		static_cast<TrackShardMetricsActor*>(this)->ActorCallback< TrackShardMetricsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TrackShardMetricsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("trackShardMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackShardMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackShardMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TrackShardMetricsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("trackShardMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackShardMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackShardMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TrackShardMetricsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("trackShardMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TrackShardMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackShardMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 342 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (e.code() != error_code_actor_cancelled && e.code() != error_code_dd_tracker_cancelled)
															#line 1000 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			{
															#line 343 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				DisabledTraceEvent(SevDebug, "TrackShardError", self()->distributorId).detail("Keys", keys);
															#line 345 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				ASSERT(!transactionRetryableErrors.contains(e.code()));
															#line 346 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				self()->output.sendError(e);
															#line 1008 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			}
															#line 348 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 1012 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 254 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		bounds = ShardSizeBounds();
															#line 255 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		bool readHotShard;
															#line 256 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		std::tie(bounds, readHotShard) = calculateShardSizeBounds(keys, shardMetrics, bandwidthStatus);
															#line 258 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (readHotShard)
															#line 1039 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		{
															#line 262 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			self()->readHotShard.send(keys);
															#line 1043 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		}
															#line 265 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		;
															#line 1047 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1(int loopDepth) 
	{
															#line 267 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		StrictFuture<std::pair<Optional<StorageMetrics>, int>> __when_expr_1 = self()->db->waitStorageMetrics(keys, bounds.min, bounds.max, bounds.permittedError, CLIENT_KNOBS->STORAGE_METRICS_SHARD_LIMIT, shardCount);
															#line 267 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (static_cast<TrackShardMetricsActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1071 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TrackShardMetricsActor*>(this)->actor_wait_state = 2;
															#line 267 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TrackShardMetricsActor, 1, std::pair<Optional<StorageMetrics>, int> >*>(static_cast<TrackShardMetricsActor*>(this)));
															#line 1076 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(std::pair<Optional<StorageMetrics>, int> const& metrics,int loopDepth) 
	{
															#line 274 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (metrics.first.present())
															#line 1098 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		{
															#line 275 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			BandwidthStatus newBandwidthStatus = getBandwidthStatus(metrics.first.get());
															#line 276 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (newBandwidthStatus == BandwidthStatusLow && bandwidthStatus != BandwidthStatusLow)
															#line 1104 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			{
															#line 277 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				lastLowBandwidthStartTime = now();
															#line 1108 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			}
															#line 279 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			bandwidthStatus = newBandwidthStatus;
															#line 281 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			DisabledTraceEvent("ShardSizeUpdate", self()->distributorId) .detail("Keys", keys) .detail("UpdatedSize", metrics.first.get().bytes) .detail("WriteBandwidth", metrics.first.get().bytesWrittenPerKSecond) .detail("BandwidthStatus", bandwidthStatus) .detail("ReadBandWidth", metrics.first.get().bytesReadPerKSecond) .detail("ReadOps", metrics.first.get().opsReadPerKSecond) .detail("BytesLower", bounds.min.bytes) .detail("BytesUpper", bounds.max.bytes) .detail("WriteBandwidthLower", bounds.min.bytesWrittenPerKSecond) .detail("WriteBandwidthUpper", bounds.max.bytesWrittenPerKSecond) .detail("ShardSizePresent", shardMetrics->get().present()) .detail("OldShardSize", shardMetrics->get().present() ? shardMetrics->get().get().metrics.bytes : 0);
															#line 296 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (shardMetrics->get().present())
															#line 1116 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			{
															#line 297 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				DisabledTraceEvent("TrackerChangeSizes") .detail("Context", "trackShardMetrics") .detail("Keys", keys) .detail("TotalSizeEstimate", self()->dbSizeEstimate->get()) .detail("EndSizeOfOldShards", shardMetrics->get().get().metrics.bytes) .detail("StartingSizeOfNewShards", metrics.first.get().bytes);
															#line 303 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				self()->dbSizeEstimate->set(self()->dbSizeEstimate->get() + metrics.first.get().bytes - shardMetrics->get().get().metrics.bytes);
															#line 305 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				if (SERVER_KNOBS->SHARD_ENCODE_LOCATION_METADATA && SERVER_KNOBS->ENABLE_DD_PHYSICAL_SHARD)
															#line 1124 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
				{
															#line 308 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
					const MoveKeyRangeOutPhysicalShard needToMove = self()->physicalShardCollection->trackPhysicalShard( keys, metrics.first.get(), shardMetrics->get().get().metrics, initWithNewMetrics);
															#line 311 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
					if (needToMove)
															#line 1130 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
					{
															#line 314 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
						self()->output.send( RelocateShard(keys, DataMovementReason::ENFORCE_MOVE_OUT_OF_PHYSICAL_SHARD, RelocateReason::OTHER));
															#line 1134 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
					}
															#line 319 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
					if (initWithNewMetrics)
															#line 1138 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
					{
															#line 320 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
						initWithNewMetrics = false;
															#line 1142 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
					}
				}
															#line 323 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				if (keys.begin >= systemKeys.begin)
															#line 1147 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
				{
															#line 324 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
					self()->systemSizeEstimate += metrics.first.get().bytes - shardMetrics->get().get().metrics.bytes;
															#line 1151 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
				}
			}
															#line 329 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			shardMetrics->set(ShardMetrics(metrics.first.get(), lastLowBandwidthStartTime, shardCount));
															#line 1156 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
		else
		{
															#line 332 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			shardCount = metrics.second;
															#line 333 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (shardMetrics->get().present())
															#line 1165 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			{
															#line 334 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				auto newShardMetrics = shardMetrics->get().get();
															#line 335 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				newShardMetrics.shardCount = shardCount;
															#line 336 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				shardMetrics->set(newShardMetrics);
															#line 1173 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			}
		}
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(std::pair<Optional<StorageMetrics>, int> && metrics,int loopDepth) 
	{
															#line 274 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (metrics.first.present())
															#line 1184 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		{
															#line 275 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			BandwidthStatus newBandwidthStatus = getBandwidthStatus(metrics.first.get());
															#line 276 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (newBandwidthStatus == BandwidthStatusLow && bandwidthStatus != BandwidthStatusLow)
															#line 1190 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			{
															#line 277 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				lastLowBandwidthStartTime = now();
															#line 1194 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			}
															#line 279 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			bandwidthStatus = newBandwidthStatus;
															#line 281 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			DisabledTraceEvent("ShardSizeUpdate", self()->distributorId) .detail("Keys", keys) .detail("UpdatedSize", metrics.first.get().bytes) .detail("WriteBandwidth", metrics.first.get().bytesWrittenPerKSecond) .detail("BandwidthStatus", bandwidthStatus) .detail("ReadBandWidth", metrics.first.get().bytesReadPerKSecond) .detail("ReadOps", metrics.first.get().opsReadPerKSecond) .detail("BytesLower", bounds.min.bytes) .detail("BytesUpper", bounds.max.bytes) .detail("WriteBandwidthLower", bounds.min.bytesWrittenPerKSecond) .detail("WriteBandwidthUpper", bounds.max.bytesWrittenPerKSecond) .detail("ShardSizePresent", shardMetrics->get().present()) .detail("OldShardSize", shardMetrics->get().present() ? shardMetrics->get().get().metrics.bytes : 0);
															#line 296 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (shardMetrics->get().present())
															#line 1202 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			{
															#line 297 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				DisabledTraceEvent("TrackerChangeSizes") .detail("Context", "trackShardMetrics") .detail("Keys", keys) .detail("TotalSizeEstimate", self()->dbSizeEstimate->get()) .detail("EndSizeOfOldShards", shardMetrics->get().get().metrics.bytes) .detail("StartingSizeOfNewShards", metrics.first.get().bytes);
															#line 303 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				self()->dbSizeEstimate->set(self()->dbSizeEstimate->get() + metrics.first.get().bytes - shardMetrics->get().get().metrics.bytes);
															#line 305 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				if (SERVER_KNOBS->SHARD_ENCODE_LOCATION_METADATA && SERVER_KNOBS->ENABLE_DD_PHYSICAL_SHARD)
															#line 1210 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
				{
															#line 308 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
					const MoveKeyRangeOutPhysicalShard needToMove = self()->physicalShardCollection->trackPhysicalShard( keys, metrics.first.get(), shardMetrics->get().get().metrics, initWithNewMetrics);
															#line 311 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
					if (needToMove)
															#line 1216 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
					{
															#line 314 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
						self()->output.send( RelocateShard(keys, DataMovementReason::ENFORCE_MOVE_OUT_OF_PHYSICAL_SHARD, RelocateReason::OTHER));
															#line 1220 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
					}
															#line 319 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
					if (initWithNewMetrics)
															#line 1224 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
					{
															#line 320 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
						initWithNewMetrics = false;
															#line 1228 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
					}
				}
															#line 323 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				if (keys.begin >= systemKeys.begin)
															#line 1233 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
				{
															#line 324 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
					self()->systemSizeEstimate += metrics.first.get().bytes - shardMetrics->get().get().metrics.bytes;
															#line 1237 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
				}
			}
															#line 329 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			shardMetrics->set(ShardMetrics(metrics.first.get(), lastLowBandwidthStartTime, shardCount));
															#line 1242 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
		else
		{
															#line 332 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			shardCount = metrics.second;
															#line 333 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (shardMetrics->get().present())
															#line 1251 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			{
															#line 334 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				auto newShardMetrics = shardMetrics->get().get();
															#line 335 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				newShardMetrics.shardCount = shardCount;
															#line 336 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				shardMetrics->set(newShardMetrics);
															#line 1259 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			}
		}
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(std::pair<Optional<StorageMetrics>, int> const& metrics,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(metrics, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(std::pair<Optional<StorageMetrics>, int> && metrics,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(std::move(metrics), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TrackShardMetricsActor*>(this)->actor_wait_state > 0) static_cast<TrackShardMetricsActor*>(this)->actor_wait_state = 0;
		static_cast<TrackShardMetricsActor*>(this)->ActorCallback< TrackShardMetricsActor, 1, std::pair<Optional<StorageMetrics>, int> >::remove();

	}
	void a_callback_fire(ActorCallback< TrackShardMetricsActor, 1, std::pair<Optional<StorageMetrics>, int> >*,std::pair<Optional<StorageMetrics>, int> const& value) 
	{
		fdb_probe_actor_enter("trackShardMetrics", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackShardMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackShardMetrics", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TrackShardMetricsActor, 1, std::pair<Optional<StorageMetrics>, int> >*,std::pair<Optional<StorageMetrics>, int> && value) 
	{
		fdb_probe_actor_enter("trackShardMetrics", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackShardMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackShardMetrics", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TrackShardMetricsActor, 1, std::pair<Optional<StorageMetrics>, int> >*,Error err) 
	{
		fdb_probe_actor_enter("trackShardMetrics", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TrackShardMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackShardMetrics", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 235 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	DataDistributionTracker::SafeAccessor self;
															#line 235 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	KeyRange keys;
															#line 235 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	Reference<AsyncVar<Optional<ShardMetrics>>> shardMetrics;
															#line 235 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	bool whenDDInit;
															#line 239 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	BandwidthStatus bandwidthStatus;
															#line 241 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	double lastLowBandwidthStartTime;
															#line 243 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	int shardCount;
															#line 244 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	bool initWithNewMetrics;
															#line 254 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	ShardSizeBounds bounds;
															#line 1359 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via trackShardMetrics()
															#line 235 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class TrackShardMetricsActor final : public Actor<Void>, public ActorCallback< TrackShardMetricsActor, 0, Void >, public ActorCallback< TrackShardMetricsActor, 1, std::pair<Optional<StorageMetrics>, int> >, public FastAllocated<TrackShardMetricsActor>, public TrackShardMetricsActorState<TrackShardMetricsActor> {
															#line 1364 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
public:
	using FastAllocated<TrackShardMetricsActor>::operator new;
	using FastAllocated<TrackShardMetricsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12750727239054107136UL, 10534965363164743936UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TrackShardMetricsActor, 0, Void >;
friend struct ActorCallback< TrackShardMetricsActor, 1, std::pair<Optional<StorageMetrics>, int> >;
															#line 235 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	TrackShardMetricsActor(DataDistributionTracker::SafeAccessor const& self,KeyRange const& keys,Reference<AsyncVar<Optional<ShardMetrics>>> const& shardMetrics,bool const& whenDDInit) 
															#line 1382 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TrackShardMetricsActorState<TrackShardMetricsActor>(self, keys, shardMetrics, whenDDInit),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("trackShardMetrics", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8095935716908204288UL, 1249160800655855360UL);
		ActorExecutionContextHelper __helper(static_cast<TrackShardMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("trackShardMetrics");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("trackShardMetrics", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TrackShardMetricsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TrackShardMetricsActor, 1, std::pair<Optional<StorageMetrics>, int> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 235 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
[[nodiscard]] Future<Void> trackShardMetrics( DataDistributionTracker::SafeAccessor const& self, KeyRange const& keys, Reference<AsyncVar<Optional<ShardMetrics>>> const& shardMetrics, bool const& whenDDInit ) {
															#line 235 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	return Future<Void>(new TrackShardMetricsActor(self, keys, shardMetrics, whenDDInit));
															#line 1416 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
}

#line 351 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"

															#line 1421 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via readHotDetector()
															#line 352 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
template <class ReadHotDetectorActor>
															#line 352 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class ReadHotDetectorActorState {
															#line 1428 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
public:
															#line 352 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	ReadHotDetectorActorState(DataDistributionTracker* const& self) 
															#line 352 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
															#line 352 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		 : self(self)
															#line 1435 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("readHotDetector", reinterpret_cast<unsigned long>(this));

	}
	~ReadHotDetectorActorState() 
	{
		fdb_probe_actor_destroy("readHotDetector", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 354 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				;
															#line 1451 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadHotDetectorActorState();
		static_cast<ReadHotDetectorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 368 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (e.code() != error_code_actor_cancelled)
															#line 1481 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			{
															#line 370 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				ASSERT(!transactionRetryableErrors.contains(e.code()));
															#line 371 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				self->output.sendError(e);
															#line 1487 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			}
															#line 373 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 1491 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 355 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		auto __when_expr_0 = self->readHotShard.getFuture();
															#line 1512 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<KeyRange>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<KeyRange>>::value, "invalid type");
															#line 355 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (static_cast<ReadHotDetectorActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1516 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
		static_cast<ReadHotDetectorActor*>(this)->actor_wait_state = 1;
															#line 355 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< ReadHotDetectorActor, 0, KeyRange >*>(static_cast<ReadHotDetectorActor*>(this)));
															#line 1521 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 356 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		StrictFuture<Standalone<VectorRef<ReadHotRangeWithMetrics>>> __when_expr_1 = self->db->getReadHotRanges(keys);
															#line 356 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (static_cast<ReadHotDetectorActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1532 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ReadHotDetectorActor*>(this)->actor_wait_state = 2;
															#line 356 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadHotDetectorActor, 1, Standalone<VectorRef<ReadHotRangeWithMetrics>> >*>(static_cast<ReadHotDetectorActor*>(this)));
															#line 1537 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(KeyRange const& __keys,int loopDepth) 
	{
															#line 355 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		keys = __keys;
															#line 1546 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(KeyRange && __keys,int loopDepth) 
	{
		keys = std::move(__keys);
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadHotDetectorActor*>(this)->actor_wait_state > 0) static_cast<ReadHotDetectorActor*>(this)->actor_wait_state = 0;
		static_cast<ReadHotDetectorActor*>(this)->ActorSingleCallback< ReadHotDetectorActor, 0, KeyRange >::remove();

	}
	void a_callback_fire(ActorSingleCallback< ReadHotDetectorActor, 0, KeyRange >*,KeyRange const& value) 
	{
		fdb_probe_actor_enter("readHotDetector", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadHotDetectorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readHotDetector", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< ReadHotDetectorActor, 0, KeyRange >*,KeyRange && value) 
	{
		fdb_probe_actor_enter("readHotDetector", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadHotDetectorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readHotDetector", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< ReadHotDetectorActor, 0, KeyRange >*,Error err) 
	{
		fdb_probe_actor_enter("readHotDetector", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadHotDetectorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readHotDetector", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Standalone<VectorRef<ReadHotRangeWithMetrics>> const& readHotRanges,int loopDepth) 
	{
															#line 358 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		for( const auto& keyRange : readHotRanges ) {
															#line 359 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			TraceEvent("ReadHotRangeLog") .detail("ReadDensity", keyRange.density) .detail("ReadBandwidth", keyRange.readBandwidthSec) .detail("ReadDensityThreshold", SERVER_KNOBS->SHARD_MAX_READ_DENSITY_RATIO) .detail("KeyRangeBegin", keyRange.keys.begin) .detail("KeyRangeEnd", keyRange.keys.end);
															#line 1627 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Standalone<VectorRef<ReadHotRangeWithMetrics>> && readHotRanges,int loopDepth) 
	{
															#line 358 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		for( const auto& keyRange : readHotRanges ) {
															#line 359 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			TraceEvent("ReadHotRangeLog") .detail("ReadDensity", keyRange.density) .detail("ReadBandwidth", keyRange.readBandwidthSec) .detail("ReadDensityThreshold", SERVER_KNOBS->SHARD_MAX_READ_DENSITY_RATIO) .detail("KeyRangeBegin", keyRange.keys.begin) .detail("KeyRangeEnd", keyRange.keys.end);
															#line 1639 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Standalone<VectorRef<ReadHotRangeWithMetrics>> const& readHotRanges,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(readHotRanges, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Standalone<VectorRef<ReadHotRangeWithMetrics>> && readHotRanges,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(readHotRanges), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReadHotDetectorActor*>(this)->actor_wait_state > 0) static_cast<ReadHotDetectorActor*>(this)->actor_wait_state = 0;
		static_cast<ReadHotDetectorActor*>(this)->ActorCallback< ReadHotDetectorActor, 1, Standalone<VectorRef<ReadHotRangeWithMetrics>> >::remove();

	}
	void a_callback_fire(ActorCallback< ReadHotDetectorActor, 1, Standalone<VectorRef<ReadHotRangeWithMetrics>> >*,Standalone<VectorRef<ReadHotRangeWithMetrics>> const& value) 
	{
		fdb_probe_actor_enter("readHotDetector", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadHotDetectorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readHotDetector", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReadHotDetectorActor, 1, Standalone<VectorRef<ReadHotRangeWithMetrics>> >*,Standalone<VectorRef<ReadHotRangeWithMetrics>> && value) 
	{
		fdb_probe_actor_enter("readHotDetector", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadHotDetectorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readHotDetector", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReadHotDetectorActor, 1, Standalone<VectorRef<ReadHotRangeWithMetrics>> >*,Error err) 
	{
		fdb_probe_actor_enter("readHotDetector", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadHotDetectorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readHotDetector", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 352 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	DataDistributionTracker* self;
															#line 355 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	KeyRange keys;
															#line 1724 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via readHotDetector()
															#line 352 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class ReadHotDetectorActor final : public Actor<Void>, public ActorSingleCallback< ReadHotDetectorActor, 0, KeyRange >, public ActorCallback< ReadHotDetectorActor, 1, Standalone<VectorRef<ReadHotRangeWithMetrics>> >, public FastAllocated<ReadHotDetectorActor>, public ReadHotDetectorActorState<ReadHotDetectorActor> {
															#line 1729 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
public:
	using FastAllocated<ReadHotDetectorActor>::operator new;
	using FastAllocated<ReadHotDetectorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2397419584041648384UL, 13233972222189361664UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< ReadHotDetectorActor, 0, KeyRange >;
friend struct ActorCallback< ReadHotDetectorActor, 1, Standalone<VectorRef<ReadHotRangeWithMetrics>> >;
															#line 352 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	ReadHotDetectorActor(DataDistributionTracker* const& self) 
															#line 1747 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ReadHotDetectorActorState<ReadHotDetectorActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readHotDetector", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7522552365585453056UL, 2930011701178436608UL);
		ActorExecutionContextHelper __helper(static_cast<ReadHotDetectorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readHotDetector");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readHotDetector", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< ReadHotDetectorActor, 0, KeyRange >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReadHotDetectorActor, 1, Standalone<VectorRef<ReadHotRangeWithMetrics>> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 352 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
[[nodiscard]] Future<Void> readHotDetector( DataDistributionTracker* const& self ) {
															#line 352 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	return Future<Void>(new ReadHotDetectorActor(self));
															#line 1781 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
}

#line 376 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"

/*
ACTOR Future<Void> extrapolateShardBytes( Reference<AsyncVar<Optional<int64_t>>> inBytes,
Reference<AsyncVar<Optional<int64_t>>> outBytes ) { state std::deque< std::pair<double,int64_t> > past; loop { wait(
inBytes->onChange() ); if( inBytes->get().present() ) { past.emplace_back(now(),inBytes->get().get()); if
(past.size() < 2) outBytes->set( inBytes->get() ); else { while (past.size() > 1 && past.end()[-1].first -
past.begin()[1].first > 1.0) past.pop_front(); double rate = std::max(0.0,
double(past.end()[-1].second-past.begin()[0].second)/(past.end()[-1].first - past.begin()[0].first)); outBytes->set(
inBytes->get().get() + rate * 10.0 );
            }
        }
    }
}*/

															#line 1799 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getFirstSize()
															#line 390 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
template <class GetFirstSizeActor>
															#line 390 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class GetFirstSizeActorState {
															#line 1806 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
public:
															#line 390 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	GetFirstSizeActorState(Reference<AsyncVar<Optional<ShardMetrics>>> const& stats) 
															#line 390 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
															#line 390 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		 : stats(stats)
															#line 1813 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getFirstSize", reinterpret_cast<unsigned long>(this));

	}
	~GetFirstSizeActorState() 
	{
		fdb_probe_actor_destroy("getFirstSize", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 391 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			;
															#line 1828 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetFirstSizeActorState();
		static_cast<GetFirstSizeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 392 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (stats->get().present())
															#line 1858 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		{
															#line 393 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (!static_cast<GetFirstSizeActor*>(this)->SAV<int64_t>::futures) { (void)(stats->get().get().metrics.bytes); this->~GetFirstSizeActorState(); static_cast<GetFirstSizeActor*>(this)->destroy(); return 0; }
															#line 1862 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			new (&static_cast<GetFirstSizeActor*>(this)->SAV< int64_t >::value()) int64_t(stats->get().get().metrics.bytes);
			this->~GetFirstSizeActorState();
			static_cast<GetFirstSizeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 394 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		StrictFuture<Void> __when_expr_0 = stats->onChange();
															#line 394 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (static_cast<GetFirstSizeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1872 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<GetFirstSizeActor*>(this)->actor_wait_state = 1;
															#line 394 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetFirstSizeActor, 0, Void >*>(static_cast<GetFirstSizeActor*>(this)));
															#line 1877 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetFirstSizeActor*>(this)->actor_wait_state > 0) static_cast<GetFirstSizeActor*>(this)->actor_wait_state = 0;
		static_cast<GetFirstSizeActor*>(this)->ActorCallback< GetFirstSizeActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetFirstSizeActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getFirstSize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetFirstSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getFirstSize", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetFirstSizeActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getFirstSize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetFirstSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getFirstSize", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetFirstSizeActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getFirstSize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetFirstSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getFirstSize", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 390 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	Reference<AsyncVar<Optional<ShardMetrics>>> stats;
															#line 1971 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getFirstSize()
															#line 390 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class GetFirstSizeActor final : public Actor<int64_t>, public ActorCallback< GetFirstSizeActor, 0, Void >, public FastAllocated<GetFirstSizeActor>, public GetFirstSizeActorState<GetFirstSizeActor> {
															#line 1976 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetFirstSizeActor>::operator new;
	using FastAllocated<GetFirstSizeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16940367534059596544UL, 7949099715050573568UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int64_t>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetFirstSizeActor, 0, Void >;
															#line 390 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	GetFirstSizeActor(Reference<AsyncVar<Optional<ShardMetrics>>> const& stats) 
															#line 1993 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		 : Actor<int64_t>(),
		   GetFirstSizeActorState<GetFirstSizeActor>(stats),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getFirstSize", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5224663036299137024UL, 12919559761751353856UL);
		ActorExecutionContextHelper __helper(static_cast<GetFirstSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getFirstSize");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getFirstSize", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetFirstSizeActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 390 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
[[nodiscard]] Future<int64_t> getFirstSize( Reference<AsyncVar<Optional<ShardMetrics>>> const& stats ) {
															#line 390 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	return Future<int64_t>(new GetFirstSizeActor(stats));
															#line 2026 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
}

#line 397 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"

															#line 2031 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via changeSizes()
															#line 398 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
template <class ChangeSizesActor>
															#line 398 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class ChangeSizesActorState {
															#line 2038 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
public:
															#line 398 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	ChangeSizesActorState(DataDistributionTracker* const& self,KeyRange const& keys,int64_t const& oldShardsEndingSize,std::string const& context) 
															#line 398 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
															#line 398 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		 : self(self),
															#line 398 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   keys(keys),
															#line 398 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   oldShardsEndingSize(oldShardsEndingSize),
															#line 398 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   context(context),
															#line 402 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   sizes(),
															#line 403 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   systemSizes()
															#line 2055 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("changeSizes", reinterpret_cast<unsigned long>(this));

	}
	~ChangeSizesActorState() 
	{
		fdb_probe_actor_destroy("changeSizes", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 404 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			for( auto it : self->shards->intersectingRanges(keys) ) {
															#line 405 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				Future<int64_t> thisSize = getFirstSize(it->value().stats);
															#line 406 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				sizes.push_back(thisSize);
															#line 407 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				if (it->range().begin >= systemKeys.begin)
															#line 2076 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
				{
															#line 408 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
					systemSizes.push_back(thisSize);
															#line 2080 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
				}
			}
															#line 412 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(sizes);
															#line 412 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (static_cast<ChangeSizesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2087 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ChangeSizesActor*>(this)->actor_wait_state = 1;
															#line 412 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ChangeSizesActor, 0, Void >*>(static_cast<ChangeSizesActor*>(this)));
															#line 2092 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ChangeSizesActorState();
		static_cast<ChangeSizesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 413 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = yield(TaskPriority::DataDistribution);
															#line 413 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (static_cast<ChangeSizesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2117 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ChangeSizesActor*>(this)->actor_wait_state = 2;
															#line 413 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ChangeSizesActor, 1, Void >*>(static_cast<ChangeSizesActor*>(this)));
															#line 2122 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 413 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = yield(TaskPriority::DataDistribution);
															#line 413 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (static_cast<ChangeSizesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2133 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ChangeSizesActor*>(this)->actor_wait_state = 2;
															#line 413 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ChangeSizesActor, 1, Void >*>(static_cast<ChangeSizesActor*>(this)));
															#line 2138 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ChangeSizesActor*>(this)->actor_wait_state > 0) static_cast<ChangeSizesActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeSizesActor*>(this)->ActorCallback< ChangeSizesActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeSizesActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeSizes", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeSizesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeSizes", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ChangeSizesActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeSizes", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeSizesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeSizes", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ChangeSizesActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeSizes", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeSizesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeSizes", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 415 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		int64_t newShardsStartingSize = 0;
															#line 416 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		for( const auto& size : sizes ) {
															#line 417 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			newShardsStartingSize += size.get();
															#line 2226 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		}
															#line 420 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		int64_t newSystemShardsStartingSize = 0;
															#line 421 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		for( const auto& systemSize : systemSizes ) {
															#line 422 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			newSystemShardsStartingSize += systemSize.get();
															#line 2234 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		}
															#line 425 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		int64_t totalSizeEstimate = self->dbSizeEstimate->get();
															#line 426 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		DisabledTraceEvent("TrackerChangeSizes") .detail("Context", "changeSizes when " + context) .detail("Keys", keys) .detail("TotalSizeEstimate", totalSizeEstimate) .detail("EndSizeOfOldShards", oldShardsEndingSize) .detail("StartingSizeOfNewShards", newShardsStartingSize);
															#line 432 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		self->dbSizeEstimate->set(totalSizeEstimate + newShardsStartingSize - oldShardsEndingSize);
															#line 433 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		self->systemSizeEstimate += newSystemShardsStartingSize;
															#line 434 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (keys.begin >= systemKeys.begin)
															#line 2246 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		{
															#line 435 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			self->systemSizeEstimate -= oldShardsEndingSize;
															#line 2250 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		}
															#line 437 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!static_cast<ChangeSizesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ChangeSizesActorState(); static_cast<ChangeSizesActor*>(this)->destroy(); return 0; }
															#line 2254 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		new (&static_cast<ChangeSizesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ChangeSizesActorState();
		static_cast<ChangeSizesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 415 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		int64_t newShardsStartingSize = 0;
															#line 416 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		for( const auto& size : sizes ) {
															#line 417 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			newShardsStartingSize += size.get();
															#line 2270 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		}
															#line 420 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		int64_t newSystemShardsStartingSize = 0;
															#line 421 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		for( const auto& systemSize : systemSizes ) {
															#line 422 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			newSystemShardsStartingSize += systemSize.get();
															#line 2278 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		}
															#line 425 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		int64_t totalSizeEstimate = self->dbSizeEstimate->get();
															#line 426 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		DisabledTraceEvent("TrackerChangeSizes") .detail("Context", "changeSizes when " + context) .detail("Keys", keys) .detail("TotalSizeEstimate", totalSizeEstimate) .detail("EndSizeOfOldShards", oldShardsEndingSize) .detail("StartingSizeOfNewShards", newShardsStartingSize);
															#line 432 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		self->dbSizeEstimate->set(totalSizeEstimate + newShardsStartingSize - oldShardsEndingSize);
															#line 433 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		self->systemSizeEstimate += newSystemShardsStartingSize;
															#line 434 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (keys.begin >= systemKeys.begin)
															#line 2290 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		{
															#line 435 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			self->systemSizeEstimate -= oldShardsEndingSize;
															#line 2294 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		}
															#line 437 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!static_cast<ChangeSizesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ChangeSizesActorState(); static_cast<ChangeSizesActor*>(this)->destroy(); return 0; }
															#line 2298 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		new (&static_cast<ChangeSizesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ChangeSizesActorState();
		static_cast<ChangeSizesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ChangeSizesActor*>(this)->actor_wait_state > 0) static_cast<ChangeSizesActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeSizesActor*>(this)->ActorCallback< ChangeSizesActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeSizesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeSizes", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeSizesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeSizes", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ChangeSizesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeSizes", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeSizesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeSizes", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ChangeSizesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeSizes", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeSizesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeSizes", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 398 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	DataDistributionTracker* self;
															#line 398 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	KeyRange keys;
															#line 398 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	int64_t oldShardsEndingSize;
															#line 398 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	std::string context;
															#line 402 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	std::vector<Future<int64_t>> sizes;
															#line 403 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	std::vector<Future<int64_t>> systemSizes;
															#line 2393 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via changeSizes()
															#line 398 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class ChangeSizesActor final : public Actor<Void>, public ActorCallback< ChangeSizesActor, 0, Void >, public ActorCallback< ChangeSizesActor, 1, Void >, public FastAllocated<ChangeSizesActor>, public ChangeSizesActorState<ChangeSizesActor> {
															#line 2398 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
public:
	using FastAllocated<ChangeSizesActor>::operator new;
	using FastAllocated<ChangeSizesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16192652908117508608UL, 9551218069730744576UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ChangeSizesActor, 0, Void >;
friend struct ActorCallback< ChangeSizesActor, 1, Void >;
															#line 398 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	ChangeSizesActor(DataDistributionTracker* const& self,KeyRange const& keys,int64_t const& oldShardsEndingSize,std::string const& context) 
															#line 2416 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ChangeSizesActorState<ChangeSizesActor>(self, keys, oldShardsEndingSize, context),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("changeSizes", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2410211478348430848UL, 17775302493419396352UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeSizesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("changeSizes");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("changeSizes", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ChangeSizesActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ChangeSizesActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 398 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
[[nodiscard]] Future<Void> changeSizes( DataDistributionTracker* const& self, KeyRange const& keys, int64_t const& oldShardsEndingSize, std::string const& context ) {
															#line 398 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	return Future<Void>(new ChangeSizesActor(self, keys, oldShardsEndingSize, context));
															#line 2450 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
}

#line 439 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"

struct HasBeenTrueFor : ReferenceCounted<HasBeenTrueFor> {
	explicit HasBeenTrueFor(const Optional<ShardMetrics>& value) {
		if (value.present()) {
			lowBandwidthStartTime = value.get().lastLowBandwidthStartTime;
			trigger =
			    delayJittered(std::max(0.0, SERVER_KNOBS->DD_MERGE_COALESCE_DELAY + lowBandwidthStartTime - now()),
			                  TaskPriority::DataDistributionLow) ||
			    cleared.getFuture();
		}
	}

	Future<Void> set(double lastLowBandwidthStartTime) {
		if (!trigger.isValid() || lowBandwidthStartTime != lastLowBandwidthStartTime) {
			cleared = Promise<Void>();
			trigger =
			    delayJittered(SERVER_KNOBS->DD_MERGE_COALESCE_DELAY + std::max(lastLowBandwidthStartTime - now(), 0.0),
			                  TaskPriority::DataDistributionLow) ||
			    cleared.getFuture();

			lowBandwidthStartTime = lastLowBandwidthStartTime;
		}
		return trigger;
	}
	void clear() {
		if (!trigger.isValid()) {
			return;
		}
		trigger = Future<Void>();
		cleared.send(Void());
		lowBandwidthStartTime = 0;
	}

	// True if this->value is true and has been true for this->seconds
	bool hasBeenTrueForLongEnough() const { return trigger.isValid() && trigger.isReady(); }

private:
	double lowBandwidthStartTime = 0;
	Future<Void> trigger;
	Promise<Void> cleared;
};

std::string describeSplit(KeyRange keys, Standalone<VectorRef<KeyRef>>& splitKeys) {
	std::string s;
	s += "[" + keys.begin.toString() + ", " + keys.end.toString() + ") -> ";

	for (auto& sk : splitKeys) {
		s += sk.printable() + " ";
	}

	return s;
}
void traceSplit(KeyRange keys, Standalone<VectorRef<KeyRef>>& splitKeys) {
	auto s = describeSplit(keys, splitKeys);
	TraceEvent(SevInfo, "ExecutingShardSplit").detail("AtKeys", s);
}

void executeShardSplit(DataDistributionTracker* self,
                       KeyRange keys,
                       Standalone<VectorRef<KeyRef>> splitKeys,
                       Reference<AsyncVar<Optional<ShardMetrics>>> shardSize,
                       bool relocate,
                       RelocateReason reason) {

	int numShards = splitKeys.size() - 1;
	ASSERT(numShards > 1);

	int skipRange = deterministicRandom()->randomInt(0, numShards);

	auto s = describeSplit(keys, splitKeys);
	TraceEvent(SevInfo, "ExecutingShardSplit").suppressFor(0.5).detail("Splitting", s).detail("NumShards", numShards);

	// The queue can't deal with RelocateShard requests which split an existing shard into three pieces, so
	// we have to send the unskipped ranges in this order (nibbling in from the edges of the old range)
	for (int i = 0; i < skipRange; i++)
		restartShardTrackers(self, KeyRangeRef(splitKeys[i], splitKeys[i + 1]));
	restartShardTrackers(self, KeyRangeRef(splitKeys[skipRange], splitKeys[skipRange + 1]));
	for (int i = numShards - 1; i > skipRange; i--)
		restartShardTrackers(self, KeyRangeRef(splitKeys[i], splitKeys[i + 1]));

	for (int i = 0; i < skipRange; i++) {
		KeyRangeRef r(splitKeys[i], splitKeys[i + 1]);
		self->shardsAffectedByTeamFailure->defineShard(r);
		if (relocate) {
			RelocateShard rs(r, DataMovementReason::SPLIT_SHARD, reason);
			rs.setParentRange(keys);
			self->output.send(rs);
		}
	}
	for (int i = numShards - 1; i > skipRange; i--) {
		KeyRangeRef r(splitKeys[i], splitKeys[i + 1]);
		self->shardsAffectedByTeamFailure->defineShard(r);
		if (relocate) {
			RelocateShard rs(r, DataMovementReason::SPLIT_SHARD, reason);
			rs.setParentRange(keys);
			self->output.send(rs);
		}
	}

	self->actors.add(changeSizes(self, keys, shardSize->get().get().metrics.bytes, "ShardSplit"));
}

struct RangeToSplit {
	RangeMap<Standalone<StringRef>, ShardTrackedData, KeyRangeRef>::iterator shard;
	Standalone<VectorRef<KeyRef>> faultLines;

	RangeToSplit(RangeMap<Standalone<StringRef>, ShardTrackedData, KeyRangeRef>::iterator shard,
	             Standalone<VectorRef<KeyRef>> faultLines)
	  : shard(shard), faultLines(faultLines) {}
};

bool faultLinesMatch(std::vector<RangeToSplit>& ranges, std::vector<std::vector<KeyRef>>& expectedFaultLines) {
	if (ranges.size() != expectedFaultLines.size()) {
		return false;
	}

	for (auto& range : ranges) {
		KeyRangeRef keys = KeyRangeRef(range.shard->begin(), range.shard->end());
		traceSplit(keys, range.faultLines);
	}

	for (int r = 0; r < ranges.size(); r++) {
		if (ranges[r].faultLines.size() != expectedFaultLines[r].size()) {
			return false;
		}
		for (int fl = 0; fl < ranges[r].faultLines.size(); fl++) {
			if (ranges[r].faultLines[fl] != expectedFaultLines[r][fl]) {
				return false;
			}
		}
	}

	return true;
}

															#line 2589 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via shardSplitter()
															#line 574 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
template <class ShardSplitterActor>
															#line 574 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class ShardSplitterActorState {
															#line 2596 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
public:
															#line 574 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	ShardSplitterActorState(DataDistributionTracker* const& self,KeyRange const& keys,Reference<AsyncVar<Optional<ShardMetrics>>> const& shardSize,ShardSizeBounds const& shardBounds,RelocateReason const& reason) 
															#line 574 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
															#line 574 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		 : self(self),
															#line 574 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   keys(keys),
															#line 574 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   shardSize(shardSize),
															#line 574 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   shardBounds(shardBounds),
															#line 574 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   reason(reason),
															#line 579 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   metrics(shardSize->get().get().metrics),
															#line 580 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   bandwidthStatus(getBandwidthStatus(metrics))
															#line 2615 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("shardSplitter", reinterpret_cast<unsigned long>(this));

	}
	~ShardSplitterActorState() 
	{
		fdb_probe_actor_destroy("shardSplitter", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 583 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			CODE_PROBE(true, "shard to be split");
															#line 585 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			StorageMetrics splitMetrics;
															#line 586 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			splitMetrics.bytes = shardBounds.max.bytes / 2;
															#line 587 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			splitMetrics.bytesWrittenPerKSecond = keys.begin >= keyServersKeys.begin ? splitMetrics.infinity : SERVER_KNOBS->SHARD_SPLIT_BYTES_PER_KSEC;
															#line 589 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			splitMetrics.iosPerKSecond = splitMetrics.infinity;
															#line 590 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			splitMetrics.bytesReadPerKSecond = splitMetrics.infinity;
															#line 592 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			StrictFuture<Standalone<VectorRef<KeyRef>>> __when_expr_0 = self->db->splitStorageMetrics(keys, splitMetrics, metrics, SERVER_KNOBS->MIN_SHARD_BYTES);
															#line 592 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (static_cast<ShardSplitterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2644 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ShardSplitterActor*>(this)->actor_wait_state = 1;
															#line 592 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ShardSplitterActor, 0, Standalone<VectorRef<KeyRef>> >*>(static_cast<ShardSplitterActor*>(this)));
															#line 2649 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ShardSplitterActorState();
		static_cast<ShardSplitterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 598 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		int numShards = splitKeys.size() - 1;
															#line 600 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		TraceEvent("RelocateShardStartSplit", self->distributorId) .suppressFor(1.0) .detail("Begin", keys.begin) .detail("End", keys.end) .detail("MaxBytes", shardBounds.max.bytes) .detail("MetricsBytes", metrics.bytes) .detail("Bandwidth", bandwidthStatus == BandwidthStatusHigh ? "High" : bandwidthStatus == BandwidthStatusNormal ? "Normal" : "Low") .detail("BytesWrittenPerKSec", metrics.bytesWrittenPerKSecond) .detail("NumShards", numShards);
															#line 613 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (numShards > 1)
															#line 2676 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		{
															#line 614 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			executeShardSplit(self, keys, splitKeys, shardSize, true, reason);
															#line 2680 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			loopDepth = a_body1cont2(loopDepth);
		}
		else
		{
															#line 616 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(1.0, TaskPriority::DataDistribution);
															#line 616 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (static_cast<ShardSplitterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2689 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ShardSplitterActor*>(this)->actor_wait_state = 2;
															#line 616 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ShardSplitterActor, 1, Void >*>(static_cast<ShardSplitterActor*>(this)));
															#line 2694 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1when1(Standalone<VectorRef<KeyRef>> const& __splitKeys,int loopDepth) 
	{
															#line 592 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		splitKeys = __splitKeys;
															#line 2704 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Standalone<VectorRef<KeyRef>> && __splitKeys,int loopDepth) 
	{
		splitKeys = std::move(__splitKeys);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ShardSplitterActor*>(this)->actor_wait_state > 0) static_cast<ShardSplitterActor*>(this)->actor_wait_state = 0;
		static_cast<ShardSplitterActor*>(this)->ActorCallback< ShardSplitterActor, 0, Standalone<VectorRef<KeyRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< ShardSplitterActor, 0, Standalone<VectorRef<KeyRef>> >*,Standalone<VectorRef<KeyRef>> const& value) 
	{
		fdb_probe_actor_enter("shardSplitter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShardSplitterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardSplitter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ShardSplitterActor, 0, Standalone<VectorRef<KeyRef>> >*,Standalone<VectorRef<KeyRef>> && value) 
	{
		fdb_probe_actor_enter("shardSplitter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShardSplitterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardSplitter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ShardSplitterActor, 0, Standalone<VectorRef<KeyRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("shardSplitter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ShardSplitterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardSplitter", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 619 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!static_cast<ShardSplitterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ShardSplitterActorState(); static_cast<ShardSplitterActor*>(this)->destroy(); return 0; }
															#line 2783 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		new (&static_cast<ShardSplitterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ShardSplitterActorState();
		static_cast<ShardSplitterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ShardSplitterActor*>(this)->actor_wait_state > 0) static_cast<ShardSplitterActor*>(this)->actor_wait_state = 0;
		static_cast<ShardSplitterActor*>(this)->ActorCallback< ShardSplitterActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ShardSplitterActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("shardSplitter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShardSplitterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardSplitter", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ShardSplitterActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("shardSplitter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShardSplitterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardSplitter", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ShardSplitterActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("shardSplitter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ShardSplitterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardSplitter", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 574 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	DataDistributionTracker* self;
															#line 574 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	KeyRange keys;
															#line 574 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	Reference<AsyncVar<Optional<ShardMetrics>>> shardSize;
															#line 574 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	ShardSizeBounds shardBounds;
															#line 574 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	RelocateReason reason;
															#line 579 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	StorageMetrics metrics;
															#line 580 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	BandwidthStatus bandwidthStatus;
															#line 592 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	Standalone<VectorRef<KeyRef>> splitKeys;
															#line 2894 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via shardSplitter()
															#line 574 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class ShardSplitterActor final : public Actor<Void>, public ActorCallback< ShardSplitterActor, 0, Standalone<VectorRef<KeyRef>> >, public ActorCallback< ShardSplitterActor, 1, Void >, public FastAllocated<ShardSplitterActor>, public ShardSplitterActorState<ShardSplitterActor> {
															#line 2899 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
public:
	using FastAllocated<ShardSplitterActor>::operator new;
	using FastAllocated<ShardSplitterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15580111379734949632UL, 14677013448479817728UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ShardSplitterActor, 0, Standalone<VectorRef<KeyRef>> >;
friend struct ActorCallback< ShardSplitterActor, 1, Void >;
															#line 574 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	ShardSplitterActor(DataDistributionTracker* const& self,KeyRange const& keys,Reference<AsyncVar<Optional<ShardMetrics>>> const& shardSize,ShardSizeBounds const& shardBounds,RelocateReason const& reason) 
															#line 2917 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ShardSplitterActorState<ShardSplitterActor>(self, keys, shardSize, shardBounds, reason),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("shardSplitter", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8500483300706847744UL, 11633084953466301952UL);
		ActorExecutionContextHelper __helper(static_cast<ShardSplitterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("shardSplitter");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("shardSplitter", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ShardSplitterActor, 0, Standalone<VectorRef<KeyRef>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ShardSplitterActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 574 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
[[nodiscard]] Future<Void> shardSplitter( DataDistributionTracker* const& self, KeyRange const& keys, Reference<AsyncVar<Optional<ShardMetrics>>> const& shardSize, ShardSizeBounds const& shardBounds, RelocateReason const& reason ) {
															#line 574 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	return Future<Void>(new ShardSplitterActor(self, keys, shardSize, shardBounds, reason));
															#line 2951 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
}

#line 621 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"

															#line 2956 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via brokenPromiseToReady()
															#line 622 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
template <class BrokenPromiseToReadyActor>
															#line 622 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class BrokenPromiseToReadyActorState {
															#line 2963 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
public:
															#line 622 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	BrokenPromiseToReadyActorState(Future<Void> const& f) 
															#line 622 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
															#line 622 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		 : f(f)
															#line 2970 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("brokenPromiseToReady", reinterpret_cast<unsigned long>(this));

	}
	~BrokenPromiseToReadyActorState() 
	{
		fdb_probe_actor_destroy("brokenPromiseToReady", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 624 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				StrictFuture<Void> __when_expr_0 = f;
															#line 624 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				if (static_cast<BrokenPromiseToReadyActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 2988 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<BrokenPromiseToReadyActor*>(this)->actor_wait_state = 1;
															#line 624 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BrokenPromiseToReadyActor, 0, Void >*>(static_cast<BrokenPromiseToReadyActor*>(this)));
															#line 2993 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BrokenPromiseToReadyActorState();
		static_cast<BrokenPromiseToReadyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 630 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!static_cast<BrokenPromiseToReadyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BrokenPromiseToReadyActorState(); static_cast<BrokenPromiseToReadyActor*>(this)->destroy(); return 0; }
															#line 3022 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		new (&static_cast<BrokenPromiseToReadyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~BrokenPromiseToReadyActorState();
		static_cast<BrokenPromiseToReadyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 626 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (e.code() != error_code_broken_promise)
															#line 3035 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			{
															#line 627 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 3039 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BrokenPromiseToReadyActor*>(this)->actor_wait_state > 0) static_cast<BrokenPromiseToReadyActor*>(this)->actor_wait_state = 0;
		static_cast<BrokenPromiseToReadyActor*>(this)->ActorCallback< BrokenPromiseToReadyActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BrokenPromiseToReadyActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("brokenPromiseToReady", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BrokenPromiseToReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("brokenPromiseToReady", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BrokenPromiseToReadyActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("brokenPromiseToReady", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BrokenPromiseToReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("brokenPromiseToReady", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BrokenPromiseToReadyActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("brokenPromiseToReady", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BrokenPromiseToReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("brokenPromiseToReady", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 622 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	Future<Void> f;
															#line 3153 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via brokenPromiseToReady()
															#line 622 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class BrokenPromiseToReadyActor final : public Actor<Void>, public ActorCallback< BrokenPromiseToReadyActor, 0, Void >, public FastAllocated<BrokenPromiseToReadyActor>, public BrokenPromiseToReadyActorState<BrokenPromiseToReadyActor> {
															#line 3158 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
public:
	using FastAllocated<BrokenPromiseToReadyActor>::operator new;
	using FastAllocated<BrokenPromiseToReadyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11498295149669266688UL, 684006972953436672UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BrokenPromiseToReadyActor, 0, Void >;
															#line 622 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	BrokenPromiseToReadyActor(Future<Void> const& f) 
															#line 3175 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   BrokenPromiseToReadyActorState<BrokenPromiseToReadyActor>(f),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("brokenPromiseToReady", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10854979289586105344UL, 2195692730666635776UL);
		ActorExecutionContextHelper __helper(static_cast<BrokenPromiseToReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("brokenPromiseToReady");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("brokenPromiseToReady", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BrokenPromiseToReadyActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 622 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
[[nodiscard]] Future<Void> brokenPromiseToReady( Future<Void> const& f ) {
															#line 622 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	return Future<Void>(new BrokenPromiseToReadyActor(f));
															#line 3208 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
}

#line 632 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"

static bool shardForwardMergeFeasible(DataDistributionTracker* self, KeyRange const& keys, KeyRangeRef nextRange) {
	if (keys.end == allKeys.end) {
		return false;
	}

	if (self->userRangeConfig->rangeContaining(keys.begin)->range().end < nextRange.end) {
		return false;
	}

	if (self->bulkLoadEnabled && self->bulkLoadTaskCollection->bulkLoading(nextRange)) {
		TraceEvent(SevWarn, "ShardCanForwardMergeButUnderBulkLoading", self->distributorId)
		    .suppressFor(5.0)
		    .detail("ShardMerging", keys)
		    .detail("NextShard", nextRange);
		return false;
	}

	return true;
}

static bool shardBackwardMergeFeasible(DataDistributionTracker* self, KeyRange const& keys, KeyRangeRef prevRange) {
	if (keys.begin == allKeys.begin) {
		return false;
	}

	if (self->userRangeConfig->rangeContaining(keys.begin)->range().begin > prevRange.begin) {
		return false;
	}

	if (self->bulkLoadEnabled && self->bulkLoadTaskCollection->bulkLoading(prevRange)) {
		TraceEvent(SevWarn, "ShardCanBackwardMergeButUnderBulkLoading", self->distributorId)
		    .suppressFor(5.0)
		    .detail("ShardMerging", keys)
		    .detail("PrevShard", prevRange);
		return false;
	}

	return true;
}

// Must be atomic
// If cancelledDataMovePriority is set, we may need to issue a data move for the task range because previous data move
// has been stuck and forced to exit. If that data move is an team unhealthy data move, we need to issue a new data
// move.
void createShardToBulkLoad(DataDistributionTracker* self,
                           const BulkLoadTaskState& bulkLoadTaskState,
                           Optional<int> cancelledDataMovePriority) {
	KeyRange keys = bulkLoadTaskState.getRange();
	ASSERT(!keys.empty());
	bool issueDataMoveForCancel = cancelledDataMovePriority.present();
	TraceEvent e(issueDataMoveForCancel ? SevWarnAlways : bulkLoadVerboseEventSev(),
	             "DDBulkLoadEngineCreateShardToBulkLoad",
	             self->distributorId);
	e.detail("TaskID", bulkLoadTaskState.getTaskId());
	e.detail("BulkLoadRange", keys);
	// Create shards at the two ends and do not data move for those shards
	// Create a new shard and trigger data move for bulk loading on the new shard
	// Step 1: split left without data move nor updating dbEstimate size (will be rebuilt after DD restarts)
	for (auto it : self->shards->intersectingRanges(keys)) {
		if (it->range().begin < keys.begin) {
			KeyRange leftRange = Standalone(KeyRangeRef(it->range().begin, keys.begin));
			e.detail("FirstSplitShard", it->range());
			restartShardTrackers(self, leftRange);
			issueDataMoveForCancel = false;
			// Shard boundary has changed. So, there has a shard split or merge data move as a normal data move.
			// Or a new bulkload task has been issued on the range. So, we need not issue data move at this time.
		}
		break;
	}

	// Step 2: split right without data move nor updating dbEstimate size (will be rebuilt after DD restarts)
	for (auto it : self->shards->intersectingRanges(keys)) {
		if (it->range().end > keys.end) {
			KeyRange rightRange = Standalone(KeyRangeRef(keys.end, it->range().end));
			e.detail("LastSplitShard", it->range());
			restartShardTrackers(self, rightRange);
			issueDataMoveForCancel = false;
			// See comments at Step 1
			break;
		}
	}

	// Step 3: merge with new data move
	StorageMetrics oldStats;
	int shardCount = 0;
	for (auto it : self->shards->intersectingRanges(keys)) {
		Reference<AsyncVar<Optional<ShardMetrics>>> stats;
		if (it->value().stats->get().present()) {
			oldStats = oldStats + it->value().stats->get().get().metrics;
			shardCount = shardCount + it->value().stats->get().get().shardCount;
		}
	}
	if (!cancelledDataMovePriority.present()) {
		// If this is for a new bulkload task
		restartShardTrackers(self, keys, ShardMetrics(oldStats, now(), shardCount));
		self->shardsAffectedByTeamFailure->defineShard(keys);
		self->output.send(RelocateShard(
		    keys, DataMovementReason::TEAM_HEALTHY, RelocateReason::OTHER, bulkLoadTaskState.getTaskId()));
	} else if (issueDataMoveForCancel) {
		// If this is for a cancelled task
		restartShardTrackers(self, keys, ShardMetrics(oldStats, now(), shardCount));
		self->shardsAffectedByTeamFailure->defineShard(keys);
		ASSERT(cancelledDataMovePriority.present() &&
		       cancelledDataMovePriority.get() != SERVER_KNOBS->PRIORITY_TEAM_HEALTHY);
		self->output.send(RelocateShard(keys,
		                                priorityToDataMovementReason(cancelledDataMovePriority.get()),
		                                RelocateReason::OTHER,
		                                bulkLoadTaskState.getTaskId()));
	}
	e.detail("NewShardToLoad", keys);
	e.detail("CancelledDataMove", cancelledDataMovePriority.present() ? cancelledDataMovePriority.get() : -1);
	e.detail("IssueDataMoveForCancel", issueDataMoveForCancel);
	return;
}

Future<Void> shardMerger(DataDistributionTracker* self,
                         KeyRange const& keys,
                         Reference<AsyncVar<Optional<ShardMetrics>>> shardSize) {
	const UID actionId = deterministicRandom()->randomUniqueID();
	const Severity stSev = static_cast<Severity>(SERVER_KNOBS->DD_SHARD_TRACKING_LOG_SEVERITY);
	int64_t maxShardSize = self->maxShardSize->get().get();

	auto prevIter = self->shards->rangeContaining(keys.begin);
	auto nextIter = self->shards->rangeContaining(keys.begin);

	CODE_PROBE(true, "shard to be merged");
	ASSERT(keys.begin > allKeys.begin);

	// This will merge shards both before and after "this" shard in keyspace.
	int shardsMerged = 1;
	bool forwardComplete = false;
	KeyRangeRef merged;

	StorageMetrics endingStats = shardSize->get().get().metrics;
	int shardCount = shardSize->get().get().shardCount;
	double lastLowBandwidthStartTime = shardSize->get().get().lastLowBandwidthStartTime;
	if (FLOW_KNOBS->DELAY_JITTER_OFFSET * SERVER_KNOBS->DD_MERGE_COALESCE_DELAY >
	        SERVER_KNOBS->DD_LOW_BANDWIDTH_DELAY &&
	    now() - lastLowBandwidthStartTime < SERVER_KNOBS->DD_LOW_BANDWIDTH_DELAY) {
		TraceEvent(g_network->isSimulated() ? SevError : SevWarnAlways, "ShardMergeTooSoon", self->distributorId)
		    .detail("Keys", keys)
		    .detail("LastLowBandwidthStartTime", lastLowBandwidthStartTime);
	}

	int64_t systemBytes = keys.begin >= systemKeys.begin ? shardSize->get().get().metrics.bytes : 0;

	loop {
		Optional<ShardMetrics> newMetrics;
		if (!forwardComplete) {
			if (nextIter->range().end == allKeys.end) {
				forwardComplete = true;
				continue;
			}

			++nextIter;
			if (!shardForwardMergeFeasible(self, keys, nextIter->range())) {
				--nextIter;
				forwardComplete = true;
				continue;
			}

			newMetrics = nextIter->value().stats->get();

			// If going forward, give up when the next shard's stats are not yet present, or if the
			// the shard is already over the merge bounds.
			const int newCount = newMetrics.present() ? (shardCount + newMetrics.get().shardCount) : shardCount;
			const int64_t newSize =
			    newMetrics.present() ? (endingStats.bytes + newMetrics.get().metrics.bytes) : endingStats.bytes;
			if (!newMetrics.present() || newCount >= CLIENT_KNOBS->SHARD_COUNT_LIMIT || newSize > maxShardSize) {
				if (shardsMerged == 1) {
					TraceEvent(stSev, "ShardMergeStopForward", self->distributorId)
					    .detail("ActionID", actionId)
					    .detail("Keys", keys)
					    .detail("MetricsPresent", newMetrics.present())
					    .detail("ShardCount", newCount)
					    .detail("ShardSize", newSize)
					    .detail("MaxShardSize", maxShardSize);
				}
				--nextIter;
				forwardComplete = true;
				continue;
			}
		} else {
			--prevIter;
			newMetrics = prevIter->value().stats->get();

			if (!shardBackwardMergeFeasible(self, keys, prevIter->range())) {
				++prevIter;
				break;
			}

			// If going backward, stop when the stats are not present or if the shard is already over the merge
			//  bounds. If this check triggers right away (if we have not merged anything) then return a trigger
			//  on the previous shard changing "size".
			const int newCount = newMetrics.present() ? (shardCount + newMetrics.get().shardCount) : shardCount;
			const int64_t newSize =
			    newMetrics.present() ? (endingStats.bytes + newMetrics.get().metrics.bytes) : endingStats.bytes;
			if (!newMetrics.present() || newCount >= CLIENT_KNOBS->SHARD_COUNT_LIMIT || newSize > maxShardSize) {
				if (shardsMerged == 1) {
					TraceEvent(stSev, "ShardMergeStopBackward", self->distributorId)
					    .detail("ActionID", actionId)
					    .detail("Keys", keys)
					    .detail("MetricsPresent", newMetrics.present())
					    .detail("ShardCount", newCount)
					    .detail("ShardSize", newSize)
					    .detail("MaxShardSize", maxShardSize);
					CODE_PROBE(true, "shardMerger cannot merge anything");
					return brokenPromiseToReady(prevIter->value().stats->onChange());
				}

				++prevIter;
				break;
			}
		}

		merged = KeyRangeRef(prevIter->range().begin, nextIter->range().end);
		endingStats += newMetrics.get().metrics;
		shardCount += newMetrics.get().shardCount;
		lastLowBandwidthStartTime = newMetrics.get().lastLowBandwidthStartTime;
		if ((forwardComplete ? prevIter->range().begin : nextIter->range().begin) >= systemKeys.begin) {
			systemBytes += newMetrics.get().metrics.bytes;
		}
		shardsMerged++;

		auto shardBounds = getShardSizeBounds(merged, maxShardSize);
		// If we just recently get the current shard's metrics (i.e., less than DD_LOW_BANDWIDTH_DELAY ago), it
		// means the shard's metric may not be stable yet. So we cannot continue merging in this direction.
		if (endingStats.bytes >= shardBounds.min.bytes || getBandwidthStatus(endingStats) != BandwidthStatusLow ||
		    now() - lastLowBandwidthStartTime < SERVER_KNOBS->DD_LOW_BANDWIDTH_DELAY ||
		    shardsMerged >= SERVER_KNOBS->DD_MERGE_LIMIT) {
			// The merged range is larger than the min bounds so we cannot continue merging in this direction.
			//  This means that:
			//  1. If we were going forwards (the starting direction), we roll back the last speculative merge.
			//      In this direction we do not want to go above this boundary since we will merge at least one in
			//      the other direction, even when that goes over the bounds.
			//  2. If we were going backwards we always want to merge one more shard on (to make sure we go over
			//      the shard min bounds) so we "break" without resetting the merged range.
			if (forwardComplete)
				break;

			shardsMerged--;
			if (shardsMerged == 1) {
				TraceEvent(stSev, "ShardMergeUndoForward", self->distributorId)
				    .detail("ActionID", actionId)
				    .detail("Keys", keys)
				    .detail("ShardCount", shardCount)
				    .detail("EndingMetrics", endingStats.toString())
				    .detail("MaxShardSize", maxShardSize);
			}
			// If going forward, remove most recently added range
			endingStats -= newMetrics.get().metrics;
			shardCount -= newMetrics.get().shardCount;
			if (nextIter->range().begin >= systemKeys.begin) {
				systemBytes -= newMetrics.get().metrics.bytes;
			}
			--nextIter;
			merged = KeyRangeRef(prevIter->range().begin, nextIter->range().end);
			forwardComplete = true;
		}
	}

	if (shardsMerged == 1) {
		return brokenPromiseToReady(nextIter->value().stats->onChange());
	}

	// restarting shard tracker will dereference values in the shard map, so make a copy
	KeyRange mergeRange = merged;

	// OldKeys: Shards in the key range are merged as one shard defined by NewKeys;
	// NewKeys: New key range after shards are merged;
	// EndingSize: The new merged shard size in bytes;
	// BatchedMerges: The number of shards merged. Each shard is defined in self->shards;
	// LastLowBandwidthStartTime: When does a shard's bandwidth status becomes BandwidthStatusLow. If a shard's
	// status
	//   becomes BandwidthStatusLow less than DD_LOW_BANDWIDTH_DELAY ago, the merging logic will stop at the shard;
	// ShardCount: The number of non-splittable shards that are merged. Each shard is defined in self->shards may
	// have
	//   more than 1 shards.
	TraceEvent("RelocateShardMergeMetrics", self->distributorId)
	    .detail("OldKeys", keys)
	    .detail("NewKeys", mergeRange)
	    .detail("EndingSize", endingStats.bytes)
	    .detail("BatchedMerges", shardsMerged)
	    .detail("LastLowBandwidthStartTime", lastLowBandwidthStartTime)
	    .detail("ShardCount", shardCount);

	if (mergeRange.begin < systemKeys.begin) {
		self->systemSizeEstimate -= systemBytes;
	}
	restartShardTrackers(self, mergeRange, ShardMetrics(endingStats, lastLowBandwidthStartTime, shardCount));
	self->shardsAffectedByTeamFailure->defineShard(mergeRange);
	self->output.send(RelocateShard(mergeRange, DataMovementReason::MERGE_SHARD, RelocateReason::MERGE_SHARD));

	// We are about to be cancelled by the call to restartShardTrackers
	return Void();
}

															#line 3510 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via shardEvaluator()
															#line 930 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
template <class ShardEvaluatorActor>
															#line 930 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class ShardEvaluatorActorState {
															#line 3517 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
public:
															#line 930 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	ShardEvaluatorActorState(DataDistributionTracker* const& self,KeyRange const& keys,Reference<AsyncVar<Optional<ShardMetrics>>> const& shardSize,Reference<HasBeenTrueFor> const& wantsToMerge) 
															#line 930 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
															#line 930 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		 : self(self),
															#line 930 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   keys(keys),
															#line 930 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   shardSize(shardSize),
															#line 930 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   wantsToMerge(wantsToMerge)
															#line 3530 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("shardEvaluator", reinterpret_cast<unsigned long>(this));

	}
	~ShardEvaluatorActorState() 
	{
		fdb_probe_actor_destroy("shardEvaluator", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 934 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			Future<Void> onChange = shardSize->onChange() || yieldedFuture(self->maxShardSize->onChange());
															#line 939 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			ShardSizeBounds shardBounds = getShardSizeBounds(keys, self->maxShardSize->get().get());
															#line 940 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			StorageMetrics const& stats = shardSize->get().get().metrics;
															#line 941 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			auto bandwidthStatus = getBandwidthStatus(stats);
															#line 943 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			bool sizeSplit = stats.bytes > shardBounds.max.bytes, writeSplit = bandwidthStatus == BandwidthStatusHigh && keys.begin < keyServersKeys.begin;
															#line 945 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			bool shouldSplit = sizeSplit || writeSplit;
															#line 947 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			auto prevIter = self->shards->rangeContaining(keys.begin);
															#line 948 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (keys.begin > allKeys.begin)
															#line 3559 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			{
															#line 949 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				--prevIter;
															#line 3563 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			}
															#line 951 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			auto nextIter = self->shards->rangeContaining(keys.begin);
															#line 952 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (keys.end < allKeys.end)
															#line 3569 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			{
															#line 953 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				++nextIter;
															#line 3573 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			}
															#line 955 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			bool shouldMerge = stats.bytes < shardBounds.min.bytes && bandwidthStatus == BandwidthStatusLow && (shardForwardMergeFeasible(self, keys, nextIter.range()) || shardBackwardMergeFeasible(self, keys, prevIter.range()));
															#line 960 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (shouldMerge && !self->anyZeroHealthyTeams->get())
															#line 3579 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			{
															#line 961 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				auto whenLongEnough = wantsToMerge->set(shardSize->get().get().lastLowBandwidthStartTime);
															#line 962 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				if (!wantsToMerge->hasBeenTrueForLongEnough())
															#line 3585 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
				{
															#line 963 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
					onChange = onChange || whenLongEnough;
															#line 3589 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
				}
			}
			else
			{
															#line 966 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				wantsToMerge->clear();
															#line 967 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				if (shouldMerge)
															#line 3598 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
				{
															#line 968 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
					onChange = onChange || self->anyZeroHealthyTeams->onChange();
															#line 3602 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
				}
			}
															#line 984 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (!self->anyZeroHealthyTeams->get() && wantsToMerge->hasBeenTrueForLongEnough())
															#line 3607 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			{
															#line 985 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				onChange = onChange || shardMerger(self, keys, shardSize);
															#line 3611 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			}
															#line 987 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (shouldSplit)
															#line 3615 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			{
															#line 988 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				RelocateReason reason = sizeSplit ? RelocateReason::SIZE_SPLIT : RelocateReason::WRITE_SPLIT;
															#line 989 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				onChange = onChange || shardSplitter(self, keys, shardSize, shardBounds, reason);
															#line 3621 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			}
															#line 992 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = onChange;
															#line 992 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (static_cast<ShardEvaluatorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3627 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ShardEvaluatorActor*>(this)->actor_wait_state = 1;
															#line 992 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ShardEvaluatorActor, 0, Void >*>(static_cast<ShardEvaluatorActor*>(this)));
															#line 3632 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ShardEvaluatorActorState();
		static_cast<ShardEvaluatorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 993 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!static_cast<ShardEvaluatorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ShardEvaluatorActorState(); static_cast<ShardEvaluatorActor*>(this)->destroy(); return 0; }
															#line 3655 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		new (&static_cast<ShardEvaluatorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ShardEvaluatorActorState();
		static_cast<ShardEvaluatorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 993 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!static_cast<ShardEvaluatorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ShardEvaluatorActorState(); static_cast<ShardEvaluatorActor*>(this)->destroy(); return 0; }
															#line 3667 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		new (&static_cast<ShardEvaluatorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ShardEvaluatorActorState();
		static_cast<ShardEvaluatorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ShardEvaluatorActor*>(this)->actor_wait_state > 0) static_cast<ShardEvaluatorActor*>(this)->actor_wait_state = 0;
		static_cast<ShardEvaluatorActor*>(this)->ActorCallback< ShardEvaluatorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ShardEvaluatorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("shardEvaluator", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShardEvaluatorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardEvaluator", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ShardEvaluatorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("shardEvaluator", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShardEvaluatorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardEvaluator", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ShardEvaluatorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("shardEvaluator", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ShardEvaluatorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardEvaluator", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 930 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	DataDistributionTracker* self;
															#line 930 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	KeyRange keys;
															#line 930 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	Reference<AsyncVar<Optional<ShardMetrics>>> shardSize;
															#line 930 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	Reference<HasBeenTrueFor> wantsToMerge;
															#line 3758 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via shardEvaluator()
															#line 930 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class ShardEvaluatorActor final : public Actor<Void>, public ActorCallback< ShardEvaluatorActor, 0, Void >, public FastAllocated<ShardEvaluatorActor>, public ShardEvaluatorActorState<ShardEvaluatorActor> {
															#line 3763 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
public:
	using FastAllocated<ShardEvaluatorActor>::operator new;
	using FastAllocated<ShardEvaluatorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7069737145759479552UL, 15389042452394294272UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ShardEvaluatorActor, 0, Void >;
															#line 930 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	ShardEvaluatorActor(DataDistributionTracker* const& self,KeyRange const& keys,Reference<AsyncVar<Optional<ShardMetrics>>> const& shardSize,Reference<HasBeenTrueFor> const& wantsToMerge) 
															#line 3780 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ShardEvaluatorActorState<ShardEvaluatorActor>(self, keys, shardSize, wantsToMerge),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("shardEvaluator", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8816555440906647552UL, 5907959878536576768UL);
		ActorExecutionContextHelper __helper(static_cast<ShardEvaluatorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("shardEvaluator");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("shardEvaluator", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ShardEvaluatorActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 930 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
[[nodiscard]] Future<Void> shardEvaluator( DataDistributionTracker* const& self, KeyRange const& keys, Reference<AsyncVar<Optional<ShardMetrics>>> const& shardSize, Reference<HasBeenTrueFor> const& wantsToMerge ) {
															#line 930 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	return Future<Void>(new ShardEvaluatorActor(self, keys, shardSize, wantsToMerge));
															#line 3813 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
}

#line 995 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"

															#line 3818 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via shardTracker()
															#line 996 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
template <class ShardTrackerActor>
															#line 996 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class ShardTrackerActorState {
															#line 3825 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
public:
															#line 996 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	ShardTrackerActorState(DataDistributionTracker::SafeAccessor const& self,KeyRange const& keys,Reference<AsyncVar<Optional<ShardMetrics>>> const& shardSize) 
															#line 996 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
															#line 996 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		 : self(self),
															#line 996 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   keys(keys),
															#line 996 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   shardSize(shardSize)
															#line 3836 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("shardTracker", reinterpret_cast<unsigned long>(this));

	}
	~ShardTrackerActorState() 
	{
		fdb_probe_actor_destroy("shardTracker", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 999 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = yieldedFuture(self()->readyToStart.getFuture());
															#line 999 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (static_cast<ShardTrackerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3853 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ShardTrackerActor*>(this)->actor_wait_state = 1;
															#line 999 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ShardTrackerActor, 0, Void >*>(static_cast<ShardTrackerActor*>(this)));
															#line 3858 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ShardTrackerActorState();
		static_cast<ShardTrackerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1001 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!shardSize->get().present())
															#line 3881 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		{
															#line 1002 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			StrictFuture<Void> __when_expr_1 = shardSize->onChange();
															#line 1002 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (static_cast<ShardTrackerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3887 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ShardTrackerActor*>(this)->actor_wait_state = 2;
															#line 1002 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ShardTrackerActor, 1, Void >*>(static_cast<ShardTrackerActor*>(this)));
															#line 3892 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1001 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!shardSize->get().present())
															#line 3906 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		{
															#line 1002 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			StrictFuture<Void> __when_expr_1 = shardSize->onChange();
															#line 1002 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (static_cast<ShardTrackerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3912 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ShardTrackerActor*>(this)->actor_wait_state = 2;
															#line 1002 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ShardTrackerActor, 1, Void >*>(static_cast<ShardTrackerActor*>(this)));
															#line 3917 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ShardTrackerActor*>(this)->actor_wait_state > 0) static_cast<ShardTrackerActor*>(this)->actor_wait_state = 0;
		static_cast<ShardTrackerActor*>(this)->ActorCallback< ShardTrackerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ShardTrackerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("shardTracker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShardTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardTracker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ShardTrackerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("shardTracker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShardTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardTracker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ShardTrackerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("shardTracker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ShardTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardTracker", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1004 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!self()->maxShardSize->get().present())
															#line 4006 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		{
															#line 1005 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			StrictFuture<Void> __when_expr_2 = yieldedFuture(self()->maxShardSize->onChange());
															#line 1005 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (static_cast<ShardTrackerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4012 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<ShardTrackerActor*>(this)->actor_wait_state = 3;
															#line 1005 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ShardTrackerActor, 2, Void >*>(static_cast<ShardTrackerActor*>(this)));
															#line 4017 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ShardTrackerActor*>(this)->actor_wait_state > 0) static_cast<ShardTrackerActor*>(this)->actor_wait_state = 0;
		static_cast<ShardTrackerActor*>(this)->ActorCallback< ShardTrackerActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ShardTrackerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("shardTracker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShardTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardTracker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ShardTrackerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("shardTracker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShardTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardTracker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ShardTrackerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("shardTracker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ShardTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardTracker", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 1008 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(0, TaskPriority::DataDistribution);
															#line 1008 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (static_cast<ShardTrackerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4120 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<ShardTrackerActor*>(this)->actor_wait_state = 4;
															#line 1008 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ShardTrackerActor, 3, Void >*>(static_cast<ShardTrackerActor*>(this)));
															#line 4125 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ShardTrackerActor*>(this)->actor_wait_state > 0) static_cast<ShardTrackerActor*>(this)->actor_wait_state = 0;
		static_cast<ShardTrackerActor*>(this)->ActorCallback< ShardTrackerActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ShardTrackerActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("shardTracker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShardTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardTracker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ShardTrackerActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("shardTracker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShardTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardTracker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ShardTrackerActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("shardTracker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ShardTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardTracker", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 1011 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		wantsToMerge = Reference<HasBeenTrueFor>(new HasBeenTrueFor(shardSize->get()));
															#line 4221 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		try {
															#line 1022 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			;
															#line 4225 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			loopDepth = a_body1cont6loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont6Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont6Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 1011 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		wantsToMerge = Reference<HasBeenTrueFor>(new HasBeenTrueFor(shardSize->get()));
															#line 4240 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		try {
															#line 1022 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			;
															#line 4244 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			loopDepth = a_body1cont6loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont6Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont6Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ShardTrackerActor*>(this)->actor_wait_state > 0) static_cast<ShardTrackerActor*>(this)->actor_wait_state = 0;
		static_cast<ShardTrackerActor*>(this)->ActorCallback< ShardTrackerActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ShardTrackerActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("shardTracker", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShardTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardTracker", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ShardTrackerActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("shardTracker", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShardTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardTracker", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ShardTrackerActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("shardTracker", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ShardTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardTracker", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont6Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1039 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (e.code() != error_code_actor_cancelled && e.code() != error_code_dd_tracker_cancelled)
															#line 4335 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			{
															#line 1040 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				self()->output.sendError(e);
															#line 4339 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			}
															#line 1042 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 4343 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont6loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1(int loopDepth) 
	{
															#line 1023 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		;
															#line 4364 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont6loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont1(int loopDepth) 
	{
															#line 1032 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		StrictFuture<Void> __when_expr_5 = shardEvaluator(self(), keys, shardSize, wantsToMerge);
															#line 1032 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (static_cast<ShardTrackerActor*>(this)->actor_wait_state < 0) return a_body1cont6Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4375 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont6Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont6loopBody1cont1when1(__when_expr_5.get(), loopDepth); };
		static_cast<ShardTrackerActor*>(this)->actor_wait_state = 6;
															#line 1032 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ShardTrackerActor, 5, Void >*>(static_cast<ShardTrackerActor*>(this)));
															#line 4380 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont6loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1loopBody1(int loopDepth) 
	{
															#line 1023 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!(self()->bulkLoadEnabled && self()->bulkLoadTaskCollection->bulkLoading(keys)))
															#line 4396 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		{
			return a_body1cont6loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1024 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		TraceEvent(SevWarn, "ShardBoundaryChangeDisabledForBulkLoad", self()->distributorId) .suppressFor(60.0) .detail("KeyRange", keys);
															#line 1027 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		StrictFuture<Void> __when_expr_4 = delay(SERVER_KNOBS->DD_BULKLOAD_SHARD_BOUNDARY_CHANGE_DELAY_SEC * deterministicRandom()->random01() + 60);
															#line 1027 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (static_cast<ShardTrackerActor*>(this)->actor_wait_state < 0) return a_body1cont6Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 4406 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont6Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 2)); else return a_body1cont6loopBody1loopBody1when1(__when_expr_4.get(), loopDepth); };
		static_cast<ShardTrackerActor*>(this)->actor_wait_state = 5;
															#line 1027 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ShardTrackerActor, 4, Void >*>(static_cast<ShardTrackerActor*>(this)));
															#line 4411 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont6loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont6Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont6Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont6loopBody1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont6loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont6loopBody1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont6loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont6loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ShardTrackerActor*>(this)->actor_wait_state > 0) static_cast<ShardTrackerActor*>(this)->actor_wait_state = 0;
		static_cast<ShardTrackerActor*>(this)->ActorCallback< ShardTrackerActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ShardTrackerActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("shardTracker", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShardTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont6loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont6Catch1(error, 0);
		} catch (...) {
			a_body1cont6Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardTracker", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ShardTrackerActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("shardTracker", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShardTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont6loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont6Catch1(error, 0);
		} catch (...) {
			a_body1cont6Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardTracker", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ShardTrackerActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("shardTracker", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ShardTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont6Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont6Catch1(error, 0);
		} catch (...) {
			a_body1cont6Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardTracker", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont6loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 1036 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		StrictFuture<Void> __when_expr_6 = delay(0, TaskPriority::DataDistribution);
															#line 1036 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (static_cast<ShardTrackerActor*>(this)->actor_wait_state < 0) return a_body1cont6Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4522 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont6Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont6loopBody1cont2when1(__when_expr_6.get(), loopDepth); };
		static_cast<ShardTrackerActor*>(this)->actor_wait_state = 7;
															#line 1036 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ShardTrackerActor, 6, Void >*>(static_cast<ShardTrackerActor*>(this)));
															#line 4527 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 1036 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		StrictFuture<Void> __when_expr_6 = delay(0, TaskPriority::DataDistribution);
															#line 1036 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (static_cast<ShardTrackerActor*>(this)->actor_wait_state < 0) return a_body1cont6Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4538 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont6Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont6loopBody1cont2when1(__when_expr_6.get(), loopDepth); };
		static_cast<ShardTrackerActor*>(this)->actor_wait_state = 7;
															#line 1036 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ShardTrackerActor, 6, Void >*>(static_cast<ShardTrackerActor*>(this)));
															#line 4543 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<ShardTrackerActor*>(this)->actor_wait_state > 0) static_cast<ShardTrackerActor*>(this)->actor_wait_state = 0;
		static_cast<ShardTrackerActor*>(this)->ActorCallback< ShardTrackerActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ShardTrackerActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("shardTracker", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShardTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont6Catch1(error, 0);
		} catch (...) {
			a_body1cont6Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardTracker", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ShardTrackerActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("shardTracker", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShardTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont6Catch1(error, 0);
		} catch (...) {
			a_body1cont6Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardTracker", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< ShardTrackerActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("shardTracker", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ShardTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont6Catch1(error, 0);
		} catch (...) {
			a_body1cont6Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardTracker", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont6loopBody1cont3(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont6loopHead1(0);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont3(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont6loopHead1(0);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<ShardTrackerActor*>(this)->actor_wait_state > 0) static_cast<ShardTrackerActor*>(this)->actor_wait_state = 0;
		static_cast<ShardTrackerActor*>(this)->ActorCallback< ShardTrackerActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ShardTrackerActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("shardTracker", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShardTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont6loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont6Catch1(error, 0);
		} catch (...) {
			a_body1cont6Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardTracker", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< ShardTrackerActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("shardTracker", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShardTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont6loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont6Catch1(error, 0);
		} catch (...) {
			a_body1cont6Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardTracker", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< ShardTrackerActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("shardTracker", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ShardTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont6Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont6Catch1(error, 0);
		} catch (...) {
			a_body1cont6Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardTracker", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 996 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	DataDistributionTracker::SafeAccessor self;
															#line 996 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	KeyRange keys;
															#line 996 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	Reference<AsyncVar<Optional<ShardMetrics>>> shardSize;
															#line 1011 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	Reference<HasBeenTrueFor> wantsToMerge;
															#line 4718 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via shardTracker()
															#line 996 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class ShardTrackerActor final : public Actor<Void>, public ActorCallback< ShardTrackerActor, 0, Void >, public ActorCallback< ShardTrackerActor, 1, Void >, public ActorCallback< ShardTrackerActor, 2, Void >, public ActorCallback< ShardTrackerActor, 3, Void >, public ActorCallback< ShardTrackerActor, 4, Void >, public ActorCallback< ShardTrackerActor, 5, Void >, public ActorCallback< ShardTrackerActor, 6, Void >, public FastAllocated<ShardTrackerActor>, public ShardTrackerActorState<ShardTrackerActor> {
															#line 4723 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
public:
	using FastAllocated<ShardTrackerActor>::operator new;
	using FastAllocated<ShardTrackerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14144320186570955264UL, 1768774606781527296UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ShardTrackerActor, 0, Void >;
friend struct ActorCallback< ShardTrackerActor, 1, Void >;
friend struct ActorCallback< ShardTrackerActor, 2, Void >;
friend struct ActorCallback< ShardTrackerActor, 3, Void >;
friend struct ActorCallback< ShardTrackerActor, 4, Void >;
friend struct ActorCallback< ShardTrackerActor, 5, Void >;
friend struct ActorCallback< ShardTrackerActor, 6, Void >;
															#line 996 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	ShardTrackerActor(DataDistributionTracker::SafeAccessor const& self,KeyRange const& keys,Reference<AsyncVar<Optional<ShardMetrics>>> const& shardSize) 
															#line 4746 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ShardTrackerActorState<ShardTrackerActor>(self, keys, shardSize),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("shardTracker", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7249602009175214080UL, 15683107163027600384UL);
		ActorExecutionContextHelper __helper(static_cast<ShardTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("shardTracker");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("shardTracker", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ShardTrackerActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ShardTrackerActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ShardTrackerActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ShardTrackerActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ShardTrackerActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< ShardTrackerActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< ShardTrackerActor, 6, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 996 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
[[nodiscard]] Future<Void> shardTracker( DataDistributionTracker::SafeAccessor const& self, KeyRange const& keys, Reference<AsyncVar<Optional<ShardMetrics>>> const& shardSize ) {
															#line 996 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	return Future<Void>(new ShardTrackerActor(self, keys, shardSize));
															#line 4785 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
}

#line 1045 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"

void restartShardTrackers(DataDistributionTracker* self,
                          KeyRangeRef keys,
                          Optional<ShardMetrics> startingMetrics,
                          bool whenDDInit) {
	auto ranges = self->shards->getAffectedRangesAfterInsertion(keys, ShardTrackedData());
	for (int i = 0; i < ranges.size(); i++) {
		if (!ranges[i].value.trackShard.isValid() && ranges[i].begin != keys.begin) {
			// When starting, key space will be full of "dummy" default constructed entries.
			// This should happen when called from trackInitialShards()
			ASSERT(!self->readyToStart.isSet());
			continue;
		}

		auto shardMetrics = makeReference<AsyncVar<Optional<ShardMetrics>>>();

		// For the case where the new tracker will take over at the boundaries of current shard(s)
		//  we can use the old size if it is available. This will be the case when merging shards.
		if (startingMetrics.present()) {
			ASSERT(ranges.size() == 1);
			/*TraceEvent("ShardTrackerSizePreset", self->distributorId)
			    .detail("Keys", keys)
			    .detail("Size", startingMetrics.get().metrics.bytes)
			    .detail("Merges", startingMetrics.get().merges);*/
			CODE_PROBE(true, "shardTracker started with trackedBytes already set");
			shardMetrics->set(startingMetrics);
		}

		ShardTrackedData data;
		data.stats = shardMetrics;
		data.trackShard = shardTracker(DataDistributionTracker::SafeAccessor(self), ranges[i], shardMetrics);
		data.trackBytes =
		    trackShardMetrics(DataDistributionTracker::SafeAccessor(self), ranges[i], shardMetrics, whenDDInit);
		if (SERVER_KNOBS->SHARD_ENCODE_LOCATION_METADATA && SERVER_KNOBS->DD_SHARD_USABLE_REGION_CHECK_RATE > 0 &&
		    self->usableRegions != -1) {
			data.trackUsableRegion = shardUsableRegions(DataDistributionTracker::SafeAccessor(self), ranges[i]);
		}
		self->shards->insert(ranges[i], data);
	}
}

															#line 4830 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via trackInitialShards()
															#line 1086 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
template <class TrackInitialShardsActor>
															#line 1086 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class TrackInitialShardsActorState {
															#line 4837 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
public:
															#line 1086 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	TrackInitialShardsActorState(DataDistributionTracker* const& self,Reference<InitialDataDistribution> const& initData) 
															#line 1086 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
															#line 1086 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		 : self(self),
															#line 1086 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   initData(initData)
															#line 4846 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("trackInitialShards", reinterpret_cast<unsigned long>(this));

	}
	~TrackInitialShardsActorState() 
	{
		fdb_probe_actor_destroy("trackInitialShards", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1087 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			TraceEvent("TrackInitialShards", self->distributorId).detail("InitialShardCount", initData->shards.size());
															#line 1091 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(0.0, TaskPriority::DataDistribution);
															#line 1091 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (static_cast<TrackInitialShardsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4865 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TrackInitialShardsActor*>(this)->actor_wait_state = 1;
															#line 1091 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TrackInitialShardsActor, 0, Void >*>(static_cast<TrackInitialShardsActor*>(this)));
															#line 4870 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TrackInitialShardsActorState();
		static_cast<TrackInitialShardsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1093 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		customBoundaries = std::vector<Key>();
															#line 1094 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		for( auto it : self->userRangeConfig->ranges() ) {
															#line 1095 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			customBoundaries.push_back(it->range().begin);
															#line 4897 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		}
															#line 1098 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		s = int();
															#line 1099 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		customBoundary = 0;
															#line 1100 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		s = 0;
															#line 4905 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1093 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		customBoundaries = std::vector<Key>();
															#line 1094 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		for( auto it : self->userRangeConfig->ranges() ) {
															#line 1095 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			customBoundaries.push_back(it->range().begin);
															#line 4918 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		}
															#line 1098 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		s = int();
															#line 1099 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		customBoundary = 0;
															#line 1100 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		s = 0;
															#line 4926 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TrackInitialShardsActor*>(this)->actor_wait_state > 0) static_cast<TrackInitialShardsActor*>(this)->actor_wait_state = 0;
		static_cast<TrackInitialShardsActor*>(this)->ActorCallback< TrackInitialShardsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TrackInitialShardsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("trackInitialShards", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackInitialShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackInitialShards", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TrackInitialShardsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("trackInitialShards", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackInitialShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackInitialShards", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TrackInitialShardsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("trackInitialShards", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TrackInitialShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackInitialShards", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1116 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		Future<Void> initialSize = changeSizes(self, KeyRangeRef(allKeys.begin, allKeys.end), 0, "ShardInit");
															#line 1117 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		self->readyToStart.send(Void());
															#line 1118 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = initialSize;
															#line 1118 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (static_cast<TrackInitialShardsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5016 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TrackInitialShardsActor*>(this)->actor_wait_state = 3;
															#line 1118 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TrackInitialShardsActor, 2, Void >*>(static_cast<TrackInitialShardsActor*>(this)));
															#line 5021 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1100 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!(s < initData->shards.size() - 1))
															#line 5037 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1101 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		Key beginKey = initData->shards[s].key;
															#line 1102 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		Key endKey = initData->shards[s + 1].key;
															#line 1103 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		for(;customBoundary < customBoundaries.size() && customBoundaries[customBoundary] <= beginKey;) {
															#line 1104 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			customBoundary++;
															#line 5049 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		}
															#line 1106 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		for(;customBoundary < customBoundaries.size() && customBoundaries[customBoundary] < endKey;) {
															#line 1107 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			restartShardTrackers( self, KeyRangeRef(beginKey, customBoundaries[customBoundary]), Optional<ShardMetrics>(), true);
															#line 1109 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			beginKey = customBoundaries[customBoundary];
															#line 1110 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			customBoundary++;
															#line 5059 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		}
															#line 1112 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		restartShardTrackers(self, KeyRangeRef(beginKey, endKey), Optional<ShardMetrics>(), true);
															#line 1113 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = yield(TaskPriority::DataDistribution);
															#line 1113 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (static_cast<TrackInitialShardsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5067 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TrackInitialShardsActor*>(this)->actor_wait_state = 2;
															#line 1113 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TrackInitialShardsActor, 1, Void >*>(static_cast<TrackInitialShardsActor*>(this)));
															#line 5072 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 1100 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		s++;
															#line 5094 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 1100 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		s++;
															#line 5103 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TrackInitialShardsActor*>(this)->actor_wait_state > 0) static_cast<TrackInitialShardsActor*>(this)->actor_wait_state = 0;
		static_cast<TrackInitialShardsActor*>(this)->ActorCallback< TrackInitialShardsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TrackInitialShardsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("trackInitialShards", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackInitialShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackInitialShards", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TrackInitialShardsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("trackInitialShards", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackInitialShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackInitialShards", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TrackInitialShardsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("trackInitialShards", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TrackInitialShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackInitialShards", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 1119 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		self->maxShardSizeUpdater = updateMaxShardSize(self->dbSizeEstimate, self->maxShardSize);
															#line 1121 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!static_cast<TrackInitialShardsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TrackInitialShardsActorState(); static_cast<TrackInitialShardsActor*>(this)->destroy(); return 0; }
															#line 5189 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		new (&static_cast<TrackInitialShardsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TrackInitialShardsActorState();
		static_cast<TrackInitialShardsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 1119 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		self->maxShardSizeUpdater = updateMaxShardSize(self->dbSizeEstimate, self->maxShardSize);
															#line 1121 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!static_cast<TrackInitialShardsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TrackInitialShardsActorState(); static_cast<TrackInitialShardsActor*>(this)->destroy(); return 0; }
															#line 5203 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		new (&static_cast<TrackInitialShardsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TrackInitialShardsActorState();
		static_cast<TrackInitialShardsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TrackInitialShardsActor*>(this)->actor_wait_state > 0) static_cast<TrackInitialShardsActor*>(this)->actor_wait_state = 0;
		static_cast<TrackInitialShardsActor*>(this)->ActorCallback< TrackInitialShardsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TrackInitialShardsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("trackInitialShards", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackInitialShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackInitialShards", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TrackInitialShardsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("trackInitialShards", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackInitialShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackInitialShards", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TrackInitialShardsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("trackInitialShards", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TrackInitialShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackInitialShards", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1086 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	DataDistributionTracker* self;
															#line 1086 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	Reference<InitialDataDistribution> initData;
															#line 1093 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	std::vector<Key> customBoundaries;
															#line 1098 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	int s;
															#line 1099 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	int customBoundary;
															#line 5296 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via trackInitialShards()
															#line 1086 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class TrackInitialShardsActor final : public Actor<Void>, public ActorCallback< TrackInitialShardsActor, 0, Void >, public ActorCallback< TrackInitialShardsActor, 1, Void >, public ActorCallback< TrackInitialShardsActor, 2, Void >, public FastAllocated<TrackInitialShardsActor>, public TrackInitialShardsActorState<TrackInitialShardsActor> {
															#line 5301 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
public:
	using FastAllocated<TrackInitialShardsActor>::operator new;
	using FastAllocated<TrackInitialShardsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9272240401602064640UL, 117597872397833984UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TrackInitialShardsActor, 0, Void >;
friend struct ActorCallback< TrackInitialShardsActor, 1, Void >;
friend struct ActorCallback< TrackInitialShardsActor, 2, Void >;
															#line 1086 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	TrackInitialShardsActor(DataDistributionTracker* const& self,Reference<InitialDataDistribution> const& initData) 
															#line 5320 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TrackInitialShardsActorState<TrackInitialShardsActor>(self, initData),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("trackInitialShards", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9397468799121883904UL, 15036047991511515904UL);
		ActorExecutionContextHelper __helper(static_cast<TrackInitialShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("trackInitialShards");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("trackInitialShards", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TrackInitialShardsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TrackInitialShardsActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TrackInitialShardsActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1086 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
[[nodiscard]] Future<Void> trackInitialShards( DataDistributionTracker* const& self, Reference<InitialDataDistribution> const& initData ) {
															#line 1086 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	return Future<Void>(new TrackInitialShardsActor(self, initData));
															#line 5355 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
}

#line 1123 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"

															#line 5360 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via fetchTopKShardMetrics_impl()
															#line 1124 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
template <class FetchTopKShardMetrics_implActor>
															#line 1124 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class FetchTopKShardMetrics_implActorState {
															#line 5367 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
public:
															#line 1124 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	FetchTopKShardMetrics_implActorState(DataDistributionTracker* const& self,GetTopKMetricsRequest const& req) 
															#line 1124 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
															#line 1124 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		 : self(self),
															#line 1124 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   req(req),
															#line 1125 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   onChange(),
															#line 1126 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   returnMetrics()
															#line 5380 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("fetchTopKShardMetrics_impl", reinterpret_cast<unsigned long>(this));

	}
	~FetchTopKShardMetrics_implActorState() 
	{
		fdb_probe_actor_destroy("fetchTopKShardMetrics_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1128 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (req.keys.size() > SERVER_KNOBS->DD_SHARD_COMPARE_LIMIT)
															#line 5395 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			{
															#line 1129 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				deterministicRandom()->randomShuffle(req.keys, 0, SERVER_KNOBS->DD_SHARD_COMPARE_LIMIT);
															#line 5399 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			}
			try {
															#line 1132 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				;
															#line 5404 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FetchTopKShardMetrics_implActorState();
		static_cast<FetchTopKShardMetrics_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1186 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (e.code() != error_code_actor_cancelled && !req.reply.isSet())
															#line 5434 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			{
															#line 1187 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				req.reply.sendError(e);
															#line 5438 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			}
															#line 1188 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 5442 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1133 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		onChange = Future<Void>();
															#line 1134 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		returnMetrics.clear();
															#line 1135 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		minReadLoad = -1;
															#line 1136 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		maxReadLoad = -1;
															#line 1137 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		i = int();
															#line 1138 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		i = 0;
															#line 5473 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 1167 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!onChange.isValid())
															#line 5482 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		{
															#line 1168 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (req.getTopK() >= returnMetrics.size())
															#line 5486 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			{
															#line 1169 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				req.reply.send(GetTopKMetricsReply(returnMetrics, minReadLoad, maxReadLoad));
															#line 5490 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1171 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				std::nth_element(returnMetrics.begin(), returnMetrics.begin() + req.getTopK() - 1, returnMetrics.end(), GetTopKMetricsRequest::compare);
															#line 1175 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				req.reply.send( GetTopKMetricsReply(std::vector<GetTopKMetricsReply::KeyRangeStorageMetrics>( returnMetrics.begin(), returnMetrics.begin() + req.getTopK()), minReadLoad, maxReadLoad));
															#line 5498 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			}
															#line 1181 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (!static_cast<FetchTopKShardMetrics_implActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FetchTopKShardMetrics_implActorState(); static_cast<FetchTopKShardMetrics_implActor*>(this)->destroy(); return 0; }
															#line 5502 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			new (&static_cast<FetchTopKShardMetrics_implActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FetchTopKShardMetrics_implActorState();
			static_cast<FetchTopKShardMetrics_implActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1183 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = onChange;
															#line 1183 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (static_cast<FetchTopKShardMetrics_implActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5512 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FetchTopKShardMetrics_implActor*>(this)->actor_wait_state = 2;
															#line 1183 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FetchTopKShardMetrics_implActor, 1, Void >*>(static_cast<FetchTopKShardMetrics_implActor*>(this)));
															#line 5517 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 1138 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!(i < SERVER_KNOBS->DD_SHARD_COMPARE_LIMIT && i < req.keys.size()))
															#line 5533 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1139 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		auto range = req.keys[i];
															#line 1140 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		StorageMetrics metrics;
															#line 1141 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		for( auto t : self->shards->intersectingRanges(range) ) {
															#line 1142 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			auto& stats = t.value().stats;
															#line 1143 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (!stats->get().present())
															#line 5547 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			{
															#line 1144 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				onChange = stats->onChange();
															#line 5551 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
				break;
			}
															#line 1147 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			metrics += t.value().stats->get().get().metrics;
															#line 5556 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		}
															#line 1151 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (onChange.isValid())
															#line 5560 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1155 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		auto readLoad = metrics.readLoadKSecond();
															#line 1156 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (readLoad > 0)
															#line 5568 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		{
															#line 1157 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			minReadLoad = std::min(readLoad, minReadLoad);
															#line 1158 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			maxReadLoad = std::max(readLoad, maxReadLoad);
															#line 1159 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (req.minReadLoadPerKSecond <= readLoad && readLoad <= req.maxReadLoadPerKSecond)
															#line 5576 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			{
															#line 1160 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				returnMetrics.emplace_back(range, metrics);
															#line 5580 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			}
		}
															#line 1164 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		StrictFuture<Void> __when_expr_0 = yield();
															#line 1164 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (static_cast<FetchTopKShardMetrics_implActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 5587 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<FetchTopKShardMetrics_implActor*>(this)->actor_wait_state = 1;
															#line 1164 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FetchTopKShardMetrics_implActor, 0, Void >*>(static_cast<FetchTopKShardMetrics_implActor*>(this)));
															#line 5592 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 1138 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		++i;
															#line 5614 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 1138 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		++i;
															#line 5623 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FetchTopKShardMetrics_implActor*>(this)->actor_wait_state > 0) static_cast<FetchTopKShardMetrics_implActor*>(this)->actor_wait_state = 0;
		static_cast<FetchTopKShardMetrics_implActor*>(this)->ActorCallback< FetchTopKShardMetrics_implActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FetchTopKShardMetrics_implActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchTopKShardMetrics_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchTopKShardMetrics_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchTopKShardMetrics_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FetchTopKShardMetrics_implActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchTopKShardMetrics_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchTopKShardMetrics_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchTopKShardMetrics_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FetchTopKShardMetrics_implActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchTopKShardMetrics_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchTopKShardMetrics_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchTopKShardMetrics_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FetchTopKShardMetrics_implActor*>(this)->actor_wait_state > 0) static_cast<FetchTopKShardMetrics_implActor*>(this)->actor_wait_state = 0;
		static_cast<FetchTopKShardMetrics_implActor*>(this)->ActorCallback< FetchTopKShardMetrics_implActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FetchTopKShardMetrics_implActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchTopKShardMetrics_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchTopKShardMetrics_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchTopKShardMetrics_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FetchTopKShardMetrics_implActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchTopKShardMetrics_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchTopKShardMetrics_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchTopKShardMetrics_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FetchTopKShardMetrics_implActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchTopKShardMetrics_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchTopKShardMetrics_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchTopKShardMetrics_impl", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1124 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	DataDistributionTracker* self;
															#line 1124 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	GetTopKMetricsRequest req;
															#line 1125 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	Future<Void> onChange;
															#line 1126 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	std::vector<GetTopKMetricsReply::KeyRangeStorageMetrics> returnMetrics;
															#line 1135 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	int64_t minReadLoad;
															#line 1136 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	int64_t maxReadLoad;
															#line 1137 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	int i;
															#line 5804 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via fetchTopKShardMetrics_impl()
															#line 1124 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class FetchTopKShardMetrics_implActor final : public Actor<Void>, public ActorCallback< FetchTopKShardMetrics_implActor, 0, Void >, public ActorCallback< FetchTopKShardMetrics_implActor, 1, Void >, public FastAllocated<FetchTopKShardMetrics_implActor>, public FetchTopKShardMetrics_implActorState<FetchTopKShardMetrics_implActor> {
															#line 5809 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
public:
	using FastAllocated<FetchTopKShardMetrics_implActor>::operator new;
	using FastAllocated<FetchTopKShardMetrics_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6612777120531028224UL, 7014136800205446656UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FetchTopKShardMetrics_implActor, 0, Void >;
friend struct ActorCallback< FetchTopKShardMetrics_implActor, 1, Void >;
															#line 1124 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	FetchTopKShardMetrics_implActor(DataDistributionTracker* const& self,GetTopKMetricsRequest const& req) 
															#line 5827 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FetchTopKShardMetrics_implActorState<FetchTopKShardMetrics_implActor>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fetchTopKShardMetrics_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16335621257324376576UL, 17612975492946055168UL);
		ActorExecutionContextHelper __helper(static_cast<FetchTopKShardMetrics_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fetchTopKShardMetrics_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fetchTopKShardMetrics_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FetchTopKShardMetrics_implActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FetchTopKShardMetrics_implActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1124 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
[[nodiscard]] Future<Void> fetchTopKShardMetrics_impl( DataDistributionTracker* const& self, GetTopKMetricsRequest const& req ) {
															#line 1124 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	return Future<Void>(new FetchTopKShardMetrics_implActor(self, req));
															#line 5861 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
}

#line 1191 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"

															#line 5866 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via fetchTopKShardMetrics()
															#line 1192 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
template <class FetchTopKShardMetricsActor>
															#line 1192 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class FetchTopKShardMetricsActorState {
															#line 5873 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
public:
															#line 1192 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	FetchTopKShardMetricsActorState(DataDistributionTracker* const& self,GetTopKMetricsRequest const& req) 
															#line 1192 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
															#line 1192 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		 : self(self),
															#line 1192 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   req(req)
															#line 5882 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("fetchTopKShardMetrics", reinterpret_cast<unsigned long>(this));

	}
	~FetchTopKShardMetricsActorState() 
	{
		fdb_probe_actor_destroy("fetchTopKShardMetrics", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1195 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = g_network->isSimulated() && BUGGIFY_WITH_PROB(0.01) ? Never() : fetchTopKShardMetrics_impl(self, req);
															#line 1193 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (static_cast<FetchTopKShardMetricsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5899 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 1197 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->DD_SHARD_METRICS_TIMEOUT);
															#line 5903 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
			static_cast<FetchTopKShardMetricsActor*>(this)->actor_wait_state = 1;
															#line 1195 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FetchTopKShardMetricsActor, 0, Void >*>(static_cast<FetchTopKShardMetricsActor*>(this)));
															#line 1197 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FetchTopKShardMetricsActor, 1, Void >*>(static_cast<FetchTopKShardMetricsActor*>(this)));
															#line 5910 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FetchTopKShardMetricsActorState();
		static_cast<FetchTopKShardMetricsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1202 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!static_cast<FetchTopKShardMetricsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FetchTopKShardMetricsActorState(); static_cast<FetchTopKShardMetricsActor*>(this)->destroy(); return 0; }
															#line 5933 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		new (&static_cast<FetchTopKShardMetricsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FetchTopKShardMetricsActorState();
		static_cast<FetchTopKShardMetricsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
															#line 1198 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		CODE_PROBE(true, "TopK DD_SHARD_METRICS_TIMEOUT");
															#line 1199 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		req.reply.send(GetTopKMetricsReply());
															#line 5959 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
															#line 1198 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		CODE_PROBE(true, "TopK DD_SHARD_METRICS_TIMEOUT");
															#line 1199 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		req.reply.send(GetTopKMetricsReply());
															#line 5970 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FetchTopKShardMetricsActor*>(this)->actor_wait_state > 0) static_cast<FetchTopKShardMetricsActor*>(this)->actor_wait_state = 0;
		static_cast<FetchTopKShardMetricsActor*>(this)->ActorCallback< FetchTopKShardMetricsActor, 0, Void >::remove();
		static_cast<FetchTopKShardMetricsActor*>(this)->ActorCallback< FetchTopKShardMetricsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FetchTopKShardMetricsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchTopKShardMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchTopKShardMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchTopKShardMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FetchTopKShardMetricsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchTopKShardMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchTopKShardMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchTopKShardMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FetchTopKShardMetricsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchTopKShardMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchTopKShardMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchTopKShardMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FetchTopKShardMetricsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchTopKShardMetrics", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchTopKShardMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchTopKShardMetrics", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FetchTopKShardMetricsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchTopKShardMetrics", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchTopKShardMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchTopKShardMetrics", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FetchTopKShardMetricsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchTopKShardMetrics", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchTopKShardMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchTopKShardMetrics", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1192 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	DataDistributionTracker* self;
															#line 1192 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	GetTopKMetricsRequest req;
															#line 6100 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via fetchTopKShardMetrics()
															#line 1192 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class FetchTopKShardMetricsActor final : public Actor<Void>, public ActorCallback< FetchTopKShardMetricsActor, 0, Void >, public ActorCallback< FetchTopKShardMetricsActor, 1, Void >, public FastAllocated<FetchTopKShardMetricsActor>, public FetchTopKShardMetricsActorState<FetchTopKShardMetricsActor> {
															#line 6105 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
public:
	using FastAllocated<FetchTopKShardMetricsActor>::operator new;
	using FastAllocated<FetchTopKShardMetricsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11034964372341749760UL, 1941817187061762560UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FetchTopKShardMetricsActor, 0, Void >;
friend struct ActorCallback< FetchTopKShardMetricsActor, 1, Void >;
															#line 1192 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	FetchTopKShardMetricsActor(DataDistributionTracker* const& self,GetTopKMetricsRequest const& req) 
															#line 6123 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FetchTopKShardMetricsActorState<FetchTopKShardMetricsActor>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fetchTopKShardMetrics", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(562825965935643136UL, 6235542981586304000UL);
		ActorExecutionContextHelper __helper(static_cast<FetchTopKShardMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fetchTopKShardMetrics");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fetchTopKShardMetrics", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FetchTopKShardMetricsActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1192 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
[[nodiscard]] Future<Void> fetchTopKShardMetrics( DataDistributionTracker* const& self, GetTopKMetricsRequest const& req ) {
															#line 1192 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	return Future<Void>(new FetchTopKShardMetricsActor(self, req));
															#line 6156 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
}

#line 1204 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"

															#line 6161 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via fetchShardMetrics_impl()
															#line 1205 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
template <class FetchShardMetrics_implActor>
															#line 1205 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class FetchShardMetrics_implActorState {
															#line 6168 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
public:
															#line 1205 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	FetchShardMetrics_implActorState(DataDistributionTracker* const& self,GetMetricsRequest const& req) 
															#line 1205 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
															#line 1205 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		 : self(self),
															#line 1205 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   req(req)
															#line 6177 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("fetchShardMetrics_impl", reinterpret_cast<unsigned long>(this));

	}
	~FetchShardMetrics_implActorState() 
	{
		fdb_probe_actor_destroy("fetchShardMetrics_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1207 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				;
															#line 6193 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FetchShardMetrics_implActorState();
		static_cast<FetchShardMetrics_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1227 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (e.code() != error_code_actor_cancelled && !req.reply.isSet())
															#line 6223 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			{
															#line 1228 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				req.reply.sendError(e);
															#line 6227 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			}
															#line 1229 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 6231 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1208 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		Future<Void> onChange;
															#line 1209 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		StorageMetrics returnMetrics;
															#line 1210 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		for( auto t : self->shards->intersectingRanges(req.keys) ) {
															#line 1211 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			auto& stats = t.value().stats;
															#line 1212 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (!stats->get().present())
															#line 6260 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			{
															#line 1213 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				onChange = stats->onChange();
															#line 6264 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
				break;
			}
															#line 1216 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			returnMetrics += t.value().stats->get().get().metrics;
															#line 6269 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		}
															#line 1219 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!onChange.isValid())
															#line 6273 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		{
															#line 1220 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			req.reply.send(returnMetrics);
															#line 1221 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (!static_cast<FetchShardMetrics_implActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FetchShardMetrics_implActorState(); static_cast<FetchShardMetrics_implActor*>(this)->destroy(); return 0; }
															#line 6279 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			new (&static_cast<FetchShardMetrics_implActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FetchShardMetrics_implActorState();
			static_cast<FetchShardMetrics_implActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1224 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		StrictFuture<Void> __when_expr_0 = onChange;
															#line 1224 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (static_cast<FetchShardMetrics_implActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6289 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<FetchShardMetrics_implActor*>(this)->actor_wait_state = 1;
															#line 1224 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FetchShardMetrics_implActor, 0, Void >*>(static_cast<FetchShardMetrics_implActor*>(this)));
															#line 6294 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FetchShardMetrics_implActor*>(this)->actor_wait_state > 0) static_cast<FetchShardMetrics_implActor*>(this)->actor_wait_state = 0;
		static_cast<FetchShardMetrics_implActor*>(this)->ActorCallback< FetchShardMetrics_implActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FetchShardMetrics_implActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchShardMetrics_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchShardMetrics_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchShardMetrics_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FetchShardMetrics_implActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchShardMetrics_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchShardMetrics_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchShardMetrics_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FetchShardMetrics_implActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchShardMetrics_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchShardMetrics_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchShardMetrics_impl", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1205 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	DataDistributionTracker* self;
															#line 1205 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	GetMetricsRequest req;
															#line 6390 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via fetchShardMetrics_impl()
															#line 1205 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class FetchShardMetrics_implActor final : public Actor<Void>, public ActorCallback< FetchShardMetrics_implActor, 0, Void >, public FastAllocated<FetchShardMetrics_implActor>, public FetchShardMetrics_implActorState<FetchShardMetrics_implActor> {
															#line 6395 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
public:
	using FastAllocated<FetchShardMetrics_implActor>::operator new;
	using FastAllocated<FetchShardMetrics_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12612365205988541952UL, 18305987736331928064UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FetchShardMetrics_implActor, 0, Void >;
															#line 1205 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	FetchShardMetrics_implActor(DataDistributionTracker* const& self,GetMetricsRequest const& req) 
															#line 6412 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FetchShardMetrics_implActorState<FetchShardMetrics_implActor>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fetchShardMetrics_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8157094183056292352UL, 15731389018228572672UL);
		ActorExecutionContextHelper __helper(static_cast<FetchShardMetrics_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fetchShardMetrics_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fetchShardMetrics_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FetchShardMetrics_implActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1205 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
[[nodiscard]] Future<Void> fetchShardMetrics_impl( DataDistributionTracker* const& self, GetMetricsRequest const& req ) {
															#line 1205 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	return Future<Void>(new FetchShardMetrics_implActor(self, req));
															#line 6445 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
}

#line 1232 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"

															#line 6450 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via fetchShardMetrics()
															#line 1233 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
template <class FetchShardMetricsActor>
															#line 1233 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class FetchShardMetricsActorState {
															#line 6457 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
public:
															#line 1233 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	FetchShardMetricsActorState(DataDistributionTracker* const& self,GetMetricsRequest const& req) 
															#line 1233 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
															#line 1233 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		 : self(self),
															#line 1233 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   req(req)
															#line 6466 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("fetchShardMetrics", reinterpret_cast<unsigned long>(this));

	}
	~FetchShardMetricsActorState() 
	{
		fdb_probe_actor_destroy("fetchShardMetrics", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1235 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = fetchShardMetrics_impl(self, req);
															#line 1234 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (static_cast<FetchShardMetricsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6483 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 1236 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->DD_SHARD_METRICS_TIMEOUT, TaskPriority::DataDistribution);
															#line 6487 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
			static_cast<FetchShardMetricsActor*>(this)->actor_wait_state = 1;
															#line 1235 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FetchShardMetricsActor, 0, Void >*>(static_cast<FetchShardMetricsActor*>(this)));
															#line 1236 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FetchShardMetricsActor, 1, Void >*>(static_cast<FetchShardMetricsActor*>(this)));
															#line 6494 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FetchShardMetricsActorState();
		static_cast<FetchShardMetricsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1243 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!static_cast<FetchShardMetricsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FetchShardMetricsActorState(); static_cast<FetchShardMetricsActor*>(this)->destroy(); return 0; }
															#line 6517 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		new (&static_cast<FetchShardMetricsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FetchShardMetricsActorState();
		static_cast<FetchShardMetricsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
															#line 1237 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		CODE_PROBE(true, "DD_SHARD_METRICS_TIMEOUT");
															#line 1238 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		StorageMetrics largeMetrics;
															#line 1239 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		largeMetrics.bytes = getMaxShardSize(self->dbSizeEstimate->get());
															#line 1240 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		req.reply.send(largeMetrics);
															#line 6547 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
															#line 1237 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		CODE_PROBE(true, "DD_SHARD_METRICS_TIMEOUT");
															#line 1238 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		StorageMetrics largeMetrics;
															#line 1239 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		largeMetrics.bytes = getMaxShardSize(self->dbSizeEstimate->get());
															#line 1240 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		req.reply.send(largeMetrics);
															#line 6562 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FetchShardMetricsActor*>(this)->actor_wait_state > 0) static_cast<FetchShardMetricsActor*>(this)->actor_wait_state = 0;
		static_cast<FetchShardMetricsActor*>(this)->ActorCallback< FetchShardMetricsActor, 0, Void >::remove();
		static_cast<FetchShardMetricsActor*>(this)->ActorCallback< FetchShardMetricsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FetchShardMetricsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchShardMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchShardMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchShardMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FetchShardMetricsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchShardMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchShardMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchShardMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FetchShardMetricsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchShardMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchShardMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchShardMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FetchShardMetricsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchShardMetrics", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchShardMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchShardMetrics", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FetchShardMetricsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchShardMetrics", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchShardMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchShardMetrics", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FetchShardMetricsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchShardMetrics", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchShardMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchShardMetrics", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1233 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	DataDistributionTracker* self;
															#line 1233 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	GetMetricsRequest req;
															#line 6692 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via fetchShardMetrics()
															#line 1233 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class FetchShardMetricsActor final : public Actor<Void>, public ActorCallback< FetchShardMetricsActor, 0, Void >, public ActorCallback< FetchShardMetricsActor, 1, Void >, public FastAllocated<FetchShardMetricsActor>, public FetchShardMetricsActorState<FetchShardMetricsActor> {
															#line 6697 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
public:
	using FastAllocated<FetchShardMetricsActor>::operator new;
	using FastAllocated<FetchShardMetricsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13840893090151927040UL, 4046272049767933696UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FetchShardMetricsActor, 0, Void >;
friend struct ActorCallback< FetchShardMetricsActor, 1, Void >;
															#line 1233 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	FetchShardMetricsActor(DataDistributionTracker* const& self,GetMetricsRequest const& req) 
															#line 6715 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FetchShardMetricsActorState<FetchShardMetricsActor>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fetchShardMetrics", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4595584884492349440UL, 13042209588914682880UL);
		ActorExecutionContextHelper __helper(static_cast<FetchShardMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fetchShardMetrics");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fetchShardMetrics", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FetchShardMetricsActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1233 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
[[nodiscard]] Future<Void> fetchShardMetrics( DataDistributionTracker* const& self, GetMetricsRequest const& req ) {
															#line 1233 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	return Future<Void>(new FetchShardMetricsActor(self, req));
															#line 6748 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
}

#line 1245 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"

															#line 6753 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via fetchShardMetricsList_impl()
															#line 1246 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
template <class FetchShardMetricsList_implActor>
															#line 1246 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class FetchShardMetricsList_implActorState {
															#line 6760 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
public:
															#line 1246 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	FetchShardMetricsList_implActorState(DataDistributionTracker* const& self,GetMetricsListRequest const& req) 
															#line 1246 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
															#line 1246 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		 : self(self),
															#line 1246 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   req(req)
															#line 6769 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("fetchShardMetricsList_impl", reinterpret_cast<unsigned long>(this));

	}
	~FetchShardMetricsList_implActorState() 
	{
		fdb_probe_actor_destroy("fetchShardMetricsList_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1248 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				;
															#line 6785 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FetchShardMetricsList_implActorState();
		static_cast<FetchShardMetricsList_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1280 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (e.code() != error_code_actor_cancelled && !req.reply.isSet())
															#line 6815 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			{
															#line 1281 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				req.reply.sendError(e);
															#line 6819 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			}
															#line 1282 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 6823 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1250 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		int shardNum = 0;
															#line 1252 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		Standalone<VectorRef<DDMetricsRef>> result;
															#line 1253 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		Future<Void> onChange;
															#line 1254 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		auto beginIter = self->shards->containedRanges(req.keys).begin();
															#line 1255 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		auto endIter = self->shards->intersectingRanges(req.keys).end();
															#line 1256 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		for(auto t = beginIter;t != endIter;++t) {
															#line 1257 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			auto& stats = t.value().stats;
															#line 1258 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (!stats->get().present())
															#line 6858 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			{
															#line 1259 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				onChange = stats->onChange();
															#line 6862 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
				break;
			}
															#line 1262 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			result.push_back_deep(result.arena(), DDMetricsRef(stats->get().get().metrics.bytes, stats->get().get().metrics.bytesWrittenPerKSecond, KeyRef(t.begin().toString())));
															#line 1266 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			++shardNum;
															#line 1267 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (shardNum >= req.shardLimit)
															#line 6871 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			{
				break;
			}
		}
															#line 1272 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!onChange.isValid())
															#line 6878 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		{
															#line 1273 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			req.reply.send(result);
															#line 1274 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (!static_cast<FetchShardMetricsList_implActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FetchShardMetricsList_implActorState(); static_cast<FetchShardMetricsList_implActor*>(this)->destroy(); return 0; }
															#line 6884 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			new (&static_cast<FetchShardMetricsList_implActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FetchShardMetricsList_implActorState();
			static_cast<FetchShardMetricsList_implActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1277 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		StrictFuture<Void> __when_expr_0 = onChange;
															#line 1277 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (static_cast<FetchShardMetricsList_implActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6894 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<FetchShardMetricsList_implActor*>(this)->actor_wait_state = 1;
															#line 1277 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FetchShardMetricsList_implActor, 0, Void >*>(static_cast<FetchShardMetricsList_implActor*>(this)));
															#line 6899 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FetchShardMetricsList_implActor*>(this)->actor_wait_state > 0) static_cast<FetchShardMetricsList_implActor*>(this)->actor_wait_state = 0;
		static_cast<FetchShardMetricsList_implActor*>(this)->ActorCallback< FetchShardMetricsList_implActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FetchShardMetricsList_implActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchShardMetricsList_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchShardMetricsList_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchShardMetricsList_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FetchShardMetricsList_implActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchShardMetricsList_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchShardMetricsList_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchShardMetricsList_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FetchShardMetricsList_implActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchShardMetricsList_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchShardMetricsList_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchShardMetricsList_impl", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1246 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	DataDistributionTracker* self;
															#line 1246 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	GetMetricsListRequest req;
															#line 6995 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via fetchShardMetricsList_impl()
															#line 1246 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class FetchShardMetricsList_implActor final : public Actor<Void>, public ActorCallback< FetchShardMetricsList_implActor, 0, Void >, public FastAllocated<FetchShardMetricsList_implActor>, public FetchShardMetricsList_implActorState<FetchShardMetricsList_implActor> {
															#line 7000 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
public:
	using FastAllocated<FetchShardMetricsList_implActor>::operator new;
	using FastAllocated<FetchShardMetricsList_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4253856241308348416UL, 17379432924532181760UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FetchShardMetricsList_implActor, 0, Void >;
															#line 1246 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	FetchShardMetricsList_implActor(DataDistributionTracker* const& self,GetMetricsListRequest const& req) 
															#line 7017 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FetchShardMetricsList_implActorState<FetchShardMetricsList_implActor>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fetchShardMetricsList_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14407635174814048256UL, 1377555907217671936UL);
		ActorExecutionContextHelper __helper(static_cast<FetchShardMetricsList_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fetchShardMetricsList_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fetchShardMetricsList_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FetchShardMetricsList_implActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1246 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
[[nodiscard]] Future<Void> fetchShardMetricsList_impl( DataDistributionTracker* const& self, GetMetricsListRequest const& req ) {
															#line 1246 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	return Future<Void>(new FetchShardMetricsList_implActor(self, req));
															#line 7050 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
}

#line 1285 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"

															#line 7055 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via fetchShardMetricsList()
															#line 1286 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
template <class FetchShardMetricsListActor>
															#line 1286 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class FetchShardMetricsListActorState {
															#line 7062 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
public:
															#line 1286 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	FetchShardMetricsListActorState(DataDistributionTracker* const& self,GetMetricsListRequest const& req) 
															#line 1286 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
															#line 1286 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		 : self(self),
															#line 1286 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   req(req)
															#line 7071 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("fetchShardMetricsList", reinterpret_cast<unsigned long>(this));

	}
	~FetchShardMetricsListActorState() 
	{
		fdb_probe_actor_destroy("fetchShardMetricsList", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1288 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = fetchShardMetricsList_impl(self, req);
															#line 1287 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (static_cast<FetchShardMetricsListActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7088 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 1289 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->DD_SHARD_METRICS_TIMEOUT);
															#line 7092 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
			static_cast<FetchShardMetricsListActor*>(this)->actor_wait_state = 1;
															#line 1288 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FetchShardMetricsListActor, 0, Void >*>(static_cast<FetchShardMetricsListActor*>(this)));
															#line 1289 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FetchShardMetricsListActor, 1, Void >*>(static_cast<FetchShardMetricsListActor*>(this)));
															#line 7099 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FetchShardMetricsListActorState();
		static_cast<FetchShardMetricsListActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1293 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!static_cast<FetchShardMetricsListActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FetchShardMetricsListActorState(); static_cast<FetchShardMetricsListActor*>(this)->destroy(); return 0; }
															#line 7122 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		new (&static_cast<FetchShardMetricsListActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FetchShardMetricsListActorState();
		static_cast<FetchShardMetricsListActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
															#line 1290 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		req.reply.sendError(timed_out());
															#line 7146 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
															#line 1290 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		req.reply.sendError(timed_out());
															#line 7155 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FetchShardMetricsListActor*>(this)->actor_wait_state > 0) static_cast<FetchShardMetricsListActor*>(this)->actor_wait_state = 0;
		static_cast<FetchShardMetricsListActor*>(this)->ActorCallback< FetchShardMetricsListActor, 0, Void >::remove();
		static_cast<FetchShardMetricsListActor*>(this)->ActorCallback< FetchShardMetricsListActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FetchShardMetricsListActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchShardMetricsList", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchShardMetricsListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchShardMetricsList", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FetchShardMetricsListActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchShardMetricsList", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchShardMetricsListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchShardMetricsList", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FetchShardMetricsListActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchShardMetricsList", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchShardMetricsListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchShardMetricsList", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FetchShardMetricsListActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchShardMetricsList", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchShardMetricsListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchShardMetricsList", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FetchShardMetricsListActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchShardMetricsList", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchShardMetricsListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchShardMetricsList", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FetchShardMetricsListActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchShardMetricsList", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchShardMetricsListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchShardMetricsList", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1286 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	DataDistributionTracker* self;
															#line 1286 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	GetMetricsListRequest req;
															#line 7285 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via fetchShardMetricsList()
															#line 1286 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class FetchShardMetricsListActor final : public Actor<Void>, public ActorCallback< FetchShardMetricsListActor, 0, Void >, public ActorCallback< FetchShardMetricsListActor, 1, Void >, public FastAllocated<FetchShardMetricsListActor>, public FetchShardMetricsListActorState<FetchShardMetricsListActor> {
															#line 7290 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
public:
	using FastAllocated<FetchShardMetricsListActor>::operator new;
	using FastAllocated<FetchShardMetricsListActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1314842626931317760UL, 7956543900790517760UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FetchShardMetricsListActor, 0, Void >;
friend struct ActorCallback< FetchShardMetricsListActor, 1, Void >;
															#line 1286 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	FetchShardMetricsListActor(DataDistributionTracker* const& self,GetMetricsListRequest const& req) 
															#line 7308 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FetchShardMetricsListActorState<FetchShardMetricsListActor>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fetchShardMetricsList", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1877805589017634560UL, 1177625241290689280UL);
		ActorExecutionContextHelper __helper(static_cast<FetchShardMetricsListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fetchShardMetricsList");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fetchShardMetricsList", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FetchShardMetricsListActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1286 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
[[nodiscard]] Future<Void> fetchShardMetricsList( DataDistributionTracker* const& self, GetMetricsListRequest const& req ) {
															#line 1286 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	return Future<Void>(new FetchShardMetricsListActor(self, req));
															#line 7341 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
}

#line 1295 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"

void triggerStorageQueueRebalance(DataDistributionTracker* self, RebalanceStorageQueueRequest req) {
	TraceEvent e("TriggerDataMoveStorageQueueRebalance", self->distributorId);
	e.detail("Server", req.serverId);
	e.detail("Teams", req.teams.size());
	int64_t maxShardWriteTraffic = 0;
	KeyRange shardToMove;
	ShardsAffectedByTeamFailure::Team selectedTeam;
	for (const auto& team : req.teams) {
		for (auto const& shard : self->shardsAffectedByTeamFailure->getShardsFor(team)) {
			for (auto it : self->shards->intersectingRanges(shard)) {
				if (it->value().stats->get().present()) {
					int64_t shardWriteTraffic = it->value().stats->get().get().metrics.bytesWrittenPerKSecond;
					if (shardWriteTraffic > maxShardWriteTraffic &&
					    (SERVER_KNOBS->DD_ENABLE_REBALANCE_STORAGE_QUEUE_WITH_LIGHT_WRITE_SHARD ||
					     shardWriteTraffic > SERVER_KNOBS->REBALANCE_STORAGE_QUEUE_SHARD_PER_KSEC_MIN)) {
						shardToMove = it->range();
						maxShardWriteTraffic = shardWriteTraffic;
					}
				}
			}
		}
	}
	if (!shardToMove.empty()) {
		e.detail("TeamSelected", selectedTeam.servers);
		e.detail("ShardSelected", shardToMove);
		e.detail("ShardWriteBytesPerKSec", maxShardWriteTraffic);
		RelocateShard rs(shardToMove, DataMovementReason::REBALANCE_STORAGE_QUEUE, RelocateReason::REBALANCE_WRITE);
		self->output.send(rs);
		TraceEvent("SendRelocateToDDQueue", self->distributorId)
		    .detail("ServerPrimary", req.primary)
		    .detail("ServerTeam", selectedTeam.servers)
		    .detail("KeyBegin", rs.keys.begin)
		    .detail("KeyEnd", rs.keys.end)
		    .detail("Priority", rs.priority);
	}
	return;
}

DataDistributionTracker::DataDistributionTracker(DataDistributionTrackerInitParams const& params)
  : IDDShardTracker(), db(params.db), distributorId(params.distributorId), shards(params.shards), actors(false),
    systemSizeEstimate(0), dbSizeEstimate(new AsyncVar<int64_t>()), maxShardSize(new AsyncVar<Optional<int64_t>>()),
    output(params.output), shardsAffectedByTeamFailure(params.shardsAffectedByTeamFailure),
    physicalShardCollection(params.physicalShardCollection), bulkLoadTaskCollection(params.bulkLoadTaskCollection),
    readyToStart(params.readyToStart), anyZeroHealthyTeams(params.anyZeroHealthyTeams),
    trackerCancelled(params.trackerCancelled), usableRegions(params.usableRegions) {}

DataDistributionTracker::~DataDistributionTracker() {
	if (trackerCancelled) {
		*trackerCancelled = true;
	}
	// Cancel all actors so they aren't waiting on sizeChanged broken promise
	actors.clear(false);
}

struct DataDistributionTrackerImpl {
																#line 7401 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
// This generated class is to be used only via run()
															#line 1351 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
template <class RunActor>
															#line 1351 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class RunActorState {
															#line 7407 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
public:
															#line 1351 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	RunActorState(DataDistributionTracker* const& self,Reference<InitialDataDistribution> const& initData) 
															#line 1351 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
															#line 1351 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		 : self(self),
															#line 1351 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   initData(initData),
															#line 1352 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   loggingTrigger(Void()),
															#line 1353 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   readHotDetect(readHotDetector(self)),
															#line 1354 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   ddTrackerStatsEventHolder(makeReference<EventCacheHolder>("DDTrackerStats"))
															#line 7422 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("run", reinterpret_cast<unsigned long>(this));

	}
	~RunActorState() 
	{
		fdb_probe_actor_destroy("run", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1357 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				StrictFuture<Void> __when_expr_0 = trackInitialShards(self, initData);
															#line 1357 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				if (static_cast<RunActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 7440 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<RunActor*>(this)->actor_wait_state = 1;
															#line 1357 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunActor, 0, Void >*>(static_cast<RunActor*>(this)));
															#line 7445 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunActorState();
		static_cast<RunActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1394 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (e.code() != error_code_broken_promise)
															#line 7475 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			{
															#line 1395 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				TraceEvent(SevError, "DataDistributionTrackerError", self->distributorId) .error(e);
															#line 7479 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1398 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				TraceEvent(SevWarn, "DataDistributionTrackerError", self->distributorId).error(e);
															#line 7485 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			}
															#line 1400 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 7489 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1358 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		initData.clear();
															#line 1360 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		;
															#line 7505 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1358 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		initData.clear();
															#line 1360 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		;
															#line 7516 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunActor*>(this)->actor_wait_state > 0) static_cast<RunActor*>(this)->actor_wait_state = 0;
		static_cast<RunActor*>(this)->ActorCallback< RunActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 1361 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		auto __when_expr_1 = self->averageShardBytes;
															#line 7607 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_1), FutureStream<Promise<int64_t>>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<Promise<int64_t>>>::value, "invalid type");
															#line 1360 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (static_cast<RunActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7611 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_1.pop(), loopDepth); };
															#line 1364 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = loggingTrigger;
															#line 7615 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when2(__when_expr_2.get(), loopDepth); };
															#line 1373 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		auto __when_expr_3 = self->getShardMetrics;
															#line 7619 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_3), FutureStream<GetMetricsRequest>>::value || std::is_same<decltype(__when_expr_3), ThreadFutureStream<GetMetricsRequest>>::value, "invalid type");
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch2(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when3(__when_expr_3.pop(), loopDepth); };
															#line 1376 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		auto __when_expr_4 = self->getTopKMetrics;
															#line 7624 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_4), FutureStream<GetTopKMetricsRequest>>::value || std::is_same<decltype(__when_expr_4), ThreadFutureStream<GetTopKMetricsRequest>>::value, "invalid type");
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch2(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when4(__when_expr_4.pop(), loopDepth); };
															#line 1379 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		auto __when_expr_5 = self->getShardMetricsList;
															#line 7629 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_5), FutureStream<GetMetricsListRequest>>::value || std::is_same<decltype(__when_expr_5), ThreadFutureStream<GetMetricsListRequest>>::value, "invalid type");
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch2(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when5(__when_expr_5.pop(), loopDepth); };
															#line 1382 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		auto __when_expr_6 = self->triggerStorageQueueRebalance;
															#line 7634 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_6), FutureStream<RebalanceStorageQueueRequest>>::value || std::is_same<decltype(__when_expr_6), ThreadFutureStream<RebalanceStorageQueueRequest>>::value, "invalid type");
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch2(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when6(__when_expr_6.pop(), loopDepth); };
															#line 1385 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		auto __when_expr_7 = self->triggerShardBulkLoading;
															#line 7639 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_7), FutureStream<BulkLoadShardRequest>>::value || std::is_same<decltype(__when_expr_7), ThreadFutureStream<BulkLoadShardRequest>>::value, "invalid type");
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch2(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when7(__when_expr_7.pop(), loopDepth); };
															#line 1388 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		StrictFuture<Void> __when_expr_8 = self->actors.getResult();
															#line 7644 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch2(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when8(__when_expr_8.get(), loopDepth); };
															#line 1389 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		auto __when_expr_9 = self->shardsAffectedByTeamFailure->restartShardTracker.getFuture();
															#line 7648 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_9), FutureStream<KeyRange>>::value || std::is_same<decltype(__when_expr_9), ThreadFutureStream<KeyRange>>::value, "invalid type");
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch2(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when9(__when_expr_9.pop(), loopDepth); };
		static_cast<RunActor*>(this)->actor_wait_state = 2;
															#line 1361 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< RunActor, 1, Promise<int64_t> >*>(static_cast<RunActor*>(this)));
															#line 1364 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunActor, 2, Void >*>(static_cast<RunActor*>(this)));
															#line 1373 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorSingleCallback< RunActor, 3, GetMetricsRequest >*>(static_cast<RunActor*>(this)));
															#line 1376 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorSingleCallback< RunActor, 4, GetTopKMetricsRequest >*>(static_cast<RunActor*>(this)));
															#line 1379 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorSingleCallback< RunActor, 5, GetMetricsListRequest >*>(static_cast<RunActor*>(this)));
															#line 1382 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorSingleCallback< RunActor, 6, RebalanceStorageQueueRequest >*>(static_cast<RunActor*>(this)));
															#line 1385 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorSingleCallback< RunActor, 7, BulkLoadShardRequest >*>(static_cast<RunActor*>(this)));
															#line 1388 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< RunActor, 8, Void >*>(static_cast<RunActor*>(this)));
															#line 1389 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorSingleCallback< RunActor, 9, KeyRange >*>(static_cast<RunActor*>(this)));
															#line 7670 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Promise<int64_t> const& req,int loopDepth) 
	{
															#line 1362 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		req.send(self->getAverageShardBytes());
															#line 7685 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Promise<int64_t> && req,int loopDepth) 
	{
															#line 1362 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		req.send(self->getAverageShardBytes());
															#line 7694 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 1365 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		TraceEvent("DDTrackerStats", self->distributorId) .detail("Shards", self->shards->size()) .detail("TotalSizeBytes", self->dbSizeEstimate->get()) .detail("SystemSizeBytes", self->systemSizeEstimate) .trackLatest(ddTrackerStatsEventHolder->trackingKey);
															#line 1371 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		loggingTrigger = delay(SERVER_KNOBS->DATA_DISTRIBUTION_LOGGING_INTERVAL, TaskPriority::FlushTrace);
															#line 7705 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when2(Void && _,int loopDepth) 
	{
															#line 1365 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		TraceEvent("DDTrackerStats", self->distributorId) .detail("Shards", self->shards->size()) .detail("TotalSizeBytes", self->dbSizeEstimate->get()) .detail("SystemSizeBytes", self->systemSizeEstimate) .trackLatest(ddTrackerStatsEventHolder->trackingKey);
															#line 1371 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		loggingTrigger = delay(SERVER_KNOBS->DATA_DISTRIBUTION_LOGGING_INTERVAL, TaskPriority::FlushTrace);
															#line 7716 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when3(GetMetricsRequest const& req,int loopDepth) 
	{
															#line 1374 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		self->actors.add(fetchShardMetrics(self, req));
															#line 7725 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when3(GetMetricsRequest && req,int loopDepth) 
	{
															#line 1374 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		self->actors.add(fetchShardMetrics(self, req));
															#line 7734 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when4(GetTopKMetricsRequest const& req,int loopDepth) 
	{
															#line 1377 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		self->actors.add(fetchTopKShardMetrics(self, req));
															#line 7743 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when4(GetTopKMetricsRequest && req,int loopDepth) 
	{
															#line 1377 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		self->actors.add(fetchTopKShardMetrics(self, req));
															#line 7752 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when5(GetMetricsListRequest const& req,int loopDepth) 
	{
															#line 1380 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		self->actors.add(fetchShardMetricsList(self, req));
															#line 7761 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when5(GetMetricsListRequest && req,int loopDepth) 
	{
															#line 1380 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		self->actors.add(fetchShardMetricsList(self, req));
															#line 7770 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when6(RebalanceStorageQueueRequest const& req,int loopDepth) 
	{
															#line 1383 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		triggerStorageQueueRebalance(self, req);
															#line 7779 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when6(RebalanceStorageQueueRequest && req,int loopDepth) 
	{
															#line 1383 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		triggerStorageQueueRebalance(self, req);
															#line 7788 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when7(BulkLoadShardRequest const& req,int loopDepth) 
	{
															#line 1386 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		createShardToBulkLoad(self, req.bulkLoadTaskState, req.cancelledDataMovePriority);
															#line 7797 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when7(BulkLoadShardRequest && req,int loopDepth) 
	{
															#line 1386 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		createShardToBulkLoad(self, req.bulkLoadTaskState, req.cancelledDataMovePriority);
															#line 7806 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when9(KeyRange const& req,int loopDepth) 
	{
															#line 1390 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		restartShardTrackers(self, req);
															#line 7827 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when9(KeyRange && req,int loopDepth) 
	{
															#line 1390 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		restartShardTrackers(self, req);
															#line 7836 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunActor*>(this)->actor_wait_state > 0) static_cast<RunActor*>(this)->actor_wait_state = 0;
		static_cast<RunActor*>(this)->ActorSingleCallback< RunActor, 1, Promise<int64_t> >::remove();
		static_cast<RunActor*>(this)->ActorCallback< RunActor, 2, Void >::remove();
		static_cast<RunActor*>(this)->ActorSingleCallback< RunActor, 3, GetMetricsRequest >::remove();
		static_cast<RunActor*>(this)->ActorSingleCallback< RunActor, 4, GetTopKMetricsRequest >::remove();
		static_cast<RunActor*>(this)->ActorSingleCallback< RunActor, 5, GetMetricsListRequest >::remove();
		static_cast<RunActor*>(this)->ActorSingleCallback< RunActor, 6, RebalanceStorageQueueRequest >::remove();
		static_cast<RunActor*>(this)->ActorSingleCallback< RunActor, 7, BulkLoadShardRequest >::remove();
		static_cast<RunActor*>(this)->ActorCallback< RunActor, 8, Void >::remove();
		static_cast<RunActor*>(this)->ActorSingleCallback< RunActor, 9, KeyRange >::remove();

	}
	void a_callback_fire(ActorSingleCallback< RunActor, 1, Promise<int64_t> >*,Promise<int64_t> const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< RunActor, 1, Promise<int64_t> >*,Promise<int64_t> && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< RunActor, 1, Promise<int64_t> >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RunActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RunActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorSingleCallback< RunActor, 3, GetMetricsRequest >*,GetMetricsRequest const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< RunActor, 3, GetMetricsRequest >*,GetMetricsRequest && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorSingleCallback< RunActor, 3, GetMetricsRequest >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< RunActor, 4, GetTopKMetricsRequest >*,GetTopKMetricsRequest const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorSingleCallback< RunActor, 4, GetTopKMetricsRequest >*,GetTopKMetricsRequest && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorSingleCallback< RunActor, 4, GetTopKMetricsRequest >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorSingleCallback< RunActor, 5, GetMetricsListRequest >*,GetMetricsListRequest const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when5(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorSingleCallback< RunActor, 5, GetMetricsListRequest >*,GetMetricsListRequest && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when5(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorSingleCallback< RunActor, 5, GetMetricsListRequest >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorSingleCallback< RunActor, 6, RebalanceStorageQueueRequest >*,RebalanceStorageQueueRequest const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when6(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorSingleCallback< RunActor, 6, RebalanceStorageQueueRequest >*,RebalanceStorageQueueRequest && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when6(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorSingleCallback< RunActor, 6, RebalanceStorageQueueRequest >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorSingleCallback< RunActor, 7, BulkLoadShardRequest >*,BulkLoadShardRequest const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when7(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorSingleCallback< RunActor, 7, BulkLoadShardRequest >*,BulkLoadShardRequest && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when7(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorSingleCallback< RunActor, 7, BulkLoadShardRequest >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< RunActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when8(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< RunActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when8(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< RunActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorSingleCallback< RunActor, 9, KeyRange >*,KeyRange const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when9(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorSingleCallback< RunActor, 9, KeyRange >*,KeyRange && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when9(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorSingleCallback< RunActor, 9, KeyRange >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 9);

	}
															#line 1351 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	DataDistributionTracker* self;
															#line 1351 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	Reference<InitialDataDistribution> initData;
															#line 1352 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	Future<Void> loggingTrigger;
															#line 1353 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	Future<Void> readHotDetect;
															#line 1354 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	Reference<EventCacheHolder> ddTrackerStatsEventHolder;
															#line 8378 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via run()
															#line 1351 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class RunActor final : public Actor<Void>, public ActorCallback< RunActor, 0, Void >, public ActorSingleCallback< RunActor, 1, Promise<int64_t> >, public ActorCallback< RunActor, 2, Void >, public ActorSingleCallback< RunActor, 3, GetMetricsRequest >, public ActorSingleCallback< RunActor, 4, GetTopKMetricsRequest >, public ActorSingleCallback< RunActor, 5, GetMetricsListRequest >, public ActorSingleCallback< RunActor, 6, RebalanceStorageQueueRequest >, public ActorSingleCallback< RunActor, 7, BulkLoadShardRequest >, public ActorCallback< RunActor, 8, Void >, public ActorSingleCallback< RunActor, 9, KeyRange >, public FastAllocated<RunActor>, public RunActorState<RunActor> {
															#line 8383 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
public:
	using FastAllocated<RunActor>::operator new;
	using FastAllocated<RunActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1672425111827833088UL, 12947038642773544448UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunActor, 0, Void >;
friend struct ActorSingleCallback< RunActor, 1, Promise<int64_t> >;
friend struct ActorCallback< RunActor, 2, Void >;
friend struct ActorSingleCallback< RunActor, 3, GetMetricsRequest >;
friend struct ActorSingleCallback< RunActor, 4, GetTopKMetricsRequest >;
friend struct ActorSingleCallback< RunActor, 5, GetMetricsListRequest >;
friend struct ActorSingleCallback< RunActor, 6, RebalanceStorageQueueRequest >;
friend struct ActorSingleCallback< RunActor, 7, BulkLoadShardRequest >;
friend struct ActorCallback< RunActor, 8, Void >;
friend struct ActorSingleCallback< RunActor, 9, KeyRange >;
															#line 1351 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	RunActor(DataDistributionTracker* const& self,Reference<InitialDataDistribution> const& initData) 
															#line 8409 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   RunActorState<RunActor>(self, initData),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(633236942609902848UL, 16810589115111353856UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("run");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorSingleCallback< RunActor, 1, Promise<int64_t> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1351 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
[[nodiscard]] static Future<Void> run( DataDistributionTracker* const& self, Reference<InitialDataDistribution> const& initData ) {
															#line 1351 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	return Future<Void>(new RunActor(self, initData));
															#line 8442 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
}

#line 1403 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
};

Future<Void> DataDistributionTracker::run(
    Reference<DataDistributionTracker> self,
    const Reference<InitialDataDistribution>& initData,
    const FutureStream<GetMetricsRequest>& getShardMetrics,
    const FutureStream<GetTopKMetricsRequest>& getTopKMetrics,
    const FutureStream<GetMetricsListRequest>& getShardMetricsList,
    const FutureStream<Promise<int64_t>>& getAverageShardBytes,
    const FutureStream<RebalanceStorageQueueRequest>& triggerStorageQueueRebalance,
    const FutureStream<BulkLoadShardRequest>& triggerShardBulkLoading) {
	self->getShardMetrics = getShardMetrics;
	self->getTopKMetrics = getTopKMetrics;
	self->getShardMetricsList = getShardMetricsList;
	self->averageShardBytes = getAverageShardBytes;
	self->triggerStorageQueueRebalance = triggerStorageQueueRebalance;
	self->triggerShardBulkLoading = triggerShardBulkLoading;
	self->userRangeConfig = initData->userRangeConfig;
	self->bulkLoadEnabled = bulkLoadIsEnabled(initData->bulkLoadMode);
	return holdWhile(self, DataDistributionTrackerImpl::run(self.getPtr(), initData));
}

// Tracks storage metrics for `keys` and updates `physicalShardStats` which is the stats for the physical shard owning
// this key range. This function is similar to `trackShardMetrics()` and altered for physical shard. This meant to be
// temporary. Eventually, we want a new interface to track physical shard metrics more efficiently.
															#line 8471 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via trackKeyRangeInPhysicalShardMetrics()
															#line 1428 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
template <class TrackKeyRangeInPhysicalShardMetricsActor>
															#line 1428 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class TrackKeyRangeInPhysicalShardMetricsActorState {
															#line 8478 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
public:
															#line 1428 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	TrackKeyRangeInPhysicalShardMetricsActorState(Reference<IDDTxnProcessor> const& db,KeyRange const& keys,Reference<AsyncVar<Optional<ShardMetrics>>> const& shardMetrics,Reference<AsyncVar<Optional<StorageMetrics>>> const& physicalShardStats) 
															#line 1428 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
															#line 1428 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		 : db(db),
															#line 1428 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   keys(keys),
															#line 1428 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   shardMetrics(shardMetrics),
															#line 1428 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   physicalShardStats(physicalShardStats),
															#line 1433 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   bandwidthStatus(shardMetrics->get().present() ? getBandwidthStatus(shardMetrics->get().get().metrics) : BandwidthStatusNormal),
															#line 1435 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   lastLowBandwidthStartTime(shardMetrics->get().present() ? shardMetrics->get().get().lastLowBandwidthStartTime : now()),
															#line 1437 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   shardCount(shardMetrics->get().present() ? shardMetrics->get().get().shardCount : 1)
															#line 8497 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("trackKeyRangeInPhysicalShardMetrics", reinterpret_cast<unsigned long>(this));

	}
	~TrackKeyRangeInPhysicalShardMetricsActorState() 
	{
		fdb_probe_actor_destroy("trackKeyRangeInPhysicalShardMetrics", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1438 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(0, TaskPriority::DataDistribution);
															#line 1438 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (static_cast<TrackKeyRangeInPhysicalShardMetricsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8514 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TrackKeyRangeInPhysicalShardMetricsActor*>(this)->actor_wait_state = 1;
															#line 1438 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TrackKeyRangeInPhysicalShardMetricsActor, 0, Void >*>(static_cast<TrackKeyRangeInPhysicalShardMetricsActor*>(this)));
															#line 8519 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TrackKeyRangeInPhysicalShardMetricsActorState();
		static_cast<TrackKeyRangeInPhysicalShardMetricsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1446 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		;
															#line 8542 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1446 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		;
															#line 8551 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TrackKeyRangeInPhysicalShardMetricsActor*>(this)->actor_wait_state > 0) static_cast<TrackKeyRangeInPhysicalShardMetricsActor*>(this)->actor_wait_state = 0;
		static_cast<TrackKeyRangeInPhysicalShardMetricsActor*>(this)->ActorCallback< TrackKeyRangeInPhysicalShardMetricsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TrackKeyRangeInPhysicalShardMetricsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("trackKeyRangeInPhysicalShardMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackKeyRangeInPhysicalShardMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackKeyRangeInPhysicalShardMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TrackKeyRangeInPhysicalShardMetricsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("trackKeyRangeInPhysicalShardMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackKeyRangeInPhysicalShardMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackKeyRangeInPhysicalShardMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TrackKeyRangeInPhysicalShardMetricsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("trackKeyRangeInPhysicalShardMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TrackKeyRangeInPhysicalShardMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackKeyRangeInPhysicalShardMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1447 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		bounds = ShardSizeBounds();
															#line 1448 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		bool readHotShard;
															#line 1449 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		std::tie(bounds, readHotShard) = calculateShardSizeBounds(keys, shardMetrics, bandwidthStatus);
															#line 1451 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		;
															#line 8648 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1(int loopDepth) 
	{
															#line 1453 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		StrictFuture<std::pair<Optional<StorageMetrics>, int>> __when_expr_1 = db->waitStorageMetrics(keys, bounds.min, bounds.max, bounds.permittedError, CLIENT_KNOBS->STORAGE_METRICS_SHARD_LIMIT, shardCount);
															#line 1453 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (static_cast<TrackKeyRangeInPhysicalShardMetricsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 8672 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TrackKeyRangeInPhysicalShardMetricsActor*>(this)->actor_wait_state = 2;
															#line 1453 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TrackKeyRangeInPhysicalShardMetricsActor, 1, std::pair<Optional<StorageMetrics>, int> >*>(static_cast<TrackKeyRangeInPhysicalShardMetricsActor*>(this)));
															#line 8677 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(std::pair<Optional<StorageMetrics>, int> const& metrics,int loopDepth) 
	{
															#line 1460 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (metrics.first.present())
															#line 8699 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		{
															#line 1461 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			BandwidthStatus newBandwidthStatus = getBandwidthStatus(metrics.first.get());
															#line 1462 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (newBandwidthStatus == BandwidthStatusLow && bandwidthStatus != BandwidthStatusLow)
															#line 8705 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			{
															#line 1463 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				lastLowBandwidthStartTime = now();
															#line 8709 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			}
															#line 1465 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			bandwidthStatus = newBandwidthStatus;
															#line 1468 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (!physicalShardStats->get().present())
															#line 8715 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			{
															#line 1469 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				physicalShardStats->set(metrics.first.get());
															#line 8719 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1471 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				if (!shardMetrics->get().present())
															#line 8725 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
				{
															#line 1473 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
					physicalShardStats->set(physicalShardStats->get().get() + metrics.first.get());
															#line 8729 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
				}
				else
				{
															#line 1475 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
					physicalShardStats->set(physicalShardStats->get().get() - shardMetrics->get().get().metrics + metrics.first.get());
															#line 8735 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
				}
			}
															#line 1480 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			shardMetrics->set(ShardMetrics(metrics.first.get(), lastLowBandwidthStartTime, shardCount));
															#line 8740 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
		else
		{
															#line 1483 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			shardCount = metrics.second;
															#line 1484 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (shardMetrics->get().present())
															#line 8749 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			{
															#line 1485 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				auto newShardMetrics = shardMetrics->get().get();
															#line 1486 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				newShardMetrics.shardCount = shardCount;
															#line 1487 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				shardMetrics->set(newShardMetrics);
															#line 8757 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			}
		}
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(std::pair<Optional<StorageMetrics>, int> && metrics,int loopDepth) 
	{
															#line 1460 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (metrics.first.present())
															#line 8768 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		{
															#line 1461 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			BandwidthStatus newBandwidthStatus = getBandwidthStatus(metrics.first.get());
															#line 1462 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (newBandwidthStatus == BandwidthStatusLow && bandwidthStatus != BandwidthStatusLow)
															#line 8774 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			{
															#line 1463 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				lastLowBandwidthStartTime = now();
															#line 8778 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			}
															#line 1465 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			bandwidthStatus = newBandwidthStatus;
															#line 1468 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (!physicalShardStats->get().present())
															#line 8784 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			{
															#line 1469 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				physicalShardStats->set(metrics.first.get());
															#line 8788 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1471 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				if (!shardMetrics->get().present())
															#line 8794 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
				{
															#line 1473 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
					physicalShardStats->set(physicalShardStats->get().get() + metrics.first.get());
															#line 8798 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
				}
				else
				{
															#line 1475 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
					physicalShardStats->set(physicalShardStats->get().get() - shardMetrics->get().get().metrics + metrics.first.get());
															#line 8804 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
				}
			}
															#line 1480 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			shardMetrics->set(ShardMetrics(metrics.first.get(), lastLowBandwidthStartTime, shardCount));
															#line 8809 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
		else
		{
															#line 1483 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			shardCount = metrics.second;
															#line 1484 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (shardMetrics->get().present())
															#line 8818 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			{
															#line 1485 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				auto newShardMetrics = shardMetrics->get().get();
															#line 1486 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				newShardMetrics.shardCount = shardCount;
															#line 1487 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				shardMetrics->set(newShardMetrics);
															#line 8826 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			}
		}
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(std::pair<Optional<StorageMetrics>, int> const& metrics,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(metrics, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(std::pair<Optional<StorageMetrics>, int> && metrics,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(std::move(metrics), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TrackKeyRangeInPhysicalShardMetricsActor*>(this)->actor_wait_state > 0) static_cast<TrackKeyRangeInPhysicalShardMetricsActor*>(this)->actor_wait_state = 0;
		static_cast<TrackKeyRangeInPhysicalShardMetricsActor*>(this)->ActorCallback< TrackKeyRangeInPhysicalShardMetricsActor, 1, std::pair<Optional<StorageMetrics>, int> >::remove();

	}
	void a_callback_fire(ActorCallback< TrackKeyRangeInPhysicalShardMetricsActor, 1, std::pair<Optional<StorageMetrics>, int> >*,std::pair<Optional<StorageMetrics>, int> const& value) 
	{
		fdb_probe_actor_enter("trackKeyRangeInPhysicalShardMetrics", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackKeyRangeInPhysicalShardMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackKeyRangeInPhysicalShardMetrics", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TrackKeyRangeInPhysicalShardMetricsActor, 1, std::pair<Optional<StorageMetrics>, int> >*,std::pair<Optional<StorageMetrics>, int> && value) 
	{
		fdb_probe_actor_enter("trackKeyRangeInPhysicalShardMetrics", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackKeyRangeInPhysicalShardMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackKeyRangeInPhysicalShardMetrics", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TrackKeyRangeInPhysicalShardMetricsActor, 1, std::pair<Optional<StorageMetrics>, int> >*,Error err) 
	{
		fdb_probe_actor_enter("trackKeyRangeInPhysicalShardMetrics", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TrackKeyRangeInPhysicalShardMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackKeyRangeInPhysicalShardMetrics", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1428 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	Reference<IDDTxnProcessor> db;
															#line 1428 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	KeyRange keys;
															#line 1428 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	Reference<AsyncVar<Optional<ShardMetrics>>> shardMetrics;
															#line 1428 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	Reference<AsyncVar<Optional<StorageMetrics>>> physicalShardStats;
															#line 1433 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	BandwidthStatus bandwidthStatus;
															#line 1435 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	double lastLowBandwidthStartTime;
															#line 1437 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	int shardCount;
															#line 1447 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	ShardSizeBounds bounds;
															#line 8924 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via trackKeyRangeInPhysicalShardMetrics()
															#line 1428 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class TrackKeyRangeInPhysicalShardMetricsActor final : public Actor<Void>, public ActorCallback< TrackKeyRangeInPhysicalShardMetricsActor, 0, Void >, public ActorCallback< TrackKeyRangeInPhysicalShardMetricsActor, 1, std::pair<Optional<StorageMetrics>, int> >, public FastAllocated<TrackKeyRangeInPhysicalShardMetricsActor>, public TrackKeyRangeInPhysicalShardMetricsActorState<TrackKeyRangeInPhysicalShardMetricsActor> {
															#line 8929 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
public:
	using FastAllocated<TrackKeyRangeInPhysicalShardMetricsActor>::operator new;
	using FastAllocated<TrackKeyRangeInPhysicalShardMetricsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2357356724135696128UL, 3457696890349045504UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TrackKeyRangeInPhysicalShardMetricsActor, 0, Void >;
friend struct ActorCallback< TrackKeyRangeInPhysicalShardMetricsActor, 1, std::pair<Optional<StorageMetrics>, int> >;
															#line 1428 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	TrackKeyRangeInPhysicalShardMetricsActor(Reference<IDDTxnProcessor> const& db,KeyRange const& keys,Reference<AsyncVar<Optional<ShardMetrics>>> const& shardMetrics,Reference<AsyncVar<Optional<StorageMetrics>>> const& physicalShardStats) 
															#line 8947 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TrackKeyRangeInPhysicalShardMetricsActorState<TrackKeyRangeInPhysicalShardMetricsActor>(db, keys, shardMetrics, physicalShardStats),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("trackKeyRangeInPhysicalShardMetrics", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10053982890854043392UL, 5522241827895872000UL);
		ActorExecutionContextHelper __helper(static_cast<TrackKeyRangeInPhysicalShardMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("trackKeyRangeInPhysicalShardMetrics");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("trackKeyRangeInPhysicalShardMetrics", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TrackKeyRangeInPhysicalShardMetricsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TrackKeyRangeInPhysicalShardMetricsActor, 1, std::pair<Optional<StorageMetrics>, int> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1428 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
[[nodiscard]] Future<Void> trackKeyRangeInPhysicalShardMetrics( Reference<IDDTxnProcessor> const& db, KeyRange const& keys, Reference<AsyncVar<Optional<ShardMetrics>>> const& shardMetrics, Reference<AsyncVar<Optional<StorageMetrics>>> const& physicalShardStats ) {
															#line 1428 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	return Future<Void>(new TrackKeyRangeInPhysicalShardMetricsActor(db, keys, shardMetrics, physicalShardStats));
															#line 8981 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
}

#line 1493 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"

void PhysicalShardCollection::PhysicalShard::insertNewRangeData(const KeyRange& newRange) {
	RangeData data;
	data.stats = makeReference<AsyncVar<Optional<ShardMetrics>>>();
	data.trackMetrics = trackKeyRangeInPhysicalShardMetrics(txnProcessor, newRange, data.stats, stats);
	auto it = rangeData.emplace(newRange, data);
	ASSERT(it.second);
}

void PhysicalShardCollection::PhysicalShard::addRange(const KeyRange& newRange) {
	if (g_network->isSimulated()) {
		// Test that new range must not overlap with any existing range in this shard.
		for (const auto& [range, data] : rangeData) {
			ASSERT(!range.intersects(newRange));
		}
	}

	insertNewRangeData(newRange);
}

void PhysicalShardCollection::PhysicalShard::removeRange(const KeyRange& outRange) {
	std::vector<KeyRangeRef> updateRanges;
	for (auto& [range, data] : rangeData) {
		if (range.intersects(outRange)) {
			updateRanges.push_back(range);
		}
	}

	for (auto& range : updateRanges) {
		std::vector<KeyRangeRef> remainingRanges = range - outRange;
		for (auto& r : remainingRanges) {
			ASSERT(r != range);
			insertNewRangeData(r);
		}
		// Must erase last since `remainingRanges` uses data in `range`.
		rangeData.erase(range);
	}
}

// Decide whether a physical shard is available at the moment when the func is calling
PhysicalShardAvailable PhysicalShardCollection::checkPhysicalShardAvailable(uint64_t physicalShardID,
                                                                            StorageMetrics const& moveInMetrics) {
	ASSERT(physicalShardID != UID().first() && physicalShardID != anonymousShardId.first());
	ASSERT(physicalShardInstances.contains(physicalShardID));
	if (physicalShardInstances[physicalShardID].metrics.bytes + moveInMetrics.bytes >
	    SERVER_KNOBS->MAX_PHYSICAL_SHARD_BYTES) {
		return PhysicalShardAvailable::False;
	}
	return PhysicalShardAvailable::True;
}

std::string PhysicalShardCollection::convertIDsToString(std::set<uint64_t> ids) {
	std::string r = "";
	for (auto id : ids) {
		r = r + std::to_string(id) + " ";
	}
	return r;
}

void PhysicalShardCollection::updateTeamPhysicalShardIDsMap(uint64_t inputPhysicalShardID,
                                                            std::vector<ShardsAffectedByTeamFailure::Team> inputTeams,
                                                            uint64_t debugID) {
	ASSERT(inputTeams.size() <= 2);
	ASSERT(inputPhysicalShardID != anonymousShardId.first() && inputPhysicalShardID != UID().first());
	for (auto inputTeam : inputTeams) {
		if (!teamPhysicalShardIDs.contains(inputTeam)) {
			std::set<uint64_t> physicalShardIDSet;
			physicalShardIDSet.insert(inputPhysicalShardID);
			teamPhysicalShardIDs.insert(std::make_pair(inputTeam, physicalShardIDSet));
		} else {
			teamPhysicalShardIDs[inputTeam].insert(inputPhysicalShardID);
		}
	}
	return;
}

void PhysicalShardCollection::insertPhysicalShardToCollection(uint64_t physicalShardID,
                                                              StorageMetrics const& metrics,
                                                              std::vector<ShardsAffectedByTeamFailure::Team> teams,
                                                              uint64_t debugID,
                                                              PhysicalShardCreationTime whenCreated) {
	ASSERT(physicalShardID != anonymousShardId.first() && physicalShardID != UID().first());
	ASSERT(!physicalShardInstances.contains(physicalShardID));
	physicalShardInstances.insert(
	    std::make_pair(physicalShardID, PhysicalShard(txnProcessor, physicalShardID, metrics, teams, whenCreated)));
	return;
}

// This method maintains the consistency between keyRangePhysicalShardIDMap and the RangeData in physicalShardInstances.
// They are all updated in this method.
void PhysicalShardCollection::updatekeyRangePhysicalShardIDMap(KeyRange keyRange,
                                                               uint64_t physicalShardID,
                                                               uint64_t debugID) {
	ASSERT(physicalShardID != UID().first());
	auto ranges = keyRangePhysicalShardIDMap.intersectingRanges(keyRange);
	std::set<uint64_t> physicalShardIDSet;

	// If there are any existing physical shards own `keyRange`, remove the overlapping ranges from existing physical
	// shards.
	for (auto it = ranges.begin(); it != ranges.end(); ++it) {
		uint64_t shardID = it->value();
		if (shardID == UID().first()) {
			continue;
		}
		ASSERT(physicalShardInstances.find(shardID) != physicalShardInstances.end());
		physicalShardInstances[shardID].removeRange(keyRange);
	}

	// Insert `keyRange` to the new physical shard.
	keyRangePhysicalShardIDMap.insert(keyRange, physicalShardID);
	ASSERT(physicalShardInstances.find(physicalShardID) != physicalShardInstances.end());
	physicalShardInstances[physicalShardID].addRange(keyRange);

	// KeyRange to physical shard mapping consistency sanity check.
	checkKeyRangePhysicalShardMapping();
}

void PhysicalShardCollection::checkKeyRangePhysicalShardMapping() {
	if (!g_network->isSimulated()) {
		return;
	}

	// Check the invariant that keyRangePhysicalShardIDMap and physicalShardInstances should be consistent.
	KeyRangeMap<uint64_t>::Ranges keyRangePhysicalShardIDRanges = keyRangePhysicalShardIDMap.ranges();
	KeyRangeMap<uint64_t>::iterator it = keyRangePhysicalShardIDRanges.begin();
	for (; it != keyRangePhysicalShardIDRanges.end(); ++it) {
		uint64_t shardID = it->value();
		if (shardID == UID().first()) {
			continue;
		}
		auto keyRangePiece = KeyRangeRef(it->range().begin, it->range().end);
		ASSERT(physicalShardInstances.find(shardID) != physicalShardInstances.end());
		bool exist = false;
		for (const auto& [range, data] : physicalShardInstances[shardID].rangeData) {
			if (range == keyRangePiece) {
				exist = true;
				break;
			}
		}
		ASSERT(exist);
	}

	for (auto& [shardID, physicalShard] : physicalShardInstances) {
		for (auto& [range, data] : physicalShard.rangeData) {
			ASSERT(keyRangePhysicalShardIDMap[range.begin] == shardID);
		}
	}
}

// At beginning of the transition from the initial state without physical shard notion
// to the physical shard aware state, the physicalShard set only contains one element which is anonymousShardId[0]
// After a period in the transition, the physicalShard set of the team contains some meaningful physicalShardIDs
Optional<uint64_t> PhysicalShardCollection::trySelectAvailablePhysicalShardFor(
    ShardsAffectedByTeamFailure::Team team,
    StorageMetrics const& moveInMetrics,
    const std::unordered_set<uint64_t>& excludedPhysicalShards,
    uint64_t debugID) {
	ASSERT(team.servers.size() > 0);
	// Case: The team is not tracked in the mapping (teamPhysicalShardIDs)
	if (!teamPhysicalShardIDs.contains(team)) {
		return Optional<uint64_t>();
	}
	ASSERT(teamPhysicalShardIDs[team].size() >= 1);
	// Case: The team is tracked in the mapping and the system already has physical shard notion
	// 		and the number of physicalShard is large
	std::vector<uint64_t> availablePhysicalShardIDs;
	for (auto physicalShardID : teamPhysicalShardIDs[team]) {
		if (physicalShardID == anonymousShardId.first() || physicalShardID == UID().first()) {
			ASSERT(false);
		}
		ASSERT(physicalShardInstances.contains(physicalShardID));
		/*TraceEvent("TryGetPhysicalShardIDCandidates")
		    .detail("PhysicalShardID", physicalShardID)
		    .detail("Bytes", physicalShardInstances[physicalShardID].metrics.bytes)
		    .detail("BelongTeam", team.toString())
		    .detail("DebugID", debugID);*/
		if (excludedPhysicalShards.find(physicalShardID) != excludedPhysicalShards.end()) {
			continue;
		}
		if (!checkPhysicalShardAvailable(physicalShardID, moveInMetrics)) {
			continue;
		}
		availablePhysicalShardIDs.push_back(physicalShardID);
	}
	if (availablePhysicalShardIDs.size() == 0) {
		/*TraceEvent("TryGetPhysicalShardIDResultFailed")
		    .detail("Reason", "no valid physicalShard")
		    .detail("MoveInBytes", moveInMetrics.bytes)
		    .detail("MaxPhysicalShardBytes", SERVER_KNOBS->MAX_PHYSICAL_SHARD_BYTES)
		    .detail("DebugID", debugID);*/
		return Optional<uint64_t>();
	}
	return deterministicRandom()->randomChoice(availablePhysicalShardIDs);
}

uint64_t PhysicalShardCollection::generateNewPhysicalShardID(uint64_t debugID) {
	uint64_t physicalShardID = UID().first();
	int stuckCount = 0;
	while (physicalShardID == UID().first() || physicalShardID == anonymousShardId.first()) {
		physicalShardID = deterministicRandom()->randomUInt64();
		stuckCount = stuckCount + 1;
		if (stuckCount > 50) {
			ASSERT(false);
		}
	}
	ASSERT(physicalShardID != UID().first() && physicalShardID != anonymousShardId.first());
	//TraceEvent("GenerateNewPhysicalShardID").detail("PhysicalShardID", physicalShardID).detail("DebugID", debugID);
	return physicalShardID;
}

void PhysicalShardCollection::reduceMetricsForMoveOut(uint64_t physicalShardID, StorageMetrics const& moveOutMetrics) {
	ASSERT(physicalShardInstances.contains(physicalShardID));
	ASSERT(physicalShardID != UID().first() && physicalShardID != anonymousShardId.first());
	physicalShardInstances[physicalShardID].metrics = physicalShardInstances[physicalShardID].metrics - moveOutMetrics;
	return;
}

void PhysicalShardCollection::increaseMetricsForMoveIn(uint64_t physicalShardID, StorageMetrics const& moveInMetrics) {
	ASSERT(physicalShardInstances.contains(physicalShardID));
	ASSERT(physicalShardID != UID().first() && physicalShardID != anonymousShardId.first());
	physicalShardInstances[physicalShardID].metrics = physicalShardInstances[physicalShardID].metrics + moveInMetrics;
	return;
}

void PhysicalShardCollection::updatePhysicalShardMetricsByKeyRange(KeyRange keyRange,
                                                                   StorageMetrics const& newMetrics,
                                                                   StorageMetrics const& oldMetrics,
                                                                   bool initWithNewMetrics) {
	auto ranges = keyRangePhysicalShardIDMap.intersectingRanges(keyRange);
	std::set<uint64_t> physicalShardIDSet;
	for (auto it = ranges.begin(); it != ranges.end(); ++it) {
		physicalShardIDSet.insert(it->value());
	}
	StorageMetrics delta;
	if (initWithNewMetrics) {
		delta = newMetrics;
	} else {
		delta = newMetrics - oldMetrics;
	}
	for (auto physicalShardID : physicalShardIDSet) {
		ASSERT(physicalShardID != UID().first());
		if (physicalShardID == anonymousShardId.first()) {
			continue; // we ignore anonymousShard when updating physicalShard metrics
		}
		increaseMetricsForMoveIn(physicalShardID, (delta * (1.0 / physicalShardIDSet.size())));
	}
	return;
}

InAnonymousPhysicalShard PhysicalShardCollection::isInAnonymousPhysicalShard(KeyRange keyRange) {
	InAnonymousPhysicalShard res = InAnonymousPhysicalShard::True;
	auto ranges = keyRangePhysicalShardIDMap.intersectingRanges(keyRange);
	for (auto it = ranges.begin(); it != ranges.end(); ++it) {
		uint64_t physicalShardID = it->value();
		if (physicalShardID != anonymousShardId.first()) {
			// res = false if exists a part of keyRange belongs to a non-anonymous physicalShard
			// exist a case where some keyRange of anonymousShard is decided to move
			// to a non-anonymous physicalShard but not completes
			res = InAnonymousPhysicalShard::False;
		}
	}
	return res;
}

// TODO: require optimize
// It is slow to go through the keyRangePhysicalShardIDRanges for each time
// Do we need a D/S to store the keyRange for each physicalShard?
PhysicalShardHasMoreThanKeyRange PhysicalShardCollection::whetherPhysicalShardHasMoreThanKeyRange(
    uint64_t physicalShardID,
    KeyRange keyRange) {
	KeyRangeMap<uint64_t>::Ranges keyRangePhysicalShardIDRanges = keyRangePhysicalShardIDMap.ranges();
	KeyRangeMap<uint64_t>::iterator it = keyRangePhysicalShardIDRanges.begin();
	for (; it != keyRangePhysicalShardIDRanges.end(); ++it) {
		if (it->value() != physicalShardID) {
			continue;
		}
		auto keyRangePiece = KeyRangeRef(it->range().begin, it->range().end);
		if (!keyRange.intersects(keyRangePiece)) {
			return PhysicalShardHasMoreThanKeyRange::True;
		}
		// if keyRange and keyRangePiece have intersection
		if (!keyRange.contains(keyRangePiece)) {
			return PhysicalShardHasMoreThanKeyRange::True;
		}
	}
	return PhysicalShardHasMoreThanKeyRange::False;
}

InOverSizePhysicalShard PhysicalShardCollection::isInOverSizePhysicalShard(KeyRange keyRange) {
	auto ranges = keyRangePhysicalShardIDMap.intersectingRanges(keyRange);
	for (auto it = ranges.begin(); it != ranges.end(); ++it) {
		uint64_t physicalShardID = it->value();
		ASSERT(physicalShardID != UID().first());
		if (physicalShardID == anonymousShardId.first()) {
			continue;
		}
		if (checkPhysicalShardAvailable(physicalShardID, StorageMetrics())) {
			continue;
		}
		if (!whetherPhysicalShardHasMoreThanKeyRange(physicalShardID, keyRange)) {
			continue;
		}
		return InOverSizePhysicalShard::True;
	}
	return InOverSizePhysicalShard::False;
}

// May return a problematic remote team
std::pair<Optional<ShardsAffectedByTeamFailure::Team>, bool> PhysicalShardCollection::tryGetAvailableRemoteTeamWith(
    uint64_t inputPhysicalShardID,
    StorageMetrics const& moveInMetrics,
    uint64_t debugID) {
	ASSERT(SERVER_KNOBS->SHARD_ENCODE_LOCATION_METADATA);
	ASSERT(SERVER_KNOBS->ENABLE_DD_PHYSICAL_SHARD);
	ASSERT(inputPhysicalShardID != anonymousShardId.first() && inputPhysicalShardID != UID().first());
	if (!physicalShardInstances.contains(inputPhysicalShardID)) {
		return { Optional<ShardsAffectedByTeamFailure::Team>(), true };
	}
	if (!checkPhysicalShardAvailable(inputPhysicalShardID, moveInMetrics)) {
		return { Optional<ShardsAffectedByTeamFailure::Team>(), false };
	}
	for (auto team : physicalShardInstances[inputPhysicalShardID].teams) {
		if (team.primary == false) {
			/*TraceEvent("TryGetRemoteTeamWith")
			    .detail("PhysicalShardID", inputPhysicalShardID)
			    .detail("Team", team.toString())
			    .detail("TeamSize", team.servers.size())
			    .detail("PhysicalShardsOfTeam", convertIDsToString(teamPhysicalShardIDs[team]))
			    .detail("DebugID", debugID);*/
			return { team, true };
		}
	}
	// In this case, the physical shard may not be populated in the remote region yet, e.g., we are making a
	// configuration change to turn a single region cluster into HA mode.
	return { Optional<ShardsAffectedByTeamFailure::Team>(), true };
}

// The update of PhysicalShardToTeams, Collection, keyRangePhysicalShardIDMap should be atomic
void PhysicalShardCollection::initPhysicalShardCollection(KeyRange keys,
                                                          std::vector<ShardsAffectedByTeamFailure::Team> selectedTeams,
                                                          uint64_t physicalShardID,
                                                          uint64_t debugID) {
	ASSERT(SERVER_KNOBS->SHARD_ENCODE_LOCATION_METADATA);
	ASSERT(SERVER_KNOBS->ENABLE_DD_PHYSICAL_SHARD);
	ASSERT(physicalShardID != UID().first());
	if (physicalShardID != anonymousShardId.first()) {
		updateTeamPhysicalShardIDsMap(physicalShardID, selectedTeams, debugID);
		if (!physicalShardInstances.contains(physicalShardID)) {
			insertPhysicalShardToCollection(
			    physicalShardID, StorageMetrics(), selectedTeams, debugID, PhysicalShardCreationTime::DDInit);
		} else {
			// This assertion will be broken if we enable the optimization of data move traffic between DCs
			ASSERT(physicalShardInstances[physicalShardID].teams == selectedTeams);
		}
	} else {
		// If any physicalShard restored when DD init is the anonymousShard,
		// Then DD enters Transition state where DD graduatelly moves Shard (or KeyRange)
		// out of the anonymousShard
		setTransitionCheck();
	}
	updatekeyRangePhysicalShardIDMap(keys, physicalShardID, debugID);
	return;
}

// The update of PhysicalShardToTeams, Collection, keyRangePhysicalShardIDMap should be atomic
void PhysicalShardCollection::updatePhysicalShardCollection(
    KeyRange keys,
    bool isRestore,
    std::vector<ShardsAffectedByTeamFailure::Team> selectedTeams,
    uint64_t physicalShardID,
    const StorageMetrics& metrics,
    uint64_t debugID) {
	ASSERT(SERVER_KNOBS->SHARD_ENCODE_LOCATION_METADATA);
	ASSERT(SERVER_KNOBS->ENABLE_DD_PHYSICAL_SHARD);
	ASSERT(physicalShardID != UID().first());
	/*TraceEvent e("UpdatePhysicalShard");
	e.detail("DebugID", debugID);
	e.detail("KeyRange", keys);
	e.detail("IsRestore", isRestore);*/
	// When updates metrics in physicalShard collection, we assume:
	// It is impossible to move a keyRange from anonymousShard to a valid physicalShard
	// Thus, we ignore anonymousShard when updating metrics
	if (physicalShardID != anonymousShardId.first()) {
		updateTeamPhysicalShardIDsMap(physicalShardID, selectedTeams, debugID);
		// Update physicalShardInstances
		// Add the metrics to in-physicalShard
		// e.detail("PhysicalShardIDIn", physicalShardID);
		if (!physicalShardInstances.contains(physicalShardID)) {
			// e.detail("Op", "Insert");
			insertPhysicalShardToCollection(
			    physicalShardID, metrics, selectedTeams, debugID, PhysicalShardCreationTime::DDRelocator);
		} else {
			// e.detail("Op", "Update");
			//  This assertion is true since we disable the optimization of data move traffic between DCs
			ASSERT(physicalShardInstances[physicalShardID].teams == selectedTeams);
			increaseMetricsForMoveIn(physicalShardID, metrics);
		}
	}
	// Minus the metrics from the existing (multiple) out-physicalShard(s)
	auto ranges = keyRangePhysicalShardIDMap.intersectingRanges(keys);
	std::set<uint64_t> physicalShardIDSet;
	for (auto it = ranges.begin(); it != ranges.end(); ++it) {
		physicalShardIDSet.insert(it->value());
	}
	/*std::string physicalShardIDOut = "";
	for (auto id : physicalShardIDSet) {
	    physicalShardIDOut = physicalShardIDOut + std::to_string(id) + " ";
	}*/
	// e.detail("PhysicalShardIDOut", physicalShardIDOut);
	for (auto physicalShardID : physicalShardIDSet) { // imprecise: evenly move out bytes
		if (physicalShardID == anonymousShardId.first()) {
			continue; // we ignore anonymousShard when updating physicalShard metrics
		}
		StorageMetrics toReduceMetrics = metrics * (1.0 / physicalShardIDSet.size());
		reduceMetricsForMoveOut(physicalShardID, toReduceMetrics);
	}
	// keyRangePhysicalShardIDMap must be update after updating the metrics of physicalShardInstances
	updatekeyRangePhysicalShardIDMap(keys, physicalShardID, debugID);
	return;
}

// return false if no need to move keyRange out of current physical shard
MoveKeyRangeOutPhysicalShard PhysicalShardCollection::trackPhysicalShard(KeyRange keyRange,
                                                                         StorageMetrics const& newMetrics,
                                                                         StorageMetrics const& oldMetrics,
                                                                         bool initWithNewMetrics) {
	ASSERT(SERVER_KNOBS->SHARD_ENCODE_LOCATION_METADATA);
	ASSERT(SERVER_KNOBS->ENABLE_DD_PHYSICAL_SHARD);
	updatePhysicalShardMetricsByKeyRange(keyRange, newMetrics, oldMetrics, initWithNewMetrics);
	if (requireTransitionCheck() &&
	    now() - lastTransitionStartTime > SERVER_KNOBS->ANONYMOUS_PHYSICAL_SHARD_TRANSITION_TIME) {
		if (isInAnonymousPhysicalShard(keyRange)) {
			// Currently, whenever a shard updates metrics, it checks whether is in AnonymousPhysicalShard
			// If yes, and if the shard has been created for long time, then triggers a data move on the shard.
			resetLastTransitionStartTime();
			TraceEvent("PhysicalShardTiggerTransitionMove")
			    .detail("KeyRange", keyRange)
			    .detail("TransitionCoolDownTime", SERVER_KNOBS->ANONYMOUS_PHYSICAL_SHARD_TRANSITION_TIME);
			return MoveKeyRangeOutPhysicalShard::True;
		}
	}
	if (isInOverSizePhysicalShard(keyRange)) {
		return MoveKeyRangeOutPhysicalShard::True;
	}
	return MoveKeyRangeOutPhysicalShard::False;
}

// The update of PhysicalShardToTeams, PhysicalShardInstances, KeyRangePhysicalShardIDMap should be atomic
void PhysicalShardCollection::cleanUpPhysicalShardCollection() {
	ASSERT(SERVER_KNOBS->SHARD_ENCODE_LOCATION_METADATA);
	ASSERT(SERVER_KNOBS->ENABLE_DD_PHYSICAL_SHARD);
	std::set<uint64_t> physicalShardsInUse;
	std::map<uint64_t, StorageMetrics> metricsReplies;
	KeyRangeMap<uint64_t>::Ranges keyRangePhysicalShardIDRanges = keyRangePhysicalShardIDMap.ranges();
	KeyRangeMap<uint64_t>::iterator it = keyRangePhysicalShardIDRanges.begin();
	// Assume that once a physical shard is disappear in keyRangePhysicalShardIDMap,
	// the physical shard (with the deleted id) should be deprecated.
	// This function aims at clean up those deprecated physical shards in PhysicalShardCollection
	// This function collects the physicalShard usage info from KeyRangePhysicalShardIDMap,
	// then based on the info to update PhysicalShardToTeams and PhysicalShardInstances

	// keyRangePhysicalShardIDMap indicates which physicalShard actually has data
	// Step 1: Clear unused physicalShard in physicalShardInstances based on keyRangePhysicalShardIDMap
	for (; it != keyRangePhysicalShardIDRanges.end(); ++it) {
		uint64_t physicalShardID = it->value();
		if (physicalShardID == anonymousShardId.first()) {
			continue;
		}
		physicalShardsInUse.insert(physicalShardID);
	}
	for (auto it = physicalShardInstances.begin(); it != physicalShardInstances.end();) {
		uint64_t physicalShardID = it->first;
		ASSERT(physicalShardInstances.contains(physicalShardID));
		if (!physicalShardsInUse.contains(physicalShardID)) {
			/*TraceEvent("PhysicalShardisEmpty")
			    .detail("PhysicalShard", physicalShardID)
			    .detail("RemainBytes", physicalShardInstances[physicalShardID].metrics.bytes);*/
			// "RemainBytes" indicates the deviation of current physical shard metric update
			it = physicalShardInstances.erase(it);
		} else {
			it++;
		}
	}
	// Step 2: Clean up teamPhysicalShardIDs
	std::set<ShardsAffectedByTeamFailure::Team> toRemoveTeams;
	for (auto [team, _] : teamPhysicalShardIDs) {
		for (auto it = teamPhysicalShardIDs[team].begin(); it != teamPhysicalShardIDs[team].end();) {
			uint64_t physicalShardID = *it;
			if (!physicalShardInstances.contains(physicalShardID)) {
				// physicalShardID has been removed from physicalShardInstances (see step 1)
				// So, remove the physicalShard from teamPhysicalShardID[team]
				it = teamPhysicalShardIDs[team].erase(it);
			} else {
				it++;
			}
		}
		if (teamPhysicalShardIDs[team].size() == 0) {
			// If a team has no physicalShard, remove the team from teamPhysicalShardID
			toRemoveTeams.insert(team);
		}
	}
	for (auto team : toRemoveTeams) {
		teamPhysicalShardIDs.erase(team);
	}
}

void PhysicalShardCollection::logPhysicalShardCollection() {
	ASSERT(SERVER_KNOBS->SHARD_ENCODE_LOCATION_METADATA);
	ASSERT(SERVER_KNOBS->ENABLE_DD_PHYSICAL_SHARD);
	// Step 1: Logging non-empty physicalShard
	for (auto [physicalShardID, physicalShard] : physicalShardInstances) {
		ASSERT(physicalShardID == physicalShard.id);
		TraceEvent e("PhysicalShardStatus");
		e.detail("PhysicalShardID", physicalShardID);
		e.detail("TotalBytes", physicalShard.metrics.bytes);
	}
	// Step 2: Logging TeamPhysicalShardStatus
	for (auto [team, physicalShardIDs] : teamPhysicalShardIDs) {
		TraceEvent e("TeamPhysicalShardStatus");
		e.detail("Team", team.toString());
		// std::string metricsStr = "";
		int64_t counter = 0;
		int64_t totalBytes = 0;
		int64_t maxPhysicalShardBytes = -1;
		int64_t minPhysicalShardBytes = StorageMetrics::infinity;
		uint64_t maxPhysicalShardID = 0;
		uint64_t minPhysicalShardID = 0;
		for (auto physicalShardID : physicalShardIDs) {
			ASSERT(physicalShardInstances.contains(physicalShardID));
			uint64_t id = physicalShardInstances[physicalShardID].id;
			int64_t bytes = physicalShardInstances[physicalShardID].metrics.bytes;
			if (bytes > maxPhysicalShardBytes) {
				maxPhysicalShardBytes = bytes;
				maxPhysicalShardID = id;
			}
			if (bytes < minPhysicalShardBytes) {
				minPhysicalShardBytes = bytes;
				minPhysicalShardID = id;
			}
			totalBytes = totalBytes + bytes;
			/* metricsStr = metricsStr + std::to_string(id) + ":" + std::to_string(bytes);
			if (counter < physicalShardIDs.size() - 1) {
			    metricsStr = metricsStr + ",";
			} */
			counter = counter + 1;
		}
		// e.detail("Metrics", metricsStr);
		e.detail("TotalBytes", totalBytes);
		e.detail("NumPhysicalShards", counter);
		e.detail("MaxPhysicalShard", std::to_string(maxPhysicalShardID) + ":" + std::to_string(maxPhysicalShardBytes));
		e.detail("MinPhysicalShard", std::to_string(minPhysicalShardID) + ":" + std::to_string(minPhysicalShardBytes));
	}
	// Step 3: Logging StorageServerPhysicalShardStatus
	std::map<UID, std::map<uint64_t, int64_t>> storageServerPhysicalShardStatus;
	for (auto [team, _] : teamPhysicalShardIDs) {
		for (auto ssid : team.servers) {
			for (auto it = teamPhysicalShardIDs[team].begin(); it != teamPhysicalShardIDs[team].end();) {
				uint64_t physicalShardID = *it;
				if (storageServerPhysicalShardStatus.contains(ssid)) {
					if (!storageServerPhysicalShardStatus[ssid].contains(physicalShardID)) {
						ASSERT(physicalShardInstances.contains(physicalShardID));
						storageServerPhysicalShardStatus[ssid].insert(
						    std::make_pair(physicalShardID, physicalShardInstances[physicalShardID].metrics.bytes));
					}
				} else {
					ASSERT(physicalShardInstances.contains(physicalShardID));
					std::map<uint64_t, int64_t> tmp;
					tmp.insert(std::make_pair(physicalShardID, physicalShardInstances[physicalShardID].metrics.bytes));
					storageServerPhysicalShardStatus.insert(std::make_pair(ssid, tmp));
				}
				it++;
			}
		}
	}
	for (auto [serverID, physicalShardMetrics] : storageServerPhysicalShardStatus) {
		TraceEvent e("ServerPhysicalShardStatus");
		e.detail("Server", serverID);
		e.detail("NumPhysicalShards", physicalShardMetrics.size());
		int64_t totalBytes = 0;
		int64_t maxPhysicalShardBytes = -1;
		int64_t minPhysicalShardBytes = StorageMetrics::infinity;
		uint64_t maxPhysicalShardID = 0;
		uint64_t minPhysicalShardID = 0;
		// std::string metricsStr = "";
		// int64_t counter = 0;
		for (auto [physicalShardID, bytes] : physicalShardMetrics) {
			totalBytes = totalBytes + bytes;
			if (bytes > maxPhysicalShardBytes) {
				maxPhysicalShardBytes = bytes;
				maxPhysicalShardID = physicalShardID;
			}
			if (bytes < minPhysicalShardBytes) {
				minPhysicalShardBytes = bytes;
				minPhysicalShardID = physicalShardID;
			}
			/* metricsStr = metricsStr + std::to_string(physicalShardID) + ":" + std::to_string(bytes);
			if (counter < physicalShardMetrics.size() - 1) {
			        metricsStr = metricsStr + ",";
			}
			counter = counter + 1; */
		}
		e.detail("TotalBytes", totalBytes);
		e.detail("MaxPhysicalShard", std::to_string(maxPhysicalShardID) + ":" + std::to_string(maxPhysicalShardBytes));
		e.detail("MinPhysicalShard", std::to_string(minPhysicalShardID) + ":" + std::to_string(minPhysicalShardBytes));
	}
}

bool PhysicalShardCollection::physicalShardExists(uint64_t physicalShardID) {
	return physicalShardInstances.find(physicalShardID) != physicalShardInstances.end();
}

// FIXME: complete this test with non-empty range
															#line 9597 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via flowTestCase2105()
															#line 2105 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
template <class FlowTestCase2105Actor>
															#line 2105 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class FlowTestCase2105ActorState {
															#line 9604 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
public:
															#line 2105 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	FlowTestCase2105ActorState(UnitTestParameters const& params) 
															#line 2105 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
															#line 2105 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		 : params(params),
															#line 2106 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   self(),
															#line 2107 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   ranges(),
															#line 2112 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   req(ranges, 3, 1000, 100000)
															#line 9617 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase2105", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase2105ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase2105", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2116 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = fetchTopKShardMetrics(&self, req);
															#line 2116 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (static_cast<FlowTestCase2105Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9634 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase2105Actor*>(this)->actor_wait_state = 1;
															#line 2116 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase2105Actor, 0, Void >*>(static_cast<FlowTestCase2105Actor*>(this)));
															#line 9639 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase2105ActorState();
		static_cast<FlowTestCase2105Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2117 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		auto& reply = req.reply.getFuture().get();
															#line 2118 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		ASSERT(reply.shardMetrics.empty());
															#line 2119 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		ASSERT(reply.maxReadLoad == -1);
															#line 2120 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		ASSERT(reply.minReadLoad == -1);
															#line 2122 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!static_cast<FlowTestCase2105Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase2105ActorState(); static_cast<FlowTestCase2105Actor*>(this)->destroy(); return 0; }
															#line 9670 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		new (&static_cast<FlowTestCase2105Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase2105ActorState();
		static_cast<FlowTestCase2105Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2117 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		auto& reply = req.reply.getFuture().get();
															#line 2118 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		ASSERT(reply.shardMetrics.empty());
															#line 2119 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		ASSERT(reply.maxReadLoad == -1);
															#line 2120 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		ASSERT(reply.minReadLoad == -1);
															#line 2122 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!static_cast<FlowTestCase2105Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase2105ActorState(); static_cast<FlowTestCase2105Actor*>(this)->destroy(); return 0; }
															#line 9690 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		new (&static_cast<FlowTestCase2105Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase2105ActorState();
		static_cast<FlowTestCase2105Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase2105Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase2105Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase2105Actor*>(this)->ActorCallback< FlowTestCase2105Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase2105Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase2105", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2105Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase2105", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase2105Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase2105", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2105Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase2105", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase2105Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase2105", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2105Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase2105", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2105 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	UnitTestParameters params;
															#line 2106 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	DataDistributionTracker self;
															#line 2107 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	std::vector<KeyRange> ranges;
															#line 2112 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	GetTopKMetricsRequest req;
															#line 9781 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase2105()
															#line 2105 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class FlowTestCase2105Actor final : public Actor<Void>, public ActorCallback< FlowTestCase2105Actor, 0, Void >, public FastAllocated<FlowTestCase2105Actor>, public FlowTestCase2105ActorState<FlowTestCase2105Actor> {
															#line 9786 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase2105Actor>::operator new;
	using FastAllocated<FlowTestCase2105Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13919276719388666368UL, 14856002344116145664UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase2105Actor, 0, Void >;
															#line 2105 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	FlowTestCase2105Actor(UnitTestParameters const& params) 
															#line 9803 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase2105ActorState<FlowTestCase2105Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase2105", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4874290787023720960UL, 14644608117156062720UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2105Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase2105");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase2105", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase2105Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2105 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
static Future<Void> flowTestCase2105( UnitTestParameters const& params ) {
															#line 2105 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	return Future<Void>(new FlowTestCase2105Actor(params));
															#line 9836 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase2105, "/DataDistributor/Tracker/FetchTopK")

#line 2124 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
