#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
/*
 * CommitProxyServer.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <algorithm>
#include <string_view>
#include <tuple>
#include <variant>

#include "fdbclient/AccumulativeChecksum.h"
#include "fdbclient/Atomic.h"
#include "fdbclient/BackupAgent.actor.h"
#include "fdbclient/BlobCipher.h"
#include "fdbclient/BuildIdempotencyIdMutations.h"
#include "fdbclient/CommitTransaction.h"
#include "fdbclient/DatabaseContext.h"
#include "fdbclient/FDBTypes.h"
#include "fdbclient/IdempotencyId.actor.h"
#include "fdbclient/Knobs.h"
#include "fdbclient/CommitProxyInterface.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/SystemData.h"
#include "fdbclient/Tracing.h"
#include "fdbclient/TransactionLineage.h"
#include "fdbrpc/sim_validation.h"
#include "fdbserver/AccumulativeChecksumUtil.h"
#include "fdbserver/ApplyMetadataMutation.h"
#include "fdbserver/ConflictSet.h"
#include "fdbserver/DataDistributorInterface.h"
#include "fdbserver/FDBExecHelper.actor.h"
#include "fdbclient/GetEncryptCipherKeys.h"
#include "fdbserver/IKeyValueStore.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/LogSystem.h"
#include "fdbserver/LogSystemDiskQueueAdapter.h"
#include "fdbserver/MasterInterface.h"
#include "fdbserver/MutationTracking.h"
#include "fdbserver/ProxyCommitData.actor.h"
#include "fdbserver/RatekeeperInterface.h"
#include "fdbserver/RecoveryState.h"
#include "fdbserver/RestoreUtil.h"
#include "fdbserver/ServerDBInfo.actor.h"
#include "fdbserver/WaitFailure.h"
#include "fdbserver/WorkerInterface.actor.h"
#include "flow/ActorCollection.h"
#include "flow/CodeProbe.h"
#include "flow/EncryptUtils.h"
#include "flow/Error.h"
#include "flow/IRandom.h"
#include "flow/Knobs.h"
#include "flow/Trace.h"
#include "flow/network.h"

#include "flow/actorcompiler.h" // This must be the last #include.

using WriteMutationRefVar = std::variant<MutationRef, VectorRef<MutationRef>>;

															#line 76 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via broadcastTxnRequest()
															#line 74 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class BroadcastTxnRequestActor>
															#line 74 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class BroadcastTxnRequestActorState {
															#line 83 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 74 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	BroadcastTxnRequestActorState(TxnStateRequest const& req,int const& sendAmount,bool const& sendReply) 
															#line 74 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 74 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : req(req),
															#line 74 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   sendAmount(sendAmount),
															#line 74 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   sendReply(sendReply),
															#line 75 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   reply(req.reply)
															#line 96 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("broadcastTxnRequest", reinterpret_cast<unsigned long>(this));

	}
	~BroadcastTxnRequestActorState() 
	{
		fdb_probe_actor_destroy("broadcastTxnRequest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 76 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			resetReply(req);
															#line 77 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			std::vector<Future<Void>> replies;
															#line 78 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			int currentStream = 0;
															#line 79 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			std::vector<Endpoint> broadcastEndpoints = req.broadcastInfo;
															#line 80 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for(int i = 0;i < sendAmount && currentStream < broadcastEndpoints.size();i++) {
															#line 81 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				std::vector<Endpoint> endpoints;
															#line 82 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				RequestStream<TxnStateRequest> cur(broadcastEndpoints[currentStream++]);
															#line 83 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				for(;currentStream < broadcastEndpoints.size() * (i + 1) / sendAmount;) {
															#line 84 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					endpoints.push_back(broadcastEndpoints[currentStream++]);
															#line 127 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				}
															#line 86 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				req.broadcastInfo = endpoints;
															#line 87 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				replies.push_back(brokenPromiseToNever(cur.getReply(req)));
															#line 88 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				resetReply(req);
															#line 135 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 90 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(replies);
															#line 90 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<BroadcastTxnRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 141 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<BroadcastTxnRequestActor*>(this)->actor_wait_state = 1;
															#line 90 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BroadcastTxnRequestActor, 0, Void >*>(static_cast<BroadcastTxnRequestActor*>(this)));
															#line 146 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BroadcastTxnRequestActorState();
		static_cast<BroadcastTxnRequestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 91 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (sendReply)
															#line 169 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 92 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			reply.send(Void());
															#line 173 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 94 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<BroadcastTxnRequestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BroadcastTxnRequestActorState(); static_cast<BroadcastTxnRequestActor*>(this)->destroy(); return 0; }
															#line 177 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<BroadcastTxnRequestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~BroadcastTxnRequestActorState();
		static_cast<BroadcastTxnRequestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 91 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (sendReply)
															#line 189 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 92 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			reply.send(Void());
															#line 193 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 94 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<BroadcastTxnRequestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BroadcastTxnRequestActorState(); static_cast<BroadcastTxnRequestActor*>(this)->destroy(); return 0; }
															#line 197 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<BroadcastTxnRequestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~BroadcastTxnRequestActorState();
		static_cast<BroadcastTxnRequestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BroadcastTxnRequestActor*>(this)->actor_wait_state > 0) static_cast<BroadcastTxnRequestActor*>(this)->actor_wait_state = 0;
		static_cast<BroadcastTxnRequestActor*>(this)->ActorCallback< BroadcastTxnRequestActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BroadcastTxnRequestActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("broadcastTxnRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BroadcastTxnRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("broadcastTxnRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BroadcastTxnRequestActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("broadcastTxnRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BroadcastTxnRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("broadcastTxnRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BroadcastTxnRequestActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("broadcastTxnRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BroadcastTxnRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("broadcastTxnRequest", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 74 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	TxnStateRequest req;
															#line 74 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	int sendAmount;
															#line 74 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	bool sendReply;
															#line 75 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ReplyPromise<Void> reply;
															#line 288 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via broadcastTxnRequest()
															#line 74 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class BroadcastTxnRequestActor final : public Actor<Void>, public ActorCallback< BroadcastTxnRequestActor, 0, Void >, public FastAllocated<BroadcastTxnRequestActor>, public BroadcastTxnRequestActorState<BroadcastTxnRequestActor> {
															#line 293 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<BroadcastTxnRequestActor>::operator new;
	using FastAllocated<BroadcastTxnRequestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9659517095642708992UL, 8995544354040204544UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BroadcastTxnRequestActor, 0, Void >;
															#line 74 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	BroadcastTxnRequestActor(TxnStateRequest const& req,int const& sendAmount,bool const& sendReply) 
															#line 310 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   BroadcastTxnRequestActorState<BroadcastTxnRequestActor>(req, sendAmount, sendReply),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("broadcastTxnRequest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18432169453488638208UL, 15272042735295047168UL);
		ActorExecutionContextHelper __helper(static_cast<BroadcastTxnRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("broadcastTxnRequest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("broadcastTxnRequest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BroadcastTxnRequestActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 74 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> broadcastTxnRequest( TxnStateRequest const& req, int const& sendAmount, bool const& sendReply ) {
															#line 74 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new BroadcastTxnRequestActor(req, sendAmount, sendReply));
															#line 343 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 96 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

															#line 348 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via discardCommit()
															#line 97 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class DiscardCommitActor>
															#line 97 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class DiscardCommitActorState {
															#line 355 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 97 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	DiscardCommitActorState(UID const& id,Future<LogSystemDiskQueueAdapter::CommitMessage> const& fcm,Future<Void> const& dummyCommitState) 
															#line 97 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 97 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : id(id),
															#line 97 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   fcm(fcm),
															#line 97 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   dummyCommitState(dummyCommitState)
															#line 366 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("discardCommit", reinterpret_cast<unsigned long>(this));

	}
	~DiscardCommitActorState() 
	{
		fdb_probe_actor_destroy("discardCommit", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 98 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT(!dummyCommitState.isReady());
															#line 99 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<LogSystemDiskQueueAdapter::CommitMessage> __when_expr_0 = fcm;
															#line 99 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 385 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			static_cast<DiscardCommitActor*>(this)->actor_wait_state = 1;
															#line 99 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DiscardCommitActor, 0, LogSystemDiskQueueAdapter::CommitMessage >*>(static_cast<DiscardCommitActor*>(this)));
															#line 389 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<DiscardCommitActor*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(LogSystemDiskQueueAdapter::CommitMessage const& cm,int loopDepth) 
	{
															#line 100 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		TraceEvent("Discarding", id).detail("Count", cm.messages.size());
															#line 101 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		cm.acknowledge.send(Void());
															#line 102 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT(dummyCommitState.isReady());
															#line 415 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(LogSystemDiskQueueAdapter::CommitMessage && cm,int loopDepth) 
	{
															#line 100 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		TraceEvent("Discarding", id).detail("Count", cm.messages.size());
															#line 101 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		cm.acknowledge.send(Void());
															#line 102 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT(dummyCommitState.isReady());
															#line 428 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(LogSystemDiskQueueAdapter::CommitMessage const& cm,int loopDepth) 
	{
		loopDepth = a_body1cont1(cm, loopDepth);

		return loopDepth;
	}
	int a_body1when1(LogSystemDiskQueueAdapter::CommitMessage && cm,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(cm), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DiscardCommitActor*>(this)->actor_wait_state > 0) static_cast<DiscardCommitActor*>(this)->actor_wait_state = 0;
		static_cast<DiscardCommitActor*>(this)->ActorCallback< DiscardCommitActor, 0, LogSystemDiskQueueAdapter::CommitMessage >::remove();

	}
	void a_callback_fire(ActorCallback< DiscardCommitActor, 0, LogSystemDiskQueueAdapter::CommitMessage >*,LogSystemDiskQueueAdapter::CommitMessage const& value) 
	{
		fdb_probe_actor_enter("discardCommit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DiscardCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("discardCommit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DiscardCommitActor, 0, LogSystemDiskQueueAdapter::CommitMessage >*,LogSystemDiskQueueAdapter::CommitMessage && value) 
	{
		fdb_probe_actor_enter("discardCommit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DiscardCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("discardCommit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DiscardCommitActor, 0, LogSystemDiskQueueAdapter::CommitMessage >*,Error err) 
	{
		fdb_probe_actor_enter("discardCommit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DiscardCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("discardCommit", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 97 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		delete static_cast<DiscardCommitActor*>(this);
															#line 512 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		return 0;

		return loopDepth;
	}
															#line 97 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	UID id;
															#line 97 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Future<LogSystemDiskQueueAdapter::CommitMessage> fcm;
															#line 97 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Future<Void> dummyCommitState;
															#line 523 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via discardCommit()
															#line 97 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class DiscardCommitActor final : public Actor<void>, public ActorCallback< DiscardCommitActor, 0, LogSystemDiskQueueAdapter::CommitMessage >, public FastAllocated<DiscardCommitActor>, public DiscardCommitActorState<DiscardCommitActor> {
															#line 528 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<DiscardCommitActor>::operator new;
	using FastAllocated<DiscardCommitActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18306673891578981632UL, 5584458805210473728UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() {{
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<void>*>(this)->~Actor();
        operator delete(this);
    }}
#pragma clang diagnostic pop
friend struct ActorCallback< DiscardCommitActor, 0, LogSystemDiskQueueAdapter::CommitMessage >;
															#line 97 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	DiscardCommitActor(UID const& id,Future<LogSystemDiskQueueAdapter::CommitMessage> const& fcm,Future<Void> const& dummyCommitState) 
															#line 545 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<void>(),
		   DiscardCommitActorState<DiscardCommitActor>(id, fcm, dummyCommitState),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("discardCommit", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7339418273539287808UL, 9304446022786112512UL);
		ActorExecutionContextHelper __helper(static_cast<DiscardCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("discardCommit");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("discardCommit", reinterpret_cast<unsigned long>(this), -1);

	}
};
} // namespace
															#line 97 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
void discardCommit( UID const& id, Future<LogSystemDiskQueueAdapter::CommitMessage> const& fcm, Future<Void> const& dummyCommitState ) {
															#line 97 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	new DiscardCommitActor(id, fcm, dummyCommitState);
															#line 569 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 104 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

struct ResolutionRequestBuilder {
	const ProxyCommitData* self;

	// One request per resolver.
	std::vector<ResolveTransactionBatchRequest> requests;

	// Txn i to resolvers that have i'th data sent
	std::vector<std::vector<int>> transactionResolverMap;
	std::vector<CommitTransactionRef*> outTr;

	// Used to report conflicting keys, the format is
	// [CommitTransactionRef_Index][Resolver_Index][Read_Conflict_Range_Index_on_Resolver]
	// -> read_conflict_range's original index in the commitTransactionRef
	std::vector<std::vector<std::vector<int>>> txReadConflictRangeIndexMap;

	ResolutionRequestBuilder(ProxyCommitData* self,
	                         Version version,
	                         Version prevVersion,
	                         Version lastReceivedVersion,
	                         Version lastShardMove,
	                         Span& parentSpan)
	  : self(self), requests(self->resolvers.size()) {
		for (auto& req : requests) {
			req.spanContext = parentSpan.context;
			req.prevVersion = prevVersion;
			req.version = version;
			req.lastReceivedVersion = lastReceivedVersion;
			req.lastShardMove = lastShardMove;
		}
	}

	CommitTransactionRef& getOutTransaction(int resolver, Version read_snapshot) {
		CommitTransactionRef*& out = outTr[resolver];
		if (!out) {
			ResolveTransactionBatchRequest& request = requests[resolver];
			request.transactions.resize(request.arena, request.transactions.size() + 1);
			out = &request.transactions.back();
			out->read_snapshot = read_snapshot;
		}
		return *out;
	}

	// Returns a read conflict index map: [resolver_index][read_conflict_range_index_on_the_resolver]
	// -> read_conflict_range's original index
	std::vector<std::vector<int>> addReadConflictRanges(CommitTransactionRef& trIn) {
		std::vector<std::vector<int>> rCRIndexMap(requests.size());
		for (int idx = 0; idx < trIn.read_conflict_ranges.size(); ++idx) {
			const auto& r = trIn.read_conflict_ranges[idx];
			auto ranges = self->keyResolvers.intersectingRanges(r);
			std::vector<int> resolvers;
			resolvers.reserve(self->resolvers.size());
			// O(1) de-dup keyed by resolver id (deterministic)
			std::vector<unsigned char> seen(self->resolvers.size(), 0);
			for (auto& ir : ranges) {
				auto& version_resolver = ir.value();
				for (int i = version_resolver.size() - 1; i >= 0; i--) {
					const int resolver_id = version_resolver[i].second;
					if (!seen[resolver_id]) {
						seen[resolver_id] = 1;
						resolvers.push_back(resolver_id);
					}
					if (version_resolver[i].first < trIn.read_snapshot)
						break;
				}
			}
			if (SERVER_KNOBS->PROXY_USE_RESOLVER_PRIVATE_MUTATIONS && systemKeys.intersects(r)) {
				// All resolvers are eligible; skip per-id de-dup and just fill 0..N-1.
				resolvers.clear();
				for (int k = 0; k < self->resolvers.size(); ++k) {
					resolvers.push_back(k);
				}
			}
			ASSERT(resolvers.size());
			for (int resolver : resolvers) {
				getOutTransaction(resolver, trIn.read_snapshot)
				    .read_conflict_ranges.push_back(requests[resolver].arena, r);
				rCRIndexMap[resolver].push_back(idx);
			}
		}
		return rCRIndexMap;
	}

	void addWriteConflictRanges(CommitTransactionRef& trIn) {
		for (auto& r : trIn.write_conflict_ranges) {
			auto ranges = self->keyResolvers.intersectingRanges(r);
			std::vector<int> resolvers;
			resolvers.reserve(self->resolvers.size());
			std::vector<unsigned char> seen(self->resolvers.size(), 0);
			for (auto& ir : ranges) {
				auto& version_resolver = ir.value();
				if (!version_resolver.empty()) {
					const int resolver_id = version_resolver.back().second;
					if (!seen[resolver_id]) {
						seen[resolver_id] = 1;
						resolvers.push_back(resolver_id);
					}
				}
			}
			if (SERVER_KNOBS->PROXY_USE_RESOLVER_PRIVATE_MUTATIONS && systemKeys.intersects(r)) {
				// All resolvers are eligible.
				resolvers.clear();
				for (int k = 0; k < self->resolvers.size(); ++k) {
					resolvers.push_back(k);
				}
			}
			ASSERT(resolvers.size());
			for (int resolver : resolvers)
				getOutTransaction(resolver, trIn.read_snapshot)
				    .write_conflict_ranges.push_back(requests[resolver].arena, r);
		}
	}

	void addTransaction(CommitTransactionRequest& trRequest, Version ver, int transactionNumberInBatch) {
		auto& trIn = trRequest.transaction;
		// SOMEDAY: There are a couple of unnecessary O( # resolvers ) steps here
		outTr.assign(requests.size(), nullptr);
		ASSERT(transactionNumberInBatch >= 0 && transactionNumberInBatch < 32768);

		bool isTXNStateTransaction = false;
		for (auto& m : trIn.mutations) {
			DEBUG_MUTATION("AddTr", ver, m, self->dbgid).detail("Idx", transactionNumberInBatch);
			if (m.type == MutationRef::SetVersionstampedKey) {
				transformVersionstampMutation(m, &MutationRef::param1, requests[0].version, transactionNumberInBatch);
				trIn.write_conflict_ranges.push_back(requests[0].arena, singleKeyRange(m.param1, requests[0].arena));
			} else if (m.type == MutationRef::SetVersionstampedValue) {
				transformVersionstampMutation(m, &MutationRef::param2, requests[0].version, transactionNumberInBatch);
			}
			if (isMetadataMutation(m)) {
				isTXNStateTransaction = true;
				auto& tr = getOutTransaction(0, trIn.read_snapshot);
				tr.mutations.push_back(requests[0].arena, m);
				tr.lock_aware = trRequest.isLockAware();
			}
		}
		if (isTXNStateTransaction && !trRequest.isLockAware()) {
			// This mitigates https://github.com/apple/foundationdb/issues/3647. Since this transaction is not lock
			// aware, if this transaction got a read version then \xff/dbLocked must not have been set at this
			// transaction's read snapshot. If that changes by commit time, then it won't commit on any proxy because of
			// a conflict. A client could set a read version manually so this isn't totally bulletproof.
			trIn.read_conflict_ranges.push_back(trRequest.arena, KeyRangeRef(databaseLockedKey, databaseLockedKeyEnd));
		}

		std::vector<std::vector<int>> rCRIndexMap = addReadConflictRanges(trIn);
		txReadConflictRangeIndexMap.push_back(std::move(rCRIndexMap));

		addWriteConflictRanges(trIn);

		if (isTXNStateTransaction) {
			for (int r = 0; r < requests.size(); r++) {
				int transactionNumberInRequest =
				    &getOutTransaction(r, trIn.read_snapshot) - requests[r].transactions.begin();
				requests[r].txnStateTransactions.push_back(requests[r].arena, transactionNumberInRequest);
			}
			// Note only Resolver 0 got the correct spanContext, which means
			// the reply from Resolver 0 has the right one back.
			auto& tr = getOutTransaction(0, trIn.read_snapshot);
			tr.spanContext = trRequest.spanContext;
		}

		std::vector<int> resolversUsed;
		for (int r = 0; r < outTr.size(); r++)
			if (outTr[r]) {
				resolversUsed.push_back(r);
				outTr[r]->report_conflicting_keys = trIn.report_conflicting_keys;
			}
		transactionResolverMap.emplace_back(std::move(resolversUsed));
	}
};

															#line 743 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via commitBatcher()
															#line 274 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class CommitBatcherActor>
															#line 274 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class CommitBatcherActorState {
															#line 750 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 274 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitBatcherActorState(ProxyCommitData* const& commitData,PromiseStream<std::pair<std::vector<CommitTransactionRequest>, int>> const& out,FutureStream<CommitTransactionRequest> const& in,int const& desiredBytes,int64_t const& memBytesLimit) 
															#line 274 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 274 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : commitData(commitData),
															#line 274 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   out(out),
															#line 274 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   in(in),
															#line 274 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   desiredBytes(desiredBytes),
															#line 274 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   memBytesLimit(memBytesLimit)
															#line 765 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("commitBatcher", reinterpret_cast<unsigned long>(this));

	}
	~CommitBatcherActorState() 
	{
		fdb_probe_actor_destroy("commitBatcher", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 279 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delayJittered(commitData->commitBatchInterval, TaskPriority::ProxyCommitBatcher);
															#line 279 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<CommitBatcherActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 782 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CommitBatcherActor*>(this)->actor_wait_state = 1;
															#line 279 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CommitBatcherActor, 0, Void >*>(static_cast<CommitBatcherActor*>(this)));
															#line 787 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CommitBatcherActorState();
		static_cast<CommitBatcherActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 281 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		lastBatch = 0;
															#line 283 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		;
															#line 812 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 281 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		lastBatch = 0;
															#line 283 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		;
															#line 823 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CommitBatcherActor*>(this)->actor_wait_state > 0) static_cast<CommitBatcherActor*>(this)->actor_wait_state = 0;
		static_cast<CommitBatcherActor*>(this)->ActorCallback< CommitBatcherActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CommitBatcherActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("commitBatcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CommitBatcherActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("commitBatcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CommitBatcherActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("commitBatcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatcher", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 284 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		timeout = Future<Void>();
															#line 285 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		batch = std::vector<CommitTransactionRequest>();
															#line 286 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		batchBytes = 0;
															#line 290 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (SERVER_KNOBS->MAX_COMMIT_BATCH_INTERVAL <= 0)
															#line 920 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 291 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			timeout = Never();
															#line 924 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		else
		{
															#line 293 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			timeout = delayJittered(SERVER_KNOBS->MAX_COMMIT_BATCH_INTERVAL, TaskPriority::ProxyCommitBatcher);
															#line 930 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 296 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		;
															#line 934 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 364 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		commitData->triggerCommit.set(false);
															#line 365 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		out.send({ std::move(batch), batchBytes });
															#line 366 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		lastBatch = now();
															#line 947 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1(int loopDepth) 
	{
															#line 296 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!(!timeout.isReady() && !(batch.size() == SERVER_KNOBS->COMMIT_TRANSACTION_BATCH_COUNT_MAX || batchBytes >= desiredBytes)))
															#line 963 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 299 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		auto __when_expr_1 = in;
															#line 969 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_1), FutureStream<CommitTransactionRequest>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<CommitTransactionRequest>>::value, "invalid type");
															#line 298 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<CommitBatcherActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 973 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1loopBody1when1(__when_expr_1.pop(), loopDepth); };
															#line 352 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_2 = timeout;
															#line 977 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1loopBody1when2(__when_expr_2.get(), loopDepth); };
															#line 353 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_3 = commitData->triggerCommit.onChange();
															#line 981 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1loopBody1when3(__when_expr_3.get(), loopDepth); };
		static_cast<CommitBatcherActor*>(this)->actor_wait_state = 2;
															#line 299 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< CommitBatcherActor, 1, CommitTransactionRequest >*>(static_cast<CommitBatcherActor*>(this)));
															#line 352 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CommitBatcherActor, 2, Void >*>(static_cast<CommitBatcherActor*>(this)));
															#line 353 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CommitBatcherActor, 3, Void >*>(static_cast<CommitBatcherActor*>(this)));
															#line 990 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(CommitTransactionRequest const& req,int loopDepth) 
	{
															#line 301 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		int bytes = getBytes(req);
															#line 304 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (commitData->commitBatchesMemBytesCount + bytes > memBytesLimit)
															#line 1020 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 305 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			++commitData->stats.txnCommitErrors;
															#line 306 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.reply.sendError(commit_proxy_memory_limit_exceeded());
															#line 307 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent(SevWarnAlways, "ProxyCommitBatchMemoryThresholdExceeded") .suppressFor(60) .detail("MemBytesCount", commitData->commitBatchesMemBytesCount) .detail("MemLimit", memBytesLimit);
															#line 1028 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			return a_body1cont1loopBody1loopHead1(loopDepth); // continue
		}
															#line 314 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (bytes > FLOW_KNOBS->PACKET_WARNING)
															#line 1033 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 315 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent(SevWarn, "LargeTransaction") .suppressFor(1.0) .detail("Size", bytes) .detail("Client", req.reply.getEndpoint().getPrimaryAddress());
															#line 1037 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 321 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		++commitData->stats.txnCommitIn;
															#line 322 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		commitData->stats.uniqueClients.insert(req.reply.getEndpoint().getPrimaryAddress());
															#line 324 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (req.debugID.present())
															#line 1045 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 325 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			g_traceBatch.addEvent("CommitDebug", req.debugID.get().first(), "CommitProxyServer.batcher");
															#line 1049 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 328 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!batch.size())
															#line 1053 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 329 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (now() - lastBatch > commitData->commitBatchInterval)
															#line 1057 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 330 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				timeout = delayJittered(SERVER_KNOBS->COMMIT_TRANSACTION_BATCH_INTERVAL_FROM_IDLE, TaskPriority::ProxyCommitBatcher);
															#line 1061 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
			else
			{
															#line 333 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				timeout = delayJittered(commitData->commitBatchInterval - (now() - lastBatch), TaskPriority::ProxyCommitBatcher);
															#line 1067 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
		}
															#line 338 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if ((batchBytes + bytes > CLIENT_KNOBS->TRANSACTION_SIZE_LIMIT || req.firstInBatch()) && batch.size())
															#line 1072 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 340 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			commitData->triggerCommit.set(false);
															#line 341 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			out.send({ std::move(batch), batchBytes });
															#line 342 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			lastBatch = now();
															#line 343 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			timeout = delayJittered(commitData->commitBatchInterval, TaskPriority::ProxyCommitBatcher);
															#line 344 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			batch.clear();
															#line 345 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			batchBytes = 0;
															#line 1086 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 348 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		batch.push_back(req);
															#line 349 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		batchBytes += bytes;
															#line 350 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		commitData->commitBatchesMemBytesCount += bytes;
															#line 1094 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(CommitTransactionRequest && req,int loopDepth) 
	{
															#line 301 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		int bytes = getBytes(req);
															#line 304 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (commitData->commitBatchesMemBytesCount + bytes > memBytesLimit)
															#line 1105 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 305 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			++commitData->stats.txnCommitErrors;
															#line 306 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.reply.sendError(commit_proxy_memory_limit_exceeded());
															#line 307 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent(SevWarnAlways, "ProxyCommitBatchMemoryThresholdExceeded") .suppressFor(60) .detail("MemBytesCount", commitData->commitBatchesMemBytesCount) .detail("MemLimit", memBytesLimit);
															#line 1113 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			return a_body1cont1loopBody1loopHead1(loopDepth); // continue
		}
															#line 314 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (bytes > FLOW_KNOBS->PACKET_WARNING)
															#line 1118 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 315 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent(SevWarn, "LargeTransaction") .suppressFor(1.0) .detail("Size", bytes) .detail("Client", req.reply.getEndpoint().getPrimaryAddress());
															#line 1122 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 321 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		++commitData->stats.txnCommitIn;
															#line 322 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		commitData->stats.uniqueClients.insert(req.reply.getEndpoint().getPrimaryAddress());
															#line 324 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (req.debugID.present())
															#line 1130 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 325 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			g_traceBatch.addEvent("CommitDebug", req.debugID.get().first(), "CommitProxyServer.batcher");
															#line 1134 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 328 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!batch.size())
															#line 1138 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 329 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (now() - lastBatch > commitData->commitBatchInterval)
															#line 1142 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 330 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				timeout = delayJittered(SERVER_KNOBS->COMMIT_TRANSACTION_BATCH_INTERVAL_FROM_IDLE, TaskPriority::ProxyCommitBatcher);
															#line 1146 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
			else
			{
															#line 333 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				timeout = delayJittered(commitData->commitBatchInterval - (now() - lastBatch), TaskPriority::ProxyCommitBatcher);
															#line 1152 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
		}
															#line 338 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if ((batchBytes + bytes > CLIENT_KNOBS->TRANSACTION_SIZE_LIMIT || req.firstInBatch()) && batch.size())
															#line 1157 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 340 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			commitData->triggerCommit.set(false);
															#line 341 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			out.send({ std::move(batch), batchBytes });
															#line 342 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			lastBatch = now();
															#line 343 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			timeout = delayJittered(commitData->commitBatchInterval, TaskPriority::ProxyCommitBatcher);
															#line 344 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			batch.clear();
															#line 345 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			batchBytes = 0;
															#line 1171 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 348 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		batch.push_back(req);
															#line 349 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		batchBytes += bytes;
															#line 350 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		commitData->commitBatchesMemBytesCount += bytes;
															#line 1179 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when3(Void const& _,int loopDepth) 
	{
															#line 354 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT(commitData->triggerCommit.get());
															#line 355 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		double commitTime = lastBatch + SERVER_KNOBS->COMMIT_TRIGGER_DELAY;
															#line 356 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (now() > commitTime)
															#line 1204 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 360 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		timeout = timeout || delayJittered(commitTime - now(), TaskPriority::ProxyCommitBatcher);
															#line 1210 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when3(Void && _,int loopDepth) 
	{
															#line 354 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT(commitData->triggerCommit.get());
															#line 355 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		double commitTime = lastBatch + SERVER_KNOBS->COMMIT_TRIGGER_DELAY;
															#line 356 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (now() > commitTime)
															#line 1223 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 360 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		timeout = timeout || delayJittered(commitTime - now(), TaskPriority::ProxyCommitBatcher);
															#line 1229 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CommitBatcherActor*>(this)->actor_wait_state > 0) static_cast<CommitBatcherActor*>(this)->actor_wait_state = 0;
		static_cast<CommitBatcherActor*>(this)->ActorSingleCallback< CommitBatcherActor, 1, CommitTransactionRequest >::remove();
		static_cast<CommitBatcherActor*>(this)->ActorCallback< CommitBatcherActor, 2, Void >::remove();
		static_cast<CommitBatcherActor*>(this)->ActorCallback< CommitBatcherActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorSingleCallback< CommitBatcherActor, 1, CommitTransactionRequest >*,CommitTransactionRequest const& value) 
	{
		fdb_probe_actor_enter("commitBatcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< CommitBatcherActor, 1, CommitTransactionRequest >*,CommitTransactionRequest && value) 
	{
		fdb_probe_actor_enter("commitBatcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< CommitBatcherActor, 1, CommitTransactionRequest >*,Error err) 
	{
		fdb_probe_actor_enter("commitBatcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CommitBatcherActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("commitBatcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatcher", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CommitBatcherActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("commitBatcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatcher", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CommitBatcherActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("commitBatcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatcher", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CommitBatcherActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("commitBatcher", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatcher", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CommitBatcherActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("commitBatcher", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatcher", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CommitBatcherActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("commitBatcher", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatcher", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 274 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCommitData* commitData;
															#line 274 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	PromiseStream<std::pair<std::vector<CommitTransactionRequest>, int>> out;
															#line 274 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	FutureStream<CommitTransactionRequest> in;
															#line 274 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	int desiredBytes;
															#line 274 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	int64_t memBytesLimit;
															#line 281 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	double lastBatch;
															#line 284 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Future<Void> timeout;
															#line 285 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	std::vector<CommitTransactionRequest> batch;
															#line 286 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	int batchBytes;
															#line 1431 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via commitBatcher()
															#line 274 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class CommitBatcherActor final : public Actor<Void>, public ActorCallback< CommitBatcherActor, 0, Void >, public ActorSingleCallback< CommitBatcherActor, 1, CommitTransactionRequest >, public ActorCallback< CommitBatcherActor, 2, Void >, public ActorCallback< CommitBatcherActor, 3, Void >, public FastAllocated<CommitBatcherActor>, public CommitBatcherActorState<CommitBatcherActor> {
															#line 1436 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<CommitBatcherActor>::operator new;
	using FastAllocated<CommitBatcherActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1750970733805895936UL, 3646477567261339904UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CommitBatcherActor, 0, Void >;
friend struct ActorSingleCallback< CommitBatcherActor, 1, CommitTransactionRequest >;
friend struct ActorCallback< CommitBatcherActor, 2, Void >;
friend struct ActorCallback< CommitBatcherActor, 3, Void >;
															#line 274 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitBatcherActor(ProxyCommitData* const& commitData,PromiseStream<std::pair<std::vector<CommitTransactionRequest>, int>> const& out,FutureStream<CommitTransactionRequest> const& in,int const& desiredBytes,int64_t const& memBytesLimit) 
															#line 1456 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   CommitBatcherActorState<CommitBatcherActor>(commitData, out, in, desiredBytes, memBytesLimit),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("commitBatcher", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16706688995745022464UL, 16424952413577766656UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("commitBatcher");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("commitBatcher", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CommitBatcherActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorSingleCallback< CommitBatcherActor, 1, CommitTransactionRequest >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 274 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> commitBatcher( ProxyCommitData* const& commitData, PromiseStream<std::pair<std::vector<CommitTransactionRequest>, int>> const& out, FutureStream<CommitTransactionRequest> const& in, int const& desiredBytes, int64_t const& memBytesLimit ) {
															#line 274 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new CommitBatcherActor(commitData, out, in, desiredBytes, memBytesLimit));
															#line 1490 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 369 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

void createWhitelistBinPathVec(const std::string& binPath, std::vector<Standalone<StringRef>>& binPathVec) {
	TraceEvent(SevDebug, "BinPathConverter").detail("Input", binPath);
	StringRef input(binPath);
	while (input != StringRef()) {
		StringRef token = input.eat(","_sr);
		if (token != StringRef()) {
			const uint8_t* ptr = token.begin();
			while (ptr != token.end() && *ptr == ' ') {
				ptr++;
			}
			if (ptr != token.end()) {
				Standalone<StringRef> newElement(token.substr(ptr - token.begin()));
				TraceEvent(SevDebug, "BinPathItem").detail("Element", newElement);
				binPathVec.push_back(newElement);
			}
		}
	}
	return;
}

bool isWhitelisted(const std::vector<Standalone<StringRef>>& binPathVec, StringRef binPath) {
	TraceEvent("BinPath").detail("Value", binPath);
	for (const auto& item : binPathVec) {
		TraceEvent("Element").detail("Value", item);
	}
	return std::find(binPathVec.begin(), binPathVec.end(), binPath) != binPathVec.end();
}

															#line 1523 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via addBackupMutations()
															#line 398 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class AddBackupMutationsActor>
															#line 398 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class AddBackupMutationsActorState {
															#line 1530 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 398 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	AddBackupMutationsActorState(ProxyCommitData* const& self,const std::map<Key, MutationListRef>* const& logRangeMutations,LogPushData* const& toCommit,Version const& commitVersion,double* const& computeDuration,double* const& computeStart) 
															#line 398 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 398 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : self(self),
															#line 398 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   logRangeMutations(logRangeMutations),
															#line 398 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   toCommit(toCommit),
															#line 398 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   commitVersion(commitVersion),
															#line 398 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   computeDuration(computeDuration),
															#line 398 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   computeStart(computeStart),
															#line 404 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   logRangeMutation(logRangeMutations->cbegin()),
															#line 405 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   version(commitVersion / CLIENT_KNOBS->LOG_RANGE_BLOCK_SIZE),
															#line 406 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   yieldBytes(0),
															#line 407 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   valueWriter(Unversioned())
															#line 1555 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("addBackupMutations", reinterpret_cast<unsigned long>(this));

	}
	~AddBackupMutationsActorState() 
	{
		fdb_probe_actor_destroy("addBackupMutations", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 409 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			toCommit->addTransactionInfo(SpanContext());
															#line 412 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			;
															#line 1572 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AddBackupMutationsActorState();
		static_cast<AddBackupMutationsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 483 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<AddBackupMutationsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AddBackupMutationsActorState(); static_cast<AddBackupMutationsActor*>(this)->destroy(); return 0; }
															#line 1595 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<AddBackupMutationsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~AddBackupMutationsActorState();
		static_cast<AddBackupMutationsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 412 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!(logRangeMutation != logRangeMutations->cend()))
															#line 1614 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 415 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		valueWriter = BinaryWriter(IncludeVersion(ProtocolVersion::withBackupMutations()));
															#line 416 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		valueWriter << logRangeMutation->second.totalSize();
															#line 418 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		blobIter = logRangeMutation->second.blob_begin;
															#line 419 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		;
															#line 1626 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 433 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		Key val = valueWriter.toValue();
															#line 435 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		BinaryWriter wr(Unversioned());
															#line 438 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		wr.serializeBytes(logRangeMutation->first);
															#line 441 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		wr << (uint8_t)hashlittle(&version, sizeof(version), 0);
															#line 442 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		wr << bigEndian64(commitVersion);
															#line 444 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		uint32_t* partBuffer = nullptr;
															#line 446 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for(int part = 0;part * CLIENT_KNOBS->MUTATION_BLOCK_SIZE < val.size();part++) {
															#line 448 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			MutationRef backupMutation;
															#line 449 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			backupMutation.type = MutationRef::SetValue;
															#line 452 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			backupMutation.param2 = getBackupValue(val, part);
															#line 453 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			Key key = getBackupKey(wr, &partBuffer, part);
															#line 454 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			backupMutation.param1 = key;
															#line 455 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT(backupMutation.param1.startsWith( logRangeMutation->first));
															#line 458 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			auto& tags = self->tagsForKey(backupMutation.param1);
															#line 459 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			toCommit->addTags(tags);
															#line 461 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (self->acsBuilder != nullptr)
															#line 1678 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 462 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				updateMutationWithAcsAndAddMutationToAcsBuilder( self->acsBuilder, backupMutation, tags, getCommitProxyAccumulativeChecksumIndex(self->commitProxyIndex), self->epoch, commitVersion, self->dbgid);
															#line 1682 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 472 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			toCommit->writeTypedMessage(backupMutation);
															#line 1686 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 412 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		++logRangeMutation;
															#line 1690 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 419 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!(blobIter))
															#line 1706 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 420 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (yieldBytes > SERVER_KNOBS->DESIRED_TOTAL_BYTES)
															#line 1712 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 421 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			yieldBytes = 0;
															#line 422 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (g_network->check_yield(TaskPriority::ProxyCommitYield1))
															#line 1718 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 423 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				*computeDuration += g_network->timer_monotonic() - *computeStart;
															#line 424 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(0, TaskPriority::ProxyCommitYield1);
															#line 424 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (static_cast<AddBackupMutationsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1726 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
				static_cast<AddBackupMutationsActor*>(this)->actor_wait_state = 1;
															#line 424 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AddBackupMutationsActor, 0, Void >*>(static_cast<AddBackupMutationsActor*>(this)));
															#line 1731 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
															#line 428 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		valueWriter.serializeBytes(blobIter->data);
															#line 429 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		yieldBytes += blobIter->data.size();
															#line 430 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		blobIter = blobIter->next;
															#line 1767 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 425 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		*computeStart = g_network->timer_monotonic();
															#line 1782 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 425 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		*computeStart = g_network->timer_monotonic();
															#line 1791 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AddBackupMutationsActor*>(this)->actor_wait_state > 0) static_cast<AddBackupMutationsActor*>(this)->actor_wait_state = 0;
		static_cast<AddBackupMutationsActor*>(this)->ActorCallback< AddBackupMutationsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AddBackupMutationsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("addBackupMutations", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddBackupMutationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addBackupMutations", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AddBackupMutationsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("addBackupMutations", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddBackupMutationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addBackupMutations", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AddBackupMutationsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("addBackupMutations", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddBackupMutationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addBackupMutations", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 398 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCommitData* self;
															#line 398 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	const std::map<Key, MutationListRef>* logRangeMutations;
															#line 398 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	LogPushData* toCommit;
															#line 398 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Version commitVersion;
															#line 398 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	double* computeDuration;
															#line 398 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	double* computeStart;
															#line 404 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	std::map<Key, MutationListRef>::const_iterator logRangeMutation;
															#line 405 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	int32_t version;
															#line 406 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	int yieldBytes;
															#line 407 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	BinaryWriter valueWriter;
															#line 418 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	MutationListRef::Blob* blobIter;
															#line 1893 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via addBackupMutations()
															#line 398 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class AddBackupMutationsActor final : public Actor<Void>, public ActorCallback< AddBackupMutationsActor, 0, Void >, public FastAllocated<AddBackupMutationsActor>, public AddBackupMutationsActorState<AddBackupMutationsActor> {
															#line 1898 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<AddBackupMutationsActor>::operator new;
	using FastAllocated<AddBackupMutationsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(890119761835574016UL, 12036440803583308800UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AddBackupMutationsActor, 0, Void >;
															#line 398 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	AddBackupMutationsActor(ProxyCommitData* const& self,const std::map<Key, MutationListRef>* const& logRangeMutations,LogPushData* const& toCommit,Version const& commitVersion,double* const& computeDuration,double* const& computeStart) 
															#line 1915 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   AddBackupMutationsActorState<AddBackupMutationsActor>(self, logRangeMutations, toCommit, commitVersion, computeDuration, computeStart),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("addBackupMutations", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11549401446348182528UL, 12220003075087083264UL);
		ActorExecutionContextHelper __helper(static_cast<AddBackupMutationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("addBackupMutations");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("addBackupMutations", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AddBackupMutationsActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 398 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> addBackupMutations( ProxyCommitData* const& self, const std::map<Key, MutationListRef>* const& logRangeMutations, LogPushData* const& toCommit, Version const& commitVersion, double* const& computeDuration, double* const& computeStart ) {
															#line 398 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new AddBackupMutationsActor(self, logRangeMutations, toCommit, commitVersion, computeDuration, computeStart));
															#line 1948 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 485 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

															#line 1953 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via releaseResolvingAfter()
															#line 486 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class ReleaseResolvingAfterActor>
															#line 486 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class ReleaseResolvingAfterActorState {
															#line 1960 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 486 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ReleaseResolvingAfterActorState(ProxyCommitData* const& self,Future<Void> const& releaseDelay,int64_t const& localBatchNumber) 
															#line 486 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 486 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : self(self),
															#line 486 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   releaseDelay(releaseDelay),
															#line 486 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   localBatchNumber(localBatchNumber)
															#line 1971 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("releaseResolvingAfter", reinterpret_cast<unsigned long>(this));

	}
	~ReleaseResolvingAfterActorState() 
	{
		fdb_probe_actor_destroy("releaseResolvingAfter", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 487 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = releaseDelay;
															#line 487 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<ReleaseResolvingAfterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1988 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ReleaseResolvingAfterActor*>(this)->actor_wait_state = 1;
															#line 487 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReleaseResolvingAfterActor, 0, Void >*>(static_cast<ReleaseResolvingAfterActor*>(this)));
															#line 1993 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReleaseResolvingAfterActorState();
		static_cast<ReleaseResolvingAfterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 488 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT(self->latestLocalCommitBatchResolving.get() == localBatchNumber - 1);
															#line 489 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->latestLocalCommitBatchResolving.set(localBatchNumber);
															#line 490 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<ReleaseResolvingAfterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReleaseResolvingAfterActorState(); static_cast<ReleaseResolvingAfterActor*>(this)->destroy(); return 0; }
															#line 2020 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<ReleaseResolvingAfterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ReleaseResolvingAfterActorState();
		static_cast<ReleaseResolvingAfterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 488 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT(self->latestLocalCommitBatchResolving.get() == localBatchNumber - 1);
															#line 489 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->latestLocalCommitBatchResolving.set(localBatchNumber);
															#line 490 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<ReleaseResolvingAfterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReleaseResolvingAfterActorState(); static_cast<ReleaseResolvingAfterActor*>(this)->destroy(); return 0; }
															#line 2036 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<ReleaseResolvingAfterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ReleaseResolvingAfterActorState();
		static_cast<ReleaseResolvingAfterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReleaseResolvingAfterActor*>(this)->actor_wait_state > 0) static_cast<ReleaseResolvingAfterActor*>(this)->actor_wait_state = 0;
		static_cast<ReleaseResolvingAfterActor*>(this)->ActorCallback< ReleaseResolvingAfterActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReleaseResolvingAfterActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("releaseResolvingAfter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReleaseResolvingAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("releaseResolvingAfter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReleaseResolvingAfterActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("releaseResolvingAfter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReleaseResolvingAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("releaseResolvingAfter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReleaseResolvingAfterActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("releaseResolvingAfter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReleaseResolvingAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("releaseResolvingAfter", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 486 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCommitData* self;
															#line 486 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Future<Void> releaseDelay;
															#line 486 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	int64_t localBatchNumber;
															#line 2125 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via releaseResolvingAfter()
															#line 486 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class ReleaseResolvingAfterActor final : public Actor<Void>, public ActorCallback< ReleaseResolvingAfterActor, 0, Void >, public FastAllocated<ReleaseResolvingAfterActor>, public ReleaseResolvingAfterActorState<ReleaseResolvingAfterActor> {
															#line 2130 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<ReleaseResolvingAfterActor>::operator new;
	using FastAllocated<ReleaseResolvingAfterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9524820704357536256UL, 7193296934700161536UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReleaseResolvingAfterActor, 0, Void >;
															#line 486 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ReleaseResolvingAfterActor(ProxyCommitData* const& self,Future<Void> const& releaseDelay,int64_t const& localBatchNumber) 
															#line 2147 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ReleaseResolvingAfterActorState<ReleaseResolvingAfterActor>(self, releaseDelay, localBatchNumber),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("releaseResolvingAfter", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15016637786698726400UL, 2544269195532515072UL);
		ActorExecutionContextHelper __helper(static_cast<ReleaseResolvingAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("releaseResolvingAfter");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("releaseResolvingAfter", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReleaseResolvingAfterActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 486 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> releaseResolvingAfter( ProxyCommitData* const& self, Future<Void> const& releaseDelay, int64_t const& localBatchNumber ) {
															#line 486 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new ReleaseResolvingAfterActor(self, releaseDelay, localBatchNumber));
															#line 2180 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 492 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

															#line 2185 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via trackResolutionMetrics()
															#line 493 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class TrackResolutionMetricsActor>
															#line 493 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class TrackResolutionMetricsActorState {
															#line 2192 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 493 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	TrackResolutionMetricsActorState(Reference<Histogram> const& dist,Future<ResolveTransactionBatchReply> const& in) 
															#line 493 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 493 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : dist(dist),
															#line 493 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   in(in),
															#line 495 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   startTime(g_network->timer_monotonic())
															#line 2203 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("trackResolutionMetrics", reinterpret_cast<unsigned long>(this));

	}
	~TrackResolutionMetricsActorState() 
	{
		fdb_probe_actor_destroy("trackResolutionMetrics", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 496 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<ResolveTransactionBatchReply> __when_expr_0 = in;
															#line 496 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<TrackResolutionMetricsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2220 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TrackResolutionMetricsActor*>(this)->actor_wait_state = 1;
															#line 496 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TrackResolutionMetricsActor, 0, ResolveTransactionBatchReply >*>(static_cast<TrackResolutionMetricsActor*>(this)));
															#line 2225 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TrackResolutionMetricsActorState();
		static_cast<TrackResolutionMetricsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(ResolveTransactionBatchReply const& reply,int loopDepth) 
	{
															#line 497 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		dist->sampleSeconds(g_network->timer_monotonic() - startTime);
															#line 498 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<TrackResolutionMetricsActor*>(this)->SAV<ResolveTransactionBatchReply>::futures) { (void)(reply); this->~TrackResolutionMetricsActorState(); static_cast<TrackResolutionMetricsActor*>(this)->destroy(); return 0; }
															#line 2250 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<TrackResolutionMetricsActor*>(this)->SAV< ResolveTransactionBatchReply >::value()) ResolveTransactionBatchReply(reply);
		this->~TrackResolutionMetricsActorState();
		static_cast<TrackResolutionMetricsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(ResolveTransactionBatchReply && reply,int loopDepth) 
	{
															#line 497 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		dist->sampleSeconds(g_network->timer_monotonic() - startTime);
															#line 498 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<TrackResolutionMetricsActor*>(this)->SAV<ResolveTransactionBatchReply>::futures) { (void)(reply); this->~TrackResolutionMetricsActorState(); static_cast<TrackResolutionMetricsActor*>(this)->destroy(); return 0; }
															#line 2264 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<TrackResolutionMetricsActor*>(this)->SAV< ResolveTransactionBatchReply >::value()) ResolveTransactionBatchReply(reply);
		this->~TrackResolutionMetricsActorState();
		static_cast<TrackResolutionMetricsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(ResolveTransactionBatchReply const& reply,int loopDepth) 
	{
		loopDepth = a_body1cont1(reply, loopDepth);

		return loopDepth;
	}
	int a_body1when1(ResolveTransactionBatchReply && reply,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(reply), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TrackResolutionMetricsActor*>(this)->actor_wait_state > 0) static_cast<TrackResolutionMetricsActor*>(this)->actor_wait_state = 0;
		static_cast<TrackResolutionMetricsActor*>(this)->ActorCallback< TrackResolutionMetricsActor, 0, ResolveTransactionBatchReply >::remove();

	}
	void a_callback_fire(ActorCallback< TrackResolutionMetricsActor, 0, ResolveTransactionBatchReply >*,ResolveTransactionBatchReply const& value) 
	{
		fdb_probe_actor_enter("trackResolutionMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackResolutionMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackResolutionMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TrackResolutionMetricsActor, 0, ResolveTransactionBatchReply >*,ResolveTransactionBatchReply && value) 
	{
		fdb_probe_actor_enter("trackResolutionMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackResolutionMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackResolutionMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TrackResolutionMetricsActor, 0, ResolveTransactionBatchReply >*,Error err) 
	{
		fdb_probe_actor_enter("trackResolutionMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TrackResolutionMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackResolutionMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 493 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Reference<Histogram> dist;
															#line 493 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Future<ResolveTransactionBatchReply> in;
															#line 495 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	double startTime;
															#line 2353 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via trackResolutionMetrics()
															#line 493 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class TrackResolutionMetricsActor final : public Actor<ResolveTransactionBatchReply>, public ActorCallback< TrackResolutionMetricsActor, 0, ResolveTransactionBatchReply >, public FastAllocated<TrackResolutionMetricsActor>, public TrackResolutionMetricsActorState<TrackResolutionMetricsActor> {
															#line 2358 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<TrackResolutionMetricsActor>::operator new;
	using FastAllocated<TrackResolutionMetricsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3701419981728069888UL, 3042057047950794496UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<ResolveTransactionBatchReply>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TrackResolutionMetricsActor, 0, ResolveTransactionBatchReply >;
															#line 493 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	TrackResolutionMetricsActor(Reference<Histogram> const& dist,Future<ResolveTransactionBatchReply> const& in) 
															#line 2375 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<ResolveTransactionBatchReply>(),
		   TrackResolutionMetricsActorState<TrackResolutionMetricsActor>(dist, in),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("trackResolutionMetrics", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(662851382450018048UL, 8345511031365611520UL);
		ActorExecutionContextHelper __helper(static_cast<TrackResolutionMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("trackResolutionMetrics");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("trackResolutionMetrics", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TrackResolutionMetricsActor, 0, ResolveTransactionBatchReply >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 493 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] static Future<ResolveTransactionBatchReply> trackResolutionMetrics( Reference<Histogram> const& dist, Future<ResolveTransactionBatchReply> const& in ) {
															#line 493 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<ResolveTransactionBatchReply>(new TrackResolutionMetricsActor(dist, in));
															#line 2408 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 500 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

namespace CommitBatch {

constexpr const std::string_view UNSET = std::string_view();
constexpr const std::string_view INITIALIZE = "initialize"sv;
constexpr const std::string_view PRE_RESOLUTION = "preResolution"sv;
constexpr const std::string_view RESOLUTION = "resolution"sv;
constexpr const std::string_view POST_RESOLUTION = "postResolution"sv;
constexpr const std::string_view TRANSACTION_LOGGING = "transactionLogging"sv;
constexpr const std::string_view REPLY = "reply"sv;
constexpr const std::string_view COMPLETE = "complete"sv;

struct CommitBatchContext {
	using StoreCommit_t = std::vector<std::pair<Future<LogSystemDiskQueueAdapter::CommitMessage>, Future<Void>>>;

	ProxyCommitData* const pProxyCommitData;
	std::vector<CommitTransactionRequest> trs;
	const int currentBatchMemBytesCount;

	double startTime;

	// The current stage of batch commit
	std::string_view stage = UNSET;

	// If encryption is enabled this value represents the total time (in nanoseconds) that was spent on encryption in
	// the commit proxy for a given Commit Batch
	Optional<double> encryptionTime;

	Optional<UID> debugID;

	bool forceRecovery = false;
	bool rejected = false; // If rejected due to long queue length

	int64_t localBatchNumber;
	LogPushData toCommit;

	int batchOperations = 0;

	Span span;

	int64_t batchBytes = 0;

	int latencyBucket = 0;

	Version commitVersion;
	Version prevVersion;

	int64_t maxTransactionBytes;
	std::vector<std::vector<int>> transactionResolverMap;
	std::vector<std::vector<std::vector<int>>> txReadConflictRangeIndexMap;

	Future<Void> releaseDelay;
	Future<Void> releaseFuture;

	std::vector<ResolveTransactionBatchReply> resolution;

	double computeStart;
	double computeDuration = 0;

	Arena arena;

	/// true if the batch is the 1st batch for this proxy, additional metadata
	/// processing is involved for this batch.
	bool isMyFirstBatch;
	bool firstStateMutations;

	Optional<Value> previousCoordinators;

	StoreCommit_t storeCommits;

	std::vector<uint8_t> committed;

	Optional<Key> lockedKey;
	bool locked;

	int commitCount = 0;

	std::vector<int> nextTr;

	bool lockedAfter;

	Optional<Value> metadataVersionAfter;

	int mutationCount = 0;
	int mutationBytes = 0;

	std::map<Key, MutationListRef> logRangeMutations;
	Arena logRangeMutationsArena;

	int transactionNum = 0;
	int yieldBytes = 0;

	LogSystemDiskQueueAdapter::CommitMessage msg;

	Future<Version> loggingComplete;

	double commitStartTime;

	std::unordered_map<uint16_t, Version> tpcvMap; // obtained from resolver
	std::set<Tag> writtenTags; // final set tags written to in the batch
	std::set<Tag> writtenTagsPreResolution; // tags written to in the batch not including any changes from the resolver.

	// Cipher keys to be used to encrypt mutations
	std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> cipherKeys;

	IdempotencyIdKVBuilder idempotencyKVBuilder;

	CommitBatchContext(ProxyCommitData*, const std::vector<CommitTransactionRequest>*, const int);

	void setupTraceBatch();

	std::set<Tag> getWrittenTagsPreResolution();

	void checkHotShards();

	bool rangeLockEnabled();

	Version lastShardMove;

private:
	void evaluateBatchSize();
};

bool CommitBatchContext::rangeLockEnabled() {
	return pProxyCommitData->rangeLockEnabled();
}

void CommitBatchContext::checkHotShards() {
	// removed expired hot shards
	for (auto it = pProxyCommitData->hotShards.begin(); it != pProxyCommitData->hotShards.end();) {
		if (now() > it->second) {
			it = pProxyCommitData->hotShards.erase(it);
		} else {
			++it;
		}
	}

	if (pProxyCommitData->hotShards.empty()) {
		return;
	}

	auto trsBegin = trs.begin();

	std::vector<size_t> transactionsToRemove;
	for (int transactionNum = 0; transactionNum < trs.size(); transactionNum++) {
		VectorRef<MutationRef>* pMutations = &trs[transactionNum].transaction.mutations;
		bool abortTransaction = false;
		for (int mutationNum = 0; mutationNum < pMutations->size(); mutationNum++) {
			auto& m = (*pMutations)[mutationNum];
			if (isSingleKeyMutation((MutationRef::Type)m.type)) {
				for (const auto& shard : pProxyCommitData->hotShards) {
					if (shard.first.contains(KeyRef(m.param1))) {
						abortTransaction = true;
						break;
					}
				}
			} else if (m.type == MutationRef::ClearRange) {
				for (const auto& shard : pProxyCommitData->hotShards) {
					if (shard.first.intersects(KeyRangeRef(m.param1, m.param2))) {
						abortTransaction = true;
						break;
					}
				}
			} else {
				UNREACHABLE();
			}
		}
		if (abortTransaction) {
			trs[transactionNum].reply.sendError(transaction_throttled_hot_shard());
			transactionsToRemove.push_back(transactionNum);
		}
	}
	// Remove transactions marked for removal in reverse order to avoid shifting indices
	for (auto it = transactionsToRemove.rbegin(); it != transactionsToRemove.rend(); ++it) {
		trs.erase(trsBegin + *it);
	}
	committed.resize(trs.size());
	return;
}

// Check whether the mutation intersects any legal backup ranges
// If so, it will be clamped to the intersecting range(s) later
inline bool shouldBackup(MutationRef const& m) {
	if (normalKeys.contains(m.param1) || m.param1 == metadataVersionKey) {
		return true;
	} else if (m.type != MutationRef::Type::ClearRange) {
		return systemBackupMutationMask().rangeContaining(m.param1).value();
	} else {
		for (auto& r : systemBackupMutationMask().intersectingRanges(KeyRangeRef(m.param1, m.param2))) {
			if (r->value()) {
				return true;
			}
		}
	}
	return false;
}

// Find the set of logs the batch is sent to. An empty set indicates it cannot be
// determined. In version vector, this means the batch should be sent to all logs.
std::set<Tag> CommitBatchContext::getWrittenTagsPreResolution() {
	std::set<Tag> transactionTags;
	lastShardMove = pProxyCommitData->lastShardMove;
	if (pProxyCommitData->txnStateStore->getReplaceContent()) {
		return std::set<Tag>();
	}
	if (pProxyCommitData->idempotencyClears.size()) {
		return std::set<Tag>();
	}
	for (int transactionNum = 0; transactionNum < trs.size(); transactionNum++) {
		int mutationNum = 0;
		VectorRef<MutationRef>* pMutations = &trs[transactionNum].transaction.mutations;
		if (trs[transactionNum].idempotencyId.valid()) {
			return std::set<Tag>();
		}
		for (; mutationNum < pMutations->size(); mutationNum++) {
			auto& m = (*pMutations)[mutationNum];
			// disable version vector's effect if any mutation in the batch is backed up.
			// TODO: make backup work with version vector.
			if (pProxyCommitData->vecBackupKeys.size() > 1 && shouldBackup(m)) {
				return std::set<Tag>();
			}
			if (isSingleKeyMutation((MutationRef::Type)m.type)) {
				auto& tags = pProxyCommitData->tagsForKey(m.param1);
				transactionTags.insert(tags.begin(), tags.end());
			} else if (m.type == MutationRef::ClearRange) {
				auto range = pProxyCommitData->keyInfo.rangeContaining(m.param1);
				if (range.end() >= m.param2) {
					range.value().populateTags();
					transactionTags.insert(range.value().tags.begin(), range.value().tags.end());
				} else {
					std::set<Tag> allSources;
					while (range.begin() < m.param2) {
						range.value().populateTags();
						allSources.insert(range.value().tags.begin(), range.value().tags.end());
						transactionTags.insert(range.value().tags.begin(), range.value().tags.end());
						++range;
					}
				}
				KeyRangeRef clearRange(KeyRangeRef(m.param1, m.param2));
			} else {
				UNREACHABLE();
			}
		}
	}

	if (toCommit.getLogRouterTags()) {
		toCommit.storeRandomRouterTag();
		transactionTags.insert(toCommit.savedRandomRouterTag.get());
	}

	return transactionTags;
}

CommitBatchContext::CommitBatchContext(ProxyCommitData* const pProxyCommitData_,
                                       const std::vector<CommitTransactionRequest>* trs_,
                                       const int currentBatchMemBytesCount)
  : pProxyCommitData(pProxyCommitData_), trs(std::move(*const_cast<std::vector<CommitTransactionRequest>*>(trs_))),
    currentBatchMemBytesCount(currentBatchMemBytesCount), startTime(g_network->now()),
    localBatchNumber(++pProxyCommitData->localCommitBatchesStarted),
    toCommit(pProxyCommitData->logSystem, pProxyCommitData->localTLogCount), span("MP:commitBatch"_loc),
    committed(trs.size()), lastShardMove(invalidVersion) {

	evaluateBatchSize();

	if (batchOperations != 0) {
		latencyBucket =
		    std::min<int>(SERVER_KNOBS->PROXY_COMPUTE_BUCKETS - 1,
		                  SERVER_KNOBS->PROXY_COMPUTE_BUCKETS * batchBytes /
		                      (batchOperations * (CLIENT_KNOBS->VALUE_SIZE_LIMIT + CLIENT_KNOBS->KEY_SIZE_LIMIT)));
	}

	// since we are using just the former to limit the number of versions actually in flight!
	ASSERT(SERVER_KNOBS->MAX_READ_TRANSACTION_LIFE_VERSIONS <= SERVER_KNOBS->MAX_VERSIONS_IN_FLIGHT);
}

void CommitBatchContext::setupTraceBatch() {
	for (const auto& tr : trs) {
		if (tr.debugID.present()) {
			if (!debugID.present()) {
				debugID = nondeterministicRandom()->randomUniqueID();
			}

			g_traceBatch.addAttach("CommitAttachID", tr.debugID.get().first(), debugID.get().first());
		}
		span.addLink(tr.spanContext);
	}

	if (debugID.present()) {
		g_traceBatch.addEvent("CommitDebug", debugID.get().first(), "CommitProxyServer.commitBatch.Before");
	}
}

void CommitBatchContext::evaluateBatchSize() {
	for (const auto& tr : trs) {
		const auto& mutations = tr.transaction.mutations;
		batchOperations += mutations.size();
		batchBytes += mutations.expectedSize();
	}
}

// Try to identify recovery transaction and backup's apply mutations (blind writes).
// Both cannot be rejected and are approximated by looking at first mutation
// starting with 0xff.
bool canReject(const std::vector<CommitTransactionRequest>& trs) {
	for (const auto& tr : trs) {
		if (tr.transaction.mutations.empty())
			continue;
		if (tr.transaction.mutations[0].param1.startsWith("\xff"_sr) || tr.transaction.read_conflict_ranges.empty()) {
			return false;
		}
	}
	return true;
}

double computeReleaseDelay(CommitBatchContext* self, double latencyBucket) {
	return std::min(SERVER_KNOBS->MAX_PROXY_COMPUTE,
	                self->batchOperations * self->pProxyCommitData->commitComputePerOperation[latencyBucket]);
}

															#line 2731 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
// This generated class is to be used only via preresolutionProcessing()
															#line 819 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class PreresolutionProcessingActor>
															#line 819 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class PreresolutionProcessingActorState {
															#line 2737 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 819 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	PreresolutionProcessingActorState(CommitBatchContext* const& self) 
															#line 819 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 819 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : self(self),
															#line 821 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   pProxyCommitData(self->pProxyCommitData),
															#line 822 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   trs(self->trs),
															#line 823 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   localBatchNumber(self->localBatchNumber),
															#line 824 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   latencyBucket(self->latencyBucket),
															#line 825 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   debugID(self->debugID),
															#line 826 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   span("MP:preresolutionProcessing"_loc, self->span.context),
															#line 827 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   startTime(g_network->timer_monotonic())
															#line 2758 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("preresolutionProcessing", reinterpret_cast<unsigned long>(this));

	}
	~PreresolutionProcessingActorState() 
	{
		fdb_probe_actor_destroy("preresolutionProcessing", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 829 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (self->localBatchNumber - self->pProxyCommitData->latestLocalCommitBatchResolving.get() > SERVER_KNOBS->RESET_MASTER_BATCHES && now() - self->pProxyCommitData->lastMasterReset > SERVER_KNOBS->RESET_MASTER_DELAY)
															#line 2773 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 832 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				TraceEvent(SevWarnAlways, "ResetMasterNetwork", self->pProxyCommitData->dbgid) .detail("CurrentBatch", self->localBatchNumber) .detail("InProcessBatch", self->pProxyCommitData->latestLocalCommitBatchResolving.get());
															#line 835 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				FlowTransport::transport().resetConnection(self->pProxyCommitData->master.address());
															#line 836 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				self->pProxyCommitData->lastMasterReset = now();
															#line 2781 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 840 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			CODE_PROBE(pProxyCommitData->latestLocalCommitBatchResolving.get() < localBatchNumber - 1, "Wait for local batch");
															#line 841 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = pProxyCommitData->latestLocalCommitBatchResolving.whenAtLeast(localBatchNumber - 1);
															#line 841 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<PreresolutionProcessingActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2789 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PreresolutionProcessingActor*>(this)->actor_wait_state = 1;
															#line 841 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PreresolutionProcessingActor, 0, Void >*>(static_cast<PreresolutionProcessingActor*>(this)));
															#line 2794 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PreresolutionProcessingActorState();
		static_cast<PreresolutionProcessingActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 842 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		double queuingDelay = g_network->timer_monotonic() - startTime;
															#line 843 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.computeLatency.addMeasurement(queuingDelay);
															#line 844 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.commitBatchQueuingDist->sampleSeconds(queuingDelay);
															#line 845 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if ((queuingDelay > (double)SERVER_KNOBS->MAX_READ_TRANSACTION_LIFE_VERSIONS / SERVER_KNOBS->VERSIONS_PER_SECOND || (g_network->isSimulated() && BUGGIFY_WITH_PROB(0.01))) && SERVER_KNOBS->PROXY_REJECT_BATCH_QUEUED_TOO_LONG && canReject(trs))
															#line 2823 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 849 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			CODE_PROBE(true, "Reject transactions in the batch");
															#line 850 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent(g_network->isSimulated() ? SevInfo : SevWarnAlways, "ProxyReject", pProxyCommitData->dbgid) .suppressFor(0.1) .detail("QDelay", queuingDelay) .detail("Transactions", trs.size()) .detail("BatchNumber", localBatchNumber);
															#line 855 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT(pProxyCommitData->latestLocalCommitBatchResolving.get() == localBatchNumber - 1);
															#line 856 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->latestLocalCommitBatchResolving.set(localBatchNumber);
															#line 858 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_1 = pProxyCommitData->latestLocalCommitBatchLogging.whenAtLeast(localBatchNumber - 1);
															#line 858 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<PreresolutionProcessingActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2837 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<PreresolutionProcessingActor*>(this)->actor_wait_state = 2;
															#line 858 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PreresolutionProcessingActor, 1, Void >*>(static_cast<PreresolutionProcessingActor*>(this)));
															#line 2842 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 842 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		double queuingDelay = g_network->timer_monotonic() - startTime;
															#line 843 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.computeLatency.addMeasurement(queuingDelay);
															#line 844 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.commitBatchQueuingDist->sampleSeconds(queuingDelay);
															#line 845 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if ((queuingDelay > (double)SERVER_KNOBS->MAX_READ_TRANSACTION_LIFE_VERSIONS / SERVER_KNOBS->VERSIONS_PER_SECOND || (g_network->isSimulated() && BUGGIFY_WITH_PROB(0.01))) && SERVER_KNOBS->PROXY_REJECT_BATCH_QUEUED_TOO_LONG && canReject(trs))
															#line 2862 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 849 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			CODE_PROBE(true, "Reject transactions in the batch");
															#line 850 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent(g_network->isSimulated() ? SevInfo : SevWarnAlways, "ProxyReject", pProxyCommitData->dbgid) .suppressFor(0.1) .detail("QDelay", queuingDelay) .detail("Transactions", trs.size()) .detail("BatchNumber", localBatchNumber);
															#line 855 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT(pProxyCommitData->latestLocalCommitBatchResolving.get() == localBatchNumber - 1);
															#line 856 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->latestLocalCommitBatchResolving.set(localBatchNumber);
															#line 858 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_1 = pProxyCommitData->latestLocalCommitBatchLogging.whenAtLeast(localBatchNumber - 1);
															#line 858 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<PreresolutionProcessingActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2876 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<PreresolutionProcessingActor*>(this)->actor_wait_state = 2;
															#line 858 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PreresolutionProcessingActor, 1, Void >*>(static_cast<PreresolutionProcessingActor*>(this)));
															#line 2881 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PreresolutionProcessingActor*>(this)->actor_wait_state > 0) static_cast<PreresolutionProcessingActor*>(this)->actor_wait_state = 0;
		static_cast<PreresolutionProcessingActor*>(this)->ActorCallback< PreresolutionProcessingActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PreresolutionProcessingActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("preresolutionProcessing", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PreresolutionProcessingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("preresolutionProcessing", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PreresolutionProcessingActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("preresolutionProcessing", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PreresolutionProcessingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("preresolutionProcessing", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PreresolutionProcessingActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("preresolutionProcessing", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PreresolutionProcessingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("preresolutionProcessing", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 871 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->releaseDelay = delay(computeReleaseDelay(self, latencyBucket), TaskPriority::ProxyMasterVersionReply);
															#line 873 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (debugID.present())
															#line 2972 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 874 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			g_traceBatch.addEvent( "CommitDebug", debugID.get().first(), "CommitProxyServer.commitBatch.GettingCommitVersion");
															#line 2976 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 878 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST)
															#line 2980 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 879 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->writtenTagsPreResolution = self->getWrittenTagsPreResolution();
															#line 2984 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 882 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (SERVER_KNOBS->HOT_SHARD_THROTTLING_ENABLED && !pProxyCommitData->hotShards.empty())
															#line 2988 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 883 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->checkHotShards();
															#line 2992 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 886 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		GetCommitVersionRequest req(span.context, pProxyCommitData->commitVersionRequestNumber++, pProxyCommitData->mostRecentProcessedRequestNumber, pProxyCommitData->dbgid);
															#line 890 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		beforeGettingCommitVersion = g_network->timer_monotonic();
															#line 891 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<GetCommitVersionReply> __when_expr_2 = brokenPromiseToNever( pProxyCommitData->master.getCommitVersion.getReply(req, TaskPriority::ProxyMasterVersionReply));
															#line 891 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<PreresolutionProcessingActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3002 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<PreresolutionProcessingActor*>(this)->actor_wait_state = 3;
															#line 891 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PreresolutionProcessingActor, 2, GetCommitVersionReply >*>(static_cast<PreresolutionProcessingActor*>(this)));
															#line 3007 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 859 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT(pProxyCommitData->latestLocalCommitBatchLogging.get() == localBatchNumber - 1);
															#line 860 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->latestLocalCommitBatchLogging.set(localBatchNumber);
															#line 861 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for( const auto& tr : trs ) {
															#line 862 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			tr.reply.sendError(transaction_too_old());
															#line 3022 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 864 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		++pProxyCommitData->stats.commitBatchOut;
															#line 865 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.txnCommitOut += trs.size();
															#line 866 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.txnRejectedForQueuedTooLong += trs.size();
															#line 867 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->rejected = true;
															#line 868 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<PreresolutionProcessingActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PreresolutionProcessingActorState(); static_cast<PreresolutionProcessingActor*>(this)->destroy(); return 0; }
															#line 3034 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<PreresolutionProcessingActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PreresolutionProcessingActorState();
		static_cast<PreresolutionProcessingActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 859 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT(pProxyCommitData->latestLocalCommitBatchLogging.get() == localBatchNumber - 1);
															#line 860 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->latestLocalCommitBatchLogging.set(localBatchNumber);
															#line 861 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for( const auto& tr : trs ) {
															#line 862 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			tr.reply.sendError(transaction_too_old());
															#line 3052 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 864 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		++pProxyCommitData->stats.commitBatchOut;
															#line 865 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.txnCommitOut += trs.size();
															#line 866 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.txnRejectedForQueuedTooLong += trs.size();
															#line 867 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->rejected = true;
															#line 868 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<PreresolutionProcessingActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PreresolutionProcessingActorState(); static_cast<PreresolutionProcessingActor*>(this)->destroy(); return 0; }
															#line 3064 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<PreresolutionProcessingActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PreresolutionProcessingActorState();
		static_cast<PreresolutionProcessingActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PreresolutionProcessingActor*>(this)->actor_wait_state > 0) static_cast<PreresolutionProcessingActor*>(this)->actor_wait_state = 0;
		static_cast<PreresolutionProcessingActor*>(this)->ActorCallback< PreresolutionProcessingActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PreresolutionProcessingActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("preresolutionProcessing", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PreresolutionProcessingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("preresolutionProcessing", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PreresolutionProcessingActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("preresolutionProcessing", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PreresolutionProcessingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("preresolutionProcessing", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PreresolutionProcessingActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("preresolutionProcessing", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PreresolutionProcessingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("preresolutionProcessing", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont7(GetCommitVersionReply const& versionReply,int loopDepth) 
	{
															#line 894 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->mostRecentProcessedRequestNumber = versionReply.requestNum;
															#line 896 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.txnCommitVersionAssigned += trs.size();
															#line 897 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.lastCommitVersionAssigned = versionReply.version;
															#line 898 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.getCommitVersionDist->sampleSeconds(g_network->timer_monotonic() - beforeGettingCommitVersion);
															#line 901 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->commitVersion = versionReply.version;
															#line 902 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->prevVersion = versionReply.prevVersion;
															#line 906 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for( auto it : versionReply.resolverChanges ) {
															#line 907 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			auto rs = pProxyCommitData->keyResolvers.modify(it.range);
															#line 908 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for(auto r = rs.begin();r != rs.end();++r) {
															#line 909 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				r->value().emplace_back(versionReply.resolverChangesVersion, it.dest);
															#line 3169 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
		}
															#line 914 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (debugID.present())
															#line 3174 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 915 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			g_traceBatch.addEvent("CommitDebug", debugID.get().first(), "CommitProxyServer.commitBatch.GotCommitVersion");
															#line 3178 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 918 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<PreresolutionProcessingActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PreresolutionProcessingActorState(); static_cast<PreresolutionProcessingActor*>(this)->destroy(); return 0; }
															#line 3182 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<PreresolutionProcessingActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PreresolutionProcessingActorState();
		static_cast<PreresolutionProcessingActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7(GetCommitVersionReply && versionReply,int loopDepth) 
	{
															#line 894 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->mostRecentProcessedRequestNumber = versionReply.requestNum;
															#line 896 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.txnCommitVersionAssigned += trs.size();
															#line 897 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.lastCommitVersionAssigned = versionReply.version;
															#line 898 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.getCommitVersionDist->sampleSeconds(g_network->timer_monotonic() - beforeGettingCommitVersion);
															#line 901 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->commitVersion = versionReply.version;
															#line 902 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->prevVersion = versionReply.prevVersion;
															#line 906 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for( auto it : versionReply.resolverChanges ) {
															#line 907 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			auto rs = pProxyCommitData->keyResolvers.modify(it.range);
															#line 908 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for(auto r = rs.begin();r != rs.end();++r) {
															#line 909 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				r->value().emplace_back(versionReply.resolverChangesVersion, it.dest);
															#line 3212 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
		}
															#line 914 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (debugID.present())
															#line 3217 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 915 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			g_traceBatch.addEvent("CommitDebug", debugID.get().first(), "CommitProxyServer.commitBatch.GotCommitVersion");
															#line 3221 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 918 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<PreresolutionProcessingActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PreresolutionProcessingActorState(); static_cast<PreresolutionProcessingActor*>(this)->destroy(); return 0; }
															#line 3225 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<PreresolutionProcessingActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PreresolutionProcessingActorState();
		static_cast<PreresolutionProcessingActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3when1(GetCommitVersionReply const& versionReply,int loopDepth) 
	{
		loopDepth = a_body1cont7(versionReply, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(GetCommitVersionReply && versionReply,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(versionReply), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<PreresolutionProcessingActor*>(this)->actor_wait_state > 0) static_cast<PreresolutionProcessingActor*>(this)->actor_wait_state = 0;
		static_cast<PreresolutionProcessingActor*>(this)->ActorCallback< PreresolutionProcessingActor, 2, GetCommitVersionReply >::remove();

	}
	void a_callback_fire(ActorCallback< PreresolutionProcessingActor, 2, GetCommitVersionReply >*,GetCommitVersionReply const& value) 
	{
		fdb_probe_actor_enter("preresolutionProcessing", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PreresolutionProcessingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("preresolutionProcessing", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< PreresolutionProcessingActor, 2, GetCommitVersionReply >*,GetCommitVersionReply && value) 
	{
		fdb_probe_actor_enter("preresolutionProcessing", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PreresolutionProcessingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("preresolutionProcessing", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< PreresolutionProcessingActor, 2, GetCommitVersionReply >*,Error err) 
	{
		fdb_probe_actor_enter("preresolutionProcessing", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PreresolutionProcessingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("preresolutionProcessing", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 819 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitBatchContext* self;
															#line 821 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCommitData* const pProxyCommitData;
															#line 822 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	std::vector<CommitTransactionRequest>& trs;
															#line 823 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	const int64_t localBatchNumber;
															#line 824 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	const int latencyBucket;
															#line 825 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	const Optional<UID>& debugID;
															#line 826 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Span span;
															#line 827 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	double startTime;
															#line 890 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	double beforeGettingCommitVersion;
															#line 3326 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via preresolutionProcessing()
															#line 819 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class PreresolutionProcessingActor final : public Actor<Void>, public ActorCallback< PreresolutionProcessingActor, 0, Void >, public ActorCallback< PreresolutionProcessingActor, 1, Void >, public ActorCallback< PreresolutionProcessingActor, 2, GetCommitVersionReply >, public FastAllocated<PreresolutionProcessingActor>, public PreresolutionProcessingActorState<PreresolutionProcessingActor> {
															#line 3331 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<PreresolutionProcessingActor>::operator new;
	using FastAllocated<PreresolutionProcessingActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3976222921293608192UL, 5760456580311129856UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PreresolutionProcessingActor, 0, Void >;
friend struct ActorCallback< PreresolutionProcessingActor, 1, Void >;
friend struct ActorCallback< PreresolutionProcessingActor, 2, GetCommitVersionReply >;
															#line 819 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	PreresolutionProcessingActor(CommitBatchContext* const& self) 
															#line 3350 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   PreresolutionProcessingActorState<PreresolutionProcessingActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("preresolutionProcessing", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18247384368358389248UL, 1993642498905904640UL);
		ActorExecutionContextHelper __helper(static_cast<PreresolutionProcessingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("preresolutionProcessing");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("preresolutionProcessing", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PreresolutionProcessingActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PreresolutionProcessingActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< PreresolutionProcessingActor, 2, GetCommitVersionReply >*)0, actor_cancelled()); break;
		}

	}
};
															#line 819 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> preresolutionProcessing( CommitBatchContext* const& self ) {
															#line 819 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new PreresolutionProcessingActor(self));
															#line 3384 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 920 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

namespace {

EncryptCipherDomainId getEncryptDetailsFromMutationRef(ProxyCommitData* commitData, MutationRef m) {
	EncryptCipherDomainId domainId = INVALID_ENCRYPT_DOMAIN_ID;

	if (isSystemKey(m.param1)) {
		// Encryption domain == FDB SystemKeyspace encryption domain
		domainId = SYSTEM_KEYSPACE_ENCRYPT_DOMAIN_ID;
	} else {
		domainId = FDB_DEFAULT_ENCRYPT_DOMAIN_ID;
	}

	return domainId;
}

} // namespace

															#line 3406 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
// This generated class is to be used only via getResolution()
															#line 938 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class GetResolutionActor>
															#line 938 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class GetResolutionActorState {
															#line 3412 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 938 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	GetResolutionActorState(CommitBatchContext* const& self) 
															#line 938 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 938 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : self(self),
															#line 939 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   resolutionStart(g_network->timer_monotonic()),
															#line 942 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   pProxyCommitData(self->pProxyCommitData)
															#line 3423 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getResolution", reinterpret_cast<unsigned long>(this));

	}
	~GetResolutionActorState() 
	{
		fdb_probe_actor_destroy("getResolution", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 943 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			std::vector<CommitTransactionRequest>& trs = self->trs;
															#line 944 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			span = Span("MP:getResolution"_loc, self->span.context);
															#line 946 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ResolutionRequestBuilder requests(pProxyCommitData, self->commitVersion, self->prevVersion, pProxyCommitData->version.get(), self->lastShardMove, span);
															#line 952 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			int conflictRangeCount = 0;
															#line 953 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->maxTransactionBytes = 0;
															#line 954 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for(int t = 0;t < trs.size();t++) {
															#line 955 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				requests.addTransaction(trs[t], self->commitVersion, t);
															#line 956 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				conflictRangeCount += trs[t].transaction.read_conflict_ranges.size() + trs[t].transaction.write_conflict_ranges.size();
															#line 960 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				self->maxTransactionBytes = std::max<int64_t>(self->maxTransactionBytes, trs[t].transaction.expectedSize());
															#line 3454 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 963 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->stats.conflictRanges += conflictRangeCount;
															#line 965 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for(int r = 1;r < pProxyCommitData->resolvers.size();r++) {
															#line 966 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				ASSERT(requests.requests[r].txnStateTransactions.size() == requests.requests[0].txnStateTransactions.size());
															#line 3462 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 968 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->stats.txnCommitResolving += trs.size();
															#line 969 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			std::vector<Future<ResolveTransactionBatchReply>> replies;
															#line 970 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for(int r = 0;r < pProxyCommitData->resolvers.size();r++) {
															#line 971 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				requests.requests[r].debugID = self->debugID;
															#line 972 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				requests.requests[r].writtenTags = self->writtenTagsPreResolution;
															#line 973 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				replies.push_back(trackResolutionMetrics(pProxyCommitData->stats.resolverDist[r], brokenPromiseToNever(pProxyCommitData->resolvers[r].resolve.getReply( requests.requests[r], TaskPriority::ProxyResolverReply))));
															#line 3476 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 978 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->transactionResolverMap.swap(requests.transactionResolverMap);
															#line 980 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->txReadConflictRangeIndexMap.swap(requests.txReadConflictRangeIndexMap);
															#line 983 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			getCipherKeys = Future<std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>>>();
															#line 984 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (pProxyCommitData->encryptMode.isEncryptionEnabled())
															#line 3486 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 985 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				std::unordered_set<EncryptCipherDomainId> encryptDomainIds = { SYSTEM_KEYSPACE_ENCRYPT_DOMAIN_ID, FDB_DEFAULT_ENCRYPT_DOMAIN_ID };
															#line 987 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (FLOW_KNOBS->ENCRYPT_HEADER_AUTH_TOKEN_ENABLED)
															#line 3492 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				{
															#line 988 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					encryptDomainIds.insert(ENCRYPT_HEADER_DOMAIN_ID);
															#line 3496 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				}
															#line 990 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				getCipherKeys = GetEncryptCipherKeys<ServerDBInfo>::getLatestEncryptCipherKeys( pProxyCommitData->db, encryptDomainIds, BlobCipherMetrics::TLOG, pProxyCommitData->encryptionMonitor);
															#line 3500 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 994 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->releaseFuture = releaseResolvingAfter(pProxyCommitData, self->releaseDelay, self->localBatchNumber);
															#line 996 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (self->localBatchNumber - self->pProxyCommitData->latestLocalCommitBatchLogging.get() > SERVER_KNOBS->RESET_RESOLVER_BATCHES && now() - self->pProxyCommitData->lastResolverReset > SERVER_KNOBS->RESET_RESOLVER_DELAY)
															#line 3506 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 999 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				for(int r = 0;r < self->pProxyCommitData->resolvers.size();r++) {
															#line 1000 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					TraceEvent(SevWarnAlways, "ResetResolverNetwork", self->pProxyCommitData->dbgid) .detail("PeerAddr", self->pProxyCommitData->resolvers[r].address()) .detail("PeerAddress", self->pProxyCommitData->resolvers[r].address()) .detail("CurrentBatch", self->localBatchNumber) .detail("InProcessBatch", self->pProxyCommitData->latestLocalCommitBatchLogging.get());
															#line 1005 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					FlowTransport::transport().resetConnection(self->pProxyCommitData->resolvers[r].address());
															#line 3514 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				}
															#line 1007 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				self->pProxyCommitData->lastResolverReset = now();
															#line 3518 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 1011 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<std::vector<ResolveTransactionBatchReply>> __when_expr_0 = getAll(replies);
															#line 1011 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<GetResolutionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3524 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetResolutionActor*>(this)->actor_wait_state = 1;
															#line 1011 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetResolutionActor, 0, std::vector<ResolveTransactionBatchReply> >*>(static_cast<GetResolutionActor*>(this)));
															#line 3529 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetResolutionActorState();
		static_cast<GetResolutionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<ResolveTransactionBatchReply> const& resolutionResp,int loopDepth) 
	{
															#line 1012 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->resolution.swap(*const_cast<std::vector<ResolveTransactionBatchReply>*>(&resolutionResp));
															#line 1014 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->pProxyCommitData->stats.resolutionDist->sampleSeconds(g_network->timer_monotonic() - resolutionStart);
															#line 1015 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (self->debugID.present())
															#line 3556 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1016 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			g_traceBatch.addEvent( "CommitDebug", self->debugID.get().first(), "CommitProxyServer.commitBatch.AfterResolution");
															#line 3560 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 1019 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (pProxyCommitData->encryptMode.isEncryptionEnabled())
															#line 3564 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1020 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>>> __when_expr_1 = getCipherKeys;
															#line 1020 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<GetResolutionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3570 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetResolutionActor*>(this)->actor_wait_state = 2;
															#line 1020 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetResolutionActor, 1, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >*>(static_cast<GetResolutionActor*>(this)));
															#line 3575 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont9(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(std::vector<ResolveTransactionBatchReply> && resolutionResp,int loopDepth) 
	{
															#line 1012 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->resolution.swap(*const_cast<std::vector<ResolveTransactionBatchReply>*>(&resolutionResp));
															#line 1014 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->pProxyCommitData->stats.resolutionDist->sampleSeconds(g_network->timer_monotonic() - resolutionStart);
															#line 1015 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (self->debugID.present())
															#line 3593 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1016 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			g_traceBatch.addEvent( "CommitDebug", self->debugID.get().first(), "CommitProxyServer.commitBatch.AfterResolution");
															#line 3597 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 1019 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (pProxyCommitData->encryptMode.isEncryptionEnabled())
															#line 3601 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1020 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>>> __when_expr_1 = getCipherKeys;
															#line 1020 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<GetResolutionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3607 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetResolutionActor*>(this)->actor_wait_state = 2;
															#line 1020 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetResolutionActor, 1, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >*>(static_cast<GetResolutionActor*>(this)));
															#line 3612 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont9(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(std::vector<ResolveTransactionBatchReply> const& resolutionResp,int loopDepth) 
	{
		loopDepth = a_body1cont1(resolutionResp, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<ResolveTransactionBatchReply> && resolutionResp,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(resolutionResp), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetResolutionActor*>(this)->actor_wait_state > 0) static_cast<GetResolutionActor*>(this)->actor_wait_state = 0;
		static_cast<GetResolutionActor*>(this)->ActorCallback< GetResolutionActor, 0, std::vector<ResolveTransactionBatchReply> >::remove();

	}
	void a_callback_fire(ActorCallback< GetResolutionActor, 0, std::vector<ResolveTransactionBatchReply> >*,std::vector<ResolveTransactionBatchReply> const& value) 
	{
		fdb_probe_actor_enter("getResolution", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getResolution", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetResolutionActor, 0, std::vector<ResolveTransactionBatchReply> >*,std::vector<ResolveTransactionBatchReply> && value) 
	{
		fdb_probe_actor_enter("getResolution", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getResolution", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetResolutionActor, 0, std::vector<ResolveTransactionBatchReply> >*,Error err) 
	{
		fdb_probe_actor_enter("getResolution", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getResolution", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont9(int loopDepth) 
	{
															#line 1024 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<GetResolutionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetResolutionActorState(); static_cast<GetResolutionActor*>(this)->destroy(); return 0; }
															#line 3701 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<GetResolutionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetResolutionActorState();
		static_cast<GetResolutionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont11(std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> const& cipherKeys,int loopDepth) 
	{
															#line 1021 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->cipherKeys = cipherKeys;
															#line 3713 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont11(std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> && cipherKeys,int loopDepth) 
	{
															#line 1021 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->cipherKeys = cipherKeys;
															#line 3722 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> const& cipherKeys,int loopDepth) 
	{
		loopDepth = a_body1cont11(cipherKeys, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> && cipherKeys,int loopDepth) 
	{
		loopDepth = a_body1cont11(std::move(cipherKeys), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetResolutionActor*>(this)->actor_wait_state > 0) static_cast<GetResolutionActor*>(this)->actor_wait_state = 0;
		static_cast<GetResolutionActor*>(this)->ActorCallback< GetResolutionActor, 1, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >::remove();

	}
	void a_callback_fire(ActorCallback< GetResolutionActor, 1, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >*,std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> const& value) 
	{
		fdb_probe_actor_enter("getResolution", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getResolution", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetResolutionActor, 1, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >*,std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> && value) 
	{
		fdb_probe_actor_enter("getResolution", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getResolution", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetResolutionActor, 1, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >*,Error err) 
	{
		fdb_probe_actor_enter("getResolution", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getResolution", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 938 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitBatchContext* self;
															#line 939 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	double resolutionStart;
															#line 942 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCommitData* pProxyCommitData;
															#line 944 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Span span;
															#line 983 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Future<std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>>> getCipherKeys;
															#line 3812 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getResolution()
															#line 938 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class GetResolutionActor final : public Actor<Void>, public ActorCallback< GetResolutionActor, 0, std::vector<ResolveTransactionBatchReply> >, public ActorCallback< GetResolutionActor, 1, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >, public FastAllocated<GetResolutionActor>, public GetResolutionActorState<GetResolutionActor> {
															#line 3817 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetResolutionActor>::operator new;
	using FastAllocated<GetResolutionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4235826236499630336UL, 13265113495188757248UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetResolutionActor, 0, std::vector<ResolveTransactionBatchReply> >;
friend struct ActorCallback< GetResolutionActor, 1, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >;
															#line 938 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	GetResolutionActor(CommitBatchContext* const& self) 
															#line 3835 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   GetResolutionActorState<GetResolutionActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getResolution", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8033480777775786752UL, 12535296860845315328UL);
		ActorExecutionContextHelper __helper(static_cast<GetResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getResolution");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getResolution", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetResolutionActor, 0, std::vector<ResolveTransactionBatchReply> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetResolutionActor, 1, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 938 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> getResolution( CommitBatchContext* const& self ) {
															#line 938 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new GetResolutionActor(self));
															#line 3868 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 1026 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

void assertResolutionStateMutationsSizeConsistent(const std::vector<ResolveTransactionBatchReply>& resolution) {
	for (int r = 1; r < resolution.size(); r++) {
		ASSERT(resolution[r].stateMutations.size() == resolution[0].stateMutations.size());
		for (int s = 0; s < resolution[r].stateMutations.size(); s++) {
			ASSERT(resolution[r].stateMutations[s].size() == resolution[0].stateMutations[s].size());
		}
	}
}

// If the splitMutations is not empty, which means some clear range in mutations are split into multiple clear range
// ops. Modify mutations by replace the old clear range with the split clear ranges
void replaceRawClearRanges(Arena& arena,
                           VectorRef<MutationRef>& mutations,
                           std::vector<std::pair<int, std::vector<MutationRef>>>& splitMutations,
                           size_t totalSize,
                           Optional<UID> debugId = Optional<UID>()) {
	if (splitMutations.empty())
		return;

	int i = mutations.size() - 1;
	mutations.resize(arena, totalSize);
	// place from back
	int curr = totalSize - 1;
	for (; i >= 0; --i) {
		if (splitMutations.empty()) {
			ASSERT_EQ(curr, i);
			break;
		}

		if (splitMutations.back().first == i) {
			ASSERT_EQ(mutations[i].type, MutationRef::ClearRange);
			// TODO(gglass): legacy comment below references tenant. Possibly some
			// opportunity for simplification here. Legacy comment:
			// replace with tenant aligned mutations
			auto& currMutations = splitMutations.back().second;
			while (!currMutations.empty()) {
				mutations[curr] = currMutations.back();
				currMutations.pop_back();
				curr--;
			}
			splitMutations.pop_back();
		} else {
			ASSERT_GT(curr, i);
			mutations[curr] = mutations[i];
			curr--;
		}
	}

	ASSERT_EQ(splitMutations.size(), 0);
}
// Acknowledge transaction state store commits.
// Note: This acknowledgement will cause the transaction state store's popped version ("poppedUpTo", that's
// maintained in LogSystemDiskQueueAdapter) to get updated.
void acknowledgeTransactionStateStoreCommits(CommitBatchContext* self) {
	for (auto& p : self->storeCommits) {
		ASSERT(!p.second.isReady());
		p.first.get().acknowledge.send(Void());
		ASSERT(p.second.isReady());
	}
}

// Compute and apply "metadata" effects of each other proxy's most recent batch
void applyMetadataEffect(CommitBatchContext* self) {
	bool initialState = self->isMyFirstBatch;
	self->firstStateMutations = self->isMyFirstBatch;
	for (int versionIndex = 0; versionIndex < self->resolution[0].stateMutations.size(); versionIndex++) {
		// pProxyCommitData->logAdapter->setNextVersion( ??? );  << Ideally we would be telling the log adapter that the
		// pushes in this commit will be in the version at which these state mutations were committed by another proxy,
		// but at present we don't have that information here.  So the disk queue may be unnecessarily conservative
		// about popping.

		for (int transactionIndex = 0;
		     transactionIndex < self->resolution[0].stateMutations[versionIndex].size() && !self->forceRecovery;
		     transactionIndex++) {
			bool committed = true;
			for (int resolver = 0; resolver < self->resolution.size(); resolver++) {
				committed =
				    committed && self->resolution[resolver].stateMutations[versionIndex][transactionIndex].committed;
			}

			if (committed) {
				// Note: since we are not to commit, we don't need to pass cipherKeys for encryption.
				applyMetadataMutations(SpanContext(),
				                       *self->pProxyCommitData,
				                       self->arena,
				                       self->pProxyCommitData->logSystem,
				                       self->resolution[0].stateMutations[versionIndex][transactionIndex].mutations,
				                       /* pToCommit= */ nullptr,
				                       /* pCipherKeys= */ nullptr,
				                       EncryptionAtRestMode::DISABLED,
				                       self->forceRecovery,
				                       /* version= */ self->commitVersion,
				                       /* popVersion= */ 0,
				                       /* initialCommit */ false,
				                       /* provisionalCommitProxy */ self->pProxyCommitData->provisional);
			}

			if (self->resolution[0].stateMutations[versionIndex][transactionIndex].mutations.size() &&
			    self->firstStateMutations) {
				ASSERT(committed);
				self->firstStateMutations = false;
				self->forceRecovery = false;
			}
		}
		// These changes to txnStateStore will be committed by the other proxy, so we simply discard the commit message
		auto fcm = self->pProxyCommitData->logAdapter->getCommitMessage();
		self->storeCommits.emplace_back(fcm, self->pProxyCommitData->txnStateStore->commit());

		if (initialState) {
			initialState = false;
			self->forceRecovery = false;
			self->pProxyCommitData->txnStateStore->resyncLog();

			acknowledgeTransactionStateStoreCommits(self);
			self->storeCommits.clear();
		}
	}
}

/// Determine which transactions actually committed (conservatively) by combining results from the resolvers
void determineCommittedTransactions(CommitBatchContext* self) {
	auto pProxyCommitData = self->pProxyCommitData;
	const auto& trs = self->trs;

	ASSERT(self->transactionResolverMap.size() == self->committed.size());
	// For each commitTransactionRef, it is only sent to resolvers specified in transactionResolverMap
	// Thus, we use this nextTr to track the correct transaction index on each resolver.
	self->nextTr.resize(self->resolution.size());
	for (int t = 0; t < trs.size(); t++) {
		uint8_t commit = ConflictBatch::TransactionCommitted;
		for (int r : self->transactionResolverMap[t]) {
			commit = std::min(self->resolution[r].committed[self->nextTr[r]++], commit);
		}
		self->committed[t] = commit;
	}
	for (int r = 0; r < self->resolution.size(); r++)
		ASSERT(self->nextTr[r] == self->resolution[r].committed.size());

	pProxyCommitData->logAdapter->setNextVersion(self->commitVersion);

	self->lockedKey = pProxyCommitData->txnStateStore->readValue(databaseLockedKey).get();
	self->locked = self->lockedKey.present() && self->lockedKey.get().size();

	const Optional<Value> mustContainSystemKey =
	    pProxyCommitData->txnStateStore->readValue(mustContainSystemMutationsKey).get();
	if (mustContainSystemKey.present() && mustContainSystemKey.get().size()) {
		for (int t = 0; t < trs.size(); t++) {
			if (self->committed[t] == ConflictBatch::TransactionCommitted) {
				bool foundSystem = false;
				for (auto& m : trs[t].transaction.mutations) {
					if ((m.type == MutationRef::ClearRange ? m.param2 : m.param1) >= nonMetadataSystemKeys.end) {
						foundSystem = true;
						break;
					}
				}
				if (!foundSystem) {
					self->committed[t] = ConflictBatch::TransactionConflict;
				}
			}
		}
	}
}

// This first pass through committed transactions deals with "metadata" effects (modifications of txnStateStore, changes
// to storage servers' responsibilities)
															#line 4038 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
// This generated class is to be used only via applyMetadataToCommittedTransactions()
															#line 1192 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class ApplyMetadataToCommittedTransactionsActor>
															#line 1192 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class ApplyMetadataToCommittedTransactionsActorState {
															#line 4044 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 1192 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ApplyMetadataToCommittedTransactionsActorState(CommitBatchContext* const& self) 
															#line 1192 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 1192 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : self(self),
															#line 1193 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   pProxyCommitData(self->pProxyCommitData)
															#line 4053 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("applyMetadataToCommittedTransactions", reinterpret_cast<unsigned long>(this));

	}
	~ApplyMetadataToCommittedTransactionsActorState() 
	{
		fdb_probe_actor_destroy("applyMetadataToCommittedTransactions", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1194 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			auto& trs = self->trs;
															#line 1196 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			int t;
															#line 1197 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for(t = 0;t < trs.size() && !self->forceRecovery;t++) {
															#line 1198 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (self->committed[t] == ConflictBatch::TransactionCommitted && (!self->locked || trs[t].isLockAware()))
															#line 4074 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				{
															#line 1199 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					self->commitCount++;
															#line 1200 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					applyMetadataMutations(trs[t].spanContext, *pProxyCommitData, self->arena, pProxyCommitData->logSystem, trs[t].transaction.mutations, SERVER_KNOBS->PROXY_USE_RESOLVER_PRIVATE_MUTATIONS ? nullptr : &self->toCommit, &self->cipherKeys, pProxyCommitData->encryptMode, self->forceRecovery, self->commitVersion, self->commitVersion + 1, false, self->pProxyCommitData->provisional);
															#line 4080 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				}
															#line 1215 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (self->firstStateMutations)
															#line 4084 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				{
															#line 1216 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					ASSERT(self->committed[t] == ConflictBatch::TransactionCommitted);
															#line 1217 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					self->firstStateMutations = false;
															#line 1218 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					self->forceRecovery = false;
															#line 4092 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				}
			}
															#line 1222 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (self->forceRecovery)
															#line 4097 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 1223 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				for(;t < trs.size();t++) {
															#line 1224 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					self->committed[t] = ConflictBatch::TransactionConflict;
															#line 4103 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				}
															#line 1225 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				TraceEvent(SevWarn, "RestartingTxnSubsystem", pProxyCommitData->dbgid).detail("Stage", "AwaitCommit");
															#line 4107 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 1227 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (SERVER_KNOBS->PROXY_USE_RESOLVER_PRIVATE_MUTATIONS)
															#line 4111 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 1230 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				ResolveTransactionBatchReply& reply = self->resolution[0];
															#line 1231 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				self->toCommit.setMutations(reply.privateMutationCount, reply.privateMutations);
															#line 1232 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST)
															#line 4119 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				{
															#line 1234 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					self->tpcvMap = reply.tpcvMap;
															#line 1235 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					self->pProxyCommitData->lastShardMove = reply.lastShardMove;
															#line 1238 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					std::vector<int> fromLocations;
															#line 1239 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					fromLocations.reserve(reply.tpcvMap.size());
															#line 1240 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					for( const auto& pair : self->tpcvMap ) {
															#line 1241 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						fromLocations.push_back(pair.first);
															#line 4133 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					}
															#line 1244 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					self->toCommit.setPushLocationsForTags(fromLocations);
															#line 4137 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				}
															#line 1246 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				self->toCommit.addWrittenTags(reply.writtenTags);
															#line 4141 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 1249 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->lockedKey = pProxyCommitData->txnStateStore->readValue(databaseLockedKey).get();
															#line 1250 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->lockedAfter = self->lockedKey.present() && self->lockedKey.get().size();
															#line 1252 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->metadataVersionAfter = pProxyCommitData->txnStateStore->readValue(metadataVersionKey).get();
															#line 1254 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			auto fcm = pProxyCommitData->logAdapter->getCommitMessage();
															#line 1255 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->storeCommits.emplace_back(fcm, pProxyCommitData->txnStateStore->commit());
															#line 1256 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->version.set(self->commitVersion);
															#line 1257 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (!pProxyCommitData->validState.isSet())
															#line 4157 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 1258 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				pProxyCommitData->validState.send(Void());
															#line 4161 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 1259 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT(self->commitVersion);
															#line 1261 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (!self->isMyFirstBatch && pProxyCommitData->txnStateStore->readValue(coordinatorsKey).get().get() != self->previousCoordinators.get())
															#line 4167 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 1263 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				StrictFuture<Void> __when_expr_0 = brokenPromiseToNever(pProxyCommitData->db->get().clusterInterface.changeCoordinators.getReply( ChangeCoordinatorsRequest(pProxyCommitData->txnStateStore->readValue(coordinatorsKey).get().get(), self->pProxyCommitData->master.id())));
															#line 1263 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (static_cast<ApplyMetadataToCommittedTransactionsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4173 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ApplyMetadataToCommittedTransactionsActor*>(this)->actor_wait_state = 1;
															#line 1263 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ApplyMetadataToCommittedTransactionsActor, 0, Void >*>(static_cast<ApplyMetadataToCommittedTransactionsActor*>(this)));
															#line 4178 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ApplyMetadataToCommittedTransactionsActorState();
		static_cast<ApplyMetadataToCommittedTransactionsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1269 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<ApplyMetadataToCommittedTransactionsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ApplyMetadataToCommittedTransactionsActorState(); static_cast<ApplyMetadataToCommittedTransactionsActor*>(this)->destroy(); return 0; }
															#line 4206 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<ApplyMetadataToCommittedTransactionsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ApplyMetadataToCommittedTransactionsActorState();
		static_cast<ApplyMetadataToCommittedTransactionsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont11(Void const& _,int loopDepth) 
	{
															#line 1266 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT(false);
															#line 4218 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11(Void && _,int loopDepth) 
	{
															#line 1266 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT(false);
															#line 4227 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ApplyMetadataToCommittedTransactionsActor*>(this)->actor_wait_state > 0) static_cast<ApplyMetadataToCommittedTransactionsActor*>(this)->actor_wait_state = 0;
		static_cast<ApplyMetadataToCommittedTransactionsActor*>(this)->ActorCallback< ApplyMetadataToCommittedTransactionsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ApplyMetadataToCommittedTransactionsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("applyMetadataToCommittedTransactions", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ApplyMetadataToCommittedTransactionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("applyMetadataToCommittedTransactions", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ApplyMetadataToCommittedTransactionsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("applyMetadataToCommittedTransactions", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ApplyMetadataToCommittedTransactionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("applyMetadataToCommittedTransactions", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ApplyMetadataToCommittedTransactionsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("applyMetadataToCommittedTransactions", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ApplyMetadataToCommittedTransactionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("applyMetadataToCommittedTransactions", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1192 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitBatchContext* self;
															#line 1193 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCommitData* const pProxyCommitData;
															#line 4311 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via applyMetadataToCommittedTransactions()
															#line 1192 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class ApplyMetadataToCommittedTransactionsActor final : public Actor<Void>, public ActorCallback< ApplyMetadataToCommittedTransactionsActor, 0, Void >, public FastAllocated<ApplyMetadataToCommittedTransactionsActor>, public ApplyMetadataToCommittedTransactionsActorState<ApplyMetadataToCommittedTransactionsActor> {
															#line 4316 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<ApplyMetadataToCommittedTransactionsActor>::operator new;
	using FastAllocated<ApplyMetadataToCommittedTransactionsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(686530382861716992UL, 1971742148503192064UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ApplyMetadataToCommittedTransactionsActor, 0, Void >;
															#line 1192 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ApplyMetadataToCommittedTransactionsActor(CommitBatchContext* const& self) 
															#line 4333 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ApplyMetadataToCommittedTransactionsActorState<ApplyMetadataToCommittedTransactionsActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("applyMetadataToCommittedTransactions", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6741896898587633920UL, 3623984856983436288UL);
		ActorExecutionContextHelper __helper(static_cast<ApplyMetadataToCommittedTransactionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("applyMetadataToCommittedTransactions");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("applyMetadataToCommittedTransactions", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ApplyMetadataToCommittedTransactionsActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1192 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> applyMetadataToCommittedTransactions( CommitBatchContext* const& self ) {
															#line 1192 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new ApplyMetadataToCommittedTransactionsActor(self));
															#line 4365 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 1271 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

WriteMutationRefVar writeMutation(CommitBatchContext* self, const MutationRef* mutation) {
	self->toCommit.writeTypedMessage(*mutation);
	return std::variant<MutationRef, VectorRef<MutationRef>>{ *mutation };
}

void pushToBackupMutations(CommitBatchContext* self,
                           ProxyCommitData* const pProxyCommitData,
                           Arena& arena,
                           MutationRef const& m,
                           MutationRef const& writtenMutation,
                           Optional<MutationRef> const& encryptedMutation) {
	if (m.type != MutationRef::Type::ClearRange) {
		ASSERT(!pProxyCommitData->encryptMode.isEncryptionEnabled() || writtenMutation.isEncrypted());

		// Add the mutation to the relevant backup tag
		for (auto backupName : pProxyCommitData->vecBackupKeys[m.param1]) {
			// If encryption is enabled make sure the mutation we are writing is also encrypted
			CODE_PROBE(writtenMutation.isEncrypted(), "using encrypted backup mutation", probe::decoration::rare);
			self->logRangeMutations[backupName].push_back_deep(self->logRangeMutationsArena, writtenMutation);
		}
	} else {
		KeyRangeRef mutationRange(m.param1, m.param2);
		KeyRangeRef intersectionRange;

		// Identify and add the intersecting ranges of the mutation to the array of mutations to serialize
		for (auto backupRange : pProxyCommitData->vecBackupKeys.intersectingRanges(mutationRange)) {
			// Get the backup sub range
			const auto& backupSubrange = backupRange.range();

			// Determine the intersecting range
			intersectionRange = mutationRange & backupSubrange;

			// Create the custom mutation for the specific backup tag
			MutationRef backupMutation(MutationRef::Type::ClearRange, intersectionRange.begin, intersectionRange.end);

			if (pProxyCommitData->encryptMode.isEncryptionEnabled()) {
				CODE_PROBE(true, "encrypting clear range backup mutation", probe::decoration::rare);
				if (backupMutation.param1 == m.param1 && backupMutation.param2 == m.param2 &&
				    encryptedMutation.present()) {
					backupMutation = encryptedMutation.get();
				} else {
					EncryptCipherDomainId domainId = getEncryptDetailsFromMutationRef(pProxyCommitData, backupMutation);
					double encryptionTimeV = 0;
					backupMutation = backupMutation.encrypt(
					    self->cipherKeys, domainId, arena, BlobCipherMetrics::BACKUP, &encryptionTimeV);
				}
			}
			ASSERT(!pProxyCommitData->encryptMode.isEncryptionEnabled() || backupMutation.isEncrypted());

			// Add the mutation to the relevant backup tag
			for (auto backupName : backupRange.value()) {
				self->logRangeMutations[backupName].push_back_deep(self->logRangeMutationsArena, backupMutation);
			}
		}
	}
}

void addAccumulativeChecksumMutations(CommitBatchContext* self) {
	ASSERT(self->pProxyCommitData->acsBuilder != nullptr);
	const uint16_t acsIndex = getCommitProxyAccumulativeChecksumIndex(self->pProxyCommitData->commitProxyIndex);
	for (const auto& [tag, acsState] : self->pProxyCommitData->acsBuilder->getAcsTable()) {
		ASSERT(tagSupportAccumulativeChecksum(tag));
		ASSERT(acsState.version <= self->commitVersion);
		if (acsState.version < self->commitVersion) {
			// Have not updated in the current commit batch
			// So, need not send acs mutation for this tag
			continue;
		}
		ASSERT(acsState.epoch == self->pProxyCommitData->epoch);
		MutationRef acsMutation;
		acsMutation.type = MutationRef::SetValue;
		acsMutation.param1 = accumulativeChecksumKey; // private mutation
		AccumulativeChecksumState acsToSend(acsIndex, acsState.acs, self->commitVersion, self->pProxyCommitData->epoch);
		Value acsValue = accumulativeChecksumValue(acsToSend);
		acsMutation.param2 = acsValue;
		acsMutation.setAccumulativeChecksumIndex(acsIndex);
		if (CLIENT_KNOBS->ENABLE_ACCUMULATIVE_CHECKSUM_LOGGING) {
			TraceEvent(SevInfo, "AcsBuilderIssueAccumulativeChecksumMutation", self->pProxyCommitData->dbgid)
			    .detail("AcsTag", tag)
			    .detail("AcsIndex", acsIndex)
			    .detail("AcsToSend", acsToSend.toString())
			    .detail("Mutation", acsMutation)
			    .detail("Version", self->commitVersion)
			    .detail("CommitProxyIndex", self->pProxyCommitData->commitProxyIndex);
		}
		DEBUG_MUTATION("ProxyCommit", self->commitVersion, acsMutation, self->pProxyCommitData->dbgid);
		self->toCommit.addTag(tag);
		self->toCommit.writeTypedMessage(acsMutation);
	}
}
// RangeLock takes effect only when the feature flag is on and database is unlocked and the mutation is not encrypted
void rejectMutationsForReadLockOnRange(CommitBatchContext* self) {
	ASSERT(self->rangeLockEnabled());
	ProxyCommitData* const pProxyCommitData = self->pProxyCommitData;
	ASSERT(pProxyCommitData->rangeLock != nullptr);
	std::vector<CommitTransactionRequest>& trs = self->trs;
	for (int i = self->transactionNum; i < trs.size(); i++) {
		if (self->committed[i] != ConflictBatch::TransactionCommitted) {
			continue;
		} else if (trs[i].isLockAware()) {
			continue; // rangeLock is transparent to lock-aware transactions
		}
		VectorRef<MutationRef>* pMutations = &trs[i].transaction.mutations;
		bool transactionRejected = false;
		for (int j = 0; j < pMutations->size(); j++) {
			MutationRef m = (*pMutations)[j];
			ASSERT_WE_THINK(!m.isEncrypted());
			if (m.isEncrypted()) {
				continue;
			}
			KeyRange rangeToCheck;
			if (isSingleKeyMutation((MutationRef::Type)m.type)) {
				rangeToCheck = singleKeyRange(m.param1);
			} else if (m.type == MutationRef::ClearRange) {
				rangeToCheck = KeyRangeRef(m.param1, m.param2);
			}
			bool shouldReject = pProxyCommitData->rangeLock->isLocked(rangeToCheck);
			if (shouldReject) {
				self->committed[i] = ConflictBatch::TransactionLockReject;
				trs[i].reply.sendError(transaction_rejected_range_locked());
				transactionRejected = true;
			}
			if (transactionRejected) {
				break;
			}
		}
	}
	return;
}

/// This second pass through committed transactions assigns the actual mutations to the appropriate storage servers'
/// tags
															#line 4502 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
// This generated class is to be used only via assignMutationsToStorageServers()
															#line 1404 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class AssignMutationsToStorageServersActor>
															#line 1404 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class AssignMutationsToStorageServersActorState {
															#line 4508 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 1404 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	AssignMutationsToStorageServersActorState(CommitBatchContext* const& self) 
															#line 1404 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 1404 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : self(self),
															#line 1405 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   pProxyCommitData(self->pProxyCommitData),
															#line 1406 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   trs(self->trs)
															#line 4519 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("assignMutationsToStorageServers", reinterpret_cast<unsigned long>(this));

	}
	~AssignMutationsToStorageServersActorState() 
	{
		fdb_probe_actor_destroy("assignMutationsToStorageServers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1408 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			;
															#line 4534 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AssignMutationsToStorageServersActorState();
		static_cast<AssignMutationsToStorageServersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1613 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<AssignMutationsToStorageServersActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AssignMutationsToStorageServersActorState(); static_cast<AssignMutationsToStorageServersActor*>(this)->destroy(); return 0; }
															#line 4557 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<AssignMutationsToStorageServersActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~AssignMutationsToStorageServersActorState();
		static_cast<AssignMutationsToStorageServersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1408 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!(self->transactionNum < trs.size()))
															#line 4576 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1409 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!(self->committed[self->transactionNum] == ConflictBatch::TransactionCommitted && (!self->locked || trs[self->transactionNum].isLockAware())))
															#line 4582 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
			return a_body1continue1(loopDepth); // continue
		}
															#line 1414 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		checkSample = trs[self->transactionNum].commitCostEstimation.present();
															#line 1415 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		trCost = &trs[self->transactionNum].commitCostEstimation;
															#line 1416 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		mutationNum = 0;
															#line 1417 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pMutations = &trs[self->transactionNum].transaction.mutations;
															#line 1418 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		encryptedMutations = &trs[self->transactionNum].transaction.encryptedMutations;
															#line 1421 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!encryptedMutations->empty())
															#line 4598 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1422 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT_EQ(encryptedMutations->size(), pMutations->size());
															#line 4602 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 1425 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		encryptDomain = FDB_DEFAULT_ENCRYPT_DOMAIN_ID;
															#line 1426 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->toCommit.addTransactionInfo(trs[self->transactionNum].spanContext);
															#line 1428 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		;
															#line 4610 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1continue1(int loopDepth) 
	{
															#line 1408 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->transactionNum++;
															#line 4632 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 1607 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (checkSample)
															#line 4641 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1608 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->pProxyCommitData->stats.txnExpensiveClearCostEstCount += trs[self->transactionNum].commitCostEstimation.get().expensiveCostEstCount;
															#line 4645 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 1408 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->transactionNum++;
															#line 4649 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 1428 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!(mutationNum < pMutations->size()))
															#line 4665 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1429 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (self->yieldBytes > SERVER_KNOBS->DESIRED_TOTAL_BYTES)
															#line 4671 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1430 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->yieldBytes = 0;
															#line 1431 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (g_network->check_yield(TaskPriority::ProxyCommitYield1))
															#line 4677 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 1432 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				self->computeDuration += g_network->timer_monotonic() - self->computeStart;
															#line 1433 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(0, TaskPriority::ProxyCommitYield1);
															#line 1433 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (static_cast<AssignMutationsToStorageServersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 4685 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
				static_cast<AssignMutationsToStorageServersActor*>(this)->actor_wait_state = 1;
															#line 1433 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AssignMutationsToStorageServersActor, 0, Void >*>(static_cast<AssignMutationsToStorageServersActor*>(this)));
															#line 4690 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1continue1(int loopDepth) 
	{
															#line 1428 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		mutationNum++;
															#line 4722 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
															#line 1438 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		m = (*pMutations)[mutationNum];
															#line 1439 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		encryptedMutation = encryptedMutations->size() > 0 ? (*encryptedMutations)[mutationNum] : Optional<MutationRef>();
															#line 1441 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		arena = Arena();
															#line 1442 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		writtenMutation = MutationRef();
															#line 1443 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->mutationCount++;
															#line 1444 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->mutationBytes += m.expectedSize();
															#line 1445 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->yieldBytes += m.expectedSize();
															#line 1446 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT(!m.isEncrypted());
															#line 1449 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (isSingleKeyMutation((MutationRef::Type)m.type))
															#line 4747 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1450 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			auto& tags = pProxyCommitData->tagsForKey(m.param1);
															#line 1454 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (checkSample)
															#line 4753 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 1455 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				double totalCosts = trCost->get().writeCosts;
															#line 1456 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				double cost = getWriteOperationCost(m.expectedSize());
															#line 1457 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				double mul = std::max(1.0, totalCosts / std::max(1.0, (double)CLIENT_KNOBS->COMMIT_SAMPLE_COST));
															#line 1458 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				ASSERT(totalCosts > 0);
															#line 1459 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				double prob = mul * cost / totalCosts;
															#line 1461 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (deterministicRandom()->random01() < prob)
															#line 4767 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				{
															#line 1462 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					const auto& storageServers = pProxyCommitData->keyInfo[m.param1].src_info;
															#line 1463 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					for( const auto& ssInfo : storageServers ) {
															#line 1464 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						auto id = ssInfo->interf.id();
															#line 1466 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						cost = cost < CLIENT_KNOBS->COMMIT_SAMPLE_COST ? CLIENT_KNOBS->COMMIT_SAMPLE_COST : cost;
															#line 1467 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						pProxyCommitData->updateSSTagCost( id, trs[self->transactionNum].tagSet.get(), m, cost / storageServers.size());
															#line 4779 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					}
				}
			}
															#line 1473 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (pProxyCommitData->singleKeyMutationEvent->enabled)
															#line 4785 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 1474 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				KeyRangeRef shard = pProxyCommitData->keyInfo.rangeContaining(m.param1).range();
															#line 1475 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				pProxyCommitData->singleKeyMutationEvent->tag1 = (int64_t)tags[0].id;
															#line 1476 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				pProxyCommitData->singleKeyMutationEvent->tag2 = (int64_t)tags[1].id;
															#line 1477 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				pProxyCommitData->singleKeyMutationEvent->tag3 = (int64_t)tags[2].id;
															#line 1478 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				pProxyCommitData->singleKeyMutationEvent->shardBegin = shard.begin;
															#line 1479 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				pProxyCommitData->singleKeyMutationEvent->shardEnd = shard.end;
															#line 1480 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				pProxyCommitData->singleKeyMutationEvent->log();
															#line 4801 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 1483 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			DEBUG_MUTATION("ProxyCommit", self->commitVersion, m, pProxyCommitData->dbgid).detail("To", tags);
															#line 1484 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->toCommit.addTags(tags);
															#line 1485 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (encryptedMutation.present())
															#line 4809 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 1486 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				ASSERT(encryptedMutation.get().isEncrypted());
															#line 4813 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 1489 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (pProxyCommitData->acsBuilder != nullptr)
															#line 4817 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 1490 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				updateMutationWithAcsAndAddMutationToAcsBuilder( pProxyCommitData->acsBuilder, m, tags, getCommitProxyAccumulativeChecksumIndex(pProxyCommitData->commitProxyIndex), pProxyCommitData->epoch, self->commitVersion, pProxyCommitData->dbgid);
															#line 4821 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 1500 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			WriteMutationRefVar var = writeMutation(self, &m);
															#line 1502 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT(std::holds_alternative<MutationRef>(var));
															#line 1503 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			writtenMutation = std::get<MutationRef>(var);
															#line 4829 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		else
		{
															#line 1504 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (m.type == MutationRef::ClearRange)
															#line 4835 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 1505 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				auto range = pProxyCommitData->keyInfo.rangeContaining(m.param1);
															#line 1506 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (range.end() >= m.param2)
															#line 4841 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				{
															#line 1508 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					DEBUG_MUTATION("ProxyCommit", self->commitVersion, m, pProxyCommitData->dbgid) .detail("To", range.value().tags);
															#line 1510 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					range.value().populateTags();
															#line 1511 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					self->toCommit.addTags(range.value().tags);
															#line 1513 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					if (pProxyCommitData->acsBuilder != nullptr)
															#line 4851 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					{
															#line 1514 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						updateMutationWithAcsAndAddMutationToAcsBuilder( pProxyCommitData->acsBuilder, m, range.value().tags, getCommitProxyAccumulativeChecksumIndex(pProxyCommitData->commitProxyIndex), pProxyCommitData->epoch, self->commitVersion, pProxyCommitData->dbgid);
															#line 4855 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					}
															#line 1525 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					if (checkSample && !trCost->get().clearIdxCosts.empty() && trCost->get().clearIdxCosts[0].first == mutationNum)
															#line 4859 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					{
															#line 1527 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						auto const& ssInfos = range.value().src_info;
															#line 1528 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						for( auto const& ssInfo : ssInfos ) {
															#line 1529 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							auto id = ssInfo->interf.id();
															#line 1530 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							pProxyCommitData->updateSSTagCost(id, trs[self->transactionNum].tagSet.get(), m, trCost->get().clearIdxCosts[0].second / ssInfos.size());
															#line 4869 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
						}
															#line 1535 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						trCost->get().clearIdxCosts.pop_front();
															#line 4873 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					}
				}
				else
				{
															#line 1538 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					CODE_PROBE(true, "A clear range extends past a shard boundary");
															#line 1539 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					std::set<Tag> allSources;
															#line 1540 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					for(;range.begin() < m.param2;) {
															#line 1541 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						range.value().populateTags();
															#line 1542 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						allSources.insert(range.value().tags.begin(), range.value().tags.end());
															#line 1545 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						if (checkSample && !trCost->get().clearIdxCosts.empty() && trCost->get().clearIdxCosts[0].first == mutationNum)
															#line 4890 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
						{
															#line 1547 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							auto const& ssInfos = range.value().src_info;
															#line 1548 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							for( auto const& ssInfo : ssInfos ) {
															#line 1549 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
								auto id = ssInfo->interf.id();
															#line 1550 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
								pProxyCommitData->updateSSTagCost(id, trs[self->transactionNum].tagSet.get(), m, trCost->get().clearIdxCosts[0].second / ssInfos.size());
															#line 4900 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
							}
															#line 1556 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							trCost->get().clearIdxCosts.pop_front();
															#line 4904 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
						}
															#line 1558 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						++range;
															#line 4908 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					}
															#line 1561 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					DEBUG_MUTATION("ProxyCommit", self->commitVersion, m) .detail("Dbgid", pProxyCommitData->dbgid) .detail("To", allSources);
															#line 1564 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					self->toCommit.addTags(allSources);
															#line 1566 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					if (self->pProxyCommitData->acsBuilder != nullptr)
															#line 4916 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					{
															#line 1567 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						updateMutationWithAcsAndAddMutationToAcsBuilder( pProxyCommitData->acsBuilder, m, allSources, getCommitProxyAccumulativeChecksumIndex(pProxyCommitData->commitProxyIndex), pProxyCommitData->epoch, self->commitVersion, pProxyCommitData->dbgid);
															#line 4920 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					}
				}
															#line 1578 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				KeyRangeRef clearRange(KeyRangeRef(m.param1, m.param2));
															#line 1579 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				WriteMutationRefVar var = writeMutation(self, &m);
															#line 1581 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				ASSERT(std::holds_alternative<MutationRef>(var));
															#line 1582 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				writtenMutation = std::get<MutationRef>(var);
															#line 4931 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1583 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (m.type == MutationRef::NoOp)
															#line 4937 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				{
															#line 1587 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					ASSERT(false);
															#line 4941 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					return a_body1loopBody1continue1(loopDepth); // continue
				}
				else
				{
															#line 1590 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					UNREACHABLE();
															#line 4948 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				}
			}
		}
															#line 1593 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		DisabledTraceEvent(SevDebug, "BeforeBackup", pProxyCommitData->dbgid) .detail("M1", m.param1) .detail("M2", m.param2) .detail("MT", getTypeString(m.type)) .detail("VecBackupKeys", pProxyCommitData->vecBackupKeys.size()) .detail("ShouldBackup", shouldBackup(m));
															#line 1600 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (pProxyCommitData->vecBackupKeys.size() <= 1 || !shouldBackup(m))
															#line 4956 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1continue1(loopDepth); // continue
		}
															#line 1604 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pushToBackupMutations(self, pProxyCommitData, arena, m, writtenMutation, encryptedMutation);
															#line 1428 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		mutationNum++;
															#line 4964 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 1434 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->computeStart = g_network->timer_monotonic();
															#line 4979 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 1434 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->computeStart = g_network->timer_monotonic();
															#line 4988 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AssignMutationsToStorageServersActor*>(this)->actor_wait_state > 0) static_cast<AssignMutationsToStorageServersActor*>(this)->actor_wait_state = 0;
		static_cast<AssignMutationsToStorageServersActor*>(this)->ActorCallback< AssignMutationsToStorageServersActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AssignMutationsToStorageServersActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("assignMutationsToStorageServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AssignMutationsToStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assignMutationsToStorageServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AssignMutationsToStorageServersActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("assignMutationsToStorageServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AssignMutationsToStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assignMutationsToStorageServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AssignMutationsToStorageServersActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("assignMutationsToStorageServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AssignMutationsToStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assignMutationsToStorageServers", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1404 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitBatchContext* self;
															#line 1405 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCommitData* const pProxyCommitData;
															#line 1406 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	std::vector<CommitTransactionRequest>& trs;
															#line 1414 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	bool checkSample;
															#line 1415 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Optional<ClientTrCommitCostEstimation>* trCost;
															#line 1416 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	int mutationNum;
															#line 1417 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	VectorRef<MutationRef>* pMutations;
															#line 1418 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	VectorRef<Optional<MutationRef>>* encryptedMutations;
															#line 1425 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	int64_t encryptDomain;
															#line 1438 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	MutationRef m;
															#line 1439 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Optional<MutationRef> encryptedMutation;
															#line 1441 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Arena arena;
															#line 1442 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	MutationRef writtenMutation;
															#line 5094 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via assignMutationsToStorageServers()
															#line 1404 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class AssignMutationsToStorageServersActor final : public Actor<Void>, public ActorCallback< AssignMutationsToStorageServersActor, 0, Void >, public FastAllocated<AssignMutationsToStorageServersActor>, public AssignMutationsToStorageServersActorState<AssignMutationsToStorageServersActor> {
															#line 5099 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<AssignMutationsToStorageServersActor>::operator new;
	using FastAllocated<AssignMutationsToStorageServersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16640924042856236800UL, 17294179827492860416UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AssignMutationsToStorageServersActor, 0, Void >;
															#line 1404 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	AssignMutationsToStorageServersActor(CommitBatchContext* const& self) 
															#line 5116 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   AssignMutationsToStorageServersActorState<AssignMutationsToStorageServersActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("assignMutationsToStorageServers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9890514799402802944UL, 16180603176411543808UL);
		ActorExecutionContextHelper __helper(static_cast<AssignMutationsToStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("assignMutationsToStorageServers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("assignMutationsToStorageServers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AssignMutationsToStorageServersActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1404 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> assignMutationsToStorageServers( CommitBatchContext* const& self ) {
															#line 1404 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new AssignMutationsToStorageServersActor(self));
															#line 5148 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 1615 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

															#line 5153 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
// This generated class is to be used only via postResolution()
															#line 1616 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class PostResolutionActor>
															#line 1616 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class PostResolutionActorState {
															#line 5159 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 1616 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	PostResolutionActorState(CommitBatchContext* const& self) 
															#line 1616 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 1616 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : self(self),
															#line 1617 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   postResolutionStart(g_network->timer_monotonic()),
															#line 1618 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   pProxyCommitData(self->pProxyCommitData),
															#line 1619 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   trs(self->trs),
															#line 1620 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   localBatchNumber(self->localBatchNumber),
															#line 1621 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   debugID(self->debugID),
															#line 1622 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   span("MP:postResolution"_loc, self->span.context)
															#line 5178 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("postResolution", reinterpret_cast<unsigned long>(this));

	}
	~PostResolutionActorState() 
	{
		fdb_probe_actor_destroy("postResolution", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1624 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			bool queuedCommits = pProxyCommitData->latestLocalCommitBatchLogging.get() < localBatchNumber - 1;
															#line 1625 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			CODE_PROBE(queuedCommits, "Queuing post-resolution commit processing");
															#line 1626 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = pProxyCommitData->latestLocalCommitBatchLogging.whenAtLeast(localBatchNumber - 1);
															#line 1626 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<PostResolutionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5199 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PostResolutionActor*>(this)->actor_wait_state = 1;
															#line 1626 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PostResolutionActor, 0, Void >*>(static_cast<PostResolutionActor*>(this)));
															#line 5204 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PostResolutionActorState();
		static_cast<PostResolutionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1627 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		postResolutionQueuing = g_network->timer_monotonic();
															#line 1628 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.postResolutionDist->sampleSeconds(postResolutionQueuing - postResolutionStart);
															#line 1629 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = yield(TaskPriority::ProxyCommitYield1);
															#line 1629 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<PostResolutionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5233 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<PostResolutionActor*>(this)->actor_wait_state = 2;
															#line 1629 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PostResolutionActor, 1, Void >*>(static_cast<PostResolutionActor*>(this)));
															#line 5238 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1627 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		postResolutionQueuing = g_network->timer_monotonic();
															#line 1628 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.postResolutionDist->sampleSeconds(postResolutionQueuing - postResolutionStart);
															#line 1629 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = yield(TaskPriority::ProxyCommitYield1);
															#line 1629 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<PostResolutionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5253 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<PostResolutionActor*>(this)->actor_wait_state = 2;
															#line 1629 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PostResolutionActor, 1, Void >*>(static_cast<PostResolutionActor*>(this)));
															#line 5258 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PostResolutionActor*>(this)->actor_wait_state > 0) static_cast<PostResolutionActor*>(this)->actor_wait_state = 0;
		static_cast<PostResolutionActor*>(this)->ActorCallback< PostResolutionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PostResolutionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1631 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->computeStart = g_network->timer_monotonic();
															#line 1633 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.txnCommitResolved += trs.size();
															#line 1635 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (debugID.present())
															#line 5346 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1636 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			g_traceBatch.addEvent( "CommitDebug", debugID.get().first(), "CommitProxyServer.commitBatch.ProcessingMutations");
															#line 5350 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 1640 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->isMyFirstBatch = !pProxyCommitData->version.get();
															#line 1641 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->previousCoordinators = pProxyCommitData->txnStateStore->readValue(coordinatorsKey).get();
															#line 1643 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		assertResolutionStateMutationsSizeConsistent(self->resolution);
															#line 1645 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		applyMetadataEffect(self);
															#line 1647 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (debugID.present())
															#line 5362 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1648 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			g_traceBatch.addEvent( "CommitDebug", debugID.get().first(), "CommitProxyServer.commitBatch.ApplyMetadataEffect");
															#line 5366 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 1652 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		determineCommittedTransactions(self);
															#line 1654 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (debugID.present())
															#line 5372 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1655 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			g_traceBatch.addEvent( "CommitDebug", debugID.get().first(), "CommitProxyServer.commitBatch.DetermineCommittedTransactions");
															#line 5376 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 1659 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (self->forceRecovery)
															#line 5380 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1660 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_2 = Future<Void>(Never());
															#line 1660 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<PostResolutionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5386 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<PostResolutionActor*>(this)->actor_wait_state = 3;
															#line 1660 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PostResolutionActor, 2, Void >*>(static_cast<PostResolutionActor*>(this)));
															#line 5391 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1631 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->computeStart = g_network->timer_monotonic();
															#line 1633 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.txnCommitResolved += trs.size();
															#line 1635 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (debugID.present())
															#line 5409 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1636 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			g_traceBatch.addEvent( "CommitDebug", debugID.get().first(), "CommitProxyServer.commitBatch.ProcessingMutations");
															#line 5413 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 1640 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->isMyFirstBatch = !pProxyCommitData->version.get();
															#line 1641 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->previousCoordinators = pProxyCommitData->txnStateStore->readValue(coordinatorsKey).get();
															#line 1643 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		assertResolutionStateMutationsSizeConsistent(self->resolution);
															#line 1645 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		applyMetadataEffect(self);
															#line 1647 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (debugID.present())
															#line 5425 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1648 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			g_traceBatch.addEvent( "CommitDebug", debugID.get().first(), "CommitProxyServer.commitBatch.ApplyMetadataEffect");
															#line 5429 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 1652 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		determineCommittedTransactions(self);
															#line 1654 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (debugID.present())
															#line 5435 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1655 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			g_traceBatch.addEvent( "CommitDebug", debugID.get().first(), "CommitProxyServer.commitBatch.DetermineCommittedTransactions");
															#line 5439 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 1659 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (self->forceRecovery)
															#line 5443 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1660 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_2 = Future<Void>(Never());
															#line 1660 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<PostResolutionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5449 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<PostResolutionActor*>(this)->actor_wait_state = 3;
															#line 1660 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PostResolutionActor, 2, Void >*>(static_cast<PostResolutionActor*>(this)));
															#line 5454 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PostResolutionActor*>(this)->actor_wait_state > 0) static_cast<PostResolutionActor*>(this)->actor_wait_state = 0;
		static_cast<PostResolutionActor*>(this)->ActorCallback< PostResolutionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PostResolutionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 1664 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_3 = applyMetadataToCommittedTransactions(self);
															#line 1664 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<PostResolutionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5545 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<PostResolutionActor*>(this)->actor_wait_state = 4;
															#line 1664 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< PostResolutionActor, 3, Void >*>(static_cast<PostResolutionActor*>(this)));
															#line 5550 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<PostResolutionActor*>(this)->actor_wait_state > 0) static_cast<PostResolutionActor*>(this)->actor_wait_state = 0;
		static_cast<PostResolutionActor*>(this)->ActorCallback< PostResolutionActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< PostResolutionActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
															#line 1666 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (debugID.present())
															#line 5646 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1667 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			g_traceBatch.addEvent( "CommitDebug", debugID.get().first(), "CommitProxyServer.commitBatch.ApplyMetadataToCommittedTxn");
															#line 5650 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 1674 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (self->rangeLockEnabled())
															#line 5654 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1675 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			rejectMutationsForReadLockOnRange(self);
															#line 5658 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 1679 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_4 = assignMutationsToStorageServers(self);
															#line 1679 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<PostResolutionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5664 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont8when1(__when_expr_4.get(), loopDepth); };
		static_cast<PostResolutionActor*>(this)->actor_wait_state = 5;
															#line 1679 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< PostResolutionActor, 4, Void >*>(static_cast<PostResolutionActor*>(this)));
															#line 5669 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
															#line 1666 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (debugID.present())
															#line 5678 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1667 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			g_traceBatch.addEvent( "CommitDebug", debugID.get().first(), "CommitProxyServer.commitBatch.ApplyMetadataToCommittedTxn");
															#line 5682 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 1674 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (self->rangeLockEnabled())
															#line 5686 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1675 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			rejectMutationsForReadLockOnRange(self);
															#line 5690 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 1679 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_4 = assignMutationsToStorageServers(self);
															#line 1679 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<PostResolutionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5696 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont8when1(__when_expr_4.get(), loopDepth); };
		static_cast<PostResolutionActor*>(this)->actor_wait_state = 5;
															#line 1679 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< PostResolutionActor, 4, Void >*>(static_cast<PostResolutionActor*>(this)));
															#line 5701 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<PostResolutionActor*>(this)->actor_wait_state > 0) static_cast<PostResolutionActor*>(this)->actor_wait_state = 0;
		static_cast<PostResolutionActor*>(this)->ActorCallback< PostResolutionActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< PostResolutionActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont9(Void const& _,int loopDepth) 
	{
															#line 1681 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (debugID.present())
															#line 5785 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1682 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			g_traceBatch.addEvent("CommitDebug", debugID.get().first(), "CommitProxyServer.commitBatch.AssignMutationToSS");
															#line 5789 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 1686 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if ((pProxyCommitData->vecBackupKeys.size() > 1) && self->logRangeMutations.size())
															#line 5793 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1687 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_5 = addBackupMutations(pProxyCommitData, &self->logRangeMutations, &self->toCommit, self->commitVersion, &self->computeDuration, &self->computeStart);
															#line 1687 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<PostResolutionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5799 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont9when1(__when_expr_5.get(), loopDepth); };
			static_cast<PostResolutionActor*>(this)->actor_wait_state = 6;
															#line 1687 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< PostResolutionActor, 5, Void >*>(static_cast<PostResolutionActor*>(this)));
															#line 5804 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont12(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont9(Void && _,int loopDepth) 
	{
															#line 1681 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (debugID.present())
															#line 5818 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1682 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			g_traceBatch.addEvent("CommitDebug", debugID.get().first(), "CommitProxyServer.commitBatch.AssignMutationToSS");
															#line 5822 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 1686 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if ((pProxyCommitData->vecBackupKeys.size() > 1) && self->logRangeMutations.size())
															#line 5826 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1687 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_5 = addBackupMutations(pProxyCommitData, &self->logRangeMutations, &self->toCommit, self->commitVersion, &self->computeDuration, &self->computeStart);
															#line 1687 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<PostResolutionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5832 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont9when1(__when_expr_5.get(), loopDepth); };
			static_cast<PostResolutionActor*>(this)->actor_wait_state = 6;
															#line 1687 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< PostResolutionActor, 5, Void >*>(static_cast<PostResolutionActor*>(this)));
															#line 5837 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont12(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<PostResolutionActor*>(this)->actor_wait_state > 0) static_cast<PostResolutionActor*>(this)->actor_wait_state = 0;
		static_cast<PostResolutionActor*>(this)->ActorCallback< PostResolutionActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< PostResolutionActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont12(int loopDepth) 
	{
															#line 1699 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		buildIdempotencyIdMutations( self->trs, self->idempotencyKVBuilder, self->commitVersion, self->committed, ConflictBatch::TransactionCommitted, self->locked, [&](const KeyValue& kv) { MutationRef idempotencyIdSet; idempotencyIdSet.type = MutationRef::Type::SetValue; idempotencyIdSet.param1 = kv.key; idempotencyIdSet.param2 = kv.value; auto& tags = pProxyCommitData->tagsForKey(kv.key); ASSERT(!SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST || pProxyCommitData->db->get().logSystemConfig.numLogs() == self->tpcvMap.size()); self->toCommit.addTags(tags); if (self->pProxyCommitData->encryptMode.isEncryptionEnabled()) { CODE_PROBE(true, "encrypting idempotency mutation", probe::decoration::rare); EncryptCipherDomainId domainId = getEncryptDetailsFromMutationRef(self->pProxyCommitData, idempotencyIdSet); MutationRef encryptedMutation = idempotencyIdSet.encrypt(self->cipherKeys, domainId, self->arena, BlobCipherMetrics::TLOG); ASSERT(encryptedMutation.isEncrypted()); self->toCommit.writeTypedMessage(encryptedMutation); } else { if (pProxyCommitData->acsBuilder != nullptr) { updateMutationWithAcsAndAddMutationToAcsBuilder( pProxyCommitData->acsBuilder, idempotencyIdSet, tags, getCommitProxyAccumulativeChecksumIndex(pProxyCommitData->commitProxyIndex), pProxyCommitData->epoch, self->commitVersion, pProxyCommitData->dbgid); } self->toCommit.writeTypedMessage(idempotencyIdSet); } });
															#line 1738 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST || pProxyCommitData->db->get().logSystemConfig.numLogs() == self->tpcvMap.size())
															#line 5928 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1740 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			i = 0;
															#line 1741 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for(i = 0;i < pProxyCommitData->idempotencyClears.size();i++) {
															#line 1742 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				auto& tags = pProxyCommitData->tagsForKey(pProxyCommitData->idempotencyClears[i].param1);
															#line 1743 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				self->toCommit.addTags(tags);
															#line 1744 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (pProxyCommitData->acsBuilder != nullptr)
															#line 5940 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				{
															#line 1745 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					updateMutationWithAcsAndAddMutationToAcsBuilder( pProxyCommitData->acsBuilder, pProxyCommitData->idempotencyClears[i], tags, getCommitProxyAccumulativeChecksumIndex(pProxyCommitData->commitProxyIndex), pProxyCommitData->epoch, self->commitVersion, pProxyCommitData->dbgid);
															#line 5944 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				}
															#line 1754 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				WriteMutationRefVar var = writeMutation(self, &pProxyCommitData->idempotencyClears[i]);
															#line 1755 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				ASSERT(std::holds_alternative<MutationRef>(var));
															#line 5950 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 1757 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->idempotencyClears = Standalone<VectorRef<MutationRef>>();
															#line 5954 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 1760 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->toCommit.saveTags(self->writtenTags);
															#line 1762 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.mutations += self->mutationCount;
															#line 1763 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.mutationBytes += self->mutationBytes;
															#line 1768 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (pProxyCommitData->committedVersion.get() < self->commitVersion - SERVER_KNOBS->MAX_READ_TRANSACTION_LIFE_VERSIONS)
															#line 5964 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1770 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->computeDuration += g_network->timer_monotonic() - self->computeStart;
															#line 1771 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			waitVersionSpan = Span();
															#line 1772 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			;
															#line 5972 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = a_body1cont12loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1cont12cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont14(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont14(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<PostResolutionActor*>(this)->actor_wait_state > 0) static_cast<PostResolutionActor*>(this)->actor_wait_state = 0;
		static_cast<PostResolutionActor*>(this)->ActorCallback< PostResolutionActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< PostResolutionActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont12cont1(int loopDepth) 
	{
															#line 1808 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->msg = self->storeCommits.back().first.get();
															#line 1810 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (self->debugID.present())
															#line 6075 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1811 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			g_traceBatch.addEvent( "CommitDebug", self->debugID.get().first(), "CommitProxyServer.commitBatch.AfterStoreCommits");
															#line 6079 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 1815 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		bool firstMessage = true;
															#line 1816 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for( auto m : self->msg.messages ) {
															#line 1817 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (firstMessage)
															#line 6087 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 1818 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				ASSERT(!SERVER_KNOBS->ENABLE_VERSION_VECTOR || pProxyCommitData->db->get().logSystemConfig.numLogs() == self->tpcvMap.size());
															#line 1820 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				self->toCommit.addTxsTag();
															#line 6093 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 1822 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->toCommit.writeMessage(StringRef(m.begin(), m.size()), !firstMessage);
															#line 1823 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			firstMessage = false;
															#line 6099 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 1826 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (self->prevVersion && self->commitVersion - self->prevVersion < SERVER_KNOBS->MAX_VERSIONS_IN_FLIGHT / 2)
															#line 6103 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1827 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			debug_advanceMaxCommittedVersion(UID(), self->commitVersion);
															#line 6107 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 1836 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (self->prevVersion && self->commitVersion - self->prevVersion < SERVER_KNOBS->MAX_VERSIONS_IN_FLIGHT / 2)
															#line 6111 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1837 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			debug_advanceMaxCommittedVersion(UID(), self->commitVersion);
															#line 6115 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 1839 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->commitStartTime = now();
															#line 1840 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->lastStartCommit = self->commitStartTime;
															#line 1841 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		Optional<std::unordered_map<uint16_t, Version>> tpcvMap = Optional<std::unordered_map<uint16_t, Version>>();
															#line 1842 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (SERVER_KNOBS->ENABLE_VERSION_VECTOR)
															#line 6125 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1843 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			tpcvMap = self->tpcvMap;
															#line 6129 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 1845 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (self->pProxyCommitData->acsBuilder != nullptr)
															#line 6133 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1847 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			addAccumulativeChecksumMutations(self);
															#line 6137 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 1849 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		const auto versionSet = ILogSystem::PushVersionSet{ self->prevVersion, self->commitVersion, pProxyCommitData->committedVersion.get(), pProxyCommitData->minKnownCommittedVersion };
															#line 1853 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->loggingComplete = pProxyCommitData->logSystem->push(versionSet, self->toCommit, span.context, self->debugID, tpcvMap);
															#line 1856 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		float ratio = self->toCommit.getEmptyMessageRatio();
															#line 1857 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.commitBatchingEmptyMessageRatio.addMeasurement(ratio);
															#line 1859 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!self->forceRecovery)
															#line 6149 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1860 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT(pProxyCommitData->latestLocalCommitBatchLogging.get() == self->localBatchNumber - 1);
															#line 1861 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->latestLocalCommitBatchLogging.set(self->localBatchNumber);
															#line 6155 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 1864 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->computeDuration += g_network->timer_monotonic() - self->computeStart;
															#line 1865 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (self->batchOperations > 0)
															#line 6161 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1866 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			double estimatedDelay = computeReleaseDelay(self, self->latencyBucket);
															#line 1867 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			double computePerOperation = std::min(SERVER_KNOBS->MAX_COMPUTE_PER_OPERATION, self->computeDuration / self->batchOperations);
															#line 1870 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (computePerOperation <= pProxyCommitData->commitComputePerOperation[self->latencyBucket])
															#line 6169 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 1871 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				pProxyCommitData->commitComputePerOperation[self->latencyBucket] = computePerOperation;
															#line 6173 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1873 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				pProxyCommitData->commitComputePerOperation[self->latencyBucket] = SERVER_KNOBS->PROXY_COMPUTE_GROWTH_RATE * computePerOperation + ((1.0 - SERVER_KNOBS->PROXY_COMPUTE_GROWTH_RATE) * pProxyCommitData->commitComputePerOperation[self->latencyBucket]);
															#line 6179 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 1878 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->stats.maxComputeNS = std::max<int64_t>(pProxyCommitData->stats.maxComputeNS, 1e9 * pProxyCommitData->commitComputePerOperation[self->latencyBucket]);
															#line 1881 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->stats.minComputeNS = std::min<int64_t>(pProxyCommitData->stats.minComputeNS, 1e9 * pProxyCommitData->commitComputePerOperation[self->latencyBucket]);
															#line 1885 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (estimatedDelay >= SERVER_KNOBS->MAX_COMPUTE_DURATION_LOG_CUTOFF || self->computeDuration >= SERVER_KNOBS->MAX_COMPUTE_DURATION_LOG_CUTOFF)
															#line 6187 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 1887 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				TraceEvent(SevInfo, "LongComputeDuration", pProxyCommitData->dbgid) .suppressFor(10.0) .detail("EstimatedComputeDuration", estimatedDelay) .detail("ComputeDuration", self->computeDuration) .detail("ComputePerOperation", computePerOperation) .detail("LatencyBucket", self->latencyBucket) .detail("UpdatedComputePerOperationEstimate", pProxyCommitData->commitComputePerOperation[self->latencyBucket]) .detail("BatchBytes", self->batchBytes) .detail("BatchOperations", self->batchOperations);
															#line 6191 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
		}
															#line 1900 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.processingMutationDist->sampleSeconds(g_network->timer_monotonic() - postResolutionQueuing);
															#line 1901 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<PostResolutionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PostResolutionActorState(); static_cast<PostResolutionActor*>(this)->destroy(); return 0; }
															#line 6198 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<PostResolutionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PostResolutionActorState();
		static_cast<PostResolutionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont12cont5(int loopDepth) 
	{
															#line 1804 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		waitVersionSpan = Span{};
															#line 1805 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->computeStart = g_network->timer_monotonic();
															#line 6212 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont12cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont12loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1(int loopDepth) 
	{
															#line 1772 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!(pProxyCommitData->committedVersion.get() < self->commitVersion - SERVER_KNOBS->MAX_READ_TRANSACTION_LIFE_VERSIONS))
															#line 6228 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
			return a_body1cont12break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1776 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		CODE_PROBE(true, "Semi-committed pipeline limited by MVCC window");
															#line 1778 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		waitVersionSpan = Span("MP:overMaxReadTransactionLifeVersions"_loc, span.context);
															#line 1780 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_6 = pProxyCommitData->committedVersion.whenAtLeast( self->commitVersion - SERVER_KNOBS->MAX_READ_TRANSACTION_LIFE_VERSIONS);
															#line 1779 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<PostResolutionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6240 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when1(__when_expr_6.get(), loopDepth); };
															#line 1785 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_7 = pProxyCommitData->cx->onProxiesChanged();
															#line 6244 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when2(__when_expr_7.get(), loopDepth); };
															#line 1789 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<GetRawCommittedVersionReply> __when_expr_8 = pProxyCommitData->master.getLiveCommittedVersion.getReply( GetRawCommittedVersionRequest(waitVersionSpan.context, debugID, invalidVersion), TaskPriority::GetLiveCommittedVersionReply);
															#line 6248 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when3(__when_expr_8.get(), loopDepth); };
		static_cast<PostResolutionActor*>(this)->actor_wait_state = 7;
															#line 1780 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< PostResolutionActor, 6, Void >*>(static_cast<PostResolutionActor*>(this)));
															#line 1785 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< PostResolutionActor, 7, Void >*>(static_cast<PostResolutionActor*>(this)));
															#line 1789 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< PostResolutionActor, 8, GetRawCommittedVersionReply >*>(static_cast<PostResolutionActor*>(this)));
															#line 6257 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12break1(int loopDepth) 
	{
		try {
			return a_body1cont12cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont12loopHead1(0);

		return loopDepth;
	}
	int a_body1cont12loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 1782 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_9 = yield();
															#line 1782 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<PostResolutionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6287 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when1when1(__when_expr_9.get(), loopDepth); };
		static_cast<PostResolutionActor*>(this)->actor_wait_state = 8;
															#line 1782 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< PostResolutionActor, 9, Void >*>(static_cast<PostResolutionActor*>(this)));
															#line 6292 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12loopBody1when1(Void && _,int loopDepth) 
	{
															#line 1782 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_9 = yield();
															#line 1782 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<PostResolutionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6303 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when1when1(__when_expr_9.get(), loopDepth); };
		static_cast<PostResolutionActor*>(this)->actor_wait_state = 8;
															#line 1782 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< PostResolutionActor, 9, Void >*>(static_cast<PostResolutionActor*>(this)));
															#line 6308 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when3(GetRawCommittedVersionReply const& v,int loopDepth) 
	{
															#line 1792 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (v.version > pProxyCommitData->committedVersion.get())
															#line 6329 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1793 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->locked = v.locked;
															#line 1794 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->metadataVersion = v.metadataVersion;
															#line 1795 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->committedVersion.set(v.version);
															#line 6337 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 1798 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (pProxyCommitData->committedVersion.get() < self->commitVersion - SERVER_KNOBS->MAX_READ_TRANSACTION_LIFE_VERSIONS)
															#line 6341 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1800 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_10 = delay(SERVER_KNOBS->PROXY_SPIN_DELAY);
															#line 1800 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<PostResolutionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6347 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when3when1(__when_expr_10.get(), loopDepth); };
			static_cast<PostResolutionActor*>(this)->actor_wait_state = 9;
															#line 1800 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< PostResolutionActor, 10, Void >*>(static_cast<PostResolutionActor*>(this)));
															#line 6352 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont12loopBody1when3cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12loopBody1when3(GetRawCommittedVersionReply && v,int loopDepth) 
	{
															#line 1792 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (v.version > pProxyCommitData->committedVersion.get())
															#line 6366 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1793 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->locked = v.locked;
															#line 1794 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->metadataVersion = v.metadataVersion;
															#line 1795 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->committedVersion.set(v.version);
															#line 6374 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 1798 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (pProxyCommitData->committedVersion.get() < self->commitVersion - SERVER_KNOBS->MAX_READ_TRANSACTION_LIFE_VERSIONS)
															#line 6378 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1800 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_10 = delay(SERVER_KNOBS->PROXY_SPIN_DELAY);
															#line 1800 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<PostResolutionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6384 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when3when1(__when_expr_10.get(), loopDepth); };
			static_cast<PostResolutionActor*>(this)->actor_wait_state = 9;
															#line 1800 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< PostResolutionActor, 10, Void >*>(static_cast<PostResolutionActor*>(this)));
															#line 6389 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont12loopBody1when3cont1(loopDepth);
		}

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<PostResolutionActor*>(this)->actor_wait_state > 0) static_cast<PostResolutionActor*>(this)->actor_wait_state = 0;
		static_cast<PostResolutionActor*>(this)->ActorCallback< PostResolutionActor, 6, Void >::remove();
		static_cast<PostResolutionActor*>(this)->ActorCallback< PostResolutionActor, 7, Void >::remove();
		static_cast<PostResolutionActor*>(this)->ActorCallback< PostResolutionActor, 8, GetRawCommittedVersionReply >::remove();

	}
	int a_body1cont12loopBody1when1cont1(Void const& _,int loopDepth) 
	{
		return a_body1cont12break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont12loopBody1when1cont1(Void && _,int loopDepth) 
	{
		return a_body1cont12break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont12loopBody1when1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1when1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1when1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<PostResolutionActor*>(this)->actor_wait_state > 0) static_cast<PostResolutionActor*>(this)->actor_wait_state = 0;
		static_cast<PostResolutionActor*>(this)->ActorCallback< PostResolutionActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont12loopBody1when1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont12loopBody1when1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< PostResolutionActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont12loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont12loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< PostResolutionActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont12loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont12loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< PostResolutionActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont12loopBody1when3cont1(int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when3cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1when3cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when3cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1when3cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1when3cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1when3cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<PostResolutionActor*>(this)->actor_wait_state > 0) static_cast<PostResolutionActor*>(this)->actor_wait_state = 0;
		static_cast<PostResolutionActor*>(this)->ActorCallback< PostResolutionActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont12loopBody1when3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont12loopBody1when3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< PostResolutionActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 8, GetRawCommittedVersionReply >*,GetRawCommittedVersionReply const& value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont12loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 8, GetRawCommittedVersionReply >*,GetRawCommittedVersionReply && value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont12loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< PostResolutionActor, 8, GetRawCommittedVersionReply >*,Error err) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 8);

	}
															#line 1616 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitBatchContext* self;
															#line 1617 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	double postResolutionStart;
															#line 1618 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCommitData* const pProxyCommitData;
															#line 1619 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	std::vector<CommitTransactionRequest>& trs;
															#line 1620 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	const int64_t localBatchNumber;
															#line 1621 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	const Optional<UID>& debugID;
															#line 1622 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Span span;
															#line 1627 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	double postResolutionQueuing;
															#line 1740 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	int i;
															#line 1771 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Span waitVersionSpan;
															#line 6778 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via postResolution()
															#line 1616 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class PostResolutionActor final : public Actor<Void>, public ActorCallback< PostResolutionActor, 0, Void >, public ActorCallback< PostResolutionActor, 1, Void >, public ActorCallback< PostResolutionActor, 2, Void >, public ActorCallback< PostResolutionActor, 3, Void >, public ActorCallback< PostResolutionActor, 4, Void >, public ActorCallback< PostResolutionActor, 5, Void >, public ActorCallback< PostResolutionActor, 6, Void >, public ActorCallback< PostResolutionActor, 9, Void >, public ActorCallback< PostResolutionActor, 7, Void >, public ActorCallback< PostResolutionActor, 8, GetRawCommittedVersionReply >, public ActorCallback< PostResolutionActor, 10, Void >, public FastAllocated<PostResolutionActor>, public PostResolutionActorState<PostResolutionActor> {
															#line 6783 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<PostResolutionActor>::operator new;
	using FastAllocated<PostResolutionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5126262922768404224UL, 6775588811908278784UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PostResolutionActor, 0, Void >;
friend struct ActorCallback< PostResolutionActor, 1, Void >;
friend struct ActorCallback< PostResolutionActor, 2, Void >;
friend struct ActorCallback< PostResolutionActor, 3, Void >;
friend struct ActorCallback< PostResolutionActor, 4, Void >;
friend struct ActorCallback< PostResolutionActor, 5, Void >;
friend struct ActorCallback< PostResolutionActor, 6, Void >;
friend struct ActorCallback< PostResolutionActor, 9, Void >;
friend struct ActorCallback< PostResolutionActor, 7, Void >;
friend struct ActorCallback< PostResolutionActor, 8, GetRawCommittedVersionReply >;
friend struct ActorCallback< PostResolutionActor, 10, Void >;
															#line 1616 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	PostResolutionActor(CommitBatchContext* const& self) 
															#line 6810 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   PostResolutionActorState<PostResolutionActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15846867638177296640UL, 14373598132617893888UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("postResolution");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PostResolutionActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PostResolutionActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< PostResolutionActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< PostResolutionActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< PostResolutionActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< PostResolutionActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< PostResolutionActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< PostResolutionActor, 9, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< PostResolutionActor, 10, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1616 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> postResolution( CommitBatchContext* const& self ) {
															#line 1616 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new PostResolutionActor(self));
															#line 6850 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 1903 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

															#line 6855 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
// This generated class is to be used only via transactionLogging()
															#line 1904 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class TransactionLoggingActor>
															#line 1904 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class TransactionLoggingActorState {
															#line 6861 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 1904 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	TransactionLoggingActorState(CommitBatchContext* const& self) 
															#line 1904 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 1904 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : self(self),
															#line 1905 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   tLoggingStart(g_network->timer_monotonic()),
															#line 1906 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   pProxyCommitData(self->pProxyCommitData),
															#line 1907 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   span("MP:transactionLogging"_loc, self->span.context)
															#line 6874 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("transactionLogging", reinterpret_cast<unsigned long>(this));

	}
	~TransactionLoggingActorState() 
	{
		fdb_probe_actor_destroy("transactionLogging", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1911 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				StrictFuture<Version> __when_expr_0 = self->loggingComplete;
															#line 1910 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (static_cast<TransactionLoggingActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 6892 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 1917 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				StrictFuture<Void> __when_expr_1 = pProxyCommitData->committedVersion.whenAtLeast(self->commitVersion + 1);
															#line 6896 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
				static_cast<TransactionLoggingActor*>(this)->actor_wait_state = 1;
															#line 1911 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TransactionLoggingActor, 0, Version >*>(static_cast<TransactionLoggingActor*>(this)));
															#line 1917 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TransactionLoggingActor, 1, Void >*>(static_cast<TransactionLoggingActor*>(this)));
															#line 6903 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TransactionLoggingActorState();
		static_cast<TransactionLoggingActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1926 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->lastCommitLatency = now() - self->commitStartTime;
															#line 1927 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->lastCommitTime = std::max(pProxyCommitData->lastCommitTime.get(), self->commitStartTime);
															#line 1929 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_2 = yield(TaskPriority::ProxyCommitYield2);
															#line 1929 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<TransactionLoggingActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6938 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<TransactionLoggingActor*>(this)->actor_wait_state = 2;
															#line 1929 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TransactionLoggingActor, 2, Void >*>(static_cast<TransactionLoggingActor*>(this)));
															#line 6943 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1920 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (e.code() == error_code_broken_promise)
															#line 6953 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 1921 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				return a_body1Catch1(tlog_failed(), loopDepth);
															#line 6957 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 1923 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 6961 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Version const& ver,int loopDepth) 
	{
															#line 1912 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST)
															#line 6981 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1913 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->minKnownCommittedVersion = std::max(pProxyCommitData->minKnownCommittedVersion, ver);
															#line 6985 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Version && ver,int loopDepth) 
	{
															#line 1912 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST)
															#line 6995 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1913 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->minKnownCommittedVersion = std::max(pProxyCommitData->minKnownCommittedVersion, ver);
															#line 6999 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TransactionLoggingActor*>(this)->actor_wait_state > 0) static_cast<TransactionLoggingActor*>(this)->actor_wait_state = 0;
		static_cast<TransactionLoggingActor*>(this)->ActorCallback< TransactionLoggingActor, 0, Version >::remove();
		static_cast<TransactionLoggingActor*>(this)->ActorCallback< TransactionLoggingActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TransactionLoggingActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("transactionLogging", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionLoggingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transactionLogging", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TransactionLoggingActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("transactionLogging", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionLoggingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transactionLogging", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TransactionLoggingActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("transactionLogging", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionLoggingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transactionLogging", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TransactionLoggingActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("transactionLogging", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionLoggingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transactionLogging", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TransactionLoggingActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("transactionLogging", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionLoggingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transactionLogging", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TransactionLoggingActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("transactionLogging", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionLoggingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transactionLogging", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 1931 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (pProxyCommitData->popRemoteTxs && self->msg.popTo > (pProxyCommitData->txsPopVersions.size() ? pProxyCommitData->txsPopVersions.back().second : pProxyCommitData->lastTxsPop))
															#line 7155 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1934 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (pProxyCommitData->txsPopVersions.size() >= SERVER_KNOBS->MAX_TXS_POP_VERSION_HISTORY)
															#line 7159 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 1935 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				TraceEvent(SevWarnAlways, "DiscardingTxsPopHistory").suppressFor(1.0);
															#line 1936 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				pProxyCommitData->txsPopVersions.pop_front();
															#line 7165 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 1939 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->txsPopVersions.emplace_back(self->commitVersion, self->msg.popTo);
															#line 7169 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 1941 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->logSystem->popTxs(self->msg.popTo);
															#line 1942 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.tlogLoggingDist->sampleSeconds(g_network->timer_monotonic() - tLoggingStart);
															#line 1943 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<TransactionLoggingActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TransactionLoggingActorState(); static_cast<TransactionLoggingActor*>(this)->destroy(); return 0; }
															#line 7177 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<TransactionLoggingActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TransactionLoggingActorState();
		static_cast<TransactionLoggingActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 1931 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (pProxyCommitData->popRemoteTxs && self->msg.popTo > (pProxyCommitData->txsPopVersions.size() ? pProxyCommitData->txsPopVersions.back().second : pProxyCommitData->lastTxsPop))
															#line 7189 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1934 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (pProxyCommitData->txsPopVersions.size() >= SERVER_KNOBS->MAX_TXS_POP_VERSION_HISTORY)
															#line 7193 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 1935 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				TraceEvent(SevWarnAlways, "DiscardingTxsPopHistory").suppressFor(1.0);
															#line 1936 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				pProxyCommitData->txsPopVersions.pop_front();
															#line 7199 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 1939 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->txsPopVersions.emplace_back(self->commitVersion, self->msg.popTo);
															#line 7203 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 1941 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->logSystem->popTxs(self->msg.popTo);
															#line 1942 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.tlogLoggingDist->sampleSeconds(g_network->timer_monotonic() - tLoggingStart);
															#line 1943 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<TransactionLoggingActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TransactionLoggingActorState(); static_cast<TransactionLoggingActor*>(this)->destroy(); return 0; }
															#line 7211 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<TransactionLoggingActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TransactionLoggingActorState();
		static_cast<TransactionLoggingActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TransactionLoggingActor*>(this)->actor_wait_state > 0) static_cast<TransactionLoggingActor*>(this)->actor_wait_state = 0;
		static_cast<TransactionLoggingActor*>(this)->ActorCallback< TransactionLoggingActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TransactionLoggingActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("transactionLogging", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionLoggingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transactionLogging", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TransactionLoggingActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("transactionLogging", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionLoggingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transactionLogging", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TransactionLoggingActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("transactionLogging", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionLoggingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transactionLogging", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1904 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitBatchContext* self;
															#line 1905 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	double tLoggingStart;
															#line 1906 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCommitData* const pProxyCommitData;
															#line 1907 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Span span;
															#line 7302 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via transactionLogging()
															#line 1904 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class TransactionLoggingActor final : public Actor<Void>, public ActorCallback< TransactionLoggingActor, 0, Version >, public ActorCallback< TransactionLoggingActor, 1, Void >, public ActorCallback< TransactionLoggingActor, 2, Void >, public FastAllocated<TransactionLoggingActor>, public TransactionLoggingActorState<TransactionLoggingActor> {
															#line 7307 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<TransactionLoggingActor>::operator new;
	using FastAllocated<TransactionLoggingActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2766873900153335296UL, 13708442280707338496UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TransactionLoggingActor, 0, Version >;
friend struct ActorCallback< TransactionLoggingActor, 1, Void >;
friend struct ActorCallback< TransactionLoggingActor, 2, Void >;
															#line 1904 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	TransactionLoggingActor(CommitBatchContext* const& self) 
															#line 7326 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TransactionLoggingActorState<TransactionLoggingActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("transactionLogging", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3004937098039659520UL, 11889376626278748672UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionLoggingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("transactionLogging");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("transactionLogging", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TransactionLoggingActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TransactionLoggingActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1904 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> transactionLogging( CommitBatchContext* const& self ) {
															#line 1904 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new TransactionLoggingActor(self));
															#line 7359 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 1945 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

															#line 7364 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
// This generated class is to be used only via reply()
															#line 1946 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class ReplyActor>
															#line 1946 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class ReplyActorState {
															#line 7370 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 1946 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ReplyActorState(CommitBatchContext* const& self) 
															#line 1946 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 1946 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : self(self),
															#line 1947 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   replyStart(g_network->timer_monotonic()),
															#line 1948 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   pProxyCommitData(self->pProxyCommitData),
															#line 1949 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   span("MP:reply"_loc, self->span.context),
															#line 1951 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   debugID(self->debugID)
															#line 7385 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("reply", reinterpret_cast<unsigned long>(this));

	}
	~ReplyActorState() 
	{
		fdb_probe_actor_destroy("reply", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1953 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (!SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST)
															#line 7400 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 1958 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (self->prevVersion && self->commitVersion - self->prevVersion < SERVER_KNOBS->MAX_VERSIONS_IN_FLIGHT / 2)
															#line 7404 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				{
															#line 1960 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					debug_advanceMinCommittedVersion(UID(), self->commitVersion);
															#line 7408 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				}
															#line 1964 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				acknowledgeTransactionStateStoreCommits(self);
															#line 7412 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 1970 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (debugID.present())
															#line 7416 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 1971 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				g_traceBatch.addEvent("CommitDebug", debugID.get().first(), "CommitProxyServer.commitBatch.AfterLogPush");
															#line 7420 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 1979 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			CODE_PROBE(pProxyCommitData->committedVersion.get() > self->commitVersion, "later version was reported committed first");
															#line 1982 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (self->commitVersion >= pProxyCommitData->committedVersion.get())
															#line 7426 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 1983 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				writtenTags = Optional<std::set<Tag>>();
															#line 1984 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (SERVER_KNOBS->ENABLE_VERSION_VECTOR)
															#line 7432 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				{
															#line 1985 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					writtenTags = self->writtenTags;
															#line 7436 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				}
															#line 1987 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				StrictFuture<Void> __when_expr_0 = pProxyCommitData->master.reportLiveCommittedVersion.getReply( ReportRawCommittedVersionRequest(self->commitVersion, self->lockedAfter, self->metadataVersionAfter, pProxyCommitData->minKnownCommittedVersion, self->prevVersion, writtenTags), TaskPriority::ProxyMasterVersionReply);
															#line 1987 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (static_cast<ReplyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7442 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ReplyActor*>(this)->actor_wait_state = 1;
															#line 1987 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReplyActor, 0, Void >*>(static_cast<ReplyActor*>(this)));
															#line 7447 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReplyActorState();
		static_cast<ReplyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1997 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (debugID.present())
															#line 7475 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1998 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			g_traceBatch.addEvent( "CommitDebug", debugID.get().first(), "CommitProxyServer.commitBatch.AfterReportRawCommittedVersion");
															#line 7479 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 2002 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST)
															#line 7483 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2007 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (self->prevVersion && self->commitVersion - self->prevVersion < SERVER_KNOBS->MAX_VERSIONS_IN_FLIGHT / 2)
															#line 7487 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 2009 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				debug_advanceMinCommittedVersion(UID(), self->commitVersion);
															#line 7491 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 2013 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			acknowledgeTransactionStateStoreCommits(self);
															#line 7495 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 2016 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (self->commitVersion > pProxyCommitData->committedVersion.get())
															#line 7499 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2017 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->locked = self->lockedAfter;
															#line 2018 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->metadataVersion = self->metadataVersionAfter;
															#line 2019 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->committedVersion.set(self->commitVersion);
															#line 2020 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST)
															#line 7509 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 2021 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				ASSERT(self->loggingComplete.isReady());
															#line 2022 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				pProxyCommitData->minKnownCommittedVersion = std::max(pProxyCommitData->minKnownCommittedVersion, self->loggingComplete.get());
															#line 7515 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
		}
															#line 2027 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (self->forceRecovery)
															#line 7520 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2028 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent(SevWarn, "RestartingTxnSubsystem", pProxyCommitData->dbgid).detail("Stage", "ProxyShutdown");
															#line 2029 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			return a_body1Catch1(worker_removed(), loopDepth);
															#line 7526 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 2034 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		double endTime = g_network->timer();
															#line 2037 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		std::fill(self->nextTr.begin(), self->nextTr.end(), 0);
															#line 2038 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		std::unordered_map<uint8_t, int16_t> idCountsForKey;
															#line 2039 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for(int t = 0;t < self->trs.size();t++) {
															#line 2040 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			auto& tr = self->trs[t];
															#line 2041 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (self->committed[t] == ConflictBatch::TransactionCommitted && (!self->locked || tr.isLockAware()))
															#line 7540 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 2042 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				ASSERT_WE_THINK(self->commitVersion != invalidVersion);
															#line 2043 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (self->trs[t].idempotencyId.valid())
															#line 7546 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				{
															#line 2044 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					idCountsForKey[uint8_t(t >> 8)] += 1;
															#line 7550 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				}
															#line 2046 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				tr.reply.send(CommitID(self->commitVersion, t, self->metadataVersionAfter));
															#line 7554 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
			else
			{
															#line 2047 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (self->committed[t] == ConflictBatch::TransactionTooOld)
															#line 7560 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				{
															#line 2048 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					tr.reply.sendError(transaction_too_old());
															#line 7564 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				}
				else
				{
															#line 2049 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					if (self->committed[t] == ConflictBatch::TransactionLockReject)
															#line 7570 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					{
															#line 2051 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						ASSERT(tr.reply.isSet());
															#line 7574 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					}
					else
					{
															#line 2055 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						if (tr.transaction.report_conflicting_keys)
															#line 7580 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
						{
															#line 2056 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							Standalone<VectorRef<int>> conflictingKRIndices;
															#line 2057 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							for( int resolverInd : self->transactionResolverMap[t] ) {
															#line 2058 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
								auto const& cKRs = self->resolution[resolverInd] .conflictingKeyRangeMap[self->nextTr[resolverInd]];
															#line 2062 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
								for( auto const& rCRIndex : cKRs ) {
															#line 2065 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
									conflictingKRIndices.push_back(conflictingKRIndices.arena(), self->txReadConflictRangeIndexMap[t][resolverInd][rCRIndex]);
															#line 7592 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
								}
							}
															#line 2069 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							ASSERT(conflictingKRIndices.size());
															#line 2070 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							tr.reply.send(CommitID( invalidVersion, t, Optional<Value>(), Optional<Standalone<VectorRef<int>>>(conflictingKRIndices)));
															#line 7599 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
						}
						else
						{
															#line 2073 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							tr.reply.sendError(not_committed());
															#line 7605 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
						}
					}
				}
			}
															#line 2078 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for( int resolverInd : self->transactionResolverMap[t] ) {
															#line 2079 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				self->nextTr[resolverInd]++;
															#line 7614 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 2082 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			const double duration = endTime - tr.requestTime();
															#line 2083 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->stats.commitLatencySample.addMeasurement(duration);
															#line 2084 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (pProxyCommitData->latencyBandConfig.present())
															#line 7622 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 2085 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				bool filter = self->maxTransactionBytes > pProxyCommitData->latencyBandConfig.get().commitConfig.maxCommitBytes.orDefault( std::numeric_limits<int>::max());
															#line 2088 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				pProxyCommitData->stats.commitLatencyBands.addMeasurement(duration, 1, Filtered(filter));
															#line 7628 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
		}
															#line 2092 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for( auto [highOrderBatchIndex, count] : idCountsForKey ) {
															#line 2093 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->expectedIdempotencyIdCountForKey.send( ExpectedIdempotencyIdCountForKey{ self->commitVersion, count, highOrderBatchIndex });
															#line 7635 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 2097 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (self->pProxyCommitData->encryptMode.isEncryptionEnabled() && self->encryptionTime.present())
															#line 7639 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2098 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->stats.encryptionLatencySample.addMeasurement(self->encryptionTime.get());
															#line 7643 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 2100 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		++pProxyCommitData->stats.commitBatchOut;
															#line 2101 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.txnCommitOut += self->trs.size();
															#line 2102 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.txnConflicts += self->trs.size() - self->commitCount;
															#line 2103 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.txnCommitOutSuccess += self->commitCount;
															#line 2105 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (now() - pProxyCommitData->lastCoalesceTime > SERVER_KNOBS->RESOLVER_COALESCE_TIME)
															#line 7655 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2106 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->lastCoalesceTime = now();
															#line 2107 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			int lastSize = pProxyCommitData->keyResolvers.size();
															#line 2108 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			auto rs = pProxyCommitData->keyResolvers.ranges();
															#line 2109 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			Version oldestVersion = self->prevVersion - SERVER_KNOBS->MAX_WRITE_TRANSACTION_LIFE_VERSIONS;
															#line 2110 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for(auto r = rs.begin();r != rs.end();++r) {
															#line 2111 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				for(;r->value().size() > 1 && r->value()[1].first < oldestVersion;) {
															#line 2112 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					r->value().pop_front();
															#line 7671 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				}
															#line 2113 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (r->value().size() && r->value().front().first < oldestVersion)
															#line 7675 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				{
															#line 2114 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					r->value().front().first = 0;
															#line 7679 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				}
			}
															#line 2116 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (SERVER_KNOBS->PROXY_USE_RESOLVER_PRIVATE_MUTATIONS)
															#line 7684 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 2118 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				pProxyCommitData->keyResolvers.coalesce(normalKeys);
															#line 2119 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				auto& versions = pProxyCommitData->systemKeyVersions;
															#line 2120 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				for(;versions.size() > 1 && versions[1] < oldestVersion;) {
															#line 2121 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					versions.pop_front();
															#line 7694 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				}
															#line 2123 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (!versions.empty() && versions[0] < oldestVersion)
															#line 7698 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				{
															#line 2124 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					versions[0] = 0;
															#line 7702 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				}
			}
			else
			{
															#line 2127 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				pProxyCommitData->keyResolvers.coalesce(allKeys);
															#line 7709 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 2129 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (pProxyCommitData->keyResolvers.size() != lastSize)
															#line 7713 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 2130 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				TraceEvent("KeyResolverSize", pProxyCommitData->dbgid) .detail("Size", pProxyCommitData->keyResolvers.size());
															#line 7717 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
		}
															#line 2135 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		double target_latency = (now() - self->startTime) * SERVER_KNOBS->COMMIT_TRANSACTION_BATCH_INTERVAL_LATENCY_FRACTION;
															#line 2137 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->commitBatchInterval = std::max(SERVER_KNOBS->COMMIT_TRANSACTION_BATCH_INTERVAL_MIN, std::min(SERVER_KNOBS->COMMIT_TRANSACTION_BATCH_INTERVAL_MAX, target_latency * SERVER_KNOBS->COMMIT_TRANSACTION_BATCH_INTERVAL_SMOOTHER_ALPHA + pProxyCommitData->commitBatchInterval * (1 - SERVER_KNOBS->COMMIT_TRANSACTION_BATCH_INTERVAL_SMOOTHER_ALPHA)));
															#line 2143 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.commitBatchingWindowSize.addMeasurement(pProxyCommitData->commitBatchInterval);
															#line 2144 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->commitBatchesMemBytesCount -= self->currentBatchMemBytesCount;
															#line 2145 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT_ABORT(pProxyCommitData->commitBatchesMemBytesCount >= 0);
															#line 2146 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->releaseFuture;
															#line 2146 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<ReplyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7734 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ReplyActor*>(this)->actor_wait_state = 2;
															#line 2146 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReplyActor, 1, Void >*>(static_cast<ReplyActor*>(this)));
															#line 7739 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReplyActor*>(this)->actor_wait_state > 0) static_cast<ReplyActor*>(this)->actor_wait_state = 0;
		static_cast<ReplyActor*>(this)->ActorCallback< ReplyActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReplyActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("reply", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReplyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reply", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReplyActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("reply", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReplyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reply", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReplyActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("reply", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReplyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reply", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
															#line 2147 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.replyCommitDist->sampleSeconds(g_network->timer_monotonic() - replyStart);
															#line 2148 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<ReplyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReplyActorState(); static_cast<ReplyActor*>(this)->destroy(); return 0; }
															#line 7837 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<ReplyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ReplyActorState();
		static_cast<ReplyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
															#line 2147 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.replyCommitDist->sampleSeconds(g_network->timer_monotonic() - replyStart);
															#line 2148 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<ReplyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReplyActorState(); static_cast<ReplyActor*>(this)->destroy(); return 0; }
															#line 7851 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<ReplyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ReplyActorState();
		static_cast<ReplyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReplyActor*>(this)->actor_wait_state > 0) static_cast<ReplyActor*>(this)->actor_wait_state = 0;
		static_cast<ReplyActor*>(this)->ActorCallback< ReplyActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReplyActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("reply", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReplyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reply", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReplyActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("reply", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReplyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reply", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReplyActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("reply", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReplyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reply", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1946 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitBatchContext* self;
															#line 1947 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	double replyStart;
															#line 1948 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCommitData* const pProxyCommitData;
															#line 1949 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Span span;
															#line 1951 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	const Optional<UID>& debugID;
															#line 1983 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Optional<std::set<Tag>> writtenTags;
															#line 7946 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via reply()
															#line 1946 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class ReplyActor final : public Actor<Void>, public ActorCallback< ReplyActor, 0, Void >, public ActorCallback< ReplyActor, 1, Void >, public FastAllocated<ReplyActor>, public ReplyActorState<ReplyActor> {
															#line 7951 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<ReplyActor>::operator new;
	using FastAllocated<ReplyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18035953649316725248UL, 5788720622010390272UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReplyActor, 0, Void >;
friend struct ActorCallback< ReplyActor, 1, Void >;
															#line 1946 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ReplyActor(CommitBatchContext* const& self) 
															#line 7969 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ReplyActorState<ReplyActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("reply", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(412875400346227200UL, 2164551364787983616UL);
		ActorExecutionContextHelper __helper(static_cast<ReplyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("reply");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("reply", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReplyActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReplyActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1946 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> reply( CommitBatchContext* const& self ) {
															#line 1946 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new ReplyActor(self));
															#line 8002 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 2150 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

// Commit one batch of transactions trs
															#line 8008 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
// This generated class is to be used only via commitBatchImpl()
															#line 2152 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class CommitBatchImplActor>
															#line 2152 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class CommitBatchImplActorState {
															#line 8014 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 2152 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitBatchImplActorState(CommitBatchContext* const& pContext) 
															#line 2152 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 2152 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : pContext(pContext)
															#line 8021 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("commitBatchImpl", reinterpret_cast<unsigned long>(this));

	}
	~CommitBatchImplActorState() 
	{
		fdb_probe_actor_destroy("commitBatchImpl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2156 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pContext->stage = INITIALIZE;
															#line 2157 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			getCurrentLineage()->modify(&TransactionLineage::operation) = TransactionLineage::Operation::Commit;
															#line 2161 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(0, TaskPriority::ProxyCommit);
															#line 2161 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<CommitBatchImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8042 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CommitBatchImplActor*>(this)->actor_wait_state = 1;
															#line 2161 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CommitBatchImplActor, 0, Void >*>(static_cast<CommitBatchImplActor*>(this)));
															#line 8047 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CommitBatchImplActorState();
		static_cast<CommitBatchImplActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2163 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->pProxyCommitData->lastVersionTime = pContext->startTime;
															#line 2164 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		++pContext->pProxyCommitData->stats.commitBatchIn;
															#line 2165 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->setupTraceBatch();
															#line 2169 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->stage = PRE_RESOLUTION;
															#line 2170 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = CommitBatch::preresolutionProcessing(pContext);
															#line 2170 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<CommitBatchImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8080 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CommitBatchImplActor*>(this)->actor_wait_state = 2;
															#line 2170 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CommitBatchImplActor, 1, Void >*>(static_cast<CommitBatchImplActor*>(this)));
															#line 8085 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2163 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->pProxyCommitData->lastVersionTime = pContext->startTime;
															#line 2164 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		++pContext->pProxyCommitData->stats.commitBatchIn;
															#line 2165 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->setupTraceBatch();
															#line 2169 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->stage = PRE_RESOLUTION;
															#line 2170 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = CommitBatch::preresolutionProcessing(pContext);
															#line 2170 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<CommitBatchImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8104 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CommitBatchImplActor*>(this)->actor_wait_state = 2;
															#line 2170 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CommitBatchImplActor, 1, Void >*>(static_cast<CommitBatchImplActor*>(this)));
															#line 8109 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CommitBatchImplActor*>(this)->actor_wait_state > 0) static_cast<CommitBatchImplActor*>(this)->actor_wait_state = 0;
		static_cast<CommitBatchImplActor*>(this)->ActorCallback< CommitBatchImplActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CommitBatchImplActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("commitBatchImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatchImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CommitBatchImplActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("commitBatchImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatchImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CommitBatchImplActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("commitBatchImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatchImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 2171 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (pContext->rejected)
															#line 8193 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2172 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pContext->pProxyCommitData->commitBatchesMemBytesCount -= pContext->currentBatchMemBytesCount;
															#line 2173 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (!static_cast<CommitBatchImplActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CommitBatchImplActorState(); static_cast<CommitBatchImplActor*>(this)->destroy(); return 0; }
															#line 8199 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			new (&static_cast<CommitBatchImplActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~CommitBatchImplActorState();
			static_cast<CommitBatchImplActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2177 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->stage = RESOLUTION;
															#line 2178 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_2 = CommitBatch::getResolution(pContext);
															#line 2178 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<CommitBatchImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8211 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<CommitBatchImplActor*>(this)->actor_wait_state = 3;
															#line 2178 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CommitBatchImplActor, 2, Void >*>(static_cast<CommitBatchImplActor*>(this)));
															#line 8216 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 2171 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (pContext->rejected)
															#line 8225 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2172 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pContext->pProxyCommitData->commitBatchesMemBytesCount -= pContext->currentBatchMemBytesCount;
															#line 2173 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (!static_cast<CommitBatchImplActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CommitBatchImplActorState(); static_cast<CommitBatchImplActor*>(this)->destroy(); return 0; }
															#line 8231 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			new (&static_cast<CommitBatchImplActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~CommitBatchImplActorState();
			static_cast<CommitBatchImplActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2177 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->stage = RESOLUTION;
															#line 2178 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_2 = CommitBatch::getResolution(pContext);
															#line 2178 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<CommitBatchImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8243 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<CommitBatchImplActor*>(this)->actor_wait_state = 3;
															#line 2178 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CommitBatchImplActor, 2, Void >*>(static_cast<CommitBatchImplActor*>(this)));
															#line 8248 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CommitBatchImplActor*>(this)->actor_wait_state > 0) static_cast<CommitBatchImplActor*>(this)->actor_wait_state = 0;
		static_cast<CommitBatchImplActor*>(this)->ActorCallback< CommitBatchImplActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CommitBatchImplActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("commitBatchImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatchImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CommitBatchImplActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("commitBatchImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatchImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CommitBatchImplActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("commitBatchImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatchImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 2182 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->stage = POST_RESOLUTION;
															#line 2183 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_3 = CommitBatch::postResolution(pContext);
															#line 2183 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<CommitBatchImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8336 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<CommitBatchImplActor*>(this)->actor_wait_state = 4;
															#line 2183 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CommitBatchImplActor, 3, Void >*>(static_cast<CommitBatchImplActor*>(this)));
															#line 8341 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 2182 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->stage = POST_RESOLUTION;
															#line 2183 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_3 = CommitBatch::postResolution(pContext);
															#line 2183 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<CommitBatchImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8354 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<CommitBatchImplActor*>(this)->actor_wait_state = 4;
															#line 2183 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CommitBatchImplActor, 3, Void >*>(static_cast<CommitBatchImplActor*>(this)));
															#line 8359 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CommitBatchImplActor*>(this)->actor_wait_state > 0) static_cast<CommitBatchImplActor*>(this)->actor_wait_state = 0;
		static_cast<CommitBatchImplActor*>(this)->ActorCallback< CommitBatchImplActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CommitBatchImplActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("commitBatchImpl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatchImpl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CommitBatchImplActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("commitBatchImpl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatchImpl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CommitBatchImplActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("commitBatchImpl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatchImpl", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 2186 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->stage = TRANSACTION_LOGGING;
															#line 2187 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_4 = CommitBatch::transactionLogging(pContext);
															#line 2187 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<CommitBatchImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8447 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<CommitBatchImplActor*>(this)->actor_wait_state = 5;
															#line 2187 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CommitBatchImplActor, 4, Void >*>(static_cast<CommitBatchImplActor*>(this)));
															#line 8452 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 2186 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->stage = TRANSACTION_LOGGING;
															#line 2187 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_4 = CommitBatch::transactionLogging(pContext);
															#line 2187 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<CommitBatchImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8465 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<CommitBatchImplActor*>(this)->actor_wait_state = 5;
															#line 2187 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CommitBatchImplActor, 4, Void >*>(static_cast<CommitBatchImplActor*>(this)));
															#line 8470 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CommitBatchImplActor*>(this)->actor_wait_state > 0) static_cast<CommitBatchImplActor*>(this)->actor_wait_state = 0;
		static_cast<CommitBatchImplActor*>(this)->ActorCallback< CommitBatchImplActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CommitBatchImplActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("commitBatchImpl", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatchImpl", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CommitBatchImplActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("commitBatchImpl", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatchImpl", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CommitBatchImplActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("commitBatchImpl", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatchImpl", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 2191 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->stage = REPLY;
															#line 2192 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_5 = CommitBatch::reply(pContext);
															#line 2192 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<CommitBatchImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8558 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<CommitBatchImplActor*>(this)->actor_wait_state = 6;
															#line 2192 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CommitBatchImplActor, 5, Void >*>(static_cast<CommitBatchImplActor*>(this)));
															#line 8563 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 2191 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->stage = REPLY;
															#line 2192 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_5 = CommitBatch::reply(pContext);
															#line 2192 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<CommitBatchImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8576 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<CommitBatchImplActor*>(this)->actor_wait_state = 6;
															#line 2192 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CommitBatchImplActor, 5, Void >*>(static_cast<CommitBatchImplActor*>(this)));
															#line 8581 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<CommitBatchImplActor*>(this)->actor_wait_state > 0) static_cast<CommitBatchImplActor*>(this)->actor_wait_state = 0;
		static_cast<CommitBatchImplActor*>(this)->ActorCallback< CommitBatchImplActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CommitBatchImplActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("commitBatchImpl", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatchImpl", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< CommitBatchImplActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("commitBatchImpl", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatchImpl", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< CommitBatchImplActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("commitBatchImpl", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatchImpl", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
															#line 2194 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->stage = COMPLETE;
															#line 2195 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<CommitBatchImplActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CommitBatchImplActorState(); static_cast<CommitBatchImplActor*>(this)->destroy(); return 0; }
															#line 8667 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<CommitBatchImplActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CommitBatchImplActorState();
		static_cast<CommitBatchImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
															#line 2194 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->stage = COMPLETE;
															#line 2195 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<CommitBatchImplActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CommitBatchImplActorState(); static_cast<CommitBatchImplActor*>(this)->destroy(); return 0; }
															#line 8681 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<CommitBatchImplActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CommitBatchImplActorState();
		static_cast<CommitBatchImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<CommitBatchImplActor*>(this)->actor_wait_state > 0) static_cast<CommitBatchImplActor*>(this)->actor_wait_state = 0;
		static_cast<CommitBatchImplActor*>(this)->ActorCallback< CommitBatchImplActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CommitBatchImplActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("commitBatchImpl", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatchImpl", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< CommitBatchImplActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("commitBatchImpl", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatchImpl", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< CommitBatchImplActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("commitBatchImpl", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatchImpl", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 2152 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitBatchContext* pContext;
															#line 8766 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via commitBatchImpl()
															#line 2152 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class CommitBatchImplActor final : public Actor<Void>, public ActorCallback< CommitBatchImplActor, 0, Void >, public ActorCallback< CommitBatchImplActor, 1, Void >, public ActorCallback< CommitBatchImplActor, 2, Void >, public ActorCallback< CommitBatchImplActor, 3, Void >, public ActorCallback< CommitBatchImplActor, 4, Void >, public ActorCallback< CommitBatchImplActor, 5, Void >, public FastAllocated<CommitBatchImplActor>, public CommitBatchImplActorState<CommitBatchImplActor> {
															#line 8771 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<CommitBatchImplActor>::operator new;
	using FastAllocated<CommitBatchImplActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6940978130376142592UL, 14893297200144201984UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CommitBatchImplActor, 0, Void >;
friend struct ActorCallback< CommitBatchImplActor, 1, Void >;
friend struct ActorCallback< CommitBatchImplActor, 2, Void >;
friend struct ActorCallback< CommitBatchImplActor, 3, Void >;
friend struct ActorCallback< CommitBatchImplActor, 4, Void >;
friend struct ActorCallback< CommitBatchImplActor, 5, Void >;
															#line 2152 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitBatchImplActor(CommitBatchContext* const& pContext) 
															#line 8793 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   CommitBatchImplActorState<CommitBatchImplActor>(pContext),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("commitBatchImpl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11797433405479390208UL, 8635865864950152704UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("commitBatchImpl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("commitBatchImpl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CommitBatchImplActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CommitBatchImplActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CommitBatchImplActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CommitBatchImplActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< CommitBatchImplActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< CommitBatchImplActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2152 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> commitBatchImpl( CommitBatchContext* const& pContext ) {
															#line 2152 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new CommitBatchImplActor(pContext));
															#line 8830 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 2197 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

} // namespace CommitBatch

															#line 8837 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via commitBatch()
															#line 2200 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class CommitBatchActor>
															#line 2200 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class CommitBatchActorState {
															#line 8844 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 2200 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitBatchActorState(ProxyCommitData* const& pCommitData,std::vector<CommitTransactionRequest>* const& trs,int const& currentBatchMemBytesCount) 
															#line 2200 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 2200 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : pCommitData(pCommitData),
															#line 2200 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   trs(trs),
															#line 2200 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   currentBatchMemBytesCount(currentBatchMemBytesCount),
															#line 2204 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   context(pCommitData, trs, currentBatchMemBytesCount)
															#line 8857 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("commitBatch", reinterpret_cast<unsigned long>(this));

	}
	~CommitBatchActorState() 
	{
		fdb_probe_actor_destroy("commitBatch", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2206 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			Future<Void> commit = CommitBatch::commitBatchImpl(&context);
															#line 2213 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			Future<Void> livenessTimeout = timeoutErrorIfCleared( commit, pCommitData->encryptionMonitor->degraded(), SERVER_KNOBS->COMMIT_PROXY_LIVENESS_TIMEOUT);
															#line 2216 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			Future<Void> maxLivenessTimeout = timeoutError(livenessTimeout, SERVER_KNOBS->COMMIT_PROXY_MAX_LIVENESS_TIMEOUT);
															#line 8876 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			try {
															#line 2218 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				StrictFuture<Void> __when_expr_0 = maxLivenessTimeout;
															#line 2218 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (static_cast<CommitBatchActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 8882 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<CommitBatchActor*>(this)->actor_wait_state = 1;
															#line 2218 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CommitBatchActor, 0, Void >*>(static_cast<CommitBatchActor*>(this)));
															#line 8887 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CommitBatchActorState();
		static_cast<CommitBatchActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2226 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<CommitBatchActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CommitBatchActorState(); static_cast<CommitBatchActor*>(this)->destroy(); return 0; }
															#line 8916 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<CommitBatchActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CommitBatchActorState();
		static_cast<CommitBatchActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& err,int loopDepth=0) 
	{
		try {
															#line 2220 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent(SevInfo, "CommitBatchFailed", pCommitData->dbgid) .detail("Stage", context.stage) .detail("ErrorCode", err.code());
															#line 2223 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			return a_body1Catch1(failed_to_progress(), loopDepth);
															#line 8931 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CommitBatchActor*>(this)->actor_wait_state > 0) static_cast<CommitBatchActor*>(this)->actor_wait_state = 0;
		static_cast<CommitBatchActor*>(this)->ActorCallback< CommitBatchActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CommitBatchActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("commitBatch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatch", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CommitBatchActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("commitBatch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatch", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CommitBatchActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("commitBatch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatch", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 2200 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCommitData* pCommitData;
															#line 2200 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	std::vector<CommitTransactionRequest>* trs;
															#line 2200 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	int currentBatchMemBytesCount;
															#line 2204 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitBatch::CommitBatchContext context;
															#line 9049 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via commitBatch()
															#line 2200 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class CommitBatchActor final : public Actor<Void>, public ActorCallback< CommitBatchActor, 0, Void >, public FastAllocated<CommitBatchActor>, public CommitBatchActorState<CommitBatchActor> {
															#line 9054 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<CommitBatchActor>::operator new;
	using FastAllocated<CommitBatchActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16791399661680468480UL, 15794895408589282816UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CommitBatchActor, 0, Void >;
															#line 2200 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitBatchActor(ProxyCommitData* const& pCommitData,std::vector<CommitTransactionRequest>* const& trs,int const& currentBatchMemBytesCount) 
															#line 9071 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   CommitBatchActorState<CommitBatchActor>(pCommitData, trs, currentBatchMemBytesCount),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("commitBatch", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17605101362369555456UL, 10066483790240320512UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("commitBatch");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("commitBatch", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CommitBatchActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2200 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> commitBatch( ProxyCommitData* const& pCommitData, std::vector<CommitTransactionRequest>* const& trs, int const& currentBatchMemBytesCount ) {
															#line 2200 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new CommitBatchActor(pCommitData, trs, currentBatchMemBytesCount));
															#line 9104 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 2228 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

// Add tss mapping data to the reply, if any of the included storage servers have a TSS pair
void maybeAddTssMapping(GetKeyServerLocationsReply& reply,
                        ProxyCommitData* commitData,
                        std::unordered_set<UID>& included,
                        UID ssId) {
	if (!included.contains(ssId)) {
		auto mappingItr = commitData->tssMapping.find(ssId);
		if (mappingItr != commitData->tssMapping.end()) {
			reply.resultsTssMapping.push_back(*mappingItr);
		}
		included.insert(ssId);
	}
}

void addTagMapping(GetKeyServerLocationsReply& reply, ProxyCommitData* commitData) {
	for (const auto& [_, shard] : reply.results) {
		for (auto& ssi : shard) {
			auto iter = commitData->storageCache.find(ssi.id());
			ASSERT_WE_THINK(iter != commitData->storageCache.end());
			reply.resultsTagMapping.emplace_back(ssi.id(), iter->second->tag);
		}
	}
}

															#line 9133 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via doKeyServerLocationRequest()
															#line 2253 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class DoKeyServerLocationRequestActor>
															#line 2253 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class DoKeyServerLocationRequestActorState {
															#line 9140 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 2253 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	DoKeyServerLocationRequestActorState(GetKeyServerLocationsRequest const& req,ProxyCommitData* const& commitData) 
															#line 2253 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 2253 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : req(req),
															#line 2253 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   commitData(commitData)
															#line 9149 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("doKeyServerLocationRequest", reinterpret_cast<unsigned long>(this));

	}
	~DoKeyServerLocationRequestActorState() 
	{
		fdb_probe_actor_destroy("doKeyServerLocationRequest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2255 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			getCurrentLineage()->modify(&TransactionLineage::operation) = TransactionLineage::Operation::GetKeyServersLocations;
															#line 2256 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			getCurrentLineage()->modify(&TransactionLineage::txID) = req.spanContext.traceID;
															#line 2258 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = commitData->validState.getFuture();
															#line 2258 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<DoKeyServerLocationRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9170 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DoKeyServerLocationRequestActor*>(this)->actor_wait_state = 1;
															#line 2258 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoKeyServerLocationRequestActor, 0, Void >*>(static_cast<DoKeyServerLocationRequestActor*>(this)));
															#line 9175 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoKeyServerLocationRequestActorState();
		static_cast<DoKeyServerLocationRequestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2260 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(0, TaskPriority::DefaultEndpoint);
															#line 2260 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<DoKeyServerLocationRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9200 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DoKeyServerLocationRequestActor*>(this)->actor_wait_state = 2;
															#line 2260 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoKeyServerLocationRequestActor, 1, Void >*>(static_cast<DoKeyServerLocationRequestActor*>(this)));
															#line 9205 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2260 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(0, TaskPriority::DefaultEndpoint);
															#line 2260 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<DoKeyServerLocationRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9216 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DoKeyServerLocationRequestActor*>(this)->actor_wait_state = 2;
															#line 2260 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoKeyServerLocationRequestActor, 1, Void >*>(static_cast<DoKeyServerLocationRequestActor*>(this)));
															#line 9221 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoKeyServerLocationRequestActor*>(this)->actor_wait_state > 0) static_cast<DoKeyServerLocationRequestActor*>(this)->actor_wait_state = 0;
		static_cast<DoKeyServerLocationRequestActor*>(this)->ActorCallback< DoKeyServerLocationRequestActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoKeyServerLocationRequestActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doKeyServerLocationRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoKeyServerLocationRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doKeyServerLocationRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoKeyServerLocationRequestActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doKeyServerLocationRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoKeyServerLocationRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doKeyServerLocationRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoKeyServerLocationRequestActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doKeyServerLocationRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoKeyServerLocationRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doKeyServerLocationRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 2262 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		std::unordered_set<UID> tssMappingsIncluded;
															#line 2263 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		GetKeyServerLocationsReply rep;
															#line 2265 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!req.end.present())
															#line 9309 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2266 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			auto r = req.reverse ? commitData->keyInfo.rangeContainingKeyBefore(req.begin) : commitData->keyInfo.rangeContaining(req.begin);
															#line 2268 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			std::vector<StorageServerInterface> ssis;
															#line 2269 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ssis.reserve(r.value().src_info.size());
															#line 2270 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for( auto& it : r.value().src_info ) {
															#line 2271 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				ssis.push_back(it->interf);
															#line 2272 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				maybeAddTssMapping(rep, commitData, tssMappingsIncluded, it->interf.id());
															#line 9323 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 2274 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			rep.results.emplace_back(r.range(), ssis);
															#line 9327 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2275 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (!req.reverse)
															#line 9333 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 2276 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				int count = 0;
															#line 2277 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				for(auto r = commitData->keyInfo.rangeContaining(req.begin);r != commitData->keyInfo.ranges().end() && count < req.limit && r.begin() < req.end.get();++r) {
															#line 2280 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					std::vector<StorageServerInterface> ssis;
															#line 2281 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					ssis.reserve(r.value().src_info.size());
															#line 2282 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					for( auto& it : r.value().src_info ) {
															#line 2283 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						ssis.push_back(it->interf);
															#line 2284 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						maybeAddTssMapping(rep, commitData, tssMappingsIncluded, it->interf.id());
															#line 9349 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					}
															#line 2286 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					rep.results.emplace_back(r.range(), ssis);
															#line 2287 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					count++;
															#line 9355 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				}
			}
			else
			{
															#line 2290 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				int count = 0;
															#line 2291 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				auto r = commitData->keyInfo.rangeContainingKeyBefore(req.end.get());
															#line 2292 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				for(;count < req.limit && req.begin < r.end();) {
															#line 2293 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					std::vector<StorageServerInterface> ssis;
															#line 2294 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					ssis.reserve(r.value().src_info.size());
															#line 2295 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					for( auto& it : r.value().src_info ) {
															#line 2296 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						ssis.push_back(it->interf);
															#line 2297 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						maybeAddTssMapping(rep, commitData, tssMappingsIncluded, it->interf.id());
															#line 9376 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					}
															#line 2299 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					rep.results.emplace_back(r.range(), ssis);
															#line 2300 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					if (r == commitData->keyInfo.ranges().begin())
															#line 9382 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					{
						break;
					}
															#line 2303 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					count++;
															#line 2304 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					--r;
															#line 9390 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				}
			}
		}
															#line 2307 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		addTagMapping(rep, commitData);
															#line 2308 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		req.reply.send(rep);
															#line 2309 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		++commitData->stats.keyServerLocationOut;
															#line 2310 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<DoKeyServerLocationRequestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoKeyServerLocationRequestActorState(); static_cast<DoKeyServerLocationRequestActor*>(this)->destroy(); return 0; }
															#line 9402 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<DoKeyServerLocationRequestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoKeyServerLocationRequestActorState();
		static_cast<DoKeyServerLocationRequestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 2262 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		std::unordered_set<UID> tssMappingsIncluded;
															#line 2263 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		GetKeyServerLocationsReply rep;
															#line 2265 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!req.end.present())
															#line 9418 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2266 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			auto r = req.reverse ? commitData->keyInfo.rangeContainingKeyBefore(req.begin) : commitData->keyInfo.rangeContaining(req.begin);
															#line 2268 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			std::vector<StorageServerInterface> ssis;
															#line 2269 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ssis.reserve(r.value().src_info.size());
															#line 2270 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for( auto& it : r.value().src_info ) {
															#line 2271 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				ssis.push_back(it->interf);
															#line 2272 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				maybeAddTssMapping(rep, commitData, tssMappingsIncluded, it->interf.id());
															#line 9432 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 2274 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			rep.results.emplace_back(r.range(), ssis);
															#line 9436 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2275 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (!req.reverse)
															#line 9442 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 2276 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				int count = 0;
															#line 2277 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				for(auto r = commitData->keyInfo.rangeContaining(req.begin);r != commitData->keyInfo.ranges().end() && count < req.limit && r.begin() < req.end.get();++r) {
															#line 2280 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					std::vector<StorageServerInterface> ssis;
															#line 2281 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					ssis.reserve(r.value().src_info.size());
															#line 2282 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					for( auto& it : r.value().src_info ) {
															#line 2283 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						ssis.push_back(it->interf);
															#line 2284 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						maybeAddTssMapping(rep, commitData, tssMappingsIncluded, it->interf.id());
															#line 9458 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					}
															#line 2286 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					rep.results.emplace_back(r.range(), ssis);
															#line 2287 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					count++;
															#line 9464 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				}
			}
			else
			{
															#line 2290 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				int count = 0;
															#line 2291 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				auto r = commitData->keyInfo.rangeContainingKeyBefore(req.end.get());
															#line 2292 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				for(;count < req.limit && req.begin < r.end();) {
															#line 2293 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					std::vector<StorageServerInterface> ssis;
															#line 2294 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					ssis.reserve(r.value().src_info.size());
															#line 2295 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					for( auto& it : r.value().src_info ) {
															#line 2296 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						ssis.push_back(it->interf);
															#line 2297 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						maybeAddTssMapping(rep, commitData, tssMappingsIncluded, it->interf.id());
															#line 9485 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					}
															#line 2299 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					rep.results.emplace_back(r.range(), ssis);
															#line 2300 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					if (r == commitData->keyInfo.ranges().begin())
															#line 9491 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					{
						break;
					}
															#line 2303 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					count++;
															#line 2304 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					--r;
															#line 9499 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				}
			}
		}
															#line 2307 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		addTagMapping(rep, commitData);
															#line 2308 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		req.reply.send(rep);
															#line 2309 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		++commitData->stats.keyServerLocationOut;
															#line 2310 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<DoKeyServerLocationRequestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoKeyServerLocationRequestActorState(); static_cast<DoKeyServerLocationRequestActor*>(this)->destroy(); return 0; }
															#line 9511 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<DoKeyServerLocationRequestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoKeyServerLocationRequestActorState();
		static_cast<DoKeyServerLocationRequestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoKeyServerLocationRequestActor*>(this)->actor_wait_state > 0) static_cast<DoKeyServerLocationRequestActor*>(this)->actor_wait_state = 0;
		static_cast<DoKeyServerLocationRequestActor*>(this)->ActorCallback< DoKeyServerLocationRequestActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoKeyServerLocationRequestActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doKeyServerLocationRequest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoKeyServerLocationRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doKeyServerLocationRequest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoKeyServerLocationRequestActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doKeyServerLocationRequest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoKeyServerLocationRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doKeyServerLocationRequest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoKeyServerLocationRequestActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doKeyServerLocationRequest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoKeyServerLocationRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doKeyServerLocationRequest", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2253 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	GetKeyServerLocationsRequest req;
															#line 2253 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCommitData* commitData;
															#line 9598 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via doKeyServerLocationRequest()
															#line 2253 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class DoKeyServerLocationRequestActor final : public Actor<Void>, public ActorCallback< DoKeyServerLocationRequestActor, 0, Void >, public ActorCallback< DoKeyServerLocationRequestActor, 1, Void >, public FastAllocated<DoKeyServerLocationRequestActor>, public DoKeyServerLocationRequestActorState<DoKeyServerLocationRequestActor> {
															#line 9603 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<DoKeyServerLocationRequestActor>::operator new;
	using FastAllocated<DoKeyServerLocationRequestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1383753982199176192UL, 6614515819908822016UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoKeyServerLocationRequestActor, 0, Void >;
friend struct ActorCallback< DoKeyServerLocationRequestActor, 1, Void >;
															#line 2253 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	DoKeyServerLocationRequestActor(GetKeyServerLocationsRequest const& req,ProxyCommitData* const& commitData) 
															#line 9621 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   DoKeyServerLocationRequestActorState<DoKeyServerLocationRequestActor>(req, commitData),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doKeyServerLocationRequest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4295041835434509824UL, 5382091244808472320UL);
		ActorExecutionContextHelper __helper(static_cast<DoKeyServerLocationRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doKeyServerLocationRequest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doKeyServerLocationRequest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoKeyServerLocationRequestActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoKeyServerLocationRequestActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2253 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] static Future<Void> doKeyServerLocationRequest( GetKeyServerLocationsRequest const& req, ProxyCommitData* const& commitData ) {
															#line 2253 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new DoKeyServerLocationRequestActor(req, commitData));
															#line 9655 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 2312 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

															#line 9660 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via readRequestServer()
															#line 2313 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class ReadRequestServerActor>
															#line 2313 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class ReadRequestServerActorState {
															#line 9667 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 2313 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ReadRequestServerActorState(CommitProxyInterface const& proxy,PromiseStream<Future<Void>> const& addActor,ProxyCommitData* const& commitData) 
															#line 2313 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 2313 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : proxy(proxy),
															#line 2313 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   addActor(addActor),
															#line 2313 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   commitData(commitData)
															#line 9678 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("readRequestServer", reinterpret_cast<unsigned long>(this));

	}
	~ReadRequestServerActorState() 
	{
		fdb_probe_actor_destroy("readRequestServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2316 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			;
															#line 9693 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadRequestServerActorState();
		static_cast<ReadRequestServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2317 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		auto __when_expr_0 = proxy.getKeyServersLocations.getFuture();
															#line 9723 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<GetKeyServerLocationsRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<GetKeyServerLocationsRequest>>::value, "invalid type");
															#line 2317 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<ReadRequestServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9727 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
		static_cast<ReadRequestServerActor*>(this)->actor_wait_state = 1;
															#line 2317 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< ReadRequestServerActor, 0, GetKeyServerLocationsRequest >*>(static_cast<ReadRequestServerActor*>(this)));
															#line 9732 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(GetKeyServerLocationsRequest const& req,int loopDepth) 
	{
															#line 2319 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (req.limit != CLIENT_KNOBS->STORAGE_METRICS_SHARD_LIMIT && (commitData->stats.keyServerLocationIn.getValue() - commitData->stats.keyServerLocationOut.getValue() > SERVER_KNOBS->KEY_LOCATION_MAX_QUEUE_SIZE || (g_network->isSimulated() && BUGGIFY_WITH_PROB(0.001))))
															#line 9741 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2323 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			++commitData->stats.keyServerLocationErrors;
															#line 2324 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.reply.sendError(commit_proxy_memory_limit_exceeded());
															#line 2325 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent(SevWarnAlways, "ProxyLocationRequestThresholdExceeded").suppressFor(60);
															#line 9749 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2327 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			++commitData->stats.keyServerLocationIn;
															#line 2328 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			addActor.send(doKeyServerLocationRequest(req, commitData));
															#line 9757 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(GetKeyServerLocationsRequest && req,int loopDepth) 
	{
															#line 2319 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (req.limit != CLIENT_KNOBS->STORAGE_METRICS_SHARD_LIMIT && (commitData->stats.keyServerLocationIn.getValue() - commitData->stats.keyServerLocationOut.getValue() > SERVER_KNOBS->KEY_LOCATION_MAX_QUEUE_SIZE || (g_network->isSimulated() && BUGGIFY_WITH_PROB(0.001))))
															#line 9767 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2323 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			++commitData->stats.keyServerLocationErrors;
															#line 2324 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.reply.sendError(commit_proxy_memory_limit_exceeded());
															#line 2325 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent(SevWarnAlways, "ProxyLocationRequestThresholdExceeded").suppressFor(60);
															#line 9775 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2327 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			++commitData->stats.keyServerLocationIn;
															#line 2328 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			addActor.send(doKeyServerLocationRequest(req, commitData));
															#line 9783 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetKeyServerLocationsRequest const& req,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(req, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetKeyServerLocationsRequest && req,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(req), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadRequestServerActor*>(this)->actor_wait_state > 0) static_cast<ReadRequestServerActor*>(this)->actor_wait_state = 0;
		static_cast<ReadRequestServerActor*>(this)->ActorSingleCallback< ReadRequestServerActor, 0, GetKeyServerLocationsRequest >::remove();

	}
	void a_callback_fire(ActorSingleCallback< ReadRequestServerActor, 0, GetKeyServerLocationsRequest >*,GetKeyServerLocationsRequest const& value) 
	{
		fdb_probe_actor_enter("readRequestServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readRequestServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< ReadRequestServerActor, 0, GetKeyServerLocationsRequest >*,GetKeyServerLocationsRequest && value) 
	{
		fdb_probe_actor_enter("readRequestServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readRequestServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< ReadRequestServerActor, 0, GetKeyServerLocationsRequest >*,Error err) 
	{
		fdb_probe_actor_enter("readRequestServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readRequestServer", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2313 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitProxyInterface proxy;
															#line 2313 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	PromiseStream<Future<Void>> addActor;
															#line 2313 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCommitData* commitData;
															#line 9870 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via readRequestServer()
															#line 2313 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class ReadRequestServerActor final : public Actor<Void>, public ActorSingleCallback< ReadRequestServerActor, 0, GetKeyServerLocationsRequest >, public FastAllocated<ReadRequestServerActor>, public ReadRequestServerActorState<ReadRequestServerActor> {
															#line 9875 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<ReadRequestServerActor>::operator new;
	using FastAllocated<ReadRequestServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11529347089928544256UL, 8216029123133534720UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< ReadRequestServerActor, 0, GetKeyServerLocationsRequest >;
															#line 2313 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ReadRequestServerActor(CommitProxyInterface const& proxy,PromiseStream<Future<Void>> const& addActor,ProxyCommitData* const& commitData) 
															#line 9892 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ReadRequestServerActorState<ReadRequestServerActor>(proxy, addActor, commitData),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readRequestServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7015573509160306432UL, 3123064095005483520UL);
		ActorExecutionContextHelper __helper(static_cast<ReadRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readRequestServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readRequestServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< ReadRequestServerActor, 0, GetKeyServerLocationsRequest >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2313 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] static Future<Void> readRequestServer( CommitProxyInterface const& proxy, PromiseStream<Future<Void>> const& addActor, ProxyCommitData* const& commitData ) {
															#line 2313 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new ReadRequestServerActor(proxy, addActor, commitData));
															#line 9925 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 2332 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

															#line 9930 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via rejoinServer()
															#line 2333 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class RejoinServerActor>
															#line 2333 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class RejoinServerActorState {
															#line 9937 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 2333 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	RejoinServerActorState(CommitProxyInterface const& proxy,ProxyCommitData* const& commitData) 
															#line 2333 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 2333 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : proxy(proxy),
															#line 2333 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   commitData(commitData)
															#line 9946 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("rejoinServer", reinterpret_cast<unsigned long>(this));

	}
	~RejoinServerActorState() 
	{
		fdb_probe_actor_destroy("rejoinServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2335 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = commitData->validState.getFuture();
															#line 2335 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<RejoinServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9963 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RejoinServerActor*>(this)->actor_wait_state = 1;
															#line 2335 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RejoinServerActor, 0, Void >*>(static_cast<RejoinServerActor*>(this)));
															#line 9968 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RejoinServerActorState();
		static_cast<RejoinServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2337 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		TraceEvent("ProxyReadyForReads", proxy.id()).log();
															#line 2339 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		;
															#line 9993 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2337 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		TraceEvent("ProxyReadyForReads", proxy.id()).log();
															#line 2339 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		;
															#line 10004 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RejoinServerActor*>(this)->actor_wait_state > 0) static_cast<RejoinServerActor*>(this)->actor_wait_state = 0;
		static_cast<RejoinServerActor*>(this)->ActorCallback< RejoinServerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RejoinServerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("rejoinServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RejoinServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rejoinServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RejoinServerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("rejoinServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RejoinServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rejoinServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RejoinServerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("rejoinServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RejoinServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rejoinServer", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 2340 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		auto __when_expr_1 = proxy.getStorageServerRejoinInfo.getFuture();
															#line 10095 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_1), FutureStream<GetStorageServerRejoinInfoRequest>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<GetStorageServerRejoinInfoRequest>>::value, "invalid type");
															#line 2340 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<RejoinServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10099 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.pop(), loopDepth); };
		static_cast<RejoinServerActor*>(this)->actor_wait_state = 2;
															#line 2340 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< RejoinServerActor, 1, GetStorageServerRejoinInfoRequest >*>(static_cast<RejoinServerActor*>(this)));
															#line 10104 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(GetStorageServerRejoinInfoRequest const& req,int loopDepth) 
	{
															#line 2341 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (commitData->txnStateStore->readValue(serverListKeyFor(req.id)).get().present())
															#line 10113 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2342 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			GetStorageServerRejoinInfoReply rep;
															#line 2343 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			rep.version = commitData->version.get();
															#line 2344 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			rep.tag = decodeServerTagValue(commitData->txnStateStore->readValue(serverTagKeyFor(req.id)).get().get());
															#line 2345 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			RangeResult history = commitData->txnStateStore->readRange(serverTagHistoryRangeFor(req.id)).get();
															#line 2346 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for(int i = history.size() - 1;i >= 0;i--) {
															#line 2347 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				rep.history.push_back( std::make_pair(decodeServerTagHistoryKey(history[i].key), decodeServerTagValue(history[i].value)));
															#line 10127 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 2350 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			auto localityKey = commitData->txnStateStore->readValue(tagLocalityListKeyFor(req.dcId)).get();
															#line 2351 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			rep.newLocality = false;
															#line 2352 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (localityKey.present())
															#line 10135 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 2353 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				int8_t locality = decodeTagLocalityListValue(localityKey.get());
															#line 2354 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (locality != rep.tag.locality)
															#line 10141 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				{
															#line 2355 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					TraceEvent(SevWarnAlways, "SSRejoinedWithChangedLocality") .detail("Tag", rep.tag.toString()) .detail("DcId", req.dcId) .detail("NewLocality", locality);
															#line 10145 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				}
				else
				{
															#line 2359 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					if (locality != rep.tag.locality)
															#line 10151 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					{
															#line 2360 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						uint16_t tagId = 0;
															#line 2361 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						std::vector<uint16_t> usedTags;
															#line 2362 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						auto tagKeys = commitData->txnStateStore->readRange(serverTagKeys).get();
															#line 2363 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						for( auto& kv : tagKeys ) {
															#line 2364 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							Tag t = decodeServerTagValue(kv.value);
															#line 2365 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							if (t.locality == locality)
															#line 10165 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
							{
															#line 2366 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
								usedTags.push_back(t.id);
															#line 10169 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
							}
						}
															#line 2369 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						auto historyKeys = commitData->txnStateStore->readRange(serverTagHistoryKeys).get();
															#line 2370 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						for( auto& kv : historyKeys ) {
															#line 2371 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							Tag t = decodeServerTagValue(kv.value);
															#line 2372 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							if (t.locality == locality)
															#line 10180 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
							{
															#line 2373 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
								usedTags.push_back(t.id);
															#line 10184 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
							}
						}
															#line 2376 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						std::sort(usedTags.begin(), usedTags.end());
															#line 2378 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						int usedIdx = 0;
															#line 2379 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						for(;usedTags.size() > 0 && tagId <= usedTags.end()[-1];tagId++) {
															#line 2380 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							if (tagId < usedTags[usedIdx])
															#line 10195 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
							{
								break;
							}
							else
							{
															#line 2383 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
								usedIdx++;
															#line 10203 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
							}
						}
															#line 2386 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						rep.newTag = Tag(locality, tagId);
															#line 10208 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					}
				}
			}
			else
			{
															#line 2389 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				ASSERT_WE_THINK(rep.tag.locality != tagLocalityUpgraded);
															#line 2390 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				TraceEvent(SevWarnAlways, "SSRejoinedWithUnknownLocality") .detail("Tag", rep.tag.toString()) .detail("DcId", req.dcId);
															#line 10218 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 2394 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			rep.encryptMode = commitData->encryptMode;
															#line 2395 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.reply.send(rep);
															#line 10224 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2397 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.reply.sendError(worker_removed());
															#line 10230 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(GetStorageServerRejoinInfoRequest && req,int loopDepth) 
	{
															#line 2341 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (commitData->txnStateStore->readValue(serverListKeyFor(req.id)).get().present())
															#line 10240 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2342 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			GetStorageServerRejoinInfoReply rep;
															#line 2343 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			rep.version = commitData->version.get();
															#line 2344 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			rep.tag = decodeServerTagValue(commitData->txnStateStore->readValue(serverTagKeyFor(req.id)).get().get());
															#line 2345 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			RangeResult history = commitData->txnStateStore->readRange(serverTagHistoryRangeFor(req.id)).get();
															#line 2346 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for(int i = history.size() - 1;i >= 0;i--) {
															#line 2347 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				rep.history.push_back( std::make_pair(decodeServerTagHistoryKey(history[i].key), decodeServerTagValue(history[i].value)));
															#line 10254 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 2350 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			auto localityKey = commitData->txnStateStore->readValue(tagLocalityListKeyFor(req.dcId)).get();
															#line 2351 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			rep.newLocality = false;
															#line 2352 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (localityKey.present())
															#line 10262 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 2353 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				int8_t locality = decodeTagLocalityListValue(localityKey.get());
															#line 2354 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (locality != rep.tag.locality)
															#line 10268 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				{
															#line 2355 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					TraceEvent(SevWarnAlways, "SSRejoinedWithChangedLocality") .detail("Tag", rep.tag.toString()) .detail("DcId", req.dcId) .detail("NewLocality", locality);
															#line 10272 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				}
				else
				{
															#line 2359 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					if (locality != rep.tag.locality)
															#line 10278 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					{
															#line 2360 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						uint16_t tagId = 0;
															#line 2361 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						std::vector<uint16_t> usedTags;
															#line 2362 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						auto tagKeys = commitData->txnStateStore->readRange(serverTagKeys).get();
															#line 2363 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						for( auto& kv : tagKeys ) {
															#line 2364 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							Tag t = decodeServerTagValue(kv.value);
															#line 2365 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							if (t.locality == locality)
															#line 10292 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
							{
															#line 2366 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
								usedTags.push_back(t.id);
															#line 10296 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
							}
						}
															#line 2369 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						auto historyKeys = commitData->txnStateStore->readRange(serverTagHistoryKeys).get();
															#line 2370 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						for( auto& kv : historyKeys ) {
															#line 2371 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							Tag t = decodeServerTagValue(kv.value);
															#line 2372 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							if (t.locality == locality)
															#line 10307 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
							{
															#line 2373 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
								usedTags.push_back(t.id);
															#line 10311 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
							}
						}
															#line 2376 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						std::sort(usedTags.begin(), usedTags.end());
															#line 2378 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						int usedIdx = 0;
															#line 2379 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						for(;usedTags.size() > 0 && tagId <= usedTags.end()[-1];tagId++) {
															#line 2380 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							if (tagId < usedTags[usedIdx])
															#line 10322 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
							{
								break;
							}
							else
							{
															#line 2383 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
								usedIdx++;
															#line 10330 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
							}
						}
															#line 2386 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						rep.newTag = Tag(locality, tagId);
															#line 10335 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					}
				}
			}
			else
			{
															#line 2389 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				ASSERT_WE_THINK(rep.tag.locality != tagLocalityUpgraded);
															#line 2390 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				TraceEvent(SevWarnAlways, "SSRejoinedWithUnknownLocality") .detail("Tag", rep.tag.toString()) .detail("DcId", req.dcId);
															#line 10345 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 2394 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			rep.encryptMode = commitData->encryptMode;
															#line 2395 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.reply.send(rep);
															#line 10351 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2397 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.reply.sendError(worker_removed());
															#line 10357 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(GetStorageServerRejoinInfoRequest const& req,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(req, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(GetStorageServerRejoinInfoRequest && req,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(req), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RejoinServerActor*>(this)->actor_wait_state > 0) static_cast<RejoinServerActor*>(this)->actor_wait_state = 0;
		static_cast<RejoinServerActor*>(this)->ActorSingleCallback< RejoinServerActor, 1, GetStorageServerRejoinInfoRequest >::remove();

	}
	void a_callback_fire(ActorSingleCallback< RejoinServerActor, 1, GetStorageServerRejoinInfoRequest >*,GetStorageServerRejoinInfoRequest const& value) 
	{
		fdb_probe_actor_enter("rejoinServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RejoinServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rejoinServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< RejoinServerActor, 1, GetStorageServerRejoinInfoRequest >*,GetStorageServerRejoinInfoRequest && value) 
	{
		fdb_probe_actor_enter("rejoinServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RejoinServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rejoinServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< RejoinServerActor, 1, GetStorageServerRejoinInfoRequest >*,Error err) 
	{
		fdb_probe_actor_enter("rejoinServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RejoinServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rejoinServer", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2333 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitProxyInterface proxy;
															#line 2333 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCommitData* commitData;
															#line 10442 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via rejoinServer()
															#line 2333 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class RejoinServerActor final : public Actor<Void>, public ActorCallback< RejoinServerActor, 0, Void >, public ActorSingleCallback< RejoinServerActor, 1, GetStorageServerRejoinInfoRequest >, public FastAllocated<RejoinServerActor>, public RejoinServerActorState<RejoinServerActor> {
															#line 10447 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<RejoinServerActor>::operator new;
	using FastAllocated<RejoinServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15866114411220576768UL, 17651593019539971328UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RejoinServerActor, 0, Void >;
friend struct ActorSingleCallback< RejoinServerActor, 1, GetStorageServerRejoinInfoRequest >;
															#line 2333 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	RejoinServerActor(CommitProxyInterface const& proxy,ProxyCommitData* const& commitData) 
															#line 10465 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   RejoinServerActorState<RejoinServerActor>(proxy, commitData),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("rejoinServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6499651042657228288UL, 13021739501090474752UL);
		ActorExecutionContextHelper __helper(static_cast<RejoinServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("rejoinServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("rejoinServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RejoinServerActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorSingleCallback< RejoinServerActor, 1, GetStorageServerRejoinInfoRequest >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2333 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] static Future<Void> rejoinServer( CommitProxyInterface const& proxy, ProxyCommitData* const& commitData ) {
															#line 2333 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new RejoinServerActor(proxy, commitData));
															#line 10499 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 2401 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

															#line 10504 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via ddMetricsRequestServer()
															#line 2402 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class DdMetricsRequestServerActor>
															#line 2402 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class DdMetricsRequestServerActorState {
															#line 10511 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 2402 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	DdMetricsRequestServerActorState(CommitProxyInterface const& proxy,Reference<AsyncVar<ServerDBInfo> const> const& db) 
															#line 2402 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 2402 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : proxy(proxy),
															#line 2402 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   db(db)
															#line 10520 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("ddMetricsRequestServer", reinterpret_cast<unsigned long>(this));

	}
	~DdMetricsRequestServerActorState() 
	{
		fdb_probe_actor_destroy("ddMetricsRequestServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2403 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			;
															#line 10535 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DdMetricsRequestServerActorState();
		static_cast<DdMetricsRequestServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2405 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		auto __when_expr_0 = proxy.getDDMetrics.getFuture();
															#line 10565 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<GetDDMetricsRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<GetDDMetricsRequest>>::value, "invalid type");
															#line 2404 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<DdMetricsRequestServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10569 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
		static_cast<DdMetricsRequestServerActor*>(this)->actor_wait_state = 1;
															#line 2405 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< DdMetricsRequestServerActor, 0, GetDDMetricsRequest >*>(static_cast<DdMetricsRequestServerActor*>(this)));
															#line 10574 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetDDMetricsRequest const& __req,int loopDepth) 
	{
															#line 2405 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		req = __req;
															#line 2406 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!db->get().distributor.present())
															#line 10591 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2407 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.reply.sendError(dd_not_found());
															#line 10595 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			return a_body1loopHead1(loopDepth); // continue
		}
															#line 2410 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<ErrorOr<GetDataDistributorMetricsReply>> __when_expr_1 = errorOr(db->get().distributor.get().dataDistributorMetrics.getReply( GetDataDistributorMetricsRequest(req.keys, req.shardLimit)));
															#line 2410 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<DdMetricsRequestServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10602 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DdMetricsRequestServerActor*>(this)->actor_wait_state = 2;
															#line 2410 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DdMetricsRequestServerActor, 1, ErrorOr<GetDataDistributorMetricsReply> >*>(static_cast<DdMetricsRequestServerActor*>(this)));
															#line 10607 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(GetDDMetricsRequest && __req,int loopDepth) 
	{
		req = std::move(__req);
															#line 2406 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!db->get().distributor.present())
															#line 10617 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2407 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.reply.sendError(dd_not_found());
															#line 10621 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			return a_body1loopHead1(loopDepth); // continue
		}
															#line 2410 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<ErrorOr<GetDataDistributorMetricsReply>> __when_expr_1 = errorOr(db->get().distributor.get().dataDistributorMetrics.getReply( GetDataDistributorMetricsRequest(req.keys, req.shardLimit)));
															#line 2410 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<DdMetricsRequestServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10628 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DdMetricsRequestServerActor*>(this)->actor_wait_state = 2;
															#line 2410 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DdMetricsRequestServerActor, 1, ErrorOr<GetDataDistributorMetricsReply> >*>(static_cast<DdMetricsRequestServerActor*>(this)));
															#line 10633 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DdMetricsRequestServerActor*>(this)->actor_wait_state > 0) static_cast<DdMetricsRequestServerActor*>(this)->actor_wait_state = 0;
		static_cast<DdMetricsRequestServerActor*>(this)->ActorSingleCallback< DdMetricsRequestServerActor, 0, GetDDMetricsRequest >::remove();

	}
	int a_body1loopBody1when1cont1(ErrorOr<GetDataDistributorMetricsReply> const& reply,int loopDepth) 
	{
															#line 2413 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (reply.isError())
															#line 10648 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2414 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.reply.sendError(reply.getError());
															#line 10652 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2416 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			GetDDMetricsReply newReply;
															#line 2417 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			newReply.storageMetricsList = reply.get().storageMetricsList;
															#line 2418 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.reply.send(newReply);
															#line 10662 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1cont1(ErrorOr<GetDataDistributorMetricsReply> && reply,int loopDepth) 
	{
															#line 2413 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (reply.isError())
															#line 10672 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2414 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.reply.sendError(reply.getError());
															#line 10676 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2416 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			GetDDMetricsReply newReply;
															#line 2417 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			newReply.storageMetricsList = reply.get().storageMetricsList;
															#line 2418 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.reply.send(newReply);
															#line 10686 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1when1(ErrorOr<GetDataDistributorMetricsReply> const& reply,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when1cont1(reply, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1when1(ErrorOr<GetDataDistributorMetricsReply> && reply,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when1cont1(std::move(reply), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DdMetricsRequestServerActor*>(this)->actor_wait_state > 0) static_cast<DdMetricsRequestServerActor*>(this)->actor_wait_state = 0;
		static_cast<DdMetricsRequestServerActor*>(this)->ActorCallback< DdMetricsRequestServerActor, 1, ErrorOr<GetDataDistributorMetricsReply> >::remove();

	}
	void a_callback_fire(ActorCallback< DdMetricsRequestServerActor, 1, ErrorOr<GetDataDistributorMetricsReply> >*,ErrorOr<GetDataDistributorMetricsReply> const& value) 
	{
		fdb_probe_actor_enter("ddMetricsRequestServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DdMetricsRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddMetricsRequestServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DdMetricsRequestServerActor, 1, ErrorOr<GetDataDistributorMetricsReply> >*,ErrorOr<GetDataDistributorMetricsReply> && value) 
	{
		fdb_probe_actor_enter("ddMetricsRequestServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DdMetricsRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddMetricsRequestServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DdMetricsRequestServerActor, 1, ErrorOr<GetDataDistributorMetricsReply> >*,Error err) 
	{
		fdb_probe_actor_enter("ddMetricsRequestServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DdMetricsRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddMetricsRequestServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< DdMetricsRequestServerActor, 0, GetDDMetricsRequest >*,GetDDMetricsRequest const& value) 
	{
		fdb_probe_actor_enter("ddMetricsRequestServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DdMetricsRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddMetricsRequestServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< DdMetricsRequestServerActor, 0, GetDDMetricsRequest >*,GetDDMetricsRequest && value) 
	{
		fdb_probe_actor_enter("ddMetricsRequestServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DdMetricsRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddMetricsRequestServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< DdMetricsRequestServerActor, 0, GetDDMetricsRequest >*,Error err) 
	{
		fdb_probe_actor_enter("ddMetricsRequestServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DdMetricsRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddMetricsRequestServer", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2402 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitProxyInterface proxy;
															#line 2402 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> db;
															#line 2405 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	GetDDMetricsRequest req;
															#line 10830 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via ddMetricsRequestServer()
															#line 2402 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class DdMetricsRequestServerActor final : public Actor<Void>, public ActorSingleCallback< DdMetricsRequestServerActor, 0, GetDDMetricsRequest >, public ActorCallback< DdMetricsRequestServerActor, 1, ErrorOr<GetDataDistributorMetricsReply> >, public FastAllocated<DdMetricsRequestServerActor>, public DdMetricsRequestServerActorState<DdMetricsRequestServerActor> {
															#line 10835 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<DdMetricsRequestServerActor>::operator new;
	using FastAllocated<DdMetricsRequestServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1205199991379688192UL, 1149809414809909760UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< DdMetricsRequestServerActor, 0, GetDDMetricsRequest >;
friend struct ActorCallback< DdMetricsRequestServerActor, 1, ErrorOr<GetDataDistributorMetricsReply> >;
															#line 2402 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	DdMetricsRequestServerActor(CommitProxyInterface const& proxy,Reference<AsyncVar<ServerDBInfo> const> const& db) 
															#line 10853 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   DdMetricsRequestServerActorState<DdMetricsRequestServerActor>(proxy, db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("ddMetricsRequestServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2722599940322443264UL, 14232635602210436608UL);
		ActorExecutionContextHelper __helper(static_cast<DdMetricsRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("ddMetricsRequestServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("ddMetricsRequestServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< DdMetricsRequestServerActor, 0, GetDDMetricsRequest >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DdMetricsRequestServerActor, 1, ErrorOr<GetDataDistributorMetricsReply> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2402 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> ddMetricsRequestServer( CommitProxyInterface const& proxy, Reference<AsyncVar<ServerDBInfo> const> const& db ) {
															#line 2402 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new DdMetricsRequestServerActor(proxy, db));
															#line 10887 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 2424 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

															#line 10892 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via monitorRemoteCommitted()
															#line 2425 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class MonitorRemoteCommittedActor>
															#line 2425 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class MonitorRemoteCommittedActorState {
															#line 10899 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 2425 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	MonitorRemoteCommittedActorState(ProxyCommitData* const& self) 
															#line 2425 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 2425 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : self(self)
															#line 10906 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this));

	}
	~MonitorRemoteCommittedActorState() 
	{
		fdb_probe_actor_destroy("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2426 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			;
															#line 10921 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorRemoteCommittedActorState();
		static_cast<MonitorRemoteCommittedActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2427 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(0);
															#line 2427 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10953 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state = 1;
															#line 2427 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorRemoteCommittedActor, 0, Void >*>(static_cast<MonitorRemoteCommittedActor*>(this)));
															#line 10958 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 2428 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		remoteLogs = Optional<std::vector<OptionalInterface<TLogInterface>>>();
															#line 2429 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (self->db->get().recoveryState >= RecoveryState::ALL_LOGS_RECRUITED)
															#line 10969 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2430 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for( auto& logSet : self->db->get().logSystemConfig.tLogs ) {
															#line 2431 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (!logSet.isLocal)
															#line 10975 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				{
															#line 2432 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					remoteLogs = logSet.tLogs;
															#line 2433 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					for( auto& tLog : logSet.tLogs ) {
															#line 2434 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						if (!tLog.present())
															#line 10983 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
						{
															#line 2435 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							remoteLogs = Optional<std::vector<OptionalInterface<TLogInterface>>>();
															#line 10987 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
							break;
						}
					}
					break;
				}
			}
		}
															#line 2444 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!remoteLogs.present())
															#line 10997 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2445 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_1 = self->db->onChange();
															#line 2445 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11003 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state = 2;
															#line 2445 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorRemoteCommittedActor, 1, Void >*>(static_cast<MonitorRemoteCommittedActor*>(this)));
															#line 11008 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 2428 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		remoteLogs = Optional<std::vector<OptionalInterface<TLogInterface>>>();
															#line 2429 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (self->db->get().recoveryState >= RecoveryState::ALL_LOGS_RECRUITED)
															#line 11024 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2430 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for( auto& logSet : self->db->get().logSystemConfig.tLogs ) {
															#line 2431 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (!logSet.isLocal)
															#line 11030 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				{
															#line 2432 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					remoteLogs = logSet.tLogs;
															#line 2433 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					for( auto& tLog : logSet.tLogs ) {
															#line 2434 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						if (!tLog.present())
															#line 11038 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
						{
															#line 2435 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							remoteLogs = Optional<std::vector<OptionalInterface<TLogInterface>>>();
															#line 11042 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
							break;
						}
					}
					break;
				}
			}
		}
															#line 2444 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!remoteLogs.present())
															#line 11052 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2445 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_1 = self->db->onChange();
															#line 2445 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11058 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state = 2;
															#line 2445 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorRemoteCommittedActor, 1, Void >*>(static_cast<MonitorRemoteCommittedActor*>(this)));
															#line 11063 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state > 0) static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorRemoteCommittedActor*>(this)->ActorCallback< MonitorRemoteCommittedActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorRemoteCommittedActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRemoteCommittedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorRemoteCommittedActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRemoteCommittedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorRemoteCommittedActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRemoteCommittedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 2448 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->popRemoteTxs = true;
															#line 2450 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		onChange = self->db->onChange();
															#line 2451 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		;
															#line 11156 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void const& _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void && _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state > 0) static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorRemoteCommittedActor*>(this)->ActorCallback< MonitorRemoteCommittedActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorRemoteCommittedActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRemoteCommittedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorRemoteCommittedActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRemoteCommittedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorRemoteCommittedActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRemoteCommittedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont10(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1(int loopDepth) 
	{
															#line 2452 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		replies = std::vector<Future<TLogQueuingMetricsReply>>();
															#line 2453 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for( auto& it : remoteLogs.get() ) {
															#line 2454 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			replies.push_back( brokenPromiseToNever(it.interf().getQueuingMetrics.getReply(TLogQueuingMetricsRequest())));
															#line 11269 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 2457 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_2 = waitForAll(replies) || onChange;
															#line 2457 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 11275 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont2loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state = 3;
															#line 2457 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorRemoteCommittedActor, 2, Void >*>(static_cast<MonitorRemoteCommittedActor*>(this)));
															#line 11280 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont10(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 2459 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (onChange.isReady())
															#line 11302 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2464 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		Version minVersion = std::numeric_limits<Version>::max();
															#line 2465 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for( auto& it : replies ) {
															#line 2466 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			minVersion = std::min(minVersion, it.get().v);
															#line 11312 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 2469 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for(;self->txsPopVersions.size() && self->txsPopVersions.front().first <= minVersion;) {
															#line 2470 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->lastTxsPop = self->txsPopVersions.front().second;
															#line 2471 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->logSystem->popTxs(self->txsPopVersions.front().second, tagLocalityRemoteLog);
															#line 2472 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->txsPopVersions.pop_front();
															#line 11322 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 2475 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(SERVER_KNOBS->UPDATE_REMOTE_LOG_VERSION_INTERVAL) || onChange;
															#line 2475 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 11328 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont2loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state = 4;
															#line 2475 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorRemoteCommittedActor, 3, Void >*>(static_cast<MonitorRemoteCommittedActor*>(this)));
															#line 11333 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 2459 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (onChange.isReady())
															#line 11342 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2464 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		Version minVersion = std::numeric_limits<Version>::max();
															#line 2465 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for( auto& it : replies ) {
															#line 2466 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			minVersion = std::min(minVersion, it.get().v);
															#line 11352 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 2469 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for(;self->txsPopVersions.size() && self->txsPopVersions.front().first <= minVersion;) {
															#line 2470 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->lastTxsPop = self->txsPopVersions.front().second;
															#line 2471 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->logSystem->popTxs(self->txsPopVersions.front().second, tagLocalityRemoteLog);
															#line 2472 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->txsPopVersions.pop_front();
															#line 11362 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 2475 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(SERVER_KNOBS->UPDATE_REMOTE_LOG_VERSION_INTERVAL) || onChange;
															#line 2475 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 11368 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont2loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state = 4;
															#line 2475 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorRemoteCommittedActor, 3, Void >*>(static_cast<MonitorRemoteCommittedActor*>(this)));
															#line 11373 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state > 0) static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorRemoteCommittedActor*>(this)->ActorCallback< MonitorRemoteCommittedActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorRemoteCommittedActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRemoteCommittedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorRemoteCommittedActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRemoteCommittedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorRemoteCommittedActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRemoteCommittedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont2loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 2476 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (onChange.isReady())
															#line 11457 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 2476 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (onChange.isReady())
															#line 11469 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state > 0) static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorRemoteCommittedActor*>(this)->ActorCallback< MonitorRemoteCommittedActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorRemoteCommittedActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRemoteCommittedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont2loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MonitorRemoteCommittedActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRemoteCommittedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont2loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MonitorRemoteCommittedActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRemoteCommittedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 2425 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCommitData* self;
															#line 2428 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Optional<std::vector<OptionalInterface<TLogInterface>>> remoteLogs;
															#line 2450 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Future<Void> onChange;
															#line 2452 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	std::vector<Future<TLogQueuingMetricsReply>> replies;
															#line 11560 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via monitorRemoteCommitted()
															#line 2425 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class MonitorRemoteCommittedActor final : public Actor<Void>, public ActorCallback< MonitorRemoteCommittedActor, 0, Void >, public ActorCallback< MonitorRemoteCommittedActor, 1, Void >, public ActorCallback< MonitorRemoteCommittedActor, 2, Void >, public ActorCallback< MonitorRemoteCommittedActor, 3, Void >, public FastAllocated<MonitorRemoteCommittedActor>, public MonitorRemoteCommittedActorState<MonitorRemoteCommittedActor> {
															#line 11565 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<MonitorRemoteCommittedActor>::operator new;
	using FastAllocated<MonitorRemoteCommittedActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17074195399773440256UL, 7206260945579492096UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorRemoteCommittedActor, 0, Void >;
friend struct ActorCallback< MonitorRemoteCommittedActor, 1, Void >;
friend struct ActorCallback< MonitorRemoteCommittedActor, 2, Void >;
friend struct ActorCallback< MonitorRemoteCommittedActor, 3, Void >;
															#line 2425 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	MonitorRemoteCommittedActor(ProxyCommitData* const& self) 
															#line 11585 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   MonitorRemoteCommittedActorState<MonitorRemoteCommittedActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5098072617628861952UL, 10945506090906970880UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRemoteCommittedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorRemoteCommitted");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorRemoteCommittedActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorRemoteCommittedActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MonitorRemoteCommittedActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< MonitorRemoteCommittedActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2425 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> monitorRemoteCommitted( ProxyCommitData* const& self ) {
															#line 2425 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new MonitorRemoteCommittedActor(self));
															#line 11621 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 2482 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

															#line 11626 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via proxySnapCreate()
															#line 2483 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class ProxySnapCreateActor>
															#line 2483 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class ProxySnapCreateActorState {
															#line 11633 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 2483 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxySnapCreateActorState(ProxySnapRequest const& snapReq,ProxyCommitData* const& commitData) 
															#line 2483 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 2483 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : snapReq(snapReq),
															#line 2483 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   commitData(commitData)
															#line 11642 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("proxySnapCreate", reinterpret_cast<unsigned long>(this));

	}
	~ProxySnapCreateActorState() 
	{
		fdb_probe_actor_destroy("proxySnapCreate", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2484 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent("SnapCommitProxy_SnapReqEnter") .detail("SnapPayload", snapReq.snapPayload) .detail("SnapUID", snapReq.snapUID);
															#line 11657 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			try {
															#line 2489 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				ExecCmdValueString execArg(snapReq.snapPayload);
															#line 2490 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				StringRef binPath = execArg.getBinaryPath();
															#line 2491 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (!isWhitelisted(commitData->whitelistedBinPathVec, binPath))
															#line 11665 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				{
															#line 2492 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					TraceEvent("SnapCommitProxy_WhiteListCheckFailed") .detail("SnapPayload", snapReq.snapPayload) .detail("SnapUID", snapReq.snapUID);
															#line 2495 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					return a_body1Catch2(snap_path_not_whitelisted(), loopDepth);
															#line 11671 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				}
															#line 2498 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (commitData->db->get().recoveryState != RecoveryState::FULLY_RECOVERED)
															#line 11675 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				{
															#line 2504 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					TraceEvent("SnapCommitProxy_ClusterNotFullyRecovered") .detail("SnapPayload", snapReq.snapPayload) .detail("SnapUID", snapReq.snapUID);
															#line 2507 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					return a_body1Catch2(snap_not_fully_recovered_unsupported(), loopDepth);
															#line 11681 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				}
															#line 2510 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				auto result = commitData->txnStateStore->readValue("log_anti_quorum"_sr.withPrefix(configKeysPrefix)).get();
															#line 2511 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				int logAntiQuorum = 0;
															#line 2512 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (result.present())
															#line 11689 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				{
															#line 2513 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					logAntiQuorum = atoi(result.get().toString().c_str());
															#line 11693 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				}
															#line 2517 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (logAntiQuorum > 0)
															#line 11697 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				{
															#line 2518 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					TraceEvent("SnapCommitProxy_LogAntiQuorumNotSupported") .detail("SnapPayload", snapReq.snapPayload) .detail("SnapUID", snapReq.snapUID);
															#line 2521 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					return a_body1Catch2(snap_log_anti_quorum_unsupported(), loopDepth);
															#line 11703 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				}
															#line 2524 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				snapReqRetry = 0;
															#line 2525 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				snapRetryBackoff = FLOW_KNOBS->PREVENT_FAST_SPIN_DELAY;
															#line 2526 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				;
															#line 11711 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ProxySnapCreateActorState();
		static_cast<ProxySnapCreateActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2564 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		TraceEvent("SnapCommitProxy_SnapReqExit") .detail("SnapPayload", snapReq.snapPayload) .detail("SnapUID", snapReq.snapUID);
															#line 2567 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<ProxySnapCreateActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ProxySnapCreateActorState(); static_cast<ProxySnapCreateActor*>(this)->destroy(); return 0; }
															#line 11742 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<ProxySnapCreateActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ProxySnapCreateActorState();
		static_cast<ProxySnapCreateActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2554 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent("SnapCommitProxy_SnapReqError") .errorUnsuppressed(e) .detail("SnapPayload", snapReq.snapPayload) .detail("SnapUID", snapReq.snapUID);
															#line 2558 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (e.code() != error_code_operation_cancelled)
															#line 11757 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 2559 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				snapReq.reply.sendError(e);
															#line 11761 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
			else
			{
															#line 2561 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 11767 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 2552 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		snapReq.reply.send(Void());
															#line 11783 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2528 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!commitData->db->get().distributor.present())
															#line 11799 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2529 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent(SevWarnAlways, "DataDistributorNotPresent").detail("Operation", "SnapRequest");
															#line 2530 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			return a_body1Catch2(dd_not_found(), std::max(0, loopDepth - 1));
															#line 11805 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		try {
															#line 2533 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			Future<ErrorOr<Void>> ddSnapReq = commitData->db->get().distributor.get().distributorSnapReq.tryGetReply( DistributorSnapRequest(snapReq.snapPayload, snapReq.snapUID));
															#line 2536 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = throwErrorOr(ddSnapReq);
															#line 2536 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<ProxySnapCreateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11814 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ProxySnapCreateActor*>(this)->actor_wait_state = 1;
															#line 2536 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ProxySnapCreateActor, 0, Void >*>(static_cast<ProxySnapCreateActor*>(this)));
															#line 11819 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2539 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent("SnapCommitProxy_DDSnapResponseError") .errorUnsuppressed(e) .detail("SnapPayload", snapReq.snapPayload) .detail("SnapUID", snapReq.snapUID) .detail("Retry", snapReqRetry);
															#line 2545 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (e.code() != error_code_request_maybe_delivered || ++snapReqRetry > SERVER_KNOBS->SNAP_NETWORK_FAILURE_RETRY_LIMIT)
															#line 11856 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 2547 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				return a_body1Catch2(e, std::max(0, loopDepth - 1));
															#line 11860 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 2548 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(snapRetryBackoff);
															#line 2548 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<ProxySnapCreateActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11866 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ProxySnapCreateActor*>(this)->actor_wait_state = 2;
															#line 2548 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ProxySnapCreateActor, 1, Void >*>(static_cast<ProxySnapCreateActor*>(this)));
															#line 11871 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ProxySnapCreateActor*>(this)->actor_wait_state > 0) static_cast<ProxySnapCreateActor*>(this)->actor_wait_state = 0;
		static_cast<ProxySnapCreateActor*>(this)->ActorCallback< ProxySnapCreateActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProxySnapCreateActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("proxySnapCreate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProxySnapCreateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("proxySnapCreate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ProxySnapCreateActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("proxySnapCreate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProxySnapCreateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("proxySnapCreate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ProxySnapCreateActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("proxySnapCreate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProxySnapCreateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("proxySnapCreate", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 2549 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		snapRetryBackoff = snapRetryBackoff * 2;
															#line 11973 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 2549 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		snapRetryBackoff = snapRetryBackoff * 2;
															#line 11982 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ProxySnapCreateActor*>(this)->actor_wait_state > 0) static_cast<ProxySnapCreateActor*>(this)->actor_wait_state = 0;
		static_cast<ProxySnapCreateActor*>(this)->ActorCallback< ProxySnapCreateActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProxySnapCreateActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("proxySnapCreate", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProxySnapCreateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("proxySnapCreate", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ProxySnapCreateActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("proxySnapCreate", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProxySnapCreateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("proxySnapCreate", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ProxySnapCreateActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("proxySnapCreate", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProxySnapCreateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("proxySnapCreate", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 2483 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxySnapRequest snapReq;
															#line 2483 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCommitData* commitData;
															#line 2524 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	int snapReqRetry;
															#line 2525 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	double snapRetryBackoff;
															#line 12083 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via proxySnapCreate()
															#line 2483 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class ProxySnapCreateActor final : public Actor<Void>, public ActorCallback< ProxySnapCreateActor, 0, Void >, public ActorCallback< ProxySnapCreateActor, 1, Void >, public FastAllocated<ProxySnapCreateActor>, public ProxySnapCreateActorState<ProxySnapCreateActor> {
															#line 12088 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<ProxySnapCreateActor>::operator new;
	using FastAllocated<ProxySnapCreateActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16039986170609224960UL, 8523918402201331968UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ProxySnapCreateActor, 0, Void >;
friend struct ActorCallback< ProxySnapCreateActor, 1, Void >;
															#line 2483 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxySnapCreateActor(ProxySnapRequest const& snapReq,ProxyCommitData* const& commitData) 
															#line 12106 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ProxySnapCreateActorState<ProxySnapCreateActor>(snapReq, commitData),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("proxySnapCreate", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9779697684357553408UL, 1968612500139297024UL);
		ActorExecutionContextHelper __helper(static_cast<ProxySnapCreateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("proxySnapCreate");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("proxySnapCreate", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ProxySnapCreateActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ProxySnapCreateActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2483 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> proxySnapCreate( ProxySnapRequest const& snapReq, ProxyCommitData* const& commitData ) {
															#line 2483 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new ProxySnapCreateActor(snapReq, commitData));
															#line 12140 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 2569 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

															#line 12145 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via proxyCheckSafeExclusion()
															#line 2570 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class ProxyCheckSafeExclusionActor>
															#line 2570 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class ProxyCheckSafeExclusionActorState {
															#line 12152 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 2570 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCheckSafeExclusionActorState(Reference<AsyncVar<ServerDBInfo> const> const& db,ExclusionSafetyCheckRequest const& req) 
															#line 2570 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 2570 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : db(db),
															#line 2570 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   req(req)
															#line 12161 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("proxyCheckSafeExclusion", reinterpret_cast<unsigned long>(this));

	}
	~ProxyCheckSafeExclusionActorState() 
	{
		fdb_probe_actor_destroy("proxyCheckSafeExclusion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2572 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent("SafetyCheckCommitProxyBegin").log();
															#line 2573 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			reply = ExclusionSafetyCheckReply(false);
															#line 2574 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (!db->get().distributor.present())
															#line 12180 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 2575 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				TraceEvent(SevWarnAlways, "DataDistributorNotPresent").detail("Operation", "ExclusionSafetyCheck");
															#line 2576 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				req.reply.send(reply);
															#line 2577 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (!static_cast<ProxyCheckSafeExclusionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ProxyCheckSafeExclusionActorState(); static_cast<ProxyCheckSafeExclusionActor*>(this)->destroy(); return 0; }
															#line 12188 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				new (&static_cast<ProxyCheckSafeExclusionActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~ProxyCheckSafeExclusionActorState();
				static_cast<ProxyCheckSafeExclusionActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			try {
															#line 2580 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				ddSafeFuture = db->get().distributor.get().distributorExclCheckReq.tryGetReply( DistributorExclusionSafetyCheckRequest(req.exclusions));
															#line 2583 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				StrictFuture<DistributorExclusionSafetyCheckReply> __when_expr_0 = throwErrorOr(ddSafeFuture);
															#line 2583 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (static_cast<ProxyCheckSafeExclusionActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 12201 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ProxyCheckSafeExclusionActor*>(this)->actor_wait_state = 1;
															#line 2583 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ProxyCheckSafeExclusionActor, 0, DistributorExclusionSafetyCheckReply >*>(static_cast<ProxyCheckSafeExclusionActor*>(this)));
															#line 12206 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ProxyCheckSafeExclusionActorState();
		static_cast<ProxyCheckSafeExclusionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2594 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		TraceEvent("SafetyCheckCommitProxyFinish").log();
															#line 2595 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		req.reply.send(reply);
															#line 2596 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<ProxyCheckSafeExclusionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ProxyCheckSafeExclusionActorState(); static_cast<ProxyCheckSafeExclusionActor*>(this)->destroy(); return 0; }
															#line 12239 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<ProxyCheckSafeExclusionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ProxyCheckSafeExclusionActorState();
		static_cast<ProxyCheckSafeExclusionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2586 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent("SafetyCheckCommitProxyResponseError").error(e);
															#line 2587 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (e.code() != error_code_operation_cancelled)
															#line 12254 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 2588 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				req.reply.sendError(e);
															#line 2589 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (!static_cast<ProxyCheckSafeExclusionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ProxyCheckSafeExclusionActorState(); static_cast<ProxyCheckSafeExclusionActor*>(this)->destroy(); return 0; }
															#line 12260 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				new (&static_cast<ProxyCheckSafeExclusionActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~ProxyCheckSafeExclusionActorState();
				static_cast<ProxyCheckSafeExclusionActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 2591 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 12270 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(DistributorExclusionSafetyCheckReply const& _reply,int loopDepth) 
	{
															#line 2584 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		reply.safe = _reply.safe;
															#line 12285 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(DistributorExclusionSafetyCheckReply && _reply,int loopDepth) 
	{
															#line 2584 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		reply.safe = _reply.safe;
															#line 12294 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1when1(DistributorExclusionSafetyCheckReply const& _reply,int loopDepth) 
	{
		loopDepth = a_body1cont3(_reply, loopDepth);

		return loopDepth;
	}
	int a_body1when1(DistributorExclusionSafetyCheckReply && _reply,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_reply), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ProxyCheckSafeExclusionActor*>(this)->actor_wait_state > 0) static_cast<ProxyCheckSafeExclusionActor*>(this)->actor_wait_state = 0;
		static_cast<ProxyCheckSafeExclusionActor*>(this)->ActorCallback< ProxyCheckSafeExclusionActor, 0, DistributorExclusionSafetyCheckReply >::remove();

	}
	void a_callback_fire(ActorCallback< ProxyCheckSafeExclusionActor, 0, DistributorExclusionSafetyCheckReply >*,DistributorExclusionSafetyCheckReply const& value) 
	{
		fdb_probe_actor_enter("proxyCheckSafeExclusion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProxyCheckSafeExclusionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("proxyCheckSafeExclusion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ProxyCheckSafeExclusionActor, 0, DistributorExclusionSafetyCheckReply >*,DistributorExclusionSafetyCheckReply && value) 
	{
		fdb_probe_actor_enter("proxyCheckSafeExclusion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProxyCheckSafeExclusionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("proxyCheckSafeExclusion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ProxyCheckSafeExclusionActor, 0, DistributorExclusionSafetyCheckReply >*,Error err) 
	{
		fdb_probe_actor_enter("proxyCheckSafeExclusion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProxyCheckSafeExclusionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("proxyCheckSafeExclusion", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 2570 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> db;
															#line 2570 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ExclusionSafetyCheckRequest req;
															#line 2573 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ExclusionSafetyCheckReply reply;
															#line 2580 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Future<ErrorOr<DistributorExclusionSafetyCheckReply>> ddSafeFuture;
															#line 12395 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via proxyCheckSafeExclusion()
															#line 2570 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class ProxyCheckSafeExclusionActor final : public Actor<Void>, public ActorCallback< ProxyCheckSafeExclusionActor, 0, DistributorExclusionSafetyCheckReply >, public FastAllocated<ProxyCheckSafeExclusionActor>, public ProxyCheckSafeExclusionActorState<ProxyCheckSafeExclusionActor> {
															#line 12400 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<ProxyCheckSafeExclusionActor>::operator new;
	using FastAllocated<ProxyCheckSafeExclusionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10490383482189273344UL, 891721850762759168UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ProxyCheckSafeExclusionActor, 0, DistributorExclusionSafetyCheckReply >;
															#line 2570 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCheckSafeExclusionActor(Reference<AsyncVar<ServerDBInfo> const> const& db,ExclusionSafetyCheckRequest const& req) 
															#line 12417 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ProxyCheckSafeExclusionActorState<ProxyCheckSafeExclusionActor>(db, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("proxyCheckSafeExclusion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1552417108573464832UL, 15142131124646932992UL);
		ActorExecutionContextHelper __helper(static_cast<ProxyCheckSafeExclusionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("proxyCheckSafeExclusion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("proxyCheckSafeExclusion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ProxyCheckSafeExclusionActor, 0, DistributorExclusionSafetyCheckReply >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2570 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> proxyCheckSafeExclusion( Reference<AsyncVar<ServerDBInfo> const> const& db, ExclusionSafetyCheckRequest const& req ) {
															#line 2570 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new ProxyCheckSafeExclusionActor(db, req));
															#line 12450 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 2598 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

															#line 12455 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via reportTxnTagCommitCost()
															#line 2599 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class ReportTxnTagCommitCostActor>
															#line 2599 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class ReportTxnTagCommitCostActorState {
															#line 12462 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 2599 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ReportTxnTagCommitCostActorState(UID const& myID,Reference<AsyncVar<ServerDBInfo> const> const& db,UIDTransactionTagMap<TransactionCommitCostEstimation>* const& ssTrTagCommitCost) 
															#line 2599 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 2599 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : myID(myID),
															#line 2599 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   db(db),
															#line 2599 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   ssTrTagCommitCost(ssTrTagCommitCost),
															#line 2602 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   nextRequestTimer(Never()),
															#line 2603 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   nextReply(Never())
															#line 12477 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("reportTxnTagCommitCost", reinterpret_cast<unsigned long>(this));

	}
	~ReportTxnTagCommitCostActorState() 
	{
		fdb_probe_actor_destroy("reportTxnTagCommitCost", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2604 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (db->get().ratekeeper.present())
															#line 12492 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 2605 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				nextRequestTimer = Void();
															#line 12496 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 2606 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			;
															#line 12500 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReportTxnTagCommitCostActorState();
		static_cast<ReportTxnTagCommitCostActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2607 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_0 = db->onChange();
															#line 2606 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<ReportTxnTagCommitCostActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12532 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 2616 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = nextRequestTimer;
															#line 12536 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
															#line 2626 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_2 = nextReply;
															#line 12540 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when3(__when_expr_2.get(), loopDepth); };
		static_cast<ReportTxnTagCommitCostActor*>(this)->actor_wait_state = 1;
															#line 2607 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReportTxnTagCommitCostActor, 0, Void >*>(static_cast<ReportTxnTagCommitCostActor*>(this)));
															#line 2616 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReportTxnTagCommitCostActor, 1, Void >*>(static_cast<ReportTxnTagCommitCostActor*>(this)));
															#line 2626 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ReportTxnTagCommitCostActor, 2, Void >*>(static_cast<ReportTxnTagCommitCostActor*>(this)));
															#line 12549 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 2608 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (db->get().ratekeeper.present())
															#line 12564 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2609 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent("ProxyRatekeeperChanged", myID).detail("RKID", db->get().ratekeeper.get().id());
															#line 2610 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			nextRequestTimer = Void();
															#line 12570 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2612 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent("ProxyRatekeeperDied", myID).log();
															#line 2613 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			nextRequestTimer = Never();
															#line 12578 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 2608 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (db->get().ratekeeper.present())
															#line 12588 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2609 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent("ProxyRatekeeperChanged", myID).detail("RKID", db->get().ratekeeper.get().id());
															#line 2610 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			nextRequestTimer = Void();
															#line 12594 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2612 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent("ProxyRatekeeperDied", myID).log();
															#line 2613 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			nextRequestTimer = Never();
															#line 12602 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 2617 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		nextRequestTimer = Never();
															#line 2618 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (db->get().ratekeeper.present())
															#line 12614 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2619 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			nextReply = brokenPromiseToNever(db->get().ratekeeper.get().reportCommitCostEstimation.getReply( ReportCommitCostEstimationRequest(std::move(*ssTrTagCommitCost))));
															#line 2621 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ssTrTagCommitCost->clear();
															#line 12620 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2623 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			nextReply = Never();
															#line 12626 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 2617 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		nextRequestTimer = Never();
															#line 2618 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (db->get().ratekeeper.present())
															#line 12638 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2619 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			nextReply = brokenPromiseToNever(db->get().ratekeeper.get().reportCommitCostEstimation.getReply( ReportCommitCostEstimationRequest(std::move(*ssTrTagCommitCost))));
															#line 2621 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ssTrTagCommitCost->clear();
															#line 12644 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2623 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			nextReply = Never();
															#line 12650 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(Void const& _,int loopDepth) 
	{
															#line 2627 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		nextReply = Never();
															#line 2628 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		nextRequestTimer = delay(SERVER_KNOBS->REPORT_TRANSACTION_COST_ESTIMATION_DELAY);
															#line 12662 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(Void && _,int loopDepth) 
	{
															#line 2627 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		nextReply = Never();
															#line 2628 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		nextRequestTimer = delay(SERVER_KNOBS->REPORT_TRANSACTION_COST_ESTIMATION_DELAY);
															#line 12673 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReportTxnTagCommitCostActor*>(this)->actor_wait_state > 0) static_cast<ReportTxnTagCommitCostActor*>(this)->actor_wait_state = 0;
		static_cast<ReportTxnTagCommitCostActor*>(this)->ActorCallback< ReportTxnTagCommitCostActor, 0, Void >::remove();
		static_cast<ReportTxnTagCommitCostActor*>(this)->ActorCallback< ReportTxnTagCommitCostActor, 1, Void >::remove();
		static_cast<ReportTxnTagCommitCostActor*>(this)->ActorCallback< ReportTxnTagCommitCostActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReportTxnTagCommitCostActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("reportTxnTagCommitCost", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReportTxnTagCommitCostActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reportTxnTagCommitCost", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReportTxnTagCommitCostActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("reportTxnTagCommitCost", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReportTxnTagCommitCostActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reportTxnTagCommitCost", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReportTxnTagCommitCostActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("reportTxnTagCommitCost", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReportTxnTagCommitCostActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reportTxnTagCommitCost", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReportTxnTagCommitCostActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("reportTxnTagCommitCost", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReportTxnTagCommitCostActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reportTxnTagCommitCost", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReportTxnTagCommitCostActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("reportTxnTagCommitCost", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReportTxnTagCommitCostActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reportTxnTagCommitCost", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReportTxnTagCommitCostActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("reportTxnTagCommitCost", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReportTxnTagCommitCostActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reportTxnTagCommitCost", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReportTxnTagCommitCostActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("reportTxnTagCommitCost", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReportTxnTagCommitCostActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reportTxnTagCommitCost", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ReportTxnTagCommitCostActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("reportTxnTagCommitCost", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReportTxnTagCommitCostActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reportTxnTagCommitCost", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ReportTxnTagCommitCostActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("reportTxnTagCommitCost", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReportTxnTagCommitCostActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reportTxnTagCommitCost", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 2599 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	UID myID;
															#line 2599 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> db;
															#line 2599 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	UIDTransactionTagMap<TransactionCommitCostEstimation>* ssTrTagCommitCost;
															#line 2602 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Future<Void> nextRequestTimer;
															#line 2603 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Future<Void> nextReply;
															#line 12867 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via reportTxnTagCommitCost()
															#line 2599 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class ReportTxnTagCommitCostActor final : public Actor<Void>, public ActorCallback< ReportTxnTagCommitCostActor, 0, Void >, public ActorCallback< ReportTxnTagCommitCostActor, 1, Void >, public ActorCallback< ReportTxnTagCommitCostActor, 2, Void >, public FastAllocated<ReportTxnTagCommitCostActor>, public ReportTxnTagCommitCostActorState<ReportTxnTagCommitCostActor> {
															#line 12872 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<ReportTxnTagCommitCostActor>::operator new;
	using FastAllocated<ReportTxnTagCommitCostActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10520449175103538176UL, 47871364601832192UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReportTxnTagCommitCostActor, 0, Void >;
friend struct ActorCallback< ReportTxnTagCommitCostActor, 1, Void >;
friend struct ActorCallback< ReportTxnTagCommitCostActor, 2, Void >;
															#line 2599 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ReportTxnTagCommitCostActor(UID const& myID,Reference<AsyncVar<ServerDBInfo> const> const& db,UIDTransactionTagMap<TransactionCommitCostEstimation>* const& ssTrTagCommitCost) 
															#line 12891 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ReportTxnTagCommitCostActorState<ReportTxnTagCommitCostActor>(myID, db, ssTrTagCommitCost),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("reportTxnTagCommitCost", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18129575439556995328UL, 8473472385509925632UL);
		ActorExecutionContextHelper __helper(static_cast<ReportTxnTagCommitCostActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("reportTxnTagCommitCost");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("reportTxnTagCommitCost", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReportTxnTagCommitCostActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2599 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> reportTxnTagCommitCost( UID const& myID, Reference<AsyncVar<ServerDBInfo> const> const& db, UIDTransactionTagMap<TransactionCommitCostEstimation>* const& ssTrTagCommitCost ) {
															#line 2599 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new ReportTxnTagCommitCostActor(myID, db, ssTrTagCommitCost));
															#line 12924 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 2632 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

namespace {
struct ExpireServerEntry {
	int64_t timeReceived;
	int expectedCount = 0;
	int receivedCount = 0;
	bool initialized = false;
};

struct IdempotencyKey {
	Version version;
	uint8_t highOrderBatchIndex;
	bool operator==(const IdempotencyKey& other) const {
		return version == other.version && highOrderBatchIndex == other.highOrderBatchIndex;
	}
};

} // namespace

namespace std {
template <>
struct hash<IdempotencyKey> {
	std::size_t operator()(const IdempotencyKey& key) const {
		std::size_t seed = 0;
		boost::hash_combine(seed, std::hash<Version>{}(key.version));
		boost::hash_combine(seed, std::hash<uint8_t>{}(key.highOrderBatchIndex));
		return seed;
	}
};

} // namespace std

															#line 12960 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via idempotencyIdsExpireServer()
															#line 2664 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class IdempotencyIdsExpireServerActor>
															#line 2664 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class IdempotencyIdsExpireServerActorState {
															#line 12967 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 2664 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	IdempotencyIdsExpireServerActorState(Database const& db,PublicRequestStream<ExpireIdempotencyIdRequest> const& expireIdempotencyId,PromiseStream<ExpectedIdempotencyIdCountForKey> const& expectedIdempotencyIdCountForKey,Standalone<VectorRef<MutationRef>>* const& idempotencyClears) 
															#line 2664 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 2664 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : db(db),
															#line 2664 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   expireIdempotencyId(expireIdempotencyId),
															#line 2664 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   expectedIdempotencyIdCountForKey(expectedIdempotencyIdCountForKey),
															#line 2664 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   idempotencyClears(idempotencyClears),
															#line 2669 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   idStatus(),
															#line 2670 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   iter(),
															#line 2671 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   purgeBefore(),
															#line 2672 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   key(),
															#line 2673 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   status(nullptr),
															#line 2674 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   purgeOld(Void())
															#line 12992 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("idempotencyIdsExpireServer", reinterpret_cast<unsigned long>(this));

	}
	~IdempotencyIdsExpireServerActorState() 
	{
		fdb_probe_actor_destroy("idempotencyIdsExpireServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2675 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			;
															#line 13007 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~IdempotencyIdsExpireServerActorState();
		static_cast<IdempotencyIdsExpireServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2677 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		auto __when_expr_0 = expireIdempotencyId.getFuture();
															#line 13037 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<ExpireIdempotencyIdRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<ExpireIdempotencyIdRequest>>::value, "invalid type");
															#line 2676 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<IdempotencyIdsExpireServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 13041 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
															#line 2686 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		auto __when_expr_1 = expectedIdempotencyIdCountForKey.getFuture();
															#line 13045 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_1), FutureStream<ExpectedIdempotencyIdCountForKey>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<ExpectedIdempotencyIdCountForKey>>::value, "invalid type");
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.pop(), loopDepth); };
															#line 2692 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_2 = purgeOld;
															#line 13050 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when3(__when_expr_2.get(), loopDepth); };
		static_cast<IdempotencyIdsExpireServerActor*>(this)->actor_wait_state = 1;
															#line 2677 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< IdempotencyIdsExpireServerActor, 0, ExpireIdempotencyIdRequest >*>(static_cast<IdempotencyIdsExpireServerActor*>(this)));
															#line 2686 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< IdempotencyIdsExpireServerActor, 1, ExpectedIdempotencyIdCountForKey >*>(static_cast<IdempotencyIdsExpireServerActor*>(this)));
															#line 2692 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< IdempotencyIdsExpireServerActor, 2, Void >*>(static_cast<IdempotencyIdsExpireServerActor*>(this)));
															#line 13059 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 2708 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (status->initialized)
															#line 13068 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2709 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (status->receivedCount == status->expectedCount)
															#line 13072 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 2710 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				auto keyRange = makeIdempotencySingleKeyRange(idempotencyClears->arena(), key.version, key.highOrderBatchIndex);
															#line 2712 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				idempotencyClears->push_back(idempotencyClears->arena(), MutationRef(MutationRef::ClearRange, keyRange.begin, keyRange.end));
															#line 2714 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				idStatus.erase(key);
															#line 13080 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 2717 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			status->timeReceived = now();
															#line 2718 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			status->initialized = true;
															#line 13089 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(ExpireIdempotencyIdRequest const& req,int loopDepth) 
	{
															#line 2678 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		key = IdempotencyKey{ req.commitVersion, req.batchIndexHighByte };
															#line 2679 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		status = &idStatus[key];
															#line 2680 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		status->receivedCount += 1;
															#line 2681 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		CODE_PROBE(status->expectedCount == 0, "ExpireIdempotencyIdRequest received before count is known");
															#line 2682 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (status->expectedCount > 0)
															#line 13107 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2683 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT_LE(status->receivedCount, status->expectedCount);
															#line 13111 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(ExpireIdempotencyIdRequest && req,int loopDepth) 
	{
															#line 2678 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		key = IdempotencyKey{ req.commitVersion, req.batchIndexHighByte };
															#line 2679 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		status = &idStatus[key];
															#line 2680 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		status->receivedCount += 1;
															#line 2681 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		CODE_PROBE(status->expectedCount == 0, "ExpireIdempotencyIdRequest received before count is known");
															#line 2682 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (status->expectedCount > 0)
															#line 13129 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2683 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT_LE(status->receivedCount, status->expectedCount);
															#line 13133 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(ExpectedIdempotencyIdCountForKey const& req,int loopDepth) 
	{
															#line 2687 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		key = IdempotencyKey{ req.commitVersion, req.batchIndexHighByte };
															#line 2688 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		status = &idStatus[key];
															#line 2689 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT_EQ(status->expectedCount, 0);
															#line 2690 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		status->expectedCount = req.idempotencyIdCount;
															#line 13149 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(ExpectedIdempotencyIdCountForKey && req,int loopDepth) 
	{
															#line 2687 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		key = IdempotencyKey{ req.commitVersion, req.batchIndexHighByte };
															#line 2688 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		status = &idStatus[key];
															#line 2689 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT_EQ(status->expectedCount, 0);
															#line 2690 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		status->expectedCount = req.idempotencyIdCount;
															#line 13164 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(Void const& _,int loopDepth) 
	{
															#line 2693 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		purgeOld = delay(SERVER_KNOBS->IDEMPOTENCY_ID_IN_MEMORY_LIFETIME);
															#line 2694 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		purgeBefore = now() - SERVER_KNOBS->IDEMPOTENCY_ID_IN_MEMORY_LIFETIME;
															#line 2695 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		iter = idStatus.begin();
															#line 13177 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1when3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(Void && _,int loopDepth) 
	{
															#line 2693 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		purgeOld = delay(SERVER_KNOBS->IDEMPOTENCY_ID_IN_MEMORY_LIFETIME);
															#line 2694 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		purgeBefore = now() - SERVER_KNOBS->IDEMPOTENCY_ID_IN_MEMORY_LIFETIME;
															#line 2695 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		iter = idStatus.begin();
															#line 13190 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1when3loopHead1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<IdempotencyIdsExpireServerActor*>(this)->actor_wait_state > 0) static_cast<IdempotencyIdsExpireServerActor*>(this)->actor_wait_state = 0;
		static_cast<IdempotencyIdsExpireServerActor*>(this)->ActorSingleCallback< IdempotencyIdsExpireServerActor, 0, ExpireIdempotencyIdRequest >::remove();
		static_cast<IdempotencyIdsExpireServerActor*>(this)->ActorSingleCallback< IdempotencyIdsExpireServerActor, 1, ExpectedIdempotencyIdCountForKey >::remove();
		static_cast<IdempotencyIdsExpireServerActor*>(this)->ActorCallback< IdempotencyIdsExpireServerActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorSingleCallback< IdempotencyIdsExpireServerActor, 0, ExpireIdempotencyIdRequest >*,ExpireIdempotencyIdRequest const& value) 
	{
		fdb_probe_actor_enter("idempotencyIdsExpireServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IdempotencyIdsExpireServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("idempotencyIdsExpireServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< IdempotencyIdsExpireServerActor, 0, ExpireIdempotencyIdRequest >*,ExpireIdempotencyIdRequest && value) 
	{
		fdb_probe_actor_enter("idempotencyIdsExpireServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IdempotencyIdsExpireServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("idempotencyIdsExpireServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< IdempotencyIdsExpireServerActor, 0, ExpireIdempotencyIdRequest >*,Error err) 
	{
		fdb_probe_actor_enter("idempotencyIdsExpireServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IdempotencyIdsExpireServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("idempotencyIdsExpireServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< IdempotencyIdsExpireServerActor, 1, ExpectedIdempotencyIdCountForKey >*,ExpectedIdempotencyIdCountForKey const& value) 
	{
		fdb_probe_actor_enter("idempotencyIdsExpireServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IdempotencyIdsExpireServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("idempotencyIdsExpireServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< IdempotencyIdsExpireServerActor, 1, ExpectedIdempotencyIdCountForKey >*,ExpectedIdempotencyIdCountForKey && value) 
	{
		fdb_probe_actor_enter("idempotencyIdsExpireServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IdempotencyIdsExpireServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("idempotencyIdsExpireServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< IdempotencyIdsExpireServerActor, 1, ExpectedIdempotencyIdCountForKey >*,Error err) 
	{
		fdb_probe_actor_enter("idempotencyIdsExpireServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IdempotencyIdsExpireServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("idempotencyIdsExpireServer", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1when3cont1(int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1when3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1when3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3loopBody1(int loopDepth) 
	{
															#line 2695 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!(iter != idStatus.end()))
															#line 13334 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1when3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2698 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_3 = yield();
															#line 2698 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<IdempotencyIdsExpireServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 13342 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1when3loopBody1when1(__when_expr_3.get(), loopDepth); };
		static_cast<IdempotencyIdsExpireServerActor*>(this)->actor_wait_state = 2;
															#line 2698 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< IdempotencyIdsExpireServerActor, 3, Void >*>(static_cast<IdempotencyIdsExpireServerActor*>(this)));
															#line 13347 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when3break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1when3cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1when3loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 2699 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (iter->second.timeReceived < purgeBefore)
															#line 13369 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2700 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			iter = idStatus.erase(iter);
															#line 13373 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2702 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			++iter;
															#line 13379 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		if (loopDepth == 0) return a_body1loopBody1when3loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when3loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 2699 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (iter->second.timeReceived < purgeBefore)
															#line 13389 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2700 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			iter = idStatus.erase(iter);
															#line 13393 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2702 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			++iter;
															#line 13399 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		if (loopDepth == 0) return a_body1loopBody1when3loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when3loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when3loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when3loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<IdempotencyIdsExpireServerActor*>(this)->actor_wait_state > 0) static_cast<IdempotencyIdsExpireServerActor*>(this)->actor_wait_state = 0;
		static_cast<IdempotencyIdsExpireServerActor*>(this)->ActorCallback< IdempotencyIdsExpireServerActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< IdempotencyIdsExpireServerActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("idempotencyIdsExpireServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IdempotencyIdsExpireServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("idempotencyIdsExpireServer", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< IdempotencyIdsExpireServerActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("idempotencyIdsExpireServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IdempotencyIdsExpireServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("idempotencyIdsExpireServer", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< IdempotencyIdsExpireServerActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("idempotencyIdsExpireServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IdempotencyIdsExpireServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("idempotencyIdsExpireServer", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< IdempotencyIdsExpireServerActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("idempotencyIdsExpireServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IdempotencyIdsExpireServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("idempotencyIdsExpireServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< IdempotencyIdsExpireServerActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("idempotencyIdsExpireServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IdempotencyIdsExpireServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("idempotencyIdsExpireServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< IdempotencyIdsExpireServerActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("idempotencyIdsExpireServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IdempotencyIdsExpireServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("idempotencyIdsExpireServer", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 2664 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Database db;
															#line 2664 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	PublicRequestStream<ExpireIdempotencyIdRequest> expireIdempotencyId;
															#line 2664 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	PromiseStream<ExpectedIdempotencyIdCountForKey> expectedIdempotencyIdCountForKey;
															#line 2664 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Standalone<VectorRef<MutationRef>>* idempotencyClears;
															#line 2669 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	std::unordered_map<IdempotencyKey, ExpireServerEntry> idStatus;
															#line 2670 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	std::unordered_map<IdempotencyKey, ExpireServerEntry>::iterator iter;
															#line 2671 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	int64_t purgeBefore;
															#line 2672 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	IdempotencyKey key;
															#line 2673 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ExpireServerEntry* status;
															#line 2674 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Future<Void> purgeOld;
															#line 13557 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via idempotencyIdsExpireServer()
															#line 2664 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class IdempotencyIdsExpireServerActor final : public Actor<Void>, public ActorSingleCallback< IdempotencyIdsExpireServerActor, 0, ExpireIdempotencyIdRequest >, public ActorSingleCallback< IdempotencyIdsExpireServerActor, 1, ExpectedIdempotencyIdCountForKey >, public ActorCallback< IdempotencyIdsExpireServerActor, 2, Void >, public ActorCallback< IdempotencyIdsExpireServerActor, 3, Void >, public FastAllocated<IdempotencyIdsExpireServerActor>, public IdempotencyIdsExpireServerActorState<IdempotencyIdsExpireServerActor> {
															#line 13562 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<IdempotencyIdsExpireServerActor>::operator new;
	using FastAllocated<IdempotencyIdsExpireServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10452205342546624512UL, 10282309484124196352UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< IdempotencyIdsExpireServerActor, 0, ExpireIdempotencyIdRequest >;
friend struct ActorSingleCallback< IdempotencyIdsExpireServerActor, 1, ExpectedIdempotencyIdCountForKey >;
friend struct ActorCallback< IdempotencyIdsExpireServerActor, 2, Void >;
friend struct ActorCallback< IdempotencyIdsExpireServerActor, 3, Void >;
															#line 2664 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	IdempotencyIdsExpireServerActor(Database const& db,PublicRequestStream<ExpireIdempotencyIdRequest> const& expireIdempotencyId,PromiseStream<ExpectedIdempotencyIdCountForKey> const& expectedIdempotencyIdCountForKey,Standalone<VectorRef<MutationRef>>* const& idempotencyClears) 
															#line 13582 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   IdempotencyIdsExpireServerActorState<IdempotencyIdsExpireServerActor>(db, expireIdempotencyId, expectedIdempotencyIdCountForKey, idempotencyClears),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("idempotencyIdsExpireServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2194589099630311680UL, 4656839406185788928UL);
		ActorExecutionContextHelper __helper(static_cast<IdempotencyIdsExpireServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("idempotencyIdsExpireServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("idempotencyIdsExpireServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< IdempotencyIdsExpireServerActor, 0, ExpireIdempotencyIdRequest >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< IdempotencyIdsExpireServerActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2664 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] static Future<Void> idempotencyIdsExpireServer( Database const& db, PublicRequestStream<ExpireIdempotencyIdRequest> const& expireIdempotencyId, PromiseStream<ExpectedIdempotencyIdCountForKey> const& expectedIdempotencyIdCountForKey, Standalone<VectorRef<MutationRef>>* const& idempotencyClears ) {
															#line 2664 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new IdempotencyIdsExpireServerActor(db, expireIdempotencyId, expectedIdempotencyIdCountForKey, idempotencyClears));
															#line 13616 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 2722 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

namespace {

struct TransactionStateResolveContext {
	// Maximum sequence for txnStateRequest, this is defined when the request last flag is set.
	Sequence maxSequence = std::numeric_limits<Sequence>::max();

	// Flags marks received transaction state requests, we only process the transaction request when *all* requests are
	// received.
	std::unordered_set<Sequence> receivedSequences;

	ProxyCommitData* pCommitData = nullptr;

	// Pointer to transaction state store, shortcut for commitData.txnStateStore
	IKeyValueStore* pTxnStateStore = nullptr;

	Future<Void> txnRecovery;

	// Actor streams
	PromiseStream<Future<Void>>* pActors = nullptr;

	// Flag reports if the transaction state request is complete. This request should only happen during recover, i.e.
	// once per commit proxy.
	bool processed = false;

	TransactionStateResolveContext() = default;

	TransactionStateResolveContext(ProxyCommitData* pCommitData_, PromiseStream<Future<Void>>* pActors_)
	  : pCommitData(pCommitData_), pTxnStateStore(pCommitData_->txnStateStore), pActors(pActors_) {
		ASSERT(pTxnStateStore != nullptr);
	}
};

															#line 13653 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
// This generated class is to be used only via processCompleteTransactionStateRequest()
															#line 2755 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class ProcessCompleteTransactionStateRequestActor>
															#line 2755 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class ProcessCompleteTransactionStateRequestActorState {
															#line 13659 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 2755 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProcessCompleteTransactionStateRequestActorState(TransactionStateResolveContext* const& pContext) 
															#line 2755 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 2755 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : pContext(pContext),
															#line 2756 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   txnKeys(allKeys),
															#line 2757 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   tag_uid()
															#line 13670 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("processCompleteTransactionStateRequest", reinterpret_cast<unsigned long>(this));

	}
	~ProcessCompleteTransactionStateRequestActorState() 
	{
		fdb_probe_actor_destroy("processCompleteTransactionStateRequest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2759 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			RangeResult UIDtoTagMap = pContext->pTxnStateStore->readRange(serverTagKeys).get();
															#line 2760 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for( const KeyValueRef& kv : UIDtoTagMap ) {
															#line 2761 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				tag_uid[decodeServerTagValue(kv.value)] = decodeServerTagKey(kv.key);
															#line 13689 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 2764 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			systemCipherKeys = std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>>();
															#line 2765 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (pContext->pCommitData->encryptMode.isEncryptionEnabled())
															#line 13695 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 2766 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				StrictFuture<std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>>> __when_expr_0 = GetEncryptCipherKeys<ServerDBInfo>::getLatestEncryptCipherKeys(pContext->pCommitData->db, ENCRYPT_CIPHER_SYSTEM_DOMAINS, BlobCipherMetrics::TLOG, pContext->pCommitData->encryptionMonitor);
															#line 2766 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (static_cast<ProcessCompleteTransactionStateRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13701 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ProcessCompleteTransactionStateRequestActor*>(this)->actor_wait_state = 1;
															#line 2766 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ProcessCompleteTransactionStateRequestActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >*>(static_cast<ProcessCompleteTransactionStateRequestActor*>(this)));
															#line 13706 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ProcessCompleteTransactionStateRequestActorState();
		static_cast<ProcessCompleteTransactionStateRequestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2774 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		;
															#line 13734 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> const& cks,int loopDepth) 
	{
															#line 2771 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		systemCipherKeys = cks;
															#line 13743 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> && cks,int loopDepth) 
	{
															#line 2771 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		systemCipherKeys = cks;
															#line 13752 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> const& cks,int loopDepth) 
	{
		loopDepth = a_body1cont3(cks, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> && cks,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(cks), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ProcessCompleteTransactionStateRequestActor*>(this)->actor_wait_state > 0) static_cast<ProcessCompleteTransactionStateRequestActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessCompleteTransactionStateRequestActor*>(this)->ActorCallback< ProcessCompleteTransactionStateRequestActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessCompleteTransactionStateRequestActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >*,std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> const& value) 
	{
		fdb_probe_actor_enter("processCompleteTransactionStateRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessCompleteTransactionStateRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processCompleteTransactionStateRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ProcessCompleteTransactionStateRequestActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >*,std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> && value) 
	{
		fdb_probe_actor_enter("processCompleteTransactionStateRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessCompleteTransactionStateRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processCompleteTransactionStateRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ProcessCompleteTransactionStateRequestActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >*,Error err) 
	{
		fdb_probe_actor_enter("processCompleteTransactionStateRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessCompleteTransactionStateRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processCompleteTransactionStateRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 2855 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		auto lockedKey = pContext->pTxnStateStore->readValue(databaseLockedKey).get();
															#line 2856 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->pCommitData->locked = lockedKey.present() && lockedKey.get().size();
															#line 2857 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->pCommitData->metadataVersion = pContext->pTxnStateStore->readValue(metadataVersionKey).get();
															#line 2859 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->pTxnStateStore->enableSnapshot();
															#line 2861 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<ProcessCompleteTransactionStateRequestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ProcessCompleteTransactionStateRequestActorState(); static_cast<ProcessCompleteTransactionStateRequestActor*>(this)->destroy(); return 0; }
															#line 13844 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<ProcessCompleteTransactionStateRequestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ProcessCompleteTransactionStateRequestActorState();
		static_cast<ProcessCompleteTransactionStateRequestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 2775 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = yield();
															#line 2775 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<ProcessCompleteTransactionStateRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 13865 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ProcessCompleteTransactionStateRequestActor*>(this)->actor_wait_state = 2;
															#line 2775 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ProcessCompleteTransactionStateRequestActor, 1, Void >*>(static_cast<ProcessCompleteTransactionStateRequestActor*>(this)));
															#line 13870 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 2777 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		RangeResult data = pContext->pTxnStateStore ->readRange(txnKeys, SERVER_KNOBS->BUGGIFIED_ROW_LIMIT, SERVER_KNOBS->APPLY_MUTATION_BYTES) .get();
															#line 2781 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!data.size())
															#line 13894 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2784 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		((KeyRangeRef&)txnKeys) = KeyRangeRef(keyAfter(data.back().key, txnKeys.arena()), txnKeys.end);
															#line 2786 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		MutationsVec mutations;
															#line 2787 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		std::vector<std::pair<MapPair<Key, ServerCacheInfo>, int>> keyInfoData;
															#line 2788 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		std::vector<UID> src, dest;
															#line 2789 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ServerCacheInfo info;
															#line 2791 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		auto updateTagInfo = [pContext = pContext](const std::vector<UID>& uids, std::vector<Tag>& tags, std::vector<Reference<StorageInfo>>& storageInfoItems) { for (const auto& id : uids) { auto storageInfo = getStorageInfo(id, &pContext->pCommitData->storageCache, pContext->pTxnStateStore); ASSERT(storageInfo->tag != invalidTag); tags.push_back(storageInfo->tag); storageInfoItems.push_back(storageInfo); } };
															#line 2801 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for( auto& kv : data ) {
															#line 2802 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (kv.key.startsWith(keyServersPrefix))
															#line 13914 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 2803 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				KeyRef k = kv.key.removePrefix(keyServersPrefix);
															#line 2804 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (k == allKeys.end)
															#line 13920 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				{
					continue;
				}
															#line 2807 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				decodeKeyServersValue(tag_uid, kv.value, src, dest);
															#line 2809 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				info.tags.clear();
															#line 2811 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				info.src_info.clear();
															#line 2812 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				updateTagInfo(src, info.tags, info.src_info);
															#line 2814 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				info.dest_info.clear();
															#line 2815 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				updateTagInfo(dest, info.tags, info.dest_info);
															#line 2817 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				uniquify(info.tags);
															#line 2818 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				keyInfoData.emplace_back(MapPair<Key, ServerCacheInfo>(k, info), 1);
															#line 13940 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
			else
			{
															#line 2819 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (kv.key.startsWith(rangeLockPrefix))
															#line 13946 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				{
															#line 2820 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					if (pContext->pCommitData->rangeLockEnabled())
															#line 13950 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					{
															#line 2821 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						ASSERT(pContext->pCommitData->rangeLock != nullptr);
															#line 2822 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						Key keyInsert = kv.key.removePrefix(rangeLockPrefix);
															#line 2823 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						pContext->pCommitData->rangeLock->initKeyPoint(keyInsert, kv.value);
															#line 13958 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					}
				}
				else
				{
															#line 2826 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					mutations.emplace_back(mutations.arena(), MutationRef::SetValue, kv.key, kv.value);
															#line 13965 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					continue;
				}
			}
		}
															#line 2833 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->pCommitData->keyInfo.rawInsert(keyInfoData);
															#line 2835 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		Arena arena;
															#line 2836 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		bool confChanges;
															#line 2837 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		CODE_PROBE( pContext->pCommitData->encryptMode.isEncryptionEnabled(), "Commit proxy apply metadata mutations from txnStateStore on recovery, with encryption-at-rest enabled");
															#line 2840 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		applyMetadataMutations(SpanContext(), *pContext->pCommitData, arena, Reference<ILogSystem>(), mutations, nullptr, &systemCipherKeys, pContext->pCommitData->encryptMode, confChanges, 0, 0, true, pContext->pCommitData->provisional);
															#line 13980 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 2777 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		RangeResult data = pContext->pTxnStateStore ->readRange(txnKeys, SERVER_KNOBS->BUGGIFIED_ROW_LIMIT, SERVER_KNOBS->APPLY_MUTATION_BYTES) .get();
															#line 2781 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!data.size())
															#line 13991 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2784 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		((KeyRangeRef&)txnKeys) = KeyRangeRef(keyAfter(data.back().key, txnKeys.arena()), txnKeys.end);
															#line 2786 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		MutationsVec mutations;
															#line 2787 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		std::vector<std::pair<MapPair<Key, ServerCacheInfo>, int>> keyInfoData;
															#line 2788 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		std::vector<UID> src, dest;
															#line 2789 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ServerCacheInfo info;
															#line 2791 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		auto updateTagInfo = [pContext = pContext](const std::vector<UID>& uids, std::vector<Tag>& tags, std::vector<Reference<StorageInfo>>& storageInfoItems) { for (const auto& id : uids) { auto storageInfo = getStorageInfo(id, &pContext->pCommitData->storageCache, pContext->pTxnStateStore); ASSERT(storageInfo->tag != invalidTag); tags.push_back(storageInfo->tag); storageInfoItems.push_back(storageInfo); } };
															#line 2801 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for( auto& kv : data ) {
															#line 2802 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (kv.key.startsWith(keyServersPrefix))
															#line 14011 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 2803 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				KeyRef k = kv.key.removePrefix(keyServersPrefix);
															#line 2804 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (k == allKeys.end)
															#line 14017 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				{
					continue;
				}
															#line 2807 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				decodeKeyServersValue(tag_uid, kv.value, src, dest);
															#line 2809 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				info.tags.clear();
															#line 2811 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				info.src_info.clear();
															#line 2812 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				updateTagInfo(src, info.tags, info.src_info);
															#line 2814 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				info.dest_info.clear();
															#line 2815 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				updateTagInfo(dest, info.tags, info.dest_info);
															#line 2817 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				uniquify(info.tags);
															#line 2818 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				keyInfoData.emplace_back(MapPair<Key, ServerCacheInfo>(k, info), 1);
															#line 14037 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
			else
			{
															#line 2819 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (kv.key.startsWith(rangeLockPrefix))
															#line 14043 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				{
															#line 2820 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					if (pContext->pCommitData->rangeLockEnabled())
															#line 14047 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					{
															#line 2821 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						ASSERT(pContext->pCommitData->rangeLock != nullptr);
															#line 2822 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						Key keyInsert = kv.key.removePrefix(rangeLockPrefix);
															#line 2823 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						pContext->pCommitData->rangeLock->initKeyPoint(keyInsert, kv.value);
															#line 14055 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					}
				}
				else
				{
															#line 2826 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					mutations.emplace_back(mutations.arena(), MutationRef::SetValue, kv.key, kv.value);
															#line 14062 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					continue;
				}
			}
		}
															#line 2833 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->pCommitData->keyInfo.rawInsert(keyInfoData);
															#line 2835 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		Arena arena;
															#line 2836 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		bool confChanges;
															#line 2837 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		CODE_PROBE( pContext->pCommitData->encryptMode.isEncryptionEnabled(), "Commit proxy apply metadata mutations from txnStateStore on recovery, with encryption-at-rest enabled");
															#line 2840 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		applyMetadataMutations(SpanContext(), *pContext->pCommitData, arena, Reference<ILogSystem>(), mutations, nullptr, &systemCipherKeys, pContext->pCommitData->encryptMode, confChanges, 0, 0, true, pContext->pCommitData->provisional);
															#line 14077 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ProcessCompleteTransactionStateRequestActor*>(this)->actor_wait_state > 0) static_cast<ProcessCompleteTransactionStateRequestActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessCompleteTransactionStateRequestActor*>(this)->ActorCallback< ProcessCompleteTransactionStateRequestActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessCompleteTransactionStateRequestActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("processCompleteTransactionStateRequest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessCompleteTransactionStateRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processCompleteTransactionStateRequest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ProcessCompleteTransactionStateRequestActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("processCompleteTransactionStateRequest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessCompleteTransactionStateRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processCompleteTransactionStateRequest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ProcessCompleteTransactionStateRequestActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("processCompleteTransactionStateRequest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessCompleteTransactionStateRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processCompleteTransactionStateRequest", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2755 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	TransactionStateResolveContext* pContext;
															#line 2756 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	KeyRange txnKeys;
															#line 2757 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	std::map<Tag, UID> tag_uid;
															#line 2764 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> systemCipherKeys;
															#line 14165 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via processCompleteTransactionStateRequest()
															#line 2755 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class ProcessCompleteTransactionStateRequestActor final : public Actor<Void>, public ActorCallback< ProcessCompleteTransactionStateRequestActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >, public ActorCallback< ProcessCompleteTransactionStateRequestActor, 1, Void >, public FastAllocated<ProcessCompleteTransactionStateRequestActor>, public ProcessCompleteTransactionStateRequestActorState<ProcessCompleteTransactionStateRequestActor> {
															#line 14170 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<ProcessCompleteTransactionStateRequestActor>::operator new;
	using FastAllocated<ProcessCompleteTransactionStateRequestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15007369777103018496UL, 15200080444409166080UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ProcessCompleteTransactionStateRequestActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >;
friend struct ActorCallback< ProcessCompleteTransactionStateRequestActor, 1, Void >;
															#line 2755 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProcessCompleteTransactionStateRequestActor(TransactionStateResolveContext* const& pContext) 
															#line 14188 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ProcessCompleteTransactionStateRequestActorState<ProcessCompleteTransactionStateRequestActor>(pContext),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("processCompleteTransactionStateRequest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8499504063907237888UL, 15656031568419423488UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessCompleteTransactionStateRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("processCompleteTransactionStateRequest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("processCompleteTransactionStateRequest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ProcessCompleteTransactionStateRequestActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ProcessCompleteTransactionStateRequestActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2755 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> processCompleteTransactionStateRequest( TransactionStateResolveContext* const& pContext ) {
															#line 2755 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new ProcessCompleteTransactionStateRequestActor(pContext));
															#line 14221 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 2863 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

															#line 14226 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
// This generated class is to be used only via processTransactionStateRequestPart()
															#line 2864 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class ProcessTransactionStateRequestPartActor>
															#line 2864 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class ProcessTransactionStateRequestPartActorState {
															#line 14232 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 2864 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProcessTransactionStateRequestPartActorState(TransactionStateResolveContext* const& pContext,TxnStateRequest const& request) 
															#line 2864 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 2864 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : pContext(pContext),
															#line 2864 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   request(request)
															#line 14241 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("processTransactionStateRequestPart", reinterpret_cast<unsigned long>(this));

	}
	~ProcessTransactionStateRequestPartActorState() 
	{
		fdb_probe_actor_destroy("processTransactionStateRequestPart", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2866 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT(pContext->pCommitData != nullptr);
															#line 2867 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT(pContext->pActors != nullptr);
															#line 2869 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (pContext->receivedSequences.contains(request.sequence))
															#line 14260 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 2870 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (pContext->receivedSequences.size() == pContext->maxSequence)
															#line 14264 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				{
															#line 2871 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					StrictFuture<Void> __when_expr_0 = pContext->txnRecovery;
															#line 2871 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					if (static_cast<ProcessTransactionStateRequestPartActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14270 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<ProcessTransactionStateRequestPartActor*>(this)->actor_wait_state = 1;
															#line 2871 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ProcessTransactionStateRequestPartActor, 0, Void >*>(static_cast<ProcessTransactionStateRequestPartActor*>(this)));
															#line 14275 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont2(loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ProcessTransactionStateRequestPartActorState();
		static_cast<ProcessTransactionStateRequestPartActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2879 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (request.last)
															#line 14308 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2881 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pContext->maxSequence = request.sequence + 1;
															#line 14312 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 2883 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->receivedSequences.insert(request.sequence);
															#line 2888 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT(!pContext->pCommitData->validState.isSet());
															#line 2890 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for( auto& kv : request.data ) {
															#line 2891 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pContext->pTxnStateStore->set(kv, &request.arena);
															#line 14322 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 2893 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->pTxnStateStore->commit(true);
															#line 2895 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (pContext->receivedSequences.size() == pContext->maxSequence)
															#line 14328 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2897 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT(!pContext->processed);
															#line 2898 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pContext->txnRecovery = processCompleteTransactionStateRequest(pContext);
															#line 2899 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_2 = pContext->txnRecovery;
															#line 2899 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<ProcessTransactionStateRequestPartActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14338 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when1(__when_expr_2.get(), loopDepth); };
			static_cast<ProcessTransactionStateRequestPartActor*>(this)->actor_wait_state = 3;
															#line 2899 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ProcessTransactionStateRequestPartActor, 2, Void >*>(static_cast<ProcessTransactionStateRequestPartActor*>(this)));
															#line 14343 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 2874 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->pActors->send(broadcastTxnRequest(request, SERVER_KNOBS->TXN_STATE_SEND_AMOUNT, true));
															#line 2875 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = yield();
															#line 2875 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<ProcessTransactionStateRequestPartActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14361 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ProcessTransactionStateRequestPartActor*>(this)->actor_wait_state = 2;
															#line 2875 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ProcessTransactionStateRequestPartActor, 1, Void >*>(static_cast<ProcessTransactionStateRequestPartActor*>(this)));
															#line 14366 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ProcessTransactionStateRequestPartActor*>(this)->actor_wait_state > 0) static_cast<ProcessTransactionStateRequestPartActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessTransactionStateRequestPartActor*>(this)->ActorCallback< ProcessTransactionStateRequestPartActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessTransactionStateRequestPartActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("processTransactionStateRequestPart", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessTransactionStateRequestPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processTransactionStateRequestPart", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ProcessTransactionStateRequestPartActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("processTransactionStateRequestPart", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessTransactionStateRequestPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processTransactionStateRequestPart", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ProcessTransactionStateRequestPartActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("processTransactionStateRequestPart", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessTransactionStateRequestPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processTransactionStateRequestPart", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 2876 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<ProcessTransactionStateRequestPartActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ProcessTransactionStateRequestPartActorState(); static_cast<ProcessTransactionStateRequestPartActor*>(this)->destroy(); return 0; }
															#line 14462 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<ProcessTransactionStateRequestPartActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ProcessTransactionStateRequestPartActorState();
		static_cast<ProcessTransactionStateRequestPartActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 2876 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<ProcessTransactionStateRequestPartActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ProcessTransactionStateRequestPartActorState(); static_cast<ProcessTransactionStateRequestPartActor*>(this)->destroy(); return 0; }
															#line 14474 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<ProcessTransactionStateRequestPartActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ProcessTransactionStateRequestPartActorState();
		static_cast<ProcessTransactionStateRequestPartActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ProcessTransactionStateRequestPartActor*>(this)->actor_wait_state > 0) static_cast<ProcessTransactionStateRequestPartActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessTransactionStateRequestPartActor*>(this)->ActorCallback< ProcessTransactionStateRequestPartActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessTransactionStateRequestPartActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("processTransactionStateRequestPart", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessTransactionStateRequestPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processTransactionStateRequestPart", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ProcessTransactionStateRequestPartActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("processTransactionStateRequestPart", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessTransactionStateRequestPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processTransactionStateRequestPart", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ProcessTransactionStateRequestPartActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("processTransactionStateRequestPart", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessTransactionStateRequestPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processTransactionStateRequestPart", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont6(int loopDepth) 
	{
															#line 2903 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->pActors->send(broadcastTxnRequest(request, SERVER_KNOBS->TXN_STATE_SEND_AMOUNT, true));
															#line 2904 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_3 = yield();
															#line 2904 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<ProcessTransactionStateRequestPartActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14565 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont6when1(__when_expr_3.get(), loopDepth); };
		static_cast<ProcessTransactionStateRequestPartActor*>(this)->actor_wait_state = 4;
															#line 2904 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ProcessTransactionStateRequestPartActor, 3, Void >*>(static_cast<ProcessTransactionStateRequestPartActor*>(this)));
															#line 14570 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9(Void const& _,int loopDepth) 
	{
															#line 2900 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->processed = true;
															#line 14579 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont9(Void && _,int loopDepth) 
	{
															#line 2900 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->processed = true;
															#line 14588 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ProcessTransactionStateRequestPartActor*>(this)->actor_wait_state > 0) static_cast<ProcessTransactionStateRequestPartActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessTransactionStateRequestPartActor*>(this)->ActorCallback< ProcessTransactionStateRequestPartActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessTransactionStateRequestPartActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("processTransactionStateRequestPart", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessTransactionStateRequestPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processTransactionStateRequestPart", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ProcessTransactionStateRequestPartActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("processTransactionStateRequestPart", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessTransactionStateRequestPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processTransactionStateRequestPart", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ProcessTransactionStateRequestPartActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("processTransactionStateRequestPart", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessTransactionStateRequestPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processTransactionStateRequestPart", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont11(Void const& _,int loopDepth) 
	{
															#line 2905 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<ProcessTransactionStateRequestPartActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ProcessTransactionStateRequestPartActorState(); static_cast<ProcessTransactionStateRequestPartActor*>(this)->destroy(); return 0; }
															#line 14672 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<ProcessTransactionStateRequestPartActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ProcessTransactionStateRequestPartActorState();
		static_cast<ProcessTransactionStateRequestPartActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont11(Void && _,int loopDepth) 
	{
															#line 2905 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<ProcessTransactionStateRequestPartActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ProcessTransactionStateRequestPartActorState(); static_cast<ProcessTransactionStateRequestPartActor*>(this)->destroy(); return 0; }
															#line 14684 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<ProcessTransactionStateRequestPartActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ProcessTransactionStateRequestPartActorState();
		static_cast<ProcessTransactionStateRequestPartActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ProcessTransactionStateRequestPartActor*>(this)->actor_wait_state > 0) static_cast<ProcessTransactionStateRequestPartActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessTransactionStateRequestPartActor*>(this)->ActorCallback< ProcessTransactionStateRequestPartActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessTransactionStateRequestPartActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("processTransactionStateRequestPart", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessTransactionStateRequestPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processTransactionStateRequestPart", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ProcessTransactionStateRequestPartActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("processTransactionStateRequestPart", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessTransactionStateRequestPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processTransactionStateRequestPart", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ProcessTransactionStateRequestPartActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("processTransactionStateRequestPart", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessTransactionStateRequestPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processTransactionStateRequestPart", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 2864 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	TransactionStateResolveContext* pContext;
															#line 2864 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	TxnStateRequest request;
															#line 14771 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via processTransactionStateRequestPart()
															#line 2864 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class ProcessTransactionStateRequestPartActor final : public Actor<Void>, public ActorCallback< ProcessTransactionStateRequestPartActor, 0, Void >, public ActorCallback< ProcessTransactionStateRequestPartActor, 1, Void >, public ActorCallback< ProcessTransactionStateRequestPartActor, 2, Void >, public ActorCallback< ProcessTransactionStateRequestPartActor, 3, Void >, public FastAllocated<ProcessTransactionStateRequestPartActor>, public ProcessTransactionStateRequestPartActorState<ProcessTransactionStateRequestPartActor> {
															#line 14776 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<ProcessTransactionStateRequestPartActor>::operator new;
	using FastAllocated<ProcessTransactionStateRequestPartActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14644900707496494080UL, 18175001281919638784UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ProcessTransactionStateRequestPartActor, 0, Void >;
friend struct ActorCallback< ProcessTransactionStateRequestPartActor, 1, Void >;
friend struct ActorCallback< ProcessTransactionStateRequestPartActor, 2, Void >;
friend struct ActorCallback< ProcessTransactionStateRequestPartActor, 3, Void >;
															#line 2864 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProcessTransactionStateRequestPartActor(TransactionStateResolveContext* const& pContext,TxnStateRequest const& request) 
															#line 14796 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ProcessTransactionStateRequestPartActorState<ProcessTransactionStateRequestPartActor>(pContext, request),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("processTransactionStateRequestPart", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6249502656935116032UL, 7110093004433443328UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessTransactionStateRequestPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("processTransactionStateRequestPart");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("processTransactionStateRequestPart", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ProcessTransactionStateRequestPartActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ProcessTransactionStateRequestPartActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ProcessTransactionStateRequestPartActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ProcessTransactionStateRequestPartActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2864 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> processTransactionStateRequestPart( TransactionStateResolveContext* const& pContext, TxnStateRequest const& request ) {
															#line 2864 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new ProcessTransactionStateRequestPartActor(pContext, request));
															#line 14831 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 2907 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

} // anonymous namespace

//
// Metrics related to the commit proxy are logged on a five second interval in
// the `ProxyMetrics` trace. However, it can be hard to determine workload
// burstiness when looking at such a large time range. This function adds much
// more frequent logging for certain metrics to provide fine-grained insight
// into workload patterns. The metrics logged by this function break down into
// two categories:
//
//   * existing counters reported by `ProxyMetrics`
//   * new counters that are only reported by this function
//
// Neither is implemented optimally, but the data collected should be helpful
// in identifying workload patterns on the server.
//
// Metrics reporting by this function can be disabled by setting the
// `BURSTINESS_METRICS_ENABLED` knob to false. The reporting interval can be
// adjusted by modifying the knob `BURSTINESS_METRICS_LOG_INTERVAL`.
//
															#line 14856 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via logDetailedMetrics()
															#line 2928 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class LogDetailedMetricsActor>
															#line 2928 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class LogDetailedMetricsActorState {
															#line 14863 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 2928 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	LogDetailedMetricsActorState(ProxyCommitData* const& commitData) 
															#line 2928 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 2928 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : commitData(commitData),
															#line 2929 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   startTime(0),
															#line 2930 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   commitBatchInBaseline(0),
															#line 2931 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   txnCommitInBaseline(0),
															#line 2932 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   mutationsBaseline(0),
															#line 2933 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   mutationBytesBaseline(0)
															#line 14880 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("logDetailedMetrics", reinterpret_cast<unsigned long>(this));

	}
	~LogDetailedMetricsActorState() 
	{
		fdb_probe_actor_destroy("logDetailedMetrics", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2935 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			;
															#line 14895 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LogDetailedMetricsActorState();
		static_cast<LogDetailedMetricsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2936 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!SERVER_KNOBS->BURSTINESS_METRICS_ENABLED)
															#line 14925 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2937 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (!static_cast<LogDetailedMetricsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LogDetailedMetricsActorState(); static_cast<LogDetailedMetricsActor*>(this)->destroy(); return 0; }
															#line 14929 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			new (&static_cast<LogDetailedMetricsActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~LogDetailedMetricsActorState();
			static_cast<LogDetailedMetricsActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2940 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		startTime = now();
															#line 2941 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		commitBatchInBaseline = commitData->stats.commitBatchIn.getValue();
															#line 2942 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		txnCommitInBaseline = commitData->stats.txnCommitIn.getValue();
															#line 2943 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		mutationsBaseline = commitData->stats.mutations.getValue();
															#line 2944 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		mutationBytesBaseline = commitData->stats.mutationBytes.getValue();
															#line 2946 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->BURSTINESS_METRICS_LOG_INTERVAL);
															#line 2946 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<LogDetailedMetricsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14949 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<LogDetailedMetricsActor*>(this)->actor_wait_state = 1;
															#line 2946 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LogDetailedMetricsActor, 0, Void >*>(static_cast<LogDetailedMetricsActor*>(this)));
															#line 14954 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 2948 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		int64_t commitBatchInReal = commitData->stats.commitBatchIn.getValue();
															#line 2949 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		int64_t txnCommitInReal = commitData->stats.txnCommitIn.getValue();
															#line 2950 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		int64_t mutationsReal = commitData->stats.mutations.getValue();
															#line 2951 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		int64_t mutationBytesReal = commitData->stats.mutationBytes.getValue();
															#line 2955 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (commitBatchInReal < commitBatchInBaseline || txnCommitInReal < txnCommitInBaseline || mutationsReal < mutationsBaseline || mutationBytesReal < mutationBytesBaseline)
															#line 14971 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
			return a_body1loopHead1(loopDepth); // continue
		}
															#line 2960 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		TraceEvent("ProxyDetailedMetrics") .detail("Elapsed", now() - startTime) .detail("CommitBatchIn", commitBatchInReal - commitBatchInBaseline) .detail("TxnCommitIn", txnCommitInReal - txnCommitInBaseline) .detail("Mutations", mutationsReal - mutationsBaseline) .detail("MutationBytes", mutationBytesReal - mutationBytesBaseline) .detail("UniqueClients", commitData->stats.getSizeAndResetUniqueClients());
															#line 14977 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 2948 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		int64_t commitBatchInReal = commitData->stats.commitBatchIn.getValue();
															#line 2949 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		int64_t txnCommitInReal = commitData->stats.txnCommitIn.getValue();
															#line 2950 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		int64_t mutationsReal = commitData->stats.mutations.getValue();
															#line 2951 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		int64_t mutationBytesReal = commitData->stats.mutationBytes.getValue();
															#line 2955 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (commitBatchInReal < commitBatchInBaseline || txnCommitInReal < txnCommitInBaseline || mutationsReal < mutationsBaseline || mutationBytesReal < mutationBytesBaseline)
															#line 14994 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
			return a_body1loopHead1(loopDepth); // continue
		}
															#line 2960 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		TraceEvent("ProxyDetailedMetrics") .detail("Elapsed", now() - startTime) .detail("CommitBatchIn", commitBatchInReal - commitBatchInBaseline) .detail("TxnCommitIn", txnCommitInReal - txnCommitInBaseline) .detail("Mutations", mutationsReal - mutationsBaseline) .detail("MutationBytes", mutationBytesReal - mutationBytesBaseline) .detail("UniqueClients", commitData->stats.getSizeAndResetUniqueClients());
															#line 15000 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LogDetailedMetricsActor*>(this)->actor_wait_state > 0) static_cast<LogDetailedMetricsActor*>(this)->actor_wait_state = 0;
		static_cast<LogDetailedMetricsActor*>(this)->ActorCallback< LogDetailedMetricsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LogDetailedMetricsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("logDetailedMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogDetailedMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logDetailedMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LogDetailedMetricsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("logDetailedMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogDetailedMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logDetailedMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LogDetailedMetricsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("logDetailedMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LogDetailedMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logDetailedMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2928 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCommitData* commitData;
															#line 2929 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	double startTime;
															#line 2930 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	int64_t commitBatchInBaseline;
															#line 2931 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	int64_t txnCommitInBaseline;
															#line 2932 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	int64_t mutationsBaseline;
															#line 2933 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	int64_t mutationBytesBaseline;
															#line 15092 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via logDetailedMetrics()
															#line 2928 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class LogDetailedMetricsActor final : public Actor<Void>, public ActorCallback< LogDetailedMetricsActor, 0, Void >, public FastAllocated<LogDetailedMetricsActor>, public LogDetailedMetricsActorState<LogDetailedMetricsActor> {
															#line 15097 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<LogDetailedMetricsActor>::operator new;
	using FastAllocated<LogDetailedMetricsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18361299188411785216UL, 8467732045646508032UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LogDetailedMetricsActor, 0, Void >;
															#line 2928 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	LogDetailedMetricsActor(ProxyCommitData* const& commitData) 
															#line 15114 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   LogDetailedMetricsActorState<LogDetailedMetricsActor>(commitData),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("logDetailedMetrics", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10939827506186500608UL, 8271598043017025536UL);
		ActorExecutionContextHelper __helper(static_cast<LogDetailedMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("logDetailedMetrics");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("logDetailedMetrics", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LogDetailedMetricsActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2928 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> logDetailedMetrics( ProxyCommitData* const& commitData ) {
															#line 2928 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new LogDetailedMetricsActor(commitData));
															#line 15147 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 2969 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

															#line 15152 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via commitProxyServerCore()
															#line 2970 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class CommitProxyServerCoreActor>
															#line 2970 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class CommitProxyServerCoreActorState {
															#line 15159 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 2970 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitProxyServerCoreActorState(CommitProxyInterface const& proxy,MasterInterface const& master,LifetimeToken const& masterLifetime,Reference<AsyncVar<ServerDBInfo> const> const& db,LogEpoch const& epoch,Version const& recoveryTransactionVersion,bool const& firstProxy,std::string const& whitelistBinPaths,EncryptionAtRestMode const& encryptMode,bool const& provisional,uint16_t const& commitProxyIndex) 
															#line 2970 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 2970 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : proxy(proxy),
															#line 2970 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   master(master),
															#line 2970 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   masterLifetime(masterLifetime),
															#line 2970 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   db(db),
															#line 2970 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   epoch(epoch),
															#line 2970 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   recoveryTransactionVersion(recoveryTransactionVersion),
															#line 2970 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   firstProxy(firstProxy),
															#line 2970 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   whitelistBinPaths(whitelistBinPaths),
															#line 2970 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   encryptMode(encryptMode),
															#line 2970 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   provisional(provisional),
															#line 2970 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   commitProxyIndex(commitProxyIndex),
															#line 2981 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   commitData(proxy.id(), master, proxy.getConsistentReadVersion, recoveryTransactionVersion, proxy.commit, db, firstProxy, encryptMode, provisional, commitProxyIndex, epoch),
															#line 2993 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   sequenceFuture((Sequence)0),
															#line 2994 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   batchedCommits(),
															#line 2995 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   commitBatcherActor(),
															#line 2996 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   lastCommitComplete(Void()),
															#line 2998 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   addActor(),
															#line 2999 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   onError(transformError(actorCollection(addActor.getFuture()), broken_promise(), tlog_failed()))
															#line 15200 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("commitProxyServerCore", reinterpret_cast<unsigned long>(this));

	}
	~CommitProxyServerCoreActorState() 
	{
		fdb_probe_actor_destroy("commitProxyServerCore", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3001 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent("CPEncryptionAtRestMode", proxy.id()).detail("Mode", commitData.encryptMode);
															#line 3003 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			addActor.send(waitFailureServer(proxy.waitFailure.getFuture()));
															#line 3004 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			addActor.send(traceRole(Role::COMMIT_PROXY, proxy.id()));
															#line 3009 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			;
															#line 15221 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CommitProxyServerCoreActorState();
		static_cast<CommitProxyServerCoreActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 3016 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		dbInfoChange = commitData.db->onChange();
															#line 3019 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		commitData.resolvers = commitData.db->get().resolvers;
															#line 3020 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		commitData.localTLogCount = commitData.db->get().logSystemConfig.numLogs();
															#line 3021 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT(commitData.resolvers.size() != 0);
															#line 3022 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for(int i = 0;i < commitData.resolvers.size();++i) {
															#line 3023 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			commitData.stats.resolverDist.push_back(Histogram::getHistogram( "CommitProxy"_sr, "ToResolver_" + commitData.resolvers[i].id().toString(), Histogram::Unit::milliseconds));
															#line 15254 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 3028 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		auto rs = commitData.keyResolvers.modify(SERVER_KNOBS->PROXY_USE_RESOLVER_PRIVATE_MUTATIONS ? normalKeys : allKeys);
															#line 3029 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for(auto r = rs.begin();r != rs.end();++r) {
															#line 3030 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			r->value().emplace_back(0, 0);
															#line 15262 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 3031 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		commitData.systemKeyVersions.push_back(0);
															#line 3033 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		commitData.logSystem = ILogSystem::fromServerDBInfo(proxy.id(), commitData.db->get(), false, addActor);
															#line 3034 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		commitData.logAdapter = new LogSystemDiskQueueAdapter(commitData.logSystem, Reference<AsyncVar<PeekTxsInfo>>(), 1, false);
															#line 3037 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		commitData.txnStateStore = keyValueStoreLogSystem( commitData.logAdapter, commitData.db, proxy.id(), 2e9, true, true, true, encryptMode.isEncryptionEnabled());
															#line 3039 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		createWhitelistBinPathVec(whitelistBinPaths, commitData.whitelistedBinPathVec);
															#line 3041 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		commitData.updateLatencyBandConfig(commitData.db->get().latencyBandConfig);
															#line 3046 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		commitBatchesMemoryLimit = SERVER_KNOBS->COMMIT_BATCHES_MEM_BYTES_HARD_LIMIT;
															#line 3047 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (SERVER_KNOBS->SERVER_MEM_LIMIT > 0)
															#line 15280 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 3048 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			commitBatchesMemoryLimit = std::min( commitBatchesMemoryLimit, static_cast<int64_t>((SERVER_KNOBS->SERVER_MEM_LIMIT * SERVER_KNOBS->COMMIT_BATCHES_MEM_FRACTION_OF_TOTAL) / SERVER_KNOBS->COMMIT_BATCHES_MEM_TO_TOTAL_MEM_SCALE_FACTOR));
															#line 15284 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 3053 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		TraceEvent(SevInfo, "CommitBatchesMemoryLimit").detail("BytesLimit", commitBatchesMemoryLimit);
															#line 3056 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (commitData.rangeLockEnabled())
															#line 15290 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 3057 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			commitData.rangeLock = std::make_shared<RangeLock>(&commitData);
															#line 3058 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent(SevInfo, "CommitProxyRangeLockEnabled", commitData.dbgid);
															#line 15296 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 3061 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		addActor.send(monitorRemoteCommitted(&commitData));
															#line 3062 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		addActor.send(readRequestServer(proxy, addActor, &commitData));
															#line 3063 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		addActor.send(rejoinServer(proxy, &commitData));
															#line 3064 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		addActor.send(ddMetricsRequestServer(proxy, db));
															#line 3065 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		addActor.send(reportTxnTagCommitCost(proxy.id(), db, &commitData.ssTrTagCommitCost));
															#line 3066 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		addActor.send(logDetailedMetrics(&commitData));
															#line 3068 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		auto openDb = openDBOnServer(db);
															#line 3070 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (firstProxy)
															#line 15314 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 3071 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			addActor.send(recurringAsync( [openDb = openDb]() { return cleanIdempotencyIds(openDb, SERVER_KNOBS->IDEMPOTENCY_IDS_MIN_AGE_SECONDS); }, SERVER_KNOBS->IDEMPOTENCY_IDS_CLEANER_POLLING_INTERVAL, true, SERVER_KNOBS->IDEMPOTENCY_IDS_CLEANER_POLLING_INTERVAL));
															#line 15318 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 3077 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		addActor.send(idempotencyIdsExpireServer( openDb, proxy.expireIdempotencyId, commitData.expectedIdempotencyIdCountForKey, &commitData.idempotencyClears));
															#line 3081 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = success(commitData.txnStateStore->readValue(StringRef()));
															#line 3081 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<CommitProxyServerCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15326 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CommitProxyServerCoreActor*>(this)->actor_wait_state = 2;
															#line 3081 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CommitProxyServerCoreActor, 1, Void >*>(static_cast<CommitProxyServerCoreActor*>(this)));
															#line 15331 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 3009 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!(!(masterLifetime.isEqual(commitData.db->get().masterLifetime) && commitData.db->get().recoveryState >= RecoveryState::RECOVERY_TRANSACTION && (!commitData.encryptMode.isEncryptionEnabled() || commitData.db->get().client.encryptKeyProxy.present()))))
															#line 15347 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 3014 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_0 = commitData.db->onChange();
															#line 3014 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<CommitProxyServerCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15355 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<CommitProxyServerCoreActor*>(this)->actor_wait_state = 1;
															#line 3014 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CommitProxyServerCoreActor, 0, Void >*>(static_cast<CommitProxyServerCoreActor*>(this)));
															#line 15360 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CommitProxyServerCoreActor*>(this)->actor_wait_state > 0) static_cast<CommitProxyServerCoreActor*>(this)->actor_wait_state = 0;
		static_cast<CommitProxyServerCoreActor*>(this)->ActorCallback< CommitProxyServerCoreActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CommitProxyServerCoreActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CommitProxyServerCoreActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CommitProxyServerCoreActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 3083 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		int commitBatchByteLimit = (int)std::min<double>(SERVER_KNOBS->COMMIT_TRANSACTION_BATCH_BYTES_MAX, std::max<double>(SERVER_KNOBS->COMMIT_TRANSACTION_BATCH_BYTES_MIN, SERVER_KNOBS->COMMIT_TRANSACTION_BATCH_BYTES_SCALE_BASE * pow(commitData.db->get().client.commitProxies.size(), SERVER_KNOBS->COMMIT_TRANSACTION_BATCH_BYTES_SCALE_POWER)));
															#line 3090 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		commitBatcherActor = commitBatcher( &commitData, batchedCommits, proxy.commit.getFuture(), commitBatchByteLimit, commitBatchesMemoryLimit);
															#line 3094 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		transactionStateResolveContext = TransactionStateResolveContext(&commitData, &addActor);
															#line 3096 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		;
															#line 15475 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 3083 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		int commitBatchByteLimit = (int)std::min<double>(SERVER_KNOBS->COMMIT_TRANSACTION_BATCH_BYTES_MAX, std::max<double>(SERVER_KNOBS->COMMIT_TRANSACTION_BATCH_BYTES_MIN, SERVER_KNOBS->COMMIT_TRANSACTION_BATCH_BYTES_SCALE_BASE * pow(commitData.db->get().client.commitProxies.size(), SERVER_KNOBS->COMMIT_TRANSACTION_BATCH_BYTES_SCALE_POWER)));
															#line 3090 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		commitBatcherActor = commitBatcher( &commitData, batchedCommits, proxy.commit.getFuture(), commitBatchByteLimit, commitBatchesMemoryLimit);
															#line 3094 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		transactionStateResolveContext = TransactionStateResolveContext(&commitData, &addActor);
															#line 3096 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		;
															#line 15490 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CommitProxyServerCoreActor*>(this)->actor_wait_state > 0) static_cast<CommitProxyServerCoreActor*>(this)->actor_wait_state = 0;
		static_cast<CommitProxyServerCoreActor*>(this)->ActorCallback< CommitProxyServerCoreActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CommitProxyServerCoreActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CommitProxyServerCoreActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CommitProxyServerCoreActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 3097 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_2 = dbInfoChange;
															#line 3096 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<CommitProxyServerCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15583 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_2.get(), loopDepth); };
															#line 3110 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_3 = onError;
															#line 15587 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when2(__when_expr_3.get(), loopDepth); };
															#line 3111 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		auto __when_expr_4 = batchedCommits.getFuture();
															#line 15591 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_4), FutureStream<std::pair<std::vector<CommitTransactionRequest>, int>>>::value || std::is_same<decltype(__when_expr_4), ThreadFutureStream<std::pair<std::vector<CommitTransactionRequest>, int>>>::value, "invalid type");
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when3(__when_expr_4.pop(), loopDepth); };
															#line 3141 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		auto __when_expr_5 = proxy.proxySnapReq.getFuture();
															#line 15596 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_5), FutureStream<ProxySnapRequest>>::value || std::is_same<decltype(__when_expr_5), ThreadFutureStream<ProxySnapRequest>>::value, "invalid type");
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when4(__when_expr_5.pop(), loopDepth); };
															#line 3145 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		auto __when_expr_6 = proxy.exclusionSafetyCheckReq.getFuture();
															#line 15601 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_6), FutureStream<ExclusionSafetyCheckRequest>>::value || std::is_same<decltype(__when_expr_6), ThreadFutureStream<ExclusionSafetyCheckRequest>>::value, "invalid type");
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when5(__when_expr_6.pop(), loopDepth); };
															#line 3148 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		auto __when_expr_7 = proxy.txnState.getFuture();
															#line 15606 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_7), FutureStream<TxnStateRequest>>::value || std::is_same<decltype(__when_expr_7), ThreadFutureStream<TxnStateRequest>>::value, "invalid type");
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when6(__when_expr_7.pop(), loopDepth); };
															#line 3151 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		auto __when_expr_8 = proxy.setThrottledShard.getFuture();
															#line 15611 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_8), FutureStream<SetThrottledShardRequest>>::value || std::is_same<decltype(__when_expr_8), ThreadFutureStream<SetThrottledShardRequest>>::value, "invalid type");
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when7(__when_expr_8.pop(), loopDepth); };
		static_cast<CommitProxyServerCoreActor*>(this)->actor_wait_state = 3;
															#line 3097 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CommitProxyServerCoreActor, 2, Void >*>(static_cast<CommitProxyServerCoreActor*>(this)));
															#line 3110 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CommitProxyServerCoreActor, 3, Void >*>(static_cast<CommitProxyServerCoreActor*>(this)));
															#line 3111 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorSingleCallback< CommitProxyServerCoreActor, 4, std::pair<std::vector<CommitTransactionRequest>, int> >*>(static_cast<CommitProxyServerCoreActor*>(this)));
															#line 3141 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorSingleCallback< CommitProxyServerCoreActor, 5, ProxySnapRequest >*>(static_cast<CommitProxyServerCoreActor*>(this)));
															#line 3145 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorSingleCallback< CommitProxyServerCoreActor, 6, ExclusionSafetyCheckRequest >*>(static_cast<CommitProxyServerCoreActor*>(this)));
															#line 3148 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorSingleCallback< CommitProxyServerCoreActor, 7, TxnStateRequest >*>(static_cast<CommitProxyServerCoreActor*>(this)));
															#line 3151 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorSingleCallback< CommitProxyServerCoreActor, 8, SetThrottledShardRequest >*>(static_cast<CommitProxyServerCoreActor*>(this)));
															#line 15629 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 3098 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		dbInfoChange = commitData.db->onChange();
															#line 3099 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (masterLifetime.isEqual(commitData.db->get().masterLifetime) && commitData.db->get().recoveryState >= RecoveryState::RECOVERY_TRANSACTION)
															#line 15646 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 3101 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			commitData.logSystem = ILogSystem::fromServerDBInfo(proxy.id(), commitData.db->get(), false, addActor);
															#line 3102 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for( auto it : commitData.tag_popped ) {
															#line 3103 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				commitData.logSystem->pop(it.second, it.first);
															#line 15654 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 3105 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			commitData.logSystem->popTxs(commitData.lastTxsPop, tagLocalityRemoteLog);
															#line 15658 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 3108 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		commitData.updateLatencyBandConfig(commitData.db->get().latencyBandConfig);
															#line 15662 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
															#line 3098 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		dbInfoChange = commitData.db->onChange();
															#line 3099 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (masterLifetime.isEqual(commitData.db->get().masterLifetime) && commitData.db->get().recoveryState >= RecoveryState::RECOVERY_TRANSACTION)
															#line 15673 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 3101 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			commitData.logSystem = ILogSystem::fromServerDBInfo(proxy.id(), commitData.db->get(), false, addActor);
															#line 3102 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for( auto it : commitData.tag_popped ) {
															#line 3103 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				commitData.logSystem->pop(it.second, it.first);
															#line 15681 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 3105 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			commitData.logSystem->popTxs(commitData.lastTxsPop, tagLocalityRemoteLog);
															#line 15685 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 3108 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		commitData.updateLatencyBandConfig(commitData.db->get().latencyBandConfig);
															#line 15689 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when3(std::pair<std::vector<CommitTransactionRequest>, int> const& batchedRequests,int loopDepth) 
	{
															#line 3127 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		const std::vector<CommitTransactionRequest>& trs = batchedRequests.first;
															#line 3128 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		const int batchBytes = batchedRequests.second;
															#line 3129 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (trs.size() || (commitData.db->get().recoveryState >= RecoveryState::ACCEPTING_COMMITS && masterLifetime.isEqual(commitData.db->get().masterLifetime) && lastCommitComplete.isReady()))
															#line 15714 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 3133 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			lastCommitComplete = commitBatch(&commitData, const_cast<std::vector<CommitTransactionRequest>*>(&batchedRequests.first), batchBytes);
															#line 3138 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			addActor.send(lastCommitComplete);
															#line 15720 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when3(std::pair<std::vector<CommitTransactionRequest>, int> && batchedRequests,int loopDepth) 
	{
															#line 3127 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		const std::vector<CommitTransactionRequest>& trs = batchedRequests.first;
															#line 3128 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		const int batchBytes = batchedRequests.second;
															#line 3129 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (trs.size() || (commitData.db->get().recoveryState >= RecoveryState::ACCEPTING_COMMITS && masterLifetime.isEqual(commitData.db->get().masterLifetime) && lastCommitComplete.isReady()))
															#line 15734 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 3133 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			lastCommitComplete = commitBatch(&commitData, const_cast<std::vector<CommitTransactionRequest>*>(&batchedRequests.first), batchBytes);
															#line 3138 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			addActor.send(lastCommitComplete);
															#line 15740 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when4(ProxySnapRequest const& snapReq,int loopDepth) 
	{
															#line 3142 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		TraceEvent(SevDebug, "SnapMasterEnqueue").log();
															#line 3143 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		addActor.send(proxySnapCreate(snapReq, &commitData));
															#line 15752 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when4(ProxySnapRequest && snapReq,int loopDepth) 
	{
															#line 3142 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		TraceEvent(SevDebug, "SnapMasterEnqueue").log();
															#line 3143 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		addActor.send(proxySnapCreate(snapReq, &commitData));
															#line 15763 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when5(ExclusionSafetyCheckRequest const& exclCheckReq,int loopDepth) 
	{
															#line 3146 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		addActor.send(proxyCheckSafeExclusion(db, exclCheckReq));
															#line 15772 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when5(ExclusionSafetyCheckRequest && exclCheckReq,int loopDepth) 
	{
															#line 3146 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		addActor.send(proxyCheckSafeExclusion(db, exclCheckReq));
															#line 15781 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when6(TxnStateRequest const& request,int loopDepth) 
	{
															#line 3149 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		addActor.send(processTransactionStateRequestPart(&transactionStateResolveContext, request));
															#line 15790 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when6(TxnStateRequest && request,int loopDepth) 
	{
															#line 3149 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		addActor.send(processTransactionStateRequestPart(&transactionStateResolveContext, request));
															#line 15799 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when7(SetThrottledShardRequest const& request,int loopDepth) 
	{
															#line 3152 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for( auto& shard : request.throttledShards ) {
															#line 3153 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			auto it = commitData.hotShards.begin();
															#line 3154 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for(;it != commitData.hotShards.end();++it) {
															#line 3155 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (it->first == shard)
															#line 15814 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				{
															#line 3156 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					it->second = request.expirationTime;
															#line 15818 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					break;
				}
			}
															#line 3160 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (it == commitData.hotShards.end())
															#line 15824 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 3161 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				commitData.hotShards.emplace_back(std::make_pair(shard, request.expirationTime));
															#line 15828 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
		}
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when7(SetThrottledShardRequest && request,int loopDepth) 
	{
															#line 3152 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for( auto& shard : request.throttledShards ) {
															#line 3153 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			auto it = commitData.hotShards.begin();
															#line 3154 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for(;it != commitData.hotShards.end();++it) {
															#line 3155 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (it->first == shard)
															#line 15845 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				{
															#line 3156 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					it->second = request.expirationTime;
															#line 15849 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					break;
				}
			}
															#line 3160 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (it == commitData.hotShards.end())
															#line 15855 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 3161 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				commitData.hotShards.emplace_back(std::make_pair(shard, request.expirationTime));
															#line 15859 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
		}
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CommitProxyServerCoreActor*>(this)->actor_wait_state > 0) static_cast<CommitProxyServerCoreActor*>(this)->actor_wait_state = 0;
		static_cast<CommitProxyServerCoreActor*>(this)->ActorCallback< CommitProxyServerCoreActor, 2, Void >::remove();
		static_cast<CommitProxyServerCoreActor*>(this)->ActorCallback< CommitProxyServerCoreActor, 3, Void >::remove();
		static_cast<CommitProxyServerCoreActor*>(this)->ActorSingleCallback< CommitProxyServerCoreActor, 4, std::pair<std::vector<CommitTransactionRequest>, int> >::remove();
		static_cast<CommitProxyServerCoreActor*>(this)->ActorSingleCallback< CommitProxyServerCoreActor, 5, ProxySnapRequest >::remove();
		static_cast<CommitProxyServerCoreActor*>(this)->ActorSingleCallback< CommitProxyServerCoreActor, 6, ExclusionSafetyCheckRequest >::remove();
		static_cast<CommitProxyServerCoreActor*>(this)->ActorSingleCallback< CommitProxyServerCoreActor, 7, TxnStateRequest >::remove();
		static_cast<CommitProxyServerCoreActor*>(this)->ActorSingleCallback< CommitProxyServerCoreActor, 8, SetThrottledShardRequest >::remove();

	}
	void a_callback_fire(ActorCallback< CommitProxyServerCoreActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CommitProxyServerCoreActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CommitProxyServerCoreActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CommitProxyServerCoreActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CommitProxyServerCoreActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CommitProxyServerCoreActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< CommitProxyServerCoreActor, 4, std::pair<std::vector<CommitTransactionRequest>, int> >*,std::pair<std::vector<CommitTransactionRequest>, int> const& value) 
	{
		fdb_probe_actor_enter("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorSingleCallback< CommitProxyServerCoreActor, 4, std::pair<std::vector<CommitTransactionRequest>, int> >*,std::pair<std::vector<CommitTransactionRequest>, int> && value) 
	{
		fdb_probe_actor_enter("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorSingleCallback< CommitProxyServerCoreActor, 4, std::pair<std::vector<CommitTransactionRequest>, int> >*,Error err) 
	{
		fdb_probe_actor_enter("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorSingleCallback< CommitProxyServerCoreActor, 5, ProxySnapRequest >*,ProxySnapRequest const& value) 
	{
		fdb_probe_actor_enter("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorSingleCallback< CommitProxyServerCoreActor, 5, ProxySnapRequest >*,ProxySnapRequest && value) 
	{
		fdb_probe_actor_enter("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorSingleCallback< CommitProxyServerCoreActor, 5, ProxySnapRequest >*,Error err) 
	{
		fdb_probe_actor_enter("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorSingleCallback< CommitProxyServerCoreActor, 6, ExclusionSafetyCheckRequest >*,ExclusionSafetyCheckRequest const& value) 
	{
		fdb_probe_actor_enter("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when5(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorSingleCallback< CommitProxyServerCoreActor, 6, ExclusionSafetyCheckRequest >*,ExclusionSafetyCheckRequest && value) 
	{
		fdb_probe_actor_enter("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when5(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorSingleCallback< CommitProxyServerCoreActor, 6, ExclusionSafetyCheckRequest >*,Error err) 
	{
		fdb_probe_actor_enter("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorSingleCallback< CommitProxyServerCoreActor, 7, TxnStateRequest >*,TxnStateRequest const& value) 
	{
		fdb_probe_actor_enter("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when6(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorSingleCallback< CommitProxyServerCoreActor, 7, TxnStateRequest >*,TxnStateRequest && value) 
	{
		fdb_probe_actor_enter("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when6(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorSingleCallback< CommitProxyServerCoreActor, 7, TxnStateRequest >*,Error err) 
	{
		fdb_probe_actor_enter("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorSingleCallback< CommitProxyServerCoreActor, 8, SetThrottledShardRequest >*,SetThrottledShardRequest const& value) 
	{
		fdb_probe_actor_enter("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when7(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorSingleCallback< CommitProxyServerCoreActor, 8, SetThrottledShardRequest >*,SetThrottledShardRequest && value) 
	{
		fdb_probe_actor_enter("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when7(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorSingleCallback< CommitProxyServerCoreActor, 8, SetThrottledShardRequest >*,Error err) 
	{
		fdb_probe_actor_enter("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 8);

	}
															#line 2970 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitProxyInterface proxy;
															#line 2970 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	MasterInterface master;
															#line 2970 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	LifetimeToken masterLifetime;
															#line 2970 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> db;
															#line 2970 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	LogEpoch epoch;
															#line 2970 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Version recoveryTransactionVersion;
															#line 2970 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	bool firstProxy;
															#line 2970 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	std::string whitelistBinPaths;
															#line 2970 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	EncryptionAtRestMode encryptMode;
															#line 2970 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	bool provisional;
															#line 2970 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	uint16_t commitProxyIndex;
															#line 2981 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCommitData commitData;
															#line 2993 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Future<Sequence> sequenceFuture;
															#line 2994 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	PromiseStream<std::pair<std::vector<CommitTransactionRequest>, int>> batchedCommits;
															#line 2995 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Future<Void> commitBatcherActor;
															#line 2996 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Future<Void> lastCommitComplete;
															#line 2998 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	PromiseStream<Future<Void>> addActor;
															#line 2999 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Future<Void> onError;
															#line 3016 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Future<Void> dbInfoChange;
															#line 3046 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	int64_t commitBatchesMemoryLimit;
															#line 3094 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	TransactionStateResolveContext transactionStateResolveContext;
															#line 16319 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via commitProxyServerCore()
															#line 2970 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class CommitProxyServerCoreActor final : public Actor<Void>, public ActorCallback< CommitProxyServerCoreActor, 0, Void >, public ActorCallback< CommitProxyServerCoreActor, 1, Void >, public ActorCallback< CommitProxyServerCoreActor, 2, Void >, public ActorCallback< CommitProxyServerCoreActor, 3, Void >, public ActorSingleCallback< CommitProxyServerCoreActor, 4, std::pair<std::vector<CommitTransactionRequest>, int> >, public ActorSingleCallback< CommitProxyServerCoreActor, 5, ProxySnapRequest >, public ActorSingleCallback< CommitProxyServerCoreActor, 6, ExclusionSafetyCheckRequest >, public ActorSingleCallback< CommitProxyServerCoreActor, 7, TxnStateRequest >, public ActorSingleCallback< CommitProxyServerCoreActor, 8, SetThrottledShardRequest >, public FastAllocated<CommitProxyServerCoreActor>, public CommitProxyServerCoreActorState<CommitProxyServerCoreActor> {
															#line 16324 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<CommitProxyServerCoreActor>::operator new;
	using FastAllocated<CommitProxyServerCoreActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17053848596564840704UL, 812918971130054144UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CommitProxyServerCoreActor, 0, Void >;
friend struct ActorCallback< CommitProxyServerCoreActor, 1, Void >;
friend struct ActorCallback< CommitProxyServerCoreActor, 2, Void >;
friend struct ActorCallback< CommitProxyServerCoreActor, 3, Void >;
friend struct ActorSingleCallback< CommitProxyServerCoreActor, 4, std::pair<std::vector<CommitTransactionRequest>, int> >;
friend struct ActorSingleCallback< CommitProxyServerCoreActor, 5, ProxySnapRequest >;
friend struct ActorSingleCallback< CommitProxyServerCoreActor, 6, ExclusionSafetyCheckRequest >;
friend struct ActorSingleCallback< CommitProxyServerCoreActor, 7, TxnStateRequest >;
friend struct ActorSingleCallback< CommitProxyServerCoreActor, 8, SetThrottledShardRequest >;
															#line 2970 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitProxyServerCoreActor(CommitProxyInterface const& proxy,MasterInterface const& master,LifetimeToken const& masterLifetime,Reference<AsyncVar<ServerDBInfo> const> const& db,LogEpoch const& epoch,Version const& recoveryTransactionVersion,bool const& firstProxy,std::string const& whitelistBinPaths,EncryptionAtRestMode const& encryptMode,bool const& provisional,uint16_t const& commitProxyIndex) 
															#line 16349 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   CommitProxyServerCoreActorState<CommitProxyServerCoreActor>(proxy, master, masterLifetime, db, epoch, recoveryTransactionVersion, firstProxy, whitelistBinPaths, encryptMode, provisional, commitProxyIndex),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("commitProxyServerCore", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13651068504771179520UL, 3876791042535516160UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("commitProxyServerCore");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("commitProxyServerCore", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CommitProxyServerCoreActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CommitProxyServerCoreActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CommitProxyServerCoreActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2970 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> commitProxyServerCore( CommitProxyInterface const& proxy, MasterInterface const& master, LifetimeToken const& masterLifetime, Reference<AsyncVar<ServerDBInfo> const> const& db, LogEpoch const& epoch, Version const& recoveryTransactionVersion, bool const& firstProxy, std::string const& whitelistBinPaths, EncryptionAtRestMode const& encryptMode, bool const& provisional, uint16_t const& commitProxyIndex ) {
															#line 2970 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new CommitProxyServerCoreActor(proxy, master, masterLifetime, db, epoch, recoveryTransactionVersion, firstProxy, whitelistBinPaths, encryptMode, provisional, commitProxyIndex));
															#line 16384 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 3168 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

// only update the local Db info if the CP is not removed
															#line 16390 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via updateLocalDbInfo()
															#line 3170 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class UpdateLocalDbInfoActor>
															#line 3170 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class UpdateLocalDbInfoActorState {
															#line 16397 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 3170 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	UpdateLocalDbInfoActorState(Reference<AsyncVar<ServerDBInfo> const> const& in,Reference<AsyncVar<ServerDBInfo>> const& out,uint64_t const& recoveryCount,CommitProxyInterface const& myInterface) 
															#line 3170 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 3170 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : in(in),
															#line 3170 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   out(out),
															#line 3170 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   recoveryCount(recoveryCount),
															#line 3170 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   myInterface(myInterface),
															#line 3175 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   firstValidDbInfo(false)
															#line 16412 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("updateLocalDbInfo", reinterpret_cast<unsigned long>(this));

	}
	~UpdateLocalDbInfoActorState() 
	{
		fdb_probe_actor_destroy("updateLocalDbInfo", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3177 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			;
															#line 16427 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateLocalDbInfoActorState();
		static_cast<UpdateLocalDbInfoActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 3178 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		bool isIncluded = std::count(in->get().client.commitProxies.begin(), in->get().client.commitProxies.end(), myInterface);
															#line 3180 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (in->get().recoveryCount >= recoveryCount && !isIncluded)
															#line 16459 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 3181 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			return a_body1Catch1(worker_removed(), std::max(0, loopDepth - 1));
															#line 16463 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 3184 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (isIncluded)
															#line 16467 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 3185 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			firstValidDbInfo = true;
															#line 16471 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 3190 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (isIncluded || !firstValidDbInfo)
															#line 16475 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 3191 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			DisabledTraceEvent("UpdateLocalDbInfo", myInterface.id()) .detail("Provisional", myInterface.provisional) .detail("Included", isIncluded) .detail("FirstValid", firstValidDbInfo) .detail("ReceivedRC", in->get().recoveryCount) .detail("RecoveryCount", recoveryCount);
															#line 3197 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (in->get().recoveryCount >= out->get().recoveryCount)
															#line 16481 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 3198 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				out->set(in->get());
															#line 16485 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
		}
															#line 3202 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_0 = in->onChange();
															#line 3202 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<UpdateLocalDbInfoActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16492 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<UpdateLocalDbInfoActor*>(this)->actor_wait_state = 1;
															#line 3202 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateLocalDbInfoActor, 0, Void >*>(static_cast<UpdateLocalDbInfoActor*>(this)));
															#line 16497 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateLocalDbInfoActor*>(this)->actor_wait_state > 0) static_cast<UpdateLocalDbInfoActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateLocalDbInfoActor*>(this)->ActorCallback< UpdateLocalDbInfoActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateLocalDbInfoActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateLocalDbInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLocalDbInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLocalDbInfo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateLocalDbInfoActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateLocalDbInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLocalDbInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLocalDbInfo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateLocalDbInfoActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateLocalDbInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLocalDbInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLocalDbInfo", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 3170 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> in;
															#line 3170 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Reference<AsyncVar<ServerDBInfo>> out;
															#line 3170 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	uint64_t recoveryCount;
															#line 3170 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitProxyInterface myInterface;
															#line 3175 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	bool firstValidDbInfo;
															#line 16599 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via updateLocalDbInfo()
															#line 3170 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class UpdateLocalDbInfoActor final : public Actor<Void>, public ActorCallback< UpdateLocalDbInfoActor, 0, Void >, public FastAllocated<UpdateLocalDbInfoActor>, public UpdateLocalDbInfoActorState<UpdateLocalDbInfoActor> {
															#line 16604 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<UpdateLocalDbInfoActor>::operator new;
	using FastAllocated<UpdateLocalDbInfoActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5310736570420864000UL, 3639138668240741376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateLocalDbInfoActor, 0, Void >;
															#line 3170 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	UpdateLocalDbInfoActor(Reference<AsyncVar<ServerDBInfo> const> const& in,Reference<AsyncVar<ServerDBInfo>> const& out,uint64_t const& recoveryCount,CommitProxyInterface const& myInterface) 
															#line 16621 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   UpdateLocalDbInfoActorState<UpdateLocalDbInfoActor>(in, out, recoveryCount, myInterface),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateLocalDbInfo", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7818349006170799616UL, 15165590002087843072UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLocalDbInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateLocalDbInfo");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateLocalDbInfo", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateLocalDbInfoActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 3170 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> updateLocalDbInfo( Reference<AsyncVar<ServerDBInfo> const> const& in, Reference<AsyncVar<ServerDBInfo>> const& out, uint64_t const& recoveryCount, CommitProxyInterface const& myInterface ) {
															#line 3170 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new UpdateLocalDbInfoActor(in, out, recoveryCount, myInterface));
															#line 16654 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 3205 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

															#line 16659 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via commitProxyServer()
															#line 3206 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class CommitProxyServerActor>
															#line 3206 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class CommitProxyServerActorState {
															#line 16666 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 3206 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitProxyServerActorState(CommitProxyInterface const& proxy,InitializeCommitProxyRequest const& req,Reference<AsyncVar<ServerDBInfo> const> const& db,std::string const& whitelistBinPaths) 
															#line 3206 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 3206 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : proxy(proxy),
															#line 3206 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   req(req),
															#line 3206 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   db(db),
															#line 3206 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   whitelistBinPaths(whitelistBinPaths)
															#line 16679 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("commitProxyServer", reinterpret_cast<unsigned long>(this));

	}
	~CommitProxyServerActorState() 
	{
		fdb_probe_actor_destroy("commitProxyServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 3211 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				localDb = makeReference<AsyncVar<ServerDBInfo>>();
															#line 3212 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				core = commitProxyServerCore(proxy, req.master, req.masterLifetime, localDb, req.recoveryCount, req.recoveryTransactionVersion, req.firstProxy, whitelistBinPaths, req.encryptMode, proxy.provisional, req.commitProxyIndex);
															#line 3223 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				StrictFuture<Void> __when_expr_0 = core || updateLocalDbInfo(db, localDb, req.recoveryCount, proxy);
															#line 3223 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (static_cast<CommitProxyServerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 16701 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<CommitProxyServerActor*>(this)->actor_wait_state = 1;
															#line 3223 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CommitProxyServerActor, 0, Void >*>(static_cast<CommitProxyServerActor*>(this)));
															#line 16706 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CommitProxyServerActorState();
		static_cast<CommitProxyServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 3236 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<CommitProxyServerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CommitProxyServerActorState(); static_cast<CommitProxyServerActor*>(this)->destroy(); return 0; }
															#line 16735 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<CommitProxyServerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CommitProxyServerActorState();
		static_cast<CommitProxyServerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 3225 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			Severity sev = e.code() == error_code_failed_to_progress ? SevWarnAlways : SevInfo;
															#line 3226 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent(sev, "CommitProxyTerminated", proxy.id()).errorUnsuppressed(e);
															#line 3228 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (e.code() != error_code_worker_removed && e.code() != error_code_tlog_stopped && e.code() != error_code_tlog_failed && e.code() != error_code_coordinators_changed && e.code() != error_code_coordinated_state_conflict && e.code() != error_code_new_coordinators_timed_out && e.code() != error_code_failed_to_progress)
															#line 16752 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 3232 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 16756 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 3234 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			CODE_PROBE(e.code() == error_code_failed_to_progress, "Commit proxy failed to progress");
															#line 16760 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CommitProxyServerActor*>(this)->actor_wait_state > 0) static_cast<CommitProxyServerActor*>(this)->actor_wait_state = 0;
		static_cast<CommitProxyServerActor*>(this)->ActorCallback< CommitProxyServerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CommitProxyServerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("commitProxyServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CommitProxyServerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("commitProxyServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CommitProxyServerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("commitProxyServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServer", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 3206 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitProxyInterface proxy;
															#line 3206 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	InitializeCommitProxyRequest req;
															#line 3206 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> db;
															#line 3206 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	std::string whitelistBinPaths;
															#line 3211 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Reference<AsyncVar<ServerDBInfo>> localDb;
															#line 3212 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Future<Void> core;
															#line 16883 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via commitProxyServer()
															#line 3206 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class CommitProxyServerActor final : public Actor<Void>, public ActorCallback< CommitProxyServerActor, 0, Void >, public FastAllocated<CommitProxyServerActor>, public CommitProxyServerActorState<CommitProxyServerActor> {
															#line 16888 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<CommitProxyServerActor>::operator new;
	using FastAllocated<CommitProxyServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13976381377752459520UL, 2752103000672333312UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CommitProxyServerActor, 0, Void >;
															#line 3206 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitProxyServerActor(CommitProxyInterface const& proxy,InitializeCommitProxyRequest const& req,Reference<AsyncVar<ServerDBInfo> const> const& db,std::string const& whitelistBinPaths) 
															#line 16905 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   CommitProxyServerActorState<CommitProxyServerActor>(proxy, req, db, whitelistBinPaths),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("commitProxyServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12704666793118132224UL, 3593437101714446336UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("commitProxyServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("commitProxyServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CommitProxyServerActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 3206 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> commitProxyServer( CommitProxyInterface const& proxy, InitializeCommitProxyRequest const& req, Reference<AsyncVar<ServerDBInfo> const> const& db, std::string const& whitelistBinPaths ) {
															#line 3206 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new CommitProxyServerActor(proxy, req, db, whitelistBinPaths));
															#line 16938 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 3238 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

void forceLinkCommitProxyTests() {}
