#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbcli/ConsistencyCheckCommand.actor.cpp"
/*
 * ConsistencyCheckCommand.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbcli/fdbcli.actor.h"

#include "fdbclient/FDBOptions.g.h"
#include "fdbclient/IClientApi.h"

#include "flow/Arena.h"
#include "flow/FastRef.h"
#include "flow/ThreadHelper.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

namespace fdb_cli {

const KeyRef consistencyCheckSpecialKey = "\xff\xff/management/consistency_check_suspended"_sr;

															#line 37 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyCheckCommand.actor.g.cpp.py_gen"
// This generated class is to be used only via consistencyCheckCommandActor()
															#line 35 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbcli/ConsistencyCheckCommand.actor.cpp"
template <class ConsistencyCheckCommandActorActor>
															#line 35 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbcli/ConsistencyCheckCommand.actor.cpp"
class ConsistencyCheckCommandActorActorState {
															#line 43 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyCheckCommand.actor.g.cpp.py_gen"
public:
															#line 35 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbcli/ConsistencyCheckCommand.actor.cpp"
	ConsistencyCheckCommandActorActorState(Reference<ITransaction> const& tr,std::vector<StringRef> const& tokens,bool const& intrans) 
															#line 35 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbcli/ConsistencyCheckCommand.actor.cpp"
															#line 35 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbcli/ConsistencyCheckCommand.actor.cpp"
		 : tr(tr),
															#line 35 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbcli/ConsistencyCheckCommand.actor.cpp"
		   tokens(tokens),
															#line 35 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbcli/ConsistencyCheckCommand.actor.cpp"
		   intrans(intrans)
															#line 54 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyCheckCommand.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("consistencyCheckCommandActor", reinterpret_cast<unsigned long>(this));

	}
	~ConsistencyCheckCommandActorActorState() 
	{
		fdb_probe_actor_destroy("consistencyCheckCommandActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 40 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbcli/ConsistencyCheckCommand.actor.cpp"
			tr->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 41 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbcli/ConsistencyCheckCommand.actor.cpp"
			if (tokens.size() == 1)
															#line 71 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyCheckCommand.actor.g.cpp.py_gen"
			{
															#line 43 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbcli/ConsistencyCheckCommand.actor.cpp"
				suspendedF = tr->get(consistencyCheckSpecialKey);
															#line 44 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbcli/ConsistencyCheckCommand.actor.cpp"
				StrictFuture<Optional<Value>> __when_expr_0 = safeThreadFutureToFuture(suspendedF);
															#line 44 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbcli/ConsistencyCheckCommand.actor.cpp"
				if (static_cast<ConsistencyCheckCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 79 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyCheckCommand.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ConsistencyCheckCommandActorActor*>(this)->actor_wait_state = 1;
															#line 44 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbcli/ConsistencyCheckCommand.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ConsistencyCheckCommandActorActor, 0, Optional<Value> >*>(static_cast<ConsistencyCheckCommandActorActor*>(this)));
															#line 84 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyCheckCommand.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 46 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbcli/ConsistencyCheckCommand.actor.cpp"
				if (tokens.size() == 2 && tokencmp(tokens[1], "off"))
															#line 91 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyCheckCommand.actor.g.cpp.py_gen"
				{
															#line 47 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbcli/ConsistencyCheckCommand.actor.cpp"
					tr->set(consistencyCheckSpecialKey, Value());
															#line 48 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbcli/ConsistencyCheckCommand.actor.cpp"
					if (!intrans)
															#line 97 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyCheckCommand.actor.g.cpp.py_gen"
					{
															#line 49 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbcli/ConsistencyCheckCommand.actor.cpp"
						StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->commit());
															#line 49 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbcli/ConsistencyCheckCommand.actor.cpp"
						if (static_cast<ConsistencyCheckCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 103 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyCheckCommand.actor.g.cpp.py_gen"
						if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
						static_cast<ConsistencyCheckCommandActorActor*>(this)->actor_wait_state = 2;
															#line 49 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbcli/ConsistencyCheckCommand.actor.cpp"
						__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ConsistencyCheckCommandActorActor, 1, Void >*>(static_cast<ConsistencyCheckCommandActorActor*>(this)));
															#line 108 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyCheckCommand.actor.g.cpp.py_gen"
						loopDepth = 0;
					}
					else
					{
						loopDepth = a_body1cont5(loopDepth);
					}
				}
				else
				{
															#line 50 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbcli/ConsistencyCheckCommand.actor.cpp"
					if (tokens.size() == 2 && tokencmp(tokens[1], "on"))
															#line 120 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyCheckCommand.actor.g.cpp.py_gen"
					{
															#line 51 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbcli/ConsistencyCheckCommand.actor.cpp"
						tr->clear(consistencyCheckSpecialKey);
															#line 52 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbcli/ConsistencyCheckCommand.actor.cpp"
						if (!intrans)
															#line 126 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyCheckCommand.actor.g.cpp.py_gen"
						{
															#line 53 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbcli/ConsistencyCheckCommand.actor.cpp"
							StrictFuture<Void> __when_expr_2 = safeThreadFutureToFuture(tr->commit());
															#line 53 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbcli/ConsistencyCheckCommand.actor.cpp"
							if (static_cast<ConsistencyCheckCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 132 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyCheckCommand.actor.g.cpp.py_gen"
							if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1when3(__when_expr_2.get(), loopDepth); };
							static_cast<ConsistencyCheckCommandActorActor*>(this)->actor_wait_state = 3;
															#line 53 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbcli/ConsistencyCheckCommand.actor.cpp"
							__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ConsistencyCheckCommandActorActor, 2, Void >*>(static_cast<ConsistencyCheckCommandActorActor*>(this)));
															#line 137 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyCheckCommand.actor.g.cpp.py_gen"
							loopDepth = 0;
						}
						else
						{
							loopDepth = a_body1cont8(loopDepth);
						}
					}
					else
					{
															#line 55 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbcli/ConsistencyCheckCommand.actor.cpp"
						printUsage(tokens[0]);
															#line 56 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbcli/ConsistencyCheckCommand.actor.cpp"
						if (!static_cast<ConsistencyCheckCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ConsistencyCheckCommandActorActorState(); static_cast<ConsistencyCheckCommandActorActor*>(this)->destroy(); return 0; }
															#line 151 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyCheckCommand.actor.g.cpp.py_gen"
						new (&static_cast<ConsistencyCheckCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
						this->~ConsistencyCheckCommandActorActorState();
						static_cast<ConsistencyCheckCommandActorActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ConsistencyCheckCommandActorActorState();
		static_cast<ConsistencyCheckCommandActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 58 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbcli/ConsistencyCheckCommand.actor.cpp"
		if (!static_cast<ConsistencyCheckCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~ConsistencyCheckCommandActorActorState(); static_cast<ConsistencyCheckCommandActorActor*>(this)->destroy(); return 0; }
															#line 180 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyCheckCommand.actor.g.cpp.py_gen"
		new (&static_cast<ConsistencyCheckCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
		this->~ConsistencyCheckCommandActorActorState();
		static_cast<ConsistencyCheckCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Optional<Value> const& suspended,int loopDepth) 
	{
															#line 45 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbcli/ConsistencyCheckCommand.actor.cpp"
		printf("ConsistencyCheck is %s\n", suspended.present() ? "off" : "on");
															#line 192 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyCheckCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Optional<Value> && suspended,int loopDepth) 
	{
															#line 45 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbcli/ConsistencyCheckCommand.actor.cpp"
		printf("ConsistencyCheck is %s\n", suspended.present() ? "off" : "on");
															#line 201 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyCheckCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& suspended,int loopDepth) 
	{
		loopDepth = a_body1cont2(suspended, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && suspended,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(suspended), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ConsistencyCheckCommandActorActor*>(this)->actor_wait_state > 0) static_cast<ConsistencyCheckCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<ConsistencyCheckCommandActorActor*>(this)->ActorCallback< ConsistencyCheckCommandActorActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ConsistencyCheckCommandActorActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("consistencyCheckCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyCheckCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyCheckCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ConsistencyCheckCommandActorActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("consistencyCheckCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyCheckCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyCheckCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ConsistencyCheckCommandActorActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("consistencyCheckCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyCheckCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyCheckCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ConsistencyCheckCommandActorActor*>(this)->actor_wait_state > 0) static_cast<ConsistencyCheckCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<ConsistencyCheckCommandActorActor*>(this)->ActorCallback< ConsistencyCheckCommandActorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConsistencyCheckCommandActorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("consistencyCheckCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyCheckCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyCheckCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ConsistencyCheckCommandActorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("consistencyCheckCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyCheckCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyCheckCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ConsistencyCheckCommandActorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("consistencyCheckCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyCheckCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyCheckCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont7(int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont9(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont9(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ConsistencyCheckCommandActorActor*>(this)->actor_wait_state > 0) static_cast<ConsistencyCheckCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<ConsistencyCheckCommandActorActor*>(this)->ActorCallback< ConsistencyCheckCommandActorActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConsistencyCheckCommandActorActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("consistencyCheckCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyCheckCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyCheckCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ConsistencyCheckCommandActorActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("consistencyCheckCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyCheckCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyCheckCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ConsistencyCheckCommandActorActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("consistencyCheckCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyCheckCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyCheckCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 35 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbcli/ConsistencyCheckCommand.actor.cpp"
	Reference<ITransaction> tr;
															#line 35 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbcli/ConsistencyCheckCommand.actor.cpp"
	std::vector<StringRef> tokens;
															#line 35 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbcli/ConsistencyCheckCommand.actor.cpp"
	bool intrans;
															#line 43 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbcli/ConsistencyCheckCommand.actor.cpp"
	ThreadFuture<Optional<Value>> suspendedF;
															#line 487 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyCheckCommand.actor.g.cpp.py_gen"
};
// This generated class is to be used only via consistencyCheckCommandActor()
															#line 35 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbcli/ConsistencyCheckCommand.actor.cpp"
class ConsistencyCheckCommandActorActor final : public Actor<bool>, public ActorCallback< ConsistencyCheckCommandActorActor, 0, Optional<Value> >, public ActorCallback< ConsistencyCheckCommandActorActor, 1, Void >, public ActorCallback< ConsistencyCheckCommandActorActor, 2, Void >, public FastAllocated<ConsistencyCheckCommandActorActor>, public ConsistencyCheckCommandActorActorState<ConsistencyCheckCommandActorActor> {
															#line 492 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyCheckCommand.actor.g.cpp.py_gen"
public:
	using FastAllocated<ConsistencyCheckCommandActorActor>::operator new;
	using FastAllocated<ConsistencyCheckCommandActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18102400785897037824UL, 10363546846462153984UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ConsistencyCheckCommandActorActor, 0, Optional<Value> >;
friend struct ActorCallback< ConsistencyCheckCommandActorActor, 1, Void >;
friend struct ActorCallback< ConsistencyCheckCommandActorActor, 2, Void >;
															#line 35 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbcli/ConsistencyCheckCommand.actor.cpp"
	ConsistencyCheckCommandActorActor(Reference<ITransaction> const& tr,std::vector<StringRef> const& tokens,bool const& intrans) 
															#line 511 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyCheckCommand.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   ConsistencyCheckCommandActorActorState<ConsistencyCheckCommandActorActor>(tr, tokens, intrans),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("consistencyCheckCommandActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6514109577149345280UL, 9711389473712159744UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyCheckCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("consistencyCheckCommandActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("consistencyCheckCommandActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ConsistencyCheckCommandActorActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ConsistencyCheckCommandActorActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ConsistencyCheckCommandActorActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 35 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbcli/ConsistencyCheckCommand.actor.cpp"
[[nodiscard]] Future<bool> consistencyCheckCommandActor( Reference<ITransaction> const& tr, std::vector<StringRef> const& tokens, bool const& intrans ) {
															#line 35 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbcli/ConsistencyCheckCommand.actor.cpp"
	return Future<bool>(new ConsistencyCheckCommandActorActor(tr, tokens, intrans));
															#line 545 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyCheckCommand.actor.g.cpp.py_gen"
}

#line 60 "/codebuild/output/src3638569120/src/github.com/apple/foundationdb/fdbcli/ConsistencyCheckCommand.actor.cpp"

CommandFactory consistencyCheckFactory(
    "consistencycheck",
    CommandHelp(
        "consistencycheck [on|off]",
        "permits or prevents consistency checking",
        "Calling this command with `on' permits consistency check processes to run and `off' will halt their checking. "
        "Calling this command with no arguments will display if consistency checking is currently allowed.\n"));

} // namespace fdb_cli
