package com.apple.foundationdb;

/**
 * Conflict range types used internally by the C API.
 */
enum ConflictRangeType {
	/**
	 * Used to add a read conflict range.
	 */
	READ(0),

	/**
	 * Used to add a write conflict range.
	 */
	WRITE(1);
    private final int code;

    ConflictRangeType(int code) {
        this.code = code;
    }

    /**
     * Gets the FoundationDB native-level constant code for a {@code ConflictRangeType}.
     *
     * @return the native code for a FoundationDB {@code ConflictRangeType} constant.
     */
    public int code() {
        return this.code;
    }
}
