#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
/*
 * ValidateStorage.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/Audit.h"
#include "fdbclient/AuditUtils.actor.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/QuietDatabase.h"
#include "fdbrpc/simulator.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/Error.h"
#include "flow/IRandom.h"
#include "flow/flow.h"
#include <cstdint>
#include <limits>

#include "flow/actorcompiler.h" // This must be the last #include.

namespace {
std::string printValue(const ErrorOr<Optional<Value>>& value) {
	if (value.isError()) {
		return value.getError().name();
	}
	return value.get().present() ? value.get().get().toString() : "Value Not Found.";
}
} // namespace

std::vector<KeyRange> shuffleRanges(std::vector<KeyRange> inputRanges) {
	std::vector<KeyRange> outputRanges;
	while (!inputRanges.empty()) {
		int idx = deterministicRandom()->randomInt(0, inputRanges.size());
		outputRanges.push_back(inputRanges[idx]);
		inputRanges.erase(inputRanges.begin() + idx);
	}
	return outputRanges;
}

const KeyRangeRef partialKeys1 = KeyRangeRef(KeyRef(), "\x01"_sr);
const KeyRangeRef partialKeys2 = KeyRangeRef("\x01"_sr, "\x02"_sr);
const KeyRangeRef partialKeys3 = KeyRangeRef("\x02"_sr, "\x03"_sr);
const KeyRangeRef partialKeys4 = KeyRangeRef("\x03"_sr, "\xfe"_sr);
const KeyRangeRef partialKeys5 = KeyRangeRef("\xfe"_sr, "\xff"_sr);
const KeyRangeRef partialKeys6 = KeyRangeRef("\x05"_sr, "\xaa"_sr);
const KeyRangeRef partialKeys7 = KeyRangeRef(KeyRef(), KeyRef());
struct ValidateStorage : TestWorkload {
	static constexpr auto NAME = "ValidateStorageWorkload";

	FlowLock startMoveKeysParallelismLock;
	FlowLock finishMoveKeysParallelismLock;
	FlowLock cleanUpDataMoveParallelismLock;
	const bool enabled;
	bool pass;

	// We disable failure injection because there is an irrelevant issue:
	// Remote tLog is failed to rejoin to CC
	// Once this issue is fixed, we should be able to enable the failure injection
	// This workload is not compatible with following workload because they will race in changing the DD mode
	void disableFailureInjectionWorkloads(std::set<std::string>& out) const override {
		out.insert({ "RandomMoveKeys",
		             "DataLossRecovery",
		             "IDDTxnProcessorApiCorrectness",
		             "PerpetualWiggleStatsWorkload",
		             "PhysicalShardMove",
		             "StorageCorruption",
		             "StorageServerCheckpointRestoreTest",
		             "Attrition" });
	}

	void validationFailed(ErrorOr<Optional<Value>> expectedValue, ErrorOr<Optional<Value>> actualValue) {
		TraceEvent(SevError, "TestFailed")
		    .detail("ExpectedValue", printValue(expectedValue))
		    .detail("ActualValue", printValue(actualValue));
		pass = false;
	}

	ValidateStorage(WorkloadContext const& wcx) : TestWorkload(wcx), enabled(!clientId), pass(true) {}

	Future<Void> setup(Database const& cx) override { return Void(); }

	Future<Void> start(Database const& cx) override {
		if (!enabled) {
			return Void();
		}
		return _start(this, cx);
	}

																#line 107 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
// This generated class is to be used only via triggerAuditStorageForType()
															#line 105 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
template <class TriggerAuditStorageForTypeActor>
															#line 105 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
class TriggerAuditStorageForTypeActorState {
															#line 113 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
public:
															#line 105 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	TriggerAuditStorageForTypeActorState(Database const& cx,AuditType const& type,std::string const& context,KeyRange const& auditRange = allKeys) 
															#line 105 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
															#line 105 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		 : cx(cx),
															#line 105 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		   type(type),
															#line 105 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		   context(context),
															#line 105 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		   auditRange(auditRange),
															#line 110 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		   auditId()
															#line 128 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
	{
		fdb_probe_actor_create("triggerAuditStorageForType", reinterpret_cast<unsigned long>(this));

	}
	~TriggerAuditStorageForTypeActorState() 
	{
		fdb_probe_actor_destroy("triggerAuditStorageForType", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 111 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			std::vector<KeyValueStoreType> storageEngineCollection = { KeyValueStoreType::SSD_ROCKSDB_V1, KeyValueStoreType::SSD_SHARDED_ROCKSDB, KeyValueStoreType::SSD_BTREE_V2, KeyValueStoreType::END };
															#line 115 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			storageEngine = deterministicRandom()->randomChoice(storageEngineCollection);
															#line 116 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			;
															#line 147 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TriggerAuditStorageForTypeActorState();
		static_cast<TriggerAuditStorageForTypeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 144 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (!static_cast<TriggerAuditStorageForTypeActor*>(this)->SAV<UID>::futures) { (void)(auditId); this->~TriggerAuditStorageForTypeActorState(); static_cast<TriggerAuditStorageForTypeActor*>(this)->destroy(); return 0; }
															#line 170 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		new (&static_cast<TriggerAuditStorageForTypeActor*>(this)->SAV< UID >::value()) UID(std::move(auditId)); // state_var_RVO
		this->~TriggerAuditStorageForTypeActorState();
		static_cast<TriggerAuditStorageForTypeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 118 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			StrictFuture<UID> __when_expr_0 = auditStorage(cx->getConnectionRecord(), auditRange, type, storageEngine, 300);
															#line 118 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			if (static_cast<TriggerAuditStorageForTypeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 192 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TriggerAuditStorageForTypeActor*>(this)->actor_wait_state = 1;
															#line 118 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TriggerAuditStorageForTypeActor, 0, UID >*>(static_cast<TriggerAuditStorageForTypeActor*>(this)));
															#line 197 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 132 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			TraceEvent(SevWarn, "TestAuditStorageError") .errorUnsuppressed(e) .detail("Context", context) .detail("AuditType", type) .detail("AuditStorageEngine", storageEngine) .detail("AuditRange", auditRange);
															#line 138 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			if (auditRange.empty() && e.code() == error_code_audit_storage_failed)
															#line 234 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			{
				return a_body1break1(loopDepth==0?0:loopDepth-1); // break
			}
															#line 141 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(1);
															#line 141 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			if (static_cast<TriggerAuditStorageForTypeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 242 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TriggerAuditStorageForTypeActor*>(this)->actor_wait_state = 2;
															#line 141 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TriggerAuditStorageForTypeActor, 1, Void >*>(static_cast<TriggerAuditStorageForTypeActor*>(this)));
															#line 247 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(UID const& auditId_,int loopDepth) 
	{
															#line 123 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		auditId = auditId_;
															#line 124 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestAuditStorageTriggered") .detail("Context", context) .detail("AuditID", auditId) .detail("AuditType", type) .detail("AuditStorageEngine", storageEngine) .detail("AuditRange", auditRange);
															#line 264 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(UID && auditId_,int loopDepth) 
	{
															#line 123 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		auditId = auditId_;
															#line 124 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestAuditStorageTriggered") .detail("Context", context) .detail("AuditID", auditId) .detail("AuditType", type) .detail("AuditStorageEngine", storageEngine) .detail("AuditRange", auditRange);
															#line 275 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(UID const& auditId_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(auditId_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(UID && auditId_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(auditId_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TriggerAuditStorageForTypeActor*>(this)->actor_wait_state > 0) static_cast<TriggerAuditStorageForTypeActor*>(this)->actor_wait_state = 0;
		static_cast<TriggerAuditStorageForTypeActor*>(this)->ActorCallback< TriggerAuditStorageForTypeActor, 0, UID >::remove();

	}
	void a_callback_fire(ActorCallback< TriggerAuditStorageForTypeActor, 0, UID >*,UID const& value) 
	{
		fdb_probe_actor_enter("triggerAuditStorageForType", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerAuditStorageForTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerAuditStorageForType", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TriggerAuditStorageForTypeActor, 0, UID >*,UID && value) 
	{
		fdb_probe_actor_enter("triggerAuditStorageForType", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerAuditStorageForTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerAuditStorageForType", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TriggerAuditStorageForTypeActor, 0, UID >*,Error err) 
	{
		fdb_probe_actor_enter("triggerAuditStorageForType", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerAuditStorageForTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerAuditStorageForType", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TriggerAuditStorageForTypeActor*>(this)->actor_wait_state > 0) static_cast<TriggerAuditStorageForTypeActor*>(this)->actor_wait_state = 0;
		static_cast<TriggerAuditStorageForTypeActor*>(this)->ActorCallback< TriggerAuditStorageForTypeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TriggerAuditStorageForTypeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("triggerAuditStorageForType", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerAuditStorageForTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerAuditStorageForType", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TriggerAuditStorageForTypeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("triggerAuditStorageForType", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerAuditStorageForTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerAuditStorageForType", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TriggerAuditStorageForTypeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("triggerAuditStorageForType", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerAuditStorageForTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerAuditStorageForType", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 105 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	Database cx;
															#line 105 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	AuditType type;
															#line 105 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	std::string context;
															#line 105 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	KeyRange auditRange;
															#line 110 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	UID auditId;
															#line 115 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	KeyValueStoreType storageEngine;
															#line 454 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
};
// This generated class is to be used only via triggerAuditStorageForType()
															#line 105 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
class TriggerAuditStorageForTypeActor final : public Actor<UID>, public ActorCallback< TriggerAuditStorageForTypeActor, 0, UID >, public ActorCallback< TriggerAuditStorageForTypeActor, 1, Void >, public FastAllocated<TriggerAuditStorageForTypeActor>, public TriggerAuditStorageForTypeActorState<TriggerAuditStorageForTypeActor> {
															#line 459 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
public:
	using FastAllocated<TriggerAuditStorageForTypeActor>::operator new;
	using FastAllocated<TriggerAuditStorageForTypeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11115593315022737664UL, 16112684352289120512UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<UID>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TriggerAuditStorageForTypeActor, 0, UID >;
friend struct ActorCallback< TriggerAuditStorageForTypeActor, 1, Void >;
															#line 105 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	TriggerAuditStorageForTypeActor(Database const& cx,AuditType const& type,std::string const& context,KeyRange const& auditRange = allKeys) 
															#line 477 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		 : Actor<UID>(),
		   TriggerAuditStorageForTypeActorState<TriggerAuditStorageForTypeActor>(cx, type, context, auditRange),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("triggerAuditStorageForType", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7889894218762374912UL, 14253782893913577984UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerAuditStorageForTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("triggerAuditStorageForType");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("triggerAuditStorageForType", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TriggerAuditStorageForTypeActor, 0, UID >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TriggerAuditStorageForTypeActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 105 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
[[nodiscard]] Future<UID> triggerAuditStorageForType( Database const& cx, AuditType const& type, std::string const& context, KeyRange const& auditRange = allKeys ) {
															#line 105 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	return Future<UID>(new TriggerAuditStorageForTypeActor(cx, type, context, auditRange));
															#line 510 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
}

#line 146 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"

																#line 515 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
// This generated class is to be used only via waitAuditStorageUntilComplete()
															#line 147 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
template <class WaitAuditStorageUntilCompleteActor>
															#line 147 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
class WaitAuditStorageUntilCompleteActorState {
															#line 521 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
public:
															#line 147 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	WaitAuditStorageUntilCompleteActorState(Database const& cx,AuditType const& type,UID const& auditId,std::string const& context,bool const& stopWaitWhenCleared) 
															#line 147 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
															#line 147 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		 : cx(cx),
															#line 147 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		   type(type),
															#line 147 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		   auditId(auditId),
															#line 147 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		   context(context),
															#line 147 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		   stopWaitWhenCleared(stopWaitWhenCleared),
															#line 152 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		   auditState()
															#line 538 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
	{
		fdb_probe_actor_create("waitAuditStorageUntilComplete", reinterpret_cast<unsigned long>(this));

	}
	~WaitAuditStorageUntilCompleteActorState() 
	{
		fdb_probe_actor_destroy("waitAuditStorageUntilComplete", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 153 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			;
															#line 553 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitAuditStorageUntilCompleteActorState();
		static_cast<WaitAuditStorageUntilCompleteActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 186 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestAuditStorageEnd") .detail("Context", context) .detail("AuditID", auditId) .detail("AuditType", type) .detail("AuditState", auditState.toString());
															#line 191 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (!static_cast<WaitAuditStorageUntilCompleteActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitAuditStorageUntilCompleteActorState(); static_cast<WaitAuditStorageUntilCompleteActor*>(this)->destroy(); return 0; }
															#line 578 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		new (&static_cast<WaitAuditStorageUntilCompleteActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WaitAuditStorageUntilCompleteActorState();
		static_cast<WaitAuditStorageUntilCompleteActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 155 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			StrictFuture<AuditStorageState> __when_expr_0 = getAuditState(cx, type, auditId);
															#line 155 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			if (static_cast<WaitAuditStorageUntilCompleteActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 600 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WaitAuditStorageUntilCompleteActor*>(this)->actor_wait_state = 1;
															#line 155 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitAuditStorageUntilCompleteActor, 0, AuditStorageState >*>(static_cast<WaitAuditStorageUntilCompleteActor*>(this)));
															#line 605 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 174 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			if (stopWaitWhenCleared && e.code() == error_code_key_not_found)
															#line 640 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			{
				return a_body1break1(loopDepth==0?0:loopDepth-1); // break
			}
															#line 177 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			TraceEvent("TestAuditStorageWaitError") .errorUnsuppressed(e) .detail("Context", context) .detail("AuditID", auditId) .detail("AuditType", type) .detail("AuditState", auditState.toString());
															#line 183 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			StrictFuture<Void> __when_expr_2 = delay(1);
															#line 183 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			if (static_cast<WaitAuditStorageUntilCompleteActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 650 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<WaitAuditStorageUntilCompleteActor*>(this)->actor_wait_state = 3;
															#line 183 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WaitAuditStorageUntilCompleteActor, 2, Void >*>(static_cast<WaitAuditStorageUntilCompleteActor*>(this)));
															#line 655 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(AuditStorageState const& auditState_,int loopDepth) 
	{
															#line 156 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		auditState = auditState_;
															#line 157 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (auditState.getPhase() == AuditPhase::Complete)
															#line 672 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		else
		{
															#line 159 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			if (auditState.getPhase() == AuditPhase::Running)
															#line 680 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			{
															#line 160 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
				TraceEvent("TestAuditStorageWait") .detail("Context", context) .detail("AuditID", auditId) .detail("AuditType", type);
															#line 164 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
				StrictFuture<Void> __when_expr_1 = delay(30);
															#line 164 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
				if (static_cast<WaitAuditStorageUntilCompleteActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 688 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
				static_cast<WaitAuditStorageUntilCompleteActor*>(this)->actor_wait_state = 2;
															#line 164 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitAuditStorageUntilCompleteActor, 1, Void >*>(static_cast<WaitAuditStorageUntilCompleteActor*>(this)));
															#line 693 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 166 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
				if (auditState.getPhase() == AuditPhase::Error)
															#line 700 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
				{
					return a_body1break1(loopDepth==0?0:loopDepth-1); // break
				}
				else
				{
															#line 168 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
					if (auditState.getPhase() == AuditPhase::Failed)
															#line 708 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
					{
						return a_body1break1(loopDepth==0?0:loopDepth-1); // break
					}
					else
					{
															#line 171 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
						UNREACHABLE();
															#line 716 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
					}
				}
				loopDepth = a_body1loopBody1cont5(loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(AuditStorageState && auditState_,int loopDepth) 
	{
															#line 156 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		auditState = auditState_;
															#line 157 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (auditState.getPhase() == AuditPhase::Complete)
															#line 731 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		else
		{
															#line 159 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			if (auditState.getPhase() == AuditPhase::Running)
															#line 739 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			{
															#line 160 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
				TraceEvent("TestAuditStorageWait") .detail("Context", context) .detail("AuditID", auditId) .detail("AuditType", type);
															#line 164 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
				StrictFuture<Void> __when_expr_1 = delay(30);
															#line 164 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
				if (static_cast<WaitAuditStorageUntilCompleteActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 747 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
				static_cast<WaitAuditStorageUntilCompleteActor*>(this)->actor_wait_state = 2;
															#line 164 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitAuditStorageUntilCompleteActor, 1, Void >*>(static_cast<WaitAuditStorageUntilCompleteActor*>(this)));
															#line 752 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 166 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
				if (auditState.getPhase() == AuditPhase::Error)
															#line 759 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
				{
					return a_body1break1(loopDepth==0?0:loopDepth-1); // break
				}
				else
				{
															#line 168 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
					if (auditState.getPhase() == AuditPhase::Failed)
															#line 767 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
					{
						return a_body1break1(loopDepth==0?0:loopDepth-1); // break
					}
					else
					{
															#line 171 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
						UNREACHABLE();
															#line 775 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
					}
				}
				loopDepth = a_body1loopBody1cont5(loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(AuditStorageState const& auditState_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(auditState_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(AuditStorageState && auditState_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(auditState_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitAuditStorageUntilCompleteActor*>(this)->actor_wait_state > 0) static_cast<WaitAuditStorageUntilCompleteActor*>(this)->actor_wait_state = 0;
		static_cast<WaitAuditStorageUntilCompleteActor*>(this)->ActorCallback< WaitAuditStorageUntilCompleteActor, 0, AuditStorageState >::remove();

	}
	void a_callback_fire(ActorCallback< WaitAuditStorageUntilCompleteActor, 0, AuditStorageState >*,AuditStorageState const& value) 
	{
		fdb_probe_actor_enter("waitAuditStorageUntilComplete", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAuditStorageUntilCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAuditStorageUntilComplete", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitAuditStorageUntilCompleteActor, 0, AuditStorageState >*,AuditStorageState && value) 
	{
		fdb_probe_actor_enter("waitAuditStorageUntilComplete", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAuditStorageUntilCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAuditStorageUntilComplete", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitAuditStorageUntilCompleteActor, 0, AuditStorageState >*,Error err) 
	{
		fdb_probe_actor_enter("waitAuditStorageUntilComplete", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAuditStorageUntilCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAuditStorageUntilComplete", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont13(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WaitAuditStorageUntilCompleteActor*>(this)->actor_wait_state > 0) static_cast<WaitAuditStorageUntilCompleteActor*>(this)->actor_wait_state = 0;
		static_cast<WaitAuditStorageUntilCompleteActor*>(this)->ActorCallback< WaitAuditStorageUntilCompleteActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitAuditStorageUntilCompleteActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitAuditStorageUntilComplete", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAuditStorageUntilCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAuditStorageUntilComplete", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WaitAuditStorageUntilCompleteActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitAuditStorageUntilComplete", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAuditStorageUntilCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAuditStorageUntilComplete", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WaitAuditStorageUntilCompleteActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitAuditStorageUntilComplete", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAuditStorageUntilCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAuditStorageUntilComplete", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont13(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WaitAuditStorageUntilCompleteActor*>(this)->actor_wait_state > 0) static_cast<WaitAuditStorageUntilCompleteActor*>(this)->actor_wait_state = 0;
		static_cast<WaitAuditStorageUntilCompleteActor*>(this)->ActorCallback< WaitAuditStorageUntilCompleteActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitAuditStorageUntilCompleteActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitAuditStorageUntilComplete", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAuditStorageUntilCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAuditStorageUntilComplete", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WaitAuditStorageUntilCompleteActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitAuditStorageUntilComplete", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAuditStorageUntilCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAuditStorageUntilComplete", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WaitAuditStorageUntilCompleteActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitAuditStorageUntilComplete", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAuditStorageUntilCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAuditStorageUntilComplete", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 147 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	Database cx;
															#line 147 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	AuditType type;
															#line 147 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	UID auditId;
															#line 147 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	std::string context;
															#line 147 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	bool stopWaitWhenCleared;
															#line 152 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	AuditStorageState auditState;
															#line 1070 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
};
// This generated class is to be used only via waitAuditStorageUntilComplete()
															#line 147 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
class WaitAuditStorageUntilCompleteActor final : public Actor<Void>, public ActorCallback< WaitAuditStorageUntilCompleteActor, 0, AuditStorageState >, public ActorCallback< WaitAuditStorageUntilCompleteActor, 1, Void >, public ActorCallback< WaitAuditStorageUntilCompleteActor, 2, Void >, public FastAllocated<WaitAuditStorageUntilCompleteActor>, public WaitAuditStorageUntilCompleteActorState<WaitAuditStorageUntilCompleteActor> {
															#line 1075 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
public:
	using FastAllocated<WaitAuditStorageUntilCompleteActor>::operator new;
	using FastAllocated<WaitAuditStorageUntilCompleteActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16573007262361805824UL, 9830989341074064384UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitAuditStorageUntilCompleteActor, 0, AuditStorageState >;
friend struct ActorCallback< WaitAuditStorageUntilCompleteActor, 1, Void >;
friend struct ActorCallback< WaitAuditStorageUntilCompleteActor, 2, Void >;
															#line 147 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	WaitAuditStorageUntilCompleteActor(Database const& cx,AuditType const& type,UID const& auditId,std::string const& context,bool const& stopWaitWhenCleared) 
															#line 1094 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		 : Actor<Void>(),
		   WaitAuditStorageUntilCompleteActorState<WaitAuditStorageUntilCompleteActor>(cx, type, auditId, context, stopWaitWhenCleared),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitAuditStorageUntilComplete", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7584465835375590400UL, 4792052876802147328UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAuditStorageUntilCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitAuditStorageUntilComplete");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitAuditStorageUntilComplete", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitAuditStorageUntilCompleteActor, 0, AuditStorageState >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WaitAuditStorageUntilCompleteActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WaitAuditStorageUntilCompleteActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 147 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
[[nodiscard]] Future<Void> waitAuditStorageUntilComplete( Database const& cx, AuditType const& type, UID const& auditId, std::string const& context, bool const& stopWaitWhenCleared ) {
															#line 147 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	return Future<Void>(new WaitAuditStorageUntilCompleteActor(cx, type, auditId, context, stopWaitWhenCleared));
															#line 1128 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
}

#line 193 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"

																#line 1133 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
// This generated class is to be used only via checkAuditStorageInternalState()
															#line 194 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
template <class CheckAuditStorageInternalStateActor>
															#line 194 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
class CheckAuditStorageInternalStateActorState {
															#line 1139 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
public:
															#line 194 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	CheckAuditStorageInternalStateActorState(Database const& cx,AuditType const& type,UID const& auditId,std::string const& context) 
															#line 194 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
															#line 194 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		 : cx(cx),
															#line 194 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		   type(type),
															#line 194 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		   auditId(auditId),
															#line 194 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		   context(context),
															#line 196 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		   tr(cx)
															#line 1154 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
	{
		fdb_probe_actor_create("checkAuditStorageInternalState", reinterpret_cast<unsigned long>(this));

	}
	~CheckAuditStorageInternalStateActorState() 
	{
		fdb_probe_actor_destroy("checkAuditStorageInternalState", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 197 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			;
															#line 1169 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckAuditStorageInternalStateActorState();
		static_cast<CheckAuditStorageInternalStateActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 251 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (!static_cast<CheckAuditStorageInternalStateActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckAuditStorageInternalStateActorState(); static_cast<CheckAuditStorageInternalStateActor*>(this)->destroy(); return 0; }
															#line 1192 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		new (&static_cast<CheckAuditStorageInternalStateActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckAuditStorageInternalStateActorState();
		static_cast<CheckAuditStorageInternalStateActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 199 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 200 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 201 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(auditKeyRange(type), GetRangeLimits());
															#line 201 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			if (static_cast<CheckAuditStorageInternalStateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1218 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckAuditStorageInternalStateActor*>(this)->actor_wait_state = 1;
															#line 201 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckAuditStorageInternalStateActor, 0, RangeResult >*>(static_cast<CheckAuditStorageInternalStateActor*>(this)));
															#line 1223 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 243 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			TraceEvent("TestAuditStorageCheckPersistStateError") .errorUnsuppressed(e) .detail("Context", context) .detail("AuditID", auditId) .detail("AuditType", type);
															#line 248 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			StrictFuture<Void> __when_expr_4 = tr.onError(e);
															#line 248 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			if (static_cast<CheckAuditStorageInternalStateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1262 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<CheckAuditStorageInternalStateActor*>(this)->actor_wait_state = 5;
															#line 248 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CheckAuditStorageInternalStateActor, 4, Void >*>(static_cast<CheckAuditStorageInternalStateActor*>(this)));
															#line 1267 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 202 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		ASSERT(!res.more);
															#line 203 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		i = 0;
															#line 204 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		;
															#line 1286 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& __res,int loopDepth) 
	{
															#line 201 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		res = __res;
															#line 1295 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && __res,int loopDepth) 
	{
		res = std::move(__res);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckAuditStorageInternalStateActor*>(this)->actor_wait_state > 0) static_cast<CheckAuditStorageInternalStateActor*>(this)->actor_wait_state = 0;
		static_cast<CheckAuditStorageInternalStateActor*>(this)->ActorCallback< CheckAuditStorageInternalStateActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CheckAuditStorageInternalStateActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("checkAuditStorageInternalState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAuditStorageInternalStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAuditStorageInternalState", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckAuditStorageInternalStateActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("checkAuditStorageInternalState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAuditStorageInternalStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAuditStorageInternalState", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckAuditStorageInternalStateActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("checkAuditStorageInternalState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAuditStorageInternalStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAuditStorageInternalState", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 227 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (res.size() > SERVER_KNOBS->PERSIST_FINISH_AUDIT_COUNT + 5)
															#line 1374 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		{
															#line 232 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			TraceEvent("TestAuditStorageCheckPersistStateWaitClean") .detail("ExistCount", res.size()) .detail("Context", context) .detail("AuditID", auditId) .detail("AuditType", type);
															#line 237 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			StrictFuture<Void> __when_expr_3 = delay(30);
															#line 237 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			if (static_cast<CheckAuditStorageInternalStateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1382 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
			static_cast<CheckAuditStorageInternalStateActor*>(this)->actor_wait_state = 4;
															#line 237 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CheckAuditStorageInternalStateActor, 3, Void >*>(static_cast<CheckAuditStorageInternalStateActor*>(this)));
															#line 1387 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1(int loopDepth) 
	{
															#line 204 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (!(i < res.size()))
															#line 1408 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		{
			return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 205 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		AuditStorageState existingAuditState = decodeAuditStorageState(res[i].value);
															#line 206 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestAuditStorageCheckPersistStateExists") .detail("Context", context) .detail("ExistAuditID", existingAuditState.id) .detail("ExistAuditPhase", existingAuditState.getPhase()) .detail("AuditID", auditId) .detail("AuditType", type);
															#line 212 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		ASSERT(existingAuditState.getPhase() == AuditPhase::Complete || existingAuditState.getPhase() == AuditPhase::Failed || existingAuditState.getPhase() == AuditPhase::Running);
															#line 215 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (existingAuditState.getPhase() == AuditPhase::Complete)
															#line 1420 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		{
															#line 216 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			if (type == AuditType::ValidateStorageServerShard)
															#line 1424 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			{
															#line 217 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
				StrictFuture<RangeResult> __when_expr_1 = tr.getRange( auditServerBasedProgressRangeFor(type, existingAuditState.id), GetRangeLimits());
															#line 217 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
				if (static_cast<CheckAuditStorageInternalStateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1430 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
				static_cast<CheckAuditStorageInternalStateActor*>(this)->actor_wait_state = 2;
															#line 217 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckAuditStorageInternalStateActor, 1, RangeResult >*>(static_cast<CheckAuditStorageInternalStateActor*>(this)));
															#line 1435 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 221 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
				StrictFuture<RangeResult> __when_expr_2 = tr.getRange( auditRangeBasedProgressRangeFor(type, existingAuditState.id), GetRangeLimits());
															#line 221 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
				if (static_cast<CheckAuditStorageInternalStateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1444 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1when2(__when_expr_2.get(), loopDepth); };
				static_cast<CheckAuditStorageInternalStateActor*>(this)->actor_wait_state = 3;
															#line 221 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CheckAuditStorageInternalStateActor, 2, RangeResult >*>(static_cast<CheckAuditStorageInternalStateActor*>(this)));
															#line 1449 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
				loopDepth = 0;
			}
		}
		else
		{
			loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(int loopDepth) 
	{
															#line 204 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		++i;
															#line 1477 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont4(RangeResult const& serverBasedRes,int loopDepth) 
	{
															#line 219 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		ASSERT(serverBasedRes.empty() && !serverBasedRes.more);
															#line 1492 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont4(RangeResult && serverBasedRes,int loopDepth) 
	{
															#line 219 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		ASSERT(serverBasedRes.empty() && !serverBasedRes.more);
															#line 1501 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(RangeResult const& serverBasedRes,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont4(serverBasedRes, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(RangeResult && serverBasedRes,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont4(std::move(serverBasedRes), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckAuditStorageInternalStateActor*>(this)->actor_wait_state > 0) static_cast<CheckAuditStorageInternalStateActor*>(this)->actor_wait_state = 0;
		static_cast<CheckAuditStorageInternalStateActor*>(this)->ActorCallback< CheckAuditStorageInternalStateActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CheckAuditStorageInternalStateActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("checkAuditStorageInternalState", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAuditStorageInternalStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAuditStorageInternalState", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckAuditStorageInternalStateActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("checkAuditStorageInternalState", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAuditStorageInternalStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAuditStorageInternalState", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckAuditStorageInternalStateActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("checkAuditStorageInternalState", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAuditStorageInternalStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAuditStorageInternalState", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont2loopBody1cont6(RangeResult const& rangeBasedRes,int loopDepth) 
	{
															#line 223 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		ASSERT(rangeBasedRes.empty() && !rangeBasedRes.more);
															#line 1585 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont6(RangeResult && rangeBasedRes,int loopDepth) 
	{
															#line 223 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		ASSERT(rangeBasedRes.empty() && !rangeBasedRes.more);
															#line 1594 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when2(RangeResult const& rangeBasedRes,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont6(rangeBasedRes, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when2(RangeResult && rangeBasedRes,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont6(std::move(rangeBasedRes), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CheckAuditStorageInternalStateActor*>(this)->actor_wait_state > 0) static_cast<CheckAuditStorageInternalStateActor*>(this)->actor_wait_state = 0;
		static_cast<CheckAuditStorageInternalStateActor*>(this)->ActorCallback< CheckAuditStorageInternalStateActor, 2, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CheckAuditStorageInternalStateActor, 2, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("checkAuditStorageInternalState", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAuditStorageInternalStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAuditStorageInternalState", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CheckAuditStorageInternalStateActor, 2, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("checkAuditStorageInternalState", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAuditStorageInternalStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAuditStorageInternalState", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CheckAuditStorageInternalStateActor, 2, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("checkAuditStorageInternalState", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAuditStorageInternalStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAuditStorageInternalState", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 238 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		tr.reset();
															#line 1684 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 238 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		tr.reset();
															#line 1693 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CheckAuditStorageInternalStateActor*>(this)->actor_wait_state > 0) static_cast<CheckAuditStorageInternalStateActor*>(this)->actor_wait_state = 0;
		static_cast<CheckAuditStorageInternalStateActor*>(this)->ActorCallback< CheckAuditStorageInternalStateActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckAuditStorageInternalStateActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkAuditStorageInternalState", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAuditStorageInternalStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAuditStorageInternalState", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CheckAuditStorageInternalStateActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkAuditStorageInternalState", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAuditStorageInternalStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAuditStorageInternalState", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CheckAuditStorageInternalStateActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkAuditStorageInternalState", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAuditStorageInternalStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAuditStorageInternalState", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<CheckAuditStorageInternalStateActor*>(this)->actor_wait_state > 0) static_cast<CheckAuditStorageInternalStateActor*>(this)->actor_wait_state = 0;
		static_cast<CheckAuditStorageInternalStateActor*>(this)->ActorCallback< CheckAuditStorageInternalStateActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckAuditStorageInternalStateActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkAuditStorageInternalState", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAuditStorageInternalStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAuditStorageInternalState", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< CheckAuditStorageInternalStateActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkAuditStorageInternalState", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAuditStorageInternalStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAuditStorageInternalState", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< CheckAuditStorageInternalStateActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkAuditStorageInternalState", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAuditStorageInternalStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAuditStorageInternalState", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 194 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	Database cx;
															#line 194 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	AuditType type;
															#line 194 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	UID auditId;
															#line 194 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	std::string context;
															#line 196 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	Transaction tr;
															#line 201 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	RangeResult res;
															#line 203 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	int i;
															#line 1874 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
};
// This generated class is to be used only via checkAuditStorageInternalState()
															#line 194 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
class CheckAuditStorageInternalStateActor final : public Actor<Void>, public ActorCallback< CheckAuditStorageInternalStateActor, 0, RangeResult >, public ActorCallback< CheckAuditStorageInternalStateActor, 1, RangeResult >, public ActorCallback< CheckAuditStorageInternalStateActor, 2, RangeResult >, public ActorCallback< CheckAuditStorageInternalStateActor, 3, Void >, public ActorCallback< CheckAuditStorageInternalStateActor, 4, Void >, public FastAllocated<CheckAuditStorageInternalStateActor>, public CheckAuditStorageInternalStateActorState<CheckAuditStorageInternalStateActor> {
															#line 1879 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
public:
	using FastAllocated<CheckAuditStorageInternalStateActor>::operator new;
	using FastAllocated<CheckAuditStorageInternalStateActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13960189558036696576UL, 7368103815639279104UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckAuditStorageInternalStateActor, 0, RangeResult >;
friend struct ActorCallback< CheckAuditStorageInternalStateActor, 1, RangeResult >;
friend struct ActorCallback< CheckAuditStorageInternalStateActor, 2, RangeResult >;
friend struct ActorCallback< CheckAuditStorageInternalStateActor, 3, Void >;
friend struct ActorCallback< CheckAuditStorageInternalStateActor, 4, Void >;
															#line 194 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	CheckAuditStorageInternalStateActor(Database const& cx,AuditType const& type,UID const& auditId,std::string const& context) 
															#line 1900 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		 : Actor<Void>(),
		   CheckAuditStorageInternalStateActorState<CheckAuditStorageInternalStateActor>(cx, type, auditId, context),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkAuditStorageInternalState", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16417465410034412544UL, 6667139408760606464UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAuditStorageInternalStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkAuditStorageInternalState");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkAuditStorageInternalState", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckAuditStorageInternalStateActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckAuditStorageInternalStateActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CheckAuditStorageInternalStateActor, 2, RangeResult >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CheckAuditStorageInternalStateActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< CheckAuditStorageInternalStateActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 194 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
[[nodiscard]] Future<Void> checkAuditStorageInternalState( Database const& cx, AuditType const& type, UID const& auditId, std::string const& context ) {
															#line 194 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	return Future<Void>(new CheckAuditStorageInternalStateActor(cx, type, auditId, context));
															#line 1936 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
}

#line 253 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"

																#line 1941 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
// This generated class is to be used only via waitCancelAuditStorageUntilComplete()
															#line 254 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
template <class WaitCancelAuditStorageUntilCompleteActor>
															#line 254 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
class WaitCancelAuditStorageUntilCompleteActorState {
															#line 1947 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
public:
															#line 254 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	WaitCancelAuditStorageUntilCompleteActorState(Database const& cx,AuditType const& type,UID const& auditId) 
															#line 254 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
															#line 254 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		 : cx(cx),
															#line 254 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		   type(type),
															#line 254 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		   auditId(auditId)
															#line 1958 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
	{
		fdb_probe_actor_create("waitCancelAuditStorageUntilComplete", reinterpret_cast<unsigned long>(this));

	}
	~WaitCancelAuditStorageUntilCompleteActorState() 
	{
		fdb_probe_actor_destroy("waitCancelAuditStorageUntilComplete", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 255 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			;
															#line 1973 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitCancelAuditStorageUntilCompleteActorState();
		static_cast<WaitCancelAuditStorageUntilCompleteActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 274 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (!static_cast<WaitCancelAuditStorageUntilCompleteActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitCancelAuditStorageUntilCompleteActorState(); static_cast<WaitCancelAuditStorageUntilCompleteActor*>(this)->destroy(); return 0; }
															#line 1996 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		new (&static_cast<WaitCancelAuditStorageUntilCompleteActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WaitCancelAuditStorageUntilCompleteActorState();
		static_cast<WaitCancelAuditStorageUntilCompleteActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 257 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			StrictFuture<UID> __when_expr_0 = cancelAuditStorage(cx->getConnectionRecord(), type, auditId, 300);
															#line 257 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			if (static_cast<WaitCancelAuditStorageUntilCompleteActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2018 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WaitCancelAuditStorageUntilCompleteActor*>(this)->actor_wait_state = 1;
															#line 257 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitCancelAuditStorageUntilCompleteActor, 0, UID >*>(static_cast<WaitCancelAuditStorageUntilCompleteActor*>(this)));
															#line 2023 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 267 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			TraceEvent(SevWarn, "TestAuditStorageWaitCancelAuditStorageUntilCompleteError") .errorUnsuppressed(e) .detail("AuditID", auditId) .detail("AuditType", type);
															#line 271 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(1);
															#line 271 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			if (static_cast<WaitCancelAuditStorageUntilCompleteActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2062 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<WaitCancelAuditStorageUntilCompleteActor*>(this)->actor_wait_state = 2;
															#line 271 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitCancelAuditStorageUntilCompleteActor, 1, Void >*>(static_cast<WaitCancelAuditStorageUntilCompleteActor*>(this)));
															#line 2067 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 261 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		ASSERT(auditId == auditId_);
															#line 262 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestAuditStorageWaitCancelAuditStorageUntilComplete") .detail("AuditID", auditId) .detail("AuditType", type);
															#line 2084 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(UID const& __auditId_,int loopDepth) 
	{
															#line 257 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		auditId_ = __auditId_;
															#line 2093 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(UID && __auditId_,int loopDepth) 
	{
		auditId_ = std::move(__auditId_);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitCancelAuditStorageUntilCompleteActor*>(this)->actor_wait_state > 0) static_cast<WaitCancelAuditStorageUntilCompleteActor*>(this)->actor_wait_state = 0;
		static_cast<WaitCancelAuditStorageUntilCompleteActor*>(this)->ActorCallback< WaitCancelAuditStorageUntilCompleteActor, 0, UID >::remove();

	}
	void a_callback_fire(ActorCallback< WaitCancelAuditStorageUntilCompleteActor, 0, UID >*,UID const& value) 
	{
		fdb_probe_actor_enter("waitCancelAuditStorageUntilComplete", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitCancelAuditStorageUntilCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitCancelAuditStorageUntilComplete", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitCancelAuditStorageUntilCompleteActor, 0, UID >*,UID && value) 
	{
		fdb_probe_actor_enter("waitCancelAuditStorageUntilComplete", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitCancelAuditStorageUntilCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitCancelAuditStorageUntilComplete", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitCancelAuditStorageUntilCompleteActor, 0, UID >*,Error err) 
	{
		fdb_probe_actor_enter("waitCancelAuditStorageUntilComplete", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitCancelAuditStorageUntilCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitCancelAuditStorageUntilComplete", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WaitCancelAuditStorageUntilCompleteActor*>(this)->actor_wait_state > 0) static_cast<WaitCancelAuditStorageUntilCompleteActor*>(this)->actor_wait_state = 0;
		static_cast<WaitCancelAuditStorageUntilCompleteActor*>(this)->ActorCallback< WaitCancelAuditStorageUntilCompleteActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitCancelAuditStorageUntilCompleteActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitCancelAuditStorageUntilComplete", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitCancelAuditStorageUntilCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitCancelAuditStorageUntilComplete", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WaitCancelAuditStorageUntilCompleteActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitCancelAuditStorageUntilComplete", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitCancelAuditStorageUntilCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitCancelAuditStorageUntilComplete", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WaitCancelAuditStorageUntilCompleteActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitCancelAuditStorageUntilComplete", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitCancelAuditStorageUntilCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitCancelAuditStorageUntilComplete", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 254 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	Database cx;
															#line 254 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	AuditType type;
															#line 254 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	UID auditId;
															#line 257 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	UID auditId_;
															#line 2263 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
};
// This generated class is to be used only via waitCancelAuditStorageUntilComplete()
															#line 254 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
class WaitCancelAuditStorageUntilCompleteActor final : public Actor<Void>, public ActorCallback< WaitCancelAuditStorageUntilCompleteActor, 0, UID >, public ActorCallback< WaitCancelAuditStorageUntilCompleteActor, 1, Void >, public FastAllocated<WaitCancelAuditStorageUntilCompleteActor>, public WaitCancelAuditStorageUntilCompleteActorState<WaitCancelAuditStorageUntilCompleteActor> {
															#line 2268 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
public:
	using FastAllocated<WaitCancelAuditStorageUntilCompleteActor>::operator new;
	using FastAllocated<WaitCancelAuditStorageUntilCompleteActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10058798183042662144UL, 1261534974133060352UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitCancelAuditStorageUntilCompleteActor, 0, UID >;
friend struct ActorCallback< WaitCancelAuditStorageUntilCompleteActor, 1, Void >;
															#line 254 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	WaitCancelAuditStorageUntilCompleteActor(Database const& cx,AuditType const& type,UID const& auditId) 
															#line 2286 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		 : Actor<Void>(),
		   WaitCancelAuditStorageUntilCompleteActorState<WaitCancelAuditStorageUntilCompleteActor>(cx, type, auditId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitCancelAuditStorageUntilComplete", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12280580684639026688UL, 15578761424616228864UL);
		ActorExecutionContextHelper __helper(static_cast<WaitCancelAuditStorageUntilCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitCancelAuditStorageUntilComplete");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitCancelAuditStorageUntilComplete", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitCancelAuditStorageUntilCompleteActor, 0, UID >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WaitCancelAuditStorageUntilCompleteActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 254 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
[[nodiscard]] Future<Void> waitCancelAuditStorageUntilComplete( Database const& cx, AuditType const& type, UID const& auditId ) {
															#line 254 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	return Future<Void>(new WaitCancelAuditStorageUntilCompleteActor(cx, type, auditId));
															#line 2319 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
}

#line 276 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"

																#line 2324 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 277 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
template <class _startActor>
															#line 277 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
class _startActorState {
															#line 2330 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
public:
															#line 277 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	_startActorState(ValidateStorage* const& self,Database const& cx) 
															#line 277 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
															#line 277 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		 : self(self),
															#line 277 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		   cx(cx)
															#line 2339 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 278 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			TraceEvent("ValidateStorageTestBegin");
															#line 279 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			kvs = std::map<Key, Value>({ { "TestKeyA"_sr, "TestValueA"_sr }, { "TestKeyB"_sr, "TestValueB"_sr }, { "TestKeyC"_sr, "TestValueC"_sr }, { "TestKeyD"_sr, "TestValueD"_sr }, { "TestKeyE"_sr, "TestValueE"_sr }, { "TestKeyF"_sr, "TestValueF"_sr } });
															#line 286 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			StrictFuture<Version> __when_expr_0 = self->populateData(self, cx, &kvs);
															#line 286 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2360 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 286 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Version >*>(static_cast<_startActor*>(this)));
															#line 2365 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Version const& ver,int loopDepth) 
	{
															#line 288 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestValueWritten").detail("AtVersion", ver);
															#line 290 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (g_network->isSimulated())
															#line 2390 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		{
															#line 292 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			disableConnectionFailures("AuditStorage");
															#line 2394 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		}
															#line 295 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		self->testStringToAuditPhaseFunctionality();
															#line 296 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestAuditStorageStringToAuditPhaseFuncionalityDone");
															#line 298 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->testSSUserDataValidation(self, cx, KeyRangeRef("TestKeyA"_sr, "TestKeyF"_sr));
															#line 298 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2404 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 298 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 2409 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Version && ver,int loopDepth) 
	{
															#line 288 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestValueWritten").detail("AtVersion", ver);
															#line 290 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (g_network->isSimulated())
															#line 2420 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		{
															#line 292 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			disableConnectionFailures("AuditStorage");
															#line 2424 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		}
															#line 295 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		self->testStringToAuditPhaseFunctionality();
															#line 296 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestAuditStorageStringToAuditPhaseFuncionalityDone");
															#line 298 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->testSSUserDataValidation(self, cx, KeyRangeRef("TestKeyA"_sr, "TestKeyF"_sr));
															#line 298 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2434 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 298 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 2439 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Version const& ver,int loopDepth) 
	{
		loopDepth = a_body1cont1(ver, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Version && ver,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(ver), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 299 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestAuditStorageValidateValueDone");
															#line 301 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->testAuditStorageFunctionality(self, cx);
															#line 301 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2527 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 301 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 2532 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 299 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestAuditStorageValidateValueDone");
															#line 301 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->testAuditStorageFunctionality(self, cx);
															#line 301 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2545 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 301 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 2550 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 302 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestAuditStorageFunctionalityDone");
															#line 304 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->testAuditStorageIDGenerator(self, cx);
															#line 304 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2638 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 304 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 2643 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 302 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestAuditStorageFunctionalityDone");
															#line 304 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->testAuditStorageIDGenerator(self, cx);
															#line 304 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2656 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 304 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 2661 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 305 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestAuditStorageIDGeneratorDone");
															#line 307 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<Void> __when_expr_4 = self->testAuditStorageConcurrentRunForDifferentType(self, cx);
															#line 307 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2749 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 307 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 2754 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 305 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestAuditStorageIDGeneratorDone");
															#line 307 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<Void> __when_expr_4 = self->testAuditStorageConcurrentRunForDifferentType(self, cx);
															#line 307 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2767 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 307 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 2772 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 308 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestAuditStorageConcurrentRunForDifferentTypeDone");
															#line 310 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<Void> __when_expr_5 = self->testAuditStorageConcurrentRunForSameType(self, cx);
															#line 310 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2860 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 310 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Void >*>(static_cast<_startActor*>(this)));
															#line 2865 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 308 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestAuditStorageConcurrentRunForDifferentTypeDone");
															#line 310 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<Void> __when_expr_5 = self->testAuditStorageConcurrentRunForSameType(self, cx);
															#line 310 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2878 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 310 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Void >*>(static_cast<_startActor*>(this)));
															#line 2883 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _startActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
															#line 311 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestAuditStorageConcurrentRunForSameTypeDone");
															#line 313 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<Void> __when_expr_6 = self->testAuditStorageCancellation(self, cx);
															#line 313 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2971 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont7when1(__when_expr_6.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 313 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, Void >*>(static_cast<_startActor*>(this)));
															#line 2976 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
															#line 311 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestAuditStorageConcurrentRunForSameTypeDone");
															#line 313 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<Void> __when_expr_6 = self->testAuditStorageCancellation(self, cx);
															#line 313 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2989 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont7when1(__when_expr_6.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 313 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, Void >*>(static_cast<_startActor*>(this)));
															#line 2994 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _startActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
															#line 314 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestAuditStorageCancellationDone");
															#line 316 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<Void> __when_expr_7 = self->testAuditStorageProgress(self, cx);
															#line 316 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3082 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont8when1(__when_expr_7.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 8;
															#line 316 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _startActor, 7, Void >*>(static_cast<_startActor*>(this)));
															#line 3087 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
															#line 314 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestAuditStorageCancellationDone");
															#line 316 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<Void> __when_expr_7 = self->testAuditStorageProgress(self, cx);
															#line 316 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3100 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont8when1(__when_expr_7.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 8;
															#line 316 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _startActor, 7, Void >*>(static_cast<_startActor*>(this)));
															#line 3105 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< _startActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont9(Void const& _,int loopDepth) 
	{
															#line 317 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestAuditStorageProgressDone");
															#line 319 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<Void> __when_expr_8 = self->testAuditStorageWhenDDSecurityMode(self, cx);
															#line 319 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3193 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont9when1(__when_expr_8.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 9;
															#line 319 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< _startActor, 8, Void >*>(static_cast<_startActor*>(this)));
															#line 3198 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9(Void && _,int loopDepth) 
	{
															#line 317 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestAuditStorageProgressDone");
															#line 319 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<Void> __when_expr_8 = self->testAuditStorageWhenDDSecurityMode(self, cx);
															#line 319 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3211 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont9when1(__when_expr_8.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 9;
															#line 319 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< _startActor, 8, Void >*>(static_cast<_startActor*>(this)));
															#line 3216 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< _startActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< _startActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont10(Void const& _,int loopDepth) 
	{
															#line 320 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestAuditStorageWhenDDSecurityModeDone");
															#line 322 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<Void> __when_expr_9 = self->testAuditStorageWhenDDBackToNormalMode(self, cx);
															#line 322 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3304 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont10when1(__when_expr_9.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 10;
															#line 322 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< _startActor, 9, Void >*>(static_cast<_startActor*>(this)));
															#line 3309 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10(Void && _,int loopDepth) 
	{
															#line 320 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestAuditStorageWhenDDSecurityModeDone");
															#line 322 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<Void> __when_expr_9 = self->testAuditStorageWhenDDBackToNormalMode(self, cx);
															#line 322 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3322 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont10when1(__when_expr_9.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 10;
															#line 322 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< _startActor, 9, Void >*>(static_cast<_startActor*>(this)));
															#line 3327 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< _startActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< _startActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont10cont1(Void const& _,int loopDepth) 
	{
															#line 323 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestAuditStorageWhenDDBackToNormalModeDone");
															#line 325 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 3413 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10cont1(Void && _,int loopDepth) 
	{
															#line 323 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestAuditStorageWhenDDBackToNormalModeDone");
															#line 325 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 3427 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< _startActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< _startActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
															#line 277 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	ValidateStorage* self;
															#line 277 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	Database cx;
															#line 279 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	std::map<Key, Value> kvs;
															#line 3516 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 277 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Version >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, Void >, public ActorCallback< _startActor, 3, Void >, public ActorCallback< _startActor, 4, Void >, public ActorCallback< _startActor, 5, Void >, public ActorCallback< _startActor, 6, Void >, public ActorCallback< _startActor, 7, Void >, public ActorCallback< _startActor, 8, Void >, public ActorCallback< _startActor, 9, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 3521 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3521933354546864640UL, 263052343017721088UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Version >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, Void >;
friend struct ActorCallback< _startActor, 3, Void >;
friend struct ActorCallback< _startActor, 4, Void >;
friend struct ActorCallback< _startActor, 5, Void >;
friend struct ActorCallback< _startActor, 6, Void >;
friend struct ActorCallback< _startActor, 7, Void >;
friend struct ActorCallback< _startActor, 8, Void >;
friend struct ActorCallback< _startActor, 9, Void >;
															#line 277 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	_startActor(ValidateStorage* const& self,Database const& cx) 
															#line 3547 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _startActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _startActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< _startActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< _startActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< _startActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< _startActor, 9, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 277 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
[[nodiscard]] Future<Void> _start( ValidateStorage* const& self, Database const& cx ) {
															#line 277 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	return Future<Void>(new _startActor(self, cx));
															#line 3588 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
}

#line 327 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"

																#line 3593 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
// This generated class is to be used only via populateData()
															#line 328 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
template <class PopulateDataActor>
															#line 328 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
class PopulateDataActorState {
															#line 3599 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
public:
															#line 328 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	PopulateDataActorState(ValidateStorage* const& self,Database const& cx,std::map<Key, Value>* const& kvs) 
															#line 328 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
															#line 328 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		 : self(self),
															#line 328 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		   cx(cx),
															#line 328 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		   kvs(kvs),
															#line 329 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		   tr(makeReference<ReadYourWritesTransaction>(cx)),
															#line 330 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		   version(),
															#line 331 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		   debugID()
															#line 3616 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
	{
		fdb_probe_actor_create("populateData", reinterpret_cast<unsigned long>(this));

	}
	~PopulateDataActorState() 
	{
		fdb_probe_actor_destroy("populateData", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 333 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			;
															#line 3631 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PopulateDataActorState();
		static_cast<PopulateDataActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 349 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("PopulateTestDataDone") .detail("CommitVersion", tr->getCommittedVersion()) .detail("DebugID", debugID);
															#line 353 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (!static_cast<PopulateDataActor*>(this)->SAV<Version>::futures) { (void)(version); this->~PopulateDataActorState(); static_cast<PopulateDataActor*>(this)->destroy(); return 0; }
															#line 3656 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		new (&static_cast<PopulateDataActor*>(this)->SAV< Version >::value()) Version(std::move(version)); // state_var_RVO
		this->~PopulateDataActorState();
		static_cast<PopulateDataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 334 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		debugID = deterministicRandom()->randomUniqueID();
															#line 3675 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		try {
															#line 336 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			tr->debugTransaction(debugID);
															#line 337 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			for( const auto& [key, value] : *kvs ) {
															#line 338 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
				tr->set(key, value);
															#line 3683 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			}
															#line 340 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr->commit();
															#line 340 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			if (static_cast<PopulateDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3689 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PopulateDataActor*>(this)->actor_wait_state = 1;
															#line 340 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PopulateDataActor, 0, Void >*>(static_cast<PopulateDataActor*>(this)));
															#line 3694 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 344 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			TraceEvent("TestCommitError").errorUnsuppressed(e);
															#line 345 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr->onError(e);
															#line 345 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			if (static_cast<PopulateDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3733 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<PopulateDataActor*>(this)->actor_wait_state = 2;
															#line 345 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PopulateDataActor, 1, Void >*>(static_cast<PopulateDataActor*>(this)));
															#line 3738 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 341 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		version = tr->getCommittedVersion();
															#line 3753 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 341 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		version = tr->getCommittedVersion();
															#line 3762 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PopulateDataActor*>(this)->actor_wait_state > 0) static_cast<PopulateDataActor*>(this)->actor_wait_state = 0;
		static_cast<PopulateDataActor*>(this)->ActorCallback< PopulateDataActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PopulateDataActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("populateData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PopulateDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("populateData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PopulateDataActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("populateData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PopulateDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("populateData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PopulateDataActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("populateData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PopulateDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("populateData", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PopulateDataActor*>(this)->actor_wait_state > 0) static_cast<PopulateDataActor*>(this)->actor_wait_state = 0;
		static_cast<PopulateDataActor*>(this)->ActorCallback< PopulateDataActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PopulateDataActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("populateData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PopulateDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("populateData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PopulateDataActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("populateData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PopulateDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("populateData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PopulateDataActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("populateData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PopulateDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("populateData", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 328 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	ValidateStorage* self;
															#line 328 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	Database cx;
															#line 328 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	std::map<Key, Value>* kvs;
															#line 329 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 330 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	Version version;
															#line 331 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	UID debugID;
															#line 3941 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
};
// This generated class is to be used only via populateData()
															#line 328 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
class PopulateDataActor final : public Actor<Version>, public ActorCallback< PopulateDataActor, 0, Void >, public ActorCallback< PopulateDataActor, 1, Void >, public FastAllocated<PopulateDataActor>, public PopulateDataActorState<PopulateDataActor> {
															#line 3946 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
public:
	using FastAllocated<PopulateDataActor>::operator new;
	using FastAllocated<PopulateDataActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6233176031840578560UL, 11067318641942112256UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PopulateDataActor, 0, Void >;
friend struct ActorCallback< PopulateDataActor, 1, Void >;
															#line 328 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	PopulateDataActor(ValidateStorage* const& self,Database const& cx,std::map<Key, Value>* const& kvs) 
															#line 3964 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		 : Actor<Version>(),
		   PopulateDataActorState<PopulateDataActor>(self, cx, kvs),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("populateData", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16199582911145818112UL, 5085221050047154688UL);
		ActorExecutionContextHelper __helper(static_cast<PopulateDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("populateData");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("populateData", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PopulateDataActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PopulateDataActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 328 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
[[nodiscard]] Future<Version> populateData( ValidateStorage* const& self, Database const& cx, std::map<Key, Value>* const& kvs ) {
															#line 328 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	return Future<Version>(new PopulateDataActor(self, cx, kvs));
															#line 3997 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
}

#line 355 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"

	void testStringToAuditPhaseFunctionality() {
		AuditPhase phase = AuditPhase::Invalid;
		std::string inputStr = "RUNNING";
		phase = stringToAuditPhase(inputStr);
		if (phase != AuditPhase::Running) {
			TraceEvent(SevError, "TestStringToAuditPhaseError").detail("Input", inputStr);
		}
		inputStr = "RUnnING";
		phase = stringToAuditPhase(inputStr);
		if (phase != AuditPhase::Running) {
			TraceEvent(SevError, "TestStringToAuditPhaseError").detail("Input", inputStr);
		}
		inputStr = "error";
		phase = stringToAuditPhase(inputStr);
		if (phase != AuditPhase::Error) {
			TraceEvent(SevError, "TestStringToAuditPhaseError").detail("Input", inputStr);
		}
		inputStr = "error123";
		phase = stringToAuditPhase(inputStr);
		if (phase != AuditPhase::Invalid) {
			TraceEvent(SevError, "TestStringToAuditPhaseError").detail("Input", inputStr);
		}
		inputStr = "123";
		phase = stringToAuditPhase(inputStr);
		if (phase != AuditPhase::Invalid) {
			TraceEvent(SevError, "TestStringToAuditPhaseError").detail("Input", inputStr);
		}
		inputStr = "12Failed";
		phase = stringToAuditPhase(inputStr);
		if (phase != AuditPhase::Invalid) {
			TraceEvent(SevError, "TestStringToAuditPhaseError").detail("Input", inputStr);
		}
		return;
	}

																#line 4037 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
// This generated class is to be used only via testSSUserDataValidation()
															#line 391 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
template <class TestSSUserDataValidationActor>
															#line 391 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
class TestSSUserDataValidationActorState {
															#line 4043 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
public:
															#line 391 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	TestSSUserDataValidationActorState(ValidateStorage* const& self,Database const& cx,KeyRange const& range) 
															#line 391 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
															#line 391 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		 : self(self),
															#line 391 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		   cx(cx),
															#line 391 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		   range(range)
															#line 4054 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
	{
		fdb_probe_actor_create("testSSUserDataValidation", reinterpret_cast<unsigned long>(this));

	}
	~TestSSUserDataValidationActorState() 
	{
		fdb_probe_actor_destroy("testSSUserDataValidation", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 392 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			TraceEvent("TestSSUserDataValidationBegin").detail("Range", range);
															#line 393 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			tr = Transaction(cx);
															#line 394 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 395 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 396 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			retryCount = 0;
															#line 397 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			;
															#line 4079 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestSSUserDataValidationActorState();
		static_cast<TestSSUserDataValidationActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 449 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestSSUserDataValidationDone").detail("Range", range);
															#line 451 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (!static_cast<TestSSUserDataValidationActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestSSUserDataValidationActorState(); static_cast<TestSSUserDataValidationActor*>(this)->destroy(); return 0; }
															#line 4104 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		new (&static_cast<TestSSUserDataValidationActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestSSUserDataValidationActorState();
		static_cast<TestSSUserDataValidationActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 399 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = krmGetRanges(&tr, keyServersPrefix, range, CLIENT_KNOBS->TOO_MANY, CLIENT_KNOBS->TOO_MANY);
															#line 399 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			if (static_cast<TestSSUserDataValidationActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4126 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestSSUserDataValidationActor*>(this)->actor_wait_state = 1;
															#line 399 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestSSUserDataValidationActor, 0, RangeResult >*>(static_cast<TestSSUserDataValidationActor*>(this)));
															#line 4131 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 432 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			if (retryCount > 5)
															#line 4160 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			{
															#line 433 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
				TraceEvent(SevWarnAlways, "TestSSUserDataValidationFailed") .errorUnsuppressed(e) .detail("Range", range);
															#line 4164 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
				return a_body1break1(loopDepth==0?0:loopDepth-1); // break
			}
			else
			{
															#line 438 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
				TraceEvent(SevWarn, "TestSSUserDataValidationFailedRetry") .errorUnsuppressed(e) .detail("Range", range) .detail("RetryCount", retryCount);
															#line 442 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
				StrictFuture<Void> __when_expr_4 = delay(1);
															#line 442 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
				if (static_cast<TestSSUserDataValidationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4175 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
				static_cast<TestSSUserDataValidationActor*>(this)->actor_wait_state = 5;
															#line 442 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestSSUserDataValidationActor, 4, Void >*>(static_cast<TestSSUserDataValidationActor*>(this)));
															#line 4180 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 401 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		ASSERT(!shards.empty() && !shards.more);
															#line 403 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = tr.getRange(serverTagKeys, CLIENT_KNOBS->TOO_MANY);
															#line 403 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<TestSSUserDataValidationActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4200 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestSSUserDataValidationActor*>(this)->actor_wait_state = 2;
															#line 403 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestSSUserDataValidationActor, 1, RangeResult >*>(static_cast<TestSSUserDataValidationActor*>(this)));
															#line 4205 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& __shards,int loopDepth) 
	{
															#line 399 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		shards = __shards;
															#line 4214 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && __shards,int loopDepth) 
	{
		shards = std::move(__shards);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestSSUserDataValidationActor*>(this)->actor_wait_state > 0) static_cast<TestSSUserDataValidationActor*>(this)->actor_wait_state = 0;
		static_cast<TestSSUserDataValidationActor*>(this)->ActorCallback< TestSSUserDataValidationActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< TestSSUserDataValidationActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("testSSUserDataValidation", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSSUserDataValidationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSSUserDataValidation", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestSSUserDataValidationActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("testSSUserDataValidation", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSSUserDataValidationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSSUserDataValidation", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestSSUserDataValidationActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("testSSUserDataValidation", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSSUserDataValidationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSSUserDataValidation", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 404 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		ASSERT(!UIDtoTagMap.more && UIDtoTagMap.size() < CLIENT_KNOBS->TOO_MANY);
															#line 406 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		i = 0;
															#line 407 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		i = 0;
															#line 4297 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult const& __UIDtoTagMap,int loopDepth) 
	{
															#line 403 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		UIDtoTagMap = __UIDtoTagMap;
															#line 4306 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult && __UIDtoTagMap,int loopDepth) 
	{
		UIDtoTagMap = std::move(__UIDtoTagMap);
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestSSUserDataValidationActor*>(this)->actor_wait_state > 0) static_cast<TestSSUserDataValidationActor*>(this)->actor_wait_state = 0;
		static_cast<TestSSUserDataValidationActor*>(this)->ActorCallback< TestSSUserDataValidationActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< TestSSUserDataValidationActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("testSSUserDataValidation", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSSUserDataValidationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSSUserDataValidation", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestSSUserDataValidationActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("testSSUserDataValidation", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSSUserDataValidationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSSUserDataValidation", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestSSUserDataValidationActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("testSSUserDataValidation", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSSUserDataValidationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSSUserDataValidation", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1(int loopDepth) 
	{
															#line 407 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (!(i < shards.size() - 1))
															#line 4398 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		{
			return a_body1loopBody1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 408 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		std::vector<UID> src;
															#line 409 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		std::vector<UID> dest;
															#line 410 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		UID srcId, destId;
															#line 411 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		decodeKeyServersValue(UIDtoTagMap, shards[i].value, src, dest, srcId, destId);
															#line 413 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		const int idx = deterministicRandom()->randomInt(0, src.size());
															#line 414 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_2 = tr.get(serverListKeyFor(src[idx]));
															#line 414 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<TestSSUserDataValidationActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4416 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestSSUserDataValidationActor*>(this)->actor_wait_state = 3;
															#line 414 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestSSUserDataValidationActor, 2, Optional<Value> >*>(static_cast<TestSSUserDataValidationActor*>(this)));
															#line 4421 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1(Optional<Value> const& serverListValue,int loopDepth) 
	{
															#line 415 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		ASSERT(serverListValue.present());
															#line 416 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		const StorageServerInterface ssi = decodeServerListValue(serverListValue.get());
															#line 417 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestSSUserDataValidationSendingRequest") .detail("Range", range) .detail("StorageServer", ssi.toString());
															#line 420 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		AuditStorageRequest req(deterministicRandom()->randomUniqueID(), KeyRangeRef(shards[i].key, shards[i + 1].key), AuditType::ValidateHA);
															#line 423 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		req.ddId = deterministicRandom()->randomUniqueID();
															#line 424 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<Optional<AuditStorageState>> __when_expr_3 = timeout<AuditStorageState>(ssi.auditStorage.getReply(req), 5);
															#line 424 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<TestSSUserDataValidationActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4455 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestSSUserDataValidationActor*>(this)->actor_wait_state = 4;
															#line 424 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestSSUserDataValidationActor, 3, Optional<AuditStorageState> >*>(static_cast<TestSSUserDataValidationActor*>(this)));
															#line 4460 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1(Optional<Value> && serverListValue,int loopDepth) 
	{
															#line 415 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		ASSERT(serverListValue.present());
															#line 416 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		const StorageServerInterface ssi = decodeServerListValue(serverListValue.get());
															#line 417 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestSSUserDataValidationSendingRequest") .detail("Range", range) .detail("StorageServer", ssi.toString());
															#line 420 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		AuditStorageRequest req(deterministicRandom()->randomUniqueID(), KeyRangeRef(shards[i].key, shards[i + 1].key), AuditType::ValidateHA);
															#line 423 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		req.ddId = deterministicRandom()->randomUniqueID();
															#line 424 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<Optional<AuditStorageState>> __when_expr_3 = timeout<AuditStorageState>(ssi.auditStorage.getReply(req), 5);
															#line 424 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<TestSSUserDataValidationActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4481 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestSSUserDataValidationActor*>(this)->actor_wait_state = 4;
															#line 424 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestSSUserDataValidationActor, 3, Optional<AuditStorageState> >*>(static_cast<TestSSUserDataValidationActor*>(this)));
															#line 4486 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1when1(Optional<Value> const& serverListValue,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont1(serverListValue, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1when1(Optional<Value> && serverListValue,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont1(std::move(serverListValue), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestSSUserDataValidationActor*>(this)->actor_wait_state > 0) static_cast<TestSSUserDataValidationActor*>(this)->actor_wait_state = 0;
		static_cast<TestSSUserDataValidationActor*>(this)->ActorCallback< TestSSUserDataValidationActor, 2, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< TestSSUserDataValidationActor, 2, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("testSSUserDataValidation", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSSUserDataValidationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSSUserDataValidation", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestSSUserDataValidationActor, 2, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("testSSUserDataValidation", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSSUserDataValidationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSSUserDataValidation", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestSSUserDataValidationActor, 2, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("testSSUserDataValidation", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSSUserDataValidationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSSUserDataValidation", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont3loopBody1cont3(Optional<AuditStorageState> const& vResult,int loopDepth) 
	{
															#line 426 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (!vResult.present())
															#line 4570 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		{
															#line 427 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			if (!static_cast<TestSSUserDataValidationActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestSSUserDataValidationActorState(); static_cast<TestSSUserDataValidationActor*>(this)->destroy(); return 0; }
															#line 4574 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			new (&static_cast<TestSSUserDataValidationActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~TestSSUserDataValidationActorState();
			static_cast<TestSSUserDataValidationActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 407 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		++i;
															#line 4582 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont3(Optional<AuditStorageState> && vResult,int loopDepth) 
	{
															#line 426 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (!vResult.present())
															#line 4591 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		{
															#line 427 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			if (!static_cast<TestSSUserDataValidationActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestSSUserDataValidationActorState(); static_cast<TestSSUserDataValidationActor*>(this)->destroy(); return 0; }
															#line 4595 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			new (&static_cast<TestSSUserDataValidationActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~TestSSUserDataValidationActorState();
			static_cast<TestSSUserDataValidationActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 407 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		++i;
															#line 4603 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1when1(Optional<AuditStorageState> const& vResult,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont3(vResult, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1when1(Optional<AuditStorageState> && vResult,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont3(std::move(vResult), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TestSSUserDataValidationActor*>(this)->actor_wait_state > 0) static_cast<TestSSUserDataValidationActor*>(this)->actor_wait_state = 0;
		static_cast<TestSSUserDataValidationActor*>(this)->ActorCallback< TestSSUserDataValidationActor, 3, Optional<AuditStorageState> >::remove();

	}
	void a_callback_fire(ActorCallback< TestSSUserDataValidationActor, 3, Optional<AuditStorageState> >*,Optional<AuditStorageState> const& value) 
	{
		fdb_probe_actor_enter("testSSUserDataValidation", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSSUserDataValidationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSSUserDataValidation", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestSSUserDataValidationActor, 3, Optional<AuditStorageState> >*,Optional<AuditStorageState> && value) 
	{
		fdb_probe_actor_enter("testSSUserDataValidation", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSSUserDataValidationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSSUserDataValidation", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestSSUserDataValidationActor, 3, Optional<AuditStorageState> >*,Error err) 
	{
		fdb_probe_actor_enter("testSSUserDataValidation", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSSUserDataValidationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSSUserDataValidation", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1Catch1cont3(Void const& _,int loopDepth) 
	{
															#line 443 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		retryCount++;
															#line 4687 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(Void && _,int loopDepth) 
	{
															#line 443 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		retryCount++;
															#line 4696 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TestSSUserDataValidationActor*>(this)->actor_wait_state > 0) static_cast<TestSSUserDataValidationActor*>(this)->actor_wait_state = 0;
		static_cast<TestSSUserDataValidationActor*>(this)->ActorCallback< TestSSUserDataValidationActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestSSUserDataValidationActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testSSUserDataValidation", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSSUserDataValidationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSSUserDataValidation", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TestSSUserDataValidationActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testSSUserDataValidation", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSSUserDataValidationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSSUserDataValidation", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TestSSUserDataValidationActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testSSUserDataValidation", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSSUserDataValidationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSSUserDataValidation", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 391 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	ValidateStorage* self;
															#line 391 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	Database cx;
															#line 391 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	KeyRange range;
															#line 393 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	Transaction tr;
															#line 396 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	int retryCount;
															#line 399 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	RangeResult shards;
															#line 403 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	RangeResult UIDtoTagMap;
															#line 406 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	int i;
															#line 4792 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
};
// This generated class is to be used only via testSSUserDataValidation()
															#line 391 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
class TestSSUserDataValidationActor final : public Actor<Void>, public ActorCallback< TestSSUserDataValidationActor, 0, RangeResult >, public ActorCallback< TestSSUserDataValidationActor, 1, RangeResult >, public ActorCallback< TestSSUserDataValidationActor, 2, Optional<Value> >, public ActorCallback< TestSSUserDataValidationActor, 3, Optional<AuditStorageState> >, public ActorCallback< TestSSUserDataValidationActor, 4, Void >, public FastAllocated<TestSSUserDataValidationActor>, public TestSSUserDataValidationActorState<TestSSUserDataValidationActor> {
															#line 4797 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
public:
	using FastAllocated<TestSSUserDataValidationActor>::operator new;
	using FastAllocated<TestSSUserDataValidationActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10347065269687428096UL, 5912329626242685440UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestSSUserDataValidationActor, 0, RangeResult >;
friend struct ActorCallback< TestSSUserDataValidationActor, 1, RangeResult >;
friend struct ActorCallback< TestSSUserDataValidationActor, 2, Optional<Value> >;
friend struct ActorCallback< TestSSUserDataValidationActor, 3, Optional<AuditStorageState> >;
friend struct ActorCallback< TestSSUserDataValidationActor, 4, Void >;
															#line 391 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	TestSSUserDataValidationActor(ValidateStorage* const& self,Database const& cx,KeyRange const& range) 
															#line 4818 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		 : Actor<Void>(),
		   TestSSUserDataValidationActorState<TestSSUserDataValidationActor>(self, cx, range),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testSSUserDataValidation", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11606703440465907200UL, 15387619525193400064UL);
		ActorExecutionContextHelper __helper(static_cast<TestSSUserDataValidationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testSSUserDataValidation");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testSSUserDataValidation", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestSSUserDataValidationActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestSSUserDataValidationActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestSSUserDataValidationActor, 2, Optional<Value> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TestSSUserDataValidationActor, 3, Optional<AuditStorageState> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TestSSUserDataValidationActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 391 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
[[nodiscard]] Future<Void> testSSUserDataValidation( ValidateStorage* const& self, Database const& cx, KeyRange const& range ) {
															#line 391 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	return Future<Void>(new TestSSUserDataValidationActor(self, cx, range));
															#line 4854 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
}

#line 453 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"

																#line 4859 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
// This generated class is to be used only via auditStorageForType()
															#line 454 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
template <class AuditStorageForTypeActor>
															#line 454 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
class AuditStorageForTypeActorState {
															#line 4865 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
public:
															#line 454 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	AuditStorageForTypeActorState(ValidateStorage* const& self,Database const& cx,AuditType const& type,std::string const& context,bool const& stopWaitWhenCleared = false) 
															#line 454 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
															#line 454 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		 : self(self),
															#line 454 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		   cx(cx),
															#line 454 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		   type(type),
															#line 454 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		   context(context),
															#line 454 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		   stopWaitWhenCleared(stopWaitWhenCleared)
															#line 4880 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
	{
		fdb_probe_actor_create("auditStorageForType", reinterpret_cast<unsigned long>(this));

	}
	~AuditStorageForTypeActorState() 
	{
		fdb_probe_actor_destroy("auditStorageForType", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 459 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			std::vector<KeyRangeRef> auditKeysCollection = { partialKeys1, partialKeys2, partialKeys3, partialKeys4, partialKeys5, partialKeys6, partialKeys7, allKeys };
															#line 461 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			auditRange = deterministicRandom()->randomChoice(auditKeysCollection);
															#line 463 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			StrictFuture<UID> __when_expr_0 = self->triggerAuditStorageForType(cx, type, context, auditRange);
															#line 463 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			if (static_cast<AuditStorageForTypeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4901 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AuditStorageForTypeActor*>(this)->actor_wait_state = 1;
															#line 463 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AuditStorageForTypeActor, 0, UID >*>(static_cast<AuditStorageForTypeActor*>(this)));
															#line 4906 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AuditStorageForTypeActorState();
		static_cast<AuditStorageForTypeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 464 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (auditRange.empty())
															#line 4929 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		{
															#line 465 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			ASSERT(!auditId.isValid());
															#line 466 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			if (!static_cast<AuditStorageForTypeActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~AuditStorageForTypeActorState(); static_cast<AuditStorageForTypeActor*>(this)->destroy(); return 0; }
															#line 4935 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			new (&static_cast<AuditStorageForTypeActor*>(this)->SAV< UID >::value()) UID(UID());
			this->~AuditStorageForTypeActorState();
			static_cast<AuditStorageForTypeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 469 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->waitAuditStorageUntilComplete(cx, type, auditId, context, stopWaitWhenCleared);
															#line 469 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<AuditStorageForTypeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4945 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AuditStorageForTypeActor*>(this)->actor_wait_state = 2;
															#line 469 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AuditStorageForTypeActor, 1, Void >*>(static_cast<AuditStorageForTypeActor*>(this)));
															#line 4950 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(UID const& __auditId,int loopDepth) 
	{
															#line 463 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		auditId = __auditId;
															#line 4959 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(UID && __auditId,int loopDepth) 
	{
		auditId = std::move(__auditId);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AuditStorageForTypeActor*>(this)->actor_wait_state > 0) static_cast<AuditStorageForTypeActor*>(this)->actor_wait_state = 0;
		static_cast<AuditStorageForTypeActor*>(this)->ActorCallback< AuditStorageForTypeActor, 0, UID >::remove();

	}
	void a_callback_fire(ActorCallback< AuditStorageForTypeActor, 0, UID >*,UID const& value) 
	{
		fdb_probe_actor_enter("auditStorageForType", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageForTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageForType", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AuditStorageForTypeActor, 0, UID >*,UID && value) 
	{
		fdb_probe_actor_enter("auditStorageForType", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageForTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageForType", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AuditStorageForTypeActor, 0, UID >*,Error err) 
	{
		fdb_probe_actor_enter("auditStorageForType", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageForTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageForType", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 471 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->checkAuditStorageInternalState(cx, type, auditId, context);
															#line 471 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<AuditStorageForTypeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5040 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<AuditStorageForTypeActor*>(this)->actor_wait_state = 3;
															#line 471 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< AuditStorageForTypeActor, 2, Void >*>(static_cast<AuditStorageForTypeActor*>(this)));
															#line 5045 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 471 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->checkAuditStorageInternalState(cx, type, auditId, context);
															#line 471 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<AuditStorageForTypeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5056 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<AuditStorageForTypeActor*>(this)->actor_wait_state = 3;
															#line 471 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< AuditStorageForTypeActor, 2, Void >*>(static_cast<AuditStorageForTypeActor*>(this)));
															#line 5061 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AuditStorageForTypeActor*>(this)->actor_wait_state > 0) static_cast<AuditStorageForTypeActor*>(this)->actor_wait_state = 0;
		static_cast<AuditStorageForTypeActor*>(this)->ActorCallback< AuditStorageForTypeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AuditStorageForTypeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("auditStorageForType", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageForTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageForType", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AuditStorageForTypeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("auditStorageForType", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageForTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageForType", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AuditStorageForTypeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("auditStorageForType", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageForTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageForType", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 472 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (!static_cast<AuditStorageForTypeActor*>(this)->SAV<UID>::futures) { (void)(auditId); this->~AuditStorageForTypeActorState(); static_cast<AuditStorageForTypeActor*>(this)->destroy(); return 0; }
															#line 5145 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		new (&static_cast<AuditStorageForTypeActor*>(this)->SAV< UID >::value()) UID(std::move(auditId)); // state_var_RVO
		this->~AuditStorageForTypeActorState();
		static_cast<AuditStorageForTypeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 472 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (!static_cast<AuditStorageForTypeActor*>(this)->SAV<UID>::futures) { (void)(auditId); this->~AuditStorageForTypeActorState(); static_cast<AuditStorageForTypeActor*>(this)->destroy(); return 0; }
															#line 5157 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		new (&static_cast<AuditStorageForTypeActor*>(this)->SAV< UID >::value()) UID(std::move(auditId)); // state_var_RVO
		this->~AuditStorageForTypeActorState();
		static_cast<AuditStorageForTypeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<AuditStorageForTypeActor*>(this)->actor_wait_state > 0) static_cast<AuditStorageForTypeActor*>(this)->actor_wait_state = 0;
		static_cast<AuditStorageForTypeActor*>(this)->ActorCallback< AuditStorageForTypeActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AuditStorageForTypeActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("auditStorageForType", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageForTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageForType", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< AuditStorageForTypeActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("auditStorageForType", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageForTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageForType", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< AuditStorageForTypeActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("auditStorageForType", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageForTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageForType", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 454 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	ValidateStorage* self;
															#line 454 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	Database cx;
															#line 454 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	AuditType type;
															#line 454 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	std::string context;
															#line 454 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	bool stopWaitWhenCleared;
															#line 461 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	KeyRangeRef auditRange;
															#line 463 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	UID auditId;
															#line 5254 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
};
// This generated class is to be used only via auditStorageForType()
															#line 454 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
class AuditStorageForTypeActor final : public Actor<UID>, public ActorCallback< AuditStorageForTypeActor, 0, UID >, public ActorCallback< AuditStorageForTypeActor, 1, Void >, public ActorCallback< AuditStorageForTypeActor, 2, Void >, public FastAllocated<AuditStorageForTypeActor>, public AuditStorageForTypeActorState<AuditStorageForTypeActor> {
															#line 5259 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
public:
	using FastAllocated<AuditStorageForTypeActor>::operator new;
	using FastAllocated<AuditStorageForTypeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12845678339167353344UL, 17953653338925144064UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<UID>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AuditStorageForTypeActor, 0, UID >;
friend struct ActorCallback< AuditStorageForTypeActor, 1, Void >;
friend struct ActorCallback< AuditStorageForTypeActor, 2, Void >;
															#line 454 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	AuditStorageForTypeActor(ValidateStorage* const& self,Database const& cx,AuditType const& type,std::string const& context,bool const& stopWaitWhenCleared = false) 
															#line 5278 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		 : Actor<UID>(),
		   AuditStorageForTypeActorState<AuditStorageForTypeActor>(self, cx, type, context, stopWaitWhenCleared),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("auditStorageForType", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7387352961922145792UL, 15880021171643597824UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageForTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("auditStorageForType");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("auditStorageForType", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AuditStorageForTypeActor, 0, UID >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AuditStorageForTypeActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< AuditStorageForTypeActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 454 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
[[nodiscard]] Future<UID> auditStorageForType( ValidateStorage* const& self, Database const& cx, AuditType const& type, std::string const& context, bool const& stopWaitWhenCleared = false ) {
															#line 454 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	return Future<UID>(new AuditStorageForTypeActor(self, cx, type, context, stopWaitWhenCleared));
															#line 5312 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
}

#line 474 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"

																#line 5317 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
// This generated class is to be used only via testAuditStorageFunctionality()
															#line 475 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
template <class TestAuditStorageFunctionalityActor>
															#line 475 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
class TestAuditStorageFunctionalityActorState {
															#line 5323 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
public:
															#line 475 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	TestAuditStorageFunctionalityActorState(ValidateStorage* const& self,Database const& cx) 
															#line 475 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
															#line 475 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		 : self(self),
															#line 475 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		   cx(cx)
															#line 5332 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
	{
		fdb_probe_actor_create("testAuditStorageFunctionality", reinterpret_cast<unsigned long>(this));

	}
	~TestAuditStorageFunctionalityActorState() 
	{
		fdb_probe_actor_destroy("testAuditStorageFunctionality", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 476 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			StrictFuture<UID> __when_expr_0 = self->auditStorageForType(self, cx, AuditType::ValidateHA, "TestAuditStorageFunctionality");
															#line 476 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			if (static_cast<TestAuditStorageFunctionalityActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5349 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestAuditStorageFunctionalityActor*>(this)->actor_wait_state = 1;
															#line 476 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestAuditStorageFunctionalityActor, 0, UID >*>(static_cast<TestAuditStorageFunctionalityActor*>(this)));
															#line 5354 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestAuditStorageFunctionalityActorState();
		static_cast<TestAuditStorageFunctionalityActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(UID const& auditIdA,int loopDepth) 
	{
															#line 478 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestFunctionalityHADone", auditIdA);
															#line 479 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<UID> __when_expr_1 = self->auditStorageForType(self, cx, AuditType::ValidateReplica, "TestAuditStorageFunctionality");
															#line 479 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<TestAuditStorageFunctionalityActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5381 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestAuditStorageFunctionalityActor*>(this)->actor_wait_state = 2;
															#line 479 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestAuditStorageFunctionalityActor, 1, UID >*>(static_cast<TestAuditStorageFunctionalityActor*>(this)));
															#line 5386 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(UID && auditIdA,int loopDepth) 
	{
															#line 478 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestFunctionalityHADone", auditIdA);
															#line 479 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<UID> __when_expr_1 = self->auditStorageForType(self, cx, AuditType::ValidateReplica, "TestAuditStorageFunctionality");
															#line 479 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<TestAuditStorageFunctionalityActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5399 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestAuditStorageFunctionalityActor*>(this)->actor_wait_state = 2;
															#line 479 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestAuditStorageFunctionalityActor, 1, UID >*>(static_cast<TestAuditStorageFunctionalityActor*>(this)));
															#line 5404 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(UID const& auditIdA,int loopDepth) 
	{
		loopDepth = a_body1cont1(auditIdA, loopDepth);

		return loopDepth;
	}
	int a_body1when1(UID && auditIdA,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(auditIdA), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestAuditStorageFunctionalityActor*>(this)->actor_wait_state > 0) static_cast<TestAuditStorageFunctionalityActor*>(this)->actor_wait_state = 0;
		static_cast<TestAuditStorageFunctionalityActor*>(this)->ActorCallback< TestAuditStorageFunctionalityActor, 0, UID >::remove();

	}
	void a_callback_fire(ActorCallback< TestAuditStorageFunctionalityActor, 0, UID >*,UID const& value) 
	{
		fdb_probe_actor_enter("testAuditStorageFunctionality", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageFunctionalityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageFunctionality", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestAuditStorageFunctionalityActor, 0, UID >*,UID && value) 
	{
		fdb_probe_actor_enter("testAuditStorageFunctionality", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageFunctionalityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageFunctionality", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestAuditStorageFunctionalityActor, 0, UID >*,Error err) 
	{
		fdb_probe_actor_enter("testAuditStorageFunctionality", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageFunctionalityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageFunctionality", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(UID const& auditIdB,int loopDepth) 
	{
															#line 481 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestFunctionalityReplicaDone", auditIdB);
															#line 482 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<UID> __when_expr_2 = self->auditStorageForType(self, cx, AuditType::ValidateLocationMetadata, "TestAuditStorageFunctionality");
															#line 482 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<TestAuditStorageFunctionalityActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5492 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestAuditStorageFunctionalityActor*>(this)->actor_wait_state = 3;
															#line 482 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestAuditStorageFunctionalityActor, 2, UID >*>(static_cast<TestAuditStorageFunctionalityActor*>(this)));
															#line 5497 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(UID && auditIdB,int loopDepth) 
	{
															#line 481 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestFunctionalityReplicaDone", auditIdB);
															#line 482 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<UID> __when_expr_2 = self->auditStorageForType(self, cx, AuditType::ValidateLocationMetadata, "TestAuditStorageFunctionality");
															#line 482 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<TestAuditStorageFunctionalityActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5510 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestAuditStorageFunctionalityActor*>(this)->actor_wait_state = 3;
															#line 482 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestAuditStorageFunctionalityActor, 2, UID >*>(static_cast<TestAuditStorageFunctionalityActor*>(this)));
															#line 5515 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(UID const& auditIdB,int loopDepth) 
	{
		loopDepth = a_body1cont2(auditIdB, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(UID && auditIdB,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(auditIdB), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestAuditStorageFunctionalityActor*>(this)->actor_wait_state > 0) static_cast<TestAuditStorageFunctionalityActor*>(this)->actor_wait_state = 0;
		static_cast<TestAuditStorageFunctionalityActor*>(this)->ActorCallback< TestAuditStorageFunctionalityActor, 1, UID >::remove();

	}
	void a_callback_fire(ActorCallback< TestAuditStorageFunctionalityActor, 1, UID >*,UID const& value) 
	{
		fdb_probe_actor_enter("testAuditStorageFunctionality", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageFunctionalityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageFunctionality", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestAuditStorageFunctionalityActor, 1, UID >*,UID && value) 
	{
		fdb_probe_actor_enter("testAuditStorageFunctionality", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageFunctionalityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageFunctionality", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestAuditStorageFunctionalityActor, 1, UID >*,Error err) 
	{
		fdb_probe_actor_enter("testAuditStorageFunctionality", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageFunctionalityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageFunctionality", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(UID const& auditIdC,int loopDepth) 
	{
															#line 484 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestFunctionalityShardLocationMetadataDone", auditIdC);
															#line 485 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<UID> __when_expr_3 = self->auditStorageForType( self, cx, AuditType::ValidateStorageServerShard, "TestAuditStorageFunctionality");
															#line 485 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<TestAuditStorageFunctionalityActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5603 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestAuditStorageFunctionalityActor*>(this)->actor_wait_state = 4;
															#line 485 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestAuditStorageFunctionalityActor, 3, UID >*>(static_cast<TestAuditStorageFunctionalityActor*>(this)));
															#line 5608 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(UID && auditIdC,int loopDepth) 
	{
															#line 484 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestFunctionalityShardLocationMetadataDone", auditIdC);
															#line 485 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<UID> __when_expr_3 = self->auditStorageForType( self, cx, AuditType::ValidateStorageServerShard, "TestAuditStorageFunctionality");
															#line 485 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<TestAuditStorageFunctionalityActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5621 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestAuditStorageFunctionalityActor*>(this)->actor_wait_state = 4;
															#line 485 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestAuditStorageFunctionalityActor, 3, UID >*>(static_cast<TestAuditStorageFunctionalityActor*>(this)));
															#line 5626 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(UID const& auditIdC,int loopDepth) 
	{
		loopDepth = a_body1cont3(auditIdC, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(UID && auditIdC,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(auditIdC), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestAuditStorageFunctionalityActor*>(this)->actor_wait_state > 0) static_cast<TestAuditStorageFunctionalityActor*>(this)->actor_wait_state = 0;
		static_cast<TestAuditStorageFunctionalityActor*>(this)->ActorCallback< TestAuditStorageFunctionalityActor, 2, UID >::remove();

	}
	void a_callback_fire(ActorCallback< TestAuditStorageFunctionalityActor, 2, UID >*,UID const& value) 
	{
		fdb_probe_actor_enter("testAuditStorageFunctionality", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageFunctionalityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageFunctionality", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestAuditStorageFunctionalityActor, 2, UID >*,UID && value) 
	{
		fdb_probe_actor_enter("testAuditStorageFunctionality", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageFunctionalityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageFunctionality", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestAuditStorageFunctionalityActor, 2, UID >*,Error err) 
	{
		fdb_probe_actor_enter("testAuditStorageFunctionality", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageFunctionalityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageFunctionality", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(UID const& auditIdD,int loopDepth) 
	{
															#line 487 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestFunctionalitySSShardInfoDone", auditIdD);
															#line 488 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<Void> __when_expr_4 = self->testGetAuditStateWhenNoOngingAudit(self, cx);
															#line 488 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<TestAuditStorageFunctionalityActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5714 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestAuditStorageFunctionalityActor*>(this)->actor_wait_state = 5;
															#line 488 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestAuditStorageFunctionalityActor, 4, Void >*>(static_cast<TestAuditStorageFunctionalityActor*>(this)));
															#line 5719 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(UID && auditIdD,int loopDepth) 
	{
															#line 487 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestFunctionalitySSShardInfoDone", auditIdD);
															#line 488 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<Void> __when_expr_4 = self->testGetAuditStateWhenNoOngingAudit(self, cx);
															#line 488 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<TestAuditStorageFunctionalityActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5732 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestAuditStorageFunctionalityActor*>(this)->actor_wait_state = 5;
															#line 488 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestAuditStorageFunctionalityActor, 4, Void >*>(static_cast<TestAuditStorageFunctionalityActor*>(this)));
															#line 5737 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(UID const& auditIdD,int loopDepth) 
	{
		loopDepth = a_body1cont4(auditIdD, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(UID && auditIdD,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(auditIdD), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TestAuditStorageFunctionalityActor*>(this)->actor_wait_state > 0) static_cast<TestAuditStorageFunctionalityActor*>(this)->actor_wait_state = 0;
		static_cast<TestAuditStorageFunctionalityActor*>(this)->ActorCallback< TestAuditStorageFunctionalityActor, 3, UID >::remove();

	}
	void a_callback_fire(ActorCallback< TestAuditStorageFunctionalityActor, 3, UID >*,UID const& value) 
	{
		fdb_probe_actor_enter("testAuditStorageFunctionality", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageFunctionalityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageFunctionality", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestAuditStorageFunctionalityActor, 3, UID >*,UID && value) 
	{
		fdb_probe_actor_enter("testAuditStorageFunctionality", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageFunctionalityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageFunctionality", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestAuditStorageFunctionalityActor, 3, UID >*,Error err) 
	{
		fdb_probe_actor_enter("testAuditStorageFunctionality", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageFunctionalityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageFunctionality", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 489 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestGetAuditStateDone");
															#line 490 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (!static_cast<TestAuditStorageFunctionalityActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestAuditStorageFunctionalityActorState(); static_cast<TestAuditStorageFunctionalityActor*>(this)->destroy(); return 0; }
															#line 5823 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		new (&static_cast<TestAuditStorageFunctionalityActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestAuditStorageFunctionalityActorState();
		static_cast<TestAuditStorageFunctionalityActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 489 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestGetAuditStateDone");
															#line 490 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (!static_cast<TestAuditStorageFunctionalityActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestAuditStorageFunctionalityActorState(); static_cast<TestAuditStorageFunctionalityActor*>(this)->destroy(); return 0; }
															#line 5837 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		new (&static_cast<TestAuditStorageFunctionalityActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestAuditStorageFunctionalityActorState();
		static_cast<TestAuditStorageFunctionalityActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TestAuditStorageFunctionalityActor*>(this)->actor_wait_state > 0) static_cast<TestAuditStorageFunctionalityActor*>(this)->actor_wait_state = 0;
		static_cast<TestAuditStorageFunctionalityActor*>(this)->ActorCallback< TestAuditStorageFunctionalityActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestAuditStorageFunctionalityActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testAuditStorageFunctionality", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageFunctionalityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageFunctionality", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TestAuditStorageFunctionalityActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testAuditStorageFunctionality", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageFunctionalityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageFunctionality", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TestAuditStorageFunctionalityActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testAuditStorageFunctionality", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageFunctionalityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageFunctionality", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 475 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	ValidateStorage* self;
															#line 475 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	Database cx;
															#line 5924 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
};
// This generated class is to be used only via testAuditStorageFunctionality()
															#line 475 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
class TestAuditStorageFunctionalityActor final : public Actor<Void>, public ActorCallback< TestAuditStorageFunctionalityActor, 0, UID >, public ActorCallback< TestAuditStorageFunctionalityActor, 1, UID >, public ActorCallback< TestAuditStorageFunctionalityActor, 2, UID >, public ActorCallback< TestAuditStorageFunctionalityActor, 3, UID >, public ActorCallback< TestAuditStorageFunctionalityActor, 4, Void >, public FastAllocated<TestAuditStorageFunctionalityActor>, public TestAuditStorageFunctionalityActorState<TestAuditStorageFunctionalityActor> {
															#line 5929 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
public:
	using FastAllocated<TestAuditStorageFunctionalityActor>::operator new;
	using FastAllocated<TestAuditStorageFunctionalityActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7823518687172111872UL, 12032623244746090496UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestAuditStorageFunctionalityActor, 0, UID >;
friend struct ActorCallback< TestAuditStorageFunctionalityActor, 1, UID >;
friend struct ActorCallback< TestAuditStorageFunctionalityActor, 2, UID >;
friend struct ActorCallback< TestAuditStorageFunctionalityActor, 3, UID >;
friend struct ActorCallback< TestAuditStorageFunctionalityActor, 4, Void >;
															#line 475 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	TestAuditStorageFunctionalityActor(ValidateStorage* const& self,Database const& cx) 
															#line 5950 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		 : Actor<Void>(),
		   TestAuditStorageFunctionalityActorState<TestAuditStorageFunctionalityActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testAuditStorageFunctionality", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6382064358636047872UL, 15616157126790726656UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageFunctionalityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testAuditStorageFunctionality");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testAuditStorageFunctionality", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestAuditStorageFunctionalityActor, 0, UID >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestAuditStorageFunctionalityActor, 1, UID >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestAuditStorageFunctionalityActor, 2, UID >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TestAuditStorageFunctionalityActor, 3, UID >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TestAuditStorageFunctionalityActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 475 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
[[nodiscard]] Future<Void> testAuditStorageFunctionality( ValidateStorage* const& self, Database const& cx ) {
															#line 475 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	return Future<Void>(new TestAuditStorageFunctionalityActor(self, cx));
															#line 5986 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
}

#line 492 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"

																#line 5991 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
// This generated class is to be used only via testAuditStorageIDGenerator()
															#line 493 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
template <class TestAuditStorageIDGeneratorActor>
															#line 493 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
class TestAuditStorageIDGeneratorActorState {
															#line 5997 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
public:
															#line 493 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	TestAuditStorageIDGeneratorActorState(ValidateStorage* const& self,Database const& cx) 
															#line 493 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
															#line 493 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		 : self(self),
															#line 493 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		   cx(cx),
															#line 494 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		   type(AuditType::ValidateReplica)
															#line 6008 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
	{
		fdb_probe_actor_create("testAuditStorageIDGenerator", reinterpret_cast<unsigned long>(this));

	}
	~TestAuditStorageIDGeneratorActorState() 
	{
		fdb_probe_actor_destroy("testAuditStorageIDGenerator", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 495 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			TraceEvent("TestAuditStorageIDGeneratorBegin").detail("AuditType", type);
															#line 496 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			StrictFuture<UID> __when_expr_0 = self->auditStorageForType(self, cx, type, "FirstRunInTestIDGenerator");
															#line 496 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			if (static_cast<TestAuditStorageIDGeneratorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6027 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestAuditStorageIDGeneratorActor*>(this)->actor_wait_state = 1;
															#line 496 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestAuditStorageIDGeneratorActor, 0, UID >*>(static_cast<TestAuditStorageIDGeneratorActor*>(this)));
															#line 6032 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestAuditStorageIDGeneratorActorState();
		static_cast<TestAuditStorageIDGeneratorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 497 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<UID> __when_expr_1 = self->auditStorageForType(self, cx, type, "SecondRunInTestIDGenerator");
															#line 497 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<TestAuditStorageIDGeneratorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6057 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestAuditStorageIDGeneratorActor*>(this)->actor_wait_state = 2;
															#line 497 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestAuditStorageIDGeneratorActor, 1, UID >*>(static_cast<TestAuditStorageIDGeneratorActor*>(this)));
															#line 6062 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(UID const& __auditIdA,int loopDepth) 
	{
															#line 496 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		auditIdA = __auditIdA;
															#line 6071 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(UID && __auditIdA,int loopDepth) 
	{
		auditIdA = std::move(__auditIdA);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestAuditStorageIDGeneratorActor*>(this)->actor_wait_state > 0) static_cast<TestAuditStorageIDGeneratorActor*>(this)->actor_wait_state = 0;
		static_cast<TestAuditStorageIDGeneratorActor*>(this)->ActorCallback< TestAuditStorageIDGeneratorActor, 0, UID >::remove();

	}
	void a_callback_fire(ActorCallback< TestAuditStorageIDGeneratorActor, 0, UID >*,UID const& value) 
	{
		fdb_probe_actor_enter("testAuditStorageIDGenerator", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageIDGeneratorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageIDGenerator", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestAuditStorageIDGeneratorActor, 0, UID >*,UID && value) 
	{
		fdb_probe_actor_enter("testAuditStorageIDGenerator", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageIDGeneratorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageIDGenerator", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestAuditStorageIDGeneratorActor, 0, UID >*,Error err) 
	{
		fdb_probe_actor_enter("testAuditStorageIDGenerator", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageIDGeneratorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageIDGenerator", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 498 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (auditIdA == auditIdB && auditIdA.isValid())
															#line 6150 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		{
															#line 499 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			TraceEvent(SevError, "TestAuditStorageIDGeneratorError") .detail("AuditType", type) .detail("AuditIDA", auditIdA) .detail("AuditIDB", auditIdB);
															#line 6154 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		}
															#line 504 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestAuditStorageIDGeneratorEnd").detail("AuditType", type);
															#line 506 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (!static_cast<TestAuditStorageIDGeneratorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestAuditStorageIDGeneratorActorState(); static_cast<TestAuditStorageIDGeneratorActor*>(this)->destroy(); return 0; }
															#line 6160 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		new (&static_cast<TestAuditStorageIDGeneratorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestAuditStorageIDGeneratorActorState();
		static_cast<TestAuditStorageIDGeneratorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(UID const& __auditIdB,int loopDepth) 
	{
															#line 497 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		auditIdB = __auditIdB;
															#line 6172 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(UID && __auditIdB,int loopDepth) 
	{
		auditIdB = std::move(__auditIdB);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestAuditStorageIDGeneratorActor*>(this)->actor_wait_state > 0) static_cast<TestAuditStorageIDGeneratorActor*>(this)->actor_wait_state = 0;
		static_cast<TestAuditStorageIDGeneratorActor*>(this)->ActorCallback< TestAuditStorageIDGeneratorActor, 1, UID >::remove();

	}
	void a_callback_fire(ActorCallback< TestAuditStorageIDGeneratorActor, 1, UID >*,UID const& value) 
	{
		fdb_probe_actor_enter("testAuditStorageIDGenerator", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageIDGeneratorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageIDGenerator", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestAuditStorageIDGeneratorActor, 1, UID >*,UID && value) 
	{
		fdb_probe_actor_enter("testAuditStorageIDGenerator", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageIDGeneratorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageIDGenerator", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestAuditStorageIDGeneratorActor, 1, UID >*,Error err) 
	{
		fdb_probe_actor_enter("testAuditStorageIDGenerator", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageIDGeneratorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageIDGenerator", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 493 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	ValidateStorage* self;
															#line 493 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	Database cx;
															#line 494 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	AuditType type;
															#line 496 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	UID auditIdA;
															#line 497 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	UID auditIdB;
															#line 6257 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
};
// This generated class is to be used only via testAuditStorageIDGenerator()
															#line 493 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
class TestAuditStorageIDGeneratorActor final : public Actor<Void>, public ActorCallback< TestAuditStorageIDGeneratorActor, 0, UID >, public ActorCallback< TestAuditStorageIDGeneratorActor, 1, UID >, public FastAllocated<TestAuditStorageIDGeneratorActor>, public TestAuditStorageIDGeneratorActorState<TestAuditStorageIDGeneratorActor> {
															#line 6262 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
public:
	using FastAllocated<TestAuditStorageIDGeneratorActor>::operator new;
	using FastAllocated<TestAuditStorageIDGeneratorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14133027419800488704UL, 1537378719660712192UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestAuditStorageIDGeneratorActor, 0, UID >;
friend struct ActorCallback< TestAuditStorageIDGeneratorActor, 1, UID >;
															#line 493 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	TestAuditStorageIDGeneratorActor(ValidateStorage* const& self,Database const& cx) 
															#line 6280 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		 : Actor<Void>(),
		   TestAuditStorageIDGeneratorActorState<TestAuditStorageIDGeneratorActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testAuditStorageIDGenerator", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1367927286749095936UL, 14240969444259773696UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageIDGeneratorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testAuditStorageIDGenerator");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testAuditStorageIDGenerator", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestAuditStorageIDGeneratorActor, 0, UID >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestAuditStorageIDGeneratorActor, 1, UID >*)0, actor_cancelled()); break;
		}

	}
};
															#line 493 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
[[nodiscard]] Future<Void> testAuditStorageIDGenerator( ValidateStorage* const& self, Database const& cx ) {
															#line 493 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	return Future<Void>(new TestAuditStorageIDGeneratorActor(self, cx));
															#line 6313 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
}

#line 508 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"

																#line 6318 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
// This generated class is to be used only via testGetAuditStateWhenNoOngingAuditForType()
															#line 509 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
template <class TestGetAuditStateWhenNoOngingAuditForTypeActor>
															#line 509 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
class TestGetAuditStateWhenNoOngingAuditForTypeActorState {
															#line 6324 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
public:
															#line 509 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	TestGetAuditStateWhenNoOngingAuditForTypeActorState(ValidateStorage* const& self,Database const& cx,AuditType const& type) 
															#line 509 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
															#line 509 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		 : self(self),
															#line 509 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		   cx(cx),
															#line 509 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		   type(type)
															#line 6335 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
	{
		fdb_probe_actor_create("testGetAuditStateWhenNoOngingAuditForType", reinterpret_cast<unsigned long>(this));

	}
	~TestGetAuditStateWhenNoOngingAuditForTypeActorState() 
	{
		fdb_probe_actor_destroy("testGetAuditStateWhenNoOngingAuditForType", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 510 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			TraceEvent("TestGetAuditStateBegin").detail("AuditType", type);
															#line 511 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			StrictFuture<std::vector<AuditStorageState>> __when_expr_0 = getAuditStates(cx, type, true, 1);
															#line 511 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			if (static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6354 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->actor_wait_state = 1;
															#line 511 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestGetAuditStateWhenNoOngingAuditForTypeActor, 0, std::vector<AuditStorageState> >*>(static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)));
															#line 6359 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestGetAuditStateWhenNoOngingAuditForTypeActorState();
		static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<AuditStorageState> const& res1,int loopDepth) 
	{
															#line 512 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (res1.size() > 1)
															#line 6382 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		{
															#line 513 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			TraceEvent(SevError, "TestGetAuditStatesError").detail("ActualResSize", res1.size());
															#line 6386 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		}
															#line 515 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<std::vector<AuditStorageState>> __when_expr_1 = getAuditStates(cx, type, true, CLIENT_KNOBS->TOO_MANY, AuditPhase::Invalid);
															#line 515 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6392 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->actor_wait_state = 2;
															#line 515 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestGetAuditStateWhenNoOngingAuditForTypeActor, 1, std::vector<AuditStorageState> >*>(static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)));
															#line 6397 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<AuditStorageState> && res1,int loopDepth) 
	{
															#line 512 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (res1.size() > 1)
															#line 6406 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		{
															#line 513 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			TraceEvent(SevError, "TestGetAuditStatesError").detail("ActualResSize", res1.size());
															#line 6410 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		}
															#line 515 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<std::vector<AuditStorageState>> __when_expr_1 = getAuditStates(cx, type, true, CLIENT_KNOBS->TOO_MANY, AuditPhase::Invalid);
															#line 515 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6416 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->actor_wait_state = 2;
															#line 515 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestGetAuditStateWhenNoOngingAuditForTypeActor, 1, std::vector<AuditStorageState> >*>(static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)));
															#line 6421 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<AuditStorageState> const& res1,int loopDepth) 
	{
		loopDepth = a_body1cont1(res1, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<AuditStorageState> && res1,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(res1), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->actor_wait_state > 0) static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->actor_wait_state = 0;
		static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->ActorCallback< TestGetAuditStateWhenNoOngingAuditForTypeActor, 0, std::vector<AuditStorageState> >::remove();

	}
	void a_callback_fire(ActorCallback< TestGetAuditStateWhenNoOngingAuditForTypeActor, 0, std::vector<AuditStorageState> >*,std::vector<AuditStorageState> const& value) 
	{
		fdb_probe_actor_enter("testGetAuditStateWhenNoOngingAuditForType", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetAuditStateWhenNoOngingAuditForType", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestGetAuditStateWhenNoOngingAuditForTypeActor, 0, std::vector<AuditStorageState> >*,std::vector<AuditStorageState> && value) 
	{
		fdb_probe_actor_enter("testGetAuditStateWhenNoOngingAuditForType", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetAuditStateWhenNoOngingAuditForType", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestGetAuditStateWhenNoOngingAuditForTypeActor, 0, std::vector<AuditStorageState> >*,Error err) 
	{
		fdb_probe_actor_enter("testGetAuditStateWhenNoOngingAuditForType", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetAuditStateWhenNoOngingAuditForType", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(std::vector<AuditStorageState> const& res2,int loopDepth) 
	{
															#line 517 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (res2.size() != 0)
															#line 6505 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		{
															#line 518 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			TraceEvent(SevError, "TestExistingInvalidAudit") .detail("ActualResSize", res2.size()) .detail("InputPhase", AuditPhase::Invalid);
															#line 6509 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		}
															#line 522 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<std::vector<AuditStorageState>> __when_expr_2 = getAuditStates(cx, type, true, CLIENT_KNOBS->TOO_MANY, AuditPhase::Running);
															#line 522 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6515 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->actor_wait_state = 3;
															#line 522 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestGetAuditStateWhenNoOngingAuditForTypeActor, 2, std::vector<AuditStorageState> >*>(static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)));
															#line 6520 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(std::vector<AuditStorageState> && res2,int loopDepth) 
	{
															#line 517 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (res2.size() != 0)
															#line 6529 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		{
															#line 518 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			TraceEvent(SevError, "TestExistingInvalidAudit") .detail("ActualResSize", res2.size()) .detail("InputPhase", AuditPhase::Invalid);
															#line 6533 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		}
															#line 522 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<std::vector<AuditStorageState>> __when_expr_2 = getAuditStates(cx, type, true, CLIENT_KNOBS->TOO_MANY, AuditPhase::Running);
															#line 522 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6539 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->actor_wait_state = 3;
															#line 522 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestGetAuditStateWhenNoOngingAuditForTypeActor, 2, std::vector<AuditStorageState> >*>(static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)));
															#line 6544 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<AuditStorageState> const& res2,int loopDepth) 
	{
		loopDepth = a_body1cont2(res2, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<AuditStorageState> && res2,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(res2), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->actor_wait_state > 0) static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->actor_wait_state = 0;
		static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->ActorCallback< TestGetAuditStateWhenNoOngingAuditForTypeActor, 1, std::vector<AuditStorageState> >::remove();

	}
	void a_callback_fire(ActorCallback< TestGetAuditStateWhenNoOngingAuditForTypeActor, 1, std::vector<AuditStorageState> >*,std::vector<AuditStorageState> const& value) 
	{
		fdb_probe_actor_enter("testGetAuditStateWhenNoOngingAuditForType", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetAuditStateWhenNoOngingAuditForType", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestGetAuditStateWhenNoOngingAuditForTypeActor, 1, std::vector<AuditStorageState> >*,std::vector<AuditStorageState> && value) 
	{
		fdb_probe_actor_enter("testGetAuditStateWhenNoOngingAuditForType", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetAuditStateWhenNoOngingAuditForType", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestGetAuditStateWhenNoOngingAuditForTypeActor, 1, std::vector<AuditStorageState> >*,Error err) 
	{
		fdb_probe_actor_enter("testGetAuditStateWhenNoOngingAuditForType", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetAuditStateWhenNoOngingAuditForType", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(std::vector<AuditStorageState> const& res3,int loopDepth) 
	{
															#line 524 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (res3.size() != 0)
															#line 6628 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		{
															#line 525 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			TraceEvent(SevError, "TestExistingRunningAudit") .detail("ActualResSize", res3.size()) .detail("InputPhase", AuditPhase::Running);
															#line 6632 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		}
															#line 529 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<std::vector<AuditStorageState>> __when_expr_3 = getAuditStates(cx, type, true, CLIENT_KNOBS->TOO_MANY, AuditPhase::Complete);
															#line 529 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6638 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->actor_wait_state = 4;
															#line 529 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestGetAuditStateWhenNoOngingAuditForTypeActor, 3, std::vector<AuditStorageState> >*>(static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)));
															#line 6643 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(std::vector<AuditStorageState> && res3,int loopDepth) 
	{
															#line 524 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (res3.size() != 0)
															#line 6652 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		{
															#line 525 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			TraceEvent(SevError, "TestExistingRunningAudit") .detail("ActualResSize", res3.size()) .detail("InputPhase", AuditPhase::Running);
															#line 6656 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		}
															#line 529 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<std::vector<AuditStorageState>> __when_expr_3 = getAuditStates(cx, type, true, CLIENT_KNOBS->TOO_MANY, AuditPhase::Complete);
															#line 529 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6662 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->actor_wait_state = 4;
															#line 529 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestGetAuditStateWhenNoOngingAuditForTypeActor, 3, std::vector<AuditStorageState> >*>(static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)));
															#line 6667 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<AuditStorageState> const& res3,int loopDepth) 
	{
		loopDepth = a_body1cont4(res3, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<AuditStorageState> && res3,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(res3), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->actor_wait_state > 0) static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->actor_wait_state = 0;
		static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->ActorCallback< TestGetAuditStateWhenNoOngingAuditForTypeActor, 2, std::vector<AuditStorageState> >::remove();

	}
	void a_callback_fire(ActorCallback< TestGetAuditStateWhenNoOngingAuditForTypeActor, 2, std::vector<AuditStorageState> >*,std::vector<AuditStorageState> const& value) 
	{
		fdb_probe_actor_enter("testGetAuditStateWhenNoOngingAuditForType", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetAuditStateWhenNoOngingAuditForType", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestGetAuditStateWhenNoOngingAuditForTypeActor, 2, std::vector<AuditStorageState> >*,std::vector<AuditStorageState> && value) 
	{
		fdb_probe_actor_enter("testGetAuditStateWhenNoOngingAuditForType", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetAuditStateWhenNoOngingAuditForType", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestGetAuditStateWhenNoOngingAuditForTypeActor, 2, std::vector<AuditStorageState> >*,Error err) 
	{
		fdb_probe_actor_enter("testGetAuditStateWhenNoOngingAuditForType", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetAuditStateWhenNoOngingAuditForType", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(std::vector<AuditStorageState> const& res4,int loopDepth) 
	{
															#line 531 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		for( const auto& auditState : res4 ) {
															#line 532 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			if (auditState.getPhase() != AuditPhase::Complete)
															#line 6753 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			{
															#line 533 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
				TraceEvent(SevError, "TestGetAuditStatesByPhaseError") .detail("ActualPhase", auditState.getPhase()) .detail("InputPhase", AuditPhase::Complete);
															#line 6757 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			}
		}
															#line 538 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<std::vector<AuditStorageState>> __when_expr_4 = getAuditStates(cx, type, true, CLIENT_KNOBS->TOO_MANY, AuditPhase::Failed);
															#line 538 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6764 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont6when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->actor_wait_state = 5;
															#line 538 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestGetAuditStateWhenNoOngingAuditForTypeActor, 4, std::vector<AuditStorageState> >*>(static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)));
															#line 6769 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(std::vector<AuditStorageState> && res4,int loopDepth) 
	{
															#line 531 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		for( const auto& auditState : res4 ) {
															#line 532 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			if (auditState.getPhase() != AuditPhase::Complete)
															#line 6780 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			{
															#line 533 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
				TraceEvent(SevError, "TestGetAuditStatesByPhaseError") .detail("ActualPhase", auditState.getPhase()) .detail("InputPhase", AuditPhase::Complete);
															#line 6784 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			}
		}
															#line 538 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<std::vector<AuditStorageState>> __when_expr_4 = getAuditStates(cx, type, true, CLIENT_KNOBS->TOO_MANY, AuditPhase::Failed);
															#line 538 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6791 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont6when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->actor_wait_state = 5;
															#line 538 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestGetAuditStateWhenNoOngingAuditForTypeActor, 4, std::vector<AuditStorageState> >*>(static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)));
															#line 6796 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(std::vector<AuditStorageState> const& res4,int loopDepth) 
	{
		loopDepth = a_body1cont6(res4, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(std::vector<AuditStorageState> && res4,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(res4), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->actor_wait_state > 0) static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->actor_wait_state = 0;
		static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->ActorCallback< TestGetAuditStateWhenNoOngingAuditForTypeActor, 3, std::vector<AuditStorageState> >::remove();

	}
	void a_callback_fire(ActorCallback< TestGetAuditStateWhenNoOngingAuditForTypeActor, 3, std::vector<AuditStorageState> >*,std::vector<AuditStorageState> const& value) 
	{
		fdb_probe_actor_enter("testGetAuditStateWhenNoOngingAuditForType", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetAuditStateWhenNoOngingAuditForType", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestGetAuditStateWhenNoOngingAuditForTypeActor, 3, std::vector<AuditStorageState> >*,std::vector<AuditStorageState> && value) 
	{
		fdb_probe_actor_enter("testGetAuditStateWhenNoOngingAuditForType", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetAuditStateWhenNoOngingAuditForType", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestGetAuditStateWhenNoOngingAuditForTypeActor, 3, std::vector<AuditStorageState> >*,Error err) 
	{
		fdb_probe_actor_enter("testGetAuditStateWhenNoOngingAuditForType", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetAuditStateWhenNoOngingAuditForType", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont8(std::vector<AuditStorageState> const& res5,int loopDepth) 
	{
															#line 540 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		for( const auto& auditState : res5 ) {
															#line 541 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			if (auditState.getPhase() != AuditPhase::Failed)
															#line 6882 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			{
															#line 542 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
				TraceEvent(SevError, "TestGetAuditStatesByPhaseError") .detail("ActualPhase", auditState.getPhase()) .detail("InputPhase", AuditPhase::Failed);
															#line 6886 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			}
		}
															#line 547 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<std::vector<AuditStorageState>> __when_expr_5 = getAuditStates(cx, type, true, CLIENT_KNOBS->TOO_MANY, AuditPhase::Error);
															#line 547 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6893 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont8when1(__when_expr_5.get(), loopDepth); };
		static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->actor_wait_state = 6;
															#line 547 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< TestGetAuditStateWhenNoOngingAuditForTypeActor, 5, std::vector<AuditStorageState> >*>(static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)));
															#line 6898 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8(std::vector<AuditStorageState> && res5,int loopDepth) 
	{
															#line 540 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		for( const auto& auditState : res5 ) {
															#line 541 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			if (auditState.getPhase() != AuditPhase::Failed)
															#line 6909 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			{
															#line 542 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
				TraceEvent(SevError, "TestGetAuditStatesByPhaseError") .detail("ActualPhase", auditState.getPhase()) .detail("InputPhase", AuditPhase::Failed);
															#line 6913 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			}
		}
															#line 547 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<std::vector<AuditStorageState>> __when_expr_5 = getAuditStates(cx, type, true, CLIENT_KNOBS->TOO_MANY, AuditPhase::Error);
															#line 547 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6920 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont8when1(__when_expr_5.get(), loopDepth); };
		static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->actor_wait_state = 6;
															#line 547 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< TestGetAuditStateWhenNoOngingAuditForTypeActor, 5, std::vector<AuditStorageState> >*>(static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)));
															#line 6925 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6when1(std::vector<AuditStorageState> const& res5,int loopDepth) 
	{
		loopDepth = a_body1cont8(res5, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(std::vector<AuditStorageState> && res5,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(res5), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->actor_wait_state > 0) static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->actor_wait_state = 0;
		static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->ActorCallback< TestGetAuditStateWhenNoOngingAuditForTypeActor, 4, std::vector<AuditStorageState> >::remove();

	}
	void a_callback_fire(ActorCallback< TestGetAuditStateWhenNoOngingAuditForTypeActor, 4, std::vector<AuditStorageState> >*,std::vector<AuditStorageState> const& value) 
	{
		fdb_probe_actor_enter("testGetAuditStateWhenNoOngingAuditForType", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetAuditStateWhenNoOngingAuditForType", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TestGetAuditStateWhenNoOngingAuditForTypeActor, 4, std::vector<AuditStorageState> >*,std::vector<AuditStorageState> && value) 
	{
		fdb_probe_actor_enter("testGetAuditStateWhenNoOngingAuditForType", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetAuditStateWhenNoOngingAuditForType", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TestGetAuditStateWhenNoOngingAuditForTypeActor, 4, std::vector<AuditStorageState> >*,Error err) 
	{
		fdb_probe_actor_enter("testGetAuditStateWhenNoOngingAuditForType", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetAuditStateWhenNoOngingAuditForType", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont11(std::vector<AuditStorageState> const& res6,int loopDepth) 
	{
															#line 549 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		for( const auto& auditState : res6 ) {
															#line 550 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			if (auditState.getPhase() != AuditPhase::Error)
															#line 7011 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			{
															#line 551 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
				TraceEvent(SevError, "TestGetAuditStatesByPhaseError") .detail("ActualPhase", auditState.getPhase()) .detail("InputPhase", AuditPhase::Error);
															#line 7015 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			}
		}
															#line 556 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestGetAuditStateEnd").detail("AuditType", type);
															#line 557 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (!static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestGetAuditStateWhenNoOngingAuditForTypeActorState(); static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->destroy(); return 0; }
															#line 7022 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		new (&static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestGetAuditStateWhenNoOngingAuditForTypeActorState();
		static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont11(std::vector<AuditStorageState> && res6,int loopDepth) 
	{
															#line 549 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		for( const auto& auditState : res6 ) {
															#line 550 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			if (auditState.getPhase() != AuditPhase::Error)
															#line 7036 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			{
															#line 551 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
				TraceEvent(SevError, "TestGetAuditStatesByPhaseError") .detail("ActualPhase", auditState.getPhase()) .detail("InputPhase", AuditPhase::Error);
															#line 7040 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			}
		}
															#line 556 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestGetAuditStateEnd").detail("AuditType", type);
															#line 557 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (!static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestGetAuditStateWhenNoOngingAuditForTypeActorState(); static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->destroy(); return 0; }
															#line 7047 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		new (&static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestGetAuditStateWhenNoOngingAuditForTypeActorState();
		static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8when1(std::vector<AuditStorageState> const& res6,int loopDepth) 
	{
		loopDepth = a_body1cont11(res6, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(std::vector<AuditStorageState> && res6,int loopDepth) 
	{
		loopDepth = a_body1cont11(std::move(res6), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->actor_wait_state > 0) static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->actor_wait_state = 0;
		static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->ActorCallback< TestGetAuditStateWhenNoOngingAuditForTypeActor, 5, std::vector<AuditStorageState> >::remove();

	}
	void a_callback_fire(ActorCallback< TestGetAuditStateWhenNoOngingAuditForTypeActor, 5, std::vector<AuditStorageState> >*,std::vector<AuditStorageState> const& value) 
	{
		fdb_probe_actor_enter("testGetAuditStateWhenNoOngingAuditForType", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetAuditStateWhenNoOngingAuditForType", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< TestGetAuditStateWhenNoOngingAuditForTypeActor, 5, std::vector<AuditStorageState> >*,std::vector<AuditStorageState> && value) 
	{
		fdb_probe_actor_enter("testGetAuditStateWhenNoOngingAuditForType", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetAuditStateWhenNoOngingAuditForType", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< TestGetAuditStateWhenNoOngingAuditForTypeActor, 5, std::vector<AuditStorageState> >*,Error err) 
	{
		fdb_probe_actor_enter("testGetAuditStateWhenNoOngingAuditForType", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetAuditStateWhenNoOngingAuditForType", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 509 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	ValidateStorage* self;
															#line 509 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	Database cx;
															#line 509 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	AuditType type;
															#line 7136 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
};
// This generated class is to be used only via testGetAuditStateWhenNoOngingAuditForType()
															#line 509 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
class TestGetAuditStateWhenNoOngingAuditForTypeActor final : public Actor<Void>, public ActorCallback< TestGetAuditStateWhenNoOngingAuditForTypeActor, 0, std::vector<AuditStorageState> >, public ActorCallback< TestGetAuditStateWhenNoOngingAuditForTypeActor, 1, std::vector<AuditStorageState> >, public ActorCallback< TestGetAuditStateWhenNoOngingAuditForTypeActor, 2, std::vector<AuditStorageState> >, public ActorCallback< TestGetAuditStateWhenNoOngingAuditForTypeActor, 3, std::vector<AuditStorageState> >, public ActorCallback< TestGetAuditStateWhenNoOngingAuditForTypeActor, 4, std::vector<AuditStorageState> >, public ActorCallback< TestGetAuditStateWhenNoOngingAuditForTypeActor, 5, std::vector<AuditStorageState> >, public FastAllocated<TestGetAuditStateWhenNoOngingAuditForTypeActor>, public TestGetAuditStateWhenNoOngingAuditForTypeActorState<TestGetAuditStateWhenNoOngingAuditForTypeActor> {
															#line 7141 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
public:
	using FastAllocated<TestGetAuditStateWhenNoOngingAuditForTypeActor>::operator new;
	using FastAllocated<TestGetAuditStateWhenNoOngingAuditForTypeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10376045304554846976UL, 16353540190050586112UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestGetAuditStateWhenNoOngingAuditForTypeActor, 0, std::vector<AuditStorageState> >;
friend struct ActorCallback< TestGetAuditStateWhenNoOngingAuditForTypeActor, 1, std::vector<AuditStorageState> >;
friend struct ActorCallback< TestGetAuditStateWhenNoOngingAuditForTypeActor, 2, std::vector<AuditStorageState> >;
friend struct ActorCallback< TestGetAuditStateWhenNoOngingAuditForTypeActor, 3, std::vector<AuditStorageState> >;
friend struct ActorCallback< TestGetAuditStateWhenNoOngingAuditForTypeActor, 4, std::vector<AuditStorageState> >;
friend struct ActorCallback< TestGetAuditStateWhenNoOngingAuditForTypeActor, 5, std::vector<AuditStorageState> >;
															#line 509 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	TestGetAuditStateWhenNoOngingAuditForTypeActor(ValidateStorage* const& self,Database const& cx,AuditType const& type) 
															#line 7163 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		 : Actor<Void>(),
		   TestGetAuditStateWhenNoOngingAuditForTypeActorState<TestGetAuditStateWhenNoOngingAuditForTypeActor>(self, cx, type),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testGetAuditStateWhenNoOngingAuditForType", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8877047082798320640UL, 7278035688999622912UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetAuditStateWhenNoOngingAuditForTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testGetAuditStateWhenNoOngingAuditForType");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testGetAuditStateWhenNoOngingAuditForType", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestGetAuditStateWhenNoOngingAuditForTypeActor, 0, std::vector<AuditStorageState> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestGetAuditStateWhenNoOngingAuditForTypeActor, 1, std::vector<AuditStorageState> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestGetAuditStateWhenNoOngingAuditForTypeActor, 2, std::vector<AuditStorageState> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TestGetAuditStateWhenNoOngingAuditForTypeActor, 3, std::vector<AuditStorageState> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TestGetAuditStateWhenNoOngingAuditForTypeActor, 4, std::vector<AuditStorageState> >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< TestGetAuditStateWhenNoOngingAuditForTypeActor, 5, std::vector<AuditStorageState> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 509 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
[[nodiscard]] Future<Void> testGetAuditStateWhenNoOngingAuditForType( ValidateStorage* const& self, Database const& cx, AuditType const& type ) {
															#line 509 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	return Future<Void>(new TestGetAuditStateWhenNoOngingAuditForTypeActor(self, cx, type));
															#line 7200 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
}

#line 559 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"

																#line 7205 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
// This generated class is to be used only via testGetAuditStateWhenNoOngingAudit()
															#line 560 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
template <class TestGetAuditStateWhenNoOngingAuditActor>
															#line 560 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
class TestGetAuditStateWhenNoOngingAuditActorState {
															#line 7211 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
public:
															#line 560 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	TestGetAuditStateWhenNoOngingAuditActorState(ValidateStorage* const& self,Database const& cx) 
															#line 560 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
															#line 560 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		 : self(self),
															#line 560 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		   cx(cx)
															#line 7220 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
	{
		fdb_probe_actor_create("testGetAuditStateWhenNoOngingAudit", reinterpret_cast<unsigned long>(this));

	}
	~TestGetAuditStateWhenNoOngingAuditActorState() 
	{
		fdb_probe_actor_destroy("testGetAuditStateWhenNoOngingAudit", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 561 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->testGetAuditStateWhenNoOngingAuditForType(self, cx, AuditType::ValidateHA);
															#line 561 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			if (static_cast<TestGetAuditStateWhenNoOngingAuditActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7237 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestGetAuditStateWhenNoOngingAuditActor*>(this)->actor_wait_state = 1;
															#line 561 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestGetAuditStateWhenNoOngingAuditActor, 0, Void >*>(static_cast<TestGetAuditStateWhenNoOngingAuditActor*>(this)));
															#line 7242 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestGetAuditStateWhenNoOngingAuditActorState();
		static_cast<TestGetAuditStateWhenNoOngingAuditActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 562 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestGetAuditStateHADone");
															#line 564 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->testGetAuditStateWhenNoOngingAuditForType(self, cx, AuditType::ValidateReplica);
															#line 564 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<TestGetAuditStateWhenNoOngingAuditActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7269 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestGetAuditStateWhenNoOngingAuditActor*>(this)->actor_wait_state = 2;
															#line 564 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestGetAuditStateWhenNoOngingAuditActor, 1, Void >*>(static_cast<TestGetAuditStateWhenNoOngingAuditActor*>(this)));
															#line 7274 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 562 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestGetAuditStateHADone");
															#line 564 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->testGetAuditStateWhenNoOngingAuditForType(self, cx, AuditType::ValidateReplica);
															#line 564 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<TestGetAuditStateWhenNoOngingAuditActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7287 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestGetAuditStateWhenNoOngingAuditActor*>(this)->actor_wait_state = 2;
															#line 564 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestGetAuditStateWhenNoOngingAuditActor, 1, Void >*>(static_cast<TestGetAuditStateWhenNoOngingAuditActor*>(this)));
															#line 7292 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestGetAuditStateWhenNoOngingAuditActor*>(this)->actor_wait_state > 0) static_cast<TestGetAuditStateWhenNoOngingAuditActor*>(this)->actor_wait_state = 0;
		static_cast<TestGetAuditStateWhenNoOngingAuditActor*>(this)->ActorCallback< TestGetAuditStateWhenNoOngingAuditActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestGetAuditStateWhenNoOngingAuditActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testGetAuditStateWhenNoOngingAudit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetAuditStateWhenNoOngingAuditActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetAuditStateWhenNoOngingAudit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestGetAuditStateWhenNoOngingAuditActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testGetAuditStateWhenNoOngingAudit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetAuditStateWhenNoOngingAuditActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetAuditStateWhenNoOngingAudit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestGetAuditStateWhenNoOngingAuditActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testGetAuditStateWhenNoOngingAudit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetAuditStateWhenNoOngingAuditActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetAuditStateWhenNoOngingAudit", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 565 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestGetAuditStateReplicaDone");
															#line 567 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->testGetAuditStateWhenNoOngingAuditForType(self, cx, AuditType::ValidateLocationMetadata);
															#line 567 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<TestGetAuditStateWhenNoOngingAuditActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7380 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestGetAuditStateWhenNoOngingAuditActor*>(this)->actor_wait_state = 3;
															#line 567 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestGetAuditStateWhenNoOngingAuditActor, 2, Void >*>(static_cast<TestGetAuditStateWhenNoOngingAuditActor*>(this)));
															#line 7385 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 565 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestGetAuditStateReplicaDone");
															#line 567 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->testGetAuditStateWhenNoOngingAuditForType(self, cx, AuditType::ValidateLocationMetadata);
															#line 567 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<TestGetAuditStateWhenNoOngingAuditActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7398 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestGetAuditStateWhenNoOngingAuditActor*>(this)->actor_wait_state = 3;
															#line 567 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestGetAuditStateWhenNoOngingAuditActor, 2, Void >*>(static_cast<TestGetAuditStateWhenNoOngingAuditActor*>(this)));
															#line 7403 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestGetAuditStateWhenNoOngingAuditActor*>(this)->actor_wait_state > 0) static_cast<TestGetAuditStateWhenNoOngingAuditActor*>(this)->actor_wait_state = 0;
		static_cast<TestGetAuditStateWhenNoOngingAuditActor*>(this)->ActorCallback< TestGetAuditStateWhenNoOngingAuditActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestGetAuditStateWhenNoOngingAuditActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testGetAuditStateWhenNoOngingAudit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetAuditStateWhenNoOngingAuditActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetAuditStateWhenNoOngingAudit", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestGetAuditStateWhenNoOngingAuditActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testGetAuditStateWhenNoOngingAudit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetAuditStateWhenNoOngingAuditActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetAuditStateWhenNoOngingAudit", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestGetAuditStateWhenNoOngingAuditActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testGetAuditStateWhenNoOngingAudit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetAuditStateWhenNoOngingAuditActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetAuditStateWhenNoOngingAudit", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 568 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestGetAuditStateShardLocationMetadataDone");
															#line 570 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->testGetAuditStateWhenNoOngingAuditForType(self, cx, AuditType::ValidateStorageServerShard);
															#line 570 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<TestGetAuditStateWhenNoOngingAuditActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7491 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestGetAuditStateWhenNoOngingAuditActor*>(this)->actor_wait_state = 4;
															#line 570 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestGetAuditStateWhenNoOngingAuditActor, 3, Void >*>(static_cast<TestGetAuditStateWhenNoOngingAuditActor*>(this)));
															#line 7496 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 568 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestGetAuditStateShardLocationMetadataDone");
															#line 570 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->testGetAuditStateWhenNoOngingAuditForType(self, cx, AuditType::ValidateStorageServerShard);
															#line 570 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<TestGetAuditStateWhenNoOngingAuditActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7509 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestGetAuditStateWhenNoOngingAuditActor*>(this)->actor_wait_state = 4;
															#line 570 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestGetAuditStateWhenNoOngingAuditActor, 3, Void >*>(static_cast<TestGetAuditStateWhenNoOngingAuditActor*>(this)));
															#line 7514 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestGetAuditStateWhenNoOngingAuditActor*>(this)->actor_wait_state > 0) static_cast<TestGetAuditStateWhenNoOngingAuditActor*>(this)->actor_wait_state = 0;
		static_cast<TestGetAuditStateWhenNoOngingAuditActor*>(this)->ActorCallback< TestGetAuditStateWhenNoOngingAuditActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestGetAuditStateWhenNoOngingAuditActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testGetAuditStateWhenNoOngingAudit", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetAuditStateWhenNoOngingAuditActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetAuditStateWhenNoOngingAudit", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestGetAuditStateWhenNoOngingAuditActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testGetAuditStateWhenNoOngingAudit", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetAuditStateWhenNoOngingAuditActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetAuditStateWhenNoOngingAudit", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestGetAuditStateWhenNoOngingAuditActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testGetAuditStateWhenNoOngingAudit", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetAuditStateWhenNoOngingAuditActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetAuditStateWhenNoOngingAudit", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 571 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestGetAuditStateSSShardInfoDone");
															#line 572 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (!static_cast<TestGetAuditStateWhenNoOngingAuditActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestGetAuditStateWhenNoOngingAuditActorState(); static_cast<TestGetAuditStateWhenNoOngingAuditActor*>(this)->destroy(); return 0; }
															#line 7600 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		new (&static_cast<TestGetAuditStateWhenNoOngingAuditActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestGetAuditStateWhenNoOngingAuditActorState();
		static_cast<TestGetAuditStateWhenNoOngingAuditActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 571 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestGetAuditStateSSShardInfoDone");
															#line 572 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (!static_cast<TestGetAuditStateWhenNoOngingAuditActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestGetAuditStateWhenNoOngingAuditActorState(); static_cast<TestGetAuditStateWhenNoOngingAuditActor*>(this)->destroy(); return 0; }
															#line 7614 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		new (&static_cast<TestGetAuditStateWhenNoOngingAuditActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestGetAuditStateWhenNoOngingAuditActorState();
		static_cast<TestGetAuditStateWhenNoOngingAuditActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TestGetAuditStateWhenNoOngingAuditActor*>(this)->actor_wait_state > 0) static_cast<TestGetAuditStateWhenNoOngingAuditActor*>(this)->actor_wait_state = 0;
		static_cast<TestGetAuditStateWhenNoOngingAuditActor*>(this)->ActorCallback< TestGetAuditStateWhenNoOngingAuditActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestGetAuditStateWhenNoOngingAuditActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testGetAuditStateWhenNoOngingAudit", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetAuditStateWhenNoOngingAuditActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetAuditStateWhenNoOngingAudit", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestGetAuditStateWhenNoOngingAuditActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testGetAuditStateWhenNoOngingAudit", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetAuditStateWhenNoOngingAuditActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetAuditStateWhenNoOngingAudit", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestGetAuditStateWhenNoOngingAuditActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testGetAuditStateWhenNoOngingAudit", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetAuditStateWhenNoOngingAuditActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetAuditStateWhenNoOngingAudit", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 560 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	ValidateStorage* self;
															#line 560 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	Database cx;
															#line 7701 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
};
// This generated class is to be used only via testGetAuditStateWhenNoOngingAudit()
															#line 560 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
class TestGetAuditStateWhenNoOngingAuditActor final : public Actor<Void>, public ActorCallback< TestGetAuditStateWhenNoOngingAuditActor, 0, Void >, public ActorCallback< TestGetAuditStateWhenNoOngingAuditActor, 1, Void >, public ActorCallback< TestGetAuditStateWhenNoOngingAuditActor, 2, Void >, public ActorCallback< TestGetAuditStateWhenNoOngingAuditActor, 3, Void >, public FastAllocated<TestGetAuditStateWhenNoOngingAuditActor>, public TestGetAuditStateWhenNoOngingAuditActorState<TestGetAuditStateWhenNoOngingAuditActor> {
															#line 7706 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
public:
	using FastAllocated<TestGetAuditStateWhenNoOngingAuditActor>::operator new;
	using FastAllocated<TestGetAuditStateWhenNoOngingAuditActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8204722207345362944UL, 647564240482696448UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestGetAuditStateWhenNoOngingAuditActor, 0, Void >;
friend struct ActorCallback< TestGetAuditStateWhenNoOngingAuditActor, 1, Void >;
friend struct ActorCallback< TestGetAuditStateWhenNoOngingAuditActor, 2, Void >;
friend struct ActorCallback< TestGetAuditStateWhenNoOngingAuditActor, 3, Void >;
															#line 560 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	TestGetAuditStateWhenNoOngingAuditActor(ValidateStorage* const& self,Database const& cx) 
															#line 7726 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		 : Actor<Void>(),
		   TestGetAuditStateWhenNoOngingAuditActorState<TestGetAuditStateWhenNoOngingAuditActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testGetAuditStateWhenNoOngingAudit", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11570656439990113536UL, 10249034376700571904UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetAuditStateWhenNoOngingAuditActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testGetAuditStateWhenNoOngingAudit");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testGetAuditStateWhenNoOngingAudit", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestGetAuditStateWhenNoOngingAuditActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestGetAuditStateWhenNoOngingAuditActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestGetAuditStateWhenNoOngingAuditActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TestGetAuditStateWhenNoOngingAuditActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 560 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
[[nodiscard]] Future<Void> testGetAuditStateWhenNoOngingAudit( ValidateStorage* const& self, Database const& cx ) {
															#line 560 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	return Future<Void>(new TestGetAuditStateWhenNoOngingAuditActor(self, cx));
															#line 7761 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
}

#line 574 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"

																#line 7766 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
// This generated class is to be used only via testAuditStorageConcurrentRunForDifferentType()
															#line 575 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
template <class TestAuditStorageConcurrentRunForDifferentTypeActor>
															#line 575 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
class TestAuditStorageConcurrentRunForDifferentTypeActorState {
															#line 7772 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
public:
															#line 575 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	TestAuditStorageConcurrentRunForDifferentTypeActorState(ValidateStorage* const& self,Database const& cx) 
															#line 575 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
															#line 575 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		 : self(self),
															#line 575 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		   cx(cx)
															#line 7781 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
	{
		fdb_probe_actor_create("testAuditStorageConcurrentRunForDifferentType", reinterpret_cast<unsigned long>(this));

	}
	~TestAuditStorageConcurrentRunForDifferentTypeActorState() 
	{
		fdb_probe_actor_destroy("testAuditStorageConcurrentRunForDifferentType", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 576 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			TraceEvent("TestAuditStorageConcurrentRunForDifferentTypeBegin");
															#line 577 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			fs = std::vector<Future<Void>>();
															#line 578 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			auditIds = { UID(), UID(), UID(), UID() };
															#line 579 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			fs.push_back( store(auditIds[0], self->auditStorageForType(self, cx, AuditType::ValidateHA, "TestConcurrentRunForDifferentType")));
															#line 582 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			fs.push_back(store( auditIds[1], self->auditStorageForType(self, cx, AuditType::ValidateReplica, "TestConcurrentRunForDifferentType")));
															#line 585 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			fs.push_back(store(auditIds[2], self->auditStorageForType( self, cx, AuditType::ValidateLocationMetadata, "TestConcurrentRunForDifferentType")));
															#line 588 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			fs.push_back(store(auditIds[3], self->auditStorageForType( self, cx, AuditType::ValidateStorageServerShard, "TestConcurrentRunForDifferentType")));
															#line 591 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(fs);
															#line 591 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			if (static_cast<TestAuditStorageConcurrentRunForDifferentTypeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7812 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestAuditStorageConcurrentRunForDifferentTypeActor*>(this)->actor_wait_state = 1;
															#line 591 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestAuditStorageConcurrentRunForDifferentTypeActor, 0, Void >*>(static_cast<TestAuditStorageConcurrentRunForDifferentTypeActor*>(this)));
															#line 7817 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestAuditStorageConcurrentRunForDifferentTypeActorState();
		static_cast<TestAuditStorageConcurrentRunForDifferentTypeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 592 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		fs.clear();
															#line 593 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestAuditStorageConcurrentRunForDifferentTypeEnd");
															#line 594 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (!static_cast<TestAuditStorageConcurrentRunForDifferentTypeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestAuditStorageConcurrentRunForDifferentTypeActorState(); static_cast<TestAuditStorageConcurrentRunForDifferentTypeActor*>(this)->destroy(); return 0; }
															#line 7844 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		new (&static_cast<TestAuditStorageConcurrentRunForDifferentTypeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestAuditStorageConcurrentRunForDifferentTypeActorState();
		static_cast<TestAuditStorageConcurrentRunForDifferentTypeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 592 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		fs.clear();
															#line 593 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestAuditStorageConcurrentRunForDifferentTypeEnd");
															#line 594 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (!static_cast<TestAuditStorageConcurrentRunForDifferentTypeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestAuditStorageConcurrentRunForDifferentTypeActorState(); static_cast<TestAuditStorageConcurrentRunForDifferentTypeActor*>(this)->destroy(); return 0; }
															#line 7860 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		new (&static_cast<TestAuditStorageConcurrentRunForDifferentTypeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestAuditStorageConcurrentRunForDifferentTypeActorState();
		static_cast<TestAuditStorageConcurrentRunForDifferentTypeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestAuditStorageConcurrentRunForDifferentTypeActor*>(this)->actor_wait_state > 0) static_cast<TestAuditStorageConcurrentRunForDifferentTypeActor*>(this)->actor_wait_state = 0;
		static_cast<TestAuditStorageConcurrentRunForDifferentTypeActor*>(this)->ActorCallback< TestAuditStorageConcurrentRunForDifferentTypeActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestAuditStorageConcurrentRunForDifferentTypeActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testAuditStorageConcurrentRunForDifferentType", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageConcurrentRunForDifferentTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageConcurrentRunForDifferentType", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestAuditStorageConcurrentRunForDifferentTypeActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testAuditStorageConcurrentRunForDifferentType", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageConcurrentRunForDifferentTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageConcurrentRunForDifferentType", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestAuditStorageConcurrentRunForDifferentTypeActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testAuditStorageConcurrentRunForDifferentType", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageConcurrentRunForDifferentTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageConcurrentRunForDifferentType", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 575 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	ValidateStorage* self;
															#line 575 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	Database cx;
															#line 577 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	std::vector<Future<Void>> fs;
															#line 578 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	std::vector<UID> auditIds;
															#line 7951 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
};
// This generated class is to be used only via testAuditStorageConcurrentRunForDifferentType()
															#line 575 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
class TestAuditStorageConcurrentRunForDifferentTypeActor final : public Actor<Void>, public ActorCallback< TestAuditStorageConcurrentRunForDifferentTypeActor, 0, Void >, public FastAllocated<TestAuditStorageConcurrentRunForDifferentTypeActor>, public TestAuditStorageConcurrentRunForDifferentTypeActorState<TestAuditStorageConcurrentRunForDifferentTypeActor> {
															#line 7956 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
public:
	using FastAllocated<TestAuditStorageConcurrentRunForDifferentTypeActor>::operator new;
	using FastAllocated<TestAuditStorageConcurrentRunForDifferentTypeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12233549969452974336UL, 9688404398879041024UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestAuditStorageConcurrentRunForDifferentTypeActor, 0, Void >;
															#line 575 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	TestAuditStorageConcurrentRunForDifferentTypeActor(ValidateStorage* const& self,Database const& cx) 
															#line 7973 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		 : Actor<Void>(),
		   TestAuditStorageConcurrentRunForDifferentTypeActorState<TestAuditStorageConcurrentRunForDifferentTypeActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testAuditStorageConcurrentRunForDifferentType", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6423685946482828288UL, 18342744862626946816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageConcurrentRunForDifferentTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testAuditStorageConcurrentRunForDifferentType");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testAuditStorageConcurrentRunForDifferentType", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestAuditStorageConcurrentRunForDifferentTypeActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 575 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
[[nodiscard]] Future<Void> testAuditStorageConcurrentRunForDifferentType( ValidateStorage* const& self, Database const& cx ) {
															#line 575 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	return Future<Void>(new TestAuditStorageConcurrentRunForDifferentTypeActor(self, cx));
															#line 8005 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
}

#line 596 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"

																#line 8010 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
// This generated class is to be used only via testAuditStorageConcurrentRunForSameType()
															#line 597 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
template <class TestAuditStorageConcurrentRunForSameTypeActor>
															#line 597 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
class TestAuditStorageConcurrentRunForSameTypeActorState {
															#line 8016 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
public:
															#line 597 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	TestAuditStorageConcurrentRunForSameTypeActorState(ValidateStorage* const& self,Database const& cx) 
															#line 597 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
															#line 597 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		 : self(self),
															#line 597 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		   cx(cx)
															#line 8025 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
	{
		fdb_probe_actor_create("testAuditStorageConcurrentRunForSameType", reinterpret_cast<unsigned long>(this));

	}
	~TestAuditStorageConcurrentRunForSameTypeActorState() 
	{
		fdb_probe_actor_destroy("testAuditStorageConcurrentRunForSameType", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 598 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			TraceEvent("TestAuditStorageConcurrentRunForSameTypeBegin");
															#line 599 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			fs = std::vector<Future<Void>>();
															#line 600 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			auditIds = { UID(), UID(), UID(), UID() };
															#line 601 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			fs.push_back(store( auditIds[0], self->auditStorageForType( self, cx, AuditType::ValidateReplica, "TestConcurrentRunForSameType", true)));
															#line 605 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			fs.push_back(store( auditIds[1], self->auditStorageForType( self, cx, AuditType::ValidateReplica, "TestConcurrentRunForSameType", true)));
															#line 609 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			fs.push_back(store( auditIds[2], self->auditStorageForType( self, cx, AuditType::ValidateReplica, "TestConcurrentRunForSameType", true)));
															#line 613 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			fs.push_back(store( auditIds[3], self->auditStorageForType( self, cx, AuditType::ValidateReplica, "TestConcurrentRunForSameType", true)));
															#line 617 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(fs);
															#line 617 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			if (static_cast<TestAuditStorageConcurrentRunForSameTypeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8056 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestAuditStorageConcurrentRunForSameTypeActor*>(this)->actor_wait_state = 1;
															#line 617 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestAuditStorageConcurrentRunForSameTypeActor, 0, Void >*>(static_cast<TestAuditStorageConcurrentRunForSameTypeActor*>(this)));
															#line 8061 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestAuditStorageConcurrentRunForSameTypeActorState();
		static_cast<TestAuditStorageConcurrentRunForSameTypeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 618 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestAuditStorageConcurrentRunForSameTypeEnd");
															#line 619 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (!static_cast<TestAuditStorageConcurrentRunForSameTypeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestAuditStorageConcurrentRunForSameTypeActorState(); static_cast<TestAuditStorageConcurrentRunForSameTypeActor*>(this)->destroy(); return 0; }
															#line 8086 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		new (&static_cast<TestAuditStorageConcurrentRunForSameTypeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestAuditStorageConcurrentRunForSameTypeActorState();
		static_cast<TestAuditStorageConcurrentRunForSameTypeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 618 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestAuditStorageConcurrentRunForSameTypeEnd");
															#line 619 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (!static_cast<TestAuditStorageConcurrentRunForSameTypeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestAuditStorageConcurrentRunForSameTypeActorState(); static_cast<TestAuditStorageConcurrentRunForSameTypeActor*>(this)->destroy(); return 0; }
															#line 8100 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		new (&static_cast<TestAuditStorageConcurrentRunForSameTypeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestAuditStorageConcurrentRunForSameTypeActorState();
		static_cast<TestAuditStorageConcurrentRunForSameTypeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestAuditStorageConcurrentRunForSameTypeActor*>(this)->actor_wait_state > 0) static_cast<TestAuditStorageConcurrentRunForSameTypeActor*>(this)->actor_wait_state = 0;
		static_cast<TestAuditStorageConcurrentRunForSameTypeActor*>(this)->ActorCallback< TestAuditStorageConcurrentRunForSameTypeActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestAuditStorageConcurrentRunForSameTypeActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testAuditStorageConcurrentRunForSameType", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageConcurrentRunForSameTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageConcurrentRunForSameType", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestAuditStorageConcurrentRunForSameTypeActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testAuditStorageConcurrentRunForSameType", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageConcurrentRunForSameTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageConcurrentRunForSameType", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestAuditStorageConcurrentRunForSameTypeActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testAuditStorageConcurrentRunForSameType", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageConcurrentRunForSameTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageConcurrentRunForSameType", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 597 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	ValidateStorage* self;
															#line 597 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	Database cx;
															#line 599 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	std::vector<Future<Void>> fs;
															#line 600 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	std::vector<UID> auditIds;
															#line 8191 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
};
// This generated class is to be used only via testAuditStorageConcurrentRunForSameType()
															#line 597 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
class TestAuditStorageConcurrentRunForSameTypeActor final : public Actor<Void>, public ActorCallback< TestAuditStorageConcurrentRunForSameTypeActor, 0, Void >, public FastAllocated<TestAuditStorageConcurrentRunForSameTypeActor>, public TestAuditStorageConcurrentRunForSameTypeActorState<TestAuditStorageConcurrentRunForSameTypeActor> {
															#line 8196 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
public:
	using FastAllocated<TestAuditStorageConcurrentRunForSameTypeActor>::operator new;
	using FastAllocated<TestAuditStorageConcurrentRunForSameTypeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15680858401759954432UL, 6832979955582292224UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestAuditStorageConcurrentRunForSameTypeActor, 0, Void >;
															#line 597 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	TestAuditStorageConcurrentRunForSameTypeActor(ValidateStorage* const& self,Database const& cx) 
															#line 8213 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		 : Actor<Void>(),
		   TestAuditStorageConcurrentRunForSameTypeActorState<TestAuditStorageConcurrentRunForSameTypeActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testAuditStorageConcurrentRunForSameType", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12126294421179417600UL, 10546103100190542848UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageConcurrentRunForSameTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testAuditStorageConcurrentRunForSameType");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testAuditStorageConcurrentRunForSameType", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestAuditStorageConcurrentRunForSameTypeActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 597 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
[[nodiscard]] Future<Void> testAuditStorageConcurrentRunForSameType( ValidateStorage* const& self, Database const& cx ) {
															#line 597 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	return Future<Void>(new TestAuditStorageConcurrentRunForSameTypeActor(self, cx));
															#line 8245 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
}

#line 621 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"

																#line 8250 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
// This generated class is to be used only via testAuditStorageCancellation()
															#line 622 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
template <class TestAuditStorageCancellationActor>
															#line 622 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
class TestAuditStorageCancellationActorState {
															#line 8256 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
public:
															#line 622 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	TestAuditStorageCancellationActorState(ValidateStorage* const& self,Database const& cx) 
															#line 622 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
															#line 622 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		 : self(self),
															#line 622 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		   cx(cx)
															#line 8265 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
	{
		fdb_probe_actor_create("testAuditStorageCancellation", reinterpret_cast<unsigned long>(this));

	}
	~TestAuditStorageCancellationActorState() 
	{
		fdb_probe_actor_destroy("testAuditStorageCancellation", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 623 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			TraceEvent("TestAuditStorageCancellationBegin");
															#line 624 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			StrictFuture<UID> __when_expr_0 = self->triggerAuditStorageForType(cx, AuditType::ValidateHA, "TestAuditCancellation");
															#line 624 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			if (static_cast<TestAuditStorageCancellationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8284 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestAuditStorageCancellationActor*>(this)->actor_wait_state = 1;
															#line 624 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestAuditStorageCancellationActor, 0, UID >*>(static_cast<TestAuditStorageCancellationActor*>(this)));
															#line 8289 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestAuditStorageCancellationActorState();
		static_cast<TestAuditStorageCancellationActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 625 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		fs = std::vector<Future<Void>>();
															#line 626 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		fs.push_back(self->waitCancelAuditStorageUntilComplete(cx, AuditType::ValidateHA, auditId));
															#line 627 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		fs.push_back(self->waitCancelAuditStorageUntilComplete(cx, AuditType::ValidateHA, auditId));
															#line 628 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		fs.push_back(self->waitCancelAuditStorageUntilComplete(cx, AuditType::ValidateReplica, auditId));
															#line 629 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		fs.push_back(self->checkAuditStorageInternalState(cx, AuditType::ValidateHA, auditId, "TestAuditCancellation"));
															#line 630 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		fs.push_back( self->checkAuditStorageInternalState(cx, AuditType::ValidateReplica, auditId, "TestAuditCancellation"));
															#line 632 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(fs);
															#line 632 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<TestAuditStorageCancellationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8326 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestAuditStorageCancellationActor*>(this)->actor_wait_state = 2;
															#line 632 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestAuditStorageCancellationActor, 1, Void >*>(static_cast<TestAuditStorageCancellationActor*>(this)));
															#line 8331 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(UID const& __auditId,int loopDepth) 
	{
															#line 624 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		auditId = __auditId;
															#line 8340 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(UID && __auditId,int loopDepth) 
	{
		auditId = std::move(__auditId);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestAuditStorageCancellationActor*>(this)->actor_wait_state > 0) static_cast<TestAuditStorageCancellationActor*>(this)->actor_wait_state = 0;
		static_cast<TestAuditStorageCancellationActor*>(this)->ActorCallback< TestAuditStorageCancellationActor, 0, UID >::remove();

	}
	void a_callback_fire(ActorCallback< TestAuditStorageCancellationActor, 0, UID >*,UID const& value) 
	{
		fdb_probe_actor_enter("testAuditStorageCancellation", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageCancellationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageCancellation", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestAuditStorageCancellationActor, 0, UID >*,UID && value) 
	{
		fdb_probe_actor_enter("testAuditStorageCancellation", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageCancellationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageCancellation", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestAuditStorageCancellationActor, 0, UID >*,Error err) 
	{
		fdb_probe_actor_enter("testAuditStorageCancellation", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageCancellationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageCancellation", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 633 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		fs.clear();
															#line 634 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		fs.push_back(self->checkAuditStorageInternalState(cx, AuditType::ValidateHA, auditId, "TestAuditCancellation"));
															#line 635 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		fs.push_back( self->checkAuditStorageInternalState(cx, AuditType::ValidateReplica, auditId, "TestAuditCancellation"));
															#line 637 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<Void> __when_expr_2 = waitForAll(fs);
															#line 637 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<TestAuditStorageCancellationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8427 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestAuditStorageCancellationActor*>(this)->actor_wait_state = 3;
															#line 637 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestAuditStorageCancellationActor, 2, Void >*>(static_cast<TestAuditStorageCancellationActor*>(this)));
															#line 8432 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 633 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		fs.clear();
															#line 634 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		fs.push_back(self->checkAuditStorageInternalState(cx, AuditType::ValidateHA, auditId, "TestAuditCancellation"));
															#line 635 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		fs.push_back( self->checkAuditStorageInternalState(cx, AuditType::ValidateReplica, auditId, "TestAuditCancellation"));
															#line 637 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<Void> __when_expr_2 = waitForAll(fs);
															#line 637 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<TestAuditStorageCancellationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8449 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestAuditStorageCancellationActor*>(this)->actor_wait_state = 3;
															#line 637 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestAuditStorageCancellationActor, 2, Void >*>(static_cast<TestAuditStorageCancellationActor*>(this)));
															#line 8454 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestAuditStorageCancellationActor*>(this)->actor_wait_state > 0) static_cast<TestAuditStorageCancellationActor*>(this)->actor_wait_state = 0;
		static_cast<TestAuditStorageCancellationActor*>(this)->ActorCallback< TestAuditStorageCancellationActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestAuditStorageCancellationActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testAuditStorageCancellation", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageCancellationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageCancellation", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestAuditStorageCancellationActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testAuditStorageCancellation", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageCancellationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageCancellation", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestAuditStorageCancellationActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testAuditStorageCancellation", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageCancellationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageCancellation", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 638 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<std::vector<AuditStorageState>> __when_expr_3 = getAuditStates(cx, AuditType::ValidateHA, true, CLIENT_KNOBS->TOO_MANY);
															#line 638 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<TestAuditStorageCancellationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8540 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestAuditStorageCancellationActor*>(this)->actor_wait_state = 4;
															#line 638 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestAuditStorageCancellationActor, 3, std::vector<AuditStorageState> >*>(static_cast<TestAuditStorageCancellationActor*>(this)));
															#line 8545 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 638 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<std::vector<AuditStorageState>> __when_expr_3 = getAuditStates(cx, AuditType::ValidateHA, true, CLIENT_KNOBS->TOO_MANY);
															#line 638 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<TestAuditStorageCancellationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8556 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestAuditStorageCancellationActor*>(this)->actor_wait_state = 4;
															#line 638 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestAuditStorageCancellationActor, 3, std::vector<AuditStorageState> >*>(static_cast<TestAuditStorageCancellationActor*>(this)));
															#line 8561 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestAuditStorageCancellationActor*>(this)->actor_wait_state > 0) static_cast<TestAuditStorageCancellationActor*>(this)->actor_wait_state = 0;
		static_cast<TestAuditStorageCancellationActor*>(this)->ActorCallback< TestAuditStorageCancellationActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestAuditStorageCancellationActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testAuditStorageCancellation", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageCancellationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageCancellation", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestAuditStorageCancellationActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testAuditStorageCancellation", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageCancellationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageCancellation", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestAuditStorageCancellationActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testAuditStorageCancellation", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageCancellationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageCancellation", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 640 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		for( const auto& auditState : currentAuditStates1 ) {
															#line 641 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			if (auditState.id == auditId && auditState.getPhase() != AuditPhase::Failed)
															#line 8647 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			{
															#line 642 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
				TraceEvent(SevError, "TestAuditStorageCancellation1Error") .detail("AuditType", auditState.getType()) .detail("AuditID", auditId) .detail("AuditPhase", auditState.getPhase());
															#line 8651 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			}
		}
															#line 648 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<std::vector<AuditStorageState>> __when_expr_4 = getAuditStates(cx, AuditType::ValidateReplica, true, CLIENT_KNOBS->TOO_MANY);
															#line 648 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<TestAuditStorageCancellationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8658 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestAuditStorageCancellationActor*>(this)->actor_wait_state = 5;
															#line 648 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestAuditStorageCancellationActor, 4, std::vector<AuditStorageState> >*>(static_cast<TestAuditStorageCancellationActor*>(this)));
															#line 8663 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(std::vector<AuditStorageState> const& __currentAuditStates1,int loopDepth) 
	{
															#line 638 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		currentAuditStates1 = __currentAuditStates1;
															#line 8672 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(std::vector<AuditStorageState> && __currentAuditStates1,int loopDepth) 
	{
		currentAuditStates1 = std::move(__currentAuditStates1);
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TestAuditStorageCancellationActor*>(this)->actor_wait_state > 0) static_cast<TestAuditStorageCancellationActor*>(this)->actor_wait_state = 0;
		static_cast<TestAuditStorageCancellationActor*>(this)->ActorCallback< TestAuditStorageCancellationActor, 3, std::vector<AuditStorageState> >::remove();

	}
	void a_callback_fire(ActorCallback< TestAuditStorageCancellationActor, 3, std::vector<AuditStorageState> >*,std::vector<AuditStorageState> const& value) 
	{
		fdb_probe_actor_enter("testAuditStorageCancellation", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageCancellationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageCancellation", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestAuditStorageCancellationActor, 3, std::vector<AuditStorageState> >*,std::vector<AuditStorageState> && value) 
	{
		fdb_probe_actor_enter("testAuditStorageCancellation", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageCancellationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageCancellation", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestAuditStorageCancellationActor, 3, std::vector<AuditStorageState> >*,Error err) 
	{
		fdb_probe_actor_enter("testAuditStorageCancellation", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageCancellationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageCancellation", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 650 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		for( const auto& auditState : currentAuditStates2 ) {
															#line 651 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			if (auditState.id == auditId && auditState.getPhase() != AuditPhase::Failed)
															#line 8753 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			{
															#line 652 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
				TraceEvent(SevError, "TestAuditStorageCancellation2Error") .detail("AuditType", auditState.getType()) .detail("AuditID", auditId) .detail("AuditPhase", auditState.getPhase());
															#line 8757 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			}
		}
															#line 658 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestAuditStorageCancellationEnd");
															#line 659 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (!static_cast<TestAuditStorageCancellationActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestAuditStorageCancellationActorState(); static_cast<TestAuditStorageCancellationActor*>(this)->destroy(); return 0; }
															#line 8764 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		new (&static_cast<TestAuditStorageCancellationActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestAuditStorageCancellationActorState();
		static_cast<TestAuditStorageCancellationActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4when1(std::vector<AuditStorageState> const& __currentAuditStates2,int loopDepth) 
	{
															#line 648 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		currentAuditStates2 = __currentAuditStates2;
															#line 8776 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(std::vector<AuditStorageState> && __currentAuditStates2,int loopDepth) 
	{
		currentAuditStates2 = std::move(__currentAuditStates2);
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TestAuditStorageCancellationActor*>(this)->actor_wait_state > 0) static_cast<TestAuditStorageCancellationActor*>(this)->actor_wait_state = 0;
		static_cast<TestAuditStorageCancellationActor*>(this)->ActorCallback< TestAuditStorageCancellationActor, 4, std::vector<AuditStorageState> >::remove();

	}
	void a_callback_fire(ActorCallback< TestAuditStorageCancellationActor, 4, std::vector<AuditStorageState> >*,std::vector<AuditStorageState> const& value) 
	{
		fdb_probe_actor_enter("testAuditStorageCancellation", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageCancellationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageCancellation", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TestAuditStorageCancellationActor, 4, std::vector<AuditStorageState> >*,std::vector<AuditStorageState> && value) 
	{
		fdb_probe_actor_enter("testAuditStorageCancellation", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageCancellationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageCancellation", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TestAuditStorageCancellationActor, 4, std::vector<AuditStorageState> >*,Error err) 
	{
		fdb_probe_actor_enter("testAuditStorageCancellation", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageCancellationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageCancellation", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 622 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	ValidateStorage* self;
															#line 622 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	Database cx;
															#line 624 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	UID auditId;
															#line 625 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	std::vector<Future<Void>> fs;
															#line 638 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	std::vector<AuditStorageState> currentAuditStates1;
															#line 648 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	std::vector<AuditStorageState> currentAuditStates2;
															#line 8863 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
};
// This generated class is to be used only via testAuditStorageCancellation()
															#line 622 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
class TestAuditStorageCancellationActor final : public Actor<Void>, public ActorCallback< TestAuditStorageCancellationActor, 0, UID >, public ActorCallback< TestAuditStorageCancellationActor, 1, Void >, public ActorCallback< TestAuditStorageCancellationActor, 2, Void >, public ActorCallback< TestAuditStorageCancellationActor, 3, std::vector<AuditStorageState> >, public ActorCallback< TestAuditStorageCancellationActor, 4, std::vector<AuditStorageState> >, public FastAllocated<TestAuditStorageCancellationActor>, public TestAuditStorageCancellationActorState<TestAuditStorageCancellationActor> {
															#line 8868 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
public:
	using FastAllocated<TestAuditStorageCancellationActor>::operator new;
	using FastAllocated<TestAuditStorageCancellationActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13690790543820433664UL, 10522753599927212800UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestAuditStorageCancellationActor, 0, UID >;
friend struct ActorCallback< TestAuditStorageCancellationActor, 1, Void >;
friend struct ActorCallback< TestAuditStorageCancellationActor, 2, Void >;
friend struct ActorCallback< TestAuditStorageCancellationActor, 3, std::vector<AuditStorageState> >;
friend struct ActorCallback< TestAuditStorageCancellationActor, 4, std::vector<AuditStorageState> >;
															#line 622 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	TestAuditStorageCancellationActor(ValidateStorage* const& self,Database const& cx) 
															#line 8889 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		 : Actor<Void>(),
		   TestAuditStorageCancellationActorState<TestAuditStorageCancellationActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testAuditStorageCancellation", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11642118680100545536UL, 6053538589928634624UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageCancellationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testAuditStorageCancellation");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testAuditStorageCancellation", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestAuditStorageCancellationActor, 0, UID >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestAuditStorageCancellationActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestAuditStorageCancellationActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TestAuditStorageCancellationActor, 3, std::vector<AuditStorageState> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TestAuditStorageCancellationActor, 4, std::vector<AuditStorageState> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 622 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
[[nodiscard]] Future<Void> testAuditStorageCancellation( ValidateStorage* const& self, Database const& cx ) {
															#line 622 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	return Future<Void>(new TestAuditStorageCancellationActor(self, cx));
															#line 8925 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
}

#line 661 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"

																#line 8930 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
// This generated class is to be used only via persistAuditStateByRange()
															#line 662 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
template <class PersistAuditStateByRangeActor>
															#line 662 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
class PersistAuditStateByRangeActorState {
															#line 8936 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
public:
															#line 662 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	PersistAuditStateByRangeActorState(ValidateStorage* const& self,Database const& cx,AuditStorageState const& auditState) 
															#line 662 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
															#line 662 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		 : self(self),
															#line 662 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		   cx(cx),
															#line 662 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		   auditState(auditState),
															#line 663 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		   tr(cx),
															#line 664 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		   auditStates()
															#line 8951 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
	{
		fdb_probe_actor_create("persistAuditStateByRange", reinterpret_cast<unsigned long>(this));

	}
	~PersistAuditStateByRangeActorState() 
	{
		fdb_probe_actor_destroy("persistAuditStateByRange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 665 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			;
															#line 8966 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PersistAuditStateByRangeActorState();
		static_cast<PersistAuditStateByRangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 680 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (!static_cast<PersistAuditStateByRangeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PersistAuditStateByRangeActorState(); static_cast<PersistAuditStateByRangeActor*>(this)->destroy(); return 0; }
															#line 8989 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		new (&static_cast<PersistAuditStateByRangeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PersistAuditStateByRangeActorState();
		static_cast<PersistAuditStateByRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 667 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 668 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 669 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 670 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			StrictFuture<Void> __when_expr_0 = krmSetRange(&tr, auditRangeBasedProgressPrefixFor(auditState.getType(), auditState.id), auditState.range, auditStorageStateValue(auditState));
															#line 670 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			if (static_cast<PersistAuditStateByRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9017 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PersistAuditStateByRangeActor*>(this)->actor_wait_state = 1;
															#line 670 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PersistAuditStateByRangeActor, 0, Void >*>(static_cast<PersistAuditStateByRangeActor*>(this)));
															#line 9022 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 677 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 677 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			if (static_cast<PersistAuditStateByRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9059 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<PersistAuditStateByRangeActor*>(this)->actor_wait_state = 3;
															#line 677 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PersistAuditStateByRangeActor, 2, Void >*>(static_cast<PersistAuditStateByRangeActor*>(this)));
															#line 9064 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 674 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 674 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<PersistAuditStateByRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9081 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<PersistAuditStateByRangeActor*>(this)->actor_wait_state = 2;
															#line 674 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PersistAuditStateByRangeActor, 1, Void >*>(static_cast<PersistAuditStateByRangeActor*>(this)));
															#line 9086 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 674 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 674 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<PersistAuditStateByRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9097 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<PersistAuditStateByRangeActor*>(this)->actor_wait_state = 2;
															#line 674 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PersistAuditStateByRangeActor, 1, Void >*>(static_cast<PersistAuditStateByRangeActor*>(this)));
															#line 9102 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PersistAuditStateByRangeActor*>(this)->actor_wait_state > 0) static_cast<PersistAuditStateByRangeActor*>(this)->actor_wait_state = 0;
		static_cast<PersistAuditStateByRangeActor*>(this)->ActorCallback< PersistAuditStateByRangeActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PersistAuditStateByRangeActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PersistAuditStateByRangeActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PersistAuditStateByRangeActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PersistAuditStateByRangeActor*>(this)->actor_wait_state > 0) static_cast<PersistAuditStateByRangeActor*>(this)->actor_wait_state = 0;
		static_cast<PersistAuditStateByRangeActor*>(this)->ActorCallback< PersistAuditStateByRangeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PersistAuditStateByRangeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PersistAuditStateByRangeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PersistAuditStateByRangeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<PersistAuditStateByRangeActor*>(this)->actor_wait_state > 0) static_cast<PersistAuditStateByRangeActor*>(this)->actor_wait_state = 0;
		static_cast<PersistAuditStateByRangeActor*>(this)->ActorCallback< PersistAuditStateByRangeActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PersistAuditStateByRangeActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< PersistAuditStateByRangeActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< PersistAuditStateByRangeActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 662 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	ValidateStorage* self;
															#line 662 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	Database cx;
															#line 662 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	AuditStorageState auditState;
															#line 663 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	Transaction tr;
															#line 664 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	RangeResult auditStates;
															#line 9366 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
};
// This generated class is to be used only via persistAuditStateByRange()
															#line 662 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
class PersistAuditStateByRangeActor final : public Actor<Void>, public ActorCallback< PersistAuditStateByRangeActor, 0, Void >, public ActorCallback< PersistAuditStateByRangeActor, 1, Void >, public ActorCallback< PersistAuditStateByRangeActor, 2, Void >, public FastAllocated<PersistAuditStateByRangeActor>, public PersistAuditStateByRangeActorState<PersistAuditStateByRangeActor> {
															#line 9371 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
public:
	using FastAllocated<PersistAuditStateByRangeActor>::operator new;
	using FastAllocated<PersistAuditStateByRangeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12863939198625221120UL, 18039189000142318336UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PersistAuditStateByRangeActor, 0, Void >;
friend struct ActorCallback< PersistAuditStateByRangeActor, 1, Void >;
friend struct ActorCallback< PersistAuditStateByRangeActor, 2, Void >;
															#line 662 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	PersistAuditStateByRangeActor(ValidateStorage* const& self,Database const& cx,AuditStorageState const& auditState) 
															#line 9390 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		 : Actor<Void>(),
		   PersistAuditStateByRangeActorState<PersistAuditStateByRangeActor>(self, cx, auditState),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12978781156159195648UL, 11031502681131358976UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("persistAuditStateByRange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PersistAuditStateByRangeActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PersistAuditStateByRangeActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< PersistAuditStateByRangeActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 662 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
[[nodiscard]] Future<Void> persistAuditStateByRange( ValidateStorage* const& self, Database const& cx, AuditStorageState const& auditState ) {
															#line 662 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	return Future<Void>(new PersistAuditStateByRangeActor(self, cx, auditState));
															#line 9424 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
}

#line 682 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"

	// Test audit progress persist invariant
																#line 9430 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
// This generated class is to be used only via testAuditStorageProgress()
															#line 684 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
template <class TestAuditStorageProgressActor>
															#line 684 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
class TestAuditStorageProgressActorState {
															#line 9436 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
public:
															#line 684 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	TestAuditStorageProgressActorState(ValidateStorage* const& self,Database const& cx) 
															#line 684 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
															#line 684 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		 : self(self),
															#line 684 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		   cx(cx)
															#line 9445 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
	{
		fdb_probe_actor_create("testAuditStorageProgress", reinterpret_cast<unsigned long>(this));

	}
	~TestAuditStorageProgressActorState() 
	{
		fdb_probe_actor_destroy("testAuditStorageProgress", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 685 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			TraceEvent("TestAuditStorageProgressBegin");
															#line 686 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			auditId = deterministicRandom()->randomUniqueID();
															#line 687 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			auditType = AuditType::ValidateHA;
															#line 688 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			ddId = deterministicRandom()->randomUniqueID();
															#line 689 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			std::vector<KeyRange> progressRangesCollection = { KeyRangeRef("TestKeyA"_sr, "TestKeyB"_sr), KeyRangeRef("TestKeyB"_sr, "TestKeyBB"_sr), KeyRangeRef("TestKeyA"_sr, "TestKeyBBB"_sr), KeyRangeRef("TestKeyE"_sr, "TestKeyF"_sr), KeyRangeRef("TestKeyC"_sr, "TestKeyD"_sr), KeyRangeRef("TestKeyBBB"_sr, "TestKeyC"_sr), KeyRangeRef("TestKeyBB"_sr, "TestKeyBC"_sr), };
															#line 695 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			progressRanges = shuffleRanges(progressRangesCollection);
															#line 696 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			i = 0;
															#line 697 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			alreadyPersisteRanges = std::vector<KeyRange>();
															#line 698 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			;
															#line 9476 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestAuditStorageProgressActorState();
		static_cast<TestAuditStorageProgressActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 737 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestAuditStorageProgressEnd");
															#line 738 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (!static_cast<TestAuditStorageProgressActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestAuditStorageProgressActorState(); static_cast<TestAuditStorageProgressActor*>(this)->destroy(); return 0; }
															#line 9501 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		new (&static_cast<TestAuditStorageProgressActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestAuditStorageProgressActorState();
		static_cast<TestAuditStorageProgressActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 698 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (!(i < progressRanges.size()))
															#line 9520 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 699 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		auditState = AuditStorageState(auditId, auditType);
															#line 700 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		auditState.range = progressRanges[i];
															#line 701 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		auditState.ddId = ddId;
															#line 702 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		auditState.setPhase(AuditPhase::Complete);
															#line 703 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<Void> __when_expr_0 = self->persistAuditStateByRange(self, cx, auditState);
															#line 703 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<TestAuditStorageProgressActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9536 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<TestAuditStorageProgressActor*>(this)->actor_wait_state = 1;
															#line 703 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestAuditStorageProgressActor, 0, Void >*>(static_cast<TestAuditStorageProgressActor*>(this)));
															#line 9541 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 704 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		alreadyPersisteRanges.push_back(progressRanges[i]);
															#line 705 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<std::vector<AuditStorageState>> __when_expr_1 = getAuditStateByRange(cx, auditType, auditId, allKeys);
															#line 705 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<TestAuditStorageProgressActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9567 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestAuditStorageProgressActor*>(this)->actor_wait_state = 2;
															#line 705 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestAuditStorageProgressActor, 1, std::vector<AuditStorageState> >*>(static_cast<TestAuditStorageProgressActor*>(this)));
															#line 9572 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 704 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		alreadyPersisteRanges.push_back(progressRanges[i]);
															#line 705 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<std::vector<AuditStorageState>> __when_expr_1 = getAuditStateByRange(cx, auditType, auditId, allKeys);
															#line 705 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<TestAuditStorageProgressActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9585 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestAuditStorageProgressActor*>(this)->actor_wait_state = 2;
															#line 705 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestAuditStorageProgressActor, 1, std::vector<AuditStorageState> >*>(static_cast<TestAuditStorageProgressActor*>(this)));
															#line 9590 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestAuditStorageProgressActor*>(this)->actor_wait_state > 0) static_cast<TestAuditStorageProgressActor*>(this)->actor_wait_state = 0;
		static_cast<TestAuditStorageProgressActor*>(this)->ActorCallback< TestAuditStorageProgressActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestAuditStorageProgressActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testAuditStorageProgress", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageProgress", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestAuditStorageProgressActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testAuditStorageProgress", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageProgress", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestAuditStorageProgressActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testAuditStorageProgress", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageProgress", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(std::vector<AuditStorageState> const& auditStates,int loopDepth) 
	{
															#line 706 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		for(int i = 0;i < auditStates.size();i++) {
															#line 707 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			KeyRange toCompare = auditStates[i].range;
															#line 708 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			bool overlapped = false;
															#line 709 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			bool fullyCovered = false;
															#line 710 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			std::vector<KeyRange> unCoveredRanges;
															#line 711 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			unCoveredRanges.push_back(toCompare);
															#line 713 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			for( const auto& persistedRange : alreadyPersisteRanges ) {
															#line 714 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
				KeyRange overlappedRange = toCompare & persistedRange;
															#line 715 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
				if (!overlappedRange.empty())
															#line 9690 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
				{
															#line 716 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
					overlapped = true;
															#line 9694 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
				}
															#line 718 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
				std::vector<KeyRange> unCoveredRangesNow;
															#line 719 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
				for( const auto& unCoveredRange : unCoveredRanges ) {
															#line 720 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
					std::vector<KeyRangeRef> tmp = unCoveredRange - persistedRange;
															#line 721 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
					for( const auto& item : tmp ) {
															#line 722 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
						unCoveredRangesNow.push_back(item);
															#line 9706 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
					}
				}
															#line 725 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
				unCoveredRanges = unCoveredRangesNow;
															#line 9711 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			}
															#line 727 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			fullyCovered = unCoveredRanges.empty();
															#line 728 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			if (fullyCovered)
															#line 9717 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			{
															#line 729 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
				ASSERT(auditStates[i].getPhase() == AuditPhase::Complete);
															#line 9721 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			}
			else
			{
															#line 732 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
				ASSERT(!overlapped);
															#line 733 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
				ASSERT(auditStates[i].getPhase() == AuditPhase::Invalid);
															#line 9729 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			}
		}
															#line 698 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		i++;
															#line 9734 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(std::vector<AuditStorageState> && auditStates,int loopDepth) 
	{
															#line 706 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		for(int i = 0;i < auditStates.size();i++) {
															#line 707 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			KeyRange toCompare = auditStates[i].range;
															#line 708 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			bool overlapped = false;
															#line 709 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			bool fullyCovered = false;
															#line 710 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			std::vector<KeyRange> unCoveredRanges;
															#line 711 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			unCoveredRanges.push_back(toCompare);
															#line 713 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			for( const auto& persistedRange : alreadyPersisteRanges ) {
															#line 714 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
				KeyRange overlappedRange = toCompare & persistedRange;
															#line 715 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
				if (!overlappedRange.empty())
															#line 9759 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
				{
															#line 716 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
					overlapped = true;
															#line 9763 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
				}
															#line 718 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
				std::vector<KeyRange> unCoveredRangesNow;
															#line 719 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
				for( const auto& unCoveredRange : unCoveredRanges ) {
															#line 720 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
					std::vector<KeyRangeRef> tmp = unCoveredRange - persistedRange;
															#line 721 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
					for( const auto& item : tmp ) {
															#line 722 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
						unCoveredRangesNow.push_back(item);
															#line 9775 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
					}
				}
															#line 725 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
				unCoveredRanges = unCoveredRangesNow;
															#line 9780 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			}
															#line 727 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			fullyCovered = unCoveredRanges.empty();
															#line 728 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			if (fullyCovered)
															#line 9786 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			{
															#line 729 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
				ASSERT(auditStates[i].getPhase() == AuditPhase::Complete);
															#line 9790 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			}
			else
			{
															#line 732 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
				ASSERT(!overlapped);
															#line 733 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
				ASSERT(auditStates[i].getPhase() == AuditPhase::Invalid);
															#line 9798 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			}
		}
															#line 698 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		i++;
															#line 9803 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(std::vector<AuditStorageState> const& auditStates,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(auditStates, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(std::vector<AuditStorageState> && auditStates,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(auditStates), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestAuditStorageProgressActor*>(this)->actor_wait_state > 0) static_cast<TestAuditStorageProgressActor*>(this)->actor_wait_state = 0;
		static_cast<TestAuditStorageProgressActor*>(this)->ActorCallback< TestAuditStorageProgressActor, 1, std::vector<AuditStorageState> >::remove();

	}
	void a_callback_fire(ActorCallback< TestAuditStorageProgressActor, 1, std::vector<AuditStorageState> >*,std::vector<AuditStorageState> const& value) 
	{
		fdb_probe_actor_enter("testAuditStorageProgress", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageProgress", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestAuditStorageProgressActor, 1, std::vector<AuditStorageState> >*,std::vector<AuditStorageState> && value) 
	{
		fdb_probe_actor_enter("testAuditStorageProgress", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageProgress", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestAuditStorageProgressActor, 1, std::vector<AuditStorageState> >*,Error err) 
	{
		fdb_probe_actor_enter("testAuditStorageProgress", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageProgress", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 684 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	ValidateStorage* self;
															#line 684 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	Database cx;
															#line 686 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	UID auditId;
															#line 687 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	AuditType auditType;
															#line 688 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	UID ddId;
															#line 695 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	std::vector<KeyRange> progressRanges;
															#line 696 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	int i;
															#line 697 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	std::vector<KeyRange> alreadyPersisteRanges;
															#line 699 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	AuditStorageState auditState;
															#line 9901 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
};
// This generated class is to be used only via testAuditStorageProgress()
															#line 684 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
class TestAuditStorageProgressActor final : public Actor<Void>, public ActorCallback< TestAuditStorageProgressActor, 0, Void >, public ActorCallback< TestAuditStorageProgressActor, 1, std::vector<AuditStorageState> >, public FastAllocated<TestAuditStorageProgressActor>, public TestAuditStorageProgressActorState<TestAuditStorageProgressActor> {
															#line 9906 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
public:
	using FastAllocated<TestAuditStorageProgressActor>::operator new;
	using FastAllocated<TestAuditStorageProgressActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10433386516148439296UL, 12423148630890710528UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestAuditStorageProgressActor, 0, Void >;
friend struct ActorCallback< TestAuditStorageProgressActor, 1, std::vector<AuditStorageState> >;
															#line 684 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	TestAuditStorageProgressActor(ValidateStorage* const& self,Database const& cx) 
															#line 9924 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		 : Actor<Void>(),
		   TestAuditStorageProgressActorState<TestAuditStorageProgressActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testAuditStorageProgress", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7167528726878713088UL, 18007714221488300800UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testAuditStorageProgress");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testAuditStorageProgress", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestAuditStorageProgressActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestAuditStorageProgressActor, 1, std::vector<AuditStorageState> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 684 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
[[nodiscard]] Future<Void> testAuditStorageProgress( ValidateStorage* const& self, Database const& cx ) {
															#line 684 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	return Future<Void>(new TestAuditStorageProgressActor(self, cx));
															#line 9957 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
}

#line 740 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"

																#line 9962 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
// This generated class is to be used only via testAuditStorageWhenDDSecurityMode()
															#line 741 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
template <class TestAuditStorageWhenDDSecurityModeActor>
															#line 741 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
class TestAuditStorageWhenDDSecurityModeActorState {
															#line 9968 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
public:
															#line 741 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	TestAuditStorageWhenDDSecurityModeActorState(ValidateStorage* const& self,Database const& cx) 
															#line 741 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
															#line 741 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		 : self(self),
															#line 741 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		   cx(cx)
															#line 9977 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
	{
		fdb_probe_actor_create("testAuditStorageWhenDDSecurityMode", reinterpret_cast<unsigned long>(this));

	}
	~TestAuditStorageWhenDDSecurityModeActorState() 
	{
		fdb_probe_actor_destroy("testAuditStorageWhenDDSecurityMode", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 742 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			TraceEvent("TestAuditStorageWhenDDSecurityModeBegin");
															#line 743 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(setDDMode(cx, 2));
															#line 743 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			if (static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9996 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->actor_wait_state = 1;
															#line 743 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestAuditStorageWhenDDSecurityModeActor, 0, Void >*>(static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)));
															#line 10001 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestAuditStorageWhenDDSecurityModeActorState();
		static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 744 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<UID> __when_expr_1 = self->auditStorageForType(self, cx, AuditType::ValidateHA, "TestAuditStorageWhenDDSecurityMode");
															#line 744 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10026 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->actor_wait_state = 2;
															#line 744 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestAuditStorageWhenDDSecurityModeActor, 1, UID >*>(static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)));
															#line 10031 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 744 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<UID> __when_expr_1 = self->auditStorageForType(self, cx, AuditType::ValidateHA, "TestAuditStorageWhenDDSecurityMode");
															#line 744 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10042 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->actor_wait_state = 2;
															#line 744 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestAuditStorageWhenDDSecurityModeActor, 1, UID >*>(static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)));
															#line 10047 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->actor_wait_state > 0) static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->actor_wait_state = 0;
		static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->ActorCallback< TestAuditStorageWhenDDSecurityModeActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestAuditStorageWhenDDSecurityModeActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testAuditStorageWhenDDSecurityMode", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageWhenDDSecurityMode", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestAuditStorageWhenDDSecurityModeActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testAuditStorageWhenDDSecurityMode", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageWhenDDSecurityMode", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestAuditStorageWhenDDSecurityModeActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testAuditStorageWhenDDSecurityMode", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageWhenDDSecurityMode", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(UID const& auditIdA,int loopDepth) 
	{
															#line 746 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestFunctionalityHADoneWhenDDSecurityMode", auditIdA);
															#line 747 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<UID> __when_expr_2 = self->auditStorageForType(self, cx, AuditType::ValidateReplica, "TestAuditStorageWhenDDSecurityMode");
															#line 747 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10135 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->actor_wait_state = 3;
															#line 747 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestAuditStorageWhenDDSecurityModeActor, 2, UID >*>(static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)));
															#line 10140 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(UID && auditIdA,int loopDepth) 
	{
															#line 746 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestFunctionalityHADoneWhenDDSecurityMode", auditIdA);
															#line 747 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<UID> __when_expr_2 = self->auditStorageForType(self, cx, AuditType::ValidateReplica, "TestAuditStorageWhenDDSecurityMode");
															#line 747 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10153 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->actor_wait_state = 3;
															#line 747 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestAuditStorageWhenDDSecurityModeActor, 2, UID >*>(static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)));
															#line 10158 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(UID const& auditIdA,int loopDepth) 
	{
		loopDepth = a_body1cont2(auditIdA, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(UID && auditIdA,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(auditIdA), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->actor_wait_state > 0) static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->actor_wait_state = 0;
		static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->ActorCallback< TestAuditStorageWhenDDSecurityModeActor, 1, UID >::remove();

	}
	void a_callback_fire(ActorCallback< TestAuditStorageWhenDDSecurityModeActor, 1, UID >*,UID const& value) 
	{
		fdb_probe_actor_enter("testAuditStorageWhenDDSecurityMode", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageWhenDDSecurityMode", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestAuditStorageWhenDDSecurityModeActor, 1, UID >*,UID && value) 
	{
		fdb_probe_actor_enter("testAuditStorageWhenDDSecurityMode", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageWhenDDSecurityMode", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestAuditStorageWhenDDSecurityModeActor, 1, UID >*,Error err) 
	{
		fdb_probe_actor_enter("testAuditStorageWhenDDSecurityMode", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageWhenDDSecurityMode", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(UID const& auditIdB,int loopDepth) 
	{
															#line 749 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestFunctionalityReplicaDoneWhenDDSecurityMode", auditIdB);
															#line 750 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<UID> __when_expr_3 = self->auditStorageForType( self, cx, AuditType::ValidateLocationMetadata, "TestAuditStorageWhenDDSecurityMode");
															#line 750 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10246 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->actor_wait_state = 4;
															#line 750 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestAuditStorageWhenDDSecurityModeActor, 3, UID >*>(static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)));
															#line 10251 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(UID && auditIdB,int loopDepth) 
	{
															#line 749 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestFunctionalityReplicaDoneWhenDDSecurityMode", auditIdB);
															#line 750 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<UID> __when_expr_3 = self->auditStorageForType( self, cx, AuditType::ValidateLocationMetadata, "TestAuditStorageWhenDDSecurityMode");
															#line 750 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10264 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->actor_wait_state = 4;
															#line 750 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestAuditStorageWhenDDSecurityModeActor, 3, UID >*>(static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)));
															#line 10269 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(UID const& auditIdB,int loopDepth) 
	{
		loopDepth = a_body1cont3(auditIdB, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(UID && auditIdB,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(auditIdB), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->actor_wait_state > 0) static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->actor_wait_state = 0;
		static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->ActorCallback< TestAuditStorageWhenDDSecurityModeActor, 2, UID >::remove();

	}
	void a_callback_fire(ActorCallback< TestAuditStorageWhenDDSecurityModeActor, 2, UID >*,UID const& value) 
	{
		fdb_probe_actor_enter("testAuditStorageWhenDDSecurityMode", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageWhenDDSecurityMode", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestAuditStorageWhenDDSecurityModeActor, 2, UID >*,UID && value) 
	{
		fdb_probe_actor_enter("testAuditStorageWhenDDSecurityMode", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageWhenDDSecurityMode", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestAuditStorageWhenDDSecurityModeActor, 2, UID >*,Error err) 
	{
		fdb_probe_actor_enter("testAuditStorageWhenDDSecurityMode", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageWhenDDSecurityMode", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(UID const& auditIdC,int loopDepth) 
	{
															#line 752 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestFunctionalityShardLocationMetadataDoneWhenDDSecurityMode", auditIdC);
															#line 753 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<UID> __when_expr_4 = self->auditStorageForType( self, cx, AuditType::ValidateStorageServerShard, "TestAuditStorageWhenDDSecurityMode");
															#line 753 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10357 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->actor_wait_state = 5;
															#line 753 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestAuditStorageWhenDDSecurityModeActor, 4, UID >*>(static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)));
															#line 10362 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(UID && auditIdC,int loopDepth) 
	{
															#line 752 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestFunctionalityShardLocationMetadataDoneWhenDDSecurityMode", auditIdC);
															#line 753 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<UID> __when_expr_4 = self->auditStorageForType( self, cx, AuditType::ValidateStorageServerShard, "TestAuditStorageWhenDDSecurityMode");
															#line 753 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10375 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->actor_wait_state = 5;
															#line 753 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestAuditStorageWhenDDSecurityModeActor, 4, UID >*>(static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)));
															#line 10380 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(UID const& auditIdC,int loopDepth) 
	{
		loopDepth = a_body1cont4(auditIdC, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(UID && auditIdC,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(auditIdC), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->actor_wait_state > 0) static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->actor_wait_state = 0;
		static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->ActorCallback< TestAuditStorageWhenDDSecurityModeActor, 3, UID >::remove();

	}
	void a_callback_fire(ActorCallback< TestAuditStorageWhenDDSecurityModeActor, 3, UID >*,UID const& value) 
	{
		fdb_probe_actor_enter("testAuditStorageWhenDDSecurityMode", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageWhenDDSecurityMode", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestAuditStorageWhenDDSecurityModeActor, 3, UID >*,UID && value) 
	{
		fdb_probe_actor_enter("testAuditStorageWhenDDSecurityMode", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageWhenDDSecurityMode", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestAuditStorageWhenDDSecurityModeActor, 3, UID >*,Error err) 
	{
		fdb_probe_actor_enter("testAuditStorageWhenDDSecurityMode", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageWhenDDSecurityMode", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont5(UID const& auditIdD,int loopDepth) 
	{
															#line 755 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestFunctionalitySSShardInfoDoneWhenDDSecurityMode", auditIdD);
															#line 756 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestAuditStorageWhenDDSecurityModeEnd");
															#line 757 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (!static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestAuditStorageWhenDDSecurityModeActorState(); static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->destroy(); return 0; }
															#line 10468 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		new (&static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestAuditStorageWhenDDSecurityModeActorState();
		static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(UID && auditIdD,int loopDepth) 
	{
															#line 755 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestFunctionalitySSShardInfoDoneWhenDDSecurityMode", auditIdD);
															#line 756 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestAuditStorageWhenDDSecurityModeEnd");
															#line 757 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (!static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestAuditStorageWhenDDSecurityModeActorState(); static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->destroy(); return 0; }
															#line 10484 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		new (&static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestAuditStorageWhenDDSecurityModeActorState();
		static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4when1(UID const& auditIdD,int loopDepth) 
	{
		loopDepth = a_body1cont5(auditIdD, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(UID && auditIdD,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(auditIdD), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->actor_wait_state > 0) static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->actor_wait_state = 0;
		static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->ActorCallback< TestAuditStorageWhenDDSecurityModeActor, 4, UID >::remove();

	}
	void a_callback_fire(ActorCallback< TestAuditStorageWhenDDSecurityModeActor, 4, UID >*,UID const& value) 
	{
		fdb_probe_actor_enter("testAuditStorageWhenDDSecurityMode", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageWhenDDSecurityMode", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TestAuditStorageWhenDDSecurityModeActor, 4, UID >*,UID && value) 
	{
		fdb_probe_actor_enter("testAuditStorageWhenDDSecurityMode", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageWhenDDSecurityMode", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TestAuditStorageWhenDDSecurityModeActor, 4, UID >*,Error err) 
	{
		fdb_probe_actor_enter("testAuditStorageWhenDDSecurityMode", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageWhenDDSecurityMode", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 741 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	ValidateStorage* self;
															#line 741 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	Database cx;
															#line 10571 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
};
// This generated class is to be used only via testAuditStorageWhenDDSecurityMode()
															#line 741 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
class TestAuditStorageWhenDDSecurityModeActor final : public Actor<Void>, public ActorCallback< TestAuditStorageWhenDDSecurityModeActor, 0, Void >, public ActorCallback< TestAuditStorageWhenDDSecurityModeActor, 1, UID >, public ActorCallback< TestAuditStorageWhenDDSecurityModeActor, 2, UID >, public ActorCallback< TestAuditStorageWhenDDSecurityModeActor, 3, UID >, public ActorCallback< TestAuditStorageWhenDDSecurityModeActor, 4, UID >, public FastAllocated<TestAuditStorageWhenDDSecurityModeActor>, public TestAuditStorageWhenDDSecurityModeActorState<TestAuditStorageWhenDDSecurityModeActor> {
															#line 10576 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
public:
	using FastAllocated<TestAuditStorageWhenDDSecurityModeActor>::operator new;
	using FastAllocated<TestAuditStorageWhenDDSecurityModeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6997863057628803072UL, 6775601873369512192UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestAuditStorageWhenDDSecurityModeActor, 0, Void >;
friend struct ActorCallback< TestAuditStorageWhenDDSecurityModeActor, 1, UID >;
friend struct ActorCallback< TestAuditStorageWhenDDSecurityModeActor, 2, UID >;
friend struct ActorCallback< TestAuditStorageWhenDDSecurityModeActor, 3, UID >;
friend struct ActorCallback< TestAuditStorageWhenDDSecurityModeActor, 4, UID >;
															#line 741 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	TestAuditStorageWhenDDSecurityModeActor(ValidateStorage* const& self,Database const& cx) 
															#line 10597 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		 : Actor<Void>(),
		   TestAuditStorageWhenDDSecurityModeActorState<TestAuditStorageWhenDDSecurityModeActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testAuditStorageWhenDDSecurityMode", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14344481275685943040UL, 1013575399417779968UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageWhenDDSecurityModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testAuditStorageWhenDDSecurityMode");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testAuditStorageWhenDDSecurityMode", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestAuditStorageWhenDDSecurityModeActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestAuditStorageWhenDDSecurityModeActor, 1, UID >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestAuditStorageWhenDDSecurityModeActor, 2, UID >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TestAuditStorageWhenDDSecurityModeActor, 3, UID >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TestAuditStorageWhenDDSecurityModeActor, 4, UID >*)0, actor_cancelled()); break;
		}

	}
};
															#line 741 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
[[nodiscard]] Future<Void> testAuditStorageWhenDDSecurityMode( ValidateStorage* const& self, Database const& cx ) {
															#line 741 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	return Future<Void>(new TestAuditStorageWhenDDSecurityModeActor(self, cx));
															#line 10633 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
}

#line 759 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"

																#line 10638 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
// This generated class is to be used only via testAuditStorageWhenDDBackToNormalMode()
															#line 760 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
template <class TestAuditStorageWhenDDBackToNormalModeActor>
															#line 760 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
class TestAuditStorageWhenDDBackToNormalModeActorState {
															#line 10644 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
public:
															#line 760 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	TestAuditStorageWhenDDBackToNormalModeActorState(ValidateStorage* const& self,Database const& cx) 
															#line 760 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
															#line 760 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		 : self(self),
															#line 760 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		   cx(cx)
															#line 10653 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
	{
		fdb_probe_actor_create("testAuditStorageWhenDDBackToNormalMode", reinterpret_cast<unsigned long>(this));

	}
	~TestAuditStorageWhenDDBackToNormalModeActorState() 
	{
		fdb_probe_actor_destroy("testAuditStorageWhenDDBackToNormalMode", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 761 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			TraceEvent("TestAuditStorageWhenDDBackToNormalModeBegin");
															#line 762 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(setDDMode(cx, 1));
															#line 762 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			if (static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10672 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->actor_wait_state = 1;
															#line 762 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestAuditStorageWhenDDBackToNormalModeActor, 0, Void >*>(static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)));
															#line 10677 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestAuditStorageWhenDDBackToNormalModeActorState();
		static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 763 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<UID> __when_expr_1 = self->auditStorageForType(self, cx, AuditType::ValidateHA, "TestAuditStorageWhenDDBackToNormalMode");
															#line 763 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10702 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->actor_wait_state = 2;
															#line 763 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestAuditStorageWhenDDBackToNormalModeActor, 1, UID >*>(static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)));
															#line 10707 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 763 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<UID> __when_expr_1 = self->auditStorageForType(self, cx, AuditType::ValidateHA, "TestAuditStorageWhenDDBackToNormalMode");
															#line 763 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10718 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->actor_wait_state = 2;
															#line 763 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestAuditStorageWhenDDBackToNormalModeActor, 1, UID >*>(static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)));
															#line 10723 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->actor_wait_state > 0) static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->actor_wait_state = 0;
		static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->ActorCallback< TestAuditStorageWhenDDBackToNormalModeActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestAuditStorageWhenDDBackToNormalModeActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testAuditStorageWhenDDBackToNormalMode", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageWhenDDBackToNormalMode", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestAuditStorageWhenDDBackToNormalModeActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testAuditStorageWhenDDBackToNormalMode", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageWhenDDBackToNormalMode", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestAuditStorageWhenDDBackToNormalModeActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testAuditStorageWhenDDBackToNormalMode", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageWhenDDBackToNormalMode", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(UID const& auditIdA,int loopDepth) 
	{
															#line 765 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestFunctionalityHADoneWhenDDBackToNormalMode", auditIdA);
															#line 766 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<UID> __when_expr_2 = self->auditStorageForType(self, cx, AuditType::ValidateReplica, "TestAuditStorageWhenDDBackToNormalMode");
															#line 766 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10811 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->actor_wait_state = 3;
															#line 766 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestAuditStorageWhenDDBackToNormalModeActor, 2, UID >*>(static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)));
															#line 10816 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(UID && auditIdA,int loopDepth) 
	{
															#line 765 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestFunctionalityHADoneWhenDDBackToNormalMode", auditIdA);
															#line 766 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<UID> __when_expr_2 = self->auditStorageForType(self, cx, AuditType::ValidateReplica, "TestAuditStorageWhenDDBackToNormalMode");
															#line 766 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10829 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->actor_wait_state = 3;
															#line 766 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestAuditStorageWhenDDBackToNormalModeActor, 2, UID >*>(static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)));
															#line 10834 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(UID const& auditIdA,int loopDepth) 
	{
		loopDepth = a_body1cont2(auditIdA, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(UID && auditIdA,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(auditIdA), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->actor_wait_state > 0) static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->actor_wait_state = 0;
		static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->ActorCallback< TestAuditStorageWhenDDBackToNormalModeActor, 1, UID >::remove();

	}
	void a_callback_fire(ActorCallback< TestAuditStorageWhenDDBackToNormalModeActor, 1, UID >*,UID const& value) 
	{
		fdb_probe_actor_enter("testAuditStorageWhenDDBackToNormalMode", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageWhenDDBackToNormalMode", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestAuditStorageWhenDDBackToNormalModeActor, 1, UID >*,UID && value) 
	{
		fdb_probe_actor_enter("testAuditStorageWhenDDBackToNormalMode", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageWhenDDBackToNormalMode", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestAuditStorageWhenDDBackToNormalModeActor, 1, UID >*,Error err) 
	{
		fdb_probe_actor_enter("testAuditStorageWhenDDBackToNormalMode", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageWhenDDBackToNormalMode", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(UID const& auditIdB,int loopDepth) 
	{
															#line 768 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestFunctionalityReplicaDoneWhenDDBackToNormalMode", auditIdB);
															#line 769 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<UID> __when_expr_3 = self->auditStorageForType( self, cx, AuditType::ValidateLocationMetadata, "TestAuditStorageWhenDDBackToNormalMode");
															#line 769 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10922 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->actor_wait_state = 4;
															#line 769 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestAuditStorageWhenDDBackToNormalModeActor, 3, UID >*>(static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)));
															#line 10927 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(UID && auditIdB,int loopDepth) 
	{
															#line 768 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestFunctionalityReplicaDoneWhenDDBackToNormalMode", auditIdB);
															#line 769 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<UID> __when_expr_3 = self->auditStorageForType( self, cx, AuditType::ValidateLocationMetadata, "TestAuditStorageWhenDDBackToNormalMode");
															#line 769 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10940 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->actor_wait_state = 4;
															#line 769 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestAuditStorageWhenDDBackToNormalModeActor, 3, UID >*>(static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)));
															#line 10945 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(UID const& auditIdB,int loopDepth) 
	{
		loopDepth = a_body1cont3(auditIdB, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(UID && auditIdB,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(auditIdB), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->actor_wait_state > 0) static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->actor_wait_state = 0;
		static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->ActorCallback< TestAuditStorageWhenDDBackToNormalModeActor, 2, UID >::remove();

	}
	void a_callback_fire(ActorCallback< TestAuditStorageWhenDDBackToNormalModeActor, 2, UID >*,UID const& value) 
	{
		fdb_probe_actor_enter("testAuditStorageWhenDDBackToNormalMode", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageWhenDDBackToNormalMode", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestAuditStorageWhenDDBackToNormalModeActor, 2, UID >*,UID && value) 
	{
		fdb_probe_actor_enter("testAuditStorageWhenDDBackToNormalMode", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageWhenDDBackToNormalMode", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestAuditStorageWhenDDBackToNormalModeActor, 2, UID >*,Error err) 
	{
		fdb_probe_actor_enter("testAuditStorageWhenDDBackToNormalMode", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageWhenDDBackToNormalMode", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(UID const& auditIdC,int loopDepth) 
	{
															#line 771 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestFunctionalityShardLocationMetadataDoneWhenDDBackToNormalMode", auditIdC);
															#line 772 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<UID> __when_expr_4 = self->auditStorageForType( self, cx, AuditType::ValidateStorageServerShard, "TestAuditStorageWhenDDBackToNormalMode");
															#line 772 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11033 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->actor_wait_state = 5;
															#line 772 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestAuditStorageWhenDDBackToNormalModeActor, 4, UID >*>(static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)));
															#line 11038 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(UID && auditIdC,int loopDepth) 
	{
															#line 771 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestFunctionalityShardLocationMetadataDoneWhenDDBackToNormalMode", auditIdC);
															#line 772 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		StrictFuture<UID> __when_expr_4 = self->auditStorageForType( self, cx, AuditType::ValidateStorageServerShard, "TestAuditStorageWhenDDBackToNormalMode");
															#line 772 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11051 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->actor_wait_state = 5;
															#line 772 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestAuditStorageWhenDDBackToNormalModeActor, 4, UID >*>(static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)));
															#line 11056 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(UID const& auditIdC,int loopDepth) 
	{
		loopDepth = a_body1cont4(auditIdC, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(UID && auditIdC,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(auditIdC), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->actor_wait_state > 0) static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->actor_wait_state = 0;
		static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->ActorCallback< TestAuditStorageWhenDDBackToNormalModeActor, 3, UID >::remove();

	}
	void a_callback_fire(ActorCallback< TestAuditStorageWhenDDBackToNormalModeActor, 3, UID >*,UID const& value) 
	{
		fdb_probe_actor_enter("testAuditStorageWhenDDBackToNormalMode", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageWhenDDBackToNormalMode", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestAuditStorageWhenDDBackToNormalModeActor, 3, UID >*,UID && value) 
	{
		fdb_probe_actor_enter("testAuditStorageWhenDDBackToNormalMode", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageWhenDDBackToNormalMode", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestAuditStorageWhenDDBackToNormalModeActor, 3, UID >*,Error err) 
	{
		fdb_probe_actor_enter("testAuditStorageWhenDDBackToNormalMode", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageWhenDDBackToNormalMode", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont5(UID const& auditIdD,int loopDepth) 
	{
															#line 774 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestFunctionalitySSShardInfoDoneWhenDDBackToNormalMode", auditIdD);
															#line 775 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestAuditStorageWhenDDBackToNormalModeEnd");
															#line 776 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (!static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestAuditStorageWhenDDBackToNormalModeActorState(); static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->destroy(); return 0; }
															#line 11144 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		new (&static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestAuditStorageWhenDDBackToNormalModeActorState();
		static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(UID && auditIdD,int loopDepth) 
	{
															#line 774 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestFunctionalitySSShardInfoDoneWhenDDBackToNormalMode", auditIdD);
															#line 775 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		TraceEvent("TestAuditStorageWhenDDBackToNormalModeEnd");
															#line 776 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
		if (!static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestAuditStorageWhenDDBackToNormalModeActorState(); static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->destroy(); return 0; }
															#line 11160 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		new (&static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestAuditStorageWhenDDBackToNormalModeActorState();
		static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4when1(UID const& auditIdD,int loopDepth) 
	{
		loopDepth = a_body1cont5(auditIdD, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(UID && auditIdD,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(auditIdD), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->actor_wait_state > 0) static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->actor_wait_state = 0;
		static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->ActorCallback< TestAuditStorageWhenDDBackToNormalModeActor, 4, UID >::remove();

	}
	void a_callback_fire(ActorCallback< TestAuditStorageWhenDDBackToNormalModeActor, 4, UID >*,UID const& value) 
	{
		fdb_probe_actor_enter("testAuditStorageWhenDDBackToNormalMode", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageWhenDDBackToNormalMode", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TestAuditStorageWhenDDBackToNormalModeActor, 4, UID >*,UID && value) 
	{
		fdb_probe_actor_enter("testAuditStorageWhenDDBackToNormalMode", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageWhenDDBackToNormalMode", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TestAuditStorageWhenDDBackToNormalModeActor, 4, UID >*,Error err) 
	{
		fdb_probe_actor_enter("testAuditStorageWhenDDBackToNormalMode", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAuditStorageWhenDDBackToNormalMode", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 760 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	ValidateStorage* self;
															#line 760 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	Database cx;
															#line 11247 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
};
// This generated class is to be used only via testAuditStorageWhenDDBackToNormalMode()
															#line 760 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
class TestAuditStorageWhenDDBackToNormalModeActor final : public Actor<Void>, public ActorCallback< TestAuditStorageWhenDDBackToNormalModeActor, 0, Void >, public ActorCallback< TestAuditStorageWhenDDBackToNormalModeActor, 1, UID >, public ActorCallback< TestAuditStorageWhenDDBackToNormalModeActor, 2, UID >, public ActorCallback< TestAuditStorageWhenDDBackToNormalModeActor, 3, UID >, public ActorCallback< TestAuditStorageWhenDDBackToNormalModeActor, 4, UID >, public FastAllocated<TestAuditStorageWhenDDBackToNormalModeActor>, public TestAuditStorageWhenDDBackToNormalModeActorState<TestAuditStorageWhenDDBackToNormalModeActor> {
															#line 11252 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
public:
	using FastAllocated<TestAuditStorageWhenDDBackToNormalModeActor>::operator new;
	using FastAllocated<TestAuditStorageWhenDDBackToNormalModeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13537577362140809728UL, 1834200160293989888UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestAuditStorageWhenDDBackToNormalModeActor, 0, Void >;
friend struct ActorCallback< TestAuditStorageWhenDDBackToNormalModeActor, 1, UID >;
friend struct ActorCallback< TestAuditStorageWhenDDBackToNormalModeActor, 2, UID >;
friend struct ActorCallback< TestAuditStorageWhenDDBackToNormalModeActor, 3, UID >;
friend struct ActorCallback< TestAuditStorageWhenDDBackToNormalModeActor, 4, UID >;
															#line 760 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	TestAuditStorageWhenDDBackToNormalModeActor(ValidateStorage* const& self,Database const& cx) 
															#line 11273 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
		 : Actor<Void>(),
		   TestAuditStorageWhenDDBackToNormalModeActorState<TestAuditStorageWhenDDBackToNormalModeActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testAuditStorageWhenDDBackToNormalMode", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16640248639765298688UL, 3114591518610938624UL);
		ActorExecutionContextHelper __helper(static_cast<TestAuditStorageWhenDDBackToNormalModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testAuditStorageWhenDDBackToNormalMode");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testAuditStorageWhenDDBackToNormalMode", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestAuditStorageWhenDDBackToNormalModeActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestAuditStorageWhenDDBackToNormalModeActor, 1, UID >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestAuditStorageWhenDDBackToNormalModeActor, 2, UID >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TestAuditStorageWhenDDBackToNormalModeActor, 3, UID >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TestAuditStorageWhenDDBackToNormalModeActor, 4, UID >*)0, actor_cancelled()); break;
		}

	}
};
															#line 760 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
[[nodiscard]] Future<Void> testAuditStorageWhenDDBackToNormalMode( ValidateStorage* const& self, Database const& cx ) {
															#line 760 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"
	return Future<Void>(new TestAuditStorageWhenDDBackToNormalModeActor(self, cx));
															#line 11309 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ValidateStorage.actor.g.cpp"
}

#line 778 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/ValidateStorage.actor.cpp"

	Future<bool> check(Database const& cx) override { return true; }

	void getMetrics(std::vector<PerfMetric>& m) override {}
};

WorkloadFactory<ValidateStorage> ValidateStorageFactory;