#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
/*
 * BulkLoading.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/BulkLoading.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/SystemData.h"
#include "fdbserver/BulkLoadUtil.actor.h"
#include "fdbserver/RocksDBCheckpointUtils.actor.h"
#include "fdbserver/StorageMetrics.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

const std::string simulationBulkLoadFolder = joinPath("simfdb", "bulkload");

struct BulkLoadTaskTestUnit {
	BulkLoadTaskTestUnit() = default;

	size_t getTotalBytes() const {
		size_t bytes = 0;
		for (const auto& kv : data) {
			bytes = bytes + kv.expectedSize(); // This size is different from size used by fetchKeys
		}
		return bytes;
	}

	size_t getKeyCount() const { return data.size(); }

	KeyRange getRange() const { return bulkLoadTask.getRange(); }

	std::string toString() const {
		return "[BulkLoadTaskTestUnit]: [Bytes]: " + std::to_string(getTotalBytes()) +
		       ", [Keys]: " + std::to_string(getKeyCount());
	}

	BulkLoadTaskState bulkLoadTask;
	std::vector<KeyValue> data;
};

struct BulkLoading : TestWorkload {
	static constexpr auto NAME = "BulkLoadingWorkload";
	const bool enabled = true;
	bool pass = true;
	bool debugging = false;
	bool backgroundTrafficEnabled = deterministicRandom()->coinflip();
	UID jobId = deterministicRandom()->randomUniqueID();
	bool initializeBulkLoadMetadata = deterministicRandom()->coinflip();

	// This workload is not compatible with following workload because they will race in changing the DD mode
	// This workload is not compatible with RandomRangeLock for the conflict in range lock
	void disableFailureInjectionWorkloads(std::set<std::string>& out) const override {
		out.insert({ "RandomMoveKeys",
		             "DataLossRecovery",
		             "IDDTxnProcessorApiCorrectness",
		             "PerpetualWiggleStatsWorkload",
		             "PhysicalShardMove",
		             "StorageCorruption",
		             "StorageServerCheckpointRestoreTest",
		             "ValidateStorage",
		             "RandomRangeLock",
		             "BulkDumping" });
	}

	BulkLoading(WorkloadContext const& wcx) : TestWorkload(wcx), enabled(true), pass(true) {}

	Future<Void> setup(Database const& cx) override { return Void(); }

	Future<Void> start(Database const& cx) override { return _start(this, cx); }

	Future<bool> check(Database const& cx) override { return true; }

	void getMetrics(std::vector<PerfMetric>& m) override {}

																#line 93 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
// This generated class is to be used only via clearAllBulkLoadTask()
															#line 91 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
template <class ClearAllBulkLoadTaskActor>
															#line 91 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
class ClearAllBulkLoadTaskActorState {
															#line 99 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
public:
															#line 91 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	ClearAllBulkLoadTaskActorState(Database const& cx) 
															#line 91 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
															#line 91 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		 : cx(cx),
															#line 92 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		   tr(cx)
															#line 108 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
	{
		fdb_probe_actor_create("clearAllBulkLoadTask", reinterpret_cast<unsigned long>(this));

	}
	~ClearAllBulkLoadTaskActorState() 
	{
		fdb_probe_actor_destroy("clearAllBulkLoadTask", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 93 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			;
															#line 123 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClearAllBulkLoadTaskActorState();
		static_cast<ClearAllBulkLoadTaskActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 104 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (!static_cast<ClearAllBulkLoadTaskActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClearAllBulkLoadTaskActorState(); static_cast<ClearAllBulkLoadTaskActor*>(this)->destroy(); return 0; }
															#line 146 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		new (&static_cast<ClearAllBulkLoadTaskActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClearAllBulkLoadTaskActorState();
		static_cast<ClearAllBulkLoadTaskActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 95 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 96 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 97 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			StrictFuture<Void> __when_expr_0 = krmSetRange(&tr, bulkLoadTaskPrefix, normalKeys, bulkLoadTaskStateValue(BulkLoadTaskState()));
															#line 97 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (static_cast<ClearAllBulkLoadTaskActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 172 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ClearAllBulkLoadTaskActor*>(this)->actor_wait_state = 1;
															#line 97 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClearAllBulkLoadTaskActor, 0, Void >*>(static_cast<ClearAllBulkLoadTaskActor*>(this)));
															#line 177 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 101 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 101 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (static_cast<ClearAllBulkLoadTaskActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 214 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<ClearAllBulkLoadTaskActor*>(this)->actor_wait_state = 3;
															#line 101 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ClearAllBulkLoadTaskActor, 2, Void >*>(static_cast<ClearAllBulkLoadTaskActor*>(this)));
															#line 219 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 98 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 98 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<ClearAllBulkLoadTaskActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 236 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ClearAllBulkLoadTaskActor*>(this)->actor_wait_state = 2;
															#line 98 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClearAllBulkLoadTaskActor, 1, Void >*>(static_cast<ClearAllBulkLoadTaskActor*>(this)));
															#line 241 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 98 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 98 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<ClearAllBulkLoadTaskActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 252 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ClearAllBulkLoadTaskActor*>(this)->actor_wait_state = 2;
															#line 98 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClearAllBulkLoadTaskActor, 1, Void >*>(static_cast<ClearAllBulkLoadTaskActor*>(this)));
															#line 257 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClearAllBulkLoadTaskActor*>(this)->actor_wait_state > 0) static_cast<ClearAllBulkLoadTaskActor*>(this)->actor_wait_state = 0;
		static_cast<ClearAllBulkLoadTaskActor*>(this)->ActorCallback< ClearAllBulkLoadTaskActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClearAllBulkLoadTaskActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clearAllBulkLoadTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAllBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAllBulkLoadTask", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClearAllBulkLoadTaskActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clearAllBulkLoadTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAllBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAllBulkLoadTask", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClearAllBulkLoadTaskActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clearAllBulkLoadTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAllBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAllBulkLoadTask", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ClearAllBulkLoadTaskActor*>(this)->actor_wait_state > 0) static_cast<ClearAllBulkLoadTaskActor*>(this)->actor_wait_state = 0;
		static_cast<ClearAllBulkLoadTaskActor*>(this)->ActorCallback< ClearAllBulkLoadTaskActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClearAllBulkLoadTaskActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clearAllBulkLoadTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAllBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAllBulkLoadTask", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClearAllBulkLoadTaskActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clearAllBulkLoadTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAllBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAllBulkLoadTask", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClearAllBulkLoadTaskActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clearAllBulkLoadTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAllBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAllBulkLoadTask", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ClearAllBulkLoadTaskActor*>(this)->actor_wait_state > 0) static_cast<ClearAllBulkLoadTaskActor*>(this)->actor_wait_state = 0;
		static_cast<ClearAllBulkLoadTaskActor*>(this)->ActorCallback< ClearAllBulkLoadTaskActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClearAllBulkLoadTaskActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clearAllBulkLoadTask", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAllBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAllBulkLoadTask", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ClearAllBulkLoadTaskActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clearAllBulkLoadTask", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAllBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAllBulkLoadTask", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ClearAllBulkLoadTaskActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clearAllBulkLoadTask", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAllBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAllBulkLoadTask", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 91 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	Database cx;
															#line 92 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	Transaction tr;
															#line 515 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
};
// This generated class is to be used only via clearAllBulkLoadTask()
															#line 91 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
class ClearAllBulkLoadTaskActor final : public Actor<Void>, public ActorCallback< ClearAllBulkLoadTaskActor, 0, Void >, public ActorCallback< ClearAllBulkLoadTaskActor, 1, Void >, public ActorCallback< ClearAllBulkLoadTaskActor, 2, Void >, public FastAllocated<ClearAllBulkLoadTaskActor>, public ClearAllBulkLoadTaskActorState<ClearAllBulkLoadTaskActor> {
															#line 520 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
public:
	using FastAllocated<ClearAllBulkLoadTaskActor>::operator new;
	using FastAllocated<ClearAllBulkLoadTaskActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7521731026712212224UL, 16042213576162493696UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClearAllBulkLoadTaskActor, 0, Void >;
friend struct ActorCallback< ClearAllBulkLoadTaskActor, 1, Void >;
friend struct ActorCallback< ClearAllBulkLoadTaskActor, 2, Void >;
															#line 91 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	ClearAllBulkLoadTaskActor(Database const& cx) 
															#line 539 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		 : Actor<Void>(),
		   ClearAllBulkLoadTaskActorState<ClearAllBulkLoadTaskActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clearAllBulkLoadTask", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6120341800804442880UL, 10309690102109238528UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAllBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clearAllBulkLoadTask");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clearAllBulkLoadTask", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClearAllBulkLoadTaskActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ClearAllBulkLoadTaskActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ClearAllBulkLoadTaskActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 91 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
[[nodiscard]] Future<Void> clearAllBulkLoadTask( Database const& cx ) {
															#line 91 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	return Future<Void>(new ClearAllBulkLoadTaskActor(cx));
															#line 573 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
}

#line 106 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"

	// Submit task can be failed due to range lock reject
																#line 579 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
// This generated class is to be used only via submitBulkLoadTask()
															#line 108 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
template <class SubmitBulkLoadTaskActor>
															#line 108 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
class SubmitBulkLoadTaskActorState {
															#line 585 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
public:
															#line 108 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	SubmitBulkLoadTaskActorState(Database const& cx,BulkLoadTaskState const& bulkLoadTask) 
															#line 108 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
															#line 108 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		 : cx(cx),
															#line 108 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		   bulkLoadTask(bulkLoadTask)
															#line 594 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
	{
		fdb_probe_actor_create("submitBulkLoadTask", reinterpret_cast<unsigned long>(this));

	}
	~SubmitBulkLoadTaskActorState() 
	{
		fdb_probe_actor_destroy("submitBulkLoadTask", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 109 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			;
															#line 609 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SubmitBulkLoadTaskActorState();
		static_cast<SubmitBulkLoadTaskActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 129 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (!static_cast<SubmitBulkLoadTaskActor*>(this)->SAV<bool>::futures) { (void)(true); this->~SubmitBulkLoadTaskActorState(); static_cast<SubmitBulkLoadTaskActor*>(this)->destroy(); return 0; }
															#line 632 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		new (&static_cast<SubmitBulkLoadTaskActor*>(this)->SAV< bool >::value()) bool(true);
		this->~SubmitBulkLoadTaskActorState();
		static_cast<SubmitBulkLoadTaskActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 111 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			tr = Transaction(cx);
															#line 112 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			StrictFuture<Void> __when_expr_0 = setBulkLoadSubmissionTransaction(&tr, bulkLoadTask, false);
															#line 112 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (static_cast<SubmitBulkLoadTaskActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 656 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SubmitBulkLoadTaskActor*>(this)->actor_wait_state = 1;
															#line 112 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SubmitBulkLoadTaskActor, 0, Void >*>(static_cast<SubmitBulkLoadTaskActor*>(this)));
															#line 661 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 118 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			TraceEvent(SevWarn, "BulkLoadingSubmitBulkLoadTaskError") .setMaxEventLength(-1) .setMaxFieldLength(-1) .errorUnsuppressed(e) .detail("BulkLoadTaskState", bulkLoadTask.toString());
															#line 123 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (e.code() == error_code_range_lock_reject)
															#line 698 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			{
															#line 124 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				if (!static_cast<SubmitBulkLoadTaskActor*>(this)->SAV<bool>::futures) { (void)(false); this->~SubmitBulkLoadTaskActorState(); static_cast<SubmitBulkLoadTaskActor*>(this)->destroy(); return 0; }
															#line 702 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
				new (&static_cast<SubmitBulkLoadTaskActor*>(this)->SAV< bool >::value()) bool(false);
				this->~SubmitBulkLoadTaskActorState();
				static_cast<SubmitBulkLoadTaskActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 126 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			StrictFuture<Void> __when_expr_2 = delay(0.1);
															#line 126 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (static_cast<SubmitBulkLoadTaskActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 712 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<SubmitBulkLoadTaskActor*>(this)->actor_wait_state = 3;
															#line 126 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SubmitBulkLoadTaskActor, 2, Void >*>(static_cast<SubmitBulkLoadTaskActor*>(this)));
															#line 717 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 113 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 113 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<SubmitBulkLoadTaskActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 734 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<SubmitBulkLoadTaskActor*>(this)->actor_wait_state = 2;
															#line 113 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SubmitBulkLoadTaskActor, 1, Void >*>(static_cast<SubmitBulkLoadTaskActor*>(this)));
															#line 739 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 113 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 113 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<SubmitBulkLoadTaskActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 750 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<SubmitBulkLoadTaskActor*>(this)->actor_wait_state = 2;
															#line 113 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SubmitBulkLoadTaskActor, 1, Void >*>(static_cast<SubmitBulkLoadTaskActor*>(this)));
															#line 755 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SubmitBulkLoadTaskActor*>(this)->actor_wait_state > 0) static_cast<SubmitBulkLoadTaskActor*>(this)->actor_wait_state = 0;
		static_cast<SubmitBulkLoadTaskActor*>(this)->ActorCallback< SubmitBulkLoadTaskActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SubmitBulkLoadTaskActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("submitBulkLoadTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitBulkLoadTask", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SubmitBulkLoadTaskActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("submitBulkLoadTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitBulkLoadTask", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SubmitBulkLoadTaskActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("submitBulkLoadTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitBulkLoadTask", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 114 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		TraceEvent(SevDebug, "BulkLoadingSubmitBulkLoadTask") .detail("BulkLoadTaskState", bulkLoadTask.toString());
															#line 839 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 114 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		TraceEvent(SevDebug, "BulkLoadingSubmitBulkLoadTask") .detail("BulkLoadTaskState", bulkLoadTask.toString());
															#line 848 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SubmitBulkLoadTaskActor*>(this)->actor_wait_state > 0) static_cast<SubmitBulkLoadTaskActor*>(this)->actor_wait_state = 0;
		static_cast<SubmitBulkLoadTaskActor*>(this)->ActorCallback< SubmitBulkLoadTaskActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SubmitBulkLoadTaskActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("submitBulkLoadTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitBulkLoadTask", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SubmitBulkLoadTaskActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("submitBulkLoadTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitBulkLoadTask", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SubmitBulkLoadTaskActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("submitBulkLoadTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitBulkLoadTask", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<SubmitBulkLoadTaskActor*>(this)->actor_wait_state > 0) static_cast<SubmitBulkLoadTaskActor*>(this)->actor_wait_state = 0;
		static_cast<SubmitBulkLoadTaskActor*>(this)->ActorCallback< SubmitBulkLoadTaskActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SubmitBulkLoadTaskActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("submitBulkLoadTask", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitBulkLoadTask", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< SubmitBulkLoadTaskActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("submitBulkLoadTask", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitBulkLoadTask", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< SubmitBulkLoadTaskActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("submitBulkLoadTask", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitBulkLoadTask", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 108 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	Database cx;
															#line 108 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	BulkLoadTaskState bulkLoadTask;
															#line 111 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	Transaction tr;
															#line 1021 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
};
// This generated class is to be used only via submitBulkLoadTask()
															#line 108 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
class SubmitBulkLoadTaskActor final : public Actor<bool>, public ActorCallback< SubmitBulkLoadTaskActor, 0, Void >, public ActorCallback< SubmitBulkLoadTaskActor, 1, Void >, public ActorCallback< SubmitBulkLoadTaskActor, 2, Void >, public FastAllocated<SubmitBulkLoadTaskActor>, public SubmitBulkLoadTaskActorState<SubmitBulkLoadTaskActor> {
															#line 1026 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
public:
	using FastAllocated<SubmitBulkLoadTaskActor>::operator new;
	using FastAllocated<SubmitBulkLoadTaskActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7861773550481775872UL, 10702307754282237696UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SubmitBulkLoadTaskActor, 0, Void >;
friend struct ActorCallback< SubmitBulkLoadTaskActor, 1, Void >;
friend struct ActorCallback< SubmitBulkLoadTaskActor, 2, Void >;
															#line 108 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	SubmitBulkLoadTaskActor(Database const& cx,BulkLoadTaskState const& bulkLoadTask) 
															#line 1045 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		 : Actor<bool>(),
		   SubmitBulkLoadTaskActorState<SubmitBulkLoadTaskActor>(cx, bulkLoadTask),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("submitBulkLoadTask", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7626601752670957568UL, 15362552488201644288UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("submitBulkLoadTask");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("submitBulkLoadTask", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SubmitBulkLoadTaskActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SubmitBulkLoadTaskActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< SubmitBulkLoadTaskActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 108 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
[[nodiscard]] Future<bool> submitBulkLoadTask( Database const& cx, BulkLoadTaskState const& bulkLoadTask ) {
															#line 108 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	return Future<bool>(new SubmitBulkLoadTaskActor(cx, bulkLoadTask));
															#line 1079 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
}

#line 131 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"

	// Finish task must always succeed
																#line 1085 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
// This generated class is to be used only via finalizeBulkLoadTask()
															#line 133 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
template <class FinalizeBulkLoadTaskActor>
															#line 133 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
class FinalizeBulkLoadTaskActorState {
															#line 1091 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
public:
															#line 133 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	FinalizeBulkLoadTaskActorState(Database const& cx,KeyRange const& range,UID const& taskId) 
															#line 133 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
															#line 133 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		 : cx(cx),
															#line 133 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		   range(range),
															#line 133 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		   taskId(taskId)
															#line 1102 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
	{
		fdb_probe_actor_create("finalizeBulkLoadTask", reinterpret_cast<unsigned long>(this));

	}
	~FinalizeBulkLoadTaskActorState() 
	{
		fdb_probe_actor_destroy("finalizeBulkLoadTask", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 134 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			;
															#line 1117 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FinalizeBulkLoadTaskActorState();
		static_cast<FinalizeBulkLoadTaskActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 152 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (!static_cast<FinalizeBulkLoadTaskActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FinalizeBulkLoadTaskActorState(); static_cast<FinalizeBulkLoadTaskActor*>(this)->destroy(); return 0; }
															#line 1140 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		new (&static_cast<FinalizeBulkLoadTaskActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FinalizeBulkLoadTaskActorState();
		static_cast<FinalizeBulkLoadTaskActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 136 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			tr = Transaction(cx);
															#line 137 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			StrictFuture<Void> __when_expr_0 = setBulkLoadFinalizeTransaction(&tr, range, taskId, false);
															#line 137 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (static_cast<FinalizeBulkLoadTaskActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1164 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FinalizeBulkLoadTaskActor*>(this)->actor_wait_state = 1;
															#line 137 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FinalizeBulkLoadTaskActor, 0, Void >*>(static_cast<FinalizeBulkLoadTaskActor*>(this)));
															#line 1169 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 144 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			TraceEvent(SevWarn, "BulkLoadingAcknowledgeBulkLoadTaskError") .errorUnsuppressed(e) .detail("TaskID", taskId.toString()) .detail("TaskRange", range);
															#line 148 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			ASSERT(e.code() != error_code_bulkload_task_outdated && e.code() != error_code_range_lock_reject);
															#line 149 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			StrictFuture<Void> __when_expr_2 = delay(0.1);
															#line 149 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (static_cast<FinalizeBulkLoadTaskActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1210 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<FinalizeBulkLoadTaskActor*>(this)->actor_wait_state = 3;
															#line 149 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FinalizeBulkLoadTaskActor, 2, Void >*>(static_cast<FinalizeBulkLoadTaskActor*>(this)));
															#line 1215 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 138 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 138 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<FinalizeBulkLoadTaskActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1232 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<FinalizeBulkLoadTaskActor*>(this)->actor_wait_state = 2;
															#line 138 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FinalizeBulkLoadTaskActor, 1, Void >*>(static_cast<FinalizeBulkLoadTaskActor*>(this)));
															#line 1237 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 138 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 138 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<FinalizeBulkLoadTaskActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1248 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<FinalizeBulkLoadTaskActor*>(this)->actor_wait_state = 2;
															#line 138 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FinalizeBulkLoadTaskActor, 1, Void >*>(static_cast<FinalizeBulkLoadTaskActor*>(this)));
															#line 1253 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FinalizeBulkLoadTaskActor*>(this)->actor_wait_state > 0) static_cast<FinalizeBulkLoadTaskActor*>(this)->actor_wait_state = 0;
		static_cast<FinalizeBulkLoadTaskActor*>(this)->ActorCallback< FinalizeBulkLoadTaskActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinalizeBulkLoadTaskActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finalizeBulkLoadTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinalizeBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finalizeBulkLoadTask", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FinalizeBulkLoadTaskActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finalizeBulkLoadTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinalizeBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finalizeBulkLoadTask", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FinalizeBulkLoadTaskActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finalizeBulkLoadTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinalizeBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finalizeBulkLoadTask", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 139 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		TraceEvent(SevDebug, "BulkLoadingAcknowledgeBulkLoadTask") .detail("TaskID", taskId.toString()) .detail("TaskRange", range);
															#line 1337 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 139 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		TraceEvent(SevDebug, "BulkLoadingAcknowledgeBulkLoadTask") .detail("TaskID", taskId.toString()) .detail("TaskRange", range);
															#line 1346 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FinalizeBulkLoadTaskActor*>(this)->actor_wait_state > 0) static_cast<FinalizeBulkLoadTaskActor*>(this)->actor_wait_state = 0;
		static_cast<FinalizeBulkLoadTaskActor*>(this)->ActorCallback< FinalizeBulkLoadTaskActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinalizeBulkLoadTaskActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finalizeBulkLoadTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinalizeBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finalizeBulkLoadTask", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FinalizeBulkLoadTaskActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finalizeBulkLoadTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinalizeBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finalizeBulkLoadTask", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FinalizeBulkLoadTaskActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finalizeBulkLoadTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinalizeBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finalizeBulkLoadTask", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FinalizeBulkLoadTaskActor*>(this)->actor_wait_state > 0) static_cast<FinalizeBulkLoadTaskActor*>(this)->actor_wait_state = 0;
		static_cast<FinalizeBulkLoadTaskActor*>(this)->ActorCallback< FinalizeBulkLoadTaskActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinalizeBulkLoadTaskActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finalizeBulkLoadTask", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinalizeBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finalizeBulkLoadTask", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FinalizeBulkLoadTaskActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finalizeBulkLoadTask", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinalizeBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finalizeBulkLoadTask", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FinalizeBulkLoadTaskActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finalizeBulkLoadTask", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinalizeBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finalizeBulkLoadTask", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 133 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	Database cx;
															#line 133 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	KeyRange range;
															#line 133 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	UID taskId;
															#line 136 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	Transaction tr;
															#line 1521 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
};
// This generated class is to be used only via finalizeBulkLoadTask()
															#line 133 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
class FinalizeBulkLoadTaskActor final : public Actor<Void>, public ActorCallback< FinalizeBulkLoadTaskActor, 0, Void >, public ActorCallback< FinalizeBulkLoadTaskActor, 1, Void >, public ActorCallback< FinalizeBulkLoadTaskActor, 2, Void >, public FastAllocated<FinalizeBulkLoadTaskActor>, public FinalizeBulkLoadTaskActorState<FinalizeBulkLoadTaskActor> {
															#line 1526 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
public:
	using FastAllocated<FinalizeBulkLoadTaskActor>::operator new;
	using FastAllocated<FinalizeBulkLoadTaskActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10634395262264567296UL, 11231150144619411456UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FinalizeBulkLoadTaskActor, 0, Void >;
friend struct ActorCallback< FinalizeBulkLoadTaskActor, 1, Void >;
friend struct ActorCallback< FinalizeBulkLoadTaskActor, 2, Void >;
															#line 133 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	FinalizeBulkLoadTaskActor(Database const& cx,KeyRange const& range,UID const& taskId) 
															#line 1545 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		 : Actor<Void>(),
		   FinalizeBulkLoadTaskActorState<FinalizeBulkLoadTaskActor>(cx, range, taskId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("finalizeBulkLoadTask", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11877883446389486336UL, 6580607135629378560UL);
		ActorExecutionContextHelper __helper(static_cast<FinalizeBulkLoadTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("finalizeBulkLoadTask");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("finalizeBulkLoadTask", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FinalizeBulkLoadTaskActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FinalizeBulkLoadTaskActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FinalizeBulkLoadTaskActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 133 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
[[nodiscard]] Future<Void> finalizeBulkLoadTask( Database const& cx, KeyRange const& range, UID const& taskId ) {
															#line 133 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	return Future<Void>(new FinalizeBulkLoadTaskActor(cx, range, taskId));
															#line 1579 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
}

#line 154 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"

																#line 1584 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
// This generated class is to be used only via checkDDEnabled()
															#line 155 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
template <class CheckDDEnabledActor>
															#line 155 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
class CheckDDEnabledActorState {
															#line 1590 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
public:
															#line 155 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	CheckDDEnabledActorState(Database const& cx) 
															#line 155 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
															#line 155 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		 : cx(cx)
															#line 1597 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
	{
		fdb_probe_actor_create("checkDDEnabled", reinterpret_cast<unsigned long>(this));

	}
	~CheckDDEnabledActorState() 
	{
		fdb_probe_actor_destroy("checkDDEnabled", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 156 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			;
															#line 1612 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckDDEnabledActorState();
		static_cast<CheckDDEnabledActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 157 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		tr = Transaction(cx);
															#line 158 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 1644 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		try {
															#line 160 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			ddMode = 1;
															#line 161 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(dataDistributionModeKey);
															#line 161 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (static_cast<CheckDDEnabledActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1652 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckDDEnabledActor*>(this)->actor_wait_state = 1;
															#line 161 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckDDEnabledActor, 0, Optional<Value> >*>(static_cast<CheckDDEnabledActor*>(this)));
															#line 1657 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 169 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 169 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (static_cast<CheckDDEnabledActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1681 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CheckDDEnabledActor*>(this)->actor_wait_state = 2;
															#line 169 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckDDEnabledActor, 1, Void >*>(static_cast<CheckDDEnabledActor*>(this)));
															#line 1686 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& mode,int loopDepth) 
	{
															#line 162 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (mode.present())
															#line 1701 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		{
															#line 163 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			BinaryReader rd(mode.get(), Unversioned());
															#line 164 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			rd >> ddMode;
															#line 1707 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		}
															#line 166 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (!static_cast<CheckDDEnabledActor*>(this)->SAV<bool>::futures) { (void)(ddMode == 1); this->~CheckDDEnabledActorState(); static_cast<CheckDDEnabledActor*>(this)->destroy(); return 0; }
															#line 1711 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		new (&static_cast<CheckDDEnabledActor*>(this)->SAV< bool >::value()) bool(ddMode == 1);
		this->~CheckDDEnabledActorState();
		static_cast<CheckDDEnabledActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && mode,int loopDepth) 
	{
															#line 162 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (mode.present())
															#line 1723 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		{
															#line 163 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			BinaryReader rd(mode.get(), Unversioned());
															#line 164 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			rd >> ddMode;
															#line 1729 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		}
															#line 166 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (!static_cast<CheckDDEnabledActor*>(this)->SAV<bool>::futures) { (void)(ddMode == 1); this->~CheckDDEnabledActorState(); static_cast<CheckDDEnabledActor*>(this)->destroy(); return 0; }
															#line 1733 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		new (&static_cast<CheckDDEnabledActor*>(this)->SAV< bool >::value()) bool(ddMode == 1);
		this->~CheckDDEnabledActorState();
		static_cast<CheckDDEnabledActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& mode,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(mode, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && mode,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(mode), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckDDEnabledActor*>(this)->actor_wait_state > 0) static_cast<CheckDDEnabledActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDDEnabledActor*>(this)->ActorCallback< CheckDDEnabledActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDDEnabledActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("checkDDEnabled", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDDEnabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDDEnabled", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckDDEnabledActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("checkDDEnabled", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDDEnabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDDEnabled", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckDDEnabledActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("checkDDEnabled", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDDEnabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDDEnabled", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckDDEnabledActor*>(this)->actor_wait_state > 0) static_cast<CheckDDEnabledActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDDEnabledActor*>(this)->ActorCallback< CheckDDEnabledActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDDEnabledActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkDDEnabled", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDDEnabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDDEnabled", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckDDEnabledActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkDDEnabled", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDDEnabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDDEnabled", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckDDEnabledActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkDDEnabled", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDDEnabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDDEnabled", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 155 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	Database cx;
															#line 157 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	Transaction tr;
															#line 160 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	int ddMode;
															#line 1909 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
};
// This generated class is to be used only via checkDDEnabled()
															#line 155 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
class CheckDDEnabledActor final : public Actor<bool>, public ActorCallback< CheckDDEnabledActor, 0, Optional<Value> >, public ActorCallback< CheckDDEnabledActor, 1, Void >, public FastAllocated<CheckDDEnabledActor>, public CheckDDEnabledActorState<CheckDDEnabledActor> {
															#line 1914 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
public:
	using FastAllocated<CheckDDEnabledActor>::operator new;
	using FastAllocated<CheckDDEnabledActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12192629829566284800UL, 10796553767735767040UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckDDEnabledActor, 0, Optional<Value> >;
friend struct ActorCallback< CheckDDEnabledActor, 1, Void >;
															#line 155 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	CheckDDEnabledActor(Database const& cx) 
															#line 1932 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		 : Actor<bool>(),
		   CheckDDEnabledActorState<CheckDDEnabledActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkDDEnabled", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11220408577052478208UL, 10499007195067868160UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDDEnabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkDDEnabled");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkDDEnabled", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckDDEnabledActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckDDEnabledActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 155 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
[[nodiscard]] Future<bool> checkDDEnabled( Database const& cx ) {
															#line 155 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	return Future<bool>(new CheckDDEnabledActor(cx));
															#line 1965 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
}

#line 173 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"

	// First return value is whether all tasks are complete or error.
	// Second return value is the error tasks.
																#line 1972 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
// This generated class is to be used only via checkAllTaskCompleteOrError()
															#line 176 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
template <class CheckAllTaskCompleteOrErrorActor>
															#line 176 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
class CheckAllTaskCompleteOrErrorActorState {
															#line 1978 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
public:
															#line 176 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	CheckAllTaskCompleteOrErrorActorState(Database const& cx) 
															#line 176 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
															#line 176 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		 : cx(cx),
															#line 177 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		   tr(cx),
															#line 178 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		   beginKey(allKeys.begin),
															#line 179 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		   endKey(allKeys.end),
															#line 180 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		   errorTasks()
															#line 1993 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
	{
		fdb_probe_actor_create("checkAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this));

	}
	~CheckAllTaskCompleteOrErrorActorState() 
	{
		fdb_probe_actor_destroy("checkAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 181 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			;
															#line 2008 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckAllTaskCompleteOrErrorActorState();
		static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 218 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (!static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->SAV<std::pair<bool, std::vector<BulkLoadTaskState>>>::futures) { (void)(std::make_pair(true, errorTasks)); this->~CheckAllTaskCompleteOrErrorActorState(); static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->destroy(); return 0; }
															#line 2031 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		new (&static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->SAV< std::pair<bool, std::vector<BulkLoadTaskState>> >::value()) std::pair<bool, std::vector<BulkLoadTaskState>>(std::make_pair(true, errorTasks));
		this->~CheckAllTaskCompleteOrErrorActorState();
		static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 181 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (!(beginKey < endKey))
															#line 2050 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		try {
															#line 183 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 184 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = krmGetRanges(&tr, bulkLoadTaskPrefix, Standalone(KeyRangeRef(beginKey, endKey)));
															#line 184 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2061 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->actor_wait_state = 1;
															#line 184 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckAllTaskCompleteOrErrorActor, 0, RangeResult >*>(static_cast<CheckAllTaskCompleteOrErrorActor*>(this)));
															#line 2066 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 215 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 215 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2103 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->actor_wait_state = 2;
															#line 215 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckAllTaskCompleteOrErrorActor, 1, Void >*>(static_cast<CheckAllTaskCompleteOrErrorActor*>(this)));
															#line 2108 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(RangeResult const& res,int loopDepth) 
	{
															#line 186 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		for(int i = 0;i < res.size() - 1;i++) {
															#line 187 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (!res[i].value.empty())
															#line 2125 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			{
															#line 188 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				BulkLoadTaskState bulkLoadTaskState = decodeBulkLoadTaskState(res[i].value);
															#line 189 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				if (!bulkLoadTaskState.isValid())
															#line 2131 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
				{
					continue;
				}
															#line 193 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				if (bulkLoadTaskState.getRange() != KeyRangeRef(res[i].key, res[i + 1].key))
															#line 2137 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
				{
					continue;
				}
															#line 196 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				if (bulkLoadTaskState.phase != BulkLoadPhase::Complete && bulkLoadTaskState.phase != BulkLoadPhase::Error)
															#line 2143 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
				{
															#line 198 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
					TraceEvent("BulkLoadingWorkLoadIncompleteTasks") .setMaxEventLength(-1) .setMaxFieldLength(-1) .detail("Task", bulkLoadTaskState.toString());
															#line 202 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
					if (!static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->SAV<std::pair<bool, std::vector<BulkLoadTaskState>>>::futures) { (void)(std::make_pair(false, errorTasks)); this->~CheckAllTaskCompleteOrErrorActorState(); static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->destroy(); return 0; }
															#line 2149 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
					new (&static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->SAV< std::pair<bool, std::vector<BulkLoadTaskState>> >::value()) std::pair<bool, std::vector<BulkLoadTaskState>>(std::make_pair(false, errorTasks));
					this->~CheckAllTaskCompleteOrErrorActorState();
					static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 204 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				if (bulkLoadTaskState.phase == BulkLoadPhase::Error)
															#line 2157 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
				{
															#line 205 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
					TraceEvent("BulkLoadingWorkLoadFailedTasks") .setMaxEventLength(-1) .setMaxFieldLength(-1) .detail("Task", bulkLoadTaskState.toString());
															#line 209 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
					errorTasks.push_back(bulkLoadTaskState);
															#line 2163 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
				}
			}
		}
															#line 213 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		beginKey = res[res.size() - 1].key;
															#line 2169 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(RangeResult && res,int loopDepth) 
	{
															#line 186 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		for(int i = 0;i < res.size() - 1;i++) {
															#line 187 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (!res[i].value.empty())
															#line 2180 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			{
															#line 188 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				BulkLoadTaskState bulkLoadTaskState = decodeBulkLoadTaskState(res[i].value);
															#line 189 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				if (!bulkLoadTaskState.isValid())
															#line 2186 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
				{
					continue;
				}
															#line 193 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				if (bulkLoadTaskState.getRange() != KeyRangeRef(res[i].key, res[i + 1].key))
															#line 2192 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
				{
					continue;
				}
															#line 196 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				if (bulkLoadTaskState.phase != BulkLoadPhase::Complete && bulkLoadTaskState.phase != BulkLoadPhase::Error)
															#line 2198 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
				{
															#line 198 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
					TraceEvent("BulkLoadingWorkLoadIncompleteTasks") .setMaxEventLength(-1) .setMaxFieldLength(-1) .detail("Task", bulkLoadTaskState.toString());
															#line 202 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
					if (!static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->SAV<std::pair<bool, std::vector<BulkLoadTaskState>>>::futures) { (void)(std::make_pair(false, errorTasks)); this->~CheckAllTaskCompleteOrErrorActorState(); static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->destroy(); return 0; }
															#line 2204 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
					new (&static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->SAV< std::pair<bool, std::vector<BulkLoadTaskState>> >::value()) std::pair<bool, std::vector<BulkLoadTaskState>>(std::make_pair(false, errorTasks));
					this->~CheckAllTaskCompleteOrErrorActorState();
					static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 204 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				if (bulkLoadTaskState.phase == BulkLoadPhase::Error)
															#line 2212 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
				{
															#line 205 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
					TraceEvent("BulkLoadingWorkLoadFailedTasks") .setMaxEventLength(-1) .setMaxFieldLength(-1) .detail("Task", bulkLoadTaskState.toString());
															#line 209 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
					errorTasks.push_back(bulkLoadTaskState);
															#line 2218 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
				}
			}
		}
															#line 213 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		beginKey = res[res.size() - 1].key;
															#line 2224 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(res, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->actor_wait_state > 0) static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->actor_wait_state = 0;
		static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->ActorCallback< CheckAllTaskCompleteOrErrorActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CheckAllTaskCompleteOrErrorActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("checkAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckAllTaskCompleteOrErrorActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("checkAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckAllTaskCompleteOrErrorActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("checkAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont11(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->actor_wait_state > 0) static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->actor_wait_state = 0;
		static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->ActorCallback< CheckAllTaskCompleteOrErrorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckAllTaskCompleteOrErrorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckAllTaskCompleteOrErrorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckAllTaskCompleteOrErrorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 176 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	Database cx;
															#line 177 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	Transaction tr;
															#line 178 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	Key beginKey;
															#line 179 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	Key endKey;
															#line 180 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	std::vector<BulkLoadTaskState> errorTasks;
															#line 2414 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
};
// This generated class is to be used only via checkAllTaskCompleteOrError()
															#line 176 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
class CheckAllTaskCompleteOrErrorActor final : public Actor<std::pair<bool, std::vector<BulkLoadTaskState>>>, public ActorCallback< CheckAllTaskCompleteOrErrorActor, 0, RangeResult >, public ActorCallback< CheckAllTaskCompleteOrErrorActor, 1, Void >, public FastAllocated<CheckAllTaskCompleteOrErrorActor>, public CheckAllTaskCompleteOrErrorActorState<CheckAllTaskCompleteOrErrorActor> {
															#line 2419 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
public:
	using FastAllocated<CheckAllTaskCompleteOrErrorActor>::operator new;
	using FastAllocated<CheckAllTaskCompleteOrErrorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10913731568131062784UL, 1256475883228277248UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::pair<bool, std::vector<BulkLoadTaskState>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckAllTaskCompleteOrErrorActor, 0, RangeResult >;
friend struct ActorCallback< CheckAllTaskCompleteOrErrorActor, 1, Void >;
															#line 176 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	CheckAllTaskCompleteOrErrorActor(Database const& cx) 
															#line 2437 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		 : Actor<std::pair<bool, std::vector<BulkLoadTaskState>>>(),
		   CheckAllTaskCompleteOrErrorActorState<CheckAllTaskCompleteOrErrorActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10583912992162580992UL, 13840933963605920512UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAllTaskCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkAllTaskCompleteOrError");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckAllTaskCompleteOrErrorActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckAllTaskCompleteOrErrorActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 176 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
[[nodiscard]] Future<std::pair<bool, std::vector<BulkLoadTaskState>>> checkAllTaskCompleteOrError( Database const& cx ) {
															#line 176 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	return Future<std::pair<bool, std::vector<BulkLoadTaskState>>>(new CheckAllTaskCompleteOrErrorActor(cx));
															#line 2470 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
}

#line 220 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"

																#line 2475 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
// This generated class is to be used only via waitUntilAllTaskCompleteOrError()
															#line 221 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
template <class WaitUntilAllTaskCompleteOrErrorActor>
															#line 221 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
class WaitUntilAllTaskCompleteOrErrorActorState {
															#line 2481 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
public:
															#line 221 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	WaitUntilAllTaskCompleteOrErrorActorState(BulkLoading* const& self,Database const& cx) 
															#line 221 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
															#line 221 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		 : self(self),
															#line 221 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		   cx(cx)
															#line 2490 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
	{
		fdb_probe_actor_create("waitUntilAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this));

	}
	~WaitUntilAllTaskCompleteOrErrorActorState() 
	{
		fdb_probe_actor_destroy("waitUntilAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 222 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			;
															#line 2505 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitUntilAllTaskCompleteOrErrorActorState();
		static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 223 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<std::pair<bool, std::vector<BulkLoadTaskState>>> __when_expr_0 = self->checkAllTaskCompleteOrError(cx);
															#line 223 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2537 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)->actor_wait_state = 1;
															#line 223 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitUntilAllTaskCompleteOrErrorActor, 0, std::pair<bool, std::vector<BulkLoadTaskState>> >*>(static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)));
															#line 2542 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(std::pair<bool, std::vector<BulkLoadTaskState>> const& res,int loopDepth) 
	{
															#line 224 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (res.first)
															#line 2551 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		{
															#line 225 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (!static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)->SAV<std::vector<BulkLoadTaskState>>::futures) { (void)(res.second); this->~WaitUntilAllTaskCompleteOrErrorActorState(); static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)->destroy(); return 0; }
															#line 2555 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			new (&static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)->SAV< std::vector<BulkLoadTaskState> >::value()) std::vector<BulkLoadTaskState>(res.second);
			this->~WaitUntilAllTaskCompleteOrErrorActorState();
			static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 227 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(10.0);
															#line 227 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2565 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)->actor_wait_state = 2;
															#line 227 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitUntilAllTaskCompleteOrErrorActor, 1, Void >*>(static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)));
															#line 2570 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(std::pair<bool, std::vector<BulkLoadTaskState>> && res,int loopDepth) 
	{
															#line 224 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (res.first)
															#line 2579 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		{
															#line 225 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (!static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)->SAV<std::vector<BulkLoadTaskState>>::futures) { (void)(res.second); this->~WaitUntilAllTaskCompleteOrErrorActorState(); static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)->destroy(); return 0; }
															#line 2583 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			new (&static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)->SAV< std::vector<BulkLoadTaskState> >::value()) std::vector<BulkLoadTaskState>(res.second);
			this->~WaitUntilAllTaskCompleteOrErrorActorState();
			static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 227 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(10.0);
															#line 227 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2593 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)->actor_wait_state = 2;
															#line 227 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitUntilAllTaskCompleteOrErrorActor, 1, Void >*>(static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)));
															#line 2598 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(std::pair<bool, std::vector<BulkLoadTaskState>> const& res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(res, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(std::pair<bool, std::vector<BulkLoadTaskState>> && res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)->actor_wait_state > 0) static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)->actor_wait_state = 0;
		static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)->ActorCallback< WaitUntilAllTaskCompleteOrErrorActor, 0, std::pair<bool, std::vector<BulkLoadTaskState>> >::remove();

	}
	void a_callback_fire(ActorCallback< WaitUntilAllTaskCompleteOrErrorActor, 0, std::pair<bool, std::vector<BulkLoadTaskState>> >*,std::pair<bool, std::vector<BulkLoadTaskState>> const& value) 
	{
		fdb_probe_actor_enter("waitUntilAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitUntilAllTaskCompleteOrErrorActor, 0, std::pair<bool, std::vector<BulkLoadTaskState>> >*,std::pair<bool, std::vector<BulkLoadTaskState>> && value) 
	{
		fdb_probe_actor_enter("waitUntilAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitUntilAllTaskCompleteOrErrorActor, 0, std::pair<bool, std::vector<BulkLoadTaskState>> >*,Error err) 
	{
		fdb_probe_actor_enter("waitUntilAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)->actor_wait_state > 0) static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)->actor_wait_state = 0;
		static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)->ActorCallback< WaitUntilAllTaskCompleteOrErrorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitUntilAllTaskCompleteOrErrorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitUntilAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WaitUntilAllTaskCompleteOrErrorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitUntilAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WaitUntilAllTaskCompleteOrErrorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitUntilAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 221 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	BulkLoading* self;
															#line 221 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	Database cx;
															#line 2769 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
};
// This generated class is to be used only via waitUntilAllTaskCompleteOrError()
															#line 221 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
class WaitUntilAllTaskCompleteOrErrorActor final : public Actor<std::vector<BulkLoadTaskState>>, public ActorCallback< WaitUntilAllTaskCompleteOrErrorActor, 0, std::pair<bool, std::vector<BulkLoadTaskState>> >, public ActorCallback< WaitUntilAllTaskCompleteOrErrorActor, 1, Void >, public FastAllocated<WaitUntilAllTaskCompleteOrErrorActor>, public WaitUntilAllTaskCompleteOrErrorActorState<WaitUntilAllTaskCompleteOrErrorActor> {
															#line 2774 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
public:
	using FastAllocated<WaitUntilAllTaskCompleteOrErrorActor>::operator new;
	using FastAllocated<WaitUntilAllTaskCompleteOrErrorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14391257457164526592UL, 8983538445162565632UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<BulkLoadTaskState>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitUntilAllTaskCompleteOrErrorActor, 0, std::pair<bool, std::vector<BulkLoadTaskState>> >;
friend struct ActorCallback< WaitUntilAllTaskCompleteOrErrorActor, 1, Void >;
															#line 221 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	WaitUntilAllTaskCompleteOrErrorActor(BulkLoading* const& self,Database const& cx) 
															#line 2792 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		 : Actor<std::vector<BulkLoadTaskState>>(),
		   WaitUntilAllTaskCompleteOrErrorActorState<WaitUntilAllTaskCompleteOrErrorActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitUntilAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1358020137240995584UL, 12847694799185404160UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilAllTaskCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitUntilAllTaskCompleteOrError");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitUntilAllTaskCompleteOrError", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitUntilAllTaskCompleteOrErrorActor, 0, std::pair<bool, std::vector<BulkLoadTaskState>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WaitUntilAllTaskCompleteOrErrorActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 221 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
[[nodiscard]] Future<std::vector<BulkLoadTaskState>> waitUntilAllTaskCompleteOrError( BulkLoading* const& self, Database const& cx ) {
															#line 221 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	return Future<std::vector<BulkLoadTaskState>>(new WaitUntilAllTaskCompleteOrErrorActor(self, cx));
															#line 2825 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
}

#line 230 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"

																#line 2830 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
// This generated class is to be used only via checkBulkLoadMetadataCleared()
															#line 231 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
template <class CheckBulkLoadMetadataClearedActor>
															#line 231 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
class CheckBulkLoadMetadataClearedActorState {
															#line 2836 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
public:
															#line 231 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	CheckBulkLoadMetadataClearedActorState(BulkLoading* const& self,Database const& cx) 
															#line 231 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
															#line 231 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		 : self(self),
															#line 231 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		   cx(cx),
															#line 232 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		   beginKey(normalKeys.begin),
															#line 233 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		   endKey(normalKeys.end),
															#line 234 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		   tr(cx)
															#line 2851 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
	{
		fdb_probe_actor_create("checkBulkLoadMetadataCleared", reinterpret_cast<unsigned long>(this));

	}
	~CheckBulkLoadMetadataClearedActorState() 
	{
		fdb_probe_actor_destroy("checkBulkLoadMetadataCleared", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 235 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			;
															#line 2866 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckBulkLoadMetadataClearedActorState();
		static_cast<CheckBulkLoadMetadataClearedActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 272 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (!static_cast<CheckBulkLoadMetadataClearedActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckBulkLoadMetadataClearedActorState(); static_cast<CheckBulkLoadMetadataClearedActor*>(this)->destroy(); return 0; }
															#line 2889 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		new (&static_cast<CheckBulkLoadMetadataClearedActor*>(this)->SAV< bool >::value()) bool(true);
		this->~CheckBulkLoadMetadataClearedActorState();
		static_cast<CheckBulkLoadMetadataClearedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 235 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (!(beginKey < endKey))
															#line 2908 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		try {
															#line 237 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 238 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = krmGetRanges(&tr, bulkLoadTaskPrefix, KeyRangeRef(beginKey, endKey));
															#line 238 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (static_cast<CheckBulkLoadMetadataClearedActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2919 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckBulkLoadMetadataClearedActor*>(this)->actor_wait_state = 1;
															#line 238 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckBulkLoadMetadataClearedActor, 0, RangeResult >*>(static_cast<CheckBulkLoadMetadataClearedActor*>(this)));
															#line 2924 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 269 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 269 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (static_cast<CheckBulkLoadMetadataClearedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2961 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CheckBulkLoadMetadataClearedActor*>(this)->actor_wait_state = 2;
															#line 269 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckBulkLoadMetadataClearedActor, 1, Void >*>(static_cast<CheckBulkLoadMetadataClearedActor*>(this)));
															#line 2966 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(RangeResult const& res,int loopDepth) 
	{
															#line 239 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		int clearedCount = 0;
															#line 240 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		int nonEmptyCount = 0;
															#line 241 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		for(int i = 0;i < res.size() - 1;i++) {
															#line 242 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			ASSERT(!self->initializeBulkLoadMetadata || !res[i].value.empty());
															#line 243 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (res[i].value.empty())
															#line 2989 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			{
				continue;
			}
															#line 246 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			BulkLoadTaskState bulkLoadTaskState = decodeBulkLoadTaskState(res[i].value);
															#line 247 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (!bulkLoadTaskState.isValid())
															#line 2997 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			{
															#line 248 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				clearedCount++;
															#line 3001 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
				continue;
			}
															#line 251 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			KeyRange currentRange = Standalone(KeyRangeRef(res[i].key, res[i + 1].key));
															#line 252 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (bulkLoadTaskState.getRange() == currentRange)
															#line 3008 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			{
															#line 253 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				TraceEvent("BulkLoadingWorkLoadMetadataNotCleared") .setMaxEventLength(-1) .setMaxFieldLength(-1) .detail("BulkLoadTask", bulkLoadTaskState.toString());
															#line 257 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				if (!static_cast<CheckBulkLoadMetadataClearedActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckBulkLoadMetadataClearedActorState(); static_cast<CheckBulkLoadMetadataClearedActor*>(this)->destroy(); return 0; }
															#line 3014 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
				new (&static_cast<CheckBulkLoadMetadataClearedActor*>(this)->SAV< bool >::value()) bool(false);
				this->~CheckBulkLoadMetadataClearedActorState();
				static_cast<CheckBulkLoadMetadataClearedActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 259 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			ASSERT(bulkLoadTaskState.getRange().contains(currentRange));
															#line 260 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			nonEmptyCount++;
															#line 3024 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		}
															#line 262 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (self->initializeBulkLoadMetadata && (clearedCount > nonEmptyCount + 1))
															#line 3028 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		{
															#line 263 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			TraceEvent(SevError, "BulkLoadingWorkLoadTooManyClearedCount") .detail("ClearedCount", clearedCount) .detail("NonEmptyCount", nonEmptyCount);
															#line 3032 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		}
															#line 267 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		beginKey = res.back().key;
															#line 3036 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(RangeResult && res,int loopDepth) 
	{
															#line 239 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		int clearedCount = 0;
															#line 240 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		int nonEmptyCount = 0;
															#line 241 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		for(int i = 0;i < res.size() - 1;i++) {
															#line 242 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			ASSERT(!self->initializeBulkLoadMetadata || !res[i].value.empty());
															#line 243 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (res[i].value.empty())
															#line 3053 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			{
				continue;
			}
															#line 246 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			BulkLoadTaskState bulkLoadTaskState = decodeBulkLoadTaskState(res[i].value);
															#line 247 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (!bulkLoadTaskState.isValid())
															#line 3061 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			{
															#line 248 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				clearedCount++;
															#line 3065 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
				continue;
			}
															#line 251 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			KeyRange currentRange = Standalone(KeyRangeRef(res[i].key, res[i + 1].key));
															#line 252 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (bulkLoadTaskState.getRange() == currentRange)
															#line 3072 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			{
															#line 253 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				TraceEvent("BulkLoadingWorkLoadMetadataNotCleared") .setMaxEventLength(-1) .setMaxFieldLength(-1) .detail("BulkLoadTask", bulkLoadTaskState.toString());
															#line 257 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				if (!static_cast<CheckBulkLoadMetadataClearedActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckBulkLoadMetadataClearedActorState(); static_cast<CheckBulkLoadMetadataClearedActor*>(this)->destroy(); return 0; }
															#line 3078 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
				new (&static_cast<CheckBulkLoadMetadataClearedActor*>(this)->SAV< bool >::value()) bool(false);
				this->~CheckBulkLoadMetadataClearedActorState();
				static_cast<CheckBulkLoadMetadataClearedActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 259 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			ASSERT(bulkLoadTaskState.getRange().contains(currentRange));
															#line 260 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			nonEmptyCount++;
															#line 3088 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		}
															#line 262 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (self->initializeBulkLoadMetadata && (clearedCount > nonEmptyCount + 1))
															#line 3092 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		{
															#line 263 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			TraceEvent(SevError, "BulkLoadingWorkLoadTooManyClearedCount") .detail("ClearedCount", clearedCount) .detail("NonEmptyCount", nonEmptyCount);
															#line 3096 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		}
															#line 267 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		beginKey = res.back().key;
															#line 3100 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(res, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckBulkLoadMetadataClearedActor*>(this)->actor_wait_state > 0) static_cast<CheckBulkLoadMetadataClearedActor*>(this)->actor_wait_state = 0;
		static_cast<CheckBulkLoadMetadataClearedActor*>(this)->ActorCallback< CheckBulkLoadMetadataClearedActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CheckBulkLoadMetadataClearedActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("checkBulkLoadMetadataCleared", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckBulkLoadMetadataClearedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkBulkLoadMetadataCleared", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckBulkLoadMetadataClearedActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("checkBulkLoadMetadataCleared", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckBulkLoadMetadataClearedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkBulkLoadMetadataCleared", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckBulkLoadMetadataClearedActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("checkBulkLoadMetadataCleared", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckBulkLoadMetadataClearedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkBulkLoadMetadataCleared", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckBulkLoadMetadataClearedActor*>(this)->actor_wait_state > 0) static_cast<CheckBulkLoadMetadataClearedActor*>(this)->actor_wait_state = 0;
		static_cast<CheckBulkLoadMetadataClearedActor*>(this)->ActorCallback< CheckBulkLoadMetadataClearedActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckBulkLoadMetadataClearedActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkBulkLoadMetadataCleared", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckBulkLoadMetadataClearedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkBulkLoadMetadataCleared", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckBulkLoadMetadataClearedActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkBulkLoadMetadataCleared", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckBulkLoadMetadataClearedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkBulkLoadMetadataCleared", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckBulkLoadMetadataClearedActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkBulkLoadMetadataCleared", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckBulkLoadMetadataClearedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkBulkLoadMetadataCleared", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 231 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	BulkLoading* self;
															#line 231 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	Database cx;
															#line 232 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	Key beginKey;
															#line 233 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	Key endKey;
															#line 234 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	Transaction tr;
															#line 3290 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
};
// This generated class is to be used only via checkBulkLoadMetadataCleared()
															#line 231 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
class CheckBulkLoadMetadataClearedActor final : public Actor<bool>, public ActorCallback< CheckBulkLoadMetadataClearedActor, 0, RangeResult >, public ActorCallback< CheckBulkLoadMetadataClearedActor, 1, Void >, public FastAllocated<CheckBulkLoadMetadataClearedActor>, public CheckBulkLoadMetadataClearedActorState<CheckBulkLoadMetadataClearedActor> {
															#line 3295 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
public:
	using FastAllocated<CheckBulkLoadMetadataClearedActor>::operator new;
	using FastAllocated<CheckBulkLoadMetadataClearedActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16002724193447905024UL, 4492665319196986368UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckBulkLoadMetadataClearedActor, 0, RangeResult >;
friend struct ActorCallback< CheckBulkLoadMetadataClearedActor, 1, Void >;
															#line 231 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	CheckBulkLoadMetadataClearedActor(BulkLoading* const& self,Database const& cx) 
															#line 3313 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		 : Actor<bool>(),
		   CheckBulkLoadMetadataClearedActorState<CheckBulkLoadMetadataClearedActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkBulkLoadMetadataCleared", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11181173172931235840UL, 4303967593809216000UL);
		ActorExecutionContextHelper __helper(static_cast<CheckBulkLoadMetadataClearedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkBulkLoadMetadataCleared");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkBulkLoadMetadataCleared", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckBulkLoadMetadataClearedActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckBulkLoadMetadataClearedActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 231 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
[[nodiscard]] Future<bool> checkBulkLoadMetadataCleared( BulkLoading* const& self, Database const& cx ) {
															#line 231 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	return Future<bool>(new CheckBulkLoadMetadataClearedActor(self, cx));
															#line 3346 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
}

#line 274 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"

	bool keyContainedInRanges(const Key& key, const std::vector<KeyRange>& ranges) {
		for (const auto& range : ranges) {
			if (range.contains(key)) {
				return true;
			}
		}
		return false;
	}

																#line 3360 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
// This generated class is to be used only via getKvsFromDB()
															#line 284 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
template <class GetKvsFromDBActor>
															#line 284 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
class GetKvsFromDBActorState {
															#line 3366 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
public:
															#line 284 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	GetKvsFromDBActorState(BulkLoading* const& self,Database const& cx,std::vector<KeyRange> const& ignoreRanges,std::vector<KeyRange> const& loadedRanges) 
															#line 284 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
															#line 284 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		 : self(self),
															#line 284 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		   cx(cx),
															#line 284 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		   ignoreRanges(ignoreRanges),
															#line 284 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		   loadedRanges(loadedRanges),
															#line 288 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		   res(),
															#line 289 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		   tr(cx)
															#line 3383 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
	{
		fdb_probe_actor_create("getKvsFromDB", reinterpret_cast<unsigned long>(this));

	}
	~GetKvsFromDBActorState() 
	{
		fdb_probe_actor_destroy("getKvsFromDB", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 290 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			TraceEvent("BulkLoadingWorkLoadGetKVSFromDBStart");
															#line 291 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			;
															#line 3400 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetKvsFromDBActorState();
		static_cast<GetKvsFromDBActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 309 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		TraceEvent("BulkLoadingWorkLoadGetKVSFromDBDone");
															#line 310 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (!static_cast<GetKvsFromDBActor*>(this)->SAV<std::vector<KeyValue>>::futures) { (void)(res); this->~GetKvsFromDBActorState(); static_cast<GetKvsFromDBActor*>(this)->destroy(); return 0; }
															#line 3425 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		new (&static_cast<GetKvsFromDBActor*>(this)->SAV< std::vector<KeyValue> >::value()) std::vector<KeyValue>(std::move(res)); // state_var_RVO
		this->~GetKvsFromDBActorState();
		static_cast<GetKvsFromDBActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 293 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(normalKeys, CLIENT_KNOBS->TOO_MANY);
															#line 293 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (static_cast<GetKvsFromDBActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3447 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetKvsFromDBActor*>(this)->actor_wait_state = 1;
															#line 293 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetKvsFromDBActor, 0, RangeResult >*>(static_cast<GetKvsFromDBActor*>(this)));
															#line 3452 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 306 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 306 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (static_cast<GetKvsFromDBActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3489 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetKvsFromDBActor*>(this)->actor_wait_state = 2;
															#line 306 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetKvsFromDBActor, 1, Void >*>(static_cast<GetKvsFromDBActor*>(this)));
															#line 3494 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult const& result,int loopDepth) 
	{
															#line 294 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		ASSERT(!result.more);
															#line 295 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		for(int i = 0;i < result.size();i++) {
															#line 296 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (self->keyContainedInRanges(result[i].key, ignoreRanges))
															#line 3513 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			{
				continue;
			}
															#line 299 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (self->backgroundTrafficEnabled && !self->keyContainedInRanges(result[i].key, loadedRanges))
															#line 3519 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			{
				continue;
			}
															#line 302 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			res.push_back(Standalone(KeyValueRef(result[i].key, result[i].value)));
															#line 3525 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult && result,int loopDepth) 
	{
															#line 294 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		ASSERT(!result.more);
															#line 295 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		for(int i = 0;i < result.size();i++) {
															#line 296 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (self->keyContainedInRanges(result[i].key, ignoreRanges))
															#line 3539 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			{
				continue;
			}
															#line 299 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (self->backgroundTrafficEnabled && !self->keyContainedInRanges(result[i].key, loadedRanges))
															#line 3545 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			{
				continue;
			}
															#line 302 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			res.push_back(Standalone(KeyValueRef(result[i].key, result[i].value)));
															#line 3551 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetKvsFromDBActor*>(this)->actor_wait_state > 0) static_cast<GetKvsFromDBActor*>(this)->actor_wait_state = 0;
		static_cast<GetKvsFromDBActor*>(this)->ActorCallback< GetKvsFromDBActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetKvsFromDBActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getKvsFromDB", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKvsFromDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKvsFromDB", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetKvsFromDBActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getKvsFromDB", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKvsFromDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKvsFromDB", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetKvsFromDBActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getKvsFromDB", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKvsFromDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKvsFromDB", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetKvsFromDBActor*>(this)->actor_wait_state > 0) static_cast<GetKvsFromDBActor*>(this)->actor_wait_state = 0;
		static_cast<GetKvsFromDBActor*>(this)->ActorCallback< GetKvsFromDBActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetKvsFromDBActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getKvsFromDB", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKvsFromDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKvsFromDB", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetKvsFromDBActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getKvsFromDB", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKvsFromDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKvsFromDB", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetKvsFromDBActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getKvsFromDB", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKvsFromDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKvsFromDB", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 284 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	BulkLoading* self;
															#line 284 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	Database cx;
															#line 284 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	std::vector<KeyRange> ignoreRanges;
															#line 284 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	std::vector<KeyRange> loadedRanges;
															#line 288 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	std::vector<KeyValue> res;
															#line 289 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	Transaction tr;
															#line 3731 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
};
// This generated class is to be used only via getKvsFromDB()
															#line 284 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
class GetKvsFromDBActor final : public Actor<std::vector<KeyValue>>, public ActorCallback< GetKvsFromDBActor, 0, RangeResult >, public ActorCallback< GetKvsFromDBActor, 1, Void >, public FastAllocated<GetKvsFromDBActor>, public GetKvsFromDBActorState<GetKvsFromDBActor> {
															#line 3736 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
public:
	using FastAllocated<GetKvsFromDBActor>::operator new;
	using FastAllocated<GetKvsFromDBActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14277206264454707712UL, 12679655596745384448UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<KeyValue>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetKvsFromDBActor, 0, RangeResult >;
friend struct ActorCallback< GetKvsFromDBActor, 1, Void >;
															#line 284 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	GetKvsFromDBActor(BulkLoading* const& self,Database const& cx,std::vector<KeyRange> const& ignoreRanges,std::vector<KeyRange> const& loadedRanges) 
															#line 3754 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		 : Actor<std::vector<KeyValue>>(),
		   GetKvsFromDBActorState<GetKvsFromDBActor>(self, cx, ignoreRanges, loadedRanges),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getKvsFromDB", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(291331993281915904UL, 13819770196307862784UL);
		ActorExecutionContextHelper __helper(static_cast<GetKvsFromDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getKvsFromDB");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getKvsFromDB", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetKvsFromDBActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetKvsFromDBActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 284 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
[[nodiscard]] Future<std::vector<KeyValue>> getKvsFromDB( BulkLoading* const& self, Database const& cx, std::vector<KeyRange> const& ignoreRanges, std::vector<KeyRange> const& loadedRanges ) {
															#line 284 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	return Future<std::vector<KeyValue>>(new GetKvsFromDBActor(self, cx, ignoreRanges, loadedRanges));
															#line 3787 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
}

#line 312 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"

	Standalone<StringRef> getRandomStringRef() const {
		int stringLength = deterministicRandom()->randomInt(1, 10);
		Standalone<StringRef> stringBuffer = makeString(stringLength);
		deterministicRandom()->randomBytes(mutateString(stringBuffer), stringLength);
		return stringBuffer;
	}

	KeyRange getRandomRange(BulkLoading* self, KeyRange scope) const {
		loop {
			Standalone<StringRef> keyA = self->getRandomStringRef();
			Standalone<StringRef> keyB = self->getRandomStringRef();
			if (!scope.contains(keyA) || !scope.contains(keyB)) {
				continue;
			}
			KeyRange range = keyA < keyB ? KeyRangeRef(keyA, keyB) : KeyRangeRef(keyB, keyA);
			if (range.empty() || range.singleKeyRange()) {
				continue;
			}
			return range;
		}
	}

	std::vector<KeyValue> generateOrderedKVS(BulkLoading* self, KeyRange range, size_t count) {
		std::set<Key> keys; // ordered
		while (keys.size() < count) {
			Standalone<StringRef> str = self->getRandomStringRef();
			Key key = range.begin.withSuffix(str);
			if (keys.contains(key)) {
				continue;
			}
			if (!range.contains(key)) {
				continue;
			}
			keys.insert(key);
		}
		std::vector<KeyValue> res;
		for (const auto& key : keys) {
			Value val = self->getRandomStringRef();
			res.push_back(Standalone(KeyValueRef(key, val)));
		}
		return res; // ordered
	}

	BulkLoadFileSet generateSSTFiles(BulkLoading* self, std::string rootPath, BulkLoadTaskTestUnit task) {
		const std::string dataFileNameBase = deterministicRandom()->randomUniqueID().toString();
		const std::string dataFileName = dataFileNameBase + "-data.sst";
		const std::string sampleFileName = dataFileNameBase + "-sample.sst";
		BulkLoadFileSet res(rootPath, "", generateEmptyManifestFileName(), dataFileName, "", BulkLoadChecksum());
		std::string folder = res.getFolder();
		platform::eraseDirectoryRecursive(folder);
		ASSERT(platform::createDirectory(folder));
		std::string dataFile = res.getDataFileFullPath();
		std::unique_ptr<IRocksDBSstFileWriter> sstWriter = newRocksDBSstFileWriter();
		sstWriter->open(abspath(dataFile));
		std::vector<KeyValue> bytesSample;
		for (const auto& kv : task.data) {
			ByteSampleInfo sampleInfo = isKeyValueInSample(kv);
			if (sampleInfo.inSample) {
				Key sampleKey = kv.key;
				Value sampleValue = BinaryWriter::toValue(sampleInfo.sampledSize, Unversioned());
				bytesSample.push_back(Standalone(KeyValueRef(sampleKey, sampleValue)));
			}
			sstWriter->write(kv.key, kv.value);
		}
		TraceEvent("BulkLoadingDataProduced")
		    .detail("Task", task.bulkLoadTask.toString())
		    .detail("LoadKeyCount", task.data.size())
		    .detail("BytesSampleSize", bytesSample.size())
		    .detail("Folder", folder)
		    .detail("DataFile", dataFile);

		if (self->debugging) {
			TraceEvent e("DebugBulkLoadDataProducedKVS");
			e.setMaxEventLength(-1);
			e.setMaxFieldLength(-1);
			e.detail("Task", task.bulkLoadTask.toString());
			e.detail("LoadKeyCount", task.data.size());
			int counter = 0;
			for (const auto& kv : task.data) {
				e.detail("Key" + std::to_string(counter), kv.key);
				e.detail("Val" + std::to_string(counter), kv.value);
				counter++;
			}
		}
		ASSERT(sstWriter->finish());

		res.setByteSampleFileName(sampleFileName);
		std::string bytesSampleFile = res.getBytesSampleFileFullPath();
		if (bytesSample.size() > 0) {
			sstWriter->open(abspath(bytesSampleFile));
			for (const auto& kv : bytesSample) {
				sstWriter->write(kv.key, kv.value);
			}
			TraceEvent("BulkLoadingByteSampleProduced")
			    .detail("Task", task.bulkLoadTask.toString())
			    .detail("LoadKeyCount", task.data.size())
			    .detail("BytesSampleSize", bytesSample.size())
			    .detail("Folder", folder)
			    .detail("DataFile", dataFile)
			    .detail("BytesSampleFile", bytesSampleFile);
			ASSERT(sstWriter->finish());
		} else {
			res.removeByteSampleFile();
		}
		TraceEvent("BulkLoadingProduceDataToLoad").detail("Folder", folder).detail("LoadKeyCount", task.data.size());
		return res;
	}

	std::vector<Key> getAllKeys(const std::vector<KeyValue>& kvs) {
		std::vector<Key> res;
		for (const auto& kv : kvs) {
			res.push_back(kv.key);
		}
		return res;
	}

	BulkLoadTaskTestUnit generateBulkLoadTaskUnit(BulkLoading* self,
	                                              std::string folderPath,
	                                              int dataSize,
	                                              Optional<KeyRange> range = Optional<KeyRange>()) {
		KeyRange rangeToLoad = range.present() ? range.get() : self->getRandomRange(self, normalKeys);
		BulkLoadTaskTestUnit taskUnit;
		taskUnit.data = self->generateOrderedKVS(self, rangeToLoad, dataSize);
		BulkLoadFileSet fileSet = self->generateSSTFiles(self, folderPath, taskUnit);
		taskUnit.bulkLoadTask =
		    createBulkLoadTask(self->jobId,
		                       rangeToLoad,
		                       fileSet,
		                       BulkLoadByteSampleSetting(0,
		                                                 "hashlittle2", // use function name to represent the method
		                                                 SERVER_KNOBS->BYTE_SAMPLING_FACTOR,
		                                                 SERVER_KNOBS->BYTE_SAMPLING_OVERHEAD,
		                                                 SERVER_KNOBS->MIN_BYTE_SAMPLING_PROBABILITY),
		                       /*snapshotVersion=*/invalidVersion,
		                       taskUnit.getTotalBytes(),
		                       taskUnit.getKeyCount(),
		                       BulkLoadType::SST,
		                       BulkLoadTransportMethod::CP);
		TraceEvent("BulkLoadingWorkLoadTaskUnitGenerated")
		    .detail("TaskUnit", taskUnit.toString())
		    .detail("RangeToLoad", rangeToLoad)
		    .detail("Data", describe(self->getAllKeys(taskUnit.data)));
		return taskUnit;
	}

	bool checkSame(BulkLoading* self, std::vector<KeyValue> kvs, std::vector<KeyValue> kvsdb) {
		if (kvs.size() != kvsdb.size()) {
			TraceEvent(SevError, "BulkLoadingWorkLoadDataWrong")
			    .detail("Reason", "KeyValue count wrong")
			    .detail("KVS", kvs.size())
			    .detail("DB", kvsdb.size());
			if (self->debugging) {
				TraceEvent e("DebugBulkLoadKVS");
				e.setMaxEventLength(-1);
				e.setMaxFieldLength(-1);
				int counter = 0;
				for (const auto& kv : kvs) {
					e.detail("Key" + std::to_string(counter), kv.key);
					e.detail("Val" + std::to_string(counter), kv.value);
					counter++;
				}
				TraceEvent e1("DebugBulkLoadDB");
				e1.setMaxEventLength(-1);
				e1.setMaxFieldLength(-1);
				counter = 0;
				for (const auto& kv : kvsdb) {
					e1.detail("Key" + std::to_string(counter), kv.key);
					e1.detail("Val" + std::to_string(counter), kv.value);
					counter++;
				}
			}
			return false;
		}
		std::sort(kvs.begin(), kvs.end(), [](KeyValue a, KeyValue b) { return a.key < b.key; });
		std::sort(kvsdb.begin(), kvsdb.end(), [](KeyValue a, KeyValue b) { return a.key < b.key; });
		for (int i = 0; i < kvs.size(); i++) {
			if (kvs[i].key != kvsdb[i].key) {
				TraceEvent(SevError, "BulkLoadingWorkLoadDataWrong")
				    .detail("Reason", "Key mismatch")
				    .detail("KVS", kvs[i])
				    .detail("DB", kvsdb[i])
				    .detail("AllKVS", describe(self->getAllKeys(kvs)))
				    .detail("AllDB", describe(self->getAllKeys(kvsdb)));
				return false;
			} else if (kvs[i].value != kvsdb[i].value) {
				TraceEvent(SevError, "BulkLoadingWorkLoadDataWrong")
				    .detail("Reason", "Value mismatch")
				    .detail("KVS", kvs[i])
				    .detail("DB", kvsdb[i]);
				return false;
			}
		}
		return true;
	}

	// Issue three non-overlapping tasks and check data consistency and correctness
																#line 3988 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
// This generated class is to be used only via simpleTest()
															#line 509 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
template <class SimpleTestActor>
															#line 509 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
class SimpleTestActorState {
															#line 3994 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
public:
															#line 509 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	SimpleTestActorState(BulkLoading* const& self,Database const& cx) 
															#line 509 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
															#line 509 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		 : self(self),
															#line 509 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		   cx(cx)
															#line 4003 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
	{
		fdb_probe_actor_create("simpleTest", reinterpret_cast<unsigned long>(this));

	}
	~SimpleTestActorState() 
	{
		fdb_probe_actor_destroy("simpleTest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 510 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			TraceEvent("BulkLoadingWorkLoadSimpleTestBegin");
															#line 511 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			oldBulkLoadMode = 0;
															#line 512 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			bulkLoadTaskStates = std::vector<BulkLoadTaskState>();
															#line 513 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			taskRanges = std::vector<KeyRange>();
															#line 514 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			errorRanges = std::vector<KeyRange>();
															#line 515 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			taskUnits = std::vector<BulkLoadTaskTestUnit>();
															#line 516 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			i = 0;
															#line 517 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			i = 0;
															#line 4032 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SimpleTestActorState();
		static_cast<SimpleTestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 533 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		TraceEvent("BulkLoadingWorkLoadSimpleTestIssuedTasks");
															#line 534 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_1 = store(oldBulkLoadMode, setBulkLoadMode(cx, 1));
															#line 534 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<SimpleTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4059 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<SimpleTestActor*>(this)->actor_wait_state = 2;
															#line 534 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SimpleTestActor, 1, Void >*>(static_cast<SimpleTestActor*>(this)));
															#line 4064 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 517 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (!(i < 2))
															#line 4080 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 518 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		std::string indexStr = std::to_string(i);
															#line 519 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		std::string indexStrNext = std::to_string(i + 1);
															#line 520 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		Key beginKey = StringRef(indexStr);
															#line 521 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		Key endKey = StringRef(indexStrNext);
															#line 522 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		std::string folderPath = joinPath(simulationBulkLoadFolder, indexStr);
															#line 523 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		int dataSize = std::pow(10, deterministicRandom()->randomInt(0, 4));
															#line 524 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		BulkLoadTaskTestUnit taskUnit = self->generateBulkLoadTaskUnit(self, folderPath, dataSize, KeyRangeRef(beginKey, endKey));
															#line 526 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		bulkLoadTaskStates.push_back(taskUnit.bulkLoadTask);
															#line 527 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		taskRanges.push_back(taskUnit.bulkLoadTask.getRange());
															#line 528 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		taskUnits.push_back(taskUnit);
															#line 529 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<bool> __when_expr_0 = self->submitBulkLoadTask(cx, taskUnit.bulkLoadTask);
															#line 529 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<SimpleTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4108 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<SimpleTestActor*>(this)->actor_wait_state = 1;
															#line 529 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SimpleTestActor, 0, bool >*>(static_cast<SimpleTestActor*>(this)));
															#line 4113 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(bool const& succeed,int loopDepth) 
	{
															#line 530 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		ASSERT(succeed);
															#line 517 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		i++;
															#line 4137 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(bool && succeed,int loopDepth) 
	{
															#line 530 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		ASSERT(succeed);
															#line 517 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		i++;
															#line 4148 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(bool const& succeed,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(succeed, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(bool && succeed,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(succeed), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SimpleTestActor*>(this)->actor_wait_state > 0) static_cast<SimpleTestActor*>(this)->actor_wait_state = 0;
		static_cast<SimpleTestActor*>(this)->ActorCallback< SimpleTestActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< SimpleTestActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SimpleTestActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SimpleTestActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 535 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		TraceEvent("BulkLoadingWorkLoadSimpleTestSetMode").detail("OldMode", oldBulkLoadMode).detail("NewMode", 1);
															#line 536 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<std::vector<BulkLoadTaskState>> __when_expr_2 = self->waitUntilAllTaskCompleteOrError(self, cx);
															#line 536 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<SimpleTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4236 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<SimpleTestActor*>(this)->actor_wait_state = 3;
															#line 536 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SimpleTestActor, 2, std::vector<BulkLoadTaskState> >*>(static_cast<SimpleTestActor*>(this)));
															#line 4241 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 535 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		TraceEvent("BulkLoadingWorkLoadSimpleTestSetMode").detail("OldMode", oldBulkLoadMode).detail("NewMode", 1);
															#line 536 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<std::vector<BulkLoadTaskState>> __when_expr_2 = self->waitUntilAllTaskCompleteOrError(self, cx);
															#line 536 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<SimpleTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4254 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<SimpleTestActor*>(this)->actor_wait_state = 3;
															#line 536 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SimpleTestActor, 2, std::vector<BulkLoadTaskState> >*>(static_cast<SimpleTestActor*>(this)));
															#line 4259 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SimpleTestActor*>(this)->actor_wait_state > 0) static_cast<SimpleTestActor*>(this)->actor_wait_state = 0;
		static_cast<SimpleTestActor*>(this)->ActorCallback< SimpleTestActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SimpleTestActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SimpleTestActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SimpleTestActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(std::vector<BulkLoadTaskState> const& errorTasks,int loopDepth) 
	{
															#line 537 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		for( const auto& errorTask : errorTasks ) {
															#line 538 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			errorRanges.push_back(errorTask.getRange());
															#line 4345 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		}
															#line 540 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		TraceEvent("BulkLoadingWorkLoadSimpleTestAllComplete");
															#line 543 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_3 = store(oldBulkLoadMode, setBulkLoadMode(cx, 0));
															#line 543 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<SimpleTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4353 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<SimpleTestActor*>(this)->actor_wait_state = 4;
															#line 543 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< SimpleTestActor, 3, Void >*>(static_cast<SimpleTestActor*>(this)));
															#line 4358 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(std::vector<BulkLoadTaskState> && errorTasks,int loopDepth) 
	{
															#line 537 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		for( const auto& errorTask : errorTasks ) {
															#line 538 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			errorRanges.push_back(errorTask.getRange());
															#line 4369 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		}
															#line 540 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		TraceEvent("BulkLoadingWorkLoadSimpleTestAllComplete");
															#line 543 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_3 = store(oldBulkLoadMode, setBulkLoadMode(cx, 0));
															#line 543 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<SimpleTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4377 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<SimpleTestActor*>(this)->actor_wait_state = 4;
															#line 543 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< SimpleTestActor, 3, Void >*>(static_cast<SimpleTestActor*>(this)));
															#line 4382 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<BulkLoadTaskState> const& errorTasks,int loopDepth) 
	{
		loopDepth = a_body1cont3(errorTasks, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<BulkLoadTaskState> && errorTasks,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(errorTasks), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<SimpleTestActor*>(this)->actor_wait_state > 0) static_cast<SimpleTestActor*>(this)->actor_wait_state = 0;
		static_cast<SimpleTestActor*>(this)->ActorCallback< SimpleTestActor, 2, std::vector<BulkLoadTaskState> >::remove();

	}
	void a_callback_fire(ActorCallback< SimpleTestActor, 2, std::vector<BulkLoadTaskState> >*,std::vector<BulkLoadTaskState> const& value) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< SimpleTestActor, 2, std::vector<BulkLoadTaskState> >*,std::vector<BulkLoadTaskState> && value) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< SimpleTestActor, 2, std::vector<BulkLoadTaskState> >*,Error err) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 544 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		TraceEvent("BulkLoadingWorkLoadSimpleTestSetMode").detail("OldMode", oldBulkLoadMode).detail("NewMode", 0);
															#line 545 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<std::vector<KeyValue>> __when_expr_4 = self->getKvsFromDB(self, cx, errorRanges, taskRanges);
															#line 545 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<SimpleTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4470 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<SimpleTestActor*>(this)->actor_wait_state = 5;
															#line 545 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< SimpleTestActor, 4, std::vector<KeyValue> >*>(static_cast<SimpleTestActor*>(this)));
															#line 4475 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 544 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		TraceEvent("BulkLoadingWorkLoadSimpleTestSetMode").detail("OldMode", oldBulkLoadMode).detail("NewMode", 0);
															#line 545 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<std::vector<KeyValue>> __when_expr_4 = self->getKvsFromDB(self, cx, errorRanges, taskRanges);
															#line 545 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<SimpleTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4488 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<SimpleTestActor*>(this)->actor_wait_state = 5;
															#line 545 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< SimpleTestActor, 4, std::vector<KeyValue> >*>(static_cast<SimpleTestActor*>(this)));
															#line 4493 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<SimpleTestActor*>(this)->actor_wait_state > 0) static_cast<SimpleTestActor*>(this)->actor_wait_state = 0;
		static_cast<SimpleTestActor*>(this)->ActorCallback< SimpleTestActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SimpleTestActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< SimpleTestActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< SimpleTestActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont6(int loopDepth) 
	{
															#line 546 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		kvs = std::vector<KeyValue>();
															#line 547 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		for(int j = 0;j < taskUnits.size();j++) {
															#line 548 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			bool rangeTaskError = false;
															#line 549 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			for( const auto& errorRange : errorRanges ) {
															#line 550 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				if (taskUnits[j].getRange() == errorRange)
															#line 4585 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
				{
															#line 551 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
					rangeTaskError = true;
															#line 4589 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
					break;
				}
			}
															#line 555 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (rangeTaskError)
															#line 4595 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			{
				continue;
			}
															#line 558 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			kvs.insert(kvs.end(), taskUnits[j].data.begin(), taskUnits[j].data.end());
															#line 4601 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		}
															#line 560 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		ASSERT(self->checkSame(self, kvs, dbkvs));
															#line 563 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_5 = store(oldBulkLoadMode, setBulkLoadMode(cx, 1));
															#line 563 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<SimpleTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4609 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<SimpleTestActor*>(this)->actor_wait_state = 6;
															#line 563 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< SimpleTestActor, 5, Void >*>(static_cast<SimpleTestActor*>(this)));
															#line 4614 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(std::vector<KeyValue> const& __dbkvs,int loopDepth) 
	{
															#line 545 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		dbkvs = __dbkvs;
															#line 4623 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(std::vector<KeyValue> && __dbkvs,int loopDepth) 
	{
		dbkvs = std::move(__dbkvs);
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<SimpleTestActor*>(this)->actor_wait_state > 0) static_cast<SimpleTestActor*>(this)->actor_wait_state = 0;
		static_cast<SimpleTestActor*>(this)->ActorCallback< SimpleTestActor, 4, std::vector<KeyValue> >::remove();

	}
	void a_callback_fire(ActorCallback< SimpleTestActor, 4, std::vector<KeyValue> >*,std::vector<KeyValue> const& value) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< SimpleTestActor, 4, std::vector<KeyValue> >*,std::vector<KeyValue> && value) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< SimpleTestActor, 4, std::vector<KeyValue> >*,Error err) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
															#line 564 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		TraceEvent("BulkLoadingWorkLoadSimpleTestSetMode").detail("OldMode", oldBulkLoadMode).detail("NewMode", 1);
															#line 565 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		i = 0;
															#line 4704 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = a_body1cont7loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
															#line 564 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		TraceEvent("BulkLoadingWorkLoadSimpleTestSetMode").detail("OldMode", oldBulkLoadMode).detail("NewMode", 1);
															#line 565 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		i = 0;
															#line 4715 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = a_body1cont7loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<SimpleTestActor*>(this)->actor_wait_state > 0) static_cast<SimpleTestActor*>(this)->actor_wait_state = 0;
		static_cast<SimpleTestActor*>(this)->ActorCallback< SimpleTestActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SimpleTestActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< SimpleTestActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< SimpleTestActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont12(int loopDepth) 
	{
															#line 568 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_7 = acknowledgeAllErrorBulkLoadTasks(cx, self->jobId, normalKeys);
															#line 568 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<SimpleTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4801 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont12when1(__when_expr_7.get(), loopDepth); };
		static_cast<SimpleTestActor*>(this)->actor_wait_state = 8;
															#line 568 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< SimpleTestActor, 7, Void >*>(static_cast<SimpleTestActor*>(this)));
															#line 4806 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont7loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1(int loopDepth) 
	{
															#line 565 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (!(i < bulkLoadTaskStates.size()))
															#line 4822 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		{
			return a_body1cont7break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 566 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_6 = self->finalizeBulkLoadTask(cx, bulkLoadTaskStates[i].getRange(), bulkLoadTaskStates[i].getTaskId());
															#line 566 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<SimpleTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4830 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont7loopBody1when1(__when_expr_6.get(), loopDepth); };
		static_cast<SimpleTestActor*>(this)->actor_wait_state = 7;
															#line 566 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< SimpleTestActor, 6, Void >*>(static_cast<SimpleTestActor*>(this)));
															#line 4835 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7break1(int loopDepth) 
	{
		try {
			return a_body1cont12(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 565 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		i++;
															#line 4857 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont7loopHead1(0);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 565 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		i++;
															#line 4866 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont7loopHead1(0);

		return loopDepth;
	}
	int a_body1cont7loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<SimpleTestActor*>(this)->actor_wait_state > 0) static_cast<SimpleTestActor*>(this)->actor_wait_state = 0;
		static_cast<SimpleTestActor*>(this)->ActorCallback< SimpleTestActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SimpleTestActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont7loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< SimpleTestActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont7loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< SimpleTestActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont12cont1(Void const& _,int loopDepth) 
	{
															#line 569 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		;
															#line 4950 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = a_body1cont12cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont1(Void && _,int loopDepth) 
	{
															#line 569 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		;
															#line 4959 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = a_body1cont12cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<SimpleTestActor*>(this)->actor_wait_state > 0) static_cast<SimpleTestActor*>(this)->actor_wait_state = 0;
		static_cast<SimpleTestActor*>(this)->ActorCallback< SimpleTestActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SimpleTestActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont12when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< SimpleTestActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont12when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< SimpleTestActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont12cont2(int loopDepth) 
	{
															#line 576 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		TraceEvent("BulkLoadingWorkLoadSimpleTestComplete");
															#line 577 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (!static_cast<SimpleTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SimpleTestActorState(); static_cast<SimpleTestActor*>(this)->destroy(); return 0; }
															#line 5045 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		new (&static_cast<SimpleTestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SimpleTestActorState();
		static_cast<SimpleTestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont12cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont12cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont1loopBody1(int loopDepth) 
	{
															#line 570 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<bool> __when_expr_8 = self->checkBulkLoadMetadataCleared(self, cx);
															#line 570 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<SimpleTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5066 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12cont1loopBody1when1(__when_expr_8.get(), loopDepth); };
		static_cast<SimpleTestActor*>(this)->actor_wait_state = 9;
															#line 570 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< SimpleTestActor, 8, bool >*>(static_cast<SimpleTestActor*>(this)));
															#line 5071 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont12cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont1loopBody1cont1(bool const& cleared,int loopDepth) 
	{
															#line 571 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (cleared)
															#line 5093 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		{
			return a_body1cont12cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 574 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_9 = delay(1.0);
															#line 574 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<SimpleTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5101 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12cont1loopBody1cont1when1(__when_expr_9.get(), loopDepth); };
		static_cast<SimpleTestActor*>(this)->actor_wait_state = 10;
															#line 574 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< SimpleTestActor, 9, Void >*>(static_cast<SimpleTestActor*>(this)));
															#line 5106 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont1loopBody1cont1(bool && cleared,int loopDepth) 
	{
															#line 571 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (cleared)
															#line 5115 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		{
			return a_body1cont12cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 574 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_9 = delay(1.0);
															#line 574 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<SimpleTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5123 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12cont1loopBody1cont1when1(__when_expr_9.get(), loopDepth); };
		static_cast<SimpleTestActor*>(this)->actor_wait_state = 10;
															#line 574 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< SimpleTestActor, 9, Void >*>(static_cast<SimpleTestActor*>(this)));
															#line 5128 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont1loopBody1when1(bool const& cleared,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1loopBody1cont1(cleared, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont1loopBody1when1(bool && cleared,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1loopBody1cont1(std::move(cleared), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<SimpleTestActor*>(this)->actor_wait_state > 0) static_cast<SimpleTestActor*>(this)->actor_wait_state = 0;
		static_cast<SimpleTestActor*>(this)->ActorCallback< SimpleTestActor, 8, bool >::remove();

	}
	void a_callback_fire(ActorCallback< SimpleTestActor, 8, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont12cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< SimpleTestActor, 8, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont12cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< SimpleTestActor, 8, bool >*,Error err) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont12cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont12cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont12cont1loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont12cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont12cont1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<SimpleTestActor*>(this)->actor_wait_state > 0) static_cast<SimpleTestActor*>(this)->actor_wait_state = 0;
		static_cast<SimpleTestActor*>(this)->ActorCallback< SimpleTestActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SimpleTestActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont12cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< SimpleTestActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont12cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< SimpleTestActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), 9);

	}
															#line 509 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	BulkLoading* self;
															#line 509 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	Database cx;
															#line 511 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	int oldBulkLoadMode;
															#line 512 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	std::vector<BulkLoadTaskState> bulkLoadTaskStates;
															#line 513 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	std::vector<KeyRange> taskRanges;
															#line 514 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	std::vector<KeyRange> errorRanges;
															#line 515 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	std::vector<BulkLoadTaskTestUnit> taskUnits;
															#line 516 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	int i;
															#line 545 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	std::vector<KeyValue> dbkvs;
															#line 546 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	std::vector<KeyValue> kvs;
															#line 5315 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
};
// This generated class is to be used only via simpleTest()
															#line 509 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
class SimpleTestActor final : public Actor<Void>, public ActorCallback< SimpleTestActor, 0, bool >, public ActorCallback< SimpleTestActor, 1, Void >, public ActorCallback< SimpleTestActor, 2, std::vector<BulkLoadTaskState> >, public ActorCallback< SimpleTestActor, 3, Void >, public ActorCallback< SimpleTestActor, 4, std::vector<KeyValue> >, public ActorCallback< SimpleTestActor, 5, Void >, public ActorCallback< SimpleTestActor, 6, Void >, public ActorCallback< SimpleTestActor, 7, Void >, public ActorCallback< SimpleTestActor, 8, bool >, public ActorCallback< SimpleTestActor, 9, Void >, public FastAllocated<SimpleTestActor>, public SimpleTestActorState<SimpleTestActor> {
															#line 5320 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
public:
	using FastAllocated<SimpleTestActor>::operator new;
	using FastAllocated<SimpleTestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14948357174696451328UL, 12072015804747921152UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SimpleTestActor, 0, bool >;
friend struct ActorCallback< SimpleTestActor, 1, Void >;
friend struct ActorCallback< SimpleTestActor, 2, std::vector<BulkLoadTaskState> >;
friend struct ActorCallback< SimpleTestActor, 3, Void >;
friend struct ActorCallback< SimpleTestActor, 4, std::vector<KeyValue> >;
friend struct ActorCallback< SimpleTestActor, 5, Void >;
friend struct ActorCallback< SimpleTestActor, 6, Void >;
friend struct ActorCallback< SimpleTestActor, 7, Void >;
friend struct ActorCallback< SimpleTestActor, 8, bool >;
friend struct ActorCallback< SimpleTestActor, 9, Void >;
															#line 509 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	SimpleTestActor(BulkLoading* const& self,Database const& cx) 
															#line 5346 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		 : Actor<Void>(),
		   SimpleTestActorState<SimpleTestActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("simpleTest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8221372827192469248UL, 17085292377102575616UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("simpleTest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("simpleTest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SimpleTestActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SimpleTestActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< SimpleTestActor, 2, std::vector<BulkLoadTaskState> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< SimpleTestActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< SimpleTestActor, 4, std::vector<KeyValue> >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< SimpleTestActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< SimpleTestActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< SimpleTestActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< SimpleTestActor, 8, bool >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< SimpleTestActor, 9, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 509 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
[[nodiscard]] Future<Void> simpleTest( BulkLoading* const& self, Database const& cx ) {
															#line 509 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	return Future<Void>(new SimpleTestActor(self, cx));
															#line 5387 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
}

#line 579 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"

																#line 5392 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
// This generated class is to be used only via setKeys()
															#line 580 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
template <class SetKeysActor>
															#line 580 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
class SetKeysActorState {
															#line 5398 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
public:
															#line 580 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	SetKeysActorState(Database const& cx,std::vector<KeyValue> const& kvs) 
															#line 580 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
															#line 580 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		 : cx(cx),
															#line 580 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		   kvs(kvs),
															#line 581 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		   tr(cx)
															#line 5409 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
	{
		fdb_probe_actor_create("setKeys", reinterpret_cast<unsigned long>(this));

	}
	~SetKeysActorState() 
	{
		fdb_probe_actor_destroy("setKeys", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 582 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			;
															#line 5424 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SetKeysActorState();
		static_cast<SetKeysActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 584 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			for( const auto& kv : kvs ) {
															#line 585 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				tr.set(kv.key, kv.value);
															#line 5457 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			}
															#line 587 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 587 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (static_cast<SetKeysActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5463 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SetKeysActor*>(this)->actor_wait_state = 1;
															#line 587 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SetKeysActor, 0, Void >*>(static_cast<SetKeysActor*>(this)));
															#line 5468 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 590 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 590 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (static_cast<SetKeysActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5492 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<SetKeysActor*>(this)->actor_wait_state = 2;
															#line 590 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SetKeysActor, 1, Void >*>(static_cast<SetKeysActor*>(this)));
															#line 5497 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 588 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (!static_cast<SetKeysActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetKeysActorState(); static_cast<SetKeysActor*>(this)->destroy(); return 0; }
															#line 5512 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		new (&static_cast<SetKeysActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetKeysActorState();
		static_cast<SetKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 588 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (!static_cast<SetKeysActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetKeysActorState(); static_cast<SetKeysActor*>(this)->destroy(); return 0; }
															#line 5524 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		new (&static_cast<SetKeysActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetKeysActorState();
		static_cast<SetKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SetKeysActor*>(this)->actor_wait_state > 0) static_cast<SetKeysActor*>(this)->actor_wait_state = 0;
		static_cast<SetKeysActor*>(this)->ActorCallback< SetKeysActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetKeysActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SetKeysActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SetKeysActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SetKeysActor*>(this)->actor_wait_state > 0) static_cast<SetKeysActor*>(this)->actor_wait_state = 0;
		static_cast<SetKeysActor*>(this)->ActorCallback< SetKeysActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetKeysActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SetKeysActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SetKeysActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setKeys", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 580 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	Database cx;
															#line 580 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	std::vector<KeyValue> kvs;
															#line 581 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	Transaction tr;
															#line 5700 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
};
// This generated class is to be used only via setKeys()
															#line 580 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
class SetKeysActor final : public Actor<Void>, public ActorCallback< SetKeysActor, 0, Void >, public ActorCallback< SetKeysActor, 1, Void >, public FastAllocated<SetKeysActor>, public SetKeysActorState<SetKeysActor> {
															#line 5705 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
public:
	using FastAllocated<SetKeysActor>::operator new;
	using FastAllocated<SetKeysActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9102134812052369664UL, 16580720085546567424UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SetKeysActor, 0, Void >;
friend struct ActorCallback< SetKeysActor, 1, Void >;
															#line 580 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	SetKeysActor(Database const& cx,std::vector<KeyValue> const& kvs) 
															#line 5723 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		 : Actor<Void>(),
		   SetKeysActorState<SetKeysActor>(cx, kvs),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("setKeys", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13837835877790460416UL, 6372757415257859072UL);
		ActorExecutionContextHelper __helper(static_cast<SetKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("setKeys");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("setKeys", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SetKeysActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SetKeysActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 580 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
[[nodiscard]] Future<Void> setKeys( Database const& cx, std::vector<KeyValue> const& kvs ) {
															#line 580 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	return Future<Void>(new SetKeysActor(cx, kvs));
															#line 5756 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
}

#line 594 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"

																#line 5761 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
// This generated class is to be used only via backgroundWriteTraffic()
															#line 595 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
template <class BackgroundWriteTrafficActor>
															#line 595 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
class BackgroundWriteTrafficActorState {
															#line 5767 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
public:
															#line 595 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	BackgroundWriteTrafficActorState(BulkLoading* const& self,Database const& cx) 
															#line 595 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
															#line 595 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		 : self(self),
															#line 595 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		   cx(cx)
															#line 5776 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
	{
		fdb_probe_actor_create("backgroundWriteTraffic", reinterpret_cast<unsigned long>(this));

	}
	~BackgroundWriteTrafficActorState() 
	{
		fdb_probe_actor_destroy("backgroundWriteTraffic", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 596 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			;
															#line 5791 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BackgroundWriteTrafficActorState();
		static_cast<BackgroundWriteTrafficActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 597 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		int keyCount = deterministicRandom()->randomInt(1, 20);
															#line 598 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		std::vector<KeyValue> kvs = self->generateOrderedKVS(self, normalKeys, keyCount);
															#line 599 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_0 = self->setKeys(cx, kvs);
															#line 599 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<BackgroundWriteTrafficActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5827 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<BackgroundWriteTrafficActor*>(this)->actor_wait_state = 1;
															#line 599 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BackgroundWriteTrafficActor, 0, Void >*>(static_cast<BackgroundWriteTrafficActor*>(this)));
															#line 5832 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 600 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		double delayTime = deterministicRandom()->random01() * 5.0;
															#line 601 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(delayTime);
															#line 601 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<BackgroundWriteTrafficActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5845 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<BackgroundWriteTrafficActor*>(this)->actor_wait_state = 2;
															#line 601 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< BackgroundWriteTrafficActor, 1, Void >*>(static_cast<BackgroundWriteTrafficActor*>(this)));
															#line 5850 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 600 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		double delayTime = deterministicRandom()->random01() * 5.0;
															#line 601 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(delayTime);
															#line 601 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<BackgroundWriteTrafficActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5863 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<BackgroundWriteTrafficActor*>(this)->actor_wait_state = 2;
															#line 601 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< BackgroundWriteTrafficActor, 1, Void >*>(static_cast<BackgroundWriteTrafficActor*>(this)));
															#line 5868 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BackgroundWriteTrafficActor*>(this)->actor_wait_state > 0) static_cast<BackgroundWriteTrafficActor*>(this)->actor_wait_state = 0;
		static_cast<BackgroundWriteTrafficActor*>(this)->ActorCallback< BackgroundWriteTrafficActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BackgroundWriteTrafficActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("backgroundWriteTraffic", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackgroundWriteTrafficActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backgroundWriteTraffic", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BackgroundWriteTrafficActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("backgroundWriteTraffic", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackgroundWriteTrafficActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backgroundWriteTraffic", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BackgroundWriteTrafficActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("backgroundWriteTraffic", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BackgroundWriteTrafficActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backgroundWriteTraffic", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<BackgroundWriteTrafficActor*>(this)->actor_wait_state > 0) static_cast<BackgroundWriteTrafficActor*>(this)->actor_wait_state = 0;
		static_cast<BackgroundWriteTrafficActor*>(this)->ActorCallback< BackgroundWriteTrafficActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BackgroundWriteTrafficActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("backgroundWriteTraffic", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackgroundWriteTrafficActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backgroundWriteTraffic", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< BackgroundWriteTrafficActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("backgroundWriteTraffic", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackgroundWriteTrafficActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backgroundWriteTraffic", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< BackgroundWriteTrafficActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("backgroundWriteTraffic", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BackgroundWriteTrafficActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backgroundWriteTraffic", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 595 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	BulkLoading* self;
															#line 595 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	Database cx;
															#line 6039 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
};
// This generated class is to be used only via backgroundWriteTraffic()
															#line 595 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
class BackgroundWriteTrafficActor final : public Actor<Void>, public ActorCallback< BackgroundWriteTrafficActor, 0, Void >, public ActorCallback< BackgroundWriteTrafficActor, 1, Void >, public FastAllocated<BackgroundWriteTrafficActor>, public BackgroundWriteTrafficActorState<BackgroundWriteTrafficActor> {
															#line 6044 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
public:
	using FastAllocated<BackgroundWriteTrafficActor>::operator new;
	using FastAllocated<BackgroundWriteTrafficActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14921795649877927680UL, 9922066074853184768UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BackgroundWriteTrafficActor, 0, Void >;
friend struct ActorCallback< BackgroundWriteTrafficActor, 1, Void >;
															#line 595 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	BackgroundWriteTrafficActor(BulkLoading* const& self,Database const& cx) 
															#line 6062 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		 : Actor<Void>(),
		   BackgroundWriteTrafficActorState<BackgroundWriteTrafficActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("backgroundWriteTraffic", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(976740153564628992UL, 14086179552707660032UL);
		ActorExecutionContextHelper __helper(static_cast<BackgroundWriteTrafficActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("backgroundWriteTraffic");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("backgroundWriteTraffic", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BackgroundWriteTrafficActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< BackgroundWriteTrafficActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 595 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
[[nodiscard]] Future<Void> backgroundWriteTraffic( BulkLoading* const& self, Database const& cx ) {
															#line 595 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	return Future<Void>(new BackgroundWriteTrafficActor(self, cx));
															#line 6095 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
}

#line 604 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"

																#line 6100 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
// This generated class is to be used only via complexTest()
															#line 605 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
template <class ComplexTestActor>
															#line 605 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
class ComplexTestActorState {
															#line 6106 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
public:
															#line 605 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	ComplexTestActorState(BulkLoading* const& self,Database const& cx) 
															#line 605 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
															#line 605 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		 : self(self),
															#line 605 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		   cx(cx),
															#line 606 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		   taskMap()
															#line 6117 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
	{
		fdb_probe_actor_create("complexTest", reinterpret_cast<unsigned long>(this));

	}
	~ComplexTestActorState() 
	{
		fdb_probe_actor_destroy("complexTest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 607 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			taskMap.insert(allKeys, Optional<BulkLoadTaskTestUnit>());
															#line 608 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			i = 0;
															#line 609 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			oldBulkLoadMode = 0;
															#line 610 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			taskUnit = BulkLoadTaskTestUnit();
															#line 611 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			outdatedRanges = std::vector<KeyRange>();
															#line 612 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			errorRanges = std::vector<KeyRange>();
															#line 615 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			StrictFuture<Void> __when_expr_0 = store(oldBulkLoadMode, setBulkLoadMode(cx, 1));
															#line 615 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (static_cast<ComplexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6146 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ComplexTestActor*>(this)->actor_wait_state = 1;
															#line 615 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ComplexTestActor, 0, Void >*>(static_cast<ComplexTestActor*>(this)));
															#line 6151 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ComplexTestActorState();
		static_cast<ComplexTestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 616 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		TraceEvent("BulkLoadingWorkLoadComplexTestSetMode").detail("OldMode", oldBulkLoadMode).detail("NewMode", 1);
															#line 617 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		;
															#line 6176 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 616 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		TraceEvent("BulkLoadingWorkLoadComplexTestSetMode").detail("OldMode", oldBulkLoadMode).detail("NewMode", 1);
															#line 617 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		;
															#line 6187 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state > 0) static_cast<ComplexTestActor*>(this)->actor_wait_state = 0;
		static_cast<ComplexTestActor*>(this)->ActorCallback< ComplexTestActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ComplexTestActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 645 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<std::vector<BulkLoadTaskState>> __when_expr_7 = self->waitUntilAllTaskCompleteOrError(self, cx);
															#line 645 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6273 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont2when1(__when_expr_7.get(), loopDepth); };
		static_cast<ComplexTestActor*>(this)->actor_wait_state = 8;
															#line 645 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< ComplexTestActor, 7, std::vector<BulkLoadTaskState> >*>(static_cast<ComplexTestActor*>(this)));
															#line 6278 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 617 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (!(i < 3))
															#line 6294 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 618 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		std::string folderPath = joinPath(simulationBulkLoadFolder, std::to_string(i));
															#line 619 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		int dataSize = std::pow(10, deterministicRandom()->randomInt(0, 4));
															#line 620 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		taskUnit = self->generateBulkLoadTaskUnit(self, folderPath, dataSize);
															#line 621 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		ASSERT(normalKeys.contains(taskUnit.bulkLoadTask.getRange()));
															#line 622 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<bool> __when_expr_1 = self->submitBulkLoadTask(cx, taskUnit.bulkLoadTask);
															#line 622 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6310 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ComplexTestActor*>(this)->actor_wait_state = 2;
															#line 622 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ComplexTestActor, 1, bool >*>(static_cast<ComplexTestActor*>(this)));
															#line 6315 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(bool const& succeed,int loopDepth) 
	{
															#line 623 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (succeed)
															#line 6337 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		{
															#line 624 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			taskMap.insert(taskUnit.bulkLoadTask.getRange(), taskUnit);
															#line 6341 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		}
															#line 626 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (deterministicRandom()->coinflip())
															#line 6345 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		{
															#line 627 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			StrictFuture<std::vector<BulkLoadTaskState>> __when_expr_2 = self->waitUntilAllTaskCompleteOrError(self, cx);
															#line 627 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (static_cast<ComplexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6351 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
			static_cast<ComplexTestActor*>(this)->actor_wait_state = 3;
															#line 627 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ComplexTestActor, 2, std::vector<BulkLoadTaskState> >*>(static_cast<ComplexTestActor*>(this)));
															#line 6356 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(bool && succeed,int loopDepth) 
	{
															#line 623 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (succeed)
															#line 6370 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		{
															#line 624 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			taskMap.insert(taskUnit.bulkLoadTask.getRange(), taskUnit);
															#line 6374 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		}
															#line 626 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (deterministicRandom()->coinflip())
															#line 6378 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		{
															#line 627 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			StrictFuture<std::vector<BulkLoadTaskState>> __when_expr_2 = self->waitUntilAllTaskCompleteOrError(self, cx);
															#line 627 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (static_cast<ComplexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6384 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
			static_cast<ComplexTestActor*>(this)->actor_wait_state = 3;
															#line 627 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ComplexTestActor, 2, std::vector<BulkLoadTaskState> >*>(static_cast<ComplexTestActor*>(this)));
															#line 6389 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(bool const& succeed,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(succeed, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(bool && succeed,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(succeed), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state > 0) static_cast<ComplexTestActor*>(this)->actor_wait_state = 0;
		static_cast<ComplexTestActor*>(this)->ActorCallback< ComplexTestActor, 1, bool >::remove();

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 1, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 1, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ComplexTestActor, 1, bool >*,Error err) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont3(int loopDepth) 
	{
															#line 629 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (deterministicRandom()->coinflip())
															#line 6478 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		{
															#line 630 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			StrictFuture<Void> __when_expr_3 = store(oldBulkLoadMode, setBulkLoadMode(cx, 0));
															#line 630 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (static_cast<ComplexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6484 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
			static_cast<ComplexTestActor*>(this)->actor_wait_state = 4;
															#line 630 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ComplexTestActor, 3, Void >*>(static_cast<ComplexTestActor*>(this)));
															#line 6489 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5(std::vector<BulkLoadTaskState> const& errorTasks,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5(std::vector<BulkLoadTaskState> && errorTasks,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(std::vector<BulkLoadTaskState> const& errorTasks,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5(errorTasks, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(std::vector<BulkLoadTaskState> && errorTasks,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5(std::move(errorTasks), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state > 0) static_cast<ComplexTestActor*>(this)->actor_wait_state = 0;
		static_cast<ComplexTestActor*>(this)->ActorCallback< ComplexTestActor, 2, std::vector<BulkLoadTaskState> >::remove();

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 2, std::vector<BulkLoadTaskState> >*,std::vector<BulkLoadTaskState> const& value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 2, std::vector<BulkLoadTaskState> >*,std::vector<BulkLoadTaskState> && value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ComplexTestActor, 2, std::vector<BulkLoadTaskState> >*,Error err) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont6(int loopDepth) 
	{
															#line 640 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (deterministicRandom()->coinflip())
															#line 6590 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		{
															#line 641 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			StrictFuture<Void> __when_expr_6 = delay(deterministicRandom()->random01() * 5);
															#line 641 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (static_cast<ComplexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6596 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont6when1(__when_expr_6.get(), loopDepth); };
			static_cast<ComplexTestActor*>(this)->actor_wait_state = 7;
															#line 641 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ComplexTestActor, 6, Void >*>(static_cast<ComplexTestActor*>(this)));
															#line 6601 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont11(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont7(Void const& _,int loopDepth) 
	{
															#line 631 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		TraceEvent("BulkLoadingWorkLoadComplexTestSetMode") .detail("OldMode", oldBulkLoadMode) .detail("NewMode", 0);
															#line 634 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_4 = delay(deterministicRandom()->random01() * 5);
															#line 634 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6619 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont7when1(__when_expr_4.get(), loopDepth); };
		static_cast<ComplexTestActor*>(this)->actor_wait_state = 5;
															#line 634 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ComplexTestActor, 4, Void >*>(static_cast<ComplexTestActor*>(this)));
															#line 6624 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont7(Void && _,int loopDepth) 
	{
															#line 631 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		TraceEvent("BulkLoadingWorkLoadComplexTestSetMode") .detail("OldMode", oldBulkLoadMode) .detail("NewMode", 0);
															#line 634 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_4 = delay(deterministicRandom()->random01() * 5);
															#line 634 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6637 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont7when1(__when_expr_4.get(), loopDepth); };
		static_cast<ComplexTestActor*>(this)->actor_wait_state = 5;
															#line 634 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ComplexTestActor, 4, Void >*>(static_cast<ComplexTestActor*>(this)));
															#line 6642 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state > 0) static_cast<ComplexTestActor*>(this)->actor_wait_state = 0;
		static_cast<ComplexTestActor*>(this)->ActorCallback< ComplexTestActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ComplexTestActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont8(Void const& _,int loopDepth) 
	{
															#line 635 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_5 = store(oldBulkLoadMode, setBulkLoadMode(cx, 1));
															#line 635 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6728 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont8when1(__when_expr_5.get(), loopDepth); };
		static_cast<ComplexTestActor*>(this)->actor_wait_state = 6;
															#line 635 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ComplexTestActor, 5, Void >*>(static_cast<ComplexTestActor*>(this)));
															#line 6733 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont8(Void && _,int loopDepth) 
	{
															#line 635 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_5 = store(oldBulkLoadMode, setBulkLoadMode(cx, 1));
															#line 635 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6744 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont8when1(__when_expr_5.get(), loopDepth); };
		static_cast<ComplexTestActor*>(this)->actor_wait_state = 6;
															#line 635 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ComplexTestActor, 5, Void >*>(static_cast<ComplexTestActor*>(this)));
															#line 6749 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state > 0) static_cast<ComplexTestActor*>(this)->actor_wait_state = 0;
		static_cast<ComplexTestActor*>(this)->ActorCallback< ComplexTestActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ComplexTestActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont1loopBody1cont9(Void const& _,int loopDepth) 
	{
															#line 636 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		TraceEvent("BulkLoadingWorkLoadComplexTestSetMode") .detail("OldMode", oldBulkLoadMode) .detail("NewMode", 1);
															#line 6833 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont9(Void && _,int loopDepth) 
	{
															#line 636 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		TraceEvent("BulkLoadingWorkLoadComplexTestSetMode") .detail("OldMode", oldBulkLoadMode) .detail("NewMode", 1);
															#line 6842 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state > 0) static_cast<ComplexTestActor*>(this)->actor_wait_state = 0;
		static_cast<ComplexTestActor*>(this)->ActorCallback< ComplexTestActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< ComplexTestActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont1loopBody1cont11(int loopDepth) 
	{
															#line 617 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		i++;
															#line 6926 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont12(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont12(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state > 0) static_cast<ComplexTestActor*>(this)->actor_wait_state = 0;
		static_cast<ComplexTestActor*>(this)->ActorCallback< ComplexTestActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< ComplexTestActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont3(std::vector<BulkLoadTaskState> const& errorTasks,int loopDepth) 
	{
															#line 646 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		for( const auto& errorTask : errorTasks ) {
															#line 647 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			errorRanges.push_back(errorTask.getRange());
															#line 7024 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		}
															#line 649 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_8 = store(oldBulkLoadMode, setBulkLoadMode(cx, 0));
															#line 649 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7030 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont3when1(__when_expr_8.get(), loopDepth); };
		static_cast<ComplexTestActor*>(this)->actor_wait_state = 9;
															#line 649 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< ComplexTestActor, 8, Void >*>(static_cast<ComplexTestActor*>(this)));
															#line 7035 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(std::vector<BulkLoadTaskState> && errorTasks,int loopDepth) 
	{
															#line 646 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		for( const auto& errorTask : errorTasks ) {
															#line 647 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			errorRanges.push_back(errorTask.getRange());
															#line 7046 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		}
															#line 649 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_8 = store(oldBulkLoadMode, setBulkLoadMode(cx, 0));
															#line 649 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7052 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont3when1(__when_expr_8.get(), loopDepth); };
		static_cast<ComplexTestActor*>(this)->actor_wait_state = 9;
															#line 649 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< ComplexTestActor, 8, Void >*>(static_cast<ComplexTestActor*>(this)));
															#line 7057 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<BulkLoadTaskState> const& errorTasks,int loopDepth) 
	{
		loopDepth = a_body1cont3(errorTasks, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<BulkLoadTaskState> && errorTasks,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(errorTasks), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state > 0) static_cast<ComplexTestActor*>(this)->actor_wait_state = 0;
		static_cast<ComplexTestActor*>(this)->ActorCallback< ComplexTestActor, 7, std::vector<BulkLoadTaskState> >::remove();

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 7, std::vector<BulkLoadTaskState> >*,std::vector<BulkLoadTaskState> const& value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 7, std::vector<BulkLoadTaskState> >*,std::vector<BulkLoadTaskState> && value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< ComplexTestActor, 7, std::vector<BulkLoadTaskState> >*,Error err) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 650 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		TraceEvent("BulkLoadingWorkLoadComplexTestSetMode").detail("OldMode", oldBulkLoadMode).detail("NewMode", 0);
															#line 653 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		kvs = std::vector<KeyValue>();
															#line 654 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		bulkLoadTaskStates = std::vector<BulkLoadTaskState>();
															#line 655 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		completeTaskRanges = std::vector<KeyRange>();
															#line 656 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		for( auto& range : taskMap.ranges() ) {
															#line 657 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (!range.value().present())
															#line 7151 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			{
				continue;
			}
															#line 661 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (range.value().get().bulkLoadTask.getRange() != range.range())
															#line 7157 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			{
															#line 662 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				ASSERT(range.value().get().bulkLoadTask.getRange().contains(range.range()));
															#line 663 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				outdatedRanges.push_back(range.range());
															#line 664 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				if (self->debugging)
															#line 7165 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
				{
															#line 665 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
					TraceEvent("DebugBulkLoadOutdateTask").detail("Task", range.value().get().bulkLoadTask.toString());
															#line 7169 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
				}
				continue;
			}
															#line 670 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			bool taskError = false;
															#line 671 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			for( const auto& errorRange : errorRanges ) {
															#line 672 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				if (errorRange == range.range())
															#line 7179 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
				{
															#line 673 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
					taskError = true;
															#line 7183 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
				}
			}
															#line 676 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (taskError)
															#line 7188 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			{
															#line 677 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				if (self->debugging)
															#line 7192 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
				{
															#line 678 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
					TraceEvent("DebugBulkLoadErrorTask").detail("Task", range.value().get().bulkLoadTask.toString());
															#line 7196 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
				}
															#line 680 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				bulkLoadTaskStates.push_back(range.value().get().bulkLoadTask);
															#line 7200 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
				continue;
			}
															#line 683 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			completeTaskRanges.push_back(range.range());
															#line 684 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			std::vector<KeyValue> kvsToCheck = range.value().get().data;
															#line 685 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			kvs.insert(std::end(kvs), std::begin(kvsToCheck), std::end(kvsToCheck));
															#line 686 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			bulkLoadTaskStates.push_back(range.value().get().bulkLoadTask);
															#line 7211 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		}
															#line 688 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		std::vector<KeyRange> ignoreRanges;
															#line 689 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		ignoreRanges.reserve(outdatedRanges.size() + errorRanges.size());
															#line 690 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		ignoreRanges.insert(ignoreRanges.end(), outdatedRanges.begin(), outdatedRanges.end());
															#line 691 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		ignoreRanges.insert(ignoreRanges.end(), errorRanges.begin(), errorRanges.end());
															#line 692 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<std::vector<KeyValue>> __when_expr_9 = self->getKvsFromDB(self, cx, ignoreRanges, completeTaskRanges);
															#line 692 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7225 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont4when1(__when_expr_9.get(), loopDepth); };
		static_cast<ComplexTestActor*>(this)->actor_wait_state = 10;
															#line 692 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< ComplexTestActor, 9, std::vector<KeyValue> >*>(static_cast<ComplexTestActor*>(this)));
															#line 7230 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 650 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		TraceEvent("BulkLoadingWorkLoadComplexTestSetMode").detail("OldMode", oldBulkLoadMode).detail("NewMode", 0);
															#line 653 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		kvs = std::vector<KeyValue>();
															#line 654 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		bulkLoadTaskStates = std::vector<BulkLoadTaskState>();
															#line 655 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		completeTaskRanges = std::vector<KeyRange>();
															#line 656 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		for( auto& range : taskMap.ranges() ) {
															#line 657 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (!range.value().present())
															#line 7249 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			{
				continue;
			}
															#line 661 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (range.value().get().bulkLoadTask.getRange() != range.range())
															#line 7255 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			{
															#line 662 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				ASSERT(range.value().get().bulkLoadTask.getRange().contains(range.range()));
															#line 663 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				outdatedRanges.push_back(range.range());
															#line 664 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				if (self->debugging)
															#line 7263 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
				{
															#line 665 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
					TraceEvent("DebugBulkLoadOutdateTask").detail("Task", range.value().get().bulkLoadTask.toString());
															#line 7267 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
				}
				continue;
			}
															#line 670 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			bool taskError = false;
															#line 671 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			for( const auto& errorRange : errorRanges ) {
															#line 672 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				if (errorRange == range.range())
															#line 7277 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
				{
															#line 673 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
					taskError = true;
															#line 7281 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
				}
			}
															#line 676 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (taskError)
															#line 7286 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			{
															#line 677 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				if (self->debugging)
															#line 7290 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
				{
															#line 678 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
					TraceEvent("DebugBulkLoadErrorTask").detail("Task", range.value().get().bulkLoadTask.toString());
															#line 7294 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
				}
															#line 680 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				bulkLoadTaskStates.push_back(range.value().get().bulkLoadTask);
															#line 7298 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
				continue;
			}
															#line 683 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			completeTaskRanges.push_back(range.range());
															#line 684 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			std::vector<KeyValue> kvsToCheck = range.value().get().data;
															#line 685 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			kvs.insert(std::end(kvs), std::begin(kvsToCheck), std::end(kvsToCheck));
															#line 686 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			bulkLoadTaskStates.push_back(range.value().get().bulkLoadTask);
															#line 7309 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		}
															#line 688 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		std::vector<KeyRange> ignoreRanges;
															#line 689 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		ignoreRanges.reserve(outdatedRanges.size() + errorRanges.size());
															#line 690 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		ignoreRanges.insert(ignoreRanges.end(), outdatedRanges.begin(), outdatedRanges.end());
															#line 691 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		ignoreRanges.insert(ignoreRanges.end(), errorRanges.begin(), errorRanges.end());
															#line 692 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<std::vector<KeyValue>> __when_expr_9 = self->getKvsFromDB(self, cx, ignoreRanges, completeTaskRanges);
															#line 692 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7323 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont4when1(__when_expr_9.get(), loopDepth); };
		static_cast<ComplexTestActor*>(this)->actor_wait_state = 10;
															#line 692 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< ComplexTestActor, 9, std::vector<KeyValue> >*>(static_cast<ComplexTestActor*>(this)));
															#line 7328 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state > 0) static_cast<ComplexTestActor*>(this)->actor_wait_state = 0;
		static_cast<ComplexTestActor*>(this)->ActorCallback< ComplexTestActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< ComplexTestActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont6(std::vector<KeyValue> const& dbkvs,int loopDepth) 
	{
															#line 693 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		ASSERT(self->checkSame(self, kvs, dbkvs));
															#line 696 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_10 = store(oldBulkLoadMode, setBulkLoadMode(cx, 1));
															#line 696 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7416 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont6when1(__when_expr_10.get(), loopDepth); };
		static_cast<ComplexTestActor*>(this)->actor_wait_state = 11;
															#line 696 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< ComplexTestActor, 10, Void >*>(static_cast<ComplexTestActor*>(this)));
															#line 7421 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(std::vector<KeyValue> && dbkvs,int loopDepth) 
	{
															#line 693 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		ASSERT(self->checkSame(self, kvs, dbkvs));
															#line 696 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_10 = store(oldBulkLoadMode, setBulkLoadMode(cx, 1));
															#line 696 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7434 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont6when1(__when_expr_10.get(), loopDepth); };
		static_cast<ComplexTestActor*>(this)->actor_wait_state = 11;
															#line 696 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< ComplexTestActor, 10, Void >*>(static_cast<ComplexTestActor*>(this)));
															#line 7439 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(std::vector<KeyValue> const& dbkvs,int loopDepth) 
	{
		loopDepth = a_body1cont6(dbkvs, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(std::vector<KeyValue> && dbkvs,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(dbkvs), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state > 0) static_cast<ComplexTestActor*>(this)->actor_wait_state = 0;
		static_cast<ComplexTestActor*>(this)->ActorCallback< ComplexTestActor, 9, std::vector<KeyValue> >::remove();

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 9, std::vector<KeyValue> >*,std::vector<KeyValue> const& value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 9, std::vector<KeyValue> >*,std::vector<KeyValue> && value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< ComplexTestActor, 9, std::vector<KeyValue> >*,Error err) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont15(Void const& _,int loopDepth) 
	{
															#line 697 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		TraceEvent("BulkLoadingWorkLoadComplexTestSetMode").detail("OldMode", oldBulkLoadMode).detail("NewMode", 1);
															#line 698 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		i = 0;
															#line 7525 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = a_body1cont15loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont15(Void && _,int loopDepth) 
	{
															#line 697 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		TraceEvent("BulkLoadingWorkLoadComplexTestSetMode").detail("OldMode", oldBulkLoadMode).detail("NewMode", 1);
															#line 698 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		i = 0;
															#line 7536 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = a_body1cont15loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont15(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont15(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state > 0) static_cast<ComplexTestActor*>(this)->actor_wait_state = 0;
		static_cast<ComplexTestActor*>(this)->ActorCallback< ComplexTestActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< ComplexTestActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont15cont1(int loopDepth) 
	{
															#line 701 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_12 = acknowledgeAllErrorBulkLoadTasks(cx, self->jobId, normalKeys);
															#line 701 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7622 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch1(__when_expr_12.getError(), loopDepth); else return a_body1cont15cont1when1(__when_expr_12.get(), loopDepth); };
		static_cast<ComplexTestActor*>(this)->actor_wait_state = 13;
															#line 701 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< ComplexTestActor, 12, Void >*>(static_cast<ComplexTestActor*>(this)));
															#line 7627 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont15loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont15loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont15loopBody1(int loopDepth) 
	{
															#line 698 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (!(i < bulkLoadTaskStates.size()))
															#line 7643 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		{
			return a_body1cont15break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 699 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_11 = self->finalizeBulkLoadTask(cx, bulkLoadTaskStates[i].getRange(), bulkLoadTaskStates[i].getTaskId());
															#line 699 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7651 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), std::max(0, loopDepth - 1)); else return a_body1cont15loopBody1when1(__when_expr_11.get(), loopDepth); };
		static_cast<ComplexTestActor*>(this)->actor_wait_state = 12;
															#line 699 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< ComplexTestActor, 11, Void >*>(static_cast<ComplexTestActor*>(this)));
															#line 7656 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont15break1(int loopDepth) 
	{
		try {
			return a_body1cont15cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont15loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 698 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		i++;
															#line 7678 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont15loopHead1(0);

		return loopDepth;
	}
	int a_body1cont15loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 698 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		i++;
															#line 7687 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont15loopHead1(0);

		return loopDepth;
	}
	int a_body1cont15loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont15loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont15loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont15loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state > 0) static_cast<ComplexTestActor*>(this)->actor_wait_state = 0;
		static_cast<ComplexTestActor*>(this)->ActorCallback< ComplexTestActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont15loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont15loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< ComplexTestActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1cont15cont2(Void const& _,int loopDepth) 
	{
															#line 702 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		;
															#line 7771 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = a_body1cont15cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont15cont2(Void && _,int loopDepth) 
	{
															#line 702 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		;
															#line 7780 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = a_body1cont15cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont15cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont15cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont15cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont15cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state > 0) static_cast<ComplexTestActor*>(this)->actor_wait_state = 0;
		static_cast<ComplexTestActor*>(this)->ActorCallback< ComplexTestActor, 12, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 12, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont15cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 12, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont15cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< ComplexTestActor, 12, Void >*,Error err) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 12);

	}
	int a_body1cont15cont3(int loopDepth) 
	{
															#line 711 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<std::vector<std::pair<KeyRange, RangeLockState>>> __when_expr_15 = findExclusiveReadLockOnRange(cx, normalKeys, rangeLockNameForBulkLoad);
															#line 711 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7866 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1Catch1(__when_expr_15.getError(), loopDepth); else return a_body1cont15cont3when1(__when_expr_15.get(), loopDepth); };
		static_cast<ComplexTestActor*>(this)->actor_wait_state = 16;
															#line 711 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_15.addCallbackAndClear(static_cast<ActorCallback< ComplexTestActor, 15, std::vector<std::pair<KeyRange, RangeLockState>> >*>(static_cast<ComplexTestActor*>(this)));
															#line 7871 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont15cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont15cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont15cont2loopBody1(int loopDepth) 
	{
															#line 703 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<bool> __when_expr_13 = self->checkBulkLoadMetadataCleared(self, cx);
															#line 703 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7889 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1Catch1(__when_expr_13.getError(), std::max(0, loopDepth - 1)); else return a_body1cont15cont2loopBody1when1(__when_expr_13.get(), loopDepth); };
		static_cast<ComplexTestActor*>(this)->actor_wait_state = 14;
															#line 703 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< ComplexTestActor, 13, bool >*>(static_cast<ComplexTestActor*>(this)));
															#line 7894 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont15cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont15cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont15cont2loopBody1cont1(bool const& cleared,int loopDepth) 
	{
															#line 704 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (cleared)
															#line 7916 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		{
			return a_body1cont15cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 707 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_14 = delay(1.0);
															#line 707 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7924 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1Catch1(__when_expr_14.getError(), std::max(0, loopDepth - 1)); else return a_body1cont15cont2loopBody1cont1when1(__when_expr_14.get(), loopDepth); };
		static_cast<ComplexTestActor*>(this)->actor_wait_state = 15;
															#line 707 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< ComplexTestActor, 14, Void >*>(static_cast<ComplexTestActor*>(this)));
															#line 7929 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont15cont2loopBody1cont1(bool && cleared,int loopDepth) 
	{
															#line 704 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (cleared)
															#line 7938 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		{
			return a_body1cont15cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 707 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_14 = delay(1.0);
															#line 707 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7946 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1Catch1(__when_expr_14.getError(), std::max(0, loopDepth - 1)); else return a_body1cont15cont2loopBody1cont1when1(__when_expr_14.get(), loopDepth); };
		static_cast<ComplexTestActor*>(this)->actor_wait_state = 15;
															#line 707 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< ComplexTestActor, 14, Void >*>(static_cast<ComplexTestActor*>(this)));
															#line 7951 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont15cont2loopBody1when1(bool const& cleared,int loopDepth) 
	{
		loopDepth = a_body1cont15cont2loopBody1cont1(cleared, loopDepth);

		return loopDepth;
	}
	int a_body1cont15cont2loopBody1when1(bool && cleared,int loopDepth) 
	{
		loopDepth = a_body1cont15cont2loopBody1cont1(std::move(cleared), loopDepth);

		return loopDepth;
	}
	void a_exitChoose14() 
	{
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state > 0) static_cast<ComplexTestActor*>(this)->actor_wait_state = 0;
		static_cast<ComplexTestActor*>(this)->ActorCallback< ComplexTestActor, 13, bool >::remove();

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 13, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont15cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 13, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont15cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorCallback< ComplexTestActor, 13, bool >*,Error err) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 13);

	}
	int a_body1cont15cont2loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont15cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont15cont2loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont15cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont15cont2loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont15cont2loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont15cont2loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont15cont2loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose15() 
	{
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state > 0) static_cast<ComplexTestActor*>(this)->actor_wait_state = 0;
		static_cast<ComplexTestActor*>(this)->ActorCallback< ComplexTestActor, 14, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 14, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont15cont2loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 14, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont15cont2loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_error(ActorCallback< ComplexTestActor, 14, Void >*,Error err) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 14);

	}
	int a_body1cont15cont4(std::vector<std::pair<KeyRange, RangeLockState>> const& res,int loopDepth) 
	{
															#line 713 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		ASSERT(res.empty());
															#line 714 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		TraceEvent("BulkLoadingWorkLoadComplexTestComplete");
															#line 715 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (!static_cast<ComplexTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ComplexTestActorState(); static_cast<ComplexTestActor*>(this)->destroy(); return 0; }
															#line 8126 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		new (&static_cast<ComplexTestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ComplexTestActorState();
		static_cast<ComplexTestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont15cont4(std::vector<std::pair<KeyRange, RangeLockState>> && res,int loopDepth) 
	{
															#line 713 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		ASSERT(res.empty());
															#line 714 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		TraceEvent("BulkLoadingWorkLoadComplexTestComplete");
															#line 715 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (!static_cast<ComplexTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ComplexTestActorState(); static_cast<ComplexTestActor*>(this)->destroy(); return 0; }
															#line 8142 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		new (&static_cast<ComplexTestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ComplexTestActorState();
		static_cast<ComplexTestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont15cont3when1(std::vector<std::pair<KeyRange, RangeLockState>> const& res,int loopDepth) 
	{
		loopDepth = a_body1cont15cont4(res, loopDepth);

		return loopDepth;
	}
	int a_body1cont15cont3when1(std::vector<std::pair<KeyRange, RangeLockState>> && res,int loopDepth) 
	{
		loopDepth = a_body1cont15cont4(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose16() 
	{
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state > 0) static_cast<ComplexTestActor*>(this)->actor_wait_state = 0;
		static_cast<ComplexTestActor*>(this)->ActorCallback< ComplexTestActor, 15, std::vector<std::pair<KeyRange, RangeLockState>> >::remove();

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 15, std::vector<std::pair<KeyRange, RangeLockState>> >*,std::vector<std::pair<KeyRange, RangeLockState>> const& value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont15cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 15, std::vector<std::pair<KeyRange, RangeLockState>> >*,std::vector<std::pair<KeyRange, RangeLockState>> && value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont15cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_error(ActorCallback< ComplexTestActor, 15, std::vector<std::pair<KeyRange, RangeLockState>> >*,Error err) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 15);

	}
															#line 605 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	BulkLoading* self;
															#line 605 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	Database cx;
															#line 606 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	KeyRangeMap<Optional<BulkLoadTaskTestUnit>> taskMap;
															#line 608 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	int i;
															#line 609 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	int oldBulkLoadMode;
															#line 610 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	BulkLoadTaskTestUnit taskUnit;
															#line 611 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	std::vector<KeyRange> outdatedRanges;
															#line 612 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	std::vector<KeyRange> errorRanges;
															#line 653 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	std::vector<KeyValue> kvs;
															#line 654 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	std::vector<BulkLoadTaskState> bulkLoadTaskStates;
															#line 655 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	std::vector<KeyRange> completeTaskRanges;
															#line 8247 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
};
// This generated class is to be used only via complexTest()
															#line 605 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
class ComplexTestActor final : public Actor<Void>, public ActorCallback< ComplexTestActor, 0, Void >, public ActorCallback< ComplexTestActor, 1, bool >, public ActorCallback< ComplexTestActor, 2, std::vector<BulkLoadTaskState> >, public ActorCallback< ComplexTestActor, 3, Void >, public ActorCallback< ComplexTestActor, 4, Void >, public ActorCallback< ComplexTestActor, 5, Void >, public ActorCallback< ComplexTestActor, 6, Void >, public ActorCallback< ComplexTestActor, 7, std::vector<BulkLoadTaskState> >, public ActorCallback< ComplexTestActor, 8, Void >, public ActorCallback< ComplexTestActor, 9, std::vector<KeyValue> >, public ActorCallback< ComplexTestActor, 10, Void >, public ActorCallback< ComplexTestActor, 11, Void >, public ActorCallback< ComplexTestActor, 12, Void >, public ActorCallback< ComplexTestActor, 13, bool >, public ActorCallback< ComplexTestActor, 14, Void >, public ActorCallback< ComplexTestActor, 15, std::vector<std::pair<KeyRange, RangeLockState>> >, public FastAllocated<ComplexTestActor>, public ComplexTestActorState<ComplexTestActor> {
															#line 8252 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
public:
	using FastAllocated<ComplexTestActor>::operator new;
	using FastAllocated<ComplexTestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14217275558607292160UL, 4102040921297235456UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ComplexTestActor, 0, Void >;
friend struct ActorCallback< ComplexTestActor, 1, bool >;
friend struct ActorCallback< ComplexTestActor, 2, std::vector<BulkLoadTaskState> >;
friend struct ActorCallback< ComplexTestActor, 3, Void >;
friend struct ActorCallback< ComplexTestActor, 4, Void >;
friend struct ActorCallback< ComplexTestActor, 5, Void >;
friend struct ActorCallback< ComplexTestActor, 6, Void >;
friend struct ActorCallback< ComplexTestActor, 7, std::vector<BulkLoadTaskState> >;
friend struct ActorCallback< ComplexTestActor, 8, Void >;
friend struct ActorCallback< ComplexTestActor, 9, std::vector<KeyValue> >;
friend struct ActorCallback< ComplexTestActor, 10, Void >;
friend struct ActorCallback< ComplexTestActor, 11, Void >;
friend struct ActorCallback< ComplexTestActor, 12, Void >;
friend struct ActorCallback< ComplexTestActor, 13, bool >;
friend struct ActorCallback< ComplexTestActor, 14, Void >;
friend struct ActorCallback< ComplexTestActor, 15, std::vector<std::pair<KeyRange, RangeLockState>> >;
															#line 605 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	ComplexTestActor(BulkLoading* const& self,Database const& cx) 
															#line 8284 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		 : Actor<Void>(),
		   ComplexTestActorState<ComplexTestActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(428946891448577280UL, 5305349067125682688UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("complexTest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ComplexTestActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ComplexTestActor, 1, bool >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ComplexTestActor, 2, std::vector<BulkLoadTaskState> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ComplexTestActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ComplexTestActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< ComplexTestActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< ComplexTestActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< ComplexTestActor, 7, std::vector<BulkLoadTaskState> >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< ComplexTestActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< ComplexTestActor, 9, std::vector<KeyValue> >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< ComplexTestActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< ComplexTestActor, 11, Void >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< ComplexTestActor, 12, Void >*)0, actor_cancelled()); break;
		case 14: this->a_callback_error((ActorCallback< ComplexTestActor, 13, bool >*)0, actor_cancelled()); break;
		case 15: this->a_callback_error((ActorCallback< ComplexTestActor, 14, Void >*)0, actor_cancelled()); break;
		case 16: this->a_callback_error((ActorCallback< ComplexTestActor, 15, std::vector<std::pair<KeyRange, RangeLockState>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 605 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
[[nodiscard]] Future<Void> complexTest( BulkLoading* const& self, Database const& cx ) {
															#line 605 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	return Future<Void>(new ComplexTestActor(self, cx));
															#line 8331 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
}

#line 717 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"

																#line 8336 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 718 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
template <class _startActor>
															#line 718 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
class _startActorState {
															#line 8342 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
public:
															#line 718 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	_startActorState(BulkLoading* const& self,Database const& cx) 
															#line 718 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
															#line 718 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		 : self(self),
															#line 718 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		   cx(cx)
															#line 8351 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 719 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (self->clientId != 0)
															#line 8366 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			{
															#line 720 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 8370 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
				new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~_startActorState();
				static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 723 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (g_network->isSimulated())
															#line 8378 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			{
															#line 727 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				disableConnectionFailures("BulkLoading");
															#line 8382 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			}
															#line 730 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (self->initializeBulkLoadMetadata)
															#line 8386 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			{
															#line 731 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				StrictFuture<Void> __when_expr_0 = self->clearAllBulkLoadTask(cx);
															#line 731 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8392 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 731 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 8397 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 735 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (self->backgroundTrafficEnabled)
															#line 8425 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		{
															#line 736 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			trafficActors = std::vector<Future<Void>>();
															#line 737 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			int actorCount = deterministicRandom()->randomInt(1, 10);
															#line 738 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			for(int i = 0;i < actorCount;i++) {
															#line 739 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
				trafficActors.push_back(self->backgroundWriteTraffic(self, cx));
															#line 8435 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			}
		}
															#line 743 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_1 = registerRangeLockOwner(cx, rangeLockNameForBulkLoad, rangeLockNameForBulkLoad);
															#line 743 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8442 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 743 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 8447 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 745 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<std::vector<RangeLockOwner>> __when_expr_2 = getAllRangeLockOwners(cx);
															#line 745 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8545 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont5when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 745 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, std::vector<RangeLockOwner> >*>(static_cast<_startActor*>(this)));
															#line 8550 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 745 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<std::vector<RangeLockOwner>> __when_expr_2 = getAllRangeLockOwners(cx);
															#line 745 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8561 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont5when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 745 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, std::vector<RangeLockOwner> >*>(static_cast<_startActor*>(this)));
															#line 8566 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont8(std::vector<RangeLockOwner> const& lockOwners,int loopDepth) 
	{
															#line 746 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		ASSERT(lockOwners.size() == 1 && lockOwners[0].getOwnerUniqueId() == rangeLockNameForBulkLoad);
															#line 749 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (deterministicRandom()->coinflip())
															#line 8652 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		{
															#line 751 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			StrictFuture<Void> __when_expr_3 = self->simpleTest(self, cx);
															#line 751 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8658 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont8when1(__when_expr_3.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 751 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 8663 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 754 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			StrictFuture<Void> __when_expr_4 = self->complexTest(self, cx);
															#line 754 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8672 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont8when2(__when_expr_4.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 754 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 8677 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont8(std::vector<RangeLockOwner> && lockOwners,int loopDepth) 
	{
															#line 746 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		ASSERT(lockOwners.size() == 1 && lockOwners[0].getOwnerUniqueId() == rangeLockNameForBulkLoad);
															#line 749 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (deterministicRandom()->coinflip())
															#line 8689 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		{
															#line 751 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			StrictFuture<Void> __when_expr_3 = self->simpleTest(self, cx);
															#line 751 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8695 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont8when1(__when_expr_3.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 751 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 8700 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 754 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			StrictFuture<Void> __when_expr_4 = self->complexTest(self, cx);
															#line 754 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8709 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont8when2(__when_expr_4.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 754 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 8714 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont5when1(std::vector<RangeLockOwner> const& lockOwners,int loopDepth) 
	{
		loopDepth = a_body1cont8(lockOwners, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(std::vector<RangeLockOwner> && lockOwners,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(lockOwners), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, std::vector<RangeLockOwner> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, std::vector<RangeLockOwner> >*,std::vector<RangeLockOwner> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, std::vector<RangeLockOwner> >*,std::vector<RangeLockOwner> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, std::vector<RangeLockOwner> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont9(int loopDepth) 
	{
															#line 757 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<Void> __when_expr_5 = removeRangeLockOwner(cx, rangeLockNameForBulkLoad);
															#line 757 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8801 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont9when1(__when_expr_5.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 757 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Void >*>(static_cast<_startActor*>(this)));
															#line 8806 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont10(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont11(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont11(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont8when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont8when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont8when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _startActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont12(Void const& _,int loopDepth) 
	{
															#line 759 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<std::vector<RangeLockOwner>> __when_expr_6 = getAllRangeLockOwners(cx);
															#line 759 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8991 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont12when1(__when_expr_6.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 759 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, std::vector<RangeLockOwner> >*>(static_cast<_startActor*>(this)));
															#line 8996 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12(Void && _,int loopDepth) 
	{
															#line 759 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		StrictFuture<std::vector<RangeLockOwner>> __when_expr_6 = getAllRangeLockOwners(cx);
															#line 759 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9007 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont12when1(__when_expr_6.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 759 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, std::vector<RangeLockOwner> >*>(static_cast<_startActor*>(this)));
															#line 9012 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _startActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont12cont1(std::vector<RangeLockOwner> const& lockOwnersAfterRemove,int loopDepth) 
	{
															#line 760 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		ASSERT(lockOwnersAfterRemove.empty());
															#line 762 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 9098 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont12cont1(std::vector<RangeLockOwner> && lockOwnersAfterRemove,int loopDepth) 
	{
															#line 760 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		ASSERT(lockOwnersAfterRemove.empty());
															#line 762 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 9112 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont12when1(std::vector<RangeLockOwner> const& lockOwnersAfterRemove,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1(lockOwnersAfterRemove, loopDepth);

		return loopDepth;
	}
	int a_body1cont12when1(std::vector<RangeLockOwner> && lockOwnersAfterRemove,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1(std::move(lockOwnersAfterRemove), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 6, std::vector<RangeLockOwner> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 6, std::vector<RangeLockOwner> >*,std::vector<RangeLockOwner> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont12when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< _startActor, 6, std::vector<RangeLockOwner> >*,std::vector<RangeLockOwner> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont12when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< _startActor, 6, std::vector<RangeLockOwner> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 718 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	BulkLoading* self;
															#line 718 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	Database cx;
															#line 736 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	std::vector<Future<Void>> trafficActors;
															#line 9201 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 718 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, std::vector<RangeLockOwner> >, public ActorCallback< _startActor, 3, Void >, public ActorCallback< _startActor, 4, Void >, public ActorCallback< _startActor, 5, Void >, public ActorCallback< _startActor, 6, std::vector<RangeLockOwner> >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 9206 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6876564726860557312UL, 13009204337628654080UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, std::vector<RangeLockOwner> >;
friend struct ActorCallback< _startActor, 3, Void >;
friend struct ActorCallback< _startActor, 4, Void >;
friend struct ActorCallback< _startActor, 5, Void >;
friend struct ActorCallback< _startActor, 6, std::vector<RangeLockOwner> >;
															#line 718 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	_startActor(BulkLoading* const& self,Database const& cx) 
															#line 9229 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, std::vector<RangeLockOwner> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _startActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _startActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< _startActor, 6, std::vector<RangeLockOwner> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 718 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
[[nodiscard]] Future<Void> _start( BulkLoading* const& self, Database const& cx ) {
															#line 718 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
	return Future<Void>(new _startActor(self, cx));
															#line 9267 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoading.actor.g.cpp"
}

#line 764 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoading.actor.cpp"
};

WorkloadFactory<BulkLoading> BulkLoadingFactory;
