#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
/*
 * BulkDumping.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/BulkDumping.h"
#include "fdbclient/BulkLoading.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/Error.h"
#include "flow/Platform.h"
#include "flow/actorcompiler.h" // This must be the last #include.

const std::string simulationBulkDumpFolder = joinPath("simfdb", "bulkdump");

struct BulkDumping : TestWorkload {
	static constexpr auto NAME = "BulkDumpingWorkload";
	const bool enabled = true;
	bool pass = true;
	int cancelTimes = 0;
	int maxCancelTimes = 0;

	// This workload is not compatible with following workload because they will race in changing the DD mode
	// This workload is not compatible with RandomRangeLock for the conflict in range lock
	void disableFailureInjectionWorkloads(std::set<std::string>& out) const override {
		out.insert({ "RandomMoveKeys",
		             "DataLossRecovery",
		             "IDDTxnProcessorApiCorrectness",
		             "PerpetualWiggleStatsWorkload",
		             "PhysicalShardMove",
		             "StorageCorruption",
		             "StorageServerCheckpointRestoreTest",
		             "ValidateStorage",
		             "RandomRangeLock",
		             "BulkLoading" });
	}

	BulkDumping(WorkloadContext const& wcx)
	  : TestWorkload(wcx), enabled(true), pass(true), cancelTimes(0),
	    maxCancelTimes(deterministicRandom()->randomInt(0, 2)) {}

	Future<Void> setup(Database const& cx) override { return Void(); }

	Future<Void> start(Database const& cx) override { return _start(this, cx); }

	Future<bool> check(Database const& cx) override { return true; }

	void getMetrics(std::vector<PerfMetric>& m) override {}

	Standalone<StringRef> getRandomStringRef() const {
		int stringLength = deterministicRandom()->randomInt(1, 10);
		Standalone<StringRef> stringBuffer = makeString(stringLength);
		deterministicRandom()->randomBytes(mutateString(stringBuffer), stringLength);
		return stringBuffer;
	}

	KeyRange getRandomRange(BulkDumping* self, KeyRange scope) const {
		loop {
			Standalone<StringRef> keyA = self->getRandomStringRef();
			Standalone<StringRef> keyB = self->getRandomStringRef();
			if (!scope.contains(keyA) || !scope.contains(keyB)) {
				continue;
			}
			KeyRange range = keyA < keyB ? KeyRangeRef(keyA, keyB) : KeyRangeRef(keyB, keyA);
			if (range.empty() || range.singleKeyRange()) {
				continue;
			}
			return range;
		}
	}

	std::map<Key, Value> generateOrderedKVS(BulkDumping* self, KeyRange range, size_t count) {
		std::map<Key, Value> kvs; // ordered
		while (kvs.size() < count) {
			Standalone<StringRef> str = self->getRandomStringRef();
			Key key = range.begin.withSuffix(str);
			Value val = self->getRandomStringRef();
			if (!range.contains(key)) {
				continue;
			}
			auto res = kvs.insert({ key, val });
			if (!res.second) {
				continue;
			}
		}
		return kvs; // ordered
	}

																#line 108 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
// This generated class is to be used only via setKeys()
															#line 106 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
template <class SetKeysActor>
															#line 106 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
class SetKeysActorState {
															#line 114 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
public:
															#line 106 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	SetKeysActorState(Database const& cx,std::map<Key, Value> const& kvs) 
															#line 106 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
															#line 106 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		 : cx(cx),
															#line 106 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   kvs(kvs),
															#line 107 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   tr(cx)
															#line 125 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
	{
		fdb_probe_actor_create("setKeys", reinterpret_cast<unsigned long>(this));

	}
	~SetKeysActorState() 
	{
		fdb_probe_actor_destroy("setKeys", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 108 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			;
															#line 140 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SetKeysActorState();
		static_cast<SetKeysActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 110 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			for( const auto& [key, value] : kvs ) {
															#line 111 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				tr.set(key, value);
															#line 173 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			}
															#line 113 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 113 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (static_cast<SetKeysActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 179 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SetKeysActor*>(this)->actor_wait_state = 1;
															#line 113 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SetKeysActor, 0, Void >*>(static_cast<SetKeysActor*>(this)));
															#line 184 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 119 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 119 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (static_cast<SetKeysActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 208 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<SetKeysActor*>(this)->actor_wait_state = 2;
															#line 119 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SetKeysActor, 1, Void >*>(static_cast<SetKeysActor*>(this)));
															#line 213 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 114 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		TraceEvent("BulkDumpingWorkLoadSetKey") .detail("KeyCount", kvs.size()) .detail("Version", tr.getCommittedVersion());
															#line 117 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (!static_cast<SetKeysActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetKeysActorState(); static_cast<SetKeysActor*>(this)->destroy(); return 0; }
															#line 230 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		new (&static_cast<SetKeysActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetKeysActorState();
		static_cast<SetKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 114 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		TraceEvent("BulkDumpingWorkLoadSetKey") .detail("KeyCount", kvs.size()) .detail("Version", tr.getCommittedVersion());
															#line 117 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (!static_cast<SetKeysActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetKeysActorState(); static_cast<SetKeysActor*>(this)->destroy(); return 0; }
															#line 244 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		new (&static_cast<SetKeysActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetKeysActorState();
		static_cast<SetKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SetKeysActor*>(this)->actor_wait_state > 0) static_cast<SetKeysActor*>(this)->actor_wait_state = 0;
		static_cast<SetKeysActor*>(this)->ActorCallback< SetKeysActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetKeysActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SetKeysActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SetKeysActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SetKeysActor*>(this)->actor_wait_state > 0) static_cast<SetKeysActor*>(this)->actor_wait_state = 0;
		static_cast<SetKeysActor*>(this)->ActorCallback< SetKeysActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetKeysActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SetKeysActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SetKeysActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setKeys", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 106 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	Database cx;
															#line 106 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	std::map<Key, Value> kvs;
															#line 107 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	Transaction tr;
															#line 420 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
};
// This generated class is to be used only via setKeys()
															#line 106 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
class SetKeysActor final : public Actor<Void>, public ActorCallback< SetKeysActor, 0, Void >, public ActorCallback< SetKeysActor, 1, Void >, public FastAllocated<SetKeysActor>, public SetKeysActorState<SetKeysActor> {
															#line 425 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
public:
	using FastAllocated<SetKeysActor>::operator new;
	using FastAllocated<SetKeysActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4961893734578960384UL, 12132048583042088704UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SetKeysActor, 0, Void >;
friend struct ActorCallback< SetKeysActor, 1, Void >;
															#line 106 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	SetKeysActor(Database const& cx,std::map<Key, Value> const& kvs) 
															#line 443 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		 : Actor<Void>(),
		   SetKeysActorState<SetKeysActor>(cx, kvs),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("setKeys", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13837835877790460416UL, 6372757415257859072UL);
		ActorExecutionContextHelper __helper(static_cast<SetKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("setKeys");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("setKeys", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SetKeysActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SetKeysActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 106 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
[[nodiscard]] Future<Void> setKeys( Database const& cx, std::map<Key, Value> const& kvs ) {
															#line 106 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	return Future<Void>(new SetKeysActor(cx, kvs));
															#line 476 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
}

#line 123 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"

																#line 481 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
// This generated class is to be used only via waitUntilDumpJobComplete()
															#line 124 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
template <class WaitUntilDumpJobCompleteActor>
															#line 124 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
class WaitUntilDumpJobCompleteActorState {
															#line 487 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
public:
															#line 124 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	WaitUntilDumpJobCompleteActorState(Database const& cx) 
															#line 124 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
															#line 124 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		 : cx(cx),
															#line 125 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   tr(cx)
															#line 496 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
	{
		fdb_probe_actor_create("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this));

	}
	~WaitUntilDumpJobCompleteActorState() 
	{
		fdb_probe_actor_destroy("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 126 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			;
															#line 511 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitUntilDumpJobCompleteActorState();
		static_cast<WaitUntilDumpJobCompleteActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 142 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (!static_cast<WaitUntilDumpJobCompleteActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitUntilDumpJobCompleteActorState(); static_cast<WaitUntilDumpJobCompleteActor*>(this)->destroy(); return 0; }
															#line 534 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		new (&static_cast<WaitUntilDumpJobCompleteActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WaitUntilDumpJobCompleteActorState();
		static_cast<WaitUntilDumpJobCompleteActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 128 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 129 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 130 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			StrictFuture<Optional<BulkDumpState>> __when_expr_0 = getSubmittedBulkDumpJob(&tr);
															#line 130 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (static_cast<WaitUntilDumpJobCompleteActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 560 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WaitUntilDumpJobCompleteActor*>(this)->actor_wait_state = 1;
															#line 130 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitUntilDumpJobCompleteActor, 0, Optional<BulkDumpState> >*>(static_cast<WaitUntilDumpJobCompleteActor*>(this)));
															#line 565 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 140 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(30.0);
															#line 140 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<WaitUntilDumpJobCompleteActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 595 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<WaitUntilDumpJobCompleteActor*>(this)->actor_wait_state = 3;
															#line 140 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WaitUntilDumpJobCompleteActor, 2, Void >*>(static_cast<WaitUntilDumpJobCompleteActor*>(this)));
															#line 600 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 135 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 610 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			{
															#line 136 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 614 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			}
															#line 138 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 138 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (static_cast<WaitUntilDumpJobCompleteActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 620 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<WaitUntilDumpJobCompleteActor*>(this)->actor_wait_state = 2;
															#line 138 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitUntilDumpJobCompleteActor, 1, Void >*>(static_cast<WaitUntilDumpJobCompleteActor*>(this)));
															#line 625 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<BulkDumpState> const& aliveJob,int loopDepth) 
	{
															#line 131 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (!aliveJob.present())
															#line 640 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<BulkDumpState> && aliveJob,int loopDepth) 
	{
															#line 131 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (!aliveJob.present())
															#line 652 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<BulkDumpState> const& aliveJob,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(aliveJob, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<BulkDumpState> && aliveJob,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(aliveJob), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitUntilDumpJobCompleteActor*>(this)->actor_wait_state > 0) static_cast<WaitUntilDumpJobCompleteActor*>(this)->actor_wait_state = 0;
		static_cast<WaitUntilDumpJobCompleteActor*>(this)->ActorCallback< WaitUntilDumpJobCompleteActor, 0, Optional<BulkDumpState> >::remove();

	}
	void a_callback_fire(ActorCallback< WaitUntilDumpJobCompleteActor, 0, Optional<BulkDumpState> >*,Optional<BulkDumpState> const& value) 
	{
		fdb_probe_actor_enter("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilDumpJobCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitUntilDumpJobCompleteActor, 0, Optional<BulkDumpState> >*,Optional<BulkDumpState> && value) 
	{
		fdb_probe_actor_enter("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilDumpJobCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitUntilDumpJobCompleteActor, 0, Optional<BulkDumpState> >*,Error err) 
	{
		fdb_probe_actor_enter("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilDumpJobCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WaitUntilDumpJobCompleteActor*>(this)->actor_wait_state > 0) static_cast<WaitUntilDumpJobCompleteActor*>(this)->actor_wait_state = 0;
		static_cast<WaitUntilDumpJobCompleteActor*>(this)->ActorCallback< WaitUntilDumpJobCompleteActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitUntilDumpJobCompleteActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilDumpJobCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WaitUntilDumpJobCompleteActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilDumpJobCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WaitUntilDumpJobCompleteActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilDumpJobCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WaitUntilDumpJobCompleteActor*>(this)->actor_wait_state > 0) static_cast<WaitUntilDumpJobCompleteActor*>(this)->actor_wait_state = 0;
		static_cast<WaitUntilDumpJobCompleteActor*>(this)->ActorCallback< WaitUntilDumpJobCompleteActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitUntilDumpJobCompleteActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilDumpJobCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WaitUntilDumpJobCompleteActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilDumpJobCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WaitUntilDumpJobCompleteActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilDumpJobCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 124 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	Database cx;
															#line 125 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	Transaction tr;
															#line 926 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
};
// This generated class is to be used only via waitUntilDumpJobComplete()
															#line 124 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
class WaitUntilDumpJobCompleteActor final : public Actor<Void>, public ActorCallback< WaitUntilDumpJobCompleteActor, 0, Optional<BulkDumpState> >, public ActorCallback< WaitUntilDumpJobCompleteActor, 1, Void >, public ActorCallback< WaitUntilDumpJobCompleteActor, 2, Void >, public FastAllocated<WaitUntilDumpJobCompleteActor>, public WaitUntilDumpJobCompleteActorState<WaitUntilDumpJobCompleteActor> {
															#line 931 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
public:
	using FastAllocated<WaitUntilDumpJobCompleteActor>::operator new;
	using FastAllocated<WaitUntilDumpJobCompleteActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2059793780536915200UL, 9209866474430355200UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitUntilDumpJobCompleteActor, 0, Optional<BulkDumpState> >;
friend struct ActorCallback< WaitUntilDumpJobCompleteActor, 1, Void >;
friend struct ActorCallback< WaitUntilDumpJobCompleteActor, 2, Void >;
															#line 124 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	WaitUntilDumpJobCompleteActor(Database const& cx) 
															#line 950 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		 : Actor<Void>(),
		   WaitUntilDumpJobCompleteActorState<WaitUntilDumpJobCompleteActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14347013697826418176UL, 10344504171819541760UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilDumpJobCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitUntilDumpJobComplete");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitUntilDumpJobCompleteActor, 0, Optional<BulkDumpState> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WaitUntilDumpJobCompleteActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WaitUntilDumpJobCompleteActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 124 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
[[nodiscard]] Future<Void> waitUntilDumpJobComplete( Database const& cx ) {
															#line 124 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	return Future<Void>(new WaitUntilDumpJobCompleteActor(cx));
															#line 984 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
}

#line 144 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"

																#line 989 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
// This generated class is to be used only via clearDatabase()
															#line 145 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
template <class ClearDatabaseActor>
															#line 145 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
class ClearDatabaseActorState {
															#line 995 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
public:
															#line 145 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	ClearDatabaseActorState(Database const& cx) 
															#line 145 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
															#line 145 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		 : cx(cx),
															#line 146 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   tr(cx)
															#line 1004 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
	{
		fdb_probe_actor_create("clearDatabase", reinterpret_cast<unsigned long>(this));

	}
	~ClearDatabaseActorState() 
	{
		fdb_probe_actor_destroy("clearDatabase", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 147 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			;
															#line 1019 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClearDatabaseActorState();
		static_cast<ClearDatabaseActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 161 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (!static_cast<ClearDatabaseActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClearDatabaseActorState(); static_cast<ClearDatabaseActor*>(this)->destroy(); return 0; }
															#line 1042 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		new (&static_cast<ClearDatabaseActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClearDatabaseActorState();
		static_cast<ClearDatabaseActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 149 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 150 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 151 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			tr.clear(normalKeys);
															#line 152 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			tr.clear(bulkDumpKeys);
															#line 153 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			tr.clear(bulkLoadJobKeys);
															#line 154 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			tr.clear(bulkLoadTaskKeys);
															#line 155 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 155 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (static_cast<ClearDatabaseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1076 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ClearDatabaseActor*>(this)->actor_wait_state = 1;
															#line 155 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClearDatabaseActor, 0, Void >*>(static_cast<ClearDatabaseActor*>(this)));
															#line 1081 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 158 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 158 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (static_cast<ClearDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1118 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ClearDatabaseActor*>(this)->actor_wait_state = 2;
															#line 158 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClearDatabaseActor, 1, Void >*>(static_cast<ClearDatabaseActor*>(this)));
															#line 1123 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClearDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ClearDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ClearDatabaseActor*>(this)->ActorCallback< ClearDatabaseActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClearDatabaseActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clearDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClearDatabaseActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clearDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClearDatabaseActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clearDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ClearDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ClearDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ClearDatabaseActor*>(this)->ActorCallback< ClearDatabaseActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClearDatabaseActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clearDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClearDatabaseActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clearDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClearDatabaseActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clearDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 145 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	Database cx;
															#line 146 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	Transaction tr;
															#line 1312 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
};
// This generated class is to be used only via clearDatabase()
															#line 145 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
class ClearDatabaseActor final : public Actor<Void>, public ActorCallback< ClearDatabaseActor, 0, Void >, public ActorCallback< ClearDatabaseActor, 1, Void >, public FastAllocated<ClearDatabaseActor>, public ClearDatabaseActorState<ClearDatabaseActor> {
															#line 1317 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
public:
	using FastAllocated<ClearDatabaseActor>::operator new;
	using FastAllocated<ClearDatabaseActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2406837217082961152UL, 5459751822255280896UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClearDatabaseActor, 0, Void >;
friend struct ActorCallback< ClearDatabaseActor, 1, Void >;
															#line 145 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	ClearDatabaseActor(Database const& cx) 
															#line 1335 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		 : Actor<Void>(),
		   ClearDatabaseActorState<ClearDatabaseActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clearDatabase", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2535882093937434112UL, 5291521835449874944UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clearDatabase");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clearDatabase", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClearDatabaseActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ClearDatabaseActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 145 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
[[nodiscard]] Future<Void> clearDatabase( Database const& cx ) {
															#line 145 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	return Future<Void>(new ClearDatabaseActor(cx));
															#line 1368 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
}

#line 163 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"

	// Return error tasks
																#line 1374 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
// This generated class is to be used only via validateAllBulkLoadTaskAcknowledgedOrError()
															#line 165 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
template <class ValidateAllBulkLoadTaskAcknowledgedOrErrorActor>
															#line 165 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
class ValidateAllBulkLoadTaskAcknowledgedOrErrorActorState {
															#line 1380 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
public:
															#line 165 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	ValidateAllBulkLoadTaskAcknowledgedOrErrorActorState(Database const& cx,UID const& jobId,KeyRange const& jobRange) 
															#line 165 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
															#line 165 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		 : cx(cx),
															#line 165 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   jobId(jobId),
															#line 165 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   jobRange(jobRange),
															#line 168 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   rangeResult(),
															#line 169 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   beginKey(jobRange.begin),
															#line 170 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   endKey(jobRange.end),
															#line 171 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   tr(cx),
															#line 172 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   errorTasks()
															#line 1401 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
	{
		fdb_probe_actor_create("validateAllBulkLoadTaskAcknowledgedOrError", reinterpret_cast<unsigned long>(this));

	}
	~ValidateAllBulkLoadTaskAcknowledgedOrErrorActorState() 
	{
		fdb_probe_actor_destroy("validateAllBulkLoadTaskAcknowledgedOrError", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 173 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			TraceEvent("BulkDumpingWorkLoad") .detail("Phase", "ValidateAllBulkLoadTaskAcknowledgedOrError") .detail("Job", jobId.toString()) .detail("Range", jobRange);
															#line 177 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			;
															#line 1418 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ValidateAllBulkLoadTaskAcknowledgedOrErrorActorState();
		static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 213 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (!static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->SAV<std::vector<BulkLoadTaskState>>::futures) { (void)(errorTasks); this->~ValidateAllBulkLoadTaskAcknowledgedOrErrorActorState(); static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->destroy(); return 0; }
															#line 1441 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		new (&static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->SAV< std::vector<BulkLoadTaskState> >::value()) std::vector<BulkLoadTaskState>(std::move(errorTasks)); // state_var_RVO
		this->~ValidateAllBulkLoadTaskAcknowledgedOrErrorActorState();
		static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 177 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (!(beginKey < endKey))
															#line 1460 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		try {
															#line 179 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 180 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 181 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			rangeResult.clear();
															#line 182 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			StrictFuture<Void> __when_expr_0 = store(rangeResult, krmGetRanges(&tr, bulkLoadTaskPrefix, KeyRangeRef(beginKey, endKey)));
															#line 182 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1475 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->actor_wait_state = 1;
															#line 182 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ValidateAllBulkLoadTaskAcknowledgedOrErrorActor, 0, Void >*>(static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)));
															#line 1480 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 210 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 210 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1517 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->actor_wait_state = 2;
															#line 210 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ValidateAllBulkLoadTaskAcknowledgedOrErrorActor, 1, Void >*>(static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)));
															#line 1522 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 183 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		for(int i = 0;i < rangeResult.size() - 1;++i) {
															#line 184 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			ASSERT(!rangeResult[i].value.empty());
															#line 185 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			BulkLoadTaskState bulkLoadTaskState = decodeBulkLoadTaskState(rangeResult[i].value);
															#line 186 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (!bulkLoadTaskState.isValid())
															#line 1543 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			{
				continue;
			}
															#line 189 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (bulkLoadTaskState.getJobId() != jobId)
															#line 1549 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			{
															#line 190 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				return a_body1loopBody1Catch1(bulkload_task_outdated(), loopDepth);
															#line 1553 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			}
															#line 192 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (bulkLoadTaskState.phase == BulkLoadPhase::Error)
															#line 1557 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			{
															#line 193 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				TraceEvent(SevWarnAlways, "BulkDumpingWorkLoadBulkLoadTaskHasError") .setMaxEventLength(-1) .setMaxFieldLength(-1) .detail("Task", bulkLoadTaskState.toString());
															#line 197 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				errorTasks.push_back(bulkLoadTaskState);
															#line 1563 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			}
															#line 199 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (bulkLoadTaskState.phase != BulkLoadPhase::Acknowledged && bulkLoadTaskState.phase != BulkLoadPhase::Error)
															#line 1567 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			{
															#line 201 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				TraceEvent(SevError, "BulkDumpingWorkLoadBulkLoadTaskWrongPhase") .setMaxEventLength(-1) .setMaxFieldLength(-1) .detail("Task", bulkLoadTaskState.toString());
															#line 205 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				ASSERT(false);
															#line 1573 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			}
		}
															#line 208 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		beginKey = rangeResult.back().key;
															#line 1578 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 183 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		for(int i = 0;i < rangeResult.size() - 1;++i) {
															#line 184 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			ASSERT(!rangeResult[i].value.empty());
															#line 185 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			BulkLoadTaskState bulkLoadTaskState = decodeBulkLoadTaskState(rangeResult[i].value);
															#line 186 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (!bulkLoadTaskState.isValid())
															#line 1593 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			{
				continue;
			}
															#line 189 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (bulkLoadTaskState.getJobId() != jobId)
															#line 1599 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			{
															#line 190 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				return a_body1loopBody1Catch1(bulkload_task_outdated(), loopDepth);
															#line 1603 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			}
															#line 192 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (bulkLoadTaskState.phase == BulkLoadPhase::Error)
															#line 1607 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			{
															#line 193 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				TraceEvent(SevWarnAlways, "BulkDumpingWorkLoadBulkLoadTaskHasError") .setMaxEventLength(-1) .setMaxFieldLength(-1) .detail("Task", bulkLoadTaskState.toString());
															#line 197 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				errorTasks.push_back(bulkLoadTaskState);
															#line 1613 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			}
															#line 199 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (bulkLoadTaskState.phase != BulkLoadPhase::Acknowledged && bulkLoadTaskState.phase != BulkLoadPhase::Error)
															#line 1617 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			{
															#line 201 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				TraceEvent(SevError, "BulkDumpingWorkLoadBulkLoadTaskWrongPhase") .setMaxEventLength(-1) .setMaxFieldLength(-1) .detail("Task", bulkLoadTaskState.toString());
															#line 205 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				ASSERT(false);
															#line 1623 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			}
		}
															#line 208 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		beginKey = rangeResult.back().key;
															#line 1628 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->actor_wait_state > 0) static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->ActorCallback< ValidateAllBulkLoadTaskAcknowledgedOrErrorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateAllBulkLoadTaskAcknowledgedOrErrorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("validateAllBulkLoadTaskAcknowledgedOrError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateAllBulkLoadTaskAcknowledgedOrError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ValidateAllBulkLoadTaskAcknowledgedOrErrorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("validateAllBulkLoadTaskAcknowledgedOrError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateAllBulkLoadTaskAcknowledgedOrError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ValidateAllBulkLoadTaskAcknowledgedOrErrorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("validateAllBulkLoadTaskAcknowledgedOrError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateAllBulkLoadTaskAcknowledgedOrError", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->actor_wait_state > 0) static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->ActorCallback< ValidateAllBulkLoadTaskAcknowledgedOrErrorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateAllBulkLoadTaskAcknowledgedOrErrorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("validateAllBulkLoadTaskAcknowledgedOrError", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateAllBulkLoadTaskAcknowledgedOrError", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ValidateAllBulkLoadTaskAcknowledgedOrErrorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("validateAllBulkLoadTaskAcknowledgedOrError", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateAllBulkLoadTaskAcknowledgedOrError", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ValidateAllBulkLoadTaskAcknowledgedOrErrorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("validateAllBulkLoadTaskAcknowledgedOrError", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateAllBulkLoadTaskAcknowledgedOrError", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 165 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	Database cx;
															#line 165 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	UID jobId;
															#line 165 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	KeyRange jobRange;
															#line 168 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	RangeResult rangeResult;
															#line 169 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	Key beginKey;
															#line 170 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	Key endKey;
															#line 171 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	Transaction tr;
															#line 172 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	std::vector<BulkLoadTaskState> errorTasks;
															#line 1824 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
};
// This generated class is to be used only via validateAllBulkLoadTaskAcknowledgedOrError()
															#line 165 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
class ValidateAllBulkLoadTaskAcknowledgedOrErrorActor final : public Actor<std::vector<BulkLoadTaskState>>, public ActorCallback< ValidateAllBulkLoadTaskAcknowledgedOrErrorActor, 0, Void >, public ActorCallback< ValidateAllBulkLoadTaskAcknowledgedOrErrorActor, 1, Void >, public FastAllocated<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor>, public ValidateAllBulkLoadTaskAcknowledgedOrErrorActorState<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor> {
															#line 1829 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
public:
	using FastAllocated<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor>::operator new;
	using FastAllocated<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12026973409345959680UL, 3213087264883234560UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<BulkLoadTaskState>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ValidateAllBulkLoadTaskAcknowledgedOrErrorActor, 0, Void >;
friend struct ActorCallback< ValidateAllBulkLoadTaskAcknowledgedOrErrorActor, 1, Void >;
															#line 165 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	ValidateAllBulkLoadTaskAcknowledgedOrErrorActor(Database const& cx,UID const& jobId,KeyRange const& jobRange) 
															#line 1847 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		 : Actor<std::vector<BulkLoadTaskState>>(),
		   ValidateAllBulkLoadTaskAcknowledgedOrErrorActorState<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor>(cx, jobId, jobRange),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("validateAllBulkLoadTaskAcknowledgedOrError", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11830555534422417920UL, 14829119776246766336UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("validateAllBulkLoadTaskAcknowledgedOrError");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("validateAllBulkLoadTaskAcknowledgedOrError", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ValidateAllBulkLoadTaskAcknowledgedOrErrorActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ValidateAllBulkLoadTaskAcknowledgedOrErrorActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 165 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
[[nodiscard]] Future<std::vector<BulkLoadTaskState>> validateAllBulkLoadTaskAcknowledgedOrError( Database const& cx, UID const& jobId, KeyRange const& jobRange ) {
															#line 165 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	return Future<std::vector<BulkLoadTaskState>>(new ValidateAllBulkLoadTaskAcknowledgedOrErrorActor(cx, jobId, jobRange));
															#line 1880 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
}

#line 215 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"

																#line 1885 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
// This generated class is to be used only via waitUntilLoadJobCompleteOrError()
															#line 216 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
template <class WaitUntilLoadJobCompleteOrErrorActor>
															#line 216 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
class WaitUntilLoadJobCompleteOrErrorActorState {
															#line 1891 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
public:
															#line 216 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	WaitUntilLoadJobCompleteOrErrorActorState(BulkDumping* const& self,Database const& cx,UID const& jobId,KeyRange const& jobRange) 
															#line 216 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
															#line 216 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		 : self(self),
															#line 216 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   cx(cx),
															#line 216 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   jobId(jobId),
															#line 216 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   jobRange(jobRange)
															#line 1904 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
	{
		fdb_probe_actor_create("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this));

	}
	~WaitUntilLoadJobCompleteOrErrorActorState() 
	{
		fdb_probe_actor_destroy("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 220 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			;
															#line 1919 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitUntilLoadJobCompleteOrErrorActorState();
		static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 221 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Optional<BulkLoadJobState>> __when_expr_0 = getRunningBulkLoadJob(cx);
															#line 221 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1951 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state = 1;
															#line 221 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 0, Optional<BulkLoadJobState> >*>(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)));
															#line 1956 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Optional<BulkLoadJobState> const& runningJob,int loopDepth) 
	{
															#line 222 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (runningJob.present())
															#line 1965 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		{
															#line 223 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			ASSERT(runningJob.get().getJobId() == jobId);
															#line 228 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (SERVER_KNOBS->BULKLOAD_SIM_FAILURE_INJECTION && self->cancelTimes < self->maxCancelTimes && deterministicRandom()->random01() < 0.1)
															#line 1971 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			{
															#line 230 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				StrictFuture<Void> __when_expr_1 = cancelBulkLoadJob(cx, jobId);
															#line 230 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				if (static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1977 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
				static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state = 2;
															#line 230 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 1, Void >*>(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)));
															#line 1982 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1cont3(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Optional<BulkLoadJobState> && runningJob,int loopDepth) 
	{
															#line 222 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (runningJob.present())
															#line 2001 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		{
															#line 223 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			ASSERT(runningJob.get().getJobId() == jobId);
															#line 228 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (SERVER_KNOBS->BULKLOAD_SIM_FAILURE_INJECTION && self->cancelTimes < self->maxCancelTimes && deterministicRandom()->random01() < 0.1)
															#line 2007 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			{
															#line 230 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				StrictFuture<Void> __when_expr_1 = cancelBulkLoadJob(cx, jobId);
															#line 230 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				if (static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2013 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
				static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state = 2;
															#line 230 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 1, Void >*>(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)));
															#line 2018 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1cont3(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<BulkLoadJobState> const& runningJob,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(runningJob, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<BulkLoadJobState> && runningJob,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(runningJob), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state > 0) static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state = 0;
		static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 0, Optional<BulkLoadJobState> >::remove();

	}
	void a_callback_fire(ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 0, Optional<BulkLoadJobState> >*,Optional<BulkLoadJobState> const& value) 
	{
		fdb_probe_actor_enter("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 0, Optional<BulkLoadJobState> >*,Optional<BulkLoadJobState> && value) 
	{
		fdb_probe_actor_enter("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 0, Optional<BulkLoadJobState> >*,Error err) 
	{
		fdb_probe_actor_enter("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 238 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<std::vector<BulkLoadTaskState>> __when_expr_3 = self->validateAllBulkLoadTaskAcknowledgedOrError(cx, jobId, jobRange);
															#line 238 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2114 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_3.get(), loopDepth); };
		static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state = 4;
															#line 238 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 3, std::vector<BulkLoadTaskState> >*>(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)));
															#line 2119 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 235 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(10.0);
															#line 235 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2130 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state = 3;
															#line 235 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 2, Void >*>(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)));
															#line 2135 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 231 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		self->cancelTimes++;
															#line 232 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		TraceEvent("BulkDumpingWorkLoad").detail("Phase", "Job Cancelled").detail("Job", jobId.toString());
															#line 233 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (!static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->SAV<std::vector<BulkLoadTaskState>>::futures) { (void)(std::vector<BulkLoadTaskState>()); this->~WaitUntilLoadJobCompleteOrErrorActorState(); static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->destroy(); return 0; }
															#line 2148 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		new (&static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->SAV< std::vector<BulkLoadTaskState> >::value()) std::vector<BulkLoadTaskState>(std::vector<BulkLoadTaskState>());
		this->~WaitUntilLoadJobCompleteOrErrorActorState();
		static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 231 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		self->cancelTimes++;
															#line 232 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		TraceEvent("BulkDumpingWorkLoad").detail("Phase", "Job Cancelled").detail("Job", jobId.toString());
															#line 233 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (!static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->SAV<std::vector<BulkLoadTaskState>>::futures) { (void)(std::vector<BulkLoadTaskState>()); this->~WaitUntilLoadJobCompleteOrErrorActorState(); static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->destroy(); return 0; }
															#line 2164 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		new (&static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->SAV< std::vector<BulkLoadTaskState> >::value()) std::vector<BulkLoadTaskState>(std::vector<BulkLoadTaskState>());
		this->~WaitUntilLoadJobCompleteOrErrorActorState();
		static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state > 0) static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state = 0;
		static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state > 0) static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state = 0;
		static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont8(std::vector<BulkLoadTaskState> const& errorTasks,int loopDepth) 
	{
															#line 240 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (!static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->SAV<std::vector<BulkLoadTaskState>>::futures) { (void)(errorTasks); this->~WaitUntilLoadJobCompleteOrErrorActorState(); static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->destroy(); return 0; }
															#line 2338 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		new (&static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->SAV< std::vector<BulkLoadTaskState> >::value()) std::vector<BulkLoadTaskState>(errorTasks);
		this->~WaitUntilLoadJobCompleteOrErrorActorState();
		static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont8(std::vector<BulkLoadTaskState> && errorTasks,int loopDepth) 
	{
															#line 240 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (!static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->SAV<std::vector<BulkLoadTaskState>>::futures) { (void)(errorTasks); this->~WaitUntilLoadJobCompleteOrErrorActorState(); static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->destroy(); return 0; }
															#line 2350 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		new (&static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->SAV< std::vector<BulkLoadTaskState> >::value()) std::vector<BulkLoadTaskState>(errorTasks);
		this->~WaitUntilLoadJobCompleteOrErrorActorState();
		static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(std::vector<BulkLoadTaskState> const& errorTasks,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(errorTasks, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(std::vector<BulkLoadTaskState> && errorTasks,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(std::move(errorTasks), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state > 0) static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state = 0;
		static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 3, std::vector<BulkLoadTaskState> >::remove();

	}
	void a_callback_fire(ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 3, std::vector<BulkLoadTaskState> >*,std::vector<BulkLoadTaskState> const& value) 
	{
		fdb_probe_actor_enter("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 3, std::vector<BulkLoadTaskState> >*,std::vector<BulkLoadTaskState> && value) 
	{
		fdb_probe_actor_enter("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 3, std::vector<BulkLoadTaskState> >*,Error err) 
	{
		fdb_probe_actor_enter("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 216 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	BulkDumping* self;
															#line 216 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	Database cx;
															#line 216 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	UID jobId;
															#line 216 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	KeyRange jobRange;
															#line 2441 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
};
// This generated class is to be used only via waitUntilLoadJobCompleteOrError()
															#line 216 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
class WaitUntilLoadJobCompleteOrErrorActor final : public Actor<std::vector<BulkLoadTaskState>>, public ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 0, Optional<BulkLoadJobState> >, public ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 1, Void >, public ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 2, Void >, public ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 3, std::vector<BulkLoadTaskState> >, public FastAllocated<WaitUntilLoadJobCompleteOrErrorActor>, public WaitUntilLoadJobCompleteOrErrorActorState<WaitUntilLoadJobCompleteOrErrorActor> {
															#line 2446 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
public:
	using FastAllocated<WaitUntilLoadJobCompleteOrErrorActor>::operator new;
	using FastAllocated<WaitUntilLoadJobCompleteOrErrorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2104010235398588672UL, 11929930071925246208UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<BulkLoadTaskState>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 0, Optional<BulkLoadJobState> >;
friend struct ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 1, Void >;
friend struct ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 2, Void >;
friend struct ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 3, std::vector<BulkLoadTaskState> >;
															#line 216 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	WaitUntilLoadJobCompleteOrErrorActor(BulkDumping* const& self,Database const& cx,UID const& jobId,KeyRange const& jobRange) 
															#line 2466 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		 : Actor<std::vector<BulkLoadTaskState>>(),
		   WaitUntilLoadJobCompleteOrErrorActorState<WaitUntilLoadJobCompleteOrErrorActor>(self, cx, jobId, jobRange),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16253690126426733056UL, 3412635736290458112UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitUntilLoadJobCompleteOrError");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 0, Optional<BulkLoadJobState> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 3, std::vector<BulkLoadTaskState> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 216 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
[[nodiscard]] Future<std::vector<BulkLoadTaskState>> waitUntilLoadJobCompleteOrError( BulkDumping* const& self, Database const& cx, UID const& jobId, KeyRange const& jobRange ) {
															#line 216 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	return Future<std::vector<BulkLoadTaskState>>(new WaitUntilLoadJobCompleteOrErrorActor(self, cx, jobId, jobRange));
															#line 2501 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
}

#line 243 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"

																#line 2506 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
// This generated class is to be used only via validateBulkLoadJobHistory()
															#line 244 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
template <class ValidateBulkLoadJobHistoryActor>
															#line 244 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
class ValidateBulkLoadJobHistoryActorState {
															#line 2512 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
public:
															#line 244 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	ValidateBulkLoadJobHistoryActorState(Database const& cx,UID const& jobId,bool const& hasError) 
															#line 244 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
															#line 244 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		 : cx(cx),
															#line 244 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   jobId(jobId),
															#line 244 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   hasError(hasError)
															#line 2523 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
	{
		fdb_probe_actor_create("validateBulkLoadJobHistory", reinterpret_cast<unsigned long>(this));

	}
	~ValidateBulkLoadJobHistoryActorState() 
	{
		fdb_probe_actor_destroy("validateBulkLoadJobHistory", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 245 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			StrictFuture<std::vector<BulkLoadJobState>> __when_expr_0 = getBulkLoadJobFromHistory(cx);
															#line 245 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (static_cast<ValidateBulkLoadJobHistoryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2540 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ValidateBulkLoadJobHistoryActor*>(this)->actor_wait_state = 1;
															#line 245 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ValidateBulkLoadJobHistoryActor, 0, std::vector<BulkLoadJobState> >*>(static_cast<ValidateBulkLoadJobHistoryActor*>(this)));
															#line 2545 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ValidateBulkLoadJobHistoryActorState();
		static_cast<ValidateBulkLoadJobHistoryActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<BulkLoadJobState> const& jobHistory,int loopDepth) 
	{
															#line 246 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		Optional<BulkLoadJobState> jobInHistory;
															#line 247 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		for( const auto& job : jobHistory ) {
															#line 248 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			ASSERT(job.isValid());
															#line 249 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			ASSERT(job.getJobId() == jobId);
															#line 250 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			ASSERT(!jobInHistory.present());
															#line 251 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			jobInHistory = job;
															#line 2578 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		}
															#line 253 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		ASSERT(jobInHistory.present());
															#line 254 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (hasError)
															#line 2584 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		{
															#line 255 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			ASSERT(jobInHistory.get().getPhase() == BulkLoadJobPhase::Error);
															#line 2588 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		}
		else
		{
															#line 257 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			ASSERT(jobInHistory.get().getPhase() == BulkLoadJobPhase::Complete);
															#line 2594 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		}
															#line 259 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (!static_cast<ValidateBulkLoadJobHistoryActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ValidateBulkLoadJobHistoryActorState(); static_cast<ValidateBulkLoadJobHistoryActor*>(this)->destroy(); return 0; }
															#line 2598 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		new (&static_cast<ValidateBulkLoadJobHistoryActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ValidateBulkLoadJobHistoryActorState();
		static_cast<ValidateBulkLoadJobHistoryActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<BulkLoadJobState> && jobHistory,int loopDepth) 
	{
															#line 246 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		Optional<BulkLoadJobState> jobInHistory;
															#line 247 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		for( const auto& job : jobHistory ) {
															#line 248 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			ASSERT(job.isValid());
															#line 249 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			ASSERT(job.getJobId() == jobId);
															#line 250 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			ASSERT(!jobInHistory.present());
															#line 251 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			jobInHistory = job;
															#line 2620 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		}
															#line 253 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		ASSERT(jobInHistory.present());
															#line 254 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (hasError)
															#line 2626 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		{
															#line 255 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			ASSERT(jobInHistory.get().getPhase() == BulkLoadJobPhase::Error);
															#line 2630 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		}
		else
		{
															#line 257 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			ASSERT(jobInHistory.get().getPhase() == BulkLoadJobPhase::Complete);
															#line 2636 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		}
															#line 259 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (!static_cast<ValidateBulkLoadJobHistoryActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ValidateBulkLoadJobHistoryActorState(); static_cast<ValidateBulkLoadJobHistoryActor*>(this)->destroy(); return 0; }
															#line 2640 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		new (&static_cast<ValidateBulkLoadJobHistoryActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ValidateBulkLoadJobHistoryActorState();
		static_cast<ValidateBulkLoadJobHistoryActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<BulkLoadJobState> const& jobHistory,int loopDepth) 
	{
		loopDepth = a_body1cont1(jobHistory, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<BulkLoadJobState> && jobHistory,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(jobHistory), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ValidateBulkLoadJobHistoryActor*>(this)->actor_wait_state > 0) static_cast<ValidateBulkLoadJobHistoryActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateBulkLoadJobHistoryActor*>(this)->ActorCallback< ValidateBulkLoadJobHistoryActor, 0, std::vector<BulkLoadJobState> >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateBulkLoadJobHistoryActor, 0, std::vector<BulkLoadJobState> >*,std::vector<BulkLoadJobState> const& value) 
	{
		fdb_probe_actor_enter("validateBulkLoadJobHistory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateBulkLoadJobHistoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateBulkLoadJobHistory", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ValidateBulkLoadJobHistoryActor, 0, std::vector<BulkLoadJobState> >*,std::vector<BulkLoadJobState> && value) 
	{
		fdb_probe_actor_enter("validateBulkLoadJobHistory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateBulkLoadJobHistoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateBulkLoadJobHistory", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ValidateBulkLoadJobHistoryActor, 0, std::vector<BulkLoadJobState> >*,Error err) 
	{
		fdb_probe_actor_enter("validateBulkLoadJobHistory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateBulkLoadJobHistoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateBulkLoadJobHistory", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 244 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	Database cx;
															#line 244 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	UID jobId;
															#line 244 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	bool hasError;
															#line 2729 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
};
// This generated class is to be used only via validateBulkLoadJobHistory()
															#line 244 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
class ValidateBulkLoadJobHistoryActor final : public Actor<Void>, public ActorCallback< ValidateBulkLoadJobHistoryActor, 0, std::vector<BulkLoadJobState> >, public FastAllocated<ValidateBulkLoadJobHistoryActor>, public ValidateBulkLoadJobHistoryActorState<ValidateBulkLoadJobHistoryActor> {
															#line 2734 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
public:
	using FastAllocated<ValidateBulkLoadJobHistoryActor>::operator new;
	using FastAllocated<ValidateBulkLoadJobHistoryActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9871384582305222400UL, 605860150887067392UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ValidateBulkLoadJobHistoryActor, 0, std::vector<BulkLoadJobState> >;
															#line 244 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	ValidateBulkLoadJobHistoryActor(Database const& cx,UID const& jobId,bool const& hasError) 
															#line 2751 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		 : Actor<Void>(),
		   ValidateBulkLoadJobHistoryActorState<ValidateBulkLoadJobHistoryActor>(cx, jobId, hasError),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("validateBulkLoadJobHistory", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2460049204226600192UL, 15679977865403206656UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateBulkLoadJobHistoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("validateBulkLoadJobHistory");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("validateBulkLoadJobHistory", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ValidateBulkLoadJobHistoryActor, 0, std::vector<BulkLoadJobState> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 244 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
[[nodiscard]] Future<Void> validateBulkLoadJobHistory( Database const& cx, UID const& jobId, bool const& hasError ) {
															#line 244 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	return Future<Void>(new ValidateBulkLoadJobHistoryActor(cx, jobId, hasError));
															#line 2783 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
}

#line 261 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"

																#line 2788 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
// This generated class is to be used only via getAllKVSFromDB()
															#line 262 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
template <class GetAllKVSFromDBActor>
															#line 262 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
class GetAllKVSFromDBActorState {
															#line 2794 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
public:
															#line 262 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	GetAllKVSFromDBActorState(Database const& cx) 
															#line 262 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
															#line 262 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		 : cx(cx),
															#line 263 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   tr(cx),
															#line 264 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   kvs()
															#line 2805 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
	{
		fdb_probe_actor_create("getAllKVSFromDB", reinterpret_cast<unsigned long>(this));

	}
	~GetAllKVSFromDBActorState() 
	{
		fdb_probe_actor_destroy("getAllKVSFromDB", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 265 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			;
															#line 2820 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetAllKVSFromDBActorState();
		static_cast<GetAllKVSFromDBActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 279 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (!static_cast<GetAllKVSFromDBActor*>(this)->SAV<std::map<Key, Value>>::futures) { (void)(kvs); this->~GetAllKVSFromDBActorState(); static_cast<GetAllKVSFromDBActor*>(this)->destroy(); return 0; }
															#line 2843 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		new (&static_cast<GetAllKVSFromDBActor*>(this)->SAV< std::map<Key, Value> >::value()) std::map<Key, Value>(std::move(kvs)); // state_var_RVO
		this->~GetAllKVSFromDBActorState();
		static_cast<GetAllKVSFromDBActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 267 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(normalKeys, CLIENT_KNOBS->TOO_MANY);
															#line 267 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (static_cast<GetAllKVSFromDBActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2865 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetAllKVSFromDBActor*>(this)->actor_wait_state = 1;
															#line 267 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetAllKVSFromDBActor, 0, RangeResult >*>(static_cast<GetAllKVSFromDBActor*>(this)));
															#line 2870 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 276 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 276 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (static_cast<GetAllKVSFromDBActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2907 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetAllKVSFromDBActor*>(this)->actor_wait_state = 2;
															#line 276 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetAllKVSFromDBActor, 1, Void >*>(static_cast<GetAllKVSFromDBActor*>(this)));
															#line 2912 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult const& kvsRes,int loopDepth) 
	{
															#line 268 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		ASSERT(!kvsRes.more);
															#line 269 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		kvs.clear();
															#line 270 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		for( auto& kv : kvsRes ) {
															#line 271 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			auto res = kvs.insert({ kv.key, kv.value });
															#line 272 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			ASSERT(res.second);
															#line 2935 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult && kvsRes,int loopDepth) 
	{
															#line 268 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		ASSERT(!kvsRes.more);
															#line 269 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		kvs.clear();
															#line 270 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		for( auto& kv : kvsRes ) {
															#line 271 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			auto res = kvs.insert({ kv.key, kv.value });
															#line 272 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			ASSERT(res.second);
															#line 2953 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& kvsRes,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(kvsRes, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && kvsRes,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(kvsRes), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetAllKVSFromDBActor*>(this)->actor_wait_state > 0) static_cast<GetAllKVSFromDBActor*>(this)->actor_wait_state = 0;
		static_cast<GetAllKVSFromDBActor*>(this)->ActorCallback< GetAllKVSFromDBActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetAllKVSFromDBActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getAllKVSFromDB", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAllKVSFromDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAllKVSFromDB", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetAllKVSFromDBActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getAllKVSFromDB", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAllKVSFromDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAllKVSFromDB", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetAllKVSFromDBActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getAllKVSFromDB", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAllKVSFromDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAllKVSFromDB", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetAllKVSFromDBActor*>(this)->actor_wait_state > 0) static_cast<GetAllKVSFromDBActor*>(this)->actor_wait_state = 0;
		static_cast<GetAllKVSFromDBActor*>(this)->ActorCallback< GetAllKVSFromDBActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetAllKVSFromDBActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getAllKVSFromDB", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAllKVSFromDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAllKVSFromDB", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetAllKVSFromDBActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getAllKVSFromDB", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAllKVSFromDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAllKVSFromDB", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetAllKVSFromDBActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getAllKVSFromDB", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAllKVSFromDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAllKVSFromDB", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 262 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	Database cx;
															#line 263 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	Transaction tr;
															#line 264 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	std::map<Key, Value> kvs;
															#line 3127 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
};
// This generated class is to be used only via getAllKVSFromDB()
															#line 262 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
class GetAllKVSFromDBActor final : public Actor<std::map<Key, Value>>, public ActorCallback< GetAllKVSFromDBActor, 0, RangeResult >, public ActorCallback< GetAllKVSFromDBActor, 1, Void >, public FastAllocated<GetAllKVSFromDBActor>, public GetAllKVSFromDBActorState<GetAllKVSFromDBActor> {
															#line 3132 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
public:
	using FastAllocated<GetAllKVSFromDBActor>::operator new;
	using FastAllocated<GetAllKVSFromDBActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17963827409998466048UL, 1784058373736476160UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::map<Key, Value>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetAllKVSFromDBActor, 0, RangeResult >;
friend struct ActorCallback< GetAllKVSFromDBActor, 1, Void >;
															#line 262 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	GetAllKVSFromDBActor(Database const& cx) 
															#line 3150 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		 : Actor<std::map<Key, Value>>(),
		   GetAllKVSFromDBActorState<GetAllKVSFromDBActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getAllKVSFromDB", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17382421922843443968UL, 2360388894854266368UL);
		ActorExecutionContextHelper __helper(static_cast<GetAllKVSFromDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getAllKVSFromDB");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getAllKVSFromDB", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetAllKVSFromDBActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetAllKVSFromDBActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 262 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
[[nodiscard]] Future<std::map<Key, Value>> getAllKVSFromDB( Database const& cx ) {
															#line 262 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	return Future<std::map<Key, Value>>(new GetAllKVSFromDBActor(cx));
															#line 3183 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
}

#line 281 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"

	bool keyContainedInRanges(const Key& key, const std::vector<KeyRange>& ranges) {
		for (const auto& range : ranges) {
			if (range.contains(key)) {
				return true;
			}
		}
		return false;
	}

	bool checkSame(BulkDumping* self,
	               std::map<Key, Value> kvs,
	               std::map<Key, Value> newKvs,
	               std::vector<KeyRange> ignoreRanges) {
		std::vector<KeyValue> kvsToCheck;
		std::vector<KeyValue> newKvsToCheck;
		for (const auto& [key, value] : kvs) {
			if (self->keyContainedInRanges(key, ignoreRanges)) {
				continue;
			}
			kvsToCheck.push_back(KeyValueRef(key, value));
		}
		for (const auto& [key, value] : newKvs) {
			if (self->keyContainedInRanges(key, ignoreRanges)) {
				continue;
			}
			newKvsToCheck.push_back(KeyValueRef(key, value));
		}
		return kvsToCheck == newKvsToCheck;
	}

																#line 3218 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 312 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
template <class _startActor>
															#line 312 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
class _startActorState {
															#line 3224 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
public:
															#line 312 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	_startActorState(BulkDumping* const& self,Database const& cx) 
															#line 312 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
															#line 312 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		 : self(self),
															#line 312 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   cx(cx)
															#line 3233 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 313 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (self->clientId != 0)
															#line 3248 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			{
															#line 314 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 3252 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
				new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~_startActorState();
				static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 316 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (g_network->isSimulated())
															#line 3260 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			{
															#line 320 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				disableConnectionFailures("BulkDumping");
															#line 3264 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			}
															#line 322 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			kvs = self->generateOrderedKVS(self, normalKeys, 1000);
															#line 323 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->setKeys(cx, kvs);
															#line 323 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3272 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 323 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 3277 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 326 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_1 = registerRangeLockOwner(cx, rangeLockNameForBulkLoad, rangeLockNameForBulkLoad);
															#line 326 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3302 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 326 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 3307 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 326 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_1 = registerRangeLockOwner(cx, rangeLockNameForBulkLoad, rangeLockNameForBulkLoad);
															#line 326 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3318 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 326 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 3323 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 328 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<std::vector<RangeLockOwner>> __when_expr_2 = getAllRangeLockOwners(cx);
															#line 328 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3409 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 328 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, std::vector<RangeLockOwner> >*>(static_cast<_startActor*>(this)));
															#line 3414 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 328 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<std::vector<RangeLockOwner>> __when_expr_2 = getAllRangeLockOwners(cx);
															#line 328 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3425 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 328 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, std::vector<RangeLockOwner> >*>(static_cast<_startActor*>(this)));
															#line 3430 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(std::vector<RangeLockOwner> const& lockOwners,int loopDepth) 
	{
															#line 329 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		ASSERT(lockOwners.size() == 1 && lockOwners[0].getOwnerUniqueId() == rangeLockNameForBulkLoad);
															#line 332 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		oldBulkDumpMode = 0;
															#line 333 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_3 = store(oldBulkDumpMode, setBulkDumpMode(cx, 1));
															#line 333 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3520 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 333 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 3525 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(std::vector<RangeLockOwner> && lockOwners,int loopDepth) 
	{
															#line 329 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		ASSERT(lockOwners.size() == 1 && lockOwners[0].getOwnerUniqueId() == rangeLockNameForBulkLoad);
															#line 332 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		oldBulkDumpMode = 0;
															#line 333 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_3 = store(oldBulkDumpMode, setBulkDumpMode(cx, 1));
															#line 333 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3540 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 333 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 3545 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(std::vector<RangeLockOwner> const& lockOwners,int loopDepth) 
	{
		loopDepth = a_body1cont5(lockOwners, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(std::vector<RangeLockOwner> && lockOwners,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(lockOwners), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, std::vector<RangeLockOwner> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, std::vector<RangeLockOwner> >*,std::vector<RangeLockOwner> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, std::vector<RangeLockOwner> >*,std::vector<RangeLockOwner> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, std::vector<RangeLockOwner> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 334 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		newJob = createBulkDumpJob(normalKeys, simulationBulkDumpFolder, BulkLoadType::SST, BulkLoadTransportMethod::CP);
															#line 336 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_4 = submitBulkDumpJob(cx, newJob);
															#line 336 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3633 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont6when1(__when_expr_4.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 336 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 3638 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 334 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		newJob = createBulkDumpJob(normalKeys, simulationBulkDumpFolder, BulkLoadType::SST, BulkLoadTransportMethod::CP);
															#line 336 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_4 = submitBulkDumpJob(cx, newJob);
															#line 336 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3651 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont6when1(__when_expr_4.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 336 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 3656 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
															#line 337 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		TraceEvent("BulkDumpingWorkLoad").detail("Phase", "Dump Job Submitted").detail("Job", newJob.toString());
															#line 340 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_5 = self->waitUntilDumpJobComplete(cx);
															#line 340 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3744 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont7when1(__when_expr_5.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 340 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Void >*>(static_cast<_startActor*>(this)));
															#line 3749 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
															#line 337 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		TraceEvent("BulkDumpingWorkLoad").detail("Phase", "Dump Job Submitted").detail("Job", newJob.toString());
															#line 340 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_5 = self->waitUntilDumpJobComplete(cx);
															#line 340 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3762 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont7when1(__when_expr_5.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 340 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Void >*>(static_cast<_startActor*>(this)));
															#line 3767 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _startActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
															#line 341 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		TraceEvent("BulkDumpingWorkLoad").detail("Phase", "Dump Job Complete").detail("Job", newJob.toString());
															#line 344 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_6 = self->clearDatabase(cx);
															#line 344 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3855 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont8when1(__when_expr_6.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 344 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, Void >*>(static_cast<_startActor*>(this)));
															#line 3860 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
															#line 341 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		TraceEvent("BulkDumpingWorkLoad").detail("Phase", "Dump Job Complete").detail("Job", newJob.toString());
															#line 344 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_6 = self->clearDatabase(cx);
															#line 344 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3873 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont8when1(__when_expr_6.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 344 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, Void >*>(static_cast<_startActor*>(this)));
															#line 3878 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _startActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont9(Void const& _,int loopDepth) 
	{
															#line 345 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		TraceEvent("BulkDumpingWorkLoad").detail("Phase", "Clear DB").detail("Job", newJob.toString());
															#line 348 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		oldBulkLoadMode = 0;
															#line 349 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_7 = store(oldBulkLoadMode, setBulkLoadMode(cx, 1));
															#line 349 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3968 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont9when1(__when_expr_7.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 8;
															#line 349 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _startActor, 7, Void >*>(static_cast<_startActor*>(this)));
															#line 3973 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9(Void && _,int loopDepth) 
	{
															#line 345 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		TraceEvent("BulkDumpingWorkLoad").detail("Phase", "Clear DB").detail("Job", newJob.toString());
															#line 348 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		oldBulkLoadMode = 0;
															#line 349 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_7 = store(oldBulkLoadMode, setBulkLoadMode(cx, 1));
															#line 349 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3988 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont9when1(__when_expr_7.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 8;
															#line 349 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _startActor, 7, Void >*>(static_cast<_startActor*>(this)));
															#line 3993 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< _startActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont10(Void const& _,int loopDepth) 
	{
															#line 350 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		;
															#line 4077 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = a_body1cont10loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10(Void && _,int loopDepth) 
	{
															#line 350 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		;
															#line 4086 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = a_body1cont10loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< _startActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< _startActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont10cont1(int loopDepth) 
	{
															#line 394 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<std::vector<std::pair<KeyRange, RangeLockState>>> __when_expr_14 = findExclusiveReadLockOnRange(cx, normalKeys, rangeLockNameForBulkLoad);
															#line 394 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4172 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1Catch1(__when_expr_14.getError(), loopDepth); else return a_body1cont10cont1when1(__when_expr_14.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 15;
															#line 394 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< _startActor, 14, std::vector<std::pair<KeyRange, RangeLockState>> >*>(static_cast<_startActor*>(this)));
															#line 4177 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont10loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10loopBody1(int loopDepth) 
	{
															#line 353 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		hasError = false;
															#line 354 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		oldCancelTimes = self->cancelTimes;
															#line 355 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		bulkLoadJob = createBulkLoadJob( newJob.getJobId(), newJob.getJobRange(), newJob.getJobRoot(), BulkLoadTransportMethod::CP);
															#line 357 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		TraceEvent("BulkDumpingWorkLoad").detail("Phase", "Load Job Submitted").detail("Job", newJob.toString());
															#line 358 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_8 = submitBulkLoadJob(cx, bulkLoadJob);
															#line 358 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4203 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1cont10loopBody1when1(__when_expr_8.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 9;
															#line 358 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< _startActor, 8, Void >*>(static_cast<_startActor*>(this)));
															#line 4208 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10break1(int loopDepth) 
	{
		try {
			return a_body1cont10cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 361 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		errorRanges = std::vector<KeyRange>();
															#line 362 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<std::vector<BulkLoadTaskState>> __when_expr_9 = self->waitUntilLoadJobCompleteOrError(self, cx, newJob.getJobId(), newJob.getJobRange());
															#line 362 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4234 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1cont10loopBody1cont1when1(__when_expr_9.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 10;
															#line 362 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< _startActor, 9, std::vector<BulkLoadTaskState> >*>(static_cast<_startActor*>(this)));
															#line 4239 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 361 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		errorRanges = std::vector<KeyRange>();
															#line 362 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<std::vector<BulkLoadTaskState>> __when_expr_9 = self->waitUntilLoadJobCompleteOrError(self, cx, newJob.getJobId(), newJob.getJobRange());
															#line 362 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4252 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1cont10loopBody1cont1when1(__when_expr_9.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 10;
															#line 362 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< _startActor, 9, std::vector<BulkLoadTaskState> >*>(static_cast<_startActor*>(this)));
															#line 4257 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont10loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< _startActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont10loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< _startActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont10loopBody1cont2(int loopDepth) 
	{
															#line 366 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		ASSERT(self->cancelTimes >= oldCancelTimes);
															#line 367 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (self->cancelTimes > oldCancelTimes)
															#line 4343 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		{
															#line 369 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			StrictFuture<Void> __when_expr_10 = delay(deterministicRandom()->random01() * 10.0);
															#line 369 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4349 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), std::max(0, loopDepth - 1)); else return a_body1cont10loopBody1cont2when1(__when_expr_10.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 11;
															#line 369 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< _startActor, 10, Void >*>(static_cast<_startActor*>(this)));
															#line 4354 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont10loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10loopBody1cont1when1(std::vector<BulkLoadTaskState> const& __errorTasks,int loopDepth) 
	{
															#line 362 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		errorTasks = __errorTasks;
															#line 4368 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = a_body1cont10loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont10loopBody1cont1when1(std::vector<BulkLoadTaskState> && __errorTasks,int loopDepth) 
	{
		errorTasks = std::move(__errorTasks);
		loopDepth = a_body1cont10loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 9, std::vector<BulkLoadTaskState> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 9, std::vector<BulkLoadTaskState> >*,std::vector<BulkLoadTaskState> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< _startActor, 9, std::vector<BulkLoadTaskState> >*,std::vector<BulkLoadTaskState> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< _startActor, 9, std::vector<BulkLoadTaskState> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont10loopBody1cont3(int loopDepth) 
	{
															#line 372 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		for( const auto& errorTask : errorTasks ) {
															#line 373 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			errorRanges.push_back(errorTask.getRange());
															#line 374 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			hasError = true;
															#line 4451 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		}
															#line 376 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		TraceEvent("BulkDumpingWorkLoad").detail("Phase", "Load Job Complete").detail("Job", newJob.toString());
															#line 379 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<std::map<Key, Value>> __when_expr_11 = self->getAllKVSFromDB(cx);
															#line 379 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4459 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), std::max(0, loopDepth - 1)); else return a_body1cont10loopBody1cont3when1(__when_expr_11.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 12;
															#line 379 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< _startActor, 11, std::map<Key, Value> >*>(static_cast<_startActor*>(this)));
															#line 4464 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10loopBody1cont4(Void const& _,int loopDepth) 
	{
		return a_body1cont10loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1cont10loopBody1cont4(Void && _,int loopDepth) 
	{
		return a_body1cont10loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1cont10loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont10loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< _startActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont10loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< _startActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont10loopBody1cont6(std::map<Key, Value> const& newKvs,int loopDepth) 
	{
															#line 380 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (!self->checkSame(self, kvs, newKvs, errorRanges))
															#line 4560 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		{
															#line 381 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			TraceEvent(SevError, "BulkDumpingWorkLoadError") .detail("KVS", kvs.size()) .detail("NewKVS", newKvs.size());
															#line 384 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			ASSERT(false);
															#line 4566 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		}
															#line 388 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_12 = acknowledgeAllErrorBulkLoadTasks(cx, bulkLoadJob.getJobId(), bulkLoadJob.getJobRange());
															#line 388 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4572 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch1(__when_expr_12.getError(), std::max(0, loopDepth - 1)); else return a_body1cont10loopBody1cont6when1(__when_expr_12.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 13;
															#line 388 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< _startActor, 12, Void >*>(static_cast<_startActor*>(this)));
															#line 4577 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10loopBody1cont6(std::map<Key, Value> && newKvs,int loopDepth) 
	{
															#line 380 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (!self->checkSame(self, kvs, newKvs, errorRanges))
															#line 4586 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		{
															#line 381 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			TraceEvent(SevError, "BulkDumpingWorkLoadError") .detail("KVS", kvs.size()) .detail("NewKVS", newKvs.size());
															#line 384 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			ASSERT(false);
															#line 4592 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		}
															#line 388 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_12 = acknowledgeAllErrorBulkLoadTasks(cx, bulkLoadJob.getJobId(), bulkLoadJob.getJobRange());
															#line 388 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4598 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch1(__when_expr_12.getError(), std::max(0, loopDepth - 1)); else return a_body1cont10loopBody1cont6when1(__when_expr_12.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 13;
															#line 388 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< _startActor, 12, Void >*>(static_cast<_startActor*>(this)));
															#line 4603 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10loopBody1cont3when1(std::map<Key, Value> const& newKvs,int loopDepth) 
	{
		loopDepth = a_body1cont10loopBody1cont6(newKvs, loopDepth);

		return loopDepth;
	}
	int a_body1cont10loopBody1cont3when1(std::map<Key, Value> && newKvs,int loopDepth) 
	{
		loopDepth = a_body1cont10loopBody1cont6(std::move(newKvs), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 11, std::map<Key, Value> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 11, std::map<Key, Value> >*,std::map<Key, Value> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont10loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< _startActor, 11, std::map<Key, Value> >*,std::map<Key, Value> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont10loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< _startActor, 11, std::map<Key, Value> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1cont10loopBody1cont8(Void const& _,int loopDepth) 
	{
															#line 389 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_13 = self->validateBulkLoadJobHistory(cx, bulkLoadJob.getJobId(), hasError);
															#line 389 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4689 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1Catch1(__when_expr_13.getError(), std::max(0, loopDepth - 1)); else return a_body1cont10loopBody1cont8when1(__when_expr_13.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 14;
															#line 389 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< _startActor, 13, Void >*>(static_cast<_startActor*>(this)));
															#line 4694 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10loopBody1cont8(Void && _,int loopDepth) 
	{
															#line 389 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_13 = self->validateBulkLoadJobHistory(cx, bulkLoadJob.getJobId(), hasError);
															#line 389 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4705 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1Catch1(__when_expr_13.getError(), std::max(0, loopDepth - 1)); else return a_body1cont10loopBody1cont8when1(__when_expr_13.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 14;
															#line 389 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< _startActor, 13, Void >*>(static_cast<_startActor*>(this)));
															#line 4710 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10loopBody1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10loopBody1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 12, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 12, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont10loopBody1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< _startActor, 12, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont10loopBody1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< _startActor, 12, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 12);

	}
	int a_body1cont10loopBody1cont10(Void const& _,int loopDepth) 
	{
		return a_body1cont10break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont10loopBody1cont10(Void && _,int loopDepth) 
	{
		return a_body1cont10break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont10loopBody1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10loopBody1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10loopBody1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10loopBody1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose14() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 13, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 13, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont10loopBody1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorCallback< _startActor, 13, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont10loopBody1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorCallback< _startActor, 13, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 13);

	}
	int a_body1cont10cont2(std::vector<std::pair<KeyRange, RangeLockState>> const& res,int loopDepth) 
	{
															#line 396 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		ASSERT(res.empty());
															#line 398 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_15 = removeRangeLockOwner(cx, rangeLockNameForBulkLoad);
															#line 398 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4885 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1Catch1(__when_expr_15.getError(), loopDepth); else return a_body1cont10cont2when1(__when_expr_15.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 16;
															#line 398 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_15.addCallbackAndClear(static_cast<ActorCallback< _startActor, 15, Void >*>(static_cast<_startActor*>(this)));
															#line 4890 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont2(std::vector<std::pair<KeyRange, RangeLockState>> && res,int loopDepth) 
	{
															#line 396 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		ASSERT(res.empty());
															#line 398 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_15 = removeRangeLockOwner(cx, rangeLockNameForBulkLoad);
															#line 398 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4903 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1Catch1(__when_expr_15.getError(), loopDepth); else return a_body1cont10cont2when1(__when_expr_15.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 16;
															#line 398 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_15.addCallbackAndClear(static_cast<ActorCallback< _startActor, 15, Void >*>(static_cast<_startActor*>(this)));
															#line 4908 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont1when1(std::vector<std::pair<KeyRange, RangeLockState>> const& res,int loopDepth) 
	{
		loopDepth = a_body1cont10cont2(res, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1when1(std::vector<std::pair<KeyRange, RangeLockState>> && res,int loopDepth) 
	{
		loopDepth = a_body1cont10cont2(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose15() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 14, std::vector<std::pair<KeyRange, RangeLockState>> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 14, std::vector<std::pair<KeyRange, RangeLockState>> >*,std::vector<std::pair<KeyRange, RangeLockState>> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont10cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_fire(ActorCallback< _startActor, 14, std::vector<std::pair<KeyRange, RangeLockState>> >*,std::vector<std::pair<KeyRange, RangeLockState>> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont10cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_error(ActorCallback< _startActor, 14, std::vector<std::pair<KeyRange, RangeLockState>> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 14);

	}
	int a_body1cont10cont3(Void const& _,int loopDepth) 
	{
															#line 400 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<std::vector<RangeLockOwner>> __when_expr_16 = getAllRangeLockOwners(cx);
															#line 400 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4994 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_16.isReady()) { if (__when_expr_16.isError()) return a_body1Catch1(__when_expr_16.getError(), loopDepth); else return a_body1cont10cont3when1(__when_expr_16.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 17;
															#line 400 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_16.addCallbackAndClear(static_cast<ActorCallback< _startActor, 16, std::vector<RangeLockOwner> >*>(static_cast<_startActor*>(this)));
															#line 4999 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont3(Void && _,int loopDepth) 
	{
															#line 400 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<std::vector<RangeLockOwner>> __when_expr_16 = getAllRangeLockOwners(cx);
															#line 400 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5010 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_16.isReady()) { if (__when_expr_16.isError()) return a_body1Catch1(__when_expr_16.getError(), loopDepth); else return a_body1cont10cont3when1(__when_expr_16.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 17;
															#line 400 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_16.addCallbackAndClear(static_cast<ActorCallback< _startActor, 16, std::vector<RangeLockOwner> >*>(static_cast<_startActor*>(this)));
															#line 5015 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose16() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 15, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 15, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont10cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_fire(ActorCallback< _startActor, 15, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont10cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_error(ActorCallback< _startActor, 15, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 15);

	}
	int a_body1cont10cont4(std::vector<RangeLockOwner> const& lockOwnersAfterRemove,int loopDepth) 
	{
															#line 401 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		ASSERT(lockOwnersAfterRemove.empty());
															#line 403 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 5101 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10cont4(std::vector<RangeLockOwner> && lockOwnersAfterRemove,int loopDepth) 
	{
															#line 401 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		ASSERT(lockOwnersAfterRemove.empty());
															#line 403 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 5115 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10cont3when1(std::vector<RangeLockOwner> const& lockOwnersAfterRemove,int loopDepth) 
	{
		loopDepth = a_body1cont10cont4(lockOwnersAfterRemove, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont3when1(std::vector<RangeLockOwner> && lockOwnersAfterRemove,int loopDepth) 
	{
		loopDepth = a_body1cont10cont4(std::move(lockOwnersAfterRemove), loopDepth);

		return loopDepth;
	}
	void a_exitChoose17() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 16, std::vector<RangeLockOwner> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 16, std::vector<RangeLockOwner> >*,std::vector<RangeLockOwner> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont10cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_fire(ActorCallback< _startActor, 16, std::vector<RangeLockOwner> >*,std::vector<RangeLockOwner> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont10cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_error(ActorCallback< _startActor, 16, std::vector<RangeLockOwner> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 16);

	}
															#line 312 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	BulkDumping* self;
															#line 312 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	Database cx;
															#line 322 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	std::map<Key, Value> kvs;
															#line 332 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	int oldBulkDumpMode;
															#line 334 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	BulkDumpState newJob;
															#line 348 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	int oldBulkLoadMode;
															#line 353 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	bool hasError;
															#line 354 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	int oldCancelTimes;
															#line 355 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	BulkLoadJobState bulkLoadJob;
															#line 361 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	std::vector<KeyRange> errorRanges;
															#line 362 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	std::vector<BulkLoadTaskState> errorTasks;
															#line 5220 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 312 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, std::vector<RangeLockOwner> >, public ActorCallback< _startActor, 3, Void >, public ActorCallback< _startActor, 4, Void >, public ActorCallback< _startActor, 5, Void >, public ActorCallback< _startActor, 6, Void >, public ActorCallback< _startActor, 7, Void >, public ActorCallback< _startActor, 8, Void >, public ActorCallback< _startActor, 9, std::vector<BulkLoadTaskState> >, public ActorCallback< _startActor, 10, Void >, public ActorCallback< _startActor, 11, std::map<Key, Value> >, public ActorCallback< _startActor, 12, Void >, public ActorCallback< _startActor, 13, Void >, public ActorCallback< _startActor, 14, std::vector<std::pair<KeyRange, RangeLockState>> >, public ActorCallback< _startActor, 15, Void >, public ActorCallback< _startActor, 16, std::vector<RangeLockOwner> >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 5225 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7401446910755277312UL, 16945727259398084864UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, std::vector<RangeLockOwner> >;
friend struct ActorCallback< _startActor, 3, Void >;
friend struct ActorCallback< _startActor, 4, Void >;
friend struct ActorCallback< _startActor, 5, Void >;
friend struct ActorCallback< _startActor, 6, Void >;
friend struct ActorCallback< _startActor, 7, Void >;
friend struct ActorCallback< _startActor, 8, Void >;
friend struct ActorCallback< _startActor, 9, std::vector<BulkLoadTaskState> >;
friend struct ActorCallback< _startActor, 10, Void >;
friend struct ActorCallback< _startActor, 11, std::map<Key, Value> >;
friend struct ActorCallback< _startActor, 12, Void >;
friend struct ActorCallback< _startActor, 13, Void >;
friend struct ActorCallback< _startActor, 14, std::vector<std::pair<KeyRange, RangeLockState>> >;
friend struct ActorCallback< _startActor, 15, Void >;
friend struct ActorCallback< _startActor, 16, std::vector<RangeLockOwner> >;
															#line 312 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	_startActor(BulkDumping* const& self,Database const& cx) 
															#line 5258 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, std::vector<RangeLockOwner> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _startActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _startActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< _startActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< _startActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< _startActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< _startActor, 9, std::vector<BulkLoadTaskState> >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< _startActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< _startActor, 11, std::map<Key, Value> >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< _startActor, 12, Void >*)0, actor_cancelled()); break;
		case 14: this->a_callback_error((ActorCallback< _startActor, 13, Void >*)0, actor_cancelled()); break;
		case 15: this->a_callback_error((ActorCallback< _startActor, 14, std::vector<std::pair<KeyRange, RangeLockState>> >*)0, actor_cancelled()); break;
		case 16: this->a_callback_error((ActorCallback< _startActor, 15, Void >*)0, actor_cancelled()); break;
		case 17: this->a_callback_error((ActorCallback< _startActor, 16, std::vector<RangeLockOwner> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 312 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
[[nodiscard]] Future<Void> _start( BulkDumping* const& self, Database const& cx ) {
															#line 312 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	return Future<Void>(new _startActor(self, cx));
															#line 5306 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
}

#line 405 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
};

WorkloadFactory<BulkDumping> BulkDumpingFactory;